import { PDFXRef } from '../pdf-structures';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Cross Reference Table.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * Cross Reference Table and (2) a subarray of the input with the characters making
 * up the parsed cross reference table removed. The "onParseXRefTable" parse
 * handler will also be called with the Table object.
 *
 * If not, null is returned.
 */
declare const parseXRefTable: (input: Uint8Array, { onParseXRefTable }?: IParseHandlers) => void | [PDFXRef.Table, Uint8Array];
export default parseXRefTable;
