"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../pdf-objects");
var PDFDictionary_1 = __importDefault(require("../pdf-objects/PDFDictionary"));
var validate_1 = require("../../utils/validate");
var VALID_KEYS = Object.freeze([
    'Type',
    'Version',
    'Extensions',
    'Pages',
    'PageLabels',
    'Names',
    'Dests',
    'ViewerPreferences',
    'PageLayout',
    'PageMode',
    'Outlines',
    'Threads',
    'OpenAction',
    'AA',
    'URI',
    'AcroForm',
    'Metadata',
    'StructTreeRoot',
    'MarkInfo',
    'Lang',
    'SpiderInfo',
    'OutputIntents',
    'PieceInfo',
    'OCProperties',
    'Perms',
    'Legal',
    'Requirements',
    'Collection',
    'NeedsRendering',
]);
var PDFCatalog = /** @class */ (function (_super) {
    __extends(PDFCatalog, _super);
    function PDFCatalog() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PDFCatalog.prototype, "Pages", {
        get: function () {
            var Pages = this.get('Pages');
            return this.index.lookup(Pages);
        },
        enumerable: true,
        configurable: true
    });
    PDFCatalog.create = function (pageTree, index) {
        validate_1.validate(pageTree, validate_1.isInstance(pdf_objects_1.PDFIndirectReference), '"pageTree" must be an indirect reference');
        return new PDFCatalog({
            Type: pdf_objects_1.PDFName.from('Catalog'),
            Pages: pageTree,
        }, index);
    };
    PDFCatalog.fromObject = function (object, index) { return new PDFCatalog(object, index, VALID_KEYS); };
    PDFCatalog.fromDict = function (dict) {
        validate_1.validate(dict, validate_1.isInstance(PDFDictionary_1.default), '"dict" must be a PDFDictionary');
        return new PDFCatalog(dict.map, dict.index, VALID_KEYS);
    };
    return PDFCatalog;
}(PDFDictionary_1.default));
exports.default = PDFCatalog;
