"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var add_1 = __importDefault(require("lodash/add"));
var flatten_1 = __importDefault(require("lodash/flatten"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var pako_1 = __importDefault(require("pako"));
require("../pdf-objects");
var pdf_objects_1 = require("../pdf-objects");
var PDFOperator_1 = __importDefault(require("../pdf-operators/PDFOperator"));
var utils_1 = require("../../utils");
var proxies_1 = require("../../utils/proxies");
var validate_1 = require("../../utils/validate");
var PDFContentStream = /** @class */ (function (_super) {
    __extends(PDFContentStream, _super);
    function PDFContentStream(dictionary) {
        var operators = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            operators[_i - 1] = arguments[_i];
        }
        var _this = _super.call(this, dictionary) || this;
        // Note: If this PDFContentStream is encoded when it is cloned, the
        //       clone will *not* be encoded.
        _this.clone = function () {
            var clonedDict = _this.dictionary.clone();
            clonedDict.delete('Filter');
            var cloned = PDFContentStream.of.apply(PDFContentStream, [clonedDict].concat(_this.operators));
            return cloned;
        };
        _this.encode = function () {
            _this.dictionary.set(pdf_objects_1.PDFName.from('Filter'), pdf_objects_1.PDFName.from('FlateDecode'));
            var buffer = new Uint8Array(_this.operatorsBytesSize());
            _this.copyOperatorBytesInto(buffer);
            _this.encodedOperators = pako_1.default.deflate(buffer);
            _this.dictionary.set('Length', pdf_objects_1.PDFNumber.fromNumber(_this.encodedOperators.length));
            return _this;
        };
        _this.operatorsBytesSize = function () {
            return _this.encodedOperators
                ? _this.encodedOperators.length
                : _this.operators
                    .filter(Boolean)
                    .map(function (op) { return op.bytesSize(); })
                    .reduce(add_1.default, 0);
        };
        _this.bytesSize = function () {
            return _this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.operatorsBytesSize() +
                10;
        }; // \nendstream
        _this.copyBytesInto = function (buffer) {
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = utils_1.addStringToBuffer('\nstream\n', remaining);
            if (_this.encodedOperators) {
                for (var i = 0; i < _this.encodedOperators.length; i++) {
                    remaining[i] = _this.encodedOperators[i];
                }
                remaining = remaining.subarray(_this.encodedOperators.length);
            }
            else {
                remaining = _this.copyOperatorBytesInto(remaining);
            }
            remaining = utils_1.addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        _this.copyOperatorBytesInto = function (buffer) {
            return _this.operators
                .filter(Boolean)
                .reduce(function (remBytes, op) { return op.copyBytesInto(remBytes); }, buffer);
        };
        validate_1.validateArr(operators, utils_1.or(validate_1.isInstance(PDFOperator_1.default), validate_1.isArrayOf(PDFOperator_1.default)), 'PDFContentStream requires PDFOperators or PDFOperator[]s to be constructed.');
        _this.operators = proxies_1.typedArrayProxy(flatten_1.default(operators), PDFOperator_1.default, {
            set: function (property) {
                if (isNumber_1.default(Number(property))) {
                    _this.Length.number = _this.operatorsBytesSize();
                }
            },
        });
        _this.dictionary.set('Length', pdf_objects_1.PDFNumber.fromNumber(_this.operatorsBytesSize()));
        return _this;
    }
    Object.defineProperty(PDFContentStream.prototype, "Length", {
        get: function () {
            var Length = this.dictionary.get('Length');
            return this.dictionary.index.lookup(Length);
        },
        enumerable: true,
        configurable: true
    });
    PDFContentStream.of = function (dict) {
        var operators = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            operators[_i - 1] = arguments[_i];
        }
        return new (PDFContentStream.bind.apply(PDFContentStream, [void 0, dict].concat(operators)))();
    };
    PDFContentStream.validateOperators = function (elements) {
        return validate_1.validateArr(elements, validate_1.isInstance(PDFOperator_1.default), 'Only PDFOperators can be pushed to a PDFContentStream.');
    };
    return PDFContentStream;
}(pdf_objects_1.PDFStream));
exports.default = PDFContentStream;
