"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFHeader = /** @class */ (function () {
    function PDFHeader(major, minor) {
        var _this = this;
        this.toString = function () { return "%PDF-" + _this.major + "." + _this.minor + "\n"; };
        this.bytesSize = function () { return ("%PDF-" + _this.major + "." + _this.minor + "\n").length + 6; };
        this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer("%PDF-" + _this.major + "." + _this.minor + "\n", buffer);
            remaining.set([utils_1.toCharCode('%'), 130, 130, 130, 130, utils_1.toCharCode('\n')], 0);
            return remaining.subarray(6);
        };
        validate_1.validate(major, isNumber_1.default, 'PDFHeader.major must be a Number');
        validate_1.validate(minor, isNumber_1.default, 'PDFHeader.minor must be a Number');
        this.major = major;
        this.minor = minor;
    }
    PDFHeader.forVersion = function (major, minor) {
        return new PDFHeader(major, minor);
    };
    return PDFHeader;
}());
exports.default = PDFHeader;
