import { PDFArray, PDFDictionary, PDFIndirectReference, PDFStream } from '../pdf-objects';
import { PDFContentStream, PDFPageTree } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
declare class PDFPage extends PDFDictionary {
    /** @hidden */
    static validKeys: ReadonlyArray<string>;
    /** @hidden */
    static readonly INHERITABLE_ENTRIES: string[];
    static create: (index: PDFObjectIndex, size: [number, number], resources?: PDFDictionary | undefined) => PDFPage;
    static fromDict: (dict: PDFDictionary) => PDFPage;
    autoNormalizeCTM: boolean;
    /** @hidden */
    readonly Parent: PDFPageTree;
    /** @hidden */
    readonly Resources: PDFDictionary;
    /** @hidden */
    readonly Contents: PDFArray<PDFContentStream | PDFIndirectReference<PDFContentStream>>;
    /**
     * Converts the `Contents` entry in this PDFPage to a [[PDFArray]], if it
     * exists and is not already a direct [[PDFArray]]. Therefore, this method
     * only has an effect if `Contents` is a `PDFIndirectReference<PDFStream>` or
     * `PDFIndirectReference<PDFArray<PDFStream>>`.
     */
    normalizeContents: () => this;
    /**
     * Ensures that content streams added to the [[PDFPage]] after calling
     * [[normalizeCTM]] will be working in the default Content Transformation
     * Matrix.
     *
     * This can be useful in cases where PDFs are being modified that
     * have existing content streams which modify the CTM outside without
     * resetting their changes (with the Q and q operators).
     *
     * Works by wrapping any existing content streams for this page in two new
     * content streams that contain a single operator each: `q` and `Q`,
     * respectively.
     *
     * Note that the `Contents` entry in this [[PDFPage]] must be a PDFArray.
     * Calling [[normalizeContents]] first will ensure that this is the case.
     *
     * @param pdfDoc The document containing this PDFPage, to which the two new
     *               [[PDFContentStream]]s will be added
     *
     * @returns Returns this [[PDFPage]] instance.
     */
    normalizeCTM: () => PDFPage;
    /** @hidden */
    normalizeResources: ({ Font, XObject, }: {
        Font?: boolean | undefined;
        XObject?: boolean | undefined;
    }) => void;
    /**
     * Add one or more content streams to the page.
     *
     * Note that this method does
     * **not** directly accept [[PDFContentStream]](s) as its arguments. Instead,
     * it accepts references to the content streams in the form of
     * [[PDFIndirectReference]] objects. To obtain a reference for a
     * [[PDFContentStream]], you must call the [[PDFDocument.register]] method
     * with the [[PDFContentStream]].
     *
     * @param contentStreams The content stream(s) to be added to the page.
     */
    addContentStreams: (...contentStreams: PDFIndirectReference<PDFContentStream>[]) => this;
    /**
     * Adds a font dictionary to the page.
     *
     * Note that this method does **not** directly accept font
     * [[PDFDictionary]](s) as its arguments. Instead, it accepts references to
     * the font dictionaries in the form of [[PDFIndirectReference]] objects.
     *
     * The first element of the tuples returned by the
     * [[PDFDocument.embedStandardFont]] and [[PDFDocument.embedFont]] methods
     * is a [[PDFIndirectReference]] to a font dictionary that can be passed as
     * the `fontDict` parameter of this method.
     *
     * @param key      The name by which the font dictionary will be referenced.
     * @param fontDict The font dictionary to be added to the page.
     */
    addFontDictionary: (key: string, fontDict: PDFIndirectReference<PDFDictionary>) => this;
    /**
     * **Note:** This method is an alias for [[addXObject]]. It exists because its
     * name is more descriptive and familiar than `addXObject` is.
     *
     * Adds an image object to the page.
     *
     * Note that this method does **not** directly accept a [[PDFStream]] object
     * as its argument. Instead, it accepts a reference to the [[PDFStream]] in
     * the form of a [[PDFIndirectReference]] object.
     *
     * The first element of the tuples returned by the
     * [[PDFDocument.embedPNG]] and [[PDFDocument.embedJPG]] methods
     * is a [[PDFIndirectReference]] to a [[PDFStream]] that can be passed as
     * the `imageObject` parameter of this method.
     *
     * @param key         The name by which the image object will be referenced.
     * @param imageObject The image object to be added to the page.
     */
    addImageObject: (key: string, imageObject: PDFIndirectReference<PDFStream>) => this;
    /**
     * Adds an XObject to the page.
     *
     * Note that this method does **not** directly accept a [[PDFStream]] object
     * as its argument. Instead, it accepts a reference to the [[PDFStream]] in
     * the form of a [[PDFIndirectReference]] object.
     *
     * @param key     The name by which the XObject will be referenced.
     * @param xObject The XObject to be added to the page.
     */
    addXObject: (key: string, xObject: PDFIndirectReference<PDFStream>) => this;
    clone: () => PDFPage;
}
export default PDFPage;
