import { PDFArray, PDFDictionary, PDFIndirectReference, PDFNumber } from '../pdf-objects';
import { PDFPage } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
export declare type Kid = PDFPageTree | PDFPage;
declare class PDFPageTree extends PDFDictionary {
    static createRootNode: (kids: PDFArray<PDFIndirectReference<Kid>>, index: PDFObjectIndex) => PDFPageTree;
    static createNode: (parent: PDFIndirectReference<Kid>, kids: PDFArray<PDFIndirectReference<Kid>>, index: PDFObjectIndex) => PDFPageTree;
    static fromDict: (dict: PDFDictionary) => PDFPageTree;
    readonly Kids: PDFArray<PDFPageTree | PDFPage | PDFIndirectReference<Kid>>;
    readonly Parent: void | PDFPageTree;
    readonly Count: PDFNumber;
    addPage: (page: PDFIndirectReference<PDFPage>) => this;
    removePage: (idx: number) => this;
    insertPage: (idx: number, page: PDFIndirectReference<PDFPage>) => this;
    traverse: (visit: (k: Kid, r: PDFPageTree | PDFPage | PDFIndirectReference<Kid>) => any) => this;
    traverseRight: (visit: (k: Kid, r: PDFPageTree | PDFPage | PDFIndirectReference<Kid>) => any) => this;
    ascend: (visit: (t: PDFPageTree) => any, visitSelf?: boolean) => void;
}
export default PDFPageTree;
