"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable prefer-destructuring, no-param-reassign */
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var last_1 = __importDefault(require("lodash/last"));
var pdf_objects_1 = require("../pdf-objects");
var validate_1 = require("../../utils/validate");
var PDFObjectIndex_1 = __importDefault(require("../pdf-document/PDFObjectIndex"));
var VALID_KEYS = Object.freeze(['Type', 'Parent', 'Kids', 'Count']);
var PDFPageTree = /** @class */ (function (_super) {
    __extends(PDFPageTree, _super);
    function PDFPageTree() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.addPage = function (page) {
            validate_1.validate(page, validate_1.isInstance(pdf_objects_1.PDFIndirectReference), '"page" arg must be of type PDFIndirectReference<PDFPage>');
            _this.Kids.array.push(page);
            _this.ascend(function (pageTree) {
                pageTree.Count.number += 1;
            });
            return _this;
        };
        _this.removePage = function (idx) {
            validate_1.validate(idx, isNumber_1.default, '"idx" arg must be a Number');
            _this.Kids.array.splice(idx, 1);
            _this.ascend(function (pageTree) {
                pageTree.Count.number -= 1;
            });
            return _this;
        };
        _this.insertPage = function (idx, page) {
            validate_1.validate(idx, isNumber_1.default, '"idx" arg must be a Number');
            validate_1.validate(page, validate_1.isInstance(pdf_objects_1.PDFIndirectReference), '"page" arg must be of type PDFIndirectReference<PDFPage>');
            _this.Kids.array.splice(idx, 0, page);
            _this.ascend(function (pageTree) {
                pageTree.Count.number += 1;
            });
            return _this;
        };
        // TODO: Pass a "stop" callback to allow "visit" to end traversal early
        // TODO: Allow for optimized tree search given an index
        _this.traverse = function (visit) {
            if (_this.Kids.array.length === 0)
                return _this;
            _this.Kids.forEach(function (kidRef) {
                var kid = _this.index.lookup(kidRef);
                visit(kid, kidRef);
                if (kid instanceof PDFPageTree)
                    kid.traverse(visit);
            });
            return _this;
        };
        _this.traverseRight = function (visit) {
            if (_this.Kids.array.length === 0)
                return _this;
            var lastKidRef = last_1.default(_this.Kids.array);
            var lastKid = _this.index.lookup(lastKidRef);
            visit(lastKid, lastKidRef);
            if (lastKid instanceof PDFPageTree)
                lastKid.traverseRight(visit);
            return _this;
        };
        _this.ascend = function (visit, visitSelf) {
            if (visitSelf === void 0) { visitSelf = true; }
            if (visitSelf)
                visit(_this);
            var Parent = _this.Parent;
            if (!Parent)
                return;
            visit(Parent);
            Parent.ascend(visit, false);
        };
        return _this;
    }
    Object.defineProperty(PDFPageTree.prototype, "Kids", {
        get: function () {
            return this.index.lookup(this.get('Kids'));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PDFPageTree.prototype, "Parent", {
        get: function () {
            return this.index.lookupMaybe(this.getMaybe('Parent'));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PDFPageTree.prototype, "Count", {
        get: function () {
            return this.get('Count');
        },
        enumerable: true,
        configurable: true
    });
    PDFPageTree.createRootNode = function (kids, index) {
        validate_1.validate(kids, validate_1.isInstance(pdf_objects_1.PDFArray), '"kids" must be a PDFArray');
        validate_1.validate(index, validate_1.isInstance(PDFObjectIndex_1.default), '"index" must be an instance of PDFObjectIndex');
        return new PDFPageTree({
            Type: pdf_objects_1.PDFName.from('Pages'),
            Kids: kids,
            Count: pdf_objects_1.PDFNumber.fromNumber(kids.array.length),
        }, index);
    };
    PDFPageTree.createNode = function (parent, kids, index) {
        validate_1.validate(parent, validate_1.isInstance(pdf_objects_1.PDFIndirectReference), '"parent" must be a PDFIndirectReference');
        return PDFPageTree.createRootNode(kids, index).set('Parent', parent);
    };
    PDFPageTree.fromDict = function (dict) {
        validate_1.validate(dict, validate_1.isInstance(pdf_objects_1.PDFDictionary), '"dict" must be a PDFDictionary');
        return new PDFPageTree(dict.map, dict.index, VALID_KEYS);
    };
    return PDFPageTree;
}(pdf_objects_1.PDFDictionary));
exports.default = PDFPageTree;
