"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("lodash/isNil"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var pdf_objects_1 = require("../pdf-objects");
var PDFTrailer = /** @class */ (function () {
    function PDFTrailer(offset, dictionary) {
        var _this = this;
        this.toString = function () {
            return (_this.dictionary ? "trailer\n" + _this.dictionary.toString() + "\n" : '') +
                "startxref\n" +
                (_this.offset + "\n") +
                "%%EOF\n";
        };
        this.bytesSize = function () {
            return (_this.dictionary
                ? 8 /* "trailer\n" */ + _this.dictionary.bytesSize() + 1 /* "\n" */
                : 0) +
                10 + // "startxref\n"
                String(_this.offset).length +
                1 + // "\n"
                6;
        }; // "%%EOF\n"
        this.copyBytesInto = function (buffer) {
            var remaining = buffer;
            if (_this.dictionary) {
                remaining = utils_1.addStringToBuffer('trailer\n', remaining);
                remaining = _this.dictionary.copyBytesInto(remaining);
                remaining = utils_1.addStringToBuffer('\n', remaining);
            }
            remaining = utils_1.addStringToBuffer("startxref\n" + _this.offset + "\n%%EOF\n", remaining);
            return remaining;
        };
        validate_1.validate(offset, isNumber_1.default, 'PDFTrailer.offset must be a number');
        validate_1.validate(dictionary, utils_1.or(isNil_1.default, validate_1.isInstance(pdf_objects_1.PDFDictionary)), 'PDFTrailer.dictionary must be instance of PDFDictionary or undefined');
        this.offset = offset;
        this.dictionary = dictionary;
    }
    PDFTrailer.from = function (offset, dictionary) {
        return new PDFTrailer(offset, dictionary);
    };
    return PDFTrailer;
}());
exports.default = PDFTrailer;
