"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:max-classes-per-file */
var add_1 = __importDefault(require("lodash/add"));
var isBoolean_1 = __importDefault(require("lodash/isBoolean"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var padStart_1 = __importDefault(require("lodash/padStart"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var Entry = /** @class */ (function () {
    function Entry() {
        var _this = this;
        this.isInUse = false;
        this.setOffset = function (offset) {
            validate_1.validate(offset, isNumber_1.default, 'offset must be a number');
            _this.offset = offset;
            return _this;
        };
        this.setGenerationNum = function (generationNum) {
            validate_1.validate(generationNum, isNumber_1.default, 'generationNum must be a number');
            _this.generationNum = generationNum;
            return _this;
        };
        this.setIsInUse = function (isInUse) {
            validate_1.validate(isInUse, isBoolean_1.default, 'isInUse must be a boolean');
            _this.isInUse = isInUse;
            return _this;
        };
        this.toString = function () {
            return padStart_1.default(String(_this.offset), 10, '0') + " " +
                (padStart_1.default(String(_this.generationNum), 5, '0') + " ") +
                ((_this.isInUse ? 'n' : 'f') + " \n");
        };
        this.bytesSize = function () { return _this.toString().length; };
    }
    Entry.create = function () { return new Entry(); };
    return Entry;
}());
exports.Entry = Entry;
var Subsection = /** @class */ (function () {
    function Subsection(entries) {
        if (entries === void 0) { entries = []; }
        var _this = this;
        this.entries = [];
        this.addEntry = function (entry) {
            validate_1.validate(entry, validate_1.isInstance(Entry), '"entry" must be instance of PDFXRef.Entry');
            _this.entries.push(entry);
            return _this;
        };
        this.setFirstObjNum = function (firstObjNum) {
            validate_1.validate(firstObjNum, isNumber_1.default, 'firstObjNum must be a number');
            _this.firstObjNum = firstObjNum;
            return _this;
        };
        this.toString = function () {
            return _this.firstObjNum + " " + _this.entries.length + "\n" +
                ("" + _this.entries.map(String).join(''));
        };
        this.bytesSize = function () {
            return (_this.firstObjNum + " " + _this.entries.length + "\n").length +
                _this.entries.map(function (e) { return e.bytesSize(); }).reduce(add_1.default, 0);
        };
        validate_1.validateArr(entries, validate_1.isInstance(Entry), 'PDFXRef.Subsection.entries must be an array of PDFXRef.Entry');
        this.entries = entries;
    }
    Subsection.from = function (entries) {
        if (entries === void 0) { entries = []; }
        return new Subsection(entries);
    };
    return Subsection;
}());
exports.Subsection = Subsection;
var Table = /** @class */ (function () {
    function Table(subsections) {
        if (subsections === void 0) { subsections = []; }
        var _this = this;
        this.subsections = [];
        this.addSubsection = function (subsection) {
            validate_1.validate(subsection, validate_1.isInstance(Subsection), '"subsection" must be instance of PDFXRef.Subsection');
            _this.subsections.push(subsection);
            return _this;
        };
        this.toString = function () { return "xref\n" + _this.subsections.map(String).join('\n') + "\n"; };
        this.bytesSize = function () {
            return 5 + _this.subsections.map(function (ss) { return ss.bytesSize() + 1; }).reduce(add_1.default, 0);
        }; // "xref\n"
        this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer('xref\n', buffer);
            _this.subsections.map(String).forEach(function (subsectionStr) {
                remaining = utils_1.addStringToBuffer(subsectionStr + "\n", remaining);
            });
            return remaining;
        };
        validate_1.validateArr(subsections, validate_1.isInstance(Subsection), 'subsections must be an array of PDFXRef.Subsection');
        this.subsections = subsections;
    }
    Table.from = function (subsections) {
        if (subsections === void 0) { subsections = []; }
        return new Table(subsections);
    };
    return Table;
}());
exports.Table = Table;
