"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var flatten_1 = __importDefault(require("lodash/flatten"));
var max_1 = __importDefault(require("lodash/max"));
var sum_1 = __importDefault(require("lodash/sum"));
var pako_1 = __importDefault(require("pako"));
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
var PDFXRefStream = /** @class */ (function (_super) {
    __extends(PDFXRefStream, _super);
    function PDFXRefStream(_a, index) {
        var Size = _a.Size, Root = _a.Root;
        var _this = _super.call(this, new pdf_objects_1.PDFDictionary({ Type: pdf_objects_1.PDFName.from('XRef'), Size: Size, Root: Root }, index)) || this;
        _this.entries = [];
        _this.addFreeObjectEntry = function (nextFreeObjectNum, generationNum) {
            _this.entries.push([0, nextFreeObjectNum, generationNum]);
        };
        _this.addUncompressedObjectEntry = function (byteOffset, generationNum) {
            _this.entries.push([1, byteOffset, generationNum]);
        };
        _this.addCompressedObjectEntry = function (objectStreamNum, index) {
            _this.entries.push([2, objectStreamNum, index]);
        };
        _this.encode = function () {
            _this.dictionary.set(pdf_objects_1.PDFName.from('Filter'), pdf_objects_1.PDFName.from('FlateDecode'));
            var buffer = new Uint8Array(_this.entriesBytesSize());
            _this.copyEntryBytesInto(buffer);
            _this.encodedEntries = pako_1.default.deflate(buffer);
            return _this;
        };
        _this.bytesSize = function () {
            _this.updateDictionary();
            return (_this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.contentBytesSize() +
                10 // \nendstream
            );
        };
        _this.copyBytesInto = function (buffer) {
            _this.updateDictionary();
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = utils_1.addStringToBuffer('\nstream\n', remaining);
            if (_this.encodedEntries) {
                for (var i = 0; i < _this.encodedEntries.length; i++) {
                    remaining[i] = _this.encodedEntries[i];
                }
                remaining = remaining.subarray(_this.encodedEntries.length);
            }
            else {
                remaining = _this.copyEntryBytesInto(remaining);
            }
            remaining = utils_1.addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        _this.contentBytesSize = function () {
            return _this.encodedEntries ? _this.encodedEntries.length : _this.entriesBytesSize();
        };
        _this.copyEntryBytesInto = function (buffer) {
            var entryWidths = _this.maxEntryByteWidths();
            var idx = 0;
            flatten_1.default(_this.entries).forEach(function (entry, currEntryIdx) {
                var bytes = utils_1.reverseArray(utils_1.bytesFor(entry));
                for (var i = entryWidths[currEntryIdx % 3] - 1; i >= 0; i--) {
                    buffer[idx++] = bytes[i] || 0;
                }
            });
            return buffer.subarray(idx);
        };
        _this.entriesBytesSize = function () {
            return sum_1.default(_this.maxEntryByteWidths()) * _this.entries.length;
        };
        _this.maxEntryByteWidths = function () { return [
            utils_1.sizeInBytes(max_1.default(_this.entries.map(function (_a) {
                var x = _a[0];
                return x;
            }))),
            utils_1.sizeInBytes(max_1.default(_this.entries.map(function (_a) {
                var x = _a[1];
                return x;
            }))),
            utils_1.sizeInBytes(max_1.default(_this.entries.map(function (_a) {
                var x = _a[2];
                return x;
            }))),
        ]; };
        _this.updateDictionary = function () {
            _this.dictionary.set(pdf_objects_1.PDFName.from('W'), pdf_objects_1.PDFArray.fromArray(_this.maxEntryByteWidths().map(pdf_objects_1.PDFNumber.fromNumber), _this.dictionary.index));
            _this.dictionary.set(pdf_objects_1.PDFName.from('Length'), pdf_objects_1.PDFNumber.fromNumber(_this.contentBytesSize()));
        };
        return _this;
    }
    PDFXRefStream.create = function (config, index) { return new PDFXRefStream(config, index); };
    return PDFXRefStream;
}(pdf_objects_1.PDFStream));
exports.default = PDFXRefStream;
