"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../../pdf-objects");
var utils_1 = require("../../../utils");
var validate_1 = require("../../../utils/validate");
/** @hidden */
var MARKERS = [
    0xffc0,
    0xffc1,
    0xffc2,
    0xffc3,
    0xffc5,
    0xffc6,
    0xffc7,
    0xffc8,
    0xffc9,
    0xffca,
    0xffcb,
    0xffcc,
    0xffcd,
    0xffce,
    0xffcf,
];
/**
 * A note of thanks to the developers of https://github.com/devongovett/pdfkit,
 * as this class borrows heavily from:
 * https://github.com/devongovett/pdfkit/blob/e71edab0dd4657b5a767804ba86c94c58d01fbca/lib/image/jpeg.coffee
 */
var JPEGXObjectFactory = /** @class */ (function () {
    function JPEGXObjectFactory(data) {
        var _this = this;
        this.embedImageIn = function (document) {
            var xObjDict = pdf_objects_1.PDFDictionary.from({
                Type: pdf_objects_1.PDFName.from('XObject'),
                Subtype: pdf_objects_1.PDFName.from('Image'),
                BitsPerComponent: pdf_objects_1.PDFNumber.fromNumber(_this.bits),
                Width: pdf_objects_1.PDFNumber.fromNumber(_this.width),
                Height: pdf_objects_1.PDFNumber.fromNumber(_this.height),
                ColorSpace: pdf_objects_1.PDFName.from(_this.colorSpace),
                Filter: pdf_objects_1.PDFName.from('DCTDecode'),
            }, document.index);
            // Add extra decode params for CMYK images. By swapping the
            // min and max values from the default, we invert the colors. See
            // section 4.8.4 of the spec.
            if (_this.colorSpace === 'DeviceCYMK') {
                xObjDict.set('Decode', pdf_objects_1.PDFArray.fromArray([
                    pdf_objects_1.PDFNumber.fromNumber(1.0),
                    pdf_objects_1.PDFNumber.fromNumber(0.0),
                    pdf_objects_1.PDFNumber.fromNumber(1.0),
                    pdf_objects_1.PDFNumber.fromNumber(0.0),
                    pdf_objects_1.PDFNumber.fromNumber(1.0),
                    pdf_objects_1.PDFNumber.fromNumber(0.0),
                    pdf_objects_1.PDFNumber.fromNumber(1.0),
                    pdf_objects_1.PDFNumber.fromNumber(0.0),
                ], document.index));
            }
            xObjDict.set('Length', pdf_objects_1.PDFNumber.fromNumber(_this.imgData.length));
            var xObj = document.register(pdf_objects_1.PDFRawStream.from(xObjDict, _this.imgData));
            return xObj;
        };
        validate_1.validate(data, validate_1.isInstance(Uint8Array), '"data" must be a Uint8Array');
        this.imgData = data;
        var dataView = new DataView(data.buffer);
        if (dataView.getUint16(0) !== 0xffd8)
            utils_1.error('SOI not found in JPEG');
        var pos = 2;
        var marker;
        while (pos < dataView.byteLength) {
            marker = dataView.getUint16(pos);
            pos += 2;
            if (MARKERS.includes(marker))
                break;
            pos += dataView.getUint16(pos);
        }
        if (!MARKERS.includes(marker))
            utils_1.error('Invalid JPEG');
        pos += 2;
        this.bits = dataView.getUint8(pos++);
        this.height = dataView.getUint16(pos);
        pos += 2;
        this.width = dataView.getUint16(pos);
        pos += 2;
        var channelMap = {
            1: 'DeviceGray',
            3: 'DeviceRGB',
            4: 'DeviceCYMK',
        };
        var channels = dataView.getUint8(pos++);
        this.colorSpace = channelMap[channels] || utils_1.error('Unknown JPEG channel.');
    }
    JPEGXObjectFactory.for = function (data) { return new JPEGXObjectFactory(data); };
    return JPEGXObjectFactory;
}());
exports.default = JPEGXObjectFactory;
