import { Font } from '@pdf-lib/fontkit';
import PDFDocument from '../../pdf-document/PDFDocument';
import { PDFArray, PDFDictionary, PDFIndirectReference, PDFNumber } from '../../pdf-objects';
import PDFObjectIndex from '../../pdf-document/PDFObjectIndex';
export interface IFontFlagOptions {
    FixedPitch?: boolean;
    Serif?: boolean;
    Symbolic?: boolean;
    Script?: boolean;
    Nonsymbolic?: boolean;
    Italic?: boolean;
    AllCap?: boolean;
    SmallCap?: boolean;
    ForceBold?: boolean;
}
/**
 * @deprecated Please use the [[PDFEmbeddedFontFactory]] instead.
 *
 * This Factory supports TrueType and OpenType fonts. Note that the apparent
 * hardcoding of values for OpenType fonts does not actually affect TrueType
 * fonts.
 *
 * A note of thanks to the developers of https://github.com/devongovett/pdfkit,
 * as this class borrows heavily from:
 * https://github.com/devongovett/pdfkit/blob/e71edab0dd4657b5a767804ba86c94c58d01fbca/lib/font/embedded.coffee
 */
declare class PDFFontFactory {
    static for: (fontData: Uint8Array, flagOptions: IFontFlagOptions) => PDFFontFactory;
    font: Font;
    scale: number;
    fontData: Uint8Array;
    flagOptions: IFontFlagOptions;
    constructor(fontData: Uint8Array, flagOptions: IFontFlagOptions);
    embedFontIn: (pdfDoc: PDFDocument, name?: string | undefined) => PDFIndirectReference<PDFDictionary>;
    /** @hidden */
    getWidths: (index: PDFObjectIndex) => PDFArray<PDFNumber>;
    getCodePointWidth: (code: number) => number;
}
export default PDFFontFactory;
