"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var flatMap_1 = __importDefault(require("lodash/flatMap"));
var last_1 = __importDefault(require("lodash/last"));
var sortBy_1 = __importDefault(require("lodash/sortBy"));
var pdf_objects_1 = require("../../pdf-objects");
var pdf_structures_1 = require("../../pdf-structures");
var computeIndices = function (objectStream) {
    return objectStream.objects.map(function (object, index) { return ({
        objectNumber: object.reference.objectNumber,
        generationNumber: object.reference.generationNumber,
        index: index,
    }); });
};
var PDFXRefStreamFactory = /** @class */ (function () {
    function PDFXRefStreamFactory() {
    }
    PDFXRefStreamFactory.forOffsetsAndObjectStream = function (offsets, objectStream, catalog, index) {
        var indices = computeIndices(objectStream.pdfObject);
        var merged = sortBy_1.default(offsets.concat(indices), 'objectNumber');
        var xrefObjectNumber = last_1.default(merged).objectNumber + 1;
        var xrefStream = pdf_structures_1.PDFXRefStream.create({
            Size: pdf_objects_1.PDFNumber.fromNumber(xrefObjectNumber + 1),
            Root: catalog,
        }, index);
        merged.push({
            objectNumber: xrefObjectNumber,
            generationNumber: 0,
            startOffset: last_1.default(offsets).startOffset,
        });
        xrefStream.addFreeObjectEntry(0, 65535);
        var xrefSections = [{ firstObjectNumber: 0, size: 1 }];
        merged.forEach(function (obj, idx) {
            var shouldStartNewSection = idx === 0 || obj.objectNumber - merged[idx - 1].objectNumber > 1;
            if (shouldStartNewSection) {
                xrefSections.push({ firstObjectNumber: obj.objectNumber, size: 1 });
            }
            else {
                last_1.default(xrefSections).size += 1;
            }
            if ('startOffset' in obj) {
                xrefStream.addUncompressedObjectEntry(obj.startOffset, obj.generationNumber);
            }
            if ('index' in obj) {
                xrefStream.addCompressedObjectEntry(objectStream.reference.objectNumber, obj.index);
            }
        });
        xrefStream.dictionary.set(pdf_objects_1.PDFName.from('Index'), pdf_objects_1.PDFArray.fromArray(flatMap_1.default(xrefSections, function (_a) {
            var firstObjectNumber = _a.firstObjectNumber, size = _a.size;
            return [
                pdf_objects_1.PDFNumber.fromNumber(firstObjectNumber),
                pdf_objects_1.PDFNumber.fromNumber(size),
            ];
        }), index));
        xrefStream.encode();
        return pdf_objects_1.PDFIndirectObject.of(xrefStream).setReferenceNumbers(xrefObjectNumber, 0);
    };
    return PDFXRefStreamFactory;
}());
exports.default = PDFXRefStreamFactory;
