"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var PDFXRef_1 = require("../PDFXRef");
var PDFXRefTableFactory = /** @class */ (function () {
    function PDFXRefTableFactory() {
    }
    PDFXRefTableFactory.forOffsets = function (offsets) {
        var table = new PDFXRef_1.Table();
        var subsection = new PDFXRef_1.Subsection().setFirstObjNum(0);
        subsection.addEntry(PDFXRef_1.Entry.create()
            .setOffset(0)
            .setGenerationNum(65535)
            .setIsInUse(false));
        table.addSubsection(subsection);
        offsets.forEach(function (info, idx) {
            // Add new subsection if needed...
            var prevObjectMeta = offsets[idx - 1];
            if (idx === 0 || info.objectNumber - prevObjectMeta.objectNumber > 1) {
                subsection = new PDFXRef_1.Subsection().setFirstObjNum(info.objectNumber);
                table.addSubsection(subsection);
            }
            subsection.addEntry(PDFXRef_1.Entry.create()
                .setOffset(info.startOffset)
                .setGenerationNum(0)
                .setIsInUse(true));
        });
        return table;
    };
    return PDFXRefTableFactory;
}());
exports.default = PDFXRefTableFactory;
