import PNG from 'png-ts';
import PDFDocument from '../../pdf-document/PDFDocument';
import { PDFDictionary, PDFIndirectReference, PDFRawStream } from '../../pdf-objects';
/**
 * A note of thanks to the developers of https://github.com/devongovett/pdfkit,
 * as this class borrows heavily from:
 * https://github.com/devongovett/pdfkit/blob/e71edab0dd4657b5a767804ba86c94c58d01fbca/lib/image/png.coffee
 */
declare class PNGXObjectFactory {
    static for: (data: Uint8Array) => PNGXObjectFactory;
    image: PNG;
    width: number;
    height: number;
    imgData: Uint8Array;
    alphaChannel: Uint8Array;
    xObjDict: PDFDictionary;
    document: PDFDocument;
    constructor(data: Uint8Array);
    embedImageIn: (document: PDFDocument) => PDFIndirectReference<PDFRawStream>;
    /** @hidden */
    private finalize;
    /** @hidden */
    private splitAlphaChannel;
    /** @hidden */
    private loadIndexedAlphaChannel;
}
export default PNGXObjectFactory;
