import PDFOperator from '../../../core/pdf-operators/PDFOperator';
/**
 * Options object with named parameters for the [[drawEllipse]] operator helper.
 */
export interface IDrawEllipseOptions {
    /**
     * Default value is `0`.
     *
     * `x` coordinate to position the center of the ellipse.
     */
    x?: number;
    /**
     * Default value is `0`.
     *
     * `y` coordinate to position the center of the ellipse.
     */
    y?: number;
    /**
     * Default value is `100`.
     *
     * Scale of the x dimension.
     */
    xScale?: number;
    /**
     * Default value is `100`.
     *
     * Scale of the y dimension.
     */
    yScale?: number;
    /**
     * Default value is `15`.
     *
     * `borderWidth` of the ellipse.
     */
    borderWidth?: number;
    /**
     * Default value is `[0, 0, 0]` (black).
     *
     * Array of 3 values between `0.0` and `1.0` representing a point in the
     * RGB color space. E.g. `colorRgb: [1, 0.2, 1]` will draw the ellipse in a
     * shade of pink - it's equivalent to `rgb(255, 50, 255)` in CSS.
     *
     * RGB values are usually expressed in numbers from `0`-`255`, not `0.0`-`1.0`
     * as used here. You can simply divide by 255 to do the conversion. E.g. we
     * could achieve the same shade of pink with
     * `colorRgb: [255 / 255, 50 / 255, 255 / 255]`.
     */
    colorRgb?: number[];
    /**
     * Default value is `[0, 0, 0]` (black).
     *
     * Array of 3 values between `0.0` and `1.0` representing a point in the
     * RGB color space. E.g. `borderColorRgb: [1, 0.2, 1]` will draw the border in a
     * shade of pink - it's equivalent to `rgb(255, 50, 255)` in CSS.
     *
     * RGB values are usually expressed in numbers from `0`-`255`, not `0.0`-`1.0`
     * as used here. You can simply divide by 255 to do the conversion. E.g. we
     * could achieve the same shade of pink with
     * `borderColorRgb: [255 / 255, 50 / 255, 255 / 255]`.
     */
    borderColorRgb?: number[];
    /**
     * Default value is `0`.
     *
     * Degrees to rotate the ellipse clockwise. If defined as a negative number,
     * the ellipse will be rotated counter-clockwise.
     */
    rotateDegrees?: number;
    /**
     * Default value is `0`.
     *
     * Radians to rotate the ellipse clockwise. If defined as a negative number,
     * the ellipse will be rotated counter-clockwise.
     */
    rotateRadians?: number;
    /**
     * Default value is `{ xAxis: 0, yAxis: 0 }`.
     *
     * Degrees to skew the x and y axes of the ellipse. Positive values will skew
     * the axes into Quadrant 1. Negative values will skew the axes away from
     * Quadrant 1.
     */
    skewDegrees?: {
        xAxis: number;
        yAxis: number;
    };
    /**
     * Default value is `{ xAxis: 0, yAxis: 0 }`.
     *
     * Radians to skew the x and y axes of the ellipse. Positive values will skew
     * the axes into Quadrant 1. Negative values will skew the axes away from
     * Quadrant 1.
     */
    skewRadians?: {
        xAxis: number;
        yAxis: number;
    };
}
/**
 * Draws an ellipse in a content stream.
 *
 * ```javascript
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawEllipse({
 *       x: 25,
 *       y: 50,
 *       xScale: 50,
 *       yScale: 150,
 *       rotateDegrees: 45,
 *       skewDegrees: { xAxis: 30, yAxis: 30 },
 *       borderWidth: 25,
 *       colorRgb: [0.25, 1.0, 0.79],
 *       borderColorRgb: [0.79, 0.25, 1.0],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param options An options object with named parameters.
 */
export declare const drawEllipse: (options: IDrawEllipseOptions) => PDFOperator[];
/**
 * Options object with named parameters for the [[drawCircle]] operator helper.
 */
export interface IDrawCircleOptions {
    /**
     * Default value is `0`.
     *
     * `x` coordinate to position the center of the circle.
     */
    x?: number;
    /**
     * Default value is `0`.
     *
     * `y` coordinate to position the center of the circle.
     */
    y?: number;
    /**
     * Default value is `100`.
     *
     * Scale of the circle.
     */
    size?: number;
    /**
     * Default value is `15`.
     *
     * `borderWidth` of the circle.
     */
    borderWidth?: number;
    /**
     * Default value is `[0, 0, 0]` (black).
     *
     * Array of 3 values between `0.0` and `1.0` representing a point in the
     * RGB color space. E.g. `colorRgb: [1, 0.2, 1]` will draw the circle in a
     * shade of pink - it's equivalent to `rgb(255, 50, 255)` in CSS.
     *
     * RGB values are usually expressed in numbers from `0`-`255`, not `0.0`-`1.0`
     * as used here. You can simply divide by 255 to do the conversion. E.g. we
     * could achieve the same shade of pink with
     * `colorRgb: [255 / 255, 50 / 255, 255 / 255]`.
     */
    colorRgb?: number[];
    /**
     * Default value is `[0, 0, 0]` (black).
     *
     * Array of 3 values between `0.0` and `1.0` representing a point in the
     * RGB color space. E.g. `borderColorRgb: [1, 0.2, 1]` will draw the border in a
     * shade of pink - it's equivalent to `rgb(255, 50, 255)` in CSS.
     *
     * RGB values are usually expressed in numbers from `0`-`255`, not `0.0`-`1.0`
     * as used here. You can simply divide by 255 to do the conversion. E.g. we
     * could achieve the same shade of pink with
     * `borderColorRgb: [255 / 255, 50 / 255, 255 / 255]`.
     */
    borderColorRgb?: number[];
    /**
     * Default value is `0`.
     *
     * Degrees to rotate the circle clockwise. If defined as a negative number,
     * the circle will be rotated counter-clockwise.
     */
    rotateDegrees?: number;
    /**
     * Default value is `0`.
     *
     * Radians to rotate the circle clockwise. If defined as a negative number,
     * the circle will be rotated counter-clockwise.
     */
    rotateRadians?: number;
    /**
     * Default value is `{ xAxis: 0, yAxis: 0 }`.
     *
     * Degrees to skew the x and y axes of the circle. Positive values will skew
     * the axes into Quadrant 1. Negative values will skew the axes away from
     * Quadrant 1.
     */
    skewDegrees?: {
        xAxis: number;
        yAxis: number;
    };
    /**
     * Default value is `{ xAxis: 0, yAxis: 0 }`.
     *
     * Radians to skew the x and y axes of the circle. Positive values will skew
     * the axes into Quadrant 1. Negative values will skew the axes away from
     * Quadrant 1.
     */
    skewRadians?: {
        xAxis: number;
        yAxis: number;
    };
}
/**
 * Draws a circle in a content stream.
 *
 * ```javascript
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawCircle({
 *       x: 25,
 *       y: 50,
 *       size: 50,
 *       rotateDegrees: 45,
 *       skewDegrees: { xAxis: 30, yAxis: 30 },
 *       borderWidth: 25,
 *       colorRgb: [0.25, 1.0, 0.79],
 *       borderColorRgb: [0.79, 0.25, 1.0],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param options An options object with named parameters.
 */
export declare const drawCircle: (options: IDrawCircleOptions) => PDFOperator[];
