"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var simple_1 = require("../../pdf-operators/simple");
/**
 * Draws an image object in a content stream. PNG and JPG image objects are
 * supported.
 *
 * ```javascript
 * // Should be a Uint8Array containing a PNG image
 * const pngBytes = ...
 *
 * const [pngImage, pngDims] = pdfDoc.embedPNG(pngBytes);
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawImage('MyPngImage', {
 *       x: 25,
 *       y: 50,
 *       width:  pngDims.width  * 0.5, // Make the image 50% smaller
 *       height: pngDims.height * 0.5, // Make the image 50% smaller
 *       rotateDegrees: 180            // Draw the image upside down
 *       skewDegrees: { xAxis: 30, yAxis: 30 } // Skew both axes by 30 degrees
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addImageObject('MyPngImage', pngImage)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param name    Name of the image XObject to be drawn. Should be present in
 *                the XObject Dictionary of the page to which the content stream
 *                is applied.
 * @param options An options object with named parameters.
 */
exports.drawImage = function (name, options) {
    return [
        simple_1.pushGraphicsState(),
        simple_1.translate(options.x || 0, options.y || 0),
        options.rotateDegrees && simple_1.rotateDegrees(options.rotateDegrees),
        options.rotateRadians && simple_1.rotateRadians(options.rotateRadians),
        simple_1.scale(options.width || 100, options.height || 100),
        options.skewDegrees &&
            simple_1.skewDegrees(options.skewDegrees.xAxis, options.skewDegrees.yAxis),
        options.skewRadians &&
            simple_1.skewRadians(options.skewRadians.xAxis, options.skewRadians.yAxis),
        simple_1.image(name),
        simple_1.popGraphicsState(),
    ].filter(Boolean);
};
