"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var get_1 = __importDefault(require("lodash/get"));
var isEmpty_1 = __importDefault(require("lodash/isEmpty"));
var simple_1 = require("../../pdf-operators/simple");
/**
 * Draws a rectangle in a content stream.
 *
 * ```javascript
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawRectangle({
 *       x: 25,
 *       y: 50,
 *       width: 1000,
 *       height: 500,
 *       rotateDegrees: 45,
 *       skewDegrees: { xAxis: 30, yAxis: 30 },
 *       borderWidth: 25,
 *       colorRgb: [0.25, 1.0, 0.79],
 *       borderColorRgb: [0.79, 0.25, 1.0],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param options An options object with named parameters.
 */
exports.drawRectangle = function (options) {
    return [
        simple_1.pushGraphicsState(),
        simple_1.fillingRgbColor(get_1.default(options, 'colorRgb[0]', 0), get_1.default(options, 'colorRgb[1]', 0), get_1.default(options, 'colorRgb[2]', 0)),
        simple_1.strokingRgbColor(get_1.default(options, 'borderColorRgb[0]', 0), get_1.default(options, 'borderColorRgb[1]', 0), get_1.default(options, 'borderColorRgb[2]', 0)),
        simple_1.lineWidth(options.borderWidth || 15),
        simple_1.translate(options.x || 0, options.y || 0),
        options.rotateDegrees && simple_1.rotateDegrees(options.rotateDegrees),
        options.rotateRadians && simple_1.rotateRadians(options.rotateRadians),
        options.skewDegrees &&
            simple_1.skewDegrees(options.skewDegrees.xAxis, options.skewDegrees.yAxis),
        options.skewRadians &&
            simple_1.skewRadians(options.skewRadians.xAxis, options.skewRadians.yAxis),
        simple_1.moveTo(0, 0),
        simple_1.lineTo(0, options.height || 100),
        simple_1.lineTo(options.width || 150, options.height || 100),
        simple_1.lineTo(options.width || 150, 0),
        simple_1.closePath(),
        // prettier-ignore
        !isEmpty_1.default(options.colorRgb) && !isEmpty_1.default(options.borderColorRgb) ? simple_1.fillAndStroke()
            : !isEmpty_1.default(options.colorRgb) ? simple_1.fill()
                : !isEmpty_1.default(options.borderColorRgb) ? simple_1.stroke()
                    : simple_1.closePath(),
        simple_1.popGraphicsState(),
    ].filter(Boolean);
};
/**
 * Draws a square in a content stream.
 *
 * ```javascript
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawSquare({
 *       x: 25,
 *       y: 50,
 *       size: 500,
 *       rotateDegrees: 45,
 *       skewDegrees: { xAxis: 30, yAxis: 30 },
 *       borderWidth: 25,
 *       colorRgb: [0.25, 1.0, 0.79],
 *       borderColorRgb: [0.79, 0.25, 1.0],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param options An options object with named parameters.
 */
exports.drawSquare = function (options) {
    return exports.drawRectangle({
        x: options.x || 0,
        y: options.y || 0,
        width: options.size || 100,
        height: options.size || 100,
        rotateDegrees: options.rotateDegrees,
        rotateRadians: options.rotateRadians,
        skewDegrees: options.skewDegrees,
        skewRadians: options.skewRadians,
        borderWidth: options.borderWidth || 15,
        colorRgb: options.colorRgb || [],
        borderColorRgb: options.borderColorRgb || [],
    });
};
