"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var flatMap_1 = __importDefault(require("lodash/flatMap"));
var get_1 = __importDefault(require("lodash/get"));
var PDFTextObject_1 = __importDefault(require("../../../core/pdf-operators/text/PDFTextObject"));
var simple_1 = require("../../pdf-operators/simple");
// TODO: Implement the border* options
/**
 * Draws a line of text in a content stream.
 *
 * ```javascript
 * const [timesRomanFont] = pdfDoc.embedStandardFont('Times-Roman');
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawText('This is a line of text!', {
 *       x: 25,
 *       y: 50,
 *       rotateDegrees: 180,
 *       skewDegrees: { xAxis: 15, yAxis: 15 },
 *       font: 'Times-Roman',
 *       size: 24,
 *       colorRgb: [0.25, 1.0, 0.79],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addFontDictionary('Times-Roman', timesRomanFont)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param line    A string of text to draw.
 * @param options An options object with named parameters.
 */
exports.drawText = function (line, options) { return [
    PDFTextObject_1.default.of(simple_1.fillingRgbColor(get_1.default(options, 'colorRgb[0]', 0), get_1.default(options, 'colorRgb[1]', 0), get_1.default(options, 'colorRgb[2]', 0)), simple_1.fontAndSize(options.font, options.size || 12), simple_1.rotateAndSkewTextRadiansAndTranslate(options.rotateDegrees
        ? simple_1.degreesToRadians(options.rotateDegrees)
        : options.rotateRadians || 0, 
    // prettier-ignore
    options.skewDegrees ? simple_1.degreesToRadians(options.skewDegrees.xAxis)
        : options.skewRadians ? options.skewRadians.xAxis
            : 0, 
    // prettier-ignore
    options.skewDegrees ? simple_1.degreesToRadians(options.skewDegrees.yAxis)
        : options.skewRadians ? options.skewRadians.yAxis
            : 0, options.x || 0, options.y || 0), simple_1.text(line)),
]; };
/**
 * Draws multiple lines of text in a content stream.
 *
 * ```javascript
 * const [timesRomanFont] = pdfDoc.embedStandardFont('Times-Roman');
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawLinesOfText(
 *       ['First line of text.', 'Second line of text.'], {
 *       x: 25,
 *       y: 50,
 *       rotateDegrees: 180,
 *       skewDegrees: { xAxis: 15, yAxis: 15 },
 *       font: 'Times-Roman',
 *       size: 24,
 *       lineHeight: 48,
 *       colorRgb: [0.25, 1.0, 0.79],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addFontDictionary('Times-Roman', timesRomanFont)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param lines   An array of strings to be drawn.
 * @param options An options object with named parameters.
 */
exports.drawLinesOfText = function (lines, options) { return [
    PDFTextObject_1.default.of.apply(PDFTextObject_1.default, [simple_1.fillingRgbColor(get_1.default(options, 'colorRgb[0]', 0), get_1.default(options, 'colorRgb[1]', 0), get_1.default(options, 'colorRgb[2]', 0)),
        simple_1.fontAndSize(options.font, options.size || 12),
        simple_1.lineHeight(options.lineHeight || options.size || 12),
        simple_1.rotateAndSkewTextRadiansAndTranslate(options.rotateDegrees
            ? simple_1.degreesToRadians(options.rotateDegrees)
            : options.rotateRadians || 0, 
        // prettier-ignore
        options.skewDegrees ? simple_1.degreesToRadians(options.skewDegrees.xAxis)
            : options.skewRadians ? options.skewRadians.xAxis
                : 0, 
        // prettier-ignore
        options.skewDegrees ? simple_1.degreesToRadians(options.skewDegrees.yAxis)
            : options.skewRadians ? options.skewRadians.yAxis
                : 0, options.x || 0, options.y || 0)].concat(flatMap_1.default(lines, function (line) { return [
        simple_1.text(line),
        simple_1.nextLine(),
    ]; }))),
]; };
