"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var round_1 = __importDefault(require("lodash/round"));
var GOps_1 = require("../../core/pdf-operators/graphics/color/GOps");
var KOps_1 = require("../../core/pdf-operators/graphics/color/KOps");
var RGOps_1 = require("../../core/pdf-operators/graphics/color/RGOps");
var cm_1 = __importDefault(require("../../core/pdf-operators/graphics/graphics-state/cm"));
var d_1 = __importDefault(require("../../core/pdf-operators/graphics/graphics-state/d"));
var JOps_1 = require("../../core/pdf-operators/graphics/graphics-state/JOps");
var w_1 = __importDefault(require("../../core/pdf-operators/graphics/graphics-state/w"));
var c_1 = __importDefault(require("../../core/pdf-operators/graphics/path-construction/c"));
var h_1 = __importDefault(require("../../core/pdf-operators/graphics/path-construction/h"));
var l_1 = __importDefault(require("../../core/pdf-operators/graphics/path-construction/l"));
var m_1 = __importDefault(require("../../core/pdf-operators/graphics/path-construction/m"));
var re_1 = __importDefault(require("../../core/pdf-operators/graphics/path-construction/re"));
var TDOps_1 = require("../../core/pdf-operators/text/text-positioning/TDOps");
var Tm_1 = __importDefault(require("../../core/pdf-operators/text/text-positioning/Tm"));
var TJOps_1 = require("../../core/pdf-operators/text/text-showing/TJOps");
var Tc_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Tc"));
var Tf_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Tf"));
var TL_1 = __importDefault(require("../../core/pdf-operators/text/text-state/TL"));
var Tr_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Tr"));
var Ts_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Ts"));
var Tw_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Tw"));
var Tz_1 = __importDefault(require("../../core/pdf-operators/text/text-state/Tz"));
var Do_1 = __importDefault(require("../../core/pdf-operators/Do"));
var pdf_operators_1 = __importDefault(require("../../core/pdf-operators"));
/* ======== Clipping path operators ======== */
var W = pdf_operators_1.default.W;
exports.clip = function () { return W.operator; };
exports.clipEvenOdd = function () { return W.asterisk.operator; };
/* ======== Graphics state operators ======== */
var Q = pdf_operators_1.default.Q, q = pdf_operators_1.default.q;
var cos = Math.cos, sin = Math.sin, tan = Math.tan;
exports.degreesToRadians = function (degrees) { return (degrees * Math.PI) / 180; };
exports.translate = function (xPos, yPos) {
    return cm_1.default.of(1, 0, 0, 1, xPos, yPos);
};
exports.scale = function (xPos, yPos) {
    return cm_1.default.of(xPos, 0, 0, yPos, 0, 0);
};
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
exports.rotateRadians = function (angle) {
    return cm_1.default.of(round_1.default(cos(angle), 6), round_1.default(sin(angle), 6), round_1.default(-sin(angle), 6), round_1.default(cos(angle), 6), 0, 0);
};
exports.rotateDegrees = function (angle) {
    return exports.rotateRadians(exports.degreesToRadians(angle));
};
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
exports.skewRadians = function (xSkewAngle, ySkewAngle) {
    return cm_1.default.of(1, round_1.default(tan(xSkewAngle), 6), round_1.default(tan(ySkewAngle), 6), 1, 0, 0);
};
exports.skewDegrees = function (xSkewAngle, ySkewAngle) {
    return exports.skewRadians(exports.degreesToRadians(xSkewAngle), exports.degreesToRadians(ySkewAngle));
};
exports.dashPattern = d_1.default.of;
exports.restoreDashPattern = function () { return d_1.default.of([], 0); };
exports.lineCap = function (style) {
    return JOps_1.J.of({ butt: 0, round: 1, projecting: 2 }[style]);
};
exports.lineJoin = function (style) {
    return JOps_1.j.of({ miter: 0, round: 1, bevel: 2 }[style]);
};
exports.popGraphicsState = function () { return Q.operator; };
exports.pushGraphicsState = function () { return q.operator; };
exports.lineWidth = w_1.default.of;
/* ======== Path construction operators ======== */
exports.appendBezierCurve = c_1.default.of;
exports.closePath = function () { return h_1.default.operator; };
exports.moveTo = m_1.default.of;
exports.lineTo = l_1.default.of;
exports.rectangle = re_1.default.of;
exports.square = function (xPos, yPos, size) {
    return exports.rectangle(xPos, yPos, size, size);
};
/* ======== Path painting operators ======== */
var S = pdf_operators_1.default.S, f = pdf_operators_1.default.f, B = pdf_operators_1.default.B, n = pdf_operators_1.default.n;
exports.stroke = function () { return S.operator; };
exports.fill = function () { return f.operator; };
exports.fillAndStroke = function () { return B.operator; };
exports.endPath = function () { return n.operator; };
/* ======== Test positioning operators ======== */
var T = pdf_operators_1.default.T;
// TODO: Allow an optional number to move more/less than the default line height.
exports.nextLine = function () { return T.asterisk.operator; };
exports.textPosition = TDOps_1.Td.of;
/* ======== Text showing operators ======== */
exports.text = TJOps_1.Tj.of;
/* ======== Text state operators ======== */
exports.fontAndSize = Tf_1.default.of;
exports.charSpacing = Tc_1.default.of;
exports.wordSpacing = Tw_1.default.of;
// Compresses glyphs horizontally - not vertically.
exports.charSqueeze = Tz_1.default.of;
exports.lineHeight = TL_1.default.of;
exports.textRise = Ts_1.default.of;
exports.textRenderingMode = function (style) {
    return Tr_1.default.of({
        fill: 0,
        outline: 1,
        fillAndOutline: 2,
        invisible: 3,
        fillAndClip: 4,
        outlineAndClip: 5,
        fillAndOutlineAndClip: 6,
        clip: 7,
    }[style]);
};
exports.textMatrix = Tm_1.default.of;
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
exports.rotateAndSkewTextRadiansAndTranslate = function (rotationAngle, xSkewAngle, ySkewAngle, x, y) {
    return Tm_1.default.of(round_1.default(cos(rotationAngle), 6), round_1.default(sin(rotationAngle) + tan(xSkewAngle), 6), round_1.default(-sin(rotationAngle) + tan(ySkewAngle), 6), round_1.default(cos(rotationAngle), 6), x, y);
};
exports.rotateAndSkewTextDegreesAndTranslate = function (rotationAngle, xSkewAngle, ySkewAngle, x, y) {
    return exports.rotateAndSkewTextRadiansAndTranslate(exports.degreesToRadians(rotationAngle), exports.degreesToRadians(xSkewAngle), exports.degreesToRadians(ySkewAngle), x, y);
};
/* ======== XObject operator ======== */
exports.image = Do_1.default.of;
/* ======== Color operators ======== */
exports.fillingGrayscaleColor = GOps_1.g.of;
exports.strokingGrayscaleColor = GOps_1.G.of;
exports.fillingRgbColor = RGOps_1.rg.of;
exports.strokingRgbColor = RGOps_1.RG.of;
exports.fillingCmykColor = KOps_1.k.of;
exports.strokingCmykColor = KOps_1.K.of;
