export declare type Predicate<A, B = true> = (a: A, b?: B) => boolean;
export declare type ArrayPredicate<A> = (...a: A[]) => boolean;
export declare const error: (msg: string) => never;
export declare const digits: (num: number) => number;
export declare const sizeInBytes: (n: number) => number;
/**
 * Converts a number into its constituent bytes and returns them as
 * a number[].
 *
 * Returns most significant byte as first element in array. It may be necessary
 * to call .reverse() to get the bits in the desired order.
 *
 * Example:
 *   bytesFor(0x02A41E) => [ 0b10, 0b10100100, 0b11110 ]
 *
 * Credit for algorithm: https://stackoverflow.com/a/1936865
 */
export declare const bytesFor: (n: number) => Uint8Array;
export declare const reverseArray: (array: any[] | Uint8Array) => any[] | Uint8Array;
export declare const isInt: (num: number) => boolean;
export declare const and: (...predicates: ArrayPredicate<any>[]) => (...values: any[]) => boolean;
export declare const or: (...predicates: ArrayPredicate<any>[]) => (...values: any[]) => boolean;
export declare const not: (predicate: ArrayPredicate<any>) => (...values: any[]) => boolean;
export declare const toBoolean: (boolStr: string) => boolean;
export declare const toCharCode: (charStr: string) => number;
export declare const charFromCode: (code: number) => string;
export declare const toHexStringOfMinLength: (num: number, minLength: number) => string;
export declare const toHexString: (num: number) => string;
export declare const mergeUint8Arrays: (...arrs: Uint8Array[]) => Uint8Array;
export declare const addStringToBuffer: (str: string, buffer: Uint8Array) => Uint8Array;
export declare const charCodes: (str: string) => number[];
export declare const typedArrayFor: (str: string) => Uint8Array;
export declare const arrayToString: (arr: Uint8Array | number[], startAt?: number, stopAt?: number | undefined) => string;
export declare const arrayCharAt: (arr: any[] | Uint8Array, idx: number) => string;
export declare const trimArray: (arr: Uint8Array) => Uint8Array;
export declare const trimArrayAndRemoveComments: (arr: Uint8Array) => Uint8Array;
export declare const arraysAreEqual: (arr1: any[] | Uint8Array, arr1Start: number, arr1Stop: number, arr2: any[] | Uint8Array, arr2Start: number, arr2Stop: number) => boolean;
export declare const arrayIndexOf: (arr: any[] | Uint8Array, targetStr: string, startFrom?: number) => number | undefined;
export declare const arrayIndexOneOf: (arr: any[] | Uint8Array, targetStrings: string[], startFrom?: number) => void | [number, string];
export declare const arrayIndexOfReverse: (arr: any[], targetStr: string, startFrom: number) => number | undefined;
export declare const arrayFindIndexOf: (arr: Uint8Array, predicate: (a: any) => boolean, startFrom?: number) => number | undefined;
export declare const setCharAt: (str: string, idx: number, newChar: string) => string;
export declare const mapIntoContiguousGroups: <A, B>(all: A[], indexProvider: (element: A) => number, transformer: (element: A) => B) => B[][];
export declare const contiguousGroups: <A>(all: A[], indexProvider: (element: A) => number) => A[][];
