"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable no-bitwise */
var padStart_1 = __importDefault(require("lodash/padStart"));
var sum_1 = __importDefault(require("lodash/sum"));
// export const writeToDebugFile = (data: any, postfix = 0) => {
//   // eslint-disable-next-line
//   const fs = require('fs');
//   fs.writeFileSync(`/Users/user/Desktop/pdf-lib/debug${postfix}`, data);
// };
exports.error = function (msg) {
    throw new Error(msg);
};
exports.digits = function (num) { return String(num).split('').length; };
exports.sizeInBytes = function (n) { return Math.ceil(n.toString(2).length / 8); };
/**
 * Converts a number into its constituent bytes and returns them as
 * a number[].
 *
 * Returns most significant byte as first element in array. It may be necessary
 * to call .reverse() to get the bits in the desired order.
 *
 * Example:
 *   bytesFor(0x02A41E) => [ 0b10, 0b10100100, 0b11110 ]
 *
 * Credit for algorithm: https://stackoverflow.com/a/1936865
 */
exports.bytesFor = function (n) {
    var bytes = new Uint8Array(exports.sizeInBytes(n));
    for (var i = 1; i <= bytes.length; i++) {
        bytes[i - 1] = n >> ((bytes.length - i) * 8);
    }
    return bytes;
};
// Arrays and TypedArrays in JS both have .reverse() methods, which would seem
// to negate the need for this function. However, not all runtimes support this
// method (e.g. React Native), so using this function compensates for that.
exports.reverseArray = function (array) {
    for (var i = 0; i < Math.floor(array.length / 2); i++) {
        var leftIdx = i;
        var rightIdx = array.length - i - 1;
        var temp = array[i];
        array[leftIdx] = array[rightIdx];
        array[rightIdx] = temp;
    }
    return array;
};
exports.isInt = function (num) { return num % 1 === 0; };
exports.and = function () {
    var predicates = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        predicates[_i] = arguments[_i];
    }
    return function () {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        return predicates.every(function (predicate) { return predicate.apply(void 0, values); });
    };
};
exports.or = function () {
    var predicates = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        predicates[_i] = arguments[_i];
    }
    return function () {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        return predicates.some(function (predicate) { return predicate.apply(void 0, values); });
    };
};
exports.not = function (predicate) { return function () {
    var values = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        values[_i] = arguments[_i];
    }
    return !predicate.apply(void 0, values);
}; };
exports.toBoolean = function (boolStr) {
    if (boolStr === 'true')
        return true;
    if (boolStr === 'false')
        return false;
    throw new Error("\"" + boolStr + "\" cannot be converted to a boolean");
};
exports.toCharCode = function (charStr) {
    if (charStr.length !== 1) {
        throw new Error('"char" must be exactly one character long');
    }
    return charStr.charCodeAt(0);
};
exports.charFromCode = function (code) { return String.fromCharCode(code); };
exports.toHexStringOfMinLength = function (num, minLength) {
    return padStart_1.default(num.toString(16), minLength, '0');
};
exports.toHexString = function (num) { return exports.toHexStringOfMinLength(num, 2); };
exports.mergeUint8Arrays = function () {
    var arrs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrs[_i] = arguments[_i];
    }
    var totalLength = sum_1.default(arrs.map(function (a) { return a.length; }));
    var newArray = new Uint8Array(totalLength);
    var offset = 0;
    arrs.forEach(function (a) {
        newArray.set(a, offset);
        offset += a.length;
    });
    return newArray;
};
exports.addStringToBuffer = function (str, buffer) {
    for (var i = 0; i < str.length; i += 1) {
        buffer[i] = str.charCodeAt(i);
    }
    return buffer.subarray(str.length);
};
exports.charCodes = function (str) {
    return str.split('').map(function (c) { return c.charCodeAt(0); });
};
exports.typedArrayFor = function (str) { return new Uint8Array(exports.charCodes(str)); };
exports.arrayToString = function (arr, startAt, stopAt) {
    if (startAt === void 0) { startAt = 0; }
    var stopIdx = stopAt === undefined || stopAt >= arr.length ? arr.length : stopAt;
    var str = '';
    for (var i = startAt; i < stopIdx; i += 1) {
        str += exports.charFromCode(arr[i]);
    }
    return str;
};
exports.arrayCharAt = function (arr, idx) {
    return String.fromCharCode(arr[idx]);
};
exports.trimArray = function (arr) {
    var idx = 0;
    while (String.fromCharCode(arr[idx]).match(/^[\0\t\n\f\r ]/) &&
        idx < arr.length) {
        idx += 1;
    }
    return arr.subarray(idx);
};
var PERCENT_SIGN_CODE = exports.toCharCode('%');
var NEWLINE_CODE = exports.toCharCode('\n');
var CARRIAGE_RETURN_CODE = exports.toCharCode('\r');
var isEOLMarker = function (code) {
    return code === NEWLINE_CODE || code === CARRIAGE_RETURN_CODE;
};
exports.trimArrayAndRemoveComments = function (arr) {
    var strippedComment = true;
    var newArray = arr;
    while (strippedComment) {
        newArray = exports.trimArray(newArray);
        if (newArray[0] === PERCENT_SIGN_CODE) {
            var idx = 0;
            while (!isEOLMarker(newArray[idx]) && idx < newArray.length)
                idx += 1;
            var foundEOLMarker = isEOLMarker(newArray[idx]);
            if (foundEOLMarker)
                newArray = newArray.subarray(idx);
            strippedComment = foundEOLMarker;
        }
        else {
            strippedComment = false;
        }
    }
    return newArray;
};
exports.arraysAreEqual = function (arr1, arr1Start, arr1Stop, arr2, arr2Start, arr2Stop) {
    var arr1Length = arr1Stop - arr1Start;
    if (arr1Length !== arr2Stop - arr2Start)
        return false;
    for (var i = 0; i < arr1Length; i += 1) {
        if (arr1[arr1Start + i] !== arr2[arr2Start + i])
            return false;
    }
    return true;
};
exports.arrayIndexOf = function (arr, targetStr, startFrom) {
    if (startFrom === void 0) { startFrom = 0; }
    var targetArr = targetStr.split('').map(function (c) { return c.charCodeAt(0); });
    var currIdx = startFrom;
    while (!exports.arraysAreEqual(arr, currIdx, currIdx + targetStr.length, targetArr, 0, targetArr.length)) {
        currIdx += 1;
        if (currIdx >= arr.length)
            return undefined;
    }
    return currIdx;
};
exports.arrayIndexOneOf = function (arr, targetStrings, startFrom) {
    if (startFrom === void 0) { startFrom = 0; }
    var targetArrs = targetStrings.map(function (str) { return str.split('').map(exports.toCharCode); });
    var currIdx = startFrom;
    var match = null;
    while (!match) {
        currIdx += 1;
        if (currIdx >= arr.length)
            return undefined;
        match = targetArrs.find(function (target) {
            return exports.arraysAreEqual(arr, currIdx, currIdx + target.length, target, 0, target.length);
        });
    }
    return [currIdx, exports.arrayToString(match)];
};
exports.arrayIndexOfReverse = function (arr, targetStr, startFrom) {
    // validate(
    //   startFrom,
    //   and(_.isNumber, not(_.isNaN)),
    //   `startFrom must be a number, found: "${startFrom}"`,
    // );
    var targetArr = targetStr.split('').map(function (c) { return c.charCodeAt(0); });
    var currIdx = startFrom;
    while (!exports.arraysAreEqual(arr, currIdx, currIdx + targetStr.length, targetArr, 0, targetArr.length)) {
        currIdx -= 1;
        if (currIdx === -1)
            return undefined;
    }
    return currIdx;
};
exports.arrayFindIndexOf = function (arr, predicate, startFrom) {
    if (startFrom === void 0) { startFrom = 0; }
    var currIdx = startFrom;
    while (!predicate(arr.subarray(currIdx, currIdx + 1)[0])) {
        currIdx += 1;
        if (currIdx >= arr.length)
            return undefined;
    }
    return currIdx;
};
exports.setCharAt = function (str, idx, newChar) {
    return str.substring(0, idx) + newChar + str.substring(idx + 1);
};
exports.mapIntoContiguousGroups = function (all, indexProvider, transformer) {
    var sections = [];
    var currSection = [];
    var lastIndex = NaN;
    for (var _i = 0, all_1 = all; _i < all_1.length; _i++) {
        var element = all_1[_i];
        var currIndex = indexProvider(element);
        var breakDetected = currIndex - lastIndex !== 1;
        var isFirstIteration = isNaN(lastIndex);
        if (breakDetected && !isFirstIteration) {
            sections.push(currSection);
            currSection = [];
        }
        currSection.push(transformer(element));
        lastIndex = currIndex;
    }
    sections.push(currSection);
    return sections;
};
exports.contiguousGroups = function (all, indexProvider) { return exports.mapIntoContiguousGroups(all, indexProvider, function (x) { return x; }); };
