"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
/* tslint:disable:ban-types */
var inRange_1 = __importDefault(require("lodash/inRange"));
var isArray_1 = __importDefault(require("lodash/isArray"));
var isNaN_1 = __importDefault(require("lodash/isNaN"));
var isNil_1 = __importDefault(require("lodash/isNil"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var pdf_objects_1 = require("../core/pdf-objects");
var _1 = require(".");
exports.validate = function (value, predicate, msg) {
    if (!predicate(value))
        throw new Error(msg);
};
exports.optional = function (predicate) { return function (value) {
    return isNil_1.default(value) || predicate(value);
}; };
exports.validateArr = function (value, predicate, msg) {
    exports.validate(value, isArray_1.default, 'validateArr.value must be an array.');
    value.forEach(function (v) { return exports.validate(v, predicate, msg); });
};
exports.isInstance = function (requiredClass) { return function (value) { return value instanceof requiredClass; }; };
exports.isArrayOf = function (requiredClass) { return function (value) {
    if (!isArray_1.default(value))
        return false;
    for (var i = 0; i < value.length; i++) {
        if (!(value[i] instanceof requiredClass))
            return false;
    }
    return true;
}; };
exports.isIdentity = function (requiredValue) { return function (value) {
    return value === requiredValue;
}; };
exports.isNotIdentity = function (requiredValue) { return function (value) {
    return value !== requiredValue;
}; };
exports.doesMatch = function (regex) { return function (value) {
    return !!value.match(regex);
}; };
exports.isNumber = function (n) { return _1.and(isNumber_1.default, _1.not(isNaN_1.default))(n); };
exports.isInRange = function (lower, upper) { return function (value) {
    return inRange_1.default(value, lower, upper) || value === upper;
}; };
exports.isIndirectObjectOf = function (requiredClass) { return function (value) {
    return exports.isInstance(pdf_objects_1.PDFIndirectObject)(value) &&
        exports.isInstance(requiredClass)(value.pdfObject);
}; };
exports.oneOf = function () {
    var allowed = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        allowed[_i] = arguments[_i];
    }
    return function (value) {
        return allowed.some(function (a) { return a === value; });
    };
};
