"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var PDFArray_1 = tslib_1.__importDefault(require("../objects/PDFArray"));
var PDFDict_1 = tslib_1.__importDefault(require("../objects/PDFDict"));
var PDFName_1 = tslib_1.__importDefault(require("../objects/PDFName"));
var PDFStream_1 = tslib_1.__importDefault(require("../objects/PDFStream"));
var PDFPageLeaf = /** @class */ (function (_super) {
    tslib_1.__extends(PDFPageLeaf, _super);
    function PDFPageLeaf(map, context, autoNormalizeCTM) {
        if (autoNormalizeCTM === void 0) { autoNormalizeCTM = true; }
        var _this = _super.call(this, map, context) || this;
        _this.normalized = false;
        _this.autoNormalizeCTM = autoNormalizeCTM;
        return _this;
    }
    PDFPageLeaf.prototype.clone = function (context) {
        var clone = PDFPageLeaf.fromMapWithContext(new Map(), context || this.context, this.autoNormalizeCTM);
        var entries = this.entries();
        for (var idx = 0, len = entries.length; idx < len; idx++) {
            var _a = entries[idx], key = _a[0], value = _a[1];
            clone.set(key, value);
        }
        return clone;
    };
    PDFPageLeaf.prototype.Parent = function () {
        return this.lookup(PDFName_1.default.of('Parent'));
    };
    PDFPageLeaf.prototype.Contents = function () {
        return this.lookup(PDFName_1.default.of('Contents'));
    };
    PDFPageLeaf.prototype.Annots = function () {
        return this.lookup(PDFName_1.default.of('Annots'));
    };
    PDFPageLeaf.prototype.BleedBox = function () {
        return this.lookup(PDFName_1.default.of('BleedBox'));
    };
    PDFPageLeaf.prototype.TrimBox = function () {
        return this.lookup(PDFName_1.default.of('TrimBox'));
    };
    PDFPageLeaf.prototype.Resources = function () {
        var dictOrRef = this.getInheritableAttribute(PDFName_1.default.of('Resources'));
        return this.context.lookup(dictOrRef, PDFDict_1.default);
    };
    PDFPageLeaf.prototype.MediaBox = function () {
        var arrayOrRef = this.getInheritableAttribute(PDFName_1.default.of('MediaBox'));
        return this.context.lookup(arrayOrRef, PDFArray_1.default);
    };
    PDFPageLeaf.prototype.CropBox = function () {
        var maybeArrayOrRef = this.getInheritableAttribute(PDFName_1.default.of('CropBox'));
        return this.context.lookup(maybeArrayOrRef);
    };
    PDFPageLeaf.prototype.Rotate = function () {
        var numberOrRef = this.getInheritableAttribute(PDFName_1.default.of('Rotate'));
        return this.context.lookup(numberOrRef);
    };
    PDFPageLeaf.prototype.getInheritableAttribute = function (name) {
        var attribute;
        this.ascend(function (node) {
            if (!attribute)
                attribute = node.get(name);
        });
        return attribute;
    };
    PDFPageLeaf.prototype.setParent = function (parentRef) {
        this.set(PDFName_1.default.of('Parent'), parentRef);
    };
    PDFPageLeaf.prototype.addContentStream = function (contentStreamRef) {
        this.normalize();
        var Contents = this.Contents();
        if (!Contents) {
            Contents = this.context.obj([]);
            this.set(PDFName_1.default.of('Contents'), Contents);
        }
        Contents.push(contentStreamRef);
    };
    PDFPageLeaf.prototype.wrapContentStreams = function (startStream, endStream) {
        var contents = this.lookup(PDFName_1.default.of('Contents'));
        if (contents instanceof PDFArray_1.default) {
            contents.insert(0, startStream);
            contents.push(endStream);
            return true;
        }
        return false;
    };
    PDFPageLeaf.prototype.setFontDictionary = function (name, fontDictRef) {
        this.normalize();
        var Font = this.Resources().lookup(PDFName_1.default.of('Font'), PDFDict_1.default);
        Font.set(name, fontDictRef);
    };
    PDFPageLeaf.prototype.setXObject = function (name, xObjectRef) {
        this.normalize();
        var XObject = this.Resources().lookup(PDFName_1.default.of('XObject'), PDFDict_1.default);
        XObject.set(name, xObjectRef);
    };
    PDFPageLeaf.prototype.ascend = function (visitor) {
        visitor(this);
        var Parent = this.Parent();
        if (Parent)
            Parent.ascend(visitor);
    };
    PDFPageLeaf.prototype.normalize = function () {
        if (this.normalized)
            return;
        var context = this.context;
        var contentsRef = this.get(PDFName_1.default.of('Contents'));
        var contents = this.context.lookup(contentsRef);
        if (contents instanceof PDFStream_1.default) {
            this.set(PDFName_1.default.of('Contents'), context.obj([contentsRef]));
        }
        if (this.autoNormalizeCTM) {
            this.wrapContentStreams(this.context.getPushGraphicsStateContentStream(), this.context.getPopGraphicsStateContentStream());
        }
        var Resources = this.get(PDFName_1.default.of('Resources'))
            ? this.Resources()
            : context.obj({});
        this.set(PDFName_1.default.of('Resources'), Resources);
        var Font = Resources.lookup(PDFName_1.default.of('Font')) || context.obj({});
        Resources.set(PDFName_1.default.of('Font'), Font);
        var XObject = Resources.lookup(PDFName_1.default.of('XObject')) || context.obj({});
        Resources.set(PDFName_1.default.of('XObject'), XObject);
        this.normalized = true;
    };
    PDFPageLeaf.InheritableEntries = [
        'Resources',
        'MediaBox',
        'CropBox',
        'Rotate',
    ];
    PDFPageLeaf.withContextAndParent = function (context, parent) {
        var dict = new Map();
        dict.set(PDFName_1.default.of('Type'), PDFName_1.default.of('Page'));
        dict.set(PDFName_1.default.of('Parent'), parent);
        dict.set(PDFName_1.default.of('Resources'), context.obj({}));
        dict.set(PDFName_1.default.of('MediaBox'), context.obj([0, 0, 612, 792]));
        return new PDFPageLeaf(dict, context, false);
    };
    PDFPageLeaf.fromMapWithContext = function (map, context, autoNormalizeCTM) {
        if (autoNormalizeCTM === void 0) { autoNormalizeCTM = true; }
        return new PDFPageLeaf(map, context, autoNormalizeCTM);
    };
    return PDFPageLeaf;
}(PDFDict_1.default));
exports.default = PDFPageLeaf;
//# sourceMappingURL=PDFPageLeaf.js.map