"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toCharCode = function (character) { return character.charCodeAt(0); };
exports.toCodePoint = function (character) { return character.codePointAt(0); };
exports.toHexStringOfMinLength = function (num, minLength) {
    return exports.padStart(num.toString(16), minLength, '0').toUpperCase();
};
exports.toHexString = function (num) { return exports.toHexStringOfMinLength(num, 2); };
exports.charFromCode = function (code) { return String.fromCharCode(code); };
exports.charFromHexCode = function (hex) { return exports.charFromCode(parseInt(hex, 16)); };
exports.padStart = function (value, length, padChar) {
    var padding = '';
    for (var idx = 0, len = length - value.length; idx < len; idx++) {
        padding += padChar;
    }
    return padding + value;
};
exports.copyStringIntoBuffer = function (str, buffer, offset) {
    var length = str.length;
    for (var idx = 0; idx < length; idx++) {
        buffer[offset++] = str.charCodeAt(idx);
    }
    return length;
};
exports.addRandomSuffix = function (prefix, suffixLength) {
    if (suffixLength === void 0) { suffixLength = 4; }
    return prefix + "-" + Math.floor(Math.random() * Math.pow(10, suffixLength));
};
//# sourceMappingURL=strings.js.map