import * as tslib_1 from "tslib";
import PDFArray from "../objects/PDFArray";
import PDFDict from "../objects/PDFDict";
import PDFName from "../objects/PDFName";
import PDFStream from "../objects/PDFStream";
var PDFPageLeaf = /** @class */ (function (_super) {
    tslib_1.__extends(PDFPageLeaf, _super);
    function PDFPageLeaf(map, context, autoNormalizeCTM) {
        if (autoNormalizeCTM === void 0) { autoNormalizeCTM = true; }
        var _this = _super.call(this, map, context) || this;
        _this.normalized = false;
        _this.autoNormalizeCTM = autoNormalizeCTM;
        return _this;
    }
    PDFPageLeaf.prototype.clone = function (context) {
        var clone = PDFPageLeaf.fromMapWithContext(new Map(), context || this.context, this.autoNormalizeCTM);
        var entries = this.entries();
        for (var idx = 0, len = entries.length; idx < len; idx++) {
            var _a = entries[idx], key = _a[0], value = _a[1];
            clone.set(key, value);
        }
        return clone;
    };
    PDFPageLeaf.prototype.Parent = function () {
        return this.lookup(PDFName.of('Parent'));
    };
    PDFPageLeaf.prototype.Contents = function () {
        return this.lookup(PDFName.of('Contents'));
    };
    PDFPageLeaf.prototype.Annots = function () {
        return this.lookup(PDFName.of('Annots'));
    };
    PDFPageLeaf.prototype.BleedBox = function () {
        return this.lookup(PDFName.of('BleedBox'));
    };
    PDFPageLeaf.prototype.TrimBox = function () {
        return this.lookup(PDFName.of('TrimBox'));
    };
    PDFPageLeaf.prototype.Resources = function () {
        var dictOrRef = this.getInheritableAttribute(PDFName.of('Resources'));
        return this.context.lookup(dictOrRef, PDFDict);
    };
    PDFPageLeaf.prototype.MediaBox = function () {
        var arrayOrRef = this.getInheritableAttribute(PDFName.of('MediaBox'));
        return this.context.lookup(arrayOrRef, PDFArray);
    };
    PDFPageLeaf.prototype.CropBox = function () {
        var maybeArrayOrRef = this.getInheritableAttribute(PDFName.of('CropBox'));
        return this.context.lookup(maybeArrayOrRef);
    };
    PDFPageLeaf.prototype.Rotate = function () {
        var numberOrRef = this.getInheritableAttribute(PDFName.of('Rotate'));
        return this.context.lookup(numberOrRef);
    };
    PDFPageLeaf.prototype.getInheritableAttribute = function (name) {
        var attribute;
        this.ascend(function (node) {
            if (!attribute)
                attribute = node.get(name);
        });
        return attribute;
    };
    PDFPageLeaf.prototype.setParent = function (parentRef) {
        this.set(PDFName.of('Parent'), parentRef);
    };
    PDFPageLeaf.prototype.addContentStream = function (contentStreamRef) {
        this.normalize();
        var Contents = this.Contents();
        if (!Contents) {
            Contents = this.context.obj([]);
            this.set(PDFName.of('Contents'), Contents);
        }
        Contents.push(contentStreamRef);
    };
    PDFPageLeaf.prototype.wrapContentStreams = function (startStream, endStream) {
        var contents = this.lookup(PDFName.of('Contents'));
        if (contents instanceof PDFArray) {
            contents.insert(0, startStream);
            contents.push(endStream);
            return true;
        }
        return false;
    };
    PDFPageLeaf.prototype.setFontDictionary = function (name, fontDictRef) {
        this.normalize();
        var Font = this.Resources().lookup(PDFName.of('Font'), PDFDict);
        Font.set(name, fontDictRef);
    };
    PDFPageLeaf.prototype.setXObject = function (name, xObjectRef) {
        this.normalize();
        var XObject = this.Resources().lookup(PDFName.of('XObject'), PDFDict);
        XObject.set(name, xObjectRef);
    };
    PDFPageLeaf.prototype.ascend = function (visitor) {
        visitor(this);
        var Parent = this.Parent();
        if (Parent)
            Parent.ascend(visitor);
    };
    PDFPageLeaf.prototype.normalize = function () {
        if (this.normalized)
            return;
        var context = this.context;
        var contentsRef = this.get(PDFName.of('Contents'));
        var contents = this.context.lookup(contentsRef);
        if (contents instanceof PDFStream) {
            this.set(PDFName.of('Contents'), context.obj([contentsRef]));
        }
        if (this.autoNormalizeCTM) {
            this.wrapContentStreams(this.context.getPushGraphicsStateContentStream(), this.context.getPopGraphicsStateContentStream());
        }
        var Resources = this.get(PDFName.of('Resources'))
            ? this.Resources()
            : context.obj({});
        this.set(PDFName.of('Resources'), Resources);
        var Font = Resources.lookup(PDFName.of('Font')) || context.obj({});
        Resources.set(PDFName.of('Font'), Font);
        var XObject = Resources.lookup(PDFName.of('XObject')) || context.obj({});
        Resources.set(PDFName.of('XObject'), XObject);
        this.normalized = true;
    };
    PDFPageLeaf.InheritableEntries = [
        'Resources',
        'MediaBox',
        'CropBox',
        'Rotate',
    ];
    PDFPageLeaf.withContextAndParent = function (context, parent) {
        var dict = new Map();
        dict.set(PDFName.of('Type'), PDFName.of('Page'));
        dict.set(PDFName.of('Parent'), parent);
        dict.set(PDFName.of('Resources'), context.obj({}));
        dict.set(PDFName.of('MediaBox'), context.obj([0, 0, 612, 792]));
        return new PDFPageLeaf(dict, context, false);
    };
    PDFPageLeaf.fromMapWithContext = function (map, context, autoNormalizeCTM) {
        if (autoNormalizeCTM === void 0) { autoNormalizeCTM = true; }
        return new PDFPageLeaf(map, context, autoNormalizeCTM);
    };
    return PDFPageLeaf;
}(PDFDict));
export default PDFPageLeaf;
//# sourceMappingURL=PDFPageLeaf.js.map