export var toCharCode = function (character) { return character.charCodeAt(0); };
export var toCodePoint = function (character) { return character.codePointAt(0); };
export var toHexStringOfMinLength = function (num, minLength) {
    return padStart(num.toString(16), minLength, '0').toUpperCase();
};
export var toHexString = function (num) { return toHexStringOfMinLength(num, 2); };
export var charFromCode = function (code) { return String.fromCharCode(code); };
export var charFromHexCode = function (hex) { return charFromCode(parseInt(hex, 16)); };
export var padStart = function (value, length, padChar) {
    var padding = '';
    for (var idx = 0, len = length - value.length; idx < len; idx++) {
        padding += padChar;
    }
    return padding + value;
};
export var copyStringIntoBuffer = function (str, buffer, offset) {
    var length = str.length;
    for (var idx = 0; idx < length; idx++) {
        buffer[offset++] = str.charCodeAt(idx);
    }
    return length;
};
export var addRandomSuffix = function (prefix, suffixLength) {
    if (suffixLength === void 0) { suffixLength = 4; }
    return prefix + "-" + Math.floor(Math.random() * Math.pow(10, suffixLength));
};
//# sourceMappingURL=strings.js.map