/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!function webpackUniversalModuleDefinition(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf",[],t):"object"==typeof exports?exports["pdfjs-dist/build/pdf"]=t():e["pdfjs-dist/build/pdf"]=e.pdfjsLib=t()}(this,(function(){return(()=>{"use strict";var __webpack_modules__=[,(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.StatTimer=t.RenderingCancelledException=t.PixelsPerInch=t.PageViewport=t.PDFDateString=t.LinkTarget=t.DOMStandardFontDataFactory=t.DOMSVGFactory=t.DOMCanvasFactory=t.DOMCMapReaderFactory=void 0;t.addLinkAttributes=function addLinkAttributes(e,{url:t,target:i,rel:s,enabled:r=!0}={}){(0,n.assert)(t&&"string"==typeof t,'addLinkAttributes: A valid "url" parameter must provided.');const o=(0,n.removeNullCharacters)(t);if(r)e.href=e.title=o;else{e.href="";e.title=`Disabled: ${o}`;e.onclick=()=>!1}let l="";switch(i){case a.NONE:break;case a.SELF:l="_self";break;case a.BLANK:l="_blank";break;case a.PARENT:l="_parent";break;case a.TOP:l="_top"}e.target=l;e.rel="string"==typeof s?s:"noopener noreferrer nofollow"};t.deprecated=function deprecated(e){console.log("Deprecated API usage: "+e)};t.getFilenameFromUrl=function getFilenameFromUrl(e){const t=e.indexOf("#"),i=e.indexOf("?"),n=Math.min(t>0?t:e.length,i>0?i:e.length);return e.substring(e.lastIndexOf("/",n)+1,n)};t.getPdfFilenameFromUrl=function getPdfFilenameFromUrl(e,t="document.pdf"){if("string"!=typeof e)return t;if(isDataScheme(e)){(0,n.warn)('getPdfFilenameFromUrl: ignore "data:"-URL for performance reasons.');return t}const i=/[^/?#=]+\.pdf\b(?!.*\.pdf\b)/i,s=/^(?:(?:[^:]+:)?\/\/[^/]+)?([^?#]*)(\?[^#]*)?(#.*)?$/.exec(e);let r=i.exec(s[1])||i.exec(s[2])||i.exec(s[3]);if(r){r=r[0];if(r.includes("%"))try{r=i.exec(decodeURIComponent(r))[0]}catch(e){}}return r||t};t.getXfaPageViewport=function getXfaPageViewport(e,{scale:t=1,rotation:i=0}){const{width:n,height:s}=e.attributes.style,r=[0,0,parseInt(n),parseInt(s)];return new PageViewport({viewBox:r,scale:t,rotation:i})};t.isDataScheme=isDataScheme;t.isPdfFile=function isPdfFile(e){return"string"==typeof e&&/\.pdf$/i.test(e)};t.isValidFetchUrl=isValidFetchUrl;t.loadScript=function loadScript(e,t=!1){return new Promise(((i,n)=>{const s=document.createElement("script");s.src=e;s.onload=function(e){t&&s.remove();i(e)};s.onerror=function(){n(new Error(`Cannot load script at: ${s.src}`))};(document.head||document.documentElement).appendChild(s)}))};var n=i(2),s=i(5);const r={CSS:96,PDF:72,get PDF_TO_CSS_UNITS(){return(0,n.shadow)(this,"PDF_TO_CSS_UNITS",this.CSS/this.PDF)}};t.PixelsPerInch=r;class DOMCanvasFactory extends s.BaseCanvasFactory{constructor({ownerDocument:e=globalThis.document}={}){super();this._document=e}_createCanvas(e,t){const i=this._document.createElement("canvas");i.width=e;i.height=t;return i}}t.DOMCanvasFactory=DOMCanvasFactory;async function fetchData(e,t=!1){if(isValidFetchUrl(e,document.baseURI)){const i=await fetch(e);if(!i.ok)throw new Error(i.statusText);return t?new Uint8Array(await i.arrayBuffer()):(0,n.stringToBytes)(await i.text())}return new Promise(((i,s)=>{const r=new XMLHttpRequest;r.open("GET",e,!0);t&&(r.responseType="arraybuffer");r.onreadystatechange=()=>{if(r.readyState===XMLHttpRequest.DONE){if(200===r.status||0===r.status){let e;t&&r.response?e=new Uint8Array(r.response):!t&&r.responseText&&(e=(0,n.stringToBytes)(r.responseText));if(e){i(e);return}}s(new Error(r.statusText))}};r.send(null)}))}class DOMCMapReaderFactory extends s.BaseCMapReaderFactory{_fetchData(e,t){return fetchData(e,this.isCompressed).then((e=>({cMapData:e,compressionType:t})))}}t.DOMCMapReaderFactory=DOMCMapReaderFactory;class DOMStandardFontDataFactory extends s.BaseStandardFontDataFactory{_fetchData(e){return fetchData(e,!0)}}t.DOMStandardFontDataFactory=DOMStandardFontDataFactory;class DOMSVGFactory extends s.BaseSVGFactory{_createSVG(e){return document.createElementNS("http://www.w3.org/2000/svg",e)}}t.DOMSVGFactory=DOMSVGFactory;class PageViewport{constructor({viewBox:e,scale:t,rotation:i,offsetX:n=0,offsetY:s=0,dontFlip:r=!1}){this.viewBox=e;this.scale=t;this.rotation=i;this.offsetX=n;this.offsetY=s;const a=(e[2]+e[0])/2,o=(e[3]+e[1])/2;let l,c,h,d,u,p,g,f;(i%=360)<0&&(i+=360);switch(i){case 180:l=-1;c=0;h=0;d=1;break;case 90:l=0;c=1;h=1;d=0;break;case 270:l=0;c=-1;h=-1;d=0;break;case 0:l=1;c=0;h=0;d=-1;break;default:throw new Error("PageViewport: Invalid rotation, must be a multiple of 90 degrees.")}if(r){h=-h;d=-d}if(0===l){u=Math.abs(o-e[1])*t+n;p=Math.abs(a-e[0])*t+s;g=Math.abs(e[3]-e[1])*t;f=Math.abs(e[2]-e[0])*t}else{u=Math.abs(a-e[0])*t+n;p=Math.abs(o-e[1])*t+s;g=Math.abs(e[2]-e[0])*t;f=Math.abs(e[3]-e[1])*t}this.transform=[l*t,c*t,h*t,d*t,u-l*t*a-h*t*o,p-c*t*a-d*t*o];this.width=g;this.height=f}clone({scale:e=this.scale,rotation:t=this.rotation,offsetX:i=this.offsetX,offsetY:n=this.offsetY,dontFlip:s=!1}={}){return new PageViewport({viewBox:this.viewBox.slice(),scale:e,rotation:t,offsetX:i,offsetY:n,dontFlip:s})}convertToViewportPoint(e,t){return n.Util.applyTransform([e,t],this.transform)}convertToViewportRectangle(e){const t=n.Util.applyTransform([e[0],e[1]],this.transform),i=n.Util.applyTransform([e[2],e[3]],this.transform);return[t[0],t[1],i[0],i[1]]}convertToPdfPoint(e,t){return n.Util.applyInverseTransform([e,t],this.transform)}}t.PageViewport=PageViewport;class RenderingCancelledException extends n.BaseException{constructor(e,t){super(e,"RenderingCancelledException");this.type=t}}t.RenderingCancelledException=RenderingCancelledException;const a={NONE:0,SELF:1,BLANK:2,PARENT:3,TOP:4};t.LinkTarget=a;function isDataScheme(e){const t=e.length;let i=0;for(;i<t&&""===e[i].trim();)i++;return"data:"===e.substring(i,i+5).toLowerCase()}t.StatTimer=class StatTimer{constructor(){this.started=Object.create(null);this.times=[]}time(e){e in this.started&&(0,n.warn)(`Timer is already running for ${e}`);this.started[e]=Date.now()}timeEnd(e){e in this.started||(0,n.warn)(`Timer has not been started for ${e}`);this.times.push({name:e,start:this.started[e],end:Date.now()});delete this.started[e]}toString(){const e=[];let t=0;for(const e of this.times){const i=e.name;i.length>t&&(t=i.length)}for(const i of this.times){const n=i.end-i.start;e.push(`${i.name.padEnd(t)} ${n}ms\n`)}return e.join("")}};function isValidFetchUrl(e,t){try{const{protocol:i}=t?new URL(e,t):new URL(e);return"http:"===i||"https:"===i}catch(e){return!1}}let o;t.PDFDateString=class PDFDateString{static toDateObject(e){if(!e||!(0,n.isString)(e))return null;o||(o=new RegExp("^D:(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?([Z|+|-])?(\\d{2})?'?(\\d{2})?'?"));const t=o.exec(e);if(!t)return null;const i=parseInt(t[1],10);let s=parseInt(t[2],10);s=s>=1&&s<=12?s-1:0;let r=parseInt(t[3],10);r=r>=1&&r<=31?r:1;let a=parseInt(t[4],10);a=a>=0&&a<=23?a:0;let l=parseInt(t[5],10);l=l>=0&&l<=59?l:0;let c=parseInt(t[6],10);c=c>=0&&c<=59?c:0;const h=t[7]||"Z";let d=parseInt(t[8],10);d=d>=0&&d<=23?d:0;let u=parseInt(t[9],10)||0;u=u>=0&&u<=59?u:0;if("-"===h){a+=d;l+=u}else if("+"===h){a-=d;l-=u}return new Date(Date.UTC(i,s,r,a,l,c))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.VerbosityLevel=t.Util=t.UnknownErrorException=t.UnexpectedResponseException=t.UNSUPPORTED_FEATURES=t.TextRenderingMode=t.StreamType=t.RenderingIntentFlag=t.PermissionFlag=t.PasswordResponses=t.PasswordException=t.PageActionEventType=t.OPS=t.MissingPDFException=t.IsLittleEndianCached=t.IsEvalSupportedCached=t.InvalidPDFException=t.ImageKind=t.IDENTITY_MATRIX=t.FormatError=t.FontType=t.FONT_IDENTITY_MATRIX=t.DocumentActionEventType=t.CMapCompressionType=t.BaseException=t.AnnotationType=t.AnnotationStateModelType=t.AnnotationReviewState=t.AnnotationReplyType=t.AnnotationMode=t.AnnotationMarkedState=t.AnnotationFlag=t.AnnotationFieldFlag=t.AnnotationBorderStyleType=t.AnnotationActionEventType=t.AbortException=void 0;t.arrayByteLength=arrayByteLength;t.arraysToBytes=function arraysToBytes(e){const t=e.length;if(1===t&&e[0]instanceof Uint8Array)return e[0];let i=0;for(let n=0;n<t;n++)i+=arrayByteLength(e[n]);let n=0;const s=new Uint8Array(i);for(let i=0;i<t;i++){let t=e[i];t instanceof Uint8Array||(t="string"==typeof t?stringToBytes(t):new Uint8Array(t));const r=t.byteLength;s.set(t,n);n+=r}return s};t.assert=assert;t.bytesToString=function bytesToString(e){assert(null!==e&&"object"==typeof e&&void 0!==e.length,"Invalid argument for bytesToString");const t=e.length,i=8192;if(t<i)return String.fromCharCode.apply(null,e);const n=[];for(let s=0;s<t;s+=i){const r=Math.min(s+i,t),a=e.subarray(s,r);n.push(String.fromCharCode.apply(null,a))}return n.join("")};t.createObjectURL=function createObjectURL(e,t="",i=!1){if(URL.createObjectURL&&"undefined"!=typeof Blob&&!i)return URL.createObjectURL(new Blob([e],{type:t}));const n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";let s=`data:${t};base64,`;for(let t=0,i=e.length;t<i;t+=3){const r=255&e[t],a=255&e[t+1],o=255&e[t+2];s+=n[r>>2]+n[(3&r)<<4|a>>4]+n[t+1<i?(15&a)<<2|o>>6:64]+n[t+2<i?63&o:64]}return s};t.createPromiseCapability=function createPromiseCapability(){const e=Object.create(null);let t=!1;Object.defineProperty(e,"settled",{get:()=>t});e.promise=new Promise((function(i,n){e.resolve=function(e){t=!0;i(e)};e.reject=function(e){t=!0;n(e)}}));return e};t.createValidAbsoluteUrl=function createValidAbsoluteUrl(e,t=null,i=null){if(!e)return null;try{if(i&&"string"==typeof e){if(i.addDefaultProtocol&&e.startsWith("www.")){const t=e.match(/\./g);t&&t.length>=2&&(e=`http://${e}`)}if(i.tryConvertEncoding)try{e=stringToUTF8String(e)}catch(e){}}const n=t?new URL(e,t):new URL(e);if(function _isValidProtocol(e){if(!e)return!1;switch(e.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":return!0;default:return!1}}(n))return n}catch(e){}return null};t.escapeString=function escapeString(e){return e.replace(/([()\\\n\r])/g,(e=>"\n"===e?"\\n":"\r"===e?"\\r":`\\${e}`))};t.getModificationDate=function getModificationDate(e=new Date){return[e.getUTCFullYear().toString(),(e.getUTCMonth()+1).toString().padStart(2,"0"),e.getUTCDate().toString().padStart(2,"0"),e.getUTCHours().toString().padStart(2,"0"),e.getUTCMinutes().toString().padStart(2,"0"),e.getUTCSeconds().toString().padStart(2,"0")].join("")};t.getVerbosityLevel=function getVerbosityLevel(){return s};t.info=function info(e){s>=n.INFOS&&console.log(`Info: ${e}`)};t.isArrayBuffer=function isArrayBuffer(e){return"object"==typeof e&&null!==e&&void 0!==e.byteLength};t.isArrayEqual=function isArrayEqual(e,t){if(e.length!==t.length)return!1;for(let i=0,n=e.length;i<n;i++)if(e[i]!==t[i])return!1;return!0};t.isAscii=function isAscii(e){return/^[\x00-\x7F]*$/.test(e)};t.isBool=function isBool(e){return"boolean"==typeof e};t.isNum=function isNum(e){return"number"==typeof e};t.isSameOrigin=function isSameOrigin(e,t){let i;try{i=new URL(e);if(!i.origin||"null"===i.origin)return!1}catch(e){return!1}const n=new URL(t,i);return i.origin===n.origin};t.isString=function isString(e){return"string"==typeof e};t.objectFromMap=function objectFromMap(e){const t=Object.create(null);for(const[i,n]of e)t[i]=n;return t};t.objectSize=function objectSize(e){return Object.keys(e).length};t.removeNullCharacters=function removeNullCharacters(e,t=!1){if("string"!=typeof e){warn("The argument for removeNullCharacters must be a string.");return e}t&&(e=e.replace(o," "));return e.replace(a,"")};t.setVerbosityLevel=function setVerbosityLevel(e){Number.isInteger(e)&&(s=e)};t.shadow=shadow;t.string32=function string32(e){return String.fromCharCode(e>>24&255,e>>16&255,e>>8&255,255&e)};t.stringToBytes=stringToBytes;t.stringToPDFString=function stringToPDFString(e){const t=e.length,i=[];if("þ"===e[0]&&"ÿ"===e[1])for(let n=2;n<t;n+=2)i.push(String.fromCharCode(e.charCodeAt(n)<<8|e.charCodeAt(n+1)));else if("ÿ"===e[0]&&"þ"===e[1])for(let n=2;n<t;n+=2)i.push(String.fromCharCode(e.charCodeAt(n+1)<<8|e.charCodeAt(n)));else for(let n=0;n<t;++n){const t=d[e.charCodeAt(n)];i.push(t?String.fromCharCode(t):e.charAt(n))}return i.join("")};t.stringToUTF16BEString=function stringToUTF16BEString(e){const t=["þÿ"];for(let i=0,n=e.length;i<n;i++){const n=e.charCodeAt(i);t.push(String.fromCharCode(n>>8&255),String.fromCharCode(255&n))}return t.join("")};t.stringToUTF8String=stringToUTF8String;t.unreachable=unreachable;t.utf8StringToString=function utf8StringToString(e){return unescape(encodeURIComponent(e))};t.warn=warn;i(3);t.IDENTITY_MATRIX=[1,0,0,1,0,0];t.FONT_IDENTITY_MATRIX=[.001,0,0,.001,0,0];t.RenderingIntentFlag={ANY:1,DISPLAY:2,PRINT:4,ANNOTATIONS_FORMS:16,ANNOTATIONS_STORAGE:32,ANNOTATIONS_DISABLE:64,OPLIST:256};t.AnnotationMode={DISABLE:0,ENABLE:1,ENABLE_FORMS:2,ENABLE_STORAGE:3};t.PermissionFlag={PRINT:4,MODIFY_CONTENTS:8,COPY:16,MODIFY_ANNOTATIONS:32,FILL_INTERACTIVE_FORMS:256,COPY_FOR_ACCESSIBILITY:512,ASSEMBLE:1024,PRINT_HIGH_QUALITY:2048};t.TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};t.ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};t.AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};t.AnnotationStateModelType={MARKED:"Marked",REVIEW:"Review"};t.AnnotationMarkedState={MARKED:"Marked",UNMARKED:"Unmarked"};t.AnnotationReviewState={ACCEPTED:"Accepted",REJECTED:"Rejected",CANCELLED:"Cancelled",COMPLETED:"Completed",NONE:"None"};t.AnnotationReplyType={GROUP:"Group",REPLY:"R"};t.AnnotationFlag={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512};t.AnnotationFieldFlag={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864};t.AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};t.AnnotationActionEventType={E:"Mouse Enter",X:"Mouse Exit",D:"Mouse Down",U:"Mouse Up",Fo:"Focus",Bl:"Blur",PO:"PageOpen",PC:"PageClose",PV:"PageVisible",PI:"PageInvisible",K:"Keystroke",F:"Format",V:"Validate",C:"Calculate"};t.DocumentActionEventType={WC:"WillClose",WS:"WillSave",DS:"DidSave",WP:"WillPrint",DP:"DidPrint"};t.PageActionEventType={O:"PageOpen",C:"PageClose"};t.StreamType={UNKNOWN:"UNKNOWN",FLATE:"FLATE",LZW:"LZW",DCT:"DCT",JPX:"JPX",JBIG:"JBIG",A85:"A85",AHX:"AHX",CCF:"CCF",RLX:"RLX"};t.FontType={UNKNOWN:"UNKNOWN",TYPE1:"TYPE1",TYPE1STANDARD:"TYPE1STANDARD",TYPE1C:"TYPE1C",CIDFONTTYPE0:"CIDFONTTYPE0",CIDFONTTYPE0C:"CIDFONTTYPE0C",TRUETYPE:"TRUETYPE",CIDFONTTYPE2:"CIDFONTTYPE2",TYPE3:"TYPE3",OPENTYPE:"OPENTYPE",TYPE0:"TYPE0",MMTYPE1:"MMTYPE1"};const n={ERRORS:0,WARNINGS:1,INFOS:5};t.VerbosityLevel=n;t.CMapCompressionType={NONE:0,BINARY:1,STREAM:2};t.OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};t.UNSUPPORTED_FEATURES={unknown:"unknown",forms:"forms",javaScript:"javaScript",signatures:"signatures",smask:"smask",shadingPattern:"shadingPattern",font:"font",errorTilingPattern:"errorTilingPattern",errorExtGState:"errorExtGState",errorXObject:"errorXObject",errorFontLoadType3:"errorFontLoadType3",errorFontState:"errorFontState",errorFontMissing:"errorFontMissing",errorFontTranslate:"errorFontTranslate",errorColorSpace:"errorColorSpace",errorOperatorList:"errorOperatorList",errorFontToUnicode:"errorFontToUnicode",errorFontLoadNative:"errorFontLoadNative",errorFontBuildPath:"errorFontBuildPath",errorFontGetPath:"errorFontGetPath",errorMarkedContent:"errorMarkedContent",errorContentSubStream:"errorContentSubStream"};t.PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};let s=n.WARNINGS;function warn(e){s>=n.WARNINGS&&console.log(`Warning: ${e}`)}function unreachable(e){throw new Error(e)}function assert(e,t){e||unreachable(t)}function shadow(e,t,i){Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!1});return i}const r=function BaseExceptionClosure(){function BaseException(e,t){this.constructor===BaseException&&unreachable("Cannot initialize BaseException.");this.message=e;this.name=t}BaseException.prototype=new Error;BaseException.constructor=BaseException;return BaseException}();t.BaseException=r;t.PasswordException=class PasswordException extends r{constructor(e,t){super(e,"PasswordException");this.code=t}};t.UnknownErrorException=class UnknownErrorException extends r{constructor(e,t){super(e,"UnknownErrorException");this.details=t}};t.InvalidPDFException=class InvalidPDFException extends r{constructor(e){super(e,"InvalidPDFException")}};t.MissingPDFException=class MissingPDFException extends r{constructor(e){super(e,"MissingPDFException")}};t.UnexpectedResponseException=class UnexpectedResponseException extends r{constructor(e,t){super(e,"UnexpectedResponseException");this.status=t}};t.FormatError=class FormatError extends r{constructor(e){super(e,"FormatError")}};t.AbortException=class AbortException extends r{constructor(e){super(e,"AbortException")}};const a=/\x00+/g,o=/[\x01-\x1F]/g;function stringToBytes(e){assert("string"==typeof e,"Invalid argument for stringToBytes");const t=e.length,i=new Uint8Array(t);for(let n=0;n<t;++n)i[n]=255&e.charCodeAt(n);return i}function arrayByteLength(e){if(void 0!==e.length)return e.length;assert(void 0!==e.byteLength,"arrayByteLength - invalid argument.");return e.byteLength}const l={get value(){return shadow(this,"value",function isLittleEndian(){const e=new Uint8Array(4);e[0]=1;return 1===new Uint32Array(e.buffer,0,1)[0]}())}};t.IsLittleEndianCached=l;const c={get value(){return shadow(this,"value",function isEvalSupported(){try{new Function("");return!0}catch(e){return!1}}())}};t.IsEvalSupportedCached=c;const h=[...Array(256).keys()].map((e=>e.toString(16).padStart(2,"0")));class Util{static makeHexColor(e,t,i){return`#${h[e]}${h[t]}${h[i]}`}static transform(e,t){return[e[0]*t[0]+e[2]*t[1],e[1]*t[0]+e[3]*t[1],e[0]*t[2]+e[2]*t[3],e[1]*t[2]+e[3]*t[3],e[0]*t[4]+e[2]*t[5]+e[4],e[1]*t[4]+e[3]*t[5]+e[5]]}static applyTransform(e,t){return[e[0]*t[0]+e[1]*t[2]+t[4],e[0]*t[1]+e[1]*t[3]+t[5]]}static applyInverseTransform(e,t){const i=t[0]*t[3]-t[1]*t[2];return[(e[0]*t[3]-e[1]*t[2]+t[2]*t[5]-t[4]*t[3])/i,(-e[0]*t[1]+e[1]*t[0]+t[4]*t[1]-t[5]*t[0])/i]}static getAxialAlignedBoundingBox(e,t){const i=Util.applyTransform(e,t),n=Util.applyTransform(e.slice(2,4),t),s=Util.applyTransform([e[0],e[3]],t),r=Util.applyTransform([e[2],e[1]],t);return[Math.min(i[0],n[0],s[0],r[0]),Math.min(i[1],n[1],s[1],r[1]),Math.max(i[0],n[0],s[0],r[0]),Math.max(i[1],n[1],s[1],r[1])]}static inverseTransform(e){const t=e[0]*e[3]-e[1]*e[2];return[e[3]/t,-e[1]/t,-e[2]/t,e[0]/t,(e[2]*e[5]-e[4]*e[3])/t,(e[4]*e[1]-e[5]*e[0])/t]}static apply3dTransform(e,t){return[e[0]*t[0]+e[1]*t[1]+e[2]*t[2],e[3]*t[0]+e[4]*t[1]+e[5]*t[2],e[6]*t[0]+e[7]*t[1]+e[8]*t[2]]}static singularValueDecompose2dScale(e){const t=[e[0],e[2],e[1],e[3]],i=e[0]*t[0]+e[1]*t[2],n=e[0]*t[1]+e[1]*t[3],s=e[2]*t[0]+e[3]*t[2],r=e[2]*t[1]+e[3]*t[3],a=(i+r)/2,o=Math.sqrt((i+r)**2-4*(i*r-s*n))/2,l=a+o||1,c=a-o||1;return[Math.sqrt(l),Math.sqrt(c)]}static normalizeRect(e){const t=e.slice(0);if(e[0]>e[2]){t[0]=e[2];t[2]=e[0]}if(e[1]>e[3]){t[1]=e[3];t[3]=e[1]}return t}static intersect(e,t){function compare(e,t){return e-t}const i=[e[0],e[2],t[0],t[2]].sort(compare),n=[e[1],e[3],t[1],t[3]].sort(compare),s=[];e=Util.normalizeRect(e);t=Util.normalizeRect(t);if(!(i[0]===e[0]&&i[1]===t[0]||i[0]===t[0]&&i[1]===e[0]))return null;s[0]=i[1];s[2]=i[2];if(!(n[0]===e[1]&&n[1]===t[1]||n[0]===t[1]&&n[1]===e[1]))return null;s[1]=n[1];s[3]=n[2];return s}static bezierBoundingBox(e,t,i,n,s,r,a,o){const l=[],c=[[],[]];let h,d,u,p,g,f,m,_;for(let c=0;c<2;++c){if(0===c){d=6*e-12*i+6*s;h=-3*e+9*i-9*s+3*a;u=3*i-3*e}else{d=6*t-12*n+6*r;h=-3*t+9*n-9*r+3*o;u=3*n-3*t}if(Math.abs(h)<1e-12){if(Math.abs(d)<1e-12)continue;p=-u/d;0<p&&p<1&&l.push(p)}else{m=d*d-4*u*h;_=Math.sqrt(m);if(!(m<0)){g=(-d+_)/(2*h);0<g&&g<1&&l.push(g);f=(-d-_)/(2*h);0<f&&f<1&&l.push(f)}}}let b,v=l.length;const w=v;for(;v--;){p=l[v];b=1-p;c[0][v]=b*b*b*e+3*b*b*p*i+3*b*p*p*s+p*p*p*a;c[1][v]=b*b*b*t+3*b*b*p*n+3*b*p*p*r+p*p*p*o}c[0][w]=e;c[1][w]=t;c[0][w+1]=a;c[1][w+1]=o;c[0].length=c[1].length=w+2;return[Math.min(...c[0]),Math.min(...c[1]),Math.max(...c[0]),Math.max(...c[1])]}}t.Util=Util;const d=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364];function stringToUTF8String(e){return decodeURIComponent(escape(e))}},(e,t,i)=>{i(4)},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.isNodeJS=void 0;const i=!("object"!=typeof process||process+""!="[object process]"||process.versions.nw||process.versions.electron&&process.type&&"browser"!==process.type);t.isNodeJS=i},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BaseStandardFontDataFactory=t.BaseSVGFactory=t.BaseCanvasFactory=t.BaseCMapReaderFactory=void 0;var n=i(2);class BaseCanvasFactory{constructor(){this.constructor===BaseCanvasFactory&&(0,n.unreachable)("Cannot initialize BaseCanvasFactory.")}create(e,t){if(e<=0||t<=0)throw new Error("Invalid canvas size");const i=this._createCanvas(e,t);return{canvas:i,context:i.getContext("2d")}}reset(e,t,i){if(!e.canvas)throw new Error("Canvas is not specified");if(t<=0||i<=0)throw new Error("Invalid canvas size");e.canvas.width=t;e.canvas.height=i}destroy(e){if(!e.canvas)throw new Error("Canvas is not specified");e.canvas.width=0;e.canvas.height=0;e.canvas=null;e.context=null}_createCanvas(e,t){(0,n.unreachable)("Abstract method `_createCanvas` called.")}}t.BaseCanvasFactory=BaseCanvasFactory;class BaseCMapReaderFactory{constructor({baseUrl:e=null,isCompressed:t=!1}){this.constructor===BaseCMapReaderFactory&&(0,n.unreachable)("Cannot initialize BaseCMapReaderFactory.");this.baseUrl=e;this.isCompressed=t}async fetch({name:e}){if(!this.baseUrl)throw new Error('The CMap "baseUrl" parameter must be specified, ensure that the "cMapUrl" and "cMapPacked" API parameters are provided.');if(!e)throw new Error("CMap name must be specified.");const t=this.baseUrl+e+(this.isCompressed?".bcmap":""),i=this.isCompressed?n.CMapCompressionType.BINARY:n.CMapCompressionType.NONE;return this._fetchData(t,i).catch((e=>{throw new Error(`Unable to load ${this.isCompressed?"binary ":""}CMap at: ${t}`)}))}_fetchData(e,t){(0,n.unreachable)("Abstract method `_fetchData` called.")}}t.BaseCMapReaderFactory=BaseCMapReaderFactory;class BaseStandardFontDataFactory{constructor({baseUrl:e=null}){this.constructor===BaseStandardFontDataFactory&&(0,n.unreachable)("Cannot initialize BaseStandardFontDataFactory.");this.baseUrl=e}async fetch({filename:e}){if(!this.baseUrl)throw new Error('The standard font "baseUrl" parameter must be specified, ensure that the "standardFontDataUrl" API parameter is provided.');if(!e)throw new Error("Font filename must be specified.");const t=`${this.baseUrl}${e}`;return this._fetchData(t).catch((e=>{throw new Error(`Unable to load font data at: ${t}`)}))}_fetchData(e){(0,n.unreachable)("Abstract method `_fetchData` called.")}}t.BaseStandardFontDataFactory=BaseStandardFontDataFactory;class BaseSVGFactory{constructor(){this.constructor===BaseSVGFactory&&(0,n.unreachable)("Cannot initialize BaseSVGFactory.")}create(e,t){if(e<=0||t<=0)throw new Error("Invalid SVG dimensions");const i=this._createSVG("svg:svg");i.setAttribute("version","1.1");i.setAttribute("width",`${e}px`);i.setAttribute("height",`${t}px`);i.setAttribute("preserveAspectRatio","none");i.setAttribute("viewBox",`0 0 ${e} ${t}`);return i}createElement(e){if("string"!=typeof e)throw new Error("Invalid SVG element type");return this._createSVG(e)}_createSVG(e){(0,n.unreachable)("Abstract method `_createSVG` called.")}}t.BaseSVGFactory=BaseSVGFactory},(__unused_webpack_module,exports,__w_pdfjs_require__)=>{Object.defineProperty(exports,"__esModule",{value:!0});exports.build=exports.RenderTask=exports.PDFWorker=exports.PDFPageProxy=exports.PDFDocumentProxy=exports.PDFDocumentLoadingTask=exports.PDFDataRangeTransport=exports.LoopbackPort=exports.DefaultStandardFontDataFactory=exports.DefaultCanvasFactory=exports.DefaultCMapReaderFactory=void 0;exports.getDocument=getDocument;exports.setPDFNetworkStreamFactory=setPDFNetworkStreamFactory;exports.version=void 0;var _util=__w_pdfjs_require__(2),_display_utils=__w_pdfjs_require__(1),_font_loader=__w_pdfjs_require__(7),_node_utils=__w_pdfjs_require__(8),_annotation_storage=__w_pdfjs_require__(9),_canvas=__w_pdfjs_require__(10),_worker_options=__w_pdfjs_require__(12),_is_node=__w_pdfjs_require__(4),_message_handler=__w_pdfjs_require__(13),_metadata=__w_pdfjs_require__(14),_optional_content_config=__w_pdfjs_require__(15),_transport_stream=__w_pdfjs_require__(16),_xfa_text=__w_pdfjs_require__(17);const DEFAULT_RANGE_CHUNK_SIZE=65536,RENDERING_CANCELLED_TIMEOUT=100,DefaultCanvasFactory=_is_node.isNodeJS?_node_utils.NodeCanvasFactory:_display_utils.DOMCanvasFactory;exports.DefaultCanvasFactory=DefaultCanvasFactory;const DefaultCMapReaderFactory=_is_node.isNodeJS?_node_utils.NodeCMapReaderFactory:_display_utils.DOMCMapReaderFactory;exports.DefaultCMapReaderFactory=DefaultCMapReaderFactory;const DefaultStandardFontDataFactory=_is_node.isNodeJS?_node_utils.NodeStandardFontDataFactory:_display_utils.DOMStandardFontDataFactory;exports.DefaultStandardFontDataFactory=DefaultStandardFontDataFactory;let createPDFNetworkStream;function setPDFNetworkStreamFactory(e){createPDFNetworkStream=e}function getDocument(e){const t=new PDFDocumentLoadingTask;let i;if("string"==typeof e||e instanceof URL)i={url:e};else if((0,_util.isArrayBuffer)(e))i={data:e};else if(e instanceof PDFDataRangeTransport)i={range:e};else{if("object"!=typeof e)throw new Error("Invalid parameter in getDocument, need either string, URL, Uint8Array, or parameter object.");if(!e.url&&!e.data&&!e.range)throw new Error("Invalid parameter object: need either .data, .range or .url");i=e}const n=Object.create(null);let s=null,r=null;for(const e in i){const t=i[e];switch(e){case"url":if("undefined"!=typeof window)try{n[e]=new URL(t,window.location).href;continue}catch(e){(0,_util.warn)(`Cannot create valid URL: "${e}".`)}else if("string"==typeof t||t instanceof URL){n[e]=t.toString();continue}throw new Error("Invalid PDF url data: either string or URL-object is expected in the url property.");case"range":s=t;continue;case"worker":r=t;continue;case"data":if(_is_node.isNodeJS&&"undefined"!=typeof Buffer&&t instanceof Buffer)n[e]=new Uint8Array(t);else{if(t instanceof Uint8Array)break;if("string"==typeof t)n[e]=(0,_util.stringToBytes)(t);else if("object"!=typeof t||null===t||isNaN(t.length)){if(!(0,_util.isArrayBuffer)(t))throw new Error("Invalid PDF binary data: either typed array, string, or array-like object is expected in the data property.");n[e]=new Uint8Array(t)}else n[e]=new Uint8Array(t)}continue}n[e]=t}n.rangeChunkSize=n.rangeChunkSize||DEFAULT_RANGE_CHUNK_SIZE;n.CMapReaderFactory=n.CMapReaderFactory||DefaultCMapReaderFactory;n.StandardFontDataFactory=n.StandardFontDataFactory||DefaultStandardFontDataFactory;n.ignoreErrors=!0!==n.stopAtErrors;n.fontExtraProperties=!0===n.fontExtraProperties;n.pdfBug=!0===n.pdfBug;n.enableXfa=!0===n.enableXfa;("string"!=typeof n.docBaseUrl||(0,_display_utils.isDataScheme)(n.docBaseUrl))&&(n.docBaseUrl=null);Number.isInteger(n.maxImageSize)||(n.maxImageSize=-1);"boolean"!=typeof n.useWorkerFetch&&(n.useWorkerFetch=n.CMapReaderFactory===_display_utils.DOMCMapReaderFactory&&n.StandardFontDataFactory===_display_utils.DOMStandardFontDataFactory);"boolean"!=typeof n.isEvalSupported&&(n.isEvalSupported=!0);"boolean"!=typeof n.disableFontFace&&(n.disableFontFace=_is_node.isNodeJS);"boolean"!=typeof n.useSystemFonts&&(n.useSystemFonts=!_is_node.isNodeJS&&!n.disableFontFace);void 0===n.ownerDocument&&(n.ownerDocument=globalThis.document);"boolean"!=typeof n.disableRange&&(n.disableRange=!1);"boolean"!=typeof n.disableStream&&(n.disableStream=!1);"boolean"!=typeof n.disableAutoFetch&&(n.disableAutoFetch=!1);(0,_util.setVerbosityLevel)(n.verbosity);if(!r){const e={verbosity:n.verbosity,port:_worker_options.GlobalWorkerOptions.workerPort};r=e.port?PDFWorker.fromPort(e):new PDFWorker(e);t._worker=r}const a=t.docId;r.promise.then((function(){if(t.destroyed)throw new Error("Loading aborted");const e=_fetchDocument(r,n,s,a),i=new Promise((function(e){let t;s?t=new _transport_stream.PDFDataTransportStream({length:n.length,initialData:n.initialData,progressiveDone:n.progressiveDone,contentDispositionFilename:n.contentDispositionFilename,disableRange:n.disableRange,disableStream:n.disableStream},s):n.data||(t=createPDFNetworkStream({url:n.url,length:n.length,httpHeaders:n.httpHeaders,withCredentials:n.withCredentials,rangeChunkSize:n.rangeChunkSize,disableRange:n.disableRange,disableStream:n.disableStream}));e(t)}));return Promise.all([e,i]).then((function([e,i]){if(t.destroyed)throw new Error("Loading aborted");const s=new _message_handler.MessageHandler(a,e,r.port),o=new WorkerTransport(s,t,i,n);t._transport=o;s.send("Ready",null)}))})).catch(t._capability.reject);return t}async function _fetchDocument(e,t,i,n){if(e.destroyed)throw new Error("Worker was destroyed");if(i){t.length=i.length;t.initialData=i.initialData;t.progressiveDone=i.progressiveDone;t.contentDispositionFilename=i.contentDispositionFilename}const s=await e.messageHandler.sendWithPromise("GetDocRequest",{docId:n,apiVersion:"2.12.313",source:{data:t.data,url:t.url,password:t.password,disableAutoFetch:t.disableAutoFetch,rangeChunkSize:t.rangeChunkSize,length:t.length},maxImageSize:t.maxImageSize,disableFontFace:t.disableFontFace,docBaseUrl:t.docBaseUrl,ignoreErrors:t.ignoreErrors,isEvalSupported:t.isEvalSupported,fontExtraProperties:t.fontExtraProperties,enableXfa:t.enableXfa,useSystemFonts:t.useSystemFonts,cMapUrl:t.useWorkerFetch?t.cMapUrl:null,standardFontDataUrl:t.useWorkerFetch?t.standardFontDataUrl:null});if(e.destroyed)throw new Error("Worker was destroyed");return s}class PDFDocumentLoadingTask{static get idCounters(){return(0,_util.shadow)(this,"idCounters",{doc:0})}constructor(){this._capability=(0,_util.createPromiseCapability)();this._transport=null;this._worker=null;this.docId="d"+PDFDocumentLoadingTask.idCounters.doc++;this.destroyed=!1;this.onPassword=null;this.onProgress=null;this.onUnsupportedFeature=null}get promise(){return this._capability.promise}async destroy(){this.destroyed=!0;await(this._transport?.destroy());this._transport=null;if(this._worker){this._worker.destroy();this._worker=null}}}exports.PDFDocumentLoadingTask=PDFDocumentLoadingTask;class PDFDataRangeTransport{constructor(e,t,i=!1,n=null){this.length=e;this.initialData=t;this.progressiveDone=i;this.contentDispositionFilename=n;this._rangeListeners=[];this._progressListeners=[];this._progressiveReadListeners=[];this._progressiveDoneListeners=[];this._readyCapability=(0,_util.createPromiseCapability)()}addRangeListener(e){this._rangeListeners.push(e)}addProgressListener(e){this._progressListeners.push(e)}addProgressiveReadListener(e){this._progressiveReadListeners.push(e)}addProgressiveDoneListener(e){this._progressiveDoneListeners.push(e)}onDataRange(e,t){for(const i of this._rangeListeners)i(e,t)}onDataProgress(e,t){this._readyCapability.promise.then((()=>{for(const i of this._progressListeners)i(e,t)}))}onDataProgressiveRead(e){this._readyCapability.promise.then((()=>{for(const t of this._progressiveReadListeners)t(e)}))}onDataProgressiveDone(){this._readyCapability.promise.then((()=>{for(const e of this._progressiveDoneListeners)e()}))}transportReady(){this._readyCapability.resolve()}requestDataRange(e,t){(0,_util.unreachable)("Abstract method PDFDataRangeTransport.requestDataRange")}abort(){}}exports.PDFDataRangeTransport=PDFDataRangeTransport;class PDFDocumentProxy{constructor(e,t){this._pdfInfo=e;this._transport=t;Object.defineProperty(this,"fingerprint",{get(){(0,_display_utils.deprecated)("`PDFDocumentProxy.fingerprint`, please use `PDFDocumentProxy.fingerprints` instead.");return this.fingerprints[0]}});Object.defineProperty(this,"getStats",{value:async()=>{(0,_display_utils.deprecated)("`PDFDocumentProxy.getStats`, please use the `PDFDocumentProxy.stats`-getter instead.");return this.stats||{streamTypes:{},fontTypes:{}}}})}get annotationStorage(){return this._transport.annotationStorage}get numPages(){return this._pdfInfo.numPages}get fingerprints(){return this._pdfInfo.fingerprints}get stats(){return this._transport.stats}get isPureXfa(){return!!this._transport._htmlForXfa}get allXfaHtml(){return this._transport._htmlForXfa}getPage(e){return this._transport.getPage(e)}getPageIndex(e){return this._transport.getPageIndex(e)}getDestinations(){return this._transport.getDestinations()}getDestination(e){return this._transport.getDestination(e)}getPageLabels(){return this._transport.getPageLabels()}getPageLayout(){return this._transport.getPageLayout()}getPageMode(){return this._transport.getPageMode()}getViewerPreferences(){return this._transport.getViewerPreferences()}getOpenAction(){return this._transport.getOpenAction()}getAttachments(){return this._transport.getAttachments()}getJavaScript(){return this._transport.getJavaScript()}getJSActions(){return this._transport.getDocJSActions()}getOutline(){return this._transport.getOutline()}getOptionalContentConfig(){return this._transport.getOptionalContentConfig()}getPermissions(){return this._transport.getPermissions()}getMetadata(){return this._transport.getMetadata()}getMarkInfo(){return this._transport.getMarkInfo()}getData(){return this._transport.getData()}getDownloadInfo(){return this._transport.downloadInfoCapability.promise}cleanup(e=!1){return this._transport.startCleanup(e||this.isPureXfa)}destroy(){return this.loadingTask.destroy()}get loadingParams(){return this._transport.loadingParams}get loadingTask(){return this._transport.loadingTask}saveDocument(){this._transport.annotationStorage.size<=0&&(0,_display_utils.deprecated)("saveDocument called while `annotationStorage` is empty, please use the getData-method instead.");return this._transport.saveDocument()}getFieldObjects(){return this._transport.getFieldObjects()}hasJSActions(){return this._transport.hasJSActions()}getCalculationOrderIds(){return this._transport.getCalculationOrderIds()}}exports.PDFDocumentProxy=PDFDocumentProxy;class PDFPageProxy{constructor(e,t,i,n,s=!1){this._pageIndex=e;this._pageInfo=t;this._ownerDocument=n;this._transport=i;this._stats=s?new _display_utils.StatTimer:null;this._pdfBug=s;this.commonObjs=i.commonObjs;this.objs=new PDFObjects;this.cleanupAfterRender=!1;this.pendingCleanup=!1;this._intentStates=new Map;this._annotationPromises=new Map;this.destroyed=!1}get pageNumber(){return this._pageIndex+1}get rotate(){return this._pageInfo.rotate}get ref(){return this._pageInfo.ref}get userUnit(){return this._pageInfo.userUnit}get view(){return this._pageInfo.view}getViewport({scale:e,rotation:t=this.rotate,offsetX:i=0,offsetY:n=0,dontFlip:s=!1}={}){return new _display_utils.PageViewport({viewBox:this.view,scale:e,rotation:t,offsetX:i,offsetY:n,dontFlip:s})}getAnnotations({intent:e="display"}={}){const t=this._transport.getRenderingIntent(e);let i=this._annotationPromises.get(t.cacheKey);if(!i){i=this._transport.getAnnotations(this._pageIndex,t.renderingIntent);this._annotationPromises.set(t.cacheKey,i);i=i.then((e=>{for(const t of e){void 0!==t.titleObj&&Object.defineProperty(t,"title",{get(){(0,_display_utils.deprecated)("`title`-property on annotation, please use `titleObj` instead.");return t.titleObj.str}});void 0!==t.contentsObj&&Object.defineProperty(t,"contents",{get(){(0,_display_utils.deprecated)("`contents`-property on annotation, please use `contentsObj` instead.");return t.contentsObj.str}})}return e}))}return i}getJSActions(){return this._jsActionsPromise||=this._transport.getPageJSActions(this._pageIndex)}async getXfa(){return this._transport._htmlForXfa?.children[this._pageIndex]||null}render({canvasContext:e,viewport:t,intent:i="display",annotationMode:n=_util.AnnotationMode.ENABLE,transform:s=null,imageLayer:r=null,canvasFactory:a=null,background:o=null,optionalContentConfigPromise:l=null,annotationCanvasMap:c=null}){if(void 0!==arguments[0]?.renderInteractiveForms){(0,_display_utils.deprecated)("render no longer accepts the `renderInteractiveForms`-option, please use the `annotationMode`-option instead.");!0===arguments[0].renderInteractiveForms&&n===_util.AnnotationMode.ENABLE&&(n=_util.AnnotationMode.ENABLE_FORMS)}if(void 0!==arguments[0]?.includeAnnotationStorage){(0,_display_utils.deprecated)("render no longer accepts the `includeAnnotationStorage`-option, please use the `annotationMode`-option instead.");!0===arguments[0].includeAnnotationStorage&&n===_util.AnnotationMode.ENABLE&&(n=_util.AnnotationMode.ENABLE_STORAGE)}this._stats&&this._stats.time("Overall");const h=this._transport.getRenderingIntent(i,n);this.pendingCleanup=!1;l||(l=this._transport.getOptionalContentConfig());let d=this._intentStates.get(h.cacheKey);if(!d){d=Object.create(null);this._intentStates.set(h.cacheKey,d)}if(d.streamReaderCancelTimeout){clearTimeout(d.streamReaderCancelTimeout);d.streamReaderCancelTimeout=null}const u=a||new DefaultCanvasFactory({ownerDocument:this._ownerDocument}),p=!!(h.renderingIntent&_util.RenderingIntentFlag.PRINT);if(!d.displayReadyCapability){d.displayReadyCapability=(0,_util.createPromiseCapability)();d.operatorList={fnArray:[],argsArray:[],lastChunk:!1};this._stats&&this._stats.time("Page Request");this._pumpOperatorList(h)}const complete=e=>{d.renderTasks.delete(g);(this.cleanupAfterRender||p)&&(this.pendingCleanup=!0);this._tryCleanup();if(e){g.capability.reject(e);this._abortOperatorList({intentState:d,reason:e instanceof Error?e:new Error(e)})}else g.capability.resolve();if(this._stats){this._stats.timeEnd("Rendering");this._stats.timeEnd("Overall")}},g=new InternalRenderTask({callback:complete,params:{canvasContext:e,viewport:t,transform:s,imageLayer:r,background:o},objs:this.objs,commonObjs:this.commonObjs,annotationCanvasMap:c,operatorList:d.operatorList,pageIndex:this._pageIndex,canvasFactory:u,useRequestAnimationFrame:!p,pdfBug:this._pdfBug});(d.renderTasks||=new Set).add(g);const f=g.task;Promise.all([d.displayReadyCapability.promise,l]).then((([e,t])=>{if(this.pendingCleanup)complete();else{this._stats&&this._stats.time("Rendering");g.initializeGraphics({transparency:e,optionalContentConfig:t});g.operatorListChanged()}})).catch(complete);return f}getOperatorList({intent:e="display",annotationMode:t=_util.AnnotationMode.ENABLE}={}){const i=this._transport.getRenderingIntent(e,t,!0);let n,s=this._intentStates.get(i.cacheKey);if(!s){s=Object.create(null);this._intentStates.set(i.cacheKey,s)}if(!s.opListReadCapability){n=Object.create(null);n.operatorListChanged=function operatorListChanged(){if(s.operatorList.lastChunk){s.opListReadCapability.resolve(s.operatorList);s.renderTasks.delete(n)}};s.opListReadCapability=(0,_util.createPromiseCapability)();(s.renderTasks||=new Set).add(n);s.operatorList={fnArray:[],argsArray:[],lastChunk:!1};this._stats&&this._stats.time("Page Request");this._pumpOperatorList(i)}return s.opListReadCapability.promise}streamTextContent({normalizeWhitespace:e=!1,disableCombineTextItems:t=!1,includeMarkedContent:i=!1}={}){return this._transport.messageHandler.sendWithStream("GetTextContent",{pageIndex:this._pageIndex,normalizeWhitespace:!0===e,combineTextItems:!0!==t,includeMarkedContent:!0===i},{highWaterMark:100,size:e=>e.items.length})}getTextContent(e={}){if(this._transport._htmlForXfa)return this.getXfa().then((e=>_xfa_text.XfaText.textContent(e)));const t=this.streamTextContent(e);return new Promise((function(e,i){const n=t.getReader(),s={items:[],styles:Object.create(null)};!function pump(){n.read().then((function({value:t,done:i}){if(i)e(s);else{Object.assign(s.styles,t.styles);s.items.push(...t.items);pump()}}),i)}()}))}getStructTree(){return this._structTreePromise||=this._transport.getStructTree(this._pageIndex)}_destroy(){this.destroyed=!0;const e=[];for(const t of this._intentStates.values()){this._abortOperatorList({intentState:t,reason:new Error("Page was destroyed."),force:!0});if(!t.opListReadCapability)for(const i of t.renderTasks){e.push(i.completed);i.cancel()}}this.objs.clear();this._annotationPromises.clear();this._jsActionsPromise=null;this._structTreePromise=null;this.pendingCleanup=!1;return Promise.all(e)}cleanup(e=!1){this.pendingCleanup=!0;return this._tryCleanup(e)}_tryCleanup(e=!1){if(!this.pendingCleanup)return!1;for(const{renderTasks:e,operatorList:t}of this._intentStates.values())if(e.size>0||!t.lastChunk)return!1;this._intentStates.clear();this.objs.clear();this._annotationPromises.clear();this._jsActionsPromise=null;this._structTreePromise=null;e&&this._stats&&(this._stats=new _display_utils.StatTimer);this.pendingCleanup=!1;return!0}_startRenderPage(e,t){const i=this._intentStates.get(t);if(i){this._stats&&this._stats.timeEnd("Page Request");i.displayReadyCapability&&i.displayReadyCapability.resolve(e)}}_renderPageChunk(e,t){for(let i=0,n=e.length;i<n;i++){t.operatorList.fnArray.push(e.fnArray[i]);t.operatorList.argsArray.push(e.argsArray[i])}t.operatorList.lastChunk=e.lastChunk;for(const e of t.renderTasks)e.operatorListChanged();e.lastChunk&&this._tryCleanup()}_pumpOperatorList({renderingIntent:e,cacheKey:t}){const i=this._transport.messageHandler.sendWithStream("GetOperatorList",{pageIndex:this._pageIndex,intent:e,cacheKey:t,annotationStorage:e&_util.RenderingIntentFlag.ANNOTATIONS_STORAGE?this._transport.annotationStorage.serializable:null}).getReader(),n=this._intentStates.get(t);n.streamReader=i;const pump=()=>{i.read().then((({value:e,done:t})=>{if(t)n.streamReader=null;else if(!this._transport.destroyed){this._renderPageChunk(e,n);pump()}}),(e=>{n.streamReader=null;if(!this._transport.destroyed){if(n.operatorList){n.operatorList.lastChunk=!0;for(const e of n.renderTasks)e.operatorListChanged();this._tryCleanup()}if(n.displayReadyCapability)n.displayReadyCapability.reject(e);else{if(!n.opListReadCapability)throw e;n.opListReadCapability.reject(e)}}}))};pump()}_abortOperatorList({intentState:e,reason:t,force:i=!1}){if(e.streamReader){if(!i){if(e.renderTasks.size>0)return;if(t instanceof _display_utils.RenderingCancelledException){e.streamReaderCancelTimeout=setTimeout((()=>{this._abortOperatorList({intentState:e,reason:t,force:!0});e.streamReaderCancelTimeout=null}),RENDERING_CANCELLED_TIMEOUT);return}}e.streamReader.cancel(new _util.AbortException(t.message)).catch((()=>{}));e.streamReader=null;if(!this._transport.destroyed){for(const[t,i]of this._intentStates)if(i===e){this._intentStates.delete(t);break}this.cleanup()}}}get stats(){return this._stats}}exports.PDFPageProxy=PDFPageProxy;class LoopbackPort{constructor(){this._listeners=[];this._deferred=Promise.resolve()}postMessage(e,t){const i={data:function cloneValue(e){if(globalThis.structuredClone)return globalThis.structuredClone(e,t);const i=new WeakMap;return function fallbackCloneValue(e){if("function"==typeof e||"symbol"==typeof e||e instanceof URL)throw new Error(`LoopbackPort.postMessage - cannot clone: ${e?.toString()}`);if("object"!=typeof e||null===e)return e;if(i.has(e))return i.get(e);let n,s;if((n=e.buffer)&&(0,_util.isArrayBuffer)(n)){s=t?.includes(n)?new e.constructor(n,e.byteOffset,e.byteLength):new e.constructor(e);i.set(e,s);return s}if(e instanceof Map){s=new Map;i.set(e,s);for(const[t,i]of e)s.set(t,fallbackCloneValue(i));return s}if(e instanceof Set){s=new Set;i.set(e,s);for(const t of e)s.add(fallbackCloneValue(t));return s}s=Array.isArray(e)?[]:Object.create(null);i.set(e,s);for(const t in e){let i,n=e;for(;!(i=Object.getOwnPropertyDescriptor(n,t));)n=Object.getPrototypeOf(n);void 0!==i.value&&(("function"!=typeof i.value||e.hasOwnProperty?.(t))&&(s[t]=fallbackCloneValue(i.value)))}return s}(e)}(e)};this._deferred.then((()=>{for(const e of this._listeners)e.call(this,i)}))}addEventListener(e,t){this._listeners.push(t)}removeEventListener(e,t){const i=this._listeners.indexOf(t);this._listeners.splice(i,1)}terminate(){this._listeners.length=0}}exports.LoopbackPort=LoopbackPort;const PDFWorkerUtil={isWorkerDisabled:!1,fallbackWorkerSrc:null,fakeWorkerId:0};if(_is_node.isNodeJS&&"function"==typeof require){PDFWorkerUtil.isWorkerDisabled=!0;PDFWorkerUtil.fallbackWorkerSrc="./pdf.worker.js"}else if("object"==typeof document){const e=document?.currentScript?.src;e&&(PDFWorkerUtil.fallbackWorkerSrc=e.replace(/(\.(?:min\.)?js)(\?.*)?$/i,".worker$1$2"))}PDFWorkerUtil.createCDNWrapper=function(e){const t=`importScripts("${e}");`;return URL.createObjectURL(new Blob([t]))};class PDFWorker{static get _workerPorts(){return(0,_util.shadow)(this,"_workerPorts",new WeakMap)}constructor({name:e=null,port:t=null,verbosity:i=(0,_util.getVerbosityLevel)()}={}){if(t&&PDFWorker._workerPorts.has(t))throw new Error("Cannot use more than one PDFWorker per port.");this.name=e;this.destroyed=!1;this.verbosity=i;this._readyCapability=(0,_util.createPromiseCapability)();this._port=null;this._webWorker=null;this._messageHandler=null;if(t){PDFWorker._workerPorts.set(t,this);this._initializeFromPort(t)}else this._initialize()}get promise(){return this._readyCapability.promise}get port(){return this._port}get messageHandler(){return this._messageHandler}_initializeFromPort(e){this._port=e;this._messageHandler=new _message_handler.MessageHandler("main","worker",e);this._messageHandler.on("ready",(function(){}));this._readyCapability.resolve()}_initialize(){if("undefined"!=typeof Worker&&!PDFWorkerUtil.isWorkerDisabled&&!PDFWorker._mainThreadWorkerMessageHandler){let e=PDFWorker.workerSrc;try{(0,_util.isSameOrigin)(window.location.href,e)||(e=PDFWorkerUtil.createCDNWrapper(new URL(e,window.location).href));const t=new Worker(e),i=new _message_handler.MessageHandler("main","worker",t),terminateEarly=()=>{t.removeEventListener("error",onWorkerError);i.destroy();t.terminate();this.destroyed?this._readyCapability.reject(new Error("Worker was destroyed")):this._setupFakeWorker()},onWorkerError=()=>{this._webWorker||terminateEarly()};t.addEventListener("error",onWorkerError);i.on("test",(e=>{t.removeEventListener("error",onWorkerError);if(this.destroyed)terminateEarly();else if(e){this._messageHandler=i;this._port=t;this._webWorker=t;this._readyCapability.resolve();i.send("configure",{verbosity:this.verbosity})}else{this._setupFakeWorker();i.destroy();t.terminate()}}));i.on("ready",(e=>{t.removeEventListener("error",onWorkerError);if(this.destroyed)terminateEarly();else try{sendTest()}catch(e){this._setupFakeWorker()}}));const sendTest=()=>{const e=new Uint8Array([255]);try{i.send("test",e,[e.buffer])}catch(t){(0,_util.warn)("Cannot use postMessage transfers.");e[0]=0;i.send("test",e)}};sendTest();return}catch(e){(0,_util.info)("The worker has been disabled.")}}this._setupFakeWorker()}_setupFakeWorker(){if(!PDFWorkerUtil.isWorkerDisabled){(0,_util.warn)("Setting up fake worker.");PDFWorkerUtil.isWorkerDisabled=!0}PDFWorker._setupFakeWorkerGlobal.then((e=>{if(this.destroyed){this._readyCapability.reject(new Error("Worker was destroyed"));return}const t=new LoopbackPort;this._port=t;const i="fake"+PDFWorkerUtil.fakeWorkerId++,n=new _message_handler.MessageHandler(i+"_worker",i,t);e.setup(n,t);const s=new _message_handler.MessageHandler(i,i+"_worker",t);this._messageHandler=s;this._readyCapability.resolve();s.send("configure",{verbosity:this.verbosity})})).catch((e=>{this._readyCapability.reject(new Error(`Setting up fake worker failed: "${e.message}".`))}))}destroy(){this.destroyed=!0;if(this._webWorker){this._webWorker.terminate();this._webWorker=null}PDFWorker._workerPorts.delete(this._port);this._port=null;if(this._messageHandler){this._messageHandler.destroy();this._messageHandler=null}}static fromPort(e){if(!e?.port)throw new Error("PDFWorker.fromPort - invalid method signature.");return this._workerPorts.has(e.port)?this._workerPorts.get(e.port):new PDFWorker(e)}static get workerSrc(){if(_worker_options.GlobalWorkerOptions.workerSrc)return _worker_options.GlobalWorkerOptions.workerSrc;if(null!==PDFWorkerUtil.fallbackWorkerSrc){_is_node.isNodeJS||(0,_display_utils.deprecated)('No "GlobalWorkerOptions.workerSrc" specified.');return PDFWorkerUtil.fallbackWorkerSrc}throw new Error('No "GlobalWorkerOptions.workerSrc" specified.')}static get _mainThreadWorkerMessageHandler(){try{return globalThis.pdfjsWorker?.WorkerMessageHandler||null}catch(e){return null}}static get _setupFakeWorkerGlobal(){const loader=async()=>{const mainWorkerMessageHandler=this._mainThreadWorkerMessageHandler;if(mainWorkerMessageHandler)return mainWorkerMessageHandler;if(_is_node.isNodeJS&&"function"==typeof require){const worker=eval("require")(this.workerSrc);return worker.WorkerMessageHandler}await(0,_display_utils.loadScript)(this.workerSrc);return window.pdfjsWorker.WorkerMessageHandler};return(0,_util.shadow)(this,"_setupFakeWorkerGlobal",loader())}}exports.PDFWorker=PDFWorker;PDFWorker.getWorkerSrc=function(){(0,_display_utils.deprecated)("`PDFWorker.getWorkerSrc()`, please use `PDFWorker.workerSrc` instead.");return this.workerSrc};class WorkerTransport{#e=null;#t=new Map;#i=new Map;#n=null;constructor(e,t,i,n){this.messageHandler=e;this.loadingTask=t;this.commonObjs=new PDFObjects;this.fontLoader=new _font_loader.FontLoader({docId:t.docId,onUnsupportedFeature:this._onUnsupportedFeature.bind(this),ownerDocument:n.ownerDocument,styleElement:n.styleElement});this._params=n;if(!n.useWorkerFetch){this.CMapReaderFactory=new n.CMapReaderFactory({baseUrl:n.cMapUrl,isCompressed:n.cMapPacked});this.StandardFontDataFactory=new n.StandardFontDataFactory({baseUrl:n.standardFontDataUrl})}this.destroyed=!1;this.destroyCapability=null;this._passwordCapability=null;this._networkStream=i;this._fullReader=null;this._lastProgress=null;this.downloadInfoCapability=(0,_util.createPromiseCapability)();this.setupMessageHandler()}get annotationStorage(){return(0,_util.shadow)(this,"annotationStorage",new _annotation_storage.AnnotationStorage)}get stats(){return this.#e}getRenderingIntent(e,t=_util.AnnotationMode.ENABLE,i=!1){let n=_util.RenderingIntentFlag.DISPLAY,s="";switch(e){case"any":n=_util.RenderingIntentFlag.ANY;break;case"display":break;case"print":n=_util.RenderingIntentFlag.PRINT;break;default:(0,_util.warn)(`getRenderingIntent - invalid intent: ${e}`)}switch(t){case _util.AnnotationMode.DISABLE:n+=_util.RenderingIntentFlag.ANNOTATIONS_DISABLE;break;case _util.AnnotationMode.ENABLE:break;case _util.AnnotationMode.ENABLE_FORMS:n+=_util.RenderingIntentFlag.ANNOTATIONS_FORMS;break;case _util.AnnotationMode.ENABLE_STORAGE:n+=_util.RenderingIntentFlag.ANNOTATIONS_STORAGE;s=this.annotationStorage.lastModified;break;default:(0,_util.warn)(`getRenderingIntent - invalid annotationMode: ${t}`)}i&&(n+=_util.RenderingIntentFlag.OPLIST);return{renderingIntent:n,cacheKey:`${n}_${s}`}}destroy(){if(this.destroyCapability)return this.destroyCapability.promise;this.destroyed=!0;this.destroyCapability=(0,_util.createPromiseCapability)();this._passwordCapability&&this._passwordCapability.reject(new Error("Worker was destroyed during onPassword callback"));const e=[];for(const t of this.#t.values())e.push(t._destroy());this.#t.clear();this.#i.clear();this.hasOwnProperty("annotationStorage")&&this.annotationStorage.resetModified();const t=this.messageHandler.sendWithPromise("Terminate",null);e.push(t);Promise.all(e).then((()=>{this.commonObjs.clear();this.fontLoader.clear();this.#n=null;this._getFieldObjectsPromise=null;this._hasJSActionsPromise=null;this._networkStream&&this._networkStream.cancelAllRequests(new _util.AbortException("Worker was terminated."));if(this.messageHandler){this.messageHandler.destroy();this.messageHandler=null}this.destroyCapability.resolve()}),this.destroyCapability.reject);return this.destroyCapability.promise}setupMessageHandler(){const{messageHandler:e,loadingTask:t}=this;e.on("GetReader",((e,t)=>{(0,_util.assert)(this._networkStream,"GetReader - no `IPDFStream` instance available.");this._fullReader=this._networkStream.getFullReader();this._fullReader.onProgress=e=>{this._lastProgress={loaded:e.loaded,total:e.total}};t.onPull=()=>{this._fullReader.read().then((function({value:e,done:i}){if(i)t.close();else{(0,_util.assert)((0,_util.isArrayBuffer)(e),"GetReader - expected an ArrayBuffer.");t.enqueue(new Uint8Array(e),1,[e])}})).catch((e=>{t.error(e)}))};t.onCancel=e=>{this._fullReader.cancel(e);t.ready.catch((e=>{if(!this.destroyed)throw e}))}}));e.on("ReaderHeadersReady",(e=>{const i=(0,_util.createPromiseCapability)(),n=this._fullReader;n.headersReady.then((()=>{if(!n.isStreamingSupported||!n.isRangeSupported){this._lastProgress&&t.onProgress?.(this._lastProgress);n.onProgress=e=>{t.onProgress?.({loaded:e.loaded,total:e.total})}}i.resolve({isStreamingSupported:n.isStreamingSupported,isRangeSupported:n.isRangeSupported,contentLength:n.contentLength})}),i.reject);return i.promise}));e.on("GetRangeReader",((e,t)=>{(0,_util.assert)(this._networkStream,"GetRangeReader - no `IPDFStream` instance available.");const i=this._networkStream.getRangeReader(e.begin,e.end);if(i){t.onPull=()=>{i.read().then((function({value:e,done:i}){if(i)t.close();else{(0,_util.assert)((0,_util.isArrayBuffer)(e),"GetRangeReader - expected an ArrayBuffer.");t.enqueue(new Uint8Array(e),1,[e])}})).catch((e=>{t.error(e)}))};t.onCancel=e=>{i.cancel(e);t.ready.catch((e=>{if(!this.destroyed)throw e}))}}else t.close()}));e.on("GetDoc",(({pdfInfo:e})=>{this._numPages=e.numPages;this._htmlForXfa=e.htmlForXfa;delete e.htmlForXfa;t._capability.resolve(new PDFDocumentProxy(e,this))}));e.on("DocException",(function(e){let i;switch(e.name){case"PasswordException":i=new _util.PasswordException(e.message,e.code);break;case"InvalidPDFException":i=new _util.InvalidPDFException(e.message);break;case"MissingPDFException":i=new _util.MissingPDFException(e.message);break;case"UnexpectedResponseException":i=new _util.UnexpectedResponseException(e.message,e.status);break;case"UnknownErrorException":i=new _util.UnknownErrorException(e.message,e.details);break;default:(0,_util.unreachable)("DocException - expected a valid Error.")}t._capability.reject(i)}));e.on("PasswordRequest",(e=>{this._passwordCapability=(0,_util.createPromiseCapability)();if(t.onPassword){const updatePassword=e=>{this._passwordCapability.resolve({password:e})};try{t.onPassword(updatePassword,e.code)}catch(e){this._passwordCapability.reject(e)}}else this._passwordCapability.reject(new _util.PasswordException(e.message,e.code));return this._passwordCapability.promise}));e.on("DataLoaded",(e=>{t.onProgress?.({loaded:e.length,total:e.length});this.downloadInfoCapability.resolve(e)}));e.on("StartRenderPage",(e=>{if(this.destroyed)return;this.#t.get(e.pageIndex)._startRenderPage(e.transparency,e.cacheKey)}));e.on("commonobj",(([t,i,n])=>{if(!this.destroyed&&!this.commonObjs.has(t))switch(i){case"Font":const s=this._params;if("error"in n){const e=n.error;(0,_util.warn)(`Error during font loading: ${e}`);this.commonObjs.resolve(t,e);break}let r=null;s.pdfBug&&globalThis.FontInspector?.enabled&&(r={registerFont(e,t){globalThis.FontInspector.fontAdded(e,t)}});const a=new _font_loader.FontFaceObject(n,{isEvalSupported:s.isEvalSupported,disableFontFace:s.disableFontFace,ignoreErrors:s.ignoreErrors,onUnsupportedFeature:this._onUnsupportedFeature.bind(this),fontRegistry:r});this.fontLoader.bind(a).catch((i=>e.sendWithPromise("FontFallback",{id:t}))).finally((()=>{!s.fontExtraProperties&&a.data&&(a.data=null);this.commonObjs.resolve(t,a)}));break;case"FontPath":case"Image":this.commonObjs.resolve(t,n);break;default:throw new Error(`Got unknown common object type ${i}`)}}));e.on("obj",(([e,t,i,n])=>{if(this.destroyed)return;const s=this.#t.get(t);if(!s.objs.has(e))switch(i){case"Image":s.objs.resolve(e,n);const t=8e6;n?.data?.length>t&&(s.cleanupAfterRender=!0);break;case"Pattern":s.objs.resolve(e,n);break;default:throw new Error(`Got unknown object type ${i}`)}}));e.on("DocProgress",(e=>{this.destroyed||t.onProgress?.({loaded:e.loaded,total:e.total})}));e.on("DocStats",(e=>{this.destroyed||(this.#e=Object.freeze({streamTypes:Object.freeze(e.streamTypes),fontTypes:Object.freeze(e.fontTypes)}))}));e.on("UnsupportedFeature",this._onUnsupportedFeature.bind(this));e.on("FetchBuiltInCMap",(e=>this.destroyed?Promise.reject(new Error("Worker was destroyed.")):this.CMapReaderFactory?this.CMapReaderFactory.fetch(e):Promise.reject(new Error("CMapReaderFactory not initialized, see the `useWorkerFetch` parameter."))));e.on("FetchStandardFontData",(e=>this.destroyed?Promise.reject(new Error("Worker was destroyed.")):this.StandardFontDataFactory?this.StandardFontDataFactory.fetch(e):Promise.reject(new Error("StandardFontDataFactory not initialized, see the `useWorkerFetch` parameter."))))}_onUnsupportedFeature({featureId:e}){this.destroyed||this.loadingTask.onUnsupportedFeature?.(e)}getData(){return this.messageHandler.sendWithPromise("GetData",null)}getPage(e){if(!Number.isInteger(e)||e<=0||e>this._numPages)return Promise.reject(new Error("Invalid page request"));const t=e-1,i=this.#i.get(t);if(i)return i;const n=this.messageHandler.sendWithPromise("GetPage",{pageIndex:t}).then((e=>{if(this.destroyed)throw new Error("Transport destroyed");const i=new PDFPageProxy(t,e,this,this._params.ownerDocument,this._params.pdfBug);this.#t.set(t,i);return i}));this.#i.set(t,n);return n}getPageIndex(e){return this.messageHandler.sendWithPromise("GetPageIndex",{ref:e})}getAnnotations(e,t){return this.messageHandler.sendWithPromise("GetAnnotations",{pageIndex:e,intent:t})}saveDocument(){return this.messageHandler.sendWithPromise("SaveDocument",{isPureXfa:!!this._htmlForXfa,numPages:this._numPages,annotationStorage:this.annotationStorage.serializable,filename:this._fullReader?.filename??null}).finally((()=>{this.annotationStorage.resetModified()}))}getFieldObjects(){return this._getFieldObjectsPromise||=this.messageHandler.sendWithPromise("GetFieldObjects",null)}hasJSActions(){return this._hasJSActionsPromise||=this.messageHandler.sendWithPromise("HasJSActions",null)}getCalculationOrderIds(){return this.messageHandler.sendWithPromise("GetCalculationOrderIds",null)}getDestinations(){return this.messageHandler.sendWithPromise("GetDestinations",null)}getDestination(e){return"string"!=typeof e?Promise.reject(new Error("Invalid destination request.")):this.messageHandler.sendWithPromise("GetDestination",{id:e})}getPageLabels(){return this.messageHandler.sendWithPromise("GetPageLabels",null)}getPageLayout(){return this.messageHandler.sendWithPromise("GetPageLayout",null)}getPageMode(){return this.messageHandler.sendWithPromise("GetPageMode",null)}getViewerPreferences(){return this.messageHandler.sendWithPromise("GetViewerPreferences",null)}getOpenAction(){return this.messageHandler.sendWithPromise("GetOpenAction",null)}getAttachments(){return this.messageHandler.sendWithPromise("GetAttachments",null)}getJavaScript(){return this.messageHandler.sendWithPromise("GetJavaScript",null)}getDocJSActions(){return this.messageHandler.sendWithPromise("GetDocJSActions",null)}getPageJSActions(e){return this.messageHandler.sendWithPromise("GetPageJSActions",{pageIndex:e})}getStructTree(e){return this.messageHandler.sendWithPromise("GetStructTree",{pageIndex:e})}getOutline(){return this.messageHandler.sendWithPromise("GetOutline",null)}getOptionalContentConfig(){return this.messageHandler.sendWithPromise("GetOptionalContentConfig",null).then((e=>new _optional_content_config.OptionalContentConfig(e)))}getPermissions(){return this.messageHandler.sendWithPromise("GetPermissions",null)}getMetadata(){return this.#n||=this.messageHandler.sendWithPromise("GetMetadata",null).then((e=>({info:e[0],metadata:e[1]?new _metadata.Metadata(e[1]):null,contentDispositionFilename:this._fullReader?.filename??null,contentLength:this._fullReader?.contentLength??null})))}getMarkInfo(){return this.messageHandler.sendWithPromise("GetMarkInfo",null)}async startCleanup(e=!1){await this.messageHandler.sendWithPromise("Cleanup",null);if(!this.destroyed){for(const e of this.#t.values()){if(!e.cleanup())throw new Error(`startCleanup: Page ${e.pageNumber} is currently rendering.`)}this.commonObjs.clear();e||this.fontLoader.clear();this.#n=null;this._getFieldObjectsPromise=null;this._hasJSActionsPromise=null}}get loadingParams(){const e=this._params;return(0,_util.shadow)(this,"loadingParams",{disableAutoFetch:e.disableAutoFetch,enableXfa:e.enableXfa})}}class PDFObjects{constructor(){this._objs=Object.create(null)}_ensureObj(e){return this._objs[e]?this._objs[e]:this._objs[e]={capability:(0,_util.createPromiseCapability)(),data:null,resolved:!1}}get(e,t=null){if(t){this._ensureObj(e).capability.promise.then(t);return null}const i=this._objs[e];if(!i||!i.resolved)throw new Error(`Requesting object that isn't resolved yet ${e}.`);return i.data}has(e){return this._objs[e]?.resolved||!1}resolve(e,t){const i=this._ensureObj(e);i.resolved=!0;i.data=t;i.capability.resolve(t)}clear(){this._objs=Object.create(null)}}class RenderTask{constructor(e){this._internalRenderTask=e;this.onContinue=null}get promise(){return this._internalRenderTask.capability.promise}cancel(){this._internalRenderTask.cancel()}}exports.RenderTask=RenderTask;class InternalRenderTask{static get canvasInUse(){return(0,_util.shadow)(this,"canvasInUse",new WeakSet)}constructor({callback:e,params:t,objs:i,commonObjs:n,annotationCanvasMap:s,operatorList:r,pageIndex:a,canvasFactory:o,useRequestAnimationFrame:l=!1,pdfBug:c=!1}){this.callback=e;this.params=t;this.objs=i;this.commonObjs=n;this.annotationCanvasMap=s;this.operatorListIdx=null;this.operatorList=r;this._pageIndex=a;this.canvasFactory=o;this._pdfBug=c;this.running=!1;this.graphicsReadyCallback=null;this.graphicsReady=!1;this._useRequestAnimationFrame=!0===l&&"undefined"!=typeof window;this.cancelled=!1;this.capability=(0,_util.createPromiseCapability)();this.task=new RenderTask(this);this._cancelBound=this.cancel.bind(this);this._continueBound=this._continue.bind(this);this._scheduleNextBound=this._scheduleNext.bind(this);this._nextBound=this._next.bind(this);this._canvas=t.canvasContext.canvas}get completed(){return this.capability.promise.catch((function(){}))}initializeGraphics({transparency:e=!1,optionalContentConfig:t}){if(this.cancelled)return;if(this._canvas){if(InternalRenderTask.canvasInUse.has(this._canvas))throw new Error("Cannot use the same canvas during multiple render() operations. Use different canvas or ensure previous operations were cancelled or completed.");InternalRenderTask.canvasInUse.add(this._canvas)}if(this._pdfBug&&globalThis.StepperManager?.enabled){this.stepper=globalThis.StepperManager.create(this._pageIndex);this.stepper.init(this.operatorList);this.stepper.nextBreakPoint=this.stepper.getNextBreakPoint()}const{canvasContext:i,viewport:n,transform:s,imageLayer:r,background:a}=this.params;this.gfx=new _canvas.CanvasGraphics(i,this.commonObjs,this.objs,this.canvasFactory,r,t,this.annotationCanvasMap);this.gfx.beginDrawing({transform:s,viewport:n,transparency:e,background:a});this.operatorListIdx=0;this.graphicsReady=!0;this.graphicsReadyCallback&&this.graphicsReadyCallback()}cancel(e=null){this.running=!1;this.cancelled=!0;this.gfx&&this.gfx.endDrawing();this._canvas&&InternalRenderTask.canvasInUse.delete(this._canvas);this.callback(e||new _display_utils.RenderingCancelledException(`Rendering cancelled, page ${this._pageIndex+1}`,"canvas"))}operatorListChanged(){if(this.graphicsReady){this.stepper&&this.stepper.updateOperatorList(this.operatorList);this.running||this._continue()}else this.graphicsReadyCallback||(this.graphicsReadyCallback=this._continueBound)}_continue(){this.running=!0;this.cancelled||(this.task.onContinue?this.task.onContinue(this._scheduleNextBound):this._scheduleNext())}_scheduleNext(){this._useRequestAnimationFrame?window.requestAnimationFrame((()=>{this._nextBound().catch(this._cancelBound)})):Promise.resolve().then(this._nextBound).catch(this._cancelBound)}async _next(){if(!this.cancelled){this.operatorListIdx=this.gfx.executeOperatorList(this.operatorList,this.operatorListIdx,this._continueBound,this.stepper);if(this.operatorListIdx===this.operatorList.argsArray.length){this.running=!1;if(this.operatorList.lastChunk){this.gfx.endDrawing();this._canvas&&InternalRenderTask.canvasInUse.delete(this._canvas);this.callback()}}}}}const version="2.12.313";exports.version=version;const build="a2ae56f39";exports.build=build},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.FontLoader=t.FontFaceObject=void 0;var n=i(2);class BaseFontLoader{constructor({docId:e,onUnsupportedFeature:t,ownerDocument:i=globalThis.document,styleElement:s=null}){this.constructor===BaseFontLoader&&(0,n.unreachable)("Cannot initialize BaseFontLoader.");this.docId=e;this._onUnsupportedFeature=t;this._document=i;this.nativeFontFaces=[];this.styleElement=null}addNativeFontFace(e){this.nativeFontFaces.push(e);this._document.fonts.add(e)}insertRule(e){let t=this.styleElement;if(!t){t=this.styleElement=this._document.createElement("style");t.id=`PDFJS_FONT_STYLE_TAG_${this.docId}`;this._document.documentElement.getElementsByTagName("head")[0].appendChild(t)}const i=t.sheet;i.insertRule(e,i.cssRules.length)}clear(){for(const e of this.nativeFontFaces)this._document.fonts.delete(e);this.nativeFontFaces.length=0;if(this.styleElement){this.styleElement.remove();this.styleElement=null}}async bind(e){if(e.attached||e.missingFile)return;e.attached=!0;if(this.isFontLoadingAPISupported){const t=e.createNativeFontFace();if(t){this.addNativeFontFace(t);try{await t.loaded}catch(i){this._onUnsupportedFeature({featureId:n.UNSUPPORTED_FEATURES.errorFontLoadNative});(0,n.warn)(`Failed to load font '${t.family}': '${i}'.`);e.disableFontFace=!0;throw i}}return}const t=e.createFontFaceRule();if(t){this.insertRule(t);if(this.isSyncFontLoadingSupported)return;await new Promise((i=>{const n=this._queueLoadingCallback(i);this._prepareFontLoadEvent([t],[e],n)}))}}_queueLoadingCallback(e){(0,n.unreachable)("Abstract method `_queueLoadingCallback`.")}get isFontLoadingAPISupported(){const e=!!this._document?.fonts;return(0,n.shadow)(this,"isFontLoadingAPISupported",e)}get isSyncFontLoadingSupported(){(0,n.unreachable)("Abstract method `isSyncFontLoadingSupported`.")}get _loadTestFont(){(0,n.unreachable)("Abstract method `_loadTestFont`.")}_prepareFontLoadEvent(e,t,i){(0,n.unreachable)("Abstract method `_prepareFontLoadEvent`.")}}let s;t.FontLoader=s;t.FontLoader=s=class GenericFontLoader extends BaseFontLoader{constructor(e){super(e);this.loadingContext={requests:[],nextRequestId:0};this.loadTestFontId=0}get isSyncFontLoadingSupported(){let e=!1;if("undefined"==typeof navigator)e=!0;else{/Mozilla\/5.0.*?rv:(\d+).*? Gecko/.exec(navigator.userAgent)?.[1]>=14&&(e=!0)}return(0,n.shadow)(this,"isSyncFontLoadingSupported",e)}_queueLoadingCallback(e){const t=this.loadingContext,i={id:"pdfjs-font-loading-"+t.nextRequestId++,done:!1,complete:function completeRequest(){(0,n.assert)(!i.done,"completeRequest() cannot be called twice.");i.done=!0;for(;t.requests.length>0&&t.requests[0].done;){const e=t.requests.shift();setTimeout(e.callback,0)}},callback:e};t.requests.push(i);return i}get _loadTestFont(){return(0,n.shadow)(this,"_loadTestFont",atob("T1RUTwALAIAAAwAwQ0ZGIDHtZg4AAAOYAAAAgUZGVE1lkzZwAAAEHAAAABxHREVGABQAFQAABDgAAAAeT1MvMlYNYwkAAAEgAAAAYGNtYXABDQLUAAACNAAAAUJoZWFk/xVFDQAAALwAAAA2aGhlYQdkA+oAAAD0AAAAJGhtdHgD6AAAAAAEWAAAAAZtYXhwAAJQAAAAARgAAAAGbmFtZVjmdH4AAAGAAAAAsXBvc3T/hgAzAAADeAAAACAAAQAAAAEAALZRFsRfDzz1AAsD6AAAAADOBOTLAAAAAM4KHDwAAAAAA+gDIQAAAAgAAgAAAAAAAAABAAADIQAAAFoD6AAAAAAD6AABAAAAAAAAAAAAAAAAAAAAAQAAUAAAAgAAAAQD6AH0AAUAAAKKArwAAACMAooCvAAAAeAAMQECAAACAAYJAAAAAAAAAAAAAQAAAAAAAAAAAAAAAFBmRWQAwAAuAC4DIP84AFoDIQAAAAAAAQAAAAAAAAAAACAAIAABAAAADgCuAAEAAAAAAAAAAQAAAAEAAAAAAAEAAQAAAAEAAAAAAAIAAQAAAAEAAAAAAAMAAQAAAAEAAAAAAAQAAQAAAAEAAAAAAAUAAQAAAAEAAAAAAAYAAQAAAAMAAQQJAAAAAgABAAMAAQQJAAEAAgABAAMAAQQJAAIAAgABAAMAAQQJAAMAAgABAAMAAQQJAAQAAgABAAMAAQQJAAUAAgABAAMAAQQJAAYAAgABWABYAAAAAAAAAwAAAAMAAAAcAAEAAAAAADwAAwABAAAAHAAEACAAAAAEAAQAAQAAAC7//wAAAC7////TAAEAAAAAAAABBgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAD/gwAyAAAAAQAAAAAAAAAAAAAAAAAAAAABAAQEAAEBAQJYAAEBASH4DwD4GwHEAvgcA/gXBIwMAYuL+nz5tQXkD5j3CBLnEQACAQEBIVhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYAAABAQAADwACAQEEE/t3Dov6fAH6fAT+fPp8+nwHDosMCvm1Cvm1DAz6fBQAAAAAAAABAAAAAMmJbzEAAAAAzgTjFQAAAADOBOQpAAEAAAAAAAAADAAUAAQAAAABAAAAAgABAAAAAAAAAAAD6AAAAAAAAA=="))}_prepareFontLoadEvent(e,t,i){function int32(e,t){return e.charCodeAt(t)<<24|e.charCodeAt(t+1)<<16|e.charCodeAt(t+2)<<8|255&e.charCodeAt(t+3)}function spliceString(e,t,i,n){return e.substring(0,t)+n+e.substring(t+i)}let s,r;const a=this._document.createElement("canvas");a.width=1;a.height=1;const o=a.getContext("2d");let l=0;const c=`lt${Date.now()}${this.loadTestFontId++}`;let h=this._loadTestFont;h=spliceString(h,976,c.length,c);const d=1482184792;let u=int32(h,16);for(s=0,r=c.length-3;s<r;s+=4)u=u-d+int32(c,s)|0;s<c.length&&(u=u-d+int32(c+"XXX",s)|0);h=spliceString(h,16,4,(0,n.string32)(u));const p=`@font-face {font-family:"${c}";src:${`url(data:font/opentype;base64,${btoa(h)});`}}`;this.insertRule(p);const g=[];for(const e of t)g.push(e.loadedName);g.push(c);const f=this._document.createElement("div");f.style.visibility="hidden";f.style.width=f.style.height="10px";f.style.position="absolute";f.style.top=f.style.left="0px";for(const e of g){const t=this._document.createElement("span");t.textContent="Hi";t.style.fontFamily=e;f.appendChild(t)}this._document.body.appendChild(f);!function isFontReady(e,t){l++;if(l>30){(0,n.warn)("Load test font never loaded.");t();return}o.font="30px "+e;o.fillText(".",0,20);o.getImageData(0,0,1,1).data[3]>0?t():setTimeout(isFontReady.bind(null,e,t))}(c,(()=>{f.remove();i.complete()}))}};t.FontFaceObject=class FontFaceObject{constructor(e,{isEvalSupported:t=!0,disableFontFace:i=!1,ignoreErrors:n=!1,onUnsupportedFeature:s,fontRegistry:r=null}){this.compiledGlyphs=Object.create(null);for(const t in e)this[t]=e[t];this.isEvalSupported=!1!==t;this.disableFontFace=!0===i;this.ignoreErrors=!0===n;this._onUnsupportedFeature=s;this.fontRegistry=r}createNativeFontFace(){if(!this.data||this.disableFontFace)return null;let e;if(this.cssFontInfo){const t={weight:this.cssFontInfo.fontWeight};this.cssFontInfo.italicAngle&&(t.style=`oblique ${this.cssFontInfo.italicAngle}deg`);e=new FontFace(this.cssFontInfo.fontFamily,this.data,t)}else e=new FontFace(this.loadedName,this.data,{});this.fontRegistry&&this.fontRegistry.registerFont(this);return e}createFontFaceRule(){if(!this.data||this.disableFontFace)return null;const e=(0,n.bytesToString)(this.data),t=`url(data:${this.mimetype};base64,${btoa(e)});`;let i;if(this.cssFontInfo){let e=`font-weight: ${this.cssFontInfo.fontWeight};`;this.cssFontInfo.italicAngle&&(e+=`font-style: oblique ${this.cssFontInfo.italicAngle}deg;`);i=`@font-face {font-family:"${this.cssFontInfo.fontFamily}";${e}src:${t}}`}else i=`@font-face {font-family:"${this.loadedName}";src:${t}}`;this.fontRegistry&&this.fontRegistry.registerFont(this,t);return i}getPathGenerator(e,t){if(void 0!==this.compiledGlyphs[t])return this.compiledGlyphs[t];let i;try{i=e.get(this.loadedName+"_path_"+t)}catch(e){if(!this.ignoreErrors)throw e;this._onUnsupportedFeature({featureId:n.UNSUPPORTED_FEATURES.errorFontGetPath});(0,n.warn)(`getPathGenerator - ignoring character: "${e}".`);return this.compiledGlyphs[t]=function(e,t){}}if(this.isEvalSupported&&n.IsEvalSupportedCached.value){const e=[];for(const t of i){const i=void 0!==t.args?t.args.join(","):"";e.push("c.",t.cmd,"(",i,");\n")}return this.compiledGlyphs[t]=new Function("c","size",e.join(""))}return this.compiledGlyphs[t]=function(e,t){for(const n of i){"scale"===n.cmd&&(n.args=[t,-t]);e[n.cmd].apply(e,n.args)}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NodeStandardFontDataFactory=t.NodeCanvasFactory=t.NodeCMapReaderFactory=void 0;var n=i(5),s=i(4),r=i(2);let a=class{constructor(){(0,r.unreachable)("Not implemented: NodeCanvasFactory")}};t.NodeCanvasFactory=a;let o=class{constructor(){(0,r.unreachable)("Not implemented: NodeCMapReaderFactory")}};t.NodeCMapReaderFactory=o;let l=class{constructor(){(0,r.unreachable)("Not implemented: NodeStandardFontDataFactory")}};t.NodeStandardFontDataFactory=l;if(s.isNodeJS){const fetchData=function(e){return new Promise(((t,i)=>{require("fs").readFile(e,((e,n)=>{!e&&n?t(new Uint8Array(n)):i(new Error(e))}))}))};t.NodeCanvasFactory=a=class extends n.BaseCanvasFactory{_createCanvas(e,t){return require("canvas").createCanvas(e,t)}};t.NodeCMapReaderFactory=o=class extends n.BaseCMapReaderFactory{_fetchData(e,t){return fetchData(e).then((e=>({cMapData:e,compressionType:t})))}};t.NodeStandardFontDataFactory=l=class extends n.BaseStandardFontDataFactory{_fetchData(e){return fetchData(e)}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.AnnotationStorage=void 0;var n=i(2);t.AnnotationStorage=class AnnotationStorage{constructor(){this._storage=new Map;this._timeStamp=Date.now();this._modified=!1;this.onSetModified=null;this.onResetModified=null}getValue(e,t){const i=this._storage.get(e);return void 0===i?t:Object.assign(t,i)}setValue(e,t){const i=this._storage.get(e);let n=!1;if(void 0!==i){for(const[e,s]of Object.entries(t))if(i[e]!==s){n=!0;i[e]=s}}else{n=!0;this._storage.set(e,t)}if(n){this._timeStamp=Date.now();this._setModified()}}getAll(){return this._storage.size>0?(0,n.objectFromMap)(this._storage):null}get size(){return this._storage.size}_setModified(){if(!this._modified){this._modified=!0;"function"==typeof this.onSetModified&&this.onSetModified()}}resetModified(){if(this._modified){this._modified=!1;"function"==typeof this.onResetModified&&this.onResetModified()}}get serializable(){return this._storage.size>0?this._storage:null}get lastModified(){return this._timeStamp.toString()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CanvasGraphics=void 0;var n=i(2),s=i(11),r=i(1);const a=4096,o=16;function addContextCurrentTransform(e){if(!e.mozCurrentTransform){e._originalSave=e.save;e._originalRestore=e.restore;e._originalRotate=e.rotate;e._originalScale=e.scale;e._originalTranslate=e.translate;e._originalTransform=e.transform;e._originalSetTransform=e.setTransform;e._originalResetTransform=e.resetTransform;e._transformMatrix=e._transformMatrix||[1,0,0,1,0,0];e._transformStack=[];try{const t=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(e),"lineWidth");e._setLineWidth=t.set;e._getLineWidth=t.get;Object.defineProperty(e,"lineWidth",{set:function setLineWidth(e){this._setLineWidth(1.000001*e)},get:function getLineWidth(){return this._getLineWidth()}})}catch(e){}Object.defineProperty(e,"mozCurrentTransform",{get:function getCurrentTransform(){return this._transformMatrix}});Object.defineProperty(e,"mozCurrentTransformInverse",{get:function getCurrentTransformInverse(){const[e,t,i,n,s,r]=this._transformMatrix,a=e*n-t*i,o=t*i-e*n;return[n/a,t/o,i/o,e/a,(n*s-i*r)/o,(t*s-e*r)/a]}});e.save=function ctxSave(){const e=this._transformMatrix;this._transformStack.push(e);this._transformMatrix=e.slice(0,6);this._originalSave()};e.restore=function ctxRestore(){const e=this._transformStack.pop();if(e){this._transformMatrix=e;this._originalRestore()}};e.translate=function ctxTranslate(e,t){const i=this._transformMatrix;i[4]=i[0]*e+i[2]*t+i[4];i[5]=i[1]*e+i[3]*t+i[5];this._originalTranslate(e,t)};e.scale=function ctxScale(e,t){const i=this._transformMatrix;i[0]*=e;i[1]*=e;i[2]*=t;i[3]*=t;this._originalScale(e,t)};e.transform=function ctxTransform(t,i,n,s,r,a){const o=this._transformMatrix;this._transformMatrix=[o[0]*t+o[2]*i,o[1]*t+o[3]*i,o[0]*n+o[2]*s,o[1]*n+o[3]*s,o[0]*r+o[2]*a+o[4],o[1]*r+o[3]*a+o[5]];e._originalTransform(t,i,n,s,r,a)};e.setTransform=function ctxSetTransform(t,i,n,s,r,a){this._transformMatrix=[t,i,n,s,r,a];e._originalSetTransform(t,i,n,s,r,a)};e.resetTransform=function ctxResetTransform(){this._transformMatrix=[1,0,0,1,0,0];e._originalResetTransform()};e.rotate=function ctxRotate(e){const t=Math.cos(e),i=Math.sin(e),n=this._transformMatrix;this._transformMatrix=[n[0]*t+n[2]*i,n[1]*t+n[3]*i,n[0]*-i+n[2]*t,n[1]*-i+n[3]*t,n[4],n[5]];this._originalRotate(e)}}}class CachedCanvases{constructor(e){this.canvasFactory=e;this.cache=Object.create(null)}getCanvas(e,t,i,n){let s;if(void 0!==this.cache[e]){s=this.cache[e];this.canvasFactory.reset(s,t,i);s.context.setTransform(1,0,0,1,0,0)}else{s=this.canvasFactory.create(t,i);this.cache[e]=s}n&&addContextCurrentTransform(s.context);return s}clear(){for(const e in this.cache){const t=this.cache[e];this.canvasFactory.destroy(t);delete this.cache[e]}}}class CanvasExtraState{constructor(e,t){this.alphaIsShape=!1;this.fontSize=0;this.fontSizeScale=1;this.textMatrix=n.IDENTITY_MATRIX;this.textMatrixScale=1;this.fontMatrix=n.FONT_IDENTITY_MATRIX;this.leading=0;this.x=0;this.y=0;this.lineX=0;this.lineY=0;this.charSpacing=0;this.wordSpacing=0;this.textHScale=1;this.textRenderingMode=n.TextRenderingMode.FILL;this.textRise=0;this.fillColor="#000000";this.strokeColor="#000000";this.patternFill=!1;this.fillAlpha=1;this.strokeAlpha=1;this.lineWidth=1;this.activeSMask=null;this.transferMaps=null;this.startNewPathAndClipBox([0,0,e,t])}clone(){const e=Object.create(this);e.clipBox=this.clipBox.slice();return e}setCurrentPoint(e,t){this.x=e;this.y=t}updatePathMinMax(e,t,i){[t,i]=n.Util.applyTransform([t,i],e);this.minX=Math.min(this.minX,t);this.minY=Math.min(this.minY,i);this.maxX=Math.max(this.maxX,t);this.maxY=Math.max(this.maxY,i)}updateCurvePathMinMax(e,t,i,s,r,a,o,l,c){const h=n.Util.bezierBoundingBox(t,i,s,r,a,o,l,c);this.updatePathMinMax(e,h[0],h[1]);this.updatePathMinMax(e,h[2],h[3])}getPathBoundingBox(e=s.PathType.FILL,t=null){const i=[this.minX,this.minY,this.maxX,this.maxY];if(e===s.PathType.STROKE){t||(0,n.unreachable)("Stroke bounding box must include transform.");const e=n.Util.singularValueDecompose2dScale(t),s=e[0]*this.lineWidth/2,r=e[1]*this.lineWidth/2;i[0]-=s;i[1]-=r;i[2]+=s;i[3]+=r}return i}updateClipFromPath(){const e=n.Util.intersect(this.clipBox,this.getPathBoundingBox());this.startNewPathAndClipBox(e||[0,0,0,0])}startNewPathAndClipBox(e){this.clipBox=e;this.minX=1/0;this.minY=1/0;this.maxX=0;this.maxY=0}getClippedPathBoundingBox(e=s.PathType.FILL,t=null){return n.Util.intersect(this.clipBox,this.getPathBoundingBox(e,t))}}function putBinaryImageData(e,t,i=null){if("undefined"!=typeof ImageData&&t instanceof ImageData){e.putImageData(t,0,0);return}const s=t.height,r=t.width,a=s%o,l=(s-a)/o,c=0===a?l:l+1,h=e.createImageData(r,o);let d,u=0;const p=t.data,g=h.data;let f,m,_,b,v,w,y,S;if(i)switch(i.length){case 1:v=i[0];w=i[0];y=i[0];S=i[0];break;case 4:v=i[0];w=i[1];y=i[2];S=i[3]}if(t.kind===n.ImageKind.GRAYSCALE_1BPP){const t=p.byteLength,i=new Uint32Array(g.buffer,0,g.byteLength>>2),s=i.length,b=r+7>>3;let v=4294967295,w=n.IsLittleEndianCached.value?4278190080:255;S&&255===S[0]&&0===S[255]&&([v,w]=[w,v]);for(f=0;f<c;f++){_=f<l?o:a;d=0;for(m=0;m<_;m++){const e=t-u;let n=0;const s=e>b?r:8*e-7,a=-8&s;let o=0,l=0;for(;n<a;n+=8){l=p[u++];i[d++]=128&l?v:w;i[d++]=64&l?v:w;i[d++]=32&l?v:w;i[d++]=16&l?v:w;i[d++]=8&l?v:w;i[d++]=4&l?v:w;i[d++]=2&l?v:w;i[d++]=1&l?v:w}for(;n<s;n++){if(0===o){l=p[u++];o=128}i[d++]=l&o?v:w;o>>=1}}for(;d<s;)i[d++]=0;e.putImageData(h,0,f*o)}}else if(t.kind===n.ImageKind.RGBA_32BPP){const t=!!(v||w||y);m=0;b=r*o*4;for(f=0;f<l;f++){g.set(p.subarray(u,u+b));u+=b;if(t)for(let e=0;e<b;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,m);m+=o}if(f<c){b=r*a*4;g.set(p.subarray(u,u+b));if(t)for(let e=0;e<b;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,m)}}else{if(t.kind!==n.ImageKind.RGB_24BPP)throw new Error(`bad image kind: ${t.kind}`);{const t=!!(v||w||y);_=o;b=r*_;for(f=0;f<c;f++){if(f>=l){_=a;b=r*_}d=0;for(m=b;m--;){g[d++]=p[u++];g[d++]=p[u++];g[d++]=p[u++];g[d++]=255}if(t)for(let e=0;e<d;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,f*o)}}}}function putBinaryImageMask(e,t){const i=t.height,n=t.width,s=i%o,r=(i-s)/o,a=0===s?r:r+1,l=e.createImageData(n,o);let c=0;const h=t.data,d=l.data;for(let t=0;t<a;t++){const i=t<r?o:s;let a=3;for(let e=0;e<i;e++){let e,t=0;for(let i=0;i<n;i++){if(!t){e=h[c++];t=128}d[a]=e&t?0:255;a+=4;t>>=1}}e.putImageData(l,0,t*o)}}function copyCtxState(e,t){const i=["strokeStyle","fillStyle","fillRule","globalAlpha","lineWidth","lineCap","lineJoin","miterLimit","globalCompositeOperation","font"];for(let n=0,s=i.length;n<s;n++){const s=i[n];void 0!==e[s]&&(t[s]=e[s])}if(void 0!==e.setLineDash){t.setLineDash(e.getLineDash());t.lineDashOffset=e.lineDashOffset}}function resetCtxToDefault(e){e.strokeStyle="#000000";e.fillStyle="#000000";e.fillRule="nonzero";e.globalAlpha=1;e.lineWidth=1;e.lineCap="butt";e.lineJoin="miter";e.miterLimit=10;e.globalCompositeOperation="source-over";e.font="10px sans-serif";if(void 0!==e.setLineDash){e.setLineDash([]);e.lineDashOffset=0}}function composeSMaskBackdrop(e,t,i,n){const s=e.length;for(let r=3;r<s;r+=4){const s=e[r];if(0===s){e[r-3]=t;e[r-2]=i;e[r-1]=n}else if(s<255){const a=255-s;e[r-3]=e[r-3]*s+t*a>>8;e[r-2]=e[r-2]*s+i*a>>8;e[r-1]=e[r-1]*s+n*a>>8}}}function composeSMaskAlpha(e,t,i){const n=e.length;for(let s=3;s<n;s+=4){const n=i?i[e[s]]:e[s];t[s]=t[s]*n*.00392156862745098|0}}function composeSMaskLuminosity(e,t,i){const n=e.length;for(let s=3;s<n;s+=4){const n=77*e[s-3]+152*e[s-2]+28*e[s-1];t[s]=i?t[s]*i[n>>8]>>8:t[s]*n>>16}}function composeSMask(e,t,i,n){const s=n[0],r=n[1],a=n[2]-s,o=n[3]-r;if(0!==a&&0!==o){!function genericComposeSMask(e,t,i,n,s,r,a,o,l,c,h){const d=!!r,u=d?r[0]:0,p=d?r[1]:0,g=d?r[2]:0;let f;f="Luminosity"===s?composeSMaskLuminosity:composeSMaskAlpha;const m=Math.min(n,Math.ceil(1048576/i));for(let s=0;s<n;s+=m){const r=Math.min(m,n-s),_=e.getImageData(o-c,s+(l-h),i,r),b=t.getImageData(o,s+l,i,r);d&&composeSMaskBackdrop(_.data,u,p,g);f(_.data,b.data,a);t.putImageData(b,o,s+l)}}(t.context,i,a,o,t.subtype,t.backdrop,t.transferMap,s,r,t.offsetX,t.offsetY);e.save();e.globalAlpha=1;e.globalCompositeOperation="source-over";e.setTransform(1,0,0,1,0,0);e.drawImage(i.canvas,0,0);e.restore()}}function getImageSmoothingEnabled(e,t){const i=n.Util.singularValueDecompose2dScale(e);i[0]=Math.fround(i[0]);i[1]=Math.fround(i[1]);const s=Math.fround((globalThis.devicePixelRatio||1)*r.PixelsPerInch.PDF_TO_CSS_UNITS);return void 0!==t?t:i[0]<=s||i[1]<=s}const l=["butt","round","square"],c=["miter","round","bevel"],h={},d={};class CanvasGraphics{constructor(e,t,i,n,s,r,a){this.ctx=e;this.current=new CanvasExtraState(this.ctx.canvas.width,this.ctx.canvas.height);this.stateStack=[];this.pendingClip=null;this.pendingEOFill=!1;this.res=null;this.xobjs=null;this.commonObjs=t;this.objs=i;this.canvasFactory=n;this.imageLayer=s;this.groupStack=[];this.processingType3=null;this.baseTransform=null;this.baseTransformStack=[];this.groupLevel=0;this.smaskStack=[];this.smaskCounter=0;this.tempSMask=null;this.suspendedCtx=null;this.contentVisible=!0;this.markedContentStack=[];this.optionalContentConfig=r;this.cachedCanvases=new CachedCanvases(this.canvasFactory);this.cachedPatterns=new Map;this.annotationCanvasMap=a;this.viewportScale=1;this.outputScaleX=1;this.outputScaleY=1;e&&addContextCurrentTransform(e);this._cachedGetSinglePixelWidth=null}beginDrawing({transform:e,viewport:t,transparency:i=!1,background:n=null}){const s=this.ctx.canvas.width,r=this.ctx.canvas.height;this.ctx.save();this.ctx.fillStyle=n||"rgb(255, 255, 255)";this.ctx.fillRect(0,0,s,r);this.ctx.restore();if(i){const e=this.cachedCanvases.getCanvas("transparent",s,r,!0);this.compositeCtx=this.ctx;this.transparentCanvas=e.canvas;this.ctx=e.context;this.ctx.save();this.ctx.transform.apply(this.ctx,this.compositeCtx.mozCurrentTransform)}this.ctx.save();resetCtxToDefault(this.ctx);if(e){this.ctx.transform.apply(this.ctx,e);this.outputScaleX=e[0];this.outputScaleY=e[0]}this.ctx.transform.apply(this.ctx,t.transform);this.viewportScale=t.scale;this.baseTransform=this.ctx.mozCurrentTransform.slice();this._combinedScaleFactor=Math.hypot(this.baseTransform[0],this.baseTransform[2]);this.imageLayer&&this.imageLayer.beginLayout()}executeOperatorList(e,t,i,s){const r=e.argsArray,a=e.fnArray;let o=t||0;const l=r.length;if(l===o)return o;const c=l-o>10&&"function"==typeof i,h=c?Date.now()+15:0;let d=0;const u=this.commonObjs,p=this.objs;let g;for(;;){if(void 0!==s&&o===s.nextBreakPoint){s.breakIt(o,i);return o}g=a[o];if(g!==n.OPS.dependency)this[g].apply(this,r[o]);else for(const e of r[o]){const t=e.startsWith("g_")?u:p;if(!t.has(e)){t.get(e,i);return o}}o++;if(o===l)return o;if(c&&++d>10){if(Date.now()>h){i();return o}d=0}}}endDrawing(){for(;this.stateStack.length||null!==this.current.activeSMask;)this.restore();this.ctx.restore();if(this.transparentCanvas){this.ctx=this.compositeCtx;this.ctx.save();this.ctx.setTransform(1,0,0,1,0,0);this.ctx.drawImage(this.transparentCanvas,0,0);this.ctx.restore();this.transparentCanvas=null}this.cachedCanvases.clear();this.cachedPatterns.clear();this.imageLayer&&this.imageLayer.endLayout()}_scaleImage(e,t){const i=e.width,n=e.height;let s,r,a=Math.max(Math.hypot(t[0],t[1]),1),o=Math.max(Math.hypot(t[2],t[3]),1),l=i,c=n,h="prescale1";for(;a>2&&l>1||o>2&&c>1;){let t=l,i=c;if(a>2&&l>1){t=Math.ceil(l/2);a/=l/t}if(o>2&&c>1){i=Math.ceil(c/2);o/=c/i}s=this.cachedCanvases.getCanvas(h,t,i);r=s.context;r.clearRect(0,0,t,i);r.drawImage(e,0,0,l,c,0,0,t,i);e=s.canvas;l=t;c=i;h="prescale1"===h?"prescale2":"prescale1"}return{img:e,paintWidth:l,paintHeight:c}}_createMaskCanvas(e){const t=this.ctx,i=e.width,r=e.height,a=this.current.fillColor,o=this.current.patternFill,l=this.cachedCanvases.getCanvas("maskCanvas",i,r);putBinaryImageMask(l.context,e);const c=t.mozCurrentTransform;let h=n.Util.transform(c,[1/i,0,0,-1/r,0,0]);h=n.Util.transform(h,[1,0,0,1,0,-r]);const d=n.Util.applyTransform([0,0],h),u=n.Util.applyTransform([i,r],h),p=n.Util.normalizeRect([d[0],d[1],u[0],u[1]]),g=Math.ceil(p[2]-p[0]),f=Math.ceil(p[3]-p[1]),m=this.cachedCanvases.getCanvas("fillCanvas",g,f,!0),_=m.context,b=Math.min(d[0],u[0]),v=Math.min(d[1],u[1]);_.translate(-b,-v);_.transform.apply(_,h);const w=this._scaleImage(l.canvas,_.mozCurrentTransformInverse);_.imageSmoothingEnabled=getImageSmoothingEnabled(_.mozCurrentTransform,e.interpolate);_.drawImage(w.img,0,0,w.img.width,w.img.height,0,0,i,r);_.globalCompositeOperation="source-in";const y=n.Util.transform(_.mozCurrentTransformInverse,[1,0,0,1,-b,-v]);_.fillStyle=o?a.getPattern(t,this,y,s.PathType.FILL):a;_.fillRect(0,0,i,r);return{canvas:m.canvas,offsetX:Math.round(b),offsetY:Math.round(v)}}setLineWidth(e){this.current.lineWidth=e;this.ctx.lineWidth=e}setLineCap(e){this.ctx.lineCap=l[e]}setLineJoin(e){this.ctx.lineJoin=c[e]}setMiterLimit(e){this.ctx.miterLimit=e}setDash(e,t){const i=this.ctx;if(void 0!==i.setLineDash){i.setLineDash(e);i.lineDashOffset=t}}setRenderingIntent(e){}setFlatness(e){}setGState(e){for(let t=0,i=e.length;t<i;t++){const i=e[t],n=i[0],s=i[1];switch(n){case"LW":this.setLineWidth(s);break;case"LC":this.setLineCap(s);break;case"LJ":this.setLineJoin(s);break;case"ML":this.setMiterLimit(s);break;case"D":this.setDash(s[0],s[1]);break;case"RI":this.setRenderingIntent(s);break;case"FL":this.setFlatness(s);break;case"Font":this.setFont(s[0],s[1]);break;case"CA":this.current.strokeAlpha=i[1];break;case"ca":this.current.fillAlpha=i[1];this.ctx.globalAlpha=i[1];break;case"BM":this.ctx.globalCompositeOperation=s;break;case"SMask":this.current.activeSMask=s?this.tempSMask:null;this.tempSMask=null;this.checkSMaskState();break;case"TR":this.current.transferMaps=s}}}checkSMaskState(){const e=!!this.suspendedCtx;this.current.activeSMask&&!e?this.beginSMaskMode():!this.current.activeSMask&&e&&this.endSMaskMode()}beginSMaskMode(){if(this.suspendedCtx)throw new Error("beginSMaskMode called while already in smask mode");const e=this.ctx.canvas.width,t=this.ctx.canvas.height,i="smaskGroupAt"+this.groupLevel,n=this.cachedCanvases.getCanvas(i,e,t,!0);this.suspendedCtx=this.ctx;this.ctx=n.context;const s=this.ctx;s.setTransform.apply(s,this.suspendedCtx.mozCurrentTransform);copyCtxState(this.suspendedCtx,s);!function mirrorContextOperations(e,t){if(e._removeMirroring)throw new Error("Context is already forwarding operations.");e.__originalSave=e.save;e.__originalRestore=e.restore;e.__originalRotate=e.rotate;e.__originalScale=e.scale;e.__originalTranslate=e.translate;e.__originalTransform=e.transform;e.__originalSetTransform=e.setTransform;e.__originalResetTransform=e.resetTransform;e.__originalClip=e.clip;e.__originalMoveTo=e.moveTo;e.__originalLineTo=e.lineTo;e.__originalBezierCurveTo=e.bezierCurveTo;e.__originalRect=e.rect;e.__originalClosePath=e.closePath;e.__originalBeginPath=e.beginPath;e._removeMirroring=()=>{e.save=e.__originalSave;e.restore=e.__originalRestore;e.rotate=e.__originalRotate;e.scale=e.__originalScale;e.translate=e.__originalTranslate;e.transform=e.__originalTransform;e.setTransform=e.__originalSetTransform;e.resetTransform=e.__originalResetTransform;e.clip=e.__originalClip;e.moveTo=e.__originalMoveTo;e.lineTo=e.__originalLineTo;e.bezierCurveTo=e.__originalBezierCurveTo;e.rect=e.__originalRect;e.closePath=e.__originalClosePath;e.beginPath=e.__originalBeginPath;delete e._removeMirroring};e.save=function ctxSave(){t.save();this.__originalSave()};e.restore=function ctxRestore(){t.restore();this.__originalRestore()};e.translate=function ctxTranslate(e,i){t.translate(e,i);this.__originalTranslate(e,i)};e.scale=function ctxScale(e,i){t.scale(e,i);this.__originalScale(e,i)};e.transform=function ctxTransform(e,i,n,s,r,a){t.transform(e,i,n,s,r,a);this.__originalTransform(e,i,n,s,r,a)};e.setTransform=function ctxSetTransform(e,i,n,s,r,a){t.setTransform(e,i,n,s,r,a);this.__originalSetTransform(e,i,n,s,r,a)};e.resetTransform=function ctxResetTransform(){t.resetTransform();this.__originalResetTransform()};e.rotate=function ctxRotate(e){t.rotate(e);this.__originalRotate(e)};e.clip=function ctxRotate(e){t.clip(e);this.__originalClip(e)};e.moveTo=function(e,i){t.moveTo(e,i);this.__originalMoveTo(e,i)};e.lineTo=function(e,i){t.lineTo(e,i);this.__originalLineTo(e,i)};e.bezierCurveTo=function(e,i,n,s,r,a){t.bezierCurveTo(e,i,n,s,r,a);this.__originalBezierCurveTo(e,i,n,s,r,a)};e.rect=function(e,i,n,s){t.rect(e,i,n,s);this.__originalRect(e,i,n,s)};e.closePath=function(){t.closePath();this.__originalClosePath()};e.beginPath=function(){t.beginPath();this.__originalBeginPath()}}(s,this.suspendedCtx);this.setGState([["BM","source-over"],["ca",1],["CA",1]])}endSMaskMode(){if(!this.suspendedCtx)throw new Error("endSMaskMode called while not in smask mode");this.ctx._removeMirroring();copyCtxState(this.ctx,this.suspendedCtx);this.ctx=this.suspendedCtx;this.current.activeSMask=null;this.suspendedCtx=null}compose(e){if(!this.current.activeSMask)return;if(e){e[0]=Math.floor(e[0]);e[1]=Math.floor(e[1]);e[2]=Math.ceil(e[2]);e[3]=Math.ceil(e[3])}else e=[0,0,this.ctx.canvas.width,this.ctx.canvas.height];const t=this.current.activeSMask;composeSMask(this.suspendedCtx,t,this.ctx,e);this.ctx.save();this.ctx.setTransform(1,0,0,1,0,0);this.ctx.clearRect(0,0,this.ctx.canvas.width,this.ctx.canvas.height);this.ctx.restore()}save(){this.ctx.save();const e=this.current;this.stateStack.push(e);this.current=e.clone()}restore(){0===this.stateStack.length&&this.current.activeSMask&&this.endSMaskMode();if(0!==this.stateStack.length){this.current=this.stateStack.pop();this.ctx.restore();this.checkSMaskState();this.pendingClip=null;this._cachedGetSinglePixelWidth=null}}transform(e,t,i,n,s,r){this.ctx.transform(e,t,i,n,s,r);this._cachedGetSinglePixelWidth=null}constructPath(e,t){const i=this.ctx,s=this.current;let r,a,o=s.x,l=s.y;for(let c=0,h=0,d=e.length;c<d;c++)switch(0|e[c]){case n.OPS.rectangle:o=t[h++];l=t[h++];const e=t[h++],c=t[h++],d=o+e,u=l+c;i.moveTo(o,l);if(0===e||0===c)i.lineTo(d,u);else{i.lineTo(d,l);i.lineTo(d,u);i.lineTo(o,u)}s.updatePathMinMax(i.mozCurrentTransform,o,l);s.updatePathMinMax(i.mozCurrentTransform,d,u);i.closePath();break;case n.OPS.moveTo:o=t[h++];l=t[h++];i.moveTo(o,l);s.updatePathMinMax(i.mozCurrentTransform,o,l);break;case n.OPS.lineTo:o=t[h++];l=t[h++];i.lineTo(o,l);s.updatePathMinMax(i.mozCurrentTransform,o,l);break;case n.OPS.curveTo:r=o;a=l;o=t[h+4];l=t[h+5];i.bezierCurveTo(t[h],t[h+1],t[h+2],t[h+3],o,l);s.updateCurvePathMinMax(i.mozCurrentTransform,r,a,t[h],t[h+1],t[h+2],t[h+3],o,l);h+=6;break;case n.OPS.curveTo2:r=o;a=l;i.bezierCurveTo(o,l,t[h],t[h+1],t[h+2],t[h+3]);s.updateCurvePathMinMax(i.mozCurrentTransform,r,a,o,l,t[h],t[h+1],t[h+2],t[h+3]);o=t[h+2];l=t[h+3];h+=4;break;case n.OPS.curveTo3:r=o;a=l;o=t[h+2];l=t[h+3];i.bezierCurveTo(t[h],t[h+1],o,l,o,l);s.updateCurvePathMinMax(i.mozCurrentTransform,r,a,t[h],t[h+1],o,l,o,l);h+=4;break;case n.OPS.closePath:i.closePath()}s.setCurrentPoint(o,l)}closePath(){this.ctx.closePath()}stroke(e){e=void 0===e||e;const t=this.ctx,i=this.current.strokeColor;t.globalAlpha=this.current.strokeAlpha;if(this.contentVisible)if("object"==typeof i&&i?.getPattern){const e=this.getSinglePixelWidth();t.save();t.strokeStyle=i.getPattern(t,this,t.mozCurrentTransformInverse,s.PathType.STROKE);t.lineWidth=Math.max(e,this.current.lineWidth);t.stroke();t.restore()}else{const e=this.getSinglePixelWidth();if(e<0&&-e>=this.current.lineWidth){t.save();t.resetTransform();t.lineWidth=Math.round(this._combinedScaleFactor);t.stroke();t.restore()}else{t.lineWidth=Math.max(e,this.current.lineWidth);t.stroke()}}e&&this.consumePath(this.current.getClippedPathBoundingBox());t.globalAlpha=this.current.fillAlpha}closeStroke(){this.closePath();this.stroke()}fill(e){e=void 0===e||e;const t=this.ctx,i=this.current.fillColor;let n=!1;if(this.current.patternFill){t.save();t.fillStyle=i.getPattern(t,this,t.mozCurrentTransformInverse,s.PathType.FILL);n=!0}const r=this.current.getClippedPathBoundingBox();if(this.contentVisible&&null!==r)if(this.pendingEOFill){t.fill("evenodd");this.pendingEOFill=!1}else t.fill();n&&t.restore();e&&this.consumePath(r)}eoFill(){this.pendingEOFill=!0;this.fill()}fillStroke(){this.fill(!1);this.stroke(!1);this.consumePath()}eoFillStroke(){this.pendingEOFill=!0;this.fillStroke()}closeFillStroke(){this.closePath();this.fillStroke()}closeEOFillStroke(){this.pendingEOFill=!0;this.closePath();this.fillStroke()}endPath(){this.consumePath()}clip(){this.pendingClip=h}eoClip(){this.pendingClip=d}beginText(){this.current.textMatrix=n.IDENTITY_MATRIX;this.current.textMatrixScale=1;this.current.x=this.current.lineX=0;this.current.y=this.current.lineY=0}endText(){const e=this.pendingTextPaths,t=this.ctx;if(void 0!==e){t.save();t.beginPath();for(let i=0;i<e.length;i++){const n=e[i];t.setTransform.apply(t,n.transform);t.translate(n.x,n.y);n.addToPath(t,n.fontSize)}t.restore();t.clip();t.beginPath();delete this.pendingTextPaths}else t.beginPath()}setCharSpacing(e){this.current.charSpacing=e}setWordSpacing(e){this.current.wordSpacing=e}setHScale(e){this.current.textHScale=e/100}setLeading(e){this.current.leading=-e}setFont(e,t){const i=this.commonObjs.get(e),s=this.current;if(!i)throw new Error(`Can't find font for ${e}`);s.fontMatrix=i.fontMatrix||n.FONT_IDENTITY_MATRIX;0!==s.fontMatrix[0]&&0!==s.fontMatrix[3]||(0,n.warn)("Invalid font matrix for font "+e);if(t<0){t=-t;s.fontDirection=-1}else s.fontDirection=1;this.current.font=i;this.current.fontSize=t;if(i.isType3Font)return;const r=i.loadedName||"sans-serif";let a="normal";i.black?a="900":i.bold&&(a="bold");const o=i.italic?"italic":"normal",l=`"${r}", ${i.fallbackName}`;let c=t;t<16?c=16:t>100&&(c=100);this.current.fontSizeScale=t/c;this.ctx.font=`${o} ${a} ${c}px ${l}`}setTextRenderingMode(e){this.current.textRenderingMode=e}setTextRise(e){this.current.textRise=e}moveText(e,t){this.current.x=this.current.lineX+=e;this.current.y=this.current.lineY+=t}setLeadingMoveText(e,t){this.setLeading(-t);this.moveText(e,t)}setTextMatrix(e,t,i,n,s,r){this.current.textMatrix=[e,t,i,n,s,r];this.current.textMatrixScale=Math.hypot(e,t);this.current.x=this.current.lineX=0;this.current.y=this.current.lineY=0}nextLine(){this.moveText(0,this.current.leading)}paintChar(e,t,i,s,r){const a=this.ctx,o=this.current,l=o.font,c=o.textRenderingMode,h=o.fontSize/o.fontSizeScale,d=c&n.TextRenderingMode.FILL_STROKE_MASK,u=!!(c&n.TextRenderingMode.ADD_TO_PATH_FLAG),p=o.patternFill&&!l.missingFile;let g;(l.disableFontFace||u||p)&&(g=l.getPathGenerator(this.commonObjs,e));if(l.disableFontFace||p){a.save();a.translate(t,i);a.beginPath();g(a,h);s&&a.setTransform.apply(a,s);d!==n.TextRenderingMode.FILL&&d!==n.TextRenderingMode.FILL_STROKE||a.fill();if(d===n.TextRenderingMode.STROKE||d===n.TextRenderingMode.FILL_STROKE){if(r){a.resetTransform();a.lineWidth=Math.round(this._combinedScaleFactor)}a.stroke()}a.restore()}else{d!==n.TextRenderingMode.FILL&&d!==n.TextRenderingMode.FILL_STROKE||a.fillText(e,t,i);if(d===n.TextRenderingMode.STROKE||d===n.TextRenderingMode.FILL_STROKE)if(r){a.save();a.moveTo(t,i);a.resetTransform();a.lineWidth=Math.round(this._combinedScaleFactor);a.strokeText(e,0,0);a.restore()}else a.strokeText(e,t,i)}if(u){(this.pendingTextPaths||(this.pendingTextPaths=[])).push({transform:a.mozCurrentTransform,x:t,y:i,fontSize:h,addToPath:g})}}get isFontSubpixelAAEnabled(){const{context:e}=this.cachedCanvases.getCanvas("isFontSubpixelAAEnabled",10,10);e.scale(1.5,1);e.fillText("I",0,10);const t=e.getImageData(0,0,10,10).data;let i=!1;for(let e=3;e<t.length;e+=4)if(t[e]>0&&t[e]<255){i=!0;break}return(0,n.shadow)(this,"isFontSubpixelAAEnabled",i)}showText(e){const t=this.current,i=t.font;if(i.isType3Font)return this.showType3Text(e);const r=t.fontSize;if(0===r)return;const a=this.ctx,o=t.fontSizeScale,l=t.charSpacing,c=t.wordSpacing,h=t.fontDirection,d=t.textHScale*h,u=e.length,p=i.vertical,g=p?1:-1,f=i.defaultVMetrics,m=r*t.fontMatrix[0],_=t.textRenderingMode===n.TextRenderingMode.FILL&&!i.disableFontFace&&!t.patternFill;a.save();a.transform.apply(a,t.textMatrix);a.translate(t.x,t.y+t.textRise);h>0?a.scale(d,-1):a.scale(d,1);let b;if(t.patternFill){a.save();const e=t.fillColor.getPattern(a,this,a.mozCurrentTransformInverse,s.PathType.FILL);b=a.mozCurrentTransform;a.restore();a.fillStyle=e}let v=t.lineWidth,w=!1;const y=t.textMatrixScale;if(0===y||0===v){const e=t.textRenderingMode&n.TextRenderingMode.FILL_STROKE_MASK;if(e===n.TextRenderingMode.STROKE||e===n.TextRenderingMode.FILL_STROKE){this._cachedGetSinglePixelWidth=null;v=this.getSinglePixelWidth();w=v<0}}else v/=y;if(1!==o){a.scale(o,o);v/=o}a.lineWidth=v;let S,P=0;for(S=0;S<u;++S){const t=e[S];if((0,n.isNum)(t)){P+=g*t*r/1e3;continue}let s=!1;const d=(t.isSpace?c:0)+l,u=t.fontChar,v=t.accent;let y,A,C,x=t.width;if(p){const e=t.vmetric||f,i=-(t.vmetric?e[1]:.5*x)*m,n=e[2]*m;x=e?-e[0]:x;y=i/o;A=(P+n)/o}else{y=P/o;A=0}if(i.remeasure&&x>0){const e=1e3*a.measureText(u).width/r*o;if(x<e&&this.isFontSubpixelAAEnabled){const t=x/e;s=!0;a.save();a.scale(t,1);y/=t}else x!==e&&(y+=(x-e)/2e3*r/o)}if(this.contentVisible&&(t.isInFont||i.missingFile))if(_&&!v)a.fillText(u,y,A);else{this.paintChar(u,y,A,b,w);if(v){const e=y+r*v.offset.x/o,t=A-r*v.offset.y/o;this.paintChar(v.fontChar,e,t,b,w)}}C=p?x*m-d*h:x*m+d*h;P+=C;s&&a.restore()}p?t.y-=P:t.x+=P*d;a.restore();this.compose()}showType3Text(e){const t=this.ctx,i=this.current,s=i.font,r=i.fontSize,a=i.fontDirection,o=s.vertical?1:-1,l=i.charSpacing,c=i.wordSpacing,h=i.textHScale*a,d=i.fontMatrix||n.FONT_IDENTITY_MATRIX,u=e.length;let p,g,f,m;if(!(i.textRenderingMode===n.TextRenderingMode.INVISIBLE)&&0!==r){this._cachedGetSinglePixelWidth=null;t.save();t.transform.apply(t,i.textMatrix);t.translate(i.x,i.y);t.scale(h,a);for(p=0;p<u;++p){g=e[p];if((0,n.isNum)(g)){m=o*g*r/1e3;this.ctx.translate(m,0);i.x+=m*h;continue}const a=(g.isSpace?c:0)+l,u=s.charProcOperatorList[g.operatorListId];if(!u){(0,n.warn)(`Type3 character "${g.operatorListId}" is not available.`);continue}if(this.contentVisible){this.processingType3=g;this.save();t.scale(r,r);t.transform.apply(t,d);this.executeOperatorList(u);this.restore()}f=n.Util.applyTransform([g.width,0],d)[0]*r+a;t.translate(f,0);i.x+=f*h}t.restore();this.processingType3=null}}setCharWidth(e,t){}setCharWidthAndBounds(e,t,i,n,s,r){this.ctx.rect(i,n,s-i,r-n);this.clip();this.endPath()}getColorN_Pattern(e){let t;if("TilingPattern"===e[0]){const i=e[1],n=this.baseTransform||this.ctx.mozCurrentTransform.slice(),r={createCanvasGraphics:e=>new CanvasGraphics(e,this.commonObjs,this.objs,this.canvasFactory)};t=new s.TilingPattern(e,i,this.ctx,r,n)}else t=this._getPattern(e[1],e[2]);return t}setStrokeColorN(){this.current.strokeColor=this.getColorN_Pattern(arguments)}setFillColorN(){this.current.fillColor=this.getColorN_Pattern(arguments);this.current.patternFill=!0}setStrokeRGBColor(e,t,i){const s=n.Util.makeHexColor(e,t,i);this.ctx.strokeStyle=s;this.current.strokeColor=s}setFillRGBColor(e,t,i){const s=n.Util.makeHexColor(e,t,i);this.ctx.fillStyle=s;this.current.fillColor=s;this.current.patternFill=!1}_getPattern(e,t=null){let i;if(this.cachedPatterns.has(e))i=this.cachedPatterns.get(e);else{i=(0,s.getShadingPattern)(this.objs.get(e));this.cachedPatterns.set(e,i)}t&&(i.matrix=t);return i}shadingFill(e){if(!this.contentVisible)return;const t=this.ctx;this.save();const i=this._getPattern(e);t.fillStyle=i.getPattern(t,this,t.mozCurrentTransformInverse,s.PathType.SHADING);const r=t.mozCurrentTransformInverse;if(r){const e=t.canvas,i=e.width,s=e.height,a=n.Util.applyTransform([0,0],r),o=n.Util.applyTransform([0,s],r),l=n.Util.applyTransform([i,0],r),c=n.Util.applyTransform([i,s],r),h=Math.min(a[0],o[0],l[0],c[0]),d=Math.min(a[1],o[1],l[1],c[1]),u=Math.max(a[0],o[0],l[0],c[0]),p=Math.max(a[1],o[1],l[1],c[1]);this.ctx.fillRect(h,d,u-h,p-d)}else this.ctx.fillRect(-1e10,-1e10,2e10,2e10);this.compose(this.current.getClippedPathBoundingBox());this.restore()}beginInlineImage(){(0,n.unreachable)("Should not call beginInlineImage")}beginImageData(){(0,n.unreachable)("Should not call beginImageData")}paintFormXObjectBegin(e,t){if(this.contentVisible){this.save();this.baseTransformStack.push(this.baseTransform);Array.isArray(e)&&6===e.length&&this.transform.apply(this,e);this.baseTransform=this.ctx.mozCurrentTransform;if(t){const e=t[2]-t[0],i=t[3]-t[1];this.ctx.rect(t[0],t[1],e,i);this.current.updatePathMinMax(this.ctx.mozCurrentTransform,t[0],t[1]);this.current.updatePathMinMax(this.ctx.mozCurrentTransform,t[2],t[3]);this.clip();this.endPath()}}}paintFormXObjectEnd(){if(this.contentVisible){this.restore();this.baseTransform=this.baseTransformStack.pop()}}beginGroup(e){if(!this.contentVisible)return;this.save();const t=this.suspendedCtx;if(this.current.activeSMask){this.suspendedCtx=null;this.current.activeSMask=null}const i=this.ctx;e.isolated||(0,n.info)("TODO: Support non-isolated groups.");e.knockout&&(0,n.warn)("Knockout groups not supported.");const s=i.mozCurrentTransform;e.matrix&&i.transform.apply(i,e.matrix);if(!e.bbox)throw new Error("Bounding box is required.");let r=n.Util.getAxialAlignedBoundingBox(e.bbox,i.mozCurrentTransform);const o=[0,0,i.canvas.width,i.canvas.height];r=n.Util.intersect(r,o)||[0,0,0,0];const l=Math.floor(r[0]),c=Math.floor(r[1]);let h=Math.max(Math.ceil(r[2])-l,1),d=Math.max(Math.ceil(r[3])-c,1),u=1,p=1;if(h>a){u=h/a;h=a}if(d>a){p=d/a;d=a}this.current.startNewPathAndClipBox([0,0,h,d]);let g="groupAt"+this.groupLevel;e.smask&&(g+="_smask_"+this.smaskCounter++%2);const f=this.cachedCanvases.getCanvas(g,h,d,!0),m=f.context;m.scale(1/u,1/p);m.translate(-l,-c);m.transform.apply(m,s);if(e.smask)this.smaskStack.push({canvas:f.canvas,context:m,offsetX:l,offsetY:c,scaleX:u,scaleY:p,subtype:e.smask.subtype,backdrop:e.smask.backdrop,transferMap:e.smask.transferMap||null,startTransformInverse:null});else{i.setTransform(1,0,0,1,0,0);i.translate(l,c);i.scale(u,p);i.save()}copyCtxState(i,m);this.ctx=m;this.setGState([["BM","source-over"],["ca",1],["CA",1]]);this.groupStack.push({ctx:i,suspendedCtx:t});this.groupLevel++}endGroup(e){if(!this.contentVisible)return;this.groupLevel--;const t=this.ctx,{ctx:i,suspendedCtx:s}=this.groupStack.pop();this.ctx=i;this.ctx.imageSmoothingEnabled=!1;s&&(this.suspendedCtx=s);if(e.smask){this.tempSMask=this.smaskStack.pop();this.restore()}else{this.ctx.restore();const e=this.ctx.mozCurrentTransform;this.restore();this.ctx.save();this.ctx.setTransform.apply(this.ctx,e);const i=n.Util.getAxialAlignedBoundingBox([0,0,t.canvas.width,t.canvas.height],e);this.ctx.drawImage(t.canvas,0,0);this.ctx.restore();this.compose(i)}}beginAnnotations(){this.save();this.baseTransform&&this.ctx.setTransform.apply(this.ctx,this.baseTransform)}endAnnotations(){this.restore()}beginAnnotation(e,t,i,s,r){this.save();if(Array.isArray(t)&&4===t.length){const s=t[2]-t[0],a=t[3]-t[1];if(r&&this.annotationCanvasMap){(i=i.slice())[4]-=t[0];i[5]-=t[1];(t=t.slice())[0]=t[1]=0;t[2]=s;t[3]=a;const[r,o]=n.Util.singularValueDecompose2dScale(this.ctx.mozCurrentTransform),{viewportScale:l}=this,c=Math.ceil(s*this.outputScaleX*l),h=Math.ceil(a*this.outputScaleY*l);this.annotationCanvas=this.canvasFactory.create(c,h);const{canvas:d,context:u}=this.annotationCanvas;d.style.width=`calc(${s}px * var(--viewport-scale-factor))`;d.style.height=`calc(${a}px * var(--viewport-scale-factor))`;this.annotationCanvasMap.set(e,d);this.annotationCanvas.savedCtx=this.ctx;this.ctx=u;this.ctx.setTransform(r,0,0,-o,0,a*o);addContextCurrentTransform(this.ctx);resetCtxToDefault(this.ctx)}else{resetCtxToDefault(this.ctx);this.ctx.rect(t[0],t[1],s,a);this.clip();this.endPath()}}this.current=new CanvasExtraState(this.ctx.canvas.width,this.ctx.canvas.height);this.transform.apply(this,i);this.transform.apply(this,s)}endAnnotation(){if(this.annotationCanvas){this.ctx=this.annotationCanvas.savedCtx;delete this.annotationCanvas.savedCtx;delete this.annotationCanvas}this.restore()}paintImageMaskXObject(e){if(!this.contentVisible)return;const t=this.ctx,i=e.width,n=e.height,s=this.processingType3;s&&void 0===s.compiled&&(s.compiled=i<=1e3&&n<=1e3?function compileType3Glyph(e){const t=new Uint8Array([0,2,4,0,1,0,5,4,8,10,0,8,0,2,1,0]),i=e.width,n=e.height,s=i+1;let r,a,o,l;const c=new Uint8Array(s*(n+1)),h=i+7&-8,d=e.data,u=new Uint8Array(h*n);let p=0;for(r=0,a=d.length;r<a;r++){const e=d[r];let t=128;for(;t>0;){u[p++]=e&t?0:255;t>>=1}}let g=0;p=0;if(0!==u[p]){c[0]=1;++g}for(o=1;o<i;o++){if(u[p]!==u[p+1]){c[o]=u[p]?2:1;++g}p++}if(0!==u[p]){c[o]=2;++g}for(r=1;r<n;r++){p=r*h;l=r*s;if(u[p-h]!==u[p]){c[l]=u[p]?1:8;++g}let e=(u[p]?4:0)+(u[p-h]?8:0);for(o=1;o<i;o++){e=(e>>2)+(u[p+1]?4:0)+(u[p-h+1]?8:0);if(t[e]){c[l+o]=t[e];++g}p++}if(u[p-h]!==u[p]){c[l+o]=u[p]?2:4;++g}if(g>1e3)return null}p=h*(n-1);l=r*s;if(0!==u[p]){c[l]=8;++g}for(o=1;o<i;o++){if(u[p]!==u[p+1]){c[l+o]=u[p]?4:8;++g}p++}if(0!==u[p]){c[l+o]=4;++g}if(g>1e3)return null;const f=new Int32Array([0,s,-1,0,-s,0,0,0,1]),m=[];for(r=0;g&&r<=n;r++){let e=r*s;const t=e+i;for(;e<t&&!c[e];)e++;if(e===t)continue;const n=[e%s,r],a=e;let o=c[e];do{const t=f[o];do{e+=t}while(!c[e]);const i=c[e];if(5!==i&&10!==i){o=i;c[e]=0}else{o=i&51*o>>4;c[e]&=o>>2|o<<2}n.push(e%s,e/s|0);c[e]||--g}while(a!==e);m.push(n);--r}return function(e){e.save();e.scale(1/i,-1/n);e.translate(0,-n);e.beginPath();for(let t=0,i=m.length;t<i;t++){const i=m[t];e.moveTo(i[0],i[1]);for(let t=2,n=i.length;t<n;t+=2)e.lineTo(i[t],i[t+1])}e.fill();e.beginPath();e.restore()}}({data:e.data,width:i,height:n}):null);if(s?.compiled){s.compiled(t);return}const r=this._createMaskCanvas(e),a=r.canvas;t.save();t.setTransform(1,0,0,1,0,0);t.drawImage(a,r.offsetX,r.offsetY);t.restore();this.compose()}paintImageMaskXObjectRepeat(e,t,i=0,s=0,r,a){if(!this.contentVisible)return;const o=this.ctx;o.save();const l=o.mozCurrentTransform;o.transform(t,i,s,r,0,0);const c=this._createMaskCanvas(e);o.setTransform(1,0,0,1,0,0);for(let e=0,h=a.length;e<h;e+=2){const h=n.Util.transform(l,[t,i,s,r,a[e],a[e+1]]),[d,u]=n.Util.applyTransform([0,0],h);o.drawImage(c.canvas,d,u)}o.restore();this.compose()}paintImageMaskXObjectGroup(e){if(!this.contentVisible)return;const t=this.ctx,i=this.current.fillColor,n=this.current.patternFill;for(let r=0,a=e.length;r<a;r++){const a=e[r],o=a.width,l=a.height,c=this.cachedCanvases.getCanvas("maskCanvas",o,l),h=c.context;h.save();putBinaryImageMask(h,a);h.globalCompositeOperation="source-in";h.fillStyle=n?i.getPattern(h,this,t.mozCurrentTransformInverse,s.PathType.FILL):i;h.fillRect(0,0,o,l);h.restore();t.save();t.transform.apply(t,a.transform);t.scale(1,-1);t.drawImage(c.canvas,0,0,o,l,0,-1,1,1);t.restore()}this.compose()}paintImageXObject(e){if(!this.contentVisible)return;const t=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);t?this.paintInlineImageXObject(t):(0,n.warn)("Dependent image isn't ready yet")}paintImageXObjectRepeat(e,t,i,s){if(!this.contentVisible)return;const r=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);if(!r){(0,n.warn)("Dependent image isn't ready yet");return}const a=r.width,o=r.height,l=[];for(let e=0,n=s.length;e<n;e+=2)l.push({transform:[t,0,0,i,s[e],s[e+1]],x:0,y:0,w:a,h:o});this.paintInlineImageXObjectGroup(r,l)}paintInlineImageXObject(e){if(!this.contentVisible)return;const t=e.width,i=e.height,n=this.ctx;this.save();n.scale(1/t,-1/i);let s;if("function"==typeof HTMLElement&&e instanceof HTMLElement||!e.data)s=e;else{const n=this.cachedCanvases.getCanvas("inlineImage",t,i);putBinaryImageData(n.context,e,this.current.transferMaps);s=n.canvas}const r=this._scaleImage(s,n.mozCurrentTransformInverse);n.imageSmoothingEnabled=getImageSmoothingEnabled(n.mozCurrentTransform,e.interpolate);n.drawImage(r.img,0,0,r.paintWidth,r.paintHeight,0,-i,t,i);if(this.imageLayer){const s=this.getCanvasPosition(0,-i);this.imageLayer.appendImage({imgData:e,left:s[0],top:s[1],width:t/n.mozCurrentTransformInverse[0],height:i/n.mozCurrentTransformInverse[3]})}this.compose();this.restore()}paintInlineImageXObjectGroup(e,t){if(!this.contentVisible)return;const i=this.ctx,n=e.width,s=e.height,r=this.cachedCanvases.getCanvas("inlineImage",n,s);putBinaryImageData(r.context,e,this.current.transferMaps);for(let a=0,o=t.length;a<o;a++){const o=t[a];i.save();i.transform.apply(i,o.transform);i.scale(1,-1);i.drawImage(r.canvas,o.x,o.y,o.w,o.h,0,-1,1,1);if(this.imageLayer){const t=this.getCanvasPosition(o.x,o.y);this.imageLayer.appendImage({imgData:e,left:t[0],top:t[1],width:n,height:s})}i.restore()}this.compose()}paintSolidColorImageMask(){if(this.contentVisible){this.ctx.fillRect(0,0,1,1);this.compose()}}markPoint(e){}markPointProps(e,t){}beginMarkedContent(e){this.markedContentStack.push({visible:!0})}beginMarkedContentProps(e,t){"OC"===e?this.markedContentStack.push({visible:this.optionalContentConfig.isVisible(t)}):this.markedContentStack.push({visible:!0});this.contentVisible=this.isContentVisible()}endMarkedContent(){this.markedContentStack.pop();this.contentVisible=this.isContentVisible()}beginCompat(){}endCompat(){}consumePath(e){this.pendingClip&&this.current.updateClipFromPath();this.pendingClip||this.compose(e);const t=this.ctx;if(this.pendingClip){this.pendingClip===d?t.clip("evenodd"):t.clip();this.pendingClip=null}this.current.startNewPathAndClipBox(this.current.clipBox);t.beginPath()}getSinglePixelWidth(){if(null===this._cachedGetSinglePixelWidth){const e=this.ctx.mozCurrentTransform,t=Math.abs(e[0]*e[3]-e[2]*e[1]),i=e[0]**2+e[2]**2,n=e[1]**2+e[3]**2,s=Math.sqrt(Math.max(i,n))/t;i!==n&&this._combinedScaleFactor*s>1?this._cachedGetSinglePixelWidth=-this._combinedScaleFactor*s:t>Number.EPSILON?this._cachedGetSinglePixelWidth=s:this._cachedGetSinglePixelWidth=1}return this._cachedGetSinglePixelWidth}getCanvasPosition(e,t){const i=this.ctx.mozCurrentTransform;return[i[0]*e+i[2]*t+i[4],i[1]*e+i[3]*t+i[5]]}isContentVisible(){for(let e=this.markedContentStack.length-1;e>=0;e--)if(!this.markedContentStack[e].visible)return!1;return!0}}t.CanvasGraphics=CanvasGraphics;for(const e in n.OPS)void 0!==CanvasGraphics.prototype[e]&&(CanvasGraphics.prototype[n.OPS[e]]=CanvasGraphics.prototype[e])},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TilingPattern=t.PathType=void 0;t.getShadingPattern=function getShadingPattern(e){switch(e[0]){case"RadialAxial":return new RadialAxialShadingPattern(e);case"Mesh":return new MeshShadingPattern(e);case"Dummy":return new DummyShadingPattern}throw new Error(`Unknown IR type: ${e[0]}`)};var n=i(2);const s={FILL:"Fill",STROKE:"Stroke",SHADING:"Shading"};t.PathType=s;function applyBoundingBox(e,t){if(!t||"undefined"==typeof Path2D)return;const i=t[2]-t[0],n=t[3]-t[1],s=new Path2D;s.rect(t[0],t[1],i,n);e.clip(s)}class BaseShadingPattern{constructor(){this.constructor===BaseShadingPattern&&(0,n.unreachable)("Cannot initialize BaseShadingPattern.")}getPattern(){(0,n.unreachable)("Abstract method `getPattern` called.")}}class RadialAxialShadingPattern extends BaseShadingPattern{constructor(e){super();this._type=e[1];this._bbox=e[2];this._colorStops=e[3];this._p0=e[4];this._p1=e[5];this._r0=e[6];this._r1=e[7];this.matrix=null}_createGradient(e){let t;"axial"===this._type?t=e.createLinearGradient(this._p0[0],this._p0[1],this._p1[0],this._p1[1]):"radial"===this._type&&(t=e.createRadialGradient(this._p0[0],this._p0[1],this._r0,this._p1[0],this._p1[1],this._r1));for(const e of this._colorStops)t.addColorStop(e[0],e[1]);return t}getPattern(e,t,i,r){let a;if(r===s.STROKE||r===s.FILL){const s=t.current.getClippedPathBoundingBox(r,e.mozCurrentTransform)||[0,0,0,0],o=Math.ceil(s[2]-s[0])||1,l=Math.ceil(s[3]-s[1])||1,c=t.cachedCanvases.getCanvas("pattern",o,l,!0),h=c.context;h.clearRect(0,0,h.canvas.width,h.canvas.height);h.beginPath();h.rect(0,0,h.canvas.width,h.canvas.height);h.translate(-s[0],-s[1]);i=n.Util.transform(i,[1,0,0,1,s[0],s[1]]);h.transform.apply(h,t.baseTransform);this.matrix&&h.transform.apply(h,this.matrix);applyBoundingBox(h,this._bbox);h.fillStyle=this._createGradient(h);h.fill();a=e.createPattern(c.canvas,"no-repeat");const d=new DOMMatrix(i);try{a.setTransform(d)}catch(e){(0,n.warn)(`RadialAxialShadingPattern.getPattern: "${e?.message}".`)}}else{applyBoundingBox(e,this._bbox);a=this._createGradient(e)}return a}}function drawTriangle(e,t,i,n,s,r,a,o){const l=t.coords,c=t.colors,h=e.data,d=4*e.width;let u;if(l[i+1]>l[n+1]){u=i;i=n;n=u;u=r;r=a;a=u}if(l[n+1]>l[s+1]){u=n;n=s;s=u;u=a;a=o;o=u}if(l[i+1]>l[n+1]){u=i;i=n;n=u;u=r;r=a;a=u}const p=(l[i]+t.offsetX)*t.scaleX,g=(l[i+1]+t.offsetY)*t.scaleY,f=(l[n]+t.offsetX)*t.scaleX,m=(l[n+1]+t.offsetY)*t.scaleY,_=(l[s]+t.offsetX)*t.scaleX,b=(l[s+1]+t.offsetY)*t.scaleY;if(g>=b)return;const v=c[r],w=c[r+1],y=c[r+2],S=c[a],P=c[a+1],A=c[a+2],C=c[o],x=c[o+1],E=c[o+2],T=Math.round(g),k=Math.round(b);let L,M,F,R,D,I,O,N;for(let e=T;e<=k;e++){if(e<m){let t;t=e<g?0:(g-e)/(g-m);L=p-(p-f)*t;M=v-(v-S)*t;F=w-(w-P)*t;R=y-(y-A)*t}else{let t;t=e>b?1:m===b?0:(m-e)/(m-b);L=f-(f-_)*t;M=S-(S-C)*t;F=P-(P-x)*t;R=A-(A-E)*t}let t;t=e<g?0:e>b?1:(g-e)/(g-b);D=p-(p-_)*t;I=v-(v-C)*t;O=w-(w-x)*t;N=y-(y-E)*t;const i=Math.round(Math.min(L,D)),n=Math.round(Math.max(L,D));let s=d*e+4*i;for(let e=i;e<=n;e++){t=(L-e)/(L-D);t<0?t=0:t>1&&(t=1);h[s++]=M-(M-I)*t|0;h[s++]=F-(F-O)*t|0;h[s++]=R-(R-N)*t|0;h[s++]=255}}}function drawFigure(e,t,i){const n=t.coords,s=t.colors;let r,a;switch(t.type){case"lattice":const o=t.verticesPerRow,l=Math.floor(n.length/o)-1,c=o-1;for(r=0;r<l;r++){let t=r*o;for(let r=0;r<c;r++,t++){drawTriangle(e,i,n[t],n[t+1],n[t+o],s[t],s[t+1],s[t+o]);drawTriangle(e,i,n[t+o+1],n[t+1],n[t+o],s[t+o+1],s[t+1],s[t+o])}}break;case"triangles":for(r=0,a=n.length;r<a;r+=3)drawTriangle(e,i,n[r],n[r+1],n[r+2],s[r],s[r+1],s[r+2]);break;default:throw new Error("illegal figure")}}class MeshShadingPattern extends BaseShadingPattern{constructor(e){super();this._coords=e[2];this._colors=e[3];this._figures=e[4];this._bounds=e[5];this._bbox=e[7];this._background=e[8];this.matrix=null}_createMeshCanvas(e,t,i){const n=Math.floor(this._bounds[0]),s=Math.floor(this._bounds[1]),r=Math.ceil(this._bounds[2])-n,a=Math.ceil(this._bounds[3])-s,o=Math.min(Math.ceil(Math.abs(r*e[0]*1.1)),3e3),l=Math.min(Math.ceil(Math.abs(a*e[1]*1.1)),3e3),c=r/o,h=a/l,d={coords:this._coords,colors:this._colors,offsetX:-n,offsetY:-s,scaleX:1/c,scaleY:1/h},u=o+4,p=l+4,g=i.getCanvas("mesh",u,p,!1),f=g.context,m=f.createImageData(o,l);if(t){const e=m.data;for(let i=0,n=e.length;i<n;i+=4){e[i]=t[0];e[i+1]=t[1];e[i+2]=t[2];e[i+3]=255}}for(const e of this._figures)drawFigure(m,e,d);f.putImageData(m,2,2);return{canvas:g.canvas,offsetX:n-2*c,offsetY:s-2*h,scaleX:c,scaleY:h}}getPattern(e,t,i,r){applyBoundingBox(e,this._bbox);let a;if(r===s.SHADING)a=n.Util.singularValueDecompose2dScale(e.mozCurrentTransform);else{a=n.Util.singularValueDecompose2dScale(t.baseTransform);if(this.matrix){const e=n.Util.singularValueDecompose2dScale(this.matrix);a=[a[0]*e[0],a[1]*e[1]]}}const o=this._createMeshCanvas(a,r===s.SHADING?null:this._background,t.cachedCanvases);if(r!==s.SHADING){e.setTransform.apply(e,t.baseTransform);this.matrix&&e.transform.apply(e,this.matrix)}e.translate(o.offsetX,o.offsetY);e.scale(o.scaleX,o.scaleY);return e.createPattern(o.canvas,"no-repeat")}}class DummyShadingPattern extends BaseShadingPattern{getPattern(){return"hotpink"}}const r=1,a=2;class TilingPattern{static get MAX_PATTERN_SIZE(){return(0,n.shadow)(this,"MAX_PATTERN_SIZE",3e3)}constructor(e,t,i,n,s){this.operatorList=e[2];this.matrix=e[3]||[1,0,0,1,0,0];this.bbox=e[4];this.xstep=e[5];this.ystep=e[6];this.paintType=e[7];this.tilingType=e[8];this.color=t;this.ctx=i;this.canvasGraphicsFactory=n;this.baseTransform=s}createPatternCanvas(e){const t=this.operatorList,i=this.bbox,s=this.xstep,r=this.ystep,a=this.paintType,o=this.tilingType,l=this.color,c=this.canvasGraphicsFactory;(0,n.info)("TilingType: "+o);const h=i[0],d=i[1],u=i[2],p=i[3],g=n.Util.singularValueDecompose2dScale(this.matrix),f=n.Util.singularValueDecompose2dScale(this.baseTransform),m=[g[0]*f[0],g[1]*f[1]],_=this.getSizeAndScale(s,this.ctx.canvas.width,m[0]),b=this.getSizeAndScale(r,this.ctx.canvas.height,m[1]),v=e.cachedCanvases.getCanvas("pattern",_.size,b.size,!0),w=v.context,y=c.createCanvasGraphics(w);y.groupLevel=e.groupLevel;this.setFillAndStrokeStyleToContext(y,a,l);let S=h,P=d,A=u,C=p;if(h<0){S=0;A+=Math.abs(h)}if(d<0){P=0;C+=Math.abs(d)}w.translate(-_.scale*S,-b.scale*P);y.transform(_.scale,0,0,b.scale,0,0);this.clipBbox(y,S,P,A,C);y.baseTransform=y.ctx.mozCurrentTransform.slice();y.executeOperatorList(t);y.endDrawing();return{canvas:v.canvas,scaleX:_.scale,scaleY:b.scale,offsetX:S,offsetY:P}}getSizeAndScale(e,t,i){e=Math.abs(e);const n=Math.max(TilingPattern.MAX_PATTERN_SIZE,t);let s=Math.ceil(e*i);s>=n?s=n:i=s/e;return{scale:i,size:s}}clipBbox(e,t,i,n,s){const r=n-t,a=s-i;e.ctx.rect(t,i,r,a);e.clip();e.endPath()}setFillAndStrokeStyleToContext(e,t,i){const s=e.ctx,o=e.current;switch(t){case r:const e=this.ctx;s.fillStyle=e.fillStyle;s.strokeStyle=e.strokeStyle;o.fillColor=e.fillStyle;o.strokeColor=e.strokeStyle;break;case a:const l=n.Util.makeHexColor(i[0],i[1],i[2]);s.fillStyle=l;s.strokeStyle=l;o.fillColor=l;o.strokeColor=l;break;default:throw new n.FormatError(`Unsupported paint type: ${t}`)}}getPattern(e,t,i,r){let a=i;if(r!==s.SHADING){a=n.Util.transform(a,t.baseTransform);this.matrix&&(a=n.Util.transform(a,this.matrix))}const o=this.createPatternCanvas(t);let l=new DOMMatrix(a);l=l.translate(o.offsetX,o.offsetY);l=l.scale(1/o.scaleX,1/o.scaleY);const c=e.createPattern(o.canvas,"repeat");try{c.setTransform(l)}catch(e){(0,n.warn)(`TilingPattern.getPattern: "${e?.message}".`)}return c}}t.TilingPattern=TilingPattern},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GlobalWorkerOptions=void 0;const i=Object.create(null);t.GlobalWorkerOptions=i;i.workerPort=void 0===i.workerPort?null:i.workerPort;i.workerSrc=void 0===i.workerSrc?"":i.workerSrc},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.MessageHandler=void 0;var n=i(2);const s=1,r=2,a=1,o=2,l=3,c=4,h=5,d=6,u=7,p=8;function wrapReason(e){if(!(e instanceof Error||"object"==typeof e&&null!==e)){(0,n.warn)('wrapReason: Expected "reason" to be a (possibly cloned) Error.');return e}switch(e.name){case"AbortException":return new n.AbortException(e.message);case"MissingPDFException":return new n.MissingPDFException(e.message);case"PasswordException":return new n.PasswordException(e.message,e.code);case"UnexpectedResponseException":return new n.UnexpectedResponseException(e.message,e.status);case"UnknownErrorException":return new n.UnknownErrorException(e.message,e.details);default:return new n.UnknownErrorException(e.message,e.toString())}}t.MessageHandler=class MessageHandler{constructor(e,t,i){this.sourceName=e;this.targetName=t;this.comObj=i;this.callbackId=1;this.streamId=1;this.streamSinks=Object.create(null);this.streamControllers=Object.create(null);this.callbackCapabilities=Object.create(null);this.actionHandler=Object.create(null);this._onComObjOnMessage=e=>{const t=e.data;if(t.targetName!==this.sourceName)return;if(t.stream){this._processStreamMessage(t);return}if(t.callback){const e=t.callbackId,i=this.callbackCapabilities[e];if(!i)throw new Error(`Cannot resolve callback ${e}`);delete this.callbackCapabilities[e];if(t.callback===s)i.resolve(t.data);else{if(t.callback!==r)throw new Error("Unexpected callback case");i.reject(wrapReason(t.reason))}return}const n=this.actionHandler[t.action];if(!n)throw new Error(`Unknown action from worker: ${t.action}`);if(t.callbackId){const e=this.sourceName,a=t.sourceName;new Promise((function(e){e(n(t.data))})).then((function(n){i.postMessage({sourceName:e,targetName:a,callback:s,callbackId:t.callbackId,data:n})}),(function(n){i.postMessage({sourceName:e,targetName:a,callback:r,callbackId:t.callbackId,reason:wrapReason(n)})}))}else t.streamId?this._createStreamSink(t):n(t.data)};i.addEventListener("message",this._onComObjOnMessage)}on(e,t){const i=this.actionHandler;if(i[e])throw new Error(`There is already an actionName called "${e}"`);i[e]=t}send(e,t,i){this.comObj.postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,data:t},i)}sendWithPromise(e,t,i){const s=this.callbackId++,r=(0,n.createPromiseCapability)();this.callbackCapabilities[s]=r;try{this.comObj.postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,callbackId:s,data:t},i)}catch(e){r.reject(e)}return r.promise}sendWithStream(e,t,i,s){const r=this.streamId++,o=this.sourceName,l=this.targetName,c=this.comObj;return new ReadableStream({start:i=>{const a=(0,n.createPromiseCapability)();this.streamControllers[r]={controller:i,startCall:a,pullCall:null,cancelCall:null,isClosed:!1};c.postMessage({sourceName:o,targetName:l,action:e,streamId:r,data:t,desiredSize:i.desiredSize},s);return a.promise},pull:e=>{const t=(0,n.createPromiseCapability)();this.streamControllers[r].pullCall=t;c.postMessage({sourceName:o,targetName:l,stream:d,streamId:r,desiredSize:e.desiredSize});return t.promise},cancel:e=>{(0,n.assert)(e instanceof Error,"cancel must have a valid reason");const t=(0,n.createPromiseCapability)();this.streamControllers[r].cancelCall=t;this.streamControllers[r].isClosed=!0;c.postMessage({sourceName:o,targetName:l,stream:a,streamId:r,reason:wrapReason(e)});return t.promise}},i)}_createStreamSink(e){const t=e.streamId,i=this.sourceName,s=e.sourceName,r=this.comObj,a=this,o=this.actionHandler[e.action],d={enqueue(e,a=1,o){if(this.isCancelled)return;const l=this.desiredSize;this.desiredSize-=a;if(l>0&&this.desiredSize<=0){this.sinkCapability=(0,n.createPromiseCapability)();this.ready=this.sinkCapability.promise}r.postMessage({sourceName:i,targetName:s,stream:c,streamId:t,chunk:e},o)},close(){if(!this.isCancelled){this.isCancelled=!0;r.postMessage({sourceName:i,targetName:s,stream:l,streamId:t});delete a.streamSinks[t]}},error(e){(0,n.assert)(e instanceof Error,"error must have a valid reason");if(!this.isCancelled){this.isCancelled=!0;r.postMessage({sourceName:i,targetName:s,stream:h,streamId:t,reason:wrapReason(e)})}},sinkCapability:(0,n.createPromiseCapability)(),onPull:null,onCancel:null,isCancelled:!1,desiredSize:e.desiredSize,ready:null};d.sinkCapability.resolve();d.ready=d.sinkCapability.promise;this.streamSinks[t]=d;new Promise((function(t){t(o(e.data,d))})).then((function(){r.postMessage({sourceName:i,targetName:s,stream:p,streamId:t,success:!0})}),(function(e){r.postMessage({sourceName:i,targetName:s,stream:p,streamId:t,reason:wrapReason(e)})}))}_processStreamMessage(e){const t=e.streamId,i=this.sourceName,s=e.sourceName,r=this.comObj,g=this.streamControllers[t],f=this.streamSinks[t];switch(e.stream){case p:e.success?g.startCall.resolve():g.startCall.reject(wrapReason(e.reason));break;case u:e.success?g.pullCall.resolve():g.pullCall.reject(wrapReason(e.reason));break;case d:if(!f){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,success:!0});break}f.desiredSize<=0&&e.desiredSize>0&&f.sinkCapability.resolve();f.desiredSize=e.desiredSize;new Promise((function(e){e(f.onPull&&f.onPull())})).then((function(){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,success:!0})}),(function(e){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,reason:wrapReason(e)})}));break;case c:(0,n.assert)(g,"enqueue should have stream controller");if(g.isClosed)break;g.controller.enqueue(e.chunk);break;case l:(0,n.assert)(g,"close should have stream controller");if(g.isClosed)break;g.isClosed=!0;g.controller.close();this._deleteStreamController(g,t);break;case h:(0,n.assert)(g,"error should have stream controller");g.controller.error(wrapReason(e.reason));this._deleteStreamController(g,t);break;case o:e.success?g.cancelCall.resolve():g.cancelCall.reject(wrapReason(e.reason));this._deleteStreamController(g,t);break;case a:if(!f)break;new Promise((function(t){t(f.onCancel&&f.onCancel(wrapReason(e.reason)))})).then((function(){r.postMessage({sourceName:i,targetName:s,stream:o,streamId:t,success:!0})}),(function(e){r.postMessage({sourceName:i,targetName:s,stream:o,streamId:t,reason:wrapReason(e)})}));f.sinkCapability.reject(wrapReason(e.reason));f.isCancelled=!0;delete this.streamSinks[t];break;default:throw new Error("Unexpected stream case")}}async _deleteStreamController(e,t){await Promise.allSettled([e.startCall&&e.startCall.promise,e.pullCall&&e.pullCall.promise,e.cancelCall&&e.cancelCall.promise]);delete this.streamControllers[t]}destroy(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Metadata=void 0;var n=i(2);t.Metadata=class Metadata{#s;#r;constructor({parsedData:e,rawData:t}){this.#s=e;this.#r=t}getRaw(){return this.#r}get(e){return this.#s.get(e)??null}getAll(){return(0,n.objectFromMap)(this.#s)}has(e){return this.#s.has(e)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OptionalContentConfig=void 0;var n=i(2);class OptionalContentGroup{constructor(e,t){this.visible=!0;this.name=e;this.intent=t}}t.OptionalContentConfig=class OptionalContentConfig{constructor(e){this.name=null;this.creator=null;this._order=null;this._groups=new Map;if(null!==e){this.name=e.name;this.creator=e.creator;this._order=e.order;for(const t of e.groups)this._groups.set(t.id,new OptionalContentGroup(t.name,t.intent));if("OFF"===e.baseState)for(const e of this._groups)e.visible=!1;for(const t of e.on)this._groups.get(t).visible=!0;for(const t of e.off)this._groups.get(t).visible=!1}}_evaluateVisibilityExpression(e){const t=e.length;if(t<2)return!0;const i=e[0];for(let s=1;s<t;s++){const t=e[s];let r;if(Array.isArray(t))r=this._evaluateVisibilityExpression(t);else{if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}r=this._groups.get(t).visible}switch(i){case"And":if(!r)return!1;break;case"Or":if(r)return!0;break;case"Not":return!r;default:return!0}}return"And"===i}isVisible(e){if(0===this._groups.size)return!0;if(!e){(0,n.warn)("Optional content group not defined.");return!0}if("OCG"===e.type){if(!this._groups.has(e.id)){(0,n.warn)(`Optional content group not found: ${e.id}`);return!0}return this._groups.get(e.id).visible}if("OCMD"===e.type){if(e.expression)return this._evaluateVisibilityExpression(e.expression);if(!e.policy||"AnyOn"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(this._groups.get(t).visible)return!0}return!1}if("AllOn"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(!this._groups.get(t).visible)return!1}return!0}if("AnyOff"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(!this._groups.get(t).visible)return!0}return!1}if("AllOff"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(this._groups.get(t).visible)return!1}return!0}(0,n.warn)(`Unknown optional content policy ${e.policy}.`);return!0}(0,n.warn)(`Unknown group type ${e.type}.`);return!0}setVisibility(e,t=!0){this._groups.has(e)?this._groups.get(e).visible=!!t:(0,n.warn)(`Optional content group not found: ${e}`)}getOrder(){return this._groups.size?this._order?this._order.slice():Array.from(this._groups.keys()):null}getGroups(){return this._groups.size>0?(0,n.objectFromMap)(this._groups):null}getGroup(e){return this._groups.get(e)||null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFDataTransportStream=void 0;var n=i(2),s=i(1);t.PDFDataTransportStream=class PDFDataTransportStream{constructor(e,t){(0,n.assert)(t,'PDFDataTransportStream - missing required "pdfDataRangeTransport" argument.');this._queuedChunks=[];this._progressiveDone=e.progressiveDone||!1;this._contentDispositionFilename=e.contentDispositionFilename||null;const i=e.initialData;if(i?.length>0){const e=new Uint8Array(i).buffer;this._queuedChunks.push(e)}this._pdfDataRangeTransport=t;this._isStreamingSupported=!e.disableStream;this._isRangeSupported=!e.disableRange;this._contentLength=e.length;this._fullRequestReader=null;this._rangeReaders=[];this._pdfDataRangeTransport.addRangeListener(((e,t)=>{this._onReceiveData({begin:e,chunk:t})}));this._pdfDataRangeTransport.addProgressListener(((e,t)=>{this._onProgress({loaded:e,total:t})}));this._pdfDataRangeTransport.addProgressiveReadListener((e=>{this._onReceiveData({chunk:e})}));this._pdfDataRangeTransport.addProgressiveDoneListener((()=>{this._onProgressiveDone()}));this._pdfDataRangeTransport.transportReady()}_onReceiveData(e){const t=new Uint8Array(e.chunk).buffer;if(void 0===e.begin)this._fullRequestReader?this._fullRequestReader._enqueue(t):this._queuedChunks.push(t);else{const i=this._rangeReaders.some((function(i){if(i._begin!==e.begin)return!1;i._enqueue(t);return!0}));(0,n.assert)(i,"_onReceiveData - no `PDFDataTransportStreamRangeReader` instance found.")}}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}_onProgress(e){if(void 0===e.total){const t=this._rangeReaders[0];t?.onProgress&&t.onProgress({loaded:e.loaded})}else{const t=this._fullRequestReader;t?.onProgress&&t.onProgress({loaded:e.loaded,total:e.total})}}_onProgressiveDone(){this._fullRequestReader&&this._fullRequestReader.progressiveDone();this._progressiveDone=!0}_removeRangeReader(e){const t=this._rangeReaders.indexOf(e);t>=0&&this._rangeReaders.splice(t,1)}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFDataTransportStream.getFullReader can only be called once.");const e=this._queuedChunks;this._queuedChunks=null;return new PDFDataTransportStreamReader(this,e,this._progressiveDone,this._contentDispositionFilename)}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=new PDFDataTransportStreamRangeReader(this,e,t);this._pdfDataRangeTransport.requestDataRange(e,t);this._rangeReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeReaders.slice(0))t.cancel(e);this._pdfDataRangeTransport.abort()}};class PDFDataTransportStreamReader{constructor(e,t,i=!1,n=null){this._stream=e;this._done=i||!1;this._filename=(0,s.isPdfFile)(n)?n:null;this._queuedChunks=t||[];this._loaded=0;for(const e of this._queuedChunks)this._loaded+=e.byteLength;this._requests=[];this._headersReady=Promise.resolve();e._fullRequestReader=this;this.onProgress=null}_enqueue(e){if(!this._done){if(this._requests.length>0){this._requests.shift().resolve({value:e,done:!1})}else this._queuedChunks.push(e);this._loaded+=e.byteLength}}get headersReady(){return this._headersReady}get filename(){return this._filename}get isRangeSupported(){return this._stream._isRangeSupported}get isStreamingSupported(){return this._stream._isStreamingSupported}get contentLength(){return this._stream._contentLength}async read(){if(this._queuedChunks.length>0){return{value:this._queuedChunks.shift(),done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}progressiveDone(){this._done||(this._done=!0)}}class PDFDataTransportStreamRangeReader{constructor(e,t,i){this._stream=e;this._begin=t;this._end=i;this._queuedChunk=null;this._requests=[];this._done=!1;this.onProgress=null}_enqueue(e){if(!this._done){if(0===this._requests.length)this._queuedChunk=e;else{this._requests.shift().resolve({value:e,done:!1});for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}this._done=!0;this._stream._removeRangeReader(this)}}get isStreamingSupported(){return!1}async read(){if(this._queuedChunk){const e=this._queuedChunk;this._queuedChunk=null;return{value:e,done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._stream._removeRangeReader(this)}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XfaText=void 0;class XfaText{static textContent(e){const t=[],i={items:t,styles:Object.create(null)};!function walk(e){if(!e)return;let i=null;const n=e.name;if("#text"===n)i=e.value;else{if(!XfaText.shouldBuildText(n))return;e?.attributes?.textContent?i=e.attributes.textContent:e.value&&(i=e.value)}null!==i&&t.push({str:i});if(e.children)for(const t of e.children)walk(t)}(e);return i}static shouldBuildText(e){return!("textarea"===e||"input"===e||"option"===e||"select"===e)}}t.XfaText=XfaText},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.AnnotationLayer=void 0;var n=i(2),s=i(1),r=i(9),a=i(19),o=i(20);const l=1e3,c=new WeakSet;class AnnotationElementFactory{static create(e){switch(e.data.annotationType){case n.AnnotationType.LINK:return new LinkAnnotationElement(e);case n.AnnotationType.TEXT:return new TextAnnotationElement(e);case n.AnnotationType.WIDGET:switch(e.data.fieldType){case"Tx":return new TextWidgetAnnotationElement(e);case"Btn":return e.data.radioButton?new RadioButtonWidgetAnnotationElement(e):e.data.checkBox?new CheckboxWidgetAnnotationElement(e):new PushButtonWidgetAnnotationElement(e);case"Ch":return new ChoiceWidgetAnnotationElement(e)}return new WidgetAnnotationElement(e);case n.AnnotationType.POPUP:return new PopupAnnotationElement(e);case n.AnnotationType.FREETEXT:return new FreeTextAnnotationElement(e);case n.AnnotationType.LINE:return new LineAnnotationElement(e);case n.AnnotationType.SQUARE:return new SquareAnnotationElement(e);case n.AnnotationType.CIRCLE:return new CircleAnnotationElement(e);case n.AnnotationType.POLYLINE:return new PolylineAnnotationElement(e);case n.AnnotationType.CARET:return new CaretAnnotationElement(e);case n.AnnotationType.INK:return new InkAnnotationElement(e);case n.AnnotationType.POLYGON:return new PolygonAnnotationElement(e);case n.AnnotationType.HIGHLIGHT:return new HighlightAnnotationElement(e);case n.AnnotationType.UNDERLINE:return new UnderlineAnnotationElement(e);case n.AnnotationType.SQUIGGLY:return new SquigglyAnnotationElement(e);case n.AnnotationType.STRIKEOUT:return new StrikeOutAnnotationElement(e);case n.AnnotationType.STAMP:return new StampAnnotationElement(e);case n.AnnotationType.FILEATTACHMENT:return new FileAttachmentAnnotationElement(e);default:return new AnnotationElement(e)}}}class AnnotationElement{constructor(e,{isRenderable:t=!1,ignoreBorder:i=!1,createQuadrilaterals:n=!1}={}){this.isRenderable=t;this.data=e.data;this.layer=e.layer;this.page=e.page;this.viewport=e.viewport;this.linkService=e.linkService;this.downloadManager=e.downloadManager;this.imageResourcesPath=e.imageResourcesPath;this.renderForms=e.renderForms;this.svgFactory=e.svgFactory;this.annotationStorage=e.annotationStorage;this.enableScripting=e.enableScripting;this.hasJSActions=e.hasJSActions;this._fieldObjects=e.fieldObjects;this._mouseState=e.mouseState;t&&(this.container=this._createContainer(i));n&&(this.quadrilaterals=this._createQuadrilaterals(i))}_createContainer(e=!1){const t=this.data,i=this.page,s=this.viewport,r=document.createElement("section");let a=t.rect[2]-t.rect[0],o=t.rect[3]-t.rect[1];r.setAttribute("data-annotation-id",t.id);const l=n.Util.normalizeRect([t.rect[0],i.view[3]-t.rect[1]+i.view[1],t.rect[2],i.view[3]-t.rect[3]+i.view[1]]);if(t.hasOwnCanvas){const e=s.transform.slice(),[t,i]=n.Util.singularValueDecompose2dScale(e);a=Math.ceil(a*t);o=Math.ceil(o*i);l[0]*=t;l[1]*=i;for(let t=0;t<4;t++)e[t]=Math.sign(e[t]);r.style.transform=`matrix(${e.join(",")})`}else r.style.transform=`matrix(${s.transform.join(",")})`;r.style.transformOrigin=`${-l[0]}px ${-l[1]}px`;if(!e&&t.borderStyle.width>0){r.style.borderWidth=`${t.borderStyle.width}px`;if(t.borderStyle.style!==n.AnnotationBorderStyleType.UNDERLINE){a-=2*t.borderStyle.width;o-=2*t.borderStyle.width}const e=t.borderStyle.horizontalCornerRadius,i=t.borderStyle.verticalCornerRadius;if(e>0||i>0){const t=`${e}px / ${i}px`;r.style.borderRadius=t}switch(t.borderStyle.style){case n.AnnotationBorderStyleType.SOLID:r.style.borderStyle="solid";break;case n.AnnotationBorderStyleType.DASHED:r.style.borderStyle="dashed";break;case n.AnnotationBorderStyleType.BEVELED:(0,n.warn)("Unimplemented border style: beveled");break;case n.AnnotationBorderStyleType.INSET:(0,n.warn)("Unimplemented border style: inset");break;case n.AnnotationBorderStyleType.UNDERLINE:r.style.borderBottomStyle="solid"}t.borderColor||t.color||null?r.style.borderColor=n.Util.makeHexColor(0|t.color[0],0|t.color[1],0|t.color[2]):r.style.borderWidth=0}r.style.left=`${l[0]}px`;r.style.top=`${l[1]}px`;if(t.hasOwnCanvas)r.style.width=r.style.height="auto";else{r.style.width=`${a}px`;r.style.height=`${o}px`}return r}_createQuadrilaterals(e=!1){if(!this.data.quadPoints)return null;const t=[],i=this.data.rect;for(const i of this.data.quadPoints){this.data.rect=[i[2].x,i[2].y,i[1].x,i[1].y];t.push(this._createContainer(e))}this.data.rect=i;return t}_createPopup(e,t){let i=this.container;if(this.quadrilaterals){e=e||this.quadrilaterals;i=this.quadrilaterals[0]}if(!e){(e=document.createElement("div")).style.height=i.style.height;e.style.width=i.style.width;i.appendChild(e)}const n=new PopupElement({container:i,trigger:e,color:t.color,titleObj:t.titleObj,modificationDate:t.modificationDate,contentsObj:t.contentsObj,richText:t.richText,hideWrapper:!0}).render();n.style.left=i.style.width;i.appendChild(n)}_renderQuadrilaterals(e){for(const t of this.quadrilaterals)t.className=e;return this.quadrilaterals}render(){(0,n.unreachable)("Abstract method `AnnotationElement.render` called")}_getElementsByName(e,t=null){const i=[];if(this._fieldObjects){const s=this._fieldObjects[e];if(s)for(const{page:e,id:r,exportValues:a}of s){if(-1===e)continue;if(r===t)continue;const s="string"==typeof a?a:null,o=document.getElementById(r);!o||c.has(o)?i.push({id:r,exportValue:s,domElement:o}):(0,n.warn)(`_getElementsByName - element not allowed: ${r}`)}return i}for(const n of document.getElementsByName(e)){const{id:e,exportValue:s}=n;e!==t&&(c.has(n)&&i.push({id:e,exportValue:s,domElement:n}))}return i}static get platform(){const e="undefined"!=typeof navigator?navigator.platform:"";return(0,n.shadow)(this,"platform",{isWin:e.includes("Win"),isMac:e.includes("Mac")})}}class LinkAnnotationElement extends AnnotationElement{constructor(e,t=null){super(e,{isRenderable:!!(e.data.url||e.data.dest||e.data.action||e.data.isTooltipOnly||e.data.resetForm||e.data.actions&&(e.data.actions.Action||e.data.actions["Mouse Up"]||e.data.actions["Mouse Down"])),ignoreBorder:!!t?.ignoreBorder,createQuadrilaterals:!0})}render(){const{data:e,linkService:t}=this,i=document.createElement("a");if(e.url){t.addLinkAttributes||(0,n.warn)("LinkAnnotationElement.render - missing `addLinkAttributes`-method on the `linkService`-instance.");t.addLinkAttributes?.(i,e.url,e.newWindow)}else if(e.action)this._bindNamedAction(i,e.action);else if(e.dest)this._bindLink(i,e.dest);else{let t=!1;if(e.actions&&(e.actions.Action||e.actions["Mouse Up"]||e.actions["Mouse Down"])&&this.enableScripting&&this.hasJSActions){t=!0;this._bindJSAction(i,e)}e.resetForm?this._bindResetFormAction(i,e.resetForm):t||this._bindLink(i,"")}if(this.quadrilaterals)return this._renderQuadrilaterals("linkAnnotation").map(((e,t)=>{const n=0===t?i:i.cloneNode();e.appendChild(n);return e}));this.container.className="linkAnnotation";this.container.appendChild(i);return this.container}_bindLink(e,t){e.href=this.linkService.getDestinationHash(t);e.onclick=()=>{t&&this.linkService.goToDestination(t);return!1};(t||""===t)&&(e.className="internalLink")}_bindNamedAction(e,t){e.href=this.linkService.getAnchorUrl("");e.onclick=()=>{this.linkService.executeNamedAction(t);return!1};e.className="internalLink"}_bindJSAction(e,t){e.href=this.linkService.getAnchorUrl("");const i=new Map([["Action","onclick"],["Mouse Up","onmouseup"],["Mouse Down","onmousedown"]]);for(const n of Object.keys(t.actions)){const s=i.get(n);s&&(e[s]=()=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t.id,name:n}});return!1})}e.onclick||(e.onclick=()=>!1);e.className="internalLink"}_bindResetFormAction(e,t){const i=e.onclick;i||(e.href=this.linkService.getAnchorUrl(""));e.className="internalLink";if(this._fieldObjects)e.onclick=()=>{i&&i();const{fields:e,refs:n,include:s}=t,r=[];if(0!==e.length||0!==n.length){const t=new Set(n);for(const i of e){const e=this._fieldObjects[i]||[];for(const{id:i}of e)t.add(i)}for(const e of Object.values(this._fieldObjects))for(const i of e)t.has(i.id)===s&&r.push(i)}else for(const e of Object.values(this._fieldObjects))r.push(...e);const a=this.annotationStorage,o=[];for(const e of r){const{id:t}=e;o.push(t);switch(e.type){case"text":{const i=e.defaultValue||"";a.setValue(t,{value:i,valueAsString:i});break}case"checkbox":case"radiobutton":{const i=e.defaultValue===e.exportValues;a.setValue(t,{value:i});break}case"combobox":case"listbox":{const i=e.defaultValue||"";a.setValue(t,{value:i});break}default:continue}const i=document.getElementById(t);i&&c.has(i)&&i.dispatchEvent(new Event("resetform"))}this.enableScripting&&this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:"app",ids:o,name:"ResetForm"}});return!1};else{(0,n.warn)('_bindResetFormAction - "resetForm" action not supported, ensure that the `fieldObjects` parameter is provided.');i||(e.onclick=()=>!1)}}}class TextAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str)})}render(){this.container.className="textAnnotation";const e=document.createElement("img");e.style.height=this.container.style.height;e.style.width=this.container.style.width;e.src=this.imageResourcesPath+"annotation-"+this.data.name.toLowerCase()+".svg";e.alt="[{{type}} Annotation]";e.dataset.l10nId="text_annotation_type";e.dataset.l10nArgs=JSON.stringify({type:this.data.name});this.data.hasPopup||this._createPopup(e,this.data);this.container.appendChild(e);return this.container}}class WidgetAnnotationElement extends AnnotationElement{render(){this.data.alternativeText&&(this.container.title=this.data.alternativeText);return this.container}_getKeyModifier(e){const{isWin:t,isMac:i}=AnnotationElement.platform;return t&&e.ctrlKey||i&&e.metaKey}_setEventListener(e,t,i,n){t.includes("mouse")?e.addEventListener(t,(e=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:this.data.id,name:i,value:n(e),shift:e.shiftKey,modifier:this._getKeyModifier(e)}})})):e.addEventListener(t,(e=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:this.data.id,name:i,value:e.target.checked}})}))}_setEventListeners(e,t,i){for(const[n,s]of t)("Action"===s||this.data.actions?.[s])&&this._setEventListener(e,n,s,i)}_setBackgroundColor(e){const t=this.data.backgroundColor||null;e.style.backgroundColor=null===t?"transparent":n.Util.makeHexColor(t[0],t[1],t[2])}_dispatchEventFromSandbox(e,t){const setColor=(e,t,i)=>{const n=i.detail[e];i.target.style[t]=a.ColorConverters[`${n[0]}_HTML`](n.slice(1))},i={display:e=>{const t=e.detail.display%2==1;e.target.style.visibility=t?"hidden":"visible";this.annotationStorage.setValue(this.data.id,{hidden:t,print:0===e.detail.display||3===e.detail.display})},print:e=>{this.annotationStorage.setValue(this.data.id,{print:e.detail.print})},hidden:e=>{e.target.style.visibility=e.detail.hidden?"hidden":"visible";this.annotationStorage.setValue(this.data.id,{hidden:e.detail.hidden})},focus:e=>{setTimeout((()=>e.target.focus({preventScroll:!1})),0)},userName:e=>{e.target.title=e.detail.userName},readonly:e=>{e.detail.readonly?e.target.setAttribute("readonly",""):e.target.removeAttribute("readonly")},required:e=>{e.detail.required?e.target.setAttribute("required",""):e.target.removeAttribute("required")},bgColor:e=>{setColor("bgColor","backgroundColor",e)},fillColor:e=>{setColor("fillColor","backgroundColor",e)},fgColor:e=>{setColor("fgColor","color",e)},textColor:e=>{setColor("textColor","color",e)},borderColor:e=>{setColor("borderColor","borderColor",e)},strokeColor:e=>{setColor("strokeColor","borderColor",e)}};for(const n of Object.keys(t.detail)){const s=e[n]||i[n];s&&s(t)}}}class TextWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderForms||!e.data.hasAppearance&&!!e.data.fieldValue})}setPropertyOnSiblings(e,t,i,n){const s=this.annotationStorage;for(const r of this._getElementsByName(e.name,e.id)){r.domElement&&(r.domElement[t]=i);s.setValue(r.id,{[n]:i})}}render(){const e=this.annotationStorage,t=this.data.id;this.container.className="textWidgetAnnotation";let i=null;if(this.renderForms){const n=e.getValue(t,{value:this.data.fieldValue,valueAsString:this.data.fieldValue}),s=n.valueAsString||n.value||"",r={userValue:null,formattedValue:null,beforeInputSelectionRange:null,beforeInputValue:null};if(this.data.multiLine){i=document.createElement("textarea");i.textContent=s}else{i=document.createElement("input");i.type="text";i.setAttribute("value",s)}c.add(i);i.disabled=this.data.readOnly;i.name=this.data.fieldName;i.tabIndex=l;r.userValue=s;i.setAttribute("id",t);i.addEventListener("input",(n=>{e.setValue(t,{value:n.target.value});this.setPropertyOnSiblings(i,"value",n.target.value,"value")}));i.addEventListener("resetform",(e=>{const t=this.data.defaultFieldValue||"";i.value=r.userValue=t;delete r.formattedValue}));let blurListener=e=>{r.formattedValue&&(e.target.value=r.formattedValue);e.target.scrollLeft=0;r.beforeInputSelectionRange=null};if(this.enableScripting&&this.hasJSActions){i.addEventListener("focus",(e=>{r.userValue&&(e.target.value=r.userValue)}));i.addEventListener("updatefromsandbox",(i=>{const n={value(i){r.userValue=i.detail.value||"";e.setValue(t,{value:r.userValue.toString()});r.formattedValue||(i.target.value=r.userValue)},valueAsString(i){r.formattedValue=i.detail.valueAsString||"";i.target!==document.activeElement&&(i.target.value=r.formattedValue);e.setValue(t,{formattedValue:r.formattedValue})},selRange(e){const[t,i]=e.detail.selRange;t>=0&&i<e.target.value.length&&e.target.setSelectionRange(t,i)}};this._dispatchEventFromSandbox(n,i)}));i.addEventListener("keydown",(e=>{r.beforeInputValue=e.target.value;let i=-1;"Escape"===e.key?i=0:"Enter"===e.key?i=2:"Tab"===e.key&&(i=3);if(-1!==i){r.userValue=e.target.value;this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:e.target.value,willCommit:!0,commitKey:i,selStart:e.target.selectionStart,selEnd:e.target.selectionEnd}})}}));const n=blurListener;blurListener=null;i.addEventListener("blur",(e=>{if(this._mouseState.isDown){r.userValue=e.target.value;this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:e.target.value,willCommit:!0,commitKey:1,selStart:e.target.selectionStart,selEnd:e.target.selectionEnd}})}n(e)}));i.addEventListener("mousedown",(e=>{r.beforeInputValue=e.target.value;r.beforeInputSelectionRange=null}));i.addEventListener("keyup",(e=>{e.target.selectionStart===e.target.selectionEnd&&(r.beforeInputSelectionRange=null)}));i.addEventListener("select",(e=>{r.beforeInputSelectionRange=[e.target.selectionStart,e.target.selectionEnd]}));this.data.actions?.Keystroke&&i.addEventListener("input",(e=>{let i=-1,n=-1;r.beforeInputSelectionRange&&([i,n]=r.beforeInputSelectionRange);this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:r.beforeInputValue,change:e.data,willCommit:!1,selStart:i,selEnd:n}})}));this._setEventListeners(i,[["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.value))}blurListener&&i.addEventListener("blur",blurListener);null!==this.data.maxLen&&(i.maxLength=this.data.maxLen);if(this.data.comb){const e=(this.data.rect[2]-this.data.rect[0])/this.data.maxLen;i.classList.add("comb");i.style.letterSpacing=`calc(${e}px - 1ch)`}}else{i=document.createElement("div");i.textContent=this.data.fieldValue;i.style.verticalAlign="middle";i.style.display="table-cell"}this._setTextStyle(i);this._setBackgroundColor(i);this.container.appendChild(i);return this.container}_setTextStyle(e){const t=["left","center","right"],{fontSize:i,fontColor:s}=this.data.defaultAppearanceData,r=e.style;i&&(r.fontSize=`${i}px`);r.color=n.Util.makeHexColor(s[0],s[1],s[2]);null!==this.data.textAlignment&&(r.textAlign=t[this.data.textAlignment])}}class CheckboxWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderForms})}render(){const e=this.annotationStorage,t=this.data,i=t.id;let n=e.getValue(i,{value:t.exportValue===t.fieldValue}).value;if("string"==typeof n){n="Off"!==n;e.setValue(i,{value:n})}this.container.className="buttonWidgetAnnotation checkBox";const s=document.createElement("input");c.add(s);s.disabled=t.readOnly;s.type="checkbox";s.name=t.fieldName;n&&s.setAttribute("checked",!0);s.setAttribute("id",i);s.setAttribute("exportValue",t.exportValue);s.tabIndex=l;s.addEventListener("change",(n=>{const{name:s,checked:r}=n.target;for(const n of this._getElementsByName(s,i)){const i=r&&n.exportValue===t.exportValue;n.domElement&&(n.domElement.checked=i);e.setValue(n.id,{value:i})}e.setValue(i,{value:r})}));s.addEventListener("resetform",(e=>{const i=t.defaultFieldValue||"Off";e.target.checked=i===t.exportValue}));if(this.enableScripting&&this.hasJSActions){s.addEventListener("updatefromsandbox",(t=>{const n={value(t){t.target.checked="Off"!==t.detail.value;e.setValue(i,{value:t.target.checked})}};this._dispatchEventFromSandbox(n,t)}));this._setEventListeners(s,[["change","Validate"],["change","Action"],["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.checked))}this._setBackgroundColor(s);this.container.appendChild(s);return this.container}}class RadioButtonWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderForms})}render(){this.container.className="buttonWidgetAnnotation radioButton";const e=this.annotationStorage,t=this.data,i=t.id;let n=e.getValue(i,{value:t.fieldValue===t.buttonValue}).value;if("string"==typeof n){n=n!==t.buttonValue;e.setValue(i,{value:n})}const s=document.createElement("input");c.add(s);s.disabled=t.readOnly;s.type="radio";s.name=t.fieldName;n&&s.setAttribute("checked",!0);s.setAttribute("id",i);s.tabIndex=l;s.addEventListener("change",(t=>{const{name:n,checked:s}=t.target;for(const t of this._getElementsByName(n,i))e.setValue(t.id,{value:!1});e.setValue(i,{value:s})}));s.addEventListener("resetform",(e=>{const i=t.defaultFieldValue;e.target.checked=null!=i&&i===t.buttonValue}));if(this.enableScripting&&this.hasJSActions){const n=t.buttonValue;s.addEventListener("updatefromsandbox",(t=>{const s={value:t=>{const s=n===t.detail.value;for(const n of this._getElementsByName(t.target.name)){const t=s&&n.id===i;n.domElement&&(n.domElement.checked=t);e.setValue(n.id,{value:t})}}};this._dispatchEventFromSandbox(s,t)}));this._setEventListeners(s,[["change","Validate"],["change","Action"],["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.checked))}this._setBackgroundColor(s);this.container.appendChild(s);return this.container}}class PushButtonWidgetAnnotationElement extends LinkAnnotationElement{constructor(e){super(e,{ignoreBorder:e.data.hasAppearance})}render(){const e=super.render();e.className="buttonWidgetAnnotation pushButton";this.data.alternativeText&&(e.title=this.data.alternativeText);return e}}class ChoiceWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderForms})}render(){this.container.className="choiceWidgetAnnotation";const e=this.annotationStorage,t=this.data.id;e.getValue(t,{value:this.data.fieldValue.length>0?this.data.fieldValue[0]:void 0});let{fontSize:i}=this.data.defaultAppearanceData;i||(i=9);const n=`calc(${i}px * var(--zoom-factor))`,s=document.createElement("select");c.add(s);s.disabled=this.data.readOnly;s.name=this.data.fieldName;s.setAttribute("id",t);s.tabIndex=l;s.style.fontSize=`${i}px`;if(!this.data.combo){s.size=this.data.options.length;this.data.multiSelect&&(s.multiple=!0)}s.addEventListener("resetform",(e=>{const t=this.data.defaultFieldValue;for(const e of s.options)e.selected=e.value===t}));for(const e of this.data.options){const t=document.createElement("option");t.textContent=e.displayValue;t.value=e.exportValue;this.data.combo&&(t.style.fontSize=n);this.data.fieldValue.includes(e.exportValue)&&t.setAttribute("selected",!0);s.appendChild(t)}const getValue=(e,t)=>{const i=t?"value":"textContent",n=e.target.options;return e.target.multiple?Array.prototype.filter.call(n,(e=>e.selected)).map((e=>e[i])):-1===n.selectedIndex?null:n[n.selectedIndex][i]},getItems=e=>{const t=e.target.options;return Array.prototype.map.call(t,(e=>({displayValue:e.textContent,exportValue:e.value})))};if(this.enableScripting&&this.hasJSActions){s.addEventListener("updatefromsandbox",(i=>{const n={value(i){const n=i.detail.value,r=new Set(Array.isArray(n)?n:[n]);for(const e of s.options)e.selected=r.has(e.value);e.setValue(t,{value:getValue(i,!0)})},multipleSelection(e){s.multiple=!0},remove(i){const n=s.options,r=i.detail.remove;n[r].selected=!1;s.remove(r);if(n.length>0){-1===Array.prototype.findIndex.call(n,(e=>e.selected))&&(n[0].selected=!0)}e.setValue(t,{value:getValue(i,!0),items:getItems(i)})},clear(i){for(;0!==s.length;)s.remove(0);e.setValue(t,{value:null,items:[]})},insert(i){const{index:n,displayValue:r,exportValue:a}=i.detail.insert,o=document.createElement("option");o.textContent=r;o.value=a;s.insertBefore(o,s.children[n]);e.setValue(t,{value:getValue(i,!0),items:getItems(i)})},items(i){const{items:n}=i.detail;for(;0!==s.length;)s.remove(0);for(const e of n){const{displayValue:t,exportValue:i}=e,n=document.createElement("option");n.textContent=t;n.value=i;s.appendChild(n)}s.options.length>0&&(s.options[0].selected=!0);e.setValue(t,{value:getValue(i,!0),items:getItems(i)})},indices(i){const n=new Set(i.detail.indices);for(const e of i.target.options)e.selected=n.has(e.index);e.setValue(t,{value:getValue(i,!0)})},editable(e){e.target.disabled=!e.detail.editable}};this._dispatchEventFromSandbox(n,i)}));s.addEventListener("input",(i=>{const n=getValue(i,!0),s=getValue(i,!1);e.setValue(t,{value:n});this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:s,changeEx:n,willCommit:!0,commitKey:1,keyDown:!1}})}));this._setEventListeners(s,[["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"],["input","Action"]],(e=>e.target.checked))}else s.addEventListener("input",(function(i){e.setValue(t,{value:getValue(i)})}));this._setBackgroundColor(s);this.container.appendChild(s);return this.container}}class PopupAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str)})}render(){this.container.className="popupAnnotation";if(["Line","Square","Circle","PolyLine","Polygon","Ink"].includes(this.data.parentType))return this.container;const e=`[data-annotation-id="${this.data.parentId}"]`,t=this.layer.querySelectorAll(e);if(0===t.length)return this.container;const i=new PopupElement({container:this.container,trigger:Array.from(t),color:this.data.color,titleObj:this.data.titleObj,modificationDate:this.data.modificationDate,contentsObj:this.data.contentsObj,richText:this.data.richText}),s=this.page,r=n.Util.normalizeRect([this.data.parentRect[0],s.view[3]-this.data.parentRect[1]+s.view[1],this.data.parentRect[2],s.view[3]-this.data.parentRect[3]+s.view[1]]),a=r[0]+this.data.parentRect[2]-this.data.parentRect[0],o=r[1];this.container.style.transformOrigin=`${-a}px ${-o}px`;this.container.style.left=`${a}px`;this.container.style.top=`${o}px`;this.container.appendChild(i.render());return this.container}}class PopupElement{constructor(e){this.container=e.container;this.trigger=e.trigger;this.color=e.color;this.titleObj=e.titleObj;this.modificationDate=e.modificationDate;this.contentsObj=e.contentsObj;this.richText=e.richText;this.hideWrapper=e.hideWrapper||!1;this.pinned=!1}render(){const e=document.createElement("div");e.className="popupWrapper";this.hideElement=this.hideWrapper?e:this.container;this.hideElement.hidden=!0;const t=document.createElement("div");t.className="popup";const i=this.color;if(i){const e=.7*(255-i[0])+i[0],s=.7*(255-i[1])+i[1],r=.7*(255-i[2])+i[2];t.style.backgroundColor=n.Util.makeHexColor(0|e,0|s,0|r)}const r=document.createElement("h1");r.dir=this.titleObj.dir;r.textContent=this.titleObj.str;t.appendChild(r);const a=s.PDFDateString.toDateObject(this.modificationDate);if(a){const e=document.createElement("span");e.className="popupDate";e.textContent="{{date}}, {{time}}";e.dataset.l10nId="annotation_date_string";e.dataset.l10nArgs=JSON.stringify({date:a.toLocaleDateString(),time:a.toLocaleTimeString()});t.appendChild(e)}if(!this.richText?.str||this.contentsObj?.str&&this.contentsObj.str!==this.richText.str){const e=this._formatContents(this.contentsObj);t.appendChild(e)}else{o.XfaLayer.render({xfaHtml:this.richText.html,intent:"richText",div:t});t.lastChild.className="richText popupContent"}Array.isArray(this.trigger)||(this.trigger=[this.trigger]);for(const e of this.trigger){e.addEventListener("click",this._toggle.bind(this));e.addEventListener("mouseover",this._show.bind(this,!1));e.addEventListener("mouseout",this._hide.bind(this,!1))}t.addEventListener("click",this._hide.bind(this,!0));e.appendChild(t);return e}_formatContents({str:e,dir:t}){const i=document.createElement("p");i.className="popupContent";i.dir=t;const n=e.split(/(?:\r\n?|\n)/);for(let e=0,t=n.length;e<t;++e){const s=n[e];i.appendChild(document.createTextNode(s));e<t-1&&i.appendChild(document.createElement("br"))}return i}_toggle(){this.pinned?this._hide(!0):this._show(!0)}_show(e=!1){e&&(this.pinned=!0);if(this.hideElement.hidden){this.hideElement.hidden=!1;this.container.style.zIndex+=1}}_hide(e=!0){e&&(this.pinned=!1);if(!this.hideElement.hidden&&!this.pinned){this.hideElement.hidden=!0;this.container.style.zIndex-=1}}}class FreeTextAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="freeTextAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class LineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="lineAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=this.svgFactory.createElement("svg:line");s.setAttribute("x1",e.rect[2]-e.lineCoordinates[0]);s.setAttribute("y1",e.rect[3]-e.lineCoordinates[1]);s.setAttribute("x2",e.rect[2]-e.lineCoordinates[2]);s.setAttribute("y2",e.rect[3]-e.lineCoordinates[3]);s.setAttribute("stroke-width",e.borderStyle.width||1);s.setAttribute("stroke","transparent");s.setAttribute("fill","transparent");n.appendChild(s);this.container.append(n);this._createPopup(s,e);return this.container}}class SquareAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="squareAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=e.borderStyle.width,r=this.svgFactory.createElement("svg:rect");r.setAttribute("x",s/2);r.setAttribute("y",s/2);r.setAttribute("width",t-s);r.setAttribute("height",i-s);r.setAttribute("stroke-width",s||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","transparent");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class CircleAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="circleAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=e.borderStyle.width,r=this.svgFactory.createElement("svg:ellipse");r.setAttribute("cx",t/2);r.setAttribute("cy",i/2);r.setAttribute("rx",t/2-s/2);r.setAttribute("ry",i/2-s/2);r.setAttribute("stroke-width",s||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","transparent");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class PolylineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0});this.containerClassName="polylineAnnotation";this.svgElementName="svg:polyline"}render(){this.container.className=this.containerClassName;const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i);let s=[];for(const t of e.vertices){const i=t.x-e.rect[0],n=e.rect[3]-t.y;s.push(i+","+n)}s=s.join(" ");const r=this.svgFactory.createElement(this.svgElementName);r.setAttribute("points",s);r.setAttribute("stroke-width",e.borderStyle.width||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","transparent");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class PolygonAnnotationElement extends PolylineAnnotationElement{constructor(e){super(e);this.containerClassName="polygonAnnotation";this.svgElementName="svg:polygon"}}class CaretAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="caretAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class InkAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0});this.containerClassName="inkAnnotation";this.svgElementName="svg:polyline"}render(){this.container.className=this.containerClassName;const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i);for(const t of e.inkLists){let i=[];for(const n of t){const t=n.x-e.rect[0],s=e.rect[3]-n.y;i.push(`${t},${s}`)}i=i.join(" ");const s=this.svgFactory.createElement(this.svgElementName);s.setAttribute("points",i);s.setAttribute("stroke-width",e.borderStyle.width||1);s.setAttribute("stroke","transparent");s.setAttribute("fill","transparent");this._createPopup(s,e);n.appendChild(s)}this.container.append(n);return this.container}}class HighlightAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("highlightAnnotation");this.container.className="highlightAnnotation";return this.container}}class UnderlineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("underlineAnnotation");this.container.className="underlineAnnotation";return this.container}}class SquigglyAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("squigglyAnnotation");this.container.className="squigglyAnnotation";return this.container}}class StrikeOutAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("strikeoutAnnotation");this.container.className="strikeoutAnnotation";return this.container}}class StampAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.titleObj?.str||e.data.contentsObj?.str||e.data.richText?.str),ignoreBorder:!0})}render(){this.container.className="stampAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class FileAttachmentAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!0});const{filename:t,content:i}=this.data.file;this.filename=(0,s.getFilenameFromUrl)(t);this.content=i;this.linkService.eventBus?.dispatch("fileattachmentannotation",{source:this,id:(0,n.stringToPDFString)(t),filename:t,content:i})}render(){this.container.className="fileAttachmentAnnotation";const e=document.createElement("div");e.style.height=this.container.style.height;e.style.width=this.container.style.width;e.addEventListener("dblclick",this._download.bind(this));!this.data.hasPopup&&(this.data.titleObj?.str||this.data.contentsObj?.str||this.data.richText)&&this._createPopup(e,this.data);this.container.appendChild(e);return this.container}_download(){this.downloadManager?.openOrDownloadData(this.container,this.content,this.filename)}}t.AnnotationLayer=class AnnotationLayer{static render(e){const t=[],i=[];for(const s of e.annotations)s&&(s.annotationType!==n.AnnotationType.POPUP?t.push(s):i.push(s));i.length&&t.push(...i);const a=e.div;for(const i of t){const t=AnnotationElementFactory.create({data:i,layer:a,page:e.page,viewport:e.viewport,linkService:e.linkService,downloadManager:e.downloadManager,imageResourcesPath:e.imageResourcesPath||"",renderForms:!1!==e.renderForms,svgFactory:new s.DOMSVGFactory,annotationStorage:e.annotationStorage||new r.AnnotationStorage,enableScripting:e.enableScripting,hasJSActions:e.hasJSActions,fieldObjects:e.fieldObjects,mouseState:e.mouseState||{isDown:!1}});if(t.isRenderable){const e=t.render();i.hidden&&(e.style.visibility="hidden");if(Array.isArray(e))for(const t of e)a.appendChild(t);else t instanceof PopupAnnotationElement?a.prepend(e):a.appendChild(e)}}this.#a(a,e.annotationCanvasMap)}static update(e){const{page:t,viewport:i,annotations:s,annotationCanvasMap:r,div:a}=e,o=i.transform,l=`matrix(${o.join(",")})`;let c,h;for(const e of s){const i=a.querySelectorAll(`[data-annotation-id="${e.id}"]`);if(i)for(const s of i)if(e.hasOwnCanvas){const i=n.Util.normalizeRect([e.rect[0],t.view[3]-e.rect[1]+t.view[1],e.rect[2],t.view[3]-e.rect[3]+t.view[1]]);if(!h){c=Math.abs(o[0]||o[1]);const e=o.slice();for(let t=0;t<4;t++)e[t]=Math.sign(e[t]);h=`matrix(${e.join(",")})`}const r=i[0]*c,a=i[1]*c;s.style.left=`${r}px`;s.style.top=`${a}px`;s.style.transformOrigin=`${-r}px ${-a}px`;s.style.transform=h}else s.style.transform=l}this.#a(a,r);a.hidden=!1}static#a(e,t){if(t){for(const[i,n]of t){const t=e.querySelector(`[data-annotation-id="${i}"]`);if(!t)continue;const{firstChild:s}=t;"CANVAS"===s.nodeName?t.replaceChild(n,s):t.insertBefore(n,s)}t.clear()}}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ColorConverters=void 0;function makeColorComp(e){return Math.floor(255*Math.max(0,Math.min(1,e))).toString(16).padStart(2,"0")}t.ColorConverters=class ColorConverters{static CMYK_G([e,t,i,n]){return["G",1-Math.min(1,.3*e+.59*i+.11*t+n)]}static G_CMYK([e]){return["CMYK",0,0,0,1-e]}static G_RGB([e]){return["RGB",e,e,e]}static G_HTML([e]){const t=makeColorComp(e);return`#${t}${t}${t}`}static RGB_G([e,t,i]){return["G",.3*e+.59*t+.11*i]}static RGB_HTML([e,t,i]){return`#${makeColorComp(e)}${makeColorComp(t)}${makeColorComp(i)}`}static T_HTML(){return"#00000000"}static CMYK_RGB([e,t,i,n]){return["RGB",1-Math.min(1,e+n),1-Math.min(1,i+n),1-Math.min(1,t+n)]}static CMYK_HTML(e){return this.RGB_HTML(this.CMYK_RGB(e))}static RGB_CMYK([e,t,i]){const n=1-e,s=1-t,r=1-i;return["CMYK",n,s,r,Math.min(n,s,r)]}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XfaLayer=void 0;var n=i(2),s=i(17);t.XfaLayer=class XfaLayer{static setupStorage(e,t,i,n,s){const r=n.getValue(t,{value:null});switch(i.name){case"textarea":null!==r.value&&(e.textContent=r.value);if("print"===s)break;e.addEventListener("input",(e=>{n.setValue(t,{value:e.target.value})}));break;case"input":if("radio"===i.attributes.type||"checkbox"===i.attributes.type){r.value===i.attributes.xfaOn?e.setAttribute("checked",!0):r.value===i.attributes.xfaOff&&e.removeAttribute("checked");if("print"===s)break;e.addEventListener("change",(e=>{n.setValue(t,{value:e.target.checked?e.target.getAttribute("xfaOn"):e.target.getAttribute("xfaOff")})}))}else{null!==r.value&&e.setAttribute("value",r.value);if("print"===s)break;e.addEventListener("input",(e=>{n.setValue(t,{value:e.target.value})}))}break;case"select":if(null!==r.value)for(const e of i.children)e.attributes.value===r.value&&(e.attributes.selected=!0);e.addEventListener("input",(e=>{const i=e.target.options,s=-1===i.selectedIndex?"":i[i.selectedIndex].value;n.setValue(t,{value:s})}))}}static setAttributes({html:e,element:t,storage:i=null,intent:s,linkService:r}){const{attributes:a}=t,o=e instanceof HTMLAnchorElement;"radio"===a.type&&(a.name=`${a.name}-${s}`);for(const[t,i]of Object.entries(a))if(null!=i&&"dataId"!==t)if("style"!==t)if("textContent"===t)e.textContent=i;else if("class"===t)i.length&&e.setAttribute(t,i.join(" "));else{if(o&&("href"===t||"newWindow"===t))continue;e.setAttribute(t,i)}else Object.assign(e.style,i);if(o){r.addLinkAttributes||(0,n.warn)("XfaLayer.setAttribute - missing `addLinkAttributes`-method on the `linkService`-instance.");r.addLinkAttributes?.(e,a.href,a.newWindow)}i&&a.dataId&&this.setupStorage(e,a.dataId,t,i)}static render(e){const t=e.annotationStorage,i=e.linkService,n=e.xfaHtml,r=e.intent||"display",a=document.createElement(n.name);n.attributes&&this.setAttributes({html:a,element:n,intent:r,linkService:i});const o=[[n,-1,a]],l=e.div;l.appendChild(a);if(e.viewport){const t=`matrix(${e.viewport.transform.join(",")})`;l.style.transform=t}"richText"!==r&&l.setAttribute("class","xfaLayer xfaFont");const c=[];for(;o.length>0;){const[e,n,a]=o[o.length-1];if(n+1===e.children.length){o.pop();continue}const l=e.children[++o[o.length-1][1]];if(null===l)continue;const{name:h}=l;if("#text"===h){const e=document.createTextNode(l.value);c.push(e);a.appendChild(e);continue}let d;d=l?.attributes?.xmlns?document.createElementNS(l.attributes.xmlns,h):document.createElement(h);a.appendChild(d);l.attributes&&this.setAttributes({html:d,element:l,storage:t,intent:r,linkService:i});if(l.children&&l.children.length>0)o.push([l,-1,d]);else if(l.value){const e=document.createTextNode(l.value);s.XfaText.shouldBuildText(h)&&c.push(e);d.appendChild(e)}}for(const e of l.querySelectorAll(".xfaNonInteractive input, .xfaNonInteractive textarea"))e.setAttribute("readOnly",!0);return{textDivs:c}}static update(e){const t=`matrix(${e.viewport.transform.join(",")})`;e.div.style.transform=t;e.div.hidden=!1}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.renderTextLayer=function renderTextLayer(e){const t=new TextLayerRenderTask({textContent:e.textContent,textContentStream:e.textContentStream,container:e.container,viewport:e.viewport,textDivs:e.textDivs,textContentItemsStr:e.textContentItemsStr,enhanceTextSelection:e.enhanceTextSelection});t._render(e.timeout);return t};var n=i(2);const s=30,r=new Map,a=/^\s+$/g;function appendText(e,t,i,o){const l=document.createElement("span"),c=e._enhanceTextSelection?{angle:0,canvasWidth:0,hasText:""!==t.str,hasEOL:t.hasEOL,originalTransform:null,paddingBottom:0,paddingLeft:0,paddingRight:0,paddingTop:0,scale:1}:{angle:0,canvasWidth:0,hasText:""!==t.str,hasEOL:t.hasEOL};e._textDivs.push(l);const h=n.Util.transform(e._viewport.transform,t.transform);let d=Math.atan2(h[1],h[0]);const u=i[t.fontName];u.vertical&&(d+=Math.PI/2);const p=Math.hypot(h[2],h[3]),g=p*function getAscent(e,t){const i=r.get(e);if(i)return i;t.save();t.font=`30px ${e}`;const n=t.measureText("");let a=n.fontBoundingBoxAscent,o=Math.abs(n.fontBoundingBoxDescent);if(a){t.restore();const i=a/(a+o);r.set(e,i);return i}t.strokeStyle="red";t.clearRect(0,0,s,s);t.strokeText("g",0,0);let l=t.getImageData(0,0,s,s).data;o=0;for(let e=l.length-1-3;e>=0;e-=4)if(l[e]>0){o=Math.ceil(e/4/s);break}t.clearRect(0,0,s,s);t.strokeText("A",0,s);l=t.getImageData(0,0,s,s).data;a=0;for(let e=0,t=l.length;e<t;e+=4)if(l[e]>0){a=s-Math.floor(e/4/s);break}t.restore();if(a){const t=a/(a+o);r.set(e,t);return t}r.set(e,.8);return.8}(u.fontFamily,o);let f,m;if(0===d){f=h[4];m=h[5]-g}else{f=h[4]+g*Math.sin(d);m=h[5]-g*Math.cos(d)}l.style.left=`${f}px`;l.style.top=`${m}px`;l.style.fontSize=`${p}px`;l.style.fontFamily=u.fontFamily;l.setAttribute("role","presentation");l.textContent=t.str;l.dir=t.dir;e._fontInspectorEnabled&&(l.dataset.fontName=t.fontName);0!==d&&(c.angle=d*(180/Math.PI));let _=!1;if(t.str.length>1||e._enhanceTextSelection&&a.test(t.str))_=!0;else if(" "!==t.str&&t.transform[0]!==t.transform[3]){const e=Math.abs(t.transform[0]),i=Math.abs(t.transform[3]);e!==i&&Math.max(e,i)/Math.min(e,i)>1.5&&(_=!0)}_&&(u.vertical?c.canvasWidth=t.height*e._viewport.scale:c.canvasWidth=t.width*e._viewport.scale);e._textDivProperties.set(l,c);e._textContentStream&&e._layoutText(l);if(e._enhanceTextSelection&&c.hasText){let i=1,s=0;if(0!==d){i=Math.cos(d);s=Math.sin(d)}const r=(u.vertical?t.height:t.width)*e._viewport.scale,a=p;let o,c;if(0!==d){o=[i,s,-s,i,f,m];c=n.Util.getAxialAlignedBoundingBox([0,0,r,a],o)}else c=[f,m,f+r,m+a];e._bounds.push({left:c[0],top:c[1],right:c[2],bottom:c[3],div:l,size:[r,a],m:o})}}function render(e){if(e._canceled)return;const t=e._textDivs,i=e._capability,n=t.length;if(n>1e5){e._renderingDone=!0;i.resolve()}else{if(!e._textContentStream)for(let i=0;i<n;i++)e._layoutText(t[i]);e._renderingDone=!0;i.resolve()}}function findPositiveMin(e,t,i){let n=0;for(let s=0;s<i;s++){const i=e[t++];i>0&&(n=n?Math.min(i,n):i)}return n}function expand(e){const t=e._bounds,i=e._viewport,s=function expandBounds(e,t,i){const n=i.map((function(e,t){return{x1:e.left,y1:e.top,x2:e.right,y2:e.bottom,index:t,x1New:void 0,x2New:void 0}}));expandBoundsLTR(e,n);const s=new Array(i.length);for(const e of n){const t=e.index;s[t]={left:e.x1New,top:0,right:e.x2New,bottom:0}}i.map((function(t,i){const r=s[i],a=n[i];a.x1=t.top;a.y1=e-r.right;a.x2=t.bottom;a.y2=e-r.left;a.index=i;a.x1New=void 0;a.x2New=void 0}));expandBoundsLTR(t,n);for(const e of n){const t=e.index;s[t].top=e.x1New;s[t].bottom=e.x2New}return s}(i.width,i.height,t);for(let i=0;i<s.length;i++){const r=t[i].div,a=e._textDivProperties.get(r);if(0===a.angle){a.paddingLeft=t[i].left-s[i].left;a.paddingTop=t[i].top-s[i].top;a.paddingRight=s[i].right-t[i].right;a.paddingBottom=s[i].bottom-t[i].bottom;e._textDivProperties.set(r,a);continue}const o=s[i],l=t[i],c=l.m,h=c[0],d=c[1],u=[[0,0],[0,l.size[1]],[l.size[0],0],l.size],p=new Float64Array(64);for(let e=0,t=u.length;e<t;e++){const t=n.Util.applyTransform(u[e],c);p[e+0]=h&&(o.left-t[0])/h;p[e+4]=d&&(o.top-t[1])/d;p[e+8]=h&&(o.right-t[0])/h;p[e+12]=d&&(o.bottom-t[1])/d;p[e+16]=d&&(o.left-t[0])/-d;p[e+20]=h&&(o.top-t[1])/h;p[e+24]=d&&(o.right-t[0])/-d;p[e+28]=h&&(o.bottom-t[1])/h;p[e+32]=h&&(o.left-t[0])/-h;p[e+36]=d&&(o.top-t[1])/-d;p[e+40]=h&&(o.right-t[0])/-h;p[e+44]=d&&(o.bottom-t[1])/-d;p[e+48]=d&&(o.left-t[0])/d;p[e+52]=h&&(o.top-t[1])/-h;p[e+56]=d&&(o.right-t[0])/d;p[e+60]=h&&(o.bottom-t[1])/-h}const g=1+Math.min(Math.abs(h),Math.abs(d));a.paddingLeft=findPositiveMin(p,32,16)/g;a.paddingTop=findPositiveMin(p,48,16)/g;a.paddingRight=findPositiveMin(p,0,16)/g;a.paddingBottom=findPositiveMin(p,16,16)/g;e._textDivProperties.set(r,a)}}function expandBoundsLTR(e,t){t.sort((function(e,t){return e.x1-t.x1||e.index-t.index}));const i=[{start:-1/0,end:1/0,boundary:{x1:-1/0,y1:-1/0,x2:0,y2:1/0,index:-1,x1New:0,x2New:0}}];for(const e of t){let t=0;for(;t<i.length&&i[t].end<=e.y1;)t++;let n,s,r=i.length-1;for(;r>=0&&i[r].start>=e.y2;)r--;let a,o,l=-1/0;for(a=t;a<=r;a++){n=i[a];s=n.boundary;let t;t=s.x2>e.x1?s.index>e.index?s.x1New:e.x1:void 0===s.x2New?(s.x2+e.x1)/2:s.x2New;t>l&&(l=t)}e.x1New=l;for(a=t;a<=r;a++){n=i[a];s=n.boundary;void 0===s.x2New?s.x2>e.x1?s.index>e.index&&(s.x2New=s.x2):s.x2New=l:s.x2New>l&&(s.x2New=Math.max(l,s.x2))}const c=[];let h=null;for(a=t;a<=r;a++){n=i[a];s=n.boundary;const t=s.x2>e.x2?s:e;if(h===t)c[c.length-1].end=n.end;else{c.push({start:n.start,end:n.end,boundary:t});h=t}}if(i[t].start<e.y1){c[0].start=e.y1;c.unshift({start:i[t].start,end:e.y1,boundary:i[t].boundary})}if(e.y2<i[r].end){c[c.length-1].end=e.y2;c.push({start:e.y2,end:i[r].end,boundary:i[r].boundary})}for(a=t;a<=r;a++){n=i[a];s=n.boundary;if(void 0!==s.x2New)continue;let e=!1;for(o=t-1;!e&&o>=0&&i[o].start>=s.y1;o--)e=i[o].boundary===s;for(o=r+1;!e&&o<i.length&&i[o].end<=s.y2;o++)e=i[o].boundary===s;for(o=0;!e&&o<c.length;o++)e=c[o].boundary===s;e||(s.x2New=l)}Array.prototype.splice.apply(i,[t,r-t+1].concat(c))}for(const t of i){const i=t.boundary;void 0===i.x2New&&(i.x2New=Math.max(e,i.x2))}}class TextLayerRenderTask{constructor({textContent:e,textContentStream:t,container:i,viewport:s,textDivs:r,textContentItemsStr:a,enhanceTextSelection:o}){this._textContent=e;this._textContentStream=t;this._container=i;this._document=i.ownerDocument;this._viewport=s;this._textDivs=r||[];this._textContentItemsStr=a||[];this._enhanceTextSelection=!!o;this._fontInspectorEnabled=!!globalThis.FontInspector?.enabled;this._reader=null;this._layoutTextLastFontSize=null;this._layoutTextLastFontFamily=null;this._layoutTextCtx=null;this._textDivProperties=new WeakMap;this._renderingDone=!1;this._canceled=!1;this._capability=(0,n.createPromiseCapability)();this._renderTimer=null;this._bounds=[];this._capability.promise.finally((()=>{this._enhanceTextSelection||(this._textDivProperties=null);if(this._layoutTextCtx){this._layoutTextCtx.canvas.width=0;this._layoutTextCtx.canvas.height=0;this._layoutTextCtx=null}})).catch((()=>{}))}get promise(){return this._capability.promise}cancel(){this._canceled=!0;if(this._reader){this._reader.cancel(new n.AbortException("TextLayer task cancelled.")).catch((()=>{}));this._reader=null}if(null!==this._renderTimer){clearTimeout(this._renderTimer);this._renderTimer=null}this._capability.reject(new Error("TextLayer task cancelled."))}_processItems(e,t){for(let i=0,n=e.length;i<n;i++)if(void 0!==e[i].str){this._textContentItemsStr.push(e[i].str);appendText(this,e[i],t,this._layoutTextCtx)}else if("beginMarkedContentProps"===e[i].type||"beginMarkedContent"===e[i].type){const t=this._container;this._container=document.createElement("span");this._container.classList.add("markedContent");null!==e[i].id&&this._container.setAttribute("id",`${e[i].id}`);t.appendChild(this._container)}else"endMarkedContent"===e[i].type&&(this._container=this._container.parentNode)}_layoutText(e){const t=this._textDivProperties.get(e);let i="";if(0!==t.canvasWidth&&t.hasText){const{fontSize:n,fontFamily:s}=e.style;if(n!==this._layoutTextLastFontSize||s!==this._layoutTextLastFontFamily){this._layoutTextCtx.font=`${n} ${s}`;this._layoutTextLastFontSize=n;this._layoutTextLastFontFamily=s}const{width:r}=this._layoutTextCtx.measureText(e.textContent);if(r>0){const e=t.canvasWidth/r;this._enhanceTextSelection&&(t.scale=e);i=`scaleX(${e})`}}0!==t.angle&&(i=`rotate(${t.angle}deg) ${i}`);if(i.length>0){this._enhanceTextSelection&&(t.originalTransform=i);e.style.transform=i}t.hasText&&this._container.appendChild(e);if(t.hasEOL){const e=document.createElement("br");e.setAttribute("role","presentation");this._container.appendChild(e)}}_render(e=0){const t=(0,n.createPromiseCapability)();let i=Object.create(null);const r=this._document.createElement("canvas");r.height=r.width=s;r.mozOpaque=!0;this._layoutTextCtx=r.getContext("2d",{alpha:!1});if(this._textContent){const e=this._textContent.items,i=this._textContent.styles;this._processItems(e,i);t.resolve()}else{if(!this._textContentStream)throw new Error('Neither "textContent" nor "textContentStream" parameters specified.');{const pump=()=>{this._reader.read().then((({value:e,done:n})=>{if(n)t.resolve();else{Object.assign(i,e.styles);this._processItems(e.items,i);pump()}}),t.reject)};this._reader=this._textContentStream.getReader();pump()}}t.promise.then((()=>{i=null;e?this._renderTimer=setTimeout((()=>{render(this);this._renderTimer=null}),e):render(this)}),this._capability.reject)}expandTextDivs(e=!1){if(!this._enhanceTextSelection||!this._renderingDone)return;if(null!==this._bounds){expand(this);this._bounds=null}const t=[],i=[];for(let n=0,s=this._textDivs.length;n<s;n++){const s=this._textDivs[n],r=this._textDivProperties.get(s);if(r.hasText)if(e){t.length=0;i.length=0;r.originalTransform&&t.push(r.originalTransform);if(r.paddingTop>0){i.push(`${r.paddingTop}px`);t.push(`translateY(${-r.paddingTop}px)`)}else i.push(0);r.paddingRight>0?i.push(r.paddingRight/r.scale+"px"):i.push(0);r.paddingBottom>0?i.push(`${r.paddingBottom}px`):i.push(0);if(r.paddingLeft>0){i.push(r.paddingLeft/r.scale+"px");t.push(`translateX(${-r.paddingLeft/r.scale}px)`)}else i.push(0);s.style.padding=i.join(" ");t.length&&(s.style.transform=t.join(" "))}else{s.style.padding=null;s.style.transform=r.originalTransform}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SVGGraphics=void 0;var n=i(2),s=i(1),r=i(4);let a=class{constructor(){(0,n.unreachable)("Not implemented: SVGGraphics")}};t.SVGGraphics=a;{const e={fontStyle:"normal",fontWeight:"normal",fillColor:"#000000"},i="http://www.w3.org/XML/1998/namespace",o="http://www.w3.org/1999/xlink",l=["butt","round","square"],c=["miter","round","bevel"],h=function(){const e=new Uint8Array([137,80,78,71,13,10,26,10]),t=new Int32Array(256);for(let e=0;e<256;e++){let i=e;for(let e=0;e<8;e++)i=1&i?3988292384^i>>1&2147483647:i>>1&2147483647;t[e]=i}function writePngChunk(e,i,n,s){let r=s;const a=i.length;n[r]=a>>24&255;n[r+1]=a>>16&255;n[r+2]=a>>8&255;n[r+3]=255&a;r+=4;n[r]=255&e.charCodeAt(0);n[r+1]=255&e.charCodeAt(1);n[r+2]=255&e.charCodeAt(2);n[r+3]=255&e.charCodeAt(3);r+=4;n.set(i,r);r+=i.length;const o=function crc32(e,i,n){let s=-1;for(let r=i;r<n;r++){const i=255&(s^e[r]);s=s>>>8^t[i]}return-1^s}(n,s+4,r);n[r]=o>>24&255;n[r+1]=o>>16&255;n[r+2]=o>>8&255;n[r+3]=255&o}function deflateSyncUncompressed(e){let t=e.length;const i=65535,n=Math.ceil(t/i),s=new Uint8Array(2+t+5*n+4);let r=0;s[r++]=120;s[r++]=156;let a=0;for(;t>i;){s[r++]=0;s[r++]=255;s[r++]=255;s[r++]=0;s[r++]=0;s.set(e.subarray(a,a+i),r);r+=i;a+=i;t-=i}s[r++]=1;s[r++]=255&t;s[r++]=t>>8&255;s[r++]=255&~t;s[r++]=(65535&~t)>>8&255;s.set(e.subarray(a),r);r+=e.length-a;const o=function adler32(e,t,i){let n=1,s=0;for(let r=t;r<i;++r){n=(n+(255&e[r]))%65521;s=(s+n)%65521}return s<<16|n}(e,0,e.length);s[r++]=o>>24&255;s[r++]=o>>16&255;s[r++]=o>>8&255;s[r++]=255&o;return s}function encode(t,i,s,a){const o=t.width,l=t.height;let c,h,d;const u=t.data;switch(i){case n.ImageKind.GRAYSCALE_1BPP:h=0;c=1;d=o+7>>3;break;case n.ImageKind.RGB_24BPP:h=2;c=8;d=3*o;break;case n.ImageKind.RGBA_32BPP:h=6;c=8;d=4*o;break;default:throw new Error("invalid format")}const p=new Uint8Array((1+d)*l);let g=0,f=0;for(let e=0;e<l;++e){p[g++]=0;p.set(u.subarray(f,f+d),g);f+=d;g+=d}if(i===n.ImageKind.GRAYSCALE_1BPP&&a){g=0;for(let e=0;e<l;e++){g++;for(let e=0;e<d;e++)p[g++]^=255}}const m=new Uint8Array([o>>24&255,o>>16&255,o>>8&255,255&o,l>>24&255,l>>16&255,l>>8&255,255&l,c,h,0,0,0]),_=function deflateSync(e){if(!r.isNodeJS)return deflateSyncUncompressed(e);try{let t;t=parseInt(process.versions.node)>=8?e:Buffer.from(e);const i=require("zlib").deflateSync(t,{level:9});return i instanceof Uint8Array?i:new Uint8Array(i)}catch(e){(0,n.warn)("Not compressing PNG because zlib.deflateSync is unavailable: "+e)}return deflateSyncUncompressed(e)}(p),b=e.length+36+m.length+_.length,v=new Uint8Array(b);let w=0;v.set(e,w);w+=e.length;writePngChunk("IHDR",m,v,w);w+=12+m.length;writePngChunk("IDATA",_,v,w);w+=12+_.length;writePngChunk("IEND",new Uint8Array(0),v,w);return(0,n.createObjectURL)(v,"image/png",s)}return function convertImgDataToPng(e,t,i){return encode(e,void 0===e.kind?n.ImageKind.GRAYSCALE_1BPP:e.kind,t,i)}}();class SVGExtraState{constructor(){this.fontSizeScale=1;this.fontWeight=e.fontWeight;this.fontSize=0;this.textMatrix=n.IDENTITY_MATRIX;this.fontMatrix=n.FONT_IDENTITY_MATRIX;this.leading=0;this.textRenderingMode=n.TextRenderingMode.FILL;this.textMatrixScale=1;this.x=0;this.y=0;this.lineX=0;this.lineY=0;this.charSpacing=0;this.wordSpacing=0;this.textHScale=1;this.textRise=0;this.fillColor=e.fillColor;this.strokeColor="#000000";this.fillAlpha=1;this.strokeAlpha=1;this.lineWidth=1;this.lineJoin="";this.lineCap="";this.miterLimit=0;this.dashArray=[];this.dashPhase=0;this.dependencies=[];this.activeClipUrl=null;this.clipGroup=null;this.maskId=""}clone(){return Object.create(this)}setCurrentPoint(e,t){this.x=e;this.y=t}}function opListToTree(e){let t=[];const i=[];for(const n of e)if("save"!==n.fn)"restore"===n.fn?t=i.pop():t.push(n);else{t.push({fnId:92,fn:"group",items:[]});i.push(t);t=t[t.length-1].items}return t}function pf(e){if(Number.isInteger(e))return e.toString();const t=e.toFixed(10);let i=t.length-1;if("0"!==t[i])return t;do{i--}while("0"===t[i]);return t.substring(0,"."===t[i]?i:i+1)}function pm(e){if(0===e[4]&&0===e[5]){if(0===e[1]&&0===e[2])return 1===e[0]&&1===e[3]?"":`scale(${pf(e[0])} ${pf(e[3])})`;if(e[0]===e[3]&&e[1]===-e[2]){return`rotate(${pf(180*Math.acos(e[0])/Math.PI)})`}}else if(1===e[0]&&0===e[1]&&0===e[2]&&1===e[3])return`translate(${pf(e[4])} ${pf(e[5])})`;return`matrix(${pf(e[0])} ${pf(e[1])} ${pf(e[2])} ${pf(e[3])} ${pf(e[4])} ${pf(e[5])})`}let d=0,u=0,p=0;t.SVGGraphics=a=class{constructor(e,t,i=!1){this.svgFactory=new s.DOMSVGFactory;this.current=new SVGExtraState;this.transformMatrix=n.IDENTITY_MATRIX;this.transformStack=[];this.extraStack=[];this.commonObjs=e;this.objs=t;this.pendingClip=null;this.pendingEOFill=!1;this.embedFonts=!1;this.embeddedFonts=Object.create(null);this.cssStyle=null;this.forceDataSchema=!!i;this._operatorIdMapping=[];for(const e in n.OPS)this._operatorIdMapping[n.OPS[e]]=e}save(){this.transformStack.push(this.transformMatrix);const e=this.current;this.extraStack.push(e);this.current=e.clone()}restore(){this.transformMatrix=this.transformStack.pop();this.current=this.extraStack.pop();this.pendingClip=null;this.tgrp=null}group(e){this.save();this.executeOpTree(e);this.restore()}loadDependencies(e){const t=e.fnArray,i=e.argsArray;for(let e=0,s=t.length;e<s;e++)if(t[e]===n.OPS.dependency)for(const t of i[e]){const e=t.startsWith("g_")?this.commonObjs:this.objs,i=new Promise((i=>{e.get(t,i)}));this.current.dependencies.push(i)}return Promise.all(this.current.dependencies)}transform(e,t,i,s,r,a){const o=[e,t,i,s,r,a];this.transformMatrix=n.Util.transform(this.transformMatrix,o);this.tgrp=null}getSVG(e,t){this.viewport=t;const i=this._initialize(t);return this.loadDependencies(e).then((()=>{this.transformMatrix=n.IDENTITY_MATRIX;this.executeOpTree(this.convertOpList(e));return i}))}convertOpList(e){const t=this._operatorIdMapping,i=e.argsArray,n=e.fnArray,s=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];s.push({fnId:r,fn:t[r],args:i[e]})}return opListToTree(s)}executeOpTree(e){for(const t of e){const e=t.fn,i=t.fnId,s=t.args;switch(0|i){case n.OPS.beginText:this.beginText();break;case n.OPS.dependency:break;case n.OPS.setLeading:this.setLeading(s);break;case n.OPS.setLeadingMoveText:this.setLeadingMoveText(s[0],s[1]);break;case n.OPS.setFont:this.setFont(s);break;case n.OPS.showText:case n.OPS.showSpacedText:this.showText(s[0]);break;case n.OPS.endText:this.endText();break;case n.OPS.moveText:this.moveText(s[0],s[1]);break;case n.OPS.setCharSpacing:this.setCharSpacing(s[0]);break;case n.OPS.setWordSpacing:this.setWordSpacing(s[0]);break;case n.OPS.setHScale:this.setHScale(s[0]);break;case n.OPS.setTextMatrix:this.setTextMatrix(s[0],s[1],s[2],s[3],s[4],s[5]);break;case n.OPS.setTextRise:this.setTextRise(s[0]);break;case n.OPS.setTextRenderingMode:this.setTextRenderingMode(s[0]);break;case n.OPS.setLineWidth:this.setLineWidth(s[0]);break;case n.OPS.setLineJoin:this.setLineJoin(s[0]);break;case n.OPS.setLineCap:this.setLineCap(s[0]);break;case n.OPS.setMiterLimit:this.setMiterLimit(s[0]);break;case n.OPS.setFillRGBColor:this.setFillRGBColor(s[0],s[1],s[2]);break;case n.OPS.setStrokeRGBColor:this.setStrokeRGBColor(s[0],s[1],s[2]);break;case n.OPS.setStrokeColorN:this.setStrokeColorN(s);break;case n.OPS.setFillColorN:this.setFillColorN(s);break;case n.OPS.shadingFill:this.shadingFill(s[0]);break;case n.OPS.setDash:this.setDash(s[0],s[1]);break;case n.OPS.setRenderingIntent:this.setRenderingIntent(s[0]);break;case n.OPS.setFlatness:this.setFlatness(s[0]);break;case n.OPS.setGState:this.setGState(s[0]);break;case n.OPS.fill:this.fill();break;case n.OPS.eoFill:this.eoFill();break;case n.OPS.stroke:this.stroke();break;case n.OPS.fillStroke:this.fillStroke();break;case n.OPS.eoFillStroke:this.eoFillStroke();break;case n.OPS.clip:this.clip("nonzero");break;case n.OPS.eoClip:this.clip("evenodd");break;case n.OPS.paintSolidColorImageMask:this.paintSolidColorImageMask();break;case n.OPS.paintImageXObject:this.paintImageXObject(s[0]);break;case n.OPS.paintInlineImageXObject:this.paintInlineImageXObject(s[0]);break;case n.OPS.paintImageMaskXObject:this.paintImageMaskXObject(s[0]);break;case n.OPS.paintFormXObjectBegin:this.paintFormXObjectBegin(s[0],s[1]);break;case n.OPS.paintFormXObjectEnd:this.paintFormXObjectEnd();break;case n.OPS.closePath:this.closePath();break;case n.OPS.closeStroke:this.closeStroke();break;case n.OPS.closeFillStroke:this.closeFillStroke();break;case n.OPS.closeEOFillStroke:this.closeEOFillStroke();break;case n.OPS.nextLine:this.nextLine();break;case n.OPS.transform:this.transform(s[0],s[1],s[2],s[3],s[4],s[5]);break;case n.OPS.constructPath:this.constructPath(s[0],s[1]);break;case n.OPS.endPath:this.endPath();break;case 92:this.group(t.items);break;default:(0,n.warn)(`Unimplemented operator ${e}`)}}}setWordSpacing(e){this.current.wordSpacing=e}setCharSpacing(e){this.current.charSpacing=e}nextLine(){this.moveText(0,this.current.leading)}setTextMatrix(e,t,i,n,s,r){const a=this.current;a.textMatrix=a.lineMatrix=[e,t,i,n,s,r];a.textMatrixScale=Math.hypot(e,t);a.x=a.lineX=0;a.y=a.lineY=0;a.xcoords=[];a.ycoords=[];a.tspan=this.svgFactory.createElement("svg:tspan");a.tspan.setAttributeNS(null,"font-family",a.fontFamily);a.tspan.setAttributeNS(null,"font-size",`${pf(a.fontSize)}px`);a.tspan.setAttributeNS(null,"y",pf(-a.y));a.txtElement=this.svgFactory.createElement("svg:text");a.txtElement.appendChild(a.tspan)}beginText(){const e=this.current;e.x=e.lineX=0;e.y=e.lineY=0;e.textMatrix=n.IDENTITY_MATRIX;e.lineMatrix=n.IDENTITY_MATRIX;e.textMatrixScale=1;e.tspan=this.svgFactory.createElement("svg:tspan");e.txtElement=this.svgFactory.createElement("svg:text");e.txtgrp=this.svgFactory.createElement("svg:g");e.xcoords=[];e.ycoords=[]}moveText(e,t){const i=this.current;i.x=i.lineX+=e;i.y=i.lineY+=t;i.xcoords=[];i.ycoords=[];i.tspan=this.svgFactory.createElement("svg:tspan");i.tspan.setAttributeNS(null,"font-family",i.fontFamily);i.tspan.setAttributeNS(null,"font-size",`${pf(i.fontSize)}px`);i.tspan.setAttributeNS(null,"y",pf(-i.y))}showText(t){const s=this.current,r=s.font,a=s.fontSize;if(0===a)return;const o=s.fontSizeScale,l=s.charSpacing,c=s.wordSpacing,h=s.fontDirection,d=s.textHScale*h,u=r.vertical,p=u?1:-1,g=r.defaultVMetrics,f=a*s.fontMatrix[0];let m=0;for(const e of t){if(null===e){m+=h*c;continue}if((0,n.isNum)(e)){m+=p*e*a/1e3;continue}const t=(e.isSpace?c:0)+l,i=e.fontChar;let d,_,b,v=e.width;if(u){let t;const i=e.vmetric||g;t=e.vmetric?i[1]:.5*v;t=-t*f;const n=i[2]*f;v=i?-i[0]:v;d=t/o;_=(m+n)/o}else{d=m/o;_=0}if(e.isInFont||r.missingFile){s.xcoords.push(s.x+d);u&&s.ycoords.push(-s.y+_);s.tspan.textContent+=i}b=u?v*f-t*h:v*f+t*h;m+=b}s.tspan.setAttributeNS(null,"x",s.xcoords.map(pf).join(" "));u?s.tspan.setAttributeNS(null,"y",s.ycoords.map(pf).join(" ")):s.tspan.setAttributeNS(null,"y",pf(-s.y));u?s.y-=m:s.x+=m*d;s.tspan.setAttributeNS(null,"font-family",s.fontFamily);s.tspan.setAttributeNS(null,"font-size",`${pf(s.fontSize)}px`);s.fontStyle!==e.fontStyle&&s.tspan.setAttributeNS(null,"font-style",s.fontStyle);s.fontWeight!==e.fontWeight&&s.tspan.setAttributeNS(null,"font-weight",s.fontWeight);const _=s.textRenderingMode&n.TextRenderingMode.FILL_STROKE_MASK;if(_===n.TextRenderingMode.FILL||_===n.TextRenderingMode.FILL_STROKE){s.fillColor!==e.fillColor&&s.tspan.setAttributeNS(null,"fill",s.fillColor);s.fillAlpha<1&&s.tspan.setAttributeNS(null,"fill-opacity",s.fillAlpha)}else s.textRenderingMode===n.TextRenderingMode.ADD_TO_PATH?s.tspan.setAttributeNS(null,"fill","transparent"):s.tspan.setAttributeNS(null,"fill","none");if(_===n.TextRenderingMode.STROKE||_===n.TextRenderingMode.FILL_STROKE){const e=1/(s.textMatrixScale||1);this._setStrokeAttributes(s.tspan,e)}let b=s.textMatrix;if(0!==s.textRise){b=b.slice();b[5]+=s.textRise}s.txtElement.setAttributeNS(null,"transform",`${pm(b)} scale(${pf(d)}, -1)`);s.txtElement.setAttributeNS(i,"xml:space","preserve");s.txtElement.appendChild(s.tspan);s.txtgrp.appendChild(s.txtElement);this._ensureTransformGroup().appendChild(s.txtElement)}setLeadingMoveText(e,t){this.setLeading(-t);this.moveText(e,t)}addFontStyle(e){if(!e.data)throw new Error('addFontStyle: No font data available, ensure that the "fontExtraProperties" API parameter is set.');if(!this.cssStyle){this.cssStyle=this.svgFactory.createElement("svg:style");this.cssStyle.setAttributeNS(null,"type","text/css");this.defs.appendChild(this.cssStyle)}const t=(0,n.createObjectURL)(e.data,e.mimetype,this.forceDataSchema);this.cssStyle.textContent+=`@font-face { font-family: "${e.loadedName}"; src: url(${t}); }\n`}setFont(e){const t=this.current,i=this.commonObjs.get(e[0]);let s=e[1];t.font=i;if(this.embedFonts&&!i.missingFile&&!this.embeddedFonts[i.loadedName]){this.addFontStyle(i);this.embeddedFonts[i.loadedName]=i}t.fontMatrix=i.fontMatrix||n.FONT_IDENTITY_MATRIX;let r="normal";i.black?r="900":i.bold&&(r="bold");const a=i.italic?"italic":"normal";if(s<0){s=-s;t.fontDirection=-1}else t.fontDirection=1;t.fontSize=s;t.fontFamily=i.loadedName;t.fontWeight=r;t.fontStyle=a;t.tspan=this.svgFactory.createElement("svg:tspan");t.tspan.setAttributeNS(null,"y",pf(-t.y));t.xcoords=[];t.ycoords=[]}endText(){const e=this.current;if(e.textRenderingMode&n.TextRenderingMode.ADD_TO_PATH_FLAG&&e.txtElement?.hasChildNodes()){e.element=e.txtElement;this.clip("nonzero");this.endPath()}}setLineWidth(e){e>0&&(this.current.lineWidth=e)}setLineCap(e){this.current.lineCap=l[e]}setLineJoin(e){this.current.lineJoin=c[e]}setMiterLimit(e){this.current.miterLimit=e}setStrokeAlpha(e){this.current.strokeAlpha=e}setStrokeRGBColor(e,t,i){this.current.strokeColor=n.Util.makeHexColor(e,t,i)}setFillAlpha(e){this.current.fillAlpha=e}setFillRGBColor(e,t,i){this.current.fillColor=n.Util.makeHexColor(e,t,i);this.current.tspan=this.svgFactory.createElement("svg:tspan");this.current.xcoords=[];this.current.ycoords=[]}setStrokeColorN(e){this.current.strokeColor=this._makeColorN_Pattern(e)}setFillColorN(e){this.current.fillColor=this._makeColorN_Pattern(e)}shadingFill(e){const t=this.viewport.width,i=this.viewport.height,s=n.Util.inverseTransform(this.transformMatrix),r=n.Util.applyTransform([0,0],s),a=n.Util.applyTransform([0,i],s),o=n.Util.applyTransform([t,0],s),l=n.Util.applyTransform([t,i],s),c=Math.min(r[0],a[0],o[0],l[0]),h=Math.min(r[1],a[1],o[1],l[1]),d=Math.max(r[0],a[0],o[0],l[0]),u=Math.max(r[1],a[1],o[1],l[1]),p=this.svgFactory.createElement("svg:rect");p.setAttributeNS(null,"x",c);p.setAttributeNS(null,"y",h);p.setAttributeNS(null,"width",d-c);p.setAttributeNS(null,"height",u-h);p.setAttributeNS(null,"fill",this._makeShadingPattern(e));this.current.fillAlpha<1&&p.setAttributeNS(null,"fill-opacity",this.current.fillAlpha);this._ensureTransformGroup().appendChild(p)}_makeColorN_Pattern(e){return"TilingPattern"===e[0]?this._makeTilingPattern(e):this._makeShadingPattern(e)}_makeTilingPattern(e){const t=e[1],i=e[2],s=e[3]||n.IDENTITY_MATRIX,[r,a,o,l]=e[4],c=e[5],h=e[6],d=e[7],u="shading"+p++,[g,f,m,_]=n.Util.normalizeRect([...n.Util.applyTransform([r,a],s),...n.Util.applyTransform([o,l],s)]),[b,v]=n.Util.singularValueDecompose2dScale(s),w=c*b,y=h*v,S=this.svgFactory.createElement("svg:pattern");S.setAttributeNS(null,"id",u);S.setAttributeNS(null,"patternUnits","userSpaceOnUse");S.setAttributeNS(null,"width",w);S.setAttributeNS(null,"height",y);S.setAttributeNS(null,"x",`${g}`);S.setAttributeNS(null,"y",`${f}`);const P=this.svg,A=this.transformMatrix,C=this.current.fillColor,x=this.current.strokeColor,E=this.svgFactory.create(m-g,_-f);this.svg=E;this.transformMatrix=s;if(2===d){const e=n.Util.makeHexColor(...t);this.current.fillColor=e;this.current.strokeColor=e}this.executeOpTree(this.convertOpList(i));this.svg=P;this.transformMatrix=A;this.current.fillColor=C;this.current.strokeColor=x;S.appendChild(E.childNodes[0]);this.defs.appendChild(S);return`url(#${u})`}_makeShadingPattern(e){"string"==typeof e&&(e=this.objs.get(e));switch(e[0]){case"RadialAxial":const t="shading"+p++,i=e[3];let s;switch(e[1]){case"axial":const i=e[4],n=e[5];s=this.svgFactory.createElement("svg:linearGradient");s.setAttributeNS(null,"id",t);s.setAttributeNS(null,"gradientUnits","userSpaceOnUse");s.setAttributeNS(null,"x1",i[0]);s.setAttributeNS(null,"y1",i[1]);s.setAttributeNS(null,"x2",n[0]);s.setAttributeNS(null,"y2",n[1]);break;case"radial":const r=e[4],a=e[5],o=e[6],l=e[7];s=this.svgFactory.createElement("svg:radialGradient");s.setAttributeNS(null,"id",t);s.setAttributeNS(null,"gradientUnits","userSpaceOnUse");s.setAttributeNS(null,"cx",a[0]);s.setAttributeNS(null,"cy",a[1]);s.setAttributeNS(null,"r",l);s.setAttributeNS(null,"fx",r[0]);s.setAttributeNS(null,"fy",r[1]);s.setAttributeNS(null,"fr",o);break;default:throw new Error(`Unknown RadialAxial type: ${e[1]}`)}for(const e of i){const t=this.svgFactory.createElement("svg:stop");t.setAttributeNS(null,"offset",e[0]);t.setAttributeNS(null,"stop-color",e[1]);s.appendChild(t)}this.defs.appendChild(s);return`url(#${t})`;case"Mesh":(0,n.warn)("Unimplemented pattern Mesh");return null;case"Dummy":return"hotpink";default:throw new Error(`Unknown IR type: ${e[0]}`)}}setDash(e,t){this.current.dashArray=e;this.current.dashPhase=t}constructPath(e,t){const i=this.current;let s=i.x,r=i.y,a=[],o=0;for(const i of e)switch(0|i){case n.OPS.rectangle:s=t[o++];r=t[o++];const e=s+t[o++],i=r+t[o++];a.push("M",pf(s),pf(r),"L",pf(e),pf(r),"L",pf(e),pf(i),"L",pf(s),pf(i),"Z");break;case n.OPS.moveTo:s=t[o++];r=t[o++];a.push("M",pf(s),pf(r));break;case n.OPS.lineTo:s=t[o++];r=t[o++];a.push("L",pf(s),pf(r));break;case n.OPS.curveTo:s=t[o+4];r=t[o+5];a.push("C",pf(t[o]),pf(t[o+1]),pf(t[o+2]),pf(t[o+3]),pf(s),pf(r));o+=6;break;case n.OPS.curveTo2:a.push("C",pf(s),pf(r),pf(t[o]),pf(t[o+1]),pf(t[o+2]),pf(t[o+3]));s=t[o+2];r=t[o+3];o+=4;break;case n.OPS.curveTo3:s=t[o+2];r=t[o+3];a.push("C",pf(t[o]),pf(t[o+1]),pf(s),pf(r),pf(s),pf(r));o+=4;break;case n.OPS.closePath:a.push("Z")}a=a.join(" ");if(i.path&&e.length>0&&e[0]!==n.OPS.rectangle&&e[0]!==n.OPS.moveTo)a=i.path.getAttributeNS(null,"d")+a;else{i.path=this.svgFactory.createElement("svg:path");this._ensureTransformGroup().appendChild(i.path)}i.path.setAttributeNS(null,"d",a);i.path.setAttributeNS(null,"fill","none");i.element=i.path;i.setCurrentPoint(s,r)}endPath(){const e=this.current;e.path=null;if(!this.pendingClip)return;if(!e.element){this.pendingClip=null;return}const t="clippath"+d++,i=this.svgFactory.createElement("svg:clipPath");i.setAttributeNS(null,"id",t);i.setAttributeNS(null,"transform",pm(this.transformMatrix));const n=e.element.cloneNode(!0);"evenodd"===this.pendingClip?n.setAttributeNS(null,"clip-rule","evenodd"):n.setAttributeNS(null,"clip-rule","nonzero");this.pendingClip=null;i.appendChild(n);this.defs.appendChild(i);if(e.activeClipUrl){e.clipGroup=null;for(const e of this.extraStack)e.clipGroup=null;i.setAttributeNS(null,"clip-path",e.activeClipUrl)}e.activeClipUrl=`url(#${t})`;this.tgrp=null}clip(e){this.pendingClip=e}closePath(){const e=this.current;if(e.path){const t=`${e.path.getAttributeNS(null,"d")}Z`;e.path.setAttributeNS(null,"d",t)}}setLeading(e){this.current.leading=-e}setTextRise(e){this.current.textRise=e}setTextRenderingMode(e){this.current.textRenderingMode=e}setHScale(e){this.current.textHScale=e/100}setRenderingIntent(e){}setFlatness(e){}setGState(e){for(const[t,i]of e)switch(t){case"LW":this.setLineWidth(i);break;case"LC":this.setLineCap(i);break;case"LJ":this.setLineJoin(i);break;case"ML":this.setMiterLimit(i);break;case"D":this.setDash(i[0],i[1]);break;case"RI":this.setRenderingIntent(i);break;case"FL":this.setFlatness(i);break;case"Font":this.setFont(i);break;case"CA":this.setStrokeAlpha(i);break;case"ca":this.setFillAlpha(i);break;default:(0,n.warn)(`Unimplemented graphic state operator ${t}`)}}fill(){const e=this.current;if(e.element){e.element.setAttributeNS(null,"fill",e.fillColor);e.element.setAttributeNS(null,"fill-opacity",e.fillAlpha);this.endPath()}}stroke(){const e=this.current;if(e.element){this._setStrokeAttributes(e.element);e.element.setAttributeNS(null,"fill","none");this.endPath()}}_setStrokeAttributes(e,t=1){const i=this.current;let n=i.dashArray;1!==t&&n.length>0&&(n=n.map((function(e){return t*e})));e.setAttributeNS(null,"stroke",i.strokeColor);e.setAttributeNS(null,"stroke-opacity",i.strokeAlpha);e.setAttributeNS(null,"stroke-miterlimit",pf(i.miterLimit));e.setAttributeNS(null,"stroke-linecap",i.lineCap);e.setAttributeNS(null,"stroke-linejoin",i.lineJoin);e.setAttributeNS(null,"stroke-width",pf(t*i.lineWidth)+"px");e.setAttributeNS(null,"stroke-dasharray",n.map(pf).join(" "));e.setAttributeNS(null,"stroke-dashoffset",pf(t*i.dashPhase)+"px")}eoFill(){this.current.element&&this.current.element.setAttributeNS(null,"fill-rule","evenodd");this.fill()}fillStroke(){this.stroke();this.fill()}eoFillStroke(){this.current.element&&this.current.element.setAttributeNS(null,"fill-rule","evenodd");this.fillStroke()}closeStroke(){this.closePath();this.stroke()}closeFillStroke(){this.closePath();this.fillStroke()}closeEOFillStroke(){this.closePath();this.eoFillStroke()}paintSolidColorImageMask(){const e=this.svgFactory.createElement("svg:rect");e.setAttributeNS(null,"x","0");e.setAttributeNS(null,"y","0");e.setAttributeNS(null,"width","1px");e.setAttributeNS(null,"height","1px");e.setAttributeNS(null,"fill",this.current.fillColor);this._ensureTransformGroup().appendChild(e)}paintImageXObject(e){const t=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);t?this.paintInlineImageXObject(t):(0,n.warn)(`Dependent image with object ID ${e} is not ready yet`)}paintInlineImageXObject(e,t){const i=e.width,n=e.height,s=h(e,this.forceDataSchema,!!t),r=this.svgFactory.createElement("svg:rect");r.setAttributeNS(null,"x","0");r.setAttributeNS(null,"y","0");r.setAttributeNS(null,"width",pf(i));r.setAttributeNS(null,"height",pf(n));this.current.element=r;this.clip("nonzero");const a=this.svgFactory.createElement("svg:image");a.setAttributeNS(o,"xlink:href",s);a.setAttributeNS(null,"x","0");a.setAttributeNS(null,"y",pf(-n));a.setAttributeNS(null,"width",pf(i)+"px");a.setAttributeNS(null,"height",pf(n)+"px");a.setAttributeNS(null,"transform",`scale(${pf(1/i)} ${pf(-1/n)})`);t?t.appendChild(a):this._ensureTransformGroup().appendChild(a)}paintImageMaskXObject(e){const t=this.current,i=e.width,n=e.height,s=t.fillColor;t.maskId="mask"+u++;const r=this.svgFactory.createElement("svg:mask");r.setAttributeNS(null,"id",t.maskId);const a=this.svgFactory.createElement("svg:rect");a.setAttributeNS(null,"x","0");a.setAttributeNS(null,"y","0");a.setAttributeNS(null,"width",pf(i));a.setAttributeNS(null,"height",pf(n));a.setAttributeNS(null,"fill",s);a.setAttributeNS(null,"mask",`url(#${t.maskId})`);this.defs.appendChild(r);this._ensureTransformGroup().appendChild(a);this.paintInlineImageXObject(e,r)}paintFormXObjectBegin(e,t){Array.isArray(e)&&6===e.length&&this.transform(e[0],e[1],e[2],e[3],e[4],e[5]);if(t){const e=t[2]-t[0],i=t[3]-t[1],n=this.svgFactory.createElement("svg:rect");n.setAttributeNS(null,"x",t[0]);n.setAttributeNS(null,"y",t[1]);n.setAttributeNS(null,"width",pf(e));n.setAttributeNS(null,"height",pf(i));this.current.element=n;this.clip("nonzero");this.endPath()}}paintFormXObjectEnd(){}_initialize(e){const t=this.svgFactory.create(e.width,e.height),i=this.svgFactory.createElement("svg:defs");t.appendChild(i);this.defs=i;const n=this.svgFactory.createElement("svg:g");n.setAttributeNS(null,"transform",pm(e.transform));t.appendChild(n);this.svg=n;return t}_ensureClipGroup(){if(!this.current.clipGroup){const e=this.svgFactory.createElement("svg:g");e.setAttributeNS(null,"clip-path",this.current.activeClipUrl);this.svg.appendChild(e);this.current.clipGroup=e}return this.current.clipGroup}_ensureTransformGroup(){if(!this.tgrp){this.tgrp=this.svgFactory.createElement("svg:g");this.tgrp.setAttributeNS(null,"transform",pm(this.transformMatrix));this.current.activeClipUrl?this._ensureClipGroup().appendChild(this.tgrp):this.svg.appendChild(this.tgrp)}return this.tgrp}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFNodeStream=void 0;var n=i(2),s=i(24);const r=require("fs"),a=require("http"),o=require("https"),l=require("url"),c=/^file:\/\/\/[a-zA-Z]:\//;t.PDFNodeStream=class PDFNodeStream{constructor(e){this.source=e;this.url=function parseUrl(e){const t=l.parse(e);if("file:"===t.protocol||t.host)return t;if(/^[a-z]:[/\\]/i.test(e))return l.parse(`file:///${e}`);t.host||(t.protocol="file:");return t}(e.url);this.isHttp="http:"===this.url.protocol||"https:"===this.url.protocol;this.isFsUrl="file:"===this.url.protocol;this.httpHeaders=this.isHttp&&e.httpHeaders||{};this._fullRequestReader=null;this._rangeRequestReaders=[]}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFNodeStream.getFullReader can only be called once.");this._fullRequestReader=this.isFsUrl?new PDFNodeStreamFsFullReader(this):new PDFNodeStreamFullReader(this);return this._fullRequestReader}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=this.isFsUrl?new PDFNodeStreamFsRangeReader(this,e,t):new PDFNodeStreamRangeReader(this,e,t);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class BaseFullReader{constructor(e){this._url=e.url;this._done=!1;this._storedError=null;this.onProgress=null;const t=e.source;this._contentLength=t.length;this._loaded=0;this._filename=null;this._disableRange=t.disableRange||!1;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);this._isStreamingSupported=!t.disableStream;this._isRangeSupported=!t.disableRange;this._readableStream=null;this._readCapability=(0,n.createPromiseCapability)();this._headersCapability=(0,n.createPromiseCapability)()}get headersReady(){return this._headersCapability.promise}get filename(){return this._filename}get contentLength(){return this._contentLength}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;if(this._done)return{value:void 0,done:!0};if(this._storedError)throw this._storedError;const e=this._readableStream.read();if(null===e){this._readCapability=(0,n.createPromiseCapability)();return this.read()}this._loaded+=e.length;this.onProgress&&this.onProgress({loaded:this._loaded,total:this._contentLength});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._readableStream?this._readableStream.destroy(e):this._error(e)}_error(e){this._storedError=e;this._readCapability.resolve()}_setReadableStream(e){this._readableStream=e;e.on("readable",(()=>{this._readCapability.resolve()}));e.on("end",(()=>{e.destroy();this._done=!0;this._readCapability.resolve()}));e.on("error",(e=>{this._error(e)}));!this._isStreamingSupported&&this._isRangeSupported&&this._error(new n.AbortException("streaming is disabled"));this._storedError&&this._readableStream.destroy(this._storedError)}}class BaseRangeReader{constructor(e){this._url=e.url;this._done=!1;this._storedError=null;this.onProgress=null;this._loaded=0;this._readableStream=null;this._readCapability=(0,n.createPromiseCapability)();const t=e.source;this._isStreamingSupported=!t.disableStream}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;if(this._done)return{value:void 0,done:!0};if(this._storedError)throw this._storedError;const e=this._readableStream.read();if(null===e){this._readCapability=(0,n.createPromiseCapability)();return this.read()}this._loaded+=e.length;this.onProgress&&this.onProgress({loaded:this._loaded});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._readableStream?this._readableStream.destroy(e):this._error(e)}_error(e){this._storedError=e;this._readCapability.resolve()}_setReadableStream(e){this._readableStream=e;e.on("readable",(()=>{this._readCapability.resolve()}));e.on("end",(()=>{e.destroy();this._done=!0;this._readCapability.resolve()}));e.on("error",(e=>{this._error(e)}));this._storedError&&this._readableStream.destroy(this._storedError)}}function createRequestOptions(e,t){return{protocol:e.protocol,auth:e.auth,host:e.hostname,port:e.port,path:e.path,method:"GET",headers:t}}class PDFNodeStreamFullReader extends BaseFullReader{constructor(e){super(e);const handleResponse=t=>{if(404===t.statusCode){const e=new n.MissingPDFException(`Missing PDF "${this._url}".`);this._storedError=e;this._headersCapability.reject(e);return}this._headersCapability.resolve();this._setReadableStream(t);const getResponseHeader=e=>this._readableStream.headers[e.toLowerCase()],{allowRangeRequests:i,suggestedLength:r}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:e.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});this._isRangeSupported=i;this._contentLength=r||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader)};this._request=null;"http:"===this._url.protocol?this._request=a.request(createRequestOptions(this._url,e.httpHeaders),handleResponse):this._request=o.request(createRequestOptions(this._url,e.httpHeaders),handleResponse);this._request.on("error",(e=>{this._storedError=e;this._headersCapability.reject(e)}));this._request.end()}}class PDFNodeStreamRangeReader extends BaseRangeReader{constructor(e,t,i){super(e);this._httpHeaders={};for(const t in e.httpHeaders){const i=e.httpHeaders[t];void 0!==i&&(this._httpHeaders[t]=i)}this._httpHeaders.Range=`bytes=${t}-${i-1}`;const handleResponse=e=>{if(404!==e.statusCode)this._setReadableStream(e);else{const e=new n.MissingPDFException(`Missing PDF "${this._url}".`);this._storedError=e}};this._request=null;"http:"===this._url.protocol?this._request=a.request(createRequestOptions(this._url,this._httpHeaders),handleResponse):this._request=o.request(createRequestOptions(this._url,this._httpHeaders),handleResponse);this._request.on("error",(e=>{this._storedError=e}));this._request.end()}}class PDFNodeStreamFsFullReader extends BaseFullReader{constructor(e){super(e);let t=decodeURIComponent(this._url.path);c.test(this._url.href)&&(t=t.replace(/^\//,""));r.lstat(t,((e,i)=>{if(e){"ENOENT"===e.code&&(e=new n.MissingPDFException(`Missing PDF "${t}".`));this._storedError=e;this._headersCapability.reject(e)}else{this._contentLength=i.size;this._setReadableStream(r.createReadStream(t));this._headersCapability.resolve()}}))}}class PDFNodeStreamFsRangeReader extends BaseRangeReader{constructor(e,t,i){super(e);let n=decodeURIComponent(this._url.path);c.test(this._url.href)&&(n=n.replace(/^\//,""));this._setReadableStream(r.createReadStream(n,{start:t,end:i-1}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.createResponseStatusError=function createResponseStatusError(e,t){if(404===e||0===e&&t.startsWith("file:"))return new n.MissingPDFException('Missing PDF "'+t+'".');return new n.UnexpectedResponseException(`Unexpected server response (${e}) while retrieving PDF "${t}".`,e)};t.extractFilenameFromHeader=function extractFilenameFromHeader(e){const t=e("Content-Disposition");if(t){let e=(0,s.getFilenameFromContentDispositionHeader)(t);if(e.includes("%"))try{e=decodeURIComponent(e)}catch(e){}if((0,r.isPdfFile)(e))return e}return null};t.validateRangeRequestCapabilities=function validateRangeRequestCapabilities({getResponseHeader:e,isHttp:t,rangeChunkSize:i,disableRange:s}){(0,n.assert)(i>0,"Range chunk size must be larger than zero");const r={allowRangeRequests:!1,suggestedLength:void 0},a=parseInt(e("Content-Length"),10);if(!Number.isInteger(a))return r;r.suggestedLength=a;if(a<=2*i)return r;if(s||!t)return r;if("bytes"!==e("Accept-Ranges"))return r;if("identity"!==(e("Content-Encoding")||"identity"))return r;r.allowRangeRequests=!0;return r};t.validateResponseStatus=function validateResponseStatus(e){return 200===e||206===e};var n=i(2),s=i(25),r=i(1)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getFilenameFromContentDispositionHeader=function getFilenameFromContentDispositionHeader(e){let t=!0,i=toParamRegExp("filename\\*","i").exec(e);if(i){i=i[1];let e=rfc2616unquote(i);e=unescape(e);e=rfc5987decode(e);e=rfc2047decode(e);return fixupEncoding(e)}i=function rfc2231getparam(e){const t=[];let i;const n=toParamRegExp("filename\\*((?!0\\d)\\d+)(\\*?)","ig");for(;null!==(i=n.exec(e));){let[,e,n,s]=i;e=parseInt(e,10);if(e in t){if(0===e)break}else t[e]=[n,s]}const s=[];for(let e=0;e<t.length&&e in t;++e){let[i,n]=t[e];n=rfc2616unquote(n);if(i){n=unescape(n);0===e&&(n=rfc5987decode(n))}s.push(n)}return s.join("")}(e);if(i){return fixupEncoding(rfc2047decode(i))}i=toParamRegExp("filename","i").exec(e);if(i){i=i[1];let e=rfc2616unquote(i);e=rfc2047decode(e);return fixupEncoding(e)}function toParamRegExp(e,t){return new RegExp("(?:^|;)\\s*"+e+'\\s*=\\s*([^";\\s][^;\\s]*|"(?:[^"\\\\]|\\\\"?)+"?)',t)}function textdecode(e,i){if(e){if(!/^[\x00-\xFF]+$/.test(i))return i;try{const s=new TextDecoder(e,{fatal:!0}),r=(0,n.stringToBytes)(i);i=s.decode(r);t=!1}catch(n){if(/^utf-?8$/i.test(e))try{i=decodeURIComponent(escape(i));t=!1}catch(e){}}}return i}function fixupEncoding(e){if(t&&/[\x80-\xff]/.test(e)){e=textdecode("utf-8",e);t&&(e=textdecode("iso-8859-1",e))}return e}function rfc2616unquote(e){if(e.startsWith('"')){const t=e.slice(1).split('\\"');for(let e=0;e<t.length;++e){const i=t[e].indexOf('"');if(-1!==i){t[e]=t[e].slice(0,i);t.length=e+1}t[e]=t[e].replace(/\\(.)/g,"$1")}e=t.join('"')}return e}function rfc5987decode(e){const t=e.indexOf("'");if(-1===t)return e;return textdecode(e.slice(0,t),e.slice(t+1).replace(/^[^']*'/,""))}function rfc2047decode(e){return!e.startsWith("=?")||/[\x00-\x19\x80-\xff]/.test(e)?e:e.replace(/=\?([\w-]*)\?([QqBb])\?((?:[^?]|\?(?!=))*)\?=/g,(function(e,t,i,n){if("q"===i||"Q"===i)return textdecode(t,n=(n=n.replace(/_/g," ")).replace(/=([0-9a-fA-F]{2})/g,(function(e,t){return String.fromCharCode(parseInt(t,16))})));try{n=atob(n)}catch(e){}return textdecode(t,n)}))}return""};var n=i(2)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFNetworkStream=void 0;var n=i(2),s=i(24);class NetworkManager{constructor(e,t={}){this.url=e;this.isHttp=/^https?:/i.test(e);this.httpHeaders=this.isHttp&&t.httpHeaders||Object.create(null);this.withCredentials=t.withCredentials||!1;this.getXhr=t.getXhr||function NetworkManager_getXhr(){return new XMLHttpRequest};this.currXhrId=0;this.pendingRequests=Object.create(null)}requestRange(e,t,i){const n={begin:e,end:t};for(const e in i)n[e]=i[e];return this.request(n)}requestFull(e){return this.request(e)}request(e){const t=this.getXhr(),i=this.currXhrId++,n=this.pendingRequests[i]={xhr:t};t.open("GET",this.url);t.withCredentials=this.withCredentials;for(const e in this.httpHeaders){const i=this.httpHeaders[e];void 0!==i&&t.setRequestHeader(e,i)}if(this.isHttp&&"begin"in e&&"end"in e){t.setRequestHeader("Range",`bytes=${e.begin}-${e.end-1}`);n.expectedStatus=206}else n.expectedStatus=200;t.responseType="arraybuffer";e.onError&&(t.onerror=function(i){e.onError(t.status)});t.onreadystatechange=this.onStateChange.bind(this,i);t.onprogress=this.onProgress.bind(this,i);n.onHeadersReceived=e.onHeadersReceived;n.onDone=e.onDone;n.onError=e.onError;n.onProgress=e.onProgress;t.send(null);return i}onProgress(e,t){const i=this.pendingRequests[e];i&&i.onProgress?.(t)}onStateChange(e,t){const i=this.pendingRequests[e];if(!i)return;const s=i.xhr;if(s.readyState>=2&&i.onHeadersReceived){i.onHeadersReceived();delete i.onHeadersReceived}if(4!==s.readyState)return;if(!(e in this.pendingRequests))return;delete this.pendingRequests[e];if(0===s.status&&this.isHttp){i.onError?.(s.status);return}const r=s.status||200;if(!(200===r&&206===i.expectedStatus)&&r!==i.expectedStatus){i.onError?.(s.status);return}const a=function getArrayBuffer(e){const t=e.response;return"string"!=typeof t?t:(0,n.stringToBytes)(t).buffer}(s);if(206===r){const e=s.getResponseHeader("Content-Range"),t=/bytes (\d+)-(\d+)\/(\d+)/.exec(e);i.onDone({begin:parseInt(t[1],10),chunk:a})}else a?i.onDone({begin:0,chunk:a}):i.onError?.(s.status)}getRequestXhr(e){return this.pendingRequests[e].xhr}isPendingRequest(e){return e in this.pendingRequests}abortRequest(e){const t=this.pendingRequests[e].xhr;delete this.pendingRequests[e];t.abort()}}t.PDFNetworkStream=class PDFNetworkStream{constructor(e){this._source=e;this._manager=new NetworkManager(e.url,{httpHeaders:e.httpHeaders,withCredentials:e.withCredentials});this._rangeChunkSize=e.rangeChunkSize;this._fullRequestReader=null;this._rangeRequestReaders=[]}_onRangeRequestReaderClosed(e){const t=this._rangeRequestReaders.indexOf(e);t>=0&&this._rangeRequestReaders.splice(t,1)}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFNetworkStream.getFullReader can only be called once.");this._fullRequestReader=new PDFNetworkStreamFullRequestReader(this._manager,this._source);return this._fullRequestReader}getRangeReader(e,t){const i=new PDFNetworkStreamRangeRequestReader(this._manager,e,t);i.onClosed=this._onRangeRequestReaderClosed.bind(this);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader?.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class PDFNetworkStreamFullRequestReader{constructor(e,t){this._manager=e;const i={onHeadersReceived:this._onHeadersReceived.bind(this),onDone:this._onDone.bind(this),onError:this._onError.bind(this),onProgress:this._onProgress.bind(this)};this._url=t.url;this._fullRequestId=e.requestFull(i);this._headersReceivedCapability=(0,n.createPromiseCapability)();this._disableRange=t.disableRange||!1;this._contentLength=t.length;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);this._isStreamingSupported=!1;this._isRangeSupported=!1;this._cachedChunks=[];this._requests=[];this._done=!1;this._storedError=void 0;this._filename=null;this.onProgress=null}_onHeadersReceived(){const e=this._fullRequestId,t=this._manager.getRequestXhr(e),getResponseHeader=e=>t.getResponseHeader(e),{allowRangeRequests:i,suggestedLength:n}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:this._manager.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});i&&(this._isRangeSupported=!0);this._contentLength=n||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader);this._isRangeSupported&&this._manager.abortRequest(e);this._headersReceivedCapability.resolve()}_onDone(e){if(e)if(this._requests.length>0){this._requests.shift().resolve({value:e.chunk,done:!1})}else this._cachedChunks.push(e.chunk);this._done=!0;if(!(this._cachedChunks.length>0)){for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}}_onError(e){this._storedError=(0,s.createResponseStatusError)(e,this._url);this._headersReceivedCapability.reject(this._storedError);for(const e of this._requests)e.reject(this._storedError);this._requests.length=0;this._cachedChunks.length=0}_onProgress(e){this.onProgress?.({loaded:e.loaded,total:e.lengthComputable?e.total:this._contentLength})}get filename(){return this._filename}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}get contentLength(){return this._contentLength}get headersReady(){return this._headersReceivedCapability.promise}async read(){if(this._storedError)throw this._storedError;if(this._cachedChunks.length>0){return{value:this._cachedChunks.shift(),done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;this._headersReceivedCapability.reject(e);for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._manager.isPendingRequest(this._fullRequestId)&&this._manager.abortRequest(this._fullRequestId);this._fullRequestReader=null}}class PDFNetworkStreamRangeRequestReader{constructor(e,t,i){this._manager=e;const n={onDone:this._onDone.bind(this),onError:this._onError.bind(this),onProgress:this._onProgress.bind(this)};this._url=e.url;this._requestId=e.requestRange(t,i,n);this._requests=[];this._queuedChunk=null;this._done=!1;this._storedError=void 0;this.onProgress=null;this.onClosed=null}_close(){this.onClosed?.(this)}_onDone(e){const t=e.chunk;if(this._requests.length>0){this._requests.shift().resolve({value:t,done:!1})}else this._queuedChunk=t;this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._close()}_onError(e){this._storedError=(0,s.createResponseStatusError)(e,this._url);for(const e of this._requests)e.reject(this._storedError);this._requests.length=0;this._queuedChunk=null}_onProgress(e){this.isStreamingSupported||this.onProgress?.({loaded:e.loaded})}get isStreamingSupported(){return!1}async read(){if(this._storedError)throw this._storedError;if(null!==this._queuedChunk){const e=this._queuedChunk;this._queuedChunk=null;return{value:e,done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._manager.isPendingRequest(this._requestId)&&this._manager.abortRequest(this._requestId);this._close()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFetchStream=void 0;var n=i(2),s=i(24);function createFetchOptions(e,t,i){return{method:"GET",headers:e,signal:i?.signal,mode:"cors",credentials:t?"include":"same-origin",redirect:"follow"}}function createHeaders(e){const t=new Headers;for(const i in e){const n=e[i];void 0!==n&&t.append(i,n)}return t}t.PDFFetchStream=class PDFFetchStream{constructor(e){this.source=e;this.isHttp=/^https?:/i.test(e.url);this.httpHeaders=this.isHttp&&e.httpHeaders||{};this._fullRequestReader=null;this._rangeRequestReaders=[]}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFFetchStream.getFullReader can only be called once.");this._fullRequestReader=new PDFFetchStreamReader(this);return this._fullRequestReader}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=new PDFFetchStreamRangeReader(this,e,t);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class PDFFetchStreamReader{constructor(e){this._stream=e;this._reader=null;this._loaded=0;this._filename=null;const t=e.source;this._withCredentials=t.withCredentials||!1;this._contentLength=t.length;this._headersCapability=(0,n.createPromiseCapability)();this._disableRange=t.disableRange||!1;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);"undefined"!=typeof AbortController&&(this._abortController=new AbortController);this._isStreamingSupported=!t.disableStream;this._isRangeSupported=!t.disableRange;this._headers=createHeaders(this._stream.httpHeaders);const i=t.url;fetch(i,createFetchOptions(this._headers,this._withCredentials,this._abortController)).then((e=>{if(!(0,s.validateResponseStatus)(e.status))throw(0,s.createResponseStatusError)(e.status,i);this._reader=e.body.getReader();this._headersCapability.resolve();const getResponseHeader=t=>e.headers.get(t),{allowRangeRequests:t,suggestedLength:r}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:this._stream.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});this._isRangeSupported=t;this._contentLength=r||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader);!this._isStreamingSupported&&this._isRangeSupported&&this.cancel(new n.AbortException("Streaming is disabled."))})).catch(this._headersCapability.reject);this.onProgress=null}get headersReady(){return this._headersCapability.promise}get filename(){return this._filename}get contentLength(){return this._contentLength}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._headersCapability.promise;const{value:e,done:t}=await this._reader.read();if(t)return{value:e,done:t};this._loaded+=e.byteLength;this.onProgress&&this.onProgress({loaded:this._loaded,total:this._contentLength});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._reader&&this._reader.cancel(e);this._abortController&&this._abortController.abort()}}class PDFFetchStreamRangeReader{constructor(e,t,i){this._stream=e;this._reader=null;this._loaded=0;const r=e.source;this._withCredentials=r.withCredentials||!1;this._readCapability=(0,n.createPromiseCapability)();this._isStreamingSupported=!r.disableStream;"undefined"!=typeof AbortController&&(this._abortController=new AbortController);this._headers=createHeaders(this._stream.httpHeaders);this._headers.append("Range",`bytes=${t}-${i-1}`);const a=r.url;fetch(a,createFetchOptions(this._headers,this._withCredentials,this._abortController)).then((e=>{if(!(0,s.validateResponseStatus)(e.status))throw(0,s.createResponseStatusError)(e.status,a);this._readCapability.resolve();this._reader=e.body.getReader()})).catch(this._readCapability.reject);this.onProgress=null}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;const{value:e,done:t}=await this._reader.read();if(t)return{value:e,done:t};this._loaded+=e.byteLength;this.onProgress&&this.onProgress({loaded:this._loaded});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._reader&&this._reader.cancel(e);this._abortController&&this._abortController.abort()}}}],__webpack_module_cache__={};function __w_pdfjs_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var i=__webpack_module_cache__[e]={exports:{}};__webpack_modules__[e](i,i.exports,__w_pdfjs_require__);return i.exports}var __webpack_exports__={};(()=>{var e=__webpack_exports__;Object.defineProperty(e,"__esModule",{value:!0});Object.defineProperty(e,"AnnotationLayer",{enumerable:!0,get:function(){return s.AnnotationLayer}});Object.defineProperty(e,"AnnotationMode",{enumerable:!0,get:function(){return i.AnnotationMode}});Object.defineProperty(e,"CMapCompressionType",{enumerable:!0,get:function(){return i.CMapCompressionType}});Object.defineProperty(e,"GlobalWorkerOptions",{enumerable:!0,get:function(){return r.GlobalWorkerOptions}});Object.defineProperty(e,"InvalidPDFException",{enumerable:!0,get:function(){return i.InvalidPDFException}});Object.defineProperty(e,"LinkTarget",{enumerable:!0,get:function(){return t.LinkTarget}});Object.defineProperty(e,"LoopbackPort",{enumerable:!0,get:function(){return n.LoopbackPort}});Object.defineProperty(e,"MissingPDFException",{enumerable:!0,get:function(){return i.MissingPDFException}});Object.defineProperty(e,"OPS",{enumerable:!0,get:function(){return i.OPS}});Object.defineProperty(e,"PDFDataRangeTransport",{enumerable:!0,get:function(){return n.PDFDataRangeTransport}});Object.defineProperty(e,"PDFDateString",{enumerable:!0,get:function(){return t.PDFDateString}});Object.defineProperty(e,"PDFWorker",{enumerable:!0,get:function(){return n.PDFWorker}});Object.defineProperty(e,"PasswordResponses",{enumerable:!0,get:function(){return i.PasswordResponses}});Object.defineProperty(e,"PermissionFlag",{enumerable:!0,get:function(){return i.PermissionFlag}});Object.defineProperty(e,"PixelsPerInch",{enumerable:!0,get:function(){return t.PixelsPerInch}});Object.defineProperty(e,"RenderingCancelledException",{enumerable:!0,get:function(){return t.RenderingCancelledException}});Object.defineProperty(e,"SVGGraphics",{enumerable:!0,get:function(){return l.SVGGraphics}});Object.defineProperty(e,"UNSUPPORTED_FEATURES",{enumerable:!0,get:function(){return i.UNSUPPORTED_FEATURES}});Object.defineProperty(e,"UnexpectedResponseException",{enumerable:!0,get:function(){return i.UnexpectedResponseException}});Object.defineProperty(e,"Util",{enumerable:!0,get:function(){return i.Util}});Object.defineProperty(e,"VerbosityLevel",{enumerable:!0,get:function(){return i.VerbosityLevel}});Object.defineProperty(e,"XfaLayer",{enumerable:!0,get:function(){return c.XfaLayer}});Object.defineProperty(e,"addLinkAttributes",{enumerable:!0,get:function(){return t.addLinkAttributes}});Object.defineProperty(e,"build",{enumerable:!0,get:function(){return n.build}});Object.defineProperty(e,"createObjectURL",{enumerable:!0,get:function(){return i.createObjectURL}});Object.defineProperty(e,"createPromiseCapability",{enumerable:!0,get:function(){return i.createPromiseCapability}});Object.defineProperty(e,"createValidAbsoluteUrl",{enumerable:!0,get:function(){return i.createValidAbsoluteUrl}});Object.defineProperty(e,"getDocument",{enumerable:!0,get:function(){return n.getDocument}});Object.defineProperty(e,"getFilenameFromUrl",{enumerable:!0,get:function(){return t.getFilenameFromUrl}});Object.defineProperty(e,"getPdfFilenameFromUrl",{enumerable:!0,get:function(){return t.getPdfFilenameFromUrl}});Object.defineProperty(e,"getXfaPageViewport",{enumerable:!0,get:function(){return t.getXfaPageViewport}});Object.defineProperty(e,"isPdfFile",{enumerable:!0,get:function(){return t.isPdfFile}});Object.defineProperty(e,"loadScript",{enumerable:!0,get:function(){return t.loadScript}});Object.defineProperty(e,"removeNullCharacters",{enumerable:!0,get:function(){return i.removeNullCharacters}});Object.defineProperty(e,"renderTextLayer",{enumerable:!0,get:function(){return o.renderTextLayer}});Object.defineProperty(e,"shadow",{enumerable:!0,get:function(){return i.shadow}});Object.defineProperty(e,"version",{enumerable:!0,get:function(){return n.version}});var t=__w_pdfjs_require__(1),i=__w_pdfjs_require__(2),n=__w_pdfjs_require__(6),s=__w_pdfjs_require__(18),r=__w_pdfjs_require__(12),a=__w_pdfjs_require__(4),o=__w_pdfjs_require__(21),l=__w_pdfjs_require__(22),c=__w_pdfjs_require__(20);if(a.isNodeJS){const{PDFNodeStream:e}=__w_pdfjs_require__(23);(0,n.setPDFNetworkStreamFactory)((t=>new e(t)))}else{const{PDFNetworkStream:e}=__w_pdfjs_require__(26),{PDFFetchStream:i}=__w_pdfjs_require__(27);(0,n.setPDFNetworkStreamFactory)((n=>(0,t.isValidFetchUrl)(n.url)?new i(n):new e(n)))}})();return __webpack_exports__})()}));
/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */(()=>{"use strict";var e=[,(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.compatibilityParams=t.OptionKind=t.AppOptions=void 0;const i=Object.create(null);t.compatibilityParams=i;{const e="undefined"!=typeof navigator&&navigator.userAgent||"",t="undefined"!=typeof navigator&&navigator.platform||"",n="undefined"!=typeof navigator&&navigator.maxTouchPoints||1,s=/Android/.test(e),r=/\b(iPad|iPhone|iPod)(?=;)/.test(e)||"MacIntel"===t&&n>1,a=/CriOS/.test(e);!function checkOnBlobSupport(){a&&(i.disableCreateObjectURL=!0)}();!function checkCanvasSizeLimitation(){(r||s)&&(i.maxCanvasPixels=5242880)}()}const n={VIEWER:2,API:4,WORKER:8,PREFERENCE:128};t.OptionKind=n;const s={annotationMode:{value:2,kind:n.VIEWER+n.PREFERENCE},cursorToolOnLoad:{value:0,kind:n.VIEWER+n.PREFERENCE},defaultUrl:{value:"compressed.tracemonkey-pldi-09.pdf",kind:n.VIEWER},defaultZoomValue:{value:"",kind:n.VIEWER+n.PREFERENCE},disableHistory:{value:!1,kind:n.VIEWER},disablePageLabels:{value:!1,kind:n.VIEWER+n.PREFERENCE},enablePermissions:{value:!1,kind:n.VIEWER+n.PREFERENCE},enablePrintAutoRotate:{value:!0,kind:n.VIEWER+n.PREFERENCE},enableScripting:{value:!0,kind:n.VIEWER+n.PREFERENCE},externalLinkRel:{value:"noopener noreferrer nofollow",kind:n.VIEWER},externalLinkTarget:{value:0,kind:n.VIEWER+n.PREFERENCE},historyUpdateUrl:{value:!1,kind:n.VIEWER+n.PREFERENCE},ignoreDestinationZoom:{value:!1,kind:n.VIEWER+n.PREFERENCE},imageResourcesPath:{value:"./images/",kind:n.VIEWER},maxCanvasPixels:{value:16777216,compatibility:i.maxCanvasPixels,kind:n.VIEWER},pdfBugEnabled:{value:!1,kind:n.VIEWER+n.PREFERENCE},printResolution:{value:150,kind:n.VIEWER},renderer:{value:"canvas",kind:n.VIEWER},sidebarViewOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},scrollModeOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},spreadModeOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},textLayerMode:{value:1,kind:n.VIEWER+n.PREFERENCE},useOnlyCssZoom:{value:!1,kind:n.VIEWER+n.PREFERENCE},viewerCssTheme:{value:0,kind:n.VIEWER+n.PREFERENCE},viewOnLoad:{value:0,kind:n.VIEWER+n.PREFERENCE},cMapPacked:{value:!0,kind:n.API},cMapUrl:{value:"../web/cmaps/",kind:n.API},disableAutoFetch:{value:!1,kind:n.API+n.PREFERENCE},disableFontFace:{value:!1,kind:n.API+n.PREFERENCE},disableRange:{value:!1,kind:n.API+n.PREFERENCE},disableStream:{value:!1,kind:n.API+n.PREFERENCE},docBaseUrl:{value:"",kind:n.API},enableXfa:{value:!0,kind:n.API+n.PREFERENCE},fontExtraProperties:{value:!1,kind:n.API},isEvalSupported:{value:!0,kind:n.API},maxImageSize:{value:-1,kind:n.API},pdfBug:{value:!1,kind:n.API},standardFontDataUrl:{value:"../web/standard_fonts/",kind:n.API},verbosity:{value:1,kind:n.API},workerPort:{value:null,kind:n.WORKER},workerSrc:{value:"../build/pdf.worker.js",kind:n.WORKER}};s.disablePreferences={value:!1,kind:n.VIEWER};s.locale={value:"undefined"!=typeof navigator?navigator.language:"en-US",kind:n.VIEWER};s.sandboxBundleSrc={value:"../build/pdf.sandbox.js",kind:n.VIEWER};s.renderer.kind+=n.PREFERENCE;const r=Object.create(null);t.AppOptions=class AppOptions{constructor(){throw new Error("Cannot initialize AppOptions.")}static get(e){const t=r[e];if(void 0!==t)return t;const i=s[e];return void 0!==i?i.compatibility??i.value:void 0}static getAll(e=null){const t=Object.create(null);for(const i in s){const a=s[i];if(e){if(0==(e&a.kind))continue;if(e===n.PREFERENCE){const e=a.value,n=typeof e;if("boolean"===n||"string"===n||"number"===n&&Number.isInteger(e)){t[i]=e;continue}throw new Error(`Invalid type for preference: ${i}`)}}const o=r[i];t[i]=void 0!==o?o:a.compatibility??a.value}return t}static set(e,t){r[e]=t}static setAll(e){for(const t in e)r[t]=e[t]}static remove(e){delete r[e]}static _hasUserOptions(){return Object.keys(r).length>0}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFViewerApplication=t.PDFPrintServiceFactory=t.DefaultExternalServices=void 0;var n=i(3),s=i(1),r=i(4),a=i(5),o=i(6),l=i(8),c=i(9),h=i(10),d=i(12),u=i(13),p=i(14),g=i(16),f=i(17),m=i(18),_=i(19),b=i(20),v=i(21),w=i(22),y=i(23),S=i(24),P=i(25),A=i(27),C=i(36),x=i(37),E=i(38);const T=-1,k=1,L={AUTOMATIC:0,LIGHT:1,DARK:2},M=["1.0","1.1","1.2","1.3","1.4","1.5","1.6","1.7","1.8","1.9","2.0","2.1","2.2","2.3"],F=["acrobat distiller","acrobat pdfwriter","adobe livecycle","adobe pdf library","adobe photoshop","ghostscript","tcpdf","cairo","dvipdfm","dvips","pdftex","pdfkit","itext","prince","quarkxpress","mac os x","microsoft","openoffice","oracle","luradocument","pdf-xchange","antenna house","aspose.cells","fpdf"];class DefaultExternalServices{constructor(){throw new Error("Cannot initialize DefaultExternalServices.")}static updateFindControlState(e){}static updateFindMatchesCount(e){}static initPassiveLoading(e){}static async fallback(e){}static reportTelemetry(e){}static createDownloadManager(e){throw new Error("Not implemented: createDownloadManager")}static createPreferences(){throw new Error("Not implemented: createPreferences")}static createL10n(e){throw new Error("Not implemented: createL10n")}static createScripting(e){throw new Error("Not implemented: createScripting")}static get supportsIntegratedFind(){return(0,a.shadow)(this,"supportsIntegratedFind",!1)}static get supportsDocumentFonts(){return(0,a.shadow)(this,"supportsDocumentFonts",!0)}static get supportedMouseWheelZoomModifierKeys(){return(0,a.shadow)(this,"supportedMouseWheelZoomModifierKeys",{ctrlKey:!0,metaKey:!0})}static get isInAutomation(){return(0,a.shadow)(this,"isInAutomation",!1)}}t.DefaultExternalServices=DefaultExternalServices;const R={initialBookmark:document.location.hash.substring(1),_initializedCapability:(0,a.createPromiseCapability)(),_fellback:!1,appConfig:null,pdfDocument:null,pdfLoadingTask:null,printService:null,pdfViewer:null,pdfThumbnailViewer:null,pdfRenderingQueue:null,pdfPresentationMode:null,pdfDocumentProperties:null,pdfLinkService:null,pdfHistory:null,pdfSidebar:null,pdfSidebarResizer:null,pdfOutlineViewer:null,pdfAttachmentViewer:null,pdfLayerViewer:null,pdfCursorTools:null,pdfScriptingManager:null,store:null,downloadManager:null,overlayManager:null,preferences:null,toolbar:null,secondaryToolbar:null,eventBus:null,l10n:null,isInitialViewSet:!1,downloadComplete:!1,isViewerEmbedded:window.parent!==window,url:"",baseUrl:"",_downloadUrl:"",externalServices:DefaultExternalServices,_boundEvents:Object.create(null),documentInfo:null,metadata:null,_contentDispositionFilename:null,_contentLength:null,_saveInProgress:!1,_docStats:null,_wheelUnusedTicks:0,_idleCallbacks:new Set,async initialize(e){this.preferences=this.externalServices.createPreferences();this.appConfig=e;await this._readPreferences();await this._parseHashParameters();this._forceCssTheme();await this._initializeL10n();this.isViewerEmbedded&&s.AppOptions.get("externalLinkTarget")===a.LinkTarget.NONE&&s.AppOptions.set("externalLinkTarget",a.LinkTarget.TOP);await this._initializeViewerComponents();this.bindEvents();this.bindWindowEvents();const t=e.appContainer||document.documentElement;this.l10n.translate(t).then((()=>{this.eventBus.dispatch("localized",{source:this})}));this._initializedCapability.resolve()},async _readPreferences(){if(!s.AppOptions.get("disablePreferences")){s.AppOptions._hasUserOptions()&&console.warn('_readPreferences: The Preferences may override manually set AppOptions; please use the "disablePreferences"-option in order to prevent that.');try{s.AppOptions.setAll(await this.preferences.getAll())}catch(e){console.error(`_readPreferences: "${e?.message}".`)}}},async _parseHashParameters(){if(!s.AppOptions.get("pdfBugEnabled"))return;const e=document.location.hash.substring(1);if(!e)return;const t=(0,n.parseQueryString)(e),i=[];"true"===t.get("disableworker")&&i.push(async function loadFakeWorker(){a.GlobalWorkerOptions.workerSrc||(a.GlobalWorkerOptions.workerSrc=s.AppOptions.get("workerSrc"));await(0,a.loadScript)(a.PDFWorker.workerSrc)}());t.has("disablerange")&&s.AppOptions.set("disableRange","true"===t.get("disablerange"));t.has("disablestream")&&s.AppOptions.set("disableStream","true"===t.get("disablestream"));t.has("disableautofetch")&&s.AppOptions.set("disableAutoFetch","true"===t.get("disableautofetch"));t.has("disablefontface")&&s.AppOptions.set("disableFontFace","true"===t.get("disablefontface"));t.has("disablehistory")&&s.AppOptions.set("disableHistory","true"===t.get("disablehistory"));t.has("verbosity")&&s.AppOptions.set("verbosity",0|t.get("verbosity"));if(t.has("textlayer"))switch(t.get("textlayer")){case"off":s.AppOptions.set("textLayerMode",n.TextLayerMode.DISABLE);break;case"visible":case"shadow":case"hover":this.appConfig.viewerContainer.classList.add(`textLayer-${t.get("textlayer")}`)}if(t.has("pdfbug")){s.AppOptions.set("pdfBug",!0);s.AppOptions.set("fontExtraProperties",!0);const e=t.get("pdfbug").split(",");i.push(async function initPDFBug(e){const{debuggerScriptPath:t,mainContainer:i}=R.appConfig;await(0,a.loadScript)(t);PDFBug.init({OPS:a.OPS},i,e)}(e))}t.has("locale")&&s.AppOptions.set("locale",t.get("locale"));if(0!==i.length)try{await Promise.all(i)}catch(e){console.error(`_parseHashParameters: "${e.message}".`)}},async _initializeL10n(){this.l10n=this.externalServices.createL10n({locale:s.AppOptions.get("locale")});const e=await this.l10n.getDirection();document.getElementsByTagName("html")[0].dir=e},_forceCssTheme(){const e=s.AppOptions.get("viewerCssTheme");if(e!==L.AUTOMATIC&&Object.values(L).includes(e))try{const t=document.styleSheets[0],i=t?.cssRules||[];for(let n=0,s=i.length;n<s;n++){const s=i[n];if(s instanceof CSSMediaRule&&"(prefers-color-scheme: dark)"===s.media?.[0]){if(e===L.LIGHT){t.deleteRule(n);return}const i=/^@media \(prefers-color-scheme: dark\) {\n\s*([\w\s-.,:;/\\{}()]+)\n}$/.exec(s.cssText);if(i?.[1]){t.deleteRule(n);t.insertRule(i[1],n)}return}}}catch(e){console.error(`_forceCssTheme: "${e?.message}".`)}},async _initializeViewerComponents(){const{appConfig:e,externalServices:t}=this;let i;i=e.eventBus?e.eventBus:t.isInAutomation?new r.AutomationEventBus:new r.EventBus;this.eventBus=i;this.overlayManager=new l.OverlayManager;const n=new v.PDFRenderingQueue;n.onIdle=this._cleanup.bind(this);this.pdfRenderingQueue=n;const a=new m.PDFLinkService({eventBus:i,externalLinkTarget:s.AppOptions.get("externalLinkTarget"),externalLinkRel:s.AppOptions.get("externalLinkRel"),ignoreDestinationZoom:s.AppOptions.get("ignoreDestinationZoom")});this.pdfLinkService=a;const E=t.createDownloadManager();this.downloadManager=E;const T=new p.PDFFindController({linkService:a,eventBus:i});this.findController=T;const k=new w.PDFScriptingManager({eventBus:i,sandboxBundleSrc:s.AppOptions.get("sandboxBundleSrc"),scriptingFactory:t,docPropertiesLookup:this._scriptingDocProperties.bind(this)});this.pdfScriptingManager=k;const L=e.mainContainer,M=e.viewerContainer;this.pdfViewer=new A.PDFViewer({container:L,viewer:M,eventBus:i,renderingQueue:n,linkService:a,downloadManager:E,findController:T,scriptingManager:s.AppOptions.get("enableScripting")&&k,renderer:s.AppOptions.get("renderer"),l10n:this.l10n,textLayerMode:s.AppOptions.get("textLayerMode"),annotationMode:s.AppOptions.get("annotationMode"),imageResourcesPath:s.AppOptions.get("imageResourcesPath"),enablePrintAutoRotate:s.AppOptions.get("enablePrintAutoRotate"),useOnlyCssZoom:s.AppOptions.get("useOnlyCssZoom"),maxCanvasPixels:s.AppOptions.get("maxCanvasPixels"),enablePermissions:s.AppOptions.get("enablePermissions")});n.setViewer(this.pdfViewer);a.setViewer(this.pdfViewer);k.setViewer(this.pdfViewer);this.pdfThumbnailViewer=new P.PDFThumbnailViewer({container:e.sidebar.thumbnailView,eventBus:i,renderingQueue:n,linkService:a,l10n:this.l10n});n.setThumbnailViewer(this.pdfThumbnailViewer);if(!this.isViewerEmbedded&&!s.AppOptions.get("disableHistory")){this.pdfHistory=new g.PDFHistory({linkService:a,eventBus:i});a.setHistory(this.pdfHistory)}this.supportsIntegratedFind||(this.findBar=new u.PDFFindBar(e.findBar,i,this.l10n));this.pdfDocumentProperties=new d.PDFDocumentProperties(e.documentProperties,this.overlayManager,i,this.l10n);this.pdfCursorTools=new o.PDFCursorTools({container:L,eventBus:i,cursorToolOnLoad:s.AppOptions.get("cursorToolOnLoad")});this.toolbar=new x.Toolbar(e.toolbar,i,this.l10n);this.secondaryToolbar=new C.SecondaryToolbar(e.secondaryToolbar,L,i);this.supportsFullscreen&&(this.pdfPresentationMode=new b.PDFPresentationMode({container:L,pdfViewer:this.pdfViewer,eventBus:i}));this.passwordPrompt=new c.PasswordPrompt(e.passwordOverlay,this.overlayManager,this.l10n,this.isViewerEmbedded);this.pdfOutlineViewer=new _.PDFOutlineViewer({container:e.sidebar.outlineView,eventBus:i,linkService:a});this.pdfAttachmentViewer=new h.PDFAttachmentViewer({container:e.sidebar.attachmentsView,eventBus:i,downloadManager:E});this.pdfLayerViewer=new f.PDFLayerViewer({container:e.sidebar.layersView,eventBus:i,l10n:this.l10n});this.pdfSidebar=new y.PDFSidebar({elements:e.sidebar,pdfViewer:this.pdfViewer,pdfThumbnailViewer:this.pdfThumbnailViewer,eventBus:i,l10n:this.l10n});this.pdfSidebar.onToggled=this.forceRendering.bind(this);this.pdfSidebarResizer=new S.PDFSidebarResizer(e.sidebarResizer,i,this.l10n)},run(e){this.initialize(e).then(webViewerInitialized)},get initialized(){return this._initializedCapability.settled},get initializedPromise(){return this._initializedCapability.promise},zoomIn(e){this.pdfViewer.isInPresentationMode||this.pdfViewer.increaseScale(e)},zoomOut(e){this.pdfViewer.isInPresentationMode||this.pdfViewer.decreaseScale(e)},zoomReset(){this.pdfViewer.isInPresentationMode||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0},get page(){return this.pdfViewer.currentPageNumber},set page(e){this.pdfViewer.currentPageNumber=e},get supportsPrinting(){return B.instance.supportsPrinting},get supportsFullscreen(){return(0,a.shadow)(this,"supportsFullscreen",document.fullscreenEnabled||document.mozFullScreenEnabled||document.webkitFullscreenEnabled)},get supportsIntegratedFind(){return this.externalServices.supportsIntegratedFind},get supportsDocumentFonts(){return this.externalServices.supportsDocumentFonts},get loadingBar(){const e=new n.ProgressBar("#loadingBar");return(0,a.shadow)(this,"loadingBar",e)},get supportedMouseWheelZoomModifierKeys(){return this.externalServices.supportedMouseWheelZoomModifierKeys},initPassiveLoading(){throw new Error("Not implemented: initPassiveLoading")},setTitleUsingUrl(e="",t=null){this.url=e;this.baseUrl=e.split("#")[0];t&&(this._downloadUrl=t===e?this.baseUrl:t.split("#")[0]);let i=(0,a.getPdfFilenameFromUrl)(e,"");if(!i)try{i=decodeURIComponent((0,a.getFilenameFromUrl)(e))||e}catch(t){i=e}this.setTitle(i)},setTitle(e){this.isViewerEmbedded||(document.title=e)},get _docFilename(){return this._contentDispositionFilename||(0,a.getPdfFilenameFromUrl)(this.url)},_hideViewBookmark(){const{toolbar:e,secondaryToolbar:t}=this.appConfig;e.viewBookmark.hidden=!0;t.viewBookmarkButton.hidden=!0},_cancelIdleCallbacks(){if(this._idleCallbacks.size){for(const e of this._idleCallbacks)window.cancelIdleCallback(e);this._idleCallbacks.clear()}},async close(){this._unblockDocumentLoadEvent();this._hideViewBookmark();const{container:e}=this.appConfig.errorWrapper;e.hidden=!0;if(!this.pdfLoadingTask)return;if(this.pdfDocument?.annotationStorage.size>0&&this._annotationStorageModified)try{await this.save({sourceEventType:"save"})}catch(e){}const t=[];t.push(this.pdfLoadingTask.destroy());this.pdfLoadingTask=null;if(this.pdfDocument){this.pdfDocument=null;this.pdfThumbnailViewer.setDocument(null);this.pdfViewer.setDocument(null);this.pdfLinkService.setDocument(null);this.pdfDocumentProperties.setDocument(null)}this.pdfLinkService.externalLinkEnabled=!0;this._fellback=!1;this.store=null;this.isInitialViewSet=!1;this.downloadComplete=!1;this.url="";this.baseUrl="";this._downloadUrl="";this.documentInfo=null;this.metadata=null;this._contentDispositionFilename=null;this._contentLength=null;this._saveInProgress=!1;this._docStats=null;this._cancelIdleCallbacks();t.push(this.pdfScriptingManager.destroyPromise);this.pdfSidebar.reset();this.pdfOutlineViewer.reset();this.pdfAttachmentViewer.reset();this.pdfLayerViewer.reset();this.pdfHistory?.reset();this.findBar?.reset();this.toolbar.reset();this.secondaryToolbar.reset();"undefined"!=typeof PDFBug&&PDFBug.cleanup();await Promise.all(t)},async open(e,t){this.pdfLoadingTask&&await this.close();const i=s.AppOptions.getAll(s.OptionKind.WORKER);for(const e in i)a.GlobalWorkerOptions[e]=i[e];const n=Object.create(null);if("string"==typeof e){this.setTitleUsingUrl(e,e);n.url=e}else if(e&&"byteLength"in e)n.data=e;else if(e.url&&e.originalUrl){this.setTitleUsingUrl(e.originalUrl,e.url);n.url=e.url}const r=s.AppOptions.getAll(s.OptionKind.API);for(const e in r){let t=r[e];n[e]=t}if(t)for(const e in t)n[e]=t[e];const o=(0,a.getDocument)(n);this.pdfLoadingTask=o;o.onPassword=(e,t)=>{this.pdfLinkService.externalLinkEnabled=!1;this.passwordPrompt.setUpdateCallback(e,t);this.passwordPrompt.open()};o.onProgress=({loaded:e,total:t})=>{this.progress(e/t)};o.onUnsupportedFeature=this.fallback.bind(this);return o.promise.then((e=>{this.load(e)}),(e=>{if(o!==this.pdfLoadingTask)return;let t="loading_error";e instanceof a.InvalidPDFException?t="invalid_file_error":e instanceof a.MissingPDFException?t="missing_file_error":e instanceof a.UnexpectedResponseException&&(t="unexpected_response_error");return this.l10n.get(t).then((t=>{this._documentError(t,{message:e?.message});throw e}))}))},_ensureDownloadComplete(){if(!this.pdfDocument||!this.downloadComplete)throw new Error("PDF document not downloaded.")},async download({sourceEventType:e="download"}={}){const t=this._downloadUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.getData(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch(e){await this.downloadManager.downloadUrl(t,i)}},async save({sourceEventType:e="download"}={}){if(this._saveInProgress)return;this._saveInProgress=!0;await this.pdfScriptingManager.dispatchWillSave();const t=this._downloadUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.saveDocument(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch(t){console.error(`Error when saving the document: ${t.message}`);await this.download({sourceEventType:e})}finally{await this.pdfScriptingManager.dispatchDidSave();this._saveInProgress=!1}},downloadOrSave(e){this.pdfDocument?.annotationStorage.size>0?this.save(e):this.download(e)},fallback(e){this.externalServices.reportTelemetry({type:"unsupportedFeature",featureId:e});if(!this._fellback){this._fellback=!0;this.externalServices.fallback({featureId:e,url:this.baseUrl}).then((e=>{e&&this.download({sourceEventType:"download"})}))}},_documentError(e,t=null){this._unblockDocumentLoadEvent();this._otherError(e,t)},_otherError(e,t=null){const i=[this.l10n.get("error_version_info",{version:a.version||"?",build:a.build||"?"})];if(t){i.push(this.l10n.get("error_message",{message:t.message}));if(t.stack)i.push(this.l10n.get("error_stack",{stack:t.stack}));else{t.filename&&i.push(this.l10n.get("error_file",{file:t.filename}));t.lineNumber&&i.push(this.l10n.get("error_line",{line:t.lineNumber}))}}const s=this.appConfig.errorWrapper,r=s.container;r.hidden=!1;s.errorMessage.textContent=e;const o=s.closeButton;o.onclick=function(){r.hidden=!0};const l=s.errorMoreInfo,c=s.moreInfoButton,h=s.lessInfoButton;c.onclick=function(){l.hidden=!1;c.hidden=!0;h.hidden=!1;l.style.height=l.scrollHeight+"px"};h.onclick=function(){l.hidden=!0;c.hidden=!1;h.hidden=!0};c.oncontextmenu=n.noContextMenuHandler;h.oncontextmenu=n.noContextMenuHandler;o.oncontextmenu=n.noContextMenuHandler;c.hidden=!1;h.hidden=!0;Promise.all(i).then((e=>{l.value=e.join("\n")}))},progress(e){if(this.downloadComplete)return;const t=Math.round(100*e);if(t>this.loadingBar.percent||isNaN(t)){this.loadingBar.percent=t;if((this.pdfDocument?this.pdfDocument.loadingParams.disableAutoFetch:s.AppOptions.get("disableAutoFetch"))&&t){if(this.disableAutoFetchLoadingBarTimeout){clearTimeout(this.disableAutoFetchLoadingBarTimeout);this.disableAutoFetchLoadingBarTimeout=null}this.loadingBar.show();this.disableAutoFetchLoadingBarTimeout=setTimeout((()=>{this.loadingBar.hide();this.disableAutoFetchLoadingBarTimeout=null}),5e3)}}},load(e){this.pdfDocument=e;e.getDownloadInfo().then((({length:e})=>{this._contentLength=e;this.downloadComplete=!0;this.loadingBar.hide();l.then((()=>{this.eventBus.dispatch("documentloaded",{source:this})}))}));const t=e.getPageLayout().catch((function(){})),i=e.getPageMode().catch((function(){})),r=e.getOpenAction().catch((function(){}));this.toolbar.setPagesCount(e.numPages,!1);this.secondaryToolbar.setPagesCount(e.numPages);let a;a=null;this.pdfLinkService.setDocument(e,null);this.pdfDocumentProperties.setDocument(e,this.url);const o=this.pdfViewer;o.setDocument(e);const{firstPagePromise:l,onePageRendered:c,pagesPromise:h}=o;this.pdfThumbnailViewer.setDocument(e);const d=(this.store=new E.ViewHistory(e.fingerprints[0])).getMultiple({page:null,zoom:n.DEFAULT_SCALE_VALUE,scrollLeft:"0",scrollTop:"0",rotation:null,sidebarView:n.SidebarView.UNKNOWN,scrollMode:n.ScrollMode.UNKNOWN,spreadMode:n.SpreadMode.UNKNOWN}).catch((()=>Object.create(null)));l.then((a=>{this.loadingBar.setWidth(this.appConfig.viewerContainer);this._initializeAnnotationStorageCallbacks(e);Promise.all([n.animationStarted,d,t,i,r]).then((async([t,i,r,a,l])=>{const c=s.AppOptions.get("viewOnLoad");this._initializePdfHistory({fingerprint:e.fingerprints[0],viewOnLoad:c,initialDest:l?.dest});const d=this.initialBookmark,u=s.AppOptions.get("defaultZoomValue");let p=u?`zoom=${u}`:null,g=null,f=s.AppOptions.get("sidebarViewOnLoad"),m=s.AppOptions.get("scrollModeOnLoad"),_=s.AppOptions.get("spreadModeOnLoad");if(i.page&&c!==k){p=`page=${i.page}&zoom=${u||i.zoom},${i.scrollLeft},${i.scrollTop}`;g=parseInt(i.rotation,10);f===n.SidebarView.UNKNOWN&&(f=0|i.sidebarView);m===n.ScrollMode.UNKNOWN&&(m=0|i.scrollMode);_===n.SpreadMode.UNKNOWN&&(_=0|i.spreadMode)}a&&f===n.SidebarView.UNKNOWN&&(f=(0,n.apiPageModeToSidebarView)(a));if(r&&m===n.ScrollMode.UNKNOWN&&_===n.SpreadMode.UNKNOWN){_=(0,n.apiPageLayoutToViewerModes)(r).spreadMode}this.setInitialView(p,{rotation:g,sidebarView:f,scrollMode:m,spreadMode:_});this.eventBus.dispatch("documentinit",{source:this});this.isViewerEmbedded||o.focus();await Promise.race([h,new Promise((e=>{setTimeout(e,1e4)}))]);if((d||p)&&!o.hasEqualPageSizes){this.initialBookmark=d;o.currentScaleValue=o.currentScaleValue;this.setInitialView(p)}})).catch((()=>{this.setInitialView()})).then((function(){o.update()}))}));h.then((()=>{this._unblockDocumentLoadEvent();this._initializeAutoPrint(e,r)}),(e=>{this.l10n.get("loading_error").then((t=>{this._documentError(t,{message:e?.message})}))}));c.then((t=>{this.externalServices.reportTelemetry({type:"pageInfo",timestamp:t.timestamp});e.getOutline().then((t=>{e===this.pdfDocument&&this.pdfOutlineViewer.render({outline:t,pdfDocument:e})}));e.getAttachments().then((t=>{e===this.pdfDocument&&this.pdfAttachmentViewer.render({attachments:t})}));o.optionalContentConfigPromise.then((t=>{e===this.pdfDocument&&this.pdfLayerViewer.render({optionalContentConfig:t,pdfDocument:e})}));if("requestIdleCallback"in window){const t=window.requestIdleCallback((()=>{this._collectTelemetry(e);this._idleCallbacks.delete(t)}),{timeout:1e3});this._idleCallbacks.add(t)}}));this._initializePageLabels(e);this._initializeMetadata(e)},async _scriptingDocProperties(e){if(!this.documentInfo){await new Promise((e=>{this.eventBus._on("metadataloaded",e,{once:!0})}));if(e!==this.pdfDocument)return null}if(!this._contentLength){await new Promise((e=>{this.eventBus._on("documentloaded",e,{once:!0})}));if(e!==this.pdfDocument)return null}return{...this.documentInfo,baseURL:this.baseUrl,filesize:this._contentLength,filename:this._docFilename,metadata:this.metadata?.getRaw(),authors:this.metadata?.get("dc:creator"),numPages:this.pagesCount,URL:this.url}},async _collectTelemetry(e){const t=await this.pdfDocument.getMarkInfo();if(e!==this.pdfDocument)return;const i=t?.Marked||!1;this.externalServices.reportTelemetry({type:"tagged",tagged:i})},async _initializeAutoPrint(e,t){const[i,s]=await Promise.all([t,this.pdfViewer.enableScripting?null:e.getJavaScript()]);if(e!==this.pdfDocument)return;let r=!1;"Print"===i?.action&&(r=!0);if(s){s.some((e=>{if(!e)return!1;console.warn("Warning: JavaScript support is not enabled");this.fallback(a.UNSUPPORTED_FEATURES.javaScript);return!0}));if(!r)for(const e of s)if(e&&n.AutoPrintRegExp.test(e)){r=!0;break}}r&&this.triggerPrinting()},async _initializeMetadata(e){const{info:t,metadata:i,contentDispositionFilename:n,contentLength:s}=await e.getMetadata();if(e!==this.pdfDocument)return;this.documentInfo=t;this.metadata=i;this._contentDispositionFilename??=n;this._contentLength??=s;console.log(`PDF ${e.fingerprints[0]} [${t.PDFFormatVersion} ${(t.Producer||"-").trim()} / ${(t.Creator||"-").trim()}] (PDF.js: ${a.version||"-"})`);let r=t?.Title;const o=i?.get("dc:title");o&&("Untitled"===o||/[\uFFF0-\uFFFF]/g.test(o)||(r=o));r?this.setTitle(`${r} - ${n||document.title}`):n&&this.setTitle(n);if(!t.IsXFAPresent||t.IsAcroFormPresent||e.isPureXfa){if((t.IsAcroFormPresent||t.IsXFAPresent)&&!this.pdfViewer.renderForms){console.warn("Warning: Interactive form support is not enabled");this.fallback(a.UNSUPPORTED_FEATURES.forms)}}else{e.loadingParams.enableXfa?console.warn("Warning: XFA Foreground documents are not supported"):console.warn("Warning: XFA support is not enabled");this.fallback(a.UNSUPPORTED_FEATURES.forms)}if(t.IsSignaturesPresent){console.warn("Warning: Digital signatures validation is not supported");this.fallback(a.UNSUPPORTED_FEATURES.signatures)}let l="other";M.includes(t.PDFFormatVersion)&&(l=`v${t.PDFFormatVersion.replace(".","_")}`);let c="other";if(t.Producer){const e=t.Producer.toLowerCase();F.some((function(t){if(!e.includes(t))return!1;c=t.replace(/[ .-]/g,"_");return!0}))}let h=null;t.IsXFAPresent?h="xfa":t.IsAcroFormPresent&&(h="acroform");this.externalServices.reportTelemetry({type:"documentInfo",version:l,generator:c,formType:h});this.eventBus.dispatch("metadataloaded",{source:this})},async _initializePageLabels(e){const t=await e.getPageLabels();if(e!==this.pdfDocument)return;if(!t||s.AppOptions.get("disablePageLabels"))return;const i=t.length;let n=0,r=0;for(let e=0;e<i;e++){const i=t[e];if(i===(e+1).toString())n++;else{if(""!==i)break;r++}}if(n>=i||r>=i)return;const{pdfViewer:a,pdfThumbnailViewer:o,toolbar:l}=this;a.setPageLabels(t);o.setPageLabels(t);l.setPagesCount(i,!0);l.setPageNumber(a.currentPageNumber,a.currentPageLabel)},_initializePdfHistory({fingerprint:e,viewOnLoad:t,initialDest:i=null}){if(this.pdfHistory){this.pdfHistory.initialize({fingerprint:e,resetHistory:t===k,updateUrl:s.AppOptions.get("historyUpdateUrl")});if(this.pdfHistory.initialBookmark){this.initialBookmark=this.pdfHistory.initialBookmark;this.initialRotation=this.pdfHistory.initialRotation}if(i&&!this.initialBookmark&&t===T){this.initialBookmark=JSON.stringify(i);this.pdfHistory.push({explicitDest:i,pageNumber:null})}}},_initializeAnnotationStorageCallbacks(e){if(e!==this.pdfDocument)return;const{annotationStorage:t}=e;t.onSetModified=()=>{window.addEventListener("beforeunload",beforeUnload);this._annotationStorageModified=!0};t.onResetModified=()=>{window.removeEventListener("beforeunload",beforeUnload);delete this._annotationStorageModified}},setInitialView(e,{rotation:t,sidebarView:i,scrollMode:s,spreadMode:r}={}){const setRotation=e=>{(0,n.isValidRotation)(e)&&(this.pdfViewer.pagesRotation=e)};this.isInitialViewSet=!0;this.pdfSidebar.setInitialView(i);((e,t)=>{(0,n.isValidScrollMode)(e)&&(this.pdfViewer.scrollMode=e);(0,n.isValidSpreadMode)(t)&&(this.pdfViewer.spreadMode=t)})(s,r);if(this.initialBookmark){setRotation(this.initialRotation);delete this.initialRotation;this.pdfLinkService.setHash(this.initialBookmark);this.initialBookmark=null}else if(e){setRotation(t);this.pdfLinkService.setHash(e)}this.toolbar.setPageNumber(this.pdfViewer.currentPageNumber,this.pdfViewer.currentPageLabel);this.secondaryToolbar.setPageNumber(this.pdfViewer.currentPageNumber);this.pdfViewer.currentScaleValue||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},_cleanup(){if(this.pdfDocument){this.pdfViewer.cleanup();this.pdfThumbnailViewer.cleanup();this.pdfDocument.cleanup(this.pdfViewer.renderer===n.RendererType.SVG)}},forceRendering(){this.pdfRenderingQueue.printing=!!this.printService;this.pdfRenderingQueue.isThumbnailViewEnabled=this.pdfSidebar.isThumbnailViewVisible;this.pdfRenderingQueue.renderHighestPriority()},beforePrint(){this.pdfScriptingManager.dispatchWillPrint();if(this.printService)return;if(!this.supportsPrinting){this.l10n.get("printing_not_supported").then((e=>{this._otherError(e)}));return}if(!this.pdfViewer.pageViewsReady){this.l10n.get("printing_not_ready").then((e=>{window.alert(e)}));return}const e=this.pdfViewer.getPagesOverview(),t=this.appConfig.printContainer,i=s.AppOptions.get("printResolution"),n=this.pdfViewer.optionalContentConfigPromise,r=B.instance.createPrintService(this.pdfDocument,e,t,i,n,this.l10n);this.printService=r;this.forceRendering();r.layout();this.externalServices.reportTelemetry({type:"print"})},afterPrint(){this.pdfScriptingManager.dispatchDidPrint();if(this.printService){this.printService.destroy();this.printService=null;this.pdfDocument?.annotationStorage.resetModified()}this.forceRendering()},rotatePages(e){this.pdfViewer.pagesRotation+=e},requestPresentationMode(){this.pdfPresentationMode?.request()},triggerPrinting(){this.supportsPrinting&&window.print()},bindEvents(){const{eventBus:e,_boundEvents:t}=this;t.beforePrint=this.beforePrint.bind(this);t.afterPrint=this.afterPrint.bind(this);e._on("resize",webViewerResize);e._on("hashchange",webViewerHashchange);e._on("beforeprint",t.beforePrint);e._on("afterprint",t.afterPrint);e._on("pagerendered",webViewerPageRendered);e._on("updateviewarea",webViewerUpdateViewarea);e._on("pagechanging",webViewerPageChanging);e._on("scalechanging",webViewerScaleChanging);e._on("rotationchanging",webViewerRotationChanging);e._on("sidebarviewchanged",webViewerSidebarViewChanged);e._on("pagemode",webViewerPageMode);e._on("namedaction",webViewerNamedAction);e._on("presentationmodechanged",webViewerPresentationModeChanged);e._on("presentationmode",webViewerPresentationMode);e._on("print",webViewerPrint);e._on("download",webViewerDownload);e._on("save",webViewerSave);e._on("firstpage",webViewerFirstPage);e._on("lastpage",webViewerLastPage);e._on("nextpage",webViewerNextPage);e._on("previouspage",webViewerPreviousPage);e._on("zoomin",webViewerZoomIn);e._on("zoomout",webViewerZoomOut);e._on("zoomreset",webViewerZoomReset);e._on("pagenumberchanged",webViewerPageNumberChanged);e._on("scalechanged",webViewerScaleChanged);e._on("rotatecw",webViewerRotateCw);e._on("rotateccw",webViewerRotateCcw);e._on("optionalcontentconfig",webViewerOptionalContentConfig);e._on("switchscrollmode",webViewerSwitchScrollMode);e._on("scrollmodechanged",webViewerScrollModeChanged);e._on("switchspreadmode",webViewerSwitchSpreadMode);e._on("spreadmodechanged",webViewerSpreadModeChanged);e._on("documentproperties",webViewerDocumentProperties);e._on("findfromurlhash",webViewerFindFromUrlHash);e._on("updatefindmatchescount",webViewerUpdateFindMatchesCount);e._on("updatefindcontrolstate",webViewerUpdateFindControlState);if(s.AppOptions.get("pdfBug")){t.reportPageStatsPDFBug=reportPageStatsPDFBug;e._on("pagerendered",t.reportPageStatsPDFBug);e._on("pagechanging",t.reportPageStatsPDFBug)}e._on("fileinputchange",I);e._on("openfile",O)},bindWindowEvents(){const{eventBus:e,_boundEvents:t}=this;t.windowResize=()=>{e.dispatch("resize",{source:window})};t.windowHashChange=()=>{e.dispatch("hashchange",{source:window,hash:document.location.hash.substring(1)})};t.windowBeforePrint=()=>{e.dispatch("beforeprint",{source:window})};t.windowAfterPrint=()=>{e.dispatch("afterprint",{source:window})};t.windowUpdateFromSandbox=t=>{e.dispatch("updatefromsandbox",{source:window,detail:t.detail})};window.addEventListener("visibilitychange",webViewerVisibilityChange);window.addEventListener("wheel",webViewerWheel,{passive:!1});window.addEventListener("touchstart",webViewerTouchStart,{passive:!1});window.addEventListener("click",webViewerClick);window.addEventListener("keydown",webViewerKeyDown);window.addEventListener("resize",t.windowResize);window.addEventListener("hashchange",t.windowHashChange);window.addEventListener("beforeprint",t.windowBeforePrint);window.addEventListener("afterprint",t.windowAfterPrint);window.addEventListener("updatefromsandbox",t.windowUpdateFromSandbox)},unbindEvents(){const{eventBus:e,_boundEvents:t}=this;e._off("resize",webViewerResize);e._off("hashchange",webViewerHashchange);e._off("beforeprint",t.beforePrint);e._off("afterprint",t.afterPrint);e._off("pagerendered",webViewerPageRendered);e._off("updateviewarea",webViewerUpdateViewarea);e._off("pagechanging",webViewerPageChanging);e._off("scalechanging",webViewerScaleChanging);e._off("rotationchanging",webViewerRotationChanging);e._off("sidebarviewchanged",webViewerSidebarViewChanged);e._off("pagemode",webViewerPageMode);e._off("namedaction",webViewerNamedAction);e._off("presentationmodechanged",webViewerPresentationModeChanged);e._off("presentationmode",webViewerPresentationMode);e._off("print",webViewerPrint);e._off("download",webViewerDownload);e._off("save",webViewerSave);e._off("firstpage",webViewerFirstPage);e._off("lastpage",webViewerLastPage);e._off("nextpage",webViewerNextPage);e._off("previouspage",webViewerPreviousPage);e._off("zoomin",webViewerZoomIn);e._off("zoomout",webViewerZoomOut);e._off("zoomreset",webViewerZoomReset);e._off("pagenumberchanged",webViewerPageNumberChanged);e._off("scalechanged",webViewerScaleChanged);e._off("rotatecw",webViewerRotateCw);e._off("rotateccw",webViewerRotateCcw);e._off("optionalcontentconfig",webViewerOptionalContentConfig);e._off("switchscrollmode",webViewerSwitchScrollMode);e._off("scrollmodechanged",webViewerScrollModeChanged);e._off("switchspreadmode",webViewerSwitchSpreadMode);e._off("spreadmodechanged",webViewerSpreadModeChanged);e._off("documentproperties",webViewerDocumentProperties);e._off("findfromurlhash",webViewerFindFromUrlHash);e._off("updatefindmatchescount",webViewerUpdateFindMatchesCount);e._off("updatefindcontrolstate",webViewerUpdateFindControlState);if(t.reportPageStatsPDFBug){e._off("pagerendered",t.reportPageStatsPDFBug);e._off("pagechanging",t.reportPageStatsPDFBug);t.reportPageStatsPDFBug=null}e._off("fileinputchange",I);e._off("openfile",O);t.beforePrint=null;t.afterPrint=null},unbindWindowEvents(){const{_boundEvents:e}=this;window.removeEventListener("visibilitychange",webViewerVisibilityChange);window.removeEventListener("wheel",webViewerWheel,{passive:!1});window.removeEventListener("touchstart",webViewerTouchStart,{passive:!1});window.removeEventListener("click",webViewerClick);window.removeEventListener("keydown",webViewerKeyDown);window.removeEventListener("resize",e.windowResize);window.removeEventListener("hashchange",e.windowHashChange);window.removeEventListener("beforeprint",e.windowBeforePrint);window.removeEventListener("afterprint",e.windowAfterPrint);window.removeEventListener("updatefromsandbox",e.windowUpdateFromSandbox);e.windowResize=null;e.windowHashChange=null;e.windowBeforePrint=null;e.windowAfterPrint=null;e.windowUpdateFromSandbox=null},accumulateWheelTicks(e){(this._wheelUnusedTicks>0&&e<0||this._wheelUnusedTicks<0&&e>0)&&(this._wheelUnusedTicks=0);this._wheelUnusedTicks+=e;const t=Math.sign(this._wheelUnusedTicks)*Math.floor(Math.abs(this._wheelUnusedTicks));this._wheelUnusedTicks-=t;return t},_unblockDocumentLoadEvent(){document.blockUnblockOnload&&document.blockUnblockOnload(!1);this._unblockDocumentLoadEvent=()=>{}},_reportDocumentStatsTelemetry(){const{stats:e}=this.pdfDocument;if(e!==this._docStats){this._docStats=e;this.externalServices.reportTelemetry({type:"documentStats",stats:e})}},get scriptingReady(){return this.pdfScriptingManager.ready}};t.PDFViewerApplication=R;let D,I,O;{const e=["null","http://mozilla.github.io","https://mozilla.github.io"];D=function(t){if(void 0!==t)try{const i=new URL(window.location.href).origin||"null";if(e.includes(i))return;const{origin:n,protocol:s}=new URL(t,window.location.href);if(n!==i&&"blob:"!==s)throw new Error("file origin does not match viewer's")}catch(e){R.l10n.get("loading_error").then((t=>{R._documentError(t,{message:e?.message})}));throw e}}}function reportPageStatsPDFBug({pageNumber:e}){if("undefined"==typeof Stats||!Stats.enabled)return;const t=R.pdfViewer.getPageView(e-1)?.pdfPage?.stats;t&&Stats.add(e,t)}function webViewerInitialized(){const e=R.appConfig;let t;const i=document.location.search.substring(1);t=(0,n.parseQueryString)(i).get("file")??s.AppOptions.get("defaultUrl");D(t);const r=document.createElement("input");r.id=e.openFileInputName;r.className="fileInput";r.setAttribute("type","file");r.oncontextmenu=n.noContextMenuHandler;document.body.appendChild(r);if(window.File&&window.FileReader&&window.FileList&&window.Blob)r.value=null;else{e.toolbar.openFile.hidden=!0;e.secondaryToolbar.openFileButton.hidden=!0}r.addEventListener("change",(function(e){const t=e.target.files;t&&0!==t.length&&R.eventBus.dispatch("fileinputchange",{source:this,fileInput:e.target})}));e.mainContainer.addEventListener("dragover",(function(e){e.preventDefault();e.dataTransfer.dropEffect="move"}));e.mainContainer.addEventListener("drop",(function(e){e.preventDefault();const t=e.dataTransfer.files;t&&0!==t.length&&R.eventBus.dispatch("fileinputchange",{source:this,fileInput:e.dataTransfer})}));if(!R.supportsDocumentFonts){s.AppOptions.set("disableFontFace",!0);R.l10n.get("web_fonts_disabled").then((e=>{console.warn(e)}))}if(!R.supportsPrinting){e.toolbar.print.classList.add("hidden");e.secondaryToolbar.printButton.classList.add("hidden")}if(!R.supportsFullscreen){e.toolbar.presentationModeButton.classList.add("hidden");e.secondaryToolbar.presentationModeButton.classList.add("hidden")}R.supportsIntegratedFind&&e.toolbar.viewFind.classList.add("hidden");e.mainContainer.addEventListener("transitionend",(function(e){e.target===this&&R.eventBus.dispatch("resize",{source:this})}),!0);try{!function webViewerOpenFileViaURL(e){e?R.open(e):R._hideViewBookmark()}(t)}catch(e){R.l10n.get("loading_error").then((t=>{R._documentError(t,e)}))}}function webViewerPageRendered({pageNumber:e,error:t}){e===R.page&&R.toolbar.updateLoadingIndicatorState(!1);if(R.pdfSidebar.isThumbnailViewVisible){const t=R.pdfViewer.getPageView(e-1),i=R.pdfThumbnailViewer.getThumbnail(e-1);t&&i&&i.setImage(t)}t&&R.l10n.get("rendering_error").then((e=>{R._otherError(e,t)}));R._reportDocumentStatsTelemetry()}function webViewerPageMode({mode:e}){let t;switch(e){case"thumbs":t=n.SidebarView.THUMBS;break;case"bookmarks":case"outline":t=n.SidebarView.OUTLINE;break;case"attachments":t=n.SidebarView.ATTACHMENTS;break;case"layers":t=n.SidebarView.LAYERS;break;case"none":t=n.SidebarView.NONE;break;default:console.error('Invalid "pagemode" hash parameter: '+e);return}R.pdfSidebar.switchView(t,!0)}function webViewerNamedAction(e){switch(e.action){case"GoToPage":R.appConfig.toolbar.pageNumber.select();break;case"Find":R.supportsIntegratedFind||R.findBar.toggle();break;case"Print":R.triggerPrinting();break;case"SaveAs":webViewerSave()}}function webViewerPresentationModeChanged(e){R.pdfViewer.presentationModeState=e.state}function webViewerSidebarViewChanged(e){R.pdfRenderingQueue.isThumbnailViewEnabled=R.pdfSidebar.isThumbnailViewVisible;R.isInitialViewSet&&R.store?.set("sidebarView",e.view).catch((()=>{}))}function webViewerUpdateViewarea(e){const t=e.location;R.isInitialViewSet&&R.store?.setMultiple({page:t.pageNumber,zoom:t.scale,scrollLeft:t.left,scrollTop:t.top,rotation:t.rotation}).catch((()=>{}));const i=R.pdfLinkService.getAnchorUrl(t.pdfOpenParams);R.appConfig.toolbar.viewBookmark.href=i;R.appConfig.secondaryToolbar.viewBookmarkButton.href=i;const s=R.pdfViewer.getPageView(R.page-1)?.renderingState!==n.RenderingStates.FINISHED;R.toolbar.updateLoadingIndicatorState(s)}function webViewerScrollModeChanged(e){R.isInitialViewSet&&R.store?.set("scrollMode",e.mode).catch((()=>{}))}function webViewerSpreadModeChanged(e){R.isInitialViewSet&&R.store?.set("spreadMode",e.mode).catch((()=>{}))}function webViewerResize(){const{pdfDocument:e,pdfViewer:t}=R;if(!e)return;const i=t.currentScaleValue;"auto"!==i&&"page-fit"!==i&&"page-width"!==i||(t.currentScaleValue=i);t.update()}function webViewerHashchange(e){const t=e.hash;t&&(R.isInitialViewSet?R.pdfHistory?.popStateInProgress||R.pdfLinkService.setHash(t):R.initialBookmark=t)}I=function(e){if(R.pdfViewer?.isInPresentationMode)return;const t=e.fileInput.files[0];if(s.compatibilityParams.disableCreateObjectURL){R.setTitleUsingUrl(t.name);const e=new FileReader;e.onload=function webViewerChangeFileReaderOnload(e){const t=e.target.result;R.open(new Uint8Array(t))};e.readAsArrayBuffer(t)}else{let e=URL.createObjectURL(t);t.name&&(e={url:e,originalUrl:t.name});R.open(e)}};O=function(e){const t=R.appConfig.openFileInputName;document.getElementById(t).click()};function webViewerPresentationMode(){R.requestPresentationMode()}function webViewerPrint(){R.triggerPrinting()}function webViewerDownload(){R.downloadOrSave({sourceEventType:"download"})}function webViewerSave(){R.downloadOrSave({sourceEventType:"save"})}function webViewerFirstPage(){R.pdfDocument&&(R.page=1)}function webViewerLastPage(){R.pdfDocument&&(R.page=R.pagesCount)}function webViewerNextPage(){R.pdfViewer.nextPage()}function webViewerPreviousPage(){R.pdfViewer.previousPage()}function webViewerZoomIn(){R.zoomIn()}function webViewerZoomOut(){R.zoomOut()}function webViewerZoomReset(){R.zoomReset()}function webViewerPageNumberChanged(e){const t=R.pdfViewer;""!==e.value&&R.pdfLinkService.goToPage(e.value);e.value!==t.currentPageNumber.toString()&&e.value!==t.currentPageLabel&&R.toolbar.setPageNumber(t.currentPageNumber,t.currentPageLabel)}function webViewerScaleChanged(e){R.pdfViewer.currentScaleValue=e.value}function webViewerRotateCw(){R.rotatePages(90)}function webViewerRotateCcw(){R.rotatePages(-90)}function webViewerOptionalContentConfig(e){R.pdfViewer.optionalContentConfigPromise=e.promise}function webViewerSwitchScrollMode(e){R.pdfViewer.scrollMode=e.mode}function webViewerSwitchSpreadMode(e){R.pdfViewer.spreadMode=e.mode}function webViewerDocumentProperties(){R.pdfDocumentProperties.open()}function webViewerFindFromUrlHash(e){R.eventBus.dispatch("find",{source:e.source,type:"",query:e.query,phraseSearch:e.phraseSearch,caseSensitive:!1,entireWord:!1,highlightAll:!0,findPrevious:!1})}function webViewerUpdateFindMatchesCount({matchesCount:e}){R.supportsIntegratedFind?R.externalServices.updateFindMatchesCount(e):R.findBar.updateResultsCount(e)}function webViewerUpdateFindControlState({state:e,previous:t,matchesCount:i,rawQuery:n}){R.supportsIntegratedFind?R.externalServices.updateFindControlState({result:e,findPrevious:t,matchesCount:i,rawQuery:n}):R.findBar.updateUIState(e,t,i)}function webViewerScaleChanging(e){R.toolbar.setPageScale(e.presetValue,e.scale);R.pdfViewer.update()}function webViewerRotationChanging(e){R.pdfThumbnailViewer.pagesRotation=e.pagesRotation;R.forceRendering();R.pdfViewer.currentPageNumber=e.pageNumber}function webViewerPageChanging({pageNumber:e,pageLabel:t}){R.toolbar.setPageNumber(e,t);R.secondaryToolbar.setPageNumber(e);R.pdfSidebar.isThumbnailViewVisible&&R.pdfThumbnailViewer.scrollThumbnailIntoView(e)}function webViewerVisibilityChange(e){"visible"===document.visibilityState&&setZoomDisabledTimeout()}let N=null;function setZoomDisabledTimeout(){N&&clearTimeout(N);N=setTimeout((function(){N=null}),1e3)}function webViewerWheel(e){const{pdfViewer:t,supportedMouseWheelZoomModifierKeys:i}=R;if(!t.isInPresentationMode)if(e.ctrlKey&&i.ctrlKey||e.metaKey&&i.metaKey){e.preventDefault();if(N||"hidden"===document.visibilityState)return;const i=t.currentScale,s=(0,n.normalizeWheelEventDirection)(e);let r=0;if(e.deltaMode===WheelEvent.DOM_DELTA_LINE||e.deltaMode===WheelEvent.DOM_DELTA_PAGE)r=Math.abs(s)>=1?Math.sign(s):R.accumulateWheelTicks(s);else{const e=30;r=R.accumulateWheelTicks(s/e)}r<0?R.zoomOut(-r):r>0&&R.zoomIn(r);const a=t.currentScale;if(i!==a){const n=a/i-1,s=t.container.getBoundingClientRect(),r=e.clientX-s.left,o=e.clientY-s.top;t.container.scrollLeft+=r*n;t.container.scrollTop+=o*n}}else setZoomDisabledTimeout()}function webViewerTouchStart(e){e.touches.length>1&&e.preventDefault()}function webViewerClick(e){if(!R.secondaryToolbar.isOpen)return;const t=R.appConfig;(R.pdfViewer.containsElement(e.target)||t.toolbar.container.contains(e.target)&&e.target!==t.secondaryToolbar.toggleButton)&&R.secondaryToolbar.close()}function webViewerKeyDown(e){if(R.overlayManager.active)return;const{eventBus:t,pdfViewer:i}=R,s=i.isInPresentationMode;let r=!1,a=!1;const l=(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0);if(1===l||8===l||5===l||12===l)switch(e.keyCode){case 70:if(!R.supportsIntegratedFind&&!e.shiftKey){R.findBar.open();r=!0}break;case 71:if(!R.supportsIntegratedFind){const{state:e}=R.findController;if(e){const i=Object.assign(Object.create(null),e,{source:window,type:"again",findPrevious:5===l||12===l});t.dispatch("find",i)}r=!0}break;case 61:case 107:case 187:case 171:s||R.zoomIn();r=!0;break;case 173:case 109:case 189:s||R.zoomOut();r=!0;break;case 48:case 96:if(!s){setTimeout((function(){R.zoomReset()}));r=!1}break;case 38:if(s||R.page>1){R.page=1;r=!0;a=!0}break;case 40:if(s||R.page<R.pagesCount){R.page=R.pagesCount;r=!0;a=!0}}if(1===l||8===l)switch(e.keyCode){case 83:t.dispatch("download",{source:window});r=!0;break;case 79:t.dispatch("openfile",{source:window});r=!0}if(3===l||10===l)switch(e.keyCode){case 80:R.requestPresentationMode();r=!0;break;case 71:R.appConfig.toolbar.pageNumber.select();r=!0}if(r){a&&!s&&i.focus();e.preventDefault();return}const c=(0,n.getActiveOrFocusedElement)(),h=c?.tagName.toUpperCase();if("INPUT"!==h&&"TEXTAREA"!==h&&"SELECT"!==h&&!c?.isContentEditable||27===e.keyCode){if(0===l){let t=0,n=!1;switch(e.keyCode){case 38:case 33:i.isVerticalScrollbarEnabled&&(n=!0);t=-1;break;case 8:s||(n=!0);t=-1;break;case 37:i.isHorizontalScrollbarEnabled&&(n=!0);case 75:case 80:t=-1;break;case 27:if(R.secondaryToolbar.isOpen){R.secondaryToolbar.close();r=!0}if(!R.supportsIntegratedFind&&R.findBar.opened){R.findBar.close();r=!0}break;case 40:case 34:i.isVerticalScrollbarEnabled&&(n=!0);t=1;break;case 13:case 32:s||(n=!0);t=1;break;case 39:i.isHorizontalScrollbarEnabled&&(n=!0);case 74:case 78:t=1;break;case 36:if(s||R.page>1){R.page=1;r=!0;a=!0}break;case 35:if(s||R.page<R.pagesCount){R.page=R.pagesCount;r=!0;a=!0}break;case 83:R.pdfCursorTools.switchTool(o.CursorTool.SELECT);break;case 72:R.pdfCursorTools.switchTool(o.CursorTool.HAND);break;case 82:R.rotatePages(90);break;case 115:R.pdfSidebar.toggle()}if(0!==t&&(!n||"page-fit"===i.currentScaleValue)){t>0?i.nextPage():i.previousPage();r=!0}}if(4===l)switch(e.keyCode){case 13:case 32:if(!s&&"page-fit"!==i.currentScaleValue)break;i.previousPage();r=!0;break;case 82:R.rotatePages(-90)}r||s||(e.keyCode>=33&&e.keyCode<=40||32===e.keyCode&&"BUTTON"!==h)&&(a=!0);a&&!i.containsElement(c)&&i.focus();r&&e.preventDefault()}}function beforeUnload(e){e.preventDefault();e.returnValue="";return!1}const B={instance:{supportsPrinting:!1,createPrintService(){throw new Error("Not implemented: createPrintService")}}};t.PDFPrintServiceFactory=B},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.animationStarted=t.VERTICAL_PADDING=t.UNKNOWN_SCALE=t.TextLayerMode=t.SpreadMode=t.SidebarView=t.ScrollMode=t.SCROLLBAR_PADDING=t.RenderingStates=t.RendererType=t.ProgressBar=t.PresentationModeState=t.MIN_SCALE=t.MAX_SCALE=t.MAX_AUTO_SCALE=t.DEFAULT_SCALE_VALUE=t.DEFAULT_SCALE_DELTA=t.DEFAULT_SCALE=t.AutoPrintRegExp=void 0;t.apiPageLayoutToViewerModes=function apiPageLayoutToViewerModes(e){let t=n.VERTICAL,i=s.NONE;switch(e){case"SinglePage":t=n.PAGE;break;case"OneColumn":break;case"TwoPageLeft":t=n.PAGE;case"TwoColumnLeft":i=s.ODD;break;case"TwoPageRight":t=n.PAGE;case"TwoColumnRight":i=s.EVEN}return{scrollMode:t,spreadMode:i}};t.apiPageModeToSidebarView=function apiPageModeToSidebarView(e){switch(e){case"UseNone":return i.NONE;case"UseThumbs":return i.THUMBS;case"UseOutlines":return i.OUTLINE;case"UseAttachments":return i.ATTACHMENTS;case"UseOC":return i.LAYERS}return i.NONE};t.approximateFraction=function approximateFraction(e){if(Math.floor(e)===e)return[e,1];const t=1/e;if(t>8)return[1,8];if(Math.floor(t)===t)return[1,t];const i=e>1?t:e;let n,s=0,r=1,a=1,o=1;for(;;){const e=s+a,t=r+o;if(t>8)break;if(i<=e/t){a=e;o=t}else{s=e;r=t}}n=i-s/r<a/o-i?i===e?[s,r]:[r,s]:i===e?[a,o]:[o,a];return n};t.backtrackBeforeAllVisibleElements=backtrackBeforeAllVisibleElements;t.binarySearchFirstItem=binarySearchFirstItem;t.getActiveOrFocusedElement=function getActiveOrFocusedElement(){let e=document,t=e.activeElement||e.querySelector(":focus");for(;t?.shadowRoot;){e=t.shadowRoot;t=e.activeElement||e.querySelector(":focus")}return t};t.getOutputScale=function getOutputScale(e){const t=window.devicePixelRatio||1,i=e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.backingStorePixelRatio||1,n=t/i;return{sx:n,sy:n,scaled:1!==n}};t.getPageSizeInches=function getPageSizeInches({view:e,userUnit:t,rotate:i}){const[n,s,r,a]=e,o=i%180!=0,l=(r-n)/72*t,c=(a-s)/72*t;return{width:o?c:l,height:o?l:c}};t.getVisibleElements=function getVisibleElements({scrollEl:e,views:t,sortByVisibility:i=!1,horizontal:n=!1,rtl:s=!1}){const r=e.scrollTop,a=r+e.clientHeight,o=e.scrollLeft,l=o+e.clientWidth;const c=[],h=new Set,d=t.length;let u=binarySearchFirstItem(t,n?function isElementNextAfterViewHorizontally(e){const t=e.div,i=t.offsetLeft+t.clientLeft,n=i+t.clientWidth;return s?i<l:n>o}:function isElementBottomAfterViewTop(e){const t=e.div;return t.offsetTop+t.clientTop+t.clientHeight>r});u>0&&u<d&&!n&&(u=backtrackBeforeAllVisibleElements(u,t,r));let p=n?l:-1;for(let e=u;e<d;e++){const i=t[e],s=i.div,d=s.offsetLeft+s.clientLeft,u=s.offsetTop+s.clientTop,g=s.clientWidth,f=s.clientHeight,m=d+g,_=u+f;if(-1===p)_>=a&&(p=_);else if((n?d:u)>p)break;if(_<=r||u>=a||m<=o||d>=l)continue;const b=Math.max(0,r-u)+Math.max(0,_-a),v=Math.max(0,o-d)+Math.max(0,m-l),w=(g-v)/g,y=(f-b)/f*w*100|0;c.push({id:i.id,x:d,y:u,view:i,percent:y,widthPercent:100*w|0});h.add(i.id)}const g=c[0],f=c[c.length-1];i&&c.sort((function(e,t){const i=e.percent-t.percent;return Math.abs(i)>.001?-i:e.id-t.id}));return{first:g,last:f,views:c,ids:h}};t.isPortraitOrientation=function isPortraitOrientation(e){return e.width<=e.height};t.isValidRotation=function isValidRotation(e){return Number.isInteger(e)&&e%90==0};t.isValidScrollMode=function isValidScrollMode(e){return Number.isInteger(e)&&Object.values(n).includes(e)&&e!==n.UNKNOWN};t.isValidSpreadMode=function isValidSpreadMode(e){return Number.isInteger(e)&&Object.values(s).includes(e)&&e!==s.UNKNOWN};t.noContextMenuHandler=function noContextMenuHandler(e){e.preventDefault()};t.normalizeWheelEventDelta=function normalizeWheelEventDelta(e){let t=normalizeWheelEventDirection(e);0===e.deltaMode?t/=900:1===e.deltaMode&&(t/=30);return t};t.normalizeWheelEventDirection=normalizeWheelEventDirection;t.parseQueryString=function parseQueryString(e){const t=new Map;for(const[i,n]of new URLSearchParams(e))t.set(i.toLowerCase(),n);return t};t.roundToDivide=function roundToDivide(e,t){const i=e%t;return 0===i?e:Math.round(e-i+t)};t.scrollIntoView=function scrollIntoView(e,t,i=!1){let n=e.offsetParent;if(!n){console.error("offsetParent is not set -- cannot scroll");return}let s=e.offsetTop+e.clientTop,r=e.offsetLeft+e.clientLeft;for(;n.clientHeight===n.scrollHeight&&n.clientWidth===n.scrollWidth||i&&(n.classList.contains("markedContent")||"hidden"===getComputedStyle(n).overflow);){s+=n.offsetTop;r+=n.offsetLeft;n=n.offsetParent;if(!n)return}if(t){void 0!==t.top&&(s+=t.top);if(void 0!==t.left){r+=t.left;n.scrollLeft=r}}n.scrollTop=s};t.watchScroll=function watchScroll(e,t){const debounceScroll=function(s){n||(n=window.requestAnimationFrame((function viewAreaElementScrolled(){n=null;const s=e.scrollLeft,r=i.lastX;s!==r&&(i.right=s>r);i.lastX=s;const a=e.scrollTop,o=i.lastY;a!==o&&(i.down=a>o);i.lastY=a;t(i)})))},i={right:!0,down:!0,lastX:e.scrollLeft,lastY:e.scrollTop,_eventHandler:debounceScroll};let n=null;e.addEventListener("scroll",debounceScroll,!0);return i};t.DEFAULT_SCALE_VALUE="auto";t.DEFAULT_SCALE=1;t.DEFAULT_SCALE_DELTA=1.1;t.MIN_SCALE=.1;t.MAX_SCALE=10;t.UNKNOWN_SCALE=0;t.MAX_AUTO_SCALE=1.25;t.SCROLLBAR_PADDING=40;t.VERTICAL_PADDING=5;t.RenderingStates={INITIAL:0,RUNNING:1,PAUSED:2,FINISHED:3};t.PresentationModeState={UNKNOWN:0,NORMAL:1,CHANGING:2,FULLSCREEN:3};const i={UNKNOWN:-1,NONE:0,THUMBS:1,OUTLINE:2,ATTACHMENTS:3,LAYERS:4};t.SidebarView=i;t.RendererType={CANVAS:"canvas",SVG:"svg"};t.TextLayerMode={DISABLE:0,ENABLE:1,ENABLE_ENHANCE:2};const n={UNKNOWN:-1,VERTICAL:0,HORIZONTAL:1,WRAPPED:2,PAGE:3};t.ScrollMode=n;const s={UNKNOWN:-1,NONE:0,ODD:1,EVEN:2};t.SpreadMode=s;t.AutoPrintRegExp=/\bprint\s*\(/;function binarySearchFirstItem(e,t){let i=0,n=e.length-1;if(n<0||!t(e[n]))return e.length;if(t(e[i]))return i;for(;i<n;){const s=i+n>>1;t(e[s])?n=s:i=s+1}return i}function backtrackBeforeAllVisibleElements(e,t,i){if(e<2)return e;let n=t[e].div,s=n.offsetTop+n.clientTop;if(s>=i){n=t[e-1].div;s=n.offsetTop+n.clientTop}for(let i=e-2;i>=0;--i){n=t[i].div;if(n.offsetTop+n.clientTop+n.clientHeight<=s)break;e=i}return e}function normalizeWheelEventDirection(e){let t=Math.hypot(e.deltaX,e.deltaY);const i=Math.atan2(e.deltaY,e.deltaX);-.25*Math.PI<i&&i<.75*Math.PI&&(t=-t);return t}const r=new Promise((function(e){window.requestAnimationFrame(e)}));t.animationStarted=r;t.ProgressBar=class ProgressBar{constructor(e,{height:t,width:i,units:n}={}){this.visible=!0;this.div=document.querySelector(e+" .progress");this.bar=this.div.parentNode;this.height=t||100;this.width=i||100;this.units=n||"%";this.div.style.height=this.height+this.units;this.percent=0}_updateBar(){if(this._indeterminate){this.div.classList.add("indeterminate");this.div.style.width=this.width+this.units;return}this.div.classList.remove("indeterminate");const e=this.width*this._percent/100;this.div.style.width=e+this.units}get percent(){return this._percent}set percent(e){this._indeterminate=isNaN(e);this._percent=function clamp(e,t,i){return Math.min(Math.max(e,t),i)}(e,0,100);this._updateBar()}setWidth(e){if(!e)return;const t=e.parentNode.offsetWidth-e.offsetWidth;if(t>0){document.documentElement.style.setProperty("--loadingBar-end-offset",`${t}px`)}}hide(){if(this.visible){this.visible=!1;this.bar.classList.add("hidden")}}show(){if(!this.visible){this.visible=!0;this.bar.classList.remove("hidden")}}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.WaitOnType=t.EventBus=t.AutomationEventBus=void 0;t.waitOnEventOrTimeout=function waitOnEventOrTimeout({target:e,name:t,delay:n=0}){return new Promise((function(s,r){if("object"!=typeof e||!t||"string"!=typeof t||!(Number.isInteger(n)&&n>=0))throw new Error("waitOnEventOrTimeout - invalid parameters.");function handler(i){e instanceof EventBus?e._off(t,a):e.removeEventListener(t,a);l&&clearTimeout(l);s(i)}const a=handler.bind(null,i.EVENT);e instanceof EventBus?e._on(t,a):e.addEventListener(t,a);const o=handler.bind(null,i.TIMEOUT),l=setTimeout(o,n)}))};const i={EVENT:"event",TIMEOUT:"timeout"};t.WaitOnType=i;class EventBus{constructor(){this._listeners=Object.create(null)}on(e,t,i=null){this._on(e,t,{external:!0,once:i?.once})}off(e,t,i=null){this._off(e,t,{external:!0,once:i?.once})}dispatch(e,t){const i=this._listeners[e];if(!i||0===i.length)return;let n;for(const{listener:s,external:r,once:a}of i.slice(0)){a&&this._off(e,s);r?(n||=[]).push(s):s(t)}if(n){for(const e of n)e(t);n=null}}_on(e,t,i=null){(this._listeners[e]||=[]).push({listener:t,external:!0===i?.external,once:!0===i?.once})}_off(e,t,i=null){const n=this._listeners[e];if(n)for(let e=0,i=n.length;e<i;e++)if(n[e].listener===t){n.splice(e,1);return}}}t.EventBus=EventBus;t.AutomationEventBus=class AutomationEventBus extends EventBus{dispatch(e,t){throw new Error("Not implemented: AutomationEventBus.dispatch")}}},e=>{let t;t="undefined"!=typeof window&&window["pdfjs-dist/build/pdf"]?window["pdfjs-dist/build/pdf"]:require("../build/pdf.js");e.exports=t},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFCursorTools=t.CursorTool=void 0;var n=i(7),s=i(3);const r={SELECT:0,HAND:1,ZOOM:2};t.CursorTool=r;t.PDFCursorTools=class PDFCursorTools{constructor({container:e,eventBus:t,cursorToolOnLoad:i=r.SELECT}){this.container=e;this.eventBus=t;this.active=r.SELECT;this.activeBeforePresentationMode=null;this.handTool=new n.GrabToPan({element:this.container});this._addEventListeners();Promise.resolve().then((()=>{this.switchTool(i)}))}get activeTool(){return this.active}switchTool(e){if(null!==this.activeBeforePresentationMode)return;if(e===this.active)return;const disableActiveTool=()=>{switch(this.active){case r.SELECT:break;case r.HAND:this.handTool.deactivate()}};switch(e){case r.SELECT:disableActiveTool();break;case r.HAND:disableActiveTool();this.handTool.activate();break;default:console.error(`switchTool: "${e}" is an unsupported value.`);return}this.active=e;this._dispatchEvent()}_dispatchEvent(){this.eventBus.dispatch("cursortoolchanged",{source:this,tool:this.active})}_addEventListeners(){this.eventBus._on("switchcursortool",(e=>{this.switchTool(e.tool)}));this.eventBus._on("presentationmodechanged",(e=>{switch(e.state){case s.PresentationModeState.FULLSCREEN:{const e=this.active;this.switchTool(r.SELECT);this.activeBeforePresentationMode=e;break}case s.PresentationModeState.NORMAL:{const e=this.activeBeforePresentationMode;this.activeBeforePresentationMode=null;this.switchTool(e);break}}}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GrabToPan=void 0;const i="grab-to-pan-grab";t.GrabToPan=class GrabToPan{constructor(e){this.element=e.element;this.document=e.element.ownerDocument;"function"==typeof e.ignoreTarget&&(this.ignoreTarget=e.ignoreTarget);this.onActiveChanged=e.onActiveChanged;this.activate=this.activate.bind(this);this.deactivate=this.deactivate.bind(this);this.toggle=this.toggle.bind(this);this._onMouseDown=this.#o.bind(this);this._onMouseMove=this.#l.bind(this);this._endPan=this.#c.bind(this);(this.overlay=document.createElement("div")).className="grab-to-pan-grabbing"}activate(){if(!this.active){this.active=!0;this.element.addEventListener("mousedown",this._onMouseDown,!0);this.element.classList.add(i);this.onActiveChanged?.(!0)}}deactivate(){if(this.active){this.active=!1;this.element.removeEventListener("mousedown",this._onMouseDown,!0);this._endPan();this.element.classList.remove(i);this.onActiveChanged?.(!1)}}toggle(){this.active?this.deactivate():this.activate()}ignoreTarget(e){return e.matches("a[href], a[href] *, input, textarea, button, button *, select, option")}#o(e){if(0!==e.button||this.ignoreTarget(e.target))return;if(e.originalTarget)try{e.originalTarget.tagName}catch(e){return}this.scrollLeftStart=this.element.scrollLeft;this.scrollTopStart=this.element.scrollTop;this.clientXStart=e.clientX;this.clientYStart=e.clientY;this.document.addEventListener("mousemove",this._onMouseMove,!0);this.document.addEventListener("mouseup",this._endPan,!0);this.element.addEventListener("scroll",this._endPan,!0);e.preventDefault();e.stopPropagation();const t=document.activeElement;t&&!t.contains(e.target)&&t.blur()}#l(e){this.element.removeEventListener("scroll",this._endPan,!0);if(!(1&e.buttons)){this._endPan();return}const t=e.clientX-this.clientXStart,i=e.clientY-this.clientYStart,n=this.scrollTopStart-i,s=this.scrollLeftStart-t;if(this.element.scrollTo)this.element.scrollTo({top:n,left:s,behavior:"instant"});else{this.element.scrollTop=n;this.element.scrollLeft=s}this.overlay.parentNode||document.body.appendChild(this.overlay)}#c(){this.element.removeEventListener("scroll",this._endPan,!0);this.document.removeEventListener("mousemove",this._onMouseMove,!0);this.document.removeEventListener("mouseup",this._endPan,!0);this.overlay.remove()}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OverlayManager=void 0;t.OverlayManager=class OverlayManager{constructor(){this._overlays={};this._active=null;this._keyDownBound=this._keyDown.bind(this)}get active(){return this._active}async register(e,t,i=null,n=!1){let s;if(!(e&&t&&(s=t.parentNode)))throw new Error("Not enough parameters.");if(this._overlays[e])throw new Error("The overlay is already registered.");this._overlays[e]={element:t,container:s,callerCloseMethod:i,canForceClose:n}}async unregister(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(this._active===e)throw new Error("The overlay cannot be removed while it is active.");delete this._overlays[e]}async open(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(this._active){if(!this._overlays[e].canForceClose)throw this._active===e?new Error("The overlay is already active."):new Error("Another overlay is currently active.");this._closeThroughCaller()}this._active=e;this._overlays[this._active].element.classList.remove("hidden");this._overlays[this._active].container.classList.remove("hidden");window.addEventListener("keydown",this._keyDownBound)}async close(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(!this._active)throw new Error("The overlay is currently not active.");if(this._active!==e)throw new Error("Another overlay is currently active.");this._overlays[this._active].container.classList.add("hidden");this._overlays[this._active].element.classList.add("hidden");this._active=null;window.removeEventListener("keydown",this._keyDownBound)}_keyDown(e){if(this._active&&27===e.keyCode){this._closeThroughCaller();e.preventDefault()}}_closeThroughCaller(){this._overlays[this._active].callerCloseMethod&&this._overlays[this._active].callerCloseMethod();this._active&&this.close(this._active)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PasswordPrompt=void 0;var n=i(5);t.PasswordPrompt=class PasswordPrompt{constructor(e,t,i,n=!1){this.overlayName=e.overlayName;this.container=e.container;this.label=e.label;this.input=e.input;this.submitButton=e.submitButton;this.cancelButton=e.cancelButton;this.overlayManager=t;this.l10n=i;this._isViewerEmbedded=n;this.updateCallback=null;this.reason=null;this.submitButton.addEventListener("click",this.verify.bind(this));this.cancelButton.addEventListener("click",this.close.bind(this));this.input.addEventListener("keydown",(e=>{13===e.keyCode&&this.verify()}));this.overlayManager.register(this.overlayName,this.container,this.close.bind(this),!0)}async open(){await this.overlayManager.open(this.overlayName);const e=this.reason===n.PasswordResponses.INCORRECT_PASSWORD;this._isViewerEmbedded&&!e||this.input.focus();this.label.textContent=await this.l10n.get("password_"+(e?"invalid":"label"))}close(){this.overlayManager.close(this.overlayName).then((()=>{this.input.value=""}))}verify(){const e=this.input.value;if(e?.length>0){this.close();this.updateCallback(e)}}setUpdateCallback(e,t){this.updateCallback=e;this.reason=t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFAttachmentViewer=void 0;var n=i(5),s=i(11);class PDFAttachmentViewer extends s.BaseTreeViewer{constructor(e){super(e);this.downloadManager=e.downloadManager;this.eventBus._on("fileattachmentannotation",this._appendAttachment.bind(this))}reset(e=!1){super.reset();this._attachments=null;e||(this._renderedCapability=(0,n.createPromiseCapability)());this._pendingDispatchEvent&&clearTimeout(this._pendingDispatchEvent);this._pendingDispatchEvent=null}_dispatchEvent(e){this._renderedCapability.resolve();if(this._pendingDispatchEvent){clearTimeout(this._pendingDispatchEvent);this._pendingDispatchEvent=null}0!==e?this.eventBus.dispatch("attachmentsloaded",{source:this,attachmentsCount:e}):this._pendingDispatchEvent=setTimeout((()=>{this.eventBus.dispatch("attachmentsloaded",{source:this,attachmentsCount:0});this._pendingDispatchEvent=null}))}_bindLink(e,{content:t,filename:i}){e.onclick=()=>{this.downloadManager.openOrDownloadData(e,t,i);return!1}}render({attachments:e,keepRenderedCapability:t=!1}){this._attachments&&this.reset(t);this._attachments=e||null;if(!e){this._dispatchEvent(0);return}const i=Object.keys(e).sort((function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())})),s=document.createDocumentFragment();let r=0;for(const t of i){const i=e[t],a=i.content,o=(0,n.getFilenameFromUrl)(i.filename),l=document.createElement("div");l.className="treeItem";const c=document.createElement("a");this._bindLink(c,{content:a,filename:o});c.textContent=this._normalizeTextContent(o);l.appendChild(c);s.appendChild(l);r++}this._finishRendering(s,r)}_appendAttachment({id:e,filename:t,content:i}){const n=this._renderedCapability.promise;n.then((()=>{if(n!==this._renderedCapability.promise)return;let s=this._attachments;if(s){for(const t in s)if(e===t)return}else s=Object.create(null);s[e]={filename:t,content:i};this.render({attachments:s,keepRenderedCapability:!0})}))}}t.PDFAttachmentViewer=PDFAttachmentViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BaseTreeViewer=void 0;var n=i(5);const s="selected";class BaseTreeViewer{constructor(e){if(this.constructor===BaseTreeViewer)throw new Error("Cannot initialize BaseTreeViewer.");this.container=e.container;this.eventBus=e.eventBus;this.reset()}reset(){this._pdfDocument=null;this._lastToggleIsShow=!0;this._currentTreeItem=null;this.container.textContent="";this.container.classList.remove("treeWithDeepNesting")}_dispatchEvent(e){throw new Error("Not implemented: _dispatchEvent")}_bindLink(e,t){throw new Error("Not implemented: _bindLink")}_normalizeTextContent(e){return(0,n.removeNullCharacters)(e,!0)||"–"}_addToggleButton(e,t=!1){const i=document.createElement("div");i.className="treeItemToggler";t&&i.classList.add("treeItemsHidden");i.onclick=t=>{t.stopPropagation();i.classList.toggle("treeItemsHidden");if(t.shiftKey){const t=!i.classList.contains("treeItemsHidden");this._toggleTreeItem(e,t)}};e.insertBefore(i,e.firstChild)}_toggleTreeItem(e,t=!1){this._lastToggleIsShow=t;for(const i of e.querySelectorAll(".treeItemToggler"))i.classList.toggle("treeItemsHidden",!t)}_toggleAllTreeItems(){this._toggleTreeItem(this.container,!this._lastToggleIsShow)}_finishRendering(e,t,i=!1){if(i){this.container.classList.add("treeWithDeepNesting");this._lastToggleIsShow=!e.querySelector(".treeItemsHidden")}this.container.appendChild(e);this._dispatchEvent(t)}render(e){throw new Error("Not implemented: render")}_updateCurrentTreeItem(e=null){if(this._currentTreeItem){this._currentTreeItem.classList.remove(s);this._currentTreeItem=null}if(e){e.classList.add(s);this._currentTreeItem=e}}_scrollToCurrentTreeItem(e){if(!e)return;let t=e.parentNode;for(;t&&t!==this.container;){if(t.classList.contains("treeItem")){t.firstElementChild?.classList.remove("treeItemsHidden")}t=t.parentNode}this._updateCurrentTreeItem(e);this.container.scrollTo(e.offsetLeft,e.offsetTop+-100)}}t.BaseTreeViewer=BaseTreeViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFDocumentProperties=void 0;var n=i(5),s=i(3);const r=["en-us","en-lr","my"],a={"8.5x11":"Letter","8.5x14":"Legal"},o={"297x420":"A3","210x297":"A4"};function getPageName(e,t,i){return i[`${t?e.width:e.height}x${t?e.height:e.width}`]}t.PDFDocumentProperties=class PDFDocumentProperties{constructor({overlayName:e,fields:t,container:i,closeButton:n},s,a,o){this.overlayName=e;this.fields=t;this.container=i;this.overlayManager=s;this.l10n=o;this._reset();n.addEventListener("click",this.close.bind(this));this.overlayManager.register(this.overlayName,this.container,this.close.bind(this));a._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber}));a._on("rotationchanging",(e=>{this._pagesRotation=e.pagesRotation}));this._isNonMetricLocale=!0;o.getLanguage().then((e=>{this._isNonMetricLocale=r.includes(e)}))}async open(){const freezeFieldData=e=>{Object.defineProperty(this,"fieldData",{value:Object.freeze(e),writable:!1,enumerable:!0,configurable:!0})};await Promise.all([this.overlayManager.open(this.overlayName),this._dataAvailableCapability.promise]);const e=this._currentPageNumber,t=this._pagesRotation;if(this.fieldData&&e===this.fieldData._currentPageNumber&&t===this.fieldData._pagesRotation){this._updateUI();return}const{info:i,contentDispositionFilename:r,contentLength:a}=await this.pdfDocument.getMetadata(),[o,l,c,h,d,u]=await Promise.all([r||(0,n.getPdfFilenameFromUrl)(this.url),this._parseFileSize(a),this._parseDate(i.CreationDate),this._parseDate(i.ModDate),this.pdfDocument.getPage(e).then((e=>this._parsePageSize((0,s.getPageSizeInches)(e),t))),this._parseLinearization(i.IsLinearized)]);freezeFieldData({fileName:o,fileSize:l,title:i.Title,author:i.Author,subject:i.Subject,keywords:i.Keywords,creationDate:c,modificationDate:h,creator:i.Creator,producer:i.Producer,version:i.PDFFormatVersion,pageCount:this.pdfDocument.numPages,pageSize:d,linearized:u,_currentPageNumber:e,_pagesRotation:t});this._updateUI();const{length:p}=await this.pdfDocument.getDownloadInfo();if(a===p)return;const g=Object.assign(Object.create(null),this.fieldData);g.fileSize=await this._parseFileSize(p);freezeFieldData(g);this._updateUI()}close(){this.overlayManager.close(this.overlayName)}setDocument(e,t=null){if(this.pdfDocument){this._reset();this._updateUI(!0)}if(e){this.pdfDocument=e;this.url=t;this._dataAvailableCapability.resolve()}}_reset(){this.pdfDocument=null;this.url=null;delete this.fieldData;this._dataAvailableCapability=(0,n.createPromiseCapability)();this._currentPageNumber=1;this._pagesRotation=0}_updateUI(e=!1){if(!e&&this.fieldData){if(this.overlayManager.active===this.overlayName)for(const e in this.fields){const t=this.fieldData[e];this.fields[e].textContent=t||0===t?t:"-"}}else for(const e in this.fields)this.fields[e].textContent="-"}async _parseFileSize(e=0){const t=e/1024,i=t/1024;if(t)return this.l10n.get("document_properties_"+(i>=1?"mb":"kb"),{size_mb:i>=1&&(+i.toPrecision(3)).toLocaleString(),size_kb:i<1&&(+t.toPrecision(3)).toLocaleString(),size_b:e.toLocaleString()})}async _parsePageSize(e,t){if(!e)return;t%180!=0&&(e={width:e.height,height:e.width});const i=(0,s.isPortraitOrientation)(e);let n={width:Math.round(100*e.width)/100,height:Math.round(100*e.height)/100},r={width:Math.round(25.4*e.width*10)/10,height:Math.round(25.4*e.height*10)/10},l=getPageName(n,i,a)||getPageName(r,i,o);if(!(l||Number.isInteger(r.width)&&Number.isInteger(r.height))){const t={width:25.4*e.width,height:25.4*e.height},s={width:Math.round(r.width),height:Math.round(r.height)};if(Math.abs(t.width-s.width)<.1&&Math.abs(t.height-s.height)<.1){l=getPageName(s,i,o);if(l){n={width:Math.round(s.width/25.4*100)/100,height:Math.round(s.height/25.4*100)/100};r=s}}}const[{width:c,height:h},d,u,p]=await Promise.all([this._isNonMetricLocale?n:r,this.l10n.get("document_properties_page_size_unit_"+(this._isNonMetricLocale?"inches":"millimeters")),l&&this.l10n.get(`document_properties_page_size_name_${l.toLowerCase()}`),this.l10n.get("document_properties_page_size_orientation_"+(i?"portrait":"landscape"))]);return this.l10n.get(`document_properties_page_size_dimension_${u?"name_":""}string`,{width:c.toLocaleString(),height:h.toLocaleString(),unit:d,name:u,orientation:p})}async _parseDate(e){const t=n.PDFDateString.toDateObject(e);if(t)return this.l10n.get("document_properties_date_string",{date:t.toLocaleDateString(),time:t.toLocaleTimeString()})}_parseLinearization(e){return this.l10n.get("document_properties_linearized_"+(e?"yes":"no"))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFindBar=void 0;var n=i(14);t.PDFFindBar=class PDFFindBar{constructor(e,t,i){this.opened=!1;this.bar=e.bar;this.toggleButton=e.toggleButton;this.findField=e.findField;this.highlightAll=e.highlightAllCheckbox;this.caseSensitive=e.caseSensitiveCheckbox;this.entireWord=e.entireWordCheckbox;this.findMsg=e.findMsg;this.findResultsCount=e.findResultsCount;this.findPreviousButton=e.findPreviousButton;this.findNextButton=e.findNextButton;this.eventBus=t;this.l10n=i;this.toggleButton.addEventListener("click",(()=>{this.toggle()}));this.findField.addEventListener("input",(()=>{this.dispatchEvent("")}));this.bar.addEventListener("keydown",(e=>{switch(e.keyCode){case 13:e.target===this.findField&&this.dispatchEvent("again",e.shiftKey);break;case 27:this.close()}}));this.findPreviousButton.addEventListener("click",(()=>{this.dispatchEvent("again",!0)}));this.findNextButton.addEventListener("click",(()=>{this.dispatchEvent("again",!1)}));this.highlightAll.addEventListener("click",(()=>{this.dispatchEvent("highlightallchange")}));this.caseSensitive.addEventListener("click",(()=>{this.dispatchEvent("casesensitivitychange")}));this.entireWord.addEventListener("click",(()=>{this.dispatchEvent("entirewordchange")}));this.eventBus._on("resize",this._adjustWidth.bind(this))}reset(){this.updateUIState()}dispatchEvent(e,t=!1){this.eventBus.dispatch("find",{source:this,type:e,query:this.findField.value,phraseSearch:!0,caseSensitive:this.caseSensitive.checked,entireWord:this.entireWord.checked,highlightAll:this.highlightAll.checked,findPrevious:t})}updateUIState(e,t,i){let s=Promise.resolve(""),r="";switch(e){case n.FindState.FOUND:break;case n.FindState.PENDING:r="pending";break;case n.FindState.NOT_FOUND:s=this.l10n.get("find_not_found");r="notFound";break;case n.FindState.WRAPPED:s=this.l10n.get("find_reached_"+(t?"top":"bottom"))}this.findField.setAttribute("data-status",r);s.then((e=>{this.findMsg.textContent=e;this._adjustWidth()}));this.updateResultsCount(i)}updateResultsCount({current:e=0,total:t=0}={}){let i=Promise.resolve("");if(t>0)if(t>1e3){let e="find_match_count_limit";i=this.l10n.get(e,{limit:1e3})}else{let n="find_match_count";i=this.l10n.get(n,{current:e,total:t})}i.then((e=>{this.findResultsCount.textContent=e;this.findResultsCount.classList.toggle("hidden",!t);this._adjustWidth()}))}open(){if(!this.opened){this.opened=!0;this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.bar.classList.remove("hidden")}this.findField.select();this.findField.focus();this._adjustWidth()}close(){if(this.opened){this.opened=!1;this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false");this.bar.classList.add("hidden");this.eventBus.dispatch("findbarclose",{source:this})}}toggle(){this.opened?this.close():this.open()}_adjustWidth(){if(!this.opened)return;this.bar.classList.remove("wrapContainers");this.bar.clientHeight>this.bar.firstElementChild.clientHeight&&this.bar.classList.add("wrapContainers")}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFindController=t.FindState=void 0;var n=i(5),s=i(15),r=i(3);const a={FOUND:0,NOT_FOUND:1,WRAPPED:2,PENDING:3};t.FindState=a;const o={"‐":"-","‘":"'","’":"'","‚":"'","‛":"'","“":'"',"”":'"',"„":'"',"‟":'"',"¼":"1/4","½":"1/2","¾":"3/4"};let l=null;function normalize(e){if(!l){const e=Object.keys(o).join("");l=new RegExp(`[${e}]`,"g")}let t=null;return[e.replace(l,(function(e,i){const n=o[e],s=n.length-e.length;0!==s&&(t||=[]).push([i,s]);return n})),t]}function getOriginalIndex(e,t=null){if(!t)return e;let i=0;for(const[n,s]of t){const t=n+i;if(t>=e)break;if(t+s>e){i+=e-t;break}i+=s}return e-i}t.PDFFindController=class PDFFindController{constructor({linkService:e,eventBus:t}){this._linkService=e;this._eventBus=t;this._reset();t._on("find",this._onFind.bind(this));t._on("findbarclose",this._onFindBarClose.bind(this));this.executeCommand=(e,t)=>{console.error('Deprecated method `PDFFindController.executeCommand` called, please dispatch a "find"-event using the EventBus instead.');const i=Object.assign(Object.create(null),t,{type:e.substring("find".length)});this._onFind(i)}}get highlightMatches(){return this._highlightMatches}get pageMatches(){return this._pageMatches}get pageMatchesLength(){return this._pageMatchesLength}get selected(){return this._selected}get state(){return this._state}setDocument(e){this._pdfDocument&&this._reset();if(e){this._pdfDocument=e;this._firstPageCapability.resolve()}}_onFind(e){if(!e)return;const t=this._pdfDocument,{type:i}=e;(null===this._state||this._shouldDirtyMatch(e))&&(this._dirtyMatch=!0);this._state=e;"highlightallchange"!==i&&this._updateUIState(a.PENDING);this._firstPageCapability.promise.then((()=>{if(!this._pdfDocument||t&&this._pdfDocument!==t)return;this._extractText();const e=!this._highlightMatches,n=!!this._findTimeout;if(this._findTimeout){clearTimeout(this._findTimeout);this._findTimeout=null}if(i)if(this._dirtyMatch)this._nextMatch();else if("again"===i){this._nextMatch();e&&this._state.highlightAll&&this._updateAllPages()}else if("highlightallchange"===i){n?this._nextMatch():this._highlightMatches=!0;this._updateAllPages()}else this._nextMatch();else this._findTimeout=setTimeout((()=>{this._nextMatch();this._findTimeout=null}),250)}))}scrollMatchIntoView({element:e=null,selectedLeft:t=0,pageIndex:i=-1,matchIndex:n=-1}){if(!this._scrollMatches||!e)return;if(-1===n||n!==this._selected.matchIdx)return;if(-1===i||i!==this._selected.pageIdx)return;this._scrollMatches=!1;const s={top:-50,left:t+-400};(0,r.scrollIntoView)(e,s,!0)}_reset(){this._highlightMatches=!1;this._scrollMatches=!1;this._pdfDocument=null;this._pageMatches=[];this._pageMatchesLength=[];this._state=null;this._selected={pageIdx:-1,matchIdx:-1};this._offset={pageIdx:null,matchIdx:null,wrapped:!1};this._extractTextPromises=[];this._pageContents=[];this._pageDiffs=[];this._matchesCountTotal=0;this._pagesToSearch=null;this._pendingFindMatches=new Set;this._resumePageIdx=null;this._dirtyMatch=!1;clearTimeout(this._findTimeout);this._findTimeout=null;this._firstPageCapability=(0,n.createPromiseCapability)()}get _query(){if(this._state.query!==this._rawQuery){this._rawQuery=this._state.query;[this._normalizedQuery]=normalize(this._state.query)}return this._normalizedQuery}_shouldDirtyMatch(e){if(e.query!==this._state.query)return!0;switch(e.type){case"again":const e=this._selected.pageIdx+1,t=this._linkService;return e>=1&&e<=t.pagesCount&&e!==t.page&&!t.isPageVisible(e);case"highlightallchange":return!1}return!0}_prepareMatches(e,t,i){function isSubTerm(t){const i=e[t],n=e[t+1];if(t<e.length-1&&i.match===n.match){i.skipped=!0;return!0}for(let n=t-1;n>=0;n--){const t=e[n];if(!t.skipped){if(t.match+t.matchLength<i.match)break;if(t.match+t.matchLength>=i.match+i.matchLength){i.skipped=!0;return!0}}}return!1}e.sort((function(e,t){return e.match===t.match?e.matchLength-t.matchLength:e.match-t.match}));for(let n=0,s=e.length;n<s;n++)if(!isSubTerm(n)){t.push(e[n].match);i.push(e[n].matchLength)}}_isEntireWord(e,t,i){if(t>0){const i=e.charCodeAt(t),n=e.charCodeAt(t-1);if((0,s.getCharacterType)(i)===(0,s.getCharacterType)(n))return!1}const n=t+i-1;if(n<e.length-1){const t=e.charCodeAt(n),i=e.charCodeAt(n+1);if((0,s.getCharacterType)(t)===(0,s.getCharacterType)(i))return!1}return!0}_calculatePhraseMatch(e,t,i,n,s){const r=[],a=[],o=e.length;let l=-o;for(;;){l=i.indexOf(e,l+o);if(-1===l)break;if(s&&!this._isEntireWord(i,l,o))continue;const t=getOriginalIndex(l,n),c=getOriginalIndex(l+o-1,n)-t+1;r.push(t);a.push(c)}this._pageMatches[t]=r;this._pageMatchesLength[t]=a}_calculateWordMatch(e,t,i,n,s){const r=[],a=e.match(/\S+/g);for(let e=0,t=a.length;e<t;e++){const t=a[e],o=t.length;let l=-o;for(;;){l=i.indexOf(t,l+o);if(-1===l)break;if(s&&!this._isEntireWord(i,l,o))continue;const e=getOriginalIndex(l,n),a=getOriginalIndex(l+o-1,n)-e+1;r.push({match:e,matchLength:a,skipped:!1})}}this._pageMatchesLength[t]=[];this._pageMatches[t]=[];this._prepareMatches(r,this._pageMatches[t],this._pageMatchesLength[t])}_calculateMatch(e){let t=this._pageContents[e];const i=this._pageDiffs[e];let n=this._query;const{caseSensitive:s,entireWord:r,phraseSearch:a}=this._state;if(0===n.length)return;if(!s){t=t.toLowerCase();n=n.toLowerCase()}a?this._calculatePhraseMatch(n,e,t,i,r):this._calculateWordMatch(n,e,t,i,r);this._state.highlightAll&&this._updatePage(e);if(this._resumePageIdx===e){this._resumePageIdx=null;this._nextPageMatch()}const o=this._pageMatches[e].length;if(o>0){this._matchesCountTotal+=o;this._updateUIResultsCount()}}_extractText(){if(this._extractTextPromises.length>0)return;let e=Promise.resolve();for(let t=0,i=this._linkService.pagesCount;t<i;t++){const i=(0,n.createPromiseCapability)();this._extractTextPromises[t]=i.promise;e=e.then((()=>this._pdfDocument.getPage(t+1).then((e=>e.getTextContent({normalizeWhitespace:!0}))).then((e=>{const n=e.items,s=[];for(let e=0,t=n.length;e<t;e++)s.push(n[e].str);[this._pageContents[t],this._pageDiffs[t]]=normalize(s.join(""));i.resolve(t)}),(e=>{console.error(`Unable to get text content for page ${t+1}`,e);this._pageContents[t]="";this._pageDiffs[t]=null;i.resolve(t)}))))}}_updatePage(e){this._scrollMatches&&this._selected.pageIdx===e&&(this._linkService.page=e+1);this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:e})}_updateAllPages(){this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:-1})}_nextMatch(){const e=this._state.findPrevious,t=this._linkService.page-1,i=this._linkService.pagesCount;this._highlightMatches=!0;if(this._dirtyMatch){this._dirtyMatch=!1;this._selected.pageIdx=this._selected.matchIdx=-1;this._offset.pageIdx=t;this._offset.matchIdx=null;this._offset.wrapped=!1;this._resumePageIdx=null;this._pageMatches.length=0;this._pageMatchesLength.length=0;this._matchesCountTotal=0;this._updateAllPages();for(let e=0;e<i;e++)if(!this._pendingFindMatches.has(e)){this._pendingFindMatches.add(e);this._extractTextPromises[e].then((e=>{this._pendingFindMatches.delete(e);this._calculateMatch(e)}))}}if(""===this._query){this._updateUIState(a.FOUND);return}if(this._resumePageIdx)return;const n=this._offset;this._pagesToSearch=i;if(null!==n.matchIdx){const t=this._pageMatches[n.pageIdx].length;if(!e&&n.matchIdx+1<t||e&&n.matchIdx>0){n.matchIdx=e?n.matchIdx-1:n.matchIdx+1;this._updateMatch(!0);return}this._advanceOffsetPage(e)}this._nextPageMatch()}_matchesReady(e){const t=this._offset,i=e.length,n=this._state.findPrevious;if(i){t.matchIdx=n?i-1:0;this._updateMatch(!0);return!0}this._advanceOffsetPage(n);if(t.wrapped){t.matchIdx=null;if(this._pagesToSearch<0){this._updateMatch(!1);return!0}}return!1}_nextPageMatch(){null!==this._resumePageIdx&&console.error("There can only be one pending page.");let e=null;do{const t=this._offset.pageIdx;e=this._pageMatches[t];if(!e){this._resumePageIdx=t;break}}while(!this._matchesReady(e))}_advanceOffsetPage(e){const t=this._offset,i=this._linkService.pagesCount;t.pageIdx=e?t.pageIdx-1:t.pageIdx+1;t.matchIdx=null;this._pagesToSearch--;if(t.pageIdx>=i||t.pageIdx<0){t.pageIdx=e?i-1:0;t.wrapped=!0}}_updateMatch(e=!1){let t=a.NOT_FOUND;const i=this._offset.wrapped;this._offset.wrapped=!1;if(e){const e=this._selected.pageIdx;this._selected.pageIdx=this._offset.pageIdx;this._selected.matchIdx=this._offset.matchIdx;t=i?a.WRAPPED:a.FOUND;-1!==e&&e!==this._selected.pageIdx&&this._updatePage(e)}this._updateUIState(t,this._state.findPrevious);if(-1!==this._selected.pageIdx){this._scrollMatches=!0;this._updatePage(this._selected.pageIdx)}}_onFindBarClose(e){const t=this._pdfDocument;this._firstPageCapability.promise.then((()=>{if(this._pdfDocument&&(!t||this._pdfDocument===t)){if(this._findTimeout){clearTimeout(this._findTimeout);this._findTimeout=null}if(this._resumePageIdx){this._resumePageIdx=null;this._dirtyMatch=!0}this._updateUIState(a.FOUND);this._highlightMatches=!1;this._updateAllPages()}}))}_requestMatchesCount(){const{pageIdx:e,matchIdx:t}=this._selected;let i=0,n=this._matchesCountTotal;if(-1!==t){for(let t=0;t<e;t++)i+=this._pageMatches[t]?.length||0;i+=t+1}(i<1||i>n)&&(i=n=0);return{current:i,total:n}}_updateUIResultsCount(){this._eventBus.dispatch("updatefindmatchescount",{source:this,matchesCount:this._requestMatchesCount()})}_updateUIState(e,t=!1){this._eventBus.dispatch("updatefindcontrolstate",{source:this,state:e,previous:t,matchesCount:this._requestMatchesCount(),rawQuery:this._state?.query??null})}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CharacterType=void 0;t.getCharacterType=function getCharacterType(e){if(function isAlphabeticalScript(e){return e<11904}(e))return function isAscii(e){return 0==(65408&e)}(e)?function isAsciiSpace(e){return 32===e||9===e||13===e||10===e}(e)?i.SPACE:function isAsciiAlpha(e){return e>=97&&e<=122||e>=65&&e<=90}(e)||function isAsciiDigit(e){return e>=48&&e<=57}(e)||95===e?i.ALPHA_LETTER:i.PUNCT:function isThai(e){return 3584==(65408&e)}(e)?i.THAI_LETTER:160===e?i.SPACE:i.ALPHA_LETTER;if(function isHan(e){return e>=13312&&e<=40959||e>=63744&&e<=64255}(e))return i.HAN_LETTER;if(function isKatakana(e){return e>=12448&&e<=12543}(e))return i.KATAKANA_LETTER;if(function isHiragana(e){return e>=12352&&e<=12447}(e))return i.HIRAGANA_LETTER;if(function isHalfwidthKatakana(e){return e>=65376&&e<=65439}(e))return i.HALFWIDTH_KATAKANA_LETTER;return i.ALPHA_LETTER};const i={SPACE:0,ALPHA_LETTER:1,PUNCT:2,HAN_LETTER:3,KATAKANA_LETTER:4,HIRAGANA_LETTER:5,HALFWIDTH_KATAKANA_LETTER:6,THAI_LETTER:7};t.CharacterType=i},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFHistory=void 0;t.isDestArraysEqual=isDestArraysEqual;t.isDestHashesEqual=isDestHashesEqual;var n=i(3),s=i(4);function getCurrentHash(){return document.location.hash}t.PDFHistory=class PDFHistory{constructor({linkService:e,eventBus:t}){this.linkService=e;this.eventBus=t;this._initialized=!1;this._fingerprint="";this.reset();this._boundEvents=null;this._isViewerInPresentationMode=!1;this.eventBus._on("presentationmodechanged",(e=>{this._isViewerInPresentationMode=e.state!==n.PresentationModeState.NORMAL}));this.eventBus._on("pagesinit",(()=>{this._isPagesLoaded=!1;this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount}),{once:!0})}))}initialize({fingerprint:e,resetHistory:t=!1,updateUrl:i=!1}){if(!e||"string"!=typeof e){console.error('PDFHistory.initialize: The "fingerprint" must be a non-empty string.');return}this._initialized&&this.reset();const n=""!==this._fingerprint&&this._fingerprint!==e;this._fingerprint=e;this._updateUrl=!0===i;this._initialized=!0;this._bindEvents();const s=window.history.state;this._popStateInProgress=!1;this._blockHashChange=0;this._currentHash=getCurrentHash();this._numPositionUpdates=0;this._uid=this._maxUid=0;this._destination=null;this._position=null;if(!this._isValidState(s,!0)||t){const{hash:e,page:i,rotation:s}=this._parseCurrentHash(!0);if(!e||n||t){this._pushOrReplaceState(null,!0);return}this._pushOrReplaceState({hash:e,page:i,rotation:s},!0);return}const r=s.destination;this._updateInternalState(r,s.uid,!0);void 0!==r.rotation&&(this._initialRotation=r.rotation);if(r.dest){this._initialBookmark=JSON.stringify(r.dest);this._destination.page=null}else r.hash?this._initialBookmark=r.hash:r.page&&(this._initialBookmark=`page=${r.page}`)}reset(){if(this._initialized){this._pageHide();this._initialized=!1;this._unbindEvents()}if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}this._initialBookmark=null;this._initialRotation=null}push({namedDest:e=null,explicitDest:t,pageNumber:i}){if(!this._initialized)return;if(e&&"string"!=typeof e){console.error(`PDFHistory.push: "${e}" is not a valid namedDest parameter.`);return}if(!Array.isArray(t)){console.error(`PDFHistory.push: "${t}" is not a valid explicitDest parameter.`);return}if(!this._isValidPage(i)&&(null!==i||this._destination)){console.error(`PDFHistory.push: "${i}" is not a valid pageNumber parameter.`);return}const n=e||JSON.stringify(t);if(!n)return;let s=!1;if(this._destination&&(isDestHashesEqual(this._destination.hash,n)||isDestArraysEqual(this._destination.dest,t))){if(this._destination.page)return;s=!0}if(!this._popStateInProgress||s){this._pushOrReplaceState({dest:t,hash:n,page:i,rotation:this.linkService.rotation},s);if(!this._popStateInProgress){this._popStateInProgress=!0;Promise.resolve().then((()=>{this._popStateInProgress=!1}))}}}pushPage(e){if(this._initialized)if(this._isValidPage(e)){if(this._destination?.page!==e&&!this._popStateInProgress){this._pushOrReplaceState({dest:null,hash:`page=${e}`,page:e,rotation:this.linkService.rotation});if(!this._popStateInProgress){this._popStateInProgress=!0;Promise.resolve().then((()=>{this._popStateInProgress=!1}))}}}else console.error(`PDFHistory.pushPage: "${e}" is not a valid page number.`)}pushCurrentPosition(){this._initialized&&!this._popStateInProgress&&this._tryPushCurrentPosition()}back(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid>0&&window.history.back()}forward(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid<this._maxUid&&window.history.forward()}get popStateInProgress(){return this._initialized&&(this._popStateInProgress||this._blockHashChange>0)}get initialBookmark(){return this._initialized?this._initialBookmark:null}get initialRotation(){return this._initialized?this._initialRotation:null}_pushOrReplaceState(e,t=!1){const i=t||!this._destination,n={fingerprint:this._fingerprint,uid:i?this._uid:this._uid+1,destination:e};this._updateInternalState(e,n.uid);let s;if(this._updateUrl&&e?.hash){const t=document.location.href.split("#")[0];t.startsWith("file://")||(s=`${t}#${e.hash}`)}i?window.history.replaceState(n,"",s):window.history.pushState(n,"",s)}_tryPushCurrentPosition(e=!1){if(!this._position)return;let t=this._position;if(e){t=Object.assign(Object.create(null),this._position);t.temporary=!0}if(!this._destination){this._pushOrReplaceState(t);return}if(this._destination.temporary){this._pushOrReplaceState(t,!0);return}if(this._destination.hash===t.hash)return;if(!this._destination.page&&this._numPositionUpdates<=50)return;let i=!1;if(this._destination.page>=t.first&&this._destination.page<=t.page){if(void 0!==this._destination.dest||!this._destination.first)return;i=!0}this._pushOrReplaceState(t,i)}_isValidPage(e){return Number.isInteger(e)&&e>0&&e<=this.linkService.pagesCount}_isValidState(e,t=!1){if(!e)return!1;if(e.fingerprint!==this._fingerprint){if(!t)return!1;{if("string"!=typeof e.fingerprint||e.fingerprint.length!==this._fingerprint.length)return!1;const[t]=performance.getEntriesByType("navigation");if("reload"!==t?.type)return!1}}return!(!Number.isInteger(e.uid)||e.uid<0)&&(null!==e.destination&&"object"==typeof e.destination)}_updateInternalState(e,t,i=!1){if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}i&&e?.temporary&&delete e.temporary;this._destination=e;this._uid=t;this._maxUid=Math.max(this._maxUid,t);this._numPositionUpdates=0}_parseCurrentHash(e=!1){const t=unescape(getCurrentHash()).substring(1),i=(0,n.parseQueryString)(t),s=i.get("nameddest")||"";let r=0|i.get("page");(!this._isValidPage(r)||e&&s.length>0)&&(r=null);return{hash:t,page:r,rotation:this.linkService.rotation}}_updateViewarea({location:e}){if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}this._position={hash:this._isViewerInPresentationMode?`page=${e.pageNumber}`:e.pdfOpenParams.substring(1),page:this.linkService.page,first:e.pageNumber,rotation:e.rotation};if(!this._popStateInProgress){this._isPagesLoaded&&this._destination&&!this._destination.page&&this._numPositionUpdates++;this._updateViewareaTimeout=setTimeout((()=>{this._popStateInProgress||this._tryPushCurrentPosition(!0);this._updateViewareaTimeout=null}),1e3)}}_popState({state:e}){const t=getCurrentHash(),i=this._currentHash!==t;this._currentHash=t;if(!e){this._uid++;const{hash:e,page:t,rotation:i}=this._parseCurrentHash();this._pushOrReplaceState({hash:e,page:t,rotation:i},!0);return}if(!this._isValidState(e))return;this._popStateInProgress=!0;if(i){this._blockHashChange++;(0,s.waitOnEventOrTimeout)({target:window,name:"hashchange",delay:1e3}).then((()=>{this._blockHashChange--}))}const r=e.destination;this._updateInternalState(r,e.uid,!0);(0,n.isValidRotation)(r.rotation)&&(this.linkService.rotation=r.rotation);r.dest?this.linkService.goToDestination(r.dest):r.hash?this.linkService.setHash(r.hash):r.page&&(this.linkService.page=r.page);Promise.resolve().then((()=>{this._popStateInProgress=!1}))}_pageHide(){this._destination&&!this._destination.temporary||this._tryPushCurrentPosition()}_bindEvents(){if(!this._boundEvents){this._boundEvents={updateViewarea:this._updateViewarea.bind(this),popState:this._popState.bind(this),pageHide:this._pageHide.bind(this)};this.eventBus._on("updateviewarea",this._boundEvents.updateViewarea);window.addEventListener("popstate",this._boundEvents.popState);window.addEventListener("pagehide",this._boundEvents.pageHide)}}_unbindEvents(){if(this._boundEvents){this.eventBus._off("updateviewarea",this._boundEvents.updateViewarea);window.removeEventListener("popstate",this._boundEvents.popState);window.removeEventListener("pagehide",this._boundEvents.pageHide);this._boundEvents=null}}};function isDestHashesEqual(e,t){if("string"!=typeof e||"string"!=typeof t)return!1;if(e===t)return!0;return(0,n.parseQueryString)(e).get("nameddest")===t}function isDestArraysEqual(e,t){function isEntryEqual(e,t){if(typeof e!=typeof t)return!1;if(Array.isArray(e)||Array.isArray(t))return!1;if(null!==e&&"object"==typeof e&&null!==t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!isEntryEqual(e[i],t[i]))return!1;return!0}return e===t||Number.isNaN(e)&&Number.isNaN(t)}if(!Array.isArray(e)||!Array.isArray(t))return!1;if(e.length!==t.length)return!1;for(let i=0,n=e.length;i<n;i++)if(!isEntryEqual(e[i],t[i]))return!1;return!0}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFLayerViewer=void 0;var n=i(11);class PDFLayerViewer extends n.BaseTreeViewer{constructor(e){super(e);this.l10n=e.l10n;this.eventBus._on("resetlayers",this._resetLayers.bind(this));this.eventBus._on("togglelayerstree",this._toggleAllTreeItems.bind(this))}reset(){super.reset();this._optionalContentConfig=null}_dispatchEvent(e){this.eventBus.dispatch("layersloaded",{source:this,layersCount:e})}_bindLink(e,{groupId:t,input:i}){const setVisibility=()=>{this._optionalContentConfig.setVisibility(t,i.checked);this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(this._optionalContentConfig)})};e.onclick=t=>{if(t.target===i){setVisibility();return!0}if(t.target!==e)return!0;i.checked=!i.checked;setVisibility();return!1}}async _setNestedName(e,{name:t=null}){if("string"!=typeof t){e.textContent=await this.l10n.get("additional_layers");e.style.fontStyle="italic"}else e.textContent=this._normalizeTextContent(t)}_addToggleButton(e,{name:t=null}){super._addToggleButton(e,null===t)}_toggleAllTreeItems(){this._optionalContentConfig&&super._toggleAllTreeItems()}render({optionalContentConfig:e,pdfDocument:t}){this._optionalContentConfig&&this.reset();this._optionalContentConfig=e||null;this._pdfDocument=t||null;const i=e?.getOrder();if(!i){this._dispatchEvent(0);return}const n=document.createDocumentFragment(),s=[{parent:n,groups:i}];let r=0,a=!1;for(;s.length>0;){const t=s.shift();for(const i of t.groups){const n=document.createElement("div");n.className="treeItem";const o=document.createElement("a");n.appendChild(o);if("object"==typeof i){a=!0;this._addToggleButton(n,i);this._setNestedName(o,i);const e=document.createElement("div");e.className="treeItems";n.appendChild(e);s.push({parent:e,groups:i.order})}else{const t=e.getGroup(i),n=document.createElement("input");this._bindLink(o,{groupId:i,input:n});n.type="checkbox";n.id=i;n.checked=t.visible;const s=document.createElement("label");s.setAttribute("for",i);s.textContent=this._normalizeTextContent(t.name);o.appendChild(n);o.appendChild(s);r++}t.parent.appendChild(n)}}this._finishRendering(n,r,a)}async _resetLayers(){if(!this._optionalContentConfig)return;const e=await this._pdfDocument.getOptionalContentConfig();this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(e)});this.render({optionalContentConfig:e,pdfDocument:this._pdfDocument})}}t.PDFLayerViewer=PDFLayerViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SimpleLinkService=t.PDFLinkService=void 0;var n=i(5),s=i(3);t.PDFLinkService=class PDFLinkService{constructor({eventBus:e,externalLinkTarget:t=null,externalLinkRel:i=null,ignoreDestinationZoom:n=!1}={}){this.eventBus=e;this.externalLinkTarget=t;this.externalLinkRel=i;this.externalLinkEnabled=!0;this._ignoreDestinationZoom=n;this.baseUrl=null;this.pdfDocument=null;this.pdfViewer=null;this.pdfHistory=null;this._pagesRefCache=null}setDocument(e,t=null){this.baseUrl=t;this.pdfDocument=e;this._pagesRefCache=Object.create(null)}setViewer(e){this.pdfViewer=e}setHistory(e){this.pdfHistory=e}get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0}get page(){return this.pdfViewer.currentPageNumber}set page(e){this.pdfViewer.currentPageNumber=e}get rotation(){return this.pdfViewer.pagesRotation}set rotation(e){this.pdfViewer.pagesRotation=e}_goToDestinationHelper(e,t=null,i){const n=i[0];let s;if("object"==typeof n&&null!==n){s=this._cachedPageNumber(n);if(!s){this.pdfDocument.getPageIndex(n).then((s=>{this.cachePageRef(s+1,n);this._goToDestinationHelper(e,t,i)})).catch((()=>{console.error(`PDFLinkService._goToDestinationHelper: "${n}" is not a valid page reference, for dest="${e}".`)}));return}}else{if(!Number.isInteger(n)){console.error(`PDFLinkService._goToDestinationHelper: "${n}" is not a valid destination reference, for dest="${e}".`);return}s=n+1}if(!s||s<1||s>this.pagesCount)console.error(`PDFLinkService._goToDestinationHelper: "${s}" is not a valid page number, for dest="${e}".`);else{if(this.pdfHistory){this.pdfHistory.pushCurrentPosition();this.pdfHistory.push({namedDest:t,explicitDest:i,pageNumber:s})}this.pdfViewer.scrollPageIntoView({pageNumber:s,destArray:i,ignoreDestinationZoom:this._ignoreDestinationZoom})}}async goToDestination(e){if(!this.pdfDocument)return;let t,i;if("string"==typeof e){t=e;i=await this.pdfDocument.getDestination(e)}else{t=null;i=await e}Array.isArray(i)?this._goToDestinationHelper(e,t,i):console.error(`PDFLinkService.goToDestination: "${i}" is not a valid destination array, for dest="${e}".`)}goToPage(e){if(!this.pdfDocument)return;const t="string"==typeof e&&this.pdfViewer.pageLabelToPageNumber(e)||0|e;if(Number.isInteger(t)&&t>0&&t<=this.pagesCount){if(this.pdfHistory){this.pdfHistory.pushCurrentPosition();this.pdfHistory.pushPage(t)}this.pdfViewer.scrollPageIntoView({pageNumber:t})}else console.error(`PDFLinkService.goToPage: "${e}" is not a valid page.`)}addLinkAttributes(e,t,i=!1){(0,n.addLinkAttributes)(e,{url:t,target:i?n.LinkTarget.BLANK:this.externalLinkTarget,rel:this.externalLinkRel,enabled:this.externalLinkEnabled})}getDestinationHash(e){if("string"==typeof e){if(e.length>0)return this.getAnchorUrl("#"+escape(e))}else if(Array.isArray(e)){const t=JSON.stringify(e);if(t.length>0)return this.getAnchorUrl("#"+escape(t))}return this.getAnchorUrl("")}getAnchorUrl(e){return(this.baseUrl||"")+e}setHash(e){if(!this.pdfDocument)return;let t,i;if(e.includes("=")){const n=(0,s.parseQueryString)(e);n.has("search")&&this.eventBus.dispatch("findfromurlhash",{source:this,query:n.get("search").replace(/"/g,""),phraseSearch:"true"===n.get("phrase")});n.has("page")&&(t=0|n.get("page")||1);if(n.has("zoom")){const e=n.get("zoom").split(","),t=e[0],s=parseFloat(t);t.includes("Fit")?"Fit"===t||"FitB"===t?i=[null,{name:t}]:"FitH"===t||"FitBH"===t||"FitV"===t||"FitBV"===t?i=[null,{name:t},e.length>1?0|e[1]:null]:"FitR"===t?5!==e.length?console.error('PDFLinkService.setHash: Not enough parameters for "FitR".'):i=[null,{name:t},0|e[1],0|e[2],0|e[3],0|e[4]]:console.error(`PDFLinkService.setHash: "${t}" is not a valid zoom value.`):i=[null,{name:"XYZ"},e.length>1?0|e[1]:null,e.length>2?0|e[2]:null,s?s/100:t]}i?this.pdfViewer.scrollPageIntoView({pageNumber:t||this.page,destArray:i,allowNegativeOffset:!0}):t&&(this.page=t);n.has("pagemode")&&this.eventBus.dispatch("pagemode",{source:this,mode:n.get("pagemode")});n.has("nameddest")&&this.goToDestination(n.get("nameddest"))}else{i=unescape(e);try{i=JSON.parse(i);Array.isArray(i)||(i=i.toString())}catch(e){}if("string"==typeof i||function isValidExplicitDestination(e){if(!Array.isArray(e))return!1;const t=e.length;if(t<2)return!1;const i=e[0];if(!("object"==typeof i&&Number.isInteger(i.num)&&Number.isInteger(i.gen)||Number.isInteger(i)&&i>=0))return!1;const n=e[1];if("object"!=typeof n||"string"!=typeof n.name)return!1;let s=!0;switch(n.name){case"XYZ":if(5!==t)return!1;break;case"Fit":case"FitB":return 2===t;case"FitH":case"FitBH":case"FitV":case"FitBV":if(3!==t)return!1;break;case"FitR":if(6!==t)return!1;s=!1;break;default:return!1}for(let i=2;i<t;i++){const t=e[i];if(!("number"==typeof t||s&&null===t))return!1}return!0}(i)){this.goToDestination(i);return}console.error(`PDFLinkService.setHash: "${unescape(e)}" is not a valid destination.`)}}executeNamedAction(e){switch(e){case"GoBack":this.pdfHistory?.back();break;case"GoForward":this.pdfHistory?.forward();break;case"NextPage":this.pdfViewer.nextPage();break;case"PrevPage":this.pdfViewer.previousPage();break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1}this.eventBus.dispatch("namedaction",{source:this,action:e})}cachePageRef(e,t){if(!t)return;const i=0===t.gen?`${t.num}R`:`${t.num}R${t.gen}`;this._pagesRefCache[i]=e}_cachedPageNumber(e){if(!e)return null;const t=0===e.gen?`${e.num}R`:`${e.num}R${e.gen}`;return this._pagesRefCache?.[t]||null}isPageVisible(e){return this.pdfViewer.isPageVisible(e)}isPageCached(e){return this.pdfViewer.isPageCached(e)}};t.SimpleLinkService=class SimpleLinkService{constructor(){this.externalLinkEnabled=!0}get pagesCount(){return 0}get page(){return 0}set page(e){}get rotation(){return 0}set rotation(e){}async goToDestination(e){}goToPage(e){}addLinkAttributes(e,t,i=!1){(0,n.addLinkAttributes)(e,{url:t,enabled:this.externalLinkEnabled})}getDestinationHash(e){return"#"}getAnchorUrl(e){return"#"}setHash(e){}executeNamedAction(e){}cachePageRef(e,t){}isPageVisible(e){return!0}isPageCached(e){return!0}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFOutlineViewer=void 0;var n=i(11),s=i(5),r=i(3);class PDFOutlineViewer extends n.BaseTreeViewer{constructor(e){super(e);this.linkService=e.linkService;this.eventBus._on("toggleoutlinetree",this._toggleAllTreeItems.bind(this));this.eventBus._on("currentoutlineitem",this._currentOutlineItem.bind(this));this.eventBus._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber}));this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount;this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(this._isPagesLoaded)}));this.eventBus._on("sidebarviewchanged",(e=>{this._sidebarView=e.view}))}reset(){super.reset();this._outline=null;this._pageNumberToDestHashCapability=null;this._currentPageNumber=1;this._isPagesLoaded=null;this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(!1);this._currentOutlineItemCapability=null}_dispatchEvent(e){this._currentOutlineItemCapability=(0,s.createPromiseCapability)();0===e||this._pdfDocument?.loadingParams.disableAutoFetch?this._currentOutlineItemCapability.resolve(!1):null!==this._isPagesLoaded&&this._currentOutlineItemCapability.resolve(this._isPagesLoaded);this.eventBus.dispatch("outlineloaded",{source:this,outlineCount:e,currentOutlineItemPromise:this._currentOutlineItemCapability.promise})}_bindLink(e,{url:t,newWindow:i,dest:n}){const{linkService:s}=this;if(t)s.addLinkAttributes(e,t,i);else{e.href=s.getDestinationHash(n);e.onclick=e=>{this._updateCurrentTreeItem(e.target.parentNode);n&&s.goToDestination(n);return!1}}}_setStyles(e,{bold:t,italic:i}){t&&(e.style.fontWeight="bold");i&&(e.style.fontStyle="italic")}_addToggleButton(e,{count:t,items:i}){let n=!1;if(t<0){let e=i.length;if(e>0){const t=[...i];for(;t.length>0;){const{count:i,items:n}=t.shift();if(i>0&&n.length>0){e+=n.length;t.push(...n)}}}Math.abs(t)===e&&(n=!0)}super._addToggleButton(e,n)}_toggleAllTreeItems(){this._outline&&super._toggleAllTreeItems()}render({outline:e,pdfDocument:t}){this._outline&&this.reset();this._outline=e||null;this._pdfDocument=t||null;if(!e){this._dispatchEvent(0);return}const i=document.createDocumentFragment(),n=[{parent:i,items:e}];let s=0,r=!1;for(;n.length>0;){const e=n.shift();for(const t of e.items){const i=document.createElement("div");i.className="treeItem";const a=document.createElement("a");this._bindLink(a,t);this._setStyles(a,t);a.textContent=this._normalizeTextContent(t.title);i.appendChild(a);if(t.items.length>0){r=!0;this._addToggleButton(i,t);const e=document.createElement("div");e.className="treeItems";i.appendChild(e);n.push({parent:e,items:t.items})}e.parent.appendChild(i);s++}}this._finishRendering(i,s,r)}async _currentOutlineItem(){if(!this._isPagesLoaded)throw new Error("_currentOutlineItem: All pages have not been loaded.");if(!this._outline||!this._pdfDocument)return;const e=await this._getPageNumberToDestHash(this._pdfDocument);if(e){this._updateCurrentTreeItem(null);if(this._sidebarView===r.SidebarView.OUTLINE)for(let t=this._currentPageNumber;t>0;t--){const i=e.get(t);if(!i)continue;const n=this.container.querySelector(`a[href="${i}"]`);if(n){this._scrollToCurrentTreeItem(n.parentNode);break}}}}async _getPageNumberToDestHash(e){if(this._pageNumberToDestHashCapability)return this._pageNumberToDestHashCapability.promise;this._pageNumberToDestHashCapability=(0,s.createPromiseCapability)();const t=new Map,i=new Map,n=[{nesting:0,items:this._outline}];for(;n.length>0;){const s=n.shift(),r=s.nesting;for(const{dest:a,items:o}of s.items){let s,l;if("string"==typeof a){s=await e.getDestination(a);if(e!==this._pdfDocument)return null}else s=a;if(Array.isArray(s)){const[n]=s;if("object"==typeof n&&null!==n){l=this.linkService._cachedPageNumber(n);if(!l)try{l=await e.getPageIndex(n)+1;if(e!==this._pdfDocument)return null;this.linkService.cachePageRef(l,n)}catch(e){}}else Number.isInteger(n)&&(l=n+1);if(Number.isInteger(l)&&(!t.has(l)||r>i.get(l))){const e=this.linkService.getDestinationHash(a);t.set(l,e);i.set(l,r)}}o.length>0&&n.push({nesting:r+1,items:o})}}this._pageNumberToDestHashCapability.resolve(t.size>0?t:null);return this._pageNumberToDestHashCapability.promise}}t.PDFOutlineViewer=PDFOutlineViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPresentationMode=void 0;var n=i(3);const s="pdfPresentationMode",r="pdfPresentationModeControls",a=Math.PI/6;t.PDFPresentationMode=class PDFPresentationMode{constructor({container:e,pdfViewer:t,eventBus:i}){this.container=e;this.pdfViewer=t;this.eventBus=i;this.active=!1;this.args=null;this.contextMenuOpen=!1;this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0;this.touchSwipeState=null}request(){if(this.switchInProgress||this.active||!this.pdfViewer.pagesCount)return!1;this._addFullscreenChangeListeners();this._setSwitchInProgress();this._notifyStateChange();if(this.container.requestFullscreen)this.container.requestFullscreen();else if(this.container.mozRequestFullScreen)this.container.mozRequestFullScreen();else{if(!this.container.webkitRequestFullscreen)return!1;this.container.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)}this.args={pageNumber:this.pdfViewer.currentPageNumber,scaleValue:this.pdfViewer.currentScaleValue,scrollMode:this.pdfViewer.scrollMode,spreadMode:this.pdfViewer.spreadMode};return!0}_mouseWheel(e){if(!this.active)return;e.preventDefault();const t=(0,n.normalizeWheelEventDelta)(e),i=Date.now(),s=this.mouseScrollTimeStamp;if(!(i>s&&i-s<50)){(this.mouseScrollDelta>0&&t<0||this.mouseScrollDelta<0&&t>0)&&this._resetMouseScrollState();this.mouseScrollDelta+=t;if(Math.abs(this.mouseScrollDelta)>=.1){const e=this.mouseScrollDelta;this._resetMouseScrollState();(e>0?this.pdfViewer.previousPage():this.pdfViewer.nextPage())&&(this.mouseScrollTimeStamp=i)}}}get isFullscreen(){return!!(document.fullscreenElement||document.mozFullScreen||document.webkitIsFullScreen)}_notifyStateChange(){let e=n.PresentationModeState.NORMAL;this.switchInProgress?e=n.PresentationModeState.CHANGING:this.active&&(e=n.PresentationModeState.FULLSCREEN);this.eventBus.dispatch("presentationmodechanged",{source:this,state:e})}_setSwitchInProgress(){this.switchInProgress&&clearTimeout(this.switchInProgress);this.switchInProgress=setTimeout((()=>{this._removeFullscreenChangeListeners();delete this.switchInProgress;this._notifyStateChange()}),1500)}_resetSwitchInProgress(){if(this.switchInProgress){clearTimeout(this.switchInProgress);delete this.switchInProgress}}_enter(){this.active=!0;this._resetSwitchInProgress();this._notifyStateChange();this.container.classList.add(s);setTimeout((()=>{this.pdfViewer.scrollMode=n.ScrollMode.PAGE;this.pdfViewer.spreadMode=n.SpreadMode.NONE;this.pdfViewer.currentPageNumber=this.args.pageNumber;this.pdfViewer.currentScaleValue="page-fit"}),0);this._addWindowListeners();this._showControls();this.contextMenuOpen=!1;window.getSelection().removeAllRanges()}_exit(){const e=this.pdfViewer.currentPageNumber;this.container.classList.remove(s);setTimeout((()=>{this.active=!1;this._removeFullscreenChangeListeners();this._notifyStateChange();this.pdfViewer.scrollMode=this.args.scrollMode;this.pdfViewer.spreadMode=this.args.spreadMode;this.pdfViewer.currentScaleValue=this.args.scaleValue;this.pdfViewer.currentPageNumber=e;this.args=null}),0);this._removeWindowListeners();this._hideControls();this._resetMouseScrollState();this.contextMenuOpen=!1}_mouseDown(e){if(this.contextMenuOpen){this.contextMenuOpen=!1;e.preventDefault()}else if(0===e.button){if(!(e.target.href&&e.target.classList.contains("internalLink"))){e.preventDefault();e.shiftKey?this.pdfViewer.previousPage():this.pdfViewer.nextPage()}}}_contextMenu(){this.contextMenuOpen=!0}_showControls(){this.controlsTimeout?clearTimeout(this.controlsTimeout):this.container.classList.add(r);this.controlsTimeout=setTimeout((()=>{this.container.classList.remove(r);delete this.controlsTimeout}),3e3)}_hideControls(){if(this.controlsTimeout){clearTimeout(this.controlsTimeout);this.container.classList.remove(r);delete this.controlsTimeout}}_resetMouseScrollState(){this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0}_touchSwipe(e){if(this.active)if(e.touches.length>1)this.touchSwipeState=null;else switch(e.type){case"touchstart":this.touchSwipeState={startX:e.touches[0].pageX,startY:e.touches[0].pageY,endX:e.touches[0].pageX,endY:e.touches[0].pageY};break;case"touchmove":if(null===this.touchSwipeState)return;this.touchSwipeState.endX=e.touches[0].pageX;this.touchSwipeState.endY=e.touches[0].pageY;e.preventDefault();break;case"touchend":if(null===this.touchSwipeState)return;let t=0;const i=this.touchSwipeState.endX-this.touchSwipeState.startX,n=this.touchSwipeState.endY-this.touchSwipeState.startY,s=Math.abs(Math.atan2(n,i));Math.abs(i)>50&&(s<=a||s>=Math.PI-a)?t=i:Math.abs(n)>50&&Math.abs(s-Math.PI/2)<=a&&(t=n);t>0?this.pdfViewer.previousPage():t<0&&this.pdfViewer.nextPage()}}_addWindowListeners(){this.showControlsBind=this._showControls.bind(this);this.mouseDownBind=this._mouseDown.bind(this);this.mouseWheelBind=this._mouseWheel.bind(this);this.resetMouseScrollStateBind=this._resetMouseScrollState.bind(this);this.contextMenuBind=this._contextMenu.bind(this);this.touchSwipeBind=this._touchSwipe.bind(this);window.addEventListener("mousemove",this.showControlsBind);window.addEventListener("mousedown",this.mouseDownBind);window.addEventListener("wheel",this.mouseWheelBind,{passive:!1});window.addEventListener("keydown",this.resetMouseScrollStateBind);window.addEventListener("contextmenu",this.contextMenuBind);window.addEventListener("touchstart",this.touchSwipeBind);window.addEventListener("touchmove",this.touchSwipeBind);window.addEventListener("touchend",this.touchSwipeBind)}_removeWindowListeners(){window.removeEventListener("mousemove",this.showControlsBind);window.removeEventListener("mousedown",this.mouseDownBind);window.removeEventListener("wheel",this.mouseWheelBind,{passive:!1});window.removeEventListener("keydown",this.resetMouseScrollStateBind);window.removeEventListener("contextmenu",this.contextMenuBind);window.removeEventListener("touchstart",this.touchSwipeBind);window.removeEventListener("touchmove",this.touchSwipeBind);window.removeEventListener("touchend",this.touchSwipeBind);delete this.showControlsBind;delete this.mouseDownBind;delete this.mouseWheelBind;delete this.resetMouseScrollStateBind;delete this.contextMenuBind;delete this.touchSwipeBind}_fullscreenChange(){this.isFullscreen?this._enter():this._exit()}_addFullscreenChangeListeners(){this.fullscreenChangeBind=this._fullscreenChange.bind(this);window.addEventListener("fullscreenchange",this.fullscreenChangeBind);window.addEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.addEventListener("webkitfullscreenchange",this.fullscreenChangeBind)}_removeFullscreenChangeListeners(){window.removeEventListener("fullscreenchange",this.fullscreenChangeBind);window.removeEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.removeEventListener("webkitfullscreenchange",this.fullscreenChangeBind);delete this.fullscreenChangeBind}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFRenderingQueue=void 0;var n=i(5),s=i(3);t.PDFRenderingQueue=class PDFRenderingQueue{constructor(){this.pdfViewer=null;this.pdfThumbnailViewer=null;this.onIdle=null;this.highestPriorityPage=null;this.idleTimeout=null;this.printing=!1;this.isThumbnailViewEnabled=!1}setViewer(e){this.pdfViewer=e}setThumbnailViewer(e){this.pdfThumbnailViewer=e}isHighestPriority(e){return this.highestPriorityPage===e.renderingId}hasViewer(){return!!this.pdfViewer}renderHighestPriority(e){if(this.idleTimeout){clearTimeout(this.idleTimeout);this.idleTimeout=null}this.pdfViewer.forceRendering(e)||this.isThumbnailViewEnabled&&this.pdfThumbnailViewer?.forceRendering()||this.printing||this.onIdle&&(this.idleTimeout=setTimeout(this.onIdle.bind(this),3e4))}getHighestPriority(e,t,i,n=!1){const s=e.views,r=s.length;if(0===r)return null;for(let e=0;e<r;e++){const t=s[e].view;if(!this.isViewFinished(t))return t}const a=e.first.id,o=e.last.id;if(o-a+1>r){const n=e.ids;for(let e=1,s=o-a;e<s;e++){const s=i?a+e:o-e;if(n.has(s))continue;const r=t[s-1];if(!this.isViewFinished(r))return r}}let l=i?o:a-2,c=t[l];if(c&&!this.isViewFinished(c))return c;if(n){l+=i?1:-1;c=t[l];if(c&&!this.isViewFinished(c))return c}return null}isViewFinished(e){return e.renderingState===s.RenderingStates.FINISHED}renderView(e){switch(e.renderingState){case s.RenderingStates.FINISHED:return!1;case s.RenderingStates.PAUSED:this.highestPriorityPage=e.renderingId;e.resume();break;case s.RenderingStates.RUNNING:this.highestPriorityPage=e.renderingId;break;case s.RenderingStates.INITIAL:this.highestPriorityPage=e.renderingId;e.draw().finally((()=>{this.renderHighestPriority()})).catch((e=>{e instanceof n.RenderingCancelledException||console.error(`renderView: "${e}"`)}))}return!0}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFScriptingManager=void 0;var n=i(3),s=i(5);t.PDFScriptingManager=class PDFScriptingManager{constructor({eventBus:e,sandboxBundleSrc:t=null,scriptingFactory:i=null,docPropertiesLookup:n=null}){this._pdfDocument=null;this._pdfViewer=null;this._closeCapability=null;this._destroyCapability=null;this._scripting=null;this._mouseState=Object.create(null);this._ready=!1;this._eventBus=e;this._sandboxBundleSrc=t;this._scriptingFactory=i;this._docPropertiesLookup=n}setViewer(e){this._pdfViewer=e}async setDocument(e){this._pdfDocument&&await this._destroyScripting();this._pdfDocument=e;if(!e)return;const[t,i,n]=await Promise.all([e.getFieldObjects(),e.getCalculationOrderIds(),e.getJSActions()]);if(t||n){if(e===this._pdfDocument){try{this._scripting=this._createScripting()}catch(e){console.error(`PDFScriptingManager.setDocument: "${e?.message}".`);await this._destroyScripting();return}this._internalEvents.set("updatefromsandbox",(e=>{e?.source===window&&this._updateFromSandbox(e.detail)}));this._internalEvents.set("dispatcheventinsandbox",(e=>{this._scripting?.dispatchEventInSandbox(e.detail)}));this._internalEvents.set("pagechanging",(({pageNumber:e,previous:t})=>{if(e!==t){this._dispatchPageClose(t);this._dispatchPageOpen(e)}}));this._internalEvents.set("pagerendered",(({pageNumber:e})=>{this._pageOpenPending.has(e)&&e===this._pdfViewer.currentPageNumber&&this._dispatchPageOpen(e)}));this._internalEvents.set("pagesdestroy",(async e=>{await this._dispatchPageClose(this._pdfViewer.currentPageNumber);await(this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillClose"}));this._closeCapability?.resolve()}));this._domEvents.set("mousedown",(e=>{this._mouseState.isDown=!0}));this._domEvents.set("mouseup",(e=>{this._mouseState.isDown=!1}));for(const[e,t]of this._internalEvents)this._eventBus._on(e,t);for(const[e,t]of this._domEvents)window.addEventListener(e,t);try{const s=await this._getDocProperties();if(e!==this._pdfDocument)return;await this._scripting.createSandbox({objects:t,calculationOrder:i,appInfo:{platform:navigator.platform,language:navigator.language},docInfo:{...s,actions:n}});this._eventBus.dispatch("sandboxcreated",{source:this})}catch(e){console.error(`PDFScriptingManager.setDocument: "${e?.message}".`);await this._destroyScripting();return}await(this._scripting?.dispatchEventInSandbox({id:"doc",name:"Open"}));await this._dispatchPageOpen(this._pdfViewer.currentPageNumber,!0);Promise.resolve().then((()=>{e===this._pdfDocument&&(this._ready=!0)}))}}else await this._destroyScripting()}async dispatchWillSave(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillSave"})}async dispatchDidSave(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"DidSave"})}async dispatchWillPrint(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillPrint"})}async dispatchDidPrint(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"DidPrint"})}get mouseState(){return this._mouseState}get destroyPromise(){return this._destroyCapability?.promise||null}get ready(){return this._ready}get _internalEvents(){return(0,s.shadow)(this,"_internalEvents",new Map)}get _domEvents(){return(0,s.shadow)(this,"_domEvents",new Map)}get _pageOpenPending(){return(0,s.shadow)(this,"_pageOpenPending",new Set)}get _visitedPages(){return(0,s.shadow)(this,"_visitedPages",new Map)}async _updateFromSandbox(e){const t=this._pdfViewer.isInPresentationMode||this._pdfViewer.isChangingPresentationMode,{id:i,siblings:s,command:r,value:a}=e;if(!i){switch(r){case"clear":console.clear();break;case"error":console.error(a);break;case"layout":if(t)return;const e=(0,n.apiPageLayoutToViewerModes)(a);this._pdfViewer.spreadMode=e.spreadMode;break;case"page-num":this._pdfViewer.currentPageNumber=a+1;break;case"print":await this._pdfViewer.pagesPromise;this._eventBus.dispatch("print",{source:this});break;case"println":console.log(a);break;case"zoom":if(t)return;this._pdfViewer.currentScaleValue=a;break;case"SaveAs":this._eventBus.dispatch("save",{source:this});break;case"FirstPage":this._pdfViewer.currentPageNumber=1;break;case"LastPage":this._pdfViewer.currentPageNumber=this._pdfViewer.pagesCount;break;case"NextPage":this._pdfViewer.nextPage();break;case"PrevPage":this._pdfViewer.previousPage();break;case"ZoomViewIn":if(t)return;this._pdfViewer.increaseScale();break;case"ZoomViewOut":if(t)return;this._pdfViewer.decreaseScale()}return}if(t&&e.focus)return;delete e.id;delete e.siblings;const o=s?[i,...s]:[i];for(const t of o){const i=document.getElementById(t);i?i.dispatchEvent(new CustomEvent("updatefromsandbox",{detail:e})):this._pdfDocument?.annotationStorage.setValue(t,e)}}async _dispatchPageOpen(e,t=!1){const i=this._pdfDocument,r=this._visitedPages;t&&(this._closeCapability=(0,s.createPromiseCapability)());if(!this._closeCapability)return;const a=this._pdfViewer.getPageView(e-1);if(a?.renderingState!==n.RenderingStates.FINISHED){this._pageOpenPending.add(e);return}this._pageOpenPending.delete(e);const o=(async()=>{const t=await(r.has(e)?null:a.pdfPage?.getJSActions());i===this._pdfDocument&&await(this._scripting?.dispatchEventInSandbox({id:"page",name:"PageOpen",pageNumber:e,actions:t}))})();r.set(e,o)}async _dispatchPageClose(e){const t=this._pdfDocument,i=this._visitedPages;if(!this._closeCapability)return;if(this._pageOpenPending.has(e))return;const n=i.get(e);if(n){i.set(e,null);await n;t===this._pdfDocument&&await(this._scripting?.dispatchEventInSandbox({id:"page",name:"PageClose",pageNumber:e}))}}async _getDocProperties(){if(this._docPropertiesLookup)return this._docPropertiesLookup(this._pdfDocument);throw new Error("_getDocProperties: Unable to lookup properties.")}_createScripting(){this._destroyCapability=(0,s.createPromiseCapability)();if(this._scripting)throw new Error("_createScripting: Scripting already exists.");if(this._scriptingFactory)return this._scriptingFactory.createScripting({sandboxBundleSrc:this._sandboxBundleSrc});throw new Error("_createScripting: Cannot create scripting.")}async _destroyScripting(){if(this._scripting){if(this._closeCapability){await Promise.race([this._closeCapability.promise,new Promise((e=>{setTimeout(e,1e3)}))]).catch((e=>{}));this._closeCapability=null}this._pdfDocument=null;try{await this._scripting.destroySandbox()}catch(e){}for(const[e,t]of this._internalEvents)this._eventBus._off(e,t);this._internalEvents.clear();for(const[e,t]of this._domEvents)window.removeEventListener(e,t);this._domEvents.clear();this._pageOpenPending.clear();this._visitedPages.clear();this._scripting=null;delete this._mouseState.isDown;this._ready=!1;this._destroyCapability?.resolve()}else{this._pdfDocument=null;this._destroyCapability?.resolve()}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFSidebar=void 0;var n=i(3);const s="pdfSidebarNotification";t.PDFSidebar=class PDFSidebar{constructor({elements:e,pdfViewer:t,pdfThumbnailViewer:i,eventBus:s,l10n:r}){this.isOpen=!1;this.active=n.SidebarView.THUMBS;this.isInitialViewSet=!1;this.onToggled=null;this.pdfViewer=t;this.pdfThumbnailViewer=i;this.outerContainer=e.outerContainer;this.viewerContainer=e.viewerContainer;this.toggleButton=e.toggleButton;this.thumbnailButton=e.thumbnailButton;this.outlineButton=e.outlineButton;this.attachmentsButton=e.attachmentsButton;this.layersButton=e.layersButton;this.thumbnailView=e.thumbnailView;this.outlineView=e.outlineView;this.attachmentsView=e.attachmentsView;this.layersView=e.layersView;this._outlineOptionsContainer=e.outlineOptionsContainer;this._currentOutlineItemButton=e.currentOutlineItemButton;this.eventBus=s;this.l10n=r;this._addEventListeners()}reset(){this.isInitialViewSet=!1;this._hideUINotification(!0);this.switchView(n.SidebarView.THUMBS);this.outlineButton.disabled=!1;this.attachmentsButton.disabled=!1;this.layersButton.disabled=!1;this._currentOutlineItemButton.disabled=!0}get visibleView(){return this.isOpen?this.active:n.SidebarView.NONE}get isThumbnailViewVisible(){return this.isOpen&&this.active===n.SidebarView.THUMBS}get isOutlineViewVisible(){return this.isOpen&&this.active===n.SidebarView.OUTLINE}get isAttachmentsViewVisible(){return this.isOpen&&this.active===n.SidebarView.ATTACHMENTS}get isLayersViewVisible(){return this.isOpen&&this.active===n.SidebarView.LAYERS}setInitialView(e=n.SidebarView.NONE){if(!this.isInitialViewSet){this.isInitialViewSet=!0;e!==n.SidebarView.NONE&&e!==n.SidebarView.UNKNOWN&&this._switchView(e,!0)||this._dispatchEvent()}}switchView(e,t=!1){this._switchView(e,t)}_switchView(e,t=!1){const i=e!==this.active;let s=!1;switch(e){case n.SidebarView.NONE:if(this.isOpen){this.close();return!0}return!1;case n.SidebarView.THUMBS:this.isOpen&&i&&(s=!0);break;case n.SidebarView.OUTLINE:if(this.outlineButton.disabled)return!1;break;case n.SidebarView.ATTACHMENTS:if(this.attachmentsButton.disabled)return!1;break;case n.SidebarView.LAYERS:if(this.layersButton.disabled)return!1;break;default:console.error(`PDFSidebar._switchView: "${e}" is not a valid view.`);return!1}this.active=e;this.thumbnailButton.classList.toggle("toggled",e===n.SidebarView.THUMBS);this.outlineButton.classList.toggle("toggled",e===n.SidebarView.OUTLINE);this.attachmentsButton.classList.toggle("toggled",e===n.SidebarView.ATTACHMENTS);this.layersButton.classList.toggle("toggled",e===n.SidebarView.LAYERS);this.thumbnailView.classList.toggle("hidden",e!==n.SidebarView.THUMBS);this.outlineView.classList.toggle("hidden",e!==n.SidebarView.OUTLINE);this.attachmentsView.classList.toggle("hidden",e!==n.SidebarView.ATTACHMENTS);this.layersView.classList.toggle("hidden",e!==n.SidebarView.LAYERS);this._outlineOptionsContainer.classList.toggle("hidden",e!==n.SidebarView.OUTLINE);if(t&&!this.isOpen){this.open();return!0}if(s){this._updateThumbnailViewer();this._forceRendering()}i&&this._dispatchEvent();return i}open(){if(!this.isOpen){this.isOpen=!0;this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.outerContainer.classList.add("sidebarMoving","sidebarOpen");this.active===n.SidebarView.THUMBS&&this._updateThumbnailViewer();this._forceRendering();this._dispatchEvent();this._hideUINotification()}}close(){if(this.isOpen){this.isOpen=!1;this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false");this.outerContainer.classList.add("sidebarMoving");this.outerContainer.classList.remove("sidebarOpen");this._forceRendering();this._dispatchEvent()}}toggle(){this.isOpen?this.close():this.open()}_dispatchEvent(){this.eventBus.dispatch("sidebarviewchanged",{source:this,view:this.visibleView})}_forceRendering(){if(this.onToggled)this.onToggled();else{this.pdfViewer.forceRendering();this.pdfThumbnailViewer.forceRendering()}}_updateThumbnailViewer(){const{pdfViewer:e,pdfThumbnailViewer:t}=this,i=e.pagesCount;for(let s=0;s<i;s++){const i=e.getPageView(s);if(i?.renderingState===n.RenderingStates.FINISHED){t.getThumbnail(s).setImage(i)}}t.scrollThumbnailIntoView(e.currentPageNumber)}_showUINotification(){this.l10n.get("toggle_sidebar_notification2.title").then((e=>{this.toggleButton.title=e}));this.isOpen||this.toggleButton.classList.add(s)}_hideUINotification(e=!1){(this.isOpen||e)&&this.toggleButton.classList.remove(s);e&&this.l10n.get("toggle_sidebar.title").then((e=>{this.toggleButton.title=e}))}_addEventListeners(){this.viewerContainer.addEventListener("transitionend",(e=>{e.target===this.viewerContainer&&this.outerContainer.classList.remove("sidebarMoving")}));this.toggleButton.addEventListener("click",(()=>{this.toggle()}));this.thumbnailButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.THUMBS)}));this.outlineButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.OUTLINE)}));this.outlineButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("toggleoutlinetree",{source:this})}));this.attachmentsButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.ATTACHMENTS)}));this.layersButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.LAYERS)}));this.layersButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("resetlayers",{source:this})}));this._currentOutlineItemButton.addEventListener("click",(()=>{this.eventBus.dispatch("currentoutlineitem",{source:this})}));const onTreeLoaded=(e,t,i)=>{t.disabled=!e;e?this._showUINotification():this.active===i&&this.switchView(n.SidebarView.THUMBS)};this.eventBus._on("outlineloaded",(e=>{onTreeLoaded(e.outlineCount,this.outlineButton,n.SidebarView.OUTLINE);e.currentOutlineItemPromise.then((e=>{this.isInitialViewSet&&(this._currentOutlineItemButton.disabled=!e)}))}));this.eventBus._on("attachmentsloaded",(e=>{onTreeLoaded(e.attachmentsCount,this.attachmentsButton,n.SidebarView.ATTACHMENTS)}));this.eventBus._on("layersloaded",(e=>{onTreeLoaded(e.layersCount,this.layersButton,n.SidebarView.LAYERS)}));this.eventBus._on("presentationmodechanged",(e=>{e.state===n.PresentationModeState.NORMAL&&this.isThumbnailViewVisible&&this._updateThumbnailViewer()}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFSidebarResizer=void 0;const i="sidebarResizing";t.PDFSidebarResizer=class PDFSidebarResizer{constructor(e,t,i){this.isRTL=!1;this.sidebarOpen=!1;this.doc=document.documentElement;this._width=null;this._outerContainerWidth=null;this._boundEvents=Object.create(null);this.outerContainer=e.outerContainer;this.resizer=e.resizer;this.eventBus=t;i.getDirection().then((e=>{this.isRTL="rtl"===e}));this._addEventListeners()}get outerContainerWidth(){return this._outerContainerWidth||=this.outerContainer.clientWidth}_updateWidth(e=0){const t=Math.floor(this.outerContainerWidth/2);e>t&&(e=t);e<200&&(e=200);if(e===this._width)return!1;this._width=e;this.doc.style.setProperty("--sidebar-width",`${e}px`);return!0}_mouseMove(e){let t=e.clientX;this.isRTL&&(t=this.outerContainerWidth-t);this._updateWidth(t)}_mouseUp(e){this.outerContainer.classList.remove(i);this.eventBus.dispatch("resize",{source:this});const t=this._boundEvents;window.removeEventListener("mousemove",t.mouseMove);window.removeEventListener("mouseup",t.mouseUp)}_addEventListeners(){const e=this._boundEvents;e.mouseMove=this._mouseMove.bind(this);e.mouseUp=this._mouseUp.bind(this);this.resizer.addEventListener("mousedown",(t=>{if(0===t.button){this.outerContainer.classList.add(i);window.addEventListener("mousemove",e.mouseMove);window.addEventListener("mouseup",e.mouseUp)}}));this.eventBus._on("sidebarviewchanged",(e=>{this.sidebarOpen=!!e?.view}));this.eventBus._on("resize",(e=>{if(e?.source!==window)return;this._outerContainerWidth=null;if(!this._width)return;if(!this.sidebarOpen){this._updateWidth(this._width);return}this.outerContainer.classList.add(i);const t=this._updateWidth(this._width);Promise.resolve().then((()=>{this.outerContainer.classList.remove(i);t&&this.eventBus.dispatch("resize",{source:this})}))}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFThumbnailViewer=void 0;var n=i(3),s=i(26);const r="selected";t.PDFThumbnailViewer=class PDFThumbnailViewer{constructor({container:e,eventBus:t,linkService:i,renderingQueue:s,l10n:r}){this.container=e;this.linkService=i;this.renderingQueue=s;this.l10n=r;this.scroll=(0,n.watchScroll)(this.container,this._scrollUpdated.bind(this));this._resetView();t._on("optionalcontentconfigchanged",(()=>{this._setImageDisabled=!0}))}_scrollUpdated(){this.renderingQueue.renderHighestPriority()}getThumbnail(e){return this._thumbnails[e]}_getVisibleThumbs(){return(0,n.getVisibleElements)({scrollEl:this.container,views:this._thumbnails})}scrollThumbnailIntoView(e){if(!this.pdfDocument)return;const t=this._thumbnails[e-1];if(!t){console.error('scrollThumbnailIntoView: Invalid "pageNumber" parameter.');return}if(e!==this._currentPageNumber){this._thumbnails[this._currentPageNumber-1].div.classList.remove(r);t.div.classList.add(r)}const{first:i,last:s,views:a}=this._getVisibleThumbs();if(a.length>0){let r=!1;if(e<=i.id||e>=s.id)r=!0;else for(const{id:t,percent:i}of a)if(t===e){r=i<100;break}r&&(0,n.scrollIntoView)(t.div,{top:-19})}this._currentPageNumber=e}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,n.isValidRotation)(e))throw new Error("Invalid thumbnails rotation angle.");if(!this.pdfDocument)return;if(this._pagesRotation===e)return;this._pagesRotation=e;const t={rotation:e};for(const e of this._thumbnails)e.update(t)}cleanup(){for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e]&&this._thumbnails[e].renderingState!==n.RenderingStates.FINISHED&&this._thumbnails[e].reset();s.TempImageFactory.destroyCanvas()}_resetView(){this._thumbnails=[];this._currentPageNumber=1;this._pageLabels=null;this._pagesRotation=0;this._optionalContentConfigPromise=null;this._setImageDisabled=!1;this.container.textContent=""}setDocument(e){if(this.pdfDocument){this._cancelRendering();this._resetView()}this.pdfDocument=e;if(!e)return;const t=e.getPage(1),i=e.getOptionalContentConfig();t.then((t=>{this._optionalContentConfigPromise=i;const n=e.numPages,a=t.getViewport({scale:1}),checkSetImageDisabled=()=>this._setImageDisabled;for(let e=1;e<=n;++e){const t=new s.PDFThumbnailView({container:this.container,id:e,defaultViewport:a.clone(),optionalContentConfigPromise:i,linkService:this.linkService,renderingQueue:this.renderingQueue,checkSetImageDisabled:checkSetImageDisabled,l10n:this.l10n});this._thumbnails.push(t)}const o=this._thumbnails[0];o&&o.setPdfPage(t);this._thumbnails[this._currentPageNumber-1].div.classList.add(r)})).catch((e=>{console.error("Unable to initialize thumbnail viewer",e)}))}_cancelRendering(){for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e]&&this._thumbnails[e].cancelRendering()}setPageLabels(e){if(this.pdfDocument){if(e)if(Array.isArray(e)&&this.pdfDocument.numPages===e.length)this._pageLabels=e;else{this._pageLabels=null;console.error("PDFThumbnailViewer_setPageLabels: Invalid page labels.")}else this._pageLabels=null;for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e].setPageLabel(this._pageLabels?.[e]??null)}}async#h(e){if(e.pdfPage)return e.pdfPage;try{const t=await this.pdfDocument.getPage(e.id);e.pdfPage||e.setPdfPage(t);return t}catch(e){console.error("Unable to get page for thumb view",e);return null}}#d(e){return 1===e.first?.id||e.last?.id!==this._thumbnails.length&&this.scroll.down}forceRendering(){const e=this._getVisibleThumbs(),t=this.#d(e),i=this.renderingQueue.getHighestPriority(e,this._thumbnails,t);if(i){this.#h(i).then((()=>{this.renderingQueue.renderView(i)}));return!0}return!1}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TempImageFactory=t.PDFThumbnailView=void 0;var n=i(3),s=i(5);class TempImageFactory{static#u=null;static getCanvas(e,t){const i=this.#u||=document.createElement("canvas");i.width=e;i.height=t;i.mozOpaque=!0;const n=i.getContext("2d",{alpha:!1});n.save();n.fillStyle="rgb(255, 255, 255)";n.fillRect(0,0,e,t);n.restore();return[i,i.getContext("2d")]}static destroyCanvas(){const e=this.#u;if(e){e.width=0;e.height=0}this.#u=null}}t.TempImageFactory=TempImageFactory;t.PDFThumbnailView=class PDFThumbnailView{constructor({container:e,id:t,defaultViewport:i,optionalContentConfigPromise:s,linkService:r,renderingQueue:a,checkSetImageDisabled:o,l10n:l}){this.id=t;this.renderingId="thumbnail"+t;this.pageLabel=null;this.pdfPage=null;this.rotation=0;this.viewport=i;this.pdfPageRotate=i.rotation;this._optionalContentConfigPromise=s||null;this.linkService=r;this.renderingQueue=a;this.renderTask=null;this.renderingState=n.RenderingStates.INITIAL;this.resume=null;this._checkSetImageDisabled=o||function(){return!1};const c=this.viewport.width,h=c/this.viewport.height;this.canvasWidth=98;this.canvasHeight=this.canvasWidth/h|0;this.scale=this.canvasWidth/c;this.l10n=l;const d=document.createElement("a");d.href=r.getAnchorUrl("#page="+t);this._thumbPageTitle.then((e=>{d.title=e}));d.onclick=function(){r.goToPage(t);return!1};this.anchor=d;const u=document.createElement("div");u.className="thumbnail";u.setAttribute("data-page-number",this.id);this.div=u;const p=document.createElement("div");p.className="thumbnailSelectionRing";p.style.width=this.canvasWidth+2+"px";p.style.height=this.canvasHeight+2+"px";this.ring=p;u.appendChild(p);d.appendChild(u);e.appendChild(d)}setPdfPage(e){this.pdfPage=e;this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:1,rotation:t});this.reset()}reset(){this.cancelRendering();this.renderingState=n.RenderingStates.INITIAL;const e=this.viewport.width,t=e/this.viewport.height;this.canvasHeight=this.canvasWidth/t|0;this.scale=this.canvasWidth/e;this.div.removeAttribute("data-loaded");const i=this.ring;i.textContent="";i.style.width=this.canvasWidth+2+"px";i.style.height=this.canvasHeight+2+"px";if(this.canvas){this.canvas.width=0;this.canvas.height=0;delete this.canvas}if(this.image){this.image.removeAttribute("src");delete this.image}}update({rotation:e=null}){"number"==typeof e&&(this.rotation=e);const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=this.viewport.clone({scale:1,rotation:t});this.reset()}cancelRendering(){if(this.renderTask){this.renderTask.cancel();this.renderTask=null}this.resume=null}_getPageDrawContext(e=1){const t=document.createElement("canvas");t.mozOpaque=!0;const i=t.getContext("2d",{alpha:!1}),s=(0,n.getOutputScale)(i);t.width=e*this.canvasWidth*s.sx|0;t.height=e*this.canvasHeight*s.sy|0;return{ctx:i,canvas:t,transform:s.scaled?[s.sx,0,0,s.sy,0,0]:null}}_convertCanvasToImage(e){if(this.renderingState!==n.RenderingStates.FINISHED)throw new Error("_convertCanvasToImage: Rendering has not finished.");const t=this._reduceImage(e),i=document.createElement("img");i.className="thumbnailImage";this._thumbPageCanvas.then((e=>{i.setAttribute("aria-label",e)}));i.style.width=this.canvasWidth+"px";i.style.height=this.canvasHeight+"px";i.src=t.toDataURL();this.image=i;this.div.setAttribute("data-loaded",!0);this.ring.appendChild(i);t.width=0;t.height=0}draw(){if(this.renderingState!==n.RenderingStates.INITIAL){console.error("Must be in new state before drawing");return Promise.resolve()}const{pdfPage:e}=this;if(!e){this.renderingState=n.RenderingStates.FINISHED;return Promise.reject(new Error("pdfPage is not loaded"))}this.renderingState=n.RenderingStates.RUNNING;const finishRenderTask=async(e=null)=>{o===this.renderTask&&(this.renderTask=null);if(!(e instanceof s.RenderingCancelledException)){this.renderingState=n.RenderingStates.FINISHED;this._convertCanvasToImage(i);if(e)throw e}},{ctx:t,canvas:i,transform:r}=this._getPageDrawContext(2),a={canvasContext:t,transform:r,viewport:this.viewport.clone({scale:2*this.scale}),optionalContentConfigPromise:this._optionalContentConfigPromise},o=this.renderTask=e.render(a);o.onContinue=e=>{if(this.renderingQueue.isHighestPriority(this))e();else{this.renderingState=n.RenderingStates.PAUSED;this.resume=()=>{this.renderingState=n.RenderingStates.RUNNING;e()}}};const l=o.promise.then((function(){return finishRenderTask(null)}),(function(e){return finishRenderTask(e)}));l.finally((()=>{i.width=0;i.height=0;this.linkService.isPageCached(this.id)||this.pdfPage?.cleanup()}));return l}setImage(e){if(this._checkSetImageDisabled())return;if(this.renderingState!==n.RenderingStates.INITIAL)return;const{canvas:t,pdfPage:i}=e;if(t){this.pdfPage||this.setPdfPage(i);this.renderingState=n.RenderingStates.FINISHED;this._convertCanvasToImage(t)}}_reduceImage(e){const{ctx:t,canvas:i}=this._getPageDrawContext();if(e.width<=2*i.width){t.drawImage(e,0,0,e.width,e.height,0,0,i.width,i.height);return i}let n=i.width<<3,s=i.height<<3;const[r,a]=TempImageFactory.getCanvas(n,s);for(;n>e.width||s>e.height;){n>>=1;s>>=1}a.drawImage(e,0,0,e.width,e.height,0,0,n,s);for(;n>2*i.width;){a.drawImage(r,0,0,n,s,0,0,n>>1,s>>1);n>>=1;s>>=1}t.drawImage(r,0,0,n,s,0,0,i.width,i.height);return i}get _thumbPageTitle(){return this.l10n.get("thumb_page_title",{page:this.pageLabel??this.id})}get _thumbPageCanvas(){return this.l10n.get("thumb_page_canvas",{page:this.pageLabel??this.id})}setPageLabel(e){this.pageLabel="string"==typeof e?e:null;this._thumbPageTitle.then((e=>{this.anchor.title=e}));this.renderingState===n.RenderingStates.FINISHED&&this._thumbPageCanvas.then((e=>{this.image?.setAttribute("aria-label",e)}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFViewer=t.PDFSinglePageViewer=void 0;var n=i(3),s=i(28);class PDFViewer extends s.BaseViewer{}t.PDFViewer=PDFViewer;class PDFSinglePageViewer extends s.BaseViewer{_resetView(){super._resetView();this._scrollMode=n.ScrollMode.PAGE;this._spreadMode=n.SpreadMode.NONE}set scrollMode(e){}_updateScrollMode(){}set spreadMode(e){}_updateSpreadMode(){}}t.PDFSinglePageViewer=PDFSinglePageViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PagesCountLimit=t.PDFPageViewBuffer=t.BaseViewer=void 0;var n=i(5),s=i(3),r=i(29),a=i(30),o=i(31),l=i(21),c=i(18),h=i(32),d=i(33),u=i(34),p=i(35);const g="enablePermissions",f={FORCE_SCROLL_MODE_PAGE:15e3,FORCE_LAZY_PAGE_INIT:7500,PAUSE_EAGER_PAGE_INIT:500};t.PagesCountLimit=f;class PDFPageViewBuffer{#p=new Set;#g=0;constructor(e){this.#g=e}push(e){const t=this.#p;t.has(e)&&t.delete(e);t.add(e);t.size>this.#g&&this.#f()}resize(e,t=null){this.#g=e;const i=this.#p;if(t){const e=i.size;let n=1;for(const s of i){if(t.has(s.id)){i.delete(s);i.add(s)}if(++n>e)break}}for(;i.size>this.#g;)this.#f()}has(e){return this.#p.has(e)}[Symbol.iterator](){return this.#p.keys()}#f(){const e=this.#p.keys().next().value;e?.destroy();this.#p.delete(e)}}t.PDFPageViewBuffer=PDFPageViewBuffer;class BaseViewer{#m=null;#_=n.AnnotationMode.ENABLE_FORMS;#b=null;#v=!1;#w=0;#y=null;constructor(e){if(this.constructor===BaseViewer)throw new Error("Cannot initialize BaseViewer.");const t="2.12.313";if(n.version!==t)throw new Error(`The API version "${n.version}" does not match the Viewer version "2.12.313".`);this.container=e.container;this.viewer=e.viewer||e.container.firstElementChild;if("DIV"!==this.container?.tagName.toUpperCase()||"DIV"!==this.viewer?.tagName.toUpperCase())throw new Error("Invalid `container` and/or `viewer` option.");if(this.container.offsetParent&&"absolute"!==getComputedStyle(this.container).position)throw new Error("The `container` must be absolutely positioned.");this.eventBus=e.eventBus;this.linkService=e.linkService||new c.SimpleLinkService;this.downloadManager=e.downloadManager||null;this.findController=e.findController||null;this._scriptingManager=e.scriptingManager||null;this.removePageBorders=e.removePageBorders||!1;this.textLayerMode=e.textLayerMode??s.TextLayerMode.ENABLE;this.#_=e.annotationMode??n.AnnotationMode.ENABLE_FORMS;this.imageResourcesPath=e.imageResourcesPath||"";this.enablePrintAutoRotate=e.enablePrintAutoRotate||!1;this.renderer=e.renderer||s.RendererType.CANVAS;this.useOnlyCssZoom=e.useOnlyCssZoom||!1;this.maxCanvasPixels=e.maxCanvasPixels;this.l10n=e.l10n||a.NullL10n;this.#v=e.enablePermissions||!1;this.defaultRenderingQueue=!e.renderingQueue;if(this.defaultRenderingQueue){this.renderingQueue=new l.PDFRenderingQueue;this.renderingQueue.setViewer(this)}else this.renderingQueue=e.renderingQueue;this._doc=document.documentElement;this.scroll=(0,s.watchScroll)(this.container,this._scrollUpdate.bind(this));this.presentationModeState=s.PresentationModeState.UNKNOWN;this._onBeforeDraw=this._onAfterDraw=null;this._resetView();this.removePageBorders&&this.viewer.classList.add("removePageBorders");Promise.resolve().then((()=>{this.eventBus.dispatch("baseviewerinit",{source:this})}))}get pagesCount(){return this._pages.length}getPageView(e){return this._pages[e]}get pageViewsReady(){return!!this._pagesCapability.settled&&this._pages.every((function(e){return e?.pdfPage}))}get renderForms(){return this.#_===n.AnnotationMode.ENABLE_FORMS}get enableScripting(){return!!this._scriptingManager}get currentPageNumber(){return this._currentPageNumber}set currentPageNumber(e){if(!Number.isInteger(e))throw new Error("Invalid page number.");this.pdfDocument&&(this._setCurrentPageNumber(e,!0)||console.error(`currentPageNumber: "${e}" is not a valid page.`))}_setCurrentPageNumber(e,t=!1){if(this._currentPageNumber===e){t&&this._resetCurrentPageView();return!0}if(!(0<e&&e<=this.pagesCount))return!1;const i=this._currentPageNumber;this._currentPageNumber=e;this.eventBus.dispatch("pagechanging",{source:this,pageNumber:e,pageLabel:this._pageLabels?.[e-1]??null,previous:i});t&&this._resetCurrentPageView();return!0}get currentPageLabel(){return this._pageLabels?.[this._currentPageNumber-1]??null}set currentPageLabel(e){if(!this.pdfDocument)return;let t=0|e;if(this._pageLabels){const i=this._pageLabels.indexOf(e);i>=0&&(t=i+1)}this._setCurrentPageNumber(t,!0)||console.error(`currentPageLabel: "${e}" is not a valid page.`)}get currentScale(){return this._currentScale!==s.UNKNOWN_SCALE?this._currentScale:s.DEFAULT_SCALE}set currentScale(e){if(isNaN(e))throw new Error("Invalid numeric scale.");this.pdfDocument&&this._setScale(e,!1)}get currentScaleValue(){return this._currentScaleValue}set currentScaleValue(e){this.pdfDocument&&this._setScale(e,!1)}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,s.isValidRotation)(e))throw new Error("Invalid pages rotation angle.");if(!this.pdfDocument)return;(e%=360)<0&&(e+=360);if(this._pagesRotation===e)return;this._pagesRotation=e;const t=this._currentPageNumber,i={rotation:e};for(const e of this._pages)e.update(i);this._currentScaleValue&&this._setScale(this._currentScaleValue,!0);this.eventBus.dispatch("rotationchanging",{source:this,pagesRotation:e,pageNumber:t});this.defaultRenderingQueue&&this.update()}get firstPagePromise(){return this.pdfDocument?this._firstPageCapability.promise:null}get onePageRendered(){return this.pdfDocument?this._onePageRenderedCapability.promise:null}get pagesPromise(){return this.pdfDocument?this._pagesCapability.promise:null}#S(e){if(e){e.includes(n.PermissionFlag.COPY)||this.viewer.classList.add(g);if(!e.includes(n.PermissionFlag.MODIFY_ANNOTATIONS)&&!e.includes(n.PermissionFlag.FILL_INTERACTIVE_FORMS)&&this.#_===n.AnnotationMode.ENABLE_FORMS){this.#b=this.#_;this.#_=n.AnnotationMode.ENABLE}}}#P(){return this.container.offsetParent&&0!==this._getVisiblePages().views.length?this._onePageRenderedCapability.promise:Promise.resolve()}setDocument(e){if(this.pdfDocument){this.eventBus.dispatch("pagesdestroy",{source:this});this._cancelRendering();this._resetView();this.findController&&this.findController.setDocument(null);this._scriptingManager&&this._scriptingManager.setDocument(null)}this.pdfDocument=e;if(!e)return;const t=e.isPureXfa,i=e.numPages,r=e.getPage(1),a=e.getOptionalContentConfig(),l=this.#v?e.getPermissions():Promise.resolve();if(i>f.FORCE_SCROLL_MODE_PAGE){console.warn("Forcing PAGE-scrolling for performance reasons, given the length of the document.");const e=this._scrollMode=s.ScrollMode.PAGE;this.eventBus.dispatch("scrollmodechanged",{source:this,mode:e})}this._pagesCapability.promise.then((()=>{this.eventBus.dispatch("pagesloaded",{source:this,pagesCount:i})}),(()=>{}));this._onBeforeDraw=e=>{const t=this._pages[e.pageNumber-1];t&&this.#m.push(t)};this.eventBus._on("pagerender",this._onBeforeDraw);this._onAfterDraw=e=>{if(!e.cssTransform&&!this._onePageRenderedCapability.settled){this._onePageRenderedCapability.resolve({timestamp:e.timestamp});this.eventBus._off("pagerendered",this._onAfterDraw);this._onAfterDraw=null}};this.eventBus._on("pagerendered",this._onAfterDraw);Promise.all([r,l]).then((([r,l])=>{if(e!==this.pdfDocument)return;this._firstPageCapability.resolve(r);this._optionalContentConfigPromise=a;this.#S(l);const c=this._scrollMode===s.ScrollMode.PAGE?null:this.viewer,h=this.currentScale,d=r.getViewport({scale:h*n.PixelsPerInch.PDF_TO_CSS_UNITS}),u=this.textLayerMode===s.TextLayerMode.DISABLE||t?null:this,p=this.#_!==n.AnnotationMode.DISABLE?this:null,g=t?this:null;for(let e=1;e<=i;++e){const t=new o.PDFPageView({container:c,eventBus:this.eventBus,id:e,scale:h,defaultViewport:d.clone(),optionalContentConfigPromise:a,renderingQueue:this.renderingQueue,textLayerFactory:u,textLayerMode:this.textLayerMode,annotationLayerFactory:p,annotationMode:this.#_,xfaLayerFactory:g,textHighlighterFactory:this,structTreeLayerFactory:this,imageResourcesPath:this.imageResourcesPath,renderer:this.renderer,useOnlyCssZoom:this.useOnlyCssZoom,maxCanvasPixels:this.maxCanvasPixels,l10n:this.l10n});this._pages.push(t)}const m=this._pages[0];if(m){m.setPdfPage(r);this.linkService.cachePageRef(1,r.ref)}this._scrollMode===s.ScrollMode.PAGE?this.#A():this._spreadMode!==s.SpreadMode.NONE&&this._updateSpreadMode();this.#P().then((async()=>{this.findController&&this.findController.setDocument(e);this._scriptingManager&&this._scriptingManager.setDocument(e);if(e.loadingParams.disableAutoFetch||i>f.FORCE_LAZY_PAGE_INIT){this._pagesCapability.resolve();return}let t=i-1;if(t<=0)this._pagesCapability.resolve();else for(let n=2;n<=i;++n){const i=e.getPage(n).then((e=>{const i=this._pages[n-1];i.pdfPage||i.setPdfPage(e);this.linkService.cachePageRef(n,e.ref);0==--t&&this._pagesCapability.resolve()}),(e=>{console.error(`Unable to get page ${n} to initialize viewer`,e);0==--t&&this._pagesCapability.resolve()}));n%f.PAUSE_EAGER_PAGE_INIT==0&&await i}}));this.eventBus.dispatch("pagesinit",{source:this});e.getMetadata().then((({info:t})=>{e===this.pdfDocument&&t.Language&&(this.viewer.lang=t.Language)}));this.defaultRenderingQueue&&this.update()})).catch((e=>{console.error("Unable to initialize viewer",e);this._pagesCapability.reject(e)}))}setPageLabels(e){if(this.pdfDocument){if(e)if(Array.isArray(e)&&this.pdfDocument.numPages===e.length)this._pageLabels=e;else{this._pageLabels=null;console.error("setPageLabels: Invalid page labels.")}else this._pageLabels=null;for(let e=0,t=this._pages.length;e<t;e++)this._pages[e].setPageLabel(this._pageLabels?.[e]??null)}}_resetView(){this._pages=[];this._currentPageNumber=1;this._currentScale=s.UNKNOWN_SCALE;this._currentScaleValue=null;this._pageLabels=null;this.#m=new PDFPageViewBuffer(10);this._location=null;this._pagesRotation=0;this._optionalContentConfigPromise=null;this._firstPageCapability=(0,n.createPromiseCapability)();this._onePageRenderedCapability=(0,n.createPromiseCapability)();this._pagesCapability=(0,n.createPromiseCapability)();this._scrollMode=s.ScrollMode.VERTICAL;this._previousScrollMode=s.ScrollMode.UNKNOWN;this._spreadMode=s.SpreadMode.NONE;this.#y={previousPageNumber:1,scrollDown:!0,pages:[]};if(this._onBeforeDraw){this.eventBus._off("pagerender",this._onBeforeDraw);this._onBeforeDraw=null}if(this._onAfterDraw){this.eventBus._off("pagerendered",this._onAfterDraw);this._onAfterDraw=null}this.viewer.textContent="";this._updateScrollMode();this.viewer.removeAttribute("lang");this.viewer.classList.remove(g);if(null!==this.#b){this.#_=this.#b;this.#b=null}}#A(){if(this._scrollMode!==s.ScrollMode.PAGE)throw new Error("#ensurePageViewVisible: Invalid scrollMode value.");const e=this._currentPageNumber,t=this.#y,i=this.viewer;i.textContent="";t.pages.length=0;if(this._spreadMode===s.SpreadMode.NONE){const n=this._pages[e-1];if(this.isInPresentationMode){const e=document.createElement("div");e.className="spread";const t=document.createElement("div");t.className="dummyPage";t.style.height=`${this.container.clientHeight}px`;e.appendChild(t);e.appendChild(n.div);i.appendChild(e)}else i.appendChild(n.div);t.pages.push(n)}else{const n=new Set,s=this._spreadMode-1;if(e%2!==s){n.add(e-1);n.add(e)}else{n.add(e-2);n.add(e-1)}let r=null;for(const e of n){const n=this._pages[e];if(n){if(null===r){r=document.createElement("div");r.className="spread";i.appendChild(r)}else if(e%2===s){r=r.cloneNode(!1);i.appendChild(r)}r.appendChild(n.div);t.pages.push(n)}}}t.scrollDown=e>=t.previousPageNumber;t.previousPageNumber=e}_scrollUpdate(){0!==this.pagesCount&&this.update()}_scrollIntoView({pageDiv:e,pageSpot:t=null,pageNumber:i=null}){if(this._scrollMode===s.ScrollMode.PAGE){i&&this._setCurrentPageNumber(i);this.#A();this.update()}if(!t&&!this.isInPresentationMode){const i=e.offsetLeft+e.clientLeft,n=i+e.clientWidth,{scrollLeft:r,clientWidth:a}=this.container;(this._scrollMode===s.ScrollMode.HORIZONTAL||i<r||n>r+a)&&(t={left:0,top:0})}(0,s.scrollIntoView)(e,t)}#C(e){return(!this.isInPresentationMode||this.container.clientHeight===this.#w)&&(e===this._currentScale||Math.abs(e-this._currentScale)<1e-15)}_setScaleUpdatePages(e,t,i=!1,s=!1){this._currentScaleValue=t.toString();if(this.#C(e)){s&&this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:t});return}this._doc.style.setProperty("--zoom-factor",e);this._doc.style.setProperty("--viewport-scale-factor",e*n.PixelsPerInch.PDF_TO_CSS_UNITS);const r={scale:e};for(const e of this._pages)e.update(r);this._currentScale=e;if(!i){let e,t=this._currentPageNumber;if(this._location&&!this.isInPresentationMode&&!this.isChangingPresentationMode){t=this._location.pageNumber;e=[null,{name:"XYZ"},this._location.left,this._location.top,null]}this.scrollPageIntoView({pageNumber:t,destArray:e,allowNegativeOffset:!0})}this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:s?t:void 0});this.defaultRenderingQueue&&this.update();this.#w=this.container.clientHeight}get _pageWidthScaleFactor(){return this._spreadMode!==s.SpreadMode.NONE&&this._scrollMode!==s.ScrollMode.HORIZONTAL?2:1}_setScale(e,t=!1){let i=parseFloat(e);if(i>0)this._setScaleUpdatePages(i,e,t,!1);else{const n=this._pages[this._currentPageNumber-1];if(!n)return;let r=s.SCROLLBAR_PADDING,a=s.VERTICAL_PADDING;this.isInPresentationMode?r=a=4:this.removePageBorders&&(r=a=0);this._scrollMode===s.ScrollMode.HORIZONTAL&&([r,a]=[a,r]);const o=(this.container.clientWidth-r)/n.width*n.scale/this._pageWidthScaleFactor,l=(this.container.clientHeight-a)/n.height*n.scale;switch(e){case"page-actual":i=1;break;case"page-width":i=o;break;case"page-height":i=l;break;case"page-fit":i=Math.min(o,l);break;case"auto":const t=(0,s.isPortraitOrientation)(n)?o:Math.min(l,o);i=Math.min(s.MAX_AUTO_SCALE,t);break;default:console.error(`_setScale: "${e}" is an unknown zoom value.`);return}this._setScaleUpdatePages(i,e,t,!0)}}_resetCurrentPageView(){this.isInPresentationMode&&this._setScale(this._currentScaleValue,!0);const e=this._pages[this._currentPageNumber-1];this._scrollIntoView({pageDiv:e.div})}pageLabelToPageNumber(e){if(!this._pageLabels)return null;const t=this._pageLabels.indexOf(e);return t<0?null:t+1}scrollPageIntoView({pageNumber:e,destArray:t=null,allowNegativeOffset:i=!1,ignoreDestinationZoom:r=!1}){if(!this.pdfDocument)return;const a=Number.isInteger(e)&&this._pages[e-1];if(!a){console.error(`scrollPageIntoView: "${e}" is not a valid pageNumber parameter.`);return}if(this.isInPresentationMode||!t){this._setCurrentPageNumber(e,!0);return}let o,l,c=0,h=0,d=0,u=0;const p=a.rotation%180!=0,g=(p?a.height:a.width)/a.scale/n.PixelsPerInch.PDF_TO_CSS_UNITS,f=(p?a.width:a.height)/a.scale/n.PixelsPerInch.PDF_TO_CSS_UNITS;let m=0;switch(t[1].name){case"XYZ":c=t[2];h=t[3];m=t[4];c=null!==c?c:0;h=null!==h?h:f;break;case"Fit":case"FitB":m="page-fit";break;case"FitH":case"FitBH":h=t[2];m="page-width";if(null===h&&this._location){c=this._location.left;h=this._location.top}else("number"!=typeof h||h<0)&&(h=f);break;case"FitV":case"FitBV":c=t[2];d=g;u=f;m="page-height";break;case"FitR":c=t[2];h=t[3];d=t[4]-c;u=t[5]-h;const e=this.removePageBorders?0:s.SCROLLBAR_PADDING,i=this.removePageBorders?0:s.VERTICAL_PADDING;o=(this.container.clientWidth-e)/d/n.PixelsPerInch.PDF_TO_CSS_UNITS;l=(this.container.clientHeight-i)/u/n.PixelsPerInch.PDF_TO_CSS_UNITS;m=Math.min(Math.abs(o),Math.abs(l));break;default:console.error(`scrollPageIntoView: "${t[1].name}" is not a valid destination type.`);return}r||(m&&m!==this._currentScale?this.currentScaleValue=m:this._currentScale===s.UNKNOWN_SCALE&&(this.currentScaleValue=s.DEFAULT_SCALE_VALUE));if("page-fit"===m&&!t[4]){this._scrollIntoView({pageDiv:a.div,pageNumber:e});return}const _=[a.viewport.convertToViewportPoint(c,h),a.viewport.convertToViewportPoint(c+d,h+u)];let b=Math.min(_[0][0],_[1][0]),v=Math.min(_[0][1],_[1][1]);if(!i){b=Math.max(b,0);v=Math.max(v,0)}this._scrollIntoView({pageDiv:a.div,pageSpot:{left:b,top:v},pageNumber:e})}_updateLocation(e){const t=this._currentScale,i=this._currentScaleValue,n=parseFloat(i)===t?Math.round(1e4*t)/100:i,s=e.id;let r="#page="+s;r+="&zoom="+n;const a=this._pages[s-1],o=this.container,l=a.getPagePoint(o.scrollLeft-e.x,o.scrollTop-e.y),c=Math.round(l[0]),h=Math.round(l[1]);r+=","+c+","+h;this._location={pageNumber:s,scale:n,top:h,left:c,rotation:this._pagesRotation,pdfOpenParams:r}}update(){const e=this._getVisiblePages(),t=e.views,i=t.length;if(0===i)return;const n=Math.max(10,2*i+1);this.#m.resize(n,e.ids);this.renderingQueue.renderHighestPriority(e);if(!this.isInPresentationMode){const e=this._spreadMode===s.SpreadMode.NONE&&(this._scrollMode===s.ScrollMode.PAGE||this._scrollMode===s.ScrollMode.VERTICAL);let i=this._currentPageNumber,n=!1;for(const s of t){if(s.percent<100)break;if(s.id===i&&e){n=!0;break}}n||(i=t[0].id);this._setCurrentPageNumber(i)}this._updateLocation(e.first);this.eventBus.dispatch("updateviewarea",{source:this,location:this._location})}containsElement(e){return this.container.contains(e)}focus(){this.container.focus()}get _isContainerRtl(){return"rtl"===getComputedStyle(this.container).direction}get isInPresentationMode(){return this.presentationModeState===s.PresentationModeState.FULLSCREEN}get isChangingPresentationMode(){return this.presentationModeState===s.PresentationModeState.CHANGING}get isHorizontalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollWidth>this.container.clientWidth}get isVerticalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollHeight>this.container.clientHeight}_getCurrentVisiblePage(){if(!this.pagesCount)return{views:[]};const e=this._pages[this._currentPageNumber-1],t=e.div,i={id:e.id,x:t.offsetLeft+t.clientLeft,y:t.offsetTop+t.clientTop,view:e};return{first:i,last:i,views:[i],ids:new Set([e.id])}}_getVisiblePages(){if(this.isInPresentationMode)return this._getCurrentVisiblePage();const e=this._scrollMode===s.ScrollMode.PAGE?this.#y.pages:this._pages,t=this._scrollMode===s.ScrollMode.HORIZONTAL,i=t&&this._isContainerRtl;return(0,s.getVisibleElements)({scrollEl:this.container,views:e,sortByVisibility:!0,horizontal:t,rtl:i})}isPageVisible(e){if(!this.pdfDocument)return!1;if(!(Number.isInteger(e)&&e>0&&e<=this.pagesCount)){console.error(`isPageVisible: "${e}" is not a valid page.`);return!1}return this._getVisiblePages().ids.has(e)}isPageCached(e){if(!this.pdfDocument)return!1;if(!(Number.isInteger(e)&&e>0&&e<=this.pagesCount)){console.error(`isPageCached: "${e}" is not a valid page.`);return!1}const t=this._pages[e-1];return this.#m.has(t)}cleanup(){for(let e=0,t=this._pages.length;e<t;e++)this._pages[e]&&this._pages[e].renderingState!==s.RenderingStates.FINISHED&&this._pages[e].reset()}_cancelRendering(){for(let e=0,t=this._pages.length;e<t;e++)this._pages[e]&&this._pages[e].cancelRendering()}async#h(e){if(e.pdfPage)return e.pdfPage;try{const t=await this.pdfDocument.getPage(e.id);e.pdfPage||e.setPdfPage(t);this.linkService._cachedPageNumber(t.ref)||this.linkService.cachePageRef(e.id,t.ref);return t}catch(e){console.error("Unable to get page for page view",e);return null}}#d(e){if(1===e.first?.id)return!0;if(e.last?.id===this.pagesCount)return!1;switch(this._scrollMode){case s.ScrollMode.PAGE:return this.#y.scrollDown;case s.ScrollMode.HORIZONTAL:return this.scroll.right}return this.scroll.down}#x(e){for(const t of e){this._pages[t-1]?.toggleLoadingIconSpinner(!0)}for(const t of this.#m)e.has(t.id)||t.toggleLoadingIconSpinner(!1)}forceRendering(e){const t=e||this._getVisiblePages(),i=this.#d(t),n=this._spreadMode!==s.SpreadMode.NONE&&this._scrollMode!==s.ScrollMode.HORIZONTAL,r=this.renderingQueue.getHighestPriority(t,this._pages,i,n);this.#x(t.ids);if(r){this.#h(r).then((()=>{this.renderingQueue.renderView(r)}));return!0}return!1}createTextLayerBuilder(e,t,i,n=!1,s,r){return new u.TextLayerBuilder({textLayerDiv:e,eventBus:s,pageIndex:t,viewport:i,enhanceTextSelection:!this.isInPresentationMode&&n,highlighter:r})}createTextHighlighter(e,t){return new d.TextHighlighter({eventBus:t,pageIndex:e,findController:this.isInPresentationMode?null:this.findController})}createAnnotationLayerBuilder(e,t,i=null,n="",s=!0,o=a.NullL10n,l=null,c=null,h=null,d=null,u=null){return new r.AnnotationLayerBuilder({pageDiv:e,pdfPage:t,annotationStorage:i||this.pdfDocument?.annotationStorage,imageResourcesPath:n,renderForms:s,linkService:this.linkService,downloadManager:this.downloadManager,l10n:o,enableScripting:l??this.enableScripting,hasJSActionsPromise:c||this.pdfDocument?.hasJSActions(),fieldObjectsPromise:d||this.pdfDocument?.getFieldObjects(),mouseState:h||this._scriptingManager?.mouseState,annotationCanvasMap:u})}createXfaLayerBuilder(e,t,i=null){return new p.XfaLayerBuilder({pageDiv:e,pdfPage:t,annotationStorage:i||this.pdfDocument?.annotationStorage,linkService:this.linkService})}createStructTreeLayerBuilder(e){return new h.StructTreeLayerBuilder({pdfPage:e})}get hasEqualPageSizes(){const e=this._pages[0];for(let t=1,i=this._pages.length;t<i;++t){const i=this._pages[t];if(i.width!==e.width||i.height!==e.height)return!1}return!0}getPagesOverview(){return this._pages.map((e=>{const t=e.pdfPage.getViewport({scale:1});return!this.enablePrintAutoRotate||(0,s.isPortraitOrientation)(t)?{width:t.width,height:t.height,rotation:t.rotation}:{width:t.height,height:t.width,rotation:(t.rotation-90)%360}}))}get optionalContentConfigPromise(){return this.pdfDocument?this._optionalContentConfigPromise?this._optionalContentConfigPromise:this.pdfDocument.getOptionalContentConfig():Promise.resolve(null)}set optionalContentConfigPromise(e){if(!(e instanceof Promise))throw new Error(`Invalid optionalContentConfigPromise: ${e}`);if(!this.pdfDocument)return;if(!this._optionalContentConfigPromise)return;this._optionalContentConfigPromise=e;const t={optionalContentConfigPromise:e};for(const e of this._pages)e.update(t);this.update();this.eventBus.dispatch("optionalcontentconfigchanged",{source:this,promise:e})}get scrollMode(){return this._scrollMode}set scrollMode(e){if(this._scrollMode!==e){if(!(0,s.isValidScrollMode)(e))throw new Error(`Invalid scroll mode: ${e}`);if(!(this.pagesCount>f.FORCE_SCROLL_MODE_PAGE)){this._previousScrollMode=this._scrollMode;this._scrollMode=e;this.eventBus.dispatch("scrollmodechanged",{source:this,mode:e});this._updateScrollMode(this._currentPageNumber)}}}_updateScrollMode(e=null){const t=this._scrollMode,i=this.viewer;i.classList.toggle("scrollHorizontal",t===s.ScrollMode.HORIZONTAL);i.classList.toggle("scrollWrapped",t===s.ScrollMode.WRAPPED);if(this.pdfDocument&&e){t===s.ScrollMode.PAGE?this.#A():this._previousScrollMode===s.ScrollMode.PAGE&&this._updateSpreadMode();this._currentScaleValue&&isNaN(this._currentScaleValue)&&this._setScale(this._currentScaleValue,!0);this._setCurrentPageNumber(e,!0);this.update()}}get spreadMode(){return this._spreadMode}set spreadMode(e){if(this._spreadMode!==e){if(!(0,s.isValidSpreadMode)(e))throw new Error(`Invalid spread mode: ${e}`);this._spreadMode=e;this.eventBus.dispatch("spreadmodechanged",{source:this,mode:e});this._updateSpreadMode(this._currentPageNumber)}}_updateSpreadMode(e=null){if(!this.pdfDocument)return;const t=this.viewer,i=this._pages;if(this._scrollMode===s.ScrollMode.PAGE)this.#A();else{t.textContent="";if(this._spreadMode===s.SpreadMode.NONE)for(let e=0,n=i.length;e<n;++e)t.appendChild(i[e].div);else{const e=this._spreadMode-1;let n=null;for(let s=0,r=i.length;s<r;++s){if(null===n){n=document.createElement("div");n.className="spread";t.appendChild(n)}else if(s%2===e){n=n.cloneNode(!1);t.appendChild(n)}n.appendChild(i[s].div)}}}if(e){this._currentScaleValue&&isNaN(this._currentScaleValue)&&this._setScale(this._currentScaleValue,!0);this._setCurrentPageNumber(e,!0);this.update()}}_getPageAdvance(e,t=!1){switch(this._scrollMode){case s.ScrollMode.WRAPPED:{const{views:i}=this._getVisiblePages(),n=new Map;for(const{id:e,y:t,percent:s,widthPercent:r}of i){if(0===s||r<100)continue;let i=n.get(t);i||n.set(t,i||=[]);i.push(e)}for(const i of n.values()){const n=i.indexOf(e);if(-1===n)continue;const s=i.length;if(1===s)break;if(t)for(let t=n-1,s=0;t>=s;t--){const n=i[t],s=i[t+1]-1;if(n<s)return e-s}else for(let t=n+1,r=s;t<r;t++){const n=i[t],s=i[t-1]+1;if(n>s)return s-e}if(t){const t=i[0];if(t<e)return e-t+1}else{const t=i[s-1];if(t>e)return t-e+1}break}break}case s.ScrollMode.HORIZONTAL:break;case s.ScrollMode.PAGE:case s.ScrollMode.VERTICAL:{if(this._spreadMode===s.SpreadMode.NONE)break;const i=this._spreadMode-1;if(t&&e%2!==i)break;if(!t&&e%2===i)break;const{views:n}=this._getVisiblePages(),r=t?e-1:e+1;for(const{id:e,percent:t,widthPercent:i}of n)if(e===r){if(t>0&&100===i)return 2;break}break}}return 1}nextPage(){const e=this._currentPageNumber,t=this.pagesCount;if(e>=t)return!1;const i=this._getPageAdvance(e,!1)||1;this.currentPageNumber=Math.min(e+i,t);return!0}previousPage(){const e=this._currentPageNumber;if(e<=1)return!1;const t=this._getPageAdvance(e,!0)||1;this.currentPageNumber=Math.max(e-t,1);return!0}increaseScale(e=1){let t=this._currentScale;do{t=(t*s.DEFAULT_SCALE_DELTA).toFixed(2);t=Math.ceil(10*t)/10;t=Math.min(s.MAX_SCALE,t)}while(--e>0&&t<s.MAX_SCALE);this.currentScaleValue=t}decreaseScale(e=1){let t=this._currentScale;do{t=(t/s.DEFAULT_SCALE_DELTA).toFixed(2);t=Math.floor(10*t)/10;t=Math.max(s.MIN_SCALE,t)}while(--e>0&&t>s.MIN_SCALE);this.currentScaleValue=t}}t.BaseViewer=BaseViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.AnnotationLayerBuilder=void 0;var n=i(5),s=i(30);t.AnnotationLayerBuilder=class AnnotationLayerBuilder{constructor({pageDiv:e,pdfPage:t,linkService:i,downloadManager:n,annotationStorage:r=null,imageResourcesPath:a="",renderForms:o=!0,l10n:l=s.NullL10n,enableScripting:c=!1,hasJSActionsPromise:h=null,fieldObjectsPromise:d=null,mouseState:u=null,annotationCanvasMap:p=null}){this.pageDiv=e;this.pdfPage=t;this.linkService=i;this.downloadManager=n;this.imageResourcesPath=a;this.renderForms=o;this.l10n=l;this.annotationStorage=r;this.enableScripting=c;this._hasJSActionsPromise=h;this._fieldObjectsPromise=d;this._mouseState=u;this._annotationCanvasMap=p;this.div=null;this._cancelled=!1}async render(e,t="display"){const[i,s=!1,r=null]=await Promise.all([this.pdfPage.getAnnotations({intent:t}),this._hasJSActionsPromise,this._fieldObjectsPromise]);if(this._cancelled||0===i.length)return;const a={viewport:e.clone({dontFlip:!0}),div:this.div,annotations:i,page:this.pdfPage,imageResourcesPath:this.imageResourcesPath,renderForms:this.renderForms,linkService:this.linkService,downloadManager:this.downloadManager,annotationStorage:this.annotationStorage,enableScripting:this.enableScripting,hasJSActions:s,fieldObjects:r,mouseState:this._mouseState,annotationCanvasMap:this._annotationCanvasMap};if(this.div)n.AnnotationLayer.update(a);else{this.div=document.createElement("div");this.div.className="annotationLayer";this.pageDiv.appendChild(this.div);a.div=this.div;n.AnnotationLayer.render(a);this.l10n.translate(this.div)}}cancel(){this._cancelled=!0}hide(){this.div&&(this.div.hidden=!0)}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NullL10n=void 0;t.fixupLangCode=function fixupLangCode(e){return n[e?.toLowerCase()]||e};t.getL10nFallback=getL10nFallback;const i={of_pages:"of {{pagesCount}}",page_of_pages:"({{pageNumber}} of {{pagesCount}})",document_properties_kb:"{{size_kb}} KB ({{size_b}} bytes)",document_properties_mb:"{{size_mb}} MB ({{size_b}} bytes)",document_properties_date_string:"{{date}}, {{time}}",document_properties_page_size_unit_inches:"in",document_properties_page_size_unit_millimeters:"mm",document_properties_page_size_orientation_portrait:"portrait",document_properties_page_size_orientation_landscape:"landscape",document_properties_page_size_name_a3:"A3",document_properties_page_size_name_a4:"A4",document_properties_page_size_name_letter:"Letter",document_properties_page_size_name_legal:"Legal",document_properties_page_size_dimension_string:"{{width}} × {{height}} {{unit}} ({{orientation}})",document_properties_page_size_dimension_name_string:"{{width}} × {{height}} {{unit}} ({{name}}, {{orientation}})",document_properties_linearized_yes:"Yes",document_properties_linearized_no:"No",print_progress_percent:"{{progress}}%","toggle_sidebar.title":"Toggle Sidebar","toggle_sidebar_notification2.title":"Toggle Sidebar (document contains outline/attachments/layers)",additional_layers:"Additional Layers",page_landmark:"Page {{page}}",thumb_page_title:"Page {{page}}",thumb_page_canvas:"Thumbnail of Page {{page}}",find_reached_top:"Reached top of document, continued from bottom",find_reached_bottom:"Reached end of document, continued from top","find_match_count[one]":"{{current}} of {{total}} match","find_match_count[other]":"{{current}} of {{total}} matches","find_match_count_limit[one]":"More than {{limit}} match","find_match_count_limit[other]":"More than {{limit}} matches",find_not_found:"Phrase not found",error_version_info:"PDF.js v{{version}} (build: {{build}})",error_message:"Message: {{message}}",error_stack:"Stack: {{stack}}",error_file:"File: {{file}}",error_line:"Line: {{line}}",rendering_error:"An error occurred while rendering the page.",page_scale_width:"Page Width",page_scale_fit:"Page Fit",page_scale_auto:"Automatic Zoom",page_scale_actual:"Actual Size",page_scale_percent:"{{scale}}%",loading:"Loading…",loading_error:"An error occurred while loading the PDF.",invalid_file_error:"Invalid or corrupted PDF file.",missing_file_error:"Missing PDF file.",unexpected_response_error:"Unexpected server response.",printing_not_supported:"Warning: Printing is not fully supported by this browser.",printing_not_ready:"Warning: The PDF is not fully loaded for printing.",web_fonts_disabled:"Web fonts are disabled: unable to use embedded PDF fonts."};function getL10nFallback(e,t){switch(e){case"find_match_count":e=`find_match_count[${1===t.total?"one":"other"}]`;break;case"find_match_count_limit":e=`find_match_count_limit[${1===t.limit?"one":"other"}]`}return i[e]||""}const n={en:"en-US",es:"es-ES",fy:"fy-NL",ga:"ga-IE",gu:"gu-IN",hi:"hi-IN",hy:"hy-AM",nb:"nb-NO",ne:"ne-NP",nn:"nn-NO",pa:"pa-IN",pt:"pt-PT",sv:"sv-SE",zh:"zh-CN"};const s={getLanguage:async()=>"en-us",getDirection:async()=>"ltr",get:async(e,t=null,i=getL10nFallback(e,t))=>function formatL10nValue(e,t){return t?e.replace(/\{\{\s*(\w+)\s*\}\}/g,((e,i)=>i in t?t[i]:"{{"+i+"}}")):e}(i,t),async translate(e){}};t.NullL10n=s},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPageView=void 0;var n=i(5),s=i(3),r=i(1),a=i(30);const o=r.compatibilityParams.maxCanvasPixels||16777216;t.PDFPageView=class PDFPageView{#_=n.AnnotationMode.ENABLE_FORMS;constructor(e){const t=e.container,i=e.defaultViewport;this.id=e.id;this.renderingId="page"+this.id;this.pdfPage=null;this.pageLabel=null;this.rotation=0;this.scale=e.scale||s.DEFAULT_SCALE;this.viewport=i;this.pdfPageRotate=i.rotation;this._optionalContentConfigPromise=e.optionalContentConfigPromise||null;this.hasRestrictedScaling=!1;this.textLayerMode=e.textLayerMode??s.TextLayerMode.ENABLE;this.#_=e.annotationMode??n.AnnotationMode.ENABLE_FORMS;this.imageResourcesPath=e.imageResourcesPath||"";this.useOnlyCssZoom=e.useOnlyCssZoom||!1;this.maxCanvasPixels=e.maxCanvasPixels||o;this.eventBus=e.eventBus;this.renderingQueue=e.renderingQueue;this.textLayerFactory=e.textLayerFactory;this.annotationLayerFactory=e.annotationLayerFactory;this.xfaLayerFactory=e.xfaLayerFactory;this.textHighlighter=e.textHighlighterFactory?.createTextHighlighter(this.id-1,this.eventBus);this.structTreeLayerFactory=e.structTreeLayerFactory;this.renderer=e.renderer||s.RendererType.CANVAS;this.l10n=e.l10n||a.NullL10n;this.paintTask=null;this.paintedViewportMap=new WeakMap;this.renderingState=s.RenderingStates.INITIAL;this.resume=null;this._renderError=null;this._isStandalone=!this.renderingQueue?.hasViewer();this._annotationCanvasMap=null;this.annotationLayer=null;this.textLayer=null;this.zoomLayer=null;this.xfaLayer=null;this.structTreeLayer=null;const r=document.createElement("div");r.className="page";r.style.width=Math.floor(this.viewport.width)+"px";r.style.height=Math.floor(this.viewport.height)+"px";r.setAttribute("data-page-number",this.id);r.setAttribute("role","region");this.l10n.get("page_landmark",{page:this.id}).then((e=>{r.setAttribute("aria-label",e)}));this.div=r;t?.appendChild(r)}setPdfPage(e){this.pdfPage=e;this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:this.scale*n.PixelsPerInch.PDF_TO_CSS_UNITS,rotation:t});this.reset()}destroy(){this.reset();this.pdfPage&&this.pdfPage.cleanup()}async _renderAnnotationLayer(){let e=null;try{await this.annotationLayer.render(this.viewport,"display")}catch(t){e=t}finally{this.eventBus.dispatch("annotationlayerrendered",{source:this,pageNumber:this.id,error:e})}}async _renderXfaLayer(){let e=null;try{const t=await this.xfaLayer.render(this.viewport,"display");this.textHighlighter&&this._buildXfaTextContentItems(t.textDivs)}catch(t){e=t}finally{this.eventBus.dispatch("xfalayerrendered",{source:this,pageNumber:this.id,error:e})}}async _buildXfaTextContentItems(e){const t=await this.pdfPage.getTextContent(),i=[];for(const e of t.items)i.push(e.str);this.textHighlighter.setTextMapping(e,i);this.textHighlighter.enable()}_resetZoomLayer(e=!1){if(!this.zoomLayer)return;const t=this.zoomLayer.firstChild;this.paintedViewportMap.delete(t);t.width=0;t.height=0;e&&this.zoomLayer.remove();this.zoomLayer=null}reset({keepZoomLayer:e=!1,keepAnnotationLayer:t=!1,keepXfaLayer:i=!1}={}){this.cancelRendering({keepAnnotationLayer:t,keepXfaLayer:i});this.renderingState=s.RenderingStates.INITIAL;const n=this.div;n.style.width=Math.floor(this.viewport.width)+"px";n.style.height=Math.floor(this.viewport.height)+"px";const r=n.childNodes,a=e&&this.zoomLayer||null,o=t&&this.annotationLayer?.div||null,l=i&&this.xfaLayer?.div||null;for(let e=r.length-1;e>=0;e--){const t=r[e];switch(t){case a:case o:case l:continue}t.remove()}n.removeAttribute("data-loaded");o&&this.annotationLayer.hide();l&&this.xfaLayer.hide();if(!a){if(this.canvas){this.paintedViewportMap.delete(this.canvas);this.canvas.width=0;this.canvas.height=0;delete this.canvas}this._resetZoomLayer()}if(this.svg){this.paintedViewportMap.delete(this.svg);delete this.svg}this.loadingIconDiv=document.createElement("div");this.loadingIconDiv.className="loadingIcon notVisible";this._isStandalone&&this.toggleLoadingIconSpinner(!0);this.loadingIconDiv.setAttribute("role","img");this.l10n.get("loading").then((e=>{this.loadingIconDiv?.setAttribute("aria-label",e)}));n.appendChild(this.loadingIconDiv)}update({scale:e=0,rotation:t=null,optionalContentConfigPromise:i=null}){if("object"!=typeof arguments[0]){console.error("PDFPageView.update called with separate parameters, please use an object instead.");this.update({scale:arguments[0],rotation:arguments[1],optionalContentConfigPromise:arguments[2]});return}this.scale=e||this.scale;"number"==typeof t&&(this.rotation=t);i instanceof Promise&&(this._optionalContentConfigPromise=i);const s=(this.rotation+this.pdfPageRotate)%360,r=this.scale*n.PixelsPerInch.PDF_TO_CSS_UNITS;this.viewport=this.viewport.clone({scale:r,rotation:s});if(this._isStandalone){const{style:e}=document.documentElement;e.setProperty("--zoom-factor",this.scale);e.setProperty("--viewport-scale-factor",r)}if(this.svg){this.cssTransform({target:this.svg,redrawAnnotationLayer:!0,redrawXfaLayer:!0});this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!0,timestamp:performance.now(),error:this._renderError});return}let a=!1;if(this.canvas&&this.maxCanvasPixels>0){const e=this.outputScale;(Math.floor(this.viewport.width)*e.sx|0)*(Math.floor(this.viewport.height)*e.sy|0)>this.maxCanvasPixels&&(a=!0)}if(this.canvas){if(this.useOnlyCssZoom||this.hasRestrictedScaling&&a){this.cssTransform({target:this.canvas,redrawAnnotationLayer:!0,redrawXfaLayer:!0});this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!0,timestamp:performance.now(),error:this._renderError});return}if(!this.zoomLayer&&!this.canvas.hidden){this.zoomLayer=this.canvas.parentNode;this.zoomLayer.style.position="absolute"}}this.zoomLayer&&this.cssTransform({target:this.zoomLayer.firstChild});this.reset({keepZoomLayer:!0,keepAnnotationLayer:!0,keepXfaLayer:!0})}cancelRendering({keepAnnotationLayer:e=!1,keepXfaLayer:t=!1}={}){if(this.paintTask){this.paintTask.cancel();this.paintTask=null}this.resume=null;if(this.textLayer){this.textLayer.cancel();this.textLayer=null}if(this.annotationLayer&&(!e||!this.annotationLayer.div)){this.annotationLayer.cancel();this.annotationLayer=null;this._annotationCanvasMap=null}if(this.xfaLayer&&(!t||!this.xfaLayer.div)){this.xfaLayer.cancel();this.xfaLayer=null;this.textHighlighter?.disable()}if(this._onTextLayerRendered){this.eventBus._off("textlayerrendered",this._onTextLayerRendered);this._onTextLayerRendered=null}}cssTransform({target:e,redrawAnnotationLayer:t=!1,redrawXfaLayer:i=!1}){const n=this.viewport.width,s=this.viewport.height,r=this.div;e.style.width=e.parentNode.style.width=r.style.width=Math.floor(n)+"px";e.style.height=e.parentNode.style.height=r.style.height=Math.floor(s)+"px";const a=this.viewport.rotation-this.paintedViewportMap.get(e).rotation,o=Math.abs(a);let l=1,c=1;if(90===o||270===o){l=s/n;c=n/s}e.style.transform=`rotate(${a}deg) scale(${l}, ${c})`;if(this.textLayer){const e=this.textLayer.viewport,t=this.viewport.rotation-e.rotation,i=Math.abs(t);let s=n/e.width;90!==i&&270!==i||(s=n/e.height);const r=this.textLayer.textLayerDiv;let a,o;switch(i){case 0:a=o=0;break;case 90:a=0;o="-"+r.style.height;break;case 180:a="-"+r.style.width;o="-"+r.style.height;break;case 270:a="-"+r.style.width;o=0;break;default:console.error("Bad rotation value.")}r.style.transform=`rotate(${i}deg) scale(${s}) translate(${a}, ${o})`;r.style.transformOrigin="0% 0%"}t&&this.annotationLayer&&this._renderAnnotationLayer();i&&this.xfaLayer&&this._renderXfaLayer()}get width(){return this.viewport.width}get height(){return this.viewport.height}getPagePoint(e,t){return this.viewport.convertToPdfPoint(e,t)}toggleLoadingIconSpinner(e=!1){this.loadingIconDiv?.classList.toggle("notVisible",!e)}draw(){if(this.renderingState!==s.RenderingStates.INITIAL){console.error("Must be in new state before drawing");this.reset()}const{div:e,pdfPage:t}=this;if(!t){this.renderingState=s.RenderingStates.FINISHED;if(this.loadingIconDiv){this.loadingIconDiv.remove();delete this.loadingIconDiv}return Promise.reject(new Error("pdfPage is not loaded"))}this.renderingState=s.RenderingStates.RUNNING;const i=document.createElement("div");i.style.width=e.style.width;i.style.height=e.style.height;i.classList.add("canvasWrapper");this.annotationLayer?.div?e.insertBefore(i,this.annotationLayer.div):e.appendChild(i);let r=null;if(this.textLayerMode!==s.TextLayerMode.DISABLE&&this.textLayerFactory){const t=document.createElement("div");t.className="textLayer";t.style.width=i.style.width;t.style.height=i.style.height;this.annotationLayer?.div?e.insertBefore(t,this.annotationLayer.div):e.appendChild(t);r=this.textLayerFactory.createTextLayerBuilder(t,this.id-1,this.viewport,this.textLayerMode===s.TextLayerMode.ENABLE_ENHANCE,this.eventBus,this.textHighlighter)}this.textLayer=r;if(this.#_!==n.AnnotationMode.DISABLE&&this.annotationLayerFactory){this._annotationCanvasMap||=new Map;this.annotationLayer||=this.annotationLayerFactory.createAnnotationLayerBuilder(e,t,null,this.imageResourcesPath,this.#_===n.AnnotationMode.ENABLE_FORMS,this.l10n,null,null,null,null,this._annotationCanvasMap)}this.xfaLayer?.div&&e.appendChild(this.xfaLayer.div);let a=null;this.renderingQueue&&(a=e=>{if(this.renderingQueue.isHighestPriority(this))e();else{this.renderingState=s.RenderingStates.PAUSED;this.resume=()=>{this.renderingState=s.RenderingStates.RUNNING;e()}}});const finishPaintTask=async(e=null)=>{o===this.paintTask&&(this.paintTask=null);if(e instanceof n.RenderingCancelledException)this._renderError=null;else{this._renderError=e;this.renderingState=s.RenderingStates.FINISHED;if(this.loadingIconDiv){this.loadingIconDiv.remove();delete this.loadingIconDiv}this._resetZoomLayer(!0);this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!1,timestamp:performance.now(),error:this._renderError});if(e)throw e}},o=this.renderer===s.RendererType.SVG?this.paintOnSvg(i):this.paintOnCanvas(i);o.onRenderContinue=a;this.paintTask=o;const l=o.promise.then((()=>finishPaintTask(null).then((()=>{if(r){const e=t.streamTextContent({normalizeWhitespace:!0,includeMarkedContent:!0});r.setTextContentStream(e);r.render()}this.annotationLayer&&this._renderAnnotationLayer()}))),(function(e){return finishPaintTask(e)}));if(this.xfaLayerFactory){this.xfaLayer||(this.xfaLayer=this.xfaLayerFactory.createXfaLayerBuilder(e,t,null));this._renderXfaLayer()}if(this.structTreeLayerFactory&&this.textLayer&&this.canvas){this._onTextLayerRendered=e=>{if(e.pageNumber===this.id){this.eventBus._off("textlayerrendered",this._onTextLayerRendered);this._onTextLayerRendered=null;this.canvas&&this.pdfPage.getStructTree().then((e=>{if(!e)return;if(!this.canvas)return;const t=this.structTreeLayer.render(e);t.classList.add("structTree");this.canvas.appendChild(t)}))}};this.eventBus._on("textlayerrendered",this._onTextLayerRendered);this.structTreeLayer=this.structTreeLayerFactory.createStructTreeLayerBuilder(t)}e.setAttribute("data-loaded",!0);this.eventBus.dispatch("pagerender",{source:this,pageNumber:this.id});return l}paintOnCanvas(e){const t=(0,n.createPromiseCapability)(),i={promise:t.promise,onRenderContinue(e){e()},cancel(){p.cancel()}},r=this.viewport,a=document.createElement("canvas");a.hidden=!0;let o=!0;const showCanvas=function(){if(o){a.hidden=!1;o=!1}};e.appendChild(a);this.canvas=a;a.mozOpaque=!0;const l=a.getContext("2d",{alpha:!1}),c=(0,s.getOutputScale)(l);this.outputScale=c;if(this.useOnlyCssZoom){const e=r.clone({scale:n.PixelsPerInch.PDF_TO_CSS_UNITS});c.sx*=e.width/r.width;c.sy*=e.height/r.height;c.scaled=!0}if(this.maxCanvasPixels>0){const e=r.width*r.height,t=Math.sqrt(this.maxCanvasPixels/e);if(c.sx>t||c.sy>t){c.sx=t;c.sy=t;c.scaled=!0;this.hasRestrictedScaling=!0}else this.hasRestrictedScaling=!1}const h=(0,s.approximateFraction)(c.sx),d=(0,s.approximateFraction)(c.sy);a.width=(0,s.roundToDivide)(r.width*c.sx,h[0]);a.height=(0,s.roundToDivide)(r.height*c.sy,d[0]);a.style.width=(0,s.roundToDivide)(r.width,h[1])+"px";a.style.height=(0,s.roundToDivide)(r.height,d[1])+"px";this.paintedViewportMap.set(a,r);const u={canvasContext:l,transform:c.scaled?[c.sx,0,0,c.sy,0,0]:null,viewport:this.viewport,annotationMode:this.#_,optionalContentConfigPromise:this._optionalContentConfigPromise,annotationCanvasMap:this._annotationCanvasMap},p=this.pdfPage.render(u);p.onContinue=function(e){showCanvas();i.onRenderContinue?i.onRenderContinue(e):e()};p.promise.then((function(){showCanvas();t.resolve()}),(function(e){showCanvas();t.reject(e)}));return i}paintOnSvg(e){let t=!1;const ensureNotCancelled=()=>{if(t)throw new n.RenderingCancelledException(`Rendering cancelled, page ${this.id}`,"svg")},i=this.pdfPage,a=this.viewport.clone({scale:n.PixelsPerInch.PDF_TO_CSS_UNITS});return{promise:i.getOperatorList({annotationMode:this.#_}).then((t=>{ensureNotCancelled();return new n.SVGGraphics(i.commonObjs,i.objs,r.compatibilityParams.disableCreateObjectURL).getSVG(t,a).then((t=>{ensureNotCancelled();this.svg=t;this.paintedViewportMap.set(t,a);t.style.width=e.style.width;t.style.height=e.style.height;this.renderingState=s.RenderingStates.FINISHED;e.appendChild(t)}))})),onRenderContinue(e){e()},cancel(){t=!0}}}setPageLabel(e){this.pageLabel="string"==typeof e?e:null;null!==this.pageLabel?this.div.setAttribute("data-page-label",this.pageLabel):this.div.removeAttribute("data-page-label")}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.StructTreeLayerBuilder=void 0;const i={Document:null,DocumentFragment:null,Part:"group",Sect:"group",Div:"group",Aside:"note",NonStruct:"none",P:null,H:"heading",Title:null,FENote:"note",Sub:"group",Lbl:null,Span:null,Em:null,Strong:null,Link:"link",Annot:"note",Form:"form",Ruby:null,RB:null,RT:null,RP:null,Warichu:null,WT:null,WP:null,L:"list",LI:"listitem",LBody:null,Table:"table",TR:"row",TH:"columnheader",TD:"cell",THead:"columnheader",TBody:null,TFoot:null,Caption:null,Figure:"figure",Formula:null,Artifact:null},n=/^H(\d+)$/;t.StructTreeLayerBuilder=class StructTreeLayerBuilder{constructor({pdfPage:e}){this.pdfPage=e}render(e){return this._walk(e)}_setAttributes(e,t){void 0!==e.alt&&t.setAttribute("aria-label",e.alt);void 0!==e.id&&t.setAttribute("aria-owns",e.id);void 0!==e.lang&&t.setAttribute("lang",e.lang)}_walk(e){if(!e)return null;const t=document.createElement("span");if("role"in e){const{role:s}=e,r=s.match(n);if(r){t.setAttribute("role","heading");t.setAttribute("aria-level",r[1])}else i[s]&&t.setAttribute("role",i[s])}this._setAttributes(e,t);if(e.children)if(1===e.children.length&&"id"in e.children[0])this._setAttributes(e.children[0],t);else for(const i of e.children)t.appendChild(this._walk(i));return t}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TextHighlighter=void 0;t.TextHighlighter=class TextHighlighter{constructor({findController:e,eventBus:t,pageIndex:i}){this.findController=e;this.matches=[];this.eventBus=t;this.pageIdx=i;this._onUpdateTextLayerMatches=null;this.textDivs=null;this.textContentItemsStr=null;this.enabled=!1}setTextMapping(e,t){this.textDivs=e;this.textContentItemsStr=t}enable(){if(!this.textDivs||!this.textContentItemsStr)throw new Error("Text divs and strings have not been set.");if(this.enabled)throw new Error("TextHighlighter is already enabled.");this.enabled=!0;if(!this._onUpdateTextLayerMatches){this._onUpdateTextLayerMatches=e=>{e.pageIndex!==this.pageIdx&&-1!==e.pageIndex||this._updateMatches()};this.eventBus._on("updatetextlayermatches",this._onUpdateTextLayerMatches)}this._updateMatches()}disable(){if(this.enabled){this.enabled=!1;if(this._onUpdateTextLayerMatches){this.eventBus._off("updatetextlayermatches",this._onUpdateTextLayerMatches);this._onUpdateTextLayerMatches=null}}}_convertMatches(e,t){if(!e)return[];const{textContentItemsStr:i}=this;let n=0,s=0;const r=i.length-1,a=[];for(let o=0,l=e.length;o<l;o++){let l=e[o];for(;n!==r&&l>=s+i[n].length;){s+=i[n].length;n++}n===i.length&&console.error("Could not find a matching mapping");const c={begin:{divIdx:n,offset:l-s}};l+=t[o];for(;n!==r&&l>s+i[n].length;){s+=i[n].length;n++}c.end={divIdx:n,offset:l-s};a.push(c)}return a}_renderMatches(e){if(0===e.length)return;const{findController:t,pageIdx:i}=this,{textContentItemsStr:n,textDivs:s}=this,r=i===t.selected.pageIdx,a=t.selected.matchIdx;let o=null;const l={divIdx:-1,offset:void 0};function beginText(e,t){const i=e.divIdx;s[i].textContent="";return appendTextToDiv(i,0,e.offset,t)}function appendTextToDiv(e,t,i,r){let a=s[e];if(a.nodeType===Node.TEXT_NODE){const t=document.createElement("span");a.parentNode.insertBefore(t,a);t.appendChild(a);s[e]=t;a=t}const o=n[e].substring(t,i),l=document.createTextNode(o);if(r){const e=document.createElement("span");e.className=`${r} appended`;e.appendChild(l);a.appendChild(e);return r.includes("selected")?e.offsetLeft:0}a.appendChild(l);return 0}let c=a,h=c+1;if(t.state.highlightAll){c=0;h=e.length}else if(!r)return;for(let n=c;n<h;n++){const c=e[n],h=c.begin,d=c.end,u=r&&n===a,p=u?" selected":"";let g=0;if(o&&h.divIdx===o.divIdx)appendTextToDiv(o.divIdx,o.offset,h.offset);else{null!==o&&appendTextToDiv(o.divIdx,o.offset,l.offset);beginText(h)}if(h.divIdx===d.divIdx)g=appendTextToDiv(h.divIdx,h.offset,d.offset,"highlight"+p);else{g=appendTextToDiv(h.divIdx,h.offset,l.offset,"highlight begin"+p);for(let e=h.divIdx+1,t=d.divIdx;e<t;e++)s[e].className="highlight middle"+p;beginText(d,"highlight end"+p)}o=d;u&&t.scrollMatchIntoView({element:s[h.divIdx],selectedLeft:g,pageIndex:i,matchIndex:a})}o&&appendTextToDiv(o.divIdx,o.offset,l.offset)}_updateMatches(){if(!this.enabled)return;const{findController:e,matches:t,pageIdx:i}=this,{textContentItemsStr:n,textDivs:s}=this;let r=-1;for(let e=0,i=t.length;e<i;e++){const i=t[e];for(let e=Math.max(r,i.begin.divIdx),t=i.end.divIdx;e<=t;e++){const t=s[e];t.textContent=n[e];t.className=""}r=i.end.divIdx+1}if(!e?.highlightMatches)return;const a=e.pageMatches[i]||null,o=e.pageMatchesLength[i]||null;this.matches=this._convertMatches(a,o);this._renderMatches(this.matches)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TextLayerBuilder=void 0;var n=i(5);t.TextLayerBuilder=class TextLayerBuilder{constructor({textLayerDiv:e,eventBus:t,pageIndex:i,viewport:n,highlighter:s=null,enhanceTextSelection:r=!1}){this.textLayerDiv=e;this.eventBus=t;this.textContent=null;this.textContentItemsStr=[];this.textContentStream=null;this.renderingDone=!1;this.pageNumber=i+1;this.viewport=n;this.textDivs=[];this.textLayerRenderTask=null;this.highlighter=s;this.enhanceTextSelection=r;this._bindMouse()}_finishRendering(){this.renderingDone=!0;if(!this.enhanceTextSelection){const e=document.createElement("div");e.className="endOfContent";this.textLayerDiv.appendChild(e)}this.eventBus.dispatch("textlayerrendered",{source:this,pageNumber:this.pageNumber,numTextDivs:this.textDivs.length})}render(e=0){if(!this.textContent&&!this.textContentStream||this.renderingDone)return;this.cancel();this.textDivs.length=0;this.highlighter?.setTextMapping(this.textDivs,this.textContentItemsStr);const t=document.createDocumentFragment();this.textLayerRenderTask=(0,n.renderTextLayer)({textContent:this.textContent,textContentStream:this.textContentStream,container:t,viewport:this.viewport,textDivs:this.textDivs,textContentItemsStr:this.textContentItemsStr,timeout:e,enhanceTextSelection:this.enhanceTextSelection});this.textLayerRenderTask.promise.then((()=>{this.textLayerDiv.appendChild(t);this._finishRendering();this.highlighter?.enable()}),(function(e){}))}cancel(){if(this.textLayerRenderTask){this.textLayerRenderTask.cancel();this.textLayerRenderTask=null}this.highlighter?.disable()}setTextContentStream(e){this.cancel();this.textContentStream=e}setTextContent(e){this.cancel();this.textContent=e}_bindMouse(){const e=this.textLayerDiv;let t=null;e.addEventListener("mousedown",(i=>{if(this.enhanceTextSelection&&this.textLayerRenderTask){this.textLayerRenderTask.expandTextDivs(!0);if(t){clearTimeout(t);t=null}return}const n=e.querySelector(".endOfContent");if(!n)return;let s=i.target!==e;s=s&&"none"!==window.getComputedStyle(n).getPropertyValue("-moz-user-select");if(s){const t=e.getBoundingClientRect(),s=Math.max(0,(i.pageY-t.top)/t.height);n.style.top=(100*s).toFixed(2)+"%"}n.classList.add("active")}));e.addEventListener("mouseup",(()=>{if(this.enhanceTextSelection&&this.textLayerRenderTask){t=setTimeout((()=>{this.textLayerRenderTask&&this.textLayerRenderTask.expandTextDivs(!1);t=null}),300);return}const i=e.querySelector(".endOfContent");if(i){i.style.top="";i.classList.remove("active")}}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XfaLayerBuilder=void 0;var n=i(5);t.XfaLayerBuilder=class XfaLayerBuilder{constructor({pageDiv:e,pdfPage:t,annotationStorage:i=null,linkService:n,xfaHtml:s=null}){this.pageDiv=e;this.pdfPage=t;this.annotationStorage=i;this.linkService=n;this.xfaHtml=s;this.div=null;this._cancelled=!1}render(e,t="display"){if("print"===t){const i={viewport:e.clone({dontFlip:!0}),div:this.div,xfaHtml:this.xfaHtml,annotationStorage:this.annotationStorage,linkService:this.linkService,intent:t},s=document.createElement("div");this.pageDiv.appendChild(s);i.div=s;const r=n.XfaLayer.render(i);return Promise.resolve(r)}return this.pdfPage.getXfa().then((i=>{if(this._cancelled||!i)return{textDivs:[]};const s={viewport:e.clone({dontFlip:!0}),div:this.div,xfaHtml:i,annotationStorage:this.annotationStorage,linkService:this.linkService,intent:t};if(this.div)return n.XfaLayer.update(s);this.div=document.createElement("div");this.pageDiv.appendChild(this.div);s.div=this.div;return n.XfaLayer.render(s)})).catch((e=>{console.error(e)}))}cancel(){this._cancelled=!0}hide(){this.div&&(this.div.hidden=!0)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SecondaryToolbar=void 0;var n=i(3),s=i(6),r=i(28);t.SecondaryToolbar=class SecondaryToolbar{constructor(e,t,i){this.toolbar=e.toolbar;this.toggleButton=e.toggleButton;this.toolbarButtonContainer=e.toolbarButtonContainer;this.buttons=[{element:e.presentationModeButton,eventName:"presentationmode",close:!0},{element:e.openFileButton,eventName:"openfile",close:!0},{element:e.printButton,eventName:"print",close:!0},{element:e.downloadButton,eventName:"download",close:!0},{element:e.viewBookmarkButton,eventName:null,close:!0},{element:e.firstPageButton,eventName:"firstpage",close:!0},{element:e.lastPageButton,eventName:"lastpage",close:!0},{element:e.pageRotateCwButton,eventName:"rotatecw",close:!1},{element:e.pageRotateCcwButton,eventName:"rotateccw",close:!1},{element:e.cursorSelectToolButton,eventName:"switchcursortool",eventDetails:{tool:s.CursorTool.SELECT},close:!0},{element:e.cursorHandToolButton,eventName:"switchcursortool",eventDetails:{tool:s.CursorTool.HAND},close:!0},{element:e.scrollPageButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.PAGE},close:!0},{element:e.scrollVerticalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.VERTICAL},close:!0},{element:e.scrollHorizontalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.HORIZONTAL},close:!0},{element:e.scrollWrappedButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.WRAPPED},close:!0},{element:e.spreadNoneButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.NONE},close:!0},{element:e.spreadOddButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.ODD},close:!0},{element:e.spreadEvenButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.EVEN},close:!0},{element:e.documentPropertiesButton,eventName:"documentproperties",close:!0}];this.items={firstPage:e.firstPageButton,lastPage:e.lastPageButton,pageRotateCw:e.pageRotateCwButton,pageRotateCcw:e.pageRotateCcwButton};this.mainContainer=t;this.eventBus=i;this.opened=!1;this.containerHeight=null;this.previousContainerHeight=null;this.reset();this._bindClickListeners();this._bindCursorToolsListener(e);this._bindScrollModeListener(e);this._bindSpreadModeListener(e);this.eventBus._on("resize",this._setMaxHeight.bind(this))}get isOpen(){return this.opened}setPageNumber(e){this.pageNumber=e;this._updateUIState()}setPagesCount(e){this.pagesCount=e;this._updateUIState()}reset(){this.pageNumber=0;this.pagesCount=0;this._updateUIState();this.eventBus.dispatch("secondarytoolbarreset",{source:this})}_updateUIState(){this.items.firstPage.disabled=this.pageNumber<=1;this.items.lastPage.disabled=this.pageNumber>=this.pagesCount;this.items.pageRotateCw.disabled=0===this.pagesCount;this.items.pageRotateCcw.disabled=0===this.pagesCount}_bindClickListeners(){this.toggleButton.addEventListener("click",this.toggle.bind(this));for(const{element:e,eventName:t,close:i,eventDetails:n}of this.buttons)e.addEventListener("click",(e=>{if(null!==t){const e={source:this};for(const t in n)e[t]=n[t];this.eventBus.dispatch(t,e)}i&&this.close()}))}_bindCursorToolsListener(e){this.eventBus._on("cursortoolchanged",(function({tool:t}){e.cursorSelectToolButton.classList.toggle("toggled",t===s.CursorTool.SELECT);e.cursorHandToolButton.classList.toggle("toggled",t===s.CursorTool.HAND)}))}_bindScrollModeListener(e){const scrollModeChanged=({mode:t})=>{e.scrollPageButton.classList.toggle("toggled",t===n.ScrollMode.PAGE);e.scrollVerticalButton.classList.toggle("toggled",t===n.ScrollMode.VERTICAL);e.scrollHorizontalButton.classList.toggle("toggled",t===n.ScrollMode.HORIZONTAL);e.scrollWrappedButton.classList.toggle("toggled",t===n.ScrollMode.WRAPPED);const i=this.pagesCount>r.PagesCountLimit.FORCE_SCROLL_MODE_PAGE;e.scrollPageButton.disabled=i;e.scrollVerticalButton.disabled=i;e.scrollHorizontalButton.disabled=i;e.scrollWrappedButton.disabled=i;const s=t===n.ScrollMode.HORIZONTAL;e.spreadNoneButton.disabled=s;e.spreadOddButton.disabled=s;e.spreadEvenButton.disabled=s};this.eventBus._on("scrollmodechanged",scrollModeChanged);this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&scrollModeChanged({mode:n.ScrollMode.VERTICAL})}))}_bindSpreadModeListener(e){function spreadModeChanged({mode:t}){e.spreadNoneButton.classList.toggle("toggled",t===n.SpreadMode.NONE);e.spreadOddButton.classList.toggle("toggled",t===n.SpreadMode.ODD);e.spreadEvenButton.classList.toggle("toggled",t===n.SpreadMode.EVEN)}this.eventBus._on("spreadmodechanged",spreadModeChanged);this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&spreadModeChanged({mode:n.SpreadMode.NONE})}))}open(){if(!this.opened){this.opened=!0;this._setMaxHeight();this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.toolbar.classList.remove("hidden")}}close(){if(this.opened){this.opened=!1;this.toolbar.classList.add("hidden");this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false")}}toggle(){this.opened?this.close():this.open()}_setMaxHeight(){if(this.opened){this.containerHeight=this.mainContainer.clientHeight;if(this.containerHeight!==this.previousContainerHeight){this.toolbarButtonContainer.style.maxHeight=this.containerHeight-n.SCROLLBAR_PADDING+"px";this.previousContainerHeight=this.containerHeight}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Toolbar=void 0;var n=i(3);t.Toolbar=class Toolbar{constructor(e,t,i){this.toolbar=e.container;this.eventBus=t;this.l10n=i;this.buttons=[{element:e.previous,eventName:"previouspage"},{element:e.next,eventName:"nextpage"},{element:e.zoomIn,eventName:"zoomin"},{element:e.zoomOut,eventName:"zoomout"},{element:e.openFile,eventName:"openfile"},{element:e.print,eventName:"print"},{element:e.presentationModeButton,eventName:"presentationmode"},{element:e.download,eventName:"download"},{element:e.viewBookmark,eventName:null}];this.items={numPages:e.numPages,pageNumber:e.pageNumber,scaleSelect:e.scaleSelect,customScaleOption:e.customScaleOption,previous:e.previous,next:e.next,zoomIn:e.zoomIn,zoomOut:e.zoomOut};this._wasLocalized=!1;this.reset();this._bindListeners()}setPageNumber(e,t){this.pageNumber=e;this.pageLabel=t;this._updateUIState(!1)}setPagesCount(e,t){this.pagesCount=e;this.hasPageLabels=t;this._updateUIState(!0)}setPageScale(e,t){this.pageScaleValue=(e||t).toString();this.pageScale=t;this._updateUIState(!1)}reset(){this.pageNumber=0;this.pageLabel=null;this.hasPageLabels=!1;this.pagesCount=0;this.pageScaleValue=n.DEFAULT_SCALE_VALUE;this.pageScale=n.DEFAULT_SCALE;this._updateUIState(!0);this.updateLoadingIndicatorState()}_bindListeners(){const{pageNumber:e,scaleSelect:t}=this.items,i=this;for(const{element:e,eventName:t}of this.buttons)e.addEventListener("click",(e=>{null!==t&&this.eventBus.dispatch(t,{source:this})}));e.addEventListener("click",(function(){this.select()}));e.addEventListener("change",(function(){i.eventBus.dispatch("pagenumberchanged",{source:i,value:this.value})}));t.addEventListener("change",(function(){"custom"!==this.value&&i.eventBus.dispatch("scalechanged",{source:i,value:this.value})}));t.addEventListener("click",(function(e){const t=e.target;this.value===i.pageScaleValue&&"OPTION"===t.tagName.toUpperCase()&&this.blur()}));t.oncontextmenu=n.noContextMenuHandler;this.eventBus._on("localized",(()=>{this._wasLocalized=!0;this._adjustScaleWidth();this._updateUIState(!0)}))}_updateUIState(e=!1){if(!this._wasLocalized)return;const{pageNumber:t,pagesCount:i,pageScaleValue:s,pageScale:r,items:a}=this;if(e){if(this.hasPageLabels)a.pageNumber.type="text";else{a.pageNumber.type="number";this.l10n.get("of_pages",{pagesCount:i}).then((e=>{a.numPages.textContent=e}))}a.pageNumber.max=i}if(this.hasPageLabels){a.pageNumber.value=this.pageLabel;this.l10n.get("page_of_pages",{pageNumber:t,pagesCount:i}).then((e=>{a.numPages.textContent=e}))}else a.pageNumber.value=t;a.previous.disabled=t<=1;a.next.disabled=t>=i;a.zoomOut.disabled=r<=n.MIN_SCALE;a.zoomIn.disabled=r>=n.MAX_SCALE;this.l10n.get("page_scale_percent",{scale:Math.round(1e4*r)/100}).then((e=>{let t=!1;for(const e of a.scaleSelect.options)if(e.value===s){e.selected=!0;t=!0}else e.selected=!1;if(!t){a.customScaleOption.textContent=e;a.customScaleOption.selected=!0}}))}updateLoadingIndicatorState(e=!1){this.items.pageNumber.classList.toggle("visiblePageIsLoading",e)}async _adjustScaleWidth(){const{items:e,l10n:t}=this,i=Promise.all([t.get("page_scale_auto"),t.get("page_scale_actual"),t.get("page_scale_fit"),t.get("page_scale_width")]),s=getComputedStyle(e.scaleSelect),r=parseInt(s.getPropertyValue("--scale-select-container-width"),10),a=parseInt(s.getPropertyValue("--scale-select-overflow"),10);let o=document.createElement("canvas");o.mozOpaque=!0;let l=o.getContext("2d",{alpha:!1});await n.animationStarted;l.font=`${s.fontSize} ${s.fontFamily}`;let c=0;for(const e of await i){const{width:t}=l.measureText(e);t>c&&(c=t)}c+=2*a;if(c>r){document.documentElement.style.setProperty("--scale-select-container-width",`${c}px`)}o.width=0;o.height=0;o=l=null}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ViewHistory=void 0;t.ViewHistory=class ViewHistory{constructor(e,t=20){this.fingerprint=e;this.cacheSize=t;this._initializedPromise=this._readFromStorage().then((e=>{const t=JSON.parse(e||"{}");let i=-1;if(Array.isArray(t.files)){for(;t.files.length>=this.cacheSize;)t.files.shift();for(let e=0,n=t.files.length;e<n;e++){if(t.files[e].fingerprint===this.fingerprint){i=e;break}}}else t.files=[];-1===i&&(i=t.files.push({fingerprint:this.fingerprint})-1);this.file=t.files[i];this.database=t}))}async _writeToStorage(){const e=JSON.stringify(this.database);localStorage.setItem("pdfjs.history",e)}async _readFromStorage(){return localStorage.getItem("pdfjs.history")}async set(e,t){await this._initializedPromise;this.file[e]=t;return this._writeToStorage()}async setMultiple(e){await this._initializedPromise;for(const t in e)this.file[t]=e[t];return this._writeToStorage()}async get(e,t){await this._initializedPromise;const i=this.file[e];return void 0!==i?i:t}async getMultiple(e){await this._initializedPromise;const t=Object.create(null);for(const i in e){const n=this.file[i];t[i]=void 0!==n?n:e[i]}return t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GenericCom=void 0;var n=i(2),s=i(40),r=i(41),a=i(42),o=i(44);t.GenericCom={};class GenericPreferences extends s.BasePreferences{async _writeToStorage(e){localStorage.setItem("pdfjs.preferences",JSON.stringify(e))}async _readFromStorage(e){return JSON.parse(localStorage.getItem("pdfjs.preferences"))}}class GenericExternalServices extends n.DefaultExternalServices{static createDownloadManager(e){return new r.DownloadManager}static createPreferences(){return new GenericPreferences}static createL10n({locale:e="en-US"}){return new a.GenericL10n(e)}static createScripting({sandboxBundleSrc:e}){return new o.GenericScripting(e)}}n.PDFViewerApplication.externalServices=GenericExternalServices},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BasePreferences=void 0;i(1);class BasePreferences{constructor(){if(this.constructor===BasePreferences)throw new Error("Cannot initialize BasePreferences.");Object.defineProperty(this,"defaults",{value:Object.freeze({annotationMode:2,cursorToolOnLoad:0,defaultZoomValue:"",disablePageLabels:!1,enablePermissions:!1,enablePrintAutoRotate:!0,enableScripting:!0,externalLinkTarget:0,historyUpdateUrl:!1,ignoreDestinationZoom:!1,pdfBugEnabled:!1,renderer:"canvas",sidebarViewOnLoad:-1,scrollModeOnLoad:-1,spreadModeOnLoad:-1,textLayerMode:1,useOnlyCssZoom:!1,viewerCssTheme:0,viewOnLoad:0,disableAutoFetch:!1,disableFontFace:!1,disableRange:!1,disableStream:!1,enableXfa:!0}),writable:!1,enumerable:!0,configurable:!1});this.prefs=Object.create(null);this._initializedPromise=this._readFromStorage(this.defaults).then((e=>{for(const t in this.defaults){const i=e?.[t];typeof i==typeof this.defaults[t]&&(this.prefs[t]=i)}}))}async _writeToStorage(e){throw new Error("Not implemented: _writeToStorage")}async _readFromStorage(e){throw new Error("Not implemented: _readFromStorage")}async reset(){await this._initializedPromise;this.prefs=Object.create(null);return this._writeToStorage(this.defaults)}async set(e,t){await this._initializedPromise;const i=this.defaults[e];if(void 0===i)throw new Error(`Set preference: "${e}" is undefined.`);if(void 0===t)throw new Error("Set preference: no value is specified.");const n=typeof t,s=typeof i;if(n!==s){if("number"!==n||"string"!==s)throw new Error(`Set preference: "${t}" is a ${n}, expected a ${s}.`);t=t.toString()}else if("number"===n&&!Number.isInteger(t))throw new Error(`Set preference: "${t}" must be an integer.`);this.prefs[e]=t;return this._writeToStorage(this.prefs)}async get(e){await this._initializedPromise;const t=this.defaults[e],i=this.prefs[e];if(void 0===t)throw new Error(`Get preference: "${e}" is undefined.`);return void 0!==i?i:t}async getAll(){await this._initializedPromise;const e=Object.create(null);for(const t in this.defaults){const i=this.prefs[t];e[t]=void 0!==i?i:this.defaults[t]}return e}}t.BasePreferences=BasePreferences},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.DownloadManager=void 0;var n=i(5),s=i(1);function download(e,t){const i=document.createElement("a");if(!i.click)throw new Error('DownloadManager: "a.click()" is not supported.');i.href=e;i.target="_parent";"download"in i&&(i.download=t);(document.body||document.documentElement).appendChild(i);i.click();i.remove()}t.DownloadManager=class DownloadManager{constructor(){this._openBlobUrls=new WeakMap}downloadUrl(e,t){(0,n.createValidAbsoluteUrl)(e,"http://example.com")?download(e+"#pdfjs.action=download",t):console.error(`downloadUrl - not a valid URL: ${e}`)}downloadData(e,t,i){download((0,n.createObjectURL)(e,i,s.compatibilityParams.disableCreateObjectURL),t)}openOrDownloadData(e,t,i){const r=(0,n.isPdfFile)(i),a=r?"application/pdf":"";if(r&&!s.compatibilityParams.disableCreateObjectURL){let n,s=this._openBlobUrls.get(e);if(!s){s=URL.createObjectURL(new Blob([t],{type:a}));this._openBlobUrls.set(e,s)}n="?file="+encodeURIComponent(s+"#"+i);try{window.open(n);return!0}catch(t){console.error(`openOrDownloadData: ${t}`);URL.revokeObjectURL(s);this._openBlobUrls.delete(e)}}this.downloadData(t,i,a);return!1}download(e,t,i,n="download"){if(s.compatibilityParams.disableCreateObjectURL){this.downloadUrl(t,i);return}download(URL.createObjectURL(e),i)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GenericL10n=void 0;i(43);var n=i(30);const s=document.webL10n;t.GenericL10n=class GenericL10n{constructor(e){this._lang=e;this._ready=new Promise(((t,i)=>{s.setLanguage((0,n.fixupLangCode)(e),(()=>{t(s)}))}))}async getLanguage(){return(await this._ready).getLanguage()}async getDirection(){return(await this._ready).getDirection()}async get(e,t=null,i=(0,n.getL10nFallback)(e,t)){return(await this._ready).get(e,t,i)}async translate(e){return(await this._ready).translate(e)}}},()=>{document.webL10n=function(e,t,i){var n={},s="",r="textContent",a="",o={},l="loading";function xhrLoadText(e,t,i){t=t||function _onSuccess(e){};i=i||function _onFailure(){};var n=new XMLHttpRequest;n.open("GET",e,true);n.overrideMimeType&&n.overrideMimeType("text/plain; charset=utf-8");n.onreadystatechange=function(){4==n.readyState&&(200==n.status||0===n.status?t(n.responseText):i())};n.onerror=i;n.ontimeout=i;try{n.send(null)}catch(e){i()}}function parseResource(e,t,i,a){var o=e.replace(/[^\/]*$/,"")||"./";function evalString(e){return e.lastIndexOf("\\")<0?e:e.replace(/\\\\/g,"\\").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\b/g,"\b").replace(/\\f/g,"\f").replace(/\\{/g,"{").replace(/\\}/g,"}").replace(/\\"/g,'"').replace(/\\'/g,"'")}xhrLoadText(e,(function(e){s+=e;!function parseProperties(e,i){var n={},s=/^\s*|\s*$/,r=/^\s*#|^\s*$/,a=/^\s*\[(.*)\]\s*$/,l=/^\s*@import\s+url\((.*)\)\s*$/i,c=/^([^=\s]*)\s*=\s*(.+)$/;function parseRawLines(e,i,h){var d=e.replace(s,"").split(/[\r\n]+/),u="*",p=t.split("-",1)[0],g=!1,f="";!function nextEntry(){for(;;){if(!d.length){h();return}var e=d.shift();if(!r.test(e)){if(i){if(f=a.exec(e)){u=f[1].toLowerCase();g="*"!==u&&u!==t&&u!==p;continue}if(g)continue;if(f=l.exec(e)){loadImport(o+f[1],nextEntry);return}}var s=e.match(c);s&&3==s.length&&(n[s[1]]=evalString(s[2]))}}}()}function loadImport(e,t){xhrLoadText(e,(function(e){parseRawLines(e,!1,t)}),(function(){console.warn(e+" not found.");t()}))}parseRawLines(e,!0,(function(){i(n)}))}(e,(function(e){for(var t in e){var s,a,o=t.lastIndexOf(".");if(o>0){s=t.substring(0,o);a=t.substring(o+1)}else{s=t;a=r}n[s]||(n[s]={});n[s][a]=e[t]}i&&i()}))}),a)}function loadLocale(e,i){e&&(e=e.toLowerCase());i=i||function _callback(){};!function clear(){n={};s="";a=""}();a=e;var r=function getL10nResourceLinks(){return t.querySelectorAll('link[type="application/l10n"]')}(),o=r.length;if(0!==o){var c,h=0;c=function(){if(++h>=o){i();l="complete"}};for(var d=0;d<o;d++){new L10nResourceLink(r[d]).load(e,c)}}else{var u=function getL10nDictionary(){var e=t.querySelector('script[type="application/l10n"]');return e?JSON.parse(e.innerHTML):null}();if(u&&u.locales&&u.default_locale){console.log("using the embedded JSON directory, early way out");if(!(n=u.locales[e])){var p=u.default_locale.toLowerCase();for(var g in u.locales){if((g=g.toLowerCase())===e){n=u.locales[e];break}g===p&&(n=u.locales[p])}}i()}else console.log("no resource to load, early way out");l="complete"}function L10nResourceLink(e){var t=e.href;this.load=function(e,i){parseResource(t,e,i,(function(){console.warn(t+" not found.");console.warn('"'+e+'" resource not found');a="";i()}))}}}o.plural=function(e,t,i,s){var l=parseFloat(t);if(isNaN(l))return e;if(s!=r)return e;o._pluralRules||(o._pluralRules=function getPluralRules(e){function isIn(e,t){return-1!==t.indexOf(e)}function isBetween(e,t,i){return t<=e&&e<=i}var t={0:function(e){return"other"},1:function(e){return isBetween(e%100,3,10)?"few":0===e?"zero":isBetween(e%100,11,99)?"many":2==e?"two":1==e?"one":"other"},2:function(e){return 0!==e&&e%10==0?"many":2==e?"two":1==e?"one":"other"},3:function(e){return 1==e?"one":"other"},4:function(e){return isBetween(e,0,1)?"one":"other"},5:function(e){return isBetween(e,0,2)&&2!=e?"one":"other"},6:function(e){return 0===e?"zero":e%10==1&&e%100!=11?"one":"other"},7:function(e){return 2==e?"two":1==e?"one":"other"},8:function(e){return isBetween(e,3,6)?"few":isBetween(e,7,10)?"many":2==e?"two":1==e?"one":"other"},9:function(e){return 0===e||1!=e&&isBetween(e%100,1,19)?"few":1==e?"one":"other"},10:function(e){return isBetween(e%10,2,9)&&!isBetween(e%100,11,19)?"few":e%10!=1||isBetween(e%100,11,19)?"other":"one"},11:function(e){return isBetween(e%10,2,4)&&!isBetween(e%100,12,14)?"few":e%10==0||isBetween(e%10,5,9)||isBetween(e%100,11,14)?"many":e%10==1&&e%100!=11?"one":"other"},12:function(e){return isBetween(e,2,4)?"few":1==e?"one":"other"},13:function(e){return isBetween(e%10,2,4)&&!isBetween(e%100,12,14)?"few":1!=e&&isBetween(e%10,0,1)||isBetween(e%10,5,9)||isBetween(e%100,12,14)?"many":1==e?"one":"other"},14:function(e){return isBetween(e%100,3,4)?"few":e%100==2?"two":e%100==1?"one":"other"},15:function(e){return 0===e||isBetween(e%100,2,10)?"few":isBetween(e%100,11,19)?"many":1==e?"one":"other"},16:function(e){return e%10==1&&11!=e?"one":"other"},17:function(e){return 3==e?"few":0===e?"zero":6==e?"many":2==e?"two":1==e?"one":"other"},18:function(e){return 0===e?"zero":isBetween(e,0,2)&&0!==e&&2!=e?"one":"other"},19:function(e){return isBetween(e,2,10)?"few":isBetween(e,0,1)?"one":"other"},20:function(e){return!isBetween(e%10,3,4)&&e%10!=9||isBetween(e%100,10,19)||isBetween(e%100,70,79)||isBetween(e%100,90,99)?e%1e6==0&&0!==e?"many":e%10!=2||isIn(e%100,[12,72,92])?e%10!=1||isIn(e%100,[11,71,91])?"other":"one":"two":"few"},21:function(e){return 0===e?"zero":1==e?"one":"other"},22:function(e){return isBetween(e,0,1)||isBetween(e,11,99)?"one":"other"},23:function(e){return isBetween(e%10,1,2)||e%20==0?"one":"other"},24:function(e){return isBetween(e,3,10)||isBetween(e,13,19)?"few":isIn(e,[2,12])?"two":isIn(e,[1,11])?"one":"other"}},i={af:3,ak:4,am:4,ar:1,asa:3,az:0,be:11,bem:3,bez:3,bg:3,bh:4,bm:0,bn:3,bo:0,br:20,brx:3,bs:11,ca:3,cgg:3,chr:3,cs:12,cy:17,da:3,de:3,dv:3,dz:0,ee:3,el:3,en:3,eo:3,es:3,et:3,eu:3,fa:0,ff:5,fi:3,fil:4,fo:3,fr:5,fur:3,fy:3,ga:8,gd:24,gl:3,gsw:3,gu:3,guw:4,gv:23,ha:3,haw:3,he:2,hi:4,hr:11,hu:0,id:0,ig:0,ii:0,is:3,it:3,iu:7,ja:0,jmc:3,jv:0,ka:0,kab:5,kaj:3,kcg:3,kde:0,kea:0,kk:3,kl:3,km:0,kn:0,ko:0,ksb:3,ksh:21,ku:3,kw:7,lag:18,lb:3,lg:3,ln:4,lo:0,lt:10,lv:6,mas:3,mg:4,mk:16,ml:3,mn:3,mo:9,mr:3,ms:0,mt:15,my:0,nah:3,naq:7,nb:3,nd:3,ne:3,nl:3,nn:3,no:3,nr:3,nso:4,ny:3,nyn:3,om:3,or:3,pa:3,pap:3,pl:13,ps:3,pt:3,rm:3,ro:9,rof:3,ru:11,rwk:3,sah:0,saq:3,se:7,seh:3,ses:0,sg:0,sh:11,shi:19,sk:12,sl:14,sma:7,smi:7,smj:7,smn:7,sms:7,sn:3,so:3,sq:3,sr:11,ss:3,ssy:3,st:3,sv:3,sw:3,syr:3,ta:3,te:3,teo:3,th:0,ti:4,tig:3,tk:3,tl:4,tn:3,to:0,tr:0,ts:3,tzm:22,uk:11,ur:3,ve:3,vi:0,vun:3,wa:4,wae:3,wo:0,xh:3,xog:3,yo:0,zh:0,zu:3}[e.replace(/-.*$/,"")];if(!(i in t)){console.warn("plural form unknown for ["+e+"]");return function(){return"other"}}return t[i]}(a));var c="["+o._pluralRules(l)+"]";0===l&&i+"[zero]"in n?e=n[i+"[zero]"][s]:1==l&&i+"[one]"in n?e=n[i+"[one]"][s]:2==l&&i+"[two]"in n?e=n[i+"[two]"][s]:i+c in n?e=n[i+c][s]:i+"[other]"in n&&(e=n[i+"[other]"][s]);return e};function getL10nData(e,t,i){var s=n[e];if(!s){console.warn("#"+e+" is undefined.");if(!i)return null;s=i}var r={};for(var a in s){var o=s[a];o=substArguments(o=substIndexes(o,t,e,a),t,e);r[a]=o}return r}function substIndexes(e,t,i,s){var r=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/.exec(e);if(!r||!r.length)return e;var a,l=r[1],c=r[2];t&&c in t?a=t[c]:c in n&&(a=n[c]);if(l in o){e=(0,o[l])(e,a,i,s)}return e}function substArguments(e,t,i){return e.replace(/\{\{\s*(.+?)\s*\}\}/g,(function(e,s){if(t&&s in t)return t[s];if(s in n)return n[s];console.log("argument {{"+s+"}} for #"+i+" is undefined.");return e}))}function translateElement(e){var i=function getL10nAttributes(e){if(!e)return{};var t=e.getAttribute("data-l10n-id"),i=e.getAttribute("data-l10n-args"),n={};if(i)try{n=JSON.parse(i)}catch(e){console.warn("could not parse arguments for #"+t)}return{id:t,args:n}}(e);if(i.id){var n=getL10nData(i.id,i.args);if(n){if(n[r]){if(0===function getChildElementCount(e){if(e.children)return e.children.length;if(void 0!==e.childElementCount)return e.childElementCount;for(var t=0,i=0;i<e.childNodes.length;i++)t+=1===e.nodeType?1:0;return t}(e))e[r]=n[r];else{for(var s=e.childNodes,a=!1,o=0,l=s.length;o<l;o++)if(3===s[o].nodeType&&/\S/.test(s[o].nodeValue))if(a)s[o].nodeValue="";else{s[o].nodeValue=n[r];a=!0}if(!a){var c=t.createTextNode(n[r]);e.insertBefore(c,e.firstChild)}}delete n[r]}for(var h in n)e[h]=n[h]}else console.warn("#"+i.id+" is undefined.")}}return{get:function(e,t,i){var n,s=e.lastIndexOf("."),a=r;if(s>0){a=e.substring(s+1);e=e.substring(0,s)}i&&((n={})[a]=i);var o=getL10nData(e,t,n);return o&&a in o?o[a]:"{{"+e+"}}"},getData:function(){return n},getText:function(){return s},getLanguage:function(){return a},setLanguage:function(e,t){loadLocale(e,(function(){t&&t()}))},getDirection:function(){var e=a.split("-",1)[0];return["ar","he","fa","ps","ur"].indexOf(e)>=0?"rtl":"ltr"},translate:function translateFragment(e){for(var i=function getTranslatableChildren(e){return e?e.querySelectorAll("*[data-l10n-id]"):[]}(e=e||t.documentElement),n=i.length,s=0;s<n;s++)translateElement(i[s]);translateElement(e)},getReadyState:function(){return l},ready:function(i){i&&("complete"==l||"interactive"==l?e.setTimeout((function(){i()})):t.addEventListener&&t.addEventListener("localized",(function once(){t.removeEventListener("localized",once);i()})))}}}(window,document)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GenericScripting=void 0;t.docPropertiesLookup=async function docPropertiesLookup(e){const t="".split("#")[0];let{info:i,metadata:s,contentDispositionFilename:r,contentLength:a}=await e.getMetadata();if(!a){const{length:t}=await e.getDownloadInfo();a=t}return{...i,baseURL:t,filesize:a,filename:r||(0,n.getPdfFilenameFromUrl)(""),metadata:s?.getRaw(),authors:s?.get("dc:creator"),numPages:e.numPages,URL:""}};var n=i(5);t.GenericScripting=class GenericScripting{constructor(e){this._ready=(0,n.loadScript)(e,!0).then((()=>window.pdfjsSandbox.QuickJSSandbox()))}async createSandbox(e){(await this._ready).create(e)}async dispatchEventInSandbox(e){(await this._ready).dispatchEvent(e)}async destroySandbox(){(await this._ready).nukeSandbox()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPrintService=PDFPrintService;var n=i(5),s=i(2),r=i(1),a=i(46);let o=null,l=null;function PDFPrintService(e,t,i,n,s=null,r){this.pdfDocument=e;this.pagesOverview=t;this.printContainer=i;this._printResolution=n||150;this._optionalContentConfigPromise=s||e.getOptionalContentConfig();this.l10n=r;this.currentPage=-1;this.scratchCanvas=document.createElement("canvas")}PDFPrintService.prototype={layout(){this.throwIfInactive();const e=document.querySelector("body");e.setAttribute("data-pdfjsprinting",!0);this.pagesOverview.every((function(e){return e.width===this.pagesOverview[0].width&&e.height===this.pagesOverview[0].height}),this)||console.warn("Not all pages have the same size. The printed result may be incorrect!");this.pageStyleSheet=document.createElement("style");const t=this.pagesOverview[0];this.pageStyleSheet.textContent="@page { size: "+t.width+"pt "+t.height+"pt;}";e.appendChild(this.pageStyleSheet)},destroy(){if(o!==this)return;this.printContainer.textContent="";document.querySelector("body").removeAttribute("data-pdfjsprinting");if(this.pageStyleSheet){this.pageStyleSheet.remove();this.pageStyleSheet=null}this.scratchCanvas.width=this.scratchCanvas.height=0;this.scratchCanvas=null;o=null;ensureOverlay().then((function(){"printServiceOverlay"===l.active&&l.close("printServiceOverlay")}))},renderPages(){if(this.pdfDocument.isPureXfa){(0,a.getXfaHtmlForPrinting)(this.printContainer,this.pdfDocument);return Promise.resolve()}const e=this.pagesOverview.length,renderNextPage=(t,i)=>{this.throwIfInactive();if(++this.currentPage>=e){renderProgress(e,e,this.l10n);t();return}const s=this.currentPage;renderProgress(s,e,this.l10n);(function renderPage(e,t,i,s,r,a){const l=o.scratchCanvas,c=r/n.PixelsPerInch.PDF;l.width=Math.floor(s.width*c);l.height=Math.floor(s.height*c);const h=l.getContext("2d");h.save();h.fillStyle="rgb(255, 255, 255)";h.fillRect(0,0,l.width,l.height);h.restore();return t.getPage(i).then((function(e){const t={canvasContext:h,transform:[c,0,0,c,0,0],viewport:e.getViewport({scale:1,rotation:s.rotation}),intent:"print",annotationMode:n.AnnotationMode.ENABLE_STORAGE,optionalContentConfigPromise:a};return e.render(t).promise}))})(0,this.pdfDocument,s+1,this.pagesOverview[s],this._printResolution,this._optionalContentConfigPromise).then(this.useRenderedPage.bind(this)).then((function(){renderNextPage(t,i)}),i)};return new Promise(renderNextPage)},useRenderedPage(){this.throwIfInactive();const e=document.createElement("img"),t=this.scratchCanvas;"toBlob"in t&&!r.compatibilityParams.disableCreateObjectURL?t.toBlob((function(t){e.src=URL.createObjectURL(t)})):e.src=t.toDataURL();const i=document.createElement("div");i.className="printedPage";i.appendChild(e);this.printContainer.appendChild(i);return new Promise((function(t,i){e.onload=t;e.onerror=i}))},performPrint(){this.throwIfInactive();return new Promise((e=>{setTimeout((()=>{if(this.active){c.call(window);setTimeout(e,20)}else e()}),0)}))},get active(){return this===o},throwIfInactive(){if(!this.active)throw new Error("This print request was cancelled or completed.")}};const c=window.print;window.print=function(){if(o)console.warn("Ignored window.print() because of a pending print job.");else{ensureOverlay().then((function(){o&&l.open("printServiceOverlay")}));try{dispatchEvent("beforeprint")}finally{if(!o){console.error("Expected print service to be initialized.");ensureOverlay().then((function(){"printServiceOverlay"===l.active&&l.close("printServiceOverlay")}));return}const e=o;o.renderPages().then((function(){return e.performPrint()})).catch((function(){})).then((function(){e.active&&abort()}))}}};function dispatchEvent(e){const t=document.createEvent("CustomEvent");t.initCustomEvent(e,!1,!1,"custom");window.dispatchEvent(t)}function abort(){if(o){o.destroy();dispatchEvent("afterprint")}}function renderProgress(e,t,i){const n=document.getElementById("printServiceOverlay"),s=Math.round(100*e/t),r=n.querySelector("progress"),a=n.querySelector(".relative-progress");r.value=s;i.get("print_progress_percent",{progress:s}).then((e=>{a.textContent=e}))}window.addEventListener("keydown",(function(e){if(80===e.keyCode&&(e.ctrlKey||e.metaKey)&&!e.altKey&&(!e.shiftKey||window.chrome||window.opera)){window.print();e.preventDefault();e.stopImmediatePropagation?e.stopImmediatePropagation():e.stopPropagation()}}),!0);if("onbeforeprint"in window){const stopPropagationIfNeeded=function(e){"custom"!==e.detail&&e.stopImmediatePropagation&&e.stopImmediatePropagation()};window.addEventListener("beforeprint",stopPropagationIfNeeded);window.addEventListener("afterprint",stopPropagationIfNeeded)}let h;function ensureOverlay(){if(!h){l=s.PDFViewerApplication.overlayManager;if(!l)throw new Error("The overlay manager has not yet been initialized.");h=l.register("printServiceOverlay",document.getElementById("printServiceOverlay"),abort,!0);document.getElementById("printCancel").onclick=abort}return h}s.PDFPrintServiceFactory.instance={supportsPrinting:!0,createPrintService(e,t,i,n,s,r){if(o)throw new Error("The print service is created and active.");o=new PDFPrintService(e,t,i,n,s,r);return o}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getXfaHtmlForPrinting=function getXfaHtmlForPrinting(e,t){const i=t.allXfaHtml,a=new s.SimpleLinkService,o=Math.round(100*n.PixelsPerInch.PDF_TO_CSS_UNITS)/100;for(const s of i.children){const i=document.createElement("div");i.className="xfaPrintedPage";e.appendChild(i);const l=new r.XfaLayerBuilder({pageDiv:i,pdfPage:null,annotationStorage:t.annotationStorage,linkService:a,xfaHtml:s}),c=(0,n.getXfaPageViewport)(s,{scale:o});l.render(c,"print")}};var n=i(5),s=i(18),r=i(35)}],t={};function __webpack_require__(i){var n=t[i];if(void 0!==n)return n.exports;var s=t[i]={exports:{}};e[i](s,s.exports,__webpack_require__);return s.exports}var i={};(()=>{var e=i;Object.defineProperty(e,"__esModule",{value:!0});Object.defineProperty(e,"PDFViewerApplication",{enumerable:!0,get:function(){return n.PDFViewerApplication}});Object.defineProperty(e,"PDFViewerApplicationOptions",{enumerable:!0,get:function(){return t.AppOptions}});var t=__webpack_require__(1),n=__webpack_require__(2);window.PDFViewerApplication=n.PDFViewerApplication;window.PDFViewerApplicationOptions=t.AppOptions;__webpack_require__(39);__webpack_require__(45);function webViewerLoad(){const e=function getViewerConfiguration(){let e=null;e={container:document.getElementById("errorWrapper"),errorMessage:document.getElementById("errorMessage"),closeButton:document.getElementById("errorClose"),errorMoreInfo:document.getElementById("errorMoreInfo"),moreInfoButton:document.getElementById("errorShowMore"),lessInfoButton:document.getElementById("errorShowLess")};return{appContainer:document.body,mainContainer:document.getElementById("viewerContainer"),viewerContainer:document.getElementById("viewer"),eventBus:null,toolbar:{container:document.getElementById("toolbarViewer"),numPages:document.getElementById("numPages"),pageNumber:document.getElementById("pageNumber"),scaleSelect:document.getElementById("scaleSelect"),customScaleOption:document.getElementById("customScaleOption"),previous:document.getElementById("previous"),next:document.getElementById("next"),zoomIn:document.getElementById("zoomIn"),zoomOut:document.getElementById("zoomOut"),viewFind:document.getElementById("viewFind"),openFile:document.getElementById("openFile"),print:document.getElementById("print"),presentationModeButton:document.getElementById("presentationMode"),download:document.getElementById("download"),viewBookmark:document.getElementById("viewBookmark")},secondaryToolbar:{toolbar:document.getElementById("secondaryToolbar"),toggleButton:document.getElementById("secondaryToolbarToggle"),toolbarButtonContainer:document.getElementById("secondaryToolbarButtonContainer"),presentationModeButton:document.getElementById("secondaryPresentationMode"),openFileButton:document.getElementById("secondaryOpenFile"),printButton:document.getElementById("secondaryPrint"),downloadButton:document.getElementById("secondaryDownload"),viewBookmarkButton:document.getElementById("secondaryViewBookmark"),firstPageButton:document.getElementById("firstPage"),lastPageButton:document.getElementById("lastPage"),pageRotateCwButton:document.getElementById("pageRotateCw"),pageRotateCcwButton:document.getElementById("pageRotateCcw"),cursorSelectToolButton:document.getElementById("cursorSelectTool"),cursorHandToolButton:document.getElementById("cursorHandTool"),scrollPageButton:document.getElementById("scrollPage"),scrollVerticalButton:document.getElementById("scrollVertical"),scrollHorizontalButton:document.getElementById("scrollHorizontal"),scrollWrappedButton:document.getElementById("scrollWrapped"),spreadNoneButton:document.getElementById("spreadNone"),spreadOddButton:document.getElementById("spreadOdd"),spreadEvenButton:document.getElementById("spreadEven"),documentPropertiesButton:document.getElementById("documentProperties")},sidebar:{outerContainer:document.getElementById("outerContainer"),viewerContainer:document.getElementById("viewerContainer"),toggleButton:document.getElementById("sidebarToggle"),thumbnailButton:document.getElementById("viewThumbnail"),outlineButton:document.getElementById("viewOutline"),attachmentsButton:document.getElementById("viewAttachments"),layersButton:document.getElementById("viewLayers"),thumbnailView:document.getElementById("thumbnailView"),outlineView:document.getElementById("outlineView"),attachmentsView:document.getElementById("attachmentsView"),layersView:document.getElementById("layersView"),outlineOptionsContainer:document.getElementById("outlineOptionsContainer"),currentOutlineItemButton:document.getElementById("currentOutlineItem")},sidebarResizer:{outerContainer:document.getElementById("outerContainer"),resizer:document.getElementById("sidebarResizer")},findBar:{bar:document.getElementById("findbar"),toggleButton:document.getElementById("viewFind"),findField:document.getElementById("findInput"),highlightAllCheckbox:document.getElementById("findHighlightAll"),caseSensitiveCheckbox:document.getElementById("findMatchCase"),entireWordCheckbox:document.getElementById("findEntireWord"),findMsg:document.getElementById("findMsg"),findResultsCount:document.getElementById("findResultsCount"),findPreviousButton:document.getElementById("findPrevious"),findNextButton:document.getElementById("findNext")},passwordOverlay:{overlayName:"passwordOverlay",container:document.getElementById("passwordOverlay"),label:document.getElementById("passwordText"),input:document.getElementById("password"),submitButton:document.getElementById("passwordSubmit"),cancelButton:document.getElementById("passwordCancel")},documentProperties:{overlayName:"documentPropertiesOverlay",container:document.getElementById("documentPropertiesOverlay"),closeButton:document.getElementById("documentPropertiesClose"),fields:{fileName:document.getElementById("fileNameField"),fileSize:document.getElementById("fileSizeField"),title:document.getElementById("titleField"),author:document.getElementById("authorField"),subject:document.getElementById("subjectField"),keywords:document.getElementById("keywordsField"),creationDate:document.getElementById("creationDateField"),modificationDate:document.getElementById("modificationDateField"),creator:document.getElementById("creatorField"),producer:document.getElementById("producerField"),version:document.getElementById("versionField"),pageCount:document.getElementById("pageCountField"),pageSize:document.getElementById("pageSizeField"),linearized:document.getElementById("linearizedField")}},errorWrapper:e,printContainer:document.getElementById("printContainer"),openFileInputName:"fileInput",debuggerScriptPath:"./debugger.js"}}(),t=document.createEvent("CustomEvent");t.initCustomEvent("webviewerloaded",!0,!0,{source:window});try{parent.document.dispatchEvent(t)}catch(e){console.error(`webviewerloaded: ${e}`);document.dispatchEvent(t)}n.PDFViewerApplication.run(e)}document.blockUnblockOnload&&document.blockUnblockOnload(!0);"interactive"===document.readyState||"complete"===document.readyState?webViewerLoad():document.addEventListener("DOMContentLoaded",webViewerLoad,!0)})()})();