/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!function webpackUniversalModuleDefinition(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf",[],t):"object"==typeof exports?exports["pdfjs-dist/build/pdf"]=t():e["pdfjs-dist/build/pdf"]=e.pdfjsLib=t()}(this,(function(){return(()=>{"use strict";var __webpack_modules__=[,(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.addLinkAttributes=function addLinkAttributes(e,{url:t,target:i,rel:r,enabled:o=!0}={}){(0,n.assert)(t&&"string"==typeof t,'addLinkAttributes: A valid "url" parameter must provided.');const l=(0,n.removeNullCharacters)(t);if(o)e.href=e.title=l;else{e.href="";e.title=`Disabled: ${l}`;e.onclick=()=>!1}let c="";switch(i){case a.NONE:break;case a.SELF:c="_self";break;case a.BLANK:c="_blank";break;case a.PARENT:c="_parent";break;case a.TOP:c="_top"}e.target=c;e.rel="string"==typeof r?r:s};t.deprecated=function deprecated(e){console.log("Deprecated API usage: "+e)};t.getFilenameFromUrl=function getFilenameFromUrl(e){const t=e.indexOf("#"),i=e.indexOf("?"),n=Math.min(t>0?t:e.length,i>0?i:e.length);return e.substring(e.lastIndexOf("/",n)+1,n)};t.getPdfFilenameFromUrl=function getPdfFilenameFromUrl(e,t="document.pdf"){if("string"!=typeof e)return t;if(isDataScheme(e)){(0,n.warn)('getPdfFilenameFromUrl: ignore "data:"-URL for performance reasons.');return t}const i=/[^/?#=]+\.pdf\b(?!.*\.pdf\b)/i,s=/^(?:(?:[^:]+:)?\/\/[^/]+)?([^?#]*)(\?[^#]*)?(#.*)?$/.exec(e);let r=i.exec(s[1])||i.exec(s[2])||i.exec(s[3]);if(r){r=r[0];if(r.includes("%"))try{r=i.exec(decodeURIComponent(r))[0]}catch(e){}}return r||t};t.isDataScheme=isDataScheme;t.isFetchSupported=isFetchSupported;t.isPdfFile=function isPdfFile(e){return"string"==typeof e&&/\.pdf$/i.test(e)};t.isValidFetchUrl=isValidFetchUrl;t.loadScript=function loadScript(e,t=!1){return new Promise(((i,n)=>{const s=document.createElement("script");s.src=e;s.onload=function(e){t&&s.remove();i(e)};s.onerror=function(){n(new Error(`Cannot load script at: ${s.src}`))};(document.head||document.documentElement).appendChild(s)}))};t.StatTimer=t.RenderingCancelledException=t.PDFDateString=t.PageViewport=t.LinkTarget=t.DOMSVGFactory=t.DOMCMapReaderFactory=t.DOMCanvasFactory=t.DEFAULT_LINK_REL=t.BaseCMapReaderFactory=t.BaseCanvasFactory=void 0;var n=i(2);const s="noopener noreferrer nofollow";t.DEFAULT_LINK_REL=s;const r="http://www.w3.org/2000/svg";class BaseCanvasFactory{constructor(){this.constructor===BaseCanvasFactory&&(0,n.unreachable)("Cannot initialize BaseCanvasFactory.")}create(e,t){(0,n.unreachable)("Abstract method `create` called.")}reset(e,t,i){if(!e.canvas)throw new Error("Canvas is not specified");if(t<=0||i<=0)throw new Error("Invalid canvas size");e.canvas.width=t;e.canvas.height=i}destroy(e){if(!e.canvas)throw new Error("Canvas is not specified");e.canvas.width=0;e.canvas.height=0;e.canvas=null;e.context=null}}t.BaseCanvasFactory=BaseCanvasFactory;t.DOMCanvasFactory=class DOMCanvasFactory extends BaseCanvasFactory{constructor({ownerDocument:e=globalThis.document}={}){super();this._document=e}create(e,t){if(e<=0||t<=0)throw new Error("Invalid canvas size");const i=this._document.createElement("canvas"),n=i.getContext("2d");i.width=e;i.height=t;return{canvas:i,context:n}}};class BaseCMapReaderFactory{constructor({baseUrl:e=null,isCompressed:t=!1}){this.constructor===BaseCMapReaderFactory&&(0,n.unreachable)("Cannot initialize BaseCMapReaderFactory.");this.baseUrl=e;this.isCompressed=t}async fetch({name:e}){if(!this.baseUrl)throw new Error('The CMap "baseUrl" parameter must be specified, ensure that the "cMapUrl" and "cMapPacked" API parameters are provided.');if(!e)throw new Error("CMap name must be specified.");const t=this.baseUrl+e+(this.isCompressed?".bcmap":""),i=this.isCompressed?n.CMapCompressionType.BINARY:n.CMapCompressionType.NONE;return this._fetchData(t,i).catch((e=>{throw new Error(`Unable to load ${this.isCompressed?"binary ":""}CMap at: ${t}`)}))}_fetchData(e,t){(0,n.unreachable)("Abstract method `_fetchData` called.")}}t.BaseCMapReaderFactory=BaseCMapReaderFactory;t.DOMCMapReaderFactory=class DOMCMapReaderFactory extends BaseCMapReaderFactory{_fetchData(e,t){return isFetchSupported()&&isValidFetchUrl(e,document.baseURI)?fetch(e).then((async e=>{if(!e.ok)throw new Error(e.statusText);let i;i=this.isCompressed?new Uint8Array(await e.arrayBuffer()):(0,n.stringToBytes)(await e.text());return{cMapData:i,compressionType:t}})):new Promise(((i,s)=>{const r=new XMLHttpRequest;r.open("GET",e,!0);this.isCompressed&&(r.responseType="arraybuffer");r.onreadystatechange=()=>{if(r.readyState===XMLHttpRequest.DONE){if(200===r.status||0===r.status){let e;this.isCompressed&&r.response?e=new Uint8Array(r.response):!this.isCompressed&&r.responseText&&(e=(0,n.stringToBytes)(r.responseText));if(e){i({cMapData:e,compressionType:t});return}}s(new Error(r.statusText))}};r.send(null)}))}};t.DOMSVGFactory=class DOMSVGFactory{create(e,t){(0,n.assert)(e>0&&t>0,"Invalid SVG dimensions");const i=document.createElementNS(r,"svg:svg");i.setAttribute("version","1.1");i.setAttribute("width",e+"px");i.setAttribute("height",t+"px");i.setAttribute("preserveAspectRatio","none");i.setAttribute("viewBox","0 0 "+e+" "+t);return i}createElement(e){(0,n.assert)("string"==typeof e,"Invalid SVG element type");return document.createElementNS(r,e)}};class PageViewport{constructor({viewBox:e,scale:t,rotation:i,offsetX:n=0,offsetY:s=0,dontFlip:r=!1}){this.viewBox=e;this.scale=t;this.rotation=i;this.offsetX=n;this.offsetY=s;const a=(e[2]+e[0])/2,o=(e[3]+e[1])/2;let l,c,h,d,u,p,g,f;(i%=360)<0&&(i+=360);switch(i){case 180:l=-1;c=0;h=0;d=1;break;case 90:l=0;c=1;h=1;d=0;break;case 270:l=0;c=-1;h=-1;d=0;break;case 0:l=1;c=0;h=0;d=-1;break;default:throw new Error("PageViewport: Invalid rotation, must be a multiple of 90 degrees.")}if(r){h=-h;d=-d}if(0===l){u=Math.abs(o-e[1])*t+n;p=Math.abs(a-e[0])*t+s;g=Math.abs(e[3]-e[1])*t;f=Math.abs(e[2]-e[0])*t}else{u=Math.abs(a-e[0])*t+n;p=Math.abs(o-e[1])*t+s;g=Math.abs(e[2]-e[0])*t;f=Math.abs(e[3]-e[1])*t}this.transform=[l*t,c*t,h*t,d*t,u-l*t*a-h*t*o,p-c*t*a-d*t*o];this.width=g;this.height=f}clone({scale:e=this.scale,rotation:t=this.rotation,offsetX:i=this.offsetX,offsetY:n=this.offsetY,dontFlip:s=!1}={}){return new PageViewport({viewBox:this.viewBox.slice(),scale:e,rotation:t,offsetX:i,offsetY:n,dontFlip:s})}convertToViewportPoint(e,t){return n.Util.applyTransform([e,t],this.transform)}convertToViewportRectangle(e){const t=n.Util.applyTransform([e[0],e[1]],this.transform),i=n.Util.applyTransform([e[2],e[3]],this.transform);return[t[0],t[1],i[0],i[1]]}convertToPdfPoint(e,t){return n.Util.applyInverseTransform([e,t],this.transform)}}t.PageViewport=PageViewport;class RenderingCancelledException extends n.BaseException{constructor(e,t){super(e);this.type=t}}t.RenderingCancelledException=RenderingCancelledException;const a={NONE:0,SELF:1,BLANK:2,PARENT:3,TOP:4};t.LinkTarget=a;function isDataScheme(e){const t=e.length;let i=0;for(;i<t&&""===e[i].trim();)i++;return"data:"===e.substring(i,i+5).toLowerCase()}t.StatTimer=class StatTimer{constructor(){this.started=Object.create(null);this.times=[]}time(e){e in this.started&&(0,n.warn)(`Timer is already running for ${e}`);this.started[e]=Date.now()}timeEnd(e){e in this.started||(0,n.warn)(`Timer has not been started for ${e}`);this.times.push({name:e,start:this.started[e],end:Date.now()});delete this.started[e]}toString(){const e=[];let t=0;for(const e of this.times){const i=e.name;i.length>t&&(t=i.length)}for(const i of this.times){const n=i.end-i.start;e.push(`${i.name.padEnd(t)} ${n}ms\n`)}return e.join("")}};function isFetchSupported(){return"undefined"!=typeof fetch&&"undefined"!=typeof Response&&"body"in Response.prototype&&"undefined"!=typeof ReadableStream}function isValidFetchUrl(e,t){try{const{protocol:i}=t?new URL(e,t):new URL(e);return"http:"===i||"https:"===i}catch(e){return!1}}let o;t.PDFDateString=class PDFDateString{static toDateObject(e){if(!e||!(0,n.isString)(e))return null;o||(o=new RegExp("^D:(\\d{4})(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?(\\d{2})?([Z|+|-])?(\\d{2})?'?(\\d{2})?'?"));const t=o.exec(e);if(!t)return null;const i=parseInt(t[1],10);let s=parseInt(t[2],10);s=s>=1&&s<=12?s-1:0;let r=parseInt(t[3],10);r=r>=1&&r<=31?r:1;let a=parseInt(t[4],10);a=a>=0&&a<=23?a:0;let l=parseInt(t[5],10);l=l>=0&&l<=59?l:0;let c=parseInt(t[6],10);c=c>=0&&c<=59?c:0;const h=t[7]||"Z";let d=parseInt(t[8],10);d=d>=0&&d<=23?d:0;let u=parseInt(t[9],10)||0;u=u>=0&&u<=59?u:0;if("-"===h){a+=d;l+=u}else if("+"===h){a-=d;l-=u}return new Date(Date.UTC(i,s,r,a,l,c))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.arrayByteLength=arrayByteLength;t.arraysToBytes=function arraysToBytes(e){const t=e.length;if(1===t&&e[0]instanceof Uint8Array)return e[0];let i=0;for(let n=0;n<t;n++)i+=arrayByteLength(e[n]);let n=0;const s=new Uint8Array(i);for(let i=0;i<t;i++){let t=e[i];t instanceof Uint8Array||(t="string"==typeof t?stringToBytes(t):new Uint8Array(t));const r=t.byteLength;s.set(t,n);n+=r}return s};t.assert=assert;t.bytesToString=function bytesToString(e){assert(null!==e&&"object"==typeof e&&void 0!==e.length,"Invalid argument for bytesToString");const t=e.length,i=8192;if(t<i)return String.fromCharCode.apply(null,e);const n=[];for(let s=0;s<t;s+=i){const r=Math.min(s+i,t),a=e.subarray(s,r);n.push(String.fromCharCode.apply(null,a))}return n.join("")};t.createObjectURL=function createObjectURL(e,t="",i=!1){if(URL.createObjectURL&&!i)return URL.createObjectURL(new Blob([e],{type:t}));const n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";let s=`data:${t};base64,`;for(let t=0,i=e.length;t<i;t+=3){const r=255&e[t],a=255&e[t+1],o=255&e[t+2];s+=n[r>>2]+n[(3&r)<<4|a>>4]+n[t+1<i?(15&a)<<2|o>>6:64]+n[t+2<i?63&o:64]}return s};t.createPromiseCapability=function createPromiseCapability(){const e=Object.create(null);let t=!1;Object.defineProperty(e,"settled",{get:()=>t});e.promise=new Promise((function(i,n){e.resolve=function(e){t=!0;i(e)};e.reject=function(e){t=!0;n(e)}}));return e};t.createValidAbsoluteUrl=function createValidAbsoluteUrl(e,t){if(!e)return null;try{const i=t?new URL(e,t):new URL(e);if(function _isValidProtocol(e){if(!e)return!1;switch(e.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":return!0;default:return!1}}(i))return i}catch(e){}return null};t.escapeString=function escapeString(e){return e.replace(/([()\\\n\r])/g,(e=>"\n"===e?"\\n":"\r"===e?"\\r":`\\${e}`))};t.getModificationDate=function getModificationDate(e=new Date){return[e.getUTCFullYear().toString(),(e.getUTCMonth()+1).toString().padStart(2,"0"),e.getUTCDate().toString().padStart(2,"0"),e.getUTCHours().toString().padStart(2,"0"),e.getUTCMinutes().toString().padStart(2,"0"),e.getUTCSeconds().toString().padStart(2,"0")].join("")};t.getVerbosityLevel=function getVerbosityLevel(){return s};t.info=function info(e){s>=n.INFOS&&console.log(`Info: ${e}`)};t.isArrayBuffer=function isArrayBuffer(e){return"object"==typeof e&&null!==e&&void 0!==e.byteLength};t.isArrayEqual=function isArrayEqual(e,t){if(e.length!==t.length)return!1;for(let i=0,n=e.length;i<n;i++)if(e[i]!==t[i])return!1;return!0};t.isAscii=function isAscii(e){return/^[\x00-\x7F]*$/.test(e)};t.isBool=function isBool(e){return"boolean"==typeof e};t.isNum=function isNum(e){return"number"==typeof e};t.isSameOrigin=function isSameOrigin(e,t){let i;try{i=new URL(e);if(!i.origin||"null"===i.origin)return!1}catch(e){return!1}const n=new URL(t,i);return i.origin===n.origin};t.isString=function isString(e){return"string"==typeof e};t.objectFromMap=function objectFromMap(e){const t=Object.create(null);for(const[i,n]of e)t[i]=n;return t};t.objectSize=function objectSize(e){return Object.keys(e).length};t.removeNullCharacters=function removeNullCharacters(e){if("string"!=typeof e){warn("The argument for removeNullCharacters must be a string.");return e}return e.replace(a,"")};t.setVerbosityLevel=function setVerbosityLevel(e){Number.isInteger(e)&&(s=e)};t.shadow=shadow;t.string32=function string32(e){return String.fromCharCode(e>>24&255,e>>16&255,e>>8&255,255&e)};t.stringToBytes=stringToBytes;t.stringToPDFString=function stringToPDFString(e){const t=e.length,i=[];if("þ"===e[0]&&"ÿ"===e[1])for(let n=2;n<t;n+=2)i.push(String.fromCharCode(e.charCodeAt(n)<<8|e.charCodeAt(n+1)));else if("ÿ"===e[0]&&"þ"===e[1])for(let n=2;n<t;n+=2)i.push(String.fromCharCode(e.charCodeAt(n+1)<<8|e.charCodeAt(n)));else for(let n=0;n<t;++n){const t=h[e.charCodeAt(n)];i.push(t?String.fromCharCode(t):e.charAt(n))}return i.join("")};t.stringToUTF16BEString=function stringToUTF16BEString(e){const t=["þÿ"];for(let i=0,n=e.length;i<n;i++){const n=e.charCodeAt(i);t.push(String.fromCharCode(n>>8&255),String.fromCharCode(255&n))}return t.join("")};t.stringToUTF8String=function stringToUTF8String(e){return decodeURIComponent(escape(e))};t.unreachable=unreachable;t.utf8StringToString=function utf8StringToString(e){return unescape(encodeURIComponent(e))};t.warn=warn;t.VerbosityLevel=t.Util=t.UNSUPPORTED_FEATURES=t.UnknownErrorException=t.UnexpectedResponseException=t.TextRenderingMode=t.StreamType=t.PermissionFlag=t.PasswordResponses=t.PasswordException=t.PageActionEventType=t.OPS=t.MissingPDFException=t.IsLittleEndianCached=t.IsEvalSupportedCached=t.InvalidPDFException=t.ImageKind=t.IDENTITY_MATRIX=t.FormatError=t.FontType=t.FONT_IDENTITY_MATRIX=t.DocumentActionEventType=t.CMapCompressionType=t.BaseException=t.AnnotationType=t.AnnotationStateModelType=t.AnnotationReviewState=t.AnnotationReplyType=t.AnnotationMarkedState=t.AnnotationFlag=t.AnnotationFieldFlag=t.AnnotationBorderStyleType=t.AnnotationActionEventType=t.AbortException=void 0;i(3);t.IDENTITY_MATRIX=[1,0,0,1,0,0];t.FONT_IDENTITY_MATRIX=[.001,0,0,.001,0,0];t.PermissionFlag={PRINT:4,MODIFY_CONTENTS:8,COPY:16,MODIFY_ANNOTATIONS:32,FILL_INTERACTIVE_FORMS:256,COPY_FOR_ACCESSIBILITY:512,ASSEMBLE:1024,PRINT_HIGH_QUALITY:2048};t.TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};t.ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};t.AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};t.AnnotationStateModelType={MARKED:"Marked",REVIEW:"Review"};t.AnnotationMarkedState={MARKED:"Marked",UNMARKED:"Unmarked"};t.AnnotationReviewState={ACCEPTED:"Accepted",REJECTED:"Rejected",CANCELLED:"Cancelled",COMPLETED:"Completed",NONE:"None"};t.AnnotationReplyType={GROUP:"Group",REPLY:"R"};t.AnnotationFlag={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512};t.AnnotationFieldFlag={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864};t.AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};t.AnnotationActionEventType={E:"Mouse Enter",X:"Mouse Exit",D:"Mouse Down",U:"Mouse Up",Fo:"Focus",Bl:"Blur",PO:"PageOpen",PC:"PageClose",PV:"PageVisible",PI:"PageInvisible",K:"Keystroke",F:"Format",V:"Validate",C:"Calculate"};t.DocumentActionEventType={WC:"WillClose",WS:"WillSave",DS:"DidSave",WP:"WillPrint",DP:"DidPrint"};t.PageActionEventType={O:"PageOpen",C:"PageClose"};t.StreamType={UNKNOWN:"UNKNOWN",FLATE:"FLATE",LZW:"LZW",DCT:"DCT",JPX:"JPX",JBIG:"JBIG",A85:"A85",AHX:"AHX",CCF:"CCF",RLX:"RLX"};t.FontType={UNKNOWN:"UNKNOWN",TYPE1:"TYPE1",TYPE1C:"TYPE1C",CIDFONTTYPE0:"CIDFONTTYPE0",CIDFONTTYPE0C:"CIDFONTTYPE0C",TRUETYPE:"TRUETYPE",CIDFONTTYPE2:"CIDFONTTYPE2",TYPE3:"TYPE3",OPENTYPE:"OPENTYPE",TYPE0:"TYPE0",MMTYPE1:"MMTYPE1"};const n={ERRORS:0,WARNINGS:1,INFOS:5};t.VerbosityLevel=n;t.CMapCompressionType={NONE:0,BINARY:1,STREAM:2};t.OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};t.UNSUPPORTED_FEATURES={unknown:"unknown",forms:"forms",javaScript:"javaScript",signatures:"signatures",smask:"smask",shadingPattern:"shadingPattern",font:"font",errorTilingPattern:"errorTilingPattern",errorExtGState:"errorExtGState",errorXObject:"errorXObject",errorFontLoadType3:"errorFontLoadType3",errorFontState:"errorFontState",errorFontMissing:"errorFontMissing",errorFontTranslate:"errorFontTranslate",errorColorSpace:"errorColorSpace",errorOperatorList:"errorOperatorList",errorFontToUnicode:"errorFontToUnicode",errorFontLoadNative:"errorFontLoadNative",errorFontBuildPath:"errorFontBuildPath",errorFontGetPath:"errorFontGetPath",errorMarkedContent:"errorMarkedContent"};t.PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};let s=n.WARNINGS;function warn(e){s>=n.WARNINGS&&console.log(`Warning: ${e}`)}function unreachable(e){throw new Error(e)}function assert(e,t){e||unreachable(t)}function shadow(e,t,i){Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!1});return i}const r=function BaseExceptionClosure(){function BaseException(e){this.constructor===BaseException&&unreachable("Cannot initialize BaseException.");this.message=e;this.name=this.constructor.name}BaseException.prototype=new Error;BaseException.constructor=BaseException;return BaseException}();t.BaseException=r;t.PasswordException=class PasswordException extends r{constructor(e,t){super(e);this.code=t}};t.UnknownErrorException=class UnknownErrorException extends r{constructor(e,t){super(e);this.details=t}};t.InvalidPDFException=class InvalidPDFException extends r{};t.MissingPDFException=class MissingPDFException extends r{};t.UnexpectedResponseException=class UnexpectedResponseException extends r{constructor(e,t){super(e);this.status=t}};t.FormatError=class FormatError extends r{};t.AbortException=class AbortException extends r{};const a=/\x00/g;function stringToBytes(e){assert("string"==typeof e,"Invalid argument for stringToBytes");const t=e.length,i=new Uint8Array(t);for(let n=0;n<t;++n)i[n]=255&e.charCodeAt(n);return i}function arrayByteLength(e){if(void 0!==e.length)return e.length;assert(void 0!==e.byteLength,"arrayByteLength - invalid argument.");return e.byteLength}const o={get value(){return shadow(this,"value",function isLittleEndian(){const e=new Uint8Array(4);e[0]=1;return 1===new Uint32Array(e.buffer,0,1)[0]}())}};t.IsLittleEndianCached=o;const l={get value(){return shadow(this,"value",function isEvalSupported(){try{new Function("");return!0}catch(e){return!1}}())}};t.IsEvalSupportedCached=l;const c=[...Array(256).keys()].map((e=>e.toString(16).padStart(2,"0")));class Util{static makeHexColor(e,t,i){return`#${c[e]}${c[t]}${c[i]}`}static transform(e,t){return[e[0]*t[0]+e[2]*t[1],e[1]*t[0]+e[3]*t[1],e[0]*t[2]+e[2]*t[3],e[1]*t[2]+e[3]*t[3],e[0]*t[4]+e[2]*t[5]+e[4],e[1]*t[4]+e[3]*t[5]+e[5]]}static applyTransform(e,t){return[e[0]*t[0]+e[1]*t[2]+t[4],e[0]*t[1]+e[1]*t[3]+t[5]]}static applyInverseTransform(e,t){const i=t[0]*t[3]-t[1]*t[2];return[(e[0]*t[3]-e[1]*t[2]+t[2]*t[5]-t[4]*t[3])/i,(-e[0]*t[1]+e[1]*t[0]+t[4]*t[1]-t[5]*t[0])/i]}static getAxialAlignedBoundingBox(e,t){const i=Util.applyTransform(e,t),n=Util.applyTransform(e.slice(2,4),t),s=Util.applyTransform([e[0],e[3]],t),r=Util.applyTransform([e[2],e[1]],t);return[Math.min(i[0],n[0],s[0],r[0]),Math.min(i[1],n[1],s[1],r[1]),Math.max(i[0],n[0],s[0],r[0]),Math.max(i[1],n[1],s[1],r[1])]}static inverseTransform(e){const t=e[0]*e[3]-e[1]*e[2];return[e[3]/t,-e[1]/t,-e[2]/t,e[0]/t,(e[2]*e[5]-e[4]*e[3])/t,(e[4]*e[1]-e[5]*e[0])/t]}static apply3dTransform(e,t){return[e[0]*t[0]+e[1]*t[1]+e[2]*t[2],e[3]*t[0]+e[4]*t[1]+e[5]*t[2],e[6]*t[0]+e[7]*t[1]+e[8]*t[2]]}static singularValueDecompose2dScale(e){const t=[e[0],e[2],e[1],e[3]],i=e[0]*t[0]+e[1]*t[2],n=e[0]*t[1]+e[1]*t[3],s=e[2]*t[0]+e[3]*t[2],r=e[2]*t[1]+e[3]*t[3],a=(i+r)/2,o=Math.sqrt((i+r)**2-4*(i*r-s*n))/2,l=a+o||1,c=a-o||1;return[Math.sqrt(l),Math.sqrt(c)]}static normalizeRect(e){const t=e.slice(0);if(e[0]>e[2]){t[0]=e[2];t[2]=e[0]}if(e[1]>e[3]){t[1]=e[3];t[3]=e[1]}return t}static intersect(e,t){function compare(e,t){return e-t}const i=[e[0],e[2],t[0],t[2]].sort(compare),n=[e[1],e[3],t[1],t[3]].sort(compare),s=[];e=Util.normalizeRect(e);t=Util.normalizeRect(t);if(!(i[0]===e[0]&&i[1]===t[0]||i[0]===t[0]&&i[1]===e[0]))return null;s[0]=i[1];s[2]=i[2];if(!(n[0]===e[1]&&n[1]===t[1]||n[0]===t[1]&&n[1]===e[1]))return null;s[1]=n[1];s[3]=n[2];return s}}t.Util=Util;const h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364]},(e,t,i)=>{i(4)},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.isNodeJS=void 0;const i=!("object"!=typeof process||process+""!="[object process]"||process.versions.nw||process.versions.electron&&process.type&&"browser"!==process.type);t.isNodeJS=i},(__unused_webpack_module,exports,__w_pdfjs_require__)=>{Object.defineProperty(exports,"__esModule",{value:!0});exports.getDocument=getDocument;exports.setPDFNetworkStreamFactory=setPDFNetworkStreamFactory;exports.version=exports.PDFWorker=exports.PDFPageProxy=exports.PDFDocumentProxy=exports.PDFDataRangeTransport=exports.LoopbackPort=exports.DefaultCMapReaderFactory=exports.DefaultCanvasFactory=exports.build=void 0;var _util=__w_pdfjs_require__(2),_display_utils=__w_pdfjs_require__(1),_font_loader=__w_pdfjs_require__(6),_node_utils=__w_pdfjs_require__(7),_annotation_storage=__w_pdfjs_require__(8),_api_compatibility=__w_pdfjs_require__(9),_canvas=__w_pdfjs_require__(10),_worker_options=__w_pdfjs_require__(12),_is_node=__w_pdfjs_require__(4),_message_handler=__w_pdfjs_require__(13),_metadata=__w_pdfjs_require__(14),_optional_content_config=__w_pdfjs_require__(15),_transport_stream=__w_pdfjs_require__(16);const DEFAULT_RANGE_CHUNK_SIZE=65536,RENDERING_CANCELLED_TIMEOUT=100,DefaultCanvasFactory=_is_node.isNodeJS?_node_utils.NodeCanvasFactory:_display_utils.DOMCanvasFactory;exports.DefaultCanvasFactory=DefaultCanvasFactory;const DefaultCMapReaderFactory=_is_node.isNodeJS?_node_utils.NodeCMapReaderFactory:_display_utils.DOMCMapReaderFactory;exports.DefaultCMapReaderFactory=DefaultCMapReaderFactory;let createPDFNetworkStream;function setPDFNetworkStreamFactory(e){createPDFNetworkStream=e}function getDocument(e){const t=new PDFDocumentLoadingTask;let i;if("string"==typeof e||e instanceof URL)i={url:e};else if((0,_util.isArrayBuffer)(e))i={data:e};else if(e instanceof PDFDataRangeTransport)i={range:e};else{if("object"!=typeof e)throw new Error("Invalid parameter in getDocument, need either string, URL, Uint8Array, or parameter object.");if(!e.url&&!e.data&&!e.range)throw new Error("Invalid parameter object: need either .data, .range or .url");i=e}const n=Object.create(null);let s=null,r=null;for(const e in i){const t=i[e];switch(e){case"url":if("undefined"!=typeof window)try{n[e]=new URL(t,window.location).href;continue}catch(e){(0,_util.warn)(`Cannot create valid URL: "${e}".`)}else if("string"==typeof t||t instanceof URL){n[e]=t.toString();continue}throw new Error("Invalid PDF url data: either string or URL-object is expected in the url property.");case"range":s=t;continue;case"worker":r=t;continue;case"data":if(_is_node.isNodeJS&&"undefined"!=typeof Buffer&&t instanceof Buffer)n[e]=new Uint8Array(t);else{if(t instanceof Uint8Array)break;if("string"==typeof t)n[e]=(0,_util.stringToBytes)(t);else if("object"!=typeof t||null===t||isNaN(t.length)){if(!(0,_util.isArrayBuffer)(t))throw new Error("Invalid PDF binary data: either typed array, string, or array-like object is expected in the data property.");n[e]=new Uint8Array(t)}else n[e]=new Uint8Array(t)}continue}n[e]=t}n.rangeChunkSize=n.rangeChunkSize||DEFAULT_RANGE_CHUNK_SIZE;n.CMapReaderFactory=n.CMapReaderFactory||DefaultCMapReaderFactory;n.ignoreErrors=!0!==n.stopAtErrors;n.fontExtraProperties=!0===n.fontExtraProperties;n.pdfBug=!0===n.pdfBug;n.enableXfa=!0===n.enableXfa;("string"!=typeof n.docBaseUrl||(0,_display_utils.isDataScheme)(n.docBaseUrl))&&(n.docBaseUrl=null);Number.isInteger(n.maxImageSize)||(n.maxImageSize=-1);"boolean"!=typeof n.isEvalSupported&&(n.isEvalSupported=!0);"boolean"!=typeof n.disableFontFace&&(n.disableFontFace=_api_compatibility.apiCompatibilityParams.disableFontFace||!1);void 0===n.ownerDocument&&(n.ownerDocument=globalThis.document);"boolean"!=typeof n.disableRange&&(n.disableRange=!1);"boolean"!=typeof n.disableStream&&(n.disableStream=!1);"boolean"!=typeof n.disableAutoFetch&&(n.disableAutoFetch=!1);(0,_util.setVerbosityLevel)(n.verbosity);if(!r){const e={verbosity:n.verbosity,port:_worker_options.GlobalWorkerOptions.workerPort};r=e.port?PDFWorker.fromPort(e):new PDFWorker(e);t._worker=r}const a=t.docId;r.promise.then((function(){if(t.destroyed)throw new Error("Loading aborted");const e=_fetchDocument(r,n,s,a),i=new Promise((function(e){let t;s?t=new _transport_stream.PDFDataTransportStream({length:n.length,initialData:n.initialData,progressiveDone:n.progressiveDone,contentDispositionFilename:n.contentDispositionFilename,disableRange:n.disableRange,disableStream:n.disableStream},s):n.data||(t=createPDFNetworkStream({url:n.url,length:n.length,httpHeaders:n.httpHeaders,withCredentials:n.withCredentials,rangeChunkSize:n.rangeChunkSize,disableRange:n.disableRange,disableStream:n.disableStream}));e(t)}));return Promise.all([e,i]).then((function([e,i]){if(t.destroyed)throw new Error("Loading aborted");const s=new _message_handler.MessageHandler(a,e,r.port);s.postMessageTransfers=r.postMessageTransfers;const o=new WorkerTransport(s,t,i,n);t._transport=o;s.send("Ready",null)}))})).catch(t._capability.reject);return t}function _fetchDocument(e,t,i,n){if(e.destroyed)return Promise.reject(new Error("Worker was destroyed"));if(i){t.length=i.length;t.initialData=i.initialData;t.progressiveDone=i.progressiveDone;t.contentDispositionFilename=i.contentDispositionFilename}return e.messageHandler.sendWithPromise("GetDocRequest",{docId:n,apiVersion:"2.9.359",source:{data:t.data,url:t.url,password:t.password,disableAutoFetch:t.disableAutoFetch,rangeChunkSize:t.rangeChunkSize,length:t.length},maxImageSize:t.maxImageSize,disableFontFace:t.disableFontFace,postMessageTransfers:e.postMessageTransfers,docBaseUrl:t.docBaseUrl,ignoreErrors:t.ignoreErrors,isEvalSupported:t.isEvalSupported,fontExtraProperties:t.fontExtraProperties,enableXfa:t.enableXfa}).then((function(t){if(e.destroyed)throw new Error("Worker was destroyed");return t}))}const PDFDocumentLoadingTask=function PDFDocumentLoadingTaskClosure(){let e=0;return class PDFDocumentLoadingTask{constructor(){this._capability=(0,_util.createPromiseCapability)();this._transport=null;this._worker=null;this.docId="d"+e++;this.destroyed=!1;this.onPassword=null;this.onProgress=null;this.onUnsupportedFeature=null}get promise(){return this._capability.promise}destroy(){this.destroyed=!0;return(this._transport?this._transport.destroy():Promise.resolve()).then((()=>{this._transport=null;if(this._worker){this._worker.destroy();this._worker=null}}))}}}();class PDFDataRangeTransport{constructor(e,t,i=!1,n=null){this.length=e;this.initialData=t;this.progressiveDone=i;this.contentDispositionFilename=n;this._rangeListeners=[];this._progressListeners=[];this._progressiveReadListeners=[];this._progressiveDoneListeners=[];this._readyCapability=(0,_util.createPromiseCapability)()}addRangeListener(e){this._rangeListeners.push(e)}addProgressListener(e){this._progressListeners.push(e)}addProgressiveReadListener(e){this._progressiveReadListeners.push(e)}addProgressiveDoneListener(e){this._progressiveDoneListeners.push(e)}onDataRange(e,t){for(const i of this._rangeListeners)i(e,t)}onDataProgress(e,t){this._readyCapability.promise.then((()=>{for(const i of this._progressListeners)i(e,t)}))}onDataProgressiveRead(e){this._readyCapability.promise.then((()=>{for(const t of this._progressiveReadListeners)t(e)}))}onDataProgressiveDone(){this._readyCapability.promise.then((()=>{for(const e of this._progressiveDoneListeners)e()}))}transportReady(){this._readyCapability.resolve()}requestDataRange(e,t){(0,_util.unreachable)("Abstract method PDFDataRangeTransport.requestDataRange")}abort(){}}exports.PDFDataRangeTransport=PDFDataRangeTransport;class PDFDocumentProxy{constructor(e,t){this._pdfInfo=e;this._transport=t}get annotationStorage(){return this._transport.annotationStorage}get numPages(){return this._pdfInfo.numPages}get fingerprint(){return this._pdfInfo.fingerprint}get isPureXfa(){return this._pdfInfo.isPureXfa}getPage(e){return this._transport.getPage(e)}getPageIndex(e){return this._transport.getPageIndex(e)}getDestinations(){return this._transport.getDestinations()}getDestination(e){return this._transport.getDestination(e)}getPageLabels(){return this._transport.getPageLabels()}getPageLayout(){return this._transport.getPageLayout()}getPageMode(){return this._transport.getPageMode()}getViewerPreferences(){return this._transport.getViewerPreferences()}getOpenAction(){return this._transport.getOpenAction()}getAttachments(){return this._transport.getAttachments()}getJavaScript(){return this._transport.getJavaScript()}getJSActions(){return this._transport.getDocJSActions()}getOutline(){return this._transport.getOutline()}getOptionalContentConfig(){return this._transport.getOptionalContentConfig()}getPermissions(){return this._transport.getPermissions()}getMetadata(){return this._transport.getMetadata()}getMarkInfo(){return this._transport.getMarkInfo()}getData(){return this._transport.getData()}getDownloadInfo(){return this._transport.downloadInfoCapability.promise}getStats(){return this._transport.getStats()}cleanup(e=!1){return this._transport.startCleanup(e||this.isPureXfa)}destroy(){return this.loadingTask.destroy()}get loadingParams(){return this._transport.loadingParams}get loadingTask(){return this._transport.loadingTask}saveDocument(){arguments.length>0&&(0,_display_utils.deprecated)("saveDocument no longer accepts any options.");this._transport.annotationStorage.size<=0&&(0,_display_utils.deprecated)("saveDocument called while `annotationStorage` is empty, please use the getData-method instead.");return this._transport.saveDocument()}getFieldObjects(){return this._transport.getFieldObjects()}hasJSActions(){return this._transport.hasJSActions()}getCalculationOrderIds(){return this._transport.getCalculationOrderIds()}}exports.PDFDocumentProxy=PDFDocumentProxy;class PDFPageProxy{constructor(e,t,i,n,s=!1){this._pageIndex=e;this._pageInfo=t;this._ownerDocument=n;this._transport=i;this._stats=s?new _display_utils.StatTimer:null;this._pdfBug=s;this.commonObjs=i.commonObjs;this.objs=new PDFObjects;this.cleanupAfterRender=!1;this.pendingCleanup=!1;this._intentStates=new Map;this.destroyed=!1}get pageNumber(){return this._pageIndex+1}get rotate(){return this._pageInfo.rotate}get ref(){return this._pageInfo.ref}get userUnit(){return this._pageInfo.userUnit}get view(){return this._pageInfo.view}getViewport({scale:e,rotation:t=this.rotate,offsetX:i=0,offsetY:n=0,dontFlip:s=!1}={}){return new _display_utils.PageViewport({viewBox:this.view,scale:e,rotation:t,offsetX:i,offsetY:n,dontFlip:s})}getAnnotations({intent:e=null}={}){if(!this._annotationsPromise||this._annotationsIntent!==e){this._annotationsPromise=this._transport.getAnnotations(this._pageIndex,e);this._annotationsIntent=e}return this._annotationsPromise}getJSActions(){return this._jsActionsPromise||(this._jsActionsPromise=this._transport.getPageJSActions(this._pageIndex))}getXfa(){return this._xfaPromise||(this._xfaPromise=this._transport.getPageXfa(this._pageIndex))}render({canvasContext:e,viewport:t,intent:i="display",renderInteractiveForms:n=!1,transform:s=null,imageLayer:r=null,canvasFactory:a=null,background:o=null,includeAnnotationStorage:l=!1,optionalContentConfigPromise:c=null}){var h;if(void 0!==arguments[0]?.annotationStorage){(0,_display_utils.deprecated)("render no longer accepts an `annotationStorage` option, please use the `includeAnnotationStorage`-boolean instead.");l||(l=!!arguments[0].annotationStorage)}this._stats&&this._stats.time("Overall");const d="print"===i?"print":"display";this.pendingCleanup=!1;c||(c=this._transport.getOptionalContentConfig());let u=this._intentStates.get(d);if(!u){u=Object.create(null);this._intentStates.set(d,u)}if(u.streamReaderCancelTimeout){clearTimeout(u.streamReaderCancelTimeout);u.streamReaderCancelTimeout=null}const p=a||new DefaultCanvasFactory({ownerDocument:this._ownerDocument}),g=l?this._transport.annotationStorage.serializable:null;if(!u.displayReadyCapability){u.displayReadyCapability=(0,_util.createPromiseCapability)();u.operatorList={fnArray:[],argsArray:[],lastChunk:!1};this._stats&&this._stats.time("Page Request");this._pumpOperatorList({pageIndex:this._pageIndex,intent:d,renderInteractiveForms:!0===n,annotationStorage:g})}const complete=e=>{u.renderTasks.delete(f);(this.cleanupAfterRender||"print"===d)&&(this.pendingCleanup=!0);this._tryCleanup();if(e){f.capability.reject(e);this._abortOperatorList({intentState:u,reason:e})}else f.capability.resolve();if(this._stats){this._stats.timeEnd("Rendering");this._stats.timeEnd("Overall")}},f=new InternalRenderTask({callback:complete,params:{canvasContext:e,viewport:t,transform:s,imageLayer:r,background:o},objs:this.objs,commonObjs:this.commonObjs,operatorList:u.operatorList,pageIndex:this._pageIndex,canvasFactory:p,useRequestAnimationFrame:"print"!==d,pdfBug:this._pdfBug});((h=u).renderTasks||(h.renderTasks=new Set)).add(f);const m=f.task;Promise.all([u.displayReadyCapability.promise,c]).then((([e,t])=>{if(this.pendingCleanup)complete();else{this._stats&&this._stats.time("Rendering");f.initializeGraphics({transparency:e,optionalContentConfig:t});f.operatorListChanged()}})).catch(complete);return m}getOperatorList(){const e="oplist";let t,i=this._intentStates.get(e);if(!i){i=Object.create(null);this._intentStates.set(e,i)}if(!i.opListReadCapability){var n;t=Object.create(null);t.operatorListChanged=function operatorListChanged(){if(i.operatorList.lastChunk){i.opListReadCapability.resolve(i.operatorList);i.renderTasks.delete(t)}};i.opListReadCapability=(0,_util.createPromiseCapability)();((n=i).renderTasks||(n.renderTasks=new Set)).add(t);i.operatorList={fnArray:[],argsArray:[],lastChunk:!1};this._stats&&this._stats.time("Page Request");this._pumpOperatorList({pageIndex:this._pageIndex,intent:e})}return i.opListReadCapability.promise}streamTextContent({normalizeWhitespace:e=!1,disableCombineTextItems:t=!1,includeMarkedContent:i=!1}={}){return this._transport.messageHandler.sendWithStream("GetTextContent",{pageIndex:this._pageIndex,normalizeWhitespace:!0===e,combineTextItems:!0!==t,includeMarkedContent:!0===i},{highWaterMark:100,size:e=>e.items.length})}getTextContent(e={}){const t=this.streamTextContent(e);return new Promise((function(e,i){const n=t.getReader(),s={items:[],styles:Object.create(null)};!function pump(){n.read().then((function({value:t,done:i}){if(i)e(s);else{Object.assign(s.styles,t.styles);s.items.push(...t.items);pump()}}),i)}()}))}getStructTree(){return this._structTreePromise||(this._structTreePromise=this._transport.getStructTree(this._pageIndex))}_destroy(){this.destroyed=!0;this._transport.pageCache[this._pageIndex]=null;const e=[];for(const[t,i]of this._intentStates){this._abortOperatorList({intentState:i,reason:new Error("Page was destroyed."),force:!0});if("oplist"!==t)for(const t of i.renderTasks){e.push(t.completed);t.cancel()}}this.objs.clear();this._annotationsPromise=null;this._jsActionsPromise=null;this._xfaPromise=null;this._structTreePromise=null;this.pendingCleanup=!1;return Promise.all(e)}cleanup(e=!1){this.pendingCleanup=!0;return this._tryCleanup(e)}_tryCleanup(e=!1){if(!this.pendingCleanup)return!1;for(const{renderTasks:e,operatorList:t}of this._intentStates.values())if(e.size>0||!t.lastChunk)return!1;this._intentStates.clear();this.objs.clear();this._annotationsPromise=null;this._jsActionsPromise=null;this._xfaPromise=null;this._structTreePromise=null;e&&this._stats&&(this._stats=new _display_utils.StatTimer);this.pendingCleanup=!1;return!0}_startRenderPage(e,t){const i=this._intentStates.get(t);if(i){this._stats&&this._stats.timeEnd("Page Request");i.displayReadyCapability&&i.displayReadyCapability.resolve(e)}}_renderPageChunk(e,t){for(let i=0,n=e.length;i<n;i++){t.operatorList.fnArray.push(e.fnArray[i]);t.operatorList.argsArray.push(e.argsArray[i])}t.operatorList.lastChunk=e.lastChunk;for(const e of t.renderTasks)e.operatorListChanged();e.lastChunk&&this._tryCleanup()}_pumpOperatorList(e){(0,_util.assert)(e.intent,'PDFPageProxy._pumpOperatorList: Expected "intent" argument.');const t=this._transport.messageHandler.sendWithStream("GetOperatorList",e).getReader(),i=this._intentStates.get(e.intent);i.streamReader=t;const pump=()=>{t.read().then((({value:e,done:t})=>{if(t)i.streamReader=null;else if(!this._transport.destroyed){this._renderPageChunk(e,i);pump()}}),(e=>{i.streamReader=null;if(!this._transport.destroyed){if(i.operatorList){i.operatorList.lastChunk=!0;for(const e of i.renderTasks)e.operatorListChanged();this._tryCleanup()}if(i.displayReadyCapability)i.displayReadyCapability.reject(e);else{if(!i.opListReadCapability)throw e;i.opListReadCapability.reject(e)}}}))};pump()}_abortOperatorList({intentState:e,reason:t,force:i=!1}){(0,_util.assert)(t instanceof Error||"object"==typeof t&&null!==t,'PDFPageProxy._abortOperatorList: Expected "reason" argument.');if(e.streamReader){if(!i){if(e.renderTasks.size>0)return;if(t instanceof _display_utils.RenderingCancelledException){e.streamReaderCancelTimeout=setTimeout((()=>{this._abortOperatorList({intentState:e,reason:t,force:!0});e.streamReaderCancelTimeout=null}),RENDERING_CANCELLED_TIMEOUT);return}}e.streamReader.cancel(new _util.AbortException(t?.message));e.streamReader=null;if(!this._transport.destroyed){for(const[t,i]of this._intentStates)if(i===e){this._intentStates.delete(t);break}this.cleanup()}}}get stats(){return this._stats}}exports.PDFPageProxy=PDFPageProxy;class LoopbackPort{constructor(){this._listeners=[];this._deferred=Promise.resolve(void 0)}postMessage(e,t){const i=new WeakMap,n={data:function cloneValue(e){if("object"!=typeof e||null===e)return e;if(i.has(e))return i.get(e);let n,s;if((n=e.buffer)&&(0,_util.isArrayBuffer)(n)){s=t?.includes(n)?new e.constructor(n,e.byteOffset,e.byteLength):new e.constructor(e);i.set(e,s);return s}if(e instanceof Map){s=new Map;i.set(e,s);for(const[t,i]of e)s.set(t,cloneValue(i));return s}if(e instanceof Set){s=new Set;i.set(e,s);for(const t of e)s.add(cloneValue(t));return s}if(e instanceof URL)throw new Error(`LoopbackPort.postMessage - cannot clone: ${e}`);s=Array.isArray(e)?[]:Object.create(null);i.set(e,s);for(const t in e){let i,n=e;for(;!(i=Object.getOwnPropertyDescriptor(n,t));)n=Object.getPrototypeOf(n);if(void 0!==i.value)if("function"!=typeof i.value)s[t]=cloneValue(i.value);else if(e.hasOwnProperty?.(t))throw new Error(`LoopbackPort.postMessage - cannot clone: ${e[t]}`)}return s}(e)};this._deferred.then((()=>{for(const e of this._listeners)e.call(this,n)}))}addEventListener(e,t){this._listeners.push(t)}removeEventListener(e,t){const i=this._listeners.indexOf(t);this._listeners.splice(i,1)}terminate(){this._listeners.length=0}}exports.LoopbackPort=LoopbackPort;const PDFWorker=function PDFWorkerClosure(){const pdfWorkerPorts=new WeakMap;let isWorkerDisabled=!1,fallbackWorkerSrc,nextFakeWorkerId=0,fakeWorkerCapability;if(_is_node.isNodeJS&&"function"==typeof require){isWorkerDisabled=!0;fallbackWorkerSrc="./pdf.worker.js"}else if("object"==typeof document&&"currentScript"in document){const e=document.currentScript?.src;e&&(fallbackWorkerSrc=e.replace(/(\.(?:min\.)?js)(\?.*)?$/i,".worker$1$2"))}function getWorkerSrc(){if(_worker_options.GlobalWorkerOptions.workerSrc)return _worker_options.GlobalWorkerOptions.workerSrc;if(void 0!==fallbackWorkerSrc){_is_node.isNodeJS||(0,_display_utils.deprecated)('No "GlobalWorkerOptions.workerSrc" specified.');return fallbackWorkerSrc}throw new Error('No "GlobalWorkerOptions.workerSrc" specified.')}function getMainThreadWorkerMessageHandler(){let e;try{e=globalThis.pdfjsWorker?.WorkerMessageHandler}catch(e){}return e||null}function setupFakeWorkerGlobal(){if(fakeWorkerCapability)return fakeWorkerCapability.promise;fakeWorkerCapability=(0,_util.createPromiseCapability)();const loader=async function(){const mainWorkerMessageHandler=getMainThreadWorkerMessageHandler();if(mainWorkerMessageHandler)return mainWorkerMessageHandler;if(_is_node.isNodeJS&&"function"==typeof require){const worker=eval("require")(getWorkerSrc());return worker.WorkerMessageHandler}await(0,_display_utils.loadScript)(getWorkerSrc());return window.pdfjsWorker.WorkerMessageHandler};loader().then(fakeWorkerCapability.resolve,fakeWorkerCapability.reject);return fakeWorkerCapability.promise}function createCDNWrapper(e){const t="importScripts('"+e+"');";return URL.createObjectURL(new Blob([t]))}class PDFWorker{constructor({name:e=null,port:t=null,verbosity:i=(0,_util.getVerbosityLevel)()}={}){if(t&&pdfWorkerPorts.has(t))throw new Error("Cannot use more than one PDFWorker per port");this.name=e;this.destroyed=!1;this.postMessageTransfers=!0;this.verbosity=i;this._readyCapability=(0,_util.createPromiseCapability)();this._port=null;this._webWorker=null;this._messageHandler=null;if(t){pdfWorkerPorts.set(t,this);this._initializeFromPort(t)}else this._initialize()}get promise(){return this._readyCapability.promise}get port(){return this._port}get messageHandler(){return this._messageHandler}_initializeFromPort(e){this._port=e;this._messageHandler=new _message_handler.MessageHandler("main","worker",e);this._messageHandler.on("ready",(function(){}));this._readyCapability.resolve()}_initialize(){if("undefined"!=typeof Worker&&!isWorkerDisabled&&!getMainThreadWorkerMessageHandler()){let e=getWorkerSrc();try{(0,_util.isSameOrigin)(window.location.href,e)||(e=createCDNWrapper(new URL(e,window.location).href));const t=new Worker(e),i=new _message_handler.MessageHandler("main","worker",t),terminateEarly=()=>{t.removeEventListener("error",onWorkerError);i.destroy();t.terminate();this.destroyed?this._readyCapability.reject(new Error("Worker was destroyed")):this._setupFakeWorker()},onWorkerError=()=>{this._webWorker||terminateEarly()};t.addEventListener("error",onWorkerError);i.on("test",(e=>{t.removeEventListener("error",onWorkerError);if(this.destroyed)terminateEarly();else if(e){this._messageHandler=i;this._port=t;this._webWorker=t;e.supportTransfers||(this.postMessageTransfers=!1);this._readyCapability.resolve();i.send("configure",{verbosity:this.verbosity})}else{this._setupFakeWorker();i.destroy();t.terminate()}}));i.on("ready",(e=>{t.removeEventListener("error",onWorkerError);if(this.destroyed)terminateEarly();else try{sendTest()}catch(e){this._setupFakeWorker()}}));const sendTest=()=>{const e=new Uint8Array([this.postMessageTransfers?255:0]);try{i.send("test",e,[e.buffer])}catch(t){(0,_util.warn)("Cannot use postMessage transfers.");e[0]=0;i.send("test",e)}};sendTest();return}catch(e){(0,_util.info)("The worker has been disabled.")}}this._setupFakeWorker()}_setupFakeWorker(){if(!isWorkerDisabled){(0,_util.warn)("Setting up fake worker.");isWorkerDisabled=!0}setupFakeWorkerGlobal().then((e=>{if(this.destroyed){this._readyCapability.reject(new Error("Worker was destroyed"));return}const t=new LoopbackPort;this._port=t;const i="fake"+nextFakeWorkerId++,n=new _message_handler.MessageHandler(i+"_worker",i,t);e.setup(n,t);const s=new _message_handler.MessageHandler(i,i+"_worker",t);this._messageHandler=s;this._readyCapability.resolve();s.send("configure",{verbosity:this.verbosity})})).catch((e=>{this._readyCapability.reject(new Error(`Setting up fake worker failed: "${e.message}".`))}))}destroy(){this.destroyed=!0;if(this._webWorker){this._webWorker.terminate();this._webWorker=null}pdfWorkerPorts.delete(this._port);this._port=null;if(this._messageHandler){this._messageHandler.destroy();this._messageHandler=null}}static fromPort(e){if(!e||!e.port)throw new Error("PDFWorker.fromPort - invalid method signature.");return pdfWorkerPorts.has(e.port)?pdfWorkerPorts.get(e.port):new PDFWorker(e)}static getWorkerSrc(){return getWorkerSrc()}}return PDFWorker}();exports.PDFWorker=PDFWorker;class WorkerTransport{constructor(e,t,i,n){this.messageHandler=e;this.loadingTask=t;this.commonObjs=new PDFObjects;this.fontLoader=new _font_loader.FontLoader({docId:t.docId,onUnsupportedFeature:this._onUnsupportedFeature.bind(this),ownerDocument:n.ownerDocument});this._params=n;this.CMapReaderFactory=new n.CMapReaderFactory({baseUrl:n.cMapUrl,isCompressed:n.cMapPacked});this.destroyed=!1;this.destroyCapability=null;this._passwordCapability=null;this._networkStream=i;this._fullReader=null;this._lastProgress=null;this.pageCache=[];this.pagePromises=[];this.downloadInfoCapability=(0,_util.createPromiseCapability)();this.setupMessageHandler()}get annotationStorage(){return(0,_util.shadow)(this,"annotationStorage",new _annotation_storage.AnnotationStorage)}destroy(){if(this.destroyCapability)return this.destroyCapability.promise;this.destroyed=!0;this.destroyCapability=(0,_util.createPromiseCapability)();this._passwordCapability&&this._passwordCapability.reject(new Error("Worker was destroyed during onPassword callback"));const e=[];for(const t of this.pageCache)t&&e.push(t._destroy());this.pageCache.length=0;this.pagePromises.length=0;this.hasOwnProperty("annotationStorage")&&this.annotationStorage.resetModified();const t=this.messageHandler.sendWithPromise("Terminate",null);e.push(t);Promise.all(e).then((()=>{this.commonObjs.clear();this.fontLoader.clear();this._hasJSActionsPromise=null;this._networkStream&&this._networkStream.cancelAllRequests(new _util.AbortException("Worker was terminated."));if(this.messageHandler){this.messageHandler.destroy();this.messageHandler=null}this.destroyCapability.resolve()}),this.destroyCapability.reject);return this.destroyCapability.promise}setupMessageHandler(){const{messageHandler:e,loadingTask:t}=this;e.on("GetReader",((e,t)=>{(0,_util.assert)(this._networkStream,"GetReader - no `IPDFStream` instance available.");this._fullReader=this._networkStream.getFullReader();this._fullReader.onProgress=e=>{this._lastProgress={loaded:e.loaded,total:e.total}};t.onPull=()=>{this._fullReader.read().then((function({value:e,done:i}){if(i)t.close();else{(0,_util.assert)((0,_util.isArrayBuffer)(e),"GetReader - expected an ArrayBuffer.");t.enqueue(new Uint8Array(e),1,[e])}})).catch((e=>{t.error(e)}))};t.onCancel=e=>{this._fullReader.cancel(e);t.ready.catch((e=>{if(!this.destroyed)throw e}))}}));e.on("ReaderHeadersReady",(e=>{const i=(0,_util.createPromiseCapability)(),n=this._fullReader;n.headersReady.then((()=>{if(!n.isStreamingSupported||!n.isRangeSupported){this._lastProgress&&t.onProgress&&t.onProgress(this._lastProgress);n.onProgress=e=>{t.onProgress&&t.onProgress({loaded:e.loaded,total:e.total})}}i.resolve({isStreamingSupported:n.isStreamingSupported,isRangeSupported:n.isRangeSupported,contentLength:n.contentLength})}),i.reject);return i.promise}));e.on("GetRangeReader",((e,t)=>{(0,_util.assert)(this._networkStream,"GetRangeReader - no `IPDFStream` instance available.");const i=this._networkStream.getRangeReader(e.begin,e.end);if(i){t.onPull=()=>{i.read().then((function({value:e,done:i}){if(i)t.close();else{(0,_util.assert)((0,_util.isArrayBuffer)(e),"GetRangeReader - expected an ArrayBuffer.");t.enqueue(new Uint8Array(e),1,[e])}})).catch((e=>{t.error(e)}))};t.onCancel=e=>{i.cancel(e);t.ready.catch((e=>{if(!this.destroyed)throw e}))}}else t.close()}));e.on("GetDoc",(({pdfInfo:e})=>{this._numPages=e.numPages;t._capability.resolve(new PDFDocumentProxy(e,this))}));e.on("DocException",(function(e){let i;switch(e.name){case"PasswordException":i=new _util.PasswordException(e.message,e.code);break;case"InvalidPDFException":i=new _util.InvalidPDFException(e.message);break;case"MissingPDFException":i=new _util.MissingPDFException(e.message);break;case"UnexpectedResponseException":i=new _util.UnexpectedResponseException(e.message,e.status);break;case"UnknownErrorException":i=new _util.UnknownErrorException(e.message,e.details)}if(!(i instanceof Error)){const e="DocException - expected a valid Error.";(0,_util.warn)(e)}t._capability.reject(i)}));e.on("PasswordRequest",(e=>{this._passwordCapability=(0,_util.createPromiseCapability)();if(t.onPassword){const updatePassword=e=>{this._passwordCapability.resolve({password:e})};try{t.onPassword(updatePassword,e.code)}catch(e){this._passwordCapability.reject(e)}}else this._passwordCapability.reject(new _util.PasswordException(e.message,e.code));return this._passwordCapability.promise}));e.on("DataLoaded",(e=>{t.onProgress&&t.onProgress({loaded:e.length,total:e.length});this.downloadInfoCapability.resolve(e)}));e.on("StartRenderPage",(e=>{if(this.destroyed)return;this.pageCache[e.pageIndex]._startRenderPage(e.transparency,e.intent)}));e.on("commonobj",(t=>{if(this.destroyed)return;const[i,n,s]=t;if(!this.commonObjs.has(i))switch(n){case"Font":const t=this._params;if("error"in s){const e=s.error;(0,_util.warn)(`Error during font loading: ${e}`);this.commonObjs.resolve(i,e);break}let r=null;t.pdfBug&&globalThis.FontInspector?.enabled&&(r={registerFont(e,t){globalThis.FontInspector.fontAdded(e,t)}});const a=new _font_loader.FontFaceObject(s,{isEvalSupported:t.isEvalSupported,disableFontFace:t.disableFontFace,ignoreErrors:t.ignoreErrors,onUnsupportedFeature:this._onUnsupportedFeature.bind(this),fontRegistry:r});this.fontLoader.bind(a).catch((t=>e.sendWithPromise("FontFallback",{id:i}))).finally((()=>{!t.fontExtraProperties&&a.data&&(a.data=null);this.commonObjs.resolve(i,a)}));break;case"FontPath":case"Image":this.commonObjs.resolve(i,s);break;default:throw new Error(`Got unknown common object type ${n}`)}}));e.on("obj",(e=>{if(this.destroyed)return;const[t,i,n,s]=e,r=this.pageCache[i];if(!r.objs.has(t))switch(n){case"Image":r.objs.resolve(t,s);const e=8e6;s?.data?.length>e&&(r.cleanupAfterRender=!0);break;default:throw new Error(`Got unknown object type ${n}`)}}));e.on("DocProgress",(e=>{this.destroyed||t.onProgress&&t.onProgress({loaded:e.loaded,total:e.total})}));e.on("UnsupportedFeature",this._onUnsupportedFeature.bind(this));e.on("FetchBuiltInCMap",((e,t)=>{if(this.destroyed){t.error(new Error("Worker was destroyed"));return}let i=!1;t.onPull=()=>{if(i)t.close();else{i=!0;this.CMapReaderFactory.fetch(e).then((function(e){t.enqueue(e,1,[e.cMapData.buffer])})).catch((function(e){t.error(e)}))}}}))}_onUnsupportedFeature({featureId:e}){this.destroyed||this.loadingTask.onUnsupportedFeature&&this.loadingTask.onUnsupportedFeature(e)}getData(){return this.messageHandler.sendWithPromise("GetData",null)}getPage(e){if(!Number.isInteger(e)||e<=0||e>this._numPages)return Promise.reject(new Error("Invalid page request"));const t=e-1;if(t in this.pagePromises)return this.pagePromises[t];const i=this.messageHandler.sendWithPromise("GetPage",{pageIndex:t}).then((e=>{if(this.destroyed)throw new Error("Transport destroyed");const i=new PDFPageProxy(t,e,this,this._params.ownerDocument,this._params.pdfBug);this.pageCache[t]=i;return i}));this.pagePromises[t]=i;return i}getPageIndex(e){return this.messageHandler.sendWithPromise("GetPageIndex",{ref:e}).catch((function(e){return Promise.reject(new Error(e))}))}getAnnotations(e,t){return this.messageHandler.sendWithPromise("GetAnnotations",{pageIndex:e,intent:t})}saveDocument(){return this.messageHandler.sendWithPromise("SaveDocument",{numPages:this._numPages,annotationStorage:this.annotationStorage.serializable,filename:this._fullReader?.filename??null}).finally((()=>{this.annotationStorage.resetModified()}))}getFieldObjects(){return this.messageHandler.sendWithPromise("GetFieldObjects",null)}hasJSActions(){return this._hasJSActionsPromise||(this._hasJSActionsPromise=this.messageHandler.sendWithPromise("HasJSActions",null))}getCalculationOrderIds(){return this.messageHandler.sendWithPromise("GetCalculationOrderIds",null)}getDestinations(){return this.messageHandler.sendWithPromise("GetDestinations",null)}getDestination(e){return"string"!=typeof e?Promise.reject(new Error("Invalid destination request.")):this.messageHandler.sendWithPromise("GetDestination",{id:e})}getPageLabels(){return this.messageHandler.sendWithPromise("GetPageLabels",null)}getPageLayout(){return this.messageHandler.sendWithPromise("GetPageLayout",null)}getPageMode(){return this.messageHandler.sendWithPromise("GetPageMode",null)}getViewerPreferences(){return this.messageHandler.sendWithPromise("GetViewerPreferences",null)}getOpenAction(){return this.messageHandler.sendWithPromise("GetOpenAction",null)}getAttachments(){return this.messageHandler.sendWithPromise("GetAttachments",null)}getJavaScript(){return this.messageHandler.sendWithPromise("GetJavaScript",null)}getDocJSActions(){return this.messageHandler.sendWithPromise("GetDocJSActions",null)}getPageJSActions(e){return this.messageHandler.sendWithPromise("GetPageJSActions",{pageIndex:e})}getPageXfa(e){return this.messageHandler.sendWithPromise("GetPageXfa",{pageIndex:e})}getStructTree(e){return this.messageHandler.sendWithPromise("GetStructTree",{pageIndex:e})}getOutline(){return this.messageHandler.sendWithPromise("GetOutline",null)}getOptionalContentConfig(){return this.messageHandler.sendWithPromise("GetOptionalContentConfig",null).then((e=>new _optional_content_config.OptionalContentConfig(e)))}getPermissions(){return this.messageHandler.sendWithPromise("GetPermissions",null)}getMetadata(){return this.messageHandler.sendWithPromise("GetMetadata",null).then((e=>({info:e[0],metadata:e[1]?new _metadata.Metadata(e[1]):null,contentDispositionFilename:this._fullReader?.filename??null,contentLength:this._fullReader?.contentLength??null})))}getMarkInfo(){return this.messageHandler.sendWithPromise("GetMarkInfo",null)}getStats(){return this.messageHandler.sendWithPromise("GetStats",null)}async startCleanup(e=!1){await this.messageHandler.sendWithPromise("Cleanup",null);if(!this.destroyed){for(let e=0,t=this.pageCache.length;e<t;e++){const t=this.pageCache[e];if(!t)continue;if(!t.cleanup())throw new Error(`startCleanup: Page ${e+1} is currently rendering.`)}this.commonObjs.clear();e||this.fontLoader.clear();this._hasJSActionsPromise=null}}get loadingParams(){const e=this._params;return(0,_util.shadow)(this,"loadingParams",{disableAutoFetch:e.disableAutoFetch,disableFontFace:e.disableFontFace})}}class PDFObjects{constructor(){this._objs=Object.create(null)}_ensureObj(e){return this._objs[e]?this._objs[e]:this._objs[e]={capability:(0,_util.createPromiseCapability)(),data:null,resolved:!1}}get(e,t=null){if(t){this._ensureObj(e).capability.promise.then(t);return null}const i=this._objs[e];if(!i||!i.resolved)throw new Error(`Requesting object that isn't resolved yet ${e}.`);return i.data}has(e){return this._objs[e]?.resolved||!1}resolve(e,t){const i=this._ensureObj(e);i.resolved=!0;i.data=t;i.capability.resolve(t)}clear(){this._objs=Object.create(null)}}class RenderTask{constructor(e){this._internalRenderTask=e;this.onContinue=null}get promise(){return this._internalRenderTask.capability.promise}cancel(){this._internalRenderTask.cancel()}}const InternalRenderTask=function InternalRenderTaskClosure(){const e=new WeakSet;return class InternalRenderTask{constructor({callback:e,params:t,objs:i,commonObjs:n,operatorList:s,pageIndex:r,canvasFactory:a,useRequestAnimationFrame:o=!1,pdfBug:l=!1}){this.callback=e;this.params=t;this.objs=i;this.commonObjs=n;this.operatorListIdx=null;this.operatorList=s;this._pageIndex=r;this.canvasFactory=a;this._pdfBug=l;this.running=!1;this.graphicsReadyCallback=null;this.graphicsReady=!1;this._useRequestAnimationFrame=!0===o&&"undefined"!=typeof window;this.cancelled=!1;this.capability=(0,_util.createPromiseCapability)();this.task=new RenderTask(this);this._cancelBound=this.cancel.bind(this);this._continueBound=this._continue.bind(this);this._scheduleNextBound=this._scheduleNext.bind(this);this._nextBound=this._next.bind(this);this._canvas=t.canvasContext.canvas}get completed(){return this.capability.promise.catch((function(){}))}initializeGraphics({transparency:t=!1,optionalContentConfig:i}){if(this.cancelled)return;if(this._canvas){if(e.has(this._canvas))throw new Error("Cannot use the same canvas during multiple render() operations. Use different canvas or ensure previous operations were cancelled or completed.");e.add(this._canvas)}if(this._pdfBug&&globalThis.StepperManager?.enabled){this.stepper=globalThis.StepperManager.create(this._pageIndex);this.stepper.init(this.operatorList);this.stepper.nextBreakPoint=this.stepper.getNextBreakPoint()}const{canvasContext:n,viewport:s,transform:r,imageLayer:a,background:o}=this.params;this.gfx=new _canvas.CanvasGraphics(n,this.commonObjs,this.objs,this.canvasFactory,a,i);this.gfx.beginDrawing({transform:r,viewport:s,transparency:t,background:o});this.operatorListIdx=0;this.graphicsReady=!0;this.graphicsReadyCallback&&this.graphicsReadyCallback()}cancel(t=null){this.running=!1;this.cancelled=!0;this.gfx&&this.gfx.endDrawing();this._canvas&&e.delete(this._canvas);this.callback(t||new _display_utils.RenderingCancelledException(`Rendering cancelled, page ${this._pageIndex+1}`,"canvas"))}operatorListChanged(){if(this.graphicsReady){this.stepper&&this.stepper.updateOperatorList(this.operatorList);this.running||this._continue()}else this.graphicsReadyCallback||(this.graphicsReadyCallback=this._continueBound)}_continue(){this.running=!0;this.cancelled||(this.task.onContinue?this.task.onContinue(this._scheduleNextBound):this._scheduleNext())}_scheduleNext(){this._useRequestAnimationFrame?window.requestAnimationFrame((()=>{this._nextBound().catch(this._cancelBound)})):Promise.resolve().then(this._nextBound).catch(this._cancelBound)}async _next(){if(!this.cancelled){this.operatorListIdx=this.gfx.executeOperatorList(this.operatorList,this.operatorListIdx,this._continueBound,this.stepper);if(this.operatorListIdx===this.operatorList.argsArray.length){this.running=!1;if(this.operatorList.lastChunk){this.gfx.endDrawing();this._canvas&&e.delete(this._canvas);this.callback()}}}}}}(),version="2.9.359";exports.version=version;const build="e667c8cbc";exports.build=build},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.FontLoader=t.FontFaceObject=void 0;var n=i(2);class BaseFontLoader{constructor({docId:e,onUnsupportedFeature:t,ownerDocument:i=globalThis.document}){this.constructor===BaseFontLoader&&(0,n.unreachable)("Cannot initialize BaseFontLoader.");this.docId=e;this._onUnsupportedFeature=t;this._document=i;this.nativeFontFaces=[];this.styleElement=null}addNativeFontFace(e){this.nativeFontFaces.push(e);this._document.fonts.add(e)}insertRule(e){let t=this.styleElement;if(!t){t=this.styleElement=this._document.createElement("style");t.id=`PDFJS_FONT_STYLE_TAG_${this.docId}`;this._document.documentElement.getElementsByTagName("head")[0].appendChild(t)}const i=t.sheet;i.insertRule(e,i.cssRules.length)}clear(){for(const e of this.nativeFontFaces)this._document.fonts.delete(e);this.nativeFontFaces.length=0;if(this.styleElement){this.styleElement.remove();this.styleElement=null}}async bind(e){if(e.attached||e.missingFile)return;e.attached=!0;if(this.isFontLoadingAPISupported){const t=e.createNativeFontFace();if(t){this.addNativeFontFace(t);try{await t.loaded}catch(i){this._onUnsupportedFeature({featureId:n.UNSUPPORTED_FEATURES.errorFontLoadNative});(0,n.warn)(`Failed to load font '${t.family}': '${i}'.`);e.disableFontFace=!0;throw i}}return}const t=e.createFontFaceRule();if(t){this.insertRule(t);if(this.isSyncFontLoadingSupported)return;await new Promise((i=>{const n=this._queueLoadingCallback(i);this._prepareFontLoadEvent([t],[e],n)}))}}_queueLoadingCallback(e){(0,n.unreachable)("Abstract method `_queueLoadingCallback`.")}get isFontLoadingAPISupported(){return(0,n.shadow)(this,"isFontLoadingAPISupported",!!this._document?.fonts)}get isSyncFontLoadingSupported(){(0,n.unreachable)("Abstract method `isSyncFontLoadingSupported`.")}get _loadTestFont(){(0,n.unreachable)("Abstract method `_loadTestFont`.")}_prepareFontLoadEvent(e,t,i){(0,n.unreachable)("Abstract method `_prepareFontLoadEvent`.")}}let s;t.FontLoader=s;t.FontLoader=s=class GenericFontLoader extends BaseFontLoader{constructor(e){super(e);this.loadingContext={requests:[],nextRequestId:0};this.loadTestFontId=0}get isSyncFontLoadingSupported(){let e=!1;if("undefined"==typeof navigator)e=!0;else{/Mozilla\/5.0.*?rv:(\d+).*? Gecko/.exec(navigator.userAgent)?.[1]>=14&&(e=!0)}return(0,n.shadow)(this,"isSyncFontLoadingSupported",e)}_queueLoadingCallback(e){const t=this.loadingContext,i={id:"pdfjs-font-loading-"+t.nextRequestId++,done:!1,complete:function completeRequest(){(0,n.assert)(!i.done,"completeRequest() cannot be called twice.");i.done=!0;for(;t.requests.length>0&&t.requests[0].done;){const e=t.requests.shift();setTimeout(e.callback,0)}},callback:e};t.requests.push(i);return i}get _loadTestFont(){return(0,n.shadow)(this,"_loadTestFont",atob("T1RUTwALAIAAAwAwQ0ZGIDHtZg4AAAOYAAAAgUZGVE1lkzZwAAAEHAAAABxHREVGABQAFQAABDgAAAAeT1MvMlYNYwkAAAEgAAAAYGNtYXABDQLUAAACNAAAAUJoZWFk/xVFDQAAALwAAAA2aGhlYQdkA+oAAAD0AAAAJGhtdHgD6AAAAAAEWAAAAAZtYXhwAAJQAAAAARgAAAAGbmFtZVjmdH4AAAGAAAAAsXBvc3T/hgAzAAADeAAAACAAAQAAAAEAALZRFsRfDzz1AAsD6AAAAADOBOTLAAAAAM4KHDwAAAAAA+gDIQAAAAgAAgAAAAAAAAABAAADIQAAAFoD6AAAAAAD6AABAAAAAAAAAAAAAAAAAAAAAQAAUAAAAgAAAAQD6AH0AAUAAAKKArwAAACMAooCvAAAAeAAMQECAAACAAYJAAAAAAAAAAAAAQAAAAAAAAAAAAAAAFBmRWQAwAAuAC4DIP84AFoDIQAAAAAAAQAAAAAAAAAAACAAIAABAAAADgCuAAEAAAAAAAAAAQAAAAEAAAAAAAEAAQAAAAEAAAAAAAIAAQAAAAEAAAAAAAMAAQAAAAEAAAAAAAQAAQAAAAEAAAAAAAUAAQAAAAEAAAAAAAYAAQAAAAMAAQQJAAAAAgABAAMAAQQJAAEAAgABAAMAAQQJAAIAAgABAAMAAQQJAAMAAgABAAMAAQQJAAQAAgABAAMAAQQJAAUAAgABAAMAAQQJAAYAAgABWABYAAAAAAAAAwAAAAMAAAAcAAEAAAAAADwAAwABAAAAHAAEACAAAAAEAAQAAQAAAC7//wAAAC7////TAAEAAAAAAAABBgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAD/gwAyAAAAAQAAAAAAAAAAAAAAAAAAAAABAAQEAAEBAQJYAAEBASH4DwD4GwHEAvgcA/gXBIwMAYuL+nz5tQXkD5j3CBLnEQACAQEBIVhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYAAABAQAADwACAQEEE/t3Dov6fAH6fAT+fPp8+nwHDosMCvm1Cvm1DAz6fBQAAAAAAAABAAAAAMmJbzEAAAAAzgTjFQAAAADOBOQpAAEAAAAAAAAADAAUAAQAAAABAAAAAgABAAAAAAAAAAAD6AAAAAAAAA=="))}_prepareFontLoadEvent(e,t,i){function int32(e,t){return e.charCodeAt(t)<<24|e.charCodeAt(t+1)<<16|e.charCodeAt(t+2)<<8|255&e.charCodeAt(t+3)}function spliceString(e,t,i,n){return e.substring(0,t)+n+e.substring(t+i)}let s,r;const a=this._document.createElement("canvas");a.width=1;a.height=1;const o=a.getContext("2d");let l=0;const c=`lt${Date.now()}${this.loadTestFontId++}`;let h=this._loadTestFont;h=spliceString(h,976,c.length,c);const d=1482184792;let u=int32(h,16);for(s=0,r=c.length-3;s<r;s+=4)u=u-d+int32(c,s)|0;s<c.length&&(u=u-d+int32(c+"XXX",s)|0);h=spliceString(h,16,4,(0,n.string32)(u));const p=`@font-face {font-family:"${c}";src:${`url(data:font/opentype;base64,${btoa(h)});`}}`;this.insertRule(p);const g=[];for(const e of t)g.push(e.loadedName);g.push(c);const f=this._document.createElement("div");f.style.visibility="hidden";f.style.width=f.style.height="10px";f.style.position="absolute";f.style.top=f.style.left="0px";for(const e of g){const t=this._document.createElement("span");t.textContent="Hi";t.style.fontFamily=e;f.appendChild(t)}this._document.body.appendChild(f);!function isFontReady(e,t){l++;if(l>30){(0,n.warn)("Load test font never loaded.");t();return}o.font="30px "+e;o.fillText(".",0,20);o.getImageData(0,0,1,1).data[3]>0?t():setTimeout(isFontReady.bind(null,e,t))}(c,(()=>{this._document.body.removeChild(f);i.complete()}))}};t.FontFaceObject=class FontFaceObject{constructor(e,{isEvalSupported:t=!0,disableFontFace:i=!1,ignoreErrors:n=!1,onUnsupportedFeature:s,fontRegistry:r=null}){this.compiledGlyphs=Object.create(null);for(const t in e)this[t]=e[t];this.isEvalSupported=!1!==t;this.disableFontFace=!0===i;this.ignoreErrors=!0===n;this._onUnsupportedFeature=s;this.fontRegistry=r}createNativeFontFace(){if(!this.data||this.disableFontFace)return null;let e;if(this.cssFontInfo){const t={weight:this.cssFontInfo.fontWeight};this.cssFontInfo.italicAngle&&(t.style=`oblique ${this.cssFontInfo.italicAngle}deg`);e=new FontFace(this.cssFontInfo.fontFamily,this.data,t)}else e=new FontFace(this.loadedName,this.data,{});this.fontRegistry&&this.fontRegistry.registerFont(this);return e}createFontFaceRule(){if(!this.data||this.disableFontFace)return null;const e=(0,n.bytesToString)(this.data),t=`url(data:${this.mimetype};base64,${btoa(e)});`;let i;if(this.cssFontInfo){let e=`font-weight: ${this.cssFontInfo.fontWeight};`;this.cssFontInfo.italicAngle&&(e+=`font-style: oblique ${this.cssFontInfo.italicAngle}deg;`);i=`@font-face {font-family:"${this.cssFontInfo.fontFamily}";${e}src:${t}}`}else i=`@font-face {font-family:"${this.loadedName}";src:${t}}`;this.fontRegistry&&this.fontRegistry.registerFont(this,t);return i}getPathGenerator(e,t){if(void 0!==this.compiledGlyphs[t])return this.compiledGlyphs[t];let i;try{i=e.get(this.loadedName+"_path_"+t)}catch(e){if(!this.ignoreErrors)throw e;this._onUnsupportedFeature({featureId:n.UNSUPPORTED_FEATURES.errorFontGetPath});(0,n.warn)(`getPathGenerator - ignoring character: "${e}".`);return this.compiledGlyphs[t]=function(e,t){}}if(this.isEvalSupported&&n.IsEvalSupportedCached.value){const e=[];for(const t of i){const i=void 0!==t.args?t.args.join(","):"";e.push("c.",t.cmd,"(",i,");\n")}return this.compiledGlyphs[t]=new Function("c","size",e.join(""))}return this.compiledGlyphs[t]=function(e,t){for(const n of i){"scale"===n.cmd&&(n.args=[t,-t]);e[n.cmd].apply(e,n.args)}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NodeCMapReaderFactory=t.NodeCanvasFactory=void 0;var n=i(1),s=i(4),r=i(2);let a=class{constructor(){(0,r.unreachable)("Not implemented: NodeCanvasFactory")}};t.NodeCanvasFactory=a;let o=class{constructor(){(0,r.unreachable)("Not implemented: NodeCMapReaderFactory")}};t.NodeCMapReaderFactory=o;if(s.isNodeJS){t.NodeCanvasFactory=a=class extends n.BaseCanvasFactory{create(e,t){if(e<=0||t<=0)throw new Error("Invalid canvas size");const i=require("canvas").createCanvas(e,t);return{canvas:i,context:i.getContext("2d")}}};t.NodeCMapReaderFactory=o=class extends n.BaseCMapReaderFactory{_fetchData(e,t){return new Promise(((i,n)=>{require("fs").readFile(e,((e,s)=>{!e&&s?i({cMapData:new Uint8Array(s),compressionType:t}):n(new Error(e))}))}))}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.AnnotationStorage=void 0;var n=i(2);t.AnnotationStorage=class AnnotationStorage{constructor(){this._storage=new Map;this._modified=!1;this.onSetModified=null;this.onResetModified=null}getValue(e,t){const i=this._storage.get(e);return void 0!==i?i:t}setValue(e,t){const i=this._storage.get(e);let n=!1;if(void 0!==i){for(const[e,s]of Object.entries(t))if(i[e]!==s){n=!0;i[e]=s}}else{this._storage.set(e,t);n=!0}n&&this._setModified()}getAll(){return this._storage.size>0?(0,n.objectFromMap)(this._storage):null}get size(){return this._storage.size}_setModified(){if(!this._modified){this._modified=!0;"function"==typeof this.onSetModified&&this.onSetModified()}}resetModified(){if(this._modified){this._modified=!1;"function"==typeof this.onResetModified&&this.onResetModified()}}get serializable(){return this._storage.size>0?this._storage:null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.apiCompatibilityParams=void 0;var n=i(4);const s=Object.create(null);!function checkFontFace(){n.isNodeJS&&(s.disableFontFace=!0)}();const r=Object.freeze(s);t.apiCompatibilityParams=r},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CanvasGraphics=void 0;var n=i(2),s=i(11);const r=4096,a=16;function addContextCurrentTransform(e){if(!e.mozCurrentTransform){e._originalSave=e.save;e._originalRestore=e.restore;e._originalRotate=e.rotate;e._originalScale=e.scale;e._originalTranslate=e.translate;e._originalTransform=e.transform;e._originalSetTransform=e.setTransform;e._originalResetTransform=e.resetTransform;e._transformMatrix=e._transformMatrix||[1,0,0,1,0,0];e._transformStack=[];try{const t=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(e),"lineWidth");e._setLineWidth=t.set;e._getLineWidth=t.get;Object.defineProperty(e,"lineWidth",{set:function setLineWidth(e){this._setLineWidth(1.000001*e)},get:function getLineWidth(){return this._getLineWidth()}})}catch(e){}Object.defineProperty(e,"mozCurrentTransform",{get:function getCurrentTransform(){return this._transformMatrix}});Object.defineProperty(e,"mozCurrentTransformInverse",{get:function getCurrentTransformInverse(){const[e,t,i,n,s,r]=this._transformMatrix,a=e*n-t*i,o=t*i-e*n;return[n/a,t/o,i/o,e/a,(n*s-i*r)/o,(t*s-e*r)/a]}});e.save=function ctxSave(){const e=this._transformMatrix;this._transformStack.push(e);this._transformMatrix=e.slice(0,6);this._originalSave()};e.restore=function ctxRestore(){const e=this._transformStack.pop();if(e){this._transformMatrix=e;this._originalRestore()}};e.translate=function ctxTranslate(e,t){const i=this._transformMatrix;i[4]=i[0]*e+i[2]*t+i[4];i[5]=i[1]*e+i[3]*t+i[5];this._originalTranslate(e,t)};e.scale=function ctxScale(e,t){const i=this._transformMatrix;i[0]=i[0]*e;i[1]=i[1]*e;i[2]=i[2]*t;i[3]=i[3]*t;this._originalScale(e,t)};e.transform=function ctxTransform(t,i,n,s,r,a){const o=this._transformMatrix;this._transformMatrix=[o[0]*t+o[2]*i,o[1]*t+o[3]*i,o[0]*n+o[2]*s,o[1]*n+o[3]*s,o[0]*r+o[2]*a+o[4],o[1]*r+o[3]*a+o[5]];e._originalTransform(t,i,n,s,r,a)};e.setTransform=function ctxSetTransform(t,i,n,s,r,a){this._transformMatrix=[t,i,n,s,r,a];e._originalSetTransform(t,i,n,s,r,a)};e.resetTransform=function ctxResetTransform(){this._transformMatrix=[1,0,0,1,0,0];e._originalResetTransform()};e.rotate=function ctxRotate(e){const t=Math.cos(e),i=Math.sin(e),n=this._transformMatrix;this._transformMatrix=[n[0]*t+n[2]*i,n[1]*t+n[3]*i,n[0]*-i+n[2]*t,n[1]*-i+n[3]*t,n[4],n[5]];this._originalRotate(e)}}}class CachedCanvases{constructor(e){this.canvasFactory=e;this.cache=Object.create(null)}getCanvas(e,t,i,n){let s;if(void 0!==this.cache[e]){s=this.cache[e];this.canvasFactory.reset(s,t,i);s.context.setTransform(1,0,0,1,0,0)}else{s=this.canvasFactory.create(t,i);this.cache[e]=s}n&&addContextCurrentTransform(s.context);return s}clear(){for(const e in this.cache){const t=this.cache[e];this.canvasFactory.destroy(t);delete this.cache[e]}}}class CanvasExtraState{constructor(){this.alphaIsShape=!1;this.fontSize=0;this.fontSizeScale=1;this.textMatrix=n.IDENTITY_MATRIX;this.textMatrixScale=1;this.fontMatrix=n.FONT_IDENTITY_MATRIX;this.leading=0;this.x=0;this.y=0;this.lineX=0;this.lineY=0;this.charSpacing=0;this.wordSpacing=0;this.textHScale=1;this.textRenderingMode=n.TextRenderingMode.FILL;this.textRise=0;this.fillColor="#000000";this.strokeColor="#000000";this.patternFill=!1;this.fillAlpha=1;this.strokeAlpha=1;this.lineWidth=1;this.activeSMask=null;this.resumeSMaskCtx=null;this.transferMaps=null}clone(){return Object.create(this)}setCurrentPoint(e,t){this.x=e;this.y=t}}const o=function CanvasGraphicsClosure(){function putBinaryImageData(e,t,i=null){if("undefined"!=typeof ImageData&&t instanceof ImageData){e.putImageData(t,0,0);return}const s=t.height,r=t.width,o=s%a,l=(s-o)/a,c=0===o?l:l+1,h=e.createImageData(r,a);let d,u=0;const p=t.data,g=h.data;let f,m,_,b,v,w,y,S;if(i)switch(i.length){case 1:v=i[0];w=i[0];y=i[0];S=i[0];break;case 4:v=i[0];w=i[1];y=i[2];S=i[3]}if(t.kind===n.ImageKind.GRAYSCALE_1BPP){const t=p.byteLength,i=new Uint32Array(g.buffer,0,g.byteLength>>2),s=i.length,b=r+7>>3;let v=4294967295,w=n.IsLittleEndianCached.value?4278190080:255;S&&255===S[0]&&0===S[255]&&([v,w]=[w,v]);for(f=0;f<c;f++){_=f<l?a:o;d=0;for(m=0;m<_;m++){const e=t-u;let n=0;const s=e>b?r:8*e-7,a=-8&s;let o=0,l=0;for(;n<a;n+=8){l=p[u++];i[d++]=128&l?v:w;i[d++]=64&l?v:w;i[d++]=32&l?v:w;i[d++]=16&l?v:w;i[d++]=8&l?v:w;i[d++]=4&l?v:w;i[d++]=2&l?v:w;i[d++]=1&l?v:w}for(;n<s;n++){if(0===o){l=p[u++];o=128}i[d++]=l&o?v:w;o>>=1}}for(;d<s;)i[d++]=0;e.putImageData(h,0,f*a)}}else if(t.kind===n.ImageKind.RGBA_32BPP){const t=!!(v||w||y);m=0;b=r*a*4;for(f=0;f<l;f++){g.set(p.subarray(u,u+b));u+=b;if(t)for(let e=0;e<b;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,m);m+=a}if(f<c){b=r*o*4;g.set(p.subarray(u,u+b));if(t)for(let e=0;e<b;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,m)}}else{if(t.kind!==n.ImageKind.RGB_24BPP)throw new Error(`bad image kind: ${t.kind}`);{const t=!!(v||w||y);_=a;b=r*_;for(f=0;f<c;f++){if(f>=l){_=o;b=r*_}d=0;for(m=b;m--;){g[d++]=p[u++];g[d++]=p[u++];g[d++]=p[u++];g[d++]=255}if(t)for(let e=0;e<d;e+=4){v&&(g[e+0]=v[g[e+0]]);w&&(g[e+1]=w[g[e+1]]);y&&(g[e+2]=y[g[e+2]])}e.putImageData(h,0,f*a)}}}}function putBinaryImageMask(e,t){const i=t.height,n=t.width,s=i%a,r=(i-s)/a,o=0===s?r:r+1,l=e.createImageData(n,a);let c=0;const h=t.data,d=l.data;for(let t=0;t<o;t++){const i=t<r?a:s;let o=3;for(let e=0;e<i;e++){let e,t=0;for(let i=0;i<n;i++){if(!t){e=h[c++];t=128}d[o]=e&t?0:255;o+=4;t>>=1}}e.putImageData(l,0,t*a)}}function copyCtxState(e,t){const i=["strokeStyle","fillStyle","fillRule","globalAlpha","lineWidth","lineCap","lineJoin","miterLimit","globalCompositeOperation","font"];for(let n=0,s=i.length;n<s;n++){const s=i[n];void 0!==e[s]&&(t[s]=e[s])}if(void 0!==e.setLineDash){t.setLineDash(e.getLineDash());t.lineDashOffset=e.lineDashOffset}}function resetCtxToDefault(e){e.strokeStyle="#000000";e.fillStyle="#000000";e.fillRule="nonzero";e.globalAlpha=1;e.lineWidth=1;e.lineCap="butt";e.lineJoin="miter";e.miterLimit=10;e.globalCompositeOperation="source-over";e.font="10px sans-serif";if(void 0!==e.setLineDash){e.setLineDash([]);e.lineDashOffset=0}}function composeSMaskBackdrop(e,t,i,n){const s=e.length;for(let r=3;r<s;r+=4){const s=e[r];if(0===s){e[r-3]=t;e[r-2]=i;e[r-1]=n}else if(s<255){const a=255-s;e[r-3]=e[r-3]*s+t*a>>8;e[r-2]=e[r-2]*s+i*a>>8;e[r-1]=e[r-1]*s+n*a>>8}}}function composeSMaskAlpha(e,t,i){const n=e.length;for(let s=3;s<n;s+=4){const n=i?i[e[s]]:e[s];t[s]=t[s]*n*.00392156862745098|0}}function composeSMaskLuminosity(e,t,i){const n=e.length;for(let s=3;s<n;s+=4){const n=77*e[s-3]+152*e[s-2]+28*e[s-1];t[s]=i?t[s]*i[n>>8]>>8:t[s]*n>>16}}function composeSMask(e,t,i){const n=t.canvas,s=t.context;e.setTransform(t.scaleX,0,0,t.scaleY,t.offsetX,t.offsetY);!function genericComposeSMask(e,t,i,n,s,r,a){const o=!!r,l=o?r[0]:0,c=o?r[1]:0,h=o?r[2]:0;let d;d="Luminosity"===s?composeSMaskLuminosity:composeSMaskAlpha;const u=Math.min(n,Math.ceil(1048576/i));for(let s=0;s<n;s+=u){const r=Math.min(u,n-s),p=e.getImageData(0,s,i,r),g=t.getImageData(0,s,i,r);o&&composeSMaskBackdrop(p.data,l,c,h);d(p.data,g.data,a);e.putImageData(g,0,s)}}(s,i,n.width,n.height,t.subtype,t.backdrop,t.transferMap);e.drawImage(n,0,0)}const e=["butt","round","square"],t=["miter","round","bevel"],i={},o={};class CanvasGraphics{constructor(e,t,i,n,s,r){this.ctx=e;this.current=new CanvasExtraState;this.stateStack=[];this.pendingClip=null;this.pendingEOFill=!1;this.res=null;this.xobjs=null;this.commonObjs=t;this.objs=i;this.canvasFactory=n;this.imageLayer=s;this.groupStack=[];this.processingType3=null;this.baseTransform=null;this.baseTransformStack=[];this.groupLevel=0;this.smaskStack=[];this.smaskCounter=0;this.tempSMask=null;this.contentVisible=!0;this.markedContentStack=[];this.optionalContentConfig=r;this.cachedCanvases=new CachedCanvases(this.canvasFactory);e&&addContextCurrentTransform(e);this._cachedGetSinglePixelWidth=null}beginDrawing({transform:e,viewport:t,transparency:i=!1,background:n=null}){const s=this.ctx.canvas.width,r=this.ctx.canvas.height;this.ctx.save();this.ctx.fillStyle=n||"rgb(255, 255, 255)";this.ctx.fillRect(0,0,s,r);this.ctx.restore();if(i){const e=this.cachedCanvases.getCanvas("transparent",s,r,!0);this.compositeCtx=this.ctx;this.transparentCanvas=e.canvas;this.ctx=e.context;this.ctx.save();this.ctx.transform.apply(this.ctx,this.compositeCtx.mozCurrentTransform)}this.ctx.save();resetCtxToDefault(this.ctx);e&&this.ctx.transform.apply(this.ctx,e);this.ctx.transform.apply(this.ctx,t.transform);this.baseTransform=this.ctx.mozCurrentTransform.slice();this._combinedScaleFactor=Math.hypot(this.baseTransform[0],this.baseTransform[2]);this.imageLayer&&this.imageLayer.beginLayout()}executeOperatorList(e,t,i,s){const r=e.argsArray,a=e.fnArray;let o=t||0;const l=r.length;if(l===o)return o;const c=l-o>10&&"function"==typeof i,h=c?Date.now()+15:0;let d=0;const u=this.commonObjs,p=this.objs;let g;for(;;){if(void 0!==s&&o===s.nextBreakPoint){s.breakIt(o,i);return o}g=a[o];if(g!==n.OPS.dependency)this[g].apply(this,r[o]);else for(const e of r[o]){const t=e.startsWith("g_")?u:p;if(!t.has(e)){t.get(e,i);return o}}o++;if(o===l)return o;if(c&&++d>10){if(Date.now()>h){i();return o}d=0}}}endDrawing(){for(;this.stateStack.length||null!==this.current.activeSMask;)this.restore();this.ctx.restore();if(this.transparentCanvas){this.ctx=this.compositeCtx;this.ctx.save();this.ctx.setTransform(1,0,0,1,0,0);this.ctx.drawImage(this.transparentCanvas,0,0);this.ctx.restore();this.transparentCanvas=null}this.cachedCanvases.clear();this.imageLayer&&this.imageLayer.endLayout()}setLineWidth(e){this.current.lineWidth=e;this.ctx.lineWidth=e}setLineCap(t){this.ctx.lineCap=e[t]}setLineJoin(e){this.ctx.lineJoin=t[e]}setMiterLimit(e){this.ctx.miterLimit=e}setDash(e,t){const i=this.ctx;if(void 0!==i.setLineDash){i.setLineDash(e);i.lineDashOffset=t}}setRenderingIntent(e){}setFlatness(e){}setGState(e){for(let t=0,i=e.length;t<i;t++){const i=e[t],n=i[0],s=i[1];switch(n){case"LW":this.setLineWidth(s);break;case"LC":this.setLineCap(s);break;case"LJ":this.setLineJoin(s);break;case"ML":this.setMiterLimit(s);break;case"D":this.setDash(s[0],s[1]);break;case"RI":this.setRenderingIntent(s);break;case"FL":this.setFlatness(s);break;case"Font":this.setFont(s[0],s[1]);break;case"CA":this.current.strokeAlpha=i[1];break;case"ca":this.current.fillAlpha=i[1];this.ctx.globalAlpha=i[1];break;case"BM":this.ctx.globalCompositeOperation=s;break;case"SMask":this.current.activeSMask&&(this.stateStack.length>0&&this.stateStack[this.stateStack.length-1].activeSMask===this.current.activeSMask?this.suspendSMaskGroup():this.endSMaskGroup());this.current.activeSMask=s?this.tempSMask:null;this.current.activeSMask&&this.beginSMaskGroup();this.tempSMask=null;break;case"TR":this.current.transferMaps=s}}}beginSMaskGroup(){const e=this.current.activeSMask,t=e.canvas.width,i=e.canvas.height,n="smaskGroupAt"+this.groupLevel,s=this.cachedCanvases.getCanvas(n,t,i,!0),r=this.ctx,a=r.mozCurrentTransform;this.ctx.save();const o=s.context;o.scale(1/e.scaleX,1/e.scaleY);o.translate(-e.offsetX,-e.offsetY);o.transform.apply(o,a);e.startTransformInverse=o.mozCurrentTransformInverse;copyCtxState(r,o);this.ctx=o;this.setGState([["BM","source-over"],["ca",1],["CA",1]]);this.groupStack.push(r);this.groupLevel++}suspendSMaskGroup(){const e=this.ctx;this.groupLevel--;this.ctx=this.groupStack.pop();composeSMask(this.ctx,this.current.activeSMask,e);this.ctx.restore();this.ctx.save();copyCtxState(e,this.ctx);this.current.resumeSMaskCtx=e;const t=n.Util.transform(this.current.activeSMask.startTransformInverse,e.mozCurrentTransform);this.ctx.transform.apply(this.ctx,t);e.save();e.setTransform(1,0,0,1,0,0);e.clearRect(0,0,e.canvas.width,e.canvas.height);e.restore()}resumeSMaskGroup(){const e=this.current.resumeSMaskCtx,t=this.ctx;this.ctx=e;this.groupStack.push(t);this.groupLevel++}endSMaskGroup(){const e=this.ctx;this.groupLevel--;this.ctx=this.groupStack.pop();composeSMask(this.ctx,this.current.activeSMask,e);this.ctx.restore();copyCtxState(e,this.ctx);const t=n.Util.transform(this.current.activeSMask.startTransformInverse,e.mozCurrentTransform);this.ctx.transform.apply(this.ctx,t)}save(){this.ctx.save();const e=this.current;this.stateStack.push(e);this.current=e.clone();this.current.resumeSMaskCtx=null}restore(){this.current.resumeSMaskCtx&&this.resumeSMaskGroup();null===this.current.activeSMask||0!==this.stateStack.length&&this.stateStack[this.stateStack.length-1].activeSMask===this.current.activeSMask||this.endSMaskGroup();if(0!==this.stateStack.length){this.current=this.stateStack.pop();this.ctx.restore();this.pendingClip=null;this._cachedGetSinglePixelWidth=null}else this.current.activeSMask=null}transform(e,t,i,n,s,r){this.ctx.transform(e,t,i,n,s,r);this._cachedGetSinglePixelWidth=null}constructPath(e,t){const i=this.ctx,s=this.current;let r=s.x,a=s.y;for(let s=0,o=0,l=e.length;s<l;s++)switch(0|e[s]){case n.OPS.rectangle:r=t[o++];a=t[o++];const e=t[o++],s=t[o++],l=r+e,c=a+s;i.moveTo(r,a);if(0===e||0===s)i.lineTo(l,c);else{i.lineTo(l,a);i.lineTo(l,c);i.lineTo(r,c)}i.closePath();break;case n.OPS.moveTo:r=t[o++];a=t[o++];i.moveTo(r,a);break;case n.OPS.lineTo:r=t[o++];a=t[o++];i.lineTo(r,a);break;case n.OPS.curveTo:r=t[o+4];a=t[o+5];i.bezierCurveTo(t[o],t[o+1],t[o+2],t[o+3],r,a);o+=6;break;case n.OPS.curveTo2:i.bezierCurveTo(r,a,t[o],t[o+1],t[o+2],t[o+3]);r=t[o+2];a=t[o+3];o+=4;break;case n.OPS.curveTo3:r=t[o+2];a=t[o+3];i.bezierCurveTo(t[o],t[o+1],r,a,r,a);o+=4;break;case n.OPS.closePath:i.closePath()}s.setCurrentPoint(r,a)}closePath(){this.ctx.closePath()}stroke(e){e=void 0===e||e;const t=this.ctx,i=this.current.strokeColor;t.globalAlpha=this.current.strokeAlpha;if(this.contentVisible)if("object"==typeof i&&i?.getPattern){const e=this.getSinglePixelWidth();t.save();t.strokeStyle=i.getPattern(t,this);t.lineWidth=Math.max(e,this.current.lineWidth);t.stroke();t.restore()}else{const e=this.getSinglePixelWidth();if(e<0&&-e>=this.current.lineWidth){t.save();t.resetTransform();t.lineWidth=Math.round(this._combinedScaleFactor);t.stroke();t.restore()}else{t.lineWidth=Math.max(e,this.current.lineWidth);t.stroke()}}e&&this.consumePath();t.globalAlpha=this.current.fillAlpha}closeStroke(){this.closePath();this.stroke()}fill(e){e=void 0===e||e;const t=this.ctx,i=this.current.fillColor;let n=!1;if(this.current.patternFill){t.save();t.fillStyle=i.getPattern(t,this);n=!0}if(this.contentVisible)if(this.pendingEOFill){t.fill("evenodd");this.pendingEOFill=!1}else t.fill();n&&t.restore();e&&this.consumePath()}eoFill(){this.pendingEOFill=!0;this.fill()}fillStroke(){this.fill(!1);this.stroke(!1);this.consumePath()}eoFillStroke(){this.pendingEOFill=!0;this.fillStroke()}closeFillStroke(){this.closePath();this.fillStroke()}closeEOFillStroke(){this.pendingEOFill=!0;this.closePath();this.fillStroke()}endPath(){this.consumePath()}clip(){this.pendingClip=i}eoClip(){this.pendingClip=o}beginText(){this.current.textMatrix=n.IDENTITY_MATRIX;this.current.textMatrixScale=1;this.current.x=this.current.lineX=0;this.current.y=this.current.lineY=0}endText(){const e=this.pendingTextPaths,t=this.ctx;if(void 0!==e){t.save();t.beginPath();for(let i=0;i<e.length;i++){const n=e[i];t.setTransform.apply(t,n.transform);t.translate(n.x,n.y);n.addToPath(t,n.fontSize)}t.restore();t.clip();t.beginPath();delete this.pendingTextPaths}else t.beginPath()}setCharSpacing(e){this.current.charSpacing=e}setWordSpacing(e){this.current.wordSpacing=e}setHScale(e){this.current.textHScale=e/100}setLeading(e){this.current.leading=-e}setFont(e,t){const i=this.commonObjs.get(e),s=this.current;if(!i)throw new Error(`Can't find font for ${e}`);s.fontMatrix=i.fontMatrix||n.FONT_IDENTITY_MATRIX;0!==s.fontMatrix[0]&&0!==s.fontMatrix[3]||(0,n.warn)("Invalid font matrix for font "+e);if(t<0){t=-t;s.fontDirection=-1}else s.fontDirection=1;this.current.font=i;this.current.fontSize=t;if(i.isType3Font)return;const r=i.loadedName||"sans-serif";let a="normal";i.black?a="900":i.bold&&(a="bold");const o=i.italic?"italic":"normal",l=`"${r}", ${i.fallbackName}`;let c=t;t<16?c=16:t>100&&(c=100);this.current.fontSizeScale=t/c;this.ctx.font=`${o} ${a} ${c}px ${l}`}setTextRenderingMode(e){this.current.textRenderingMode=e}setTextRise(e){this.current.textRise=e}moveText(e,t){this.current.x=this.current.lineX+=e;this.current.y=this.current.lineY+=t}setLeadingMoveText(e,t){this.setLeading(-t);this.moveText(e,t)}setTextMatrix(e,t,i,n,s,r){this.current.textMatrix=[e,t,i,n,s,r];this.current.textMatrixScale=Math.hypot(e,t);this.current.x=this.current.lineX=0;this.current.y=this.current.lineY=0}nextLine(){this.moveText(0,this.current.leading)}paintChar(e,t,i,s,r){const a=this.ctx,o=this.current,l=o.font,c=o.textRenderingMode,h=o.fontSize/o.fontSizeScale,d=c&n.TextRenderingMode.FILL_STROKE_MASK,u=!!(c&n.TextRenderingMode.ADD_TO_PATH_FLAG),p=o.patternFill&&!l.missingFile;let g;(l.disableFontFace||u||p)&&(g=l.getPathGenerator(this.commonObjs,e));if(l.disableFontFace||p){a.save();a.translate(t,i);a.beginPath();g(a,h);s&&a.setTransform.apply(a,s);d!==n.TextRenderingMode.FILL&&d!==n.TextRenderingMode.FILL_STROKE||a.fill();if(d===n.TextRenderingMode.STROKE||d===n.TextRenderingMode.FILL_STROKE){if(r){a.resetTransform();a.lineWidth=Math.round(this._combinedScaleFactor)}a.stroke()}a.restore()}else{d!==n.TextRenderingMode.FILL&&d!==n.TextRenderingMode.FILL_STROKE||a.fillText(e,t,i);if(d===n.TextRenderingMode.STROKE||d===n.TextRenderingMode.FILL_STROKE)if(r){a.save();a.moveTo(t,i);a.resetTransform();a.lineWidth=Math.round(this._combinedScaleFactor);a.strokeText(e,0,0);a.restore()}else a.strokeText(e,t,i)}if(u){(this.pendingTextPaths||(this.pendingTextPaths=[])).push({transform:a.mozCurrentTransform,x:t,y:i,fontSize:h,addToPath:g})}}get isFontSubpixelAAEnabled(){const{context:e}=this.cachedCanvases.getCanvas("isFontSubpixelAAEnabled",10,10);e.scale(1.5,1);e.fillText("I",0,10);const t=e.getImageData(0,0,10,10).data;let i=!1;for(let e=3;e<t.length;e+=4)if(t[e]>0&&t[e]<255){i=!0;break}return(0,n.shadow)(this,"isFontSubpixelAAEnabled",i)}showText(e){const t=this.current,i=t.font;if(i.isType3Font)return this.showType3Text(e);const s=t.fontSize;if(0===s)return;const r=this.ctx,a=t.fontSizeScale,o=t.charSpacing,l=t.wordSpacing,c=t.fontDirection,h=t.textHScale*c,d=e.length,u=i.vertical,p=u?1:-1,g=i.defaultVMetrics,f=s*t.fontMatrix[0],m=t.textRenderingMode===n.TextRenderingMode.FILL&&!i.disableFontFace&&!t.patternFill;r.save();let _;if(t.patternFill){r.save();const e=t.fillColor.getPattern(r,this);_=r.mozCurrentTransform;r.restore();r.fillStyle=e}r.transform.apply(r,t.textMatrix);r.translate(t.x,t.y+t.textRise);c>0?r.scale(h,-1):r.scale(h,1);let b=t.lineWidth,v=!1;const w=t.textMatrixScale;if(0===w||0===b){const e=t.textRenderingMode&n.TextRenderingMode.FILL_STROKE_MASK;if(e===n.TextRenderingMode.STROKE||e===n.TextRenderingMode.FILL_STROKE){this._cachedGetSinglePixelWidth=null;b=this.getSinglePixelWidth();v=b<0}}else b/=w;if(1!==a){r.scale(a,a);b/=a}r.lineWidth=b;let y,S=0;for(y=0;y<d;++y){const t=e[y];if((0,n.isNum)(t)){S+=p*t*s/1e3;continue}let h=!1;const d=(t.isSpace?l:0)+o,b=t.fontChar,w=t.accent;let P,A,C,x=t.width;if(u){const e=t.vmetric||g,i=-(t.vmetric?e[1]:.5*x)*f,n=e[2]*f;x=e?-e[0]:x;P=i/a;A=(S+n)/a}else{P=S/a;A=0}if(i.remeasure&&x>0){const e=1e3*r.measureText(b).width/s*a;if(x<e&&this.isFontSubpixelAAEnabled){const t=x/e;h=!0;r.save();r.scale(t,1);P/=t}else x!==e&&(P+=(x-e)/2e3*s/a)}if(this.contentVisible&&(t.isInFont||i.missingFile))if(m&&!w)r.fillText(b,P,A);else{this.paintChar(b,P,A,_,v);if(w){const e=P+s*w.offset.x/a,t=A-s*w.offset.y/a;this.paintChar(w.fontChar,e,t,_,v)}}C=u?x*f-d*c:x*f+d*c;S+=C;h&&r.restore()}u?t.y-=S:t.x+=S*h;r.restore()}showType3Text(e){const t=this.ctx,i=this.current,s=i.font,r=i.fontSize,a=i.fontDirection,o=s.vertical?1:-1,l=i.charSpacing,c=i.wordSpacing,h=i.textHScale*a,d=i.fontMatrix||n.FONT_IDENTITY_MATRIX,u=e.length;let p,g,f,m;if(!(i.textRenderingMode===n.TextRenderingMode.INVISIBLE)&&0!==r){this._cachedGetSinglePixelWidth=null;t.save();t.transform.apply(t,i.textMatrix);t.translate(i.x,i.y);t.scale(h,a);for(p=0;p<u;++p){g=e[p];if((0,n.isNum)(g)){m=o*g*r/1e3;this.ctx.translate(m,0);i.x+=m*h;continue}const a=(g.isSpace?c:0)+l,u=s.charProcOperatorList[g.operatorListId];if(!u){(0,n.warn)(`Type3 character "${g.operatorListId}" is not available.`);continue}if(this.contentVisible){this.processingType3=g;this.save();t.scale(r,r);t.transform.apply(t,d);this.executeOperatorList(u);this.restore()}f=n.Util.applyTransform([g.width,0],d)[0]*r+a;t.translate(f,0);i.x+=f*h}t.restore();this.processingType3=null}}setCharWidth(e,t){}setCharWidthAndBounds(e,t,i,n,s,r){this.ctx.rect(i,n,s-i,r-n);this.clip();this.endPath()}getColorN_Pattern(e){let t;if("TilingPattern"===e[0]){const i=e[1],n=this.baseTransform||this.ctx.mozCurrentTransform.slice(),r={createCanvasGraphics:e=>new CanvasGraphics(e,this.commonObjs,this.objs,this.canvasFactory)};t=new s.TilingPattern(e,i,this.ctx,r,n)}else t=(0,s.getShadingPattern)(e);return t}setStrokeColorN(){this.current.strokeColor=this.getColorN_Pattern(arguments)}setFillColorN(){this.current.fillColor=this.getColorN_Pattern(arguments);this.current.patternFill=!0}setStrokeRGBColor(e,t,i){const s=n.Util.makeHexColor(e,t,i);this.ctx.strokeStyle=s;this.current.strokeColor=s}setFillRGBColor(e,t,i){const s=n.Util.makeHexColor(e,t,i);this.ctx.fillStyle=s;this.current.fillColor=s;this.current.patternFill=!1}shadingFill(e){if(!this.contentVisible)return;const t=this.ctx;this.save();const i=(0,s.getShadingPattern)(e);t.fillStyle=i.getPattern(t,this,!0);const r=t.mozCurrentTransformInverse;if(r){const e=t.canvas,i=e.width,s=e.height,a=n.Util.applyTransform([0,0],r),o=n.Util.applyTransform([0,s],r),l=n.Util.applyTransform([i,0],r),c=n.Util.applyTransform([i,s],r),h=Math.min(a[0],o[0],l[0],c[0]),d=Math.min(a[1],o[1],l[1],c[1]),u=Math.max(a[0],o[0],l[0],c[0]),p=Math.max(a[1],o[1],l[1],c[1]);this.ctx.fillRect(h,d,u-h,p-d)}else this.ctx.fillRect(-1e10,-1e10,2e10,2e10);this.restore()}beginInlineImage(){(0,n.unreachable)("Should not call beginInlineImage")}beginImageData(){(0,n.unreachable)("Should not call beginImageData")}paintFormXObjectBegin(e,t){if(this.contentVisible){this.save();this.baseTransformStack.push(this.baseTransform);Array.isArray(e)&&6===e.length&&this.transform.apply(this,e);this.baseTransform=this.ctx.mozCurrentTransform;if(t){const e=t[2]-t[0],i=t[3]-t[1];this.ctx.rect(t[0],t[1],e,i);this.clip();this.endPath()}}}paintFormXObjectEnd(){if(this.contentVisible){this.restore();this.baseTransform=this.baseTransformStack.pop()}}beginGroup(e){if(!this.contentVisible)return;this.save();const t=this.ctx;e.isolated||(0,n.info)("TODO: Support non-isolated groups.");e.knockout&&(0,n.warn)("Knockout groups not supported.");const i=t.mozCurrentTransform;e.matrix&&t.transform.apply(t,e.matrix);if(!e.bbox)throw new Error("Bounding box is required.");let s=n.Util.getAxialAlignedBoundingBox(e.bbox,t.mozCurrentTransform);const a=[0,0,t.canvas.width,t.canvas.height];s=n.Util.intersect(s,a)||[0,0,0,0];const o=Math.floor(s[0]),l=Math.floor(s[1]);let c=Math.max(Math.ceil(s[2])-o,1),h=Math.max(Math.ceil(s[3])-l,1),d=1,u=1;if(c>r){d=c/r;c=r}if(h>r){u=h/r;h=r}let p="groupAt"+this.groupLevel;e.smask&&(p+="_smask_"+this.smaskCounter++%2);const g=this.cachedCanvases.getCanvas(p,c,h,!0),f=g.context;f.scale(1/d,1/u);f.translate(-o,-l);f.transform.apply(f,i);if(e.smask)this.smaskStack.push({canvas:g.canvas,context:f,offsetX:o,offsetY:l,scaleX:d,scaleY:u,subtype:e.smask.subtype,backdrop:e.smask.backdrop,transferMap:e.smask.transferMap||null,startTransformInverse:null});else{t.setTransform(1,0,0,1,0,0);t.translate(o,l);t.scale(d,u)}copyCtxState(t,f);this.ctx=f;this.setGState([["BM","source-over"],["ca",1],["CA",1]]);this.groupStack.push(t);this.groupLevel++;this.current.activeSMask=null}endGroup(e){if(!this.contentVisible)return;this.groupLevel--;const t=this.ctx;this.ctx=this.groupStack.pop();void 0!==this.ctx.imageSmoothingEnabled?this.ctx.imageSmoothingEnabled=!1:this.ctx.mozImageSmoothingEnabled=!1;e.smask?this.tempSMask=this.smaskStack.pop():this.ctx.drawImage(t.canvas,0,0);this.restore()}beginAnnotations(){this.save();this.baseTransform&&this.ctx.setTransform.apply(this.ctx,this.baseTransform)}endAnnotations(){this.restore()}beginAnnotation(e,t,i){this.save();resetCtxToDefault(this.ctx);this.current=new CanvasExtraState;if(Array.isArray(e)&&4===e.length){const t=e[2]-e[0],i=e[3]-e[1];this.ctx.rect(e[0],e[1],t,i);this.clip();this.endPath()}this.transform.apply(this,t);this.transform.apply(this,i)}endAnnotation(){this.restore()}paintImageMaskXObject(e){if(!this.contentVisible)return;const t=this.ctx,i=e.width,n=e.height,s=this.current.fillColor,r=this.current.patternFill,a=this.processingType3;a&&void 0===a.compiled&&(a.compiled=i<=1e3&&n<=1e3?function compileType3Glyph(e){const t=new Uint8Array([0,2,4,0,1,0,5,4,8,10,0,8,0,2,1,0]),i=e.width,n=e.height,s=i+1;let r,a,o,l;const c=new Uint8Array(s*(n+1)),h=i+7&-8,d=e.data,u=new Uint8Array(h*n);let p=0;for(r=0,a=d.length;r<a;r++){const e=d[r];let t=128;for(;t>0;){u[p++]=e&t?0:255;t>>=1}}let g=0;p=0;if(0!==u[p]){c[0]=1;++g}for(o=1;o<i;o++){if(u[p]!==u[p+1]){c[o]=u[p]?2:1;++g}p++}if(0!==u[p]){c[o]=2;++g}for(r=1;r<n;r++){p=r*h;l=r*s;if(u[p-h]!==u[p]){c[l]=u[p]?1:8;++g}let e=(u[p]?4:0)+(u[p-h]?8:0);for(o=1;o<i;o++){e=(e>>2)+(u[p+1]?4:0)+(u[p-h+1]?8:0);if(t[e]){c[l+o]=t[e];++g}p++}if(u[p-h]!==u[p]){c[l+o]=u[p]?2:4;++g}if(g>1e3)return null}p=h*(n-1);l=r*s;if(0!==u[p]){c[l]=8;++g}for(o=1;o<i;o++){if(u[p]!==u[p+1]){c[l+o]=u[p]?4:8;++g}p++}if(0!==u[p]){c[l+o]=4;++g}if(g>1e3)return null;const f=new Int32Array([0,s,-1,0,-s,0,0,0,1]),m=[];for(r=0;g&&r<=n;r++){let e=r*s;const t=e+i;for(;e<t&&!c[e];)e++;if(e===t)continue;const n=[e%s,r],a=e;let o=c[e];do{const t=f[o];do{e+=t}while(!c[e]);const i=c[e];if(5!==i&&10!==i){o=i;c[e]=0}else{o=i&51*o>>4;c[e]&=o>>2|o<<2}n.push(e%s,e/s|0);c[e]||--g}while(a!==e);m.push(n);--r}return function(e){e.save();e.scale(1/i,-1/n);e.translate(0,-n);e.beginPath();for(let t=0,i=m.length;t<i;t++){const i=m[t];e.moveTo(i[0],i[1]);for(let t=2,n=i.length;t<n;t+=2)e.lineTo(i[t],i[t+1])}e.fill();e.beginPath();e.restore()}}({data:e.data,width:i,height:n}):null);if(a?.compiled){a.compiled(t);return}const o=this.cachedCanvases.getCanvas("maskCanvas",i,n),l=o.context;l.save();putBinaryImageMask(l,e);l.globalCompositeOperation="source-in";l.fillStyle=r?s.getPattern(l,this):s;l.fillRect(0,0,i,n);l.restore();this.paintInlineImageXObject(o.canvas)}paintImageMaskXObjectRepeat(e,t,i=0,n=0,s,r){if(!this.contentVisible)return;const a=e.width,o=e.height,l=this.current.fillColor,c=this.current.patternFill,h=this.cachedCanvases.getCanvas("maskCanvas",a,o),d=h.context;d.save();putBinaryImageMask(d,e);d.globalCompositeOperation="source-in";d.fillStyle=c?l.getPattern(d,this):l;d.fillRect(0,0,a,o);d.restore();const u=this.ctx;for(let e=0,l=r.length;e<l;e+=2){u.save();u.transform(t,i,n,s,r[e],r[e+1]);u.scale(1,-1);u.drawImage(h.canvas,0,0,a,o,0,-1,1,1);u.restore()}}paintImageMaskXObjectGroup(e){if(!this.contentVisible)return;const t=this.ctx,i=this.current.fillColor,n=this.current.patternFill;for(let s=0,r=e.length;s<r;s++){const r=e[s],a=r.width,o=r.height,l=this.cachedCanvases.getCanvas("maskCanvas",a,o),c=l.context;c.save();putBinaryImageMask(c,r);c.globalCompositeOperation="source-in";c.fillStyle=n?i.getPattern(c,this):i;c.fillRect(0,0,a,o);c.restore();t.save();t.transform.apply(t,r.transform);t.scale(1,-1);t.drawImage(l.canvas,0,0,a,o,0,-1,1,1);t.restore()}}paintImageXObject(e){if(!this.contentVisible)return;const t=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);t?this.paintInlineImageXObject(t):(0,n.warn)("Dependent image isn't ready yet")}paintImageXObjectRepeat(e,t,i,s){if(!this.contentVisible)return;const r=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);if(!r){(0,n.warn)("Dependent image isn't ready yet");return}const a=r.width,o=r.height,l=[];for(let e=0,n=s.length;e<n;e+=2)l.push({transform:[t,0,0,i,s[e],s[e+1]],x:0,y:0,w:a,h:o});this.paintInlineImageXObjectGroup(r,l)}paintInlineImageXObject(e){if(!this.contentVisible)return;const t=e.width,i=e.height,n=this.ctx;this.save();n.scale(1/t,-1/i);const s=n.mozCurrentTransformInverse;let r,a,o,l=Math.max(Math.hypot(s[0],s[1]),1),c=Math.max(Math.hypot(s[2],s[3]),1);if("function"==typeof HTMLElement&&e instanceof HTMLElement||!e.data)r=e;else{a=this.cachedCanvases.getCanvas("inlineImage",t,i);o=a.context;putBinaryImageData(o,e,this.current.transferMaps);r=a.canvas}let h=t,d=i,u="prescale1";for(;l>2&&h>1||c>2&&d>1;){let e=h,t=d;if(l>2&&h>1){e=Math.ceil(h/2);l/=h/e}if(c>2&&d>1){t=Math.ceil(d/2);c/=d/t}a=this.cachedCanvases.getCanvas(u,e,t);o=a.context;o.clearRect(0,0,e,t);o.drawImage(r,0,0,h,d,0,0,e,t);r=a.canvas;h=e;d=t;u="prescale1"===u?"prescale2":"prescale1"}n.drawImage(r,0,0,h,d,0,-i,t,i);if(this.imageLayer){const n=this.getCanvasPosition(0,-i);this.imageLayer.appendImage({imgData:e,left:n[0],top:n[1],width:t/s[0],height:i/s[3]})}this.restore()}paintInlineImageXObjectGroup(e,t){if(!this.contentVisible)return;const i=this.ctx,n=e.width,s=e.height,r=this.cachedCanvases.getCanvas("inlineImage",n,s);putBinaryImageData(r.context,e,this.current.transferMaps);for(let a=0,o=t.length;a<o;a++){const o=t[a];i.save();i.transform.apply(i,o.transform);i.scale(1,-1);i.drawImage(r.canvas,o.x,o.y,o.w,o.h,0,-1,1,1);if(this.imageLayer){const t=this.getCanvasPosition(o.x,o.y);this.imageLayer.appendImage({imgData:e,left:t[0],top:t[1],width:n,height:s})}i.restore()}}paintSolidColorImageMask(){this.contentVisible&&this.ctx.fillRect(0,0,1,1)}markPoint(e){}markPointProps(e,t){}beginMarkedContent(e){this.markedContentStack.push({visible:!0})}beginMarkedContentProps(e,t){"OC"===e?this.markedContentStack.push({visible:this.optionalContentConfig.isVisible(t)}):this.markedContentStack.push({visible:!0});this.contentVisible=this.isContentVisible()}endMarkedContent(){this.markedContentStack.pop();this.contentVisible=this.isContentVisible()}beginCompat(){}endCompat(){}consumePath(){const e=this.ctx;if(this.pendingClip){this.pendingClip===o?e.clip("evenodd"):e.clip();this.pendingClip=null}e.beginPath()}getSinglePixelWidth(){if(null===this._cachedGetSinglePixelWidth){const e=this.ctx.mozCurrentTransform,t=Math.abs(e[0]*e[3]-e[2]*e[1]),i=e[0]**2+e[2]**2,n=e[1]**2+e[3]**2,s=Math.sqrt(Math.max(i,n))/t;i!==n&&this._combinedScaleFactor*s>1?this._cachedGetSinglePixelWidth=-this._combinedScaleFactor*s:t>Number.EPSILON?this._cachedGetSinglePixelWidth=s:this._cachedGetSinglePixelWidth=1}return this._cachedGetSinglePixelWidth}getCanvasPosition(e,t){const i=this.ctx.mozCurrentTransform;return[i[0]*e+i[2]*t+i[4],i[1]*e+i[3]*t+i[5]]}isContentVisible(){for(let e=this.markedContentStack.length-1;e>=0;e--)if(!this.markedContentStack[e].visible)return!1;return!0}}for(const e in n.OPS)CanvasGraphics.prototype[n.OPS[e]]=CanvasGraphics.prototype[e];return CanvasGraphics}();t.CanvasGraphics=o},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getShadingPattern=function getShadingPattern(e){switch(e[0]){case"RadialAxial":return new RadialAxialShadingPattern(e);case"Mesh":return new MeshShadingPattern(e);case"Dummy":return new DummyShadingPattern}throw new Error(`Unknown IR type: ${e[0]}`)};t.TilingPattern=void 0;var n=i(2);let s;function createMatrix(e){if("undefined"!=typeof DOMMatrix)return new DOMMatrix(e);s||(s=document.createElementNS("http://www.w3.org/2000/svg","svg"));return s.createSVGMatrix(e)}function applyBoundingBox(e,t){if(!t||"undefined"==typeof Path2D)return;const i=t[2]-t[0],n=t[3]-t[1],s=new Path2D;s.rect(t[0],t[1],i,n);e.clip(s)}class BaseShadingPattern{constructor(){this.constructor===BaseShadingPattern&&(0,n.unreachable)("Cannot initialize BaseShadingPattern.")}getPattern(){(0,n.unreachable)("Abstract method `getPattern` called.")}}class RadialAxialShadingPattern extends BaseShadingPattern{constructor(e){super();this._type=e[1];this._bbox=e[2];this._colorStops=e[3];this._p0=e[4];this._p1=e[5];this._r0=e[6];this._r1=e[7];this._matrix=e[8]}getPattern(e,t,i){const n=t.cachedCanvases.getCanvas("pattern",e.canvas.width,e.canvas.height,!0),s=n.context;s.clearRect(0,0,s.canvas.width,s.canvas.height);s.beginPath();s.rect(0,0,s.canvas.width,s.canvas.height);if(i)s.setTransform.apply(s,e.mozCurrentTransform);else{s.setTransform.apply(s,t.baseTransform);this._matrix&&s.transform.apply(s,this._matrix)}applyBoundingBox(s,this._bbox);let r;"axial"===this._type?r=s.createLinearGradient(this._p0[0],this._p0[1],this._p1[0],this._p1[1]):"radial"===this._type&&(r=s.createRadialGradient(this._p0[0],this._p0[1],this._r0,this._p1[0],this._p1[1],this._r1));for(const e of this._colorStops)r.addColorStop(e[0],e[1]);s.fillStyle=r;s.fill();const a=e.createPattern(n.canvas,"repeat");a.setTransform(createMatrix(e.mozCurrentTransformInverse));return a}}function drawTriangle(e,t,i,n,s,r,a,o){const l=t.coords,c=t.colors,h=e.data,d=4*e.width;let u;if(l[i+1]>l[n+1]){u=i;i=n;n=u;u=r;r=a;a=u}if(l[n+1]>l[s+1]){u=n;n=s;s=u;u=a;a=o;o=u}if(l[i+1]>l[n+1]){u=i;i=n;n=u;u=r;r=a;a=u}const p=(l[i]+t.offsetX)*t.scaleX,g=(l[i+1]+t.offsetY)*t.scaleY,f=(l[n]+t.offsetX)*t.scaleX,m=(l[n+1]+t.offsetY)*t.scaleY,_=(l[s]+t.offsetX)*t.scaleX,b=(l[s+1]+t.offsetY)*t.scaleY;if(g>=b)return;const v=c[r],w=c[r+1],y=c[r+2],S=c[a],P=c[a+1],A=c[a+2],C=c[o],x=c[o+1],E=c[o+2],T=Math.round(g),k=Math.round(b);let L,R,I,F,M,D,N,O;for(let e=T;e<=k;e++){if(e<m){let t;t=e<g?0:g===m?1:(g-e)/(g-m);L=p-(p-f)*t;R=v-(v-S)*t;I=w-(w-P)*t;F=y-(y-A)*t}else{let t;t=e>b?1:m===b?0:(m-e)/(m-b);L=f-(f-_)*t;R=S-(S-C)*t;I=P-(P-x)*t;F=A-(A-E)*t}let t;t=e<g?0:e>b?1:(g-e)/(g-b);M=p-(p-_)*t;D=v-(v-C)*t;N=w-(w-x)*t;O=y-(y-E)*t;const i=Math.round(Math.min(L,M)),n=Math.round(Math.max(L,M));let s=d*e+4*i;for(let e=i;e<=n;e++){t=(L-e)/(L-M);t<0?t=0:t>1&&(t=1);h[s++]=R-(R-D)*t|0;h[s++]=I-(I-N)*t|0;h[s++]=F-(F-O)*t|0;h[s++]=255}}}function drawFigure(e,t,i){const n=t.coords,s=t.colors;let r,a;switch(t.type){case"lattice":const o=t.verticesPerRow,l=Math.floor(n.length/o)-1,c=o-1;for(r=0;r<l;r++){let t=r*o;for(let r=0;r<c;r++,t++){drawTriangle(e,i,n[t],n[t+1],n[t+o],s[t],s[t+1],s[t+o]);drawTriangle(e,i,n[t+o+1],n[t+1],n[t+o],s[t+o+1],s[t+1],s[t+o])}}break;case"triangles":for(r=0,a=n.length;r<a;r+=3)drawTriangle(e,i,n[r],n[r+1],n[r+2],s[r],s[r+1],s[r+2]);break;default:throw new Error("illegal figure")}}class MeshShadingPattern extends BaseShadingPattern{constructor(e){super();this._coords=e[2];this._colors=e[3];this._figures=e[4];this._bounds=e[5];this._matrix=e[6];this._bbox=e[7];this._background=e[8]}_createMeshCanvas(e,t,i){const n=Math.floor(this._bounds[0]),s=Math.floor(this._bounds[1]),r=Math.ceil(this._bounds[2])-n,a=Math.ceil(this._bounds[3])-s,o=Math.min(Math.ceil(Math.abs(r*e[0]*1.1)),3e3),l=Math.min(Math.ceil(Math.abs(a*e[1]*1.1)),3e3),c=r/o,h=a/l,d={coords:this._coords,colors:this._colors,offsetX:-n,offsetY:-s,scaleX:1/c,scaleY:1/h},u=o+4,p=l+4,g=i.getCanvas("mesh",u,p,!1),f=g.context,m=f.createImageData(o,l);if(t){const e=m.data;for(let i=0,n=e.length;i<n;i+=4){e[i]=t[0];e[i+1]=t[1];e[i+2]=t[2];e[i+3]=255}}for(const e of this._figures)drawFigure(m,e,d);f.putImageData(m,2,2);return{canvas:g.canvas,offsetX:n-2*c,offsetY:s-2*h,scaleX:c,scaleY:h}}getPattern(e,t,i){applyBoundingBox(e,this._bbox);let s;if(i)s=n.Util.singularValueDecompose2dScale(e.mozCurrentTransform);else{s=n.Util.singularValueDecompose2dScale(t.baseTransform);if(this._matrix){const e=n.Util.singularValueDecompose2dScale(this._matrix);s=[s[0]*e[0],s[1]*e[1]]}}const r=this._createMeshCanvas(s,i?null:this._background,t.cachedCanvases);if(!i){e.setTransform.apply(e,t.baseTransform);this._matrix&&e.transform.apply(e,this._matrix)}e.translate(r.offsetX,r.offsetY);e.scale(r.scaleX,r.scaleY);return e.createPattern(r.canvas,"no-repeat")}}class DummyShadingPattern extends BaseShadingPattern{getPattern(){return"hotpink"}}const r=1,a=2;class TilingPattern{static get MAX_PATTERN_SIZE(){return(0,n.shadow)(this,"MAX_PATTERN_SIZE",3e3)}constructor(e,t,i,n,s){this.operatorList=e[2];this.matrix=e[3]||[1,0,0,1,0,0];this.bbox=e[4];this.xstep=e[5];this.ystep=e[6];this.paintType=e[7];this.tilingType=e[8];this.color=t;this.ctx=i;this.canvasGraphicsFactory=n;this.baseTransform=s}createPatternCanvas(e){const t=this.operatorList,i=this.bbox,s=this.xstep,r=this.ystep,a=this.paintType,o=this.tilingType,l=this.color,c=this.canvasGraphicsFactory;(0,n.info)("TilingType: "+o);const h=i[0],d=i[1],u=i[2],p=i[3],g=n.Util.singularValueDecompose2dScale(this.matrix),f=n.Util.singularValueDecompose2dScale(this.baseTransform),m=[g[0]*f[0],g[1]*f[1]],_=this.getSizeAndScale(s,this.ctx.canvas.width,m[0]),b=this.getSizeAndScale(r,this.ctx.canvas.height,m[1]),v=e.cachedCanvases.getCanvas("pattern",_.size,b.size,!0),w=v.context,y=c.createCanvasGraphics(w);y.groupLevel=e.groupLevel;this.setFillAndStrokeStyleToContext(y,a,l);y.transform(_.scale,0,0,b.scale,0,0);this.clipBbox(y,i,h,d,u,p);y.baseTransform=y.ctx.mozCurrentTransform.slice();y.executeOperatorList(t);y.endDrawing();return{canvas:v.canvas,scaleX:_.scale,scaleY:b.scale}}getSizeAndScale(e,t,i){e=Math.abs(e);const n=Math.max(TilingPattern.MAX_PATTERN_SIZE,t);let s=Math.ceil(e*i);s>=n?s=n:i=s/e;return{scale:i,size:s}}clipBbox(e,t,i,n,s,r){if(Array.isArray(t)&&4===t.length){const t=s-i,a=r-n;e.ctx.rect(i,n,t,a);e.clip();e.endPath()}}setFillAndStrokeStyleToContext(e,t,i){const s=e.ctx,o=e.current;switch(t){case r:const e=this.ctx;s.fillStyle=e.fillStyle;s.strokeStyle=e.strokeStyle;o.fillColor=e.fillStyle;o.strokeColor=e.strokeStyle;break;case a:const l=n.Util.makeHexColor(i[0],i[1],i[2]);s.fillStyle=l;s.strokeStyle=l;o.fillColor=l;o.strokeColor=l;break;default:throw new n.FormatError(`Unsupported paint type: ${t}`)}}getPattern(e,t,i){let s=(e=this.ctx).mozCurrentTransformInverse;if(!i){s=n.Util.transform(s,t.baseTransform);this.matrix&&(s=n.Util.transform(s,this.matrix))}const r=this.createPatternCanvas(t);let a=createMatrix(s);a=a.scale(1/r.scaleX,1/r.scaleY);const o=e.createPattern(r.canvas,"repeat");o.setTransform(a);return o}}t.TilingPattern=TilingPattern},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GlobalWorkerOptions=void 0;const i=Object.create(null);t.GlobalWorkerOptions=i;i.workerPort=void 0===i.workerPort?null:i.workerPort;i.workerSrc=void 0===i.workerSrc?"":i.workerSrc},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.MessageHandler=void 0;var n=i(2);const s=1,r=2,a=1,o=2,l=3,c=4,h=5,d=6,u=7,p=8;function wrapReason(e){if("object"!=typeof e||null===e)return e;switch(e.name){case"AbortException":return new n.AbortException(e.message);case"MissingPDFException":return new n.MissingPDFException(e.message);case"UnexpectedResponseException":return new n.UnexpectedResponseException(e.message,e.status);case"UnknownErrorException":return new n.UnknownErrorException(e.message,e.details);default:return new n.UnknownErrorException(e.message,e.toString())}}t.MessageHandler=class MessageHandler{constructor(e,t,i){this.sourceName=e;this.targetName=t;this.comObj=i;this.callbackId=1;this.streamId=1;this.postMessageTransfers=!0;this.streamSinks=Object.create(null);this.streamControllers=Object.create(null);this.callbackCapabilities=Object.create(null);this.actionHandler=Object.create(null);this._onComObjOnMessage=e=>{const t=e.data;if(t.targetName!==this.sourceName)return;if(t.stream){this._processStreamMessage(t);return}if(t.callback){const e=t.callbackId,i=this.callbackCapabilities[e];if(!i)throw new Error(`Cannot resolve callback ${e}`);delete this.callbackCapabilities[e];if(t.callback===s)i.resolve(t.data);else{if(t.callback!==r)throw new Error("Unexpected callback case");i.reject(wrapReason(t.reason))}return}const n=this.actionHandler[t.action];if(!n)throw new Error(`Unknown action from worker: ${t.action}`);if(t.callbackId){const e=this.sourceName,a=t.sourceName;new Promise((function(e){e(n(t.data))})).then((function(n){i.postMessage({sourceName:e,targetName:a,callback:s,callbackId:t.callbackId,data:n})}),(function(n){i.postMessage({sourceName:e,targetName:a,callback:r,callbackId:t.callbackId,reason:wrapReason(n)})}))}else t.streamId?this._createStreamSink(t):n(t.data)};i.addEventListener("message",this._onComObjOnMessage)}on(e,t){const i=this.actionHandler;if(i[e])throw new Error(`There is already an actionName called "${e}"`);i[e]=t}send(e,t,i){this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,data:t},i)}sendWithPromise(e,t,i){const s=this.callbackId++,r=(0,n.createPromiseCapability)();this.callbackCapabilities[s]=r;try{this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,callbackId:s,data:t},i)}catch(e){r.reject(e)}return r.promise}sendWithStream(e,t,i,s){const r=this.streamId++,o=this.sourceName,l=this.targetName,c=this.comObj;return new ReadableStream({start:i=>{const a=(0,n.createPromiseCapability)();this.streamControllers[r]={controller:i,startCall:a,pullCall:null,cancelCall:null,isClosed:!1};this._postMessage({sourceName:o,targetName:l,action:e,streamId:r,data:t,desiredSize:i.desiredSize},s);return a.promise},pull:e=>{const t=(0,n.createPromiseCapability)();this.streamControllers[r].pullCall=t;c.postMessage({sourceName:o,targetName:l,stream:d,streamId:r,desiredSize:e.desiredSize});return t.promise},cancel:e=>{(0,n.assert)(e instanceof Error,"cancel must have a valid reason");const t=(0,n.createPromiseCapability)();this.streamControllers[r].cancelCall=t;this.streamControllers[r].isClosed=!0;c.postMessage({sourceName:o,targetName:l,stream:a,streamId:r,reason:wrapReason(e)});return t.promise}},i)}_createStreamSink(e){const t=this,i=this.actionHandler[e.action],s=e.streamId,r=this.sourceName,a=e.sourceName,o=this.comObj,d={enqueue(e,i=1,o){if(this.isCancelled)return;const l=this.desiredSize;this.desiredSize-=i;if(l>0&&this.desiredSize<=0){this.sinkCapability=(0,n.createPromiseCapability)();this.ready=this.sinkCapability.promise}t._postMessage({sourceName:r,targetName:a,stream:c,streamId:s,chunk:e},o)},close(){if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:r,targetName:a,stream:l,streamId:s});delete t.streamSinks[s]}},error(e){(0,n.assert)(e instanceof Error,"error must have a valid reason");if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:r,targetName:a,stream:h,streamId:s,reason:wrapReason(e)})}},sinkCapability:(0,n.createPromiseCapability)(),onPull:null,onCancel:null,isCancelled:!1,desiredSize:e.desiredSize,ready:null};d.sinkCapability.resolve();d.ready=d.sinkCapability.promise;this.streamSinks[s]=d;new Promise((function(t){t(i(e.data,d))})).then((function(){o.postMessage({sourceName:r,targetName:a,stream:p,streamId:s,success:!0})}),(function(e){o.postMessage({sourceName:r,targetName:a,stream:p,streamId:s,reason:wrapReason(e)})}))}_processStreamMessage(e){const t=e.streamId,i=this.sourceName,s=e.sourceName,r=this.comObj;switch(e.stream){case p:e.success?this.streamControllers[t].startCall.resolve():this.streamControllers[t].startCall.reject(wrapReason(e.reason));break;case u:e.success?this.streamControllers[t].pullCall.resolve():this.streamControllers[t].pullCall.reject(wrapReason(e.reason));break;case d:if(!this.streamSinks[t]){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,success:!0});break}this.streamSinks[t].desiredSize<=0&&e.desiredSize>0&&this.streamSinks[t].sinkCapability.resolve();this.streamSinks[t].desiredSize=e.desiredSize;const{onPull:g}=this.streamSinks[e.streamId];new Promise((function(e){e(g&&g())})).then((function(){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,success:!0})}),(function(e){r.postMessage({sourceName:i,targetName:s,stream:u,streamId:t,reason:wrapReason(e)})}));break;case c:(0,n.assert)(this.streamControllers[t],"enqueue should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].controller.enqueue(e.chunk);break;case l:(0,n.assert)(this.streamControllers[t],"close should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].isClosed=!0;this.streamControllers[t].controller.close();this._deleteStreamController(t);break;case h:(0,n.assert)(this.streamControllers[t],"error should have stream controller");this.streamControllers[t].controller.error(wrapReason(e.reason));this._deleteStreamController(t);break;case o:e.success?this.streamControllers[t].cancelCall.resolve():this.streamControllers[t].cancelCall.reject(wrapReason(e.reason));this._deleteStreamController(t);break;case a:if(!this.streamSinks[t])break;const{onCancel:f}=this.streamSinks[e.streamId];new Promise((function(t){t(f&&f(wrapReason(e.reason)))})).then((function(){r.postMessage({sourceName:i,targetName:s,stream:o,streamId:t,success:!0})}),(function(e){r.postMessage({sourceName:i,targetName:s,stream:o,streamId:t,reason:wrapReason(e)})}));this.streamSinks[t].sinkCapability.reject(wrapReason(e.reason));this.streamSinks[t].isCancelled=!0;delete this.streamSinks[t];break;default:throw new Error("Unexpected stream case")}}async _deleteStreamController(e){await Promise.allSettled([this.streamControllers[e].startCall,this.streamControllers[e].pullCall,this.streamControllers[e].cancelCall].map((function(e){return e&&e.promise})));delete this.streamControllers[e]}_postMessage(e,t){t&&this.postMessageTransfers?this.comObj.postMessage(e,t):this.comObj.postMessage(e)}destroy(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Metadata=void 0;var n=i(2);t.Metadata=class Metadata{constructor({parsedData:e,rawData:t}){this._metadataMap=e;this._data=t}getRaw(){return this._data}get(e){return this._metadataMap.get(e)??null}getAll(){return(0,n.objectFromMap)(this._metadataMap)}has(e){return this._metadataMap.has(e)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OptionalContentConfig=void 0;var n=i(2);class OptionalContentGroup{constructor(e,t){this.visible=!0;this.name=e;this.intent=t}}t.OptionalContentConfig=class OptionalContentConfig{constructor(e){this.name=null;this.creator=null;this._order=null;this._groups=new Map;if(null!==e){this.name=e.name;this.creator=e.creator;this._order=e.order;for(const t of e.groups)this._groups.set(t.id,new OptionalContentGroup(t.name,t.intent));if("OFF"===e.baseState)for(const e of this._groups)e.visible=!1;for(const t of e.on)this._groups.get(t).visible=!0;for(const t of e.off)this._groups.get(t).visible=!1}}_evaluateVisibilityExpression(e){const t=e.length;if(t<2)return!0;const i=e[0];for(let s=1;s<t;s++){const t=e[s];let r;if(Array.isArray(t))r=this._evaluateVisibilityExpression(t);else{if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}r=this._groups.get(t).visible}switch(i){case"And":if(!r)return!1;break;case"Or":if(r)return!0;break;case"Not":return!r;default:return!0}}return"And"===i}isVisible(e){if("OCG"===e.type){if(!this._groups.has(e.id)){(0,n.warn)(`Optional content group not found: ${e.id}`);return!0}return this._groups.get(e.id).visible}if("OCMD"===e.type){if(e.expression)return this._evaluateVisibilityExpression(e.expression);if(!e.policy||"AnyOn"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(this._groups.get(t).visible)return!0}return!1}if("AllOn"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(!this._groups.get(t).visible)return!1}return!0}if("AnyOff"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(!this._groups.get(t).visible)return!0}return!1}if("AllOff"===e.policy){for(const t of e.ids){if(!this._groups.has(t)){(0,n.warn)(`Optional content group not found: ${t}`);return!0}if(this._groups.get(t).visible)return!1}return!0}(0,n.warn)(`Unknown optional content policy ${e.policy}.`);return!0}(0,n.warn)(`Unknown group type ${e.type}.`);return!0}setVisibility(e,t=!0){this._groups.has(e)?this._groups.get(e).visible=!!t:(0,n.warn)(`Optional content group not found: ${e}`)}getOrder(){return this._groups.size?this._order?this._order.slice():Array.from(this._groups.keys()):null}getGroups(){return this._groups.size>0?(0,n.objectFromMap)(this._groups):null}getGroup(e){return this._groups.get(e)||null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFDataTransportStream=void 0;var n=i(2),s=i(1);t.PDFDataTransportStream=class PDFDataTransportStream{constructor(e,t){(0,n.assert)(t,'PDFDataTransportStream - missing required "pdfDataRangeTransport" argument.');this._queuedChunks=[];this._progressiveDone=e.progressiveDone||!1;this._contentDispositionFilename=e.contentDispositionFilename||null;const i=e.initialData;if(i?.length>0){const e=new Uint8Array(i).buffer;this._queuedChunks.push(e)}this._pdfDataRangeTransport=t;this._isStreamingSupported=!e.disableStream;this._isRangeSupported=!e.disableRange;this._contentLength=e.length;this._fullRequestReader=null;this._rangeReaders=[];this._pdfDataRangeTransport.addRangeListener(((e,t)=>{this._onReceiveData({begin:e,chunk:t})}));this._pdfDataRangeTransport.addProgressListener(((e,t)=>{this._onProgress({loaded:e,total:t})}));this._pdfDataRangeTransport.addProgressiveReadListener((e=>{this._onReceiveData({chunk:e})}));this._pdfDataRangeTransport.addProgressiveDoneListener((()=>{this._onProgressiveDone()}));this._pdfDataRangeTransport.transportReady()}_onReceiveData(e){const t=new Uint8Array(e.chunk).buffer;if(void 0===e.begin)this._fullRequestReader?this._fullRequestReader._enqueue(t):this._queuedChunks.push(t);else{const i=this._rangeReaders.some((function(i){if(i._begin!==e.begin)return!1;i._enqueue(t);return!0}));(0,n.assert)(i,"_onReceiveData - no `PDFDataTransportStreamRangeReader` instance found.")}}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}_onProgress(e){if(void 0===e.total){const t=this._rangeReaders[0];t?.onProgress&&t.onProgress({loaded:e.loaded})}else{const t=this._fullRequestReader;t?.onProgress&&t.onProgress({loaded:e.loaded,total:e.total})}}_onProgressiveDone(){this._fullRequestReader&&this._fullRequestReader.progressiveDone();this._progressiveDone=!0}_removeRangeReader(e){const t=this._rangeReaders.indexOf(e);t>=0&&this._rangeReaders.splice(t,1)}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFDataTransportStream.getFullReader can only be called once.");const e=this._queuedChunks;this._queuedChunks=null;return new PDFDataTransportStreamReader(this,e,this._progressiveDone,this._contentDispositionFilename)}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=new PDFDataTransportStreamRangeReader(this,e,t);this._pdfDataRangeTransport.requestDataRange(e,t);this._rangeReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeReaders.slice(0))t.cancel(e);this._pdfDataRangeTransport.abort()}};class PDFDataTransportStreamReader{constructor(e,t,i=!1,n=null){this._stream=e;this._done=i||!1;this._filename=(0,s.isPdfFile)(n)?n:null;this._queuedChunks=t||[];this._loaded=0;for(const e of this._queuedChunks)this._loaded+=e.byteLength;this._requests=[];this._headersReady=Promise.resolve();e._fullRequestReader=this;this.onProgress=null}_enqueue(e){if(!this._done){if(this._requests.length>0){this._requests.shift().resolve({value:e,done:!1})}else this._queuedChunks.push(e);this._loaded+=e.byteLength}}get headersReady(){return this._headersReady}get filename(){return this._filename}get isRangeSupported(){return this._stream._isRangeSupported}get isStreamingSupported(){return this._stream._isStreamingSupported}get contentLength(){return this._stream._contentLength}async read(){if(this._queuedChunks.length>0){return{value:this._queuedChunks.shift(),done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}progressiveDone(){this._done||(this._done=!0)}}class PDFDataTransportStreamRangeReader{constructor(e,t,i){this._stream=e;this._begin=t;this._end=i;this._queuedChunk=null;this._requests=[];this._done=!1;this.onProgress=null}_enqueue(e){if(!this._done){if(0===this._requests.length)this._queuedChunk=e;else{this._requests.shift().resolve({value:e,done:!1});for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}this._done=!0;this._stream._removeRangeReader(this)}}get isStreamingSupported(){return!1}async read(){if(this._queuedChunk){const e=this._queuedChunk;this._queuedChunk=null;return{value:e,done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._stream._removeRangeReader(this)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.AnnotationLayer=void 0;var n=i(1),s=i(2),r=i(8),a=i(18);class AnnotationElementFactory{static create(e){switch(e.data.annotationType){case s.AnnotationType.LINK:return new LinkAnnotationElement(e);case s.AnnotationType.TEXT:return new TextAnnotationElement(e);case s.AnnotationType.WIDGET:switch(e.data.fieldType){case"Tx":return new TextWidgetAnnotationElement(e);case"Btn":return e.data.radioButton?new RadioButtonWidgetAnnotationElement(e):e.data.checkBox?new CheckboxWidgetAnnotationElement(e):new PushButtonWidgetAnnotationElement(e);case"Ch":return new ChoiceWidgetAnnotationElement(e)}return new WidgetAnnotationElement(e);case s.AnnotationType.POPUP:return new PopupAnnotationElement(e);case s.AnnotationType.FREETEXT:return new FreeTextAnnotationElement(e);case s.AnnotationType.LINE:return new LineAnnotationElement(e);case s.AnnotationType.SQUARE:return new SquareAnnotationElement(e);case s.AnnotationType.CIRCLE:return new CircleAnnotationElement(e);case s.AnnotationType.POLYLINE:return new PolylineAnnotationElement(e);case s.AnnotationType.CARET:return new CaretAnnotationElement(e);case s.AnnotationType.INK:return new InkAnnotationElement(e);case s.AnnotationType.POLYGON:return new PolygonAnnotationElement(e);case s.AnnotationType.HIGHLIGHT:return new HighlightAnnotationElement(e);case s.AnnotationType.UNDERLINE:return new UnderlineAnnotationElement(e);case s.AnnotationType.SQUIGGLY:return new SquigglyAnnotationElement(e);case s.AnnotationType.STRIKEOUT:return new StrikeOutAnnotationElement(e);case s.AnnotationType.STAMP:return new StampAnnotationElement(e);case s.AnnotationType.FILEATTACHMENT:return new FileAttachmentAnnotationElement(e);default:return new AnnotationElement(e)}}}class AnnotationElement{constructor(e,{isRenderable:t=!1,ignoreBorder:i=!1,createQuadrilaterals:n=!1}={}){this.isRenderable=t;this.data=e.data;this.layer=e.layer;this.page=e.page;this.viewport=e.viewport;this.linkService=e.linkService;this.downloadManager=e.downloadManager;this.imageResourcesPath=e.imageResourcesPath;this.renderInteractiveForms=e.renderInteractiveForms;this.svgFactory=e.svgFactory;this.annotationStorage=e.annotationStorage;this.enableScripting=e.enableScripting;this.hasJSActions=e.hasJSActions;this._mouseState=e.mouseState;t&&(this.container=this._createContainer(i));n&&(this.quadrilaterals=this._createQuadrilaterals(i))}_createContainer(e=!1){const t=this.data,i=this.page,n=this.viewport,r=document.createElement("section");let a=t.rect[2]-t.rect[0],o=t.rect[3]-t.rect[1];r.setAttribute("data-annotation-id",t.id);const l=s.Util.normalizeRect([t.rect[0],i.view[3]-t.rect[1]+i.view[1],t.rect[2],i.view[3]-t.rect[3]+i.view[1]]);r.style.transform=`matrix(${n.transform.join(",")})`;r.style.transformOrigin=`${-l[0]}px ${-l[1]}px`;if(!e&&t.borderStyle.width>0){r.style.borderWidth=`${t.borderStyle.width}px`;if(t.borderStyle.style!==s.AnnotationBorderStyleType.UNDERLINE){a-=2*t.borderStyle.width;o-=2*t.borderStyle.width}const e=t.borderStyle.horizontalCornerRadius,i=t.borderStyle.verticalCornerRadius;if(e>0||i>0){const t=`${e}px / ${i}px`;r.style.borderRadius=t}switch(t.borderStyle.style){case s.AnnotationBorderStyleType.SOLID:r.style.borderStyle="solid";break;case s.AnnotationBorderStyleType.DASHED:r.style.borderStyle="dashed";break;case s.AnnotationBorderStyleType.BEVELED:(0,s.warn)("Unimplemented border style: beveled");break;case s.AnnotationBorderStyleType.INSET:(0,s.warn)("Unimplemented border style: inset");break;case s.AnnotationBorderStyleType.UNDERLINE:r.style.borderBottomStyle="solid"}t.color?r.style.borderColor=s.Util.makeHexColor(0|t.color[0],0|t.color[1],0|t.color[2]):r.style.borderWidth=0}r.style.left=`${l[0]}px`;r.style.top=`${l[1]}px`;r.style.width=`${a}px`;r.style.height=`${o}px`;return r}_createQuadrilaterals(e=!1){if(!this.data.quadPoints)return null;const t=[],i=this.data.rect;for(const i of this.data.quadPoints){this.data.rect=[i[2].x,i[2].y,i[1].x,i[1].y];t.push(this._createContainer(e))}this.data.rect=i;return t}_createPopup(e,t){let i=this.container;if(this.quadrilaterals){e=e||this.quadrilaterals;i=this.quadrilaterals[0]}if(!e){(e=document.createElement("div")).style.height=i.style.height;e.style.width=i.style.width;i.appendChild(e)}const n=new PopupElement({container:i,trigger:e,color:t.color,title:t.title,modificationDate:t.modificationDate,contents:t.contents,hideWrapper:!0}).render();n.style.left=i.style.width;i.appendChild(n)}_renderQuadrilaterals(e){for(const t of this.quadrilaterals)t.className=e;return this.quadrilaterals}render(){(0,s.unreachable)("Abstract method `AnnotationElement.render` called")}}class LinkAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.url||e.data.dest||e.data.action||e.data.isTooltipOnly||e.data.actions&&(e.data.actions.Action||e.data.actions["Mouse Up"]||e.data.actions["Mouse Down"])),createQuadrilaterals:!0})}render(){const{data:e,linkService:t}=this,i=document.createElement("a");e.url?(0,n.addLinkAttributes)(i,{url:e.url,target:e.newWindow?n.LinkTarget.BLANK:t.externalLinkTarget,rel:t.externalLinkRel,enabled:t.externalLinkEnabled}):e.action?this._bindNamedAction(i,e.action):e.dest?this._bindLink(i,e.dest):e.actions&&(e.actions.Action||e.actions["Mouse Up"]||e.actions["Mouse Down"])&&this.enableScripting&&this.hasJSActions?this._bindJSAction(i,e):this._bindLink(i,"");if(this.quadrilaterals)return this._renderQuadrilaterals("linkAnnotation").map(((e,t)=>{const n=0===t?i:i.cloneNode();e.appendChild(n);return e}));this.container.className="linkAnnotation";this.container.appendChild(i);return this.container}_bindLink(e,t){e.href=this.linkService.getDestinationHash(t);e.onclick=()=>{t&&this.linkService.goToDestination(t);return!1};(t||""===t)&&(e.className="internalLink")}_bindNamedAction(e,t){e.href=this.linkService.getAnchorUrl("");e.onclick=()=>{this.linkService.executeNamedAction(t);return!1};e.className="internalLink"}_bindJSAction(e,t){e.href=this.linkService.getAnchorUrl("");const i=new Map([["Action","onclick"],["Mouse Up","onmouseup"],["Mouse Down","onmousedown"]]);for(const n of Object.keys(t.actions)){const s=i.get(n);s&&(e[s]=()=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t.id,name:n}});return!1})}e.className="internalLink"}}class TextAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents)})}render(){this.container.className="textAnnotation";const e=document.createElement("img");e.style.height=this.container.style.height;e.style.width=this.container.style.width;e.src=this.imageResourcesPath+"annotation-"+this.data.name.toLowerCase()+".svg";e.alt="[{{type}} Annotation]";e.dataset.l10nId="text_annotation_type";e.dataset.l10nArgs=JSON.stringify({type:this.data.name});this.data.hasPopup||this._createPopup(e,this.data);this.container.appendChild(e);return this.container}}class WidgetAnnotationElement extends AnnotationElement{render(){this.data.alternativeText&&(this.container.title=this.data.alternativeText);return this.container}_getKeyModifier(e){return navigator.platform.includes("Win")&&e.ctrlKey||navigator.platform.includes("Mac")&&e.metaKey}_setEventListener(e,t,i,n){t.includes("mouse")?e.addEventListener(t,(e=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:this.data.id,name:i,value:n(e),shift:e.shiftKey,modifier:this._getKeyModifier(e)}})})):e.addEventListener(t,(e=>{this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:this.data.id,name:i,value:e.target.checked}})}))}_setEventListeners(e,t,i){for(const[n,s]of t)("Action"===s||this.data.actions?.[s])&&this._setEventListener(e,n,s,i)}_dispatchEventFromSandbox(e,t){const setColor=(e,t,i)=>{const n=i.detail[e];i.target.style[t]=a.ColorConverters[`${n[0]}_HTML`](n.slice(1))},i={display:e=>{const t=e.detail.display%2==1;e.target.style.visibility=t?"hidden":"visible";this.annotationStorage.setValue(this.data.id,{hidden:t,print:0===e.detail.display||3===e.detail.display})},print:e=>{this.annotationStorage.setValue(this.data.id,{print:e.detail.print})},hidden:e=>{e.target.style.visibility=e.detail.hidden?"hidden":"visible";this.annotationStorage.setValue(this.data.id,{hidden:e.detail.hidden})},focus:e=>{setTimeout((()=>e.target.focus({preventScroll:!1})),0)},userName:e=>{e.target.title=e.detail.userName},readonly:e=>{e.detail.readonly?e.target.setAttribute("readonly",""):e.target.removeAttribute("readonly")},required:e=>{e.detail.required?e.target.setAttribute("required",""):e.target.removeAttribute("required")},bgColor:e=>{setColor("bgColor","backgroundColor",e)},fillColor:e=>{setColor("fillColor","backgroundColor",e)},fgColor:e=>{setColor("fgColor","color",e)},textColor:e=>{setColor("textColor","color",e)},borderColor:e=>{setColor("borderColor","borderColor",e)},strokeColor:e=>{setColor("strokeColor","borderColor",e)}};for(const n of Object.keys(t.detail)){const s=e[n]||i[n];s&&s(t)}}}class TextWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderInteractiveForms||!e.data.hasAppearance&&!!e.data.fieldValue})}setPropertyOnSiblings(e,t,i,n){const s=this.annotationStorage;for(const r of document.getElementsByName(e.name))if(r!==e){r[t]=i;const e=Object.create(null);e[n]=i;s.setValue(r.getAttribute("id"),e)}}render(){const e=this.annotationStorage,t=this.data.id;this.container.className="textWidgetAnnotation";let i=null;if(this.renderInteractiveForms){const n=e.getValue(t,{value:this.data.fieldValue,valueAsString:this.data.fieldValue}),s=n.valueAsString||n.value||"",r={userValue:null,formattedValue:null,beforeInputSelectionRange:null,beforeInputValue:null};if(this.data.multiLine){i=document.createElement("textarea");i.textContent=s}else{i=document.createElement("input");i.type="text";i.setAttribute("value",s)}r.userValue=s;i.setAttribute("id",t);i.addEventListener("input",(n=>{e.setValue(t,{value:n.target.value});this.setPropertyOnSiblings(i,"value",n.target.value,"value")}));let blurListener=e=>{r.formattedValue&&(e.target.value=r.formattedValue);e.target.scrollLeft=0;r.beforeInputSelectionRange=null};if(this.enableScripting&&this.hasJSActions){i.addEventListener("focus",(e=>{r.userValue&&(e.target.value=r.userValue)}));i.addEventListener("updatefromsandbox",(i=>{const n={value(i){r.userValue=i.detail.value||"";e.setValue(t,{value:r.userValue.toString()});r.formattedValue||(i.target.value=r.userValue)},valueAsString(i){r.formattedValue=i.detail.valueAsString||"";i.target!==document.activeElement&&(i.target.value=r.formattedValue);e.setValue(t,{formattedValue:r.formattedValue})},selRange(e){const[t,i]=e.detail.selRange;t>=0&&i<e.target.value.length&&e.target.setSelectionRange(t,i)}};this._dispatchEventFromSandbox(n,i)}));i.addEventListener("keydown",(e=>{r.beforeInputValue=e.target.value;let i=-1;"Escape"===e.key?i=0:"Enter"===e.key?i=2:"Tab"===e.key&&(i=3);if(-1!==i){r.userValue=e.target.value;this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:e.target.value,willCommit:!0,commitKey:i,selStart:e.target.selectionStart,selEnd:e.target.selectionEnd}})}}));const n=blurListener;blurListener=null;i.addEventListener("blur",(e=>{if(this._mouseState.isDown){r.userValue=e.target.value;this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:e.target.value,willCommit:!0,commitKey:1,selStart:e.target.selectionStart,selEnd:e.target.selectionEnd}})}n(e)}));i.addEventListener("mousedown",(e=>{r.beforeInputValue=e.target.value;r.beforeInputSelectionRange=null}));i.addEventListener("keyup",(e=>{e.target.selectionStart===e.target.selectionEnd&&(r.beforeInputSelectionRange=null)}));i.addEventListener("select",(e=>{r.beforeInputSelectionRange=[e.target.selectionStart,e.target.selectionEnd]}));this.data.actions?.Keystroke&&i.addEventListener("input",(e=>{let i=-1,n=-1;r.beforeInputSelectionRange&&([i,n]=r.beforeInputSelectionRange);this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:r.beforeInputValue,change:e.data,willCommit:!1,selStart:i,selEnd:n}})}));this._setEventListeners(i,[["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.value))}blurListener&&i.addEventListener("blur",blurListener);i.disabled=this.data.readOnly;i.name=this.data.fieldName;null!==this.data.maxLen&&(i.maxLength=this.data.maxLen);if(this.data.comb){const e=(this.data.rect[2]-this.data.rect[0])/this.data.maxLen;i.classList.add("comb");i.style.letterSpacing=`calc(${e}px - 1ch)`}}else{i=document.createElement("div");i.textContent=this.data.fieldValue;i.style.verticalAlign="middle";i.style.display="table-cell"}this._setTextStyle(i);this.container.appendChild(i);return this.container}_setTextStyle(e){const t=["left","center","right"],{fontSize:i,fontColor:n}=this.data.defaultAppearanceData,r=e.style;i&&(r.fontSize=`${i}px`);r.color=s.Util.makeHexColor(n[0],n[1],n[2]);null!==this.data.textAlignment&&(r.textAlign=t[this.data.textAlignment])}}class CheckboxWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderInteractiveForms})}render(){const e=this.annotationStorage,t=this.data,i=t.id;let n=e.getValue(i,{value:t.fieldValue&&(t.exportValue&&t.exportValue===t.fieldValue||!t.exportValue&&"Off"!==t.fieldValue)}).value;if("string"==typeof n){n="Off"!==n;e.setValue(i,{value:n})}this.container.className="buttonWidgetAnnotation checkBox";const s=document.createElement("input");s.disabled=t.readOnly;s.type="checkbox";s.name=this.data.fieldName;n&&s.setAttribute("checked",!0);s.setAttribute("id",i);s.addEventListener("change",(function(t){const n=t.target.name;for(const i of document.getElementsByName(n))if(i!==t.target){i.checked=!1;e.setValue(i.parentNode.getAttribute("data-annotation-id"),{value:!1})}e.setValue(i,{value:t.target.checked})}));if(this.enableScripting&&this.hasJSActions){s.addEventListener("updatefromsandbox",(t=>{const n={value(t){t.target.checked="Off"!==t.detail.value;e.setValue(i,{value:t.target.checked})}};this._dispatchEventFromSandbox(n,t)}));this._setEventListeners(s,[["change","Validate"],["change","Action"],["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.checked))}this.container.appendChild(s);return this.container}}class RadioButtonWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderInteractiveForms})}render(){this.container.className="buttonWidgetAnnotation radioButton";const e=this.annotationStorage,t=this.data,i=t.id;let n=e.getValue(i,{value:t.fieldValue===t.buttonValue}).value;if("string"==typeof n){n=n!==t.buttonValue;e.setValue(i,{value:n})}const s=document.createElement("input");s.disabled=t.readOnly;s.type="radio";s.name=t.fieldName;n&&s.setAttribute("checked",!0);s.setAttribute("id",i);s.addEventListener("change",(function(t){const{target:n}=t;for(const t of document.getElementsByName(n.name))t!==n&&e.setValue(t.getAttribute("id"),{value:!1});e.setValue(i,{value:n.checked})}));if(this.enableScripting&&this.hasJSActions){const n=t.buttonValue;s.addEventListener("updatefromsandbox",(t=>{const s={value(t){const s=n===t.detail.value;for(const n of document.getElementsByName(t.target.name)){const t=n.getAttribute("id");n.checked=t===i&&s;e.setValue(t,{value:n.checked})}}};this._dispatchEventFromSandbox(s,t)}));this._setEventListeners(s,[["change","Validate"],["change","Action"],["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"]],(e=>e.target.checked))}this.container.appendChild(s);return this.container}}class PushButtonWidgetAnnotationElement extends LinkAnnotationElement{render(){const e=super.render();e.className="buttonWidgetAnnotation pushButton";this.data.alternativeText&&(e.title=this.data.alternativeText);return e}}class ChoiceWidgetAnnotationElement extends WidgetAnnotationElement{constructor(e){super(e,{isRenderable:e.renderInteractiveForms})}render(){this.container.className="choiceWidgetAnnotation";const e=this.annotationStorage,t=this.data.id;e.getValue(t,{value:this.data.fieldValue.length>0?this.data.fieldValue[0]:void 0});const i=document.createElement("select");i.disabled=this.data.readOnly;i.name=this.data.fieldName;i.setAttribute("id",t);if(!this.data.combo){i.size=this.data.options.length;this.data.multiSelect&&(i.multiple=!0)}for(const e of this.data.options){const t=document.createElement("option");t.textContent=e.displayValue;t.value=e.exportValue;this.data.fieldValue.includes(e.exportValue)&&t.setAttribute("selected",!0);i.appendChild(t)}const getValue=(e,t)=>{const i=t?"value":"textContent",n=e.target.options;return e.target.multiple?Array.prototype.filter.call(n,(e=>e.selected)).map((e=>e[i])):-1===n.selectedIndex?null:n[n.selectedIndex][i]},getItems=e=>{const t=e.target.options;return Array.prototype.map.call(t,(e=>({displayValue:e.textContent,exportValue:e.value})))};if(this.enableScripting&&this.hasJSActions){i.addEventListener("updatefromsandbox",(n=>{const s={value(n){const s=i.options,r=n.detail.value,a=new Set(Array.isArray(r)?r:[r]);Array.prototype.forEach.call(s,(e=>{e.selected=a.has(e.value)}));e.setValue(t,{value:getValue(n,!0)})},multipleSelection(e){i.multiple=!0},remove(n){const s=i.options,r=n.detail.remove;s[r].selected=!1;i.remove(r);if(s.length>0){-1===Array.prototype.findIndex.call(s,(e=>e.selected))&&(s[0].selected=!0)}e.setValue(t,{value:getValue(n,!0),items:getItems(n)})},clear(n){for(;0!==i.length;)i.remove(0);e.setValue(t,{value:null,items:[]})},insert(n){const{index:s,displayValue:r,exportValue:a}=n.detail.insert,o=document.createElement("option");o.textContent=r;o.value=a;i.insertBefore(o,i.children[s]);e.setValue(t,{value:getValue(n,!0),items:getItems(n)})},items(n){const{items:s}=n.detail;for(;0!==i.length;)i.remove(0);for(const e of s){const{displayValue:t,exportValue:n}=e,s=document.createElement("option");s.textContent=t;s.value=n;i.appendChild(s)}i.options.length>0&&(i.options[0].selected=!0);e.setValue(t,{value:getValue(n,!0),items:getItems(n)})},indices(i){const n=new Set(i.detail.indices),s=i.target.options;Array.prototype.forEach.call(s,((e,t)=>{e.selected=n.has(t)}));e.setValue(t,{value:getValue(i,!0)})},editable(e){e.target.disabled=!e.detail.editable}};this._dispatchEventFromSandbox(s,n)}));i.addEventListener("input",(i=>{const n=getValue(i,!0),s=getValue(i,!1);e.setValue(t,{value:n});this.linkService.eventBus?.dispatch("dispatcheventinsandbox",{source:this,detail:{id:t,name:"Keystroke",value:s,changeEx:n,willCommit:!0,commitKey:1,keyDown:!1}})}));this._setEventListeners(i,[["focus","Focus"],["blur","Blur"],["mousedown","Mouse Down"],["mouseenter","Mouse Enter"],["mouseleave","Mouse Exit"],["mouseup","Mouse Up"],["input","Action"]],(e=>e.target.checked))}else i.addEventListener("input",(function(i){e.setValue(t,{value:getValue(i)})}));this.container.appendChild(i);return this.container}}class PopupAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!(!e.data.title&&!e.data.contents)})}render(){this.container.className="popupAnnotation";if(["Line","Square","Circle","PolyLine","Polygon","Ink"].includes(this.data.parentType))return this.container;const e=`[data-annotation-id="${this.data.parentId}"]`,t=this.layer.querySelectorAll(e);if(0===t.length)return this.container;const i=new PopupElement({container:this.container,trigger:Array.from(t),color:this.data.color,title:this.data.title,modificationDate:this.data.modificationDate,contents:this.data.contents}),n=this.page,r=s.Util.normalizeRect([this.data.parentRect[0],n.view[3]-this.data.parentRect[1]+n.view[1],this.data.parentRect[2],n.view[3]-this.data.parentRect[3]+n.view[1]]),a=r[0]+this.data.parentRect[2]-this.data.parentRect[0],o=r[1];this.container.style.transformOrigin=`${-a}px ${-o}px`;this.container.style.left=`${a}px`;this.container.style.top=`${o}px`;this.container.appendChild(i.render());return this.container}}class PopupElement{constructor(e){this.container=e.container;this.trigger=e.trigger;this.color=e.color;this.title=e.title;this.modificationDate=e.modificationDate;this.contents=e.contents;this.hideWrapper=e.hideWrapper||!1;this.pinned=!1}render(){const e=document.createElement("div");e.className="popupWrapper";this.hideElement=this.hideWrapper?e:this.container;this.hideElement.hidden=!0;const t=document.createElement("div");t.className="popup";const i=this.color;if(i){const e=.7*(255-i[0])+i[0],n=.7*(255-i[1])+i[1],r=.7*(255-i[2])+i[2];t.style.backgroundColor=s.Util.makeHexColor(0|e,0|n,0|r)}const r=document.createElement("h1");r.textContent=this.title;t.appendChild(r);const a=n.PDFDateString.toDateObject(this.modificationDate);if(a){const e=document.createElement("span");e.textContent="{{date}}, {{time}}";e.dataset.l10nId="annotation_date_string";e.dataset.l10nArgs=JSON.stringify({date:a.toLocaleDateString(),time:a.toLocaleTimeString()});t.appendChild(e)}const o=this._formatContents(this.contents);t.appendChild(o);Array.isArray(this.trigger)||(this.trigger=[this.trigger]);for(const e of this.trigger){e.addEventListener("click",this._toggle.bind(this));e.addEventListener("mouseover",this._show.bind(this,!1));e.addEventListener("mouseout",this._hide.bind(this,!1))}t.addEventListener("click",this._hide.bind(this,!0));e.appendChild(t);return e}_formatContents(e){const t=document.createElement("p"),i=e.split(/(?:\r\n?|\n)/);for(let e=0,n=i.length;e<n;++e){const s=i[e];t.appendChild(document.createTextNode(s));e<n-1&&t.appendChild(document.createElement("br"))}return t}_toggle(){this.pinned?this._hide(!0):this._show(!0)}_show(e=!1){e&&(this.pinned=!0);if(this.hideElement.hidden){this.hideElement.hidden=!1;this.container.style.zIndex+=1}}_hide(e=!0){e&&(this.pinned=!1);if(!this.hideElement.hidden&&!this.pinned){this.hideElement.hidden=!0;this.container.style.zIndex-=1}}}class FreeTextAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="freeTextAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class LineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="lineAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=this.svgFactory.createElement("svg:line");s.setAttribute("x1",e.rect[2]-e.lineCoordinates[0]);s.setAttribute("y1",e.rect[3]-e.lineCoordinates[1]);s.setAttribute("x2",e.rect[2]-e.lineCoordinates[2]);s.setAttribute("y2",e.rect[3]-e.lineCoordinates[3]);s.setAttribute("stroke-width",e.borderStyle.width||1);s.setAttribute("stroke","transparent");n.appendChild(s);this.container.append(n);this._createPopup(s,e);return this.container}}class SquareAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="squareAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=e.borderStyle.width,r=this.svgFactory.createElement("svg:rect");r.setAttribute("x",s/2);r.setAttribute("y",s/2);r.setAttribute("width",t-s);r.setAttribute("height",i-s);r.setAttribute("stroke-width",s||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","none");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class CircleAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="circleAnnotation";const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i),s=e.borderStyle.width,r=this.svgFactory.createElement("svg:ellipse");r.setAttribute("cx",t/2);r.setAttribute("cy",i/2);r.setAttribute("rx",t/2-s/2);r.setAttribute("ry",i/2-s/2);r.setAttribute("stroke-width",s||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","none");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class PolylineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0});this.containerClassName="polylineAnnotation";this.svgElementName="svg:polyline"}render(){this.container.className=this.containerClassName;const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i);let s=[];for(const t of e.vertices){const i=t.x-e.rect[0],n=e.rect[3]-t.y;s.push(i+","+n)}s=s.join(" ");const r=this.svgFactory.createElement(this.svgElementName);r.setAttribute("points",s);r.setAttribute("stroke-width",e.borderStyle.width||1);r.setAttribute("stroke","transparent");r.setAttribute("fill","none");n.appendChild(r);this.container.append(n);this._createPopup(r,e);return this.container}}class PolygonAnnotationElement extends PolylineAnnotationElement{constructor(e){super(e);this.containerClassName="polygonAnnotation";this.svgElementName="svg:polygon"}}class CaretAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="caretAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class InkAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0});this.containerClassName="inkAnnotation";this.svgElementName="svg:polyline"}render(){this.container.className=this.containerClassName;const e=this.data,t=e.rect[2]-e.rect[0],i=e.rect[3]-e.rect[1],n=this.svgFactory.create(t,i);for(const t of e.inkLists){let i=[];for(const n of t){const t=n.x-e.rect[0],s=e.rect[3]-n.y;i.push(`${t},${s}`)}i=i.join(" ");const s=this.svgFactory.createElement(this.svgElementName);s.setAttribute("points",i);s.setAttribute("stroke-width",e.borderStyle.width||1);s.setAttribute("stroke","transparent");s.setAttribute("fill","none");this._createPopup(s,e);n.appendChild(s)}this.container.append(n);return this.container}}class HighlightAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("highlightAnnotation");this.container.className="highlightAnnotation";return this.container}}class UnderlineAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("underlineAnnotation");this.container.className="underlineAnnotation";return this.container}}class SquigglyAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("squigglyAnnotation");this.container.className="squigglyAnnotation";return this.container}}class StrikeOutAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0,createQuadrilaterals:!0})}render(){this.data.hasPopup||this._createPopup(null,this.data);if(this.quadrilaterals)return this._renderQuadrilaterals("strikeoutAnnotation");this.container.className="strikeoutAnnotation";return this.container}}class StampAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!!(e.data.hasPopup||e.data.title||e.data.contents),ignoreBorder:!0})}render(){this.container.className="stampAnnotation";this.data.hasPopup||this._createPopup(null,this.data);return this.container}}class FileAttachmentAnnotationElement extends AnnotationElement{constructor(e){super(e,{isRenderable:!0});const{filename:t,content:i}=this.data.file;this.filename=(0,n.getFilenameFromUrl)(t);this.content=i;this.linkService.eventBus?.dispatch("fileattachmentannotation",{source:this,id:(0,s.stringToPDFString)(t),filename:t,content:i})}render(){this.container.className="fileAttachmentAnnotation";const e=document.createElement("div");e.style.height=this.container.style.height;e.style.width=this.container.style.width;e.addEventListener("dblclick",this._download.bind(this));this.data.hasPopup||!this.data.title&&!this.data.contents||this._createPopup(e,this.data);this.container.appendChild(e);return this.container}_download(){this.downloadManager?.openOrDownloadData(this.container,this.content,this.filename)}}t.AnnotationLayer=class AnnotationLayer{static render(e){const t=[],i=[];for(const n of e.annotations)n&&(n.annotationType!==s.AnnotationType.POPUP?t.push(n):i.push(n));i.length&&t.push(...i);for(const i of t){const t=AnnotationElementFactory.create({data:i,layer:e.div,page:e.page,viewport:e.viewport,linkService:e.linkService,downloadManager:e.downloadManager,imageResourcesPath:e.imageResourcesPath||"",renderInteractiveForms:!1!==e.renderInteractiveForms,svgFactory:new n.DOMSVGFactory,annotationStorage:e.annotationStorage||new r.AnnotationStorage,enableScripting:e.enableScripting,hasJSActions:e.hasJSActions,mouseState:e.mouseState||{isDown:!1}});if(t.isRenderable){const n=t.render();i.hidden&&(n.style.visibility="hidden");if(Array.isArray(n))for(const t of n)e.div.appendChild(t);else t instanceof PopupAnnotationElement?e.div.prepend(n):e.div.appendChild(n)}}}static update(e){const t=`matrix(${e.viewport.transform.join(",")})`;for(const i of e.annotations){const n=e.div.querySelectorAll(`[data-annotation-id="${i.id}"]`);if(n)for(const e of n)e.style.transform=t}e.div.hidden=!1}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ColorConverters=void 0;function makeColorComp(e){return Math.floor(255*Math.max(0,Math.min(1,e))).toString(16).padStart(2,"0")}t.ColorConverters=class ColorConverters{static CMYK_G([e,t,i,n]){return["G",1-Math.min(1,.3*e+.59*i+.11*t+n)]}static G_CMYK([e]){return["CMYK",0,0,0,1-e]}static G_RGB([e]){return["RGB",e,e,e]}static G_HTML([e]){const t=makeColorComp(e);return`#${t}${t}${t}`}static RGB_G([e,t,i]){return["G",.3*e+.59*t+.11*i]}static RGB_HTML([e,t,i]){return`#${makeColorComp(e)}${makeColorComp(t)}${makeColorComp(i)}`}static T_HTML(){return"#00000000"}static CMYK_RGB([e,t,i,n]){return["RGB",1-Math.min(1,e+n),1-Math.min(1,i+n),1-Math.min(1,t+n)]}static CMYK_HTML(e){return this.RGB_HTML(this.CMYK_RGB(e))}static RGB_CMYK([e,t,i]){const n=1-e,s=1-t,r=1-i;return["CMYK",n,s,r,Math.min(n,s,r)]}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.renderTextLayer=function renderTextLayer(e){const t=new TextLayerRenderTask({textContent:e.textContent,textContentStream:e.textContentStream,container:e.container,viewport:e.viewport,textDivs:e.textDivs,textContentItemsStr:e.textContentItemsStr,enhanceTextSelection:e.enhanceTextSelection});t._render(e.timeout);return t};var n=i(2);const s=30,r=new Map,a=/^\s+$/g;function appendText(e,t,i,o){const l=document.createElement("span"),c={angle:0,canvasWidth:0,hasText:""!==t.str,hasEOL:t.hasEOL,originalTransform:null,paddingBottom:0,paddingLeft:0,paddingRight:0,paddingTop:0,scale:1};e._textDivs.push(l);const h=n.Util.transform(e._viewport.transform,t.transform);let d=Math.atan2(h[1],h[0]);const u=i[t.fontName];u.vertical&&(d+=Math.PI/2);const p=Math.hypot(h[2],h[3]),g=p*function getAscent(e,t){const i=r.get(e);if(i)return i;t.save();t.font=`30px ${e}`;const n=t.measureText("");let a=n.fontBoundingBoxAscent,o=Math.abs(n.fontBoundingBoxDescent);if(a){t.restore();const i=a/(a+o);r.set(e,i);return i}t.strokeStyle="red";t.clearRect(0,0,s,s);t.strokeText("g",0,0);let l=t.getImageData(0,0,s,s).data;o=0;for(let e=l.length-1-3;e>=0;e-=4)if(l[e]>0){o=Math.ceil(e/4/s);break}t.clearRect(0,0,s,s);t.strokeText("A",0,s);l=t.getImageData(0,0,s,s).data;a=0;for(let e=0,t=l.length;e<t;e+=4)if(l[e]>0){a=s-Math.floor(e/4/s);break}t.restore();if(a){const t=a/(a+o);r.set(e,t);return t}r.set(e,.8);return.8}(u.fontFamily,o);let f,m;if(0===d){f=h[4];m=h[5]-g}else{f=h[4]+g*Math.sin(d);m=h[5]-g*Math.cos(d)}l.style.left=`${f}px`;l.style.top=`${m}px`;l.style.fontSize=`${p}px`;l.style.fontFamily=u.fontFamily;l.setAttribute("role","presentation");l.textContent=t.str;l.dir=t.dir;e._fontInspectorEnabled&&(l.dataset.fontName=t.fontName);0!==d&&(c.angle=d*(180/Math.PI));let _=!1;if(t.str.length>1||e._enhanceTextSelection&&a.test(t.str))_=!0;else if(t.transform[0]!==t.transform[3]){const e=Math.abs(t.transform[0]),i=Math.abs(t.transform[3]);e!==i&&Math.max(e,i)/Math.min(e,i)>1.5&&(_=!0)}_&&(u.vertical?c.canvasWidth=t.height*e._viewport.scale:c.canvasWidth=t.width*e._viewport.scale);e._textDivProperties.set(l,c);e._textContentStream&&e._layoutText(l);if(e._enhanceTextSelection&&c.hasText){let i=1,s=0;if(0!==d){i=Math.cos(d);s=Math.sin(d)}const r=(u.vertical?t.height:t.width)*e._viewport.scale,a=p;let o,c;if(0!==d){o=[i,s,-s,i,f,m];c=n.Util.getAxialAlignedBoundingBox([0,0,r,a],o)}else c=[f,m,f+r,m+a];e._bounds.push({left:c[0],top:c[1],right:c[2],bottom:c[3],div:l,size:[r,a],m:o})}}function render(e){if(e._canceled)return;const t=e._textDivs,i=e._capability,n=t.length;if(n>1e5){e._renderingDone=!0;i.resolve()}else{if(!e._textContentStream)for(let i=0;i<n;i++)e._layoutText(t[i]);e._renderingDone=!0;i.resolve()}}function findPositiveMin(e,t,i){let n=0;for(let s=0;s<i;s++){const i=e[t++];i>0&&(n=n?Math.min(i,n):i)}return n}function expand(e){const t=e._bounds,i=e._viewport,s=function expandBounds(e,t,i){const n=i.map((function(e,t){return{x1:e.left,y1:e.top,x2:e.right,y2:e.bottom,index:t,x1New:void 0,x2New:void 0}}));expandBoundsLTR(e,n);const s=new Array(i.length);for(const e of n){const t=e.index;s[t]={left:e.x1New,top:0,right:e.x2New,bottom:0}}i.map((function(t,i){const r=s[i],a=n[i];a.x1=t.top;a.y1=e-r.right;a.x2=t.bottom;a.y2=e-r.left;a.index=i;a.x1New=void 0;a.x2New=void 0}));expandBoundsLTR(t,n);for(const e of n){const t=e.index;s[t].top=e.x1New;s[t].bottom=e.x2New}return s}(i.width,i.height,t);for(let i=0;i<s.length;i++){const r=t[i].div,a=e._textDivProperties.get(r);if(0===a.angle){a.paddingLeft=t[i].left-s[i].left;a.paddingTop=t[i].top-s[i].top;a.paddingRight=s[i].right-t[i].right;a.paddingBottom=s[i].bottom-t[i].bottom;e._textDivProperties.set(r,a);continue}const o=s[i],l=t[i],c=l.m,h=c[0],d=c[1],u=[[0,0],[0,l.size[1]],[l.size[0],0],l.size],p=new Float64Array(64);for(let e=0,t=u.length;e<t;e++){const t=n.Util.applyTransform(u[e],c);p[e+0]=h&&(o.left-t[0])/h;p[e+4]=d&&(o.top-t[1])/d;p[e+8]=h&&(o.right-t[0])/h;p[e+12]=d&&(o.bottom-t[1])/d;p[e+16]=d&&(o.left-t[0])/-d;p[e+20]=h&&(o.top-t[1])/h;p[e+24]=d&&(o.right-t[0])/-d;p[e+28]=h&&(o.bottom-t[1])/h;p[e+32]=h&&(o.left-t[0])/-h;p[e+36]=d&&(o.top-t[1])/-d;p[e+40]=h&&(o.right-t[0])/-h;p[e+44]=d&&(o.bottom-t[1])/-d;p[e+48]=d&&(o.left-t[0])/d;p[e+52]=h&&(o.top-t[1])/-h;p[e+56]=d&&(o.right-t[0])/d;p[e+60]=h&&(o.bottom-t[1])/-h}const g=1+Math.min(Math.abs(h),Math.abs(d));a.paddingLeft=findPositiveMin(p,32,16)/g;a.paddingTop=findPositiveMin(p,48,16)/g;a.paddingRight=findPositiveMin(p,0,16)/g;a.paddingBottom=findPositiveMin(p,16,16)/g;e._textDivProperties.set(r,a)}}function expandBoundsLTR(e,t){t.sort((function(e,t){return e.x1-t.x1||e.index-t.index}));const i=[{start:-1/0,end:1/0,boundary:{x1:-1/0,y1:-1/0,x2:0,y2:1/0,index:-1,x1New:0,x2New:0}}];for(const e of t){let t=0;for(;t<i.length&&i[t].end<=e.y1;)t++;let n,s,r=i.length-1;for(;r>=0&&i[r].start>=e.y2;)r--;let a,o,l=-1/0;for(a=t;a<=r;a++){n=i[a];s=n.boundary;let t;t=s.x2>e.x1?s.index>e.index?s.x1New:e.x1:void 0===s.x2New?(s.x2+e.x1)/2:s.x2New;t>l&&(l=t)}e.x1New=l;for(a=t;a<=r;a++){n=i[a];s=n.boundary;void 0===s.x2New?s.x2>e.x1?s.index>e.index&&(s.x2New=s.x2):s.x2New=l:s.x2New>l&&(s.x2New=Math.max(l,s.x2))}const c=[];let h=null;for(a=t;a<=r;a++){n=i[a];s=n.boundary;const t=s.x2>e.x2?s:e;if(h===t)c[c.length-1].end=n.end;else{c.push({start:n.start,end:n.end,boundary:t});h=t}}if(i[t].start<e.y1){c[0].start=e.y1;c.unshift({start:i[t].start,end:e.y1,boundary:i[t].boundary})}if(e.y2<i[r].end){c[c.length-1].end=e.y2;c.push({start:e.y2,end:i[r].end,boundary:i[r].boundary})}for(a=t;a<=r;a++){n=i[a];s=n.boundary;if(void 0!==s.x2New)continue;let e=!1;for(o=t-1;!e&&o>=0&&i[o].start>=s.y1;o--)e=i[o].boundary===s;for(o=r+1;!e&&o<i.length&&i[o].end<=s.y2;o++)e=i[o].boundary===s;for(o=0;!e&&o<c.length;o++)e=c[o].boundary===s;e||(s.x2New=l)}Array.prototype.splice.apply(i,[t,r-t+1].concat(c))}for(const t of i){const i=t.boundary;void 0===i.x2New&&(i.x2New=Math.max(e,i.x2))}}class TextLayerRenderTask{constructor({textContent:e,textContentStream:t,container:i,viewport:s,textDivs:r,textContentItemsStr:a,enhanceTextSelection:o}){this._textContent=e;this._textContentStream=t;this._container=i;this._document=i.ownerDocument;this._viewport=s;this._textDivs=r||[];this._textContentItemsStr=a||[];this._enhanceTextSelection=!!o;this._fontInspectorEnabled=!!globalThis.FontInspector?.enabled;this._reader=null;this._layoutTextLastFontSize=null;this._layoutTextLastFontFamily=null;this._layoutTextCtx=null;this._textDivProperties=new WeakMap;this._renderingDone=!1;this._canceled=!1;this._capability=(0,n.createPromiseCapability)();this._renderTimer=null;this._bounds=[];this._capability.promise.finally((()=>{if(this._layoutTextCtx){this._layoutTextCtx.canvas.width=0;this._layoutTextCtx.canvas.height=0;this._layoutTextCtx=null}})).catch((()=>{}))}get promise(){return this._capability.promise}cancel(){this._canceled=!0;if(this._reader){this._reader.cancel(new n.AbortException("TextLayer task cancelled."));this._reader=null}if(null!==this._renderTimer){clearTimeout(this._renderTimer);this._renderTimer=null}this._capability.reject(new Error("TextLayer task cancelled."))}_processItems(e,t){for(let i=0,n=e.length;i<n;i++)if(void 0!==e[i].str){this._textContentItemsStr.push(e[i].str);appendText(this,e[i],t,this._layoutTextCtx)}else if("beginMarkedContentProps"===e[i].type||"beginMarkedContent"===e[i].type){const t=this._container;this._container=document.createElement("span");this._container.classList.add("markedContent");null!==e[i].id&&this._container.setAttribute("id",`${e[i].id}`);t.appendChild(this._container)}else"endMarkedContent"===e[i].type&&(this._container=this._container.parentNode)}_layoutText(e){const t=this._textDivProperties.get(e);let i="";if(0!==t.canvasWidth&&t.hasText){const{fontSize:n,fontFamily:s}=e.style;if(n!==this._layoutTextLastFontSize||s!==this._layoutTextLastFontFamily){this._layoutTextCtx.font=`${n} ${s}`;this._layoutTextLastFontSize=n;this._layoutTextLastFontFamily=s}const{width:r}=this._layoutTextCtx.measureText(e.textContent);if(r>0){t.scale=t.canvasWidth/r;i=`scaleX(${t.scale})`}}0!==t.angle&&(i=`rotate(${t.angle}deg) ${i}`);if(i.length>0){this._enhanceTextSelection&&(t.originalTransform=i);e.style.transform=i}t.hasText&&this._container.appendChild(e);if(t.hasEOL){const e=document.createElement("br");e.setAttribute("role","presentation");this._container.appendChild(e)}}_render(e=0){const t=(0,n.createPromiseCapability)();let i=Object.create(null);const r=this._document.createElement("canvas");r.height=r.width=s;r.mozOpaque=!0;this._layoutTextCtx=r.getContext("2d",{alpha:!1});if(this._textContent){const e=this._textContent.items,i=this._textContent.styles;this._processItems(e,i);t.resolve()}else{if(!this._textContentStream)throw new Error('Neither "textContent" nor "textContentStream" parameters specified.');{const pump=()=>{this._reader.read().then((({value:e,done:n})=>{if(n)t.resolve();else{Object.assign(i,e.styles);this._processItems(e.items,i);pump()}}),t.reject)};this._reader=this._textContentStream.getReader();pump()}}t.promise.then((()=>{i=null;e?this._renderTimer=setTimeout((()=>{render(this);this._renderTimer=null}),e):render(this)}),this._capability.reject)}expandTextDivs(e=!1){if(!this._enhanceTextSelection||!this._renderingDone)return;if(null!==this._bounds){expand(this);this._bounds=null}const t=[],i=[];for(let n=0,s=this._textDivs.length;n<s;n++){const s=this._textDivs[n],r=this._textDivProperties.get(s);if(r.hasText)if(e){t.length=0;i.length=0;r.originalTransform&&t.push(r.originalTransform);if(r.paddingTop>0){i.push(`${r.paddingTop}px`);t.push(`translateY(${-r.paddingTop}px)`)}else i.push(0);r.paddingRight>0?i.push(r.paddingRight/r.scale+"px"):i.push(0);r.paddingBottom>0?i.push(`${r.paddingBottom}px`):i.push(0);if(r.paddingLeft>0){i.push(r.paddingLeft/r.scale+"px");t.push(`translateX(${-r.paddingLeft/r.scale}px)`)}else i.push(0);s.style.padding=i.join(" ");t.length&&(s.style.transform=t.join(" "))}else{s.style.padding=null;s.style.transform=r.originalTransform}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SVGGraphics=void 0;var n=i(2),s=i(1),r=i(4);let a=class{constructor(){(0,n.unreachable)("Not implemented: SVGGraphics")}};t.SVGGraphics=a;{const e={fontStyle:"normal",fontWeight:"normal",fillColor:"#000000"},i="http://www.w3.org/XML/1998/namespace",o="http://www.w3.org/1999/xlink",l=["butt","round","square"],c=["miter","round","bevel"],h=function(){const e=new Uint8Array([137,80,78,71,13,10,26,10]),t=new Int32Array(256);for(let e=0;e<256;e++){let i=e;for(let e=0;e<8;e++)i=1&i?3988292384^i>>1&2147483647:i>>1&2147483647;t[e]=i}function writePngChunk(e,i,n,s){let r=s;const a=i.length;n[r]=a>>24&255;n[r+1]=a>>16&255;n[r+2]=a>>8&255;n[r+3]=255&a;r+=4;n[r]=255&e.charCodeAt(0);n[r+1]=255&e.charCodeAt(1);n[r+2]=255&e.charCodeAt(2);n[r+3]=255&e.charCodeAt(3);r+=4;n.set(i,r);r+=i.length;const o=function crc32(e,i,n){let s=-1;for(let r=i;r<n;r++){const i=255&(s^e[r]);s=s>>>8^t[i]}return-1^s}(n,s+4,r);n[r]=o>>24&255;n[r+1]=o>>16&255;n[r+2]=o>>8&255;n[r+3]=255&o}function deflateSyncUncompressed(e){let t=e.length;const i=65535,n=Math.ceil(t/i),s=new Uint8Array(2+t+5*n+4);let r=0;s[r++]=120;s[r++]=156;let a=0;for(;t>i;){s[r++]=0;s[r++]=255;s[r++]=255;s[r++]=0;s[r++]=0;s.set(e.subarray(a,a+i),r);r+=i;a+=i;t-=i}s[r++]=1;s[r++]=255&t;s[r++]=t>>8&255;s[r++]=255&~t;s[r++]=(65535&~t)>>8&255;s.set(e.subarray(a),r);r+=e.length-a;const o=function adler32(e,t,i){let n=1,s=0;for(let r=t;r<i;++r){n=(n+(255&e[r]))%65521;s=(s+n)%65521}return s<<16|n}(e,0,e.length);s[r++]=o>>24&255;s[r++]=o>>16&255;s[r++]=o>>8&255;s[r++]=255&o;return s}function encode(t,i,s,a){const o=t.width,l=t.height;let c,h,d;const u=t.data;switch(i){case n.ImageKind.GRAYSCALE_1BPP:h=0;c=1;d=o+7>>3;break;case n.ImageKind.RGB_24BPP:h=2;c=8;d=3*o;break;case n.ImageKind.RGBA_32BPP:h=6;c=8;d=4*o;break;default:throw new Error("invalid format")}const p=new Uint8Array((1+d)*l);let g=0,f=0;for(let e=0;e<l;++e){p[g++]=0;p.set(u.subarray(f,f+d),g);f+=d;g+=d}if(i===n.ImageKind.GRAYSCALE_1BPP&&a){g=0;for(let e=0;e<l;e++){g++;for(let e=0;e<d;e++)p[g++]^=255}}const m=new Uint8Array([o>>24&255,o>>16&255,o>>8&255,255&o,l>>24&255,l>>16&255,l>>8&255,255&l,c,h,0,0,0]),_=function deflateSync(e){if(!r.isNodeJS)return deflateSyncUncompressed(e);try{let t;t=parseInt(process.versions.node)>=8?e:Buffer.from(e);const i=require("zlib").deflateSync(t,{level:9});return i instanceof Uint8Array?i:new Uint8Array(i)}catch(e){(0,n.warn)("Not compressing PNG because zlib.deflateSync is unavailable: "+e)}return deflateSyncUncompressed(e)}(p),b=e.length+36+m.length+_.length,v=new Uint8Array(b);let w=0;v.set(e,w);w+=e.length;writePngChunk("IHDR",m,v,w);w+=12+m.length;writePngChunk("IDATA",_,v,w);w+=12+_.length;writePngChunk("IEND",new Uint8Array(0),v,w);return(0,n.createObjectURL)(v,"image/png",s)}return function convertImgDataToPng(e,t,i){return encode(e,void 0===e.kind?n.ImageKind.GRAYSCALE_1BPP:e.kind,t,i)}}();class SVGExtraState{constructor(){this.fontSizeScale=1;this.fontWeight=e.fontWeight;this.fontSize=0;this.textMatrix=n.IDENTITY_MATRIX;this.fontMatrix=n.FONT_IDENTITY_MATRIX;this.leading=0;this.textRenderingMode=n.TextRenderingMode.FILL;this.textMatrixScale=1;this.x=0;this.y=0;this.lineX=0;this.lineY=0;this.charSpacing=0;this.wordSpacing=0;this.textHScale=1;this.textRise=0;this.fillColor=e.fillColor;this.strokeColor="#000000";this.fillAlpha=1;this.strokeAlpha=1;this.lineWidth=1;this.lineJoin="";this.lineCap="";this.miterLimit=0;this.dashArray=[];this.dashPhase=0;this.dependencies=[];this.activeClipUrl=null;this.clipGroup=null;this.maskId=""}clone(){return Object.create(this)}setCurrentPoint(e,t){this.x=e;this.y=t}}function pf(e){if(Number.isInteger(e))return e.toString();const t=e.toFixed(10);let i=t.length-1;if("0"!==t[i])return t;do{i--}while("0"===t[i]);return t.substring(0,"."===t[i]?i:i+1)}function pm(e){if(0===e[4]&&0===e[5]){if(0===e[1]&&0===e[2])return 1===e[0]&&1===e[3]?"":`scale(${pf(e[0])} ${pf(e[3])})`;if(e[0]===e[3]&&e[1]===-e[2]){return`rotate(${pf(180*Math.acos(e[0])/Math.PI)})`}}else if(1===e[0]&&0===e[1]&&0===e[2]&&1===e[3])return`translate(${pf(e[4])} ${pf(e[5])})`;return`matrix(${pf(e[0])} ${pf(e[1])} ${pf(e[2])} ${pf(e[3])} ${pf(e[4])} ${pf(e[5])})`}let d=0,u=0,p=0;t.SVGGraphics=a=class{constructor(e,t,i=!1){this.svgFactory=new s.DOMSVGFactory;this.current=new SVGExtraState;this.transformMatrix=n.IDENTITY_MATRIX;this.transformStack=[];this.extraStack=[];this.commonObjs=e;this.objs=t;this.pendingClip=null;this.pendingEOFill=!1;this.embedFonts=!1;this.embeddedFonts=Object.create(null);this.cssStyle=null;this.forceDataSchema=!!i;this._operatorIdMapping=[];for(const e in n.OPS)this._operatorIdMapping[n.OPS[e]]=e}save(){this.transformStack.push(this.transformMatrix);const e=this.current;this.extraStack.push(e);this.current=e.clone()}restore(){this.transformMatrix=this.transformStack.pop();this.current=this.extraStack.pop();this.pendingClip=null;this.tgrp=null}group(e){this.save();this.executeOpTree(e);this.restore()}loadDependencies(e){const t=e.fnArray,i=e.argsArray;for(let e=0,s=t.length;e<s;e++)if(t[e]===n.OPS.dependency)for(const t of i[e]){const e=t.startsWith("g_")?this.commonObjs:this.objs,i=new Promise((i=>{e.get(t,i)}));this.current.dependencies.push(i)}return Promise.all(this.current.dependencies)}transform(e,t,i,s,r,a){const o=[e,t,i,s,r,a];this.transformMatrix=n.Util.transform(this.transformMatrix,o);this.tgrp=null}getSVG(e,t){this.viewport=t;const i=this._initialize(t);return this.loadDependencies(e).then((()=>{this.transformMatrix=n.IDENTITY_MATRIX;this.executeOpTree(this.convertOpList(e));return i}))}convertOpList(e){const t=this._operatorIdMapping,i=e.argsArray,n=e.fnArray,s=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];s.push({fnId:r,fn:t[r],args:i[e]})}return function opListToTree(e){let t=[];const i=[];for(const n of e)if("save"!==n.fn)"restore"===n.fn?t=i.pop():t.push(n);else{t.push({fnId:92,fn:"group",items:[]});i.push(t);t=t[t.length-1].items}return t}(s)}executeOpTree(e){for(const t of e){const e=t.fn,i=t.fnId,s=t.args;switch(0|i){case n.OPS.beginText:this.beginText();break;case n.OPS.dependency:break;case n.OPS.setLeading:this.setLeading(s);break;case n.OPS.setLeadingMoveText:this.setLeadingMoveText(s[0],s[1]);break;case n.OPS.setFont:this.setFont(s);break;case n.OPS.showText:case n.OPS.showSpacedText:this.showText(s[0]);break;case n.OPS.endText:this.endText();break;case n.OPS.moveText:this.moveText(s[0],s[1]);break;case n.OPS.setCharSpacing:this.setCharSpacing(s[0]);break;case n.OPS.setWordSpacing:this.setWordSpacing(s[0]);break;case n.OPS.setHScale:this.setHScale(s[0]);break;case n.OPS.setTextMatrix:this.setTextMatrix(s[0],s[1],s[2],s[3],s[4],s[5]);break;case n.OPS.setTextRise:this.setTextRise(s[0]);break;case n.OPS.setTextRenderingMode:this.setTextRenderingMode(s[0]);break;case n.OPS.setLineWidth:this.setLineWidth(s[0]);break;case n.OPS.setLineJoin:this.setLineJoin(s[0]);break;case n.OPS.setLineCap:this.setLineCap(s[0]);break;case n.OPS.setMiterLimit:this.setMiterLimit(s[0]);break;case n.OPS.setFillRGBColor:this.setFillRGBColor(s[0],s[1],s[2]);break;case n.OPS.setStrokeRGBColor:this.setStrokeRGBColor(s[0],s[1],s[2]);break;case n.OPS.setStrokeColorN:this.setStrokeColorN(s);break;case n.OPS.setFillColorN:this.setFillColorN(s);break;case n.OPS.shadingFill:this.shadingFill(s[0]);break;case n.OPS.setDash:this.setDash(s[0],s[1]);break;case n.OPS.setRenderingIntent:this.setRenderingIntent(s[0]);break;case n.OPS.setFlatness:this.setFlatness(s[0]);break;case n.OPS.setGState:this.setGState(s[0]);break;case n.OPS.fill:this.fill();break;case n.OPS.eoFill:this.eoFill();break;case n.OPS.stroke:this.stroke();break;case n.OPS.fillStroke:this.fillStroke();break;case n.OPS.eoFillStroke:this.eoFillStroke();break;case n.OPS.clip:this.clip("nonzero");break;case n.OPS.eoClip:this.clip("evenodd");break;case n.OPS.paintSolidColorImageMask:this.paintSolidColorImageMask();break;case n.OPS.paintImageXObject:this.paintImageXObject(s[0]);break;case n.OPS.paintInlineImageXObject:this.paintInlineImageXObject(s[0]);break;case n.OPS.paintImageMaskXObject:this.paintImageMaskXObject(s[0]);break;case n.OPS.paintFormXObjectBegin:this.paintFormXObjectBegin(s[0],s[1]);break;case n.OPS.paintFormXObjectEnd:this.paintFormXObjectEnd();break;case n.OPS.closePath:this.closePath();break;case n.OPS.closeStroke:this.closeStroke();break;case n.OPS.closeFillStroke:this.closeFillStroke();break;case n.OPS.closeEOFillStroke:this.closeEOFillStroke();break;case n.OPS.nextLine:this.nextLine();break;case n.OPS.transform:this.transform(s[0],s[1],s[2],s[3],s[4],s[5]);break;case n.OPS.constructPath:this.constructPath(s[0],s[1]);break;case n.OPS.endPath:this.endPath();break;case 92:this.group(t.items);break;default:(0,n.warn)(`Unimplemented operator ${e}`)}}}setWordSpacing(e){this.current.wordSpacing=e}setCharSpacing(e){this.current.charSpacing=e}nextLine(){this.moveText(0,this.current.leading)}setTextMatrix(e,t,i,n,s,r){const a=this.current;a.textMatrix=a.lineMatrix=[e,t,i,n,s,r];a.textMatrixScale=Math.hypot(e,t);a.x=a.lineX=0;a.y=a.lineY=0;a.xcoords=[];a.ycoords=[];a.tspan=this.svgFactory.createElement("svg:tspan");a.tspan.setAttributeNS(null,"font-family",a.fontFamily);a.tspan.setAttributeNS(null,"font-size",`${pf(a.fontSize)}px`);a.tspan.setAttributeNS(null,"y",pf(-a.y));a.txtElement=this.svgFactory.createElement("svg:text");a.txtElement.appendChild(a.tspan)}beginText(){const e=this.current;e.x=e.lineX=0;e.y=e.lineY=0;e.textMatrix=n.IDENTITY_MATRIX;e.lineMatrix=n.IDENTITY_MATRIX;e.textMatrixScale=1;e.tspan=this.svgFactory.createElement("svg:tspan");e.txtElement=this.svgFactory.createElement("svg:text");e.txtgrp=this.svgFactory.createElement("svg:g");e.xcoords=[];e.ycoords=[]}moveText(e,t){const i=this.current;i.x=i.lineX+=e;i.y=i.lineY+=t;i.xcoords=[];i.ycoords=[];i.tspan=this.svgFactory.createElement("svg:tspan");i.tspan.setAttributeNS(null,"font-family",i.fontFamily);i.tspan.setAttributeNS(null,"font-size",`${pf(i.fontSize)}px`);i.tspan.setAttributeNS(null,"y",pf(-i.y))}showText(t){const s=this.current,r=s.font,a=s.fontSize;if(0===a)return;const o=s.fontSizeScale,l=s.charSpacing,c=s.wordSpacing,h=s.fontDirection,d=s.textHScale*h,u=r.vertical,p=u?1:-1,g=r.defaultVMetrics,f=a*s.fontMatrix[0];let m=0;for(const e of t){if(null===e){m+=h*c;continue}if((0,n.isNum)(e)){m+=p*e*a/1e3;continue}const t=(e.isSpace?c:0)+l,i=e.fontChar;let d,_,b,v=e.width;if(u){let t;const i=e.vmetric||g;t=e.vmetric?i[1]:.5*v;t=-t*f;const n=i[2]*f;v=i?-i[0]:v;d=t/o;_=(m+n)/o}else{d=m/o;_=0}if(e.isInFont||r.missingFile){s.xcoords.push(s.x+d);u&&s.ycoords.push(-s.y+_);s.tspan.textContent+=i}b=u?v*f-t*h:v*f+t*h;m+=b}s.tspan.setAttributeNS(null,"x",s.xcoords.map(pf).join(" "));u?s.tspan.setAttributeNS(null,"y",s.ycoords.map(pf).join(" ")):s.tspan.setAttributeNS(null,"y",pf(-s.y));u?s.y-=m:s.x+=m*d;s.tspan.setAttributeNS(null,"font-family",s.fontFamily);s.tspan.setAttributeNS(null,"font-size",`${pf(s.fontSize)}px`);s.fontStyle!==e.fontStyle&&s.tspan.setAttributeNS(null,"font-style",s.fontStyle);s.fontWeight!==e.fontWeight&&s.tspan.setAttributeNS(null,"font-weight",s.fontWeight);const _=s.textRenderingMode&n.TextRenderingMode.FILL_STROKE_MASK;if(_===n.TextRenderingMode.FILL||_===n.TextRenderingMode.FILL_STROKE){s.fillColor!==e.fillColor&&s.tspan.setAttributeNS(null,"fill",s.fillColor);s.fillAlpha<1&&s.tspan.setAttributeNS(null,"fill-opacity",s.fillAlpha)}else s.textRenderingMode===n.TextRenderingMode.ADD_TO_PATH?s.tspan.setAttributeNS(null,"fill","transparent"):s.tspan.setAttributeNS(null,"fill","none");if(_===n.TextRenderingMode.STROKE||_===n.TextRenderingMode.FILL_STROKE){const e=1/(s.textMatrixScale||1);this._setStrokeAttributes(s.tspan,e)}let b=s.textMatrix;if(0!==s.textRise){b=b.slice();b[5]+=s.textRise}s.txtElement.setAttributeNS(null,"transform",`${pm(b)} scale(${pf(d)}, -1)`);s.txtElement.setAttributeNS(i,"xml:space","preserve");s.txtElement.appendChild(s.tspan);s.txtgrp.appendChild(s.txtElement);this._ensureTransformGroup().appendChild(s.txtElement)}setLeadingMoveText(e,t){this.setLeading(-t);this.moveText(e,t)}addFontStyle(e){if(!e.data)throw new Error('addFontStyle: No font data available, ensure that the "fontExtraProperties" API parameter is set.');if(!this.cssStyle){this.cssStyle=this.svgFactory.createElement("svg:style");this.cssStyle.setAttributeNS(null,"type","text/css");this.defs.appendChild(this.cssStyle)}const t=(0,n.createObjectURL)(e.data,e.mimetype,this.forceDataSchema);this.cssStyle.textContent+=`@font-face { font-family: "${e.loadedName}"; src: url(${t}); }\n`}setFont(e){const t=this.current,i=this.commonObjs.get(e[0]);let s=e[1];t.font=i;if(this.embedFonts&&!i.missingFile&&!this.embeddedFonts[i.loadedName]){this.addFontStyle(i);this.embeddedFonts[i.loadedName]=i}t.fontMatrix=i.fontMatrix||n.FONT_IDENTITY_MATRIX;let r="normal";i.black?r="900":i.bold&&(r="bold");const a=i.italic?"italic":"normal";if(s<0){s=-s;t.fontDirection=-1}else t.fontDirection=1;t.fontSize=s;t.fontFamily=i.loadedName;t.fontWeight=r;t.fontStyle=a;t.tspan=this.svgFactory.createElement("svg:tspan");t.tspan.setAttributeNS(null,"y",pf(-t.y));t.xcoords=[];t.ycoords=[]}endText(){const e=this.current;if(e.textRenderingMode&n.TextRenderingMode.ADD_TO_PATH_FLAG&&e.txtElement?.hasChildNodes()){e.element=e.txtElement;this.clip("nonzero");this.endPath()}}setLineWidth(e){e>0&&(this.current.lineWidth=e)}setLineCap(e){this.current.lineCap=l[e]}setLineJoin(e){this.current.lineJoin=c[e]}setMiterLimit(e){this.current.miterLimit=e}setStrokeAlpha(e){this.current.strokeAlpha=e}setStrokeRGBColor(e,t,i){this.current.strokeColor=n.Util.makeHexColor(e,t,i)}setFillAlpha(e){this.current.fillAlpha=e}setFillRGBColor(e,t,i){this.current.fillColor=n.Util.makeHexColor(e,t,i);this.current.tspan=this.svgFactory.createElement("svg:tspan");this.current.xcoords=[];this.current.ycoords=[]}setStrokeColorN(e){this.current.strokeColor=this._makeColorN_Pattern(e)}setFillColorN(e){this.current.fillColor=this._makeColorN_Pattern(e)}shadingFill(e){const t=this.viewport.width,i=this.viewport.height,s=n.Util.inverseTransform(this.transformMatrix),r=n.Util.applyTransform([0,0],s),a=n.Util.applyTransform([0,i],s),o=n.Util.applyTransform([t,0],s),l=n.Util.applyTransform([t,i],s),c=Math.min(r[0],a[0],o[0],l[0]),h=Math.min(r[1],a[1],o[1],l[1]),d=Math.max(r[0],a[0],o[0],l[0]),u=Math.max(r[1],a[1],o[1],l[1]),p=this.svgFactory.createElement("svg:rect");p.setAttributeNS(null,"x",c);p.setAttributeNS(null,"y",h);p.setAttributeNS(null,"width",d-c);p.setAttributeNS(null,"height",u-h);p.setAttributeNS(null,"fill",this._makeShadingPattern(e));this.current.fillAlpha<1&&p.setAttributeNS(null,"fill-opacity",this.current.fillAlpha);this._ensureTransformGroup().appendChild(p)}_makeColorN_Pattern(e){return"TilingPattern"===e[0]?this._makeTilingPattern(e):this._makeShadingPattern(e)}_makeTilingPattern(e){const t=e[1],i=e[2],s=e[3]||n.IDENTITY_MATRIX,[r,a,o,l]=e[4],c=e[5],h=e[6],d=e[7],u="shading"+p++,[g,f]=n.Util.applyTransform([r,a],s),[m,_]=n.Util.applyTransform([o,l],s),[b,v]=n.Util.singularValueDecompose2dScale(s),w=c*b,y=h*v,S=this.svgFactory.createElement("svg:pattern");S.setAttributeNS(null,"id",u);S.setAttributeNS(null,"patternUnits","userSpaceOnUse");S.setAttributeNS(null,"width",w);S.setAttributeNS(null,"height",y);S.setAttributeNS(null,"x",`${g}`);S.setAttributeNS(null,"y",`${f}`);const P=this.svg,A=this.transformMatrix,C=this.current.fillColor,x=this.current.strokeColor,E=this.svgFactory.create(m-g,_-f);this.svg=E;this.transformMatrix=s;if(2===d){const e=n.Util.makeHexColor(...t);this.current.fillColor=e;this.current.strokeColor=e}this.executeOpTree(this.convertOpList(i));this.svg=P;this.transformMatrix=A;this.current.fillColor=C;this.current.strokeColor=x;S.appendChild(E.childNodes[0]);this.defs.appendChild(S);return`url(#${u})`}_makeShadingPattern(e){switch(e[0]){case"RadialAxial":const t="shading"+p++,i=e[3];let s;switch(e[1]){case"axial":const i=e[4],n=e[5];s=this.svgFactory.createElement("svg:linearGradient");s.setAttributeNS(null,"id",t);s.setAttributeNS(null,"gradientUnits","userSpaceOnUse");s.setAttributeNS(null,"x1",i[0]);s.setAttributeNS(null,"y1",i[1]);s.setAttributeNS(null,"x2",n[0]);s.setAttributeNS(null,"y2",n[1]);break;case"radial":const r=e[4],a=e[5],o=e[6],l=e[7];s=this.svgFactory.createElement("svg:radialGradient");s.setAttributeNS(null,"id",t);s.setAttributeNS(null,"gradientUnits","userSpaceOnUse");s.setAttributeNS(null,"cx",a[0]);s.setAttributeNS(null,"cy",a[1]);s.setAttributeNS(null,"r",l);s.setAttributeNS(null,"fx",r[0]);s.setAttributeNS(null,"fy",r[1]);s.setAttributeNS(null,"fr",o);break;default:throw new Error(`Unknown RadialAxial type: ${e[1]}`)}for(const e of i){const t=this.svgFactory.createElement("svg:stop");t.setAttributeNS(null,"offset",e[0]);t.setAttributeNS(null,"stop-color",e[1]);s.appendChild(t)}this.defs.appendChild(s);return`url(#${t})`;case"Mesh":(0,n.warn)("Unimplemented pattern Mesh");return null;case"Dummy":return"hotpink";default:throw new Error(`Unknown IR type: ${e[0]}`)}}setDash(e,t){this.current.dashArray=e;this.current.dashPhase=t}constructPath(e,t){const i=this.current;let s=i.x,r=i.y,a=[],o=0;for(const i of e)switch(0|i){case n.OPS.rectangle:s=t[o++];r=t[o++];const e=s+t[o++],i=r+t[o++];a.push("M",pf(s),pf(r),"L",pf(e),pf(r),"L",pf(e),pf(i),"L",pf(s),pf(i),"Z");break;case n.OPS.moveTo:s=t[o++];r=t[o++];a.push("M",pf(s),pf(r));break;case n.OPS.lineTo:s=t[o++];r=t[o++];a.push("L",pf(s),pf(r));break;case n.OPS.curveTo:s=t[o+4];r=t[o+5];a.push("C",pf(t[o]),pf(t[o+1]),pf(t[o+2]),pf(t[o+3]),pf(s),pf(r));o+=6;break;case n.OPS.curveTo2:a.push("C",pf(s),pf(r),pf(t[o]),pf(t[o+1]),pf(t[o+2]),pf(t[o+3]));s=t[o+2];r=t[o+3];o+=4;break;case n.OPS.curveTo3:s=t[o+2];r=t[o+3];a.push("C",pf(t[o]),pf(t[o+1]),pf(s),pf(r),pf(s),pf(r));o+=4;break;case n.OPS.closePath:a.push("Z")}a=a.join(" ");if(i.path&&e.length>0&&e[0]!==n.OPS.rectangle&&e[0]!==n.OPS.moveTo)a=i.path.getAttributeNS(null,"d")+a;else{i.path=this.svgFactory.createElement("svg:path");this._ensureTransformGroup().appendChild(i.path)}i.path.setAttributeNS(null,"d",a);i.path.setAttributeNS(null,"fill","none");i.element=i.path;i.setCurrentPoint(s,r)}endPath(){const e=this.current;e.path=null;if(!this.pendingClip)return;if(!e.element){this.pendingClip=null;return}const t="clippath"+d++,i=this.svgFactory.createElement("svg:clipPath");i.setAttributeNS(null,"id",t);i.setAttributeNS(null,"transform",pm(this.transformMatrix));const n=e.element.cloneNode(!0);"evenodd"===this.pendingClip?n.setAttributeNS(null,"clip-rule","evenodd"):n.setAttributeNS(null,"clip-rule","nonzero");this.pendingClip=null;i.appendChild(n);this.defs.appendChild(i);if(e.activeClipUrl){e.clipGroup=null;for(const e of this.extraStack)e.clipGroup=null;i.setAttributeNS(null,"clip-path",e.activeClipUrl)}e.activeClipUrl=`url(#${t})`;this.tgrp=null}clip(e){this.pendingClip=e}closePath(){const e=this.current;if(e.path){const t=`${e.path.getAttributeNS(null,"d")}Z`;e.path.setAttributeNS(null,"d",t)}}setLeading(e){this.current.leading=-e}setTextRise(e){this.current.textRise=e}setTextRenderingMode(e){this.current.textRenderingMode=e}setHScale(e){this.current.textHScale=e/100}setRenderingIntent(e){}setFlatness(e){}setGState(e){for(const[t,i]of e)switch(t){case"LW":this.setLineWidth(i);break;case"LC":this.setLineCap(i);break;case"LJ":this.setLineJoin(i);break;case"ML":this.setMiterLimit(i);break;case"D":this.setDash(i[0],i[1]);break;case"RI":this.setRenderingIntent(i);break;case"FL":this.setFlatness(i);break;case"Font":this.setFont(i);break;case"CA":this.setStrokeAlpha(i);break;case"ca":this.setFillAlpha(i);break;default:(0,n.warn)(`Unimplemented graphic state operator ${t}`)}}fill(){const e=this.current;if(e.element){e.element.setAttributeNS(null,"fill",e.fillColor);e.element.setAttributeNS(null,"fill-opacity",e.fillAlpha);this.endPath()}}stroke(){const e=this.current;if(e.element){this._setStrokeAttributes(e.element);e.element.setAttributeNS(null,"fill","none");this.endPath()}}_setStrokeAttributes(e,t=1){const i=this.current;let n=i.dashArray;1!==t&&n.length>0&&(n=n.map((function(e){return t*e})));e.setAttributeNS(null,"stroke",i.strokeColor);e.setAttributeNS(null,"stroke-opacity",i.strokeAlpha);e.setAttributeNS(null,"stroke-miterlimit",pf(i.miterLimit));e.setAttributeNS(null,"stroke-linecap",i.lineCap);e.setAttributeNS(null,"stroke-linejoin",i.lineJoin);e.setAttributeNS(null,"stroke-width",pf(t*i.lineWidth)+"px");e.setAttributeNS(null,"stroke-dasharray",n.map(pf).join(" "));e.setAttributeNS(null,"stroke-dashoffset",pf(t*i.dashPhase)+"px")}eoFill(){this.current.element&&this.current.element.setAttributeNS(null,"fill-rule","evenodd");this.fill()}fillStroke(){this.stroke();this.fill()}eoFillStroke(){this.current.element&&this.current.element.setAttributeNS(null,"fill-rule","evenodd");this.fillStroke()}closeStroke(){this.closePath();this.stroke()}closeFillStroke(){this.closePath();this.fillStroke()}closeEOFillStroke(){this.closePath();this.eoFillStroke()}paintSolidColorImageMask(){const e=this.svgFactory.createElement("svg:rect");e.setAttributeNS(null,"x","0");e.setAttributeNS(null,"y","0");e.setAttributeNS(null,"width","1px");e.setAttributeNS(null,"height","1px");e.setAttributeNS(null,"fill",this.current.fillColor);this._ensureTransformGroup().appendChild(e)}paintImageXObject(e){const t=e.startsWith("g_")?this.commonObjs.get(e):this.objs.get(e);t?this.paintInlineImageXObject(t):(0,n.warn)(`Dependent image with object ID ${e} is not ready yet`)}paintInlineImageXObject(e,t){const i=e.width,n=e.height,s=h(e,this.forceDataSchema,!!t),r=this.svgFactory.createElement("svg:rect");r.setAttributeNS(null,"x","0");r.setAttributeNS(null,"y","0");r.setAttributeNS(null,"width",pf(i));r.setAttributeNS(null,"height",pf(n));this.current.element=r;this.clip("nonzero");const a=this.svgFactory.createElement("svg:image");a.setAttributeNS(o,"xlink:href",s);a.setAttributeNS(null,"x","0");a.setAttributeNS(null,"y",pf(-n));a.setAttributeNS(null,"width",pf(i)+"px");a.setAttributeNS(null,"height",pf(n)+"px");a.setAttributeNS(null,"transform",`scale(${pf(1/i)} ${pf(-1/n)})`);t?t.appendChild(a):this._ensureTransformGroup().appendChild(a)}paintImageMaskXObject(e){const t=this.current,i=e.width,n=e.height,s=t.fillColor;t.maskId="mask"+u++;const r=this.svgFactory.createElement("svg:mask");r.setAttributeNS(null,"id",t.maskId);const a=this.svgFactory.createElement("svg:rect");a.setAttributeNS(null,"x","0");a.setAttributeNS(null,"y","0");a.setAttributeNS(null,"width",pf(i));a.setAttributeNS(null,"height",pf(n));a.setAttributeNS(null,"fill",s);a.setAttributeNS(null,"mask",`url(#${t.maskId})`);this.defs.appendChild(r);this._ensureTransformGroup().appendChild(a);this.paintInlineImageXObject(e,r)}paintFormXObjectBegin(e,t){Array.isArray(e)&&6===e.length&&this.transform(e[0],e[1],e[2],e[3],e[4],e[5]);if(t){const e=t[2]-t[0],i=t[3]-t[1],n=this.svgFactory.createElement("svg:rect");n.setAttributeNS(null,"x",t[0]);n.setAttributeNS(null,"y",t[1]);n.setAttributeNS(null,"width",pf(e));n.setAttributeNS(null,"height",pf(i));this.current.element=n;this.clip("nonzero");this.endPath()}}paintFormXObjectEnd(){}_initialize(e){const t=this.svgFactory.create(e.width,e.height),i=this.svgFactory.createElement("svg:defs");t.appendChild(i);this.defs=i;const n=this.svgFactory.createElement("svg:g");n.setAttributeNS(null,"transform",pm(e.transform));t.appendChild(n);this.svg=n;return t}_ensureClipGroup(){if(!this.current.clipGroup){const e=this.svgFactory.createElement("svg:g");e.setAttributeNS(null,"clip-path",this.current.activeClipUrl);this.svg.appendChild(e);this.current.clipGroup=e}return this.current.clipGroup}_ensureTransformGroup(){if(!this.tgrp){this.tgrp=this.svgFactory.createElement("svg:g");this.tgrp.setAttributeNS(null,"transform",pm(this.transformMatrix));this.current.activeClipUrl?this._ensureClipGroup().appendChild(this.tgrp):this.svg.appendChild(this.tgrp)}return this.tgrp}}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XfaLayer=void 0;t.XfaLayer=class XfaLayer{static setupStorage(e,t,i,n){const s=n.getValue(t,{value:null});switch(i.name){case"textarea":e.textContent=null!==s.value?s.value:"";e.addEventListener("input",(e=>{n.setValue(t,{value:e.target.value})}));break;case"input":null!==s.value&&e.setAttribute("value",s.value);"radio"===i.attributes.type?e.addEventListener("change",(e=>{const{target:i}=e;for(const e of document.getElementsByName(i.name))if(e!==i){const t=e.id;n.setValue(t.split("-")[0],{value:!1})}n.setValue(t,{value:i.checked})})):e.addEventListener("input",(e=>{n.setValue(t,{value:e.target.value})}));break;case"select":if(null!==s.value)for(const e of i.children)e.attributes.value===s.value&&(e.attributes.selected=!0);e.addEventListener("input",(e=>{const i=e.target.options,s=-1===i.selectedIndex?null:i[i.selectedIndex].value;n.setValue(t,{value:s})}))}}static setAttributes(e,t,i){const{attributes:n}=t;for(const[t,i]of Object.entries(n))null!=i&&"fieldId"!==t&&("style"!==t?"textContent"===t?e.textContent=i:e.setAttribute(t,i):Object.assign(e.style,i));i&&void 0!==n.fieldId&&this.setupStorage(e,n.fieldId,t,i)}static render(e){const t=e.annotationStorage,i=e.xfa,n=document.createElement(i.name);i.attributes&&this.setAttributes(n,i);const s=[[i,-1,n]],r=e.div;r.appendChild(n);const a=e.viewport.transform.join(",");r.style.transform=`matrix(${a})`;r.setAttribute("class","xfaLayer xfaFont");for(;s.length>0;){const[e,i,n]=s[s.length-1];if(i+1===e.children.length){s.pop();continue}const r=e.children[++s[s.length-1][1]];if(null===r)continue;const{name:a}=r;if("#text"===a){n.appendChild(document.createTextNode(r.value));continue}const o=document.createElement(a);n.appendChild(o);r.attributes&&this.setAttributes(o,r,t);r.children&&r.children.length>0?s.push([r,-1,o]):r.value&&o.appendChild(document.createTextNode(r.value))}}static update(e){const t=`matrix(${e.viewport.transform.join(",")})`;e.div.style.transform=t;e.div.hidden=!1}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFNodeStream=void 0;var n=i(2),s=i(23);const r=require("fs"),a=require("http"),o=require("https"),l=require("url"),c=/^file:\/\/\/[a-zA-Z]:\//;t.PDFNodeStream=class PDFNodeStream{constructor(e){this.source=e;this.url=function parseUrl(e){const t=l.parse(e);if("file:"===t.protocol||t.host)return t;if(/^[a-z]:[/\\]/i.test(e))return l.parse(`file:///${e}`);t.host||(t.protocol="file:");return t}(e.url);this.isHttp="http:"===this.url.protocol||"https:"===this.url.protocol;this.isFsUrl="file:"===this.url.protocol;this.httpHeaders=this.isHttp&&e.httpHeaders||{};this._fullRequestReader=null;this._rangeRequestReaders=[]}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFNodeStream.getFullReader can only be called once.");this._fullRequestReader=this.isFsUrl?new PDFNodeStreamFsFullReader(this):new PDFNodeStreamFullReader(this);return this._fullRequestReader}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=this.isFsUrl?new PDFNodeStreamFsRangeReader(this,e,t):new PDFNodeStreamRangeReader(this,e,t);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class BaseFullReader{constructor(e){this._url=e.url;this._done=!1;this._storedError=null;this.onProgress=null;const t=e.source;this._contentLength=t.length;this._loaded=0;this._filename=null;this._disableRange=t.disableRange||!1;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);this._isStreamingSupported=!t.disableStream;this._isRangeSupported=!t.disableRange;this._readableStream=null;this._readCapability=(0,n.createPromiseCapability)();this._headersCapability=(0,n.createPromiseCapability)()}get headersReady(){return this._headersCapability.promise}get filename(){return this._filename}get contentLength(){return this._contentLength}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;if(this._done)return{value:void 0,done:!0};if(this._storedError)throw this._storedError;const e=this._readableStream.read();if(null===e){this._readCapability=(0,n.createPromiseCapability)();return this.read()}this._loaded+=e.length;this.onProgress&&this.onProgress({loaded:this._loaded,total:this._contentLength});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._readableStream?this._readableStream.destroy(e):this._error(e)}_error(e){this._storedError=e;this._readCapability.resolve()}_setReadableStream(e){this._readableStream=e;e.on("readable",(()=>{this._readCapability.resolve()}));e.on("end",(()=>{e.destroy();this._done=!0;this._readCapability.resolve()}));e.on("error",(e=>{this._error(e)}));!this._isStreamingSupported&&this._isRangeSupported&&this._error(new n.AbortException("streaming is disabled"));this._storedError&&this._readableStream.destroy(this._storedError)}}class BaseRangeReader{constructor(e){this._url=e.url;this._done=!1;this._storedError=null;this.onProgress=null;this._loaded=0;this._readableStream=null;this._readCapability=(0,n.createPromiseCapability)();const t=e.source;this._isStreamingSupported=!t.disableStream}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;if(this._done)return{value:void 0,done:!0};if(this._storedError)throw this._storedError;const e=this._readableStream.read();if(null===e){this._readCapability=(0,n.createPromiseCapability)();return this.read()}this._loaded+=e.length;this.onProgress&&this.onProgress({loaded:this._loaded});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._readableStream?this._readableStream.destroy(e):this._error(e)}_error(e){this._storedError=e;this._readCapability.resolve()}_setReadableStream(e){this._readableStream=e;e.on("readable",(()=>{this._readCapability.resolve()}));e.on("end",(()=>{e.destroy();this._done=!0;this._readCapability.resolve()}));e.on("error",(e=>{this._error(e)}));this._storedError&&this._readableStream.destroy(this._storedError)}}function createRequestOptions(e,t){return{protocol:e.protocol,auth:e.auth,host:e.hostname,port:e.port,path:e.path,method:"GET",headers:t}}class PDFNodeStreamFullReader extends BaseFullReader{constructor(e){super(e);const handleResponse=t=>{if(404===t.statusCode){const e=new n.MissingPDFException(`Missing PDF "${this._url}".`);this._storedError=e;this._headersCapability.reject(e);return}this._headersCapability.resolve();this._setReadableStream(t);const getResponseHeader=e=>this._readableStream.headers[e.toLowerCase()],{allowRangeRequests:i,suggestedLength:r}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:e.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});this._isRangeSupported=i;this._contentLength=r||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader)};this._request=null;"http:"===this._url.protocol?this._request=a.request(createRequestOptions(this._url,e.httpHeaders),handleResponse):this._request=o.request(createRequestOptions(this._url,e.httpHeaders),handleResponse);this._request.on("error",(e=>{this._storedError=e;this._headersCapability.reject(e)}));this._request.end()}}class PDFNodeStreamRangeReader extends BaseRangeReader{constructor(e,t,i){super(e);this._httpHeaders={};for(const t in e.httpHeaders){const i=e.httpHeaders[t];void 0!==i&&(this._httpHeaders[t]=i)}this._httpHeaders.Range=`bytes=${t}-${i-1}`;const handleResponse=e=>{if(404!==e.statusCode)this._setReadableStream(e);else{const e=new n.MissingPDFException(`Missing PDF "${this._url}".`);this._storedError=e}};this._request=null;"http:"===this._url.protocol?this._request=a.request(createRequestOptions(this._url,this._httpHeaders),handleResponse):this._request=o.request(createRequestOptions(this._url,this._httpHeaders),handleResponse);this._request.on("error",(e=>{this._storedError=e}));this._request.end()}}class PDFNodeStreamFsFullReader extends BaseFullReader{constructor(e){super(e);let t=decodeURIComponent(this._url.path);c.test(this._url.href)&&(t=t.replace(/^\//,""));r.lstat(t,((e,i)=>{if(e){"ENOENT"===e.code&&(e=new n.MissingPDFException(`Missing PDF "${t}".`));this._storedError=e;this._headersCapability.reject(e)}else{this._contentLength=i.size;this._setReadableStream(r.createReadStream(t));this._headersCapability.resolve()}}))}}class PDFNodeStreamFsRangeReader extends BaseRangeReader{constructor(e,t,i){super(e);let n=decodeURIComponent(this._url.path);c.test(this._url.href)&&(n=n.replace(/^\//,""));this._setReadableStream(r.createReadStream(n,{start:t,end:i-1}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.createResponseStatusError=function createResponseStatusError(e,t){if(404===e||0===e&&t.startsWith("file:"))return new n.MissingPDFException('Missing PDF "'+t+'".');return new n.UnexpectedResponseException(`Unexpected server response (${e}) while retrieving PDF "${t}".`,e)};t.extractFilenameFromHeader=function extractFilenameFromHeader(e){const t=e("Content-Disposition");if(t){let e=(0,s.getFilenameFromContentDispositionHeader)(t);if(e.includes("%"))try{e=decodeURIComponent(e)}catch(e){}if((0,r.isPdfFile)(e))return e}return null};t.validateRangeRequestCapabilities=function validateRangeRequestCapabilities({getResponseHeader:e,isHttp:t,rangeChunkSize:i,disableRange:s}){(0,n.assert)(i>0,"Range chunk size must be larger than zero");const r={allowRangeRequests:!1,suggestedLength:void 0},a=parseInt(e("Content-Length"),10);if(!Number.isInteger(a))return r;r.suggestedLength=a;if(a<=2*i)return r;if(s||!t)return r;if("bytes"!==e("Accept-Ranges"))return r;if("identity"!==(e("Content-Encoding")||"identity"))return r;r.allowRangeRequests=!0;return r};t.validateResponseStatus=function validateResponseStatus(e){return 200===e||206===e};var n=i(2),s=i(24),r=i(1)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getFilenameFromContentDispositionHeader=function getFilenameFromContentDispositionHeader(e){let t=!0,i=toParamRegExp("filename\\*","i").exec(e);if(i){i=i[1];let e=rfc2616unquote(i);e=unescape(e);e=rfc5987decode(e);e=rfc2047decode(e);return fixupEncoding(e)}i=function rfc2231getparam(e){const t=[];let i;const n=toParamRegExp("filename\\*((?!0\\d)\\d+)(\\*?)","ig");for(;null!==(i=n.exec(e));){let[,e,n,s]=i;e=parseInt(e,10);if(e in t){if(0===e)break}else t[e]=[n,s]}const s=[];for(let e=0;e<t.length&&e in t;++e){let[i,n]=t[e];n=rfc2616unquote(n);if(i){n=unescape(n);0===e&&(n=rfc5987decode(n))}s.push(n)}return s.join("")}(e);if(i){return fixupEncoding(rfc2047decode(i))}i=toParamRegExp("filename","i").exec(e);if(i){i=i[1];let e=rfc2616unquote(i);e=rfc2047decode(e);return fixupEncoding(e)}function toParamRegExp(e,t){return new RegExp("(?:^|;)\\s*"+e+'\\s*=\\s*([^";\\s][^;\\s]*|"(?:[^"\\\\]|\\\\"?)+"?)',t)}function textdecode(e,i){if(e){if(!/^[\x00-\xFF]+$/.test(i))return i;try{const s=new TextDecoder(e,{fatal:!0}),r=(0,n.stringToBytes)(i);i=s.decode(r);t=!1}catch(n){if(/^utf-?8$/i.test(e))try{i=decodeURIComponent(escape(i));t=!1}catch(e){}}}return i}function fixupEncoding(e){if(t&&/[\x80-\xff]/.test(e)){e=textdecode("utf-8",e);t&&(e=textdecode("iso-8859-1",e))}return e}function rfc2616unquote(e){if(e.startsWith('"')){const t=e.slice(1).split('\\"');for(let e=0;e<t.length;++e){const i=t[e].indexOf('"');if(-1!==i){t[e]=t[e].slice(0,i);t.length=e+1}t[e]=t[e].replace(/\\(.)/g,"$1")}e=t.join('"')}return e}function rfc5987decode(e){const t=e.indexOf("'");if(-1===t)return e;return textdecode(e.slice(0,t),e.slice(t+1).replace(/^[^']*'/,""))}function rfc2047decode(e){return!e.startsWith("=?")||/[\x00-\x19\x80-\xff]/.test(e)?e:e.replace(/=\?([\w-]*)\?([QqBb])\?((?:[^?]|\?(?!=))*)\?=/g,(function(e,t,i,n){if("q"===i||"Q"===i)return textdecode(t,n=(n=n.replace(/_/g," ")).replace(/=([0-9a-fA-F]{2})/g,(function(e,t){return String.fromCharCode(parseInt(t,16))})));try{n=atob(n)}catch(e){}return textdecode(t,n)}))}return""};var n=i(2)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFNetworkStream=void 0;var n=i(2),s=i(23);class NetworkManager{constructor(e,t){this.url=e;t=t||{};this.isHttp=/^https?:/i.test(e);this.httpHeaders=this.isHttp&&t.httpHeaders||{};this.withCredentials=t.withCredentials||!1;this.getXhr=t.getXhr||function NetworkManager_getXhr(){return new XMLHttpRequest};this.currXhrId=0;this.pendingRequests=Object.create(null)}requestRange(e,t,i){const n={begin:e,end:t};for(const e in i)n[e]=i[e];return this.request(n)}requestFull(e){return this.request(e)}request(e){const t=this.getXhr(),i=this.currXhrId++,n=this.pendingRequests[i]={xhr:t};t.open("GET",this.url);t.withCredentials=this.withCredentials;for(const e in this.httpHeaders){const i=this.httpHeaders[e];void 0!==i&&t.setRequestHeader(e,i)}if(this.isHttp&&"begin"in e&&"end"in e){t.setRequestHeader("Range",`bytes=${e.begin}-${e.end-1}`);n.expectedStatus=206}else n.expectedStatus=200;t.responseType="arraybuffer";e.onError&&(t.onerror=function(i){e.onError(t.status)});t.onreadystatechange=this.onStateChange.bind(this,i);t.onprogress=this.onProgress.bind(this,i);n.onHeadersReceived=e.onHeadersReceived;n.onDone=e.onDone;n.onError=e.onError;n.onProgress=e.onProgress;t.send(null);return i}onProgress(e,t){const i=this.pendingRequests[e];i&&i.onProgress&&i.onProgress(t)}onStateChange(e,t){const i=this.pendingRequests[e];if(!i)return;const s=i.xhr;if(s.readyState>=2&&i.onHeadersReceived){i.onHeadersReceived();delete i.onHeadersReceived}if(4!==s.readyState)return;if(!(e in this.pendingRequests))return;delete this.pendingRequests[e];if(0===s.status&&this.isHttp){i.onError&&i.onError(s.status);return}const r=s.status||200;if(!(200===r&&206===i.expectedStatus)&&r!==i.expectedStatus){i.onError&&i.onError(s.status);return}const a=function getArrayBuffer(e){const t=e.response;return"string"!=typeof t?t:(0,n.stringToBytes)(t).buffer}(s);if(206===r){const e=s.getResponseHeader("Content-Range"),t=/bytes (\d+)-(\d+)\/(\d+)/.exec(e);i.onDone({begin:parseInt(t[1],10),chunk:a})}else a?i.onDone({begin:0,chunk:a}):i.onError&&i.onError(s.status)}getRequestXhr(e){return this.pendingRequests[e].xhr}isPendingRequest(e){return e in this.pendingRequests}abortRequest(e){const t=this.pendingRequests[e].xhr;delete this.pendingRequests[e];t.abort()}}t.PDFNetworkStream=class PDFNetworkStream{constructor(e){this._source=e;this._manager=new NetworkManager(e.url,{httpHeaders:e.httpHeaders,withCredentials:e.withCredentials});this._rangeChunkSize=e.rangeChunkSize;this._fullRequestReader=null;this._rangeRequestReaders=[]}_onRangeRequestReaderClosed(e){const t=this._rangeRequestReaders.indexOf(e);t>=0&&this._rangeRequestReaders.splice(t,1)}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFNetworkStream.getFullReader can only be called once.");this._fullRequestReader=new PDFNetworkStreamFullRequestReader(this._manager,this._source);return this._fullRequestReader}getRangeReader(e,t){const i=new PDFNetworkStreamRangeRequestReader(this._manager,e,t);i.onClosed=this._onRangeRequestReaderClosed.bind(this);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class PDFNetworkStreamFullRequestReader{constructor(e,t){this._manager=e;const i={onHeadersReceived:this._onHeadersReceived.bind(this),onDone:this._onDone.bind(this),onError:this._onError.bind(this),onProgress:this._onProgress.bind(this)};this._url=t.url;this._fullRequestId=e.requestFull(i);this._headersReceivedCapability=(0,n.createPromiseCapability)();this._disableRange=t.disableRange||!1;this._contentLength=t.length;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);this._isStreamingSupported=!1;this._isRangeSupported=!1;this._cachedChunks=[];this._requests=[];this._done=!1;this._storedError=void 0;this._filename=null;this.onProgress=null}_onHeadersReceived(){const e=this._fullRequestId,t=this._manager.getRequestXhr(e),getResponseHeader=e=>t.getResponseHeader(e),{allowRangeRequests:i,suggestedLength:n}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:this._manager.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});i&&(this._isRangeSupported=!0);this._contentLength=n||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader);this._isRangeSupported&&this._manager.abortRequest(e);this._headersReceivedCapability.resolve()}_onDone(e){if(e)if(this._requests.length>0){this._requests.shift().resolve({value:e.chunk,done:!1})}else this._cachedChunks.push(e.chunk);this._done=!0;if(!(this._cachedChunks.length>0)){for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0}}_onError(e){const t=this._url,i=(0,s.createResponseStatusError)(e,t);this._storedError=i;this._headersReceivedCapability.reject(i);for(const e of this._requests)e.reject(i);this._requests.length=0;this._cachedChunks.length=0}_onProgress(e){this.onProgress&&this.onProgress({loaded:e.loaded,total:e.lengthComputable?e.total:this._contentLength})}get filename(){return this._filename}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}get contentLength(){return this._contentLength}get headersReady(){return this._headersReceivedCapability.promise}async read(){if(this._storedError)throw this._storedError;if(this._cachedChunks.length>0){return{value:this._cachedChunks.shift(),done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;this._headersReceivedCapability.reject(e);for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._manager.isPendingRequest(this._fullRequestId)&&this._manager.abortRequest(this._fullRequestId);this._fullRequestReader=null}}class PDFNetworkStreamRangeRequestReader{constructor(e,t,i){this._manager=e;const n={onDone:this._onDone.bind(this),onProgress:this._onProgress.bind(this)};this._requestId=e.requestRange(t,i,n);this._requests=[];this._queuedChunk=null;this._done=!1;this.onProgress=null;this.onClosed=null}_close(){this.onClosed&&this.onClosed(this)}_onDone(e){const t=e.chunk;if(this._requests.length>0){this._requests.shift().resolve({value:t,done:!1})}else this._queuedChunk=t;this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._close()}_onProgress(e){!this.isStreamingSupported&&this.onProgress&&this.onProgress({loaded:e.loaded})}get isStreamingSupported(){return!1}async read(){if(null!==this._queuedChunk){const e=this._queuedChunk;this._queuedChunk=null;return{value:e,done:!1}}if(this._done)return{value:void 0,done:!0};const e=(0,n.createPromiseCapability)();this._requests.push(e);return e.promise}cancel(e){this._done=!0;for(const e of this._requests)e.resolve({value:void 0,done:!0});this._requests.length=0;this._manager.isPendingRequest(this._requestId)&&this._manager.abortRequest(this._requestId);this._close()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFetchStream=void 0;var n=i(2),s=i(23);function createFetchOptions(e,t,i){return{method:"GET",headers:e,signal:i?.signal,mode:"cors",credentials:t?"include":"same-origin",redirect:"follow"}}function createHeaders(e){const t=new Headers;for(const i in e){const n=e[i];void 0!==n&&t.append(i,n)}return t}t.PDFFetchStream=class PDFFetchStream{constructor(e){this.source=e;this.isHttp=/^https?:/i.test(e.url);this.httpHeaders=this.isHttp&&e.httpHeaders||{};this._fullRequestReader=null;this._rangeRequestReaders=[]}get _progressiveDataLength(){return this._fullRequestReader?._loaded??0}getFullReader(){(0,n.assert)(!this._fullRequestReader,"PDFFetchStream.getFullReader can only be called once.");this._fullRequestReader=new PDFFetchStreamReader(this);return this._fullRequestReader}getRangeReader(e,t){if(t<=this._progressiveDataLength)return null;const i=new PDFFetchStreamRangeReader(this,e,t);this._rangeRequestReaders.push(i);return i}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);for(const t of this._rangeRequestReaders.slice(0))t.cancel(e)}};class PDFFetchStreamReader{constructor(e){this._stream=e;this._reader=null;this._loaded=0;this._filename=null;const t=e.source;this._withCredentials=t.withCredentials||!1;this._contentLength=t.length;this._headersCapability=(0,n.createPromiseCapability)();this._disableRange=t.disableRange||!1;this._rangeChunkSize=t.rangeChunkSize;this._rangeChunkSize||this._disableRange||(this._disableRange=!0);"undefined"!=typeof AbortController&&(this._abortController=new AbortController);this._isStreamingSupported=!t.disableStream;this._isRangeSupported=!t.disableRange;this._headers=createHeaders(this._stream.httpHeaders);const i=t.url;fetch(i,createFetchOptions(this._headers,this._withCredentials,this._abortController)).then((e=>{if(!(0,s.validateResponseStatus)(e.status))throw(0,s.createResponseStatusError)(e.status,i);this._reader=e.body.getReader();this._headersCapability.resolve();const getResponseHeader=t=>e.headers.get(t),{allowRangeRequests:t,suggestedLength:r}=(0,s.validateRangeRequestCapabilities)({getResponseHeader:getResponseHeader,isHttp:this._stream.isHttp,rangeChunkSize:this._rangeChunkSize,disableRange:this._disableRange});this._isRangeSupported=t;this._contentLength=r||this._contentLength;this._filename=(0,s.extractFilenameFromHeader)(getResponseHeader);!this._isStreamingSupported&&this._isRangeSupported&&this.cancel(new n.AbortException("Streaming is disabled."))})).catch(this._headersCapability.reject);this.onProgress=null}get headersReady(){return this._headersCapability.promise}get filename(){return this._filename}get contentLength(){return this._contentLength}get isRangeSupported(){return this._isRangeSupported}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._headersCapability.promise;const{value:e,done:t}=await this._reader.read();if(t)return{value:e,done:t};this._loaded+=e.byteLength;this.onProgress&&this.onProgress({loaded:this._loaded,total:this._contentLength});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._reader&&this._reader.cancel(e);this._abortController&&this._abortController.abort()}}class PDFFetchStreamRangeReader{constructor(e,t,i){this._stream=e;this._reader=null;this._loaded=0;const r=e.source;this._withCredentials=r.withCredentials||!1;this._readCapability=(0,n.createPromiseCapability)();this._isStreamingSupported=!r.disableStream;"undefined"!=typeof AbortController&&(this._abortController=new AbortController);this._headers=createHeaders(this._stream.httpHeaders);this._headers.append("Range",`bytes=${t}-${i-1}`);const a=r.url;fetch(a,createFetchOptions(this._headers,this._withCredentials,this._abortController)).then((e=>{if(!(0,s.validateResponseStatus)(e.status))throw(0,s.createResponseStatusError)(e.status,a);this._readCapability.resolve();this._reader=e.body.getReader()})).catch((e=>{if("AbortError"!==e?.name)throw e}));this.onProgress=null}get isStreamingSupported(){return this._isStreamingSupported}async read(){await this._readCapability.promise;const{value:e,done:t}=await this._reader.read();if(t)return{value:e,done:t};this._loaded+=e.byteLength;this.onProgress&&this.onProgress({loaded:this._loaded});return{value:new Uint8Array(e).buffer,done:!1}}cancel(e){this._reader&&this._reader.cancel(e);this._abortController&&this._abortController.abort()}}}],__webpack_module_cache__={};function __w_pdfjs_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var i=__webpack_module_cache__[e]={exports:{}};__webpack_modules__[e](i,i.exports,__w_pdfjs_require__);return i.exports}var __webpack_exports__={};(()=>{var e=__webpack_exports__;Object.defineProperty(e,"__esModule",{value:!0});Object.defineProperty(e,"addLinkAttributes",{enumerable:!0,get:function(){return t.addLinkAttributes}});Object.defineProperty(e,"getFilenameFromUrl",{enumerable:!0,get:function(){return t.getFilenameFromUrl}});Object.defineProperty(e,"getPdfFilenameFromUrl",{enumerable:!0,get:function(){return t.getPdfFilenameFromUrl}});Object.defineProperty(e,"isPdfFile",{enumerable:!0,get:function(){return t.isPdfFile}});Object.defineProperty(e,"LinkTarget",{enumerable:!0,get:function(){return t.LinkTarget}});Object.defineProperty(e,"loadScript",{enumerable:!0,get:function(){return t.loadScript}});Object.defineProperty(e,"PDFDateString",{enumerable:!0,get:function(){return t.PDFDateString}});Object.defineProperty(e,"RenderingCancelledException",{enumerable:!0,get:function(){return t.RenderingCancelledException}});Object.defineProperty(e,"build",{enumerable:!0,get:function(){return i.build}});Object.defineProperty(e,"getDocument",{enumerable:!0,get:function(){return i.getDocument}});Object.defineProperty(e,"LoopbackPort",{enumerable:!0,get:function(){return i.LoopbackPort}});Object.defineProperty(e,"PDFDataRangeTransport",{enumerable:!0,get:function(){return i.PDFDataRangeTransport}});Object.defineProperty(e,"PDFWorker",{enumerable:!0,get:function(){return i.PDFWorker}});Object.defineProperty(e,"version",{enumerable:!0,get:function(){return i.version}});Object.defineProperty(e,"CMapCompressionType",{enumerable:!0,get:function(){return n.CMapCompressionType}});Object.defineProperty(e,"createObjectURL",{enumerable:!0,get:function(){return n.createObjectURL}});Object.defineProperty(e,"createPromiseCapability",{enumerable:!0,get:function(){return n.createPromiseCapability}});Object.defineProperty(e,"createValidAbsoluteUrl",{enumerable:!0,get:function(){return n.createValidAbsoluteUrl}});Object.defineProperty(e,"InvalidPDFException",{enumerable:!0,get:function(){return n.InvalidPDFException}});Object.defineProperty(e,"MissingPDFException",{enumerable:!0,get:function(){return n.MissingPDFException}});Object.defineProperty(e,"OPS",{enumerable:!0,get:function(){return n.OPS}});Object.defineProperty(e,"PasswordResponses",{enumerable:!0,get:function(){return n.PasswordResponses}});Object.defineProperty(e,"PermissionFlag",{enumerable:!0,get:function(){return n.PermissionFlag}});Object.defineProperty(e,"removeNullCharacters",{enumerable:!0,get:function(){return n.removeNullCharacters}});Object.defineProperty(e,"shadow",{enumerable:!0,get:function(){return n.shadow}});Object.defineProperty(e,"UnexpectedResponseException",{enumerable:!0,get:function(){return n.UnexpectedResponseException}});Object.defineProperty(e,"UNSUPPORTED_FEATURES",{enumerable:!0,get:function(){return n.UNSUPPORTED_FEATURES}});Object.defineProperty(e,"Util",{enumerable:!0,get:function(){return n.Util}});Object.defineProperty(e,"VerbosityLevel",{enumerable:!0,get:function(){return n.VerbosityLevel}});Object.defineProperty(e,"AnnotationLayer",{enumerable:!0,get:function(){return s.AnnotationLayer}});Object.defineProperty(e,"apiCompatibilityParams",{enumerable:!0,get:function(){return r.apiCompatibilityParams}});Object.defineProperty(e,"GlobalWorkerOptions",{enumerable:!0,get:function(){return a.GlobalWorkerOptions}});Object.defineProperty(e,"renderTextLayer",{enumerable:!0,get:function(){return o.renderTextLayer}});Object.defineProperty(e,"SVGGraphics",{enumerable:!0,get:function(){return l.SVGGraphics}});Object.defineProperty(e,"XfaLayer",{enumerable:!0,get:function(){return c.XfaLayer}});var t=__w_pdfjs_require__(1),i=__w_pdfjs_require__(5),n=__w_pdfjs_require__(2),s=__w_pdfjs_require__(17),r=__w_pdfjs_require__(9),a=__w_pdfjs_require__(12),o=__w_pdfjs_require__(19),l=__w_pdfjs_require__(20),c=__w_pdfjs_require__(21);{const{isNodeJS:e}=__w_pdfjs_require__(4);if(e){const e=__w_pdfjs_require__(22).PDFNodeStream;(0,i.setPDFNetworkStreamFactory)((t=>new e(t)))}else{const e=__w_pdfjs_require__(25).PDFNetworkStream;let n;(0,t.isFetchSupported)()&&(n=__w_pdfjs_require__(26).PDFFetchStream);(0,i.setPDFNetworkStreamFactory)((i=>n&&(0,t.isValidFetchUrl)(i.url)?new n(i):new e(i)))}}})();return __webpack_exports__})()}));
/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */(()=>{"use strict";var e=[,(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OptionKind=t.AppOptions=void 0;var n=i(2);const s={VIEWER:2,API:4,WORKER:8,PREFERENCE:128};t.OptionKind=s;const r={cursorToolOnLoad:{value:0,kind:s.VIEWER+s.PREFERENCE},defaultUrl:{value:"compressed.tracemonkey-pldi-09.pdf",kind:s.VIEWER},defaultZoomValue:{value:"",kind:s.VIEWER+s.PREFERENCE},disableHistory:{value:!1,kind:s.VIEWER},disablePageLabels:{value:!1,kind:s.VIEWER+s.PREFERENCE},enablePermissions:{value:!1,kind:s.VIEWER+s.PREFERENCE},enablePrintAutoRotate:{value:!0,kind:s.VIEWER+s.PREFERENCE},enableScripting:{value:!0,kind:s.VIEWER+s.PREFERENCE},externalLinkRel:{value:"noopener noreferrer nofollow",kind:s.VIEWER},externalLinkTarget:{value:0,kind:s.VIEWER+s.PREFERENCE},historyUpdateUrl:{value:!1,kind:s.VIEWER+s.PREFERENCE},ignoreDestinationZoom:{value:!1,kind:s.VIEWER+s.PREFERENCE},imageResourcesPath:{value:"./images/",kind:s.VIEWER},maxCanvasPixels:{value:16777216,compatibility:n.viewerCompatibilityParams.maxCanvasPixels,kind:s.VIEWER},pdfBugEnabled:{value:!1,kind:s.VIEWER+s.PREFERENCE},printResolution:{value:150,kind:s.VIEWER},renderer:{value:"canvas",kind:s.VIEWER},renderInteractiveForms:{value:!0,kind:s.VIEWER+s.PREFERENCE},sidebarViewOnLoad:{value:-1,kind:s.VIEWER+s.PREFERENCE},scrollModeOnLoad:{value:-1,kind:s.VIEWER+s.PREFERENCE},spreadModeOnLoad:{value:-1,kind:s.VIEWER+s.PREFERENCE},textLayerMode:{value:1,kind:s.VIEWER+s.PREFERENCE},useOnlyCssZoom:{value:!1,kind:s.VIEWER+s.PREFERENCE},viewerCssTheme:{value:0,kind:s.VIEWER+s.PREFERENCE},viewOnLoad:{value:0,kind:s.VIEWER+s.PREFERENCE},cMapPacked:{value:!0,kind:s.API},cMapUrl:{value:"../web/cmaps/",kind:s.API},disableAutoFetch:{value:!1,kind:s.API+s.PREFERENCE},disableFontFace:{value:!1,kind:s.API+s.PREFERENCE},disableRange:{value:!1,kind:s.API+s.PREFERENCE},disableStream:{value:!1,kind:s.API+s.PREFERENCE},docBaseUrl:{value:"",kind:s.API},enableXfa:{value:!1,kind:s.API+s.PREFERENCE},fontExtraProperties:{value:!1,kind:s.API},isEvalSupported:{value:!0,kind:s.API},maxImageSize:{value:-1,kind:s.API},pdfBug:{value:!1,kind:s.API},verbosity:{value:1,kind:s.API},workerPort:{value:null,kind:s.WORKER},workerSrc:{value:"../build/pdf.worker.js",kind:s.WORKER}};r.disablePreferences={value:!1,kind:s.VIEWER};r.locale={value:"undefined"!=typeof navigator?navigator.language:"en-US",kind:s.VIEWER};r.sandboxBundleSrc={value:"../build/pdf.sandbox.js",kind:s.VIEWER};r.renderer.kind+=s.PREFERENCE;const a=Object.create(null);t.AppOptions=class AppOptions{constructor(){throw new Error("Cannot initialize AppOptions.")}static get(e){const t=a[e];if(void 0!==t)return t;const i=r[e];return void 0!==i?i.compatibility??i.value:void 0}static getAll(e=null){const t=Object.create(null);for(const i in r){const n=r[i];if(e){if(0==(e&n.kind))continue;if(e===s.PREFERENCE){const e=n.value,s=typeof e;if("boolean"===s||"string"===s||"number"===s&&Number.isInteger(e)){t[i]=e;continue}throw new Error(`Invalid type for preference: ${i}`)}}const o=a[i];t[i]=void 0!==o?o:n.compatibility??n.value}return t}static set(e,t){a[e]=t}static setAll(e){for(const t in e)a[t]=e[t]}static remove(e){delete a[e]}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.viewerCompatibilityParams=void 0;const i=Object.create(null);{const e="undefined"!=typeof navigator&&navigator.userAgent||"",t="undefined"!=typeof navigator&&navigator.platform||"",n="undefined"!=typeof navigator&&navigator.maxTouchPoints||1,s=/Android/.test(e),r=/\b(iPad|iPhone|iPod)(?=;)/.test(e)||"MacIntel"===t&&n>1,a=/CriOS/.test(e);!function checkOnBlobSupport(){a&&(i.disableCreateObjectURL=!0)}();!function checkCanvasSizeLimitation(){(r||s)&&(i.maxCanvasPixels=5242880)}()}const n=Object.freeze(i);t.viewerCompatibilityParams=n},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFViewerApplication=t.PDFPrintServiceFactory=t.DefaultExternalServices=void 0;var n=i(4),s=i(1),r=i(5),a=i(6),o=i(8),l=i(9),c=i(10),h=i(11),d=i(13),u=i(14),p=i(15),g=i(17),f=i(18),m=i(19),_=i(20),b=i(21),v=i(22),w=i(23),y=i(24),S=i(25),P=i(27),A=i(35),C=i(37),x=i(2),E=i(38);const T="enablePermissions",k=-1,L=1,R={AUTOMATIC:0,LIGHT:1,DARK:2},I=["1.0","1.1","1.2","1.3","1.4","1.5","1.6","1.7","1.8","1.9","2.0","2.1","2.2","2.3"],F=["acrobat distiller","acrobat pdfwriter","adobe livecycle","adobe pdf library","adobe photoshop","ghostscript","tcpdf","cairo","dvipdfm","dvips","pdftex","pdfkit","itext","prince","quarkxpress","mac os x","microsoft","openoffice","oracle","luradocument","pdf-xchange","antenna house","aspose.cells","fpdf"];class DefaultExternalServices{constructor(){throw new Error("Cannot initialize DefaultExternalServices.")}static updateFindControlState(e){}static updateFindMatchesCount(e){}static initPassiveLoading(e){}static async fallback(e){}static reportTelemetry(e){}static createDownloadManager(e){throw new Error("Not implemented: createDownloadManager")}static createPreferences(){throw new Error("Not implemented: createPreferences")}static createL10n(e){throw new Error("Not implemented: createL10n")}static createScripting(e){throw new Error("Not implemented: createScripting")}static get supportsIntegratedFind(){return(0,r.shadow)(this,"supportsIntegratedFind",!1)}static get supportsDocumentFonts(){return(0,r.shadow)(this,"supportsDocumentFonts",!0)}static get supportedMouseWheelZoomModifierKeys(){return(0,r.shadow)(this,"supportedMouseWheelZoomModifierKeys",{ctrlKey:!0,metaKey:!0})}static get isInAutomation(){return(0,r.shadow)(this,"isInAutomation",!1)}}t.DefaultExternalServices=DefaultExternalServices;const M={initialBookmark:document.location.hash.substring(1),_initializedCapability:(0,r.createPromiseCapability)(),_fellback:!1,appConfig:null,pdfDocument:null,pdfLoadingTask:null,printService:null,pdfViewer:null,pdfThumbnailViewer:null,pdfRenderingQueue:null,pdfPresentationMode:null,pdfDocumentProperties:null,pdfLinkService:null,pdfHistory:null,pdfSidebar:null,pdfSidebarResizer:null,pdfOutlineViewer:null,pdfAttachmentViewer:null,pdfLayerViewer:null,pdfCursorTools:null,pdfScriptingManager:null,store:null,downloadManager:null,overlayManager:null,preferences:null,toolbar:null,secondaryToolbar:null,eventBus:null,l10n:null,isInitialViewSet:!1,downloadComplete:!1,isViewerEmbedded:window.parent!==window,url:"",baseUrl:"",externalServices:DefaultExternalServices,_boundEvents:Object.create(null),documentInfo:null,metadata:null,_contentDispositionFilename:null,_contentLength:null,_saveInProgress:!1,_wheelUnusedTicks:0,_idleCallbacks:new Set,async initialize(e){this.preferences=this.externalServices.createPreferences();this.appConfig=e;await this._readPreferences();await this._parseHashParameters();this._forceCssTheme();await this._initializeL10n();this.isViewerEmbedded&&s.AppOptions.get("externalLinkTarget")===r.LinkTarget.NONE&&s.AppOptions.set("externalLinkTarget",r.LinkTarget.TOP);await this._initializeViewerComponents();this.bindEvents();this.bindWindowEvents();const t=e.appContainer||document.documentElement;this.l10n.translate(t).then((()=>{this.eventBus.dispatch("localized",{source:this})}));this._initializedCapability.resolve()},async _readPreferences(){if(!s.AppOptions.get("disablePreferences"))try{s.AppOptions.setAll(await this.preferences.getAll())}catch(e){console.error(`_readPreferences: "${e?.message}".`)}},async _parseHashParameters(){if(!s.AppOptions.get("pdfBugEnabled"))return;const e=document.location.hash.substring(1);if(!e)return;const t=(0,n.parseQueryString)(e),i=[];"disableworker"in t&&"true"===t.disableworker&&i.push(async function loadFakeWorker(){r.GlobalWorkerOptions.workerSrc||(r.GlobalWorkerOptions.workerSrc=s.AppOptions.get("workerSrc"));return(0,r.loadScript)(r.PDFWorker.getWorkerSrc())}());"disablerange"in t&&s.AppOptions.set("disableRange","true"===t.disablerange);"disablestream"in t&&s.AppOptions.set("disableStream","true"===t.disablestream);"disableautofetch"in t&&s.AppOptions.set("disableAutoFetch","true"===t.disableautofetch);"disablefontface"in t&&s.AppOptions.set("disableFontFace","true"===t.disablefontface);"disablehistory"in t&&s.AppOptions.set("disableHistory","true"===t.disablehistory);"verbosity"in t&&s.AppOptions.set("verbosity",0|t.verbosity);if("textlayer"in t)switch(t.textlayer){case"off":s.AppOptions.set("textLayerMode",n.TextLayerMode.DISABLE);break;case"visible":case"shadow":case"hover":this.appConfig.viewerContainer.classList.add("textLayer-"+t.textlayer)}if("pdfbug"in t){s.AppOptions.set("pdfBug",!0);s.AppOptions.set("fontExtraProperties",!0);const e=t.pdfbug.split(",");i.push(function loadAndEnablePDFBug(e){const t=M.appConfig;return(0,r.loadScript)(t.debuggerScriptPath).then((function(){PDFBug.enable(e);PDFBug.init({OPS:r.OPS},t.mainContainer)}))}(e))}"locale"in t&&s.AppOptions.set("locale",t.locale);return 0!==i.length?Promise.all(i).catch((e=>{console.error(`_parseHashParameters: "${e.message}".`)})):void 0},async _initializeL10n(){this.l10n=this.externalServices.createL10n({locale:s.AppOptions.get("locale")});const e=await this.l10n.getDirection();document.getElementsByTagName("html")[0].dir=e},_forceCssTheme(){const e=s.AppOptions.get("viewerCssTheme");if(e!==R.AUTOMATIC&&Object.values(R).includes(e))try{const t=document.styleSheets[0],i=t?.cssRules||[],n="prefers-color-scheme",s=`(${n}: dark)`,r=new RegExp(`^@media \\(${n}: dark\\) {\\n\\s*([\\w\\s-.,:;/\\\\{}()]+)\\n}$`);for(let n=0,a=i.length;n<a;n++){const a=i[n];if(a instanceof CSSMediaRule&&a.media?.[0]===s){if(e===R.LIGHT){t.deleteRule(n);return}const i=r.exec(a.cssText);if(i?.[1]){t.deleteRule(n);t.insertRule(i[1],n)}return}}}catch(e){console.error(`_forceCssTheme: "${e?.message}".`)}},async _initializeViewerComponents(){const e=this.appConfig,t=e.eventBus||new n.EventBus({isInAutomation:this.externalServices.isInAutomation});this.eventBus=t;this.overlayManager=new l.OverlayManager;const i=new o.PDFRenderingQueue;i.onIdle=this._cleanup.bind(this);this.pdfRenderingQueue=i;const r=new m.PDFLinkService({eventBus:t,externalLinkTarget:s.AppOptions.get("externalLinkTarget"),externalLinkRel:s.AppOptions.get("externalLinkRel"),ignoreDestinationZoom:s.AppOptions.get("ignoreDestinationZoom")});this.pdfLinkService=r;const x=this.externalServices.createDownloadManager();this.downloadManager=x;const E=new p.PDFFindController({linkService:r,eventBus:t});this.findController=E;const T=new v.PDFScriptingManager({eventBus:t,sandboxBundleSrc:s.AppOptions.get("sandboxBundleSrc"),scriptingFactory:this.externalServices,docPropertiesLookup:this._scriptingDocProperties.bind(this)});this.pdfScriptingManager=T;const k=e.mainContainer,L=e.viewerContainer;this.pdfViewer=new P.PDFViewer({container:k,viewer:L,eventBus:t,renderingQueue:i,linkService:r,downloadManager:x,findController:E,scriptingManager:T,renderer:s.AppOptions.get("renderer"),l10n:this.l10n,textLayerMode:s.AppOptions.get("textLayerMode"),imageResourcesPath:s.AppOptions.get("imageResourcesPath"),renderInteractiveForms:s.AppOptions.get("renderInteractiveForms"),enablePrintAutoRotate:s.AppOptions.get("enablePrintAutoRotate"),useOnlyCssZoom:s.AppOptions.get("useOnlyCssZoom"),maxCanvasPixels:s.AppOptions.get("maxCanvasPixels"),enableScripting:s.AppOptions.get("enableScripting")});i.setViewer(this.pdfViewer);r.setViewer(this.pdfViewer);T.setViewer(this.pdfViewer);this.pdfThumbnailViewer=new S.PDFThumbnailViewer({container:e.sidebar.thumbnailView,eventBus:t,renderingQueue:i,linkService:r,l10n:this.l10n});i.setThumbnailViewer(this.pdfThumbnailViewer);this.pdfHistory=new g.PDFHistory({linkService:r,eventBus:t});r.setHistory(this.pdfHistory);this.supportsIntegratedFind||(this.findBar=new u.PDFFindBar(e.findBar,t,this.l10n));this.pdfDocumentProperties=new d.PDFDocumentProperties(e.documentProperties,this.overlayManager,t,this.l10n);this.pdfCursorTools=new a.PDFCursorTools({container:k,eventBus:t,cursorToolOnLoad:s.AppOptions.get("cursorToolOnLoad")});this.toolbar=new C.Toolbar(e.toolbar,t,this.l10n);this.secondaryToolbar=new A.SecondaryToolbar(e.secondaryToolbar,k,t);this.supportsFullscreen&&(this.pdfPresentationMode=new b.PDFPresentationMode({container:k,pdfViewer:this.pdfViewer,eventBus:t}));this.passwordPrompt=new c.PasswordPrompt(e.passwordOverlay,this.overlayManager,this.l10n,this.isViewerEmbedded);this.pdfOutlineViewer=new _.PDFOutlineViewer({container:e.sidebar.outlineView,eventBus:t,linkService:r});this.pdfAttachmentViewer=new h.PDFAttachmentViewer({container:e.sidebar.attachmentsView,eventBus:t,downloadManager:x});this.pdfLayerViewer=new f.PDFLayerViewer({container:e.sidebar.layersView,eventBus:t,l10n:this.l10n});this.pdfSidebar=new w.PDFSidebar({elements:e.sidebar,pdfViewer:this.pdfViewer,pdfThumbnailViewer:this.pdfThumbnailViewer,eventBus:t,l10n:this.l10n});this.pdfSidebar.onToggled=this.forceRendering.bind(this);this.pdfSidebarResizer=new y.PDFSidebarResizer(e.sidebarResizer,t,this.l10n)},run(e){this.initialize(e).then(webViewerInitialized)},get initialized(){return this._initializedCapability.settled},get initializedPromise(){return this._initializedCapability.promise},zoomIn(e){if(this.pdfViewer.isInPresentationMode)return;let t=this.pdfViewer.currentScale;do{t=(1.1*t).toFixed(2);t=Math.ceil(10*t)/10;t=Math.min(n.MAX_SCALE,t)}while(--e>0&&t<n.MAX_SCALE);this.pdfViewer.currentScaleValue=t},zoomOut(e){if(this.pdfViewer.isInPresentationMode)return;let t=this.pdfViewer.currentScale;do{t=(t/1.1).toFixed(2);t=Math.floor(10*t)/10;t=Math.max(n.MIN_SCALE,t)}while(--e>0&&t>n.MIN_SCALE);this.pdfViewer.currentScaleValue=t},zoomReset(){this.pdfViewer.isInPresentationMode||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0},get page(){return this.pdfViewer.currentPageNumber},set page(e){this.pdfViewer.currentPageNumber=e},get supportsPrinting(){return V.instance.supportsPrinting},get supportsFullscreen(){const e=document.documentElement;let t=!!(e.requestFullscreen||e.mozRequestFullScreen||e.webkitRequestFullScreen);!1!==document.fullscreenEnabled&&!1!==document.mozFullScreenEnabled&&!1!==document.webkitFullscreenEnabled||(t=!1);return(0,r.shadow)(this,"supportsFullscreen",t)},get supportsIntegratedFind(){return this.externalServices.supportsIntegratedFind},get supportsDocumentFonts(){return this.externalServices.supportsDocumentFonts},get loadingBar(){const e=new n.ProgressBar("#loadingBar");return(0,r.shadow)(this,"loadingBar",e)},get supportedMouseWheelZoomModifierKeys(){return this.externalServices.supportedMouseWheelZoomModifierKeys},initPassiveLoading(){throw new Error("Not implemented: initPassiveLoading")},setTitleUsingUrl(e=""){this.url=e;this.baseUrl=e.split("#")[0];let t=(0,r.getPdfFilenameFromUrl)(e,"");if(!t)try{t=decodeURIComponent((0,r.getFilenameFromUrl)(e))||e}catch(i){t=e}this.setTitle(t)},setTitle(e){this.isViewerEmbedded||(document.title=e)},get _docFilename(){return this._contentDispositionFilename||(0,r.getPdfFilenameFromUrl)(this.url)},_cancelIdleCallbacks(){if(this._idleCallbacks.size){for(const e of this._idleCallbacks)window.cancelIdleCallback(e);this._idleCallbacks.clear()}},async close(){this._unblockDocumentLoadEvent();const{container:e}=this.appConfig.errorWrapper;e.hidden=!0;if(!this.pdfLoadingTask)return;if(this.pdfDocument?.annotationStorage.size>0&&this._annotationStorageModified)try{await this.save({sourceEventType:"save"})}catch(e){}const t=[];t.push(this.pdfLoadingTask.destroy());this.pdfLoadingTask=null;if(this.pdfDocument){this.pdfDocument=null;this.pdfThumbnailViewer.setDocument(null);this.pdfViewer.setDocument(null);this.pdfLinkService.setDocument(null);this.pdfDocumentProperties.setDocument(null)}!function webViewerResetPermissions(){const{appConfig:e}=M;if(!e)return;e.viewerContainer.classList.remove(T)}();this._fellback=!1;this.store=null;this.isInitialViewSet=!1;this.downloadComplete=!1;this.url="";this.baseUrl="";this.documentInfo=null;this.metadata=null;this._contentDispositionFilename=null;this._contentLength=null;this._saveInProgress=!1;this._cancelIdleCallbacks();t.push(this.pdfScriptingManager.destroyPromise);this.pdfSidebar.reset();this.pdfOutlineViewer.reset();this.pdfAttachmentViewer.reset();this.pdfLayerViewer.reset();this.pdfHistory&&this.pdfHistory.reset();this.findBar&&this.findBar.reset();this.toolbar.reset();this.secondaryToolbar.reset();"undefined"!=typeof PDFBug&&PDFBug.cleanup();await Promise.all(t)},async open(e,t){this.pdfLoadingTask&&await this.close();const i=s.AppOptions.getAll(s.OptionKind.WORKER);for(const e in i)r.GlobalWorkerOptions[e]=i[e];const n=Object.create(null);if("string"==typeof e){this.setTitleUsingUrl(e);n.url=e}else if(e&&"byteLength"in e)n.data=e;else if(e.url&&e.originalUrl){this.setTitleUsingUrl(e.originalUrl);n.url=e.url}const a=s.AppOptions.getAll(s.OptionKind.API);for(const e in a){let t=a[e];n[e]=t}if(t)for(const e in t)n[e]=t[e];const o=(0,r.getDocument)(n);this.pdfLoadingTask=o;o.onPassword=(e,t)=>{this.pdfLinkService.externalLinkEnabled=!1;this.passwordPrompt.setUpdateCallback(e,t);this.passwordPrompt.open()};o.onProgress=({loaded:e,total:t})=>{this.progress(e/t)};o.onUnsupportedFeature=this.fallback.bind(this);return o.promise.then((e=>{this.load(e)}),(e=>{if(o!==this.pdfLoadingTask)return;let t="loading_error";e instanceof r.InvalidPDFException?t="invalid_file_error":e instanceof r.MissingPDFException?t="missing_file_error":e instanceof r.UnexpectedResponseException&&(t="unexpected_response_error");return this.l10n.get(t).then((t=>{this._documentError(t,{message:e?.message});throw e}))}))},_ensureDownloadComplete(){if(!this.pdfDocument||!this.downloadComplete)throw new Error("PDF document not downloaded.")},async download({sourceEventType:e="download"}={}){const t=this.baseUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.getData(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch(e){await this.downloadManager.downloadUrl(t,i)}},async save({sourceEventType:e="download"}={}){if(this._saveInProgress)return;this._saveInProgress=!0;await this.pdfScriptingManager.dispatchWillSave();const t=this.baseUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.saveDocument(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch(t){await this.download({sourceEventType:e})}finally{await this.pdfScriptingManager.dispatchDidSave();this._saveInProgress=!1}},downloadOrSave(e){this.pdfDocument?.annotationStorage.size>0?this.save(e):this.download(e)},fallback(e){this.externalServices.reportTelemetry({type:"unsupportedFeature",featureId:e});if(!this._fellback){this._fellback=!0;this.externalServices.fallback({featureId:e,url:this.baseUrl}).then((e=>{e&&this.download({sourceEventType:"download"})}))}},_documentError(e,t=null){this._unblockDocumentLoadEvent();this._otherError(e,t)},_otherError(e,t=null){const i=[this.l10n.get("error_version_info",{version:r.version||"?",build:r.build||"?"})];if(t){i.push(this.l10n.get("error_message",{message:t.message}));if(t.stack)i.push(this.l10n.get("error_stack",{stack:t.stack}));else{t.filename&&i.push(this.l10n.get("error_file",{file:t.filename}));t.lineNumber&&i.push(this.l10n.get("error_line",{line:t.lineNumber}))}}const s=this.appConfig.errorWrapper,a=s.container;a.hidden=!1;s.errorMessage.textContent=e;const o=s.closeButton;o.onclick=function(){a.hidden=!0};const l=s.errorMoreInfo,c=s.moreInfoButton,h=s.lessInfoButton;c.onclick=function(){l.hidden=!1;c.hidden=!0;h.hidden=!1;l.style.height=l.scrollHeight+"px"};h.onclick=function(){l.hidden=!0;c.hidden=!1;h.hidden=!0};c.oncontextmenu=n.noContextMenuHandler;h.oncontextmenu=n.noContextMenuHandler;o.oncontextmenu=n.noContextMenuHandler;c.hidden=!1;h.hidden=!0;Promise.all(i).then((e=>{l.value=e.join("\n")}))},progress(e){if(this.downloadComplete)return;const t=Math.round(100*e);if(t>this.loadingBar.percent||isNaN(t)){this.loadingBar.percent=t;if((this.pdfDocument?this.pdfDocument.loadingParams.disableAutoFetch:s.AppOptions.get("disableAutoFetch"))&&t){if(this.disableAutoFetchLoadingBarTimeout){clearTimeout(this.disableAutoFetchLoadingBarTimeout);this.disableAutoFetchLoadingBarTimeout=null}this.loadingBar.show();this.disableAutoFetchLoadingBarTimeout=setTimeout((()=>{this.loadingBar.hide();this.disableAutoFetchLoadingBarTimeout=null}),5e3)}}},load(e){this.pdfDocument=e;e.getDownloadInfo().then((({length:e})=>{this._contentLength=e;this.downloadComplete=!0;this.loadingBar.hide();l.then((()=>{this.eventBus.dispatch("documentloaded",{source:this})}))}));const t=e.getPageLayout().catch((function(){})),i=e.getPageMode().catch((function(){})),r=e.getOpenAction().catch((function(){}));this.toolbar.setPagesCount(e.numPages,!1);this.secondaryToolbar.setPagesCount(e.numPages);let a;a=null;this.pdfLinkService.setDocument(e,null);this.pdfDocumentProperties.setDocument(e,this.url);const o=this.pdfViewer;o.setDocument(e);const{firstPagePromise:l,onePageRendered:c,pagesPromise:h}=o;this.pdfThumbnailViewer.setDocument(e);const d=(this.store=new E.ViewHistory(e.fingerprint)).getMultiple({page:null,zoom:n.DEFAULT_SCALE_VALUE,scrollLeft:"0",scrollTop:"0",rotation:null,sidebarView:n.SidebarView.UNKNOWN,scrollMode:n.ScrollMode.UNKNOWN,spreadMode:n.SpreadMode.UNKNOWN}).catch((()=>Object.create(null)));l.then((a=>{this.loadingBar.setWidth(this.appConfig.viewerContainer);this._initializeAnnotationStorageCallbacks(e);Promise.all([n.animationStarted,d,t,i,r]).then((async([t,i,r,a,l])=>{const c=s.AppOptions.get("viewOnLoad");this._initializePdfHistory({fingerprint:e.fingerprint,viewOnLoad:c,initialDest:l?.dest});const d=this.initialBookmark,u=s.AppOptions.get("defaultZoomValue");let p=u?`zoom=${u}`:null,g=null,f=s.AppOptions.get("sidebarViewOnLoad"),m=s.AppOptions.get("scrollModeOnLoad"),_=s.AppOptions.get("spreadModeOnLoad");if(i.page&&c!==L){p=`page=${i.page}&zoom=${u||i.zoom},${i.scrollLeft},${i.scrollTop}`;g=parseInt(i.rotation,10);f===n.SidebarView.UNKNOWN&&(f=0|i.sidebarView);m===n.ScrollMode.UNKNOWN&&(m=0|i.scrollMode);_===n.SpreadMode.UNKNOWN&&(_=0|i.spreadMode)}a&&f===n.SidebarView.UNKNOWN&&(f=(0,n.apiPageModeToSidebarView)(a));r&&_===n.SpreadMode.UNKNOWN&&(_=(0,n.apiPageLayoutToSpreadMode)(r));this.setInitialView(p,{rotation:g,sidebarView:f,scrollMode:m,spreadMode:_});this.eventBus.dispatch("documentinit",{source:this});this.isViewerEmbedded||o.focus();this._initializePermissions(e);await Promise.race([h,new Promise((e=>{setTimeout(e,1e4)}))]);if((d||p)&&!o.hasEqualPageSizes){this.initialBookmark=d;o.currentScaleValue=o.currentScaleValue;this.setInitialView(p)}})).catch((()=>{this.setInitialView()})).then((function(){o.update()}))}));h.then((()=>{this._unblockDocumentLoadEvent();this._initializeAutoPrint(e,r)}));c.then((()=>{e.getOutline().then((t=>{e===this.pdfDocument&&this.pdfOutlineViewer.render({outline:t,pdfDocument:e})}));e.getAttachments().then((t=>{e===this.pdfDocument&&this.pdfAttachmentViewer.render({attachments:t})}));o.optionalContentConfigPromise.then((t=>{e===this.pdfDocument&&this.pdfLayerViewer.render({optionalContentConfig:t,pdfDocument:e})}));if("requestIdleCallback"in window){const t=window.requestIdleCallback((()=>{this._collectTelemetry(e);this._idleCallbacks.delete(t)}),{timeout:1e3});this._idleCallbacks.add(t)}}));this._initializePageLabels(e);this._initializeMetadata(e)},async _scriptingDocProperties(e){if(!this.documentInfo){await new Promise((e=>{this.eventBus._on("metadataloaded",e,{once:!0})}));if(e!==this.pdfDocument)return null}if(!this._contentLength){await new Promise((e=>{this.eventBus._on("documentloaded",e,{once:!0})}));if(e!==this.pdfDocument)return null}return{...this.documentInfo,baseURL:this.baseUrl,filesize:this._contentLength,filename:this._docFilename,metadata:this.metadata?.getRaw(),authors:this.metadata?.get("dc:creator"),numPages:this.pagesCount,URL:this.url}},async _collectTelemetry(e){const t=await this.pdfDocument.getMarkInfo();if(e!==this.pdfDocument)return;const i=t?.Marked||!1;this.externalServices.reportTelemetry({type:"tagged",tagged:i})},async _initializeAutoPrint(e,t){const[i,s]=await Promise.all([t,this.pdfViewer.enableScripting?null:e.getJavaScript()]);if(e!==this.pdfDocument)return;let a=!1;"Print"===i?.action&&(a=!0);if(s){s.some((e=>{if(!e)return!1;console.warn("Warning: JavaScript support is not enabled");this.fallback(r.UNSUPPORTED_FEATURES.javaScript);return!0}));if(!a)for(const e of s)if(e&&n.AutoPrintRegExp.test(e)){a=!0;break}}a&&this.triggerPrinting()},async _initializeMetadata(e){const{info:t,metadata:i,contentDispositionFilename:n,contentLength:s}=await e.getMetadata();if(e!==this.pdfDocument)return;this.documentInfo=t;this.metadata=i;this._contentDispositionFilename??(this._contentDispositionFilename=n);this._contentLength??(this._contentLength=s);console.log(`PDF ${e.fingerprint} [${t.PDFFormatVersion} ${(t.Producer||"-").trim()} / ${(t.Creator||"-").trim()}] (PDF.js: ${r.version||"-"})`);let a=t?.Title;const o=i?.get("dc:title");o&&("Untitled"===o||/[\uFFF0-\uFFFF]/g.test(o)||(a=o));a?this.setTitle(`${a} - ${n||document.title}`):n&&this.setTitle(n);if(!t.IsXFAPresent||t.IsAcroFormPresent||e.isPureXfa){if((t.IsAcroFormPresent||t.IsXFAPresent)&&!this.pdfViewer.renderInteractiveForms){console.warn("Warning: Interactive form support is not enabled");this.fallback(r.UNSUPPORTED_FEATURES.forms)}}else{console.warn("Warning: XFA is not enabled");this.fallback(r.UNSUPPORTED_FEATURES.forms)}if(t.IsSignaturesPresent){console.warn("Warning: Digital signatures validation is not supported");this.fallback(r.UNSUPPORTED_FEATURES.signatures)}let l="other";I.includes(t.PDFFormatVersion)&&(l=`v${t.PDFFormatVersion.replace(".","_")}`);let c="other";if(t.Producer){const e=t.Producer.toLowerCase();F.some((function(t){if(!e.includes(t))return!1;c=t.replace(/[ .-]/g,"_");return!0}))}let h=null;t.IsXFAPresent?h="xfa":t.IsAcroFormPresent&&(h="acroform");this.externalServices.reportTelemetry({type:"documentInfo",version:l,generator:c,formType:h});this.eventBus.dispatch("metadataloaded",{source:this})},async _initializePageLabels(e){const t=await e.getPageLabels();if(e!==this.pdfDocument)return;if(!t||s.AppOptions.get("disablePageLabels"))return;const i=t.length;if(i!==this.pagesCount){console.error("The number of Page Labels does not match the number of pages in the document.");return}let n=0;for(;n<i&&t[n]===(n+1).toString();)n++;if(n===i)return;const{pdfViewer:r,pdfThumbnailViewer:a,toolbar:o}=this;r.setPageLabels(t);a.setPageLabels(t);o.setPagesCount(i,!0);o.setPageNumber(r.currentPageNumber,r.currentPageLabel)},_initializePdfHistory({fingerprint:e,viewOnLoad:t,initialDest:i=null}){if(!this.isViewerEmbedded&&!s.AppOptions.get("disableHistory")){this.pdfHistory.initialize({fingerprint:e,resetHistory:t===L,updateUrl:s.AppOptions.get("historyUpdateUrl")});if(this.pdfHistory.initialBookmark){this.initialBookmark=this.pdfHistory.initialBookmark;this.initialRotation=this.pdfHistory.initialRotation}if(i&&!this.initialBookmark&&t===k){this.initialBookmark=JSON.stringify(i);this.pdfHistory.push({explicitDest:i,pageNumber:null})}}},async _initializePermissions(e){const t=await e.getPermissions();e===this.pdfDocument&&t&&s.AppOptions.get("enablePermissions")&&(t.includes(r.PermissionFlag.COPY)||this.appConfig.viewerContainer.classList.add(T))},_initializeAnnotationStorageCallbacks(e){if(e!==this.pdfDocument)return;const{annotationStorage:t}=e;t.onSetModified=()=>{window.addEventListener("beforeunload",beforeUnload);this._annotationStorageModified=!0};t.onResetModified=()=>{window.removeEventListener("beforeunload",beforeUnload);delete this._annotationStorageModified}},setInitialView(e,{rotation:t,sidebarView:i,scrollMode:s,spreadMode:r}={}){const setRotation=e=>{(0,n.isValidRotation)(e)&&(this.pdfViewer.pagesRotation=e)};this.isInitialViewSet=!0;this.pdfSidebar.setInitialView(i);((e,t)=>{(0,n.isValidScrollMode)(e)&&(this.pdfViewer.scrollMode=e);(0,n.isValidSpreadMode)(t)&&(this.pdfViewer.spreadMode=t)})(s,r);if(this.initialBookmark){setRotation(this.initialRotation);delete this.initialRotation;this.pdfLinkService.setHash(this.initialBookmark);this.initialBookmark=null}else if(e){setRotation(t);this.pdfLinkService.setHash(e)}this.toolbar.setPageNumber(this.pdfViewer.currentPageNumber,this.pdfViewer.currentPageLabel);this.secondaryToolbar.setPageNumber(this.pdfViewer.currentPageNumber);this.pdfViewer.currentScaleValue||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},_cleanup(){if(this.pdfDocument){this.pdfViewer.cleanup();this.pdfThumbnailViewer.cleanup();this.pdfDocument.cleanup(this.pdfViewer.renderer===n.RendererType.SVG)}},forceRendering(){this.pdfRenderingQueue.printing=!!this.printService;this.pdfRenderingQueue.isThumbnailViewEnabled=this.pdfSidebar.isThumbnailViewVisible;this.pdfRenderingQueue.renderHighestPriority()},beforePrint(){this.pdfScriptingManager.dispatchWillPrint();if(this.printService)return;if(!this.supportsPrinting){this.l10n.get("printing_not_supported").then((e=>{this._otherError(e)}));return}if(!this.pdfViewer.pageViewsReady){this.l10n.get("printing_not_ready").then((e=>{window.alert(e)}));return}const e=this.pdfViewer.getPagesOverview(),t=this.appConfig.printContainer,i=s.AppOptions.get("printResolution"),n=this.pdfViewer.optionalContentConfigPromise,r=V.instance.createPrintService(this.pdfDocument,e,t,i,n,this.l10n);this.printService=r;this.forceRendering();r.layout();this.externalServices.reportTelemetry({type:"print"})},afterPrint(){this.pdfScriptingManager.dispatchDidPrint();if(this.printService){this.printService.destroy();this.printService=null;this.pdfDocument&&this.pdfDocument.annotationStorage.resetModified()}this.forceRendering()},rotatePages(e){this.pdfViewer.pagesRotation+=e},requestPresentationMode(){this.pdfPresentationMode&&this.pdfPresentationMode.request()},triggerPrinting(){this.supportsPrinting&&window.print()},bindEvents(){const{eventBus:e,_boundEvents:t}=this;t.beforePrint=this.beforePrint.bind(this);t.afterPrint=this.afterPrint.bind(this);e._on("resize",webViewerResize);e._on("hashchange",webViewerHashchange);e._on("beforeprint",t.beforePrint);e._on("afterprint",t.afterPrint);e._on("pagerendered",webViewerPageRendered);e._on("updateviewarea",webViewerUpdateViewarea);e._on("pagechanging",webViewerPageChanging);e._on("scalechanging",webViewerScaleChanging);e._on("rotationchanging",webViewerRotationChanging);e._on("sidebarviewchanged",webViewerSidebarViewChanged);e._on("pagemode",webViewerPageMode);e._on("namedaction",webViewerNamedAction);e._on("presentationmodechanged",webViewerPresentationModeChanged);e._on("presentationmode",webViewerPresentationMode);e._on("print",webViewerPrint);e._on("download",webViewerDownload);e._on("save",webViewerSave);e._on("firstpage",webViewerFirstPage);e._on("lastpage",webViewerLastPage);e._on("nextpage",webViewerNextPage);e._on("previouspage",webViewerPreviousPage);e._on("zoomin",webViewerZoomIn);e._on("zoomout",webViewerZoomOut);e._on("zoomreset",webViewerZoomReset);e._on("pagenumberchanged",webViewerPageNumberChanged);e._on("scalechanged",webViewerScaleChanged);e._on("rotatecw",webViewerRotateCw);e._on("rotateccw",webViewerRotateCcw);e._on("optionalcontentconfig",webViewerOptionalContentConfig);e._on("switchscrollmode",webViewerSwitchScrollMode);e._on("scrollmodechanged",webViewerScrollModeChanged);e._on("switchspreadmode",webViewerSwitchSpreadMode);e._on("spreadmodechanged",webViewerSpreadModeChanged);e._on("documentproperties",webViewerDocumentProperties);e._on("find",webViewerFind);e._on("findfromurlhash",webViewerFindFromUrlHash);e._on("updatefindmatchescount",webViewerUpdateFindMatchesCount);e._on("updatefindcontrolstate",webViewerUpdateFindControlState);if(s.AppOptions.get("pdfBug")){t.reportPageStatsPDFBug=reportPageStatsPDFBug;e._on("pagerendered",t.reportPageStatsPDFBug);e._on("pagechanging",t.reportPageStatsPDFBug)}e._on("fileinputchange",N);e._on("openfile",O)},bindWindowEvents(){const{eventBus:e,_boundEvents:t}=this;t.windowResize=()=>{e.dispatch("resize",{source:window})};t.windowHashChange=()=>{e.dispatch("hashchange",{source:window,hash:document.location.hash.substring(1)})};t.windowBeforePrint=()=>{e.dispatch("beforeprint",{source:window})};t.windowAfterPrint=()=>{e.dispatch("afterprint",{source:window})};t.windowUpdateFromSandbox=t=>{e.dispatch("updatefromsandbox",{source:window,detail:t.detail})};window.addEventListener("visibilitychange",webViewerVisibilityChange);window.addEventListener("wheel",webViewerWheel,{passive:!1});window.addEventListener("touchstart",webViewerTouchStart,{passive:!1});window.addEventListener("click",webViewerClick);window.addEventListener("keydown",webViewerKeyDown);window.addEventListener("resize",t.windowResize);window.addEventListener("hashchange",t.windowHashChange);window.addEventListener("beforeprint",t.windowBeforePrint);window.addEventListener("afterprint",t.windowAfterPrint);window.addEventListener("updatefromsandbox",t.windowUpdateFromSandbox)},unbindEvents(){const{eventBus:e,_boundEvents:t}=this;e._off("resize",webViewerResize);e._off("hashchange",webViewerHashchange);e._off("beforeprint",t.beforePrint);e._off("afterprint",t.afterPrint);e._off("pagerendered",webViewerPageRendered);e._off("updateviewarea",webViewerUpdateViewarea);e._off("pagechanging",webViewerPageChanging);e._off("scalechanging",webViewerScaleChanging);e._off("rotationchanging",webViewerRotationChanging);e._off("sidebarviewchanged",webViewerSidebarViewChanged);e._off("pagemode",webViewerPageMode);e._off("namedaction",webViewerNamedAction);e._off("presentationmodechanged",webViewerPresentationModeChanged);e._off("presentationmode",webViewerPresentationMode);e._off("print",webViewerPrint);e._off("download",webViewerDownload);e._off("save",webViewerSave);e._off("firstpage",webViewerFirstPage);e._off("lastpage",webViewerLastPage);e._off("nextpage",webViewerNextPage);e._off("previouspage",webViewerPreviousPage);e._off("zoomin",webViewerZoomIn);e._off("zoomout",webViewerZoomOut);e._off("zoomreset",webViewerZoomReset);e._off("pagenumberchanged",webViewerPageNumberChanged);e._off("scalechanged",webViewerScaleChanged);e._off("rotatecw",webViewerRotateCw);e._off("rotateccw",webViewerRotateCcw);e._off("optionalcontentconfig",webViewerOptionalContentConfig);e._off("switchscrollmode",webViewerSwitchScrollMode);e._off("scrollmodechanged",webViewerScrollModeChanged);e._off("switchspreadmode",webViewerSwitchSpreadMode);e._off("spreadmodechanged",webViewerSpreadModeChanged);e._off("documentproperties",webViewerDocumentProperties);e._off("find",webViewerFind);e._off("findfromurlhash",webViewerFindFromUrlHash);e._off("updatefindmatchescount",webViewerUpdateFindMatchesCount);e._off("updatefindcontrolstate",webViewerUpdateFindControlState);if(t.reportPageStatsPDFBug){e._off("pagerendered",t.reportPageStatsPDFBug);e._off("pagechanging",t.reportPageStatsPDFBug);t.reportPageStatsPDFBug=null}e._off("fileinputchange",N);e._off("openfile",O);t.beforePrint=null;t.afterPrint=null},unbindWindowEvents(){const{_boundEvents:e}=this;window.removeEventListener("visibilitychange",webViewerVisibilityChange);window.removeEventListener("wheel",webViewerWheel,{passive:!1});window.removeEventListener("touchstart",webViewerTouchStart,{passive:!1});window.removeEventListener("click",webViewerClick);window.removeEventListener("keydown",webViewerKeyDown);window.removeEventListener("resize",e.windowResize);window.removeEventListener("hashchange",e.windowHashChange);window.removeEventListener("beforeprint",e.windowBeforePrint);window.removeEventListener("afterprint",e.windowAfterPrint);window.removeEventListener("updatefromsandbox",e.windowUpdateFromSandbox);e.windowResize=null;e.windowHashChange=null;e.windowBeforePrint=null;e.windowAfterPrint=null;e.windowUpdateFromSandbox=null},accumulateWheelTicks(e){(this._wheelUnusedTicks>0&&e<0||this._wheelUnusedTicks<0&&e>0)&&(this._wheelUnusedTicks=0);this._wheelUnusedTicks+=e;const t=Math.sign(this._wheelUnusedTicks)*Math.floor(Math.abs(this._wheelUnusedTicks));this._wheelUnusedTicks-=t;return t},_unblockDocumentLoadEvent(){document.blockUnblockOnload&&document.blockUnblockOnload(!1);this._unblockDocumentLoadEvent=()=>{}},get scriptingReady(){return this.pdfScriptingManager.ready}};t.PDFViewerApplication=M;let D,N,O;{const e=["null","http://mozilla.github.io","https://mozilla.github.io"];D=function(t){if(void 0!==t)try{const i=new URL(window.location.href).origin||"null";if(e.includes(i))return;const{origin:n,protocol:s}=new URL(t,window.location.href);if(n!==i&&"blob:"!==s)throw new Error("file origin does not match viewer's")}catch(e){M.l10n.get("loading_error").then((t=>{M._documentError(t,{message:e?.message})}));throw e}}}function reportPageStatsPDFBug({pageNumber:e}){if("undefined"==typeof Stats||!Stats.enabled)return;const t=M.pdfViewer.getPageView(e-1)?.pdfPage?.stats;t&&Stats.add(e,t)}function webViewerInitialized(){const e=M.appConfig;let t;const i=document.location.search.substring(1),r=(0,n.parseQueryString)(i);t="file"in r?r.file:s.AppOptions.get("defaultUrl");D(t);const a=document.createElement("input");a.id=e.openFileInputName;a.className="fileInput";a.setAttribute("type","file");a.oncontextmenu=n.noContextMenuHandler;document.body.appendChild(a);if(window.File&&window.FileReader&&window.FileList&&window.Blob)a.value=null;else{e.toolbar.openFile.hidden=!0;e.secondaryToolbar.openFileButton.hidden=!0}a.addEventListener("change",(function(e){const t=e.target.files;t&&0!==t.length&&M.eventBus.dispatch("fileinputchange",{source:this,fileInput:e.target})}));e.mainContainer.addEventListener("dragover",(function(e){e.preventDefault();e.dataTransfer.dropEffect="move"}));e.mainContainer.addEventListener("drop",(function(e){e.preventDefault();const t=e.dataTransfer.files;t&&0!==t.length&&M.eventBus.dispatch("fileinputchange",{source:this,fileInput:e.dataTransfer})}));if(!M.supportsDocumentFonts){s.AppOptions.set("disableFontFace",!0);M.l10n.get("web_fonts_disabled").then((e=>{console.warn(e)}))}if(!M.supportsPrinting){e.toolbar.print.classList.add("hidden");e.secondaryToolbar.printButton.classList.add("hidden")}if(!M.supportsFullscreen){e.toolbar.presentationModeButton.classList.add("hidden");e.secondaryToolbar.presentationModeButton.classList.add("hidden")}M.supportsIntegratedFind&&e.toolbar.viewFind.classList.add("hidden");e.mainContainer.addEventListener("transitionend",(function(e){e.target===this&&M.eventBus.dispatch("resize",{source:this})}),!0);try{!function webViewerOpenFileViaURL(e){e&&M.open(e)}(t)}catch(e){M.l10n.get("loading_error").then((t=>{M._documentError(t,e)}))}}function webViewerPageRendered({pageNumber:e,timestamp:t,error:i}){e===M.page&&M.toolbar.updateLoadingIndicatorState(!1);if(M.pdfSidebar.isThumbnailViewVisible){const t=M.pdfViewer.getPageView(e-1),i=M.pdfThumbnailViewer.getThumbnail(e-1);t&&i&&i.setImage(t)}i&&M.l10n.get("rendering_error").then((e=>{M._otherError(e,i)}));M.externalServices.reportTelemetry({type:"pageInfo",timestamp:t});M.pdfDocument.getStats().then((function(e){M.externalServices.reportTelemetry({type:"documentStats",stats:e})}))}function webViewerPageMode({mode:e}){let t;switch(e){case"thumbs":t=n.SidebarView.THUMBS;break;case"bookmarks":case"outline":t=n.SidebarView.OUTLINE;break;case"attachments":t=n.SidebarView.ATTACHMENTS;break;case"layers":t=n.SidebarView.LAYERS;break;case"none":t=n.SidebarView.NONE;break;default:console.error('Invalid "pagemode" hash parameter: '+e);return}M.pdfSidebar.switchView(t,!0)}function webViewerNamedAction(e){switch(e.action){case"GoToPage":M.appConfig.toolbar.pageNumber.select();break;case"Find":M.supportsIntegratedFind||M.findBar.toggle();break;case"Print":M.triggerPrinting();break;case"SaveAs":webViewerSave()}}function webViewerPresentationModeChanged(e){M.pdfViewer.presentationModeState=e.state}function webViewerSidebarViewChanged(e){M.pdfRenderingQueue.isThumbnailViewEnabled=M.pdfSidebar.isThumbnailViewVisible;const t=M.store;t&&M.isInitialViewSet&&t.set("sidebarView",e.view).catch((function(){}))}function webViewerUpdateViewarea(e){const t=e.location,i=M.store;i&&M.isInitialViewSet&&i.setMultiple({page:t.pageNumber,zoom:t.scale,scrollLeft:t.left,scrollTop:t.top,rotation:t.rotation}).catch((function(){}));const n=M.pdfLinkService.getAnchorUrl(t.pdfOpenParams);M.appConfig.toolbar.viewBookmark.href=n;M.appConfig.secondaryToolbar.viewBookmarkButton.href=n;const s=M.pdfViewer.getPageView(M.page-1)?.renderingState!==o.RenderingStates.FINISHED;M.toolbar.updateLoadingIndicatorState(s)}function webViewerScrollModeChanged(e){const t=M.store;t&&M.isInitialViewSet&&t.set("scrollMode",e.mode).catch((function(){}))}function webViewerSpreadModeChanged(e){const t=M.store;t&&M.isInitialViewSet&&t.set("spreadMode",e.mode).catch((function(){}))}function webViewerResize(){const{pdfDocument:e,pdfViewer:t}=M;if(!e)return;const i=t.currentScaleValue;"auto"!==i&&"page-fit"!==i&&"page-width"!==i||(t.currentScaleValue=i);t.update()}function webViewerHashchange(e){const t=e.hash;t&&(M.isInitialViewSet?M.pdfHistory.popStateInProgress||M.pdfLinkService.setHash(t):M.initialBookmark=t)}N=function(e){if(M.pdfViewer?.isInPresentationMode)return;const t=e.fileInput.files[0];if(x.viewerCompatibilityParams.disableCreateObjectURL){M.setTitleUsingUrl(t.name);const e=new FileReader;e.onload=function webViewerChangeFileReaderOnload(e){const t=e.target.result;M.open(new Uint8Array(t))};e.readAsArrayBuffer(t)}else{let e=URL.createObjectURL(t);t.name&&(e={url:e,originalUrl:t.name});M.open(e)}const i=M.appConfig;i.toolbar.viewBookmark.hidden=!0;i.secondaryToolbar.viewBookmarkButton.hidden=!0;i.toolbar.download.hidden=!0;i.secondaryToolbar.downloadButton.hidden=!0};O=function(e){const t=M.appConfig.openFileInputName;document.getElementById(t).click()};function webViewerPresentationMode(){M.requestPresentationMode()}function webViewerPrint(){M.triggerPrinting()}function webViewerDownload(){M.downloadOrSave({sourceEventType:"download"})}function webViewerSave(){M.downloadOrSave({sourceEventType:"save"})}function webViewerFirstPage(){M.pdfDocument&&(M.page=1)}function webViewerLastPage(){M.pdfDocument&&(M.page=M.pagesCount)}function webViewerNextPage(){M.pdfViewer.nextPage()}function webViewerPreviousPage(){M.pdfViewer.previousPage()}function webViewerZoomIn(){M.zoomIn()}function webViewerZoomOut(){M.zoomOut()}function webViewerZoomReset(){M.zoomReset()}function webViewerPageNumberChanged(e){const t=M.pdfViewer;""!==e.value&&M.pdfLinkService.goToPage(e.value);e.value!==t.currentPageNumber.toString()&&e.value!==t.currentPageLabel&&M.toolbar.setPageNumber(t.currentPageNumber,t.currentPageLabel)}function webViewerScaleChanged(e){M.pdfViewer.currentScaleValue=e.value}function webViewerRotateCw(){M.rotatePages(90)}function webViewerRotateCcw(){M.rotatePages(-90)}function webViewerOptionalContentConfig(e){M.pdfViewer.optionalContentConfigPromise=e.promise}function webViewerSwitchScrollMode(e){M.pdfViewer.scrollMode=e.mode}function webViewerSwitchSpreadMode(e){M.pdfViewer.spreadMode=e.mode}function webViewerDocumentProperties(){M.pdfDocumentProperties.open()}function webViewerFind(e){M.findController.executeCommand("find"+e.type,{query:e.query,phraseSearch:e.phraseSearch,caseSensitive:e.caseSensitive,entireWord:e.entireWord,highlightAll:e.highlightAll,findPrevious:e.findPrevious})}function webViewerFindFromUrlHash(e){M.findController.executeCommand("find",{query:e.query,phraseSearch:e.phraseSearch,caseSensitive:!1,entireWord:!1,highlightAll:!0,findPrevious:!1})}function webViewerUpdateFindMatchesCount({matchesCount:e}){M.supportsIntegratedFind?M.externalServices.updateFindMatchesCount(e):M.findBar.updateResultsCount(e)}function webViewerUpdateFindControlState({state:e,previous:t,matchesCount:i,rawQuery:n}){M.supportsIntegratedFind?M.externalServices.updateFindControlState({result:e,findPrevious:t,matchesCount:i,rawQuery:n}):M.findBar.updateUIState(e,t,i)}function webViewerScaleChanging(e){M.toolbar.setPageScale(e.presetValue,e.scale);M.pdfViewer.update()}function webViewerRotationChanging(e){M.pdfThumbnailViewer.pagesRotation=e.pagesRotation;M.forceRendering();M.pdfViewer.currentPageNumber=e.pageNumber}function webViewerPageChanging({pageNumber:e,pageLabel:t}){M.toolbar.setPageNumber(e,t);M.secondaryToolbar.setPageNumber(e);M.pdfSidebar.isThumbnailViewVisible&&M.pdfThumbnailViewer.scrollThumbnailIntoView(e)}function webViewerVisibilityChange(e){"visible"===document.visibilityState&&setZoomDisabledTimeout()}let B=null;function setZoomDisabledTimeout(){B&&clearTimeout(B);B=setTimeout((function(){B=null}),1e3)}function webViewerWheel(e){const{pdfViewer:t,supportedMouseWheelZoomModifierKeys:i}=M;if(!t.isInPresentationMode)if(e.ctrlKey&&i.ctrlKey||e.metaKey&&i.metaKey){e.preventDefault();if(B||"hidden"===document.visibilityState)return;const i=t.currentScale,s=(0,n.normalizeWheelEventDirection)(e);let r=0;if(e.deltaMode===WheelEvent.DOM_DELTA_LINE||e.deltaMode===WheelEvent.DOM_DELTA_PAGE)r=Math.abs(s)>=1?Math.sign(s):M.accumulateWheelTicks(s);else{const e=30;r=M.accumulateWheelTicks(s/e)}r<0?M.zoomOut(-r):r>0&&M.zoomIn(r);const a=t.currentScale;if(i!==a){const n=a/i-1,s=t.container.getBoundingClientRect(),r=e.clientX-s.left,o=e.clientY-s.top;t.container.scrollLeft+=r*n;t.container.scrollTop+=o*n}}else setZoomDisabledTimeout()}function webViewerTouchStart(e){e.touches.length>1&&e.preventDefault()}function webViewerClick(e){if(!M.secondaryToolbar.isOpen)return;const t=M.appConfig;(M.pdfViewer.containsElement(e.target)||t.toolbar.container.contains(e.target)&&e.target!==t.secondaryToolbar.toggleButton)&&M.secondaryToolbar.close()}function webViewerKeyDown(e){if(M.overlayManager.active)return;let t=!1,i=!1;const s=(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0),r=M.pdfViewer,o=r?.isInPresentationMode;if(1===s||8===s||5===s||12===s)switch(e.keyCode){case 70:if(!M.supportsIntegratedFind&&!e.shiftKey){M.findBar.open();t=!0}break;case 71:if(!M.supportsIntegratedFind){const e=M.findController.state;e&&M.findController.executeCommand("findagain",{query:e.query,phraseSearch:e.phraseSearch,caseSensitive:e.caseSensitive,entireWord:e.entireWord,highlightAll:e.highlightAll,findPrevious:5===s||12===s});t=!0}break;case 61:case 107:case 187:case 171:o||M.zoomIn();t=!0;break;case 173:case 109:case 189:o||M.zoomOut();t=!0;break;case 48:case 96:if(!o){setTimeout((function(){M.zoomReset()}));t=!1}break;case 38:if(o||M.page>1){M.page=1;t=!0;i=!0}break;case 40:if(o||M.page<M.pagesCount){M.page=M.pagesCount;t=!0;i=!0}}const{eventBus:l}=M;if(1===s||8===s)switch(e.keyCode){case 83:l.dispatch("download",{source:window});t=!0;break;case 79:l.dispatch("openfile",{source:window});t=!0}if(3===s||10===s)switch(e.keyCode){case 80:M.requestPresentationMode();t=!0;break;case 71:M.appConfig.toolbar.pageNumber.select();t=!0}if(t){i&&!o&&r.focus();e.preventDefault();return}const c=(0,n.getActiveOrFocusedElement)(),h=c?.tagName.toUpperCase();if("INPUT"!==h&&"TEXTAREA"!==h&&"SELECT"!==h&&!c?.isContentEditable||27===e.keyCode){if(0===s){let n=0,s=!1;switch(e.keyCode){case 38:case 33:r.isVerticalScrollbarEnabled&&(s=!0);n=-1;break;case 8:o||(s=!0);n=-1;break;case 37:r.isHorizontalScrollbarEnabled&&(s=!0);case 75:case 80:n=-1;break;case 27:if(M.secondaryToolbar.isOpen){M.secondaryToolbar.close();t=!0}if(!M.supportsIntegratedFind&&M.findBar.opened){M.findBar.close();t=!0}break;case 40:case 34:r.isVerticalScrollbarEnabled&&(s=!0);n=1;break;case 13:case 32:o||(s=!0);n=1;break;case 39:r.isHorizontalScrollbarEnabled&&(s=!0);case 74:case 78:n=1;break;case 36:if(o||M.page>1){M.page=1;t=!0;i=!0}break;case 35:if(o||M.page<M.pagesCount){M.page=M.pagesCount;t=!0;i=!0}break;case 83:M.pdfCursorTools.switchTool(a.CursorTool.SELECT);break;case 72:M.pdfCursorTools.switchTool(a.CursorTool.HAND);break;case 82:M.rotatePages(90);break;case 115:M.pdfSidebar.toggle()}if(0!==n&&(!s||"page-fit"===r.currentScaleValue)){n>0?r.nextPage():r.previousPage();t=!0}}if(4===s)switch(e.keyCode){case 13:case 32:if(!o&&"page-fit"!==r.currentScaleValue)break;M.page>1&&M.page--;t=!0;break;case 82:M.rotatePages(-90)}t||o||(e.keyCode>=33&&e.keyCode<=40||32===e.keyCode&&"BUTTON"!==h)&&(i=!0);i&&!r.containsElement(c)&&r.focus();t&&e.preventDefault()}}function beforeUnload(e){e.preventDefault();e.returnValue="";return!1}const V={instance:{supportsPrinting:!1,createPrintService(){throw new Error("Not implemented: createPrintService")}}};t.PDFPrintServiceFactory=V},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.apiPageLayoutToSpreadMode=function apiPageLayoutToSpreadMode(e){switch(e){case"SinglePage":case"OneColumn":return s.NONE;case"TwoColumnLeft":case"TwoPageLeft":return s.ODD;case"TwoColumnRight":case"TwoPageRight":return s.EVEN}return s.NONE};t.apiPageModeToSidebarView=function apiPageModeToSidebarView(e){switch(e){case"UseNone":return i.NONE;case"UseThumbs":return i.THUMBS;case"UseOutlines":return i.OUTLINE;case"UseAttachments":return i.ATTACHMENTS;case"UseOC":return i.LAYERS}return i.NONE};t.approximateFraction=function approximateFraction(e){if(Math.floor(e)===e)return[e,1];const t=1/e;if(t>8)return[1,8];if(Math.floor(t)===t)return[1,t];const i=e>1?t:e;let n,s=0,r=1,a=1,o=1;for(;;){const e=s+a,t=r+o;if(t>8)break;if(i<=e/t){a=e;o=t}else{s=e;r=t}}n=i-s/r<a/o-i?i===e?[s,r]:[r,s]:i===e?[a,o]:[o,a];return n};t.backtrackBeforeAllVisibleElements=backtrackBeforeAllVisibleElements;t.binarySearchFirstItem=binarySearchFirstItem;t.getActiveOrFocusedElement=function getActiveOrFocusedElement(){let e=document,t=e.activeElement||e.querySelector(":focus");for(;t?.shadowRoot;){e=t.shadowRoot;t=e.activeElement||e.querySelector(":focus")}return t};t.getOutputScale=function getOutputScale(e){const t=window.devicePixelRatio||1,i=e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.backingStorePixelRatio||1,n=t/i;return{sx:n,sy:n,scaled:1!==n}};t.getPageSizeInches=function getPageSizeInches({view:e,userUnit:t,rotate:i}){const[n,s,r,a]=e,o=i%180!=0,l=(r-n)/72*t,c=(a-s)/72*t;return{width:o?c:l,height:o?l:c}};t.getVisibleElements=function getVisibleElements({scrollEl:e,views:t,sortByVisibility:i=!1,horizontal:n=!1,rtl:s=!1}){const r=e.scrollTop,a=r+e.clientHeight,o=e.scrollLeft,l=o+e.clientWidth;const c=[],h=t.length;let d=binarySearchFirstItem(t,n?function isElementNextAfterViewHorizontally(e){const t=e.div,i=t.offsetLeft+t.clientLeft,n=i+t.clientWidth;return s?i<l:n>o}:function isElementBottomAfterViewTop(e){const t=e.div;return t.offsetTop+t.clientTop+t.clientHeight>r});d>0&&d<h&&!n&&(d=backtrackBeforeAllVisibleElements(d,t,r));let u=n?l:-1;for(let e=d;e<h;e++){const i=t[e],s=i.div,h=s.offsetLeft+s.clientLeft,d=s.offsetTop+s.clientTop,p=s.clientWidth,g=s.clientHeight,f=h+p,m=d+g;if(-1===u)m>=a&&(u=m);else if((n?h:d)>u)break;if(m<=r||d>=a||f<=o||h>=l)continue;const _=Math.max(0,r-d)+Math.max(0,m-a),b=Math.max(0,o-h)+Math.max(0,f-l),v=(p-b)/p,w=(g-_)/g*v*100|0;c.push({id:i.id,x:h,y:d,view:i,percent:w,widthPercent:100*v|0})}const p=c[0],g=c[c.length-1];i&&c.sort((function(e,t){const i=e.percent-t.percent;return Math.abs(i)>.001?-i:e.id-t.id}));return{first:p,last:g,views:c}};t.isPortraitOrientation=function isPortraitOrientation(e){return e.width<=e.height};t.isValidRotation=function isValidRotation(e){return Number.isInteger(e)&&e%90==0};t.isValidScrollMode=function isValidScrollMode(e){return Number.isInteger(e)&&Object.values(n).includes(e)&&e!==n.UNKNOWN};t.isValidSpreadMode=function isValidSpreadMode(e){return Number.isInteger(e)&&Object.values(s).includes(e)&&e!==s.UNKNOWN};t.moveToEndOfArray=function moveToEndOfArray(e,t){const i=[],n=e.length;let s=0;for(let r=0;r<n;++r)if(t(e[r]))i.push(e[r]);else{e[s]=e[r];++s}for(let t=0;s<n;++t,++s)e[s]=i[t]};t.noContextMenuHandler=function noContextMenuHandler(e){e.preventDefault()};t.normalizeWheelEventDelta=function normalizeWheelEventDelta(e){let t=normalizeWheelEventDirection(e);0===e.deltaMode?t/=900:1===e.deltaMode&&(t/=30);return t};t.normalizeWheelEventDirection=normalizeWheelEventDirection;t.parseQueryString=function parseQueryString(e){const t=e.split("&"),i=Object.create(null);for(let e=0,n=t.length;e<n;++e){const n=t[e].split("="),s=n[0].toLowerCase(),r=n.length>1?n[1]:null;i[decodeURIComponent(s)]=decodeURIComponent(r)}return i};t.roundToDivide=function roundToDivide(e,t){const i=e%t;return 0===i?e:Math.round(e-i+t)};t.scrollIntoView=function scrollIntoView(e,t,i=!1){let n=e.offsetParent;if(!n){console.error("offsetParent is not set -- cannot scroll");return}let s=e.offsetTop+e.clientTop,r=e.offsetLeft+e.clientLeft;for(;n.clientHeight===n.scrollHeight&&n.clientWidth===n.scrollWidth||i&&"hidden"===getComputedStyle(n).overflow;){if(n.dataset._scaleY){s/=n.dataset._scaleY;r/=n.dataset._scaleX}s+=n.offsetTop;r+=n.offsetLeft;n=n.offsetParent;if(!n)return}if(t){void 0!==t.top&&(s+=t.top);if(void 0!==t.left){r+=t.left;n.scrollLeft=r}}n.scrollTop=s};t.waitOnEventOrTimeout=function waitOnEventOrTimeout({target:e,name:t,delay:i=0}){return new Promise((function(n,s){if("object"!=typeof e||!t||"string"!=typeof t||!(Number.isInteger(i)&&i>=0))throw new Error("waitOnEventOrTimeout - invalid parameters.");function handler(i){e instanceof EventBus?e._off(t,a):e.removeEventListener(t,a);l&&clearTimeout(l);n(i)}const a=handler.bind(null,r.EVENT);e instanceof EventBus?e._on(t,a):e.addEventListener(t,a);const o=handler.bind(null,r.TIMEOUT),l=setTimeout(o,i)}))};t.watchScroll=function watchScroll(e,t){const debounceScroll=function(s){n||(n=window.requestAnimationFrame((function viewAreaElementScrolled(){n=null;const s=e.scrollLeft,r=i.lastX;s!==r&&(i.right=s>r);i.lastX=s;const a=e.scrollTop,o=i.lastY;a!==o&&(i.down=a>o);i.lastY=a;t(i)})))},i={right:!0,down:!0,lastX:e.scrollLeft,lastY:e.scrollTop,_eventHandler:debounceScroll};let n=null;e.addEventListener("scroll",debounceScroll,!0);return i};t.WaitOnType=t.VERTICAL_PADDING=t.UNKNOWN_SCALE=t.TextLayerMode=t.SpreadMode=t.SidebarView=t.ScrollMode=t.SCROLLBAR_PADDING=t.RendererType=t.ProgressBar=t.PresentationModeState=t.MIN_SCALE=t.MAX_SCALE=t.MAX_AUTO_SCALE=t.EventBus=t.DEFAULT_SCALE_VALUE=t.DEFAULT_SCALE=t.CSS_UNITS=t.AutoPrintRegExp=t.animationStarted=void 0;t.CSS_UNITS=96/72;t.DEFAULT_SCALE_VALUE="auto";t.DEFAULT_SCALE=1;t.MIN_SCALE=.1;t.MAX_SCALE=10;t.UNKNOWN_SCALE=0;t.MAX_AUTO_SCALE=1.25;t.SCROLLBAR_PADDING=40;t.VERTICAL_PADDING=5;t.PresentationModeState={UNKNOWN:0,NORMAL:1,CHANGING:2,FULLSCREEN:3};const i={UNKNOWN:-1,NONE:0,THUMBS:1,OUTLINE:2,ATTACHMENTS:3,LAYERS:4};t.SidebarView=i;t.RendererType={CANVAS:"canvas",SVG:"svg"};t.TextLayerMode={DISABLE:0,ENABLE:1,ENABLE_ENHANCE:2};const n={UNKNOWN:-1,VERTICAL:0,HORIZONTAL:1,WRAPPED:2};t.ScrollMode=n;const s={UNKNOWN:-1,NONE:0,ODD:1,EVEN:2};t.SpreadMode=s;t.AutoPrintRegExp=/\bprint\s*\(/;function binarySearchFirstItem(e,t){let i=0,n=e.length-1;if(n<0||!t(e[n]))return e.length;if(t(e[i]))return i;for(;i<n;){const s=i+n>>1;t(e[s])?n=s:i=s+1}return i}function backtrackBeforeAllVisibleElements(e,t,i){if(e<2)return e;let n=t[e].div,s=n.offsetTop+n.clientTop;if(s>=i){n=t[e-1].div;s=n.offsetTop+n.clientTop}for(let i=e-2;i>=0;--i){n=t[i].div;if(n.offsetTop+n.clientTop+n.clientHeight<=s)break;e=i}return e}function normalizeWheelEventDirection(e){let t=Math.hypot(e.deltaX,e.deltaY);const i=Math.atan2(e.deltaY,e.deltaX);-.25*Math.PI<i&&i<.75*Math.PI&&(t=-t);return t}const r={EVENT:"event",TIMEOUT:"timeout"};t.WaitOnType=r;const a=new Promise((function(e){window.requestAnimationFrame(e)}));t.animationStarted=a;class EventBus{constructor(e){this._listeners=Object.create(null)}on(e,t,i=null){this._on(e,t,{external:!0,once:i?.once})}off(e,t,i=null){this._off(e,t,{external:!0,once:i?.once})}dispatch(e){const t=this._listeners[e];if(!t||0===t.length)return;const i=Array.prototype.slice.call(arguments,1);let n;for(const{listener:s,external:r,once:a}of t.slice(0)){a&&this._off(e,s);r?(n||(n=[])).push(s):s.apply(null,i)}if(n){for(const e of n)e.apply(null,i);n=null}}_on(e,t,i=null){var n;((n=this._listeners)[e]||(n[e]=[])).push({listener:t,external:!0===i?.external,once:!0===i?.once})}_off(e,t,i=null){const n=this._listeners[e];if(n)for(let e=0,i=n.length;e<i;e++)if(n[e].listener===t){n.splice(e,1);return}}}t.EventBus=EventBus;t.ProgressBar=class ProgressBar{constructor(e,{height:t,width:i,units:n}={}){this.visible=!0;this.div=document.querySelector(e+" .progress");this.bar=this.div.parentNode;this.height=t||100;this.width=i||100;this.units=n||"%";this.div.style.height=this.height+this.units;this.percent=0}_updateBar(){if(this._indeterminate){this.div.classList.add("indeterminate");this.div.style.width=this.width+this.units;return}this.div.classList.remove("indeterminate");const e=this.width*this._percent/100;this.div.style.width=e+this.units}get percent(){return this._percent}set percent(e){this._indeterminate=isNaN(e);this._percent=function clamp(e,t,i){return Math.min(Math.max(e,t),i)}(e,0,100);this._updateBar()}setWidth(e){if(!e)return;const t=e.parentNode.offsetWidth-e.offsetWidth;if(t>0){document.documentElement.style.setProperty("--loadingBar-end-offset",`${t}px`)}}hide(){if(this.visible){this.visible=!1;this.bar.classList.add("hidden")}}show(){if(!this.visible){this.visible=!0;this.bar.classList.remove("hidden")}}}},e=>{let t;t="undefined"!=typeof window&&window["pdfjs-dist/build/pdf"]?window["pdfjs-dist/build/pdf"]:require("../build/pdf.js");e.exports=t},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFCursorTools=t.CursorTool=void 0;var n=i(7),s=i(4);const r={SELECT:0,HAND:1,ZOOM:2};t.CursorTool=r;t.PDFCursorTools=class PDFCursorTools{constructor({container:e,eventBus:t,cursorToolOnLoad:i=r.SELECT}){this.container=e;this.eventBus=t;this.active=r.SELECT;this.activeBeforePresentationMode=null;this.handTool=new n.GrabToPan({element:this.container});this._addEventListeners();Promise.resolve().then((()=>{this.switchTool(i)}))}get activeTool(){return this.active}switchTool(e){if(null!==this.activeBeforePresentationMode)return;if(e===this.active)return;const disableActiveTool=()=>{switch(this.active){case r.SELECT:break;case r.HAND:this.handTool.deactivate()}};switch(e){case r.SELECT:disableActiveTool();break;case r.HAND:disableActiveTool();this.handTool.activate();break;case r.ZOOM:default:console.error(`switchTool: "${e}" is an unsupported value.`);return}this.active=e;this._dispatchEvent()}_dispatchEvent(){this.eventBus.dispatch("cursortoolchanged",{source:this,tool:this.active})}_addEventListeners(){this.eventBus._on("switchcursortool",(e=>{this.switchTool(e.tool)}));this.eventBus._on("presentationmodechanged",(e=>{switch(e.state){case s.PresentationModeState.FULLSCREEN:{const e=this.active;this.switchTool(r.SELECT);this.activeBeforePresentationMode=e;break}case s.PresentationModeState.NORMAL:{const e=this.activeBeforePresentationMode;this.activeBeforePresentationMode=null;this.switchTool(e);break}}}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GrabToPan=GrabToPan;function GrabToPan(e){this.element=e.element;this.document=e.element.ownerDocument;"function"==typeof e.ignoreTarget&&(this.ignoreTarget=e.ignoreTarget);this.onActiveChanged=e.onActiveChanged;this.activate=this.activate.bind(this);this.deactivate=this.deactivate.bind(this);this.toggle=this.toggle.bind(this);this._onmousedown=this._onmousedown.bind(this);this._onmousemove=this._onmousemove.bind(this);this._endPan=this._endPan.bind(this);(this.overlay=document.createElement("div")).className="grab-to-pan-grabbing"}GrabToPan.prototype={CSS_CLASS_GRAB:"grab-to-pan-grab",activate:function GrabToPan_activate(){if(!this.active){this.active=!0;this.element.addEventListener("mousedown",this._onmousedown,!0);this.element.classList.add(this.CSS_CLASS_GRAB);this.onActiveChanged&&this.onActiveChanged(!0)}},deactivate:function GrabToPan_deactivate(){if(this.active){this.active=!1;this.element.removeEventListener("mousedown",this._onmousedown,!0);this._endPan();this.element.classList.remove(this.CSS_CLASS_GRAB);this.onActiveChanged&&this.onActiveChanged(!1)}},toggle:function GrabToPan_toggle(){this.active?this.deactivate():this.activate()},ignoreTarget:function GrabToPan_ignoreTarget(e){return e.matches("a[href], a[href] *, input, textarea, button, button *, select, option")},_onmousedown:function GrabToPan__onmousedown(e){if(0!==e.button||this.ignoreTarget(e.target))return;if(e.originalTarget)try{e.originalTarget.tagName}catch(e){return}this.scrollLeftStart=this.element.scrollLeft;this.scrollTopStart=this.element.scrollTop;this.clientXStart=e.clientX;this.clientYStart=e.clientY;this.document.addEventListener("mousemove",this._onmousemove,!0);this.document.addEventListener("mouseup",this._endPan,!0);this.element.addEventListener("scroll",this._endPan,!0);e.preventDefault();e.stopPropagation();const t=document.activeElement;t&&!t.contains(e.target)&&t.blur()},_onmousemove:function GrabToPan__onmousemove(e){this.element.removeEventListener("scroll",this._endPan,!0);if(function isLeftMouseReleased(e){if("buttons"in e)return!(1&e.buttons);const t=window.chrome,i=t&&(t.webstore||t.app),n=/Apple/.test(navigator.vendor)&&/Version\/([6-9]\d*|[1-5]\d+)/.test(navigator.userAgent);if(i||n)return 0===e.which;return!1}(e)){this._endPan();return}const t=e.clientX-this.clientXStart,i=e.clientY-this.clientYStart,n=this.scrollTopStart-i,s=this.scrollLeftStart-t;if(this.element.scrollTo)this.element.scrollTo({top:n,left:s,behavior:"instant"});else{this.element.scrollTop=n;this.element.scrollLeft=s}this.overlay.parentNode||document.body.appendChild(this.overlay)},_endPan:function GrabToPan__endPan(){this.element.removeEventListener("scroll",this._endPan,!0);this.document.removeEventListener("mousemove",this._onmousemove,!0);this.document.removeEventListener("mouseup",this._endPan,!0);this.overlay.remove()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.RenderingStates=t.PDFRenderingQueue=void 0;var n=i(5);const s={INITIAL:0,RUNNING:1,PAUSED:2,FINISHED:3};t.RenderingStates=s;t.PDFRenderingQueue=class PDFRenderingQueue{constructor(){this.pdfViewer=null;this.pdfThumbnailViewer=null;this.onIdle=null;this.highestPriorityPage=null;this.idleTimeout=null;this.printing=!1;this.isThumbnailViewEnabled=!1}setViewer(e){this.pdfViewer=e}setThumbnailViewer(e){this.pdfThumbnailViewer=e}isHighestPriority(e){return this.highestPriorityPage===e.renderingId}renderHighestPriority(e){if(this.idleTimeout){clearTimeout(this.idleTimeout);this.idleTimeout=null}this.pdfViewer.forceRendering(e)||this.pdfThumbnailViewer&&this.isThumbnailViewEnabled&&this.pdfThumbnailViewer.forceRendering()||this.printing||this.onIdle&&(this.idleTimeout=setTimeout(this.onIdle.bind(this),3e4))}getHighestPriority(e,t,i){const n=e.views,s=n.length;if(0===s)return null;for(let e=0;e<s;++e){const t=n[e].view;if(!this.isViewFinished(t))return t}if(i){const i=e.last.id;if(t[i]&&!this.isViewFinished(t[i]))return t[i]}else{const i=e.first.id-2;if(t[i]&&!this.isViewFinished(t[i]))return t[i]}return null}isViewFinished(e){return e.renderingState===s.FINISHED}renderView(e){switch(e.renderingState){case s.FINISHED:return!1;case s.PAUSED:this.highestPriorityPage=e.renderingId;e.resume();break;case s.RUNNING:this.highestPriorityPage=e.renderingId;break;case s.INITIAL:this.highestPriorityPage=e.renderingId;e.draw().finally((()=>{this.renderHighestPriority()})).catch((e=>{e instanceof n.RenderingCancelledException||console.error(`renderView: "${e}"`)}))}return!0}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OverlayManager=void 0;t.OverlayManager=class OverlayManager{constructor(){this._overlays={};this._active=null;this._keyDownBound=this._keyDown.bind(this)}get active(){return this._active}async register(e,t,i=null,n=!1){let s;if(!(e&&t&&(s=t.parentNode)))throw new Error("Not enough parameters.");if(this._overlays[e])throw new Error("The overlay is already registered.");this._overlays[e]={element:t,container:s,callerCloseMethod:i,canForceClose:n}}async unregister(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(this._active===e)throw new Error("The overlay cannot be removed while it is active.");delete this._overlays[e]}async open(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(this._active){if(!this._overlays[e].canForceClose)throw this._active===e?new Error("The overlay is already active."):new Error("Another overlay is currently active.");this._closeThroughCaller()}this._active=e;this._overlays[this._active].element.classList.remove("hidden");this._overlays[this._active].container.classList.remove("hidden");window.addEventListener("keydown",this._keyDownBound)}async close(e){if(!this._overlays[e])throw new Error("The overlay does not exist.");if(!this._active)throw new Error("The overlay is currently not active.");if(this._active!==e)throw new Error("Another overlay is currently active.");this._overlays[this._active].container.classList.add("hidden");this._overlays[this._active].element.classList.add("hidden");this._active=null;window.removeEventListener("keydown",this._keyDownBound)}_keyDown(e){if(this._active&&27===e.keyCode){this._closeThroughCaller();e.preventDefault()}}_closeThroughCaller(){this._overlays[this._active].callerCloseMethod&&this._overlays[this._active].callerCloseMethod();this._active&&this.close(this._active)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PasswordPrompt=void 0;var n=i(5);t.PasswordPrompt=class PasswordPrompt{constructor(e,t,i,n=!1){this.overlayName=e.overlayName;this.container=e.container;this.label=e.label;this.input=e.input;this.submitButton=e.submitButton;this.cancelButton=e.cancelButton;this.overlayManager=t;this.l10n=i;this._isViewerEmbedded=n;this.updateCallback=null;this.reason=null;this.submitButton.addEventListener("click",this.verify.bind(this));this.cancelButton.addEventListener("click",this.close.bind(this));this.input.addEventListener("keydown",(e=>{13===e.keyCode&&this.verify()}));this.overlayManager.register(this.overlayName,this.container,this.close.bind(this),!0)}async open(){await this.overlayManager.open(this.overlayName);const e=this.reason===n.PasswordResponses.INCORRECT_PASSWORD;this._isViewerEmbedded&&!e||this.input.focus();this.label.textContent=await this.l10n.get("password_"+(e?"invalid":"label"))}close(){this.overlayManager.close(this.overlayName).then((()=>{this.input.value=""}))}verify(){const e=this.input.value;if(e?.length>0){this.close();this.updateCallback(e)}}setUpdateCallback(e,t){this.updateCallback=e;this.reason=t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFAttachmentViewer=void 0;var n=i(5),s=i(12);class PDFAttachmentViewer extends s.BaseTreeViewer{constructor(e){super(e);this.downloadManager=e.downloadManager;this.eventBus._on("fileattachmentannotation",this._appendAttachment.bind(this))}reset(e=!1){super.reset();this._attachments=null;e||(this._renderedCapability=(0,n.createPromiseCapability)());this._pendingDispatchEvent&&clearTimeout(this._pendingDispatchEvent);this._pendingDispatchEvent=null}_dispatchEvent(e){this._renderedCapability.resolve();if(this._pendingDispatchEvent){clearTimeout(this._pendingDispatchEvent);this._pendingDispatchEvent=null}0!==e?this.eventBus.dispatch("attachmentsloaded",{source:this,attachmentsCount:e}):this._pendingDispatchEvent=setTimeout((()=>{this.eventBus.dispatch("attachmentsloaded",{source:this,attachmentsCount:0});this._pendingDispatchEvent=null}))}_bindLink(e,{content:t,filename:i}){e.onclick=()=>{this.downloadManager.openOrDownloadData(e,t,i);return!1}}render({attachments:e,keepRenderedCapability:t=!1}){this._attachments&&this.reset(t);this._attachments=e||null;if(!e){this._dispatchEvent(0);return}const i=Object.keys(e).sort((function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())})),s=document.createDocumentFragment();let r=0;for(const t of i){const i=e[t],a=i.content,o=(0,n.getFilenameFromUrl)(i.filename),l=document.createElement("div");l.className="treeItem";const c=document.createElement("a");this._bindLink(c,{content:a,filename:o});c.textContent=this._normalizeTextContent(o);l.appendChild(c);s.appendChild(l);r++}this._finishRendering(s,r)}_appendAttachment({id:e,filename:t,content:i}){const n=this._renderedCapability.promise;n.then((()=>{if(n!==this._renderedCapability.promise)return;let s=this._attachments;if(s){for(const t in s)if(e===t)return}else s=Object.create(null);s[e]={filename:t,content:i};this.render({attachments:s,keepRenderedCapability:!0})}))}}t.PDFAttachmentViewer=PDFAttachmentViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BaseTreeViewer=void 0;var n=i(5);const s="selected";class BaseTreeViewer{constructor(e){if(this.constructor===BaseTreeViewer)throw new Error("Cannot initialize BaseTreeViewer.");this.container=e.container;this.eventBus=e.eventBus;this.reset()}reset(){this._pdfDocument=null;this._lastToggleIsShow=!0;this._currentTreeItem=null;this.container.textContent="";this.container.classList.remove("treeWithDeepNesting")}_dispatchEvent(e){throw new Error("Not implemented: _dispatchEvent")}_bindLink(e,t){throw new Error("Not implemented: _bindLink")}_normalizeTextContent(e){return(0,n.removeNullCharacters)(e)||"–"}_addToggleButton(e,t=!1){const i=document.createElement("div");i.className="treeItemToggler";t&&i.classList.add("treeItemsHidden");i.onclick=t=>{t.stopPropagation();i.classList.toggle("treeItemsHidden");if(t.shiftKey){const t=!i.classList.contains("treeItemsHidden");this._toggleTreeItem(e,t)}};e.insertBefore(i,e.firstChild)}_toggleTreeItem(e,t=!1){this._lastToggleIsShow=t;for(const i of e.querySelectorAll(".treeItemToggler"))i.classList.toggle("treeItemsHidden",!t)}_toggleAllTreeItems(){this._toggleTreeItem(this.container,!this._lastToggleIsShow)}_finishRendering(e,t,i=!1){if(i){this.container.classList.add("treeWithDeepNesting");this._lastToggleIsShow=!e.querySelector(".treeItemsHidden")}this.container.appendChild(e);this._dispatchEvent(t)}render(e){throw new Error("Not implemented: render")}_updateCurrentTreeItem(e=null){if(this._currentTreeItem){this._currentTreeItem.classList.remove(s);this._currentTreeItem=null}if(e){e.classList.add(s);this._currentTreeItem=e}}_scrollToCurrentTreeItem(e){if(!e)return;let t=e.parentNode;for(;t&&t!==this.container;){if(t.classList.contains("treeItem")){t.firstElementChild?.classList.remove("treeItemsHidden")}t=t.parentNode}this._updateCurrentTreeItem(e);this.container.scrollTo(e.offsetLeft,e.offsetTop+-100)}}t.BaseTreeViewer=BaseTreeViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFDocumentProperties=void 0;var n=i(5),s=i(4);const r=["en-us","en-lr","my"],a={"8.5x11":"Letter","8.5x14":"Legal"},o={"297x420":"A3","210x297":"A4"};function getPageName(e,t,i){return i[`${t?e.width:e.height}x${t?e.height:e.width}`]}t.PDFDocumentProperties=class PDFDocumentProperties{constructor({overlayName:e,fields:t,container:i,closeButton:n},s,a,o){this.overlayName=e;this.fields=t;this.container=i;this.overlayManager=s;this.l10n=o;this._reset();n.addEventListener("click",this.close.bind(this));this.overlayManager.register(this.overlayName,this.container,this.close.bind(this));a._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber}));a._on("rotationchanging",(e=>{this._pagesRotation=e.pagesRotation}));this._isNonMetricLocale=!0;o.getLanguage().then((e=>{this._isNonMetricLocale=r.includes(e)}))}async open(){const freezeFieldData=e=>{Object.defineProperty(this,"fieldData",{value:Object.freeze(e),writable:!1,enumerable:!0,configurable:!0})};await Promise.all([this.overlayManager.open(this.overlayName),this._dataAvailableCapability.promise]);const e=this._currentPageNumber,t=this._pagesRotation;if(this.fieldData&&e===this.fieldData._currentPageNumber&&t===this.fieldData._pagesRotation){this._updateUI();return}const{info:i,contentDispositionFilename:r,contentLength:a}=await this.pdfDocument.getMetadata(),[o,l,c,h,d,u]=await Promise.all([r||(0,n.getPdfFilenameFromUrl)(this.url),this._parseFileSize(a),this._parseDate(i.CreationDate),this._parseDate(i.ModDate),this.pdfDocument.getPage(e).then((e=>this._parsePageSize((0,s.getPageSizeInches)(e),t))),this._parseLinearization(i.IsLinearized)]);freezeFieldData({fileName:o,fileSize:l,title:i.Title,author:i.Author,subject:i.Subject,keywords:i.Keywords,creationDate:c,modificationDate:h,creator:i.Creator,producer:i.Producer,version:i.PDFFormatVersion,pageCount:this.pdfDocument.numPages,pageSize:d,linearized:u,_currentPageNumber:e,_pagesRotation:t});this._updateUI();const{length:p}=await this.pdfDocument.getDownloadInfo();if(a===p)return;const g=Object.assign(Object.create(null),this.fieldData);g.fileSize=await this._parseFileSize(p);freezeFieldData(g);this._updateUI()}close(){this.overlayManager.close(this.overlayName)}setDocument(e,t=null){if(this.pdfDocument){this._reset();this._updateUI(!0)}if(e){this.pdfDocument=e;this.url=t;this._dataAvailableCapability.resolve()}}_reset(){this.pdfDocument=null;this.url=null;delete this.fieldData;this._dataAvailableCapability=(0,n.createPromiseCapability)();this._currentPageNumber=1;this._pagesRotation=0}_updateUI(e=!1){if(!e&&this.fieldData){if(this.overlayManager.active===this.overlayName)for(const e in this.fields){const t=this.fieldData[e];this.fields[e].textContent=t||0===t?t:"-"}}else for(const e in this.fields)this.fields[e].textContent="-"}async _parseFileSize(e=0){const t=e/1024,i=t/1024;if(t)return this.l10n.get("document_properties_"+(i>=1?"mb":"kb"),{size_mb:i>=1&&(+i.toPrecision(3)).toLocaleString(),size_kb:i<1&&(+t.toPrecision(3)).toLocaleString(),size_b:e.toLocaleString()})}async _parsePageSize(e,t){if(!e)return;t%180!=0&&(e={width:e.height,height:e.width});const i=(0,s.isPortraitOrientation)(e);let n={width:Math.round(100*e.width)/100,height:Math.round(100*e.height)/100},r={width:Math.round(25.4*e.width*10)/10,height:Math.round(25.4*e.height*10)/10},l=getPageName(n,i,a)||getPageName(r,i,o);if(!(l||Number.isInteger(r.width)&&Number.isInteger(r.height))){const t={width:25.4*e.width,height:25.4*e.height},s={width:Math.round(r.width),height:Math.round(r.height)};if(Math.abs(t.width-s.width)<.1&&Math.abs(t.height-s.height)<.1){l=getPageName(s,i,o);if(l){n={width:Math.round(s.width/25.4*100)/100,height:Math.round(s.height/25.4*100)/100};r=s}}}const[{width:c,height:h},d,u,p]=await Promise.all([this._isNonMetricLocale?n:r,this.l10n.get("document_properties_page_size_unit_"+(this._isNonMetricLocale?"inches":"millimeters")),l&&this.l10n.get(`document_properties_page_size_name_${l.toLowerCase()}`),this.l10n.get("document_properties_page_size_orientation_"+(i?"portrait":"landscape"))]);return this.l10n.get(`document_properties_page_size_dimension_${u?"name_":""}string`,{width:c.toLocaleString(),height:h.toLocaleString(),unit:d,name:u,orientation:p})}async _parseDate(e){const t=n.PDFDateString.toDateObject(e);if(t)return this.l10n.get("document_properties_date_string",{date:t.toLocaleDateString(),time:t.toLocaleTimeString()})}_parseLinearization(e){return this.l10n.get("document_properties_linearized_"+(e?"yes":"no"))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFindBar=void 0;var n=i(15);t.PDFFindBar=class PDFFindBar{constructor(e,t,i){this.opened=!1;this.bar=e.bar;this.toggleButton=e.toggleButton;this.findField=e.findField;this.highlightAll=e.highlightAllCheckbox;this.caseSensitive=e.caseSensitiveCheckbox;this.entireWord=e.entireWordCheckbox;this.findMsg=e.findMsg;this.findResultsCount=e.findResultsCount;this.findPreviousButton=e.findPreviousButton;this.findNextButton=e.findNextButton;this.eventBus=t;this.l10n=i;this.toggleButton.addEventListener("click",(()=>{this.toggle()}));this.findField.addEventListener("input",(()=>{this.dispatchEvent("")}));this.bar.addEventListener("keydown",(e=>{switch(e.keyCode){case 13:e.target===this.findField&&this.dispatchEvent("again",e.shiftKey);break;case 27:this.close()}}));this.findPreviousButton.addEventListener("click",(()=>{this.dispatchEvent("again",!0)}));this.findNextButton.addEventListener("click",(()=>{this.dispatchEvent("again",!1)}));this.highlightAll.addEventListener("click",(()=>{this.dispatchEvent("highlightallchange")}));this.caseSensitive.addEventListener("click",(()=>{this.dispatchEvent("casesensitivitychange")}));this.entireWord.addEventListener("click",(()=>{this.dispatchEvent("entirewordchange")}));this.eventBus._on("resize",this._adjustWidth.bind(this))}reset(){this.updateUIState()}dispatchEvent(e,t){this.eventBus.dispatch("find",{source:this,type:e,query:this.findField.value,phraseSearch:!0,caseSensitive:this.caseSensitive.checked,entireWord:this.entireWord.checked,highlightAll:this.highlightAll.checked,findPrevious:t})}updateUIState(e,t,i){let s=Promise.resolve(""),r="";switch(e){case n.FindState.FOUND:break;case n.FindState.PENDING:r="pending";break;case n.FindState.NOT_FOUND:s=this.l10n.get("find_not_found");r="notFound";break;case n.FindState.WRAPPED:s=this.l10n.get("find_reached_"+(t?"top":"bottom"))}this.findField.setAttribute("data-status",r);s.then((e=>{this.findMsg.textContent=e;this._adjustWidth()}));this.updateResultsCount(i)}updateResultsCount({current:e=0,total:t=0}={}){let i=Promise.resolve("");if(t>0)if(t>1e3){let e="find_match_count_limit";i=this.l10n.get(e,{limit:1e3})}else{let n="find_match_count";i=this.l10n.get(n,{current:e,total:t})}i.then((e=>{this.findResultsCount.textContent=e;this.findResultsCount.classList.toggle("hidden",!t);this._adjustWidth()}))}open(){if(!this.opened){this.opened=!0;this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.bar.classList.remove("hidden")}this.findField.select();this.findField.focus();this._adjustWidth()}close(){if(this.opened){this.opened=!1;this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false");this.bar.classList.add("hidden");this.eventBus.dispatch("findbarclose",{source:this})}}toggle(){this.opened?this.close():this.open()}_adjustWidth(){if(!this.opened)return;this.bar.classList.remove("wrapContainers");this.bar.clientHeight>this.bar.firstElementChild.clientHeight&&this.bar.classList.add("wrapContainers")}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFFindController=t.FindState=void 0;var n=i(5),s=i(16),r=i(4);const a={FOUND:0,NOT_FOUND:1,WRAPPED:2,PENDING:3};t.FindState=a;const o={"‘":"'","’":"'","‚":"'","‛":"'","“":'"',"”":'"',"„":'"',"‟":'"',"¼":"1/4","½":"1/2","¾":"3/4"};let l=null;function normalize(e){if(!l){const e=Object.keys(o).join("");l=new RegExp(`[${e}]`,"g")}let t=null;return[e.replace(l,(function(e,i){const n=o[e],s=n.length-e.length;0!==s&&(t||(t=[])).push([i,s]);return n})),t]}function getOriginalIndex(e,t=null){if(!t)return e;let i=0;for(const[n,s]of t){const t=n+i;if(t>=e)break;if(t+s>e){i+=e-t;break}i+=s}return e-i}t.PDFFindController=class PDFFindController{constructor({linkService:e,eventBus:t}){this._linkService=e;this._eventBus=t;this._reset();t._on("findbarclose",this._onFindBarClose.bind(this))}get highlightMatches(){return this._highlightMatches}get pageMatches(){return this._pageMatches}get pageMatchesLength(){return this._pageMatchesLength}get selected(){return this._selected}get state(){return this._state}setDocument(e){this._pdfDocument&&this._reset();if(e){this._pdfDocument=e;this._firstPageCapability.resolve()}}executeCommand(e,t){if(!t)return;const i=this._pdfDocument;(null===this._state||this._shouldDirtyMatch(e,t))&&(this._dirtyMatch=!0);this._state=t;"findhighlightallchange"!==e&&this._updateUIState(a.PENDING);this._firstPageCapability.promise.then((()=>{if(!this._pdfDocument||i&&this._pdfDocument!==i)return;this._extractText();const t=!this._highlightMatches,n=!!this._findTimeout;if(this._findTimeout){clearTimeout(this._findTimeout);this._findTimeout=null}if("find"===e)this._findTimeout=setTimeout((()=>{this._nextMatch();this._findTimeout=null}),250);else if(this._dirtyMatch)this._nextMatch();else if("findagain"===e){this._nextMatch();t&&this._state.highlightAll&&this._updateAllPages()}else if("findhighlightallchange"===e){n?this._nextMatch():this._highlightMatches=!0;this._updateAllPages()}else this._nextMatch()}))}scrollMatchIntoView({element:e=null,pageIndex:t=-1,matchIndex:i=-1}){if(!this._scrollMatches||!e)return;if(-1===i||i!==this._selected.matchIdx)return;if(-1===t||t!==this._selected.pageIdx)return;this._scrollMatches=!1;const n={top:-50,left:-400};(0,r.scrollIntoView)(e,n,!0)}_reset(){this._highlightMatches=!1;this._scrollMatches=!1;this._pdfDocument=null;this._pageMatches=[];this._pageMatchesLength=[];this._state=null;this._selected={pageIdx:-1,matchIdx:-1};this._offset={pageIdx:null,matchIdx:null,wrapped:!1};this._extractTextPromises=[];this._pageContents=[];this._pageDiffs=[];this._matchesCountTotal=0;this._pagesToSearch=null;this._pendingFindMatches=new Set;this._resumePageIdx=null;this._dirtyMatch=!1;clearTimeout(this._findTimeout);this._findTimeout=null;this._firstPageCapability=(0,n.createPromiseCapability)()}get _query(){if(this._state.query!==this._rawQuery){this._rawQuery=this._state.query;[this._normalizedQuery]=normalize(this._state.query)}return this._normalizedQuery}_shouldDirtyMatch(e,t){if(t.query!==this._state.query)return!0;switch(e){case"findagain":const e=this._selected.pageIdx+1,t=this._linkService;return e>=1&&e<=t.pagesCount&&e!==t.page&&!t.isPageVisible(e);case"findhighlightallchange":return!1}return!0}_prepareMatches(e,t,i){function isSubTerm(t){const i=e[t],n=e[t+1];if(t<e.length-1&&i.match===n.match){i.skipped=!0;return!0}for(let n=t-1;n>=0;n--){const t=e[n];if(!t.skipped){if(t.match+t.matchLength<i.match)break;if(t.match+t.matchLength>=i.match+i.matchLength){i.skipped=!0;return!0}}}return!1}e.sort((function(e,t){return e.match===t.match?e.matchLength-t.matchLength:e.match-t.match}));for(let n=0,s=e.length;n<s;n++)if(!isSubTerm(n)){t.push(e[n].match);i.push(e[n].matchLength)}}_isEntireWord(e,t,i){if(t>0){const i=e.charCodeAt(t),n=e.charCodeAt(t-1);if((0,s.getCharacterType)(i)===(0,s.getCharacterType)(n))return!1}const n=t+i-1;if(n<e.length-1){const t=e.charCodeAt(n),i=e.charCodeAt(n+1);if((0,s.getCharacterType)(t)===(0,s.getCharacterType)(i))return!1}return!0}_calculatePhraseMatch(e,t,i,n,s){const r=[],a=[],o=e.length;let l=-o;for(;;){l=i.indexOf(e,l+o);if(-1===l)break;if(s&&!this._isEntireWord(i,l,o))continue;const t=getOriginalIndex(l,n),c=getOriginalIndex(l+o-1,n)-t+1;r.push(t);a.push(c)}this._pageMatches[t]=r;this._pageMatchesLength[t]=a}_calculateWordMatch(e,t,i,n,s){const r=[],a=e.match(/\S+/g);for(let e=0,t=a.length;e<t;e++){const t=a[e],o=t.length;let l=-o;for(;;){l=i.indexOf(t,l+o);if(-1===l)break;if(s&&!this._isEntireWord(i,l,o))continue;const e=getOriginalIndex(l,n),a=getOriginalIndex(l+o-1,n)-e+1;r.push({match:e,matchLength:a,skipped:!1})}}this._pageMatchesLength[t]=[];this._pageMatches[t]=[];this._prepareMatches(r,this._pageMatches[t],this._pageMatchesLength[t])}_calculateMatch(e){let t=this._pageContents[e];const i=this._pageDiffs[e];let n=this._query;const{caseSensitive:s,entireWord:r,phraseSearch:a}=this._state;if(0===n.length)return;if(!s){t=t.toLowerCase();n=n.toLowerCase()}a?this._calculatePhraseMatch(n,e,t,i,r):this._calculateWordMatch(n,e,t,i,r);this._state.highlightAll&&this._updatePage(e);if(this._resumePageIdx===e){this._resumePageIdx=null;this._nextPageMatch()}const o=this._pageMatches[e].length;if(o>0){this._matchesCountTotal+=o;this._updateUIResultsCount()}}_extractText(){if(this._extractTextPromises.length>0)return;let e=Promise.resolve();for(let t=0,i=this._linkService.pagesCount;t<i;t++){const i=(0,n.createPromiseCapability)();this._extractTextPromises[t]=i.promise;e=e.then((()=>this._pdfDocument.getPage(t+1).then((e=>e.getTextContent({normalizeWhitespace:!0}))).then((e=>{const n=e.items,s=[];for(let e=0,t=n.length;e<t;e++)s.push(n[e].str);[this._pageContents[t],this._pageDiffs[t]]=normalize(s.join(""));i.resolve(t)}),(e=>{console.error(`Unable to get text content for page ${t+1}`,e);this._pageContents[t]="";this._pageDiffs[t]=null;i.resolve(t)}))))}}_updatePage(e){this._scrollMatches&&this._selected.pageIdx===e&&(this._linkService.page=e+1);this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:e})}_updateAllPages(){this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:-1})}_nextMatch(){const e=this._state.findPrevious,t=this._linkService.page-1,i=this._linkService.pagesCount;this._highlightMatches=!0;if(this._dirtyMatch){this._dirtyMatch=!1;this._selected.pageIdx=this._selected.matchIdx=-1;this._offset.pageIdx=t;this._offset.matchIdx=null;this._offset.wrapped=!1;this._resumePageIdx=null;this._pageMatches.length=0;this._pageMatchesLength.length=0;this._matchesCountTotal=0;this._updateAllPages();for(let e=0;e<i;e++)if(!this._pendingFindMatches.has(e)){this._pendingFindMatches.add(e);this._extractTextPromises[e].then((e=>{this._pendingFindMatches.delete(e);this._calculateMatch(e)}))}}if(""===this._query){this._updateUIState(a.FOUND);return}if(this._resumePageIdx)return;const n=this._offset;this._pagesToSearch=i;if(null!==n.matchIdx){const t=this._pageMatches[n.pageIdx].length;if(!e&&n.matchIdx+1<t||e&&n.matchIdx>0){n.matchIdx=e?n.matchIdx-1:n.matchIdx+1;this._updateMatch(!0);return}this._advanceOffsetPage(e)}this._nextPageMatch()}_matchesReady(e){const t=this._offset,i=e.length,n=this._state.findPrevious;if(i){t.matchIdx=n?i-1:0;this._updateMatch(!0);return!0}this._advanceOffsetPage(n);if(t.wrapped){t.matchIdx=null;if(this._pagesToSearch<0){this._updateMatch(!1);return!0}}return!1}_nextPageMatch(){null!==this._resumePageIdx&&console.error("There can only be one pending page.");let e=null;do{const t=this._offset.pageIdx;e=this._pageMatches[t];if(!e){this._resumePageIdx=t;break}}while(!this._matchesReady(e))}_advanceOffsetPage(e){const t=this._offset,i=this._linkService.pagesCount;t.pageIdx=e?t.pageIdx-1:t.pageIdx+1;t.matchIdx=null;this._pagesToSearch--;if(t.pageIdx>=i||t.pageIdx<0){t.pageIdx=e?i-1:0;t.wrapped=!0}}_updateMatch(e=!1){let t=a.NOT_FOUND;const i=this._offset.wrapped;this._offset.wrapped=!1;if(e){const e=this._selected.pageIdx;this._selected.pageIdx=this._offset.pageIdx;this._selected.matchIdx=this._offset.matchIdx;t=i?a.WRAPPED:a.FOUND;-1!==e&&e!==this._selected.pageIdx&&this._updatePage(e)}this._updateUIState(t,this._state.findPrevious);if(-1!==this._selected.pageIdx){this._scrollMatches=!0;this._updatePage(this._selected.pageIdx)}}_onFindBarClose(e){const t=this._pdfDocument;this._firstPageCapability.promise.then((()=>{if(this._pdfDocument&&(!t||this._pdfDocument===t)){if(this._findTimeout){clearTimeout(this._findTimeout);this._findTimeout=null}if(this._resumePageIdx){this._resumePageIdx=null;this._dirtyMatch=!0}this._updateUIState(a.FOUND);this._highlightMatches=!1;this._updateAllPages()}}))}_requestMatchesCount(){const{pageIdx:e,matchIdx:t}=this._selected;let i=0,n=this._matchesCountTotal;if(-1!==t){for(let t=0;t<e;t++)i+=this._pageMatches[t]?.length||0;i+=t+1}(i<1||i>n)&&(i=n=0);return{current:i,total:n}}_updateUIResultsCount(){this._eventBus.dispatch("updatefindmatchescount",{source:this,matchesCount:this._requestMatchesCount()})}_updateUIState(e,t){this._eventBus.dispatch("updatefindcontrolstate",{source:this,state:e,previous:t,matchesCount:this._requestMatchesCount(),rawQuery:this._state?.query??null})}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getCharacterType=function getCharacterType(e){if(function isAlphabeticalScript(e){return e<11904}(e))return function isAscii(e){return 0==(65408&e)}(e)?function isAsciiSpace(e){return 32===e||9===e||13===e||10===e}(e)?i.SPACE:function isAsciiAlpha(e){return e>=97&&e<=122||e>=65&&e<=90}(e)||function isAsciiDigit(e){return e>=48&&e<=57}(e)||95===e?i.ALPHA_LETTER:i.PUNCT:function isThai(e){return 3584==(65408&e)}(e)?i.THAI_LETTER:160===e?i.SPACE:i.ALPHA_LETTER;if(function isHan(e){return e>=13312&&e<=40959||e>=63744&&e<=64255}(e))return i.HAN_LETTER;if(function isKatakana(e){return e>=12448&&e<=12543}(e))return i.KATAKANA_LETTER;if(function isHiragana(e){return e>=12352&&e<=12447}(e))return i.HIRAGANA_LETTER;if(function isHalfwidthKatakana(e){return e>=65376&&e<=65439}(e))return i.HALFWIDTH_KATAKANA_LETTER;return i.ALPHA_LETTER};t.CharacterType=void 0;const i={SPACE:0,ALPHA_LETTER:1,PUNCT:2,HAN_LETTER:3,KATAKANA_LETTER:4,HIRAGANA_LETTER:5,HALFWIDTH_KATAKANA_LETTER:6,THAI_LETTER:7};t.CharacterType=i},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.isDestArraysEqual=isDestArraysEqual;t.isDestHashesEqual=isDestHashesEqual;t.PDFHistory=void 0;var n=i(4);function getCurrentHash(){return document.location.hash}t.PDFHistory=class PDFHistory{constructor({linkService:e,eventBus:t}){this.linkService=e;this.eventBus=t;this._initialized=!1;this._fingerprint="";this.reset();this._boundEvents=null;this._isViewerInPresentationMode=!1;this.eventBus._on("presentationmodechanged",(e=>{this._isViewerInPresentationMode=e.state!==n.PresentationModeState.NORMAL}));this.eventBus._on("pagesinit",(()=>{this._isPagesLoaded=!1;this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount}),{once:!0})}))}initialize({fingerprint:e,resetHistory:t=!1,updateUrl:i=!1}){if(!e||"string"!=typeof e){console.error('PDFHistory.initialize: The "fingerprint" must be a non-empty string.');return}this._initialized&&this.reset();const n=""!==this._fingerprint&&this._fingerprint!==e;this._fingerprint=e;this._updateUrl=!0===i;this._initialized=!0;this._bindEvents();const s=window.history.state;this._popStateInProgress=!1;this._blockHashChange=0;this._currentHash=getCurrentHash();this._numPositionUpdates=0;this._uid=this._maxUid=0;this._destination=null;this._position=null;if(!this._isValidState(s,!0)||t){const{hash:e,page:i,rotation:s}=this._parseCurrentHash(!0);if(!e||n||t){this._pushOrReplaceState(null,!0);return}this._pushOrReplaceState({hash:e,page:i,rotation:s},!0);return}const r=s.destination;this._updateInternalState(r,s.uid,!0);void 0!==r.rotation&&(this._initialRotation=r.rotation);if(r.dest){this._initialBookmark=JSON.stringify(r.dest);this._destination.page=null}else r.hash?this._initialBookmark=r.hash:r.page&&(this._initialBookmark=`page=${r.page}`)}reset(){if(this._initialized){this._pageHide();this._initialized=!1;this._unbindEvents()}if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}this._initialBookmark=null;this._initialRotation=null}push({namedDest:e=null,explicitDest:t,pageNumber:i}){if(!this._initialized)return;if(e&&"string"!=typeof e){console.error(`PDFHistory.push: "${e}" is not a valid namedDest parameter.`);return}if(!Array.isArray(t)){console.error(`PDFHistory.push: "${t}" is not a valid explicitDest parameter.`);return}if(!this._isValidPage(i)&&(null!==i||this._destination)){console.error(`PDFHistory.push: "${i}" is not a valid pageNumber parameter.`);return}const n=e||JSON.stringify(t);if(!n)return;let s=!1;if(this._destination&&(isDestHashesEqual(this._destination.hash,n)||isDestArraysEqual(this._destination.dest,t))){if(this._destination.page)return;s=!0}if(!this._popStateInProgress||s){this._pushOrReplaceState({dest:t,hash:n,page:i,rotation:this.linkService.rotation},s);if(!this._popStateInProgress){this._popStateInProgress=!0;Promise.resolve().then((()=>{this._popStateInProgress=!1}))}}}pushPage(e){if(this._initialized)if(this._isValidPage(e)){if(this._destination?.page!==e&&!this._popStateInProgress){this._pushOrReplaceState({dest:null,hash:`page=${e}`,page:e,rotation:this.linkService.rotation});if(!this._popStateInProgress){this._popStateInProgress=!0;Promise.resolve().then((()=>{this._popStateInProgress=!1}))}}}else console.error(`PDFHistory.pushPage: "${e}" is not a valid page number.`)}pushCurrentPosition(){this._initialized&&!this._popStateInProgress&&this._tryPushCurrentPosition()}back(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid>0&&window.history.back()}forward(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid<this._maxUid&&window.history.forward()}get popStateInProgress(){return this._initialized&&(this._popStateInProgress||this._blockHashChange>0)}get initialBookmark(){return this._initialized?this._initialBookmark:null}get initialRotation(){return this._initialized?this._initialRotation:null}_pushOrReplaceState(e,t=!1){const i=t||!this._destination,n={fingerprint:this._fingerprint,uid:i?this._uid:this._uid+1,destination:e};this._updateInternalState(e,n.uid);let s;if(this._updateUrl&&e?.hash){const t=document.location.href.split("#")[0];t.startsWith("file://")||(s=`${t}#${e.hash}`)}i?window.history.replaceState(n,"",s):window.history.pushState(n,"",s)}_tryPushCurrentPosition(e=!1){if(!this._position)return;let t=this._position;if(e){t=Object.assign(Object.create(null),this._position);t.temporary=!0}if(!this._destination){this._pushOrReplaceState(t);return}if(this._destination.temporary){this._pushOrReplaceState(t,!0);return}if(this._destination.hash===t.hash)return;if(!this._destination.page&&this._numPositionUpdates<=50)return;let i=!1;if(this._destination.page>=t.first&&this._destination.page<=t.page){if(void 0!==this._destination.dest||!this._destination.first)return;i=!0}this._pushOrReplaceState(t,i)}_isValidPage(e){return Number.isInteger(e)&&e>0&&e<=this.linkService.pagesCount}_isValidState(e,t=!1){if(!e)return!1;if(e.fingerprint!==this._fingerprint){if(!t)return!1;{if("string"!=typeof e.fingerprint||e.fingerprint.length!==this._fingerprint.length)return!1;const[t]=performance.getEntriesByType("navigation");if("reload"!==t?.type)return!1}}return!(!Number.isInteger(e.uid)||e.uid<0)&&(null!==e.destination&&"object"==typeof e.destination)}_updateInternalState(e,t,i=!1){if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}i&&e?.temporary&&delete e.temporary;this._destination=e;this._uid=t;this._maxUid=Math.max(this._maxUid,t);this._numPositionUpdates=0}_parseCurrentHash(e=!1){const t=unescape(getCurrentHash()).substring(1),i=(0,n.parseQueryString)(t),s=i.nameddest||"";let r=0|i.page;(!this._isValidPage(r)||e&&s.length>0)&&(r=null);return{hash:t,page:r,rotation:this.linkService.rotation}}_updateViewarea({location:e}){if(this._updateViewareaTimeout){clearTimeout(this._updateViewareaTimeout);this._updateViewareaTimeout=null}this._position={hash:this._isViewerInPresentationMode?`page=${e.pageNumber}`:e.pdfOpenParams.substring(1),page:this.linkService.page,first:e.pageNumber,rotation:e.rotation};if(!this._popStateInProgress){this._isPagesLoaded&&this._destination&&!this._destination.page&&this._numPositionUpdates++;this._updateViewareaTimeout=setTimeout((()=>{this._popStateInProgress||this._tryPushCurrentPosition(!0);this._updateViewareaTimeout=null}),1e3)}}_popState({state:e}){const t=getCurrentHash(),i=this._currentHash!==t;this._currentHash=t;if(!e){this._uid++;const{hash:e,page:t,rotation:i}=this._parseCurrentHash();this._pushOrReplaceState({hash:e,page:t,rotation:i},!0);return}if(!this._isValidState(e))return;this._popStateInProgress=!0;if(i){this._blockHashChange++;(0,n.waitOnEventOrTimeout)({target:window,name:"hashchange",delay:1e3}).then((()=>{this._blockHashChange--}))}const s=e.destination;this._updateInternalState(s,e.uid,!0);(0,n.isValidRotation)(s.rotation)&&(this.linkService.rotation=s.rotation);s.dest?this.linkService.goToDestination(s.dest):s.hash?this.linkService.setHash(s.hash):s.page&&(this.linkService.page=s.page);Promise.resolve().then((()=>{this._popStateInProgress=!1}))}_pageHide(){this._destination&&!this._destination.temporary||this._tryPushCurrentPosition()}_bindEvents(){if(!this._boundEvents){this._boundEvents={updateViewarea:this._updateViewarea.bind(this),popState:this._popState.bind(this),pageHide:this._pageHide.bind(this)};this.eventBus._on("updateviewarea",this._boundEvents.updateViewarea);window.addEventListener("popstate",this._boundEvents.popState);window.addEventListener("pagehide",this._boundEvents.pageHide)}}_unbindEvents(){if(this._boundEvents){this.eventBus._off("updateviewarea",this._boundEvents.updateViewarea);window.removeEventListener("popstate",this._boundEvents.popState);window.removeEventListener("pagehide",this._boundEvents.pageHide);this._boundEvents=null}}};function isDestHashesEqual(e,t){if("string"!=typeof e||"string"!=typeof t)return!1;if(e===t)return!0;const{nameddest:i}=(0,n.parseQueryString)(e);return i===t}function isDestArraysEqual(e,t){function isEntryEqual(e,t){if(typeof e!=typeof t)return!1;if(Array.isArray(e)||Array.isArray(t))return!1;if(null!==e&&"object"==typeof e&&null!==t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!isEntryEqual(e[i],t[i]))return!1;return!0}return e===t||Number.isNaN(e)&&Number.isNaN(t)}if(!Array.isArray(e)||!Array.isArray(t))return!1;if(e.length!==t.length)return!1;for(let i=0,n=e.length;i<n;i++)if(!isEntryEqual(e[i],t[i]))return!1;return!0}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFLayerViewer=void 0;var n=i(12);class PDFLayerViewer extends n.BaseTreeViewer{constructor(e){super(e);this.l10n=e.l10n;this.eventBus._on("resetlayers",this._resetLayers.bind(this));this.eventBus._on("togglelayerstree",this._toggleAllTreeItems.bind(this))}reset(){super.reset();this._optionalContentConfig=null}_dispatchEvent(e){this.eventBus.dispatch("layersloaded",{source:this,layersCount:e})}_bindLink(e,{groupId:t,input:i}){const setVisibility=()=>{this._optionalContentConfig.setVisibility(t,i.checked);this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(this._optionalContentConfig)})};e.onclick=t=>{if(t.target===i){setVisibility();return!0}if(t.target!==e)return!0;i.checked=!i.checked;setVisibility();return!1}}async _setNestedName(e,{name:t=null}){if("string"!=typeof t){e.textContent=await this.l10n.get("additional_layers");e.style.fontStyle="italic"}else e.textContent=this._normalizeTextContent(t)}_addToggleButton(e,{name:t=null}){super._addToggleButton(e,null===t)}_toggleAllTreeItems(){this._optionalContentConfig&&super._toggleAllTreeItems()}render({optionalContentConfig:e,pdfDocument:t}){this._optionalContentConfig&&this.reset();this._optionalContentConfig=e||null;this._pdfDocument=t||null;const i=e?.getOrder();if(!i){this._dispatchEvent(0);return}const n=document.createDocumentFragment(),s=[{parent:n,groups:i}];let r=0,a=!1;for(;s.length>0;){const t=s.shift();for(const i of t.groups){const n=document.createElement("div");n.className="treeItem";const o=document.createElement("a");n.appendChild(o);if("object"==typeof i){a=!0;this._addToggleButton(n,i);this._setNestedName(o,i);const e=document.createElement("div");e.className="treeItems";n.appendChild(e);s.push({parent:e,groups:i.order})}else{const t=e.getGroup(i),n=document.createElement("input");this._bindLink(o,{groupId:i,input:n});n.type="checkbox";n.id=i;n.checked=t.visible;const s=document.createElement("label");s.setAttribute("for",i);s.textContent=this._normalizeTextContent(t.name);o.appendChild(n);o.appendChild(s);r++}t.parent.appendChild(n)}}this._finishRendering(n,r,a)}async _resetLayers(){if(!this._optionalContentConfig)return;const e=await this._pdfDocument.getOptionalContentConfig();this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(e)});this.render({optionalContentConfig:e,pdfDocument:this._pdfDocument})}}t.PDFLayerViewer=PDFLayerViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SimpleLinkService=t.PDFLinkService=void 0;var n=i(4);t.PDFLinkService=class PDFLinkService{constructor({eventBus:e,externalLinkTarget:t=null,externalLinkRel:i=null,externalLinkEnabled:n=!0,ignoreDestinationZoom:s=!1}={}){this.eventBus=e;this.externalLinkTarget=t;this.externalLinkRel=i;this.externalLinkEnabled=n;this._ignoreDestinationZoom=s;this.baseUrl=null;this.pdfDocument=null;this.pdfViewer=null;this.pdfHistory=null;this._pagesRefCache=null}setDocument(e,t=null){this.baseUrl=t;this.pdfDocument=e;this._pagesRefCache=Object.create(null)}setViewer(e){this.pdfViewer=e}setHistory(e){this.pdfHistory=e}get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0}get page(){return this.pdfViewer.currentPageNumber}set page(e){this.pdfViewer.currentPageNumber=e}get rotation(){return this.pdfViewer.pagesRotation}set rotation(e){this.pdfViewer.pagesRotation=e}_goToDestinationHelper(e,t=null,i){const n=i[0];let s;if(n instanceof Object){s=this._cachedPageNumber(n);if(null===s){this.pdfDocument.getPageIndex(n).then((s=>{this.cachePageRef(s+1,n);this._goToDestinationHelper(e,t,i)})).catch((()=>{console.error(`PDFLinkService._goToDestinationHelper: "${n}" is not a valid page reference, for dest="${e}".`)}));return}}else{if(!Number.isInteger(n)){console.error(`PDFLinkService._goToDestinationHelper: "${n}" is not a valid destination reference, for dest="${e}".`);return}s=n+1}if(!s||s<1||s>this.pagesCount)console.error(`PDFLinkService._goToDestinationHelper: "${s}" is not a valid page number, for dest="${e}".`);else{if(this.pdfHistory){this.pdfHistory.pushCurrentPosition();this.pdfHistory.push({namedDest:t,explicitDest:i,pageNumber:s})}this.pdfViewer.scrollPageIntoView({pageNumber:s,destArray:i,ignoreDestinationZoom:this._ignoreDestinationZoom})}}async goToDestination(e){if(!this.pdfDocument)return;let t,i;if("string"==typeof e){t=e;i=await this.pdfDocument.getDestination(e)}else{t=null;i=await e}Array.isArray(i)?this._goToDestinationHelper(e,t,i):console.error(`PDFLinkService.goToDestination: "${i}" is not a valid destination array, for dest="${e}".`)}goToPage(e){if(!this.pdfDocument)return;const t="string"==typeof e&&this.pdfViewer.pageLabelToPageNumber(e)||0|e;if(Number.isInteger(t)&&t>0&&t<=this.pagesCount){if(this.pdfHistory){this.pdfHistory.pushCurrentPosition();this.pdfHistory.pushPage(t)}this.pdfViewer.scrollPageIntoView({pageNumber:t})}else console.error(`PDFLinkService.goToPage: "${e}" is not a valid page.`)}getDestinationHash(e){if("string"==typeof e){if(e.length>0)return this.getAnchorUrl("#"+escape(e))}else if(Array.isArray(e)){const t=JSON.stringify(e);if(t.length>0)return this.getAnchorUrl("#"+escape(t))}return this.getAnchorUrl("")}getAnchorUrl(e){return(this.baseUrl||"")+e}setHash(e){if(!this.pdfDocument)return;let t,i;if(e.includes("=")){const s=(0,n.parseQueryString)(e);"search"in s&&this.eventBus.dispatch("findfromurlhash",{source:this,query:s.search.replace(/"/g,""),phraseSearch:"true"===s.phrase});"page"in s&&(t=0|s.page||1);if("zoom"in s){const e=s.zoom.split(","),t=e[0],n=parseFloat(t);t.includes("Fit")?"Fit"===t||"FitB"===t?i=[null,{name:t}]:"FitH"===t||"FitBH"===t||"FitV"===t||"FitBV"===t?i=[null,{name:t},e.length>1?0|e[1]:null]:"FitR"===t?5!==e.length?console.error('PDFLinkService.setHash: Not enough parameters for "FitR".'):i=[null,{name:t},0|e[1],0|e[2],0|e[3],0|e[4]]:console.error(`PDFLinkService.setHash: "${t}" is not a valid zoom value.`):i=[null,{name:"XYZ"},e.length>1?0|e[1]:null,e.length>2?0|e[2]:null,n?n/100:t]}i?this.pdfViewer.scrollPageIntoView({pageNumber:t||this.page,destArray:i,allowNegativeOffset:!0}):t&&(this.page=t);"pagemode"in s&&this.eventBus.dispatch("pagemode",{source:this,mode:s.pagemode});"nameddest"in s&&this.goToDestination(s.nameddest)}else{i=unescape(e);try{i=JSON.parse(i);Array.isArray(i)||(i=i.toString())}catch(e){}if("string"==typeof i||function isValidExplicitDestination(e){if(!Array.isArray(e))return!1;const t=e.length;if(t<2)return!1;const i=e[0];if(!("object"==typeof i&&Number.isInteger(i.num)&&Number.isInteger(i.gen)||Number.isInteger(i)&&i>=0))return!1;const n=e[1];if("object"!=typeof n||"string"!=typeof n.name)return!1;let s=!0;switch(n.name){case"XYZ":if(5!==t)return!1;break;case"Fit":case"FitB":return 2===t;case"FitH":case"FitBH":case"FitV":case"FitBV":if(3!==t)return!1;break;case"FitR":if(6!==t)return!1;s=!1;break;default:return!1}for(let i=2;i<t;i++){const t=e[i];if(!("number"==typeof t||s&&null===t))return!1}return!0}(i)){this.goToDestination(i);return}console.error(`PDFLinkService.setHash: "${unescape(e)}" is not a valid destination.`)}}executeNamedAction(e){switch(e){case"GoBack":this.pdfHistory&&this.pdfHistory.back();break;case"GoForward":this.pdfHistory&&this.pdfHistory.forward();break;case"NextPage":this.pdfViewer.nextPage();break;case"PrevPage":this.pdfViewer.previousPage();break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1}this.eventBus.dispatch("namedaction",{source:this,action:e})}cachePageRef(e,t){if(!t)return;const i=0===t.gen?`${t.num}R`:`${t.num}R${t.gen}`;this._pagesRefCache[i]=e}_cachedPageNumber(e){const t=0===e.gen?`${e.num}R`:`${e.num}R${e.gen}`;return this._pagesRefCache?.[t]||null}isPageVisible(e){return this.pdfViewer.isPageVisible(e)}isPageCached(e){return this.pdfViewer.isPageCached(e)}};t.SimpleLinkService=class SimpleLinkService{constructor(){this.externalLinkTarget=null;this.externalLinkRel=null;this.externalLinkEnabled=!0;this._ignoreDestinationZoom=!1}get pagesCount(){return 0}get page(){return 0}set page(e){}get rotation(){return 0}set rotation(e){}async goToDestination(e){}goToPage(e){}getDestinationHash(e){return"#"}getAnchorUrl(e){return"#"}setHash(e){}executeNamedAction(e){}cachePageRef(e,t){}isPageVisible(e){return!0}isPageCached(e){return!0}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFOutlineViewer=void 0;var n=i(5),s=i(12),r=i(4);class PDFOutlineViewer extends s.BaseTreeViewer{constructor(e){super(e);this.linkService=e.linkService;this.eventBus._on("toggleoutlinetree",this._toggleAllTreeItems.bind(this));this.eventBus._on("currentoutlineitem",this._currentOutlineItem.bind(this));this.eventBus._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber}));this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount;this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(this._isPagesLoaded)}));this.eventBus._on("sidebarviewchanged",(e=>{this._sidebarView=e.view}))}reset(){super.reset();this._outline=null;this._pageNumberToDestHashCapability=null;this._currentPageNumber=1;this._isPagesLoaded=!1;this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(!1);this._currentOutlineItemCapability=null}_dispatchEvent(e){this._currentOutlineItemCapability=(0,n.createPromiseCapability)();0===e||this._pdfDocument?.loadingParams.disableAutoFetch?this._currentOutlineItemCapability.resolve(!1):this._isPagesLoaded&&this._currentOutlineItemCapability.resolve(!0);this.eventBus.dispatch("outlineloaded",{source:this,outlineCount:e,currentOutlineItemPromise:this._currentOutlineItemCapability.promise})}_bindLink(e,{url:t,newWindow:i,dest:s}){const{linkService:r}=this;if(t)(0,n.addLinkAttributes)(e,{url:t,target:i?n.LinkTarget.BLANK:r.externalLinkTarget,rel:r.externalLinkRel,enabled:r.externalLinkEnabled});else{e.href=r.getDestinationHash(s);e.onclick=e=>{this._updateCurrentTreeItem(e.target.parentNode);s&&r.goToDestination(s);return!1}}}_setStyles(e,{bold:t,italic:i}){t&&(e.style.fontWeight="bold");i&&(e.style.fontStyle="italic")}_addToggleButton(e,{count:t,items:i}){let n=!1;if(t<0){let e=i.length;if(e>0){const t=[...i];for(;t.length>0;){const{count:i,items:n}=t.shift();if(i>0&&n.length>0){e+=n.length;t.push(...n)}}}Math.abs(t)===e&&(n=!0)}super._addToggleButton(e,n)}_toggleAllTreeItems(){this._outline&&super._toggleAllTreeItems()}render({outline:e,pdfDocument:t}){this._outline&&this.reset();this._outline=e||null;this._pdfDocument=t||null;if(!e){this._dispatchEvent(0);return}const i=document.createDocumentFragment(),n=[{parent:i,items:e}];let s=0,r=!1;for(;n.length>0;){const e=n.shift();for(const t of e.items){const i=document.createElement("div");i.className="treeItem";const a=document.createElement("a");this._bindLink(a,t);this._setStyles(a,t);a.textContent=this._normalizeTextContent(t.title);i.appendChild(a);if(t.items.length>0){r=!0;this._addToggleButton(i,t);const e=document.createElement("div");e.className="treeItems";i.appendChild(e);n.push({parent:e,items:t.items})}e.parent.appendChild(i);s++}}this._finishRendering(i,s,r)}async _currentOutlineItem(){if(!this._isPagesLoaded)throw new Error("_currentOutlineItem: All pages have not been loaded.");if(!this._outline||!this._pdfDocument)return;const e=await this._getPageNumberToDestHash(this._pdfDocument);if(e){this._updateCurrentTreeItem(null);if(this._sidebarView===r.SidebarView.OUTLINE)for(let t=this._currentPageNumber;t>0;t--){const i=e.get(t);if(!i)continue;const n=this.container.querySelector(`a[href="${i}"]`);if(n){this._scrollToCurrentTreeItem(n.parentNode);break}}}}async _getPageNumberToDestHash(e){if(this._pageNumberToDestHashCapability)return this._pageNumberToDestHashCapability.promise;this._pageNumberToDestHashCapability=(0,n.createPromiseCapability)();const t=new Map,i=new Map,s=[{nesting:0,items:this._outline}];for(;s.length>0;){const n=s.shift(),r=n.nesting;for(const{dest:a,items:o}of n.items){let n,l;if("string"==typeof a){n=await e.getDestination(a);if(e!==this._pdfDocument)return null}else n=a;if(Array.isArray(n)){const[s]=n;if(s instanceof Object){l=this.linkService._cachedPageNumber(s);if(!l)try{l=await e.getPageIndex(s)+1;if(e!==this._pdfDocument)return null;this.linkService.cachePageRef(l,s)}catch(e){}}else Number.isInteger(s)&&(l=s+1);if(Number.isInteger(l)&&(!t.has(l)||r>i.get(l))){const e=this.linkService.getDestinationHash(a);t.set(l,e);i.set(l,r)}}o.length>0&&s.push({nesting:r+1,items:o})}}this._pageNumberToDestHashCapability.resolve(t.size>0?t:null);return this._pageNumberToDestHashCapability.promise}}t.PDFOutlineViewer=PDFOutlineViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPresentationMode=void 0;var n=i(4);const s="pdfPresentationMode",r="pdfPresentationModeControls",a=Math.PI/6;t.PDFPresentationMode=class PDFPresentationMode{constructor({container:e,pdfViewer:t,eventBus:i}){this.container=e;this.pdfViewer=t;this.eventBus=i;this.active=!1;this.args=null;this.contextMenuOpen=!1;this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0;this.touchSwipeState=null}request(){if(this.switchInProgress||this.active||!this.pdfViewer.pagesCount)return!1;this._addFullscreenChangeListeners();this._setSwitchInProgress();this._notifyStateChange();if(this.container.requestFullscreen)this.container.requestFullscreen();else if(this.container.mozRequestFullScreen)this.container.mozRequestFullScreen();else{if(!this.container.webkitRequestFullscreen)return!1;this.container.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)}this.args={page:this.pdfViewer.currentPageNumber,previousScale:this.pdfViewer.currentScaleValue};return!0}_mouseWheel(e){if(!this.active)return;e.preventDefault();const t=(0,n.normalizeWheelEventDelta)(e),i=Date.now(),s=this.mouseScrollTimeStamp;if(!(i>s&&i-s<50)){(this.mouseScrollDelta>0&&t<0||this.mouseScrollDelta<0&&t>0)&&this._resetMouseScrollState();this.mouseScrollDelta+=t;if(Math.abs(this.mouseScrollDelta)>=.1){const e=this.mouseScrollDelta;this._resetMouseScrollState();(e>0?this.pdfViewer.previousPage():this.pdfViewer.nextPage())&&(this.mouseScrollTimeStamp=i)}}}get isFullscreen(){return!!(document.fullscreenElement||document.mozFullScreen||document.webkitIsFullScreen)}_notifyStateChange(){let e=n.PresentationModeState.NORMAL;this.switchInProgress?e=n.PresentationModeState.CHANGING:this.active&&(e=n.PresentationModeState.FULLSCREEN);this.eventBus.dispatch("presentationmodechanged",{source:this,state:e})}_setSwitchInProgress(){this.switchInProgress&&clearTimeout(this.switchInProgress);this.switchInProgress=setTimeout((()=>{this._removeFullscreenChangeListeners();delete this.switchInProgress;this._notifyStateChange()}),1500)}_resetSwitchInProgress(){if(this.switchInProgress){clearTimeout(this.switchInProgress);delete this.switchInProgress}}_enter(){this.active=!0;this._resetSwitchInProgress();this._notifyStateChange();this.container.classList.add(s);setTimeout((()=>{this.pdfViewer.currentPageNumber=this.args.page;this.pdfViewer.currentScaleValue="page-fit"}),0);this._addWindowListeners();this._showControls();this.contextMenuOpen=!1;window.getSelection().removeAllRanges()}_exit(){const e=this.pdfViewer.currentPageNumber;this.container.classList.remove(s);setTimeout((()=>{this.active=!1;this._removeFullscreenChangeListeners();this._notifyStateChange();this.pdfViewer.currentScaleValue=this.args.previousScale;this.pdfViewer.currentPageNumber=e;this.args=null}),0);this._removeWindowListeners();this._hideControls();this._resetMouseScrollState();this.contextMenuOpen=!1}_mouseDown(e){if(this.contextMenuOpen){this.contextMenuOpen=!1;e.preventDefault()}else if(0===e.button){if(!(e.target.href&&e.target.classList.contains("internalLink"))){e.preventDefault();e.shiftKey?this.pdfViewer.previousPage():this.pdfViewer.nextPage()}}}_contextMenu(){this.contextMenuOpen=!0}_showControls(){this.controlsTimeout?clearTimeout(this.controlsTimeout):this.container.classList.add(r);this.controlsTimeout=setTimeout((()=>{this.container.classList.remove(r);delete this.controlsTimeout}),3e3)}_hideControls(){if(this.controlsTimeout){clearTimeout(this.controlsTimeout);this.container.classList.remove(r);delete this.controlsTimeout}}_resetMouseScrollState(){this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0}_touchSwipe(e){if(this.active)if(e.touches.length>1)this.touchSwipeState=null;else switch(e.type){case"touchstart":this.touchSwipeState={startX:e.touches[0].pageX,startY:e.touches[0].pageY,endX:e.touches[0].pageX,endY:e.touches[0].pageY};break;case"touchmove":if(null===this.touchSwipeState)return;this.touchSwipeState.endX=e.touches[0].pageX;this.touchSwipeState.endY=e.touches[0].pageY;e.preventDefault();break;case"touchend":if(null===this.touchSwipeState)return;let t=0;const i=this.touchSwipeState.endX-this.touchSwipeState.startX,n=this.touchSwipeState.endY-this.touchSwipeState.startY,s=Math.abs(Math.atan2(n,i));Math.abs(i)>50&&(s<=a||s>=Math.PI-a)?t=i:Math.abs(n)>50&&Math.abs(s-Math.PI/2)<=a&&(t=n);t>0?this.pdfViewer.previousPage():t<0&&this.pdfViewer.nextPage()}}_addWindowListeners(){this.showControlsBind=this._showControls.bind(this);this.mouseDownBind=this._mouseDown.bind(this);this.mouseWheelBind=this._mouseWheel.bind(this);this.resetMouseScrollStateBind=this._resetMouseScrollState.bind(this);this.contextMenuBind=this._contextMenu.bind(this);this.touchSwipeBind=this._touchSwipe.bind(this);window.addEventListener("mousemove",this.showControlsBind);window.addEventListener("mousedown",this.mouseDownBind);window.addEventListener("wheel",this.mouseWheelBind,{passive:!1});window.addEventListener("keydown",this.resetMouseScrollStateBind);window.addEventListener("contextmenu",this.contextMenuBind);window.addEventListener("touchstart",this.touchSwipeBind);window.addEventListener("touchmove",this.touchSwipeBind);window.addEventListener("touchend",this.touchSwipeBind)}_removeWindowListeners(){window.removeEventListener("mousemove",this.showControlsBind);window.removeEventListener("mousedown",this.mouseDownBind);window.removeEventListener("wheel",this.mouseWheelBind,{passive:!1});window.removeEventListener("keydown",this.resetMouseScrollStateBind);window.removeEventListener("contextmenu",this.contextMenuBind);window.removeEventListener("touchstart",this.touchSwipeBind);window.removeEventListener("touchmove",this.touchSwipeBind);window.removeEventListener("touchend",this.touchSwipeBind);delete this.showControlsBind;delete this.mouseDownBind;delete this.mouseWheelBind;delete this.resetMouseScrollStateBind;delete this.contextMenuBind;delete this.touchSwipeBind}_fullscreenChange(){this.isFullscreen?this._enter():this._exit()}_addFullscreenChangeListeners(){this.fullscreenChangeBind=this._fullscreenChange.bind(this);window.addEventListener("fullscreenchange",this.fullscreenChangeBind);window.addEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.addEventListener("webkitfullscreenchange",this.fullscreenChangeBind)}_removeFullscreenChangeListeners(){window.removeEventListener("fullscreenchange",this.fullscreenChangeBind);window.removeEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.removeEventListener("webkitfullscreenchange",this.fullscreenChangeBind);delete this.fullscreenChangeBind}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFScriptingManager=void 0;var n=i(5),s=i(4),r=i(8);t.PDFScriptingManager=class PDFScriptingManager{constructor({eventBus:e,sandboxBundleSrc:t=null,scriptingFactory:i=null,docPropertiesLookup:n=null}){this._pdfDocument=null;this._pdfViewer=null;this._closeCapability=null;this._destroyCapability=null;this._scripting=null;this._mouseState=Object.create(null);this._pageEventsReady=!1;this._ready=!1;this._eventBus=e;this._sandboxBundleSrc=t;this._scriptingFactory=i;this._docPropertiesLookup=n}setViewer(e){this._pdfViewer=e}async setDocument(e){this._pdfDocument&&await this._destroyScripting();this._pdfDocument=e;if(!e)return;const[t,i,n]=await Promise.all([e.getFieldObjects(),e.getCalculationOrderIds(),e.getJSActions()]);if(t||n){if(e===this._pdfDocument){this._scripting=this._createScripting();this._internalEvents.set("updatefromsandbox",(e=>{e?.source===window&&this._updateFromSandbox(e.detail)}));this._internalEvents.set("dispatcheventinsandbox",(e=>{this._scripting?.dispatchEventInSandbox(e.detail)}));this._internalEvents.set("pagechanging",(({pageNumber:e,previous:t})=>{if(e!==t){this._dispatchPageClose(t);this._dispatchPageOpen(e)}}));this._internalEvents.set("pagerendered",(({pageNumber:e})=>{this._pageOpenPending.has(e)&&e===this._pdfViewer.currentPageNumber&&this._dispatchPageOpen(e)}));this._internalEvents.set("pagesdestroy",(async e=>{await this._dispatchPageClose(this._pdfViewer.currentPageNumber);await(this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillClose"}));this._closeCapability?.resolve()}));this._domEvents.set("mousedown",(e=>{this._mouseState.isDown=!0}));this._domEvents.set("mouseup",(e=>{this._mouseState.isDown=!1}));for(const[e,t]of this._internalEvents)this._eventBus._on(e,t);for(const[e,t]of this._domEvents)window.addEventListener(e,t);try{const s=await this._getDocProperties();if(e!==this._pdfDocument)return;await this._scripting.createSandbox({objects:t,calculationOrder:i,appInfo:{platform:navigator.platform,language:navigator.language},docInfo:{...s,actions:n}});this._eventBus.dispatch("sandboxcreated",{source:this})}catch(e){console.error(`PDFScriptingManager.setDocument: "${e?.message}".`);await this._destroyScripting();return}await(this._scripting?.dispatchEventInSandbox({id:"doc",name:"Open"}));await this._dispatchPageOpen(this._pdfViewer.currentPageNumber,!0);Promise.resolve().then((()=>{e===this._pdfDocument&&(this._ready=!0)}))}}else await this._destroyScripting()}async dispatchWillSave(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillSave"})}async dispatchDidSave(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"DidSave"})}async dispatchWillPrint(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"WillPrint"})}async dispatchDidPrint(e){return this._scripting?.dispatchEventInSandbox({id:"doc",name:"DidPrint"})}get mouseState(){return this._mouseState}get destroyPromise(){return this._destroyCapability?.promise||null}get ready(){return this._ready}get _internalEvents(){return(0,n.shadow)(this,"_internalEvents",new Map)}get _domEvents(){return(0,n.shadow)(this,"_domEvents",new Map)}get _pageOpenPending(){return(0,n.shadow)(this,"_pageOpenPending",new Set)}get _visitedPages(){return(0,n.shadow)(this,"_visitedPages",new Map)}async _updateFromSandbox(e){const t=this._pdfViewer.isInPresentationMode||this._pdfViewer.isChangingPresentationMode,{id:i,siblings:n,command:r,value:a}=e;if(!i){switch(r){case"clear":console.clear();break;case"error":console.error(a);break;case"layout":this._pdfViewer.spreadMode=(0,s.apiPageLayoutToSpreadMode)(a);break;case"page-num":this._pdfViewer.currentPageNumber=a+1;break;case"print":await this._pdfViewer.pagesPromise;this._eventBus.dispatch("print",{source:this});break;case"println":console.log(a);break;case"zoom":if(t)return;this._pdfViewer.currentScaleValue=a}return}if(t&&e.focus)return;delete e.id;delete e.siblings;const o=n?[i,...n]:[i];for(const t of o){const i=document.getElementById(t);i?i.dispatchEvent(new CustomEvent("updatefromsandbox",{detail:e})):this._pdfDocument?.annotationStorage.setValue(t,e)}}async _dispatchPageOpen(e,t=!1){const i=this._pdfDocument,s=this._visitedPages;if(t){this._closeCapability=(0,n.createPromiseCapability)();this._pageEventsReady=!0}if(!this._pageEventsReady)return;const a=this._pdfViewer.getPageView(e-1);if(a?.renderingState!==r.RenderingStates.FINISHED){this._pageOpenPending.add(e);return}this._pageOpenPending.delete(e);const o=(async()=>{const t=await(s.has(e)?null:a.pdfPage?.getJSActions());i===this._pdfDocument&&await(this._scripting?.dispatchEventInSandbox({id:"page",name:"PageOpen",pageNumber:e,actions:t}))})();s.set(e,o)}async _dispatchPageClose(e){const t=this._pdfDocument,i=this._visitedPages;if(!this._pageEventsReady)return;if(this._pageOpenPending.has(e))return;const n=i.get(e);if(n){i.set(e,null);await n;t===this._pdfDocument&&await(this._scripting?.dispatchEventInSandbox({id:"page",name:"PageClose",pageNumber:e}))}}async _getDocProperties(){if(this._docPropertiesLookup)return this._docPropertiesLookup(this._pdfDocument);throw new Error("_getDocProperties: Unable to lookup properties.")}_createScripting(){this._destroyCapability=(0,n.createPromiseCapability)();if(this._scripting)throw new Error("_createScripting: Scripting already exists.");if(this._scriptingFactory)return this._scriptingFactory.createScripting({sandboxBundleSrc:this._sandboxBundleSrc});throw new Error("_createScripting: Cannot create scripting.")}async _destroyScripting(){if(this._scripting){if(this._closeCapability){await Promise.race([this._closeCapability.promise,new Promise((e=>{setTimeout(e,1e3)}))]).catch((e=>{}));this._closeCapability=null}this._pdfDocument=null;try{await this._scripting.destroySandbox()}catch(e){}for(const[e,t]of this._internalEvents)this._eventBus._off(e,t);this._internalEvents.clear();for(const[e,t]of this._domEvents)window.removeEventListener(e,t);this._domEvents.clear();this._pageOpenPending.clear();this._visitedPages.clear();this._scripting=null;delete this._mouseState.isDown;this._pageEventsReady=!1;this._ready=!1;this._destroyCapability?.resolve()}else{this._pdfDocument=null;this._destroyCapability?.resolve()}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFSidebar=void 0;var n=i(4),s=i(8);const r="pdfSidebarNotification";t.PDFSidebar=class PDFSidebar{constructor({elements:e,pdfViewer:t,pdfThumbnailViewer:i,eventBus:s,l10n:r}){this.isOpen=!1;this.active=n.SidebarView.THUMBS;this.isInitialViewSet=!1;this.onToggled=null;this.pdfViewer=t;this.pdfThumbnailViewer=i;this.outerContainer=e.outerContainer;this.viewerContainer=e.viewerContainer;this.toggleButton=e.toggleButton;this.thumbnailButton=e.thumbnailButton;this.outlineButton=e.outlineButton;this.attachmentsButton=e.attachmentsButton;this.layersButton=e.layersButton;this.thumbnailView=e.thumbnailView;this.outlineView=e.outlineView;this.attachmentsView=e.attachmentsView;this.layersView=e.layersView;this._outlineOptionsContainer=e.outlineOptionsContainer;this._currentOutlineItemButton=e.currentOutlineItemButton;this.eventBus=s;this.l10n=r;this._addEventListeners()}reset(){this.isInitialViewSet=!1;this._hideUINotification(!0);this.switchView(n.SidebarView.THUMBS);this.outlineButton.disabled=!1;this.attachmentsButton.disabled=!1;this.layersButton.disabled=!1;this._currentOutlineItemButton.disabled=!0}get visibleView(){return this.isOpen?this.active:n.SidebarView.NONE}get isThumbnailViewVisible(){return this.isOpen&&this.active===n.SidebarView.THUMBS}get isOutlineViewVisible(){return this.isOpen&&this.active===n.SidebarView.OUTLINE}get isAttachmentsViewVisible(){return this.isOpen&&this.active===n.SidebarView.ATTACHMENTS}get isLayersViewVisible(){return this.isOpen&&this.active===n.SidebarView.LAYERS}setInitialView(e=n.SidebarView.NONE){if(!this.isInitialViewSet){this.isInitialViewSet=!0;e!==n.SidebarView.NONE&&e!==n.SidebarView.UNKNOWN&&this._switchView(e,!0)||this._dispatchEvent()}}switchView(e,t=!1){this._switchView(e,t)}_switchView(e,t=!1){const i=e!==this.active;let s=!1;switch(e){case n.SidebarView.NONE:if(this.isOpen){this.close();return!0}return!1;case n.SidebarView.THUMBS:this.isOpen&&i&&(s=!0);break;case n.SidebarView.OUTLINE:if(this.outlineButton.disabled)return!1;break;case n.SidebarView.ATTACHMENTS:if(this.attachmentsButton.disabled)return!1;break;case n.SidebarView.LAYERS:if(this.layersButton.disabled)return!1;break;default:console.error(`PDFSidebar._switchView: "${e}" is not a valid view.`);return!1}this.active=e;this.thumbnailButton.classList.toggle("toggled",e===n.SidebarView.THUMBS);this.outlineButton.classList.toggle("toggled",e===n.SidebarView.OUTLINE);this.attachmentsButton.classList.toggle("toggled",e===n.SidebarView.ATTACHMENTS);this.layersButton.classList.toggle("toggled",e===n.SidebarView.LAYERS);this.thumbnailView.classList.toggle("hidden",e!==n.SidebarView.THUMBS);this.outlineView.classList.toggle("hidden",e!==n.SidebarView.OUTLINE);this.attachmentsView.classList.toggle("hidden",e!==n.SidebarView.ATTACHMENTS);this.layersView.classList.toggle("hidden",e!==n.SidebarView.LAYERS);this._outlineOptionsContainer.classList.toggle("hidden",e!==n.SidebarView.OUTLINE);if(t&&!this.isOpen){this.open();return!0}if(s){this._updateThumbnailViewer();this._forceRendering()}i&&this._dispatchEvent();return i}open(){if(!this.isOpen){this.isOpen=!0;this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.outerContainer.classList.add("sidebarMoving","sidebarOpen");this.active===n.SidebarView.THUMBS&&this._updateThumbnailViewer();this._forceRendering();this._dispatchEvent();this._hideUINotification()}}close(){if(this.isOpen){this.isOpen=!1;this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false");this.outerContainer.classList.add("sidebarMoving");this.outerContainer.classList.remove("sidebarOpen");this._forceRendering();this._dispatchEvent()}}toggle(){this.isOpen?this.close():this.open()}_dispatchEvent(){this.eventBus.dispatch("sidebarviewchanged",{source:this,view:this.visibleView})}_forceRendering(){if(this.onToggled)this.onToggled();else{this.pdfViewer.forceRendering();this.pdfThumbnailViewer.forceRendering()}}_updateThumbnailViewer(){const{pdfViewer:e,pdfThumbnailViewer:t}=this,i=e.pagesCount;for(let n=0;n<i;n++){const i=e.getPageView(n);if(i?.renderingState===s.RenderingStates.FINISHED){t.getThumbnail(n).setImage(i)}}t.scrollThumbnailIntoView(e.currentPageNumber)}_showUINotification(){this.l10n.get("toggle_sidebar_notification2.title").then((e=>{this.toggleButton.title=e}));this.isOpen||this.toggleButton.classList.add(r)}_hideUINotification(e=!1){(this.isOpen||e)&&this.toggleButton.classList.remove(r);e&&this.l10n.get("toggle_sidebar.title").then((e=>{this.toggleButton.title=e}))}_addEventListeners(){this.viewerContainer.addEventListener("transitionend",(e=>{e.target===this.viewerContainer&&this.outerContainer.classList.remove("sidebarMoving")}));this.toggleButton.addEventListener("click",(()=>{this.toggle()}));this.thumbnailButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.THUMBS)}));this.outlineButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.OUTLINE)}));this.outlineButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("toggleoutlinetree",{source:this})}));this.attachmentsButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.ATTACHMENTS)}));this.layersButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.LAYERS)}));this.layersButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("resetlayers",{source:this})}));this._currentOutlineItemButton.addEventListener("click",(()=>{this.eventBus.dispatch("currentoutlineitem",{source:this})}));const onTreeLoaded=(e,t,i)=>{t.disabled=!e;e?this._showUINotification():this.active===i&&this.switchView(n.SidebarView.THUMBS)};this.eventBus._on("outlineloaded",(e=>{onTreeLoaded(e.outlineCount,this.outlineButton,n.SidebarView.OUTLINE);e.currentOutlineItemPromise.then((e=>{this.isInitialViewSet&&(this._currentOutlineItemButton.disabled=!e)}))}));this.eventBus._on("attachmentsloaded",(e=>{onTreeLoaded(e.attachmentsCount,this.attachmentsButton,n.SidebarView.ATTACHMENTS)}));this.eventBus._on("layersloaded",(e=>{onTreeLoaded(e.layersCount,this.layersButton,n.SidebarView.LAYERS)}));this.eventBus._on("presentationmodechanged",(e=>{e.state===n.PresentationModeState.NORMAL&&this.isThumbnailViewVisible&&this._updateThumbnailViewer()}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFSidebarResizer=void 0;const i="sidebarResizing";t.PDFSidebarResizer=class PDFSidebarResizer{constructor(e,t,i){this.isRTL=!1;this.sidebarOpen=!1;this.doc=document.documentElement;this._width=null;this._outerContainerWidth=null;this._boundEvents=Object.create(null);this.outerContainer=e.outerContainer;this.resizer=e.resizer;this.eventBus=t;i.getDirection().then((e=>{this.isRTL="rtl"===e}));this._addEventListeners()}get outerContainerWidth(){return this._outerContainerWidth||(this._outerContainerWidth=this.outerContainer.clientWidth)}_updateWidth(e=0){const t=Math.floor(this.outerContainerWidth/2);e>t&&(e=t);e<200&&(e=200);if(e===this._width)return!1;this._width=e;this.doc.style.setProperty("--sidebar-width",`${e}px`);return!0}_mouseMove(e){let t=e.clientX;this.isRTL&&(t=this.outerContainerWidth-t);this._updateWidth(t)}_mouseUp(e){this.outerContainer.classList.remove(i);this.eventBus.dispatch("resize",{source:this});const t=this._boundEvents;window.removeEventListener("mousemove",t.mouseMove);window.removeEventListener("mouseup",t.mouseUp)}_addEventListeners(){const e=this._boundEvents;e.mouseMove=this._mouseMove.bind(this);e.mouseUp=this._mouseUp.bind(this);this.resizer.addEventListener("mousedown",(t=>{if(0===t.button){this.outerContainer.classList.add(i);window.addEventListener("mousemove",e.mouseMove);window.addEventListener("mouseup",e.mouseUp)}}));this.eventBus._on("sidebarviewchanged",(e=>{this.sidebarOpen=!!e?.view}));this.eventBus._on("resize",(e=>{if(e?.source!==window)return;this._outerContainerWidth=null;if(!this._width)return;if(!this.sidebarOpen){this._updateWidth(this._width);return}this.outerContainer.classList.add(i);const t=this._updateWidth(this._width);Promise.resolve().then((()=>{this.outerContainer.classList.remove(i);t&&this.eventBus.dispatch("resize",{source:this})}))}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFThumbnailViewer=void 0;var n=i(4),s=i(26),r=i(8);const a="selected";t.PDFThumbnailViewer=class PDFThumbnailViewer{constructor({container:e,eventBus:t,linkService:i,renderingQueue:s,l10n:r}){this.container=e;this.linkService=i;this.renderingQueue=s;this.l10n=r;this.scroll=(0,n.watchScroll)(this.container,this._scrollUpdated.bind(this));this._resetView();t._on("optionalcontentconfigchanged",(()=>{this._setImageDisabled=!0}))}_scrollUpdated(){this.renderingQueue.renderHighestPriority()}getThumbnail(e){return this._thumbnails[e]}_getVisibleThumbs(){return(0,n.getVisibleElements)({scrollEl:this.container,views:this._thumbnails})}scrollThumbnailIntoView(e){if(!this.pdfDocument)return;const t=this._thumbnails[e-1];if(!t){console.error('scrollThumbnailIntoView: Invalid "pageNumber" parameter.');return}if(e!==this._currentPageNumber){this._thumbnails[this._currentPageNumber-1].div.classList.remove(a);t.div.classList.add(a)}const i=this._getVisibleThumbs(),s=i.views.length;if(s>0){const r=i.first.id,a=s>1?i.last.id:r;let o=!1;e<=r||e>=a?o=!0:i.views.some((function(t){if(t.id!==e)return!1;o=t.percent<100;return!0}));o&&(0,n.scrollIntoView)(t.div,{top:-19})}this._currentPageNumber=e}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,n.isValidRotation)(e))throw new Error("Invalid thumbnails rotation angle.");if(this.pdfDocument&&this._pagesRotation!==e){this._pagesRotation=e;for(let t=0,i=this._thumbnails.length;t<i;t++)this._thumbnails[t].update(e)}}cleanup(){for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e]&&this._thumbnails[e].renderingState!==r.RenderingStates.FINISHED&&this._thumbnails[e].reset();s.TempImageFactory.destroyCanvas()}_resetView(){this._thumbnails=[];this._currentPageNumber=1;this._pageLabels=null;this._pagesRotation=0;this._optionalContentConfigPromise=null;this._pagesRequests=new WeakMap;this._setImageDisabled=!1;this.container.textContent=""}setDocument(e){if(this.pdfDocument){this._cancelRendering();this._resetView()}this.pdfDocument=e;if(!e)return;const t=e.getPage(1),i=e.getOptionalContentConfig();t.then((t=>{this._optionalContentConfigPromise=i;const n=e.numPages,r=t.getViewport({scale:1}),checkSetImageDisabled=()=>this._setImageDisabled;for(let e=1;e<=n;++e){const t=new s.PDFThumbnailView({container:this.container,id:e,defaultViewport:r.clone(),optionalContentConfigPromise:i,linkService:this.linkService,renderingQueue:this.renderingQueue,checkSetImageDisabled:checkSetImageDisabled,l10n:this.l10n});this._thumbnails.push(t)}const o=this._thumbnails[0];o&&o.setPdfPage(t);this._thumbnails[this._currentPageNumber-1].div.classList.add(a)})).catch((e=>{console.error("Unable to initialize thumbnail viewer",e)}))}_cancelRendering(){for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e]&&this._thumbnails[e].cancelRendering()}setPageLabels(e){if(this.pdfDocument){if(e)if(Array.isArray(e)&&this.pdfDocument.numPages===e.length)this._pageLabels=e;else{this._pageLabels=null;console.error("PDFThumbnailViewer_setPageLabels: Invalid page labels.")}else this._pageLabels=null;for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e].setPageLabel(this._pageLabels?.[e]??null)}}_ensurePdfPageLoaded(e){if(e.pdfPage)return Promise.resolve(e.pdfPage);if(this._pagesRequests.has(e))return this._pagesRequests.get(e);const t=this.pdfDocument.getPage(e.id).then((t=>{e.pdfPage||e.setPdfPage(t);this._pagesRequests.delete(e);return t})).catch((t=>{console.error("Unable to get page for thumb view",t);this._pagesRequests.delete(e)}));this._pagesRequests.set(e,t);return t}forceRendering(){const e=this._getVisibleThumbs(),t=this.renderingQueue.getHighestPriority(e,this._thumbnails,this.scroll.down);if(t){this._ensurePdfPageLoaded(t).then((()=>{this.renderingQueue.renderView(t)}));return!0}return!1}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TempImageFactory=t.PDFThumbnailView=void 0;var n=i(4),s=i(5),r=i(8);const a=function TempImageFactoryClosure(){let e=null;return{getCanvas(t,i){let n=e;if(!n){n=document.createElement("canvas");e=n}n.width=t;n.height=i;n.mozOpaque=!0;const s=n.getContext("2d",{alpha:!1});s.save();s.fillStyle="rgb(255, 255, 255)";s.fillRect(0,0,t,i);s.restore();return[n,n.getContext("2d")]},destroyCanvas(){const t=e;if(t){t.width=0;t.height=0}e=null}}}();t.TempImageFactory=a;t.PDFThumbnailView=class PDFThumbnailView{constructor({container:e,id:t,defaultViewport:i,optionalContentConfigPromise:n,linkService:s,renderingQueue:a,checkSetImageDisabled:o,l10n:l}){this.id=t;this.renderingId="thumbnail"+t;this.pageLabel=null;this.pdfPage=null;this.rotation=0;this.viewport=i;this.pdfPageRotate=i.rotation;this._optionalContentConfigPromise=n||null;this.linkService=s;this.renderingQueue=a;this.renderTask=null;this.renderingState=r.RenderingStates.INITIAL;this.resume=null;this._checkSetImageDisabled=o||function(){return!1};const c=this.viewport.width,h=c/this.viewport.height;this.canvasWidth=98;this.canvasHeight=this.canvasWidth/h|0;this.scale=this.canvasWidth/c;this.l10n=l;const d=document.createElement("a");d.href=s.getAnchorUrl("#page="+t);this._thumbPageTitle.then((e=>{d.title=e}));d.onclick=function(){s.goToPage(t);return!1};this.anchor=d;const u=document.createElement("div");u.className="thumbnail";u.setAttribute("data-page-number",this.id);this.div=u;const p=document.createElement("div");p.className="thumbnailSelectionRing";p.style.width=this.canvasWidth+2+"px";p.style.height=this.canvasHeight+2+"px";this.ring=p;u.appendChild(p);d.appendChild(u);e.appendChild(d)}setPdfPage(e){this.pdfPage=e;this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:1,rotation:t});this.reset()}reset(){this.cancelRendering();this.renderingState=r.RenderingStates.INITIAL;const e=this.viewport.width,t=e/this.viewport.height;this.canvasHeight=this.canvasWidth/t|0;this.scale=this.canvasWidth/e;this.div.removeAttribute("data-loaded");const i=this.ring;i.textContent="";i.style.width=this.canvasWidth+2+"px";i.style.height=this.canvasHeight+2+"px";if(this.canvas){this.canvas.width=0;this.canvas.height=0;delete this.canvas}if(this.image){this.image.removeAttribute("src");delete this.image}}update(e){void 0!==e&&(this.rotation=e);const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=this.viewport.clone({scale:1,rotation:t});this.reset()}cancelRendering(){if(this.renderTask){this.renderTask.cancel();this.renderTask=null}this.resume=null}_getPageDrawContext(e=1){const t=document.createElement("canvas");t.mozOpaque=!0;const i=t.getContext("2d",{alpha:!1}),s=(0,n.getOutputScale)(i);t.width=e*this.canvasWidth*s.sx|0;t.height=e*this.canvasHeight*s.sy|0;return{ctx:i,canvas:t,transform:s.scaled?[s.sx,0,0,s.sy,0,0]:null}}_convertCanvasToImage(e){if(this.renderingState!==r.RenderingStates.FINISHED)throw new Error("_convertCanvasToImage: Rendering has not finished.");const t=this._reduceImage(e),i=document.createElement("img");i.className="thumbnailImage";this._thumbPageCanvas.then((e=>{i.setAttribute("aria-label",e)}));i.style.width=this.canvasWidth+"px";i.style.height=this.canvasHeight+"px";i.src=t.toDataURL();this.image=i;this.div.setAttribute("data-loaded",!0);this.ring.appendChild(i);t.width=0;t.height=0}draw(){if(this.renderingState!==r.RenderingStates.INITIAL){console.error("Must be in new state before drawing");return Promise.resolve(void 0)}const{pdfPage:e}=this;if(!e){this.renderingState=r.RenderingStates.FINISHED;return Promise.reject(new Error("pdfPage is not loaded"))}this.renderingState=r.RenderingStates.RUNNING;const finishRenderTask=async(e=null)=>{o===this.renderTask&&(this.renderTask=null);if(!(e instanceof s.RenderingCancelledException)){this.renderingState=r.RenderingStates.FINISHED;this._convertCanvasToImage(i);if(e)throw e}},{ctx:t,canvas:i,transform:n}=this._getPageDrawContext(2),a={canvasContext:t,transform:n,viewport:this.viewport.clone({scale:2*this.scale}),optionalContentConfigPromise:this._optionalContentConfigPromise},o=this.renderTask=e.render(a);o.onContinue=e=>{if(this.renderingQueue.isHighestPriority(this))e();else{this.renderingState=r.RenderingStates.PAUSED;this.resume=()=>{this.renderingState=r.RenderingStates.RUNNING;e()}}};const l=o.promise.then((function(){return finishRenderTask(null)}),(function(e){return finishRenderTask(e)}));l.finally((()=>{i.width=0;i.height=0;this.linkService.isPageCached(this.id)||this.pdfPage?.cleanup()}));return l}setImage(e){if(this._checkSetImageDisabled())return;if(this.renderingState!==r.RenderingStates.INITIAL)return;const{canvas:t,pdfPage:i}=e;if(t){this.pdfPage||this.setPdfPage(i);this.renderingState=r.RenderingStates.FINISHED;this._convertCanvasToImage(t)}}_reduceImage(e){const{ctx:t,canvas:i}=this._getPageDrawContext();if(e.width<=2*i.width){t.drawImage(e,0,0,e.width,e.height,0,0,i.width,i.height);return i}let n=i.width<<3,s=i.height<<3;const[r,o]=a.getCanvas(n,s);for(;n>e.width||s>e.height;){n>>=1;s>>=1}o.drawImage(e,0,0,e.width,e.height,0,0,n,s);for(;n>2*i.width;){o.drawImage(r,0,0,n,s,0,0,n>>1,s>>1);n>>=1;s>>=1}t.drawImage(r,0,0,n,s,0,0,i.width,i.height);return i}get _thumbPageTitle(){return this.l10n.get("thumb_page_title",{page:this.pageLabel??this.id})}get _thumbPageCanvas(){return this.l10n.get("thumb_page_canvas",{page:this.pageLabel??this.id})}setPageLabel(e){this.pageLabel="string"==typeof e?e:null;this._thumbPageTitle.then((e=>{this.anchor.title=e}));this.renderingState===r.RenderingStates.FINISHED&&this._thumbPageCanvas.then((e=>{this.image?.setAttribute("aria-label",e)}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFViewer=void 0;var n=i(4),s=i(28),r=i(5);class PDFViewer extends s.BaseViewer{get _viewerElement(){return(0,r.shadow)(this,"_viewerElement",this.viewer)}_scrollIntoView({pageDiv:e,pageSpot:t=null,pageNumber:i=null}){if(!t&&!this.isInPresentationMode){const i=e.offsetLeft+e.clientLeft,n=i+e.clientWidth,{scrollLeft:s,clientWidth:r}=this.container;(this._isScrollModeHorizontal||i<s||n>s+r)&&(t={left:0,top:0})}super._scrollIntoView({pageDiv:e,pageSpot:t,pageNumber:i})}_getVisiblePages(){return this.isInPresentationMode?this._getCurrentVisiblePage():super._getVisiblePages()}_updateHelper(e){if(this.isInPresentationMode)return;let t=this._currentPageNumber,i=!1;for(const s of e){if(s.percent<100)break;if(s.id===t&&this._scrollMode===n.ScrollMode.VERTICAL&&this._spreadMode===n.SpreadMode.NONE){i=!0;break}}i||(t=e[0].id);this._setCurrentPageNumber(t)}}t.PDFViewer=PDFViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BaseViewer=void 0;var n=i(5),s=i(4),r=i(8),a=i(29),o=i(30),l=i(31),c=i(19),h=i(32),d=i(33),u=i(34);function PDFPageViewBuffer(e){const t=[];this.push=function(i){const n=t.indexOf(i);n>=0&&t.splice(n,1);t.push(i);t.length>e&&t.shift().destroy()};this.resize=function(i,n){e=i;if(n){const e=new Set;for(let t=0,i=n.length;t<i;++t)e.add(n[t].id);(0,s.moveToEndOfArray)(t,(function(t){return e.has(t.id)}))}for(;t.length>e;)t.shift().destroy()};this.has=function(e){return t.includes(e)}}class BaseViewer{constructor(e){if(this.constructor===BaseViewer)throw new Error("Cannot initialize BaseViewer.");const t="2.9.359";if(n.version!==t)throw new Error(`The API version "${n.version}" does not match the Viewer version "2.9.359".`);this._name=this.constructor.name;this.container=e.container;this.viewer=e.viewer||e.container.firstElementChild;if("DIV"!==this.container?.tagName.toUpperCase()||"DIV"!==this.viewer?.tagName.toUpperCase())throw new Error("Invalid `container` and/or `viewer` option.");if(this.container.offsetParent&&"absolute"!==getComputedStyle(this.container).position)throw new Error("The `container` must be absolutely positioned.");this.eventBus=e.eventBus;this.linkService=e.linkService||new c.SimpleLinkService;this.downloadManager=e.downloadManager||null;this.findController=e.findController||null;this._scriptingManager=e.scriptingManager||null;this.removePageBorders=e.removePageBorders||!1;this.textLayerMode=Number.isInteger(e.textLayerMode)?e.textLayerMode:s.TextLayerMode.ENABLE;this.imageResourcesPath=e.imageResourcesPath||"";this.renderInteractiveForms=!1!==e.renderInteractiveForms;this.enablePrintAutoRotate=e.enablePrintAutoRotate||!1;this.renderer=e.renderer||s.RendererType.CANVAS;this.useOnlyCssZoom=e.useOnlyCssZoom||!1;this.maxCanvasPixels=e.maxCanvasPixels;this.l10n=e.l10n||o.NullL10n;this.enableScripting=!0===e.enableScripting&&!!this._scriptingManager;this.defaultRenderingQueue=!e.renderingQueue;if(this.defaultRenderingQueue){this.renderingQueue=new r.PDFRenderingQueue;this.renderingQueue.setViewer(this)}else this.renderingQueue=e.renderingQueue;this.scroll=(0,s.watchScroll)(this.container,this._scrollUpdate.bind(this));this.presentationModeState=s.PresentationModeState.UNKNOWN;this._onBeforeDraw=this._onAfterDraw=null;this._resetView();this.removePageBorders&&this.viewer.classList.add("removePageBorders");Promise.resolve().then((()=>{this.eventBus.dispatch("baseviewerinit",{source:this})}))}get pagesCount(){return this._pages.length}getPageView(e){return this._pages[e]}get pageViewsReady(){return!!this._pagesCapability.settled&&this._pages.every((function(e){return e?.pdfPage}))}get currentPageNumber(){return this._currentPageNumber}set currentPageNumber(e){if(!Number.isInteger(e))throw new Error("Invalid page number.");this.pdfDocument&&(this._setCurrentPageNumber(e,!0)||console.error(`${this._name}.currentPageNumber: "${e}" is not a valid page.`))}_setCurrentPageNumber(e,t=!1){if(this._currentPageNumber===e){t&&this._resetCurrentPageView();return!0}if(!(0<e&&e<=this.pagesCount))return!1;const i=this._currentPageNumber;this._currentPageNumber=e;this.eventBus.dispatch("pagechanging",{source:this,pageNumber:e,pageLabel:this._pageLabels?.[e-1]??null,previous:i});t&&this._resetCurrentPageView();return!0}get currentPageLabel(){return this._pageLabels?.[this._currentPageNumber-1]??null}set currentPageLabel(e){if(!this.pdfDocument)return;let t=0|e;if(this._pageLabels){const i=this._pageLabels.indexOf(e);i>=0&&(t=i+1)}this._setCurrentPageNumber(t,!0)||console.error(`${this._name}.currentPageLabel: "${e}" is not a valid page.`)}get currentScale(){return this._currentScale!==s.UNKNOWN_SCALE?this._currentScale:s.DEFAULT_SCALE}set currentScale(e){if(isNaN(e))throw new Error("Invalid numeric scale.");this.pdfDocument&&this._setScale(e,!1)}get currentScaleValue(){return this._currentScaleValue}set currentScaleValue(e){this.pdfDocument&&this._setScale(e,!1)}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,s.isValidRotation)(e))throw new Error("Invalid pages rotation angle.");if(!this.pdfDocument)return;(e%=360)<0&&(e+=360);if(this._pagesRotation===e)return;this._pagesRotation=e;const t=this._currentPageNumber;for(let t=0,i=this._pages.length;t<i;t++){const i=this._pages[t];i.update(i.scale,e)}this._currentScaleValue&&this._setScale(this._currentScaleValue,!0);this.eventBus.dispatch("rotationchanging",{source:this,pagesRotation:e,pageNumber:t});this.defaultRenderingQueue&&this.update()}get firstPagePromise(){return this.pdfDocument?this._firstPageCapability.promise:null}get onePageRendered(){return this.pdfDocument?this._onePageRenderedCapability.promise:null}get pagesPromise(){return this.pdfDocument?this._pagesCapability.promise:null}get _viewerElement(){throw new Error("Not implemented: _viewerElement")}_onePageRenderedOrForceFetch(){return this.container.offsetParent&&0!==this._getVisiblePages().views.length?this._onePageRenderedCapability.promise:Promise.resolve()}setDocument(e){if(this.pdfDocument){this.eventBus.dispatch("pagesdestroy",{source:this});this._cancelRendering();this._resetView();this.findController&&this.findController.setDocument(null);this._scriptingManager&&this._scriptingManager.setDocument(null)}this.pdfDocument=e;if(!e)return;const t=e.isPureXfa,i=e.numPages,n=e.getPage(1),r=e.getOptionalContentConfig();this._pagesCapability.promise.then((()=>{this.eventBus.dispatch("pagesloaded",{source:this,pagesCount:i})}));this._onBeforeDraw=e=>{const t=this._pages[e.pageNumber-1];t&&this._buffer.push(t)};this.eventBus._on("pagerender",this._onBeforeDraw);this._onAfterDraw=e=>{if(!e.cssTransform&&!this._onePageRenderedCapability.settled){this._onePageRenderedCapability.resolve();this.eventBus._off("pagerendered",this._onAfterDraw);this._onAfterDraw=null}};this.eventBus._on("pagerendered",this._onAfterDraw);n.then((n=>{this._firstPageCapability.resolve(n);this._optionalContentConfigPromise=r;const a=this.currentScale,o=n.getViewport({scale:a*s.CSS_UNITS}),c=this.textLayerMode!==s.TextLayerMode.DISABLE?this:null,h=t?this:null;for(let e=1;e<=i;++e){const t=new l.PDFPageView({container:this._viewerElement,eventBus:this.eventBus,id:e,scale:a,defaultViewport:o.clone(),optionalContentConfigPromise:r,renderingQueue:this.renderingQueue,textLayerFactory:c,textLayerMode:this.textLayerMode,annotationLayerFactory:this,xfaLayerFactory:h,structTreeLayerFactory:this,imageResourcesPath:this.imageResourcesPath,renderInteractiveForms:this.renderInteractiveForms,renderer:this.renderer,useOnlyCssZoom:this.useOnlyCssZoom,maxCanvasPixels:this.maxCanvasPixels,l10n:this.l10n});this._pages.push(t)}const d=this._pages[0];if(d){d.setPdfPage(n);this.linkService.cachePageRef(1,n.ref)}this._spreadMode!==s.SpreadMode.NONE&&this._updateSpreadMode();this._onePageRenderedOrForceFetch().then((()=>{this.findController&&this.findController.setDocument(e);this.enableScripting&&this._scriptingManager.setDocument(e);if(e.loadingParams.disableAutoFetch||i>7500){this._pagesCapability.resolve();return}let t=i-1;if(t<=0)this._pagesCapability.resolve();else for(let n=2;n<=i;++n)e.getPage(n).then((e=>{const i=this._pages[n-1];i.pdfPage||i.setPdfPage(e);this.linkService.cachePageRef(n,e.ref);0==--t&&this._pagesCapability.resolve()}),(e=>{console.error(`Unable to get page ${n} to initialize viewer`,e);0==--t&&this._pagesCapability.resolve()}))}));this.eventBus.dispatch("pagesinit",{source:this});this.defaultRenderingQueue&&this.update()})).catch((e=>{console.error("Unable to initialize viewer",e)}))}setPageLabels(e){if(this.pdfDocument){if(e)if(Array.isArray(e)&&this.pdfDocument.numPages===e.length)this._pageLabels=e;else{this._pageLabels=null;console.error(`${this._name}.setPageLabels: Invalid page labels.`)}else this._pageLabels=null;for(let e=0,t=this._pages.length;e<t;e++)this._pages[e].setPageLabel(this._pageLabels?.[e]??null)}}_resetView(){this._pages=[];this._currentPageNumber=1;this._currentScale=s.UNKNOWN_SCALE;this._currentScaleValue=null;this._pageLabels=null;this._buffer=new PDFPageViewBuffer(10);this._location=null;this._pagesRotation=0;this._optionalContentConfigPromise=null;this._pagesRequests=new WeakMap;this._firstPageCapability=(0,n.createPromiseCapability)();this._onePageRenderedCapability=(0,n.createPromiseCapability)();this._pagesCapability=(0,n.createPromiseCapability)();this._scrollMode=s.ScrollMode.VERTICAL;this._spreadMode=s.SpreadMode.NONE;if(this._onBeforeDraw){this.eventBus._off("pagerender",this._onBeforeDraw);this._onBeforeDraw=null}if(this._onAfterDraw){this.eventBus._off("pagerendered",this._onAfterDraw);this._onAfterDraw=null}this.viewer.textContent="";this._updateScrollMode()}_scrollUpdate(){0!==this.pagesCount&&this.update()}_scrollIntoView({pageDiv:e,pageSpot:t=null,pageNumber:i=null}){(0,s.scrollIntoView)(e,t)}_setScaleUpdatePages(e,t,i=!1,n=!1){this._currentScaleValue=t.toString();if(function isSameScale(e,t){return t===e||Math.abs(t-e)<1e-15}(this._currentScale,e))n&&this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:t});else{for(let t=0,i=this._pages.length;t<i;t++)this._pages[t].update(e);this._currentScale=e;if(!i){let e,t=this._currentPageNumber;if(this._location&&!this.isInPresentationMode&&!this.isChangingPresentationMode){t=this._location.pageNumber;e=[null,{name:"XYZ"},this._location.left,this._location.top,null]}this.scrollPageIntoView({pageNumber:t,destArray:e,allowNegativeOffset:!0})}this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:n?t:void 0});this.defaultRenderingQueue&&this.update()}}get _pageWidthScaleFactor(){return this._spreadMode===s.SpreadMode.NONE||this._scrollMode===s.ScrollMode.HORIZONTAL||this.isInPresentationMode?1:2}_setScale(e,t=!1){let i=parseFloat(e);if(i>0)this._setScaleUpdatePages(i,e,t,!1);else{const n=this._pages[this._currentPageNumber-1];if(!n)return;const r=this.isInPresentationMode||this.removePageBorders;let a=r?0:s.SCROLLBAR_PADDING,o=r?0:s.VERTICAL_PADDING;!r&&this._isScrollModeHorizontal&&([a,o]=[o,a]);const l=(this.container.clientWidth-a)/n.width*n.scale/this._pageWidthScaleFactor,c=(this.container.clientHeight-o)/n.height*n.scale;switch(e){case"page-actual":i=1;break;case"page-width":i=l;break;case"page-height":i=c;break;case"page-fit":i=Math.min(l,c);break;case"auto":const t=(0,s.isPortraitOrientation)(n)?l:Math.min(c,l);i=Math.min(s.MAX_AUTO_SCALE,t);break;default:console.error(`${this._name}._setScale: "${e}" is an unknown zoom value.`);return}this._setScaleUpdatePages(i,e,t,!0)}}_resetCurrentPageView(){this.isInPresentationMode&&this._setScale(this._currentScaleValue,!0);const e=this._pages[this._currentPageNumber-1];this._scrollIntoView({pageDiv:e.div})}pageLabelToPageNumber(e){if(!this._pageLabels)return null;const t=this._pageLabels.indexOf(e);return t<0?null:t+1}scrollPageIntoView({pageNumber:e,destArray:t=null,allowNegativeOffset:i=!1,ignoreDestinationZoom:n=!1}){if(!this.pdfDocument)return;const r=Number.isInteger(e)&&this._pages[e-1];if(!r){console.error(`${this._name}.scrollPageIntoView: "${e}" is not a valid pageNumber parameter.`);return}if(this.isInPresentationMode||!t){this._setCurrentPageNumber(e,!0);return}let a,o,l=0,c=0,h=0,d=0;const u=r.rotation%180!=0,p=(u?r.height:r.width)/r.scale/s.CSS_UNITS,g=(u?r.width:r.height)/r.scale/s.CSS_UNITS;let f=0;switch(t[1].name){case"XYZ":l=t[2];c=t[3];f=t[4];l=null!==l?l:0;c=null!==c?c:g;break;case"Fit":case"FitB":f="page-fit";break;case"FitH":case"FitBH":c=t[2];f="page-width";if(null===c&&this._location){l=this._location.left;c=this._location.top}else"number"!=typeof c&&(c=g);break;case"FitV":case"FitBV":l=t[2];h=p;d=g;f="page-height";break;case"FitR":l=t[2];c=t[3];h=t[4]-l;d=t[5]-c;const e=this.removePageBorders?0:s.SCROLLBAR_PADDING,i=this.removePageBorders?0:s.VERTICAL_PADDING;a=(this.container.clientWidth-e)/h/s.CSS_UNITS;o=(this.container.clientHeight-i)/d/s.CSS_UNITS;f=Math.min(Math.abs(a),Math.abs(o));break;default:console.error(`${this._name}.scrollPageIntoView: "${t[1].name}" is not a valid destination type.`);return}n||(f&&f!==this._currentScale?this.currentScaleValue=f:this._currentScale===s.UNKNOWN_SCALE&&(this.currentScaleValue=s.DEFAULT_SCALE_VALUE));if("page-fit"===f&&!t[4]){this._scrollIntoView({pageDiv:r.div,pageNumber:e});return}const m=[r.viewport.convertToViewportPoint(l,c),r.viewport.convertToViewportPoint(l+h,c+d)];let _=Math.min(m[0][0],m[1][0]),b=Math.min(m[0][1],m[1][1]);if(!i){_=Math.max(_,0);b=Math.max(b,0)}this._scrollIntoView({pageDiv:r.div,pageSpot:{left:_,top:b},pageNumber:e})}_updateLocation(e){const t=this._currentScale,i=this._currentScaleValue,n=parseFloat(i)===t?Math.round(1e4*t)/100:i,s=e.id;let r="#page="+s;r+="&zoom="+n;const a=this._pages[s-1],o=this.container,l=a.getPagePoint(o.scrollLeft-e.x,o.scrollTop-e.y),c=Math.round(l[0]),h=Math.round(l[1]);r+=","+c+","+h;this._location={pageNumber:s,scale:n,top:h,left:c,rotation:this._pagesRotation,pdfOpenParams:r}}_updateHelper(e){throw new Error("Not implemented: _updateHelper")}update(){const e=this._getVisiblePages(),t=e.views,i=t.length;if(0===i)return;const n=Math.max(10,2*i+1);this._buffer.resize(n,t);this.renderingQueue.renderHighestPriority(e);this._updateHelper(t);this._updateLocation(e.first);this.eventBus.dispatch("updateviewarea",{source:this,location:this._location})}containsElement(e){return this.container.contains(e)}focus(){this.container.focus()}get _isScrollModeHorizontal(){return!this.isInPresentationMode&&this._scrollMode===s.ScrollMode.HORIZONTAL}get _isContainerRtl(){return"rtl"===getComputedStyle(this.container).direction}get isInPresentationMode(){return this.presentationModeState===s.PresentationModeState.FULLSCREEN}get isChangingPresentationMode(){return this.presentationModeState===s.PresentationModeState.CHANGING}get isHorizontalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollWidth>this.container.clientWidth}get isVerticalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollHeight>this.container.clientHeight}_getCurrentVisiblePage(){if(!this.pagesCount)return{views:[]};const e=this._pages[this._currentPageNumber-1],t=e.div,i={id:e.id,x:t.offsetLeft+t.clientLeft,y:t.offsetTop+t.clientTop,view:e};return{first:i,last:i,views:[i]}}_getVisiblePages(){return(0,s.getVisibleElements)({scrollEl:this.container,views:this._pages,sortByVisibility:!0,horizontal:this._isScrollModeHorizontal,rtl:this._isScrollModeHorizontal&&this._isContainerRtl})}isPageVisible(e){if(!this.pdfDocument)return!1;if(!(Number.isInteger(e)&&e>0&&e<=this.pagesCount)){console.error(`${this._name}.isPageVisible: "${e}" is not a valid page.`);return!1}return this._getVisiblePages().views.some((function(t){return t.id===e}))}isPageCached(e){if(!this.pdfDocument||!this._buffer)return!1;if(!(Number.isInteger(e)&&e>0&&e<=this.pagesCount)){console.error(`${this._name}.isPageCached: "${e}" is not a valid page.`);return!1}const t=this._pages[e-1];return!!t&&this._buffer.has(t)}cleanup(){for(let e=0,t=this._pages.length;e<t;e++)this._pages[e]&&this._pages[e].renderingState!==r.RenderingStates.FINISHED&&this._pages[e].reset()}_cancelRendering(){for(let e=0,t=this._pages.length;e<t;e++)this._pages[e]&&this._pages[e].cancelRendering()}_ensurePdfPageLoaded(e){if(e.pdfPage)return Promise.resolve(e.pdfPage);if(this._pagesRequests.has(e))return this._pagesRequests.get(e);const t=this.pdfDocument.getPage(e.id).then((t=>{e.pdfPage||e.setPdfPage(t);this._pagesRequests.delete(e);return t})).catch((t=>{console.error("Unable to get page for page view",t);this._pagesRequests.delete(e)}));this._pagesRequests.set(e,t);return t}forceRendering(e){const t=e||this._getVisiblePages(),i=this._isScrollModeHorizontal?this.scroll.right:this.scroll.down,n=this.renderingQueue.getHighestPriority(t,this._pages,i);if(n){this._ensurePdfPageLoaded(n).then((()=>{this.renderingQueue.renderView(n)}));return!0}return!1}createTextLayerBuilder(e,t,i,n=!1,s){return new d.TextLayerBuilder({textLayerDiv:e,eventBus:s,pageIndex:t,viewport:i,findController:this.isInPresentationMode?null:this.findController,enhanceTextSelection:!this.isInPresentationMode&&n})}createAnnotationLayerBuilder(e,t,i=null,n="",s=!1,r=o.NullL10n,l=null,c=null,h=null){return new a.AnnotationLayerBuilder({pageDiv:e,pdfPage:t,annotationStorage:i||this.pdfDocument?.annotationStorage,imageResourcesPath:n,renderInteractiveForms:s,linkService:this.linkService,downloadManager:this.downloadManager,l10n:r,enableScripting:l??this.enableScripting,hasJSActionsPromise:c||this.pdfDocument?.hasJSActions(),mouseState:h||this._scriptingManager?.mouseState})}createXfaLayerBuilder(e,t,i=null){return new u.XfaLayerBuilder({pageDiv:e,pdfPage:t,annotationStorage:i||this.pdfDocument?.annotationStorage})}createStructTreeLayerBuilder(e){return new h.StructTreeLayerBuilder({pdfPage:e})}get hasEqualPageSizes(){const e=this._pages[0];for(let t=1,i=this._pages.length;t<i;++t){const i=this._pages[t];if(i.width!==e.width||i.height!==e.height)return!1}return!0}getPagesOverview(){return this._pages.map((e=>{const t=e.pdfPage.getViewport({scale:1});return!this.enablePrintAutoRotate||(0,s.isPortraitOrientation)(t)?{width:t.width,height:t.height,rotation:t.rotation}:{width:t.height,height:t.width,rotation:(t.rotation-90)%360}}))}get optionalContentConfigPromise(){return this.pdfDocument?this._optionalContentConfigPromise?this._optionalContentConfigPromise:this.pdfDocument.getOptionalContentConfig():Promise.resolve(null)}set optionalContentConfigPromise(e){if(!(e instanceof Promise))throw new Error(`Invalid optionalContentConfigPromise: ${e}`);if(this.pdfDocument&&this._optionalContentConfigPromise){this._optionalContentConfigPromise=e;for(const t of this._pages)t.update(t.scale,t.rotation,e);this.update();this.eventBus.dispatch("optionalcontentconfigchanged",{source:this,promise:e})}}get scrollMode(){return this._scrollMode}set scrollMode(e){if(this._scrollMode!==e){if(!(0,s.isValidScrollMode)(e))throw new Error(`Invalid scroll mode: ${e}`);this._scrollMode=e;this.eventBus.dispatch("scrollmodechanged",{source:this,mode:e});this._updateScrollMode(this._currentPageNumber)}}_updateScrollMode(e=null){const t=this._scrollMode,i=this.viewer;i.classList.toggle("scrollHorizontal",t===s.ScrollMode.HORIZONTAL);i.classList.toggle("scrollWrapped",t===s.ScrollMode.WRAPPED);if(this.pdfDocument&&e){this._currentScaleValue&&isNaN(this._currentScaleValue)&&this._setScale(this._currentScaleValue,!0);this._setCurrentPageNumber(e,!0);this.update()}}get spreadMode(){return this._spreadMode}set spreadMode(e){if(this._spreadMode!==e){if(!(0,s.isValidSpreadMode)(e))throw new Error(`Invalid spread mode: ${e}`);this._spreadMode=e;this.eventBus.dispatch("spreadmodechanged",{source:this,mode:e});this._updateSpreadMode(this._currentPageNumber)}}_updateSpreadMode(e=null){if(!this.pdfDocument)return;const t=this.viewer,i=this._pages;t.textContent="";if(this._spreadMode===s.SpreadMode.NONE)for(let e=0,n=i.length;e<n;++e)t.appendChild(i[e].div);else{const e=this._spreadMode-1;let n=null;for(let s=0,r=i.length;s<r;++s){if(null===n){n=document.createElement("div");n.className="spread";t.appendChild(n)}else if(s%2===e){n=n.cloneNode(!1);t.appendChild(n)}n.appendChild(i[s].div)}}if(e){this._currentScaleValue&&isNaN(this._currentScaleValue)&&this._setScale(this._currentScaleValue,!0);this._setCurrentPageNumber(e,!0);this.update()}}_getPageAdvance(e,t=!1){if(this.isInPresentationMode)return 1;switch(this._scrollMode){case s.ScrollMode.WRAPPED:{const{views:i}=this._getVisiblePages(),n=new Map;for(const{id:e,y:t,percent:s,widthPercent:r}of i){if(0===s||r<100)continue;let i=n.get(t);i||n.set(t,i||(i=[]));i.push(e)}for(const i of n.values()){const n=i.indexOf(e);if(-1===n)continue;const s=i.length;if(1===s)break;if(t)for(let t=n-1,s=0;t>=s;t--){const n=i[t],s=i[t+1]-1;if(n<s)return e-s}else for(let t=n+1,r=s;t<r;t++){const n=i[t],s=i[t-1]+1;if(n>s)return s-e}if(t){const t=i[0];if(t<e)return e-t+1}else{const t=i[s-1];if(t>e)return t-e+1}break}break}case s.ScrollMode.HORIZONTAL:break;case s.ScrollMode.VERTICAL:{if(this._spreadMode===s.SpreadMode.NONE)break;const i=this._spreadMode-1;if(t&&e%2!==i)break;if(!t&&e%2===i)break;const{views:n}=this._getVisiblePages(),r=t?e-1:e+1;for(const{id:e,percent:t,widthPercent:i}of n)if(e===r){if(t>0&&100===i)return 2;break}break}}return 1}nextPage(){const e=this._currentPageNumber,t=this.pagesCount;if(e>=t)return!1;const i=this._getPageAdvance(e,!1)||1;this.currentPageNumber=Math.min(e+i,t);return!0}previousPage(){const e=this._currentPageNumber;if(e<=1)return!1;const t=this._getPageAdvance(e,!0)||1;this.currentPageNumber=Math.max(e-t,1);return!0}}t.BaseViewer=BaseViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.DefaultAnnotationLayerFactory=t.AnnotationLayerBuilder=void 0;var n=i(5),s=i(30),r=i(19);class AnnotationLayerBuilder{constructor({pageDiv:e,pdfPage:t,linkService:i,downloadManager:n,annotationStorage:r=null,imageResourcesPath:a="",renderInteractiveForms:o=!0,l10n:l=s.NullL10n,enableScripting:c=!1,hasJSActionsPromise:h=null,mouseState:d=null}){this.pageDiv=e;this.pdfPage=t;this.linkService=i;this.downloadManager=n;this.imageResourcesPath=a;this.renderInteractiveForms=o;this.l10n=l;this.annotationStorage=r;this.enableScripting=c;this._hasJSActionsPromise=h;this._mouseState=d;this.div=null;this._cancelled=!1}render(e,t="display"){return Promise.all([this.pdfPage.getAnnotations({intent:t}),this._hasJSActionsPromise]).then((([t,i=!1])=>{if(this._cancelled)return;if(0===t.length)return;const s={viewport:e.clone({dontFlip:!0}),div:this.div,annotations:t,page:this.pdfPage,imageResourcesPath:this.imageResourcesPath,renderInteractiveForms:this.renderInteractiveForms,linkService:this.linkService,downloadManager:this.downloadManager,annotationStorage:this.annotationStorage,enableScripting:this.enableScripting,hasJSActions:i,mouseState:this._mouseState};if(this.div)n.AnnotationLayer.update(s);else{this.div=document.createElement("div");this.div.className="annotationLayer";this.pageDiv.appendChild(this.div);s.div=this.div;n.AnnotationLayer.render(s);this.l10n.translate(this.div)}}))}cancel(){this._cancelled=!0}hide(){this.div&&(this.div.hidden=!0)}}t.AnnotationLayerBuilder=AnnotationLayerBuilder;t.DefaultAnnotationLayerFactory=class DefaultAnnotationLayerFactory{createAnnotationLayerBuilder(e,t,i=null,n="",a=!0,o=s.NullL10n,l=!1,c=null,h=null){return new AnnotationLayerBuilder({pageDiv:e,pdfPage:t,imageResourcesPath:n,renderInteractiveForms:a,linkService:new r.SimpleLinkService,l10n:o,annotationStorage:i,enableScripting:l,hasJSActionsPromise:c,mouseState:h})}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getL10nFallback=getL10nFallback;t.NullL10n=void 0;const i={of_pages:"of {{pagesCount}}",page_of_pages:"({{pageNumber}} of {{pagesCount}})",document_properties_kb:"{{size_kb}} KB ({{size_b}} bytes)",document_properties_mb:"{{size_mb}} MB ({{size_b}} bytes)",document_properties_date_string:"{{date}}, {{time}}",document_properties_page_size_unit_inches:"in",document_properties_page_size_unit_millimeters:"mm",document_properties_page_size_orientation_portrait:"portrait",document_properties_page_size_orientation_landscape:"landscape",document_properties_page_size_name_a3:"A3",document_properties_page_size_name_a4:"A4",document_properties_page_size_name_letter:"Letter",document_properties_page_size_name_legal:"Legal",document_properties_page_size_dimension_string:"{{width}} × {{height}} {{unit}} ({{orientation}})",document_properties_page_size_dimension_name_string:"{{width}} × {{height}} {{unit}} ({{name}}, {{orientation}})",document_properties_linearized_yes:"Yes",document_properties_linearized_no:"No",print_progress_percent:"{{progress}}%","toggle_sidebar.title":"Toggle Sidebar","toggle_sidebar_notification2.title":"Toggle Sidebar (document contains outline/attachments/layers)",additional_layers:"Additional Layers",page_landmark:"Page {{page}}",thumb_page_title:"Page {{page}}",thumb_page_canvas:"Thumbnail of Page {{page}}",find_reached_top:"Reached top of document, continued from bottom",find_reached_bottom:"Reached end of document, continued from top","find_match_count[one]":"{{current}} of {{total}} match","find_match_count[other]":"{{current}} of {{total}} matches","find_match_count_limit[one]":"More than {{limit}} match","find_match_count_limit[other]":"More than {{limit}} matches",find_not_found:"Phrase not found",error_version_info:"PDF.js v{{version}} (build: {{build}})",error_message:"Message: {{message}}",error_stack:"Stack: {{stack}}",error_file:"File: {{file}}",error_line:"Line: {{line}}",rendering_error:"An error occurred while rendering the page.",page_scale_width:"Page Width",page_scale_fit:"Page Fit",page_scale_auto:"Automatic Zoom",page_scale_actual:"Actual Size",page_scale_percent:"{{scale}}%",loading:"Loading…",loading_error:"An error occurred while loading the PDF.",invalid_file_error:"Invalid or corrupted PDF file.",missing_file_error:"Missing PDF file.",unexpected_response_error:"Unexpected server response.",printing_not_supported:"Warning: Printing is not fully supported by this browser.",printing_not_ready:"Warning: The PDF is not fully loaded for printing.",web_fonts_disabled:"Web fonts are disabled: unable to use embedded PDF fonts."};function getL10nFallback(e,t){switch(e){case"find_match_count":e=`find_match_count[${1===t.total?"one":"other"}]`;break;case"find_match_count_limit":e=`find_match_count_limit[${1===t.limit?"one":"other"}]`}return i[e]||""}const n={getLanguage:async()=>"en-us",getDirection:async()=>"ltr",get:async(e,t=null,i=getL10nFallback(e,t))=>function formatL10nValue(e,t){return t?e.replace(/\{\{\s*(\w+)\s*\}\}/g,((e,i)=>i in t?t[i]:"{{"+i+"}}")):e}(i,t),async translate(e){}};t.NullL10n=n},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPageView=void 0;var n=i(4),s=i(5),r=i(30),a=i(8),o=i(2);const l=o.viewerCompatibilityParams.maxCanvasPixels||16777216;t.PDFPageView=class PDFPageView{constructor(e){const t=e.container,i=e.defaultViewport;this.id=e.id;this.renderingId="page"+this.id;this.pdfPage=null;this.pageLabel=null;this.rotation=0;this.scale=e.scale||n.DEFAULT_SCALE;this.viewport=i;this.pdfPageRotate=i.rotation;this._optionalContentConfigPromise=e.optionalContentConfigPromise||null;this.hasRestrictedScaling=!1;this.textLayerMode=Number.isInteger(e.textLayerMode)?e.textLayerMode:n.TextLayerMode.ENABLE;this.imageResourcesPath=e.imageResourcesPath||"";this.renderInteractiveForms=!1!==e.renderInteractiveForms;this.useOnlyCssZoom=e.useOnlyCssZoom||!1;this.maxCanvasPixels=e.maxCanvasPixels||l;this.eventBus=e.eventBus;this.renderingQueue=e.renderingQueue;this.textLayerFactory=e.textLayerFactory;this.annotationLayerFactory=e.annotationLayerFactory;this.xfaLayerFactory=e.xfaLayerFactory;this.structTreeLayerFactory=e.structTreeLayerFactory;this.renderer=e.renderer||n.RendererType.CANVAS;this.l10n=e.l10n||r.NullL10n;this.paintTask=null;this.paintedViewportMap=new WeakMap;this.renderingState=a.RenderingStates.INITIAL;this.resume=null;this._renderError=null;this.annotationLayer=null;this.textLayer=null;this.zoomLayer=null;this.xfaLayer=null;this.structTreeLayer=null;const s=document.createElement("div");s.className="page";s.style.width=Math.floor(this.viewport.width)+"px";s.style.height=Math.floor(this.viewport.height)+"px";s.setAttribute("data-page-number",this.id);s.setAttribute("role","region");this.l10n.get("page_landmark",{page:this.id}).then((e=>{s.setAttribute("aria-label",e)}));this.div=s;t.appendChild(s)}setPdfPage(e){this.pdfPage=e;this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:this.scale*n.CSS_UNITS,rotation:t});this.reset()}destroy(){this.reset();this.pdfPage&&this.pdfPage.cleanup()}async _renderAnnotationLayer(){let e=null;try{await this.annotationLayer.render(this.viewport,"display")}catch(t){e=t}finally{this.eventBus.dispatch("annotationlayerrendered",{source:this,pageNumber:this.id,error:e})}}async _renderXfaLayer(){let e=null;try{await this.xfaLayer.render(this.viewport,"display")}catch(t){e=t}finally{this.eventBus.dispatch("xfalayerrendered",{source:this,pageNumber:this.id,error:e})}}_resetZoomLayer(e=!1){if(!this.zoomLayer)return;const t=this.zoomLayer.firstChild;this.paintedViewportMap.delete(t);t.width=0;t.height=0;e&&this.zoomLayer.remove();this.zoomLayer=null}reset(e=!1,t=!1){this.cancelRendering(t);this.renderingState=a.RenderingStates.INITIAL;const i=this.div;i.style.width=Math.floor(this.viewport.width)+"px";i.style.height=Math.floor(this.viewport.height)+"px";const n=i.childNodes,s=e&&this.zoomLayer||null,r=t&&this.annotationLayer?.div||null,o=this.xfaLayer?.div||null;for(let e=n.length-1;e>=0;e--){const t=n[e];s!==t&&r!==t&&o!==t&&i.removeChild(t)}i.removeAttribute("data-loaded");if(r)this.annotationLayer.hide();else if(this.annotationLayer){this.annotationLayer.cancel();this.annotationLayer=null}if(!s){if(this.canvas){this.paintedViewportMap.delete(this.canvas);this.canvas.width=0;this.canvas.height=0;delete this.canvas}this._resetZoomLayer()}if(this.svg){this.paintedViewportMap.delete(this.svg);delete this.svg}this.loadingIconDiv=document.createElement("div");this.loadingIconDiv.className="loadingIcon";this.loadingIconDiv.setAttribute("role","img");this.l10n.get("loading").then((e=>{this.loadingIconDiv?.setAttribute("aria-label",e)}));i.appendChild(this.loadingIconDiv)}update(e,t,i=null){this.scale=e||this.scale;void 0!==t&&(this.rotation=t);i instanceof Promise&&(this._optionalContentConfigPromise=i);const s=(this.rotation+this.pdfPageRotate)%360;this.viewport=this.viewport.clone({scale:this.scale*n.CSS_UNITS,rotation:s});if(this.svg){this.cssTransform(this.svg,!0);this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!0,timestamp:performance.now(),error:this._renderError});return}let r=!1;if(this.canvas&&this.maxCanvasPixels>0){const e=this.outputScale;(Math.floor(this.viewport.width)*e.sx|0)*(Math.floor(this.viewport.height)*e.sy|0)>this.maxCanvasPixels&&(r=!0)}if(this.canvas){if(this.useOnlyCssZoom||this.hasRestrictedScaling&&r){this.cssTransform(this.canvas,!0);this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!0,timestamp:performance.now(),error:this._renderError});return}if(!this.zoomLayer&&!this.canvas.hidden){this.zoomLayer=this.canvas.parentNode;this.zoomLayer.style.position="absolute"}}this.zoomLayer&&this.cssTransform(this.zoomLayer.firstChild);this.reset(!0,!0)}cancelRendering(e=!1){if(this.paintTask){this.paintTask.cancel();this.paintTask=null}this.resume=null;if(this.textLayer){this.textLayer.cancel();this.textLayer=null}if(!e&&this.annotationLayer){this.annotationLayer.cancel();this.annotationLayer=null}if(this._onTextLayerRendered){this.eventBus._off("textlayerrendered",this._onTextLayerRendered);this._onTextLayerRendered=null}}cssTransform(e,t=!1){const i=this.viewport.width,n=this.viewport.height,s=this.div;e.style.width=e.parentNode.style.width=s.style.width=Math.floor(i)+"px";e.style.height=e.parentNode.style.height=s.style.height=Math.floor(n)+"px";const r=this.viewport.rotation-this.paintedViewportMap.get(e).rotation,a=Math.abs(r);let o=1,l=1;if(90===a||270===a){o=n/i;l=i/n}e.style.transform=`rotate(${r}deg) scale(${o}, ${l})`;if(this.textLayer){const e=this.textLayer.viewport,t=this.viewport.rotation-e.rotation,n=Math.abs(t);let s=i/e.width;90!==n&&270!==n||(s=i/e.height);const r=this.textLayer.textLayerDiv;let a,o;switch(n){case 0:a=o=0;break;case 90:a=0;o="-"+r.style.height;break;case 180:a="-"+r.style.width;o="-"+r.style.height;break;case 270:a="-"+r.style.width;o=0;break;default:console.error("Bad rotation value.")}r.style.transform=`rotate(${n}deg) scale(${s}) translate(${a}, ${o})`;r.style.transformOrigin="0% 0%"}t&&this.annotationLayer&&this._renderAnnotationLayer();this.xfaLayer&&this._renderXfaLayer()}get width(){return this.viewport.width}get height(){return this.viewport.height}getPagePoint(e,t){return this.viewport.convertToPdfPoint(e,t)}draw(){if(this.renderingState!==a.RenderingStates.INITIAL){console.error("Must be in new state before drawing");this.reset()}const{div:e,pdfPage:t}=this;if(!t){this.renderingState=a.RenderingStates.FINISHED;if(this.loadingIconDiv){e.removeChild(this.loadingIconDiv);delete this.loadingIconDiv}return Promise.reject(new Error("pdfPage is not loaded"))}this.renderingState=a.RenderingStates.RUNNING;const i=document.createElement("div");i.style.width=e.style.width;i.style.height=e.style.height;i.classList.add("canvasWrapper");this.annotationLayer?.div?e.insertBefore(i,this.annotationLayer.div):e.appendChild(i);let r=null;if(this.textLayerMode!==n.TextLayerMode.DISABLE&&this.textLayerFactory){const t=document.createElement("div");t.className="textLayer";t.style.width=i.style.width;t.style.height=i.style.height;this.annotationLayer?.div?e.insertBefore(t,this.annotationLayer.div):e.appendChild(t);r=this.textLayerFactory.createTextLayerBuilder(t,this.id-1,this.viewport,this.textLayerMode===n.TextLayerMode.ENABLE_ENHANCE,this.eventBus)}this.textLayer=r;let o=null;this.renderingQueue&&(o=e=>{if(this.renderingQueue.isHighestPriority(this))e();else{this.renderingState=a.RenderingStates.PAUSED;this.resume=()=>{this.renderingState=a.RenderingStates.RUNNING;e()}}});const finishPaintTask=async(t=null)=>{l===this.paintTask&&(this.paintTask=null);if(t instanceof s.RenderingCancelledException)this._renderError=null;else{this._renderError=t;this.renderingState=a.RenderingStates.FINISHED;if(this.loadingIconDiv){e.removeChild(this.loadingIconDiv);delete this.loadingIconDiv}this._resetZoomLayer(!0);this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!1,timestamp:performance.now(),error:this._renderError});if(t)throw t}},l=this.renderer===n.RendererType.SVG?this.paintOnSvg(i):this.paintOnCanvas(i);l.onRenderContinue=o;this.paintTask=l;const c=l.promise.then((()=>finishPaintTask(null).then((()=>{if(r){const e=t.streamTextContent({normalizeWhitespace:!0,includeMarkedContent:!0});r.setTextContentStream(e);r.render()}}))),(function(e){return finishPaintTask(e)}));if(this.annotationLayerFactory){this.annotationLayer||(this.annotationLayer=this.annotationLayerFactory.createAnnotationLayerBuilder(e,t,null,this.imageResourcesPath,this.renderInteractiveForms,this.l10n,null,null,null));this._renderAnnotationLayer()}if(this.xfaLayerFactory){this.xfaLayer||(this.xfaLayer=this.xfaLayerFactory.createXfaLayerBuilder(e,t,null));this._renderXfaLayer()}if(this.structTreeLayerFactory&&this.textLayer&&this.canvas){this._onTextLayerRendered=e=>{if(e.pageNumber===this.id){this.eventBus._off("textlayerrendered",this._onTextLayerRendered);this._onTextLayerRendered=null;this.canvas&&this.pdfPage.getStructTree().then((e=>{if(!e)return;if(!this.canvas)return;const t=this.structTreeLayer.render(e);t.classList.add("structTree");this.canvas.appendChild(t)}))}};this.eventBus._on("textlayerrendered",this._onTextLayerRendered);this.structTreeLayer=this.structTreeLayerFactory.createStructTreeLayerBuilder(t)}e.setAttribute("data-loaded",!0);this.eventBus.dispatch("pagerender",{source:this,pageNumber:this.id});return c}paintOnCanvas(e){const t=(0,s.createPromiseCapability)(),i={promise:t.promise,onRenderContinue(e){e()},cancel(){p.cancel()}},r=this.viewport,a=document.createElement("canvas");a.hidden=!0;let o=!0;const showCanvas=function(){if(o){a.hidden=!1;o=!1}};e.appendChild(a);this.canvas=a;a.mozOpaque=!0;const l=a.getContext("2d",{alpha:!1}),c=(0,n.getOutputScale)(l);this.outputScale=c;if(this.useOnlyCssZoom){const e=r.clone({scale:n.CSS_UNITS});c.sx*=e.width/r.width;c.sy*=e.height/r.height;c.scaled=!0}if(this.maxCanvasPixels>0){const e=r.width*r.height,t=Math.sqrt(this.maxCanvasPixels/e);if(c.sx>t||c.sy>t){c.sx=t;c.sy=t;c.scaled=!0;this.hasRestrictedScaling=!0}else this.hasRestrictedScaling=!1}const h=(0,n.approximateFraction)(c.sx),d=(0,n.approximateFraction)(c.sy);a.width=(0,n.roundToDivide)(r.width*c.sx,h[0]);a.height=(0,n.roundToDivide)(r.height*c.sy,d[0]);a.style.width=(0,n.roundToDivide)(r.width,h[1])+"px";a.style.height=(0,n.roundToDivide)(r.height,d[1])+"px";this.paintedViewportMap.set(a,r);const u={canvasContext:l,transform:c.scaled?[c.sx,0,0,c.sy,0,0]:null,viewport:this.viewport,renderInteractiveForms:this.renderInteractiveForms,optionalContentConfigPromise:this._optionalContentConfigPromise},p=this.pdfPage.render(u);p.onContinue=function(e){showCanvas();i.onRenderContinue?i.onRenderContinue(e):e()};p.promise.then((function(){showCanvas();t.resolve(void 0)}),(function(e){showCanvas();t.reject(e)}));return i}paintOnSvg(e){let t=!1;const ensureNotCancelled=()=>{if(t)throw new s.RenderingCancelledException(`Rendering cancelled, page ${this.id}`,"svg")},i=this.pdfPage,r=this.viewport.clone({scale:n.CSS_UNITS});return{promise:i.getOperatorList().then((t=>{ensureNotCancelled();return new s.SVGGraphics(i.commonObjs,i.objs,o.viewerCompatibilityParams.disableCreateObjectURL).getSVG(t,r).then((t=>{ensureNotCancelled();this.svg=t;this.paintedViewportMap.set(t,r);t.style.width=e.style.width;t.style.height=e.style.height;this.renderingState=a.RenderingStates.FINISHED;e.appendChild(t)}))})),onRenderContinue(e){e()},cancel(){t=!0}}}setPageLabel(e){this.pageLabel="string"==typeof e?e:null;null!==this.pageLabel?this.div.setAttribute("data-page-label",this.pageLabel):this.div.removeAttribute("data-page-label")}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.StructTreeLayerBuilder=t.DefaultStructTreeLayerFactory=void 0;const i={Document:null,DocumentFragment:null,Part:"group",Sect:"group",Div:"group",Aside:"note",NonStruct:"none",P:null,H:"heading",Title:null,FENote:"note",Sub:"group",Lbl:null,Span:null,Em:null,Strong:null,Link:"link",Annot:"note",Form:"form",Ruby:null,RB:null,RT:null,RP:null,Warichu:null,WT:null,WP:null,L:"list",LI:"listitem",LBody:null,Table:"table",TR:"row",TH:"columnheader",TD:"cell",THead:"columnheader",TBody:null,TFoot:null,Caption:null,Figure:"figure",Formula:null,Artifact:null},n=/^H(\d+)$/;class StructTreeLayerBuilder{constructor({pdfPage:e}){this.pdfPage=e}render(e){return this._walk(e)}_setAttributes(e,t){void 0!==e.alt&&t.setAttribute("aria-label",e.alt);void 0!==e.id&&t.setAttribute("aria-owns",e.id)}_walk(e){if(!e)return null;const t=document.createElement("span");if("role"in e){const{role:s}=e,r=s.match(n);if(r){t.setAttribute("role","heading");t.setAttribute("aria-level",r[1])}else i[s]&&t.setAttribute("role",i[s])}this._setAttributes(e,t);if(e.children)if(1===e.children.length&&"id"in e.children[0])this._setAttributes(e.children[0],t);else for(const i of e.children)t.appendChild(this._walk(i));return t}}t.StructTreeLayerBuilder=StructTreeLayerBuilder;t.DefaultStructTreeLayerFactory=class DefaultStructTreeLayerFactory{createStructTreeLayerBuilder(e){return new StructTreeLayerBuilder({pdfPage:e})}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.TextLayerBuilder=t.DefaultTextLayerFactory=void 0;var n=i(5);class TextLayerBuilder{constructor({textLayerDiv:e,eventBus:t,pageIndex:i,viewport:n,findController:s=null,enhanceTextSelection:r=!1}){this.textLayerDiv=e;this.eventBus=t;this.textContent=null;this.textContentItemsStr=[];this.textContentStream=null;this.renderingDone=!1;this.pageIdx=i;this.pageNumber=this.pageIdx+1;this.matches=[];this.viewport=n;this.textDivs=[];this.findController=s;this.textLayerRenderTask=null;this.enhanceTextSelection=r;this._onUpdateTextLayerMatches=null;this._bindMouse()}_finishRendering(){this.renderingDone=!0;if(!this.enhanceTextSelection){const e=document.createElement("div");e.className="endOfContent";this.textLayerDiv.appendChild(e)}this.eventBus.dispatch("textlayerrendered",{source:this,pageNumber:this.pageNumber,numTextDivs:this.textDivs.length})}render(e=0){if(!this.textContent&&!this.textContentStream||this.renderingDone)return;this.cancel();this.textDivs=[];const t=document.createDocumentFragment();this.textLayerRenderTask=(0,n.renderTextLayer)({textContent:this.textContent,textContentStream:this.textContentStream,container:t,viewport:this.viewport,textDivs:this.textDivs,textContentItemsStr:this.textContentItemsStr,timeout:e,enhanceTextSelection:this.enhanceTextSelection});this.textLayerRenderTask.promise.then((()=>{this.textLayerDiv.appendChild(t);this._finishRendering();this._updateMatches()}),(function(e){}));if(!this._onUpdateTextLayerMatches){this._onUpdateTextLayerMatches=e=>{e.pageIndex!==this.pageIdx&&-1!==e.pageIndex||this._updateMatches()};this.eventBus._on("updatetextlayermatches",this._onUpdateTextLayerMatches)}}cancel(){if(this.textLayerRenderTask){this.textLayerRenderTask.cancel();this.textLayerRenderTask=null}if(this._onUpdateTextLayerMatches){this.eventBus._off("updatetextlayermatches",this._onUpdateTextLayerMatches);this._onUpdateTextLayerMatches=null}}setTextContentStream(e){this.cancel();this.textContentStream=e}setTextContent(e){this.cancel();this.textContent=e}_convertMatches(e,t){if(!e)return[];const{textContentItemsStr:i}=this;let n=0,s=0;const r=i.length-1,a=[];for(let o=0,l=e.length;o<l;o++){let l=e[o];for(;n!==r&&l>=s+i[n].length;){s+=i[n].length;n++}n===i.length&&console.error("Could not find a matching mapping");const c={begin:{divIdx:n,offset:l-s}};l+=t[o];for(;n!==r&&l>s+i[n].length;){s+=i[n].length;n++}c.end={divIdx:n,offset:l-s};a.push(c)}return a}_renderMatches(e){if(0===e.length)return;const{findController:t,pageIdx:i,textContentItemsStr:n,textDivs:s}=this,r=i===t.selected.pageIdx,a=t.selected.matchIdx;let o=null;const l={divIdx:-1,offset:void 0};function beginText(e,t){const i=e.divIdx;s[i].textContent="";appendTextToDiv(i,0,e.offset,t)}function appendTextToDiv(e,t,i,r){const a=s[e],o=n[e].substring(t,i),l=document.createTextNode(o);if(r){const e=document.createElement("span");e.className=r;e.appendChild(l);a.appendChild(e)}else a.appendChild(l)}let c=a,h=c+1;if(t.state.highlightAll){c=0;h=e.length}else if(!r)return;for(let n=c;n<h;n++){const c=e[n],h=c.begin,d=c.end,u=r&&n===a,p=u?" selected":"";u&&t.scrollMatchIntoView({element:s[h.divIdx],pageIndex:i,matchIndex:a});if(o&&h.divIdx===o.divIdx)appendTextToDiv(o.divIdx,o.offset,h.offset);else{null!==o&&appendTextToDiv(o.divIdx,o.offset,l.offset);beginText(h)}if(h.divIdx===d.divIdx)appendTextToDiv(h.divIdx,h.offset,d.offset,"highlight"+p);else{appendTextToDiv(h.divIdx,h.offset,l.offset,"highlight begin"+p);for(let e=h.divIdx+1,t=d.divIdx;e<t;e++)s[e].className="highlight middle"+p;beginText(d,"highlight end"+p)}o=d}o&&appendTextToDiv(o.divIdx,o.offset,l.offset)}_updateMatches(){if(!this.renderingDone)return;const{findController:e,matches:t,pageIdx:i,textContentItemsStr:n,textDivs:s}=this;let r=-1;for(let e=0,i=t.length;e<i;e++){const i=t[e];for(let e=Math.max(r,i.begin.divIdx),t=i.end.divIdx;e<=t;e++){const t=s[e];t.textContent=n[e];t.className=""}r=i.end.divIdx+1}if(!e?.highlightMatches)return;const a=e.pageMatches[i]||null,o=e.pageMatchesLength[i]||null;this.matches=this._convertMatches(a,o);this._renderMatches(this.matches)}_bindMouse(){const e=this.textLayerDiv;let t=null;e.addEventListener("mousedown",(i=>{if(this.enhanceTextSelection&&this.textLayerRenderTask){this.textLayerRenderTask.expandTextDivs(!0);if(t){clearTimeout(t);t=null}return}const n=e.querySelector(".endOfContent");if(!n)return;let s=i.target!==e;s=s&&"none"!==window.getComputedStyle(n).getPropertyValue("-moz-user-select");if(s){const t=e.getBoundingClientRect(),s=Math.max(0,(i.pageY-t.top)/t.height);n.style.top=(100*s).toFixed(2)+"%"}n.classList.add("active")}));e.addEventListener("mouseup",(()=>{if(this.enhanceTextSelection&&this.textLayerRenderTask){t=setTimeout((()=>{this.textLayerRenderTask&&this.textLayerRenderTask.expandTextDivs(!1);t=null}),300);return}const i=e.querySelector(".endOfContent");if(i){i.style.top="";i.classList.remove("active")}}))}}t.TextLayerBuilder=TextLayerBuilder;t.DefaultTextLayerFactory=class DefaultTextLayerFactory{createTextLayerBuilder(e,t,i,n=!1,s){return new TextLayerBuilder({textLayerDiv:e,pageIndex:t,viewport:i,enhanceTextSelection:n,eventBus:s})}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XfaLayerBuilder=t.DefaultXfaLayerFactory=void 0;var n=i(5);class XfaLayerBuilder{constructor({pageDiv:e,pdfPage:t,annotationStorage:i}){this.pageDiv=e;this.pdfPage=t;this.annotationStorage=i;this.div=null;this._cancelled=!1}render(e,t="display"){return this.pdfPage.getXfa().then((t=>{if(this._cancelled)return;const i={viewport:e.clone({dontFlip:!0}),div:this.div,xfa:t,page:this.pdfPage,annotationStorage:this.annotationStorage};if(this.div)n.XfaLayer.update(i);else{this.div=document.createElement("div");this.pageDiv.appendChild(this.div);i.div=this.div;n.XfaLayer.render(i)}})).catch((e=>{console.error(e)}))}cancel(){this._cancelled=!0}hide(){this.div&&(this.div.hidden=!0)}}t.XfaLayerBuilder=XfaLayerBuilder;t.DefaultXfaLayerFactory=class DefaultXfaLayerFactory{createXfaLayerBuilder(e,t,i=null){return new XfaLayerBuilder({pageDiv:e,pdfPage:t,annotationStorage:i})}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SecondaryToolbar=void 0;var n=i(4),s=i(6),r=i(36);t.SecondaryToolbar=class SecondaryToolbar{constructor(e,t,i){this.toolbar=e.toolbar;this.toggleButton=e.toggleButton;this.toolbarButtonContainer=e.toolbarButtonContainer;this.buttons=[{element:e.presentationModeButton,eventName:"presentationmode",close:!0},{element:e.openFileButton,eventName:"openfile",close:!0},{element:e.printButton,eventName:"print",close:!0},{element:e.downloadButton,eventName:"download",close:!0},{element:e.viewBookmarkButton,eventName:null,close:!0},{element:e.firstPageButton,eventName:"firstpage",close:!0},{element:e.lastPageButton,eventName:"lastpage",close:!0},{element:e.pageRotateCwButton,eventName:"rotatecw",close:!1},{element:e.pageRotateCcwButton,eventName:"rotateccw",close:!1},{element:e.cursorSelectToolButton,eventName:"switchcursortool",eventDetails:{tool:s.CursorTool.SELECT},close:!0},{element:e.cursorHandToolButton,eventName:"switchcursortool",eventDetails:{tool:s.CursorTool.HAND},close:!0},{element:e.scrollVerticalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.VERTICAL},close:!0},{element:e.scrollHorizontalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.HORIZONTAL},close:!0},{element:e.scrollWrappedButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.WRAPPED},close:!0},{element:e.spreadNoneButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.NONE},close:!0},{element:e.spreadOddButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.ODD},close:!0},{element:e.spreadEvenButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.EVEN},close:!0},{element:e.documentPropertiesButton,eventName:"documentproperties",close:!0}];this.items={firstPage:e.firstPageButton,lastPage:e.lastPageButton,pageRotateCw:e.pageRotateCwButton,pageRotateCcw:e.pageRotateCcwButton};this.mainContainer=t;this.eventBus=i;this.opened=!1;this.containerHeight=null;this.previousContainerHeight=null;this.reset();this._bindClickListeners();this._bindCursorToolsListener(e);this._bindScrollModeListener(e);this._bindSpreadModeListener(e);this.eventBus._on("resize",this._setMaxHeight.bind(this));this.eventBus._on("baseviewerinit",(e=>{e.source instanceof r.PDFSinglePageViewer?this.toolbarButtonContainer.classList.add("hiddenScrollModeButtons","hiddenSpreadModeButtons"):this.toolbarButtonContainer.classList.remove("hiddenScrollModeButtons","hiddenSpreadModeButtons")}))}get isOpen(){return this.opened}setPageNumber(e){this.pageNumber=e;this._updateUIState()}setPagesCount(e){this.pagesCount=e;this._updateUIState()}reset(){this.pageNumber=0;this.pagesCount=0;this._updateUIState();this.eventBus.dispatch("secondarytoolbarreset",{source:this})}_updateUIState(){this.items.firstPage.disabled=this.pageNumber<=1;this.items.lastPage.disabled=this.pageNumber>=this.pagesCount;this.items.pageRotateCw.disabled=0===this.pagesCount;this.items.pageRotateCcw.disabled=0===this.pagesCount}_bindClickListeners(){this.toggleButton.addEventListener("click",this.toggle.bind(this));for(const{element:e,eventName:t,close:i,eventDetails:n}of this.buttons)e.addEventListener("click",(e=>{if(null!==t){const e={source:this};for(const t in n)e[t]=n[t];this.eventBus.dispatch(t,e)}i&&this.close()}))}_bindCursorToolsListener(e){this.eventBus._on("cursortoolchanged",(function({tool:t}){e.cursorSelectToolButton.classList.toggle("toggled",t===s.CursorTool.SELECT);e.cursorHandToolButton.classList.toggle("toggled",t===s.CursorTool.HAND)}))}_bindScrollModeListener(e){function scrollModeChanged({mode:t}){e.scrollVerticalButton.classList.toggle("toggled",t===n.ScrollMode.VERTICAL);e.scrollHorizontalButton.classList.toggle("toggled",t===n.ScrollMode.HORIZONTAL);e.scrollWrappedButton.classList.toggle("toggled",t===n.ScrollMode.WRAPPED);const i=t===n.ScrollMode.HORIZONTAL;e.spreadNoneButton.disabled=i;e.spreadOddButton.disabled=i;e.spreadEvenButton.disabled=i}this.eventBus._on("scrollmodechanged",scrollModeChanged);this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&scrollModeChanged({mode:n.ScrollMode.VERTICAL})}))}_bindSpreadModeListener(e){function spreadModeChanged({mode:t}){e.spreadNoneButton.classList.toggle("toggled",t===n.SpreadMode.NONE);e.spreadOddButton.classList.toggle("toggled",t===n.SpreadMode.ODD);e.spreadEvenButton.classList.toggle("toggled",t===n.SpreadMode.EVEN)}this.eventBus._on("spreadmodechanged",spreadModeChanged);this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&spreadModeChanged({mode:n.SpreadMode.NONE})}))}open(){if(!this.opened){this.opened=!0;this._setMaxHeight();this.toggleButton.classList.add("toggled");this.toggleButton.setAttribute("aria-expanded","true");this.toolbar.classList.remove("hidden")}}close(){if(this.opened){this.opened=!1;this.toolbar.classList.add("hidden");this.toggleButton.classList.remove("toggled");this.toggleButton.setAttribute("aria-expanded","false")}}toggle(){this.opened?this.close():this.open()}_setMaxHeight(){if(this.opened){this.containerHeight=this.mainContainer.clientHeight;if(this.containerHeight!==this.previousContainerHeight){this.toolbarButtonContainer.style.maxHeight=this.containerHeight-n.SCROLLBAR_PADDING+"px";this.previousContainerHeight=this.containerHeight}}}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFSinglePageViewer=void 0;var n=i(28),s=i(5);class PDFSinglePageViewer extends n.BaseViewer{constructor(e){super(e);this.eventBus._on("pagesinit",(e=>{this._ensurePageViewVisible()}))}get _viewerElement(){return(0,s.shadow)(this,"_viewerElement",this._shadowViewer)}get _pageWidthScaleFactor(){return 1}_resetView(){super._resetView();this._previousPageNumber=1;this._shadowViewer=document.createDocumentFragment();this._updateScrollDown=null}_ensurePageViewVisible(){const e=this._pages[this._currentPageNumber-1],t=this._pages[this._previousPageNumber-1],i=this.viewer.childNodes;switch(i.length){case 0:this.viewer.appendChild(e.div);break;case 1:if(i[0]!==t.div)throw new Error("_ensurePageViewVisible: Unexpected previously visible page.");if(e===t)break;this._shadowViewer.appendChild(t.div);this.viewer.appendChild(e.div);this.container.scrollTop=0;break;default:throw new Error("_ensurePageViewVisible: Only one page should be visible at a time.")}this._previousPageNumber=this._currentPageNumber}_scrollUpdate(){this._updateScrollDown&&this._updateScrollDown();super._scrollUpdate()}_scrollIntoView({pageDiv:e,pageSpot:t=null,pageNumber:i=null}){i&&this._setCurrentPageNumber(i);const n=this._currentPageNumber>=this._previousPageNumber;this._ensurePageViewVisible();this.update();super._scrollIntoView({pageDiv:e,pageSpot:t,pageNumber:i});this._updateScrollDown=()=>{this.scroll.down=n;this._updateScrollDown=null}}_getVisiblePages(){return this._getCurrentVisiblePage()}_updateHelper(e){}get _isScrollModeHorizontal(){return(0,s.shadow)(this,"_isScrollModeHorizontal",!1)}_updateScrollMode(){}_updateSpreadMode(){}_getPageAdvance(){return 1}}t.PDFSinglePageViewer=PDFSinglePageViewer},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Toolbar=void 0;var n=i(4);t.Toolbar=class Toolbar{constructor(e,t,i){this.toolbar=e.container;this.eventBus=t;this.l10n=i;this.buttons=[{element:e.previous,eventName:"previouspage"},{element:e.next,eventName:"nextpage"},{element:e.zoomIn,eventName:"zoomin"},{element:e.zoomOut,eventName:"zoomout"},{element:e.openFile,eventName:"openfile"},{element:e.print,eventName:"print"},{element:e.presentationModeButton,eventName:"presentationmode"},{element:e.download,eventName:"download"},{element:e.viewBookmark,eventName:null}];this.items={numPages:e.numPages,pageNumber:e.pageNumber,scaleSelectContainer:e.scaleSelectContainer,scaleSelect:e.scaleSelect,customScaleOption:e.customScaleOption,previous:e.previous,next:e.next,zoomIn:e.zoomIn,zoomOut:e.zoomOut};this._wasLocalized=!1;this.reset();this._bindListeners()}setPageNumber(e,t){this.pageNumber=e;this.pageLabel=t;this._updateUIState(!1)}setPagesCount(e,t){this.pagesCount=e;this.hasPageLabels=t;this._updateUIState(!0)}setPageScale(e,t){this.pageScaleValue=(e||t).toString();this.pageScale=t;this._updateUIState(!1)}reset(){this.pageNumber=0;this.pageLabel=null;this.hasPageLabels=!1;this.pagesCount=0;this.pageScaleValue=n.DEFAULT_SCALE_VALUE;this.pageScale=n.DEFAULT_SCALE;this._updateUIState(!0);this.updateLoadingIndicatorState()}_bindListeners(){const{pageNumber:e,scaleSelect:t}=this.items,i=this;for(const{element:e,eventName:t}of this.buttons)e.addEventListener("click",(e=>{null!==t&&this.eventBus.dispatch(t,{source:this})}));e.addEventListener("click",(function(){this.select()}));e.addEventListener("change",(function(){i.eventBus.dispatch("pagenumberchanged",{source:i,value:this.value})}));t.addEventListener("change",(function(){"custom"!==this.value&&i.eventBus.dispatch("scalechanged",{source:i,value:this.value})}));t.addEventListener("click",(function(e){const t=e.target;this.value===i.pageScaleValue&&"OPTION"===t.tagName.toUpperCase()&&this.blur()}));t.oncontextmenu=n.noContextMenuHandler;this.eventBus._on("localized",(()=>{this._wasLocalized=!0;this._adjustScaleWidth();this._updateUIState(!0)}))}_updateUIState(e=!1){if(!this._wasLocalized)return;const{pageNumber:t,pagesCount:i,pageScaleValue:s,pageScale:r,items:a}=this;if(e){if(this.hasPageLabels)a.pageNumber.type="text";else{a.pageNumber.type="number";this.l10n.get("of_pages",{pagesCount:i}).then((e=>{a.numPages.textContent=e}))}a.pageNumber.max=i}if(this.hasPageLabels){a.pageNumber.value=this.pageLabel;this.l10n.get("page_of_pages",{pageNumber:t,pagesCount:i}).then((e=>{a.numPages.textContent=e}))}else a.pageNumber.value=t;a.previous.disabled=t<=1;a.next.disabled=t>=i;a.zoomOut.disabled=r<=n.MIN_SCALE;a.zoomIn.disabled=r>=n.MAX_SCALE;this.l10n.get("page_scale_percent",{scale:Math.round(1e4*r)/100}).then((e=>{let t=!1;for(const e of a.scaleSelect.options)if(e.value===s){e.selected=!0;t=!0}else e.selected=!1;if(!t){a.customScaleOption.textContent=e;a.customScaleOption.selected=!0}}))}updateLoadingIndicatorState(e=!1){this.items.pageNumber.classList.toggle("visiblePageIsLoading",e)}async _adjustScaleWidth(){const{items:e,l10n:t}=this,i=Promise.all([t.get("page_scale_auto"),t.get("page_scale_actual"),t.get("page_scale_fit"),t.get("page_scale_width")]);let s=document.createElement("canvas");s.mozOpaque=!0;let r=s.getContext("2d",{alpha:!1});await n.animationStarted;const{fontSize:a,fontFamily:o}=getComputedStyle(e.scaleSelect);r.font=`${a} ${o}`;let l=0;for(const e of await i){const{width:t}=r.measureText(e);t>l&&(l=t)}l+=44;if(l>140){e.scaleSelect.style.width=`${l+22}px`;e.scaleSelectContainer.style.width=`${l}px`}s.width=0;s.height=0;s=r=null}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ViewHistory=void 0;t.ViewHistory=class ViewHistory{constructor(e,t=20){this.fingerprint=e;this.cacheSize=t;this._initializedPromise=this._readFromStorage().then((e=>{const t=JSON.parse(e||"{}");let i=-1;if(Array.isArray(t.files)){for(;t.files.length>=this.cacheSize;)t.files.shift();for(let e=0,n=t.files.length;e<n;e++){if(t.files[e].fingerprint===this.fingerprint){i=e;break}}}else t.files=[];-1===i&&(i=t.files.push({fingerprint:this.fingerprint})-1);this.file=t.files[i];this.database=t}))}async _writeToStorage(){const e=JSON.stringify(this.database);localStorage.setItem("pdfjs.history",e)}async _readFromStorage(){return localStorage.getItem("pdfjs.history")}async set(e,t){await this._initializedPromise;this.file[e]=t;return this._writeToStorage()}async setMultiple(e){await this._initializedPromise;for(const t in e)this.file[t]=e[t];return this._writeToStorage()}async get(e,t){await this._initializedPromise;const i=this.file[e];return void 0!==i?i:t}async getMultiple(e){await this._initializedPromise;const t=Object.create(null);for(const i in e){const n=this.file[i];t[i]=void 0!==n?n:e[i]}return t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GenericCom=void 0;var n=i(3),s=i(40),r=i(41),a=i(42),o=i(44);t.GenericCom={};class GenericPreferences extends s.BasePreferences{async _writeToStorage(e){localStorage.setItem("pdfjs.preferences",JSON.stringify(e))}async _readFromStorage(e){return JSON.parse(localStorage.getItem("pdfjs.preferences"))}}class GenericExternalServices extends n.DefaultExternalServices{static createDownloadManager(e){return new r.DownloadManager}static createPreferences(){return new GenericPreferences}static createL10n({locale:e="en-US"}){return new a.GenericL10n(e)}static createScripting({sandboxBundleSrc:e}){return new o.GenericScripting(e)}}n.PDFViewerApplication.externalServices=GenericExternalServices},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.BasePreferences=void 0;i(1);class BasePreferences{constructor(){if(this.constructor===BasePreferences)throw new Error("Cannot initialize BasePreferences.");Object.defineProperty(this,"defaults",{value:Object.freeze({cursorToolOnLoad:0,defaultZoomValue:"",disablePageLabels:!1,enablePermissions:!1,enablePrintAutoRotate:!0,enableScripting:!0,externalLinkTarget:0,historyUpdateUrl:!1,ignoreDestinationZoom:!1,pdfBugEnabled:!1,renderer:"canvas",renderInteractiveForms:!0,sidebarViewOnLoad:-1,scrollModeOnLoad:-1,spreadModeOnLoad:-1,textLayerMode:1,useOnlyCssZoom:!1,viewerCssTheme:0,viewOnLoad:0,disableAutoFetch:!1,disableFontFace:!1,disableRange:!1,disableStream:!1,enableXfa:!1}),writable:!1,enumerable:!0,configurable:!1});this.prefs=Object.create(null);this._initializedPromise=this._readFromStorage(this.defaults).then((e=>{for(const t in this.defaults){const i=e?.[t];typeof i==typeof this.defaults[t]&&(this.prefs[t]=i)}}))}async _writeToStorage(e){throw new Error("Not implemented: _writeToStorage")}async _readFromStorage(e){throw new Error("Not implemented: _readFromStorage")}async reset(){await this._initializedPromise;this.prefs=Object.create(null);return this._writeToStorage(this.defaults)}async set(e,t){await this._initializedPromise;const i=this.defaults[e];if(void 0===i)throw new Error(`Set preference: "${e}" is undefined.`);if(void 0===t)throw new Error("Set preference: no value is specified.");const n=typeof t,s=typeof i;if(n!==s){if("number"!==n||"string"!==s)throw new Error(`Set preference: "${t}" is a ${n}, expected a ${s}.`);t=t.toString()}else if("number"===n&&!Number.isInteger(t))throw new Error(`Set preference: "${t}" must be an integer.`);this.prefs[e]=t;return this._writeToStorage(this.prefs)}async get(e){await this._initializedPromise;const t=this.defaults[e],i=this.prefs[e];if(void 0===t)throw new Error(`Get preference: "${e}" is undefined.`);return void 0!==i?i:t}async getAll(){await this._initializedPromise;const e=Object.create(null);for(const t in this.defaults){const i=this.prefs[t];e[t]=void 0!==i?i:this.defaults[t]}return e}}t.BasePreferences=BasePreferences},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.DownloadManager=void 0;var n=i(5),s=i(2);function download(e,t){const i=document.createElement("a");if(!i.click)throw new Error('DownloadManager: "a.click()" is not supported.');i.href=e;i.target="_parent";"download"in i&&(i.download=t);(document.body||document.documentElement).appendChild(i);i.click();i.remove()}t.DownloadManager=class DownloadManager{constructor(){this._openBlobUrls=new WeakMap}downloadUrl(e,t){(0,n.createValidAbsoluteUrl)(e,"http://example.com")&&download(e+"#pdfjs.action=download",t)}downloadData(e,t,i){download((0,n.createObjectURL)(e,i,s.viewerCompatibilityParams.disableCreateObjectURL),t)}openOrDownloadData(e,t,i){const r=(0,n.isPdfFile)(i),a=r?"application/pdf":"";if(r&&!s.viewerCompatibilityParams.disableCreateObjectURL){let n,s=this._openBlobUrls.get(e);if(!s){s=URL.createObjectURL(new Blob([t],{type:a}));this._openBlobUrls.set(e,s)}n="?file="+encodeURIComponent(s+"#"+i);try{window.open(n);return!0}catch(t){console.error(`openOrDownloadData: ${t}`);URL.revokeObjectURL(s);this._openBlobUrls.delete(e)}}this.downloadData(t,i,a);return!1}download(e,t,i,n="download"){if(s.viewerCompatibilityParams.disableCreateObjectURL){this.downloadUrl(t,i);return}download(URL.createObjectURL(e),i)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.GenericL10n=void 0;i(43);var n=i(30);const s=document.webL10n;t.GenericL10n=class GenericL10n{constructor(e){this._lang=e;this._ready=new Promise(((t,i)=>{s.setLanguage(e,(()=>{t(s)}))}))}async getLanguage(){return(await this._ready).getLanguage()}async getDirection(){return(await this._ready).getDirection()}async get(e,t=null,i=(0,n.getL10nFallback)(e,t)){return(await this._ready).get(e,t,i)}async translate(e){return(await this._ready).translate(e)}}},()=>{document.webL10n=function(e,t,i){var n={},s="",r="textContent",a="",o={},l="loading";function xhrLoadText(e,t,i){t=t||function _onSuccess(e){};i=i||function _onFailure(){};var n=new XMLHttpRequest;n.open("GET",e,true);n.overrideMimeType&&n.overrideMimeType("text/plain; charset=utf-8");n.onreadystatechange=function(){4==n.readyState&&(200==n.status||0===n.status?t(n.responseText):i())};n.onerror=i;n.ontimeout=i;try{n.send(null)}catch(e){i()}}function parseResource(e,t,i,a){var o=e.replace(/[^\/]*$/,"")||"./";function evalString(e){return e.lastIndexOf("\\")<0?e:e.replace(/\\\\/g,"\\").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\b/g,"\b").replace(/\\f/g,"\f").replace(/\\{/g,"{").replace(/\\}/g,"}").replace(/\\"/g,'"').replace(/\\'/g,"'")}xhrLoadText(e,(function(e){s+=e;!function parseProperties(e,i){var n={},s=/^\s*|\s*$/,r=/^\s*#|^\s*$/,a=/^\s*\[(.*)\]\s*$/,l=/^\s*@import\s+url\((.*)\)\s*$/i,c=/^([^=\s]*)\s*=\s*(.+)$/;function parseRawLines(e,i,h){var d=e.replace(s,"").split(/[\r\n]+/),u="*",p=t.split("-",1)[0],g=!1,f="";!function nextEntry(){for(;;){if(!d.length){h();return}var e=d.shift();if(!r.test(e)){if(i){if(f=a.exec(e)){u=f[1].toLowerCase();g="*"!==u&&u!==t&&u!==p;continue}if(g)continue;if(f=l.exec(e)){loadImport(o+f[1],nextEntry);return}}var s=e.match(c);s&&3==s.length&&(n[s[1]]=evalString(s[2]))}}}()}function loadImport(e,t){xhrLoadText(e,(function(e){parseRawLines(e,!1,t)}),(function(){console.warn(e+" not found.");t()}))}parseRawLines(e,!0,(function(){i(n)}))}(e,(function(e){for(var t in e){var s,a,o=t.lastIndexOf(".");if(o>0){s=t.substring(0,o);a=t.substring(o+1)}else{s=t;a=r}n[s]||(n[s]={});n[s][a]=e[t]}i&&i()}))}),a)}function loadLocale(e,i){e&&(e=e.toLowerCase());i=i||function _callback(){};!function clear(){n={};s="";a=""}();a=e;var r=function getL10nResourceLinks(){return t.querySelectorAll('link[type="application/l10n"]')}(),o=r.length;if(0!==o){var c,h=0;c=function(){if(++h>=o){i();l="complete"}};for(var d=0;d<o;d++){new L10nResourceLink(r[d]).load(e,c)}}else{var u=function getL10nDictionary(){var e=t.querySelector('script[type="application/l10n"]');return e?JSON.parse(e.innerHTML):null}();if(u&&u.locales&&u.default_locale){console.log("using the embedded JSON directory, early way out");if(!(n=u.locales[e])){var p=u.default_locale.toLowerCase();for(var g in u.locales){if((g=g.toLowerCase())===e){n=u.locales[e];break}g===p&&(n=u.locales[p])}}i()}else console.log("no resource to load, early way out");l="complete"}function L10nResourceLink(e){var t=e.href;this.load=function(e,i){parseResource(t,e,i,(function(){console.warn(t+" not found.");console.warn('"'+e+'" resource not found');a="";i()}))}}}o.plural=function(e,t,i,s){var l=parseFloat(t);if(isNaN(l))return e;if(s!=r)return e;o._pluralRules||(o._pluralRules=function getPluralRules(e){function isIn(e,t){return-1!==t.indexOf(e)}function isBetween(e,t,i){return t<=e&&e<=i}var t={0:function(e){return"other"},1:function(e){return isBetween(e%100,3,10)?"few":0===e?"zero":isBetween(e%100,11,99)?"many":2==e?"two":1==e?"one":"other"},2:function(e){return 0!==e&&e%10==0?"many":2==e?"two":1==e?"one":"other"},3:function(e){return 1==e?"one":"other"},4:function(e){return isBetween(e,0,1)?"one":"other"},5:function(e){return isBetween(e,0,2)&&2!=e?"one":"other"},6:function(e){return 0===e?"zero":e%10==1&&e%100!=11?"one":"other"},7:function(e){return 2==e?"two":1==e?"one":"other"},8:function(e){return isBetween(e,3,6)?"few":isBetween(e,7,10)?"many":2==e?"two":1==e?"one":"other"},9:function(e){return 0===e||1!=e&&isBetween(e%100,1,19)?"few":1==e?"one":"other"},10:function(e){return isBetween(e%10,2,9)&&!isBetween(e%100,11,19)?"few":e%10!=1||isBetween(e%100,11,19)?"other":"one"},11:function(e){return isBetween(e%10,2,4)&&!isBetween(e%100,12,14)?"few":e%10==0||isBetween(e%10,5,9)||isBetween(e%100,11,14)?"many":e%10==1&&e%100!=11?"one":"other"},12:function(e){return isBetween(e,2,4)?"few":1==e?"one":"other"},13:function(e){return isBetween(e%10,2,4)&&!isBetween(e%100,12,14)?"few":1!=e&&isBetween(e%10,0,1)||isBetween(e%10,5,9)||isBetween(e%100,12,14)?"many":1==e?"one":"other"},14:function(e){return isBetween(e%100,3,4)?"few":e%100==2?"two":e%100==1?"one":"other"},15:function(e){return 0===e||isBetween(e%100,2,10)?"few":isBetween(e%100,11,19)?"many":1==e?"one":"other"},16:function(e){return e%10==1&&11!=e?"one":"other"},17:function(e){return 3==e?"few":0===e?"zero":6==e?"many":2==e?"two":1==e?"one":"other"},18:function(e){return 0===e?"zero":isBetween(e,0,2)&&0!==e&&2!=e?"one":"other"},19:function(e){return isBetween(e,2,10)?"few":isBetween(e,0,1)?"one":"other"},20:function(e){return!isBetween(e%10,3,4)&&e%10!=9||isBetween(e%100,10,19)||isBetween(e%100,70,79)||isBetween(e%100,90,99)?e%1e6==0&&0!==e?"many":e%10!=2||isIn(e%100,[12,72,92])?e%10!=1||isIn(e%100,[11,71,91])?"other":"one":"two":"few"},21:function(e){return 0===e?"zero":1==e?"one":"other"},22:function(e){return isBetween(e,0,1)||isBetween(e,11,99)?"one":"other"},23:function(e){return isBetween(e%10,1,2)||e%20==0?"one":"other"},24:function(e){return isBetween(e,3,10)||isBetween(e,13,19)?"few":isIn(e,[2,12])?"two":isIn(e,[1,11])?"one":"other"}},i={af:3,ak:4,am:4,ar:1,asa:3,az:0,be:11,bem:3,bez:3,bg:3,bh:4,bm:0,bn:3,bo:0,br:20,brx:3,bs:11,ca:3,cgg:3,chr:3,cs:12,cy:17,da:3,de:3,dv:3,dz:0,ee:3,el:3,en:3,eo:3,es:3,et:3,eu:3,fa:0,ff:5,fi:3,fil:4,fo:3,fr:5,fur:3,fy:3,ga:8,gd:24,gl:3,gsw:3,gu:3,guw:4,gv:23,ha:3,haw:3,he:2,hi:4,hr:11,hu:0,id:0,ig:0,ii:0,is:3,it:3,iu:7,ja:0,jmc:3,jv:0,ka:0,kab:5,kaj:3,kcg:3,kde:0,kea:0,kk:3,kl:3,km:0,kn:0,ko:0,ksb:3,ksh:21,ku:3,kw:7,lag:18,lb:3,lg:3,ln:4,lo:0,lt:10,lv:6,mas:3,mg:4,mk:16,ml:3,mn:3,mo:9,mr:3,ms:0,mt:15,my:0,nah:3,naq:7,nb:3,nd:3,ne:3,nl:3,nn:3,no:3,nr:3,nso:4,ny:3,nyn:3,om:3,or:3,pa:3,pap:3,pl:13,ps:3,pt:3,rm:3,ro:9,rof:3,ru:11,rwk:3,sah:0,saq:3,se:7,seh:3,ses:0,sg:0,sh:11,shi:19,sk:12,sl:14,sma:7,smi:7,smj:7,smn:7,sms:7,sn:3,so:3,sq:3,sr:11,ss:3,ssy:3,st:3,sv:3,sw:3,syr:3,ta:3,te:3,teo:3,th:0,ti:4,tig:3,tk:3,tl:4,tn:3,to:0,tr:0,ts:3,tzm:22,uk:11,ur:3,ve:3,vi:0,vun:3,wa:4,wae:3,wo:0,xh:3,xog:3,yo:0,zh:0,zu:3}[e.replace(/-.*$/,"")];if(!(i in t)){console.warn("plural form unknown for ["+e+"]");return function(){return"other"}}return t[i]}(a));var c="["+o._pluralRules(l)+"]";0===l&&i+"[zero]"in n?e=n[i+"[zero]"][s]:1==l&&i+"[one]"in n?e=n[i+"[one]"][s]:2==l&&i+"[two]"in n?e=n[i+"[two]"][s]:i+c in n?e=n[i+c][s]:i+"[other]"in n&&(e=n[i+"[other]"][s]);return e};function getL10nData(e,t,i){var s=n[e];if(!s){console.warn("#"+e+" is undefined.");if(!i)return null;s=i}var r={};for(var a in s){var o=s[a];o=substArguments(o=substIndexes(o,t,e,a),t,e);r[a]=o}return r}function substIndexes(e,t,i,s){var r=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/.exec(e);if(!r||!r.length)return e;var a,l=r[1],c=r[2];t&&c in t?a=t[c]:c in n&&(a=n[c]);if(l in o){e=(0,o[l])(e,a,i,s)}return e}function substArguments(e,t,i){return e.replace(/\{\{\s*(.+?)\s*\}\}/g,(function(e,s){if(t&&s in t)return t[s];if(s in n)return n[s];console.log("argument {{"+s+"}} for #"+i+" is undefined.");return e}))}function translateElement(e){var i=function getL10nAttributes(e){if(!e)return{};var t=e.getAttribute("data-l10n-id"),i=e.getAttribute("data-l10n-args"),n={};if(i)try{n=JSON.parse(i)}catch(e){console.warn("could not parse arguments for #"+t)}return{id:t,args:n}}(e);if(i.id){var n=getL10nData(i.id,i.args);if(n){if(n[r]){if(0===function getChildElementCount(e){if(e.children)return e.children.length;if(void 0!==e.childElementCount)return e.childElementCount;for(var t=0,i=0;i<e.childNodes.length;i++)t+=1===e.nodeType?1:0;return t}(e))e[r]=n[r];else{for(var s=e.childNodes,a=!1,o=0,l=s.length;o<l;o++)if(3===s[o].nodeType&&/\S/.test(s[o].nodeValue))if(a)s[o].nodeValue="";else{s[o].nodeValue=n[r];a=!0}if(!a){var c=t.createTextNode(n[r]);e.insertBefore(c,e.firstChild)}}delete n[r]}for(var h in n)e[h]=n[h]}else console.warn("#"+i.id+" is undefined.")}}return{get:function(e,t,i){var n,s=e.lastIndexOf("."),a=r;if(s>0){a=e.substring(s+1);e=e.substring(0,s)}i&&((n={})[a]=i);var o=getL10nData(e,t,n);return o&&a in o?o[a]:"{{"+e+"}}"},getData:function(){return n},getText:function(){return s},getLanguage:function(){return a},setLanguage:function(e,t){loadLocale(e,(function(){t&&t()}))},getDirection:function(){var e=a.split("-",1)[0];return["ar","he","fa","ps","ur"].indexOf(e)>=0?"rtl":"ltr"},translate:function translateFragment(e){for(var i=function getTranslatableChildren(e){return e?e.querySelectorAll("*[data-l10n-id]"):[]}(e=e||t.documentElement),n=i.length,s=0;s<n;s++)translateElement(i[s]);translateElement(e)},getReadyState:function(){return l},ready:function(i){i&&("complete"==l||"interactive"==l?e.setTimeout((function(){i()})):t.addEventListener&&t.addEventListener("localized",(function once(){t.removeEventListener("localized",once);i()})))}}}(window,document)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.docPropertiesLookup=async function docPropertiesLookup(e){const t="".split("#")[0];let{info:i,metadata:s,contentDispositionFilename:r,contentLength:a}=await e.getMetadata();if(!a){const{length:t}=await e.getDownloadInfo();a=t}return{...i,baseURL:t,filesize:a,filename:r||(0,n.getPdfFilenameFromUrl)(""),metadata:s?.getRaw(),authors:s?.get("dc:creator"),numPages:e.numPages,URL:""}};t.GenericScripting=void 0;var n=i(5);t.GenericScripting=class GenericScripting{constructor(e){this._ready=(0,n.loadScript)(e,!0).then((()=>window.pdfjsSandbox.QuickJSSandbox()))}async createSandbox(e){(await this._ready).create(e)}async dispatchEventInSandbox(e){(await this._ready).dispatchEvent(e)}async destroySandbox(){(await this._ready).nukeSandbox()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFPrintService=PDFPrintService;var n=i(3),s=i(2);let r=null,a=null;function PDFPrintService(e,t,i,n,s=null,r){this.pdfDocument=e;this.pagesOverview=t;this.printContainer=i;this._printResolution=n||150;this._optionalContentConfigPromise=s||e.getOptionalContentConfig();this.l10n=r;this.currentPage=-1;this.scratchCanvas=document.createElement("canvas")}PDFPrintService.prototype={layout(){this.throwIfInactive();const e=document.querySelector("body");e.setAttribute("data-pdfjsprinting",!0);this.pagesOverview.every((function(e){return e.width===this.pagesOverview[0].width&&e.height===this.pagesOverview[0].height}),this)||console.warn("Not all pages have the same size. The printed result may be incorrect!");this.pageStyleSheet=document.createElement("style");const t=this.pagesOverview[0];this.pageStyleSheet.textContent="@page { size: "+t.width+"pt "+t.height+"pt;}";e.appendChild(this.pageStyleSheet)},destroy(){if(r!==this)return;this.printContainer.textContent="";document.querySelector("body").removeAttribute("data-pdfjsprinting");if(this.pageStyleSheet){this.pageStyleSheet.remove();this.pageStyleSheet=null}this.scratchCanvas.width=this.scratchCanvas.height=0;this.scratchCanvas=null;r=null;ensureOverlay().then((function(){"printServiceOverlay"===a.active&&a.close("printServiceOverlay")}))},renderPages(){const e=this.pagesOverview.length,renderNextPage=(t,i)=>{this.throwIfInactive();if(++this.currentPage>=e){renderProgress(e,e,this.l10n);t();return}const n=this.currentPage;renderProgress(n,e,this.l10n);(function renderPage(e,t,i,n,s,a){const o=r.scratchCanvas,l=s/72;o.width=Math.floor(n.width*l);o.height=Math.floor(n.height*l);const c=o.getContext("2d");c.save();c.fillStyle="rgb(255, 255, 255)";c.fillRect(0,0,o.width,o.height);c.restore();return t.getPage(i).then((function(e){const t={canvasContext:c,transform:[l,0,0,l,0,0],viewport:e.getViewport({scale:1,rotation:n.rotation}),intent:"print",includeAnnotationStorage:!0,optionalContentConfigPromise:a};return e.render(t).promise}))})(0,this.pdfDocument,n+1,this.pagesOverview[n],this._printResolution,this._optionalContentConfigPromise).then(this.useRenderedPage.bind(this)).then((function(){renderNextPage(t,i)}),i)};return new Promise(renderNextPage)},useRenderedPage(){this.throwIfInactive();const e=document.createElement("img"),t=this.scratchCanvas;"toBlob"in t&&!s.viewerCompatibilityParams.disableCreateObjectURL?t.toBlob((function(t){e.src=URL.createObjectURL(t)})):e.src=t.toDataURL();const i=document.createElement("div");i.appendChild(e);this.printContainer.appendChild(i);return new Promise((function(t,i){e.onload=t;e.onerror=i}))},performPrint(){this.throwIfInactive();return new Promise((e=>{setTimeout((()=>{if(this.active){o.call(window);setTimeout(e,20)}else e()}),0)}))},get active(){return this===r},throwIfInactive(){if(!this.active)throw new Error("This print request was cancelled or completed.")}};const o=window.print;window.print=function(){if(r)console.warn("Ignored window.print() because of a pending print job.");else{ensureOverlay().then((function(){r&&a.open("printServiceOverlay")}));try{dispatchEvent("beforeprint")}finally{if(!r){console.error("Expected print service to be initialized.");ensureOverlay().then((function(){"printServiceOverlay"===a.active&&a.close("printServiceOverlay")}));return}const e=r;r.renderPages().then((function(){return e.performPrint()})).catch((function(){})).then((function(){e.active&&abort()}))}}};function dispatchEvent(e){const t=document.createEvent("CustomEvent");t.initCustomEvent(e,!1,!1,"custom");window.dispatchEvent(t)}function abort(){if(r){r.destroy();dispatchEvent("afterprint")}}function renderProgress(e,t,i){const n=document.getElementById("printServiceOverlay"),s=Math.round(100*e/t),r=n.querySelector("progress"),a=n.querySelector(".relative-progress");r.value=s;i.get("print_progress_percent",{progress:s}).then((e=>{a.textContent=e}))}window.addEventListener("keydown",(function(e){if(80===e.keyCode&&(e.ctrlKey||e.metaKey)&&!e.altKey&&(!e.shiftKey||window.chrome||window.opera)){window.print();e.preventDefault();e.stopImmediatePropagation?e.stopImmediatePropagation():e.stopPropagation()}}),!0);if("onbeforeprint"in window){const stopPropagationIfNeeded=function(e){"custom"!==e.detail&&e.stopImmediatePropagation&&e.stopImmediatePropagation()};window.addEventListener("beforeprint",stopPropagationIfNeeded);window.addEventListener("afterprint",stopPropagationIfNeeded)}let l;function ensureOverlay(){if(!l){a=n.PDFViewerApplication.overlayManager;if(!a)throw new Error("The overlay manager has not yet been initialized.");l=a.register("printServiceOverlay",document.getElementById("printServiceOverlay"),abort,!0);document.getElementById("printCancel").onclick=abort}return l}n.PDFPrintServiceFactory.instance={supportsPrinting:!0,createPrintService(e,t,i,n,s,a){if(r)throw new Error("The print service is created and active.");r=new PDFPrintService(e,t,i,n,s,a);return r}}}],t={};function __webpack_require__(i){var n=t[i];if(void 0!==n)return n.exports;var s=t[i]={exports:{}};e[i](s,s.exports,__webpack_require__);return s.exports}var i={};(()=>{var e=i;Object.defineProperty(e,"__esModule",{value:!0});Object.defineProperty(e,"PDFViewerApplicationOptions",{enumerable:!0,get:function(){return t.AppOptions}});Object.defineProperty(e,"PDFViewerApplication",{enumerable:!0,get:function(){return n.PDFViewerApplication}});var t=__webpack_require__(1),n=__webpack_require__(3);window.PDFViewerApplication=n.PDFViewerApplication;window.PDFViewerApplicationOptions=t.AppOptions;__webpack_require__(39);__webpack_require__(45);function webViewerLoad(){const e=function getViewerConfiguration(){let e=null;e={container:document.getElementById("errorWrapper"),errorMessage:document.getElementById("errorMessage"),closeButton:document.getElementById("errorClose"),errorMoreInfo:document.getElementById("errorMoreInfo"),moreInfoButton:document.getElementById("errorShowMore"),lessInfoButton:document.getElementById("errorShowLess")};return{appContainer:document.body,mainContainer:document.getElementById("viewerContainer"),viewerContainer:document.getElementById("viewer"),eventBus:null,toolbar:{container:document.getElementById("toolbarViewer"),numPages:document.getElementById("numPages"),pageNumber:document.getElementById("pageNumber"),scaleSelectContainer:document.getElementById("scaleSelectContainer"),scaleSelect:document.getElementById("scaleSelect"),customScaleOption:document.getElementById("customScaleOption"),previous:document.getElementById("previous"),next:document.getElementById("next"),zoomIn:document.getElementById("zoomIn"),zoomOut:document.getElementById("zoomOut"),viewFind:document.getElementById("viewFind"),openFile:document.getElementById("openFile"),print:document.getElementById("print"),presentationModeButton:document.getElementById("presentationMode"),download:document.getElementById("download"),viewBookmark:document.getElementById("viewBookmark")},secondaryToolbar:{toolbar:document.getElementById("secondaryToolbar"),toggleButton:document.getElementById("secondaryToolbarToggle"),toolbarButtonContainer:document.getElementById("secondaryToolbarButtonContainer"),presentationModeButton:document.getElementById("secondaryPresentationMode"),openFileButton:document.getElementById("secondaryOpenFile"),printButton:document.getElementById("secondaryPrint"),downloadButton:document.getElementById("secondaryDownload"),viewBookmarkButton:document.getElementById("secondaryViewBookmark"),firstPageButton:document.getElementById("firstPage"),lastPageButton:document.getElementById("lastPage"),pageRotateCwButton:document.getElementById("pageRotateCw"),pageRotateCcwButton:document.getElementById("pageRotateCcw"),cursorSelectToolButton:document.getElementById("cursorSelectTool"),cursorHandToolButton:document.getElementById("cursorHandTool"),scrollVerticalButton:document.getElementById("scrollVertical"),scrollHorizontalButton:document.getElementById("scrollHorizontal"),scrollWrappedButton:document.getElementById("scrollWrapped"),spreadNoneButton:document.getElementById("spreadNone"),spreadOddButton:document.getElementById("spreadOdd"),spreadEvenButton:document.getElementById("spreadEven"),documentPropertiesButton:document.getElementById("documentProperties")},sidebar:{outerContainer:document.getElementById("outerContainer"),viewerContainer:document.getElementById("viewerContainer"),toggleButton:document.getElementById("sidebarToggle"),thumbnailButton:document.getElementById("viewThumbnail"),outlineButton:document.getElementById("viewOutline"),attachmentsButton:document.getElementById("viewAttachments"),layersButton:document.getElementById("viewLayers"),thumbnailView:document.getElementById("thumbnailView"),outlineView:document.getElementById("outlineView"),attachmentsView:document.getElementById("attachmentsView"),layersView:document.getElementById("layersView"),outlineOptionsContainer:document.getElementById("outlineOptionsContainer"),currentOutlineItemButton:document.getElementById("currentOutlineItem")},sidebarResizer:{outerContainer:document.getElementById("outerContainer"),resizer:document.getElementById("sidebarResizer")},findBar:{bar:document.getElementById("findbar"),toggleButton:document.getElementById("viewFind"),findField:document.getElementById("findInput"),highlightAllCheckbox:document.getElementById("findHighlightAll"),caseSensitiveCheckbox:document.getElementById("findMatchCase"),entireWordCheckbox:document.getElementById("findEntireWord"),findMsg:document.getElementById("findMsg"),findResultsCount:document.getElementById("findResultsCount"),findPreviousButton:document.getElementById("findPrevious"),findNextButton:document.getElementById("findNext")},passwordOverlay:{overlayName:"passwordOverlay",container:document.getElementById("passwordOverlay"),label:document.getElementById("passwordText"),input:document.getElementById("password"),submitButton:document.getElementById("passwordSubmit"),cancelButton:document.getElementById("passwordCancel")},documentProperties:{overlayName:"documentPropertiesOverlay",container:document.getElementById("documentPropertiesOverlay"),closeButton:document.getElementById("documentPropertiesClose"),fields:{fileName:document.getElementById("fileNameField"),fileSize:document.getElementById("fileSizeField"),title:document.getElementById("titleField"),author:document.getElementById("authorField"),subject:document.getElementById("subjectField"),keywords:document.getElementById("keywordsField"),creationDate:document.getElementById("creationDateField"),modificationDate:document.getElementById("modificationDateField"),creator:document.getElementById("creatorField"),producer:document.getElementById("producerField"),version:document.getElementById("versionField"),pageCount:document.getElementById("pageCountField"),pageSize:document.getElementById("pageSizeField"),linearized:document.getElementById("linearizedField")}},errorWrapper:e,printContainer:document.getElementById("printContainer"),openFileInputName:"fileInput",debuggerScriptPath:"./debugger.js"}}(),t=document.createEvent("CustomEvent");t.initCustomEvent("webviewerloaded",!0,!0,{source:window});try{parent.document.dispatchEvent(t)}catch(e){console.error(`webviewerloaded: ${e}`);document.dispatchEvent(t)}n.PDFViewerApplication.run(e)}document.blockUnblockOnload&&document.blockUnblockOnload(!0);"interactive"===document.readyState||"complete"===document.readyState?webViewerLoad():document.addEventListener("DOMContentLoaded",webViewerLoad,!0)})()})();