/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!function webpackUniversalModuleDefinition(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf.worker",[],t):"object"==typeof exports?exports["pdfjs-dist/build/pdf.worker"]=t():e["pdfjs-dist/build/pdf.worker"]=e.pdfjsWorker=t()}(this,(function(){return(()=>{"use strict";var e=[,(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.WorkerTask=t.WorkerMessageHandler=void 0;var a=r(2),i=r(5),n=r(6),s=r(48),o=r(4),c=r(69),l=r(70),h=r(8);class WorkerTask{constructor(e){this.name=e;this.terminated=!1;this._capability=(0,a.createPromiseCapability)()}get finished(){return this._capability.promise}finish(){this._capability.resolve()}terminate(){this.terminated=!0}ensureNotTerminated(){if(this.terminated)throw new Error("Worker task was terminated")}}t.WorkerTask=WorkerTask;class WorkerMessageHandler{static setup(e,t){var r=!1;e.on("test",(function wphSetupTest(t){if(r)return;r=!0;if(!(t instanceof Uint8Array)){e.send("test",null);return}const a=255===t[0];e.postMessageTransfers=a;e.send("test",{supportTransfers:a})}));e.on("configure",(function wphConfigure(e){(0,a.setVerbosityLevel)(e.verbosity)}));e.on("GetDocRequest",(function wphSetupDoc(e){return WorkerMessageHandler.createDocumentHandler(e,t)}))}static createDocumentHandler(e,t){var r,o=!1,u=null,d=[];const f=(0,a.getVerbosityLevel)(),g=e.apiVersion,p="2.8.335";if(g!==p)throw new Error(`The API version "${g}" does not match the Worker version "2.8.335".`);const m=[];for(const e in[])m.push(e);if(m.length)throw new Error("The `Array.prototype` contains unexpected enumerable properties: "+m.join(", ")+"; thus breaking e.g. `for...in` iteration of `Array`s.");if("undefined"==typeof ReadableStream)throw new Error("The browser/environment lacks native support for critical functionality used by the PDF.js library (e.g. `ReadableStream`); please use a `legacy`-build instead.");var b=e.docId,y=e.docBaseUrl,w=e.docId+"_worker",S=new c.MessageHandler(w,b,t);S.postMessageTransfers=e.postMessageTransfers;function ensureNotTerminated(){if(o)throw new Error("Worker was terminated")}function startWorkerTask(e){d.push(e)}function finishWorkerTask(e){e.finish();var t=d.indexOf(e);d.splice(t,1)}async function loadDocument(e){await r.ensureDoc("checkHeader");await r.ensureDoc("parseStartXRef");await r.ensureDoc("parse",[e]);e||await r.ensureDoc("checkFirstPage");const[t,a,i]=await Promise.all([r.ensureDoc("numPages"),r.ensureDoc("fingerprint"),r.ensureDoc("isPureXfa")]);return{numPages:t,fingerprint:a,isPureXfa:i}}function getPdfManager(e,t,r){var i=(0,a.createPromiseCapability)();let s;var o=e.source;if(o.data){try{s=new n.LocalPdfManager(b,o.data,o.password,t,r,y);i.resolve(s)}catch(e){i.reject(e)}return i.promise}var c,h=[];try{c=new l.PDFWorkerStream(S)}catch(e){i.reject(e);return i.promise}var d=c.getFullReader();d.headersReady.then((function(){if(d.isRangeSupported){var e=o.disableAutoFetch||d.isStreamingSupported;s=new n.NetworkPdfManager(b,c,{msgHandler:S,password:o.password,length:d.contentLength,disableAutoFetch:e,rangeChunkSize:o.rangeChunkSize},t,r,y);for(let e=0;e<h.length;e++)s.sendProgressiveData(h[e]);h=[];i.resolve(s);u=null}})).catch((function(e){i.reject(e);u=null}));var f=0;new Promise((function(e,c){var readChunk=function({value:e,done:l}){try{ensureNotTerminated();if(l){s||function(){var e=(0,a.arraysToBytes)(h);o.length&&e.length!==o.length&&(0,a.warn)("reported HTTP length is different from actual");try{s=new n.LocalPdfManager(b,e,o.password,t,r,y);i.resolve(s)}catch(e){i.reject(e)}h=[]}();u=null;return}f+=(0,a.arrayByteLength)(e);d.isStreamingSupported||S.send("DocProgress",{loaded:f,total:Math.max(f,d.contentLength||0)});s?s.sendProgressiveData(e):h.push(e);d.read().then(readChunk,c)}catch(e){c(e)}};d.read().then(readChunk,c)})).catch((function(e){i.reject(e);u=null}));u=function(e){c.cancelAllRequests(e)};return i.promise}S.on("GetPage",(function wphSetupGetPage(e){return r.getPage(e.pageIndex).then((function(e){return Promise.all([r.ensure(e,"rotate"),r.ensure(e,"ref"),r.ensure(e,"userUnit"),r.ensure(e,"view")]).then((function([e,t,r,a]){return{rotate:e,ref:t,userUnit:r,view:a}}))}))}));S.on("GetPageIndex",(function wphSetupGetPageIndex({ref:e}){const t=i.Ref.get(e.num,e.gen);return r.ensureCatalog("getPageIndex",[t])}));S.on("GetDestinations",(function wphSetupGetDestinations(e){return r.ensureCatalog("destinations")}));S.on("GetDestination",(function wphSetupGetDestination(e){return r.ensureCatalog("getDestination",[e.id])}));S.on("GetPageLabels",(function wphSetupGetPageLabels(e){return r.ensureCatalog("pageLabels")}));S.on("GetPageLayout",(function wphSetupGetPageLayout(e){return r.ensureCatalog("pageLayout")}));S.on("GetPageMode",(function wphSetupGetPageMode(e){return r.ensureCatalog("pageMode")}));S.on("GetViewerPreferences",(function(e){return r.ensureCatalog("viewerPreferences")}));S.on("GetOpenAction",(function(e){return r.ensureCatalog("openAction")}));S.on("GetAttachments",(function wphSetupGetAttachments(e){return r.ensureCatalog("attachments")}));S.on("GetJavaScript",(function wphSetupGetJavaScript(e){return r.ensureCatalog("javaScript")}));S.on("GetDocJSActions",(function wphSetupGetDocJSActions(e){return r.ensureCatalog("jsActions")}));S.on("GetPageJSActions",(function({pageIndex:e}){return r.getPage(e).then((function(e){return e.jsActions}))}));S.on("GetPageXfa",(function wphSetupGetXfa({pageIndex:e}){return r.getPage(e).then((function(e){return r.ensure(e,"xfaData")}))}));S.on("GetIsPureXfa",(function wphSetupGetIsPureXfa(e){return r.ensureDoc("isPureXfa")}));S.on("GetOutline",(function wphSetupGetOutline(e){return r.ensureCatalog("documentOutline")}));S.on("GetOptionalContentConfig",(function(e){return r.ensureCatalog("optionalContentConfig")}));S.on("GetPermissions",(function(e){return r.ensureCatalog("permissions")}));S.on("GetMetadata",(function wphSetupGetMetadata(e){return Promise.all([r.ensureDoc("documentInfo"),r.ensureCatalog("metadata")])}));S.on("GetMarkInfo",(function wphSetupGetMarkInfo(e){return r.ensureCatalog("markInfo")}));S.on("GetData",(function wphSetupGetData(e){r.requestLoadedStream();return r.onLoadedStream().then((function(e){return e.bytes}))}));S.on("GetStats",(function wphSetupGetStats(e){return r.ensureXRef("stats")}));S.on("GetAnnotations",(function({pageIndex:e,intent:t}){return r.getPage(e).then((function(e){return e.getAnnotationsData(t)}))}));S.on("GetFieldObjects",(function(e){return r.ensureDoc("fieldObjects")}));S.on("HasJSActions",(function(e){return r.ensureDoc("hasJSActions")}));S.on("GetCalculationOrderIds",(function(e){return r.ensureDoc("calculationOrderIds")}));S.on("SaveDocument",(function({numPages:e,annotationStorage:t,filename:n}){r.requestLoadedStream();const o=[r.onLoadedStream(),r.ensureCatalog("acroForm"),r.ensureDoc("xref"),r.ensureDoc("startXRef")];for(let a=0;a<e;a++)o.push(r.getPage(a).then((function(e){const r=new WorkerTask(`Save: page ${a}`);startWorkerTask(r);return e.save(S,r,t).finally((function(){finishWorkerTask(r)}))})));return Promise.all(o).then((function([e,t,r,o,...c]){let l=[];for(const e of c)l=e.filter((e=>null!==e)).reduce(((e,t)=>e.concat(t)),l);if(0===l.length)return e.bytes;const h=t instanceof i.Dict&&t.get("XFA")||[];let u=null;if(Array.isArray(h))for(let e=0,t=h.length;e<t;e+=2)"datasets"===h[e]&&(u=h[e+1]);else(0,a.warn)("Unsupported XFA type.");let d=Object.create(null);if(r.trailer){const e=Object.create(null),t=r.trailer.get("Info")||null;t instanceof i.Dict&&t.forEach(((t,r)=>{(0,a.isString)(t)&&(0,a.isString)(r)&&(e[t]=(0,a.stringToPDFString)(r))}));d={rootRef:r.trailer.getRaw("Root")||null,encrypt:r.trailer.getRaw("Encrypt")||null,newRef:r.getNewRef(),infoRef:r.trailer.getRaw("Info")||null,info:e,fileIds:r.trailer.getRaw("ID")||null,startXRef:o,filename:n}}r.resetNewRef();return(0,s.incrementalUpdate)({originalData:e.bytes,xrefInfo:d,newRefs:l,xref:r,datasetsRef:u})}))}));S.on("GetOperatorList",(function wphSetupRenderPage(e,t){var i=e.pageIndex;r.getPage(i).then((function(r){var n=new WorkerTask(`GetOperatorList: page ${i}`);startWorkerTask(n);const s=f>=a.VerbosityLevel.INFOS?Date.now():0;r.getOperatorList({handler:S,sink:t,task:n,intent:e.intent,renderInteractiveForms:e.renderInteractiveForms,annotationStorage:e.annotationStorage}).then((function(e){finishWorkerTask(n);s&&(0,a.info)(`page=${i+1} - getOperatorList: time=${Date.now()-s}ms, len=${e.length}`);t.close()}),(function(e){finishWorkerTask(n);if(!n.terminated){S.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorOperatorList});t.error(e)}}))}))}));S.on("GetTextContent",(function wphExtractText(e,t){var i=e.pageIndex;t.onPull=function(e){};t.onCancel=function(e){};r.getPage(i).then((function(r){var n=new WorkerTask("GetTextContent: page "+i);startWorkerTask(n);const s=f>=a.VerbosityLevel.INFOS?Date.now():0;r.extractTextContent({handler:S,task:n,sink:t,normalizeWhitespace:e.normalizeWhitespace,combineTextItems:e.combineTextItems}).then((function(){finishWorkerTask(n);s&&(0,a.info)(`page=${i+1} - getTextContent: time=`+(Date.now()-s)+"ms");t.close()}),(function(e){finishWorkerTask(n);n.terminated||t.error(e)}))}))}));S.on("FontFallback",(function(e){return r.fontFallback(e.id,S)}));S.on("Cleanup",(function wphCleanup(e){return r.cleanup(!0)}));S.on("Terminate",(function wphTerminate(e){o=!0;const t=[];if(r){r.terminate(new a.AbortException("Worker was terminated."));const e=r.cleanup();t.push(e);r=null}else(0,i.clearPrimitiveCaches)();u&&u(new a.AbortException("Worker was terminated."));d.forEach((function(e){t.push(e.finished);e.terminate()}));return Promise.all(t).then((function(){S.destroy();S=null}))}));S.on("Ready",(function wphReady(t){!function setupDoc(e){function onSuccess(e){ensureNotTerminated();S.send("GetDoc",{pdfInfo:e})}function onFailure(e){ensureNotTerminated();if(e instanceof a.PasswordException){var t=new WorkerTask(`PasswordException: response ${e.code}`);startWorkerTask(t);S.sendWithPromise("PasswordRequest",e).then((function({password:e}){finishWorkerTask(t);r.updatePassword(e);pdfManagerReady()})).catch((function(){finishWorkerTask(t);S.send("DocException",e)}))}else e instanceof a.InvalidPDFException||e instanceof a.MissingPDFException||e instanceof a.UnexpectedResponseException||e instanceof a.UnknownErrorException?S.send("DocException",e):S.send("DocException",new a.UnknownErrorException(e.message,e.toString()))}function pdfManagerReady(){ensureNotTerminated();loadDocument(!1).then(onSuccess,(function(e){ensureNotTerminated();if(e instanceof h.XRefParseException){r.requestLoadedStream();r.onLoadedStream().then((function(){ensureNotTerminated();loadDocument(!0).then(onSuccess,onFailure)}))}else onFailure(e)}))}ensureNotTerminated();getPdfManager(e,{maxImageSize:e.maxImageSize,disableFontFace:e.disableFontFace,ignoreErrors:e.ignoreErrors,isEvalSupported:e.isEvalSupported,fontExtraProperties:e.fontExtraProperties},e.enableXfa).then((function(e){if(o){e.terminate(new a.AbortException("Worker was terminated."));throw new Error("Worker was terminated")}(r=e).onLoadedStream().then((function(e){S.send("DataLoaded",{length:e.bytes.byteLength})}))})).then(pdfManagerReady,onFailure)}(e);e=null}));return w}static initializeFromPort(e){var t=new c.MessageHandler("worker","main",e);WorkerMessageHandler.setup(t,e);t.send("ready",null)}}t.WorkerMessageHandler=WorkerMessageHandler;"undefined"==typeof window&&!o.isNodeJS&&"undefined"!=typeof self&&function isMessagePort(e){return"function"==typeof e.postMessage&&"onmessage"in e}(self)&&WorkerMessageHandler.initializeFromPort(self)},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.arrayByteLength=arrayByteLength;t.arraysToBytes=function arraysToBytes(e){const t=e.length;if(1===t&&e[0]instanceof Uint8Array)return e[0];let r=0;for(let a=0;a<t;a++)r+=arrayByteLength(e[a]);let a=0;const i=new Uint8Array(r);for(let r=0;r<t;r++){let t=e[r];t instanceof Uint8Array||(t="string"==typeof t?stringToBytes(t):new Uint8Array(t));const n=t.byteLength;i.set(t,a);a+=n}return i};t.assert=assert;t.bytesToString=function bytesToString(e){assert(null!==e&&"object"==typeof e&&void 0!==e.length,"Invalid argument for bytesToString");const t=e.length,r=8192;if(t<r)return String.fromCharCode.apply(null,e);const a=[];for(let i=0;i<t;i+=r){const n=Math.min(i+r,t),s=e.subarray(i,n);a.push(String.fromCharCode.apply(null,s))}return a.join("")};t.createObjectURL=function createObjectURL(e,t="",r=!1){if(URL.createObjectURL&&!r)return URL.createObjectURL(new Blob([e],{type:t}));const a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";let i=`data:${t};base64,`;for(let t=0,r=e.length;t<r;t+=3){const n=255&e[t],s=255&e[t+1],o=255&e[t+2];i+=a[n>>2]+a[(3&n)<<4|s>>4]+a[t+1<r?(15&s)<<2|o>>6:64]+a[t+2<r?63&o:64]}return i};t.createPromiseCapability=function createPromiseCapability(){const e=Object.create(null);let t=!1;Object.defineProperty(e,"settled",{get:()=>t});e.promise=new Promise((function(r,a){e.resolve=function(e){t=!0;r(e)};e.reject=function(e){t=!0;a(e)}}));return e};t.createValidAbsoluteUrl=function createValidAbsoluteUrl(e,t){if(!e)return null;try{const r=t?new URL(e,t):new URL(e);if(function _isValidProtocol(e){if(!e)return!1;switch(e.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":return!0;default:return!1}}(r))return r}catch(e){}return null};t.escapeString=function escapeString(e){return e.replace(/([()\\\n\r])/g,(e=>"\n"===e?"\\n":"\r"===e?"\\r":`\\${e}`))};t.getModificationDate=function getModificationDate(e=new Date){return[e.getUTCFullYear().toString(),(e.getUTCMonth()+1).toString().padStart(2,"0"),e.getUTCDate().toString().padStart(2,"0"),e.getUTCHours().toString().padStart(2,"0"),e.getUTCMinutes().toString().padStart(2,"0"),e.getUTCSeconds().toString().padStart(2,"0")].join("")};t.getVerbosityLevel=function getVerbosityLevel(){return i};t.info=function info(e){i>=a.INFOS&&console.log(`Info: ${e}`)};t.isArrayBuffer=function isArrayBuffer(e){return"object"==typeof e&&null!==e&&void 0!==e.byteLength};t.isArrayEqual=function isArrayEqual(e,t){if(e.length!==t.length)return!1;for(let r=0,a=e.length;r<a;r++)if(e[r]!==t[r])return!1;return!0};t.isAscii=function isAscii(e){return/^[\x00-\x7F]*$/.test(e)};t.isBool=function isBool(e){return"boolean"==typeof e};t.isNum=function isNum(e){return"number"==typeof e};t.isSameOrigin=function isSameOrigin(e,t){let r;try{r=new URL(e);if(!r.origin||"null"===r.origin)return!1}catch(e){return!1}const a=new URL(t,r);return r.origin===a.origin};t.isString=function isString(e){return"string"==typeof e};t.objectFromMap=function objectFromMap(e){const t=Object.create(null);for(const[r,a]of e)t[r]=a;return t};t.objectSize=function objectSize(e){return Object.keys(e).length};t.removeNullCharacters=function removeNullCharacters(e){if("string"!=typeof e){warn("The argument for removeNullCharacters must be a string.");return e}return e.replace(s,"")};t.setVerbosityLevel=function setVerbosityLevel(e){Number.isInteger(e)&&(i=e)};t.shadow=shadow;t.string32=function string32(e){return String.fromCharCode(e>>24&255,e>>16&255,e>>8&255,255&e)};t.stringToBytes=stringToBytes;t.stringToPDFString=function stringToPDFString(e){const t=e.length,r=[];if("þ"===e[0]&&"ÿ"===e[1])for(let a=2;a<t;a+=2)r.push(String.fromCharCode(e.charCodeAt(a)<<8|e.charCodeAt(a+1)));else if("ÿ"===e[0]&&"þ"===e[1])for(let a=2;a<t;a+=2)r.push(String.fromCharCode(e.charCodeAt(a+1)<<8|e.charCodeAt(a)));else for(let a=0;a<t;++a){const t=h[e.charCodeAt(a)];r.push(t?String.fromCharCode(t):e.charAt(a))}return r.join("")};t.stringToUTF16BEString=function stringToUTF16BEString(e){const t=["þÿ"];for(let r=0,a=e.length;r<a;r++){const a=e.charCodeAt(r);t.push(String.fromCharCode(a>>8&255));t.push(String.fromCharCode(255&a))}return t.join("")};t.stringToUTF8String=function stringToUTF8String(e){return decodeURIComponent(escape(e))};t.unreachable=unreachable;t.utf8StringToString=function utf8StringToString(e){return unescape(encodeURIComponent(e))};t.warn=warn;t.VerbosityLevel=t.Util=t.UNSUPPORTED_FEATURES=t.UnknownErrorException=t.UnexpectedResponseException=t.TextRenderingMode=t.StreamType=t.PermissionFlag=t.PasswordResponses=t.PasswordException=t.PageActionEventType=t.OPS=t.MissingPDFException=t.IsLittleEndianCached=t.IsEvalSupportedCached=t.InvalidPDFException=t.ImageKind=t.IDENTITY_MATRIX=t.FormatError=t.FontType=t.FONT_IDENTITY_MATRIX=t.DocumentActionEventType=t.CMapCompressionType=t.BaseException=t.AnnotationType=t.AnnotationStateModelType=t.AnnotationReviewState=t.AnnotationReplyType=t.AnnotationMarkedState=t.AnnotationFlag=t.AnnotationFieldFlag=t.AnnotationBorderStyleType=t.AnnotationActionEventType=t.AbortException=void 0;r(3);t.IDENTITY_MATRIX=[1,0,0,1,0,0];t.FONT_IDENTITY_MATRIX=[.001,0,0,.001,0,0];t.PermissionFlag={PRINT:4,MODIFY_CONTENTS:8,COPY:16,MODIFY_ANNOTATIONS:32,FILL_INTERACTIVE_FORMS:256,COPY_FOR_ACCESSIBILITY:512,ASSEMBLE:1024,PRINT_HIGH_QUALITY:2048};t.TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};t.ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};t.AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};t.AnnotationStateModelType={MARKED:"Marked",REVIEW:"Review"};t.AnnotationMarkedState={MARKED:"Marked",UNMARKED:"Unmarked"};t.AnnotationReviewState={ACCEPTED:"Accepted",REJECTED:"Rejected",CANCELLED:"Cancelled",COMPLETED:"Completed",NONE:"None"};t.AnnotationReplyType={GROUP:"Group",REPLY:"R"};t.AnnotationFlag={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512};t.AnnotationFieldFlag={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864};t.AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};t.AnnotationActionEventType={E:"Mouse Enter",X:"Mouse Exit",D:"Mouse Down",U:"Mouse Up",Fo:"Focus",Bl:"Blur",PO:"PageOpen",PC:"PageClose",PV:"PageVisible",PI:"PageInvisible",K:"Keystroke",F:"Format",V:"Validate",C:"Calculate"};t.DocumentActionEventType={WC:"WillClose",WS:"WillSave",DS:"DidSave",WP:"WillPrint",DP:"DidPrint"};t.PageActionEventType={O:"PageOpen",C:"PageClose"};t.StreamType={UNKNOWN:"UNKNOWN",FLATE:"FLATE",LZW:"LZW",DCT:"DCT",JPX:"JPX",JBIG:"JBIG",A85:"A85",AHX:"AHX",CCF:"CCF",RLX:"RLX"};t.FontType={UNKNOWN:"UNKNOWN",TYPE1:"TYPE1",TYPE1C:"TYPE1C",CIDFONTTYPE0:"CIDFONTTYPE0",CIDFONTTYPE0C:"CIDFONTTYPE0C",TRUETYPE:"TRUETYPE",CIDFONTTYPE2:"CIDFONTTYPE2",TYPE3:"TYPE3",OPENTYPE:"OPENTYPE",TYPE0:"TYPE0",MMTYPE1:"MMTYPE1"};const a={ERRORS:0,WARNINGS:1,INFOS:5};t.VerbosityLevel=a;t.CMapCompressionType={NONE:0,BINARY:1,STREAM:2};t.OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};t.UNSUPPORTED_FEATURES={unknown:"unknown",forms:"forms",javaScript:"javaScript",smask:"smask",shadingPattern:"shadingPattern",font:"font",errorTilingPattern:"errorTilingPattern",errorExtGState:"errorExtGState",errorXObject:"errorXObject",errorFontLoadType3:"errorFontLoadType3",errorFontState:"errorFontState",errorFontMissing:"errorFontMissing",errorFontTranslate:"errorFontTranslate",errorColorSpace:"errorColorSpace",errorOperatorList:"errorOperatorList",errorFontToUnicode:"errorFontToUnicode",errorFontLoadNative:"errorFontLoadNative",errorFontGetPath:"errorFontGetPath",errorMarkedContent:"errorMarkedContent"};t.PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};let i=a.WARNINGS;function warn(e){i>=a.WARNINGS&&console.log(`Warning: ${e}`)}function unreachable(e){throw new Error(e)}function assert(e,t){e||unreachable(t)}function shadow(e,t,r){Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!1});return r}const n=function BaseExceptionClosure(){function BaseException(e){this.constructor===BaseException&&unreachable("Cannot initialize BaseException.");this.message=e;this.name=this.constructor.name}BaseException.prototype=new Error;BaseException.constructor=BaseException;return BaseException}();t.BaseException=n;t.PasswordException=class PasswordException extends n{constructor(e,t){super(e);this.code=t}};t.UnknownErrorException=class UnknownErrorException extends n{constructor(e,t){super(e);this.details=t}};t.InvalidPDFException=class InvalidPDFException extends n{};t.MissingPDFException=class MissingPDFException extends n{};t.UnexpectedResponseException=class UnexpectedResponseException extends n{constructor(e,t){super(e);this.status=t}};t.FormatError=class FormatError extends n{};t.AbortException=class AbortException extends n{};const s=/\x00/g;function stringToBytes(e){assert("string"==typeof e,"Invalid argument for stringToBytes");const t=e.length,r=new Uint8Array(t);for(let a=0;a<t;++a)r[a]=255&e.charCodeAt(a);return r}function arrayByteLength(e){if(void 0!==e.length)return e.length;assert(void 0!==e.byteLength,"arrayByteLength - invalid argument.");return e.byteLength}const o={get value(){return shadow(this,"value",function isLittleEndian(){const e=new Uint8Array(4);e[0]=1;return 1===new Uint32Array(e.buffer,0,1)[0]}())}};t.IsLittleEndianCached=o;const c={get value(){return shadow(this,"value",function isEvalSupported(){try{new Function("");return!0}catch(e){return!1}}())}};t.IsEvalSupportedCached=c;const l=[...Array(256).keys()].map((e=>e.toString(16).padStart(2,"0")));class Util{static makeHexColor(e,t,r){return`#${l[e]}${l[t]}${l[r]}`}static transform(e,t){return[e[0]*t[0]+e[2]*t[1],e[1]*t[0]+e[3]*t[1],e[0]*t[2]+e[2]*t[3],e[1]*t[2]+e[3]*t[3],e[0]*t[4]+e[2]*t[5]+e[4],e[1]*t[4]+e[3]*t[5]+e[5]]}static applyTransform(e,t){return[e[0]*t[0]+e[1]*t[2]+t[4],e[0]*t[1]+e[1]*t[3]+t[5]]}static applyInverseTransform(e,t){const r=t[0]*t[3]-t[1]*t[2];return[(e[0]*t[3]-e[1]*t[2]+t[2]*t[5]-t[4]*t[3])/r,(-e[0]*t[1]+e[1]*t[0]+t[4]*t[1]-t[5]*t[0])/r]}static getAxialAlignedBoundingBox(e,t){const r=Util.applyTransform(e,t),a=Util.applyTransform(e.slice(2,4),t),i=Util.applyTransform([e[0],e[3]],t),n=Util.applyTransform([e[2],e[1]],t);return[Math.min(r[0],a[0],i[0],n[0]),Math.min(r[1],a[1],i[1],n[1]),Math.max(r[0],a[0],i[0],n[0]),Math.max(r[1],a[1],i[1],n[1])]}static inverseTransform(e){const t=e[0]*e[3]-e[1]*e[2];return[e[3]/t,-e[1]/t,-e[2]/t,e[0]/t,(e[2]*e[5]-e[4]*e[3])/t,(e[4]*e[1]-e[5]*e[0])/t]}static apply3dTransform(e,t){return[e[0]*t[0]+e[1]*t[1]+e[2]*t[2],e[3]*t[0]+e[4]*t[1]+e[5]*t[2],e[6]*t[0]+e[7]*t[1]+e[8]*t[2]]}static singularValueDecompose2dScale(e){const t=[e[0],e[2],e[1],e[3]],r=e[0]*t[0]+e[1]*t[2],a=e[0]*t[1]+e[1]*t[3],i=e[2]*t[0]+e[3]*t[2],n=e[2]*t[1]+e[3]*t[3],s=(r+n)/2,o=Math.sqrt((r+n)**2-4*(r*n-i*a))/2,c=s+o||1,l=s-o||1;return[Math.sqrt(c),Math.sqrt(l)]}static normalizeRect(e){const t=e.slice(0);if(e[0]>e[2]){t[0]=e[2];t[2]=e[0]}if(e[1]>e[3]){t[1]=e[3];t[3]=e[1]}return t}static intersect(e,t){function compare(e,t){return e-t}const r=[e[0],e[2],t[0],t[2]].sort(compare),a=[e[1],e[3],t[1],t[3]].sort(compare),i=[];e=Util.normalizeRect(e);t=Util.normalizeRect(t);if(!(r[0]===e[0]&&r[1]===t[0]||r[0]===t[0]&&r[1]===e[0]))return null;i[0]=r[1];i[2]=r[2];if(!(a[0]===e[1]&&a[1]===t[1]||a[0]===t[1]&&a[1]===e[1]))return null;i[1]=a[1];i[3]=a[2];return i}}t.Util=Util;const h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364]},(e,t,r)=>{r(4)},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.isNodeJS=void 0;const r=!("object"!=typeof process||process+""!="[object process]"||process.versions.nw||process.versions.electron&&process.type&&"browser"!==process.type);t.isNodeJS=r},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.clearPrimitiveCaches=function clearPrimitiveCaches(){s._clearCache();n._clearCache();c._clearCache()};t.isCmd=function isCmd(e,t){return e instanceof s&&(void 0===t||e.cmd===t)};t.isDict=function isDict(e,t){return e instanceof o&&(void 0===t||isName(e.get("Type"),t))};t.isEOF=function isEOF(e){return e===i};t.isName=isName;t.isRef=function isRef(e){return e instanceof c};t.isRefsEqual=function isRefsEqual(e,t){return e.num===t.num&&e.gen===t.gen};t.isStream=function isStream(e){return"object"==typeof e&&null!==e&&void 0!==e.getBytes};t.RefSetCache=t.RefSet=t.Ref=t.Name=t.EOF=t.Dict=t.Cmd=void 0;var a=r(2);const i={};t.EOF=i;const n=function NameClosure(){let e=Object.create(null);function Name(e){this.name=e}Name.prototype={};Name.get=function Name_get(t){const r=e[t];return r||(e[t]=new Name(t))};Name._clearCache=function(){e=Object.create(null)};return Name}();t.Name=n;const s=function CmdClosure(){let e=Object.create(null);function Cmd(e){this.cmd=e}Cmd.prototype={};Cmd.get=function Cmd_get(t){const r=e[t];return r||(e[t]=new Cmd(t))};Cmd._clearCache=function(){e=Object.create(null)};return Cmd}();t.Cmd=s;const o=function DictClosure(){const e=function nonSerializableClosure(){return e};function Dict(t){this._map=Object.create(null);this.xref=t;this.objId=null;this.suppressEncryption=!1;this.__nonSerializable__=e}Dict.prototype={assignXref:function Dict_assignXref(e){this.xref=e},get size(){return Object.keys(this._map).length},get(e,t,r){let a=this._map[e];if(void 0===a&&void 0!==t){a=this._map[t];void 0===a&&void 0!==r&&(a=this._map[r])}return a instanceof c&&this.xref?this.xref.fetch(a,this.suppressEncryption):a},async getAsync(e,t,r){let a=this._map[e];if(void 0===a&&void 0!==t){a=this._map[t];void 0===a&&void 0!==r&&(a=this._map[r])}return a instanceof c&&this.xref?this.xref.fetchAsync(a,this.suppressEncryption):a},getArray(e,t,r){let a=this.get(e,t,r);if(!Array.isArray(a)||!this.xref)return a;a=a.slice();for(let e=0,t=a.length;e<t;e++)a[e]instanceof c&&(a[e]=this.xref.fetch(a[e],this.suppressEncryption));return a},getRaw:function Dict_getRaw(e){return this._map[e]},getKeys:function Dict_getKeys(){return Object.keys(this._map)},getRawValues:function Dict_getRawValues(){return Object.values(this._map)},set:function Dict_set(e,t){this._map[e]=t},has:function Dict_has(e){return void 0!==this._map[e]},forEach:function Dict_forEach(e){for(const t in this._map)e(t,this.get(t))}};Dict.empty=function(){const e=new Dict(null);e.set=(e,t)=>{(0,a.unreachable)("Should not call `set` on the empty dictionary.")};return e}();Dict.merge=function({xref:e,dictArray:t,mergeSubDicts:r=!1}){const a=new Dict(e);if(!r){for(const e of t)if(e instanceof Dict)for(const[t,r]of Object.entries(e._map))void 0===a._map[t]&&(a._map[t]=r);return a.size>0?a:Dict.empty}const i=new Map;for(const e of t)if(e instanceof Dict)for(const[t,r]of Object.entries(e._map)){let e=i.get(t);if(void 0===e){e=[];i.set(t,e)}e.push(r)}for(const[t,r]of i){if(1===r.length||!(r[0]instanceof Dict)){a._map[t]=r[0];continue}const i=new Dict(e);for(const e of r)if(e instanceof Dict)for(const[t,r]of Object.entries(e._map))void 0===i._map[t]&&(i._map[t]=r);i.size>0&&(a._map[t]=i)}i.clear();return a.size>0?a:Dict.empty};return Dict}();t.Dict=o;const c=function RefClosure(){let e=Object.create(null);function Ref(e,t){this.num=e;this.gen=t}Ref.prototype={toString:function Ref_toString(){return 0===this.gen?`${this.num}R`:`${this.num}R${this.gen}`}};Ref.get=function(t,r){const a=0===r?`${t}R`:`${t}R${r}`,i=e[a];return i||(e[a]=new Ref(t,r))};Ref._clearCache=function(){e=Object.create(null)};return Ref}();t.Ref=c;t.RefSet=class RefSet{constructor(e=null){this._set=new Set(e&&e._set)}has(e){return this._set.has(e.toString())}put(e){this._set.add(e.toString())}remove(e){this._set.delete(e.toString())}forEach(e){for(const t of this._set.values())e(t)}clear(){this._set.clear()}};t.RefSetCache=class RefSetCache{constructor(){this._map=new Map}get size(){return this._map.size}get(e){return this._map.get(e.toString())}has(e){return this._map.has(e.toString())}put(e,t){this._map.set(e.toString(),t)}putAlias(e,t){this._map.set(e.toString(),this.get(t))}forEach(e){for(const t of this._map.values())e(t)}clear(){this._map.clear()}};function isName(e,t){return e instanceof n&&(void 0===t||e.name===t)}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NetworkPdfManager=t.LocalPdfManager=void 0;var a=r(2),i=r(7),n=r(8),s=r(9),o=r(12);function parseDocBaseUrl(e){if(e){const t=(0,a.createValidAbsoluteUrl)(e);if(t)return t.href;(0,a.warn)(`Invalid absolute docBaseUrl: "${e}".`)}return null}class BasePdfManager{constructor(){this.constructor===BasePdfManager&&(0,a.unreachable)("Cannot initialize BasePdfManager.")}get docId(){return this._docId}get password(){return this._password}get docBaseUrl(){return this._docBaseUrl}onLoadedStream(){(0,a.unreachable)("Abstract method `onLoadedStream` called")}ensureDoc(e,t){return this.ensure(this.pdfDocument,e,t)}ensureXRef(e,t){return this.ensure(this.pdfDocument.xref,e,t)}ensureCatalog(e,t){return this.ensure(this.pdfDocument.catalog,e,t)}getPage(e){return this.pdfDocument.getPage(e)}fontFallback(e,t){return this.pdfDocument.fontFallback(e,t)}cleanup(e=!1){return this.pdfDocument.cleanup(e)}async ensure(e,t,r){(0,a.unreachable)("Abstract method `ensure` called")}requestRange(e,t){(0,a.unreachable)("Abstract method `requestRange` called")}requestLoadedStream(){(0,a.unreachable)("Abstract method `requestLoadedStream` called")}sendProgressiveData(e){(0,a.unreachable)("Abstract method `sendProgressiveData` called")}updatePassword(e){this._password=e}terminate(e){(0,a.unreachable)("Abstract method `terminate` called")}}t.LocalPdfManager=class LocalPdfManager extends BasePdfManager{constructor(e,t,r,a,i,n){super();this._docId=e;this._password=r;this._docBaseUrl=parseDocBaseUrl(n);this.evaluatorOptions=a;this.enableXfa=i;const c=new o.Stream(t);this.pdfDocument=new s.PDFDocument(this,c);this._loadedStreamPromise=Promise.resolve(c)}async ensure(e,t,r){const a=e[t];return"function"==typeof a?a.apply(e,r):a}requestRange(e,t){return Promise.resolve()}requestLoadedStream(){}onLoadedStream(){return this._loadedStreamPromise}terminate(e){}};t.NetworkPdfManager=class NetworkPdfManager extends BasePdfManager{constructor(e,t,r,a,n,o){super();this._docId=e;this._password=r.password;this._docBaseUrl=parseDocBaseUrl(o);this.msgHandler=r.msgHandler;this.evaluatorOptions=a;this.enableXfa=n;this.streamManager=new i.ChunkedStreamManager(t,{msgHandler:r.msgHandler,length:r.length,disableAutoFetch:r.disableAutoFetch,rangeChunkSize:r.rangeChunkSize});this.pdfDocument=new s.PDFDocument(this,this.streamManager.getStream())}async ensure(e,t,r){try{const a=e[t];return"function"==typeof a?a.apply(e,r):a}catch(a){if(!(a instanceof n.MissingDataException))throw a;await this.requestRange(a.begin,a.end);return this.ensure(e,t,r)}}requestRange(e,t){return this.streamManager.requestRange(e,t)}requestLoadedStream(){this.streamManager.requestAllChunks()}sendProgressiveData(e){this.streamManager.onReceiveData({chunk:e})}onLoadedStream(){return this.streamManager.onLoadedStream()}terminate(e){this.streamManager.abort(e)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ChunkedStreamManager=t.ChunkedStream=void 0;var a=r(2),i=r(8);class ChunkedStream{constructor(e,t,r){this.bytes=new Uint8Array(e);this.start=0;this.pos=0;this.end=e;this.chunkSize=t;this._loadedChunks=new Set;this.numChunks=Math.ceil(e/t);this.manager=r;this.progressiveDataLength=0;this.lastSuccessfulEnsureByteChunk=-1}getMissingChunks(){const e=[];for(let t=0,r=this.numChunks;t<r;++t)this._loadedChunks.has(t)||e.push(t);return e}getBaseStreams(){return[this]}get numChunksLoaded(){return this._loadedChunks.size}allChunksLoaded(){return this.numChunksLoaded===this.numChunks}onReceiveData(e,t){const r=this.chunkSize;if(e%r!=0)throw new Error(`Bad begin offset: ${e}`);const a=e+t.byteLength;if(a%r!=0&&a!==this.bytes.length)throw new Error(`Bad end offset: ${a}`);this.bytes.set(new Uint8Array(t),e);const i=Math.floor(e/r),n=Math.floor((a-1)/r)+1;for(let e=i;e<n;++e)this._loadedChunks.add(e)}onReceiveProgressiveData(e){let t=this.progressiveDataLength;const r=Math.floor(t/this.chunkSize);this.bytes.set(new Uint8Array(e),t);t+=e.byteLength;this.progressiveDataLength=t;const a=t>=this.end?this.numChunks:Math.floor(t/this.chunkSize);for(let e=r;e<a;++e)this._loadedChunks.add(e)}ensureByte(e){if(e<this.progressiveDataLength)return;const t=Math.floor(e/this.chunkSize);if(t!==this.lastSuccessfulEnsureByteChunk){if(!this._loadedChunks.has(t))throw new i.MissingDataException(e,e+1);this.lastSuccessfulEnsureByteChunk=t}}ensureRange(e,t){if(e>=t)return;if(t<=this.progressiveDataLength)return;const r=this.chunkSize,a=Math.floor(e/r),n=Math.floor((t-1)/r)+1;for(let r=a;r<n;++r)if(!this._loadedChunks.has(r))throw new i.MissingDataException(e,t)}nextEmptyChunk(e){const t=this.numChunks;for(let r=0;r<t;++r){const a=(e+r)%t;if(!this._loadedChunks.has(a))return a}return null}hasChunk(e){return this._loadedChunks.has(e)}get length(){return this.end-this.start}get isEmpty(){return 0===this.length}getByte(){const e=this.pos;if(e>=this.end)return-1;e>=this.progressiveDataLength&&this.ensureByte(e);return this.bytes[this.pos++]}getUint16(){const e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t}getInt32(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()}getBytes(e,t=!1){const r=this.bytes,a=this.pos,i=this.end;if(!e){i>this.progressiveDataLength&&this.ensureRange(a,i);const e=r.subarray(a,i);return t?new Uint8ClampedArray(e):e}let n=a+e;n>i&&(n=i);n>this.progressiveDataLength&&this.ensureRange(a,n);this.pos=n;const s=r.subarray(a,n);return t?new Uint8ClampedArray(s):s}peekByte(){const e=this.getByte();-1!==e&&this.pos--;return e}peekBytes(e,t=!1){const r=this.getBytes(e,t);this.pos-=r.length;return r}getByteRange(e,t){e<0&&(e=0);t>this.end&&(t=this.end);t>this.progressiveDataLength&&this.ensureRange(e,t);return this.bytes.subarray(e,t)}skip(e){e||(e=1);this.pos+=e}reset(){this.pos=this.start}moveStart(){this.start=this.pos}makeSubStream(e,t,r){t?e+t>this.progressiveDataLength&&this.ensureRange(e,e+t):e>=this.progressiveDataLength&&this.ensureByte(e);function ChunkedStreamSubstream(){}ChunkedStreamSubstream.prototype=Object.create(this);ChunkedStreamSubstream.prototype.getMissingChunks=function(){const e=this.chunkSize,t=Math.floor(this.start/e),r=Math.floor((this.end-1)/e)+1,a=[];for(let e=t;e<r;++e)this._loadedChunks.has(e)||a.push(e);return a};ChunkedStreamSubstream.prototype.allChunksLoaded=function(){return this.numChunksLoaded===this.numChunks||0===this.getMissingChunks().length};const a=new ChunkedStreamSubstream;a.pos=a.start=e;a.end=e+t||this.end;a.dict=r;return a}}t.ChunkedStream=ChunkedStream;t.ChunkedStreamManager=class ChunkedStreamManager{constructor(e,t){this.length=t.length;this.chunkSize=t.rangeChunkSize;this.stream=new ChunkedStream(this.length,this.chunkSize,this);this.pdfNetworkStream=e;this.disableAutoFetch=t.disableAutoFetch;this.msgHandler=t.msgHandler;this.currRequestId=0;this._chunksNeededByRequest=new Map;this._requestsByChunk=new Map;this._promisesByRequest=new Map;this.progressiveDataLength=0;this.aborted=!1;this._loadedStreamCapability=(0,a.createPromiseCapability)()}onLoadedStream(){return this._loadedStreamCapability.promise}sendRequest(e,t){const r=this.pdfNetworkStream.getRangeReader(e,t);r.isStreamingSupported||(r.onProgress=this.onProgress.bind(this));let i=[],n=0;new Promise(((e,t)=>{const readChunk=s=>{try{if(!s.done){const e=s.value;i.push(e);n+=(0,a.arrayByteLength)(e);r.isStreamingSupported&&this.onProgress({loaded:n});r.read().then(readChunk,t);return}const o=(0,a.arraysToBytes)(i);i=null;e(o)}catch(e){t(e)}};r.read().then(readChunk,t)})).then((t=>{this.aborted||this.onReceiveData({chunk:t,begin:e})}))}requestAllChunks(){const e=this.stream.getMissingChunks();this._requestChunks(e);return this._loadedStreamCapability.promise}_requestChunks(e){const t=this.currRequestId++,r=new Set;this._chunksNeededByRequest.set(t,r);for(const t of e)this.stream.hasChunk(t)||r.add(t);if(0===r.size)return Promise.resolve();const i=(0,a.createPromiseCapability)();this._promisesByRequest.set(t,i);const n=[];for(const e of r){let r=this._requestsByChunk.get(e);if(!r){r=[];this._requestsByChunk.set(e,r);n.push(e)}r.push(t)}if(n.length>0){const e=this.groupChunks(n);for(const t of e){const e=t.beginChunk*this.chunkSize,r=Math.min(t.endChunk*this.chunkSize,this.length);this.sendRequest(e,r)}}return i.promise.catch((e=>{if(!this.aborted)throw e}))}getStream(){return this.stream}requestRange(e,t){t=Math.min(t,this.length);const r=this.getBeginChunk(e),a=this.getEndChunk(t),i=[];for(let e=r;e<a;++e)i.push(e);return this._requestChunks(i)}requestRanges(e=[]){const t=[];for(const r of e){const e=this.getBeginChunk(r.begin),a=this.getEndChunk(r.end);for(let r=e;r<a;++r)t.includes(r)||t.push(r)}t.sort((function(e,t){return e-t}));return this._requestChunks(t)}groupChunks(e){const t=[];let r=-1,a=-1;for(let i=0,n=e.length;i<n;++i){const n=e[i];r<0&&(r=n);if(a>=0&&a+1!==n){t.push({beginChunk:r,endChunk:a+1});r=n}i+1===e.length&&t.push({beginChunk:r,endChunk:n+1});a=n}return t}onProgress(e){this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize+e.loaded,total:this.length})}onReceiveData(e){const t=e.chunk,r=void 0===e.begin,a=r?this.progressiveDataLength:e.begin,i=a+t.byteLength,n=Math.floor(a/this.chunkSize),s=i<this.length?Math.floor(i/this.chunkSize):Math.ceil(i/this.chunkSize);if(r){this.stream.onReceiveProgressiveData(t);this.progressiveDataLength=i}else this.stream.onReceiveData(a,t);this.stream.allChunksLoaded()&&this._loadedStreamCapability.resolve(this.stream);const o=[];for(let e=n;e<s;++e){const t=this._requestsByChunk.get(e);if(t){this._requestsByChunk.delete(e);for(const r of t){const t=this._chunksNeededByRequest.get(r);t.has(e)&&t.delete(e);t.size>0||o.push(r)}}}if(!this.disableAutoFetch&&0===this._requestsByChunk.size){let e;if(1===this.stream.numChunksLoaded){const t=this.stream.numChunks-1;this.stream.hasChunk(t)||(e=t)}else e=this.stream.nextEmptyChunk(s);Number.isInteger(e)&&this._requestChunks([e])}for(const e of o){const t=this._promisesByRequest.get(e);this._promisesByRequest.delete(e);t.resolve()}this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize,total:this.length})}onError(e){this._loadedStreamCapability.reject(e)}getBeginChunk(e){return Math.floor(e/this.chunkSize)}getEndChunk(e){return Math.floor((e-1)/this.chunkSize)+1}abort(e){this.aborted=!0;this.pdfNetworkStream&&this.pdfNetworkStream.cancelAllRequests(e);for(const t of this._promisesByRequest.values())t.reject(e)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.collectActions=function collectActions(e,t,r){const n=Object.create(null),s=getInheritableProperty({dict:t,key:"AA",stopWhenFound:!1});if(s)for(let t=s.length-1;t>=0;t--){const a=s[t];if(a instanceof i.Dict)for(const t of a.getKeys()){const s=r[t];if(!s)continue;const o=a.getRaw(t),c=new i.RefSet,l=[];_collectJS(o,e,l,c);l.length>0&&(n[s]=l)}}if(t.has("A")){const r=t.get("A"),a=new i.RefSet,s=[];_collectJS(r,e,s,a);s.length>0&&(n.Action=s)}return(0,a.objectSize)(n)>0?n:null};t.encodeToXmlString=function encodeToXmlString(e){const t=[];let r=0;for(let a=0,i=e.length;a<i;a++){const i=e.codePointAt(a);if(32<=i&&i<=126){const n=s[i];if(n){r<a&&t.push(e.substring(r,a));t.push(n);r=a+1}}else{r<a&&t.push(e.substring(r,a));t.push(`&#x${i.toString(16).toUpperCase()};`);i>55295&&(i<57344||i>65533)&&a++;r=a+1}}if(0===t.length)return e;r<e.length&&t.push(e.substring(r,e.length));return t.join("")};t.escapePDFName=function escapePDFName(e){const t=[];let r=0;for(let a=0,i=e.length;a<i;a++){const i=e.charCodeAt(a);if(i<33||i>126||35===i||40===i||41===i||60===i||62===i||91===i||93===i||123===i||125===i||47===i||37===i){r<a&&t.push(e.substring(r,a));t.push(`#${i.toString(16)}`);r=a+1}}if(0===t.length)return e;r<e.length&&t.push(e.substring(r,e.length));return t.join("")};t.getArrayLookupTableFactory=function getArrayLookupTableFactory(e){let t;return function(){if(e){let r=e();e=null;t=Object.create(null);for(let e=0,a=r.length;e<a;e+=2)t[r[e]]=r[e+1];r=null}return t}};t.getInheritableProperty=getInheritableProperty;t.getLookupTableFactory=function getLookupTableFactory(e){let t;return function(){if(e){t=Object.create(null);e(t);e=null}return t}};t.isWhiteSpace=function isWhiteSpace(e){return 32===e||9===e||13===e||10===e};t.log2=function log2(e){if(e<=0)return 0;return Math.ceil(Math.log2(e))};t.parseXFAPath=function parseXFAPath(e){const t=/(.+)\[([0-9]+)\]$/;return e.split(".").map((e=>{const r=e.match(t);return r?{name:r[1],pos:parseInt(r[2],10)}:{name:e,pos:0}}))};t.readInt8=function readInt8(e,t){return e[t]<<24>>24};t.readUint16=function readUint16(e,t){return e[t]<<8|e[t+1]};t.readUint32=function readUint32(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0};t.toRomanNumerals=function toRomanNumerals(e,t=!1){(0,a.assert)(Number.isInteger(e)&&e>0,"The number should be a positive integer.");const r=[];let i;for(;e>=1e3;){e-=1e3;r.push("M")}i=e/100|0;e%=100;r.push(n[i]);i=e/10|0;e%=10;r.push(n[10+i]);r.push(n[20+e]);const s=r.join("");return t?s.toLowerCase():s};t.XRefParseException=t.XRefEntryException=t.MissingDataException=void 0;var a=r(2),i=r(5);class MissingDataException extends a.BaseException{constructor(e,t){super(`Missing data [${e}, ${t})`);this.begin=e;this.end=t}}t.MissingDataException=MissingDataException;class XRefEntryException extends a.BaseException{}t.XRefEntryException=XRefEntryException;class XRefParseException extends a.BaseException{}t.XRefParseException=XRefParseException;function getInheritableProperty({dict:e,key:t,getArray:r=!1,stopWhenFound:a=!0}){let n;const s=new i.RefSet;for(;e instanceof i.Dict&&(!e.objId||!s.has(e.objId));){e.objId&&s.put(e.objId);const i=r?e.getArray(t):e.get(t);if(void 0!==i){if(a)return i;n||(n=[]);n.push(i)}e=e.get("Parent")}return n}const n=["","C","CC","CCC","CD","D","DC","DCC","DCCC","CM","","X","XX","XXX","XL","L","LX","LXX","LXXX","XC","","I","II","III","IV","V","VI","VII","VIII","IX"];function _collectJS(e,t,r,n){if(!e)return;let s=null;if((0,i.isRef)(e)){if(n.has(e))return;s=e;n.put(s);e=t.fetch(e)}if(Array.isArray(e))for(const a of e)_collectJS(a,t,r,n);else if(e instanceof i.Dict){if((0,i.isName)(e.get("S"),"JavaScript")&&e.has("JS")){const t=e.get("JS");let n;n=(0,i.isStream)(t)?(0,a.bytesToString)(t.getBytes()):t;n=(0,a.stringToPDFString)(n);n&&r.push(n)}_collectJS(e.getRaw("Next"),t,r,n)}s&&n.remove(s)}const s={60:"&lt;",62:"&gt;",38:"&amp;",34:"&quot;",39:"&apos;"}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFDocument=t.Page=void 0;var a=r(2),i=r(10),n=r(5),s=r(8),o=r(12),c=r(27),l=r(22),h=r(11),u=r(46),d=r(29),f=r(49);const g=[0,0,612,792];function isAnnotationRenderable(e,t){return"display"===t&&e.viewable||"print"===t&&e.printable}class Page{constructor({pdfManager:e,xref:t,pageIndex:r,pageDict:a,ref:i,globalIdFactory:n,fontCache:s,builtInCMapCache:o,globalImageCache:c,nonBlendModesSet:l,xfaFactory:h}){this.pdfManager=e;this.pageIndex=r;this.pageDict=a;this.xref=t;this.ref=i;this.fontCache=s;this.builtInCMapCache=o;this.globalImageCache=c;this.nonBlendModesSet=l;this.evaluatorOptions=e.evaluatorOptions;this.resourcesPromise=null;this.xfaFactory=h;const u={obj:0};this._localIdFactory=class extends n{static createObjId(){return`p${r}_${++u.obj}`}}}_getInheritableProperty(e,t=!1){const r=(0,s.getInheritableProperty)({dict:this.pageDict,key:e,getArray:t,stopWhenFound:!1});return Array.isArray(r)?1!==r.length&&(0,n.isDict)(r[0])?n.Dict.merge({xref:this.xref,dictArray:r}):r[0]:r}get content(){return this.pageDict.get("Contents")}get resources(){return(0,a.shadow)(this,"resources",this._getInheritableProperty("Resources")||n.Dict.empty)}_getBoundingBox(e){if(this.xfaData){const{width:e,height:t}=this.xfaData.attributes.style;return[0,0,parseInt(e),parseInt(t)]}const t=this._getInheritableProperty(e,!0);if(Array.isArray(t)&&4===t.length){if(t[2]-t[0]!=0&&t[3]-t[1]!=0)return t;(0,a.warn)(`Empty /${e} entry.`)}return null}get mediaBox(){return(0,a.shadow)(this,"mediaBox",this._getBoundingBox("MediaBox")||g)}get cropBox(){return(0,a.shadow)(this,"cropBox",this._getBoundingBox("CropBox")||this.mediaBox)}get userUnit(){let e=this.pageDict.get("UserUnit");(!(0,a.isNum)(e)||e<=0)&&(e=1);return(0,a.shadow)(this,"userUnit",e)}get view(){const{cropBox:e,mediaBox:t}=this;let r;if(e===t||(0,a.isArrayEqual)(e,t))r=t;else{const i=a.Util.intersect(e,t);i&&i[2]-i[0]!=0&&i[3]-i[1]!=0?r=i:(0,a.warn)("Empty /CropBox and /MediaBox intersection.")}return(0,a.shadow)(this,"view",r||t)}get rotate(){let e=this._getInheritableProperty("Rotate")||0;e%90!=0?e=0:e>=360?e%=360:e<0&&(e=(e%360+360)%360);return(0,a.shadow)(this,"rotate",e)}getContentStream(){const e=this.content;let t;if(Array.isArray(e)){const r=this.xref,a=[];for(const t of e)a.push(r.fetchIfRef(t));t=new o.StreamsSequenceStream(a)}else t=(0,n.isStream)(e)?e:new o.NullStream;return t}get xfaData(){return this.xfaFactory?(0,a.shadow)(this,"xfaData",this.xfaFactory.getPage(this.pageIndex)):(0,a.shadow)(this,"xfaData",null)}save(e,t,r){const i=new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions});return this._parsedAnnotations.then((function(e){const n=[];for(const s of e)isAnnotationRenderable(s,"print")&&n.push(s.save(i,t,r).catch((function(e){(0,a.warn)(`save - ignoring annotation data during "${t.name}" task: "${e}".`);return null})));return Promise.all(n)}))}loadResources(e){this.resourcesPromise||(this.resourcesPromise=this.pdfManager.ensure(this,"resources"));return this.resourcesPromise.then((()=>new i.ObjectLoader(this.resources,e,this.xref).load()))}getOperatorList({handler:e,sink:t,task:r,intent:i,renderInteractiveForms:n,annotationStorage:s}){const o=this.pdfManager.ensure(this,"getContentStream"),c=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),l=new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions}),h=Promise.all([o,c]).then((([a])=>{const n=new u.OperatorList(i,t);e.send("StartRenderPage",{transparency:l.hasBlendModes(this.resources,this.nonBlendModesSet),pageIndex:this.pageIndex,intent:i});return l.getOperatorList({stream:a,task:r,resources:this.resources,operatorList:n}).then((function(){return n}))}));return Promise.all([h,this._parsedAnnotations]).then((function([e,t]){if(0===t.length){e.flush(!0);return{length:e.totalLength}}const o=[];for(const e of t)isAnnotationRenderable(e,i)&&!e.isHidden(s)&&o.push(e.getOperatorList(l,r,n,s).catch((function(e){(0,a.warn)(`getOperatorList - ignoring annotation data during "${r.name}" task: "${e}".`);return null})));return Promise.all(o).then((function(t){e.addOp(a.OPS.beginAnnotations,[]);for(const r of t)e.addOpList(r);e.addOp(a.OPS.endAnnotations,[]);e.flush(!0);return{length:e.totalLength}}))}))}extractTextContent({handler:e,task:t,normalizeWhitespace:r,sink:a,combineTextItems:i}){const n=this.pdfManager.ensure(this,"getContentStream"),s=this.loadResources(["ExtGState","XObject","Font"]);return Promise.all([n,s]).then((([n])=>new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,globalImageCache:this.globalImageCache,options:this.evaluatorOptions}).getTextContent({stream:n,task:t,resources:this.resources,normalizeWhitespace:r,combineTextItems:i,sink:a})))}getAnnotationsData(e){return this._parsedAnnotations.then((function(t){const r=[];for(let a=0,i=t.length;a<i;a++)e&&!isAnnotationRenderable(t[a],e)||r.push(t[a].data);return r}))}get annotations(){const e=this._getInheritableProperty("Annots");return(0,a.shadow)(this,"annotations",Array.isArray(e)?e:[])}get _parsedAnnotations(){const e=this.pdfManager.ensure(this,"annotations").then((()=>{const e=[];for(const t of this.annotations)e.push(c.AnnotationFactory.create(this.xref,t,this.pdfManager,this._localIdFactory,!1).catch((function(e){(0,a.warn)(`_parsedAnnotations: "${e}".`);return null})));return Promise.all(e).then((function(e){return e.filter((e=>!!e))}))}));return(0,a.shadow)(this,"_parsedAnnotations",e)}get jsActions(){const e=(0,s.collectActions)(this.xref,this.pageDict,a.PageActionEventType);return(0,a.shadow)(this,"jsActions",e)}}t.Page=Page;const p=new Uint8Array([37,80,68,70,45]),m=new Uint8Array([115,116,97,114,116,120,114,101,102]),b=new Uint8Array([101,110,100,111,98,106]),y=/^[1-9]\.[0-9]$/;function find(e,t,r=1024,a=!1){const i=t.length,n=e.peekBytes(r),s=n.length-i;if(s<=0)return!1;if(a){const r=i-1;let a=n.length-1;for(;a>=r;){let s=0;for(;s<i&&n[a-s]===t[r-s];)s++;if(s>=i){e.pos+=a-r;return!0}a--}}else{let r=0;for(;r<=s;){let a=0;for(;a<i&&n[r+a]===t[a];)a++;if(a>=i){e.pos+=r;return!0}r++}}return!1}t.PDFDocument=class PDFDocument{constructor(e,t){let r;if((0,n.isStream)(t))r=t;else{if(!(0,a.isArrayBuffer)(t))throw new Error("PDFDocument: Unknown argument type");r=new o.Stream(t)}if(r.length<=0)throw new a.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");this.pdfManager=e;this.stream=r;this.xref=new i.XRef(r,e);this._pagePromises=[];this._version=null;const s={font:0};this._globalIdFactory=class{static getDocId(){return`g_${e.docId}`}static createFontId(){return"f"+ ++s.font}static createObjId(){(0,a.unreachable)("Abstract method `createObjId` called.")}}}parse(e){this.xref.parse(e);this.catalog=new i.Catalog(this.pdfManager,this.xref);this.catalog.version&&(this._version=this.catalog.version)}get linearization(){let e=null;try{e=h.Linearization.create(this.stream)}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.info)(e)}return(0,a.shadow)(this,"linearization",e)}get startXRef(){const e=this.stream;let t=0;if(this.linearization){e.reset();find(e,b)&&(t=e.pos+6-e.start)}else{const r=1024,a=m.length;let i=!1,n=e.end;for(;!i&&n>0;){n-=r-a;n<0&&(n=0);e.pos=n;i=find(e,m,r,!0)}if(i){e.skip(9);let r;do{r=e.getByte()}while((0,s.isWhiteSpace)(r));let a="";for(;r>=32&&r<=57;){a+=String.fromCharCode(r);r=e.getByte()}t=parseInt(a,10);isNaN(t)&&(t=0)}}return(0,a.shadow)(this,"startXRef",t)}checkHeader(){const e=this.stream;e.reset();if(!find(e,p))return;e.moveStart();let t,r="";for(;(t=e.getByte())>32&&!(r.length>=12);)r+=String.fromCharCode(t);this._version||(this._version=r.substring(5))}parseStartXRef(){this.xref.setStartXRef(this.startXRef)}get numPages(){if(this.xfaFactory)return(0,a.shadow)(this,"numPages",this.xfaFactory.numberPages);const e=this.linearization,t=e?e.numPages:this.catalog.numPages;return(0,a.shadow)(this,"numPages",t)}_hasOnlyDocumentSignatures(e,t=0){return!!Array.isArray(e)&&e.every((e=>{if(!((e=this.xref.fetchIfRef(e))instanceof n.Dict))return!1;if(e.has("Kids")){if(++t>10){(0,a.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");return!1}return this._hasOnlyDocumentSignatures(e.get("Kids"),t)}const r=(0,n.isName)(e.get("FT"),"Sig"),i=e.get("Rect"),s=Array.isArray(i)&&i.every((e=>0===e));return r&&s}))}get xfaData(){const e=this.catalog.acroForm;if(!e)return null;const t=e.get("XFA"),r={"xdp:xdp":"",template:"",datasets:"",config:"",connectionSet:"",localeSet:"",stylesheet:"","/xdp:xdp":""};if((0,n.isStream)(t)&&!t.isEmpty)try{r["xdp:xdp"]=(0,a.stringToUTF8String)((0,a.bytesToString)(t.getBytes()));return r}catch(e){(0,a.warn)("XFA - Invalid utf-8 string.");return null}if(!Array.isArray(t)||0===t.length)return null;for(let e=0,i=t.length;e<i;e+=2){let s;s=0===e?"xdp:xdp":e===i-2?"/xdp:xdp":t[e];if(!r.hasOwnProperty(s))continue;const o=this.xref.fetchIfRef(t[e+1]);if((0,n.isStream)(o)&&!o.isEmpty)try{r[s]=(0,a.stringToUTF8String)((0,a.bytesToString)(o.getBytes()))}catch(e){(0,a.warn)("XFA - Invalid utf-8 string.");return null}}return r}get xfaFactory(){if(this.pdfManager.enableXfa&&this.formInfo.hasXfa&&!this.formInfo.hasAcroForm){const e=this.xfaData;return(0,a.shadow)(this,"xfaFactory",e?new f.XFAFactory(e):null)}return(0,a.shadow)(this,"xfaFaxtory",null)}get isPureXfa(){return null!==this.xfaFactory}get formInfo(){const e={hasFields:!1,hasAcroForm:!1,hasXfa:!1},t=this.catalog.acroForm;if(!t)return(0,a.shadow)(this,"formInfo",e);try{const r=t.get("Fields"),a=Array.isArray(r)&&r.length>0;e.hasFields=a;const i=t.get("XFA");e.hasXfa=Array.isArray(i)&&i.length>0||(0,n.isStream)(i)&&!i.isEmpty;const s=!!(1&t.get("SigFlags"))&&this._hasOnlyDocumentSignatures(r);e.hasAcroForm=a&&!s}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.warn)(`Cannot fetch form information: "${e}".`)}return(0,a.shadow)(this,"formInfo",e)}get documentInfo(){const e={Title:a.isString,Author:a.isString,Subject:a.isString,Keywords:a.isString,Creator:a.isString,Producer:a.isString,CreationDate:a.isString,ModDate:a.isString,Trapped:n.isName};let t=this._version;if("string"!=typeof t||!y.test(t)){(0,a.warn)(`Invalid PDF header version number: ${t}`);t=null}const r={PDFFormatVersion:t,IsLinearized:!!this.linearization,IsAcroFormPresent:this.formInfo.hasAcroForm,IsXFAPresent:this.formInfo.hasXfa,IsCollectionPresent:!!this.catalog.collection};let i;try{i=this.xref.trailer.get("Info")}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.info)("The document information dictionary is invalid.")}if((0,n.isDict)(i))for(const t of i.getKeys()){const s=i.get(t);if(e[t])e[t](s)?r[t]="string"!=typeof s?s:(0,a.stringToPDFString)(s):(0,a.info)(`Bad value in document info for "${t}".`);else if("string"==typeof t){let e;if((0,a.isString)(s))e=(0,a.stringToPDFString)(s);else{if(!((0,n.isName)(s)||(0,a.isNum)(s)||(0,a.isBool)(s))){(0,a.info)(`Unsupported value in document info for (custom) "${t}".`);continue}e=s}r.Custom||(r.Custom=Object.create(null));r.Custom[t]=e}}return(0,a.shadow)(this,"documentInfo",r)}get fingerprint(){let e;const t=this.xref.trailer.get("ID");e=Array.isArray(t)&&t[0]&&(0,a.isString)(t[0])&&"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"!==t[0]?(0,a.stringToBytes)(t[0]):(0,l.calculateMD5)(this.stream.getByteRange(0,1024),0,1024);const r=[];for(let t=0,a=e.length;t<a;t++){const a=e[t].toString(16);r.push(a.padStart(2,"0"))}return(0,a.shadow)(this,"fingerprint",r.join(""))}_getLinearizationPage(e){const{catalog:t,linearization:r}=this,i=n.Ref.get(r.objectNumberFirst,0);return this.xref.fetchAsync(i).then((e=>{if((0,n.isDict)(e,"Page")||(0,n.isDict)(e)&&!e.has("Type")&&e.has("Contents")){i&&!t.pageKidsCountCache.has(i)&&t.pageKidsCountCache.put(i,1);return[e,i]}throw new a.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.")})).catch((r=>{(0,a.info)(r);return t.getPageDict(e)}))}getPage(e){if(void 0!==this._pagePromises[e])return this._pagePromises[e];const{catalog:t,linearization:r}=this;if(this.xfaFactory)return Promise.resolve(new Page({pdfManager:this.pdfManager,xref:this.xref,pageIndex:e,pageDict:n.Dict.empty,ref:null,globalIdFactory:this._globalIdFactory,fontCache:t.fontCache,builtInCMapCache:t.builtInCMapCache,globalImageCache:t.globalImageCache,nonBlendModesSet:t.nonBlendModesSet,xfaFactory:this.xfaFactory}));const a=r&&r.pageFirst===e?this._getLinearizationPage(e):t.getPageDict(e);return this._pagePromises[e]=a.then((([r,a])=>new Page({pdfManager:this.pdfManager,xref:this.xref,pageIndex:e,pageDict:r,ref:a,globalIdFactory:this._globalIdFactory,fontCache:t.fontCache,builtInCMapCache:t.builtInCMapCache,globalImageCache:t.globalImageCache,nonBlendModesSet:t.nonBlendModesSet,xfaFactory:null})))}checkFirstPage(){return this.getPage(0).catch((async e=>{if(e instanceof s.XRefEntryException){this._pagePromises.length=0;await this.cleanup();throw new s.XRefParseException}}))}fontFallback(e,t){return this.catalog.fontFallback(e,t)}async cleanup(e=!1){return this.catalog?this.catalog.cleanup(e):(0,n.clearPrimitiveCaches)()}_collectFieldObjects(e,t,r){const i=this.xref.fetchIfRef(t);if(i.has("T")){const t=(0,a.stringToPDFString)(i.get("T"));e=""===e?t:`${e}.${t}`}r.has(e)||r.set(e,[]);r.get(e).push(c.AnnotationFactory.create(this.xref,t,this.pdfManager,this._localIdFactory,!0).then((e=>e&&e.getFieldObject())).catch((function(e){(0,a.warn)(`_collectFieldObjects: "${e}".`);return null})));if(i.has("Kids")){const t=i.get("Kids");for(const a of t)this._collectFieldObjects(e,a,r)}}get fieldObjects(){if(!this.formInfo.hasFields)return(0,a.shadow)(this,"fieldObjects",Promise.resolve(null));const e=Object.create(null),t=new Map;for(const e of this.catalog.acroForm.get("Fields"))this._collectFieldObjects("",e,t);const r=[];for(const[a,i]of t)r.push(Promise.all(i).then((t=>{(t=t.filter((e=>!!e))).length>0&&(e[a]=t)})));return(0,a.shadow)(this,"fieldObjects",Promise.all(r).then((()=>e)))}get hasJSActions(){return(0,a.shadow)(this,"hasJSActions",this.fieldObjects.then((e=>null!==e&&Object.values(e).some((e=>e.some((e=>null!==e.actions))))||!!this.catalog.jsActions)))}get calculationOrderIds(){const e=this.catalog.acroForm;if(!e||!e.has("CO"))return(0,a.shadow)(this,"calculationOrderIds",null);const t=e.get("CO");if(!Array.isArray(t)||0===t.length)return(0,a.shadow)(this,"calculationOrderIds",null);const r=t.filter(n.isRef).map((e=>e.toString()));return 0===r.length?(0,a.shadow)(this,"calculationOrderIds",null):(0,a.shadow)(this,"calculationOrderIds",r)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XRef=t.ObjectLoader=t.FileSpec=t.Catalog=void 0;var a=r(2),i=r(5),n=r(8),s=r(11),o=r(22),c=r(23),l=r(24),h=r(25);function fetchDestination(e){return(0,i.isDict)(e)?e.get("D"):e}class Catalog{constructor(e,t){this.pdfManager=e;this.xref=t;this._catDict=t.getCatalogObj();if(!(0,i.isDict)(this._catDict))throw new a.FormatError("Catalog object is not a dictionary.");this.fontCache=new i.RefSetCache;this.builtInCMapCache=new Map;this.globalImageCache=new l.GlobalImageCache;this.pageKidsCountCache=new i.RefSetCache;this.nonBlendModesSet=new i.RefSet}get version(){const e=this._catDict.get("Version");return(0,i.isName)(e)?(0,a.shadow)(this,"version",e.name):(0,a.shadow)(this,"version",null)}get collection(){let e=null;try{const t=this._catDict.get("Collection");(0,i.isDict)(t)&&t.size>0&&(e=t)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Cannot fetch Collection entry; assuming no collection is present.")}return(0,a.shadow)(this,"collection",e)}get acroForm(){let e=null;try{const t=this._catDict.get("AcroForm");(0,i.isDict)(t)&&t.size>0&&(e=t)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Cannot fetch AcroForm entry; assuming no forms are present.")}return(0,a.shadow)(this,"acroForm",e)}get metadata(){const e=this._catDict.getRaw("Metadata");if(!(0,i.isRef)(e))return(0,a.shadow)(this,"metadata",null);const t=!(this.xref.encrypt&&this.xref.encrypt.encryptMetadata),r=this.xref.fetch(e,t);let s=null;if((0,i.isStream)(r)&&(0,i.isDict)(r.dict)){const e=r.dict.get("Type"),t=r.dict.get("Subtype");if((0,i.isName)(e,"Metadata")&&(0,i.isName)(t,"XML"))try{const e=(0,a.stringToUTF8String)((0,a.bytesToString)(r.getBytes()));e&&(s=new h.MetadataParser(e).serializable)}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("Skipping invalid metadata.")}}return(0,a.shadow)(this,"metadata",s)}get markInfo(){let e=null;try{e=this._readMarkInfo()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read mark info.")}return(0,a.shadow)(this,"markInfo",e)}_readMarkInfo(){const e=this._catDict.get("MarkInfo");if(!(0,i.isDict)(e))return null;const t=Object.assign(Object.create(null),{Marked:!1,UserProperties:!1,Suspects:!1});for(const r in t){if(!e.has(r))continue;const i=e.get(r);(0,a.isBool)(i)&&(t[r]=i)}return t}get toplevelPagesDict(){const e=this._catDict.get("Pages");if(!(0,i.isDict)(e))throw new a.FormatError("Invalid top-level pages dictionary.");return(0,a.shadow)(this,"toplevelPagesDict",e)}get documentOutline(){let e=null;try{e=this._readDocumentOutline()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read document outline.")}return(0,a.shadow)(this,"documentOutline",e)}_readDocumentOutline(){let e=this._catDict.get("Outlines");if(!(0,i.isDict)(e))return null;e=e.getRaw("First");if(!(0,i.isRef)(e))return null;const t={items:[]},r=[{obj:e,parent:t}],n=new i.RefSet;n.put(e);const s=this.xref,o=new Uint8ClampedArray(3);for(;r.length>0;){const t=r.shift(),l=s.fetchIfRef(t.obj);if(null===l)continue;if(!l.has("Title"))throw new a.FormatError("Invalid outline item encountered.");const h={url:null,dest:null};Catalog.parseDestDictionary({destDict:l,resultObj:h,docBaseUrl:this.pdfManager.docBaseUrl});const u=l.get("Title"),d=l.get("F")||0,f=l.getArray("C"),g=l.get("Count");let p=o;!Array.isArray(f)||3!==f.length||0===f[0]&&0===f[1]&&0===f[2]||(p=c.ColorSpace.singletons.rgb.getRgb(f,0));const m={dest:h.dest,url:h.url,unsafeUrl:h.unsafeUrl,newWindow:h.newWindow,title:(0,a.stringToPDFString)(u),color:p,count:Number.isInteger(g)?g:void 0,bold:!!(2&d),italic:!!(1&d),items:[]};t.parent.items.push(m);e=l.getRaw("First");if((0,i.isRef)(e)&&!n.has(e)){r.push({obj:e,parent:m});n.put(e)}e=l.getRaw("Next");if((0,i.isRef)(e)&&!n.has(e)){r.push({obj:e,parent:t.parent});n.put(e)}}return t.items.length>0?t.items:null}get permissions(){let e=null;try{e=this._readPermissions()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read permissions.")}return(0,a.shadow)(this,"permissions",e)}_readPermissions(){const e=this.xref.trailer.get("Encrypt");if(!(0,i.isDict)(e))return null;let t=e.get("P");if(!(0,a.isNum)(t))return null;t+=2**32;const r=[];for(const e in a.PermissionFlag){const i=a.PermissionFlag[e];t&i&&r.push(i)}return r}get optionalContentConfig(){let e=null;try{const t=this._catDict.get("OCProperties");if(!t)return(0,a.shadow)(this,"optionalContentConfig",null);const r=t.get("D");if(!r)return(0,a.shadow)(this,"optionalContentConfig",null);const n=t.get("OCGs");if(!Array.isArray(n))return(0,a.shadow)(this,"optionalContentConfig",null);const s=[],o=[];for(const e of n){if(!(0,i.isRef)(e))continue;o.push(e);const t=this.xref.fetchIfRef(e);s.push({id:e.toString(),name:(0,a.isString)(t.get("Name"))?(0,a.stringToPDFString)(t.get("Name")):null,intent:(0,a.isString)(t.get("Intent"))?(0,a.stringToPDFString)(t.get("Intent")):null})}e=this._readOptionalContentConfig(r,o);e.groups=s}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`Unable to read optional content config: ${e}`)}return(0,a.shadow)(this,"optionalContentConfig",e)}_readOptionalContentConfig(e,t){function parseOnOff(e){const r=[];if(Array.isArray(e))for(const a of e)(0,i.isRef)(a)&&t.includes(a)&&r.push(a.toString());return r}function parseOrder(e,r=0){if(!Array.isArray(e))return null;const a=[];for(const s of e){if((0,i.isRef)(s)&&t.includes(s)){n.put(s);a.push(s.toString());continue}const e=parseNestedOrder(s,r);e&&a.push(e)}if(r>0)return a;const s=[];for(const e of t)n.has(e)||s.push(e.toString());s.length&&a.push({name:null,order:s});return a}function parseNestedOrder(e,t){if(++t>s){(0,a.warn)("parseNestedOrder - reached MAX_NESTED_LEVELS.");return null}const i=r.fetchIfRef(e);if(!Array.isArray(i))return null;const n=r.fetchIfRef(i[0]);if("string"!=typeof n)return null;const o=parseOrder(i.slice(1),t);return o&&o.length?{name:(0,a.stringToPDFString)(n),order:o}:null}const r=this.xref,n=new i.RefSet,s=10;return{name:(0,a.isString)(e.get("Name"))?(0,a.stringToPDFString)(e.get("Name")):null,creator:(0,a.isString)(e.get("Creator"))?(0,a.stringToPDFString)(e.get("Creator")):null,baseState:(0,i.isName)(e.get("BaseState"))?e.get("BaseState").name:null,on:parseOnOff(e.get("ON")),off:parseOnOff(e.get("OFF")),order:parseOrder(e.get("Order")),groups:null}}get numPages(){const e=this.toplevelPagesDict.get("Count");if(!Number.isInteger(e))throw new a.FormatError("Page count in top-level pages dictionary is not an integer.");return(0,a.shadow)(this,"numPages",e)}get destinations(){const e=this._readDests(),t=Object.create(null);if(e instanceof NameTree){const r=e.getAll();for(const e in r)t[e]=fetchDestination(r[e])}else e instanceof i.Dict&&e.forEach((function(e,r){r&&(t[e]=fetchDestination(r))}));return(0,a.shadow)(this,"destinations",t)}getDestination(e){const t=this._readDests();return t instanceof NameTree||t instanceof i.Dict?fetchDestination(t.get(e)||null):null}_readDests(){const e=this._catDict.get("Names");return e&&e.has("Dests")?new NameTree(e.getRaw("Dests"),this.xref):this._catDict.has("Dests")?this._catDict.get("Dests"):void 0}get pageLabels(){let e=null;try{e=this._readPageLabels()}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)("Unable to read page labels.")}return(0,a.shadow)(this,"pageLabels",e)}_readPageLabels(){const e=this._catDict.getRaw("PageLabels");if(!e)return null;const t=new Array(this.numPages);let r=null,s="";const o=new NumberTree(e,this.xref).getAll();let c="",l=1;for(let e=0,h=this.numPages;e<h;e++){if(e in o){const t=o[e];if(!(0,i.isDict)(t))throw new a.FormatError("PageLabel is not a dictionary.");if(t.has("Type")&&!(0,i.isName)(t.get("Type"),"PageLabel"))throw new a.FormatError("Invalid type in PageLabel dictionary.");if(t.has("S")){const e=t.get("S");if(!(0,i.isName)(e))throw new a.FormatError("Invalid style in PageLabel dictionary.");r=e.name}else r=null;if(t.has("P")){const e=t.get("P");if(!(0,a.isString)(e))throw new a.FormatError("Invalid prefix in PageLabel dictionary.");s=(0,a.stringToPDFString)(e)}else s="";if(t.has("St")){const e=t.get("St");if(!(Number.isInteger(e)&&e>=1))throw new a.FormatError("Invalid start in PageLabel dictionary.");l=e}else l=1}switch(r){case"D":c=l;break;case"R":case"r":c=(0,n.toRomanNumerals)(l,"r"===r);break;case"A":case"a":const e=26,t=65,i=97,s="a"===r?i:t,o=l-1,h=String.fromCharCode(s+o%e),u=[];for(let t=0,r=o/e|0;t<=r;t++)u.push(h);c=u.join("");break;default:if(r)throw new a.FormatError(`Invalid style "${r}" in PageLabel dictionary.`);c=""}t[e]=s+c;l++}return t}get pageLayout(){const e=this._catDict.get("PageLayout");let t="";if((0,i.isName)(e))switch(e.name){case"SinglePage":case"OneColumn":case"TwoColumnLeft":case"TwoColumnRight":case"TwoPageLeft":case"TwoPageRight":t=e.name}return(0,a.shadow)(this,"pageLayout",t)}get pageMode(){const e=this._catDict.get("PageMode");let t="UseNone";if((0,i.isName)(e))switch(e.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"FullScreen":case"UseOC":case"UseAttachments":t=e.name}return(0,a.shadow)(this,"pageMode",t)}get viewerPreferences(){const e={HideToolbar:a.isBool,HideMenubar:a.isBool,HideWindowUI:a.isBool,FitWindow:a.isBool,CenterWindow:a.isBool,DisplayDocTitle:a.isBool,NonFullScreenPageMode:i.isName,Direction:i.isName,ViewArea:i.isName,ViewClip:i.isName,PrintArea:i.isName,PrintClip:i.isName,PrintScaling:i.isName,Duplex:i.isName,PickTrayByPDFSize:a.isBool,PrintPageRange:Array.isArray,NumCopies:Number.isInteger},t=this._catDict.get("ViewerPreferences");let r=null;if((0,i.isDict)(t))for(const i in e){if(!t.has(i))continue;const n=t.get(i);if(!e[i](n)){(0,a.info)(`Bad value in ViewerPreferences for "${i}".`);continue}let s;switch(i){case"NonFullScreenPageMode":switch(n.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"UseOC":s=n.name;break;default:s="UseNone"}break;case"Direction":switch(n.name){case"L2R":case"R2L":s=n.name;break;default:s="L2R"}break;case"ViewArea":case"ViewClip":case"PrintArea":case"PrintClip":switch(n.name){case"MediaBox":case"CropBox":case"BleedBox":case"TrimBox":case"ArtBox":s=n.name;break;default:s="CropBox"}break;case"PrintScaling":switch(n.name){case"None":case"AppDefault":s=n.name;break;default:s="AppDefault"}break;case"Duplex":switch(n.name){case"Simplex":case"DuplexFlipShortEdge":case"DuplexFlipLongEdge":s=n.name;break;default:s="None"}break;case"PrintPageRange":if(n.length%2!=0)break;n.every(((e,t,r)=>Number.isInteger(e)&&e>0&&(0===t||e>=r[t-1])&&e<=this.numPages))&&(s=n);break;case"NumCopies":n>0&&(s=n);break;default:if("boolean"!=typeof n)throw new a.FormatError(`viewerPreferences - expected a boolean value for: ${i}`);s=n}if(void 0!==s){r||(r=Object.create(null));r[i]=s}else(0,a.info)(`Bad value in ViewerPreferences for "${i}".`)}return(0,a.shadow)(this,"viewerPreferences",r)}get openAction(){const e=this._catDict.get("OpenAction"),t=Object.create(null);if((0,i.isDict)(e)){const r=new i.Dict(this.xref);r.set("A",e);const a={url:null,dest:null,action:null};Catalog.parseDestDictionary({destDict:r,resultObj:a});Array.isArray(a.dest)?t.dest=a.dest:a.action&&(t.action=a.action)}else Array.isArray(e)&&(t.dest=e);return(0,a.shadow)(this,"openAction",(0,a.objectSize)(t)>0?t:null)}get attachments(){const e=this._catDict.get("Names");let t=null;if(e&&e.has("EmbeddedFiles")){const r=new NameTree(e.getRaw("EmbeddedFiles"),this.xref).getAll();for(const e in r){const i=new d(r[e],this.xref);t||(t=Object.create(null));t[(0,a.stringToPDFString)(e)]=i.serializable}}return(0,a.shadow)(this,"attachments",t)}_collectJavaScript(){const e=this._catDict.get("Names");let t=null;function appendIfJavaScriptDict(e,r){const n=r.get("S");if(!(0,i.isName)(n,"JavaScript"))return;let s=r.get("JS");if((0,i.isStream)(s))s=(0,a.bytesToString)(s.getBytes());else if(!(0,a.isString)(s))return;null===t&&(t=Object.create(null));t[e]=(0,a.stringToPDFString)(s)}if(e&&e.has("JavaScript")){const t=new NameTree(e.getRaw("JavaScript"),this.xref).getAll();for(const e in t){const r=t[e];(0,i.isDict)(r)&&appendIfJavaScriptDict(e,r)}}const r=this._catDict.get("OpenAction");(0,i.isDict)(r)&&(0,i.isName)(r.get("S"),"JavaScript")&&appendIfJavaScriptDict("OpenAction",r);return t}get javaScript(){const e=this._collectJavaScript();return(0,a.shadow)(this,"javaScript",e?Object.values(e):null)}get jsActions(){const e=this._collectJavaScript();let t=(0,n.collectActions)(this.xref,this._catDict,a.DocumentActionEventType);!t&&e&&(t=Object.create(null));if(t&&e)for(const[r,a]of Object.entries(e))r in t?t[r].push(a):t[r]=[a];return(0,a.shadow)(this,"jsActions",t)}fontFallback(e,t){const r=[];this.fontCache.forEach((function(e){r.push(e)}));return Promise.all(r).then((r=>{for(const a of r)if(a.loadedName===e){a.fallback(t);return}}))}cleanup(e=!1){(0,i.clearPrimitiveCaches)();this.globalImageCache.clear(e);this.pageKidsCountCache.clear();this.nonBlendModesSet.clear();const t=[];this.fontCache.forEach((function(e){t.push(e)}));return Promise.all(t).then((e=>{for(const{dict:t}of e)delete t.cacheKey;this.fontCache.clear();this.builtInCMapCache.clear()}))}getPageDict(e){const t=(0,a.createPromiseCapability)(),r=[this._catDict.getRaw("Pages")],n=new i.RefSet,s=this.xref,o=this.pageKidsCountCache;let c,l=0;!function next(){for(;r.length;){const h=r.pop();if((0,i.isRef)(h)){c=o.get(h);if(c>0&&l+c<e){l+=c;continue}if(n.has(h)){t.reject(new a.FormatError("Pages tree contains circular reference."));return}n.put(h);s.fetchAsync(h).then((function(a){if((0,i.isDict)(a,"Page")||(0,i.isDict)(a)&&!a.has("Kids"))if(e===l){h&&!o.has(h)&&o.put(h,1);t.resolve([a,h])}else{l++;next()}else{r.push(a);next()}}),t.reject);return}if(!(0,i.isDict)(h)){t.reject(new a.FormatError("Page dictionary kid reference points to wrong type of object."));return}c=h.get("Count");if(Number.isInteger(c)&&c>=0){const t=h.objId;t&&!o.has(t)&&o.put(t,c);if(l+c<=e){l+=c;continue}}const u=h.get("Kids");if(!Array.isArray(u)){if((0,i.isName)(h.get("Type"),"Page")||!h.has("Type")&&h.has("Contents")){if(l===e){t.resolve([h,null]);return}l++;continue}t.reject(new a.FormatError("Page dictionary kids object is not an array."));return}for(let e=u.length-1;e>=0;e--)r.push(u[e])}t.reject(new Error(`Page index ${e} not found.`))}();return t.promise}getPageIndex(e){const t=this.xref;let r=0;return function next(n){return function pagesBeforeRef(r){let n,s=0;return t.fetchAsync(r).then((function(t){if((0,i.isRefsEqual)(r,e)&&!(0,i.isDict)(t,"Page")&&(!(0,i.isDict)(t)||t.has("Type")||!t.has("Contents")))throw new a.FormatError("The reference does not point to a /Page dictionary.");if(!t)return null;if(!(0,i.isDict)(t))throw new a.FormatError("Node must be a dictionary.");n=t.getRaw("Parent");return t.getAsync("Parent")})).then((function(e){if(!e)return null;if(!(0,i.isDict)(e))throw new a.FormatError("Parent must be a dictionary.");return e.getAsync("Kids")})).then((function(e){if(!e)return null;const o=[];let c=!1;for(let n=0,l=e.length;n<l;n++){const l=e[n];if(!(0,i.isRef)(l))throw new a.FormatError("Kid must be a reference.");if((0,i.isRefsEqual)(l,r)){c=!0;break}o.push(t.fetchAsync(l).then((function(e){if(!(0,i.isDict)(e))throw new a.FormatError("Kid node must be a dictionary.");e.has("Count")?s+=e.get("Count"):s++})))}if(!c)throw new a.FormatError("Kid reference not found in parent's kids.");return Promise.all(o).then((function(){return[s,n]}))}))}(n).then((function(e){if(!e)return r;const[t,a]=e;r+=t;return next(a)}))}(e)}static parseDestDictionary(e){const t=e.destDict;if(!(0,i.isDict)(t)){(0,a.warn)("parseDestDictionary: `destDict` must be a dictionary.");return}const r=e.resultObj;if("object"!=typeof r){(0,a.warn)("parseDestDictionary: `resultObj` must be an object.");return}const n=e.docBaseUrl||null;let s,o,c=t.get("A");if(!(0,i.isDict)(c))if(t.has("Dest"))c=t.get("Dest");else{c=t.get("AA");(0,i.isDict)(c)&&(c.has("D")?c=c.get("D"):c.has("U")&&(c=c.get("U")))}if((0,i.isDict)(c)){const e=c.get("S");if(!(0,i.isName)(e)){(0,a.warn)("parseDestDictionary: Invalid type in Action dictionary.");return}const t=e.name;switch(t){case"URI":s=c.get("URI");(0,i.isName)(s)?s="/"+s.name:(0,a.isString)(s)&&(s=function addDefaultProtocolToUrl(e){return e.startsWith("www.")?`http://${e}`:e}(s));break;case"GoTo":o=c.get("D");break;case"Launch":case"GoToR":const e=c.get("F");(0,i.isDict)(e)?s=e.get("F")||null:(0,a.isString)(e)&&(s=e);let n=c.get("D");if(n){(0,i.isName)(n)&&(n=n.name);if((0,a.isString)(s)){const e=s.split("#")[0];(0,a.isString)(n)?s=e+"#"+n:Array.isArray(n)&&(s=e+"#"+JSON.stringify(n))}}const l=c.get("NewWindow");(0,a.isBool)(l)&&(r.newWindow=l);break;case"Named":const h=c.get("N");(0,i.isName)(h)&&(r.action=h.name);break;case"JavaScript":const u=c.get("JS");let d;(0,i.isStream)(u)?d=(0,a.bytesToString)(u.getBytes()):(0,a.isString)(u)&&(d=u);if(d){const e=new RegExp("^\\s*("+["app.launchURL","window.open"].join("|").split(".").join("\\.")+")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))","i").exec((0,a.stringToPDFString)(d));if(e&&e[2]){s=e[2];"true"===e[3]&&"app.launchURL"===e[1]&&(r.newWindow=!0);break}}default:if("JavaScript"===t||"ResetForm"===t||"SubmitForm"===t)break;(0,a.warn)(`parseDestDictionary - unsupported action: "${t}".`)}}else t.has("Dest")&&(o=t.get("Dest"));if((0,a.isString)(s)){s=function tryConvertUrlEncoding(e){try{return(0,a.stringToUTF8String)(e)}catch(t){return e}}(s);const e=(0,a.createValidAbsoluteUrl)(s,n);e&&(r.url=e.href);r.unsafeUrl=s}if(o){(0,i.isName)(o)&&(o=o.name);((0,a.isString)(o)||Array.isArray(o))&&(r.dest=o)}}}t.Catalog=Catalog;var u=function XRefClosure(){function XRef(e,t){this.stream=e;this.pdfManager=t;this.entries=[];this.xrefstms=Object.create(null);this._cacheMap=new Map;this.stats={streamTypes:Object.create(null),fontTypes:Object.create(null)};this._newRefNum=null}XRef.prototype={getNewRef:function XRef_getNewRef(){null===this._newRefNum&&(this._newRefNum=this.entries.length);return i.Ref.get(this._newRefNum++,0)},resetNewRef:function XRef_resetNewRef(){this._newRefNum=null},setStartXRef:function XRef_setStartXRef(e){this.startXRefQueue=[e]},parse:function XRef_parse(e){var t;if(e){(0,a.warn)("Indexing all PDF objects");t=this.indexObjects()}else t=this.readXRef();t.assignXref(this);this.trailer=t;let r,s;try{r=t.get("Encrypt")}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`XRef.parse - Invalid "Encrypt" reference: "${e}".`)}if((0,i.isDict)(r)){var c=t.get("ID"),l=c&&c.length?c[0]:"";r.suppressEncryption=!0;this.encrypt=new o.CipherTransformFactory(r,l,this.pdfManager.password)}try{s=t.get("Root")}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.warn)(`XRef.parse - Invalid "Root" reference: "${e}".`)}if(!(0,i.isDict)(s)||!s.has("Pages")){if(!e)throw new n.XRefParseException;throw new a.FormatError("Invalid root reference")}this.root=s},processXRefTable:function XRef_processXRefTable(e){"tableState"in this||(this.tableState={entryNum:0,streamPos:e.lexer.stream.pos,parserBuf1:e.buf1,parserBuf2:e.buf2});var t=this.readXRefTable(e);if(!(0,i.isCmd)(t,"trailer"))throw new a.FormatError("Invalid XRef table: could not find trailer dictionary");var r=e.getObj();!(0,i.isDict)(r)&&r.dict&&(r=r.dict);if(!(0,i.isDict)(r))throw new a.FormatError("Invalid XRef table: could not parse trailer dictionary");delete this.tableState;return r},readXRefTable:function XRef_readXRefTable(e){var t,r=e.lexer.stream,n=this.tableState;r.pos=n.streamPos;e.buf1=n.parserBuf1;e.buf2=n.parserBuf2;for(;;){if(!("firstEntryNum"in n)||!("entryCount"in n)){if((0,i.isCmd)(t=e.getObj(),"trailer"))break;n.firstEntryNum=t;n.entryCount=e.getObj()}var s=n.firstEntryNum,o=n.entryCount;if(!Number.isInteger(s)||!Number.isInteger(o))throw new a.FormatError("Invalid XRef table: wrong types in subsection header");for(var c=n.entryNum;c<o;c++){n.streamPos=r.pos;n.entryNum=c;n.parserBuf1=e.buf1;n.parserBuf2=e.buf2;var l={};l.offset=e.getObj();l.gen=e.getObj();var h=e.getObj();if(h instanceof i.Cmd)switch(h.cmd){case"f":l.free=!0;break;case"n":l.uncompressed=!0}if(!Number.isInteger(l.offset)||!Number.isInteger(l.gen)||!l.free&&!l.uncompressed)throw new a.FormatError(`Invalid entry in XRef subsection: ${s}, ${o}`);0===c&&l.free&&1===s&&(s=0);this.entries[c+s]||(this.entries[c+s]=l)}n.entryNum=0;n.streamPos=r.pos;n.parserBuf1=e.buf1;n.parserBuf2=e.buf2;delete n.firstEntryNum;delete n.entryCount}if(this.entries[0]&&!this.entries[0].free)throw new a.FormatError("Invalid XRef table: unexpected first object");return t},processXRefStream:function XRef_processXRefStream(e){if(!("streamState"in this)){var t=e.dict,r=t.get("W"),a=t.get("Index");a||(a=[0,t.get("Size")]);this.streamState={entryRanges:a,byteWidths:r,entryNum:0,streamPos:e.pos}}this.readXRefStream(e);delete this.streamState;return e.dict},readXRefStream:function XRef_readXRefStream(e){var t,r,i=this.streamState;e.pos=i.streamPos;for(var n=i.byteWidths,s=n[0],o=n[1],c=n[2],l=i.entryRanges;l.length>0;){var h=l[0],u=l[1];if(!Number.isInteger(h)||!Number.isInteger(u))throw new a.FormatError(`Invalid XRef range fields: ${h}, ${u}`);if(!Number.isInteger(s)||!Number.isInteger(o)||!Number.isInteger(c))throw new a.FormatError(`Invalid XRef entry fields length: ${h}, ${u}`);for(t=i.entryNum;t<u;++t){i.entryNum=t;i.streamPos=e.pos;var d=0,f=0,g=0;for(r=0;r<s;++r)d=d<<8|e.getByte();0===s&&(d=1);for(r=0;r<o;++r)f=f<<8|e.getByte();for(r=0;r<c;++r)g=g<<8|e.getByte();var p={};p.offset=f;p.gen=g;switch(d){case 0:p.free=!0;break;case 1:p.uncompressed=!0;break;case 2:break;default:throw new a.FormatError(`Invalid XRef entry type: ${d}`)}this.entries[h+t]||(this.entries[h+t]=p)}i.entryNum=0;i.streamPos=e.pos;l.splice(0,2)}},indexObjects:function XRef_indexObjects(){function readToken(e,t){for(var r="",a=e[t];10!==a&&13!==a&&60!==a&&!(++t>=e.length);){r+=String.fromCharCode(a);a=e[t]}return r}function skipUntil(e,t,r){for(var a=r.length,i=e.length,n=0;t<i;){for(var s=0;s<a&&e[t+s]===r[s];)++s;if(s>=a)break;t++;n++}return n}var e=/^(\d+)\s+(\d+)\s+obj\b/;const t=/\bendobj[\b\s]$/,r=/\s+(\d+\s+\d+\s+obj[\b\s<])$/;var n=new Uint8Array([116,114,97,105,108,101,114]),o=new Uint8Array([115,116,97,114,116,120,114,101,102]);const c=new Uint8Array([111,98,106]);var l=new Uint8Array([47,88,82,101,102]);this.entries.length=0;var h=this.stream;h.pos=0;for(var u=h.getBytes(),d=h.start,f=u.length,g=[],p=[];d<f;){var m=u[d];if(9!==m&&10!==m&&13!==m&&32!==m)if(37!==m){var b,y=readToken(u,d);if(y.startsWith("xref")&&(4===y.length||/\s/.test(y[4]))){d+=skipUntil(u,d,n);g.push(d);d+=skipUntil(u,d,o)}else if(b=e.exec(y)){const e=0|b[1],i=0|b[2];this.entries[e]&&this.entries[e].gen!==i||(this.entries[e]={offset:d-h.start,gen:i,uncompressed:!0});let n,s=d+y.length;for(;s<u.length;){const e=s+skipUntil(u,s,c)+4;n=e-d;const i=Math.max(e-25,s),o=(0,a.bytesToString)(u.subarray(i,e));if(t.test(o))break;{const e=r.exec(o);if(e&&e[1]){(0,a.warn)('indexObjects: Found new "obj" inside of another "obj", caused by missing "endobj" -- trying to recover.');n-=e[1].length;break}}s=e}const o=u.subarray(d,d+n);var w=skipUntil(o,0,l);if(w<n&&o[w+5]<64){p.push(d-h.start);this.xrefstms[d-h.start]=1}d+=n}else if(y.startsWith("trailer")&&(7===y.length||/\s/.test(y[7]))){g.push(d);d+=skipUntil(u,d,o)}else d+=y.length+1}else do{if(++d>=f)break;m=u[d]}while(10!==m&&13!==m);else++d}for(let e=0,t=p.length;e<t;++e){this.startXRefQueue.push(p[e]);this.readXRef(!0)}let S;for(let e=0,t=g.length;e<t;++e){h.pos=g[e];const t=new s.Parser({lexer:new s.Lexer(h),xref:this,allowStreams:!0,recoveryMode:!0});var v=t.getObj();if(!(0,i.isCmd)(v,"trailer"))continue;const r=t.getObj();if((0,i.isDict)(r)){try{const e=r.get("Root");if(!(e instanceof i.Dict))continue;const t=e.get("Pages");if(!(t instanceof i.Dict))continue;const a=t.get("Count");if(!Number.isInteger(a))continue}catch(e){continue}if(r.has("ID"))return r;S=r}}if(S)return S;throw new a.InvalidPDFException("Invalid PDF structure.")},readXRef:function XRef_readXRef(e){var t=this.stream;const r=Object.create(null);try{for(;this.startXRefQueue.length;){var o=this.startXRefQueue[0];if(r[o]){(0,a.warn)("readXRef - skipping XRef table since it was already parsed.");this.startXRefQueue.shift();continue}r[o]=!0;t.pos=o+t.start;const e=new s.Parser({lexer:new s.Lexer(t),xref:this,allowStreams:!0});var c,l=e.getObj();if((0,i.isCmd)(l,"xref")){c=this.processXRefTable(e);this.topDict||(this.topDict=c);l=c.get("XRefStm");if(Number.isInteger(l)){var h=l;if(!(h in this.xrefstms)){this.xrefstms[h]=1;this.startXRefQueue.push(h)}}}else{if(!Number.isInteger(l))throw new a.FormatError("Invalid XRef stream header");if(!Number.isInteger(e.getObj())||!(0,i.isCmd)(e.getObj(),"obj")||!(0,i.isStream)(l=e.getObj()))throw new a.FormatError("Invalid XRef stream");c=this.processXRefStream(l);this.topDict||(this.topDict=c);if(!c)throw new a.FormatError("Failed to read XRef stream")}l=c.get("Prev");Number.isInteger(l)?this.startXRefQueue.push(l):(0,i.isRef)(l)&&this.startXRefQueue.push(l.num);this.startXRefQueue.shift()}return this.topDict}catch(e){if(e instanceof n.MissingDataException)throw e;(0,a.info)("(while reading XRef): "+e)}if(!e)throw new n.XRefParseException},getEntry:function XRef_getEntry(e){var t=this.entries[e];return t&&!t.free&&t.offset?t:null},fetchIfRef:function XRef_fetchIfRef(e,t){return e instanceof i.Ref?this.fetch(e,t):e},fetch:function XRef_fetch(e,t){if(!(e instanceof i.Ref))throw new Error("ref object is not a reference");const r=e.num,a=this._cacheMap.get(r);if(void 0!==a){a instanceof i.Dict&&!a.objId&&(a.objId=e.toString());return a}let n=this.getEntry(r);if(null===n){this._cacheMap.set(r,n);return n}n=n.uncompressed?this.fetchUncompressed(e,n,t):this.fetchCompressed(e,n,t);(0,i.isDict)(n)?n.objId=e.toString():(0,i.isStream)(n)&&(n.dict.objId=e.toString());return n},fetchUncompressed(e,t,r=!1){var a=e.gen,o=e.num;if(t.gen!==a)throw new n.XRefEntryException(`Inconsistent generation in XRef: ${e}`);var c=this.stream.makeSubStream(t.offset+this.stream.start);const l=new s.Parser({lexer:new s.Lexer(c),xref:this,allowStreams:!0});var h=l.getObj(),u=l.getObj(),d=l.getObj();if(h!==o||u!==a||!(d instanceof i.Cmd))throw new n.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`);if("obj"!==d.cmd){if(d.cmd.startsWith("obj")){o=parseInt(d.cmd.substring(3),10);if(!Number.isNaN(o))return o}throw new n.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`)}t=this.encrypt&&!r?l.getObj(this.encrypt.createCipherTransform(o,a)):l.getObj();(0,i.isStream)(t)||this._cacheMap.set(o,t);return t},fetchCompressed(e,t,r=!1){const o=t.offset,c=this.fetch(i.Ref.get(o,0));if(!(0,i.isStream)(c))throw new a.FormatError("bad ObjStm stream");const l=c.dict.get("First"),h=c.dict.get("N");if(!Number.isInteger(l)||!Number.isInteger(h))throw new a.FormatError("invalid first and n parameters for ObjStm stream");let u=new s.Parser({lexer:new s.Lexer(c),xref:this,allowStreams:!0});const d=new Array(h),f=new Array(h);for(let e=0;e<h;++e){const t=u.getObj();if(!Number.isInteger(t))throw new a.FormatError(`invalid object number in the ObjStm stream: ${t}`);const r=u.getObj();if(!Number.isInteger(r))throw new a.FormatError(`invalid object offset in the ObjStm stream: ${r}`);d[e]=t;f[e]=r}const g=(c.start||0)+l,p=new Array(h);for(let e=0;e<h;++e){const t=e<h-1?f[e+1]-f[e]:void 0;if(t<0)throw new a.FormatError("Invalid offset in the ObjStm stream.");u=new s.Parser({lexer:new s.Lexer(c.makeSubStream(g+f[e],t,c.dict)),xref:this,allowStreams:!0});const r=u.getObj();p[e]=r;if((0,i.isStream)(r))continue;const n=d[e],l=this.entries[n];l&&l.offset===o&&l.gen===e&&this._cacheMap.set(n,r)}if(void 0===(t=p[t.gen]))throw new n.XRefEntryException(`Bad (compressed) XRef entry: ${e}`);return t},async fetchIfRefAsync(e,t){return e instanceof i.Ref?this.fetchAsync(e,t):e},async fetchAsync(e,t){try{return this.fetch(e,t)}catch(r){if(!(r instanceof n.MissingDataException))throw r;await this.pdfManager.requestRange(r.begin,r.end);return this.fetchAsync(e,t)}},getCatalogObj:function XRef_getCatalogObj(){return this.root}};return XRef}();t.XRef=u;class NameOrNumberTree{constructor(e,t,r){this.constructor===NameOrNumberTree&&(0,a.unreachable)("Cannot initialize NameOrNumberTree.");this.root=e;this.xref=t;this._type=r}getAll(){const e=Object.create(null);if(!this.root)return e;const t=this.xref,r=new i.RefSet;r.put(this.root);const n=[this.root];for(;n.length>0;){const s=t.fetchIfRef(n.shift());if(!(0,i.isDict)(s))continue;if(s.has("Kids")){const e=s.get("Kids");for(let t=0,i=e.length;t<i;t++){const i=e[t];if(r.has(i))throw new a.FormatError(`Duplicate entry in "${this._type}" tree.`);n.push(i);r.put(i)}continue}const o=s.get(this._type);if(Array.isArray(o))for(let r=0,a=o.length;r<a;r+=2)e[t.fetchIfRef(o[r])]=t.fetchIfRef(o[r+1])}return e}get(e){if(!this.root)return null;const t=this.xref;let r=t.fetchIfRef(this.root),i=0;for(;r.has("Kids");){if(++i>10){(0,a.warn)(`Search depth limit reached for "${this._type}" tree.`);return null}const n=r.get("Kids");if(!Array.isArray(n))return null;let s=0,o=n.length-1;for(;s<=o;){const a=s+o>>1,i=t.fetchIfRef(n[a]).get("Limits");if(e<t.fetchIfRef(i[0]))o=a-1;else{if(!(e>t.fetchIfRef(i[1]))){r=t.fetchIfRef(n[a]);break}s=a+1}}if(s>o)return null}const n=r.get(this._type);if(Array.isArray(n)){let r=0,i=n.length-2;for(;r<=i;){const a=r+i>>1,s=a+(1&a),o=t.fetchIfRef(n[s]);if(e<o)i=s-2;else{if(!(e>o))return t.fetchIfRef(n[s+1]);r=s+2}}(0,a.info)(`Falling back to an exhaustive search, for key "${e}", in "${this._type}" tree.`);for(let r=0,i=n.length;r<i;r+=2){if(t.fetchIfRef(n[r])===e){(0,a.warn)(`The "${e}" key was found at an incorrect, i.e. out-of-order, position in "${this._type}" tree.`);return t.fetchIfRef(n[r+1])}}}return null}}class NameTree extends NameOrNumberTree{constructor(e,t){super(e,t,"Names")}}class NumberTree extends NameOrNumberTree{constructor(e,t){super(e,t,"Nums")}}var d=function FileSpecClosure(){function FileSpec(e,t){if(e&&(0,i.isDict)(e)){this.xref=t;this.root=e;e.has("FS")&&(this.fs=e.get("FS"));this.description=e.has("Desc")?(0,a.stringToPDFString)(e.get("Desc")):"";e.has("RF")&&(0,a.warn)("Related file specifications are not supported");this.contentAvailable=!0;if(!e.has("EF")){this.contentAvailable=!1;(0,a.warn)("Non-embedded file specifications are not supported")}}}function pickPlatformItem(e){return e.has("UF")?e.get("UF"):e.has("F")?e.get("F"):e.has("Unix")?e.get("Unix"):e.has("Mac")?e.get("Mac"):e.has("DOS")?e.get("DOS"):null}FileSpec.prototype={get filename(){if(!this._filename&&this.root){var e=pickPlatformItem(this.root)||"unnamed";this._filename=(0,a.stringToPDFString)(e).replace(/\\\\/g,"\\").replace(/\\\//g,"/").replace(/\\/g,"/")}return this._filename},get content(){if(!this.contentAvailable)return null;!this.contentRef&&this.root&&(this.contentRef=pickPlatformItem(this.root.get("EF")));var e=null;if(this.contentRef){var t=this.xref.fetchIfRef(this.contentRef);t&&(0,i.isStream)(t)?e=t.getBytes():(0,a.warn)("Embedded file specification points to non-existing/invalid content")}else(0,a.warn)("Embedded file specification does not have a content");return e},get serializable(){return{filename:this.filename,content:this.content}}};return FileSpec}();t.FileSpec=d;const f=function(){function addChildren(e,t){if(e instanceof i.Dict)e=e.getRawValues();else if((0,i.isStream)(e))e=e.dict.getRawValues();else if(!Array.isArray(e))return;for(const a of e)((r=a)instanceof i.Ref||r instanceof i.Dict||Array.isArray(r)||(0,i.isStream)(r))&&t.push(a);var r}function ObjectLoader(e,t,r){this.dict=e;this.keys=t;this.xref=r;this.refSet=null}ObjectLoader.prototype={async load(){if(!this.xref.stream.allChunksLoaded||this.xref.stream.allChunksLoaded())return;const{keys:e,dict:t}=this;this.refSet=new i.RefSet;const r=[];for(let a=0,i=e.length;a<i;a++){const i=t.getRaw(e[a]);void 0!==i&&r.push(i)}return this._walk(r)},async _walk(e){const t=[],r=[];for(;e.length;){let s=e.pop();if(s instanceof i.Ref){if(this.refSet.has(s))continue;try{this.refSet.put(s);s=this.xref.fetch(s)}catch(e){if(!(e instanceof n.MissingDataException)){(0,a.warn)(`ObjectLoader._walk - requesting all data: "${e}".`);this.refSet=null;const{manager:t}=this.xref.stream;return t.requestAllChunks()}t.push(s);r.push({begin:e.begin,end:e.end})}}if(s&&s.getBaseStreams){const e=s.getBaseStreams();let a=!1;for(let t=0,i=e.length;t<i;t++){const i=e[t];if(i.allChunksLoaded&&!i.allChunksLoaded()){a=!0;r.push({begin:i.start,end:i.end})}}a&&t.push(s)}addChildren(s,e)}if(r.length){await this.xref.stream.manager.requestRanges(r);for(let e=0,r=t.length;e<r;e++){const r=t[e];r instanceof i.Ref&&this.refSet.remove(r)}return this._walk(t)}this.refSet=null}};return ObjectLoader}();t.ObjectLoader=f},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Parser=t.Linearization=t.Lexer=void 0;var a=r(12),i=r(2),n=r(5),s=r(8),o=r(13),c=r(15),l=r(18),h=r(20);function computeAdler32(e){const t=e.length;let r=1,a=0;for(let i=0;i<t;++i){r+=255&e[i];a+=r}return a%65521<<16|r%65521}class Parser{constructor({lexer:e,xref:t,allowStreams:r=!1,recoveryMode:a=!1}){this.lexer=e;this.xref=t;this.allowStreams=r;this.recoveryMode=a;this.imageCache=Object.create(null);this.refill()}refill(){this.buf1=this.lexer.getObj();this.buf2=this.lexer.getObj()}shift(){if(this.buf2 instanceof n.Cmd&&"ID"===this.buf2.cmd){this.buf1=this.buf2;this.buf2=null}else{this.buf1=this.buf2;this.buf2=this.lexer.getObj()}}tryShift(){try{this.shift();return!0}catch(e){if(e instanceof s.MissingDataException)throw e;return!1}}getObj(e=null){const t=this.buf1;this.shift();if(t instanceof n.Cmd)switch(t.cmd){case"BI":return this.makeInlineImage(e);case"[":const r=[];for(;!(0,n.isCmd)(this.buf1,"]")&&!(0,n.isEOF)(this.buf1);)r.push(this.getObj(e));if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside array");return r}this.shift();return r;case"<<":const a=new n.Dict(this.xref);for(;!(0,n.isCmd)(this.buf1,">>")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1)){(0,i.info)("Malformed dictionary: key must be a name object");this.shift();continue}const t=this.buf1.name;this.shift();if((0,n.isEOF)(this.buf1))break;a.set(t,this.getObj(e))}if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside dictionary");return a}if((0,n.isCmd)(this.buf2,"stream"))return this.allowStreams?this.makeStream(a,e):a;this.shift();return a;default:return t}if(Number.isInteger(t)){if(Number.isInteger(this.buf1)&&(0,n.isCmd)(this.buf2,"R")){const e=n.Ref.get(t,this.buf1);this.shift();this.shift();return e}return t}return"string"==typeof t&&e?e.decryptString(t):t}findDefaultInlineStreamEnd(e){const t=this.lexer,r=e.pos;let a,o,c=0;for(;-1!==(a=e.getByte());)if(0===c)c=69===a?1:0;else if(1===c)c=73===a?2:0;else{(0,i.assert)(2===c,"findDefaultInlineStreamEnd - invalid state.");if(32===a||10===a||13===a){o=e.pos;const r=e.peekBytes(10);for(let e=0,t=r.length;e<t;e++){a=r[e];if((0!==a||0===r[e+1])&&(10!==a&&13!==a&&(a<32||a>127))){c=0;break}}if(2!==c)continue;if(t.knownCommands){const e=t.peekObj();e instanceof n.Cmd&&!t.knownCommands[e.cmd]&&(c=0)}else(0,i.warn)("findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.");if(2===c)break}else c=0}if(-1===a){(0,i.warn)("findDefaultInlineStreamEnd: Reached the end of the stream without finding a valid EI marker");if(o){(0,i.warn)('... trying to recover by using the last "EI" occurrence.');e.skip(-(e.pos-o))}}let l=4;e.skip(-l);a=e.peekByte();e.skip(l);(0,s.isWhiteSpace)(a)||l--;return e.pos-l-r}findDCTDecodeInlineStreamEnd(e){const t=e.pos;let r,a,n=!1;for(;-1!==(r=e.getByte());)if(255===r){switch(e.getByte()){case 0:break;case 255:e.skip(-1);break;case 217:n=!0;break;case 192:case 193:case 194:case 195:case 197:case 198:case 199:case 201:case 202:case 203:case 205:case 206:case 207:case 196:case 204:case 218:case 219:case 220:case 221:case 222:case 223:case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 254:a=e.getUint16();a>2?e.skip(a-2):e.skip(-2)}if(n)break}const s=e.pos-t;if(-1===r){(0,i.warn)("Inline DCTDecode image stream: EOI marker not found, searching for /EI/ instead.");e.skip(-s);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return s}findASCII85DecodeInlineStreamEnd(e){const t=e.pos;let r;for(;-1!==(r=e.getByte());)if(126===r){const t=e.pos;r=e.peekByte();for(;(0,s.isWhiteSpace)(r);){e.skip();r=e.peekByte()}if(62===r){e.skip();break}if(e.pos>t){const t=e.peekBytes(2);if(69===t[0]&&73===t[1])break}}const a=e.pos-t;if(-1===r){(0,i.warn)("Inline ASCII85Decode image stream: EOD marker not found, searching for /EI/ instead.");e.skip(-a);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return a}findASCIIHexDecodeInlineStreamEnd(e){const t=e.pos;let r;for(;-1!==(r=e.getByte())&&62!==r;);const a=e.pos-t;if(-1===r){(0,i.warn)("Inline ASCIIHexDecode image stream: EOD marker not found, searching for /EI/ instead.");e.skip(-a);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return a}inlineStreamSkipEI(e){let t,r=0;for(;-1!==(t=e.getByte());)if(0===r)r=69===t?1:0;else if(1===r)r=73===t?2:0;else if(2===r)break}makeInlineImage(e){const t=this.lexer,r=t.stream,a=new n.Dict(this.xref);let s;for(;!(0,n.isCmd)(this.buf1,"ID")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1))throw new i.FormatError("Dictionary key must be a name object");const t=this.buf1.name;this.shift();if((0,n.isEOF)(this.buf1))break;a.set(t,this.getObj(e))}-1!==t.beginInlineImagePos&&(s=r.pos-t.beginInlineImagePos);const o=a.get("Filter","F");let c;if((0,n.isName)(o))c=o.name;else if(Array.isArray(o)){const e=this.xref.fetchIfRef(o[0]);(0,n.isName)(e)&&(c=e.name)}const l=r.pos;let h;h="DCTDecode"===c||"DCT"===c?this.findDCTDecodeInlineStreamEnd(r):"ASCII85Decode"===c||"A85"===c?this.findASCII85DecodeInlineStreamEnd(r):"ASCIIHexDecode"===c||"AHx"===c?this.findASCIIHexDecodeInlineStreamEnd(r):this.findDefaultInlineStreamEnd(r);let u,d=r.makeSubStream(l,h,a);if(h<1e3&&s<5552){const e=d.getBytes();d.reset();const a=r.pos;r.pos=t.beginInlineImagePos;const i=r.getBytes(s);r.pos=a;u=computeAdler32(e)+"_"+computeAdler32(i);const o=this.imageCache[u];if(void 0!==o){this.buf2=n.Cmd.get("EI");this.shift();o.reset();return o}}e&&(d=e.createStream(d,h));d=this.filter(d,a,h);d.dict=a;if(void 0!==u){d.cacheKey=`inline_${h}_${u}`;this.imageCache[u]=d}this.buf2=n.Cmd.get("EI");this.shift();return d}_findStreamLength(e,t){const{stream:r}=this.lexer;r.pos=e;const a=t.length;for(;r.pos<r.end;){const i=r.peekBytes(2048),n=i.length-a;if(n<=0)break;let s=0;for(;s<n;){let n=0;for(;n<a&&i[s+n]===t[n];)n++;if(n>=a){r.pos+=s;return r.pos-e}s++}r.pos+=n}return-1}makeStream(e,t){const r=this.lexer;let a=r.stream;r.skipToNextLine();const o=a.pos-1;let c=e.get("Length");if(!Number.isInteger(c)){(0,i.info)(`Bad length "${c}" in stream`);c=0}a.pos=o+c;r.nextChar();if(this.tryShift()&&(0,n.isCmd)(this.buf2,"endstream"))this.shift();else{const e=new Uint8Array([101,110,100,115,116,114,101,97,109]);let t=this._findStreamLength(o,e);if(t<0){const r=1;for(let n=1;n<=r;n++){const r=e.length-n,c=e.slice(0,r),l=this._findStreamLength(o,c);if(l>=0){const e=a.peekBytes(r+1)[r];if(!(0,s.isWhiteSpace)(e))break;(0,i.info)(`Found "${(0,i.bytesToString)(c)}" when searching for endstream command.`);t=l;break}}if(t<0)throw new i.FormatError("Missing endstream command.")}c=t;r.nextChar();this.shift();this.shift()}this.shift();a=a.makeSubStream(o,c,e);t&&(a=t.createStream(a,c));a=this.filter(a,e,c);a.dict=e;return a}filter(e,t,r){let a=t.get("Filter","F"),s=t.get("DecodeParms","DP");if((0,n.isName)(a)){Array.isArray(s)&&(0,i.warn)("/DecodeParms should not contain an Array, when /Filter contains a Name.");return this.makeFilter(e,a.name,r,s)}let o=r;if(Array.isArray(a)){const t=a,r=s;for(let c=0,l=t.length;c<l;++c){a=this.xref.fetchIfRef(t[c]);if(!(0,n.isName)(a))throw new i.FormatError(`Bad filter name "${a}"`);s=null;Array.isArray(r)&&c in r&&(s=this.xref.fetchIfRef(r[c]));e=this.makeFilter(e,a.name,o,s);o=null}}return e}makeFilter(e,t,r,n){if(0===r){(0,i.warn)(`Empty "${t}" stream.`);return new a.NullStream}try{const s=this.xref.stats.streamTypes;if("FlateDecode"===t||"Fl"===t){s[i.StreamType.FLATE]=!0;return n?new a.PredictorStream(new a.FlateStream(e,r),r,n):new a.FlateStream(e,r)}if("LZWDecode"===t||"LZW"===t){s[i.StreamType.LZW]=!0;let t=1;if(n){n.has("EarlyChange")&&(t=n.get("EarlyChange"));return new a.PredictorStream(new a.LZWStream(e,r,t),r,n)}return new a.LZWStream(e,r,t)}if("DCTDecode"===t||"DCT"===t){s[i.StreamType.DCT]=!0;return new l.JpegStream(e,r,e.dict,n)}if("JPXDecode"===t||"JPX"===t){s[i.StreamType.JPX]=!0;return new h.JpxStream(e,r,e.dict,n)}if("ASCII85Decode"===t||"A85"===t){s[i.StreamType.A85]=!0;return new a.Ascii85Stream(e,r)}if("ASCIIHexDecode"===t||"AHx"===t){s[i.StreamType.AHX]=!0;return new a.AsciiHexStream(e,r)}if("CCITTFaxDecode"===t||"CCF"===t){s[i.StreamType.CCF]=!0;return new o.CCITTFaxStream(e,r,n)}if("RunLengthDecode"===t||"RL"===t){s[i.StreamType.RLX]=!0;return new a.RunLengthStream(e,r)}if("JBIG2Decode"===t){s[i.StreamType.JBIG]=!0;return new c.Jbig2Stream(e,r,e.dict,n)}(0,i.warn)(`Filter "${t}" is not supported.`);return e}catch(e){if(e instanceof s.MissingDataException)throw e;(0,i.warn)(`Invalid stream: "${e}"`);return new a.NullStream}}}t.Parser=Parser;const u=[1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];function toHexDigit(e){return e>=48&&e<=57?15&e:e>=65&&e<=70||e>=97&&e<=102?9+(15&e):-1}class Lexer{constructor(e,t=null){this.stream=e;this.nextChar();this.strBuf=[];this.knownCommands=t;this._hexStringNumWarn=0;this.beginInlineImagePos=-1}nextChar(){return this.currentChar=this.stream.getByte()}peekChar(){return this.stream.peekByte()}getNumber(){let e=this.currentChar,t=!1,r=0,a=0;if(45===e){a=-1;e=this.nextChar();45===e&&(e=this.nextChar())}else if(43===e){a=1;e=this.nextChar()}if(10===e||13===e)do{e=this.nextChar()}while(10===e||13===e);if(46===e){r=10;e=this.nextChar()}if(e<48||e>57){if(10===r&&0===a&&((0,s.isWhiteSpace)(e)||-1===e)){(0,i.warn)("Lexer.getNumber - treating a single decimal point as zero.");return 0}throw new i.FormatError(`Invalid number: ${String.fromCharCode(e)} (charCode ${e})`)}a=a||1;let n=e-48,o=0,c=1;for(;(e=this.nextChar())>=0;)if(e>=48&&e<=57){const a=e-48;if(t)o=10*o+a;else{0!==r&&(r*=10);n=10*n+a}}else if(46===e){if(0!==r)break;r=1}else if(45===e)(0,i.warn)("Badly formatted number: minus sign in the middle");else{if(69!==e&&101!==e)break;e=this.peekChar();if(43===e||45===e){c=45===e?-1:1;this.nextChar()}else if(e<48||e>57)break;t=!0}0!==r&&(n/=r);t&&(n*=10**(c*o));return a*n}getString(){let e=1,t=!1;const r=this.strBuf;r.length=0;let a=this.nextChar();for(;;){let n=!1;switch(0|a){case-1:(0,i.warn)("Unterminated string");t=!0;break;case 40:++e;r.push("(");break;case 41:if(0==--e){this.nextChar();t=!0}else r.push(")");break;case 92:a=this.nextChar();switch(a){case-1:(0,i.warn)("Unterminated string");t=!0;break;case 110:r.push("\n");break;case 114:r.push("\r");break;case 116:r.push("\t");break;case 98:r.push("\b");break;case 102:r.push("\f");break;case 92:case 40:case 41:r.push(String.fromCharCode(a));break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:let e=15&a;a=this.nextChar();n=!0;if(a>=48&&a<=55){e=(e<<3)+(15&a);a=this.nextChar();if(a>=48&&a<=55){n=!1;e=(e<<3)+(15&a)}}r.push(String.fromCharCode(e));break;case 13:10===this.peekChar()&&this.nextChar();break;case 10:break;default:r.push(String.fromCharCode(a))}break;default:r.push(String.fromCharCode(a))}if(t)break;n||(a=this.nextChar())}return r.join("")}getName(){let e,t;const r=this.strBuf;r.length=0;for(;(e=this.nextChar())>=0&&!u[e];)if(35===e){e=this.nextChar();if(u[e]){(0,i.warn)("Lexer_getName: NUMBER SIGN (#) should be followed by a hexadecimal number.");r.push("#");break}const a=toHexDigit(e);if(-1!==a){t=e;e=this.nextChar();const n=toHexDigit(e);if(-1===n){(0,i.warn)(`Lexer_getName: Illegal digit (${String.fromCharCode(e)}) in hexadecimal number.`);r.push("#",String.fromCharCode(t));if(u[e])break;r.push(String.fromCharCode(e));continue}r.push(String.fromCharCode(a<<4|n))}else r.push("#",String.fromCharCode(e))}else r.push(String.fromCharCode(e));r.length>127&&(0,i.warn)(`Name token is longer than allowed by the spec: ${r.length}`);return n.Name.get(r.join(""))}_hexStringWarn(e){5!=this._hexStringNumWarn++?this._hexStringNumWarn>5||(0,i.warn)(`getHexString - ignoring invalid character: ${e}`):(0,i.warn)("getHexString - ignoring additional invalid characters.")}getHexString(){const e=this.strBuf;e.length=0;let t,r,a=this.currentChar,n=!0;this._hexStringNumWarn=0;for(;;){if(a<0){(0,i.warn)("Unterminated hex string");break}if(62===a){this.nextChar();break}if(1!==u[a]){if(n){t=toHexDigit(a);if(-1===t){this._hexStringWarn(a);a=this.nextChar();continue}}else{r=toHexDigit(a);if(-1===r){this._hexStringWarn(a);a=this.nextChar();continue}e.push(String.fromCharCode(t<<4|r))}n=!n;a=this.nextChar()}else a=this.nextChar()}return e.join("")}getObj(){let e=!1,t=this.currentChar;for(;;){if(t<0)return n.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(1!==u[t])break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return this.getNumber();case 40:return this.getString();case 47:return this.getName();case 91:this.nextChar();return n.Cmd.get("[");case 93:this.nextChar();return n.Cmd.get("]");case 60:t=this.nextChar();if(60===t){this.nextChar();return n.Cmd.get("<<")}return this.getHexString();case 62:t=this.nextChar();if(62===t){this.nextChar();return n.Cmd.get(">>")}return n.Cmd.get(">");case 123:this.nextChar();return n.Cmd.get("{");case 125:this.nextChar();return n.Cmd.get("}");case 41:this.nextChar();throw new i.FormatError(`Illegal character: ${t}`)}let r=String.fromCharCode(t);const a=this.knownCommands;let s=a&&void 0!==a[r];for(;(t=this.nextChar())>=0&&!u[t];){const e=r+String.fromCharCode(t);if(s&&void 0===a[e])break;if(128===r.length)throw new i.FormatError(`Command token too long: ${r.length}`);r=e;s=a&&void 0!==a[r]}if("true"===r)return!0;if("false"===r)return!1;if("null"===r)return null;"BI"===r&&(this.beginInlineImagePos=this.stream.pos);return n.Cmd.get(r)}peekObj(){const e=this.stream.pos,t=this.currentChar,r=this.beginInlineImagePos;let a;try{a=this.getObj()}catch(e){if(e instanceof s.MissingDataException)throw e;(0,i.warn)(`peekObj: ${e}`)}this.stream.pos=e;this.currentChar=t;this.beginInlineImagePos=r;return a}skipToNextLine(){let e=this.currentChar;for(;e>=0;){if(13===e){e=this.nextChar();10===e&&this.nextChar();break}if(10===e){this.nextChar();break}e=this.nextChar()}}}t.Lexer=Lexer;t.Linearization=class Linearization{static create(e){function getInt(e,t,r=!1){const a=e.get(t);if(Number.isInteger(a)&&(r?a>=0:a>0))return a;throw new Error(`The "${t}" parameter in the linearization dictionary is invalid.`)}const t=new Parser({lexer:new Lexer(e),xref:null}),r=t.getObj(),a=t.getObj(),s=t.getObj(),o=t.getObj();let c,l;if(!(Number.isInteger(r)&&Number.isInteger(a)&&(0,n.isCmd)(s,"obj")&&(0,n.isDict)(o)&&(0,i.isNum)(c=o.get("Linearized"))&&c>0))return null;if((l=getInt(o,"L"))!==e.length)throw new Error('The "L" parameter in the linearization dictionary does not equal the stream length.');return{length:l,hints:function getHints(e){const t=e.get("H");let r;if(Array.isArray(t)&&(2===(r=t.length)||4===r)){for(let e=0;e<r;e++){const r=t[e];if(!(Number.isInteger(r)&&r>0))throw new Error(`Hint (${e}) in the linearization dictionary is invalid.`)}return t}throw new Error("Hint array in the linearization dictionary is invalid.")}(o),objectNumberFirst:getInt(o,"O"),endFirst:getInt(o,"E"),numPages:getInt(o,"N"),mainXRefEntriesOffset:getInt(o,"T"),pageFirst:o.has("P")?getInt(o,"P",!0):0}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.StringStream=t.StreamsSequenceStream=t.Stream=t.RunLengthStream=t.PredictorStream=t.NullStream=t.LZWStream=t.FlateStream=t.DecryptStream=t.DecodeStream=t.AsciiHexStream=t.Ascii85Stream=void 0;var a=r(2),i=r(5),n=r(8),s=function StreamClosure(){function Stream(e,t,r,a){this.bytes=e instanceof Uint8Array?e:new Uint8Array(e);this.start=t||0;this.pos=this.start;this.end=t+r||this.bytes.length;this.dict=a}Stream.prototype={get length(){return this.end-this.start},get isEmpty(){return 0===this.length},getByte:function Stream_getByte(){return this.pos>=this.end?-1:this.bytes[this.pos++]},getUint16:function Stream_getUint16(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function Stream_getInt32(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var r=this.bytes,a=this.pos,i=this.end;if(!e){const e=r.subarray(a,i);return t?new Uint8ClampedArray(e):e}var n=a+e;n>i&&(n=i);this.pos=n;const s=r.subarray(a,n);return t?new Uint8ClampedArray(s):s},peekByte:function Stream_peekByte(){var e=this.getByte();-1!==e&&this.pos--;return e},peekBytes(e,t=!1){var r=this.getBytes(e,t);this.pos-=r.length;return r},getByteRange(e,t){e<0&&(e=0);t>this.end&&(t=this.end);return this.bytes.subarray(e,t)},skip:function Stream_skip(e){e||(e=1);this.pos+=e},reset:function Stream_reset(){this.pos=this.start},moveStart:function Stream_moveStart(){this.start=this.pos},makeSubStream:function Stream_makeSubStream(e,t,r){return new Stream(this.bytes.buffer,e,t,r)}};return Stream}();t.Stream=s;var o=function StringStreamClosure(){function StringStream(e){const t=(0,a.stringToBytes)(e);s.call(this,t)}StringStream.prototype=s.prototype;return StringStream}();t.StringStream=o;var c=function DecodeStreamClosure(){var e=new Uint8Array(0);function DecodeStream(t){this._rawMinBufferLength=t||0;this.pos=0;this.bufferLength=0;this.eof=!1;this.buffer=e;this.minBufferLength=512;if(t)for(;this.minBufferLength<t;)this.minBufferLength*=2}DecodeStream.prototype={get length(){(0,a.unreachable)("Should not access DecodeStream.length")},get isEmpty(){for(;!this.eof&&0===this.bufferLength;)this.readBlock();return 0===this.bufferLength},ensureBuffer:function DecodeStream_ensureBuffer(e){var t=this.buffer;if(e<=t.byteLength)return t;for(var r=this.minBufferLength;r<e;)r*=2;var a=new Uint8Array(r);a.set(t);return this.buffer=a},getByte:function DecodeStream_getByte(){for(var e=this.pos;this.bufferLength<=e;){if(this.eof)return-1;this.readBlock()}return this.buffer[this.pos++]},getUint16:function DecodeStream_getUint16(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function DecodeStream_getInt32(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var r,a=this.pos;if(e){this.ensureBuffer(a+e);r=a+e;for(;!this.eof&&this.bufferLength<r;)this.readBlock();var i=this.bufferLength;r>i&&(r=i)}else{for(;!this.eof;)this.readBlock();r=this.bufferLength}this.pos=r;const n=this.buffer.subarray(a,r);return!t||n instanceof Uint8ClampedArray?n:new Uint8ClampedArray(n)},peekByte:function DecodeStream_peekByte(){var e=this.getByte();-1!==e&&this.pos--;return e},peekBytes(e,t=!1){var r=this.getBytes(e,t);this.pos-=r.length;return r},makeSubStream:function DecodeStream_makeSubStream(e,t,r){if(void 0===t)for(;!this.eof;)this.readBlock();else for(var a=e+t;this.bufferLength<=a&&!this.eof;)this.readBlock();return new s(this.buffer,e,t,r)},getByteRange(e,t){(0,a.unreachable)("Should not call DecodeStream.getByteRange")},skip:function DecodeStream_skip(e){e||(e=1);this.pos+=e},reset:function DecodeStream_reset(){this.pos=0},getBaseStreams:function DecodeStream_getBaseStreams(){return this.str&&this.str.getBaseStreams?this.str.getBaseStreams():[]}};return DecodeStream}();t.DecodeStream=c;var l=function StreamsSequenceStreamClosure(){function StreamsSequenceStream(e){this.streams=e;let t=0;for(let r=0,a=e.length;r<a;r++){const a=e[r];t+=a instanceof c?a._rawMinBufferLength:a.length}c.call(this,t)}StreamsSequenceStream.prototype=Object.create(c.prototype);StreamsSequenceStream.prototype.readBlock=function streamSequenceStreamReadBlock(){var e=this.streams;if(0!==e.length){var t=e.shift().getBytes(),r=this.bufferLength,a=r+t.length;this.ensureBuffer(a).set(t,r);this.bufferLength=a}else this.eof=!0};StreamsSequenceStream.prototype.getBaseStreams=function StreamsSequenceStream_getBaseStreams(){for(var e=[],t=0,r=this.streams.length;t<r;t++){var a=this.streams[t];a.getBaseStreams&&e.push(...a.getBaseStreams())}return e};return StreamsSequenceStream}();t.StreamsSequenceStream=l;var h=function FlateStreamClosure(){var e=new Int32Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),t=new Int32Array([3,4,5,6,7,8,9,10,65547,65549,65551,65553,131091,131095,131099,131103,196643,196651,196659,196667,262211,262227,262243,262259,327811,327843,327875,327907,258,258,258]),r=new Int32Array([1,2,3,4,65541,65543,131081,131085,196625,196633,262177,262193,327745,327777,393345,393409,459009,459137,524801,525057,590849,591361,657409,658433,724993,727041,794625,798721,868353,876545]),i=[new Int32Array([459008,524368,524304,524568,459024,524400,524336,590016,459016,524384,524320,589984,524288,524416,524352,590048,459012,524376,524312,589968,459028,524408,524344,590032,459020,524392,524328,59e4,524296,524424,524360,590064,459010,524372,524308,524572,459026,524404,524340,590024,459018,524388,524324,589992,524292,524420,524356,590056,459014,524380,524316,589976,459030,524412,524348,590040,459022,524396,524332,590008,524300,524428,524364,590072,459009,524370,524306,524570,459025,524402,524338,590020,459017,524386,524322,589988,524290,524418,524354,590052,459013,524378,524314,589972,459029,524410,524346,590036,459021,524394,524330,590004,524298,524426,524362,590068,459011,524374,524310,524574,459027,524406,524342,590028,459019,524390,524326,589996,524294,524422,524358,590060,459015,524382,524318,589980,459031,524414,524350,590044,459023,524398,524334,590012,524302,524430,524366,590076,459008,524369,524305,524569,459024,524401,524337,590018,459016,524385,524321,589986,524289,524417,524353,590050,459012,524377,524313,589970,459028,524409,524345,590034,459020,524393,524329,590002,524297,524425,524361,590066,459010,524373,524309,524573,459026,524405,524341,590026,459018,524389,524325,589994,524293,524421,524357,590058,459014,524381,524317,589978,459030,524413,524349,590042,459022,524397,524333,590010,524301,524429,524365,590074,459009,524371,524307,524571,459025,524403,524339,590022,459017,524387,524323,589990,524291,524419,524355,590054,459013,524379,524315,589974,459029,524411,524347,590038,459021,524395,524331,590006,524299,524427,524363,590070,459011,524375,524311,524575,459027,524407,524343,590030,459019,524391,524327,589998,524295,524423,524359,590062,459015,524383,524319,589982,459031,524415,524351,590046,459023,524399,524335,590014,524303,524431,524367,590078,459008,524368,524304,524568,459024,524400,524336,590017,459016,524384,524320,589985,524288,524416,524352,590049,459012,524376,524312,589969,459028,524408,524344,590033,459020,524392,524328,590001,524296,524424,524360,590065,459010,524372,524308,524572,459026,524404,524340,590025,459018,524388,524324,589993,524292,524420,524356,590057,459014,524380,524316,589977,459030,524412,524348,590041,459022,524396,524332,590009,524300,524428,524364,590073,459009,524370,524306,524570,459025,524402,524338,590021,459017,524386,524322,589989,524290,524418,524354,590053,459013,524378,524314,589973,459029,524410,524346,590037,459021,524394,524330,590005,524298,524426,524362,590069,459011,524374,524310,524574,459027,524406,524342,590029,459019,524390,524326,589997,524294,524422,524358,590061,459015,524382,524318,589981,459031,524414,524350,590045,459023,524398,524334,590013,524302,524430,524366,590077,459008,524369,524305,524569,459024,524401,524337,590019,459016,524385,524321,589987,524289,524417,524353,590051,459012,524377,524313,589971,459028,524409,524345,590035,459020,524393,524329,590003,524297,524425,524361,590067,459010,524373,524309,524573,459026,524405,524341,590027,459018,524389,524325,589995,524293,524421,524357,590059,459014,524381,524317,589979,459030,524413,524349,590043,459022,524397,524333,590011,524301,524429,524365,590075,459009,524371,524307,524571,459025,524403,524339,590023,459017,524387,524323,589991,524291,524419,524355,590055,459013,524379,524315,589975,459029,524411,524347,590039,459021,524395,524331,590007,524299,524427,524363,590071,459011,524375,524311,524575,459027,524407,524343,590031,459019,524391,524327,589999,524295,524423,524359,590063,459015,524383,524319,589983,459031,524415,524351,590047,459023,524399,524335,590015,524303,524431,524367,590079]),9],n=[new Int32Array([327680,327696,327688,327704,327684,327700,327692,327708,327682,327698,327690,327706,327686,327702,327694,0,327681,327697,327689,327705,327685,327701,327693,327709,327683,327699,327691,327707,327687,327703,327695,0]),5];function FlateStream(e,t){this.str=e;this.dict=e.dict;var r=e.getByte(),i=e.getByte();if(-1===r||-1===i)throw new a.FormatError(`Invalid header in flate stream: ${r}, ${i}`);if(8!=(15&r))throw new a.FormatError(`Unknown compression method in flate stream: ${r}, ${i}`);if(((r<<8)+i)%31!=0)throw new a.FormatError(`Bad FCHECK in flate stream: ${r}, ${i}`);if(32&i)throw new a.FormatError(`FDICT bit set in flate stream: ${r}, ${i}`);this.codeSize=0;this.codeBuf=0;c.call(this,t)}FlateStream.prototype=Object.create(c.prototype);FlateStream.prototype.getBits=function FlateStream_getBits(e){for(var t,r=this.str,i=this.codeSize,n=this.codeBuf;i<e;){if(-1===(t=r.getByte()))throw new a.FormatError("Bad encoding in flate stream");n|=t<<i;i+=8}t=n&(1<<e)-1;this.codeBuf=n>>e;this.codeSize=i-=e;return t};FlateStream.prototype.getCode=function FlateStream_getCode(e){for(var t,r=this.str,i=e[0],n=e[1],s=this.codeSize,o=this.codeBuf;s<n&&-1!==(t=r.getByte());){o|=t<<s;s+=8}var c=i[o&(1<<n)-1],l=c>>16,h=65535&c;if(l<1||s<l)throw new a.FormatError("Bad encoding in flate stream");this.codeBuf=o>>l;this.codeSize=s-l;return h};FlateStream.prototype.generateHuffmanTable=function flateStreamGenerateHuffmanTable(e){var t,r=e.length,a=0;for(t=0;t<r;++t)e[t]>a&&(a=e[t]);for(var i=1<<a,n=new Int32Array(i),s=1,o=0,c=2;s<=a;++s,o<<=1,c<<=1)for(var l=0;l<r;++l)if(e[l]===s){var h=0,u=o;for(t=0;t<s;++t){h=h<<1|1&u;u>>=1}for(t=h;t<i;t+=c)n[t]=s<<16|l;++o}return[n,a]};FlateStream.prototype.readBlock=function FlateStream_readBlock(){var s,o,c=this.str,l=this.getBits(3);1&l&&(this.eof=!0);if(0!==(l>>=1)){var h,u;if(1===l){h=i;u=n}else{if(2!==l)throw new a.FormatError("Unknown block type in flate stream");var d,f=this.getBits(5)+257,g=this.getBits(5)+1,p=this.getBits(4)+4,m=new Uint8Array(e.length);for(d=0;d<p;++d)m[e[d]]=this.getBits(3);var b=this.generateHuffmanTable(m);o=0;d=0;for(var y,w,S,v=f+g,k=new Uint8Array(v);d<v;){var x=this.getCode(b);if(16===x){y=2;w=3;S=o}else if(17===x){y=3;w=3;S=o=0}else{if(18!==x){k[d++]=o=x;continue}y=7;w=11;S=o=0}for(var C=this.getBits(y)+w;C-- >0;)k[d++]=S}h=this.generateHuffmanTable(k.subarray(0,f));u=this.generateHuffmanTable(k.subarray(f,v))}for(var O=(s=this.buffer)?s.length:0,F=this.bufferLength;;){var T=this.getCode(h);if(T<256){F+1>=O&&(O=(s=this.ensureBuffer(F+1)).length);s[F++]=T}else{if(256===T){this.bufferLength=F;return}var E=(T=t[T-=257])>>16;E>0&&(E=this.getBits(E));o=(65535&T)+E;T=this.getCode(u);(E=(T=r[T])>>16)>0&&(E=this.getBits(E));var M=(65535&T)+E;F+o>=O&&(O=(s=this.ensureBuffer(F+o)).length);for(var D=0;D<o;++D,++F)s[F]=s[F-M]}}}else{var N;if(-1===(N=c.getByte()))throw new a.FormatError("Bad block header in flate stream");var R=N;if(-1===(N=c.getByte()))throw new a.FormatError("Bad block header in flate stream");R|=N<<8;if(-1===(N=c.getByte()))throw new a.FormatError("Bad block header in flate stream");var j=N;if(-1===(N=c.getByte()))throw new a.FormatError("Bad block header in flate stream");if((j|=N<<8)!==(65535&~R)&&(0!==R||0!==j))throw new a.FormatError("Bad uncompressed block length in flate stream");this.codeBuf=0;this.codeSize=0;const e=this.bufferLength,t=e+R;s=this.ensureBuffer(t);this.bufferLength=t;if(0===R)-1===c.peekByte()&&(this.eof=!0);else{const t=c.getBytes(R);s.set(t,e);t.length<R&&(this.eof=!0)}}};return FlateStream}();t.FlateStream=h;var u=function PredictorStreamClosure(){function PredictorStream(e,t,r){if(!(0,i.isDict)(r))return e;var n=this.predictor=r.get("Predictor")||1;if(n<=1)return e;if(2!==n&&(n<10||n>15))throw new a.FormatError(`Unsupported predictor: ${n}`);this.readBlock=2===n?this.readBlockTiff:this.readBlockPng;this.str=e;this.dict=e.dict;var s=this.colors=r.get("Colors")||1,o=this.bits=r.get("BitsPerComponent")||8,l=this.columns=r.get("Columns")||1;this.pixBytes=s*o+7>>3;this.rowBytes=l*s*o+7>>3;c.call(this,t);return this}PredictorStream.prototype=Object.create(c.prototype);PredictorStream.prototype.readBlockTiff=function predictorStreamReadBlockTiff(){var e=this.rowBytes,t=this.bufferLength,r=this.ensureBuffer(t+e),a=this.bits,i=this.colors,n=this.str.getBytes(e);this.eof=!n.length;if(!this.eof){var s,o=0,c=0,l=0,h=0,u=t;if(1===a&&1===i)for(s=0;s<e;++s){var d=n[s]^o;d^=d>>1;d^=d>>2;o=(1&(d^=d>>4))<<7;r[u++]=d}else if(8===a){for(s=0;s<i;++s)r[u++]=n[s];for(;s<e;++s){r[u]=r[u-i]+n[s];u++}}else if(16===a){var f=2*i;for(s=0;s<f;++s)r[u++]=n[s];for(;s<e;s+=2){var g=((255&n[s])<<8)+(255&n[s+1])+((255&r[u-f])<<8)+(255&r[u-f+1]);r[u++]=g>>8&255;r[u++]=255&g}}else{var p=new Uint8Array(i+1),m=(1<<a)-1,b=0,y=t,w=this.columns;for(s=0;s<w;++s)for(var S=0;S<i;++S){if(l<a){o=o<<8|255&n[b++];l+=8}p[S]=p[S]+(o>>l-a)&m;l-=a;c=c<<a|p[S];if((h+=a)>=8){r[y++]=c>>h-8&255;h-=8}}h>0&&(r[y++]=(c<<8-h)+(o&(1<<8-h)-1))}this.bufferLength+=e}};PredictorStream.prototype.readBlockPng=function predictorStreamReadBlockPng(){var e=this.rowBytes,t=this.pixBytes,r=this.str.getByte(),i=this.str.getBytes(e);this.eof=!i.length;if(!this.eof){var n=this.bufferLength,s=this.ensureBuffer(n+e),o=s.subarray(n-e,n);0===o.length&&(o=new Uint8Array(e));var c,l,h,u=n;switch(r){case 0:for(c=0;c<e;++c)s[u++]=i[c];break;case 1:for(c=0;c<t;++c)s[u++]=i[c];for(;c<e;++c){s[u]=s[u-t]+i[c]&255;u++}break;case 2:for(c=0;c<e;++c)s[u++]=o[c]+i[c]&255;break;case 3:for(c=0;c<t;++c)s[u++]=(o[c]>>1)+i[c];for(;c<e;++c){s[u]=(o[c]+s[u-t]>>1)+i[c]&255;u++}break;case 4:for(c=0;c<t;++c){l=o[c];h=i[c];s[u++]=l+h}for(;c<e;++c){l=o[c];var d=o[c-t],f=s[u-t],g=f+l-d,p=g-f;p<0&&(p=-p);var m=g-l;m<0&&(m=-m);var b=g-d;b<0&&(b=-b);h=i[c];s[u++]=p<=m&&p<=b?f+h:m<=b?l+h:d+h}break;default:throw new a.FormatError(`Unsupported predictor: ${r}`)}this.bufferLength+=e}};return PredictorStream}();t.PredictorStream=u;var d=function DecryptStreamClosure(){function DecryptStream(e,t,r){this.str=e;this.dict=e.dict;this.decrypt=r;this.nextChunk=null;this.initialized=!1;c.call(this,t)}DecryptStream.prototype=Object.create(c.prototype);DecryptStream.prototype.readBlock=function DecryptStream_readBlock(){var e;if(this.initialized)e=this.nextChunk;else{e=this.str.getBytes(512);this.initialized=!0}if(e&&0!==e.length){this.nextChunk=this.str.getBytes(512);var t=this.nextChunk&&this.nextChunk.length>0;e=(0,this.decrypt)(e,!t);var r,a=this.bufferLength,i=e.length,n=this.ensureBuffer(a+i);for(r=0;r<i;r++)n[a++]=e[r];this.bufferLength=a}else this.eof=!0};return DecryptStream}();t.DecryptStream=d;var f=function Ascii85StreamClosure(){function Ascii85Stream(e,t){this.str=e;this.dict=e.dict;this.input=new Uint8Array(5);t&&(t*=.8);c.call(this,t)}Ascii85Stream.prototype=Object.create(c.prototype);Ascii85Stream.prototype.readBlock=function Ascii85Stream_readBlock(){for(var e=this.str,t=e.getByte();(0,n.isWhiteSpace)(t);)t=e.getByte();if(-1!==t&&126!==t){var r,a,i=this.bufferLength;if(122===t){r=this.ensureBuffer(i+4);for(a=0;a<4;++a)r[i+a]=0;this.bufferLength+=4}else{var s=this.input;s[0]=t;for(a=1;a<5;++a){t=e.getByte();for(;(0,n.isWhiteSpace)(t);)t=e.getByte();s[a]=t;if(-1===t||126===t)break}r=this.ensureBuffer(i+a-1);this.bufferLength+=a-1;if(a<5){for(;a<5;++a)s[a]=117;this.eof=!0}var o=0;for(a=0;a<5;++a)o=85*o+(s[a]-33);for(a=3;a>=0;--a){r[i+a]=255&o;o>>=8}}}else this.eof=!0};return Ascii85Stream}();t.Ascii85Stream=f;var g=function AsciiHexStreamClosure(){function AsciiHexStream(e,t){this.str=e;this.dict=e.dict;this.firstDigit=-1;t&&(t*=.5);c.call(this,t)}AsciiHexStream.prototype=Object.create(c.prototype);AsciiHexStream.prototype.readBlock=function AsciiHexStream_readBlock(){var e=this.str.getBytes(8e3);if(e.length){for(var t=e.length+1>>1,r=this.ensureBuffer(this.bufferLength+t),a=this.bufferLength,i=this.firstDigit,n=0,s=e.length;n<s;n++){var o,c=e[n];if(c>=48&&c<=57)o=15&c;else{if(!(c>=65&&c<=70||c>=97&&c<=102)){if(62===c){this.eof=!0;break}continue}o=9+(15&c)}if(i<0)i=o;else{r[a++]=i<<4|o;i=-1}}if(i>=0&&this.eof){r[a++]=i<<4;i=-1}this.firstDigit=i;this.bufferLength=a}else this.eof=!0};return AsciiHexStream}();t.AsciiHexStream=g;var p=function RunLengthStreamClosure(){function RunLengthStream(e,t){this.str=e;this.dict=e.dict;c.call(this,t)}RunLengthStream.prototype=Object.create(c.prototype);RunLengthStream.prototype.readBlock=function RunLengthStream_readBlock(){var e=this.str.getBytes(2);if(!e||e.length<2||128===e[0])this.eof=!0;else{var t,r=this.bufferLength,a=e[0];if(a<128){(t=this.ensureBuffer(r+a+1))[r++]=e[1];if(a>0){var i=this.str.getBytes(a);t.set(i,r);r+=a}}else{a=257-a;var n=e[1];t=this.ensureBuffer(r+a+1);for(var s=0;s<a;s++)t[r++]=n}this.bufferLength=r}};return RunLengthStream}();t.RunLengthStream=p;var m=function LZWStreamClosure(){function LZWStream(e,t,r){this.str=e;this.dict=e.dict;this.cachedData=0;this.bitsCached=0;for(var a=4096,i={earlyChange:r,codeLength:9,nextCode:258,dictionaryValues:new Uint8Array(a),dictionaryLengths:new Uint16Array(a),dictionaryPrevCodes:new Uint16Array(a),currentSequence:new Uint8Array(a),currentSequenceLength:0},n=0;n<256;++n){i.dictionaryValues[n]=n;i.dictionaryLengths[n]=1}this.lzwState=i;c.call(this,t)}LZWStream.prototype=Object.create(c.prototype);LZWStream.prototype.readBits=function LZWStream_readBits(e){for(var t=this.bitsCached,r=this.cachedData;t<e;){var a=this.str.getByte();if(-1===a){this.eof=!0;return null}r=r<<8|a;t+=8}this.bitsCached=t-=e;this.cachedData=r;this.lastCode=null;return r>>>t&(1<<e)-1};LZWStream.prototype.readBlock=function LZWStream_readBlock(){var e,t,r,a=1024,i=this.lzwState;if(i){var n=i.earlyChange,s=i.nextCode,o=i.dictionaryValues,c=i.dictionaryLengths,l=i.dictionaryPrevCodes,h=i.codeLength,u=i.prevCode,d=i.currentSequence,f=i.currentSequenceLength,g=0,p=this.bufferLength,m=this.ensureBuffer(this.bufferLength+a);for(e=0;e<512;e++){var b=this.readBits(h),y=f>0;if(b<256){d[0]=b;f=1}else{if(!(b>=258)){if(256===b){h=9;s=258;f=0;continue}this.eof=!0;delete this.lzwState;break}if(b<s)for(t=(f=c[b])-1,r=b;t>=0;t--){d[t]=o[r];r=l[r]}else d[f++]=d[0]}if(y){l[s]=u;c[s]=c[u]+1;o[s]=d[0];h=++s+n&s+n-1?h:0|Math.min(Math.log(s+n)/.6931471805599453+1,12)}u=b;if(a<(g+=f)){do{a+=512}while(a<g);m=this.ensureBuffer(this.bufferLength+a)}for(t=0;t<f;t++)m[p++]=d[t]}i.nextCode=s;i.codeLength=h;i.prevCode=u;i.currentSequenceLength=f;this.bufferLength=p}};return LZWStream}();t.LZWStream=m;var b=function NullStreamClosure(){function NullStream(){s.call(this,new Uint8Array(0))}NullStream.prototype=s.prototype;return NullStream}();t.NullStream=b},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CCITTFaxStream=void 0;var a=r(5),i=r(14),n=r(12);const s=function CCITTFaxStreamClosure(){function CCITTFaxStream(e,t,r){this.str=e;this.dict=e.dict;(0,a.isDict)(r)||(r=a.Dict.empty);const s={next:()=>e.getByte()};this.ccittFaxDecoder=new i.CCITTFaxDecoder(s,{K:r.get("K"),EndOfLine:r.get("EndOfLine"),EncodedByteAlign:r.get("EncodedByteAlign"),Columns:r.get("Columns"),Rows:r.get("Rows"),EndOfBlock:r.get("EndOfBlock"),BlackIs1:r.get("BlackIs1")});n.DecodeStream.call(this,t)}CCITTFaxStream.prototype=Object.create(n.DecodeStream.prototype);CCITTFaxStream.prototype.readBlock=function(){for(;!this.eof;){const e=this.ccittFaxDecoder.readNextChar();if(-1===e){this.eof=!0;return}this.ensureBuffer(this.bufferLength+1);this.buffer[this.bufferLength++]=e}};return CCITTFaxStream}();t.CCITTFaxStream=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CCITTFaxDecoder=void 0;var a=r(2);const i=function CCITTFaxDecoder(){const e=-1,t=[[-1,-1],[-1,-1],[7,8],[7,7],[6,6],[6,6],[6,5],[6,5],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2]],r=[[-1,-1],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[12,1984],[12,2048],[12,2112],[12,2176],[12,2240],[12,2304],[11,1856],[11,1856],[11,1920],[11,1920],[12,2368],[12,2432],[12,2496],[12,2560]],i=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[8,29],[8,29],[8,30],[8,30],[8,45],[8,45],[8,46],[8,46],[7,22],[7,22],[7,22],[7,22],[7,23],[7,23],[7,23],[7,23],[8,47],[8,47],[8,48],[8,48],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[7,20],[7,20],[7,20],[7,20],[8,33],[8,33],[8,34],[8,34],[8,35],[8,35],[8,36],[8,36],[8,37],[8,37],[8,38],[8,38],[7,19],[7,19],[7,19],[7,19],[8,31],[8,31],[8,32],[8,32],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[8,53],[8,53],[8,54],[8,54],[7,26],[7,26],[7,26],[7,26],[8,39],[8,39],[8,40],[8,40],[8,41],[8,41],[8,42],[8,42],[8,43],[8,43],[8,44],[8,44],[7,21],[7,21],[7,21],[7,21],[7,28],[7,28],[7,28],[7,28],[8,61],[8,61],[8,62],[8,62],[8,63],[8,63],[8,0],[8,0],[8,320],[8,320],[8,384],[8,384],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[7,27],[7,27],[7,27],[7,27],[8,59],[8,59],[8,60],[8,60],[9,1472],[9,1536],[9,1600],[9,1728],[7,18],[7,18],[7,18],[7,18],[7,24],[7,24],[7,24],[7,24],[8,49],[8,49],[8,50],[8,50],[8,51],[8,51],[8,52],[8,52],[7,25],[7,25],[7,25],[7,25],[8,55],[8,55],[8,56],[8,56],[8,57],[8,57],[8,58],[8,58],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[8,448],[8,448],[8,512],[8,512],[9,704],[9,768],[8,640],[8,640],[8,576],[8,576],[9,832],[9,896],[9,960],[9,1024],[9,1088],[9,1152],[9,1216],[9,1280],[9,1344],[9,1408],[7,256],[7,256],[7,256],[7,256],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7]],n=[[-1,-1],[-1,-1],[12,-2],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[11,1792],[11,1792],[12,1984],[12,1984],[12,2048],[12,2048],[12,2112],[12,2112],[12,2176],[12,2176],[12,2240],[12,2240],[12,2304],[12,2304],[11,1856],[11,1856],[11,1856],[11,1856],[11,1920],[11,1920],[11,1920],[11,1920],[12,2368],[12,2368],[12,2432],[12,2432],[12,2496],[12,2496],[12,2560],[12,2560],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[12,52],[12,52],[13,640],[13,704],[13,768],[13,832],[12,55],[12,55],[12,56],[12,56],[13,1280],[13,1344],[13,1408],[13,1472],[12,59],[12,59],[12,60],[12,60],[13,1536],[13,1600],[11,24],[11,24],[11,24],[11,24],[11,25],[11,25],[11,25],[11,25],[13,1664],[13,1728],[12,320],[12,320],[12,384],[12,384],[12,448],[12,448],[13,512],[13,576],[12,53],[12,53],[12,54],[12,54],[13,896],[13,960],[13,1024],[13,1088],[13,1152],[13,1216],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64]],s=[[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[11,23],[11,23],[12,50],[12,51],[12,44],[12,45],[12,46],[12,47],[12,57],[12,58],[12,61],[12,256],[10,16],[10,16],[10,16],[10,16],[10,17],[10,17],[10,17],[10,17],[12,48],[12,49],[12,62],[12,63],[12,30],[12,31],[12,32],[12,33],[12,40],[12,41],[11,22],[11,22],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[12,128],[12,192],[12,26],[12,27],[12,28],[12,29],[11,19],[11,19],[11,20],[11,20],[12,34],[12,35],[12,36],[12,37],[12,38],[12,39],[11,21],[11,21],[12,42],[12,43],[10,0],[10,0],[10,0],[10,0],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12]],o=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[6,9],[6,8],[5,7],[5,7],[4,6],[4,6],[4,6],[4,6],[4,5],[4,5],[4,5],[4,5],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2]];function CCITTFaxDecoder(e,t={}){if(!e||"function"!=typeof e.next)throw new Error('CCITTFaxDecoder - invalid "source" parameter.');this.source=e;this.eof=!1;this.encoding=t.K||0;this.eoline=t.EndOfLine||!1;this.byteAlign=t.EncodedByteAlign||!1;this.columns=t.Columns||1728;this.rows=t.Rows||0;let r,a=t.EndOfBlock;null==a&&(a=!0);this.eoblock=a;this.black=t.BlackIs1||!1;this.codingLine=new Uint32Array(this.columns+1);this.refLine=new Uint32Array(this.columns+2);this.codingLine[0]=this.columns;this.codingPos=0;this.row=0;this.nextLine2D=this.encoding<0;this.inputBits=0;this.inputBuf=0;this.outputBits=0;this.rowsDone=!1;for(;0===(r=this._lookBits(12));)this._eatBits(1);1===r&&this._eatBits(12);if(this.encoding>0){this.nextLine2D=!this._lookBits(1);this._eatBits(1)}}CCITTFaxDecoder.prototype={readNextChar(){if(this.eof)return-1;const t=this.refLine,r=this.codingLine,i=this.columns;let n,s,o,c,l;if(0===this.outputBits){this.rowsDone&&(this.eof=!0);if(this.eof)return-1;this.err=!1;let o,l,h;if(this.nextLine2D){for(c=0;r[c]<i;++c)t[c]=r[c];t[c++]=i;t[c]=i;r[0]=0;this.codingPos=0;n=0;s=0;for(;r[this.codingPos]<i;){o=this._getTwoDimCode();switch(o){case 0:this._addPixels(t[n+1],s);t[n+1]<i&&(n+=2);break;case 1:o=l=0;if(s){do{o+=h=this._getBlackCode()}while(h>=64);do{l+=h=this._getWhiteCode()}while(h>=64)}else{do{o+=h=this._getWhiteCode()}while(h>=64);do{l+=h=this._getBlackCode()}while(h>=64)}this._addPixels(r[this.codingPos]+o,s);r[this.codingPos]<i&&this._addPixels(r[this.codingPos]+l,1^s);for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2;break;case 7:this._addPixels(t[n]+3,s);s^=1;if(r[this.codingPos]<i){++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 5:this._addPixels(t[n]+2,s);s^=1;if(r[this.codingPos]<i){++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 3:this._addPixels(t[n]+1,s);s^=1;if(r[this.codingPos]<i){++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 2:this._addPixels(t[n],s);s^=1;if(r[this.codingPos]<i){++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 8:this._addPixelsNeg(t[n]-3,s);s^=1;if(r[this.codingPos]<i){n>0?--n:++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 6:this._addPixelsNeg(t[n]-2,s);s^=1;if(r[this.codingPos]<i){n>0?--n:++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case 4:this._addPixelsNeg(t[n]-1,s);s^=1;if(r[this.codingPos]<i){n>0?--n:++n;for(;t[n]<=r[this.codingPos]&&t[n]<i;)n+=2}break;case e:this._addPixels(i,0);this.eof=!0;break;default:(0,a.info)("bad 2d code");this._addPixels(i,0);this.err=!0}}}else{r[0]=0;this.codingPos=0;s=0;for(;r[this.codingPos]<i;){o=0;if(s)do{o+=h=this._getBlackCode()}while(h>=64);else do{o+=h=this._getWhiteCode()}while(h>=64);this._addPixels(r[this.codingPos]+o,s);s^=1}}let u=!1;this.byteAlign&&(this.inputBits&=-8);if(this.eoblock||this.row!==this.rows-1){o=this._lookBits(12);if(this.eoline)for(;o!==e&&1!==o;){this._eatBits(1);o=this._lookBits(12)}else for(;0===o;){this._eatBits(1);o=this._lookBits(12)}if(1===o){this._eatBits(12);u=!0}else o===e&&(this.eof=!0)}else this.rowsDone=!0;if(!this.eof&&this.encoding>0&&!this.rowsDone){this.nextLine2D=!this._lookBits(1);this._eatBits(1)}if(this.eoblock&&u&&this.byteAlign){o=this._lookBits(12);if(1===o){this._eatBits(12);if(this.encoding>0){this._lookBits(1);this._eatBits(1)}if(this.encoding>=0)for(c=0;c<4;++c){o=this._lookBits(12);1!==o&&(0,a.info)("bad rtc code: "+o);this._eatBits(12);if(this.encoding>0){this._lookBits(1);this._eatBits(1)}}this.eof=!0}}else if(this.err&&this.eoline){for(;;){o=this._lookBits(13);if(o===e){this.eof=!0;return-1}if(o>>1==1)break;this._eatBits(1)}this._eatBits(12);if(this.encoding>0){this._eatBits(1);this.nextLine2D=!(1&o)}}r[0]>0?this.outputBits=r[this.codingPos=0]:this.outputBits=r[this.codingPos=1];this.row++}if(this.outputBits>=8){l=1&this.codingPos?0:255;this.outputBits-=8;if(0===this.outputBits&&r[this.codingPos]<i){this.codingPos++;this.outputBits=r[this.codingPos]-r[this.codingPos-1]}}else{o=8;l=0;do{if(this.outputBits>o){l<<=o;1&this.codingPos||(l|=255>>8-o);this.outputBits-=o;o=0}else{l<<=this.outputBits;1&this.codingPos||(l|=255>>8-this.outputBits);o-=this.outputBits;this.outputBits=0;if(r[this.codingPos]<i){this.codingPos++;this.outputBits=r[this.codingPos]-r[this.codingPos-1]}else if(o>0){l<<=o;o=0}}}while(o)}this.black&&(l^=255);return l},_addPixels(e,t){const r=this.codingLine;let i=this.codingPos;if(e>r[i]){if(e>this.columns){(0,a.info)("row is wrong length");this.err=!0;e=this.columns}1&i^t&&++i;r[i]=e}this.codingPos=i},_addPixelsNeg(e,t){const r=this.codingLine;let i=this.codingPos;if(e>r[i]){if(e>this.columns){(0,a.info)("row is wrong length");this.err=!0;e=this.columns}1&i^t&&++i;r[i]=e}else if(e<r[i]){if(e<0){(0,a.info)("invalid code");this.err=!0;e=0}for(;i>0&&e<r[i-1];)--i;r[i]=e}this.codingPos=i},_findTableCode(t,r,a,i){const n=i||0;for(let i=t;i<=r;++i){let t=this._lookBits(i);if(t===e)return[!0,1,!1];i<r&&(t<<=r-i);if(!n||t>=n){const e=a[t-n];if(e[0]===i){this._eatBits(i);return[!0,e[1],!0]}}}return[!1,0,!1]},_getTwoDimCode(){let r,i=0;if(this.eoblock){i=this._lookBits(7);r=t[i];if(r&&r[0]>0){this._eatBits(r[0]);return r[1]}}else{const e=this._findTableCode(1,7,t);if(e[0]&&e[2])return e[1]}(0,a.info)("Bad two dim code");return e},_getWhiteCode(){let t,n=0;if(this.eoblock){n=this._lookBits(12);if(n===e)return 1;t=n>>5==0?r[n]:i[n>>3];if(t[0]>0){this._eatBits(t[0]);return t[1]}}else{let e=this._findTableCode(1,9,i);if(e[0])return e[1];e=this._findTableCode(11,12,r);if(e[0])return e[1]}(0,a.info)("bad white code");this._eatBits(1);return 1},_getBlackCode(){let t,r;if(this.eoblock){t=this._lookBits(13);if(t===e)return 1;r=t>>7==0?n[t]:t>>9==0&&t>>7!=0?s[(t>>1)-64]:o[t>>7];if(r[0]>0){this._eatBits(r[0]);return r[1]}}else{let e=this._findTableCode(2,6,o);if(e[0])return e[1];e=this._findTableCode(7,12,s,64);if(e[0])return e[1];e=this._findTableCode(10,13,n);if(e[0])return e[1]}(0,a.info)("bad black code");this._eatBits(1);return 1},_lookBits(t){let r;for(;this.inputBits<t;){if(-1===(r=this.source.next()))return 0===this.inputBits?e:this.inputBuf<<t-this.inputBits&65535>>16-t;this.inputBuf=this.inputBuf<<8|r;this.inputBits+=8}return this.inputBuf>>this.inputBits-t&65535>>16-t},_eatBits(e){(this.inputBits-=e)<0&&(this.inputBits=0)}};return CCITTFaxDecoder}();t.CCITTFaxDecoder=i},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Jbig2Stream=void 0;var a=r(5),i=r(12),n=r(16),s=r(2);const o=function Jbig2StreamClosure(){function Jbig2Stream(e,t,r,a){this.stream=e;this.maybeLength=t;this.dict=r;this.params=a;i.DecodeStream.call(this,t)}Jbig2Stream.prototype=Object.create(i.DecodeStream.prototype);Object.defineProperty(Jbig2Stream.prototype,"bytes",{get(){return(0,s.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});Jbig2Stream.prototype.ensureBuffer=function(e){};Jbig2Stream.prototype.readBlock=function(){if(this.eof)return;const e=new n.Jbig2Image,t=[];if((0,a.isDict)(this.params)){const e=this.params.get("JBIG2Globals");if((0,a.isStream)(e)){const r=e.getBytes();t.push({data:r,start:0,end:r.length})}}t.push({data:this.bytes,start:0,end:this.bytes.length});const r=e.parseChunks(t),i=r.length;for(let e=0;e<i;e++)r[e]^=255;this.buffer=r;this.bufferLength=i;this.eof=!0};return Jbig2Stream}();t.Jbig2Stream=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Jbig2Image=void 0;var a=r(2),i=r(8),n=r(17),s=r(14);class Jbig2Error extends a.BaseException{constructor(e){super(`JBIG2 error: ${e}`)}}var o=function Jbig2ImageClosure(){function ContextCache(){}ContextCache.prototype={getContexts(e){return e in this?this[e]:this[e]=new Int8Array(65536)}};function DecodingContext(e,t,r){this.data=e;this.start=t;this.end=r}DecodingContext.prototype={get decoder(){var e=new n.ArithmeticDecoder(this.data,this.start,this.end);return(0,a.shadow)(this,"decoder",e)},get contextCache(){var e=new ContextCache;return(0,a.shadow)(this,"contextCache",e)}};function decodeInteger(e,t,r){var a=e.getContexts(t),i=1;function readBits(e){for(var t=0,n=0;n<e;n++){var s=r.readBit(a,i);i=i<256?i<<1|s:511&(i<<1|s)|256;t=t<<1|s}return t>>>0}var n=readBits(1),s=readBits(1)?readBits(1)?readBits(1)?readBits(1)?readBits(1)?readBits(32)+4436:readBits(12)+340:readBits(8)+84:readBits(6)+20:readBits(4)+4:readBits(2);return 0===n?s:s>0?-s:null}function decodeIAID(e,t,r){for(var a=e.getContexts("IAID"),i=1,n=0;n<r;n++){i=i<<1|t.readBit(a,i)}return r<31?i&(1<<r)-1:2147483647&i}var e=["SymbolDictionary",null,null,null,"IntermediateTextRegion",null,"ImmediateTextRegion","ImmediateLosslessTextRegion",null,null,null,null,null,null,null,null,"PatternDictionary",null,null,null,"IntermediateHalftoneRegion",null,"ImmediateHalftoneRegion","ImmediateLosslessHalftoneRegion",null,null,null,null,null,null,null,null,null,null,null,null,"IntermediateGenericRegion",null,"ImmediateGenericRegion","ImmediateLosslessGenericRegion","IntermediateGenericRefinementRegion",null,"ImmediateGenericRefinementRegion","ImmediateLosslessGenericRefinementRegion",null,null,null,null,"PageInformation","EndOfPage","EndOfStripe","EndOfFile","Profiles","Tables",null,null,null,null,null,null,null,null,"Extension"],t=[[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:2,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-2,y:0},{x:-1,y:0}],[{x:-3,y:-1},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}]],r=[{coding:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:-1,y:1},{x:0,y:1},{x:1,y:1}]},{coding:[{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:0,y:1},{x:1,y:1}]}],o=[39717,1941,229,405],c=[32,8];function decodeBitmap(e,r,a,i,n,s,c,l){if(e){return decodeMMRBitmap(new Reader(l.data,l.start,l.end),r,a,!1)}if(0===i&&!s&&!n&&4===c.length&&3===c[0].x&&-1===c[0].y&&-3===c[1].x&&-1===c[1].y&&2===c[2].x&&-2===c[2].y&&-2===c[3].x&&-2===c[3].y)return function decodeBitmapTemplate0(e,t,r){var a,i,n,s,o,c,l,h=r.decoder,u=r.contextCache.getContexts("GB"),d=[];for(i=0;i<t;i++){o=d[i]=new Uint8Array(e);c=i<1?o:d[i-1];a=(l=i<2?o:d[i-2])[0]<<13|l[1]<<12|l[2]<<11|c[0]<<7|c[1]<<6|c[2]<<5|c[3]<<4;for(n=0;n<e;n++){o[n]=s=h.readBit(u,a);a=(31735&a)<<1|(n+3<e?l[n+3]<<11:0)|(n+4<e?c[n+4]<<4:0)|s}}return d}(r,a,l);var h=!!s,u=t[i].concat(c);u.sort((function(e,t){return e.y-t.y||e.x-t.x}));var d,f,g=u.length,p=new Int8Array(g),m=new Int8Array(g),b=[],y=0,w=0,S=0,v=0;for(f=0;f<g;f++){p[f]=u[f].x;m[f]=u[f].y;w=Math.min(w,u[f].x);S=Math.max(S,u[f].x);v=Math.min(v,u[f].y);f<g-1&&u[f].y===u[f+1].y&&u[f].x===u[f+1].x-1?y|=1<<g-1-f:b.push(f)}var k=b.length,x=new Int8Array(k),C=new Int8Array(k),O=new Uint16Array(k);for(d=0;d<k;d++){f=b[d];x[d]=u[f].x;C[d]=u[f].y;O[d]=1<<g-1-f}for(var F,T,E,M,D,N=-w,R=-v,j=r-S,L=o[i],_=new Uint8Array(r),U=[],X=l.decoder,q=l.contextCache.getContexts("GB"),$=0,H=0,z=0;z<a;z++){if(n){if($^=X.readBit(q,L)){U.push(_);continue}}_=new Uint8Array(_);U.push(_);for(F=0;F<r;F++)if(h&&s[z][F])_[F]=0;else{if(F>=N&&F<j&&z>=R){H=H<<1&y;for(f=0;f<k;f++){T=z+C[f];E=F+x[f];(M=U[T][E])&&(H|=M=O[f])}}else{H=0;D=g-1;for(f=0;f<g;f++,D--)(E=F+p[f])>=0&&E<r&&(T=z+m[f])>=0&&(M=U[T][E])&&(H|=M<<D)}var G=X.readBit(q,H);_[F]=G}}return U}function decodeRefinement(e,t,a,i,n,s,o,l,h){var u=r[a].coding;0===a&&(u=u.concat([l[0]]));var d,f=u.length,g=new Int32Array(f),p=new Int32Array(f);for(d=0;d<f;d++){g[d]=u[d].x;p[d]=u[d].y}var m=r[a].reference;0===a&&(m=m.concat([l[1]]));var b=m.length,y=new Int32Array(b),w=new Int32Array(b);for(d=0;d<b;d++){y[d]=m[d].x;w[d]=m[d].y}for(var S=i[0].length,v=i.length,k=c[a],x=[],C=h.decoder,O=h.contextCache.getContexts("GR"),F=0,T=0;T<t;T++){if(o){if(F^=C.readBit(O,k))throw new Jbig2Error("prediction is not supported")}var E=new Uint8Array(e);x.push(E);for(var M=0;M<e;M++){var D,N,R=0;for(d=0;d<f;d++){D=T+p[d];N=M+g[d];D<0||N<0||N>=e?R<<=1:R=R<<1|x[D][N]}for(d=0;d<b;d++){D=T+w[d]-s;N=M+y[d]-n;D<0||D>=v||N<0||N>=S?R<<=1:R=R<<1|i[D][N]}var j=C.readBit(O,R);E[M]=j}}return x}function decodeTextRegion(e,t,r,a,i,n,s,o,c,l,h,u,d,f,g,p,m,b,y){if(e&&t)throw new Jbig2Error("refinement with Huffman is not supported");var w,S,v=[];for(w=0;w<a;w++){S=new Uint8Array(r);if(i)for(var k=0;k<r;k++)S[k]=i;v.push(S)}var x=m.decoder,C=m.contextCache,O=e?-f.tableDeltaT.decode(y):-decodeInteger(C,"IADT",x),F=0;w=0;for(;w<n;){O+=e?f.tableDeltaT.decode(y):decodeInteger(C,"IADT",x);for(var T=F+=e?f.tableFirstS.decode(y):decodeInteger(C,"IAFS",x);;){let a=0;s>1&&(a=e?y.readBits(b):decodeInteger(C,"IAIT",x));var E=s*O+a,M=e?f.symbolIDTable.decode(y):decodeIAID(C,x,c),D=t&&(e?y.readBit():decodeInteger(C,"IARI",x)),N=o[M],R=N[0].length,j=N.length;if(D){var L=decodeInteger(C,"IARDW",x),_=decodeInteger(C,"IARDH",x);N=decodeRefinement(R+=L,j+=_,g,N,(L>>1)+decodeInteger(C,"IARDX",x),(_>>1)+decodeInteger(C,"IARDY",x),!1,p,m)}var U,X,q,$=E-(1&u?0:j-1),H=T-(2&u?R-1:0);if(l){for(U=0;U<j;U++)if(S=v[H+U]){q=N[U];var z=Math.min(r-$,R);switch(d){case 0:for(X=0;X<z;X++)S[$+X]|=q[X];break;case 2:for(X=0;X<z;X++)S[$+X]^=q[X];break;default:throw new Jbig2Error(`operator ${d} is not supported`)}}T+=j-1}else{for(X=0;X<j;X++)if(S=v[$+X]){q=N[X];switch(d){case 0:for(U=0;U<R;U++)S[H+U]|=q[U];break;case 2:for(U=0;U<R;U++)S[H+U]^=q[U];break;default:throw new Jbig2Error(`operator ${d} is not supported`)}}T+=R-1}w++;var G=e?f.tableDeltaS.decode(y):decodeInteger(C,"IADS",x);if(null===G)break;T+=G+h}}return v}function readSegmentHeader(t,r){var a={};a.number=(0,i.readUint32)(t,r);var n=t[r+4],s=63&n;if(!e[s])throw new Jbig2Error("invalid segment type: "+s);a.type=s;a.typeName=e[s];a.deferredNonRetain=!!(128&n);var o=!!(64&n),c=t[r+5],h=c>>5&7,u=[31&c],d=r+6;if(7===c){h=536870911&(0,i.readUint32)(t,d-1);d+=3;var f=h+7>>3;u[0]=t[d++];for(;--f>0;)u.push(t[d++])}else if(5===c||6===c)throw new Jbig2Error("invalid referred-to flags");a.retainBits=u;let g=4;a.number<=256?g=1:a.number<=65536&&(g=2);var p,m,b=[];for(p=0;p<h;p++){let e;e=1===g?t[d]:2===g?(0,i.readUint16)(t,d):(0,i.readUint32)(t,d);b.push(e);d+=g}a.referredTo=b;if(o){a.pageAssociation=(0,i.readUint32)(t,d);d+=4}else a.pageAssociation=t[d++];a.length=(0,i.readUint32)(t,d);d+=4;if(4294967295===a.length){if(38!==s)throw new Jbig2Error("invalid unknown segment length");var y=readRegionSegmentInformation(t,d),w=!!(1&t[d+l]),S=new Uint8Array(6);if(!w){S[0]=255;S[1]=172}S[2]=y.height>>>24&255;S[3]=y.height>>16&255;S[4]=y.height>>8&255;S[5]=255&y.height;for(p=d,m=t.length;p<m;p++){for(var v=0;v<6&&S[v]===t[p+v];)v++;if(6===v){a.length=p+6;break}}if(4294967295===a.length)throw new Jbig2Error("segment end was not found")}a.headerEnd=d;return a}function readSegments(e,t,r,a){for(var i=[],n=r;n<a;){var s=readSegmentHeader(t,n);n=s.headerEnd;var o={header:s,data:t};if(!e.randomAccess){o.start=n;n+=s.length;o.end=n}i.push(o);if(51===s.type)break}if(e.randomAccess)for(var c=0,l=i.length;c<l;c++){i[c].start=n;n+=i[c].header.length;i[c].end=n}return i}function readRegionSegmentInformation(e,t){return{width:(0,i.readUint32)(e,t),height:(0,i.readUint32)(e,t+4),x:(0,i.readUint32)(e,t+8),y:(0,i.readUint32)(e,t+12),combinationOperator:7&e[t+16]}}var l=17;function processSegment(e,t){var r,a,n,s,o=e.header,c=e.data,h=e.start,u=e.end;switch(o.type){case 0:var d={},f=(0,i.readUint16)(c,h);d.huffman=!!(1&f);d.refinement=!!(2&f);d.huffmanDHSelector=f>>2&3;d.huffmanDWSelector=f>>4&3;d.bitmapSizeSelector=f>>6&1;d.aggregationInstancesSelector=f>>7&1;d.bitmapCodingContextUsed=!!(256&f);d.bitmapCodingContextRetained=!!(512&f);d.template=f>>10&3;d.refinementTemplate=f>>12&1;h+=2;if(!d.huffman){s=0===d.template?4:1;a=[];for(n=0;n<s;n++){a.push({x:(0,i.readInt8)(c,h),y:(0,i.readInt8)(c,h+1)});h+=2}d.at=a}if(d.refinement&&!d.refinementTemplate){a=[];for(n=0;n<2;n++){a.push({x:(0,i.readInt8)(c,h),y:(0,i.readInt8)(c,h+1)});h+=2}d.refinementAt=a}d.numberOfExportedSymbols=(0,i.readUint32)(c,h);h+=4;d.numberOfNewSymbols=(0,i.readUint32)(c,h);h+=4;r=[d,o.number,o.referredTo,c,h,u];break;case 6:case 7:var g={};g.info=readRegionSegmentInformation(c,h);h+=l;var p=(0,i.readUint16)(c,h);h+=2;g.huffman=!!(1&p);g.refinement=!!(2&p);g.logStripSize=p>>2&3;g.stripSize=1<<g.logStripSize;g.referenceCorner=p>>4&3;g.transposed=!!(64&p);g.combinationOperator=p>>7&3;g.defaultPixelValue=p>>9&1;g.dsOffset=p<<17>>27;g.refinementTemplate=p>>15&1;if(g.huffman){var m=(0,i.readUint16)(c,h);h+=2;g.huffmanFS=3&m;g.huffmanDS=m>>2&3;g.huffmanDT=m>>4&3;g.huffmanRefinementDW=m>>6&3;g.huffmanRefinementDH=m>>8&3;g.huffmanRefinementDX=m>>10&3;g.huffmanRefinementDY=m>>12&3;g.huffmanRefinementSizeSelector=!!(16384&m)}if(g.refinement&&!g.refinementTemplate){a=[];for(n=0;n<2;n++){a.push({x:(0,i.readInt8)(c,h),y:(0,i.readInt8)(c,h+1)});h+=2}g.refinementAt=a}g.numberOfSymbolInstances=(0,i.readUint32)(c,h);h+=4;r=[g,o.referredTo,c,h,u];break;case 16:const e={},t=c[h++];e.mmr=!!(1&t);e.template=t>>1&3;e.patternWidth=c[h++];e.patternHeight=c[h++];e.maxPatternIndex=(0,i.readUint32)(c,h);h+=4;r=[e,o.number,c,h,u];break;case 22:case 23:const v={};v.info=readRegionSegmentInformation(c,h);h+=l;const k=c[h++];v.mmr=!!(1&k);v.template=k>>1&3;v.enableSkip=!!(8&k);v.combinationOperator=k>>4&7;v.defaultPixelValue=k>>7&1;v.gridWidth=(0,i.readUint32)(c,h);h+=4;v.gridHeight=(0,i.readUint32)(c,h);h+=4;v.gridOffsetX=4294967295&(0,i.readUint32)(c,h);h+=4;v.gridOffsetY=4294967295&(0,i.readUint32)(c,h);h+=4;v.gridVectorX=(0,i.readUint16)(c,h);h+=2;v.gridVectorY=(0,i.readUint16)(c,h);h+=2;r=[v,o.referredTo,c,h,u];break;case 38:case 39:var b={};b.info=readRegionSegmentInformation(c,h);h+=l;var y=c[h++];b.mmr=!!(1&y);b.template=y>>1&3;b.prediction=!!(8&y);if(!b.mmr){s=0===b.template?4:1;a=[];for(n=0;n<s;n++){a.push({x:(0,i.readInt8)(c,h),y:(0,i.readInt8)(c,h+1)});h+=2}b.at=a}r=[b,c,h,u];break;case 48:var w={width:(0,i.readUint32)(c,h),height:(0,i.readUint32)(c,h+4),resolutionX:(0,i.readUint32)(c,h+8),resolutionY:(0,i.readUint32)(c,h+12)};4294967295===w.height&&delete w.height;var S=c[h+16];(0,i.readUint16)(c,h+17);w.lossless=!!(1&S);w.refinement=!!(2&S);w.defaultPixelValue=S>>2&1;w.combinationOperator=S>>3&3;w.requiresBuffer=!!(32&S);w.combinationOperatorOverride=!!(64&S);r=[w];break;case 49:case 50:case 51:break;case 53:r=[o.number,c,h,u];break;case 62:break;default:throw new Jbig2Error(`segment type ${o.typeName}(${o.type}) is not implemented`)}var v="on"+o.typeName;v in t&&t[v].apply(t,r)}function processSegments(e,t){for(var r=0,a=e.length;r<a;r++)processSegment(e[r],t)}function SimpleSegmentVisitor(){}SimpleSegmentVisitor.prototype={onPageInformation:function SimpleSegmentVisitor_onPageInformation(e){this.currentPageInfo=e;var t=e.width+7>>3,r=new Uint8ClampedArray(t*e.height);if(e.defaultPixelValue)for(var a=0,i=r.length;a<i;a++)r[a]=255;this.buffer=r},drawBitmap:function SimpleSegmentVisitor_drawBitmap(e,t){var r,a,i,n,s=this.currentPageInfo,o=e.width,c=e.height,l=s.width+7>>3,h=s.combinationOperatorOverride?e.combinationOperator:s.combinationOperator,u=this.buffer,d=128>>(7&e.x),f=e.y*l+(e.x>>3);switch(h){case 0:for(r=0;r<c;r++){i=d;n=f;for(a=0;a<o;a++){t[r][a]&&(u[n]|=i);if(!(i>>=1)){i=128;n++}}f+=l}break;case 2:for(r=0;r<c;r++){i=d;n=f;for(a=0;a<o;a++){t[r][a]&&(u[n]^=i);if(!(i>>=1)){i=128;n++}}f+=l}break;default:throw new Jbig2Error(`operator ${h} is not supported`)}},onImmediateGenericRegion:function SimpleSegmentVisitor_onImmediateGenericRegion(e,t,r,a){var i=e.info,n=new DecodingContext(t,r,a),s=decodeBitmap(e.mmr,i.width,i.height,e.template,e.prediction,null,e.at,n);this.drawBitmap(i,s)},onImmediateLosslessGenericRegion:function SimpleSegmentVisitor_onImmediateLosslessGenericRegion(){this.onImmediateGenericRegion.apply(this,arguments)},onSymbolDictionary:function SimpleSegmentVisitor_onSymbolDictionary(e,t,r,a,n,s){let o,c;if(e.huffman){o=function getSymbolDictionaryHuffmanTables(e,t,r){let a,i,n,s,o=0;switch(e.huffmanDHSelector){case 0:case 1:a=getStandardTable(e.huffmanDHSelector+4);break;case 3:a=getCustomHuffmanTable(o,t,r);o++;break;default:throw new Jbig2Error("invalid Huffman DH selector")}switch(e.huffmanDWSelector){case 0:case 1:i=getStandardTable(e.huffmanDWSelector+2);break;case 3:i=getCustomHuffmanTable(o,t,r);o++;break;default:throw new Jbig2Error("invalid Huffman DW selector")}if(e.bitmapSizeSelector){n=getCustomHuffmanTable(o,t,r);o++}else n=getStandardTable(1);s=e.aggregationInstancesSelector?getCustomHuffmanTable(o,t,r):getStandardTable(1);return{tableDeltaHeight:a,tableDeltaWidth:i,tableBitmapSize:n,tableAggregateInstances:s}}(e,r,this.customTables);c=new Reader(a,n,s)}var l=this.symbols;l||(this.symbols=l={});for(var h=[],u=0,d=r.length;u<d;u++){const e=l[r[u]];e&&(h=h.concat(e))}var f=new DecodingContext(a,n,s);l[t]=function decodeSymbolDictionary(e,t,r,a,n,s,o,c,l,h,u,d){if(e&&t)throw new Jbig2Error("symbol refinement with Huffman is not supported");var f=[],g=0,p=(0,i.log2)(r.length+a),m=u.decoder,b=u.contextCache;let y,w;if(e){y=getStandardTable(1);w=[];p=Math.max(p,1)}for(;f.length<a;){g+=e?s.tableDeltaHeight.decode(d):decodeInteger(b,"IADH",m);let a=0,i=0;const n=e?w.length:0;for(;;){var S,v=e?s.tableDeltaWidth.decode(d):decodeInteger(b,"IADW",m);if(null===v)break;a+=v;i+=a;if(t){var k=decodeInteger(b,"IAAI",m);if(k>1)S=decodeTextRegion(e,t,a,g,0,k,1,r.concat(f),p,0,0,1,0,s,l,h,u,0,d);else{var x=decodeIAID(b,m,p),C=decodeInteger(b,"IARDX",m),O=decodeInteger(b,"IARDY",m);S=decodeRefinement(a,g,l,x<r.length?r[x]:f[x-r.length],C,O,!1,h,u)}f.push(S)}else if(e)w.push(a);else{S=decodeBitmap(!1,a,g,o,!1,null,c,u);f.push(S)}}if(e&&!t){const e=s.tableBitmapSize.decode(d);d.byteAlign();let t;if(0===e)t=readUncompressedBitmap(d,i,g);else{const r=d.end,a=d.position+e;d.end=a;t=decodeMMRBitmap(d,i,g,!1);d.end=r;d.position=a}const r=w.length;if(n===r-1)f.push(t);else{let e,a,i,s,o,c=0;for(e=n;e<r;e++){s=w[e];i=c+s;o=[];for(a=0;a<g;a++)o.push(t[a].subarray(c,i));f.push(o);c=i}}}}for(var F=[],T=[],E=!1,M=r.length+a;T.length<M;){for(var D=e?y.decode(d):decodeInteger(b,"IAEX",m);D--;)T.push(E);E=!E}for(var N=0,R=r.length;N<R;N++)T[N]&&F.push(r[N]);for(var j=0;j<a;N++,j++)T[N]&&F.push(f[j]);return F}(e.huffman,e.refinement,h,e.numberOfNewSymbols,e.numberOfExportedSymbols,o,e.template,e.at,e.refinementTemplate,e.refinementAt,f,c)},onImmediateTextRegion:function SimpleSegmentVisitor_onImmediateTextRegion(e,t,r,a,n){var s=e.info;let o,c;for(var l=this.symbols,h=[],u=0,d=t.length;u<d;u++){const e=l[t[u]];e&&(h=h.concat(e))}var f=(0,i.log2)(h.length);if(e.huffman){c=new Reader(r,a,n);o=function getTextRegionHuffmanTables(e,t,r,a,i){const n=[];for(let e=0;e<=34;e++){const t=i.readBits(4);n.push(new HuffmanLine([e,t,0,0]))}const s=new HuffmanTable(n,!1);n.length=0;for(let e=0;e<a;){const t=s.decode(i);if(t>=32){let r,a,s;switch(t){case 32:if(0===e)throw new Jbig2Error("no previous value in symbol ID table");a=i.readBits(2)+3;r=n[e-1].prefixLength;break;case 33:a=i.readBits(3)+3;r=0;break;case 34:a=i.readBits(7)+11;r=0;break;default:throw new Jbig2Error("invalid code length in symbol ID table")}for(s=0;s<a;s++){n.push(new HuffmanLine([e,r,0,0]));e++}}else{n.push(new HuffmanLine([e,t,0,0]));e++}}i.byteAlign();const o=new HuffmanTable(n,!1);let c,l,h,u=0;switch(e.huffmanFS){case 0:case 1:c=getStandardTable(e.huffmanFS+6);break;case 3:c=getCustomHuffmanTable(u,t,r);u++;break;default:throw new Jbig2Error("invalid Huffman FS selector")}switch(e.huffmanDS){case 0:case 1:case 2:l=getStandardTable(e.huffmanDS+8);break;case 3:l=getCustomHuffmanTable(u,t,r);u++;break;default:throw new Jbig2Error("invalid Huffman DS selector")}switch(e.huffmanDT){case 0:case 1:case 2:h=getStandardTable(e.huffmanDT+11);break;case 3:h=getCustomHuffmanTable(u,t,r);u++;break;default:throw new Jbig2Error("invalid Huffman DT selector")}if(e.refinement)throw new Jbig2Error("refinement with Huffman is not supported");return{symbolIDTable:o,tableFirstS:c,tableDeltaS:l,tableDeltaT:h}}(e,t,this.customTables,h.length,c)}var g=new DecodingContext(r,a,n),p=decodeTextRegion(e.huffman,e.refinement,s.width,s.height,e.defaultPixelValue,e.numberOfSymbolInstances,e.stripSize,h,f,e.transposed,e.dsOffset,e.referenceCorner,e.combinationOperator,o,e.refinementTemplate,e.refinementAt,g,e.logStripSize,c);this.drawBitmap(s,p)},onImmediateLosslessTextRegion:function SimpleSegmentVisitor_onImmediateLosslessTextRegion(){this.onImmediateTextRegion.apply(this,arguments)},onPatternDictionary(e,t,r,a,i){let n=this.patterns;n||(this.patterns=n={});const s=new DecodingContext(r,a,i);n[t]=function decodePatternDictionary(e,t,r,a,i,n){const s=[];if(!e){s.push({x:-t,y:0});if(0===i){s.push({x:-3,y:-1});s.push({x:2,y:-2});s.push({x:-2,y:-2})}}const o=decodeBitmap(e,(a+1)*t,r,i,!1,null,s,n),c=[];for(let e=0;e<=a;e++){const a=[],i=t*e,n=i+t;for(let e=0;e<r;e++)a.push(o[e].subarray(i,n));c.push(a)}return c}(e.mmr,e.patternWidth,e.patternHeight,e.maxPatternIndex,e.template,s)},onImmediateHalftoneRegion(e,t,r,a,n){const s=this.patterns[t[0]],o=e.info,c=new DecodingContext(r,a,n),l=function decodeHalftoneRegion(e,t,r,a,n,s,o,c,l,h,u,d,f,g,p){if(o)throw new Jbig2Error("skip is not supported");if(0!==c)throw new Jbig2Error("operator "+c+" is not supported in halftone region");const m=[];let b,y,w;for(b=0;b<n;b++){w=new Uint8Array(a);if(s)for(y=0;y<a;y++)w[y]=s;m.push(w)}const S=t.length,v=t[0],k=v[0].length,x=v.length,C=(0,i.log2)(S),O=[];if(!e){O.push({x:r<=1?3:2,y:-1});if(0===r){O.push({x:-3,y:-1});O.push({x:2,y:-2});O.push({x:-2,y:-2})}}const F=[];let T,E,M,D,N,R,j,L,_,U,X;e&&(T=new Reader(p.data,p.start,p.end));for(b=C-1;b>=0;b--){E=e?decodeMMRBitmap(T,l,h,!0):decodeBitmap(!1,l,h,r,!1,null,O,p);F[b]=E}for(M=0;M<h;M++)for(D=0;D<l;D++){N=0;R=0;for(y=C-1;y>=0;y--){N=F[y][M][D]^N;R|=N<<y}j=t[R];L=u+M*g+D*f>>8;_=d+M*f-D*g>>8;if(L>=0&&L+k<=a&&_>=0&&_+x<=n)for(b=0;b<x;b++){X=m[_+b];U=j[b];for(y=0;y<k;y++)X[L+y]|=U[y]}else{let e,t;for(b=0;b<x;b++){t=_+b;if(!(t<0||t>=n)){X=m[t];U=j[b];for(y=0;y<k;y++){e=L+y;e>=0&&e<a&&(X[e]|=U[y])}}}}}return m}(e.mmr,s,e.template,o.width,o.height,e.defaultPixelValue,e.enableSkip,e.combinationOperator,e.gridWidth,e.gridHeight,e.gridOffsetX,e.gridOffsetY,e.gridVectorX,e.gridVectorY,c);this.drawBitmap(o,l)},onImmediateLosslessHalftoneRegion(){this.onImmediateHalftoneRegion.apply(this,arguments)},onTables(e,t,r,a){let n=this.customTables;n||(this.customTables=n={});n[e]=function decodeTablesSegment(e,t,r){const a=e[t],n=4294967295&(0,i.readUint32)(e,t+1),s=4294967295&(0,i.readUint32)(e,t+5),o=new Reader(e,t+9,r),c=1+(a>>1&7),l=1+(a>>4&7),h=[];let u,d,f=n;do{u=o.readBits(c);d=o.readBits(l);h.push(new HuffmanLine([f,u,d,0]));f+=1<<d}while(f<s);u=o.readBits(c);h.push(new HuffmanLine([n-1,u,32,0,"lower"]));u=o.readBits(c);h.push(new HuffmanLine([s,u,32,0]));if(1&a){u=o.readBits(c);h.push(new HuffmanLine([u,0]))}return new HuffmanTable(h,!1)}(t,r,a)}};function HuffmanLine(e){if(2===e.length){this.isOOB=!0;this.rangeLow=0;this.prefixLength=e[0];this.rangeLength=0;this.prefixCode=e[1];this.isLowerRange=!1}else{this.isOOB=!1;this.rangeLow=e[0];this.prefixLength=e[1];this.rangeLength=e[2];this.prefixCode=e[3];this.isLowerRange="lower"===e[4]}}function HuffmanTreeNode(e){this.children=[];if(e){this.isLeaf=!0;this.rangeLength=e.rangeLength;this.rangeLow=e.rangeLow;this.isLowerRange=e.isLowerRange;this.isOOB=e.isOOB}else this.isLeaf=!1}HuffmanTreeNode.prototype={buildTree(e,t){const r=e.prefixCode>>t&1;if(t<=0)this.children[r]=new HuffmanTreeNode(e);else{let a=this.children[r];a||(this.children[r]=a=new HuffmanTreeNode(null));a.buildTree(e,t-1)}},decodeNode(e){if(this.isLeaf){if(this.isOOB)return null;const t=e.readBits(this.rangeLength);return this.rangeLow+(this.isLowerRange?-t:t)}const t=this.children[e.readBit()];if(!t)throw new Jbig2Error("invalid Huffman data");return t.decodeNode(e)}};function HuffmanTable(e,t){t||this.assignPrefixCodes(e);this.rootNode=new HuffmanTreeNode(null);for(let t=0,r=e.length;t<r;t++){const r=e[t];r.prefixLength>0&&this.rootNode.buildTree(r,r.prefixLength-1)}}HuffmanTable.prototype={decode(e){return this.rootNode.decodeNode(e)},assignPrefixCodes(e){const t=e.length;let r=0;for(let a=0;a<t;a++)r=Math.max(r,e[a].prefixLength);const a=new Uint32Array(r+1);for(let r=0;r<t;r++)a[e[r].prefixLength]++;let i,n,s,o=1,c=0;a[0]=0;for(;o<=r;){c=c+a[o-1]<<1;i=c;n=0;for(;n<t;){s=e[n];if(s.prefixLength===o){s.prefixCode=i;i++}n++}o++}}};const h={};function getStandardTable(e){let t,r=h[e];if(r)return r;switch(e){case 1:t=[[0,1,4,0],[16,2,8,2],[272,3,16,6],[65808,3,32,7]];break;case 2:t=[[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[75,6,32,62],[6,63]];break;case 3:t=[[-256,8,8,254],[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[-257,8,32,255,"lower"],[75,7,32,126],[6,62]];break;case 4:t=[[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[76,5,32,31]];break;case 5:t=[[-255,7,8,126],[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[-256,7,32,127,"lower"],[76,6,32,62]];break;case 6:t=[[-2048,5,10,28],[-1024,4,9,8],[-512,4,8,9],[-256,4,7,10],[-128,5,6,29],[-64,5,5,30],[-32,4,5,11],[0,2,7,0],[128,3,7,2],[256,3,8,3],[512,4,9,12],[1024,4,10,13],[-2049,6,32,62,"lower"],[2048,6,32,63]];break;case 7:t=[[-1024,4,9,8],[-512,3,8,0],[-256,4,7,9],[-128,5,6,26],[-64,5,5,27],[-32,4,5,10],[0,4,5,11],[32,5,5,28],[64,5,6,29],[128,4,7,12],[256,3,8,1],[512,3,9,2],[1024,3,10,3],[-1025,5,32,30,"lower"],[2048,5,32,31]];break;case 8:t=[[-15,8,3,252],[-7,9,1,508],[-5,8,1,253],[-3,9,0,509],[-2,7,0,124],[-1,4,0,10],[0,2,1,0],[2,5,0,26],[3,6,0,58],[4,3,4,4],[20,6,1,59],[22,4,4,11],[38,4,5,12],[70,5,6,27],[134,5,7,28],[262,6,7,60],[390,7,8,125],[646,6,10,61],[-16,9,32,510,"lower"],[1670,9,32,511],[2,1]];break;case 9:t=[[-31,8,4,252],[-15,9,2,508],[-11,8,2,253],[-7,9,1,509],[-5,7,1,124],[-3,4,1,10],[-1,3,1,2],[1,3,1,3],[3,5,1,26],[5,6,1,58],[7,3,5,4],[39,6,2,59],[43,4,5,11],[75,4,6,12],[139,5,7,27],[267,5,8,28],[523,6,8,60],[779,7,9,125],[1291,6,11,61],[-32,9,32,510,"lower"],[3339,9,32,511],[2,0]];break;case 10:t=[[-21,7,4,122],[-5,8,0,252],[-4,7,0,123],[-3,5,0,24],[-2,2,2,0],[2,5,0,25],[3,6,0,54],[4,7,0,124],[5,8,0,253],[6,2,6,1],[70,5,5,26],[102,6,5,55],[134,6,6,56],[198,6,7,57],[326,6,8,58],[582,6,9,59],[1094,6,10,60],[2118,7,11,125],[-22,8,32,254,"lower"],[4166,8,32,255],[2,2]];break;case 11:t=[[1,1,0,0],[2,2,1,2],[4,4,0,12],[5,4,1,13],[7,5,1,28],[9,5,2,29],[13,6,2,60],[17,7,2,122],[21,7,3,123],[29,7,4,124],[45,7,5,125],[77,7,6,126],[141,7,32,127]];break;case 12:t=[[1,1,0,0],[2,2,0,2],[3,3,1,6],[5,5,0,28],[6,5,1,29],[8,6,1,60],[10,7,0,122],[11,7,1,123],[13,7,2,124],[17,7,3,125],[25,7,4,126],[41,8,5,254],[73,8,32,255]];break;case 13:t=[[1,1,0,0],[2,3,0,4],[3,4,0,12],[4,5,0,28],[5,4,1,13],[7,3,3,5],[15,6,1,58],[17,6,2,59],[21,6,3,60],[29,6,4,61],[45,6,5,62],[77,7,6,126],[141,7,32,127]];break;case 14:t=[[-2,3,0,4],[-1,3,0,5],[0,1,0,0],[1,3,0,6],[2,3,0,7]];break;case 15:t=[[-24,7,4,124],[-8,6,2,60],[-4,5,1,28],[-2,4,0,12],[-1,3,0,4],[0,1,0,0],[1,3,0,5],[2,4,0,13],[3,5,1,29],[5,6,2,61],[9,7,4,125],[-25,7,32,126,"lower"],[25,7,32,127]];break;default:throw new Jbig2Error(`standard table B.${e} does not exist`)}for(let e=0,r=t.length;e<r;e++)t[e]=new HuffmanLine(t[e]);r=new HuffmanTable(t,!0);h[e]=r;return r}function Reader(e,t,r){this.data=e;this.start=t;this.end=r;this.position=t;this.shift=-1;this.currentByte=0}Reader.prototype={readBit(){if(this.shift<0){if(this.position>=this.end)throw new Jbig2Error("end of data while reading bit");this.currentByte=this.data[this.position++];this.shift=7}const e=this.currentByte>>this.shift&1;this.shift--;return e},readBits(e){let t,r=0;for(t=e-1;t>=0;t--)r|=this.readBit()<<t;return r},byteAlign(){this.shift=-1},next(){return this.position>=this.end?-1:this.data[this.position++]}};function getCustomHuffmanTable(e,t,r){let a=0;for(let i=0,n=t.length;i<n;i++){const n=r[t[i]];if(n){if(e===a)return n;a++}}throw new Jbig2Error("can't find custom Huffman table")}function readUncompressedBitmap(e,t,r){const a=[];for(let i=0;i<r;i++){const r=new Uint8Array(t);a.push(r);for(let a=0;a<t;a++)r[a]=e.readBit();e.byteAlign()}return a}function decodeMMRBitmap(e,t,r,a){const i={K:-1,Columns:t,Rows:r,BlackIs1:!0,EndOfBlock:a},n=new s.CCITTFaxDecoder(e,i),o=[];let c,l=!1;for(let e=0;e<r;e++){const e=new Uint8Array(t);o.push(e);let r=-1;for(let a=0;a<t;a++){if(r<0){c=n.readNextChar();if(-1===c){c=0;l=!0}r=7}e[a]=c>>r&1;r--}}if(a&&!l){const e=5;for(let t=0;t<e&&-1!==n.readNextChar();t++);}return o}function Jbig2Image(){}Jbig2Image.prototype={parseChunks:e=>function parseJbig2Chunks(e){for(var t=new SimpleSegmentVisitor,r=0,a=e.length;r<a;r++){var i=e[r];processSegments(readSegments({},i.data,i.start,i.end),t)}return t.buffer}(e),parse(e){const{imgData:t,width:r,height:a}=function parseJbig2(e){const t=e.length;let r=0;if(151!==e[r]||74!==e[r+1]||66!==e[r+2]||50!==e[r+3]||13!==e[r+4]||10!==e[r+5]||26!==e[r+6]||10!==e[r+7])throw new Jbig2Error("parseJbig2 - invalid header.");const a=Object.create(null);r+=8;const n=e[r++];a.randomAccess=!(1&n);if(!(2&n)){a.numberOfPages=(0,i.readUint32)(e,r);r+=4}const s=readSegments(a,e,r,t),o=new SimpleSegmentVisitor;processSegments(s,o);const{width:c,height:l}=o.currentPageInfo,h=o.buffer,u=new Uint8ClampedArray(c*l);let d=0,f=0;for(let e=0;e<l;e++){let e,t=0;for(let r=0;r<c;r++){if(!t){t=128;e=h[f++]}u[d++]=e&t?0:255;t>>=1}}return{imgData:u,width:c,height:l}}(e);this.width=r;this.height=a;return t}};return Jbig2Image}();t.Jbig2Image=o},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ArithmeticDecoder=void 0;const r=[{qe:22017,nmps:1,nlps:1,switchFlag:1},{qe:13313,nmps:2,nlps:6,switchFlag:0},{qe:6145,nmps:3,nlps:9,switchFlag:0},{qe:2753,nmps:4,nlps:12,switchFlag:0},{qe:1313,nmps:5,nlps:29,switchFlag:0},{qe:545,nmps:38,nlps:33,switchFlag:0},{qe:22017,nmps:7,nlps:6,switchFlag:1},{qe:21505,nmps:8,nlps:14,switchFlag:0},{qe:18433,nmps:9,nlps:14,switchFlag:0},{qe:14337,nmps:10,nlps:14,switchFlag:0},{qe:12289,nmps:11,nlps:17,switchFlag:0},{qe:9217,nmps:12,nlps:18,switchFlag:0},{qe:7169,nmps:13,nlps:20,switchFlag:0},{qe:5633,nmps:29,nlps:21,switchFlag:0},{qe:22017,nmps:15,nlps:14,switchFlag:1},{qe:21505,nmps:16,nlps:14,switchFlag:0},{qe:20737,nmps:17,nlps:15,switchFlag:0},{qe:18433,nmps:18,nlps:16,switchFlag:0},{qe:14337,nmps:19,nlps:17,switchFlag:0},{qe:13313,nmps:20,nlps:18,switchFlag:0},{qe:12289,nmps:21,nlps:19,switchFlag:0},{qe:10241,nmps:22,nlps:19,switchFlag:0},{qe:9217,nmps:23,nlps:20,switchFlag:0},{qe:8705,nmps:24,nlps:21,switchFlag:0},{qe:7169,nmps:25,nlps:22,switchFlag:0},{qe:6145,nmps:26,nlps:23,switchFlag:0},{qe:5633,nmps:27,nlps:24,switchFlag:0},{qe:5121,nmps:28,nlps:25,switchFlag:0},{qe:4609,nmps:29,nlps:26,switchFlag:0},{qe:4353,nmps:30,nlps:27,switchFlag:0},{qe:2753,nmps:31,nlps:28,switchFlag:0},{qe:2497,nmps:32,nlps:29,switchFlag:0},{qe:2209,nmps:33,nlps:30,switchFlag:0},{qe:1313,nmps:34,nlps:31,switchFlag:0},{qe:1089,nmps:35,nlps:32,switchFlag:0},{qe:673,nmps:36,nlps:33,switchFlag:0},{qe:545,nmps:37,nlps:34,switchFlag:0},{qe:321,nmps:38,nlps:35,switchFlag:0},{qe:273,nmps:39,nlps:36,switchFlag:0},{qe:133,nmps:40,nlps:37,switchFlag:0},{qe:73,nmps:41,nlps:38,switchFlag:0},{qe:37,nmps:42,nlps:39,switchFlag:0},{qe:21,nmps:43,nlps:40,switchFlag:0},{qe:9,nmps:44,nlps:41,switchFlag:0},{qe:5,nmps:45,nlps:42,switchFlag:0},{qe:1,nmps:45,nlps:43,switchFlag:0},{qe:22017,nmps:46,nlps:46,switchFlag:0}];t.ArithmeticDecoder=class ArithmeticDecoder{constructor(e,t,r){this.data=e;this.bp=t;this.dataEnd=r;this.chigh=e[t];this.clow=0;this.byteIn();this.chigh=this.chigh<<7&65535|this.clow>>9&127;this.clow=this.clow<<7&65535;this.ct-=7;this.a=32768}byteIn(){const e=this.data;let t=this.bp;if(255===e[t])if(e[t+1]>143){this.clow+=65280;this.ct=8}else{t++;this.clow+=e[t]<<9;this.ct=7;this.bp=t}else{t++;this.clow+=t<this.dataEnd?e[t]<<8:65280;this.ct=8;this.bp=t}if(this.clow>65535){this.chigh+=this.clow>>16;this.clow&=65535}}readBit(e,t){let a=e[t]>>1,i=1&e[t];const n=r[a],s=n.qe;let o,c=this.a-s;if(this.chigh<s)if(c<s){c=s;o=i;a=n.nmps}else{c=s;o=1^i;1===n.switchFlag&&(i=o);a=n.nlps}else{this.chigh-=s;if(0!=(32768&c)){this.a=c;return i}if(c<s){o=1^i;1===n.switchFlag&&(i=o);a=n.nlps}else{o=i;a=n.nmps}}do{0===this.ct&&this.byteIn();c<<=1;this.chigh=this.chigh<<1&65535|this.clow>>15&1;this.clow=this.clow<<1&65535;this.ct--}while(0==(32768&c));this.a=c;e[t]=a<<1|i;return o}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.JpegStream=void 0;var a=r(12),i=r(5),n=r(19),s=r(2);const o=function JpegStreamClosure(){function JpegStream(e,t,r,i){let n;for(;-1!==(n=e.getByte());)if(255===n){e.skip(-1);break}this.stream=e;this.maybeLength=t;this.dict=r;this.params=i;a.DecodeStream.call(this,t)}JpegStream.prototype=Object.create(a.DecodeStream.prototype);Object.defineProperty(JpegStream.prototype,"bytes",{get:function JpegStream_bytes(){return(0,s.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});JpegStream.prototype.ensureBuffer=function(e){};JpegStream.prototype.readBlock=function(){if(this.eof)return;const e={decodeTransform:void 0,colorTransform:void 0},t=this.dict.getArray("Decode","D");if(this.forceRGB&&Array.isArray(t)){const r=this.dict.get("BitsPerComponent")||8,a=t.length,i=new Int32Array(a);let n=!1;const s=(1<<r)-1;for(let e=0;e<a;e+=2){i[e]=256*(t[e+1]-t[e])|0;i[e+1]=t[e]*s|0;256===i[e]&&0===i[e+1]||(n=!0)}n&&(e.decodeTransform=i)}if((0,i.isDict)(this.params)){const t=this.params.get("ColorTransform");Number.isInteger(t)&&(e.colorTransform=t)}const r=new n.JpegImage(e);r.parse(this.bytes);const a=r.getData({width:this.drawWidth,height:this.drawHeight,forceRGB:this.forceRGB,isSourcePDF:!0});this.buffer=a;this.bufferLength=a.length;this.eof=!0};return JpegStream}();t.JpegStream=o},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.JpegImage=void 0;var a=r(2),i=r(8);class JpegError extends a.BaseException{constructor(e){super(`JPEG error: ${e}`)}}class DNLMarkerError extends a.BaseException{constructor(e,t){super(e);this.scanLines=t}}class EOIMarkerError extends a.BaseException{}var n=function JpegImageClosure(){var e=new Uint8Array([0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]),t=4017,r=799,n=3406,s=2276,o=1567,c=3784,l=5793,h=2896;function JpegImage({decodeTransform:e=null,colorTransform:t=-1}={}){this._decodeTransform=e;this._colorTransform=t}function buildHuffmanTable(e,t){for(var r,a,i=0,n=[],s=16;s>0&&!e[s-1];)s--;n.push({children:[],index:0});var o,c=n[0];for(r=0;r<s;r++){for(a=0;a<e[r];a++){(c=n.pop()).children[c.index]=t[i];for(;c.index>0;)c=n.pop();c.index++;n.push(c);for(;n.length<=r;){n.push(o={children:[],index:0});c.children[c.index]=o.children;c=o}i++}if(r+1<s){n.push(o={children:[],index:0});c.children[c.index]=o.children;c=o}}return n[0].children}function getBlockBufferOffset(e,t,r){return 64*((e.blocksPerLine+1)*t+r)}function decodeScan(t,r,n,s,o,c,l,h,u,d=!1){var f=n.mcusPerLine,g=n.progressive;const p=r;let m=0,b=0;function readBit(){if(b>0){b--;return m>>b&1}m=t[r++];if(255===m){var e=t[r++];if(e){if(220===e&&d){r+=2;const e=(0,i.readUint16)(t,r);r+=2;if(e>0&&e!==n.scanLines)throw new DNLMarkerError("Found DNL marker (0xFFDC) while parsing scan data",e)}else if(217===e){if(d){const e=v*(8===n.precision?8:0);if(e>0&&Math.round(n.scanLines/e)>=10)throw new DNLMarkerError("Found EOI marker (0xFFD9) while parsing scan data, possibly caused by incorrect `scanLines` parameter",e)}throw new EOIMarkerError("Found EOI marker (0xFFD9) while parsing scan data")}throw new JpegError(`unexpected marker ${(m<<8|e).toString(16)}`)}}b=7;return m>>>7}function decodeHuffman(e){for(var t=e;;){switch(typeof(t=t[readBit()])){case"number":return t;case"object":continue}throw new JpegError("invalid huffman sequence")}}function receive(e){for(var t=0;e>0;){t=t<<1|readBit();e--}return t}function receiveAndExtend(e){if(1===e)return 1===readBit()?1:-1;var t=receive(e);return t>=1<<e-1?t:t+(-1<<e)+1}var y=0;var w,S=0;let v=0;function decodeMcu(e,t,r,a,i){var n=r%f;v=(r/f|0)*e.v+a;var s=n*e.h+i;t(e,getBlockBufferOffset(e,v,s))}function decodeBlock(e,t,r){v=r/e.blocksPerLine|0;var a=r%e.blocksPerLine;t(e,getBlockBufferOffset(e,v,a))}var k,x,C,O,F,T,E=s.length;T=g?0===c?0===h?function decodeDCFirst(e,t){var r=decodeHuffman(e.huffmanTableDC),a=0===r?0:receiveAndExtend(r)<<u;e.blockData[t]=e.pred+=a}:function decodeDCSuccessive(e,t){e.blockData[t]|=readBit()<<u}:0===h?function decodeACFirst(t,r){if(y>0)y--;else for(var a=c,i=l;a<=i;){var n=decodeHuffman(t.huffmanTableAC),s=15&n,o=n>>4;if(0!==s){var h=e[a+=o];t.blockData[r+h]=receiveAndExtend(s)*(1<<u);a++}else{if(o<15){y=receive(o)+(1<<o)-1;break}a+=16}}}:function decodeACSuccessive(t,r){for(var a,i,n=c,s=l,o=0;n<=s;){const s=r+e[n],c=t.blockData[s]<0?-1:1;switch(S){case 0:o=(i=decodeHuffman(t.huffmanTableAC))>>4;if(0==(a=15&i))if(o<15){y=receive(o)+(1<<o);S=4}else{o=16;S=1}else{if(1!==a)throw new JpegError("invalid ACn encoding");w=receiveAndExtend(a);S=o?2:3}continue;case 1:case 2:t.blockData[s]?t.blockData[s]+=c*(readBit()<<u):0==--o&&(S=2===S?3:0);break;case 3:if(t.blockData[s])t.blockData[s]+=c*(readBit()<<u);else{t.blockData[s]=w<<u;S=0}break;case 4:t.blockData[s]&&(t.blockData[s]+=c*(readBit()<<u))}n++}4===S&&0==--y&&(S=0)}:function decodeBaseline(t,r){var a=decodeHuffman(t.huffmanTableDC),i=0===a?0:receiveAndExtend(a);t.blockData[r]=t.pred+=i;for(var n=1;n<64;){var s=decodeHuffman(t.huffmanTableAC),o=15&s,c=s>>4;if(0!==o){var l=e[n+=c];t.blockData[r+l]=receiveAndExtend(o);n++}else{if(c<15)break;n+=16}}};var M,D,N,R,j=0;D=1===E?s[0].blocksPerLine*s[0].blocksPerColumn:f*n.mcusPerColumn;for(;j<=D;){var L=o?Math.min(D-j,o):D;if(L>0){for(x=0;x<E;x++)s[x].pred=0;y=0;if(1===E){k=s[0];for(F=0;F<L;F++){decodeBlock(k,T,j);j++}}else for(F=0;F<L;F++){for(x=0;x<E;x++){N=(k=s[x]).h;R=k.v;for(C=0;C<R;C++)for(O=0;O<N;O++)decodeMcu(k,T,j,C,O)}j++}}b=0;if(!(M=findNextFileMarker(t,r)))break;if(M.invalid){const e=L>0?"unexpected":"excessive";(0,a.warn)(`decodeScan - ${e} MCU data, current marker is: ${M.invalid}`);r=M.offset}if(!(M.marker>=65488&&M.marker<=65495))break;r+=2}return r-p}function quantizeAndInverse(e,a,i){var u,d,f,g,p,m,b,y,w,S,v,k,x,C,O,F,T,E=e.quantizationTable,M=e.blockData;if(!E)throw new JpegError("missing required Quantization Table.");for(var D=0;D<64;D+=8){w=M[a+D];S=M[a+D+1];v=M[a+D+2];k=M[a+D+3];x=M[a+D+4];C=M[a+D+5];O=M[a+D+6];F=M[a+D+7];w*=E[D];if(0!=(S|v|k|x|C|O|F)){S*=E[D+1];v*=E[D+2];k*=E[D+3];x*=E[D+4];C*=E[D+5];O*=E[D+6];F*=E[D+7];d=(u=(u=l*w+128>>8)+(d=l*x+128>>8)+1>>1)-d;T=(f=v)*c+(g=O)*o+128>>8;f=f*o-g*c+128>>8;b=(p=(p=h*(S-F)+128>>8)+(b=C<<4)+1>>1)-b;m=(y=(y=h*(S+F)+128>>8)+(m=k<<4)+1>>1)-m;g=(u=u+(g=T)+1>>1)-g;f=(d=d+f+1>>1)-f;T=p*s+y*n+2048>>12;p=p*n-y*s+2048>>12;y=T;T=m*r+b*t+2048>>12;m=m*t-b*r+2048>>12;b=T;i[D]=u+y;i[D+7]=u-y;i[D+1]=d+b;i[D+6]=d-b;i[D+2]=f+m;i[D+5]=f-m;i[D+3]=g+p;i[D+4]=g-p}else{T=l*w+512>>10;i[D]=T;i[D+1]=T;i[D+2]=T;i[D+3]=T;i[D+4]=T;i[D+5]=T;i[D+6]=T;i[D+7]=T}}for(var N=0;N<8;++N){w=i[N];if(0!=((S=i[N+8])|(v=i[N+16])|(k=i[N+24])|(x=i[N+32])|(C=i[N+40])|(O=i[N+48])|(F=i[N+56]))){d=(u=4112+((u=l*w+2048>>12)+(d=l*x+2048>>12)+1>>1))-d;T=(f=v)*c+(g=O)*o+2048>>12;f=f*o-g*c+2048>>12;g=T;b=(p=(p=h*(S-F)+2048>>12)+(b=C)+1>>1)-b;m=(y=(y=h*(S+F)+2048>>12)+(m=k)+1>>1)-m;T=p*s+y*n+2048>>12;p=p*n-y*s+2048>>12;y=T;T=m*r+b*t+2048>>12;m=m*t-b*r+2048>>12;(w=(u=u+g+1>>1)+y)<16?w=0:w>=4080?w=255:w>>=4;(S=(d=d+f+1>>1)+(b=T))<16?S=0:S>=4080?S=255:S>>=4;(v=(f=d-f)+m)<16?v=0:v>=4080?v=255:v>>=4;(k=(g=u-g)+p)<16?k=0:k>=4080?k=255:k>>=4;(x=g-p)<16?x=0:x>=4080?x=255:x>>=4;(C=f-m)<16?C=0:C>=4080?C=255:C>>=4;(O=d-b)<16?O=0:O>=4080?O=255:O>>=4;(F=u-y)<16?F=0:F>=4080?F=255:F>>=4;M[a+N]=w;M[a+N+8]=S;M[a+N+16]=v;M[a+N+24]=k;M[a+N+32]=x;M[a+N+40]=C;M[a+N+48]=O;M[a+N+56]=F}else{T=(T=l*w+8192>>14)<-2040?0:T>=2024?255:T+2056>>4;M[a+N]=T;M[a+N+8]=T;M[a+N+16]=T;M[a+N+24]=T;M[a+N+32]=T;M[a+N+40]=T;M[a+N+48]=T;M[a+N+56]=T}}}function buildComponentData(e,t){for(var r=t.blocksPerLine,a=t.blocksPerColumn,i=new Int16Array(64),n=0;n<a;n++)for(var s=0;s<r;s++){quantizeAndInverse(t,getBlockBufferOffset(t,n,s),i)}return t.blockData}function findNextFileMarker(e,t,r=t){const a=e.length-1;var n=r<t?r:t;if(t>=a)return null;var s=(0,i.readUint16)(e,t);if(s>=65472&&s<=65534)return{invalid:null,marker:s,offset:t};for(var o=(0,i.readUint16)(e,n);!(o>=65472&&o<=65534);){if(++n>=a)return null;o=(0,i.readUint16)(e,n)}return{invalid:s.toString(16),marker:o,offset:n}}JpegImage.prototype={parse(t,{dnlScanLines:r=null}={}){function readDataBlock(){const e=(0,i.readUint16)(t,o);let r=(o+=2)+e-2;var n=findNextFileMarker(t,r,o);if(n&&n.invalid){(0,a.warn)("readDataBlock - incorrect length, current marker is: "+n.invalid);r=n.offset}var s=t.subarray(o,r);o+=s.length;return s}function prepareComponents(e){for(var t=Math.ceil(e.samplesPerLine/8/e.maxH),r=Math.ceil(e.scanLines/8/e.maxV),a=0;a<e.components.length;a++){j=e.components[a];var i=Math.ceil(Math.ceil(e.samplesPerLine/8)*j.h/e.maxH),n=Math.ceil(Math.ceil(e.scanLines/8)*j.v/e.maxV),s=t*j.h,o=64*(r*j.v)*(s+1);j.blockData=new Int16Array(o);j.blocksPerLine=i;j.blocksPerColumn=n}e.mcusPerLine=t;e.mcusPerColumn=r}var n,s,o=0,c=null,l=null;let h=0;var u=[],d=[],f=[];let g=(0,i.readUint16)(t,o);o+=2;if(65496!==g)throw new JpegError("SOI not found");g=(0,i.readUint16)(t,o);o+=2;e:for(;65497!==g;){var p,m,b;switch(g){case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var y=readDataBlock();65504===g&&74===y[0]&&70===y[1]&&73===y[2]&&70===y[3]&&0===y[4]&&(c={version:{major:y[5],minor:y[6]},densityUnits:y[7],xDensity:y[8]<<8|y[9],yDensity:y[10]<<8|y[11],thumbWidth:y[12],thumbHeight:y[13],thumbData:y.subarray(14,14+3*y[12]*y[13])});65518===g&&65===y[0]&&100===y[1]&&111===y[2]&&98===y[3]&&101===y[4]&&(l={version:y[5]<<8|y[6],flags0:y[7]<<8|y[8],flags1:y[9]<<8|y[10],transformCode:y[11]});break;case 65499:for(var w=(0,i.readUint16)(t,o)+(o+=2)-2;o<w;){var S=t[o++],v=new Uint16Array(64);if(S>>4==0)for(m=0;m<64;m++)v[e[m]]=t[o++];else{if(S>>4!=1)throw new JpegError("DQT - invalid table spec");for(m=0;m<64;m++){v[e[m]]=(0,i.readUint16)(t,o);o+=2}}u[15&S]=v}break;case 65472:case 65473:case 65474:if(n)throw new JpegError("Only single frame JPEGs supported");o+=2;(n={}).extended=65473===g;n.progressive=65474===g;n.precision=t[o++];const G=(0,i.readUint16)(t,o);o+=2;n.scanLines=r||G;n.samplesPerLine=(0,i.readUint16)(t,o);o+=2;n.components=[];n.componentIds={};var k,x=t[o++],C=0,O=0;for(p=0;p<x;p++){k=t[o];var F=t[o+1]>>4,T=15&t[o+1];C<F&&(C=F);O<T&&(O=T);var E=t[o+2];b=n.components.push({h:F,v:T,quantizationId:E,quantizationTable:null});n.componentIds[k]=b-1;o+=3}n.maxH=C;n.maxV=O;prepareComponents(n);break;case 65476:const W=(0,i.readUint16)(t,o);o+=2;for(p=2;p<W;){var M=t[o++],D=new Uint8Array(16),N=0;for(m=0;m<16;m++,o++)N+=D[m]=t[o];var R=new Uint8Array(N);for(m=0;m<N;m++,o++)R[m]=t[o];p+=17+N;(M>>4==0?f:d)[15&M]=buildHuffmanTable(D,R)}break;case 65501:o+=2;s=(0,i.readUint16)(t,o);o+=2;break;case 65498:const V=1==++h&&!r;o+=2;var j,L=t[o++],_=[];for(p=0;p<L;p++){const e=t[o++];var U=n.componentIds[e];(j=n.components[U]).index=e;var X=t[o++];j.huffmanTableDC=f[X>>4];j.huffmanTableAC=d[15&X];_.push(j)}var q=t[o++],$=t[o++],H=t[o++];try{var z=decodeScan(t,o,n,_,s,q,$,H>>4,15&H,V);o+=z}catch(e){if(e instanceof DNLMarkerError){(0,a.warn)(`${e.message} -- attempting to re-parse the JPEG image.`);return this.parse(t,{dnlScanLines:e.scanLines})}if(e instanceof EOIMarkerError){(0,a.warn)(`${e.message} -- ignoring the rest of the image data.`);break e}throw e}break;case 65500:o+=4;break;case 65535:255!==t[o]&&o--;break;default:const J=findNextFileMarker(t,o-2,o-3);if(J&&J.invalid){(0,a.warn)("JpegImage.parse - unexpected data, current marker is: "+J.invalid);o=J.offset;break}if(!J||o>=t.length-1){(0,a.warn)("JpegImage.parse - reached the end of the image data without finding an EOI marker (0xFFD9).");break e}throw new JpegError("JpegImage.parse - unknown marker: "+g.toString(16))}g=(0,i.readUint16)(t,o);o+=2}this.width=n.samplesPerLine;this.height=n.scanLines;this.jfif=c;this.adobe=l;this.components=[];for(p=0;p<n.components.length;p++){var G=u[(j=n.components[p]).quantizationId];G&&(j.quantizationTable=G);this.components.push({index:j.index,output:buildComponentData(0,j),scaleX:j.h/n.maxH,scaleY:j.v/n.maxV,blocksPerLine:j.blocksPerLine,blocksPerColumn:j.blocksPerColumn})}this.numComponents=this.components.length},_getLinearizedBlockData(e,t,r=!1){var a,i,n,s,o,c,l,h,u,d,f,g=this.width/e,p=this.height/t,m=0,b=this.components.length,y=e*t*b,w=new Uint8ClampedArray(y),S=new Uint32Array(e),v=4294967288;let k;for(l=0;l<b;l++){i=(a=this.components[l]).scaleX*g;n=a.scaleY*p;m=l;f=a.output;s=a.blocksPerLine+1<<3;if(i!==k){for(o=0;o<e;o++){h=0|o*i;S[o]=(h&v)<<3|7&h}k=i}for(c=0;c<t;c++){d=s*((h=0|c*n)&v)|(7&h)<<3;for(o=0;o<e;o++){w[m]=f[d+S[o]];m+=b}}}let x=this._decodeTransform;r||4!==b||x||(x=new Int32Array([-256,255,-256,255,-256,255,-256,255]));if(x)for(l=0;l<y;)for(h=0,u=0;h<b;h++,l++,u+=2)w[l]=(w[l]*x[u]>>8)+x[u+1];return w},get _isColorConversionNeeded(){return this.adobe?!!this.adobe.transformCode:3===this.numComponents?0!==this._colorTransform&&(82!==this.components[0].index||71!==this.components[1].index||66!==this.components[2].index):1===this._colorTransform},_convertYccToRgb:function convertYccToRgb(e){for(var t,r,a,i=0,n=e.length;i<n;i+=3){t=e[i];r=e[i+1];a=e[i+2];e[i]=t-179.456+1.402*a;e[i+1]=t+135.459-.344*r-.714*a;e[i+2]=t-226.816+1.772*r}return e},_convertYcckToRgb:function convertYcckToRgb(e){for(var t,r,a,i,n=0,s=0,o=e.length;s<o;s+=4){t=e[s];r=e[s+1];a=e[s+2];i=e[s+3];e[n++]=r*(-660635669420364e-19*r+.000437130475926232*a-54080610064599e-18*t+.00048449797120281*i-.154362151871126)-122.67195406894+a*(-.000957964378445773*a+.000817076911346625*t-.00477271405408747*i+1.53380253221734)+t*(.000961250184130688*t-.00266257332283933*i+.48357088451265)+i*(-.000336197177618394*i+.484791561490776);e[n++]=107.268039397724+r*(219927104525741e-19*r-.000640992018297945*a+.000659397001245577*t+.000426105652938837*i-.176491792462875)+a*(-.000778269941513683*a+.00130872261408275*t+.000770482631801132*i-.151051492775562)+t*(.00126935368114843*t-.00265090189010898*i+.25802910206845)+i*(-.000318913117588328*i-.213742400323665);e[n++]=r*(-.000570115196973677*r-263409051004589e-19*a+.0020741088115012*t-.00288260236853442*i+.814272968359295)-20.810012546947+a*(-153496057440975e-19*a-.000132689043961446*t+.000560833691242812*i-.195152027534049)+t*(.00174418132927582*t-.00255243321439347*i+.116935020465145)+i*(-.000343531996510555*i+.24165260232407)}return e.subarray(0,n)},_convertYcckToCmyk:function convertYcckToCmyk(e){for(var t,r,a,i=0,n=e.length;i<n;i+=4){t=e[i];r=e[i+1];a=e[i+2];e[i]=434.456-t-1.402*a;e[i+1]=119.541-t+.344*r+.714*a;e[i+2]=481.816-t-1.772*r}return e},_convertCmykToRgb:function convertCmykToRgb(e){for(var t,r,a,i,n=0,s=0,o=e.length;s<o;s+=4){t=e[s];r=e[s+1];a=e[s+2];i=e[s+3];e[n++]=255+t*(-6747147073602441e-20*t+.0008379262121013727*r+.0002894718188643294*a+.003264231057537806*i-1.1185611867203937)+r*(26374107616089405e-21*r-8626949158638572e-20*a-.0002748769067499491*i-.02155688794978967)+a*(-3878099212869363e-20*a-.0003267808279485286*i+.0686742238595345)-i*(.0003361971776183937*i+.7430659151342254);e[n++]=255+t*(.00013596372813588848*t+.000924537132573585*r+.00010567359618683593*a+.0004791864687436512*i-.3109689587515875)+r*(-.00023545346108370344*r+.0002702845253534714*a+.0020200308977307156*i-.7488052167015494)+a*(6834815998235662e-20*a+.00015168452363460973*i-.09751927774728933)-i*(.0003189131175883281*i+.7364883807733168);e[n++]=255+t*(13598650411385307e-21*t+.00012423956175490851*r+.0004751985097583589*a-36729317476630422e-22*i-.05562186980264034)+r*(.00016141380598724676*r+.0009692239130725186*a+.0007782692450036253*i-.44015232367526463)+a*(5.068882914068769e-7*a+.0017778369011375071*i-.7591454649749609)-i*(.0003435319965105553*i+.7063770186160144)}return e.subarray(0,n)},getData({width:e,height:t,forceRGB:r=!1,isSourcePDF:a=!1}){if(this.numComponents>4)throw new JpegError("Unsupported color mode");var i=this._getLinearizedBlockData(e,t,a);if(1===this.numComponents&&r){for(var n=i.length,s=new Uint8ClampedArray(3*n),o=0,c=0;c<n;c++){var l=i[c];s[o++]=l;s[o++]=l;s[o++]=l}return s}if(3===this.numComponents&&this._isColorConversionNeeded)return this._convertYccToRgb(i);if(4===this.numComponents){if(this._isColorConversionNeeded)return r?this._convertYcckToRgb(i):this._convertYcckToCmyk(i);if(r)return this._convertCmykToRgb(i)}return i}};return JpegImage}();t.JpegImage=n},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.JpxStream=void 0;var a=r(12),i=r(21),n=r(2);const s=function JpxStreamClosure(){function JpxStream(e,t,r,i){this.stream=e;this.maybeLength=t;this.dict=r;this.params=i;a.DecodeStream.call(this,t)}JpxStream.prototype=Object.create(a.DecodeStream.prototype);Object.defineProperty(JpxStream.prototype,"bytes",{get:function JpxStream_bytes(){return(0,n.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});JpxStream.prototype.ensureBuffer=function(e){};JpxStream.prototype.readBlock=function(){if(this.eof)return;const e=new i.JpxImage;e.parse(this.bytes);const t=e.width,r=e.height,a=e.componentsCount,n=e.tiles.length;if(1===n)this.buffer=e.tiles[0].items;else{const i=new Uint8ClampedArray(t*r*a);for(let r=0;r<n;r++){const n=e.tiles[r],s=n.width,o=n.height,c=n.left,l=n.top,h=n.items;let u=0,d=(t*l+c)*a;const f=t*a,g=s*a;for(let e=0;e<o;e++){const e=h.subarray(u,u+g);i.set(e,d);u+=g;d+=f}}this.buffer=i}this.bufferLength=this.buffer.length;this.eof=!0};return JpxStream}();t.JpxStream=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.JpxImage=void 0;var a=r(2),i=r(8),n=r(17);class JpxError extends a.BaseException{constructor(e){super(`JPX error: ${e}`)}}var s=function JpxImageClosure(){var e={LL:0,LH:1,HL:1,HH:2};function JpxImage(){this.failOnCorruptedImage=!1}JpxImage.prototype={parse:function JpxImage_parse(e){if(65359!==(0,i.readUint16)(e,0))for(var t=0,r=e.length;t<r;){var n=8,s=(0,i.readUint32)(e,t),o=(0,i.readUint32)(e,t+4);t+=n;if(1===s){s=4294967296*(0,i.readUint32)(e,t)+(0,i.readUint32)(e,t+4);t+=8;n+=8}0===s&&(s=r-t+n);if(s<n)throw new JpxError("Invalid box field size");var c=s-n,l=!0;switch(o){case 1785737832:l=!1;break;case 1668246642:var h=e[t];if(1===h){var u=(0,i.readUint32)(e,t+3);switch(u){case 16:case 17:case 18:break;default:(0,a.warn)("Unknown colorspace "+u)}}else 2===h&&(0,a.info)("ICC profile not supported");break;case 1785737827:this.parseCodestream(e,t,t+c);break;case 1783636e3:218793738!==(0,i.readUint32)(e,t)&&(0,a.warn)("Invalid JP2 signature");break;case 1783634458:case 1718909296:case 1920099697:case 1919251232:case 1768449138:break;default:var d=String.fromCharCode(o>>24&255,o>>16&255,o>>8&255,255&o);(0,a.warn)("Unsupported header type "+o+" ("+d+")")}l&&(t+=c)}else this.parseCodestream(e,0,e.length)},parseImageProperties:function JpxImage_parseImageProperties(e){for(var t=e.getByte();t>=0;){if(65361===(t<<8|(t=e.getByte()))){e.skip(4);var r=e.getInt32()>>>0,a=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0;e.skip(16);var s=e.getUint16();this.width=r-i;this.height=a-n;this.componentsCount=s;this.bitsPerComponent=8;return}}throw new JpxError("No size marker found in JPX stream")},parseCodestream:function JpxImage_parseCodestream(e,t,r){var n={},s=!1;try{for(var o=t;o+1<r;){var c=(0,i.readUint16)(e,o);o+=2;var l,h,u,d,f,g,p=0;switch(c){case 65359:n.mainHeader=!0;break;case 65497:break;case 65361:p=(0,i.readUint16)(e,o);var m={};m.Xsiz=(0,i.readUint32)(e,o+4);m.Ysiz=(0,i.readUint32)(e,o+8);m.XOsiz=(0,i.readUint32)(e,o+12);m.YOsiz=(0,i.readUint32)(e,o+16);m.XTsiz=(0,i.readUint32)(e,o+20);m.YTsiz=(0,i.readUint32)(e,o+24);m.XTOsiz=(0,i.readUint32)(e,o+28);m.YTOsiz=(0,i.readUint32)(e,o+32);var b=(0,i.readUint16)(e,o+36);m.Csiz=b;var y=[];l=o+38;for(var w=0;w<b;w++){var S={precision:1+(127&e[l]),isSigned:!!(128&e[l]),XRsiz:e[l+1],YRsiz:e[l+2]};l+=3;calculateComponentDimensions(S,m);y.push(S)}n.SIZ=m;n.components=y;calculateTileGrids(n,y);n.QCC=[];n.COC=[];break;case 65372:p=(0,i.readUint16)(e,o);var v={};l=o+2;switch(31&(h=e[l++])){case 0:d=8;f=!0;break;case 1:d=16;f=!1;break;case 2:d=16;f=!0;break;default:throw new Error("Invalid SQcd value "+h)}v.noQuantization=8===d;v.scalarExpounded=f;v.guardBits=h>>5;u=[];for(;l<p+o;){var k={};if(8===d){k.epsilon=e[l++]>>3;k.mu=0}else{k.epsilon=e[l]>>3;k.mu=(7&e[l])<<8|e[l+1];l+=2}u.push(k)}v.SPqcds=u;if(n.mainHeader)n.QCD=v;else{n.currentTile.QCD=v;n.currentTile.QCC=[]}break;case 65373:p=(0,i.readUint16)(e,o);var x,C={};l=o+2;if(n.SIZ.Csiz<257)x=e[l++];else{x=(0,i.readUint16)(e,l);l+=2}switch(31&(h=e[l++])){case 0:d=8;f=!0;break;case 1:d=16;f=!1;break;case 2:d=16;f=!0;break;default:throw new Error("Invalid SQcd value "+h)}C.noQuantization=8===d;C.scalarExpounded=f;C.guardBits=h>>5;u=[];for(;l<p+o;){k={};if(8===d){k.epsilon=e[l++]>>3;k.mu=0}else{k.epsilon=e[l]>>3;k.mu=(7&e[l])<<8|e[l+1];l+=2}u.push(k)}C.SPqcds=u;n.mainHeader?n.QCC[x]=C:n.currentTile.QCC[x]=C;break;case 65362:p=(0,i.readUint16)(e,o);var O={};l=o+2;var F=e[l++];O.entropyCoderWithCustomPrecincts=!!(1&F);O.sopMarkerUsed=!!(2&F);O.ephMarkerUsed=!!(4&F);O.progressionOrder=e[l++];O.layersCount=(0,i.readUint16)(e,l);l+=2;O.multipleComponentTransform=e[l++];O.decompositionLevelsCount=e[l++];O.xcb=2+(15&e[l++]);O.ycb=2+(15&e[l++]);var T=e[l++];O.selectiveArithmeticCodingBypass=!!(1&T);O.resetContextProbabilities=!!(2&T);O.terminationOnEachCodingPass=!!(4&T);O.verticallyStripe=!!(8&T);O.predictableTermination=!!(16&T);O.segmentationSymbolUsed=!!(32&T);O.reversibleTransformation=e[l++];if(O.entropyCoderWithCustomPrecincts){for(var E=[];l<p+o;){var M=e[l++];E.push({PPx:15&M,PPy:M>>4})}O.precinctsSizes=E}var D=[];O.selectiveArithmeticCodingBypass&&D.push("selectiveArithmeticCodingBypass");O.resetContextProbabilities&&D.push("resetContextProbabilities");O.terminationOnEachCodingPass&&D.push("terminationOnEachCodingPass");O.verticallyStripe&&D.push("verticallyStripe");O.predictableTermination&&D.push("predictableTermination");if(D.length>0){s=!0;(0,a.warn)(`JPX: Unsupported COD options (${D.join(", ")}).`)}if(n.mainHeader)n.COD=O;else{n.currentTile.COD=O;n.currentTile.COC=[]}break;case 65424:p=(0,i.readUint16)(e,o);(g={}).index=(0,i.readUint16)(e,o+2);g.length=(0,i.readUint32)(e,o+4);g.dataEnd=g.length+o-2;g.partIndex=e[o+8];g.partsCount=e[o+9];n.mainHeader=!1;if(0===g.partIndex){g.COD=n.COD;g.COC=n.COC.slice(0);g.QCD=n.QCD;g.QCC=n.QCC.slice(0)}n.currentTile=g;break;case 65427:if(0===(g=n.currentTile).partIndex){initializeTile(n,g.index);buildPackets(n)}parseTilePackets(n,e,o,p=g.dataEnd-o);break;case 65363:(0,a.warn)("JPX: Codestream code 0xFF53 (COC) is not implemented.");case 65365:case 65367:case 65368:case 65380:p=(0,i.readUint16)(e,o);break;default:throw new Error("Unknown codestream code: "+c.toString(16))}o+=p}}catch(e){if(s||this.failOnCorruptedImage)throw new JpxError(e.message);(0,a.warn)(`JPX: Trying to recover from: "${e.message}".`)}this.tiles=function transformComponents(e){for(var t=e.SIZ,r=e.components,a=t.Csiz,i=[],n=0,s=e.tiles.length;n<s;n++){var o,c=e.tiles[n],l=[];for(o=0;o<a;o++)l[o]=transformTile(e,c,o);var h,u,d,f,g,p,m,b=l[0],y=new Uint8ClampedArray(b.items.length*a),w={left:b.left,top:b.top,width:b.width,height:b.height,items:y},S=0;if(c.codingStyleDefaultParameters.multipleComponentTransform){var v=4===a,k=l[0].items,x=l[1].items,C=l[2].items,O=v?l[3].items:null;u=.5+(128<<(h=r[0].precision-8));var F=c.components[0],T=a-3;f=k.length;if(F.codingStyleParameters.reversibleTransformation)for(d=0;d<f;d++,S+=T){g=k[d]+u;p=x[d];const e=g-((m=C[d])+p>>2);y[S++]=e+m>>h;y[S++]=e>>h;y[S++]=e+p>>h}else for(d=0;d<f;d++,S+=T){g=k[d]+u;p=x[d];m=C[d];y[S++]=g+1.402*m>>h;y[S++]=g-.34413*p-.71414*m>>h;y[S++]=g+1.772*p>>h}if(v)for(d=0,S=3;d<f;d++,S+=4)y[S]=O[d]+u>>h}else for(o=0;o<a;o++){var E=l[o].items;u=.5+(128<<(h=r[o].precision-8));for(S=o,d=0,f=E.length;d<f;d++){y[S]=E[d]+u>>h;S+=a}}i.push(w)}return i}(n);this.width=n.SIZ.Xsiz-n.SIZ.XOsiz;this.height=n.SIZ.Ysiz-n.SIZ.YOsiz;this.componentsCount=n.SIZ.Csiz}};function calculateComponentDimensions(e,t){e.x0=Math.ceil(t.XOsiz/e.XRsiz);e.x1=Math.ceil(t.Xsiz/e.XRsiz);e.y0=Math.ceil(t.YOsiz/e.YRsiz);e.y1=Math.ceil(t.Ysiz/e.YRsiz);e.width=e.x1-e.x0;e.height=e.y1-e.y0}function calculateTileGrids(e,t){for(var r,a=e.SIZ,i=[],n=Math.ceil((a.Xsiz-a.XTOsiz)/a.XTsiz),s=Math.ceil((a.Ysiz-a.YTOsiz)/a.YTsiz),o=0;o<s;o++)for(var c=0;c<n;c++){(r={}).tx0=Math.max(a.XTOsiz+c*a.XTsiz,a.XOsiz);r.ty0=Math.max(a.YTOsiz+o*a.YTsiz,a.YOsiz);r.tx1=Math.min(a.XTOsiz+(c+1)*a.XTsiz,a.Xsiz);r.ty1=Math.min(a.YTOsiz+(o+1)*a.YTsiz,a.Ysiz);r.width=r.tx1-r.tx0;r.height=r.ty1-r.ty0;r.components=[];i.push(r)}e.tiles=i;for(var l=0,h=a.Csiz;l<h;l++)for(var u=t[l],d=0,f=i.length;d<f;d++){var g={};r=i[d];g.tcx0=Math.ceil(r.tx0/u.XRsiz);g.tcy0=Math.ceil(r.ty0/u.YRsiz);g.tcx1=Math.ceil(r.tx1/u.XRsiz);g.tcy1=Math.ceil(r.ty1/u.YRsiz);g.width=g.tcx1-g.tcx0;g.height=g.tcy1-g.tcy0;r.components[l]=g}}function getBlocksDimensions(e,t,r){var a=t.codingStyleParameters,i={};if(a.entropyCoderWithCustomPrecincts){i.PPx=a.precinctsSizes[r].PPx;i.PPy=a.precinctsSizes[r].PPy}else{i.PPx=15;i.PPy=15}i.xcb_=r>0?Math.min(a.xcb,i.PPx-1):Math.min(a.xcb,i.PPx);i.ycb_=r>0?Math.min(a.ycb,i.PPy-1):Math.min(a.ycb,i.PPy);return i}function buildPrecincts(e,t,r){var a=1<<r.PPx,i=1<<r.PPy,n=0===t.resLevel,s=1<<r.PPx+(n?0:-1),o=1<<r.PPy+(n?0:-1),c=t.trx1>t.trx0?Math.ceil(t.trx1/a)-Math.floor(t.trx0/a):0,l=t.try1>t.try0?Math.ceil(t.try1/i)-Math.floor(t.try0/i):0,h=c*l;t.precinctParameters={precinctWidth:a,precinctHeight:i,numprecinctswide:c,numprecinctshigh:l,numprecincts:h,precinctWidthInSubband:s,precinctHeightInSubband:o}}function buildCodeblocks(e,t,r){var a,i,n,s,o=r.xcb_,c=r.ycb_,l=1<<o,h=1<<c,u=t.tbx0>>o,d=t.tby0>>c,f=t.tbx1+l-1>>o,g=t.tby1+h-1>>c,p=t.resolution.precinctParameters,m=[],b=[];for(i=d;i<g;i++)for(a=u;a<f;a++){(n={cbx:a,cby:i,tbx0:l*a,tby0:h*i,tbx1:l*(a+1),tby1:h*(i+1)}).tbx0_=Math.max(t.tbx0,n.tbx0);n.tby0_=Math.max(t.tby0,n.tby0);n.tbx1_=Math.min(t.tbx1,n.tbx1);n.tby1_=Math.min(t.tby1,n.tby1);s=Math.floor((n.tbx0_-t.tbx0)/p.precinctWidthInSubband)+Math.floor((n.tby0_-t.tby0)/p.precinctHeightInSubband)*p.numprecinctswide;n.precinctNumber=s;n.subbandType=t.type;n.Lblock=3;if(!(n.tbx1_<=n.tbx0_||n.tby1_<=n.tby0_)){m.push(n);var y=b[s];if(void 0!==y){a<y.cbxMin?y.cbxMin=a:a>y.cbxMax&&(y.cbxMax=a);i<y.cbyMin?y.cbxMin=i:i>y.cbyMax&&(y.cbyMax=i)}else b[s]=y={cbxMin:a,cbyMin:i,cbxMax:a,cbyMax:i};n.precinct=y}}t.codeblockParameters={codeblockWidth:o,codeblockHeight:c,numcodeblockwide:f-u+1,numcodeblockhigh:g-d+1};t.codeblocks=m;t.precincts=b}function createPacket(e,t,r){for(var a=[],i=e.subbands,n=0,s=i.length;n<s;n++)for(var o=i[n].codeblocks,c=0,l=o.length;c<l;c++){var h=o[c];h.precinctNumber===t&&a.push(h)}return{layerNumber:r,codeblocks:a}}function LayerResolutionComponentPositionIterator(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,s=0,o=0;o<n;o++)s=Math.max(s,a.components[o].codingStyleParameters.decompositionLevelsCount);var c=0,l=0,h=0,u=0;this.nextPacket=function JpxImage_nextPacket(){for(;c<i;c++){for(;l<=s;l++){for(;h<n;h++){var e=a.components[h];if(!(l>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[l],r=t.precinctParameters.numprecincts;u<r;){var o=createPacket(t,u,c);u++;return o}u=0}}h=0}l=0}throw new JpxError("Out of packets")}}function ResolutionLayerComponentPositionIterator(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,s=0,o=0;o<n;o++)s=Math.max(s,a.components[o].codingStyleParameters.decompositionLevelsCount);var c=0,l=0,h=0,u=0;this.nextPacket=function JpxImage_nextPacket(){for(;c<=s;c++){for(;l<i;l++){for(;h<n;h++){var e=a.components[h];if(!(c>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[c],r=t.precinctParameters.numprecincts;u<r;){var o=createPacket(t,u,l);u++;return o}u=0}}h=0}l=0}throw new JpxError("Out of packets")}}function ResolutionPositionComponentLayerIterator(e){var t,r,a,i,n=e.SIZ,s=e.currentTile.index,o=e.tiles[s],c=o.codingStyleDefaultParameters.layersCount,l=n.Csiz,h=0;for(a=0;a<l;a++){const e=o.components[a];h=Math.max(h,e.codingStyleParameters.decompositionLevelsCount)}var u=new Int32Array(h+1);for(r=0;r<=h;++r){var d=0;for(a=0;a<l;++a){var f=o.components[a].resolutions;r<f.length&&(d=Math.max(d,f[r].precinctParameters.numprecincts))}u[r]=d}t=0;r=0;a=0;i=0;this.nextPacket=function JpxImage_nextPacket(){for(;r<=h;r++){for(;i<u[r];i++){for(;a<l;a++){const l=o.components[a];if(!(r>l.codingStyleParameters.decompositionLevelsCount)){var e=l.resolutions[r],n=e.precinctParameters.numprecincts;if(!(i>=n)){for(;t<c;){var s=createPacket(e,i,t);t++;return s}t=0}}}a=0}i=0}throw new JpxError("Out of packets")}}function PositionComponentResolutionLayerIterator(e){var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,s=getPrecinctSizesInImageScale(a),o=s,c=0,l=0,h=0,u=0,d=0;this.nextPacket=function JpxImage_nextPacket(){for(;d<o.maxNumHigh;d++){for(;u<o.maxNumWide;u++){for(;h<n;h++){for(var e=a.components[h],t=e.codingStyleParameters.decompositionLevelsCount;l<=t;l++){var r=e.resolutions[l],f=s.components[h].resolutions[l],g=getPrecinctIndexIfExist(u,d,f,o,r);if(null!==g){for(;c<i;){var p=createPacket(r,g,c);c++;return p}c=0}}l=0}h=0}u=0}throw new JpxError("Out of packets")}}function ComponentPositionResolutionLayerIterator(e){var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=a.codingStyleDefaultParameters.layersCount,n=t.Csiz,s=getPrecinctSizesInImageScale(a),o=0,c=0,l=0,h=0,u=0;this.nextPacket=function JpxImage_nextPacket(){for(;l<n;++l){for(var e=a.components[l],t=s.components[l],r=e.codingStyleParameters.decompositionLevelsCount;u<t.maxNumHigh;u++){for(;h<t.maxNumWide;h++){for(;c<=r;c++){var d=e.resolutions[c],f=t.resolutions[c],g=getPrecinctIndexIfExist(h,u,f,t,d);if(null!==g){for(;o<i;){var p=createPacket(d,g,o);o++;return p}o=0}}c=0}h=0}u=0}throw new JpxError("Out of packets")}}function getPrecinctIndexIfExist(e,t,r,a,i){var n=e*a.minWidth,s=t*a.minHeight;if(n%r.width!=0||s%r.height!=0)return null;var o=s/r.width*i.precinctParameters.numprecinctswide;return n/r.height+o}function getPrecinctSizesInImageScale(e){for(var t=e.components.length,r=Number.MAX_VALUE,a=Number.MAX_VALUE,i=0,n=0,s=new Array(t),o=0;o<t;o++){for(var c=e.components[o],l=c.codingStyleParameters.decompositionLevelsCount,h=new Array(l+1),u=Number.MAX_VALUE,d=Number.MAX_VALUE,f=0,g=0,p=1,m=l;m>=0;--m){var b=c.resolutions[m],y=p*b.precinctParameters.precinctWidth,w=p*b.precinctParameters.precinctHeight;u=Math.min(u,y);d=Math.min(d,w);f=Math.max(f,b.precinctParameters.numprecinctswide);g=Math.max(g,b.precinctParameters.numprecinctshigh);h[m]={width:y,height:w};p<<=1}r=Math.min(r,u);a=Math.min(a,d);i=Math.max(i,f);n=Math.max(n,g);s[o]={resolutions:h,minWidth:u,minHeight:d,maxNumWide:f,maxNumHigh:g}}return{components:s,minWidth:r,minHeight:a,maxNumWide:i,maxNumHigh:n}}function buildPackets(e){for(var t=e.SIZ,r=e.currentTile.index,a=e.tiles[r],i=t.Csiz,n=0;n<i;n++){for(var s=a.components[n],o=s.codingStyleParameters.decompositionLevelsCount,c=[],l=[],h=0;h<=o;h++){var u,d=getBlocksDimensions(0,s,h),f={},g=1<<o-h;f.trx0=Math.ceil(s.tcx0/g);f.try0=Math.ceil(s.tcy0/g);f.trx1=Math.ceil(s.tcx1/g);f.try1=Math.ceil(s.tcy1/g);f.resLevel=h;buildPrecincts(0,f,d);c.push(f);if(0===h){(u={}).type="LL";u.tbx0=Math.ceil(s.tcx0/g);u.tby0=Math.ceil(s.tcy0/g);u.tbx1=Math.ceil(s.tcx1/g);u.tby1=Math.ceil(s.tcy1/g);u.resolution=f;buildCodeblocks(0,u,d);l.push(u);f.subbands=[u]}else{var p=1<<o-h+1,m=[];(u={}).type="HL";u.tbx0=Math.ceil(s.tcx0/p-.5);u.tby0=Math.ceil(s.tcy0/p);u.tbx1=Math.ceil(s.tcx1/p-.5);u.tby1=Math.ceil(s.tcy1/p);u.resolution=f;buildCodeblocks(0,u,d);l.push(u);m.push(u);(u={}).type="LH";u.tbx0=Math.ceil(s.tcx0/p);u.tby0=Math.ceil(s.tcy0/p-.5);u.tbx1=Math.ceil(s.tcx1/p);u.tby1=Math.ceil(s.tcy1/p-.5);u.resolution=f;buildCodeblocks(0,u,d);l.push(u);m.push(u);(u={}).type="HH";u.tbx0=Math.ceil(s.tcx0/p-.5);u.tby0=Math.ceil(s.tcy0/p-.5);u.tbx1=Math.ceil(s.tcx1/p-.5);u.tby1=Math.ceil(s.tcy1/p-.5);u.resolution=f;buildCodeblocks(0,u,d);l.push(u);m.push(u);f.subbands=m}}s.resolutions=c;s.subbands=l}var b=a.codingStyleDefaultParameters.progressionOrder;switch(b){case 0:a.packetsIterator=new LayerResolutionComponentPositionIterator(e);break;case 1:a.packetsIterator=new ResolutionLayerComponentPositionIterator(e);break;case 2:a.packetsIterator=new ResolutionPositionComponentLayerIterator(e);break;case 3:a.packetsIterator=new PositionComponentResolutionLayerIterator(e);break;case 4:a.packetsIterator=new ComponentPositionResolutionLayerIterator(e);break;default:throw new JpxError(`Unsupported progression order ${b}`)}}function parseTilePackets(e,a,n,s){var o,c=0,l=0,h=!1;function readBits(e){for(;l<e;){var t=a[n+c];c++;if(h){o=o<<7|t;l+=7;h=!1}else{o=o<<8|t;l+=8}255===t&&(h=!0)}return o>>>(l-=e)&(1<<e)-1}function skipMarkerIfEqual(e){if(255===a[n+c-1]&&a[n+c]===e){skipBytes(1);return!0}if(255===a[n+c]&&a[n+c+1]===e){skipBytes(2);return!0}return!1}function skipBytes(e){c+=e}function alignToByte(){l=0;if(h){c++;h=!1}}function readCodingpasses(){if(0===readBits(1))return 1;if(0===readBits(1))return 2;var e=readBits(2);return e<3?e+3:(e=readBits(5))<31?e+6:(e=readBits(7))+37}for(var u=e.currentTile.index,d=e.tiles[u],f=e.COD.sopMarkerUsed,g=e.COD.ephMarkerUsed,p=d.packetsIterator;c<s;){alignToByte();f&&skipMarkerIfEqual(145)&&skipBytes(4);var m=p.nextPacket();if(readBits(1)){for(var b,y=m.layerNumber,w=[],S=0,v=m.codeblocks.length;S<v;S++){var k=(b=m.codeblocks[S]).precinct,x=b.cbx-k.cbxMin,C=b.cby-k.cbyMin,O=!1,F=!1;if(void 0!==b.included)O=!!readBits(1);else{var T,E;if(void 0!==(k=b.precinct).inclusionTree)T=k.inclusionTree;else{var M=k.cbxMax-k.cbxMin+1,D=k.cbyMax-k.cbyMin+1;T=new r(M,D,y);E=new t(M,D);k.inclusionTree=T;k.zeroBitPlanesTree=E}if(T.reset(x,C,y))for(;;){if(!readBits(1)){T.incrementValue(y);break}if(!T.nextLevel()){b.included=!0;O=F=!0;break}}}if(O){if(F){(E=k.zeroBitPlanesTree).reset(x,C);for(;;)if(readBits(1)){if(!E.nextLevel())break}else E.incrementValue();b.zeroBitPlanes=E.value}for(var N=readCodingpasses();readBits(1);)b.Lblock++;var R=(0,i.log2)(N),j=readBits((N<1<<R?R-1:R)+b.Lblock);w.push({codeblock:b,codingpasses:N,dataLength:j})}}alignToByte();g&&skipMarkerIfEqual(146);for(;w.length>0;){var L=w.shift();void 0===(b=L.codeblock).data&&(b.data=[]);b.data.push({data:a,start:n+c,end:n+c+L.dataLength,codingpasses:L.codingpasses});c+=L.dataLength}}}return c}function copyCoefficients(e,t,r,a,i,o,c,l){for(var h=a.tbx0,u=a.tby0,d=a.tbx1-a.tbx0,f=a.codeblocks,g="H"===a.type.charAt(0)?1:0,p="H"===a.type.charAt(1)?t:0,m=0,b=f.length;m<b;++m){var y=f[m],w=y.tbx1_-y.tbx0_,S=y.tby1_-y.tby0_;if(0!==w&&0!==S&&void 0!==y.data){var v,k;v=new s(w,S,y.subbandType,y.zeroBitPlanes,o);k=2;var x,C,O,F=y.data,T=0,E=0;for(x=0,C=F.length;x<C;x++){T+=(O=F[x]).end-O.start;E+=O.codingpasses}var M=new Uint8Array(T),D=0;for(x=0,C=F.length;x<C;x++){var N=(O=F[x]).data.subarray(O.start,O.end);M.set(N,D);D+=N.length}var R=new n.ArithmeticDecoder(M,0,T);v.setDecoder(R);for(x=0;x<E;x++){switch(k){case 0:v.runSignificancePropagationPass();break;case 1:v.runMagnitudeRefinementPass();break;case 2:v.runCleanupPass();l&&v.checkSegmentationSymbol()}k=(k+1)%3}var j,L,_,U=y.tbx0_-h+(y.tby0_-u)*d,X=v.coefficentsSign,q=v.coefficentsMagnitude,$=v.bitsDecoded,H=c?0:.5;D=0;var z="LL"!==a.type;for(x=0;x<S;x++){var G=2*(U/d|0)*(t-d)+g+p;for(j=0;j<w;j++){if(0!==(L=q[D])){L=(L+H)*i;0!==X[D]&&(L=-L);_=$[D];var W=z?G+(U<<1):U;e[W]=c&&_>=o?L:L*(1<<o-_)}U++;D++}U+=d-w}}}}function transformTile(t,r,a){for(var i=r.components[a],n=i.codingStyleParameters,s=i.quantizationParameters,o=n.decompositionLevelsCount,h=s.SPqcds,u=s.scalarExpounded,d=s.guardBits,f=n.segmentationSymbolUsed,g=t.components[a].precision,p=n.reversibleTransformation,m=p?new l:new c,b=[],y=0,w=0;w<=o;w++){for(var S=i.resolutions[w],v=S.trx1-S.trx0,k=S.try1-S.try0,x=new Float32Array(v*k),C=0,O=S.subbands.length;C<O;C++){var F,T;if(u){F=h[y].mu;T=h[y].epsilon;y++}else{F=h[0].mu;T=h[0].epsilon+(w>0?1-w:0)}var E=S.subbands[C],M=e[E.type];copyCoefficients(x,v,0,E,p?1:2**(g+M-T)*(1+F/2048),d+T-1,p,f)}b.push({width:v,height:k,items:x})}var D=m.calculate(b,i.tcx0,i.tcy0);return{left:i.tcx0,top:i.tcy0,width:D.width,height:D.height,items:D.items}}function initializeTile(e,t){for(var r=e.SIZ.Csiz,a=e.tiles[t],i=0;i<r;i++){var n=a.components[i],s=void 0!==e.currentTile.QCC[i]?e.currentTile.QCC[i]:e.currentTile.QCD;n.quantizationParameters=s;var o=void 0!==e.currentTile.COC[i]?e.currentTile.COC[i]:e.currentTile.COD;n.codingStyleParameters=o}a.codingStyleDefaultParameters=e.currentTile.COD}var t=function TagTreeClosure(){function TagTree(e,t){var r=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var a=0;a<r;a++){var n={width:e,height:t,items:[]};this.levels.push(n);e=Math.ceil(e/2);t=Math.ceil(t/2)}}TagTree.prototype={reset:function TagTree_reset(e,t){for(var r,a=0,i=0;a<this.levels.length;){var n=e+t*(r=this.levels[a]).width;if(void 0!==r.items[n]){i=r.items[n];break}r.index=n;e>>=1;t>>=1;a++}a--;(r=this.levels[a]).items[r.index]=i;this.currentLevel=a;delete this.value},incrementValue:function TagTree_incrementValue(){var e=this.levels[this.currentLevel];e.items[e.index]++},nextLevel:function TagTree_nextLevel(){var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];if(--e<0){this.value=r;return!1}this.currentLevel=e;(t=this.levels[e]).items[t.index]=r;return!0}};return TagTree}(),r=function InclusionTreeClosure(){function InclusionTree(e,t,r){var a=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var n=0;n<a;n++){for(var s=new Uint8Array(e*t),o=0,c=s.length;o<c;o++)s[o]=r;var l={width:e,height:t,items:s};this.levels.push(l);e=Math.ceil(e/2);t=Math.ceil(t/2)}}InclusionTree.prototype={reset:function InclusionTree_reset(e,t,r){for(var a=0;a<this.levels.length;){var i=this.levels[a],n=e+t*i.width;i.index=n;var s=i.items[n];if(255===s)break;if(s>r){this.currentLevel=a;this.propagateValues();return!1}e>>=1;t>>=1;a++}this.currentLevel=a-1;return!0},incrementValue:function InclusionTree_incrementValue(e){var t=this.levels[this.currentLevel];t.items[t.index]=e+1;this.propagateValues()},propagateValues:function InclusionTree_propagateValues(){for(var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];--e>=0;)(t=this.levels[e]).items[t.index]=r},nextLevel:function InclusionTree_nextLevel(){var e=this.currentLevel,t=this.levels[e],r=t.items[t.index];t.items[t.index]=255;if(--e<0)return!1;this.currentLevel=e;(t=this.levels[e]).items[t.index]=r;return!0}};return InclusionTree}(),s=function BitModelClosure(){var e=17,t=new Uint8Array([0,5,8,0,3,7,8,0,4,7,8,0,0,0,0,0,1,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8]),r=new Uint8Array([0,3,4,0,5,7,7,0,8,8,8,0,0,0,0,0,1,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8]),a=new Uint8Array([0,1,2,0,1,2,2,0,2,2,2,0,0,0,0,0,3,4,5,0,4,5,5,0,5,5,5,0,0,0,0,0,6,7,7,0,7,7,7,0,7,7,7,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8]);function BitModel(e,i,n,s,o){this.width=e;this.height=i;let c;c="HH"===n?a:"HL"===n?r:t;this.contextLabelTable=c;var l=e*i;this.neighborsSignificance=new Uint8Array(l);this.coefficentsSign=new Uint8Array(l);let h;h=o>14?new Uint32Array(l):o>6?new Uint16Array(l):new Uint8Array(l);this.coefficentsMagnitude=h;this.processingFlags=new Uint8Array(l);var u=new Uint8Array(l);if(0!==s)for(var d=0;d<l;d++)u[d]=s;this.bitsDecoded=u;this.reset()}BitModel.prototype={setDecoder:function BitModel_setDecoder(e){this.decoder=e},reset:function BitModel_reset(){this.contexts=new Int8Array(19);this.contexts[0]=8;this.contexts[17]=92;this.contexts[18]=6},setNeighborsSignificance:function BitModel_setNeighborsSignificance(e,t,r){var a,i=this.neighborsSignificance,n=this.width,s=this.height,o=t>0,c=t+1<n;if(e>0){a=r-n;o&&(i[a-1]+=16);c&&(i[a+1]+=16);i[a]+=4}if(e+1<s){a=r+n;o&&(i[a-1]+=16);c&&(i[a+1]+=16);i[a]+=4}o&&(i[r-1]+=1);c&&(i[r+1]+=1);i[r]|=128},runSignificancePropagationPass:function BitModel_runSignificancePropagationPass(){for(var e=this.decoder,t=this.width,r=this.height,a=this.coefficentsMagnitude,i=this.coefficentsSign,n=this.neighborsSignificance,s=this.processingFlags,o=this.contexts,c=this.contextLabelTable,l=this.bitsDecoded,h=0;h<r;h+=4)for(var u=0;u<t;u++)for(var d=h*t+u,f=0;f<4;f++,d+=t){var g=h+f;if(g>=r)break;s[d]&=-2;if(!a[d]&&n[d]){var p=c[n[d]];if(e.readBit(o,p)){var m=this.decodeSignBit(g,u,d);i[d]=m;a[d]=1;this.setNeighborsSignificance(g,u,d);s[d]|=2}l[d]++;s[d]|=1}}},decodeSignBit:function BitModel_decodeSignBit(e,t,r){var a,i,n,s,o,c,l=this.width,h=this.height,u=this.coefficentsMagnitude,d=this.coefficentsSign;s=t>0&&0!==u[r-1];if(t+1<l&&0!==u[r+1]){n=d[r+1];a=s?1-n-(i=d[r-1]):1-n-n}else a=s?1-(i=d[r-1])-i:0;var f=3*a;s=e>0&&0!==u[r-l];if(e+1<h&&0!==u[r+l]){n=d[r+l];a=s?1-n-(i=d[r-l])+f:1-n-n+f}else a=s?1-(i=d[r-l])-i+f:f;if(a>=0){o=9+a;c=this.decoder.readBit(this.contexts,o)}else{o=9-a;c=1^this.decoder.readBit(this.contexts,o)}return c},runMagnitudeRefinementPass:function BitModel_runMagnitudeRefinementPass(){for(var e,t=this.decoder,r=this.width,a=this.height,i=this.coefficentsMagnitude,n=this.neighborsSignificance,s=this.contexts,o=this.bitsDecoded,c=this.processingFlags,l=r*a,h=4*r,u=0;u<l;u=e){e=Math.min(l,u+h);for(var d=0;d<r;d++)for(var f=u+d;f<e;f+=r)if(i[f]&&0==(1&c[f])){var g=16;if(0!=(2&c[f])){c[f]^=2;g=0===(127&n[f])?15:14}var p=t.readBit(s,g);i[f]=i[f]<<1|p;o[f]++;c[f]|=1}}},runCleanupPass:function BitModel_runCleanupPass(){for(var t,r=this.decoder,a=this.width,i=this.height,n=this.neighborsSignificance,s=this.coefficentsMagnitude,o=this.coefficentsSign,c=this.contexts,l=this.contextLabelTable,h=this.bitsDecoded,u=this.processingFlags,d=a,f=2*a,g=3*a,p=0;p<i;p=t){t=Math.min(p+4,i);for(var m=p*a,b=p+3<i,y=0;y<a;y++){var w,S=m+y,v=0,k=S,x=p;if(b&&0===u[S]&&0===u[S+d]&&0===u[S+f]&&0===u[S+g]&&0===n[S]&&0===n[S+d]&&0===n[S+f]&&0===n[S+g]){if(!r.readBit(c,18)){h[S]++;h[S+d]++;h[S+f]++;h[S+g]++;continue}if(0!==(v=r.readBit(c,e)<<1|r.readBit(c,e))){x=p+v;k+=v*a}w=this.decodeSignBit(x,y,k);o[k]=w;s[k]=1;this.setNeighborsSignificance(x,y,k);u[k]|=2;k=S;for(var C=p;C<=x;C++,k+=a)h[k]++;v++}for(x=p+v;x<t;x++,k+=a)if(!s[k]&&0==(1&u[k])){var O=l[n[k]];if(1===r.readBit(c,O)){w=this.decodeSignBit(x,y,k);o[k]=w;s[k]=1;this.setNeighborsSignificance(x,y,k);u[k]|=2}h[k]++}}}},checkSegmentationSymbol:function BitModel_checkSegmentationSymbol(){var t=this.decoder,r=this.contexts;if(10!==(t.readBit(r,e)<<3|t.readBit(r,e)<<2|t.readBit(r,e)<<1|t.readBit(r,e)))throw new JpxError("Invalid segmentation symbol")}};return BitModel}(),o=function TransformClosure(){function Transform(){}Transform.prototype.calculate=function transformCalculate(e,t,r){for(var a=e[0],i=1,n=e.length;i<n;i++)a=this.iterate(a,e[i],t,r);return a};Transform.prototype.extend=function extend(e,t,r){var a=t-1,i=t+1,n=t+r-2,s=t+r;e[a--]=e[i++];e[s++]=e[n--];e[a--]=e[i++];e[s++]=e[n--];e[a--]=e[i++];e[s++]=e[n--];e[a]=e[i];e[s]=e[n]};Transform.prototype.iterate=function Transform_iterate(e,t,r,a){var i,n,s,o,c,l,h=e.width,u=e.height,d=e.items,f=t.width,g=t.height,p=t.items;for(s=0,i=0;i<u;i++){o=2*i*f;for(n=0;n<h;n++,s++,o+=2)p[o]=d[s]}d=e.items=null;var m=new Float32Array(f+8);if(1===f){if(0!=(1&r))for(l=0,s=0;l<g;l++,s+=f)p[s]*=.5}else for(l=0,s=0;l<g;l++,s+=f){m.set(p.subarray(s,s+f),4);this.extend(m,4,f);this.filter(m,4,f);p.set(m.subarray(4,4+f),s)}var b=16,y=[];for(i=0;i<b;i++)y.push(new Float32Array(g+8));var w,S=0;e=4+g;if(1===g){if(0!=(1&a))for(c=0;c<f;c++)p[c]*=.5}else for(c=0;c<f;c++){if(0===S){b=Math.min(f-c,b);for(s=c,o=4;o<e;s+=f,o++)for(w=0;w<b;w++)y[w][o]=p[s+w];S=b}var v=y[--S];this.extend(v,4,g);this.filter(v,4,g);if(0===S){s=c-b+1;for(o=4;o<e;s+=f,o++)for(w=0;w<b;w++)p[s+w]=y[w][o]}}return{width:f,height:g,items:p}};return Transform}(),c=function IrreversibleTransformClosure(){function IrreversibleTransform(){o.call(this)}IrreversibleTransform.prototype=Object.create(o.prototype);IrreversibleTransform.prototype.filter=function irreversibleTransformFilter(e,t,r){var a,i,n,s,o=r>>1,c=-1.586134342059924,l=-.052980118572961,h=.882911075530934,u=.443506852043971,d=1.230174104914001;a=(t|=0)-3;for(i=o+4;i--;a+=2)e[a]*=.8128930661159609;n=u*e[(a=t-2)-1];for(i=o+3;i--;a+=2){s=u*e[a+1];e[a]=d*e[a]-n-s;if(!i--)break;n=u*e[(a+=2)+1];e[a]=d*e[a]-n-s}n=h*e[(a=t-1)-1];for(i=o+2;i--;a+=2){s=h*e[a+1];e[a]-=n+s;if(!i--)break;n=h*e[(a+=2)+1];e[a]-=n+s}n=l*e[(a=t)-1];for(i=o+1;i--;a+=2){s=l*e[a+1];e[a]-=n+s;if(!i--)break;n=l*e[(a+=2)+1];e[a]-=n+s}if(0!==o){n=c*e[(a=t+1)-1];for(i=o;i--;a+=2){s=c*e[a+1];e[a]-=n+s;if(!i--)break;n=c*e[(a+=2)+1];e[a]-=n+s}}};return IrreversibleTransform}(),l=function ReversibleTransformClosure(){function ReversibleTransform(){o.call(this)}ReversibleTransform.prototype=Object.create(o.prototype);ReversibleTransform.prototype.filter=function reversibleTransformFilter(e,t,r){var a,i,n=r>>1;for(a=t|=0,i=n+1;i--;a+=2)e[a]-=e[a-1]+e[a+1]+2>>2;for(a=t+1,i=n;i--;a+=2)e[a]+=e[a-1]+e[a+1]>>1};return ReversibleTransform}();return JpxImage}();t.JpxImage=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.calculateSHA384=calculateSHA384;t.PDF20=t.PDF17=t.CipherTransformFactory=t.calculateSHA512=t.calculateSHA256=t.calculateMD5=t.ARCFourCipher=t.AES256Cipher=t.AES128Cipher=void 0;var a=r(2),i=r(5),n=r(12);class ARCFourCipher{constructor(e){this.a=0;this.b=0;var t,r,a=new Uint8Array(256),i=0,n=e.length;for(t=0;t<256;++t)a[t]=t;for(t=0;t<256;++t){i=i+(r=a[t])+e[t%n]&255;a[t]=a[i];a[i]=r}this.s=a}encryptBlock(e){var t,r,a,i=e.length,n=this.a,s=this.b,o=this.s,c=new Uint8Array(i);for(t=0;t<i;++t){a=o[s=s+(r=o[n=n+1&255])&255];o[n]=a;o[s]=r;c[t]=e[t]^o[r+a&255]}this.a=n;this.b=s;return c}decryptBlock(e){return this.encryptBlock(e)}encrypt(e){return this.encryptBlock(e)}}t.ARCFourCipher=ARCFourCipher;var s=function calculateMD5Closure(){var e=new Uint8Array([7,12,17,22,7,12,17,22,7,12,17,22,7,12,17,22,5,9,14,20,5,9,14,20,5,9,14,20,5,9,14,20,4,11,16,23,4,11,16,23,4,11,16,23,4,11,16,23,6,10,15,21,6,10,15,21,6,10,15,21,6,10,15,21]),t=new Int32Array([-680876936,-389564586,606105819,-1044525330,-176418897,1200080426,-1473231341,-45705983,1770035416,-1958414417,-42063,-1990404162,1804603682,-40341101,-1502002290,1236535329,-165796510,-1069501632,643717713,-373897302,-701558691,38016083,-660478335,-405537848,568446438,-1019803690,-187363961,1163531501,-1444681467,-51403784,1735328473,-1926607734,-378558,-2022574463,1839030562,-35309556,-1530992060,1272893353,-155497632,-1094730640,681279174,-358537222,-722521979,76029189,-640364487,-421815835,530742520,-995338651,-198630844,1126891415,-1416354905,-57434055,1700485571,-1894986606,-1051523,-2054922799,1873313359,-30611744,-1560198380,1309151649,-145523070,-1120210379,718787259,-343485551]);return function hash(r,a,i){var n,s,o,c=1732584193,l=-271733879,h=-1732584194,u=271733878,d=i+72&-64,f=new Uint8Array(d);for(n=0;n<i;++n)f[n]=r[a++];f[n++]=128;o=d-8;for(;n<o;)f[n++]=0;f[n++]=i<<3&255;f[n++]=i>>5&255;f[n++]=i>>13&255;f[n++]=i>>21&255;f[n++]=i>>>29&255;f[n++]=0;f[n++]=0;f[n++]=0;var g=new Int32Array(16);for(n=0;n<d;){for(s=0;s<16;++s,n+=4)g[s]=f[n]|f[n+1]<<8|f[n+2]<<16|f[n+3]<<24;var p,m,b=c,y=l,w=h,S=u;for(s=0;s<64;++s){if(s<16){p=y&w|~y&S;m=s}else if(s<32){p=S&y|~S&w;m=5*s+1&15}else if(s<48){p=y^w^S;m=3*s+5&15}else{p=w^(y|~S);m=7*s&15}var v=S,k=b+p+t[s]+g[m]|0,x=e[s];S=w;w=y;y=y+(k<<x|k>>>32-x)|0;b=v}c=c+b|0;l=l+y|0;h=h+w|0;u=u+S|0}return new Uint8Array([255&c,c>>8&255,c>>16&255,c>>>24&255,255&l,l>>8&255,l>>16&255,l>>>24&255,255&h,h>>8&255,h>>16&255,h>>>24&255,255&u,u>>8&255,u>>16&255,u>>>24&255])}}();t.calculateMD5=s;class Word64{constructor(e,t){this.high=0|e;this.low=0|t}and(e){this.high&=e.high;this.low&=e.low}xor(e){this.high^=e.high;this.low^=e.low}or(e){this.high|=e.high;this.low|=e.low}shiftRight(e){if(e>=32){this.low=this.high>>>e-32|0;this.high=0}else{this.low=this.low>>>e|this.high<<32-e;this.high=this.high>>>e|0}}shiftLeft(e){if(e>=32){this.high=this.low<<e-32;this.low=0}else{this.high=this.high<<e|this.low>>>32-e;this.low=this.low<<e}}rotateRight(e){var t,r;if(32&e){r=this.low;t=this.high}else{t=this.low;r=this.high}e&=31;this.low=t>>>e|r<<32-e;this.high=r>>>e|t<<32-e}not(){this.high=~this.high;this.low=~this.low}add(e){var t=(this.low>>>0)+(e.low>>>0),r=(this.high>>>0)+(e.high>>>0);t>4294967295&&(r+=1);this.low=0|t;this.high=0|r}copyTo(e,t){e[t]=this.high>>>24&255;e[t+1]=this.high>>16&255;e[t+2]=this.high>>8&255;e[t+3]=255&this.high;e[t+4]=this.low>>>24&255;e[t+5]=this.low>>16&255;e[t+6]=this.low>>8&255;e[t+7]=255&this.low}assign(e){this.high=e.high;this.low=e.low}}var o=function calculateSHA256Closure(){function rotr(e,t){return e>>>t|e<<32-t}function ch(e,t,r){return e&t^~e&r}function maj(e,t,r){return e&t^e&r^t&r}function sigma(e){return rotr(e,2)^rotr(e,13)^rotr(e,22)}function sigmaPrime(e){return rotr(e,6)^rotr(e,11)^rotr(e,25)}function littleSigma(e){return rotr(e,7)^rotr(e,18)^e>>>3}var e=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];return function hash(t,r,a){var i,n,s,o=1779033703,c=3144134277,l=1013904242,h=2773480762,u=1359893119,d=2600822924,f=528734635,g=1541459225,p=64*Math.ceil((a+9)/64),m=new Uint8Array(p);for(i=0;i<a;++i)m[i]=t[r++];m[i++]=128;s=p-8;for(;i<s;)m[i++]=0;m[i++]=0;m[i++]=0;m[i++]=0;m[i++]=a>>>29&255;m[i++]=a>>21&255;m[i++]=a>>13&255;m[i++]=a>>5&255;m[i++]=a<<3&255;var b,y=new Uint32Array(64);for(i=0;i<p;){for(n=0;n<16;++n){y[n]=m[i]<<24|m[i+1]<<16|m[i+2]<<8|m[i+3];i+=4}for(n=16;n<64;++n)y[n]=(rotr(b=y[n-2],17)^rotr(b,19)^b>>>10)+y[n-7]+littleSigma(y[n-15])+y[n-16]|0;var w,S,v=o,k=c,x=l,C=h,O=u,F=d,T=f,E=g;for(n=0;n<64;++n){w=E+sigmaPrime(O)+ch(O,F,T)+e[n]+y[n];S=sigma(v)+maj(v,k,x);E=T;T=F;F=O;O=C+w|0;C=x;x=k;k=v;v=w+S|0}o=o+v|0;c=c+k|0;l=l+x|0;h=h+C|0;u=u+O|0;d=d+F|0;f=f+T|0;g=g+E|0}return new Uint8Array([o>>24&255,o>>16&255,o>>8&255,255&o,c>>24&255,c>>16&255,c>>8&255,255&c,l>>24&255,l>>16&255,l>>8&255,255&l,h>>24&255,h>>16&255,h>>8&255,255&h,u>>24&255,u>>16&255,u>>8&255,255&u,d>>24&255,d>>16&255,d>>8&255,255&d,f>>24&255,f>>16&255,f>>8&255,255&f,g>>24&255,g>>16&255,g>>8&255,255&g])}}();t.calculateSHA256=o;var c=function calculateSHA512Closure(){function ch(e,t,r,a,i){e.assign(t);e.and(r);i.assign(t);i.not();i.and(a);e.xor(i)}function maj(e,t,r,a,i){e.assign(t);e.and(r);i.assign(t);i.and(a);e.xor(i);i.assign(r);i.and(a);e.xor(i)}function sigma(e,t,r){e.assign(t);e.rotateRight(28);r.assign(t);r.rotateRight(34);e.xor(r);r.assign(t);r.rotateRight(39);e.xor(r)}function sigmaPrime(e,t,r){e.assign(t);e.rotateRight(14);r.assign(t);r.rotateRight(18);e.xor(r);r.assign(t);r.rotateRight(41);e.xor(r)}function littleSigma(e,t,r){e.assign(t);e.rotateRight(1);r.assign(t);r.rotateRight(8);e.xor(r);r.assign(t);r.shiftRight(7);e.xor(r)}function littleSigmaPrime(e,t,r){e.assign(t);e.rotateRight(19);r.assign(t);r.rotateRight(61);e.xor(r);r.assign(t);r.shiftRight(6);e.xor(r)}var e=[new Word64(1116352408,3609767458),new Word64(1899447441,602891725),new Word64(3049323471,3964484399),new Word64(3921009573,2173295548),new Word64(961987163,4081628472),new Word64(1508970993,3053834265),new Word64(2453635748,2937671579),new Word64(2870763221,3664609560),new Word64(3624381080,2734883394),new Word64(310598401,1164996542),new Word64(607225278,1323610764),new Word64(1426881987,3590304994),new Word64(1925078388,4068182383),new Word64(2162078206,991336113),new Word64(2614888103,633803317),new Word64(3248222580,3479774868),new Word64(3835390401,2666613458),new Word64(4022224774,944711139),new Word64(264347078,2341262773),new Word64(604807628,2007800933),new Word64(770255983,1495990901),new Word64(1249150122,1856431235),new Word64(1555081692,3175218132),new Word64(1996064986,2198950837),new Word64(2554220882,3999719339),new Word64(2821834349,766784016),new Word64(2952996808,2566594879),new Word64(3210313671,3203337956),new Word64(3336571891,1034457026),new Word64(3584528711,2466948901),new Word64(113926993,3758326383),new Word64(338241895,168717936),new Word64(666307205,1188179964),new Word64(773529912,1546045734),new Word64(1294757372,1522805485),new Word64(1396182291,2643833823),new Word64(1695183700,2343527390),new Word64(1986661051,1014477480),new Word64(2177026350,1206759142),new Word64(2456956037,344077627),new Word64(2730485921,1290863460),new Word64(2820302411,3158454273),new Word64(3259730800,3505952657),new Word64(3345764771,106217008),new Word64(3516065817,3606008344),new Word64(3600352804,1432725776),new Word64(4094571909,1467031594),new Word64(275423344,851169720),new Word64(430227734,3100823752),new Word64(506948616,1363258195),new Word64(659060556,3750685593),new Word64(883997877,3785050280),new Word64(958139571,3318307427),new Word64(1322822218,3812723403),new Word64(1537002063,2003034995),new Word64(1747873779,3602036899),new Word64(1955562222,1575990012),new Word64(2024104815,1125592928),new Word64(2227730452,2716904306),new Word64(2361852424,442776044),new Word64(2428436474,593698344),new Word64(2756734187,3733110249),new Word64(3204031479,2999351573),new Word64(3329325298,3815920427),new Word64(3391569614,3928383900),new Word64(3515267271,566280711),new Word64(3940187606,3454069534),new Word64(4118630271,4000239992),new Word64(116418474,1914138554),new Word64(174292421,2731055270),new Word64(289380356,3203993006),new Word64(460393269,320620315),new Word64(685471733,587496836),new Word64(852142971,1086792851),new Word64(1017036298,365543100),new Word64(1126000580,2618297676),new Word64(1288033470,3409855158),new Word64(1501505948,4234509866),new Word64(1607167915,987167468),new Word64(1816402316,1246189591)];return function hash(t,r,a,i=!1){var n,s,o,c,l,h,u,d;if(i){n=new Word64(3418070365,3238371032);s=new Word64(1654270250,914150663);o=new Word64(2438529370,812702999);c=new Word64(355462360,4144912697);l=new Word64(1731405415,4290775857);h=new Word64(2394180231,1750603025);u=new Word64(3675008525,1694076839);d=new Word64(1203062813,3204075428)}else{n=new Word64(1779033703,4089235720);s=new Word64(3144134277,2227873595);o=new Word64(1013904242,4271175723);c=new Word64(2773480762,1595750129);l=new Word64(1359893119,2917565137);h=new Word64(2600822924,725511199);u=new Word64(528734635,4215389547);d=new Word64(1541459225,327033209)}var f,g,p,m=128*Math.ceil((a+17)/128),b=new Uint8Array(m);for(f=0;f<a;++f)b[f]=t[r++];b[f++]=128;p=m-16;for(;f<p;)b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=0;b[f++]=a>>>29&255;b[f++]=a>>21&255;b[f++]=a>>13&255;b[f++]=a>>5&255;b[f++]=a<<3&255;var y=new Array(80);for(f=0;f<80;f++)y[f]=new Word64(0,0);var w,S,v=new Word64(0,0),k=new Word64(0,0),x=new Word64(0,0),C=new Word64(0,0),O=new Word64(0,0),F=new Word64(0,0),T=new Word64(0,0),E=new Word64(0,0),M=new Word64(0,0),D=new Word64(0,0),N=new Word64(0,0),R=new Word64(0,0);for(f=0;f<m;){for(g=0;g<16;++g){y[g].high=b[f]<<24|b[f+1]<<16|b[f+2]<<8|b[f+3];y[g].low=b[f+4]<<24|b[f+5]<<16|b[f+6]<<8|b[f+7];f+=8}for(g=16;g<80;++g){littleSigmaPrime(w=y[g],y[g-2],R);w.add(y[g-7]);littleSigma(N,y[g-15],R);w.add(N);w.add(y[g-16])}v.assign(n);k.assign(s);x.assign(o);C.assign(c);O.assign(l);F.assign(h);T.assign(u);E.assign(d);for(g=0;g<80;++g){M.assign(E);sigmaPrime(N,O,R);M.add(N);ch(N,O,F,T,R);M.add(N);M.add(e[g]);M.add(y[g]);sigma(D,v,R);maj(N,v,k,x,R);D.add(N);w=E;E=T;T=F;F=O;C.add(M);O=C;C=x;x=k;k=v;w.assign(M);w.add(D);v=w}n.add(v);s.add(k);o.add(x);c.add(C);l.add(O);h.add(F);u.add(T);d.add(E)}if(i){S=new Uint8Array(48);n.copyTo(S,0);s.copyTo(S,8);o.copyTo(S,16);c.copyTo(S,24);l.copyTo(S,32);h.copyTo(S,40)}else{S=new Uint8Array(64);n.copyTo(S,0);s.copyTo(S,8);o.copyTo(S,16);c.copyTo(S,24);l.copyTo(S,32);h.copyTo(S,40);u.copyTo(S,48);d.copyTo(S,56)}return S}}();t.calculateSHA512=c;function calculateSHA384(e,t,r){return c(e,t,r,!0)}class NullCipher{decryptBlock(e){return e}encrypt(e){return e}}class AESBaseCipher{constructor(){this.constructor===AESBaseCipher&&(0,a.unreachable)("Cannot initialize AESBaseCipher.");this._s=new Uint8Array([99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22]);this._inv_s=new Uint8Array([82,9,106,213,48,54,165,56,191,64,163,158,129,243,215,251,124,227,57,130,155,47,255,135,52,142,67,68,196,222,233,203,84,123,148,50,166,194,35,61,238,76,149,11,66,250,195,78,8,46,161,102,40,217,36,178,118,91,162,73,109,139,209,37,114,248,246,100,134,104,152,22,212,164,92,204,93,101,182,146,108,112,72,80,253,237,185,218,94,21,70,87,167,141,157,132,144,216,171,0,140,188,211,10,247,228,88,5,184,179,69,6,208,44,30,143,202,63,15,2,193,175,189,3,1,19,138,107,58,145,17,65,79,103,220,234,151,242,207,206,240,180,230,115,150,172,116,34,231,173,53,133,226,249,55,232,28,117,223,110,71,241,26,113,29,41,197,137,111,183,98,14,170,24,190,27,252,86,62,75,198,210,121,32,154,219,192,254,120,205,90,244,31,221,168,51,136,7,199,49,177,18,16,89,39,128,236,95,96,81,127,169,25,181,74,13,45,229,122,159,147,201,156,239,160,224,59,77,174,42,245,176,200,235,187,60,131,83,153,97,23,43,4,126,186,119,214,38,225,105,20,99,85,33,12,125]);this._mix=new Uint32Array([0,235474187,470948374,303765277,941896748,908933415,607530554,708780849,1883793496,2118214995,1817866830,1649639237,1215061108,1181045119,1417561698,1517767529,3767586992,4003061179,4236429990,4069246893,3635733660,3602770327,3299278474,3400528769,2430122216,2664543715,2362090238,2193862645,2835123396,2801107407,3035535058,3135740889,3678124923,3576870512,3341394285,3374361702,3810496343,3977675356,4279080257,4043610186,2876494627,2776292904,3076639029,3110650942,2472011535,2640243204,2403728665,2169303058,1001089995,899835584,666464733,699432150,59727847,226906860,530400753,294930682,1273168787,1172967064,1475418501,1509430414,1942435775,2110667444,1876241833,1641816226,2910219766,2743034109,2976151520,3211623147,2505202138,2606453969,2302690252,2269728455,3711829422,3543599269,3240894392,3475313331,3843699074,3943906441,4178062228,4144047775,1306967366,1139781709,1374988112,1610459739,1975683434,2076935265,1775276924,1742315127,1034867998,866637845,566021896,800440835,92987698,193195065,429456164,395441711,1984812685,2017778566,1784663195,1683407248,1315562145,1080094634,1383856311,1551037884,101039829,135050206,437757123,337553864,1042385657,807962610,573804783,742039012,2531067453,2564033334,2328828971,2227573024,2935566865,2700099354,3001755655,3168937228,3868552805,3902563182,4203181171,4102977912,3736164937,3501741890,3265478751,3433712980,1106041591,1340463100,1576976609,1408749034,2043211483,2009195472,1708848333,1809054150,832877231,1068351396,766945465,599762354,159417987,126454664,361929877,463180190,2709260871,2943682380,3178106961,3009879386,2572697195,2538681184,2236228733,2336434550,3509871135,3745345300,3441850377,3274667266,3910161971,3877198648,4110568485,4211818798,2597806476,2497604743,2261089178,2295101073,2733856160,2902087851,3202437046,2968011453,3936291284,3835036895,4136440770,4169408201,3535486456,3702665459,3467192302,3231722213,2051518780,1951317047,1716890410,1750902305,1113818384,1282050075,1584504582,1350078989,168810852,67556463,371049330,404016761,841739592,1008918595,775550814,540080725,3969562369,3801332234,4035489047,4269907996,3569255213,3669462566,3366754619,3332740144,2631065433,2463879762,2160117071,2395588676,2767645557,2868897406,3102011747,3069049960,202008497,33778362,270040487,504459436,875451293,975658646,675039627,641025152,2084704233,1917518562,1615861247,1851332852,1147550661,1248802510,1484005843,1451044056,933301370,967311729,733156972,632953703,260388950,25965917,328671808,496906059,1206477858,1239443753,1543208500,1441952575,2144161806,1908694277,1675577880,1842759443,3610369226,3644379585,3408119516,3307916247,4011190502,3776767469,4077384432,4245618683,2809771154,2842737049,3144396420,3043140495,2673705150,2438237621,2203032232,2370213795]);this._mixCol=new Uint8Array(256);for(let e=0;e<256;e++)this._mixCol[e]=e<128?e<<1:e<<1^27;this.buffer=new Uint8Array(16);this.bufferPosition=0}_expandKey(e){(0,a.unreachable)("Cannot call `_expandKey` on the base class")}_decrypt(e,t){let r,a,i;const n=new Uint8Array(16);n.set(e);for(let e=0,r=this._keySize;e<16;++e,++r)n[e]^=t[r];for(let e=this._cyclesOfRepetition-1;e>=1;--e){r=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=r;r=n[14];a=n[10];n[14]=n[6];n[10]=n[2];n[6]=r;n[2]=a;r=n[15];a=n[11];i=n[7];n[15]=n[3];n[11]=r;n[7]=a;n[3]=i;for(let e=0;e<16;++e)n[e]=this._inv_s[n[e]];for(let r=0,a=16*e;r<16;++r,++a)n[r]^=t[a];for(let e=0;e<16;e+=4){const t=this._mix[n[e]],a=this._mix[n[e+1]],i=this._mix[n[e+2]],s=this._mix[n[e+3]];r=t^a>>>8^a<<24^i>>>16^i<<16^s>>>24^s<<8;n[e]=r>>>24&255;n[e+1]=r>>16&255;n[e+2]=r>>8&255;n[e+3]=255&r}}r=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=r;r=n[14];a=n[10];n[14]=n[6];n[10]=n[2];n[6]=r;n[2]=a;r=n[15];a=n[11];i=n[7];n[15]=n[3];n[11]=r;n[7]=a;n[3]=i;for(let e=0;e<16;++e){n[e]=this._inv_s[n[e]];n[e]^=t[e]}return n}_encrypt(e,t){const r=this._s;let a,i,n;const s=new Uint8Array(16);s.set(e);for(let e=0;e<16;++e)s[e]^=t[e];for(let e=1;e<this._cyclesOfRepetition;e++){for(let e=0;e<16;++e)s[e]=r[s[e]];n=s[1];s[1]=s[5];s[5]=s[9];s[9]=s[13];s[13]=n;n=s[2];i=s[6];s[2]=s[10];s[6]=s[14];s[10]=n;s[14]=i;n=s[3];i=s[7];a=s[11];s[3]=s[15];s[7]=n;s[11]=i;s[15]=a;for(let e=0;e<16;e+=4){const t=s[e+0],r=s[e+1],i=s[e+2],n=s[e+3];a=t^r^i^n;s[e+0]^=a^this._mixCol[t^r];s[e+1]^=a^this._mixCol[r^i];s[e+2]^=a^this._mixCol[i^n];s[e+3]^=a^this._mixCol[n^t]}for(let r=0,a=16*e;r<16;++r,++a)s[r]^=t[a]}for(let e=0;e<16;++e)s[e]=r[s[e]];n=s[1];s[1]=s[5];s[5]=s[9];s[9]=s[13];s[13]=n;n=s[2];i=s[6];s[2]=s[10];s[6]=s[14];s[10]=n;s[14]=i;n=s[3];i=s[7];a=s[11];s[3]=s[15];s[7]=n;s[11]=i;s[15]=a;for(let e=0,r=this._keySize;e<16;++e,++r)s[e]^=t[r];return s}_decryptBlock2(e,t){const r=e.length;let a=this.buffer,i=this.bufferPosition;const n=[];let s=this.iv;for(let t=0;t<r;++t){a[i]=e[t];++i;if(i<16)continue;const r=this._decrypt(a,this._key);for(let e=0;e<16;++e)r[e]^=s[e];s=a;n.push(r);a=new Uint8Array(16);i=0}this.buffer=a;this.bufferLength=i;this.iv=s;if(0===n.length)return new Uint8Array(0);let o=16*n.length;if(t){const e=n[n.length-1];let t=e[15];if(t<=16){for(let r=15,a=16-t;r>=a;--r)if(e[r]!==t){t=0;break}o-=t;n[n.length-1]=e.subarray(0,16-t)}}const c=new Uint8Array(o);for(let e=0,t=0,r=n.length;e<r;++e,t+=16)c.set(n[e],t);return c}decryptBlock(e,t,r=null){const a=e.length,i=this.buffer;let n=this.bufferPosition;if(r)this.iv=r;else{for(let t=0;n<16&&t<a;++t,++n)i[n]=e[t];if(n<16){this.bufferLength=n;return new Uint8Array(0)}this.iv=i;e=e.subarray(16)}this.buffer=new Uint8Array(16);this.bufferLength=0;this.decryptBlock=this._decryptBlock2;return this.decryptBlock(e,t)}encrypt(e,t){const r=e.length;let a=this.buffer,i=this.bufferPosition;const n=[];t||(t=new Uint8Array(16));for(let s=0;s<r;++s){a[i]=e[s];++i;if(i<16)continue;for(let e=0;e<16;++e)a[e]^=t[e];const r=this._encrypt(a,this._key);t=r;n.push(r);a=new Uint8Array(16);i=0}this.buffer=a;this.bufferLength=i;this.iv=t;if(0===n.length)return new Uint8Array(0);const s=16*n.length,o=new Uint8Array(s);for(let e=0,t=0,r=n.length;e<r;++e,t+=16)o.set(n[e],t);return o}}class AES128Cipher extends AESBaseCipher{constructor(e){super();this._cyclesOfRepetition=10;this._keySize=160;this._rcon=new Uint8Array([141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141]);this._key=this._expandKey(e)}_expandKey(e){const t=this._s,r=this._rcon,a=new Uint8Array(176);a.set(e);for(let e=16,i=1;e<176;++i){let n=a[e-3],s=a[e-2],o=a[e-1],c=a[e-4];n=t[n];s=t[s];o=t[o];c=t[c];n^=r[i];for(let t=0;t<4;++t){a[e]=n^=a[e-16];e++;a[e]=s^=a[e-16];e++;a[e]=o^=a[e-16];e++;a[e]=c^=a[e-16];e++}}return a}}t.AES128Cipher=AES128Cipher;class AES256Cipher extends AESBaseCipher{constructor(e){super();this._cyclesOfRepetition=14;this._keySize=224;this._key=this._expandKey(e)}_expandKey(e){const t=this._s,r=new Uint8Array(240);r.set(e);let a,i,n,s,o=1;for(let e=32,c=1;e<240;++c){if(e%32==16){a=t[a];i=t[i];n=t[n];s=t[s]}else if(e%32==0){a=r[e-3];i=r[e-2];n=r[e-1];s=r[e-4];a=t[a];i=t[i];n=t[n];s=t[s];a^=o;(o<<=1)>=256&&(o=255&(27^o))}for(let t=0;t<4;++t){r[e]=a^=r[e-32];e++;r[e]=i^=r[e-32];e++;r[e]=n^=r[e-32];e++;r[e]=s^=r[e-32];e++}}return r}}t.AES256Cipher=AES256Cipher;class PDF17{checkOwnerPassword(e,t,r,i){var n=new Uint8Array(e.length+56);n.set(e,0);n.set(t,e.length);n.set(r,e.length+t.length);var s=o(n,0,n.length);return(0,a.isArrayEqual)(s,i)}checkUserPassword(e,t,r){var i=new Uint8Array(e.length+8);i.set(e,0);i.set(t,e.length);var n=o(i,0,i.length);return(0,a.isArrayEqual)(n,r)}getOwnerKey(e,t,r,a){var i=new Uint8Array(e.length+56);i.set(e,0);i.set(t,e.length);i.set(r,e.length+t.length);var n=o(i,0,i.length);return new AES256Cipher(n).decryptBlock(a,!1,new Uint8Array(16))}getUserKey(e,t,r){var a=new Uint8Array(e.length+8);a.set(e,0);a.set(t,e.length);var i=o(a,0,a.length);return new AES256Cipher(i).decryptBlock(r,!1,new Uint8Array(16))}}t.PDF17=PDF17;var l=function PDF20Closure(){function calculatePDF20Hash(e,t,r){for(var a=o(t,0,t.length).subarray(0,32),i=[0],n=0;n<64||i[i.length-1]>n-32;){const t=e.length+a.length+r.length,f=new Uint8Array(t);let g=0;f.set(e,g);g+=e.length;f.set(a,g);g+=a.length;f.set(r,g);for(var s=new Uint8Array(64*t),l=0,h=0;l<64;l++,h+=t)s.set(f,h);i=new AES128Cipher(a.subarray(0,16)).encrypt(s,a.subarray(16,32));for(var u=0,d=0;d<16;d++){u*=1;u%=3;u+=(i[d]>>>0)%3;u%=3}0===u?a=o(i,0,i.length):1===u?a=calculateSHA384(i,0,i.length):2===u&&(a=c(i,0,i.length));n++}return a.subarray(0,32)}return class PDF20{hash(e,t,r){return calculatePDF20Hash(e,t,r)}checkOwnerPassword(e,t,r,i){var n=new Uint8Array(e.length+56);n.set(e,0);n.set(t,e.length);n.set(r,e.length+t.length);var s=calculatePDF20Hash(e,n,r);return(0,a.isArrayEqual)(s,i)}checkUserPassword(e,t,r){var i=new Uint8Array(e.length+8);i.set(e,0);i.set(t,e.length);var n=calculatePDF20Hash(e,i,[]);return(0,a.isArrayEqual)(n,r)}getOwnerKey(e,t,r,a){var i=new Uint8Array(e.length+56);i.set(e,0);i.set(t,e.length);i.set(r,e.length+t.length);var n=calculatePDF20Hash(e,i,r);return new AES256Cipher(n).decryptBlock(a,!1,new Uint8Array(16))}getUserKey(e,t,r){var a=new Uint8Array(e.length+8);a.set(e,0);a.set(t,e.length);var i=calculatePDF20Hash(e,a,[]);return new AES256Cipher(i).decryptBlock(r,!1,new Uint8Array(16))}}}();t.PDF20=l;class CipherTransform{constructor(e,t){this.StringCipherConstructor=e;this.StreamCipherConstructor=t}createStream(e,t){var r=new this.StreamCipherConstructor;return new n.DecryptStream(e,t,(function cipherTransformDecryptStream(e,t){return r.decryptBlock(e,t)}))}decryptString(e){var t=new this.StringCipherConstructor,r=(0,a.stringToBytes)(e);r=t.decryptBlock(r,!0);return(0,a.bytesToString)(r)}encryptString(e){const t=new this.StringCipherConstructor;if(t instanceof AESBaseCipher){const r=e.length,i=16-r%16;16!==i&&(e=e.padEnd(16*Math.ceil(r/16),String.fromCharCode(i)));const n=new Uint8Array(16);if("undefined"!=typeof crypto)crypto.getRandomValues(n);else for(let e=0;e<16;e++)n[e]=Math.floor(256*Math.random());let s=(0,a.stringToBytes)(e);s=t.encrypt(s,n);const o=new Uint8Array(16+s.length);o.set(n);o.set(s,16);return(0,a.bytesToString)(o)}let r=(0,a.stringToBytes)(e);r=t.encrypt(r);return(0,a.bytesToString)(r)}}var h=function CipherTransformFactoryClosure(){var e=new Uint8Array([40,191,78,94,78,117,138,65,100,0,78,86,255,250,1,8,46,46,0,182,208,104,62,128,47,12,169,254,100,83,105,122]);function prepareKeyData(t,r,a,i,n,o,c,l){var h,u,d=40+a.length+t.length,f=new Uint8Array(d),g=0;if(r){u=Math.min(32,r.length);for(;g<u;++g)f[g]=r[g]}h=0;for(;g<32;)f[g++]=e[h++];for(h=0,u=a.length;h<u;++h)f[g++]=a[h];f[g++]=255&n;f[g++]=n>>8&255;f[g++]=n>>16&255;f[g++]=n>>>24&255;for(h=0,u=t.length;h<u;++h)f[g++]=t[h];if(o>=4&&!l){f[g++]=255;f[g++]=255;f[g++]=255;f[g++]=255}var p=s(f,0,g),m=c>>3;if(o>=3)for(h=0;h<50;++h)p=s(p,0,m);var b,y=p.subarray(0,m);if(o>=3){for(g=0;g<32;++g)f[g]=e[g];for(h=0,u=t.length;h<u;++h)f[g++]=t[h];b=new ARCFourCipher(y).encryptBlock(s(f,0,g));u=y.length;var w,S=new Uint8Array(u);for(h=1;h<=19;++h){for(w=0;w<u;++w)S[w]=y[w]^h;b=new ARCFourCipher(S).encryptBlock(b)}for(h=0,u=b.length;h<u;++h)if(i[h]!==b[h])return null}else for(h=0,u=(b=new ARCFourCipher(y).encryptBlock(e)).length;h<u;++h)if(i[h]!==b[h])return null;return y}var t=i.Name.get("Identity");function buildObjectKey(e,t,r,a=!1){var i,n,o=new Uint8Array(r.length+9);for(i=0,n=r.length;i<n;++i)o[i]=r[i];o[i++]=255&e;o[i++]=e>>8&255;o[i++]=e>>16&255;o[i++]=255&t;o[i++]=t>>8&255;if(a){o[i++]=115;o[i++]=65;o[i++]=108;o[i++]=84}return s(o,0,i).subarray(0,Math.min(r.length+5,16))}function buildCipherConstructor(e,t,r,n,s){if(!(0,i.isName)(t))throw new a.FormatError("Invalid crypt filter name.");var o,c=e.get(t.name);null!=c&&(o=c.get("CFM"));if(!o||"None"===o.name)return function cipherTransformFactoryBuildCipherConstructorNone(){return new NullCipher};if("V2"===o.name)return function cipherTransformFactoryBuildCipherConstructorV2(){return new ARCFourCipher(buildObjectKey(r,n,s,!1))};if("AESV2"===o.name)return function cipherTransformFactoryBuildCipherConstructorAESV2(){return new AES128Cipher(buildObjectKey(r,n,s,!0))};if("AESV3"===o.name)return function cipherTransformFactoryBuildCipherConstructorAESV3(){return new AES256Cipher(s)};throw new a.FormatError("Unknown crypto method")}return class CipherTransformFactory{constructor(r,n,o){var c=r.get("Filter");if(!(0,i.isName)(c,"Standard"))throw new a.FormatError("unknown encryption method");this.dict=r;var h=r.get("V");if(!Number.isInteger(h)||1!==h&&2!==h&&4!==h&&5!==h)throw new a.FormatError("unsupported encryption algorithm");this.algorithm=h;var u=r.get("Length");if(!u)if(h<=3)u=40;else{var d=r.get("CF"),f=r.get("StmF");if((0,i.isDict)(d)&&(0,i.isName)(f)){d.suppressEncryption=!0;var g=d.get(f.name);(u=g&&g.get("Length")||128)<40&&(u<<=3)}}if(!Number.isInteger(u)||u<40||u%8!=0)throw new a.FormatError("invalid key length");var p=(0,a.stringToBytes)(r.get("O")).subarray(0,32),m=(0,a.stringToBytes)(r.get("U")).subarray(0,32),b=r.get("P"),y=r.get("R"),w=(4===h||5===h)&&!1!==r.get("EncryptMetadata");this.encryptMetadata=w;var S,v,k=(0,a.stringToBytes)(n);if(o){if(6===y)try{o=(0,a.utf8StringToString)(o)}catch(e){(0,a.warn)("CipherTransformFactory: Unable to convert UTF8 encoded password.")}S=(0,a.stringToBytes)(o)}if(5!==h)v=prepareKeyData(k,S,p,m,b,y,u,w);else{var x=(0,a.stringToBytes)(r.get("O")).subarray(32,40),C=(0,a.stringToBytes)(r.get("O")).subarray(40,48),O=(0,a.stringToBytes)(r.get("U")).subarray(0,48),F=(0,a.stringToBytes)(r.get("U")).subarray(32,40),T=(0,a.stringToBytes)(r.get("U")).subarray(40,48),E=(0,a.stringToBytes)(r.get("OE")),M=(0,a.stringToBytes)(r.get("UE"));(0,a.stringToBytes)(r.get("Perms"));v=function createEncryptionKey20(e,t,r,a,i,n,s,o,c,h,u,d){if(t){var f=Math.min(127,t.length);t=t.subarray(0,f)}else t=[];var g;return(g=6===e?new l:new PDF17).checkUserPassword(t,o,s)?g.getUserKey(t,c,u):t.length&&g.checkOwnerPassword(t,a,n,r)?g.getOwnerKey(t,i,n,h):null}(y,S,p,x,C,O,m,F,T,E,M)}if(!v&&!o)throw new a.PasswordException("No password given",a.PasswordResponses.NEED_PASSWORD);if(!v&&o){v=prepareKeyData(k,function decodeUserPassword(t,r,a,i){var n,o,c=new Uint8Array(32),l=0;o=Math.min(32,t.length);for(;l<o;++l)c[l]=t[l];n=0;for(;l<32;)c[l++]=e[n++];var h,u=s(c,0,l),d=i>>3;if(a>=3)for(n=0;n<50;++n)u=s(u,0,u.length);if(a>=3){h=r;var f,g=new Uint8Array(d);for(n=19;n>=0;n--){for(f=0;f<d;++f)g[f]=u[f]^n;h=new ARCFourCipher(g).encryptBlock(h)}}else h=new ARCFourCipher(u.subarray(0,d)).encryptBlock(r);return h}(S,p,y,u),p,m,b,y,u,w)}if(!v)throw new a.PasswordException("Incorrect Password",a.PasswordResponses.INCORRECT_PASSWORD);this.encryptionKey=v;if(h>=4){var D=r.get("CF");(0,i.isDict)(D)&&(D.suppressEncryption=!0);this.cf=D;this.stmf=r.get("StmF")||t;this.strf=r.get("StrF")||t;this.eff=r.get("EFF")||this.stmf}}createCipherTransform(e,t){if(4===this.algorithm||5===this.algorithm)return new CipherTransform(buildCipherConstructor(this.cf,this.stmf,e,t,this.encryptionKey),buildCipherConstructor(this.cf,this.strf,e,t,this.encryptionKey));var r=buildObjectKey(e,t,this.encryptionKey,!1),a=function buildCipherCipherConstructor(){return new ARCFourCipher(r)};return new CipherTransform(a,a)}}}();t.CipherTransformFactory=h},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ColorSpace=void 0;var a=r(2),i=r(5),n=r(8);class ColorSpace{constructor(e,t){this.constructor===ColorSpace&&(0,a.unreachable)("Cannot initialize ColorSpace.");this.name=e;this.numComps=t}getRgb(e,t){const r=new Uint8ClampedArray(3);this.getRgbItem(e,t,r,0);return r}getRgbItem(e,t,r,i){(0,a.unreachable)("Should not call ColorSpace.getRgbItem")}getRgbBuffer(e,t,r,i,n,s,o){(0,a.unreachable)("Should not call ColorSpace.getRgbBuffer")}getOutputLength(e,t){(0,a.unreachable)("Should not call ColorSpace.getOutputLength")}isPassthrough(e){return!1}isDefaultDecode(e,t){return ColorSpace.isDefaultDecode(e,this.numComps)}fillRgb(e,t,r,a,i,n,s,o,c){const l=t*r;let h=null;const u=1<<s,d=r!==i||t!==a;if(this.isPassthrough(s))h=o;else if(1===this.numComps&&l>u&&"DeviceGray"!==this.name&&"DeviceRGB"!==this.name){const t=s<=8?new Uint8Array(u):new Uint16Array(u);for(let e=0;e<u;e++)t[e]=e;const r=new Uint8ClampedArray(3*u);this.getRgbBuffer(t,0,u,r,0,s,0);if(d){h=new Uint8Array(3*l);let e=0;for(let t=0;t<l;++t){const a=3*o[t];h[e++]=r[a];h[e++]=r[a+1];h[e++]=r[a+2]}}else{let t=0;for(let a=0;a<l;++a){const i=3*o[a];e[t++]=r[i];e[t++]=r[i+1];e[t++]=r[i+2];t+=c}}}else if(d){h=new Uint8ClampedArray(3*l);this.getRgbBuffer(o,0,l,h,0,s,0)}else this.getRgbBuffer(o,0,a*n,e,0,s,c);if(h)if(d)!function resizeRgbImage(e,t,r,a,i,n,s){s=1!==s?0:s;const o=r/i,c=a/n;let l,h=0;const u=new Uint16Array(i),d=3*r;for(let e=0;e<i;e++)u[e]=3*Math.floor(e*o);for(let r=0;r<n;r++){const a=Math.floor(r*c)*d;for(let r=0;r<i;r++){l=a+u[r];t[h++]=e[l++];t[h++]=e[l++];t[h++]=e[l++];h+=s}}}(h,e,t,r,a,i,c);else{let t=0,r=0;for(let i=0,s=a*n;i<s;i++){e[t++]=h[r++];e[t++]=h[r++];e[t++]=h[r++];t+=c}}}get usesZeroToOneRange(){return(0,a.shadow)(this,"usesZeroToOneRange",!0)}static _cache(e,t,r,a){if(!r)throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');if(!a)throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');let n,s;if(e instanceof i.Ref){s=e;e=t.fetch(e)}e instanceof i.Name&&(n=e.name);(n||s)&&r.set(n,s,a)}static getCached(e,t,r){if(!r)throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');if(e instanceof i.Ref){const a=r.getByRef(e);if(a)return a;try{e=t.fetch(e)}catch(e){if(e instanceof n.MissingDataException)throw e}}if(e instanceof i.Name){const t=r.getByName(e.name);if(t)return t}return null}static async parseAsync({cs:e,xref:t,resources:r=null,pdfFunctionFactory:a,localColorSpaceCache:i}){const n=this._parse(e,t,r,a);this._cache(e,t,i,n);return n}static parse({cs:e,xref:t,resources:r=null,pdfFunctionFactory:a,localColorSpaceCache:i}){const n=this.getCached(e,t,i);if(n)return n;const s=this._parse(e,t,r,a);this._cache(e,t,i,s);return s}static _parse(e,t,r=null,n){e=t.fetchIfRef(e);if((0,i.isName)(e))switch(e.name){case"DeviceGray":case"G":return this.singletons.gray;case"DeviceRGB":case"RGB":return this.singletons.rgb;case"DeviceCMYK":case"CMYK":return this.singletons.cmyk;case"Pattern":return new PatternCS(null);default:if((0,i.isDict)(r)){const a=r.get("ColorSpace");if((0,i.isDict)(a)){const s=a.get(e.name);if(s){if((0,i.isName)(s))return this._parse(s,t,r,n);e=s;break}}}throw new a.FormatError(`Unrecognized ColorSpace: ${e.name}`)}if(Array.isArray(e)){const i=t.fetchIfRef(e[0]).name;let s,h,u,d,f,g;switch(i){case"DeviceGray":case"G":return this.singletons.gray;case"DeviceRGB":case"RGB":return this.singletons.rgb;case"DeviceCMYK":case"CMYK":return this.singletons.cmyk;case"CalGray":s=t.fetchIfRef(e[1]);d=s.getArray("WhitePoint");f=s.getArray("BlackPoint");g=s.get("Gamma");return new o(d,f,g);case"CalRGB":s=t.fetchIfRef(e[1]);d=s.getArray("WhitePoint");f=s.getArray("BlackPoint");g=s.getArray("Gamma");const p=s.getArray("Matrix");return new c(d,f,g,p);case"ICCBased":const m=t.fetchIfRef(e[1]).dict;h=m.get("N");const b=m.get("Alternate");if(b){const e=this._parse(b,t,r,n);if(e.numComps===h)return e;(0,a.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.")}if(1===h)return this.singletons.gray;if(3===h)return this.singletons.rgb;if(4===h)return this.singletons.cmyk;break;case"Pattern":u=e[1]||null;u&&(u=this._parse(u,t,r,n));return new PatternCS(u);case"Indexed":case"I":u=this._parse(e[1],t,r,n);const y=t.fetchIfRef(e[2])+1,w=t.fetchIfRef(e[3]);return new IndexedCS(u,y,w);case"Separation":case"DeviceN":const S=t.fetchIfRef(e[1]);h=Array.isArray(S)?S.length:1;u=this._parse(e[2],t,r,n);const v=n.create(e[3]);return new AlternateCS(h,u,v);case"Lab":s=t.fetchIfRef(e[1]);d=s.getArray("WhitePoint");f=s.getArray("BlackPoint");const k=s.getArray("Range");return new l(d,f,k);default:throw new a.FormatError(`Unimplemented ColorSpace object: ${i}`)}}throw new a.FormatError(`Unrecognized ColorSpace object: ${e}`)}static isDefaultDecode(e,t){if(!Array.isArray(e))return!0;if(2*t!==e.length){(0,a.warn)("The decode map is not the correct length");return!0}for(let t=0,r=e.length;t<r;t+=2)if(0!==e[t]||1!==e[t+1])return!1;return!0}static get singletons(){return(0,a.shadow)(this,"singletons",{get gray(){return(0,a.shadow)(this,"gray",new DeviceGrayCS)},get rgb(){return(0,a.shadow)(this,"rgb",new DeviceRgbCS)},get cmyk(){return(0,a.shadow)(this,"cmyk",new s)}})}}t.ColorSpace=ColorSpace;class AlternateCS extends ColorSpace{constructor(e,t,r){super("Alternate",e);this.base=t;this.tintFn=r;this.tmpBuf=new Float32Array(t.numComps)}getRgbItem(e,t,r,a){const i=this.tmpBuf;this.tintFn(e,t,i,0);this.base.getRgbItem(i,0,r,a)}getRgbBuffer(e,t,r,a,i,n,s){const o=this.tintFn,c=this.base,l=1/((1<<n)-1),h=c.numComps,u=c.usesZeroToOneRange,d=(c.isPassthrough(8)||!u)&&0===s;let f=d?i:0;const g=d?a:new Uint8ClampedArray(h*r),p=this.numComps,m=new Float32Array(p),b=new Float32Array(h);let y,w;for(y=0;y<r;y++){for(w=0;w<p;w++)m[w]=e[t++]*l;o(m,0,b,0);if(u)for(w=0;w<h;w++)g[f++]=255*b[w];else{c.getRgbItem(b,0,g,f);f+=h}}d||c.getRgbBuffer(g,0,r,a,i,8,s)}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps/this.numComps,t)}}class PatternCS extends ColorSpace{constructor(e){super("Pattern",null);this.base=e}isDefaultDecode(e,t){(0,a.unreachable)("Should not call PatternCS.isDefaultDecode")}}class IndexedCS extends ColorSpace{constructor(e,t,r){super("Indexed",1);this.base=e;this.highVal=t;const n=e.numComps*t;this.lookup=new Uint8Array(n);if((0,i.isStream)(r)){const e=r.getBytes(n);this.lookup.set(e)}else{if("string"!=typeof r)throw new a.FormatError(`IndexedCS - unrecognized lookup table: ${r}`);for(let e=0;e<n;++e)this.lookup[e]=255&r.charCodeAt(e)}}getRgbItem(e,t,r,a){const i=this.base.numComps,n=e[t]*i;this.base.getRgbBuffer(this.lookup,n,1,r,a,8,0)}getRgbBuffer(e,t,r,a,i,n,s){const o=this.base,c=o.numComps,l=o.getOutputLength(c,s),h=this.lookup;for(let n=0;n<r;++n){const r=e[t++]*c;o.getRgbBuffer(h,r,1,a,i,8,s);i+=l}}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps,t)}isDefaultDecode(e,t){if(!Array.isArray(e))return!0;if(2!==e.length){(0,a.warn)("Decode map length is not correct");return!0}if(!Number.isInteger(t)||t<1){(0,a.warn)("Bits per component is not correct");return!0}return 0===e[0]&&e[1]===(1<<t)-1}}class DeviceGrayCS extends ColorSpace{constructor(){super("DeviceGray",1)}getRgbItem(e,t,r,a){const i=255*e[t];r[a]=r[a+1]=r[a+2]=i}getRgbBuffer(e,t,r,a,i,n,s){const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<r;++t){const t=o*e[c++];a[l++]=t;a[l++]=t;a[l++]=t;l+=s}}getOutputLength(e,t){return e*(3+t)}}class DeviceRgbCS extends ColorSpace{constructor(){super("DeviceRGB",3)}getRgbItem(e,t,r,a){r[a]=255*e[t];r[a+1]=255*e[t+1];r[a+2]=255*e[t+2]}getRgbBuffer(e,t,r,a,i,n,s){if(8===n&&0===s){a.set(e.subarray(t,t+3*r),i);return}const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<r;++t){a[l++]=o*e[c++];a[l++]=o*e[c++];a[l++]=o*e[c++];l+=s}}getOutputLength(e,t){return e*(3+t)/3|0}isPassthrough(e){return 8===e}}const s=function DeviceCmykCSClosure(){function convertToRgb(e,t,r,a,i){const n=e[t]*r,s=e[t+1]*r,o=e[t+2]*r,c=e[t+3]*r;a[i]=255+n*(-4.387332384609988*n+54.48615194189176*s+18.82290502165302*o+212.25662451639585*c-285.2331026137004)+s*(1.7149763477362134*s-5.6096736904047315*o+-17.873870861415444*c-5.497006427196366)+o*(-2.5217340131683033*o-21.248923337353073*c+17.5119270841813)+c*(-21.86122147463605*c-189.48180835922747);a[i+1]=255+n*(8.841041422036149*n+60.118027045597366*s+6.871425592049007*o+31.159100130055922*c-79.2970844816548)+s*(-15.310361306967817*s+17.575251261109482*o+131.35250912493976*c-190.9453302588951)+o*(4.444339102852739*o+9.8632861493405*c-24.86741582555878)+c*(-20.737325471181034*c-187.80453709719578);a[i+2]=255+n*(.8842522430003296*n+8.078677503112928*s+30.89978309703729*o-.23883238689178934*c-14.183576799673286)+s*(10.49593273432072*s+63.02378494754052*o+50.606957656360734*c-112.23884253719248)+o*(.03296041114873217*o+115.60384449646641*c-193.58209356861505)+c*(-22.33816807309886*c-180.12613974708367)}return class DeviceCmykCS extends ColorSpace{constructor(){super("DeviceCMYK",4)}getRgbItem(e,t,r,a){convertToRgb(e,t,1,r,a)}getRgbBuffer(e,t,r,a,i,n,s){const o=1/((1<<n)-1);for(let n=0;n<r;n++){convertToRgb(e,t,o,a,i);t+=4;i+=3+s}}getOutputLength(e,t){return e/4*(3+t)|0}}}(),o=function CalGrayCSClosure(){function convertToRgb(e,t,r,a,i,n){const s=(t[r]*n)**e.G,o=e.YW*s,c=Math.max(295.8*o**.3333333333333333-40.8,0);a[i]=c;a[i+1]=c;a[i+2]=c}return class CalGrayCS extends ColorSpace{constructor(e,t,r){super("CalGray",1);if(!e)throw new a.FormatError("WhitePoint missing - required for color space CalGray");t=t||[0,0,0];r=r||1;this.XW=e[0];this.YW=e[1];this.ZW=e[2];this.XB=t[0];this.YB=t[1];this.ZB=t[2];this.G=r;if(this.XW<0||this.ZW<0||1!==this.YW)throw new a.FormatError(`Invalid WhitePoint components for ${this.name}, no fallback available`);if(this.XB<0||this.YB<0||this.ZB<0){(0,a.info)(`Invalid BlackPoint for ${this.name}, falling back to default.`);this.XB=this.YB=this.ZB=0}0===this.XB&&0===this.YB&&0===this.ZB||(0,a.warn)(`${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, ZB: ${this.ZB}, only default values are supported.`);if(this.G<1){(0,a.info)(`Invalid Gamma: ${this.G} for ${this.name}, falling back to default.`);this.G=1}}getRgbItem(e,t,r,a){convertToRgb(this,e,t,r,a,1)}getRgbBuffer(e,t,r,a,i,n,s){const o=1/((1<<n)-1);for(let n=0;n<r;++n){convertToRgb(this,e,t,a,i,o);t+=1;i+=3+s}}getOutputLength(e,t){return e*(3+t)}}}(),c=function CalRGBCSClosure(){const e=new Float32Array([.8951,.2664,-.1614,-.7502,1.7135,.0367,.0389,-.0685,1.0296]),t=new Float32Array([.9869929,-.1470543,.1599627,.4323053,.5183603,.0492912,-.0085287,.0400428,.9684867]),r=new Float32Array([3.2404542,-1.5371385,-.4985314,-.969266,1.8760108,.041556,.0556434,-.2040259,1.0572252]),i=new Float32Array([1,1,1]),n=new Float32Array(3),s=new Float32Array(3),o=new Float32Array(3);function matrixProduct(e,t,r){r[0]=e[0]*t[0]+e[1]*t[1]+e[2]*t[2];r[1]=e[3]*t[0]+e[4]*t[1]+e[5]*t[2];r[2]=e[6]*t[0]+e[7]*t[1]+e[8]*t[2]}function sRGBTransferFunction(e){return e<=.0031308?adjustToRange(0,1,12.92*e):e>=.99554525?1:adjustToRange(0,1,1.055*e**(1/2.4)-.055)}function adjustToRange(e,t,r){return Math.max(e,Math.min(t,r))}function decodeL(e){return e<0?-decodeL(-e):e>8?((e+16)/116)**3:.0011070564598794539*e}function convertToRgb(a,c,l,h,u,d){const f=adjustToRange(0,1,c[l]*d),g=adjustToRange(0,1,c[l+1]*d),p=adjustToRange(0,1,c[l+2]*d),m=1===f?1:f**a.GR,b=1===g?1:g**a.GG,y=1===p?1:p**a.GB,w=a.MXA*m+a.MXB*b+a.MXC*y,S=a.MYA*m+a.MYB*b+a.MYC*y,v=a.MZA*m+a.MZB*b+a.MZC*y,k=s;k[0]=w;k[1]=S;k[2]=v;const x=o;!function normalizeWhitePointToFlat(r,a,i){if(1===r[0]&&1===r[2]){i[0]=a[0];i[1]=a[1];i[2]=a[2];return}const s=i;matrixProduct(e,a,s);const o=n;!function convertToFlat(e,t,r){r[0]=1*t[0]/e[0];r[1]=1*t[1]/e[1];r[2]=1*t[2]/e[2]}(r,s,o);matrixProduct(t,o,i)}(a.whitePoint,k,x);const C=s;!function compensateBlackPoint(e,t,r){if(0===e[0]&&0===e[1]&&0===e[2]){r[0]=t[0];r[1]=t[1];r[2]=t[2];return}const a=decodeL(0),i=(1-a)/(1-decodeL(e[0])),n=1-i,s=(1-a)/(1-decodeL(e[1])),o=1-s,c=(1-a)/(1-decodeL(e[2])),l=1-c;r[0]=t[0]*i+n;r[1]=t[1]*s+o;r[2]=t[2]*c+l}(a.blackPoint,x,C);const O=o;!function normalizeWhitePointToD65(r,a,i){const s=i;matrixProduct(e,a,s);const o=n;!function convertToD65(e,t,r){r[0]=.95047*t[0]/e[0];r[1]=1*t[1]/e[1];r[2]=1.08883*t[2]/e[2]}(r,s,o);matrixProduct(t,o,i)}(i,C,O);const F=s;matrixProduct(r,O,F);h[u]=255*sRGBTransferFunction(F[0]);h[u+1]=255*sRGBTransferFunction(F[1]);h[u+2]=255*sRGBTransferFunction(F[2])}return class CalRGBCS extends ColorSpace{constructor(e,t,r,i){super("CalRGB",3);if(!e)throw new a.FormatError("WhitePoint missing - required for color space CalRGB");t=t||new Float32Array(3);r=r||new Float32Array([1,1,1]);i=i||new Float32Array([1,0,0,0,1,0,0,0,1]);const n=e[0],s=e[1],o=e[2];this.whitePoint=e;const c=t[0],l=t[1],h=t[2];this.blackPoint=t;this.GR=r[0];this.GG=r[1];this.GB=r[2];this.MXA=i[0];this.MYA=i[1];this.MZA=i[2];this.MXB=i[3];this.MYB=i[4];this.MZB=i[5];this.MXC=i[6];this.MYC=i[7];this.MZC=i[8];if(n<0||o<0||1!==s)throw new a.FormatError(`Invalid WhitePoint components for ${this.name}, no fallback available`);if(c<0||l<0||h<0){(0,a.info)(`Invalid BlackPoint for ${this.name} [${c}, ${l}, ${h}], falling back to default.`);this.blackPoint=new Float32Array(3)}if(this.GR<0||this.GG<0||this.GB<0){(0,a.info)(`Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for ${this.name}, falling back to default.`);this.GR=this.GG=this.GB=1}}getRgbItem(e,t,r,a){convertToRgb(this,e,t,r,a,1)}getRgbBuffer(e,t,r,a,i,n,s){const o=1/((1<<n)-1);for(let n=0;n<r;++n){convertToRgb(this,e,t,a,i,o);t+=3;i+=3+s}}getOutputLength(e,t){return e*(3+t)/3|0}}}(),l=function LabCSClosure(){function fn_g(e){let t;t=e>=6/29?e**3:108/841*(e-4/29);return t}function decode(e,t,r,a){return r+e*(a-r)/t}function convertToRgb(e,t,r,a,i,n){let s=t[r],o=t[r+1],c=t[r+2];if(!1!==a){s=decode(s,a,0,100);o=decode(o,a,e.amin,e.amax);c=decode(c,a,e.bmin,e.bmax)}o>e.amax?o=e.amax:o<e.amin&&(o=e.amin);c>e.bmax?c=e.bmax:c<e.bmin&&(c=e.bmin);const l=(s+16)/116,h=l+o/500,u=l-c/200,d=e.XW*fn_g(h),f=e.YW*fn_g(l),g=e.ZW*fn_g(u);let p,m,b;if(e.ZW<1){p=3.1339*d+-1.617*f+-.4906*g;m=-.9785*d+1.916*f+.0333*g;b=.072*d+-.229*f+1.4057*g}else{p=3.2406*d+-1.5372*f+-.4986*g;m=-.9689*d+1.8758*f+.0415*g;b=.0557*d+-.204*f+1.057*g}i[n]=255*Math.sqrt(p);i[n+1]=255*Math.sqrt(m);i[n+2]=255*Math.sqrt(b)}return class LabCS extends ColorSpace{constructor(e,t,r){super("Lab",3);if(!e)throw new a.FormatError("WhitePoint missing - required for color space Lab");t=t||[0,0,0];r=r||[-100,100,-100,100];this.XW=e[0];this.YW=e[1];this.ZW=e[2];this.amin=r[0];this.amax=r[1];this.bmin=r[2];this.bmax=r[3];this.XB=t[0];this.YB=t[1];this.ZB=t[2];if(this.XW<0||this.ZW<0||1!==this.YW)throw new a.FormatError("Invalid WhitePoint components, no fallback available");if(this.XB<0||this.YB<0||this.ZB<0){(0,a.info)("Invalid BlackPoint, falling back to default");this.XB=this.YB=this.ZB=0}if(this.amin>this.amax||this.bmin>this.bmax){(0,a.info)("Invalid Range, falling back to defaults");this.amin=-100;this.amax=100;this.bmin=-100;this.bmax=100}}getRgbItem(e,t,r,a){convertToRgb(this,e,t,!1,r,a)}getRgbBuffer(e,t,r,a,i,n,s){const o=(1<<n)-1;for(let n=0;n<r;n++){convertToRgb(this,e,t,o,a,i);t+=3;i+=3+s}}getOutputLength(e,t){return e*(3+t)/3|0}isDefaultDecode(e,t){return!0}get usesZeroToOneRange(){return(0,a.shadow)(this,"usesZeroToOneRange",!1)}}}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.LocalTilingPatternCache=t.LocalImageCache=t.LocalGStateCache=t.LocalFunctionCache=t.LocalColorSpaceCache=t.GlobalImageCache=void 0;var a=r(2),i=r(5);class BaseLocalCache{constructor(e){this.constructor===BaseLocalCache&&(0,a.unreachable)("Cannot initialize BaseLocalCache.");if(!e||!e.onlyRefs){this._nameRefMap=new Map;this._imageMap=new Map}this._imageCache=new i.RefSetCache}getByName(e){const t=this._nameRefMap.get(e);return t?this.getByRef(t):this._imageMap.get(e)||null}getByRef(e){return this._imageCache.get(e)||null}set(e,t,r){(0,a.unreachable)("Abstract method `set` called.")}}t.LocalImageCache=class LocalImageCache extends BaseLocalCache{set(e,t=null,r){if(!e)throw new Error('LocalImageCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;this._nameRefMap.set(e,t);this._imageCache.put(t,r)}else this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalColorSpaceCache=class LocalColorSpaceCache extends BaseLocalCache{set(e=null,t=null,r){if(!e&&!t)throw new Error('LocalColorSpaceCache.set - expected "name" and/or "ref" argument.');if(t){if(this._imageCache.has(t))return;e&&this._nameRefMap.set(e,t);this._imageCache.put(t,r)}else this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalFunctionCache=class LocalFunctionCache extends BaseLocalCache{constructor(e){super({onlyRefs:!0})}getByName(e){(0,a.unreachable)("Should not call `getByName` method.")}set(e=null,t,r){if(!t)throw new Error('LocalFunctionCache.set - expected "ref" argument.');this._imageCache.has(t)||this._imageCache.put(t,r)}};t.LocalGStateCache=class LocalGStateCache extends BaseLocalCache{set(e,t=null,r){if(!e)throw new Error('LocalGStateCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;this._nameRefMap.set(e,t);this._imageCache.put(t,r)}else this._imageMap.has(e)||this._imageMap.set(e,r)}};t.LocalTilingPatternCache=class LocalTilingPatternCache extends BaseLocalCache{set(e,t=null,r){if(!e)throw new Error('LocalTilingPatternCache.set - expected "name" argument.');if(t){if(this._imageCache.has(t))return;this._nameRefMap.set(e,t);this._imageCache.put(t,r)}else this._imageMap.has(e)||this._imageMap.set(e,r)}};class GlobalImageCache{static get NUM_PAGES_THRESHOLD(){return(0,a.shadow)(this,"NUM_PAGES_THRESHOLD",2)}static get MIN_IMAGES_TO_CACHE(){return(0,a.shadow)(this,"MIN_IMAGES_TO_CACHE",10)}static get MAX_BYTE_SIZE(){return(0,a.shadow)(this,"MAX_BYTE_SIZE",4e7)}constructor(){this._refCache=new i.RefSetCache;this._imageCache=new i.RefSetCache}get _byteSize(){let e=0;this._imageCache.forEach((t=>{e+=t.byteSize}));return e}get _cacheLimitReached(){return!(this._imageCache.size<GlobalImageCache.MIN_IMAGES_TO_CACHE)&&!(this._byteSize<GlobalImageCache.MAX_BYTE_SIZE)}shouldCache(e,t){const r=this._refCache.get(e);return!((r?r.size+(r.has(t)?0:1):1)<GlobalImageCache.NUM_PAGES_THRESHOLD)&&!(!this._imageCache.has(e)&&this._cacheLimitReached)}addPageIndex(e,t){let r=this._refCache.get(e);if(!r){r=new Set;this._refCache.put(e,r)}r.add(t)}addByteSize(e,t){const r=this._imageCache.get(e);r&&(r.byteSize||(r.byteSize=t))}getData(e,t){const r=this._refCache.get(e);if(!r)return null;if(r.size<GlobalImageCache.NUM_PAGES_THRESHOLD)return null;const a=this._imageCache.get(e);if(!a)return null;r.add(t);return a}setData(e,t){if(!this._refCache.has(e))throw new Error('GlobalImageCache.setData - expected "addPageIndex" to have been called.');this._imageCache.has(e)||(this._cacheLimitReached?(0,a.warn)("GlobalImageCache.setData - cache limit reached."):this._imageCache.put(e,t))}clear(e=!1){e||this._refCache.clear();this._imageCache.clear()}}t.GlobalImageCache=GlobalImageCache},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.MetadataParser=void 0;var a=r(26);t.MetadataParser=class MetadataParser{constructor(e){e=this._repair(e);const t=new a.SimpleXMLParser({lowerCaseName:!0}).parseFromString(e);this._metadataMap=new Map;this._data=e;t&&this._parse(t)}_repair(e){return e.replace(/^[^<]+/,"").replace(/>\\376\\377([^<]+)/g,(function(e,t){const r=t.replace(/\\([0-3])([0-7])([0-7])/g,(function(e,t,r,a){return String.fromCharCode(64*t+8*r+1*a)})).replace(/&(amp|apos|gt|lt|quot);/g,(function(e,t){switch(t){case"amp":return"&";case"apos":return"'";case"gt":return">";case"lt":return"<";case"quot":return'"'}throw new Error(`_repair: ${t} isn't defined.`)})),a=[];for(let e=0,t=r.length;e<t;e+=2){const t=256*r.charCodeAt(e)+r.charCodeAt(e+1);t>=32&&t<127&&60!==t&&62!==t&&38!==t?a.push(String.fromCharCode(t)):a.push("&#x"+(65536+t).toString(16).substring(1)+";")}return">"+a.join("")}))}_getSequence(e){const t=e.nodeName;return"rdf:bag"!==t&&"rdf:seq"!==t&&"rdf:alt"!==t?null:e.childNodes.filter((e=>"rdf:li"===e.nodeName))}_parseArray(e){if(!e.hasChildNodes())return;const[t]=e.childNodes,r=this._getSequence(t)||[];this._metadataMap.set(e.nodeName,r.map((e=>e.textContent.trim())))}_parse(e){let t=e.documentElement;if("rdf:rdf"!==t.nodeName){t=t.firstChild;for(;t&&"rdf:rdf"!==t.nodeName;)t=t.nextSibling}if(t&&"rdf:rdf"===t.nodeName&&t.hasChildNodes())for(const e of t.childNodes)if("rdf:description"===e.nodeName)for(const t of e.childNodes){const e=t.nodeName;switch(e){case"#text":continue;case"dc:creator":case"dc:subject":this._parseArray(t);continue}this._metadataMap.set(e,t.textContent.trim())}}get serializable(){return{parsedData:this._metadataMap,rawData:this._data}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XMLParserErrorCode=t.XMLParserBase=t.SimpleXMLParser=t.SimpleDOMNode=void 0;var a=r(8);const i={NoError:0,EndOfDocument:-1,UnterminatedCdat:-2,UnterminatedXmlDeclaration:-3,UnterminatedDoctypeDeclaration:-4,UnterminatedComment:-5,MalformedElement:-6,OutOfMemory:-7,UnterminatedAttributeValue:-8,UnterminatedElement:-9,ElementNeverBegun:-10};t.XMLParserErrorCode=i;function isWhitespace(e,t){const r=e[t];return" "===r||"\n"===r||"\r"===r||"\t"===r}class XMLParserBase{_resolveEntities(e){return e.replace(/&([^;]+);/g,((e,t)=>{if("#x"===t.substring(0,2))return String.fromCodePoint(parseInt(t.substring(2),16));if("#"===t.substring(0,1))return String.fromCodePoint(parseInt(t.substring(1),10));switch(t){case"lt":return"<";case"gt":return">";case"amp":return"&";case"quot":return'"';case"apos":return"'"}return this.onResolveEntity(t)}))}_parseContent(e,t){const r=[];let a=t;function skipWs(){for(;a<e.length&&isWhitespace(e,a);)++a}for(;a<e.length&&!isWhitespace(e,a)&&">"!==e[a]&&"/"!==e[a];)++a;const i=e.substring(t,a);skipWs();for(;a<e.length&&">"!==e[a]&&"/"!==e[a]&&"?"!==e[a];){skipWs();let t="",i="";for(;a<e.length&&!isWhitespace(e,a)&&"="!==e[a];){t+=e[a];++a}skipWs();if("="!==e[a])return null;++a;skipWs();const n=e[a];if('"'!==n&&"'"!==n)return null;const s=e.indexOf(n,++a);if(s<0)return null;i=e.substring(a,s);r.push({name:t,value:this._resolveEntities(i)});a=s+1;skipWs()}return{name:i,attributes:r,parsed:a-t}}_parseProcessingInstruction(e,t){let r=t;for(;r<e.length&&!isWhitespace(e,r)&&">"!==e[r]&&"/"!==e[r];)++r;const a=e.substring(t,r);!function skipWs(){for(;r<e.length&&isWhitespace(e,r);)++r}();const i=r;for(;r<e.length&&("?"!==e[r]||">"!==e[r+1]);)++r;return{name:a,value:e.substring(i,r),parsed:r-t}}parseXml(e){let t=0;for(;t<e.length;){let r=t;if("<"===e[t]){++r;let t;switch(e[r]){case"/":++r;t=e.indexOf(">",r);if(t<0){this.onError(i.UnterminatedElement);return}this.onEndElement(e.substring(r,t));r=t+1;break;case"?":++r;const a=this._parseProcessingInstruction(e,r);if("?>"!==e.substring(r+a.parsed,r+a.parsed+2)){this.onError(i.UnterminatedXmlDeclaration);return}this.onPi(a.name,a.value);r+=a.parsed+2;break;case"!":if("--"===e.substring(r+1,r+3)){t=e.indexOf("--\x3e",r+3);if(t<0){this.onError(i.UnterminatedComment);return}this.onComment(e.substring(r+3,t));r=t+3}else if("[CDATA["===e.substring(r+1,r+8)){t=e.indexOf("]]>",r+8);if(t<0){this.onError(i.UnterminatedCdat);return}this.onCdata(e.substring(r+8,t));r=t+3}else{if("DOCTYPE"!==e.substring(r+1,r+8)){this.onError(i.MalformedElement);return}{const a=e.indexOf("[",r+8);let n=!1;t=e.indexOf(">",r+8);if(t<0){this.onError(i.UnterminatedDoctypeDeclaration);return}if(a>0&&t>a){t=e.indexOf("]>",r+8);if(t<0){this.onError(i.UnterminatedDoctypeDeclaration);return}n=!0}const s=e.substring(r+8,t+(n?1:0));this.onDoctype(s);r=t+(n?2:1)}}break;default:const n=this._parseContent(e,r);if(null===n){this.onError(i.MalformedElement);return}let s=!1;if("/>"===e.substring(r+n.parsed,r+n.parsed+2))s=!0;else if(">"!==e.substring(r+n.parsed,r+n.parsed+1)){this.onError(i.UnterminatedElement);return}this.onBeginElement(n.name,n.attributes,s);r+=n.parsed+(s?2:1)}}else{for(;r<e.length&&"<"!==e[r];)r++;const a=e.substring(t,r);this.onText(this._resolveEntities(a))}t=r}}onResolveEntity(e){return`&${e};`}onPi(e,t){}onComment(e){}onCdata(e){}onDoctype(e){}onText(e){}onBeginElement(e,t,r){}onEndElement(e){}onError(e){}}t.XMLParserBase=XMLParserBase;class SimpleDOMNode{constructor(e,t){this.nodeName=e;this.nodeValue=t;Object.defineProperty(this,"parentNode",{value:null,writable:!0})}get firstChild(){return this.childNodes&&this.childNodes[0]}get nextSibling(){const e=this.parentNode.childNodes;if(!e)return;const t=e.indexOf(this);return-1!==t?e[t+1]:void 0}get textContent(){return this.childNodes?this.childNodes.map((function(e){return e.textContent})).join(""):this.nodeValue||""}hasChildNodes(){return this.childNodes&&this.childNodes.length>0}searchNode(e,t){if(t>=e.length)return this;const r=e[t],a=[];let i=this;for(;;){if(r.name===i.nodeName){if(0!==r.pos){if(0===a.length)return null;{const[n]=a.pop();let s=0;for(const a of n.childNodes)if(r.name===a.nodeName){if(s===r.pos)return a.searchNode(e,t+1);s++}return i.searchNode(e,t+1)}}{const r=i.searchNode(e,t+1);if(null!==r)return r}}if(i.childNodes&&0!==i.childNodes.length){a.push([i,0]);i=i.childNodes[0]}else{if(0===a.length)return null;for(;0!==a.length;){const[e,t]=a.pop(),r=t+1;if(r<e.childNodes.length){a.push([e,r]);i=e.childNodes[r];break}}if(0===a.length)return null}}}dump(e){if("#text"!==this.nodeName){e.push(`<${this.nodeName}`);if(this.attributes)for(const t of this.attributes)e.push(` ${t.name}="${(0,a.encodeToXmlString)(t.value)}"`);if(this.hasChildNodes()){e.push(">");for(const t of this.childNodes)t.dump(e);e.push(`</${this.nodeName}>`)}else this.nodeValue?e.push(`>${(0,a.encodeToXmlString)(this.nodeValue)}</${this.nodeName}>`):e.push("/>")}else e.push((0,a.encodeToXmlString)(this.nodeValue))}}t.SimpleDOMNode=SimpleDOMNode;t.SimpleXMLParser=class SimpleXMLParser extends XMLParserBase{constructor({hasAttributes:e=!1,lowerCaseName:t=!1}){super();this._currentFragment=null;this._stack=null;this._errorCode=i.NoError;this._hasAttributes=e;this._lowerCaseName=t}parseFromString(e){this._currentFragment=[];this._stack=[];this._errorCode=i.NoError;this.parseXml(e);if(this._errorCode!==i.NoError)return;const[t]=this._currentFragment;return t?{documentElement:t}:void 0}onText(e){if(function isWhitespaceString(e){for(let t=0,r=e.length;t<r;t++)if(!isWhitespace(e,t))return!1;return!0}(e))return;const t=new SimpleDOMNode("#text",e);this._currentFragment.push(t)}onCdata(e){const t=new SimpleDOMNode("#text",e);this._currentFragment.push(t)}onBeginElement(e,t,r){this._lowerCaseName&&(e=e.toLowerCase());const a=new SimpleDOMNode(e);a.childNodes=[];this._hasAttributes&&(a.attributes=t);this._currentFragment.push(a);if(!r){this._stack.push(this._currentFragment);this._currentFragment=a.childNodes}}onEndElement(e){this._currentFragment=this._stack.pop()||[];const t=this._currentFragment[this._currentFragment.length-1];if(t)for(let e=0,r=t.childNodes.length;e<r;e++)t.childNodes[e].parentNode=t}onError(e){this._errorCode=e}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getQuadPoints=getQuadPoints;t.MarkupAnnotation=t.AnnotationFactory=t.AnnotationBorderStyle=t.Annotation=void 0;var a=r(2),i=r(10),n=r(8),s=r(28),o=r(5),c=r(23),l=r(46),h=r(12),u=r(48);t.AnnotationFactory=class AnnotationFactory{static create(e,t,r,a,i){return r.ensureCatalog("acroForm").then((n=>r.ensure(this,"_create",[e,t,r,a,n,i])))}static _create(e,t,r,i,s,c){const l=e.fetchIfRef(t);if(!(0,o.isDict)(l))return;const h=(0,o.isRef)(t)?t.toString():`annot_${i.createObjId()}`;let u=l.get("Subtype");u=(0,o.isName)(u)?u.name:null;const d={xref:e,ref:t,dict:l,subtype:u,id:h,pdfManager:r,acroForm:s instanceof o.Dict?s:o.Dict.empty,collectFields:c};switch(u){case"Link":return new LinkAnnotation(d);case"Text":return new TextAnnotation(d);case"Widget":let e=(0,n.getInheritableProperty)({dict:l,key:"FT"});e=(0,o.isName)(e)?e.name:null;switch(e){case"Tx":return new TextWidgetAnnotation(d);case"Btn":return new ButtonWidgetAnnotation(d);case"Ch":return new ChoiceWidgetAnnotation(d)}(0,a.warn)(`Unimplemented widget field type "${e}", falling back to base field type.`);return new WidgetAnnotation(d);case"Popup":return new PopupAnnotation(d);case"FreeText":return new FreeTextAnnotation(d);case"Line":return new LineAnnotation(d);case"Square":return new SquareAnnotation(d);case"Circle":return new CircleAnnotation(d);case"PolyLine":return new PolylineAnnotation(d);case"Polygon":return new PolygonAnnotation(d);case"Caret":return new CaretAnnotation(d);case"Ink":return new InkAnnotation(d);case"Highlight":return new HighlightAnnotation(d);case"Underline":return new UnderlineAnnotation(d);case"Squiggly":return new SquigglyAnnotation(d);case"StrikeOut":return new StrikeOutAnnotation(d);case"Stamp":return new StampAnnotation(d);case"FileAttachment":return new FileAttachmentAnnotation(d);default:c||(u?(0,a.warn)(`Unimplemented annotation type "${u}", falling back to base annotation.`):(0,a.warn)("Annotation is missing the required /Subtype."));return new Annotation(d)}}};function getRgbColor(e){const t=new Uint8ClampedArray(3);if(!Array.isArray(e))return t;switch(e.length){case 0:return null;case 1:c.ColorSpace.singletons.gray.getRgbItem(e,0,t,0);return t;case 3:c.ColorSpace.singletons.rgb.getRgbItem(e,0,t,0);return t;case 4:c.ColorSpace.singletons.cmyk.getRgbItem(e,0,t,0);return t;default:return t}}function getQuadPoints(e,t){if(!e.has("QuadPoints"))return null;const r=e.getArray("QuadPoints");if(!Array.isArray(r)||0===r.length||r.length%8>0)return null;const a=[];for(let e=0,i=r.length/8;e<i;e++){a.push([]);for(let i=8*e,n=8*e+8;i<n;i+=2){const n=r[i],s=r[i+1];if(null!==t&&(n<t[0]||n>t[2]||s<t[1]||s>t[3]))return null;a[e].push({x:n,y:s})}}return a.map((e=>{const[t,r,a,i]=e.reduce((([e,t,r,a],i)=>[Math.min(e,i.x),Math.max(t,i.x),Math.min(r,i.y),Math.max(a,i.y)]),[Number.MAX_VALUE,Number.MIN_VALUE,Number.MAX_VALUE,Number.MIN_VALUE]);return[{x:t,y:i},{x:r,y:i},{x:t,y:a},{x:r,y:a}]}))}function getTransformMatrix(e,t,r){const[i,n,s,o]=a.Util.getAxialAlignedBoundingBox(t,r);if(i===s||n===o)return[1,0,0,1,e[0],e[1]];const c=(e[2]-e[0])/(s-i),l=(e[3]-e[1])/(o-n);return[c,0,0,l,e[0]-i*c,e[1]-n*l]}class Annotation{constructor(e){const t=e.dict;this.setContents(t.get("Contents"));this.setModificationDate(t.get("M"));this.setFlags(t.get("F"));this.setRectangle(t.getArray("Rect"));this.setColor(t.getArray("C"));this.setBorderStyle(t);this.setAppearance(t);this._streams=[];this.appearance&&this._streams.push(this.appearance);this.data={annotationFlags:this.flags,borderStyle:this.borderStyle,color:this.color,contents:this.contents,hasAppearance:!!this.appearance,id:e.id,modificationDate:this.modificationDate,rect:this.rectangle,subtype:e.subtype};if(e.collectFields){const r=t.get("Kids");if(Array.isArray(r)){const e=[];for(const t of r)(0,o.isRef)(t)&&e.push(t.toString());0!==e.length&&(this.data.kidIds=e)}this.data.actions=(0,n.collectActions)(e.xref,t,a.AnnotationActionEventType);this.data.fieldName=this._constructFieldName(t)}this._fallbackFontDict=null}_hasFlag(e,t){return!!(e&t)}_isViewable(e){return!this._hasFlag(e,a.AnnotationFlag.INVISIBLE)&&!this._hasFlag(e,a.AnnotationFlag.NOVIEW)}_isPrintable(e){return this._hasFlag(e,a.AnnotationFlag.PRINT)&&!this._hasFlag(e,a.AnnotationFlag.INVISIBLE)}isHidden(e){const t=e&&e.get(this.data.id);return t&&void 0!==t.hidden?t.hidden:this._hasFlag(this.flags,a.AnnotationFlag.HIDDEN)}get viewable(){return null!==this.data.quadPoints&&(0===this.flags||this._isViewable(this.flags))}get printable(){return null!==this.data.quadPoints&&(0!==this.flags&&this._isPrintable(this.flags))}setContents(e){this.contents=(0,a.stringToPDFString)(e||"")}setModificationDate(e){this.modificationDate=(0,a.isString)(e)?e:null}setFlags(e){this.flags=Number.isInteger(e)&&e>0?e:0}hasFlag(e){return this._hasFlag(this.flags,e)}setRectangle(e){Array.isArray(e)&&4===e.length?this.rectangle=a.Util.normalizeRect(e):this.rectangle=[0,0,0,0]}setColor(e){this.color=getRgbColor(e)}setBorderStyle(e){this.borderStyle=new AnnotationBorderStyle;if((0,o.isDict)(e))if(e.has("BS")){const t=e.get("BS"),r=t.get("Type");if(!r||(0,o.isName)(r,"Border")){this.borderStyle.setWidth(t.get("W"),this.rectangle);this.borderStyle.setStyle(t.get("S"));this.borderStyle.setDashArray(t.getArray("D"))}}else if(e.has("Border")){const t=e.getArray("Border");if(Array.isArray(t)&&t.length>=3){this.borderStyle.setHorizontalCornerRadius(t[0]);this.borderStyle.setVerticalCornerRadius(t[1]);this.borderStyle.setWidth(t[2],this.rectangle);4===t.length&&this.borderStyle.setDashArray(t[3])}}else this.borderStyle.setWidth(0)}setAppearance(e){this.appearance=null;const t=e.get("AP");if(!(0,o.isDict)(t))return;const r=t.get("N");if((0,o.isStream)(r)){this.appearance=r;return}if(!(0,o.isDict)(r))return;const a=e.get("AS");(0,o.isName)(a)&&r.has(a.name)&&(this.appearance=r.get(a.name))}loadResources(e){return this.appearance.dict.getAsync("Resources").then((t=>{if(!t)return;return new i.ObjectLoader(t,e,t.xref).load().then((function(){return t}))}))}getOperatorList(e,t,r,i){if(!this.appearance)return Promise.resolve(new l.OperatorList);const n=this.appearance,s=this.data,o=n.dict,c=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),h=o.getArray("BBox")||[0,0,1,1],u=o.getArray("Matrix")||[1,0,0,1,0,0],d=getTransformMatrix(s.rect,h,u);return c.then((r=>{const i=new l.OperatorList;i.addOp(a.OPS.beginAnnotation,[s.rect,d,u]);return e.getOperatorList({stream:n,task:t,resources:r,operatorList:i,fallbackFontDict:this._fallbackFontDict}).then((()=>{i.addOp(a.OPS.endAnnotation,[]);this.reset();return i}))}))}async save(e,t,r){return null}getFieldObject(){return this.data.kidIds?{id:this.data.id,actions:this.data.actions,name:this.data.fieldName,type:"",kidIds:this.data.kidIds}:null}reset(){for(const e of this._streams)e.reset()}_constructFieldName(e){if(!e.has("T")&&!e.has("Parent")){(0,a.warn)("Unknown field name, falling back to empty field name.");return""}if(!e.has("Parent"))return(0,a.stringToPDFString)(e.get("T"));const t=[];e.has("T")&&t.unshift((0,a.stringToPDFString)(e.get("T")));let r=e;const i=new o.RefSet;e.objId&&i.put(e.objId);for(;r.has("Parent");){r=r.get("Parent");if(!(r instanceof o.Dict)||r.objId&&i.has(r.objId))break;r.objId&&i.put(r.objId);r.has("T")&&t.unshift((0,a.stringToPDFString)(r.get("T")))}return t.join(".")}}t.Annotation=Annotation;class AnnotationBorderStyle{constructor(){this.width=1;this.style=a.AnnotationBorderStyleType.SOLID;this.dashArray=[3];this.horizontalCornerRadius=0;this.verticalCornerRadius=0}setWidth(e,t=[0,0,0,0]){if((0,o.isName)(e))this.width=0;else if(Number.isInteger(e)){if(e>0){const r=(t[2]-t[0])/2,i=(t[3]-t[1])/2;if(r>0&&i>0&&(e>r||e>i)){(0,a.warn)(`AnnotationBorderStyle.setWidth - ignoring width: ${e}`);e=1}}this.width=e}}setStyle(e){if((0,o.isName)(e))switch(e.name){case"S":this.style=a.AnnotationBorderStyleType.SOLID;break;case"D":this.style=a.AnnotationBorderStyleType.DASHED;break;case"B":this.style=a.AnnotationBorderStyleType.BEVELED;break;case"I":this.style=a.AnnotationBorderStyleType.INSET;break;case"U":this.style=a.AnnotationBorderStyleType.UNDERLINE}}setDashArray(e){if(Array.isArray(e)&&e.length>0){let t=!0,r=!0;for(const a of e){if(!(+a>=0)){t=!1;break}a>0&&(r=!1)}t&&!r?this.dashArray=e:this.width=0}else e&&(this.width=0)}setHorizontalCornerRadius(e){Number.isInteger(e)&&(this.horizontalCornerRadius=e)}setVerticalCornerRadius(e){Number.isInteger(e)&&(this.verticalCornerRadius=e)}}t.AnnotationBorderStyle=AnnotationBorderStyle;class MarkupAnnotation extends Annotation{constructor(e){super(e);const t=e.dict;if(t.has("IRT")){const e=t.getRaw("IRT");this.data.inReplyTo=(0,o.isRef)(e)?e.toString():null;const r=t.get("RT");this.data.replyType=(0,o.isName)(r)?r.name:a.AnnotationReplyType.REPLY}if(this.data.replyType===a.AnnotationReplyType.GROUP){const e=t.get("IRT");this.data.title=(0,a.stringToPDFString)(e.get("T")||"");this.setContents(e.get("Contents"));this.data.contents=this.contents;if(e.has("CreationDate")){this.setCreationDate(e.get("CreationDate"));this.data.creationDate=this.creationDate}else this.data.creationDate=null;if(e.has("M")){this.setModificationDate(e.get("M"));this.data.modificationDate=this.modificationDate}else this.data.modificationDate=null;this.data.hasPopup=e.has("Popup");if(e.has("C")){this.setColor(e.getArray("C"));this.data.color=this.color}else this.data.color=null}else{this.data.title=(0,a.stringToPDFString)(t.get("T")||"");this.setCreationDate(t.get("CreationDate"));this.data.creationDate=this.creationDate;this.data.hasPopup=t.has("Popup");t.has("C")||(this.data.color=null)}}setCreationDate(e){this.creationDate=(0,a.isString)(e)?e:null}_setDefaultAppearance({xref:e,extra:t,strokeColor:r,fillColor:a,blendMode:i,pointsCallback:n}){let s=Number.MAX_VALUE,c=Number.MAX_VALUE,l=Number.MIN_VALUE,u=Number.MIN_VALUE;const d=["q"];t&&d.push(t);r&&d.push(`${r[0]} ${r[1]} ${r[2]} RG`);a&&d.push(`${a[0]} ${a[1]} ${a[2]} rg`);let f=this.data.quadPoints;f||(f=[[{x:this.rectangle[0],y:this.rectangle[3]},{x:this.rectangle[2],y:this.rectangle[3]},{x:this.rectangle[0],y:this.rectangle[1]},{x:this.rectangle[2],y:this.rectangle[1]}]]);for(const e of f){const[t,r,a,i]=n(d,e);s=Math.min(s,t);l=Math.max(l,r);c=Math.min(c,a);u=Math.max(u,i)}d.push("Q");const g=new o.Dict(e),p=new o.Dict(e);p.set("Subtype",o.Name.get("Form"));const m=new h.StringStream(d.join(" "));m.dict=p;g.set("Fm0",m);const b=new o.Dict(e);i&&b.set("BM",o.Name.get(i));const y=new o.Dict(e);y.set("GS0",b);const w=new o.Dict(e);w.set("ExtGState",y);w.set("XObject",g);const S=new o.Dict(e);S.set("Resources",w);const v=this.data.rect=[s,c,l,u];S.set("BBox",v);this.appearance=new h.StringStream("/GS0 gs /Fm0 Do");this.appearance.dict=S;this._streams.push(this.appearance,m)}}t.MarkupAnnotation=MarkupAnnotation;class WidgetAnnotation extends Annotation{constructor(e){super(e);const t=e.dict,r=this.data;this.ref=e.ref;r.annotationType=a.AnnotationType.WIDGET;void 0===r.fieldName&&(r.fieldName=this._constructFieldName(t));void 0===r.actions&&(r.actions=(0,n.collectActions)(e.xref,t,a.AnnotationActionEventType));const i=(0,n.getInheritableProperty)({dict:t,key:"V",getArray:!0});r.fieldValue=this._decodeFormValue(i);const c=(0,n.getInheritableProperty)({dict:t,key:"DV",getArray:!0});r.defaultFieldValue=this._decodeFormValue(c);r.alternativeText=(0,a.stringToPDFString)(t.get("TU")||"");const l=(0,n.getInheritableProperty)({dict:t,key:"DA"})||e.acroForm.get("DA");this._defaultAppearance=(0,a.isString)(l)?l:"";r.defaultAppearanceData=(0,s.parseDefaultAppearance)(this._defaultAppearance);const h=(0,n.getInheritableProperty)({dict:t,key:"FT"});r.fieldType=(0,o.isName)(h)?h.name:null;const u=(0,n.getInheritableProperty)({dict:t,key:"DR"}),d=e.acroForm.get("DR"),f=this.appearance&&this.appearance.dict.get("Resources");this._fieldResources={localResources:u,acroFormResources:d,appearanceResources:f,mergedResources:o.Dict.merge({xref:e.xref,dictArray:[u,f,d],mergeSubDicts:!0})};r.fieldFlags=(0,n.getInheritableProperty)({dict:t,key:"Ff"});(!Number.isInteger(r.fieldFlags)||r.fieldFlags<0)&&(r.fieldFlags=0);r.readOnly=this.hasFieldFlag(a.AnnotationFieldFlag.READONLY);r.hidden=this._hasFlag(r.annotationFlags,a.AnnotationFlag.HIDDEN);if("Sig"===r.fieldType){r.fieldValue=null;this.setFlags(a.AnnotationFlag.HIDDEN);r.hidden=!0}}_decodeFormValue(e){return Array.isArray(e)?e.filter((e=>(0,a.isString)(e))).map((e=>(0,a.stringToPDFString)(e))):(0,o.isName)(e)?(0,a.stringToPDFString)(e.name):(0,a.isString)(e)?(0,a.stringToPDFString)(e):null}hasFieldFlag(e){return!!(this.data.fieldFlags&e)}getOperatorList(e,t,r,i){return r?Promise.resolve(new l.OperatorList):this._hasText?this._getAppearance(e,t,i).then((n=>{if(this.appearance&&null===n)return super.getOperatorList(e,t,r,i);const s=new l.OperatorList;if(!this._defaultAppearance||null===n)return s;const o=[1,0,0,1,0,0],c=[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]],u=getTransformMatrix(this.data.rect,c,o);s.addOp(a.OPS.beginAnnotation,[this.data.rect,u,o]);const d=new h.StringStream(n);return e.getOperatorList({stream:d,task:t,resources:this._fieldResources.mergedResources,operatorList:s}).then((function(){s.addOp(a.OPS.endAnnotation,[]);return s}))})):super.getOperatorList(e,t,r,i)}async save(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(n===this.data.fieldValue||void 0===n)return null;let s=await this._getAppearance(e,t,r);if(null===s)return null;const{xref:c}=e,l=c.fetchIfRef(this.ref);if(!(0,o.isDict)(l))return null;const h=[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]],d={path:(0,a.stringToPDFString)(l.get("T")||""),value:n},f=c.getNewRef(),g=new o.Dict(c);g.set("N",f);const p=c.encrypt;let m=null,b=null;if(p){m=p.createCipherTransform(this.ref.num,this.ref.gen);b=p.createCipherTransform(f.num,f.gen);s=b.encryptString(s)}l.set("V",(0,a.isAscii)(n)?n:(0,a.stringToUTF16BEString)(n));l.set("AP",g);l.set("M",`D:${(0,a.getModificationDate)()}`);const y=new o.Dict(c);y.set("Length",s.length);y.set("Subtype",o.Name.get("Form"));y.set("Resources",this._getSaveFieldResources(c));y.set("BBox",h);const w=[`${this.ref.num} ${this.ref.gen} obj\n`];(0,u.writeDict)(l,w,m);w.push("\nendobj\n");const S=[`${f.num} ${f.gen} obj\n`];(0,u.writeDict)(y,S,b);S.push(" stream\n");S.push(s);S.push("\nendstream\nendobj\n");return[{ref:this.ref,data:w.join(""),xfa:d},{ref:f,data:S.join(""),xfa:null}]}async _getAppearance(e,t,r){const i=this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD);if(!r||i)return null;const n=r.get(this.data.id);let o=n&&n.value;if(void 0===o)return null;o=o.trim();if(""===o)return"";let c=-1;this.data.multiLine&&(c=o.split(/\r\n|\r|\n/).length);const l=this.data.rect[3]-this.data.rect[1],h=this.data.rect[2]-this.data.rect[0];this._defaultAppearance||(this.data.defaultAppearanceData=(0,s.parseDefaultAppearance)(this._defaultAppearance="/Helvetica 0 Tf 0 g"));const[u,d]=this._computeFontSize(l,c),f=await this._getFontData(e,t);let g=f.descent;isNaN(g)&&(g=0);const p=2+Math.abs(g)*d,m=this.data.textAlignment;if(this.data.multiLine)return this._getMultilineAppearance(u,o,f,d,h,l,m,2,p);const b=f.encodeString(o).join("");if(this.data.comb)return this._getCombAppearance(u,f,b,h,2,p);if(0===m||m>2)return"/Tx BMC q BT "+u+` 1 0 0 1 2 ${p} Tm (${(0,a.escapeString)(b)}) Tj ET Q EMC`;return"/Tx BMC q BT "+u+` 1 0 0 1 0 0 Tm ${this._renderText(b,f,d,h,m,2,p)} ET Q EMC`}async _getFontData(e,t){const r=new l.OperatorList,a={font:null,clone(){return this}},{fontName:i,fontSize:n}=this.data.defaultAppearanceData;await e.handleSetFont(this._fieldResources.mergedResources,[i&&o.Name.get(i),n],null,r,t,a,null);return a.font}_computeFontSize(e,t){let{fontSize:r}=this.data.defaultAppearanceData;if(!r){const roundWithOneDigit=e=>Math.round(10*e)/10,a=.8;if(-1===t)r=roundWithOneDigit(a*e);else{r=10;let i=r/a,n=Math.round(e/i);n=Math.max(n,t);i=e/n;r=roundWithOneDigit(a*i)}const{fontName:i,fontColor:n}=this.data.defaultAppearanceData;this._defaultAppearance=(0,s.createDefaultAppearance)({fontSize:r,fontName:i,fontColor:n})}return[this._defaultAppearance,r]}_renderText(e,t,r,i,n,s,o){const c=t.charsToGlyphs(e),l=r/1e3;let h,u=0;for(const e of c)u+=e.width*l;h=1===n?(i-u)/2:2===n?i-u-s:s;h=h.toFixed(2);return`${h} ${o=o.toFixed(2)} Td (${(0,a.escapeString)(e)}) Tj`}_getSaveFieldResources(e){const{localResources:t,appearanceResources:r,acroFormResources:a}=this._fieldResources,i=this.data.defaultAppearanceData&&this.data.defaultAppearanceData.fontName;if(!i)return t||o.Dict.empty;for(const e of[t,r])if(e instanceof o.Dict){const t=e.get("Font");if(t instanceof o.Dict&&t.has(i))return e}if(a instanceof o.Dict){const r=a.get("Font");if(r instanceof o.Dict&&r.has(i)){const a=new o.Dict(e);a.set(i,r.getRaw(i));const n=new o.Dict(e);n.set("Font",a);return o.Dict.merge({xref:e,dictArray:[n,t],mergeSubDicts:!0})}}return t||o.Dict.empty}getFieldObject(){return"Sig"===this.data.fieldType?{id:this.data.id,value:null,type:"signature"}:null}}class TextWidgetAnnotation extends WidgetAnnotation{constructor(e){super(e);this._hasText=!0;const t=e.dict;(0,a.isString)(this.data.fieldValue)||(this.data.fieldValue="");let r=(0,n.getInheritableProperty)({dict:t,key:"Q"});(!Number.isInteger(r)||r<0||r>2)&&(r=null);this.data.textAlignment=r;let i=(0,n.getInheritableProperty)({dict:t,key:"MaxLen"});(!Number.isInteger(i)||i<0)&&(i=null);this.data.maxLen=i;this.data.multiLine=this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE);this.data.comb=this.hasFieldFlag(a.AnnotationFieldFlag.COMB)&&!this.hasFieldFlag(a.AnnotationFieldFlag.MULTILINE)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD)&&!this.hasFieldFlag(a.AnnotationFieldFlag.FILESELECT)&&null!==this.data.maxLen}_getCombAppearance(e,t,r,i,n,s){const o=(i/this.data.maxLen).toFixed(2),c=[],l=t.getCharPositions(r);for(const[e,t]of l)c.push(`(${(0,a.escapeString)(r.substring(e,t))}) Tj`);return"/Tx BMC q BT "+e+` 1 0 0 1 ${n} ${s} Tm ${c.join(` ${o} 0 Td `)} ET Q EMC`}_getMultilineAppearance(e,t,r,a,i,n,s,o,c){const l=t.split(/\r\n|\r|\n/),h=[],u=i-2*o;for(const e of l){const t=this._splitLine(e,r,a,u);for(const e of t){const t=0===h.length?o:0;h.push(this._renderText(e,r,a,i,s,t,-a))}}return"/Tx BMC q BT "+e+` 1 0 0 1 0 ${n} Tm ${h.join("\n")} ET Q EMC`}_splitLine(e,t,r,a){e=t.encodeString(e).join("");const i=t.charsToGlyphs(e);if(i.length<=1)return[e];const n=t.getCharPositions(e),s=r/1e3,o=[];let c=-1,l=-1,h=-1,u=0,d=0;for(let t=0,r=i.length;t<r;t++){const[r,f]=n[t],g=i[t],p=g.width*s;if(" "===g.unicode)if(d+p>a){o.push(e.substring(u,r));u=r;d=p;c=-1;h=-1}else{d+=p;c=r;l=f;h=t}else if(d+p>a)if(-1!==c){o.push(e.substring(u,l));u=l;t=h+1;c=-1;d=0}else{o.push(e.substring(u,r));u=r;d=p}else d+=p}u<e.length&&o.push(e.substring(u,e.length));return o}getFieldObject(){return{id:this.data.id,value:this.data.fieldValue,defaultValue:this.data.defaultFieldValue,multiline:this.data.multiLine,password:this.hasFieldFlag(a.AnnotationFieldFlag.PASSWORD),charLimit:this.data.maxLen,comb:this.data.comb,editable:!this.data.readOnly,hidden:this.data.hidden,name:this.data.fieldName,rect:this.data.rect,actions:this.data.actions,type:"text"}}}class ButtonWidgetAnnotation extends WidgetAnnotation{constructor(e){super(e);this.checkedAppearance=null;this.uncheckedAppearance=null;this.data.checkBox=!this.hasFieldFlag(a.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);this.data.radioButton=this.hasFieldFlag(a.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);this.data.pushButton=this.hasFieldFlag(a.AnnotationFieldFlag.PUSHBUTTON);this.data.isTooltipOnly=!1;this.data.checkBox?this._processCheckBox(e):this.data.radioButton?this._processRadioButton(e):this.data.pushButton?this._processPushButton(e):(0,a.warn)("Invalid field flags for button widget annotation")}getOperatorList(e,t,r,a){if(this.data.pushButton)return super.getOperatorList(e,t,!1,a);if(a){const i=a.get(this.data.id),n=i&&i.value;if(void 0===n)return super.getOperatorList(e,t,r,a);let s;s=n?this.checkedAppearance:this.uncheckedAppearance;if(s){const i=this.appearance;this.appearance=s;const n=super.getOperatorList(e,t,r,a);this.appearance=i;return n}return Promise.resolve(new l.OperatorList)}return super.getOperatorList(e,t,r,a)}async save(e,t,r){return this.data.checkBox?this._saveCheckbox(e,t,r):this.data.radioButton?this._saveRadioButton(e,t,r):null}async _saveCheckbox(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(void 0===n)return null;if((this.data.fieldValue&&"Off"!==this.data.fieldValue)===n)return null;const s=e.xref.fetchIfRef(this.ref);if(!(0,o.isDict)(s))return null;const c={path:(0,a.stringToPDFString)(s.get("T")||""),value:n?this.data.exportValue:""},l=o.Name.get(n?this.data.exportValue:"Off");s.set("V",l);s.set("AS",l);s.set("M",`D:${(0,a.getModificationDate)()}`);const h=e.xref.encrypt;let d=null;h&&(d=h.createCipherTransform(this.ref.num,this.ref.gen));const f=[`${this.ref.num} ${this.ref.gen} obj\n`];(0,u.writeDict)(s,f,d);f.push("\nendobj\n");return[{ref:this.ref,data:f.join(""),xfa:c}]}async _saveRadioButton(e,t,r){if(!r)return null;const i=r.get(this.data.id),n=i&&i.value;if(void 0===n)return null;if(this.data.fieldValue===this.data.buttonValue===n)return null;const s=e.xref.fetchIfRef(this.ref);if(!(0,o.isDict)(s))return null;const c={path:(0,a.stringToPDFString)(s.get("T")||""),value:n?this.data.buttonValue:""},l=o.Name.get(n?this.data.buttonValue:"Off");let h=null;const d=e.xref.encrypt;if(n)if((0,o.isRef)(this.parent)){const t=e.xref.fetch(this.parent);let r=null;d&&(r=d.createCipherTransform(this.parent.num,this.parent.gen));t.set("V",l);h=[`${this.parent.num} ${this.parent.gen} obj\n`];(0,u.writeDict)(t,h,r);h.push("\nendobj\n")}else(0,o.isDict)(this.parent)&&this.parent.set("V",l);s.set("AS",l);s.set("M",`D:${(0,a.getModificationDate)()}`);let f=null;d&&(f=d.createCipherTransform(this.ref.num,this.ref.gen));const g=[`${this.ref.num} ${this.ref.gen} obj\n`];(0,u.writeDict)(s,g,f);g.push("\nendobj\n");const p=[{ref:this.ref,data:g.join(""),xfa:c}];null!==h&&p.push({ref:this.parent,data:h.join(""),xfa:null});return p}_processCheckBox(e){const t=e.dict.get("AP");if(!(0,o.isDict)(t))return;const r=t.get("N");if(!(0,o.isDict)(r))return;const a=r.getKeys();a.includes("Off")||a.push("Off");if(2===a.length){this.data.exportValue="Off"===a[0]?a[1]:a[0];this.checkedAppearance=r.get(this.data.exportValue);this.uncheckedAppearance=r.get("Off")||null;this._streams.push(this.checkedAppearance);this.uncheckedAppearance&&this._streams.push(this.uncheckedAppearance);this._fallbackFontDict=this.fallbackFontDict}}_processRadioButton(e){this.data.fieldValue=this.data.buttonValue=null;const t=e.dict.get("Parent");if((0,o.isDict)(t)){this.parent=e.dict.getRaw("Parent");const r=t.get("V");(0,o.isName)(r)&&(this.data.fieldValue=this._decodeFormValue(r))}const r=e.dict.get("AP");if(!(0,o.isDict)(r))return;const a=r.get("N");if((0,o.isDict)(a)){for(const e of a.getKeys())if("Off"!==e){this.data.buttonValue=this._decodeFormValue(e);break}this.checkedAppearance=a.get(this.data.buttonValue);this.uncheckedAppearance=a.get("Off")||null;this._streams.push(this.checkedAppearance);this.uncheckedAppearance&&this._streams.push(this.uncheckedAppearance);this._fallbackFontDict=this.fallbackFontDict}}_processPushButton(e){if(e.dict.has("A")||e.dict.has("AA")||this.data.alternativeText){this.data.isTooltipOnly=!e.dict.has("A")&&!e.dict.has("AA");i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl})}else(0,a.warn)("Push buttons without action dictionaries are not supported")}getFieldObject(){let e,t="button";if(this.data.checkBox){t="checkbox";e=this.data.exportValue}else if(this.data.radioButton){t="radiobutton";e=this.data.buttonValue}return{id:this.data.id,value:this.data.fieldValue||"Off",defaultValue:this.data.defaultFieldValue,exportValues:e,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,hidden:this.data.hidden,actions:this.data.actions,type:t}}get fallbackFontDict(){const e=new o.Dict;e.set("BaseFont",o.Name.get("ZapfDingbats"));e.set("Type",o.Name.get("FallbackType"));e.set("Subtype",o.Name.get("FallbackType"));e.set("Encoding",o.Name.get("ZapfDingbatsEncoding"));return(0,a.shadow)(this,"fallbackFontDict",e)}}class ChoiceWidgetAnnotation extends WidgetAnnotation{constructor(e){super(e);this.data.options=[];const t=(0,n.getInheritableProperty)({dict:e.dict,key:"Opt"});if(Array.isArray(t)){const r=e.xref;for(let e=0,a=t.length;e<a;e++){const a=r.fetchIfRef(t[e]),i=Array.isArray(a);this.data.options[e]={exportValue:this._decodeFormValue(i?r.fetchIfRef(a[0]):a),displayValue:this._decodeFormValue(i?r.fetchIfRef(a[1]):a)}}}(0,a.isString)(this.data.fieldValue)?this.data.fieldValue=[this.data.fieldValue]:this.data.fieldValue||(this.data.fieldValue=[]);this.data.combo=this.hasFieldFlag(a.AnnotationFieldFlag.COMBO);this.data.multiSelect=this.hasFieldFlag(a.AnnotationFieldFlag.MULTISELECT);this._hasText=!0}getFieldObject(){const e=this.data.combo?"combobox":"listbox",t=this.data.fieldValue.length>0?this.data.fieldValue[0]:null;return{id:this.data.id,value:t,defaultValue:this.data.defaultFieldValue,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,numItems:this.data.fieldValue.length,multipleSelection:this.data.multiSelect,hidden:this.data.hidden,actions:this.data.actions,items:this.data.options,type:e}}}class TextAnnotation extends MarkupAnnotation{constructor(e){super(e);const t=e.dict;this.data.annotationType=a.AnnotationType.TEXT;if(this.data.hasAppearance)this.data.name="NoIcon";else{this.data.rect[1]=this.data.rect[3]-22;this.data.rect[2]=this.data.rect[0]+22;this.data.name=t.has("Name")?t.get("Name").name:"Note"}if(t.has("State")){this.data.state=t.get("State")||null;this.data.stateModel=t.get("StateModel")||null}else{this.data.state=null;this.data.stateModel=null}}}class LinkAnnotation extends Annotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.LINK;const t=getQuadPoints(e.dict,this.rectangle);t&&(this.data.quadPoints=t);i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl})}}class PopupAnnotation extends Annotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.POPUP;let t=e.dict.get("Parent");if(!t){(0,a.warn)("Popup annotation has a missing or invalid parent annotation.");return}const r=t.get("Subtype");this.data.parentType=(0,o.isName)(r)?r.name:null;const i=e.dict.getRaw("Parent");this.data.parentId=(0,o.isRef)(i)?i.toString():null;const n=t.getArray("Rect");Array.isArray(n)&&4===n.length?this.data.parentRect=a.Util.normalizeRect(n):this.data.parentRect=[0,0,0,0];const s=t.get("RT");(0,o.isName)(s,a.AnnotationReplyType.GROUP)&&(t=t.get("IRT"));if(t.has("M")){this.setModificationDate(t.get("M"));this.data.modificationDate=this.modificationDate}else this.data.modificationDate=null;if(t.has("C")){this.setColor(t.getArray("C"));this.data.color=this.color}else this.data.color=null;if(!this.viewable){const e=t.get("F");this._isViewable(e)&&this.setFlags(e)}this.data.title=(0,a.stringToPDFString)(t.get("T")||"");this.data.contents=(0,a.stringToPDFString)(t.get("Contents")||"")}}class FreeTextAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.FREETEXT}}class LineAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.LINE;const t=e.dict.getArray("L");this.data.lineCoordinates=a.Util.normalizeRect(t);if(!this.appearance){const r=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0],i=this.borderStyle.width;(0,a.isArrayEqual)(this.rectangle,[0,0,0,0])&&(this.rectangle=[this.data.lineCoordinates[0]-2*i,this.data.lineCoordinates[1]-2*i,this.data.lineCoordinates[2]+2*i,this.data.lineCoordinates[3]+2*i]);this._setDefaultAppearance({xref:e.xref,extra:`${i} w`,strokeColor:r,pointsCallback:(e,r)=>{e.push(`${t[0]} ${t[1]} m`);e.push(`${t[2]} ${t[3]} l`);e.push("S");return[r[0].x-i,r[1].x+i,r[3].y-i,r[1].y+i]}})}}}class SquareAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.SQUARE;if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];let r=null,a=e.dict.getArray("IC");if(a){a=getRgbColor(a);r=a?Array.from(a).map((e=>e/255)):null}this._setDefaultAppearance({xref:e.xref,extra:`${this.borderStyle.width} w`,strokeColor:t,fillColor:r,pointsCallback:(e,t)=>{const a=t[2].x+this.borderStyle.width/2,i=t[2].y+this.borderStyle.width/2,n=t[3].x-t[2].x-this.borderStyle.width,s=t[1].y-t[3].y-this.borderStyle.width;e.push(`${a} ${i} ${n} ${s} re`);r?e.push("B"):e.push("S");return[t[0].x,t[1].x,t[3].y,t[1].y]}})}}}class CircleAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.CIRCLE;if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];let r=null,a=e.dict.getArray("IC");if(a){a=getRgbColor(a);r=a?Array.from(a).map((e=>e/255)):null}const i=4/3*Math.tan(Math.PI/8);this._setDefaultAppearance({xref:e.xref,extra:`${this.borderStyle.width} w`,strokeColor:t,fillColor:r,pointsCallback:(e,t)=>{const a=t[0].x+this.borderStyle.width/2,n=t[0].y-this.borderStyle.width/2,s=t[3].x-this.borderStyle.width/2,o=t[3].y+this.borderStyle.width/2,c=a+(s-a)/2,l=n+(o-n)/2,h=(s-a)/2*i,u=(o-n)/2*i;e.push(`${c} ${o} m`);e.push(`${c+h} ${o} ${s} ${l+u} ${s} ${l} c`);e.push(`${s} ${l-u} ${c+h} ${n} ${c} ${n} c`);e.push(`${c-h} ${n} ${a} ${l-u} ${a} ${l} c`);e.push(`${a} ${l+u} ${c-h} ${o} ${c} ${o} c`);e.push("h");r?e.push("B"):e.push("S");return[t[0].x,t[1].x,t[3].y,t[1].y]}})}}}class PolylineAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.POLYLINE;this.data.vertices=[];const t=e.dict.getArray("Vertices");if(Array.isArray(t))for(let e=0,r=t.length;e<r;e+=2)this.data.vertices.push({x:t[e],y:t[e+1]})}}class PolygonAnnotation extends PolylineAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.POLYGON}}class CaretAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.CARET}}class InkAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.INK;this.data.inkLists=[];const t=e.dict.getArray("InkList");if(!Array.isArray(t))return;const r=e.xref;for(let e=0,a=t.length;e<a;++e){this.data.inkLists.push([]);for(let a=0,i=t[e].length;a<i;a+=2)this.data.inkLists[e].push({x:r.fetchIfRef(t[e][a]),y:r.fetchIfRef(t[e][a+1])})}}}class HighlightAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.HIGHLIGHT;if(this.data.quadPoints=getQuadPoints(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[1,1,0];this._setDefaultAppearance({xref:e.xref,fillColor:t,blendMode:"Multiply",pointsCallback:(e,t)=>{e.push(`${t[0].x} ${t[0].y} m`);e.push(`${t[1].x} ${t[1].y} l`);e.push(`${t[3].x} ${t[3].y} l`);e.push(`${t[2].x} ${t[2].y} l`);e.push("f");return[t[0].x,t[1].x,t[3].y,t[1].y]}})}}else this.data.hasPopup=!1}}class UnderlineAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.UNDERLINE;if(this.data.quadPoints=getQuadPoints(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>{e.push(`${t[2].x} ${t[2].y} m`);e.push(`${t[3].x} ${t[3].y} l`);e.push("S");return[t[0].x,t[1].x,t[3].y,t[1].y]}})}}else this.data.hasPopup=!1}}class SquigglyAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.SQUIGGLY;if(this.data.quadPoints=getQuadPoints(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>{const r=(t[0].y-t[2].y)/6;let a=r,i=t[2].x;const n=t[2].y,s=t[3].x;e.push(`${i} ${n+a} m`);do{i+=2;a=0===a?r:0;e.push(`${i} ${n+a} l`)}while(i<s);e.push("S");return[t[2].x,s,n-2*r,n+2*r]}})}}else this.data.hasPopup=!1}}class StrikeOutAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.STRIKEOUT;if(this.data.quadPoints=getQuadPoints(e.dict,null)){if(!this.appearance){const t=this.color?Array.from(this.color).map((e=>e/255)):[0,0,0];this._setDefaultAppearance({xref:e.xref,extra:"[] 0 d 1 w",strokeColor:t,pointsCallback:(e,t)=>{e.push((t[0].x+t[2].x)/2+` ${(t[0].y+t[2].y)/2} m`);e.push((t[1].x+t[3].x)/2+` ${(t[1].y+t[3].y)/2} l`);e.push("S");return[t[0].x,t[1].x,t[3].y,t[1].y]}})}}else this.data.hasPopup=!1}}class StampAnnotation extends MarkupAnnotation{constructor(e){super(e);this.data.annotationType=a.AnnotationType.STAMP}}class FileAttachmentAnnotation extends MarkupAnnotation{constructor(e){super(e);const t=new i.FileSpec(e.dict.get("FS"),e.xref);this.data.annotationType=a.AnnotationType.FILEATTACHMENT;this.data.file=t.serializable}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.createDefaultAppearance=function createDefaultAppearance({fontSize:e,fontName:t,fontColor:r}){let a;a=r.every((e=>0===e))?"0 g":Array.from(r).map((e=>(e/255).toFixed(2))).join(" ")+" rg";return`/${(0,n.escapePDFName)(t)} ${e} Tf ${a}`};t.parseDefaultAppearance=function parseDefaultAppearance(e){return new DefaultAppearanceEvaluator(e).parse()};var a=r(2),i=r(23),n=r(8),s=r(29),o=r(5),c=r(12);class DefaultAppearanceEvaluator extends s.EvaluatorPreprocessor{constructor(e){super(new c.StringStream(e))}parse(){const e={fn:0,args:[]},t={fontSize:0,fontName:"",fontColor:new Uint8ClampedArray(3)};try{for(;;){e.args.length=0;if(!this.read(e))break;if(0!==this.savedStatesDepth)continue;const{fn:r,args:n}=e;switch(0|r){case a.OPS.setFont:const[e,r]=n;e instanceof o.Name&&(t.fontName=e.name);"number"==typeof r&&r>0&&(t.fontSize=r);break;case a.OPS.setFillRGBColor:i.ColorSpace.singletons.rgb.getRgbItem(n,0,t.fontColor,0);break;case a.OPS.setFillGray:i.ColorSpace.singletons.gray.getRgbItem(n,0,t.fontColor,0);break;case a.OPS.setFillColorSpace:i.ColorSpace.singletons.cmyk.getRgbItem(n,0,t.fontColor,0)}}}catch(e){(0,a.warn)(`parseDefaultAppearance - ignoring errors: "${e}".`)}return t}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PartialEvaluator=t.EvaluatorPreprocessor=void 0;var a=r(2),i=r(30),n=r(5),s=r(12),o=r(31),c=r(34),l=r(37),h=r(36),u=r(40),d=r(41),f=r(11),g=r(24),p=r(43),m=r(23),b=r(35),y=r(8),w=r(44),S=r(45),v=r(46),k=r(47);const x=Object.freeze({maxImageSize:-1,disableFontFace:!1,ignoreErrors:!1,isEvalSupported:!0,fontExtraProperties:!1}),C=1,O=2,F=Promise.resolve();function normalizeBlendMode(e,t=!1){if(Array.isArray(e)){for(let t=0,r=e.length;t<r;t++){const r=normalizeBlendMode(e[t],!0);if(r)return r}(0,a.warn)(`Unsupported blend mode Array: ${e}`);return"source-over"}if(!(0,n.isName)(e))return t?null:"source-over";switch(e.name){case"Normal":case"Compatible":return"source-over";case"Multiply":return"multiply";case"Screen":return"screen";case"Overlay":return"overlay";case"Darken":return"darken";case"Lighten":return"lighten";case"ColorDodge":return"color-dodge";case"ColorBurn":return"color-burn";case"HardLight":return"hard-light";case"SoftLight":return"soft-light";case"Difference":return"difference";case"Exclusion":return"exclusion";case"Hue":return"hue";case"Saturation":return"saturation";case"Color":return"color";case"Luminosity":return"luminosity"}if(t)return null;(0,a.warn)(`Unsupported blend mode: ${e.name}`);return"source-over"}class TimeSlotManager{static get TIME_SLOT_DURATION_MS(){return(0,a.shadow)(this,"TIME_SLOT_DURATION_MS",20)}static get CHECK_TIME_EVERY(){return(0,a.shadow)(this,"CHECK_TIME_EVERY",100)}constructor(){this.reset()}check(){if(++this.checked<TimeSlotManager.CHECK_TIME_EVERY)return!1;this.checked=0;return this.endTime<=Date.now()}reset(){this.endTime=Date.now()+TimeSlotManager.TIME_SLOT_DURATION_MS;this.checked=0}}class PartialEvaluator{constructor({xref:e,handler:t,pageIndex:r,idFactory:a,fontCache:i,builtInCMapCache:n,globalImageCache:s,options:o=null}){this.xref=e;this.handler=t;this.pageIndex=r;this.idFactory=a;this.fontCache=i;this.builtInCMapCache=n;this.globalImageCache=s;this.options=o||x;this.parsingType3Font=!1;this._fetchBuiltInCMapBound=this.fetchBuiltInCMap.bind(this)}get _pdfFunctionFactory(){const e=new d.PDFFunctionFactory({xref:this.xref,isEvalSupported:this.options.isEvalSupported});return(0,a.shadow)(this,"_pdfFunctionFactory",e)}clone(e=x){var t=Object.create(this);t.options=e;return t}hasBlendModes(e,t){if(!(e instanceof n.Dict))return!1;if(e.objId&&t.has(e.objId))return!1;const r=new n.RefSet(t);e.objId&&r.put(e.objId);for(var i=[e],s=this.xref;i.length;){var o=i.shift(),c=o.get("ExtGState");if(c instanceof n.Dict)for(let e of c.getRawValues()){if(e instanceof n.Ref){if(r.has(e))continue;try{e=s.fetch(e)}catch(t){r.put(e);(0,a.info)(`hasBlendModes - ignoring ExtGState: "${t}".`);continue}}if(!(e instanceof n.Dict))continue;e.objId&&r.put(e.objId);const t=e.get("BM");if(t instanceof n.Name){if("Normal"!==t.name)return!0}else if(void 0!==t&&Array.isArray(t))for(const e of t)if(e instanceof n.Name&&"Normal"!==e.name)return!0}var l=o.get("XObject");if(l instanceof n.Dict)for(let e of l.getRawValues()){if(e instanceof n.Ref){if(r.has(e))continue;try{e=s.fetch(e)}catch(t){r.put(e);(0,a.info)(`hasBlendModes - ignoring XObject: "${t}".`);continue}}if((0,n.isStream)(e)){e.dict.objId&&r.put(e.dict.objId);var h=e.dict.get("Resources");if(h instanceof n.Dict&&(!h.objId||!r.has(h.objId))){i.push(h);h.objId&&r.put(h.objId)}}}}r.forEach((e=>{t.put(e)}));return!1}async fetchBuiltInCMap(e){const t=this.builtInCMapCache.get(e);if(t)return t;const r=this.handler.sendWithStream("FetchBuiltInCMap",{name:e}).getReader(),i=await new Promise((function(e,t){!function pump(){r.read().then((function({value:t,done:r}){if(!r){e(t);pump()}}),t)}()}));i.compressionType!==a.CMapCompressionType.NONE&&this.builtInCMapCache.set(e,i);return i}async buildFormXObject(e,t,r,i,s,o,c){var l=t.dict,h=l.getArray("Matrix"),u=l.getArray("BBox");u=Array.isArray(u)&&4===u.length?a.Util.normalizeRect(u):null;let d=null;if(l.has("OC")){d=await this.parseMarkedContentProps(l.get("OC"),e);i.addOp(a.OPS.beginMarkedContentProps,["OC",d])}var f=l.get("Group");if(f){var g={matrix:h,bbox:u,smask:r,isolated:!1,knockout:!1},p=f.get("S"),b=null;if((0,n.isName)(p,"Transparency")){g.isolated=f.get("I")||!1;g.knockout=f.get("K")||!1;if(f.has("CS")){const t=f.getRaw("CS"),r=m.ColorSpace.getCached(t,this.xref,c);b=r||await this.parseColorSpace({cs:t,resources:e,localColorSpaceCache:c})}}if(r&&r.backdrop){b=b||m.ColorSpace.singletons.rgb;r.backdrop=b.getRgb(r.backdrop,0)}i.addOp(a.OPS.beginGroup,[g])}i.addOp(a.OPS.paintFormXObjectBegin,[h,u]);return this.getOperatorList({stream:t,task:s,resources:l.get("Resources")||e,operatorList:i,initialState:o}).then((function(){i.addOp(a.OPS.paintFormXObjectEnd,[]);f&&i.addOp(a.OPS.endGroup,[g]);d&&i.addOp(a.OPS.endMarkedContent,[])}))}_sendImgData(e,t,r=!1){const a=t?[t.data.buffer]:null;return this.parsingType3Font||r?this.handler.send("commonobj",[e,"Image",t],a):this.handler.send("obj",[e,this.pageIndex,"Image",t],a)}async buildPaintImageXObject({resources:e,image:t,isInline:r=!1,operatorList:i,cacheKey:n,localImageCache:o,localColorSpaceCache:c}){var l=t.dict;const h=l.objId;var u=l.get("Width","W"),d=l.get("Height","H");if(!(u&&(0,a.isNum)(u)&&d&&(0,a.isNum)(d))){(0,a.warn)("Image dimensions are missing, or not numbers.");return}var f,g,p=this.options.maxImageSize;if(-1!==p&&u*d>p){(0,a.warn)("Image exceeded maximum allowed size and was removed.");return}if(l.get("ImageMask","IM")||!1){var m=l.get("Width","W"),b=l.get("Height","H"),y=m+7>>3,w=t.getBytes(y*b,!0),S=l.getArray("Decode","D");(f=k.PDFImage.createMask({imgArray:w,width:m,height:b,imageIsFromDecodeStream:t instanceof s.DecodeStream,inverseDecode:!!S&&S[0]>0})).cached=!!n;g=[f];i.addOp(a.OPS.paintImageMaskXObject,g);n&&o.set(n,h,{fn:a.OPS.paintImageMaskXObject,args:g});return}var v=l.get("SMask","SM")||!1,x=l.get("Mask")||!1;if(r&&!v&&!x&&u+d<200){const n=new k.PDFImage({xref:this.xref,res:e,image:t,isInline:r,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:c});f=n.createImageData(!0);i.addOp(a.OPS.paintInlineImageXObject,[f]);return}let C=`img_${this.idFactory.createObjId()}`,O=!1;if(this.parsingType3Font)C=`${this.idFactory.getDocId()}_type3_${C}`;else if(h){O=this.globalImageCache.shouldCache(h,this.pageIndex);O&&(C=`${this.idFactory.getDocId()}_${C}`)}i.addDependency(C);g=[C,u,d];k.PDFImage.buildImage({xref:this.xref,res:e,image:t,isInline:r,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:c}).then((e=>{f=e.createImageData(!1);n&&h&&O&&this.globalImageCache.addByteSize(h,f.data.length);return this._sendImgData(C,f,O)})).catch((e=>{(0,a.warn)(`Unable to decode image "${C}": "${e}".`);return this._sendImgData(C,null,O)}));i.addOp(a.OPS.paintImageXObject,g);if(n){o.set(n,h,{fn:a.OPS.paintImageXObject,args:g});if(h){(0,a.assert)(!r,"Cannot cache an inline image globally.");this.globalImageCache.addPageIndex(h,this.pageIndex);O&&this.globalImageCache.setData(h,{objId:C,fn:a.OPS.paintImageXObject,args:g,byteSize:0})}}}handleSMask(e,t,r,a,i,n){var s=e.get("G"),o={subtype:e.get("S").name,backdrop:e.get("BC")},c=e.get("TR");if((0,d.isPDFFunction)(c)){const e=this._pdfFunctionFactory.create(c);for(var l=new Uint8Array(256),h=new Float32Array(1),u=0;u<256;u++){h[0]=u/255;e(h,0,h,0);l[u]=255*h[0]|0}o.transferMap=l}return this.buildFormXObject(t,s,o,r,a,i.state.clone(),n)}handleTransferFunction(e){let t;if(Array.isArray(e))t=e;else{if(!(0,d.isPDFFunction)(e))return null;t=[e]}const r=[];let a=0,i=0;for(const e of t){const t=this.xref.fetchIfRef(e);a++;if((0,n.isName)(t,"Identity")){r.push(null);continue}if(!(0,d.isPDFFunction)(t))return null;const s=this._pdfFunctionFactory.create(t),o=new Uint8Array(256),c=new Float32Array(1);for(let e=0;e<256;e++){c[0]=e/255;s(c,0,c,0);o[e]=255*c[0]|0}r.push(o);i++}return 1!==a&&4!==a||0===i?null:r}handleTilingType(e,t,r,i,s,o,c,l,h){const d=new v.OperatorList,f=n.Dict.merge({xref:this.xref,dictArray:[s.get("Resources"),r]});return this.getOperatorList({stream:i,task:c,resources:f,operatorList:d}).then((function(){const r=d.getIR(),a=(0,u.getTilingPatternIR)(r,s,t);o.addDependencies(d.dependencies);o.addOp(e,a);l&&h.set(l,s.objId,{operatorListIR:r,dict:s})})).catch((e=>{if(!(e instanceof a.AbortException)){if(!this.options.ignoreErrors)throw e;this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorTilingPattern});(0,a.warn)(`handleTilingType - ignoring pattern: "${e}".`)}}))}handleSetFont(e,t,r,i,s,c,l=null){const h=t&&t[0]instanceof n.Name?t[0].name:null;return this.loadFont(h,r,e,l).then((t=>t.font.isType3Font?t.loadType3Data(this,e,s).then((function(){i.addDependencies(t.type3Dependencies);return t})).catch((e=>{this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontLoadType3});return new TranslatedFont({loadedName:"g_font_error",font:new o.ErrorFont(`Type3 font load error: ${e}`),dict:t.font,extraProperties:this.options.fontExtraProperties})})):t)).then((e=>{c.font=e.font;e.send(this.handler);return e.loadedName}))}handleText(e,t){const r=t.font,i=r.charsToGlyphs(e);if(r.data){(!!(t.textRenderingMode&a.TextRenderingMode.ADD_TO_PATH_FLAG)||"Pattern"===t.fillColorSpace.name||r.disableFontFace||this.options.disableFontFace)&&PartialEvaluator.buildFontPaths(r,i,this.handler)}return i}ensureStateFont(e){if(e.font)return;const t=new a.FormatError("Missing setFont (Tf) operator before text rendering operator.");if(!this.options.ignoreErrors)throw t;this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontState});(0,a.warn)(`ensureStateFont: "${t}".`)}async setGState({resources:e,gState:t,operatorList:r,cacheKey:i,task:s,stateManager:o,localGStateCache:c,localColorSpaceCache:l}){const h=t.objId;let u=!0;for(var d=[],f=t.getKeys(),g=Promise.resolve(),p=0,m=f.length;p<m;p++){const i=f[p],c=t.get(i);switch(i){case"Type":break;case"LW":case"LC":case"LJ":case"ML":case"D":case"RI":case"FL":case"CA":case"ca":d.push([i,c]);break;case"Font":u=!1;g=g.then((()=>this.handleSetFont(e,null,c[0],r,s,o.state).then((function(e){r.addDependency(e);d.push([i,[e,c[1]]])}))));break;case"BM":d.push([i,normalizeBlendMode(c)]);break;case"SMask":if((0,n.isName)(c,"None")){d.push([i,!1]);break}if((0,n.isDict)(c)){u=!1;g=g.then((()=>this.handleSMask(c,e,r,s,o,l)));d.push([i,!0])}else(0,a.warn)("Unsupported SMask type");break;case"TR":const t=this.handleTransferFunction(c);d.push([i,t]);break;case"OP":case"op":case"OPM":case"BG":case"BG2":case"UCR":case"UCR2":case"TR2":case"HT":case"SM":case"SA":case"AIS":case"TK":(0,a.info)("graphic state operator "+i);break;default:(0,a.info)("Unknown graphic state operator "+i)}}return g.then((function(){d.length>0&&r.addOp(a.OPS.setGState,[d]);u&&c.set(i,h,d)}))}loadFont(e,t,r,i=null){const errorFont=async()=>new TranslatedFont({loadedName:"g_font_error",font:new o.ErrorFont(`Font "${e}" is not available.`),dict:t,extraProperties:this.options.fontExtraProperties});var s,c=this.xref;if(t){if(!(0,n.isRef)(t))throw new a.FormatError('The "font" object should be a reference.');s=t}else{var l=r.get("Font");l&&(s=l.getRaw(e))}if(!s){const r=`Font "${e||t&&t.toString()}" is not available`;if(!this.options.ignoreErrors&&!this.parsingType3Font){(0,a.warn)(`${r}.`);return errorFont()}this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontMissing});(0,a.warn)(`${r} -- attempting to fallback to a default font.`);s=i||PartialEvaluator.fallbackFontDict}if(this.fontCache.has(s))return this.fontCache.get(s);t=c.fetchIfRef(s);if(!(0,n.isDict)(t))return errorFont();if(t.cacheKey&&this.fontCache.has(t.cacheKey))return this.fontCache.get(t.cacheKey);var h=(0,a.createPromiseCapability)();let u;try{u=this.preEvaluateFont(t)}catch(e){(0,a.warn)(`loadFont - preEvaluateFont failed: "${e}".`);return errorFont()}const{descriptor:d,hash:f}=u;var g,p=(0,n.isRef)(s);p&&(g=`f${s.toString()}`);if(f&&(0,n.isDict)(d)){d.fontAliases||(d.fontAliases=Object.create(null));var m=d.fontAliases;if(m[f]){var b=m[f].aliasRef;if(p&&b&&this.fontCache.has(b)){this.fontCache.putAlias(s,b);return this.fontCache.get(s)}}else m[f]={fontID:this.idFactory.createFontId()};p&&(m[f].aliasRef=s);g=m[f].fontID}if(p)this.fontCache.put(s,h.promise);else{g||(g=this.idFactory.createFontId());t.cacheKey=`cacheKey_${g}`;this.fontCache.put(t.cacheKey,h.promise)}(0,a.assert)(g&&g.startsWith("f"),'The "fontID" must be (correctly) defined.');t.loadedName=`${this.idFactory.getDocId()}_${g}`;this.translateFont(u).then((e=>{if(void 0!==e.fontType){c.stats.fontTypes[e.fontType]=!0}h.resolve(new TranslatedFont({loadedName:t.loadedName,font:e,dict:t,extraProperties:this.options.fontExtraProperties}))})).catch((e=>{this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontTranslate});(0,a.warn)(`loadFont - translateFont failed: "${e}".`);try{var r=d&&d.get("FontFile3"),i=r&&r.get("Subtype"),n=(0,o.getFontType)(u.type,i&&i.name);c.stats.fontTypes[n]=!0}catch(e){}h.resolve(new TranslatedFont({loadedName:t.loadedName,font:new o.ErrorFont(e instanceof Error?e.message:e),dict:t,extraProperties:this.options.fontExtraProperties}))}));return h.promise}buildPath(e,t,r,i=!1){var n=e.length-1;r||(r=[]);if(n<0||e.fnArray[n]!==a.OPS.constructPath){if(i){(0,a.warn)(`Encountered path operator "${t}" inside of a text object.`);e.addOp(a.OPS.save,null)}e.addOp(a.OPS.constructPath,[[t],r]);i&&e.addOp(a.OPS.restore,null)}else{var s=e.argsArray[n];s[0].push(t);Array.prototype.push.apply(s[1],r)}}parseColorSpace({cs:e,resources:t,localColorSpaceCache:r}){return m.ColorSpace.parseAsync({cs:e,xref:this.xref,resources:t,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:r}).catch((e=>{if(e instanceof a.AbortException)return null;if(this.options.ignoreErrors){this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorColorSpace});(0,a.warn)(`parseColorSpace - ignoring ColorSpace: "${e}".`);return null}throw e}))}handleColorN(e,t,r,i,s,o,c,l,h){const d=r.pop();if(d instanceof n.Name){const b=d.name,y=h.getByName(b);if(y)try{const a=i.base?i.base.getRgb(r,0):null,n=(0,u.getTilingPatternIR)(y.operatorListIR,y.dict,a);e.addOp(t,n);return}catch(e){}let w=s.get(b);if(w){var f=(0,n.isStream)(w)?w.dict:w,g=f.get("PatternType");if(g===C){const a=i.base?i.base.getRgb(r,0):null;return this.handleTilingType(t,a,o,w,f,e,c,b,h)}if(g===O){var p=f.get("Shading"),m=f.getArray("Matrix");w=u.Pattern.parseShading(p,m,this.xref,o,this.handler,this._pdfFunctionFactory,l);e.addOp(t,w.getIR());return}throw new a.FormatError(`Unknown PatternType: ${g}`)}}throw new a.FormatError(`Unknown PatternName: ${d}`)}async parseMarkedContentProps(e,t){let r;if((0,n.isName)(e)){r=t.get("Properties").get(e.name)}else{if(!(0,n.isDict)(e))throw new a.FormatError("Optional content properties malformed.");r=e}const i=r.get("Type").name;if("OCG"===i)return{type:i,id:r.objId};if("OCMD"===i){const e=r.get("OCGs");if(Array.isArray(e)||(0,n.isDict)(e)){const t=[];Array.isArray(e)?r.get("OCGs").forEach((e=>{t.push(e.toString())})):t.push(e.objId);let a=null;r.get("VE")&&(a=!0);return{type:i,ids:t,policy:(0,n.isName)(r.get("P"))?r.get("P").name:null,expression:a}}if((0,n.isRef)(e))return{type:i,id:e.toString()}}return null}getOperatorList({stream:e,task:t,resources:r,operatorList:i,initialState:s=null,fallbackFontDict:o=null}){r=r||n.Dict.empty;s=s||new EvalState;if(!i)throw new Error('getOperatorList: missing "operatorList" parameter');var c=this,l=this.xref;let h=!1;const d=new g.LocalImageCache,f=new g.LocalColorSpaceCache,p=new g.LocalGStateCache,b=new g.LocalTilingPatternCache;var y=r.get("XObject")||n.Dict.empty,w=r.get("Pattern")||n.Dict.empty,S=new StateManager(s),v=new EvaluatorPreprocessor(e,l,S),k=new TimeSlotManager;function closePendingRestoreOPS(e){for(var t=0,r=v.savedStatesDepth;t<r;t++)i.addOp(a.OPS.restore,[])}return new Promise((function promiseBody(e,s){const next=function(t){Promise.all([t,i.ready]).then((function(){try{promiseBody(e,s)}catch(e){s(e)}}),s)};t.ensureNotTerminated();k.reset();for(var g,x,C,O,T,E={};!(g=k.check());){E.args=null;if(!v.read(E))break;var M=E.args,D=E.fn;switch(0|D){case a.OPS.paintXObject:if(T=M[0].name){const e=d.getByName(T);if(e){i.addOp(e.fn,e.args);M=null;continue}}next(new Promise((function(e,s){if(!T)throw new a.FormatError("XObject must be referred to by name.");let o=y.getRaw(T);if(o instanceof n.Ref){const t=d.getByRef(o);if(t){i.addOp(t.fn,t.args);e();return}const r=c.globalImageCache.getData(o,c.pageIndex);if(r){i.addDependency(r.objId);i.addOp(r.fn,r.args);e();return}o=l.fetch(o)}if(!(0,n.isStream)(o))throw new a.FormatError("XObject should be a stream");const h=o.dict.get("Subtype");if(!(0,n.isName)(h))throw new a.FormatError("XObject should have a Name subtype");if("Form"!==h.name)if("Image"!==h.name){if("PS"!==h.name)throw new a.FormatError(`Unhandled XObject subtype ${h.name}`);(0,a.info)("Ignored XObject subtype PS");e()}else c.buildPaintImageXObject({resources:r,image:o,operatorList:i,cacheKey:T,localImageCache:d,localColorSpaceCache:f}).then(e,s);else{S.save();c.buildFormXObject(r,o,null,i,t,S.state.clone(),f).then((function(){S.restore();e()}),s)}})).catch((function(e){if(!(e instanceof a.AbortException)){if(!c.options.ignoreErrors)throw e;c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorXObject});(0,a.warn)(`getOperatorList - ignoring XObject: "${e}".`)}})));return;case a.OPS.setFont:var N=M[1];next(c.handleSetFont(r,M,null,i,t,S.state,o).then((function(e){i.addDependency(e);i.addOp(a.OPS.setFont,[e,N])})));return;case a.OPS.beginText:h=!0;break;case a.OPS.endText:h=!1;break;case a.OPS.endInlineImage:var R=M[0].cacheKey;if(R){const e=d.getByName(R);if(e){i.addOp(e.fn,e.args);M=null;continue}}next(c.buildPaintImageXObject({resources:r,image:M[0],isInline:!0,operatorList:i,cacheKey:R,localImageCache:d,localColorSpaceCache:f}));return;case a.OPS.showText:if(!S.state.font){c.ensureStateFont(S.state);continue}M[0]=c.handleText(M[0],S.state);break;case a.OPS.showSpacedText:if(!S.state.font){c.ensureStateFont(S.state);continue}var j=M[0],L=[],_=j.length,U=S.state;for(x=0;x<_;++x){var X=j[x];(0,a.isString)(X)?Array.prototype.push.apply(L,c.handleText(X,U)):(0,a.isNum)(X)&&L.push(X)}M[0]=L;D=a.OPS.showText;break;case a.OPS.nextLineShowText:if(!S.state.font){c.ensureStateFont(S.state);continue}i.addOp(a.OPS.nextLine);M[0]=c.handleText(M[0],S.state);D=a.OPS.showText;break;case a.OPS.nextLineSetSpacingShowText:if(!S.state.font){c.ensureStateFont(S.state);continue}i.addOp(a.OPS.nextLine);i.addOp(a.OPS.setWordSpacing,[M.shift()]);i.addOp(a.OPS.setCharSpacing,[M.shift()]);M[0]=c.handleText(M[0],S.state);D=a.OPS.showText;break;case a.OPS.setTextRenderingMode:S.state.textRenderingMode=M[0];break;case a.OPS.setFillColorSpace:{const e=m.ColorSpace.getCached(M[0],l,f);if(e){S.state.fillColorSpace=e;continue}next(c.parseColorSpace({cs:M[0],resources:r,localColorSpaceCache:f}).then((function(e){e&&(S.state.fillColorSpace=e)})));return}case a.OPS.setStrokeColorSpace:{const e=m.ColorSpace.getCached(M[0],l,f);if(e){S.state.strokeColorSpace=e;continue}next(c.parseColorSpace({cs:M[0],resources:r,localColorSpaceCache:f}).then((function(e){e&&(S.state.strokeColorSpace=e)})));return}case a.OPS.setFillColor:M=(O=S.state.fillColorSpace).getRgb(M,0);D=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeColor:M=(O=S.state.strokeColorSpace).getRgb(M,0);D=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillGray:S.state.fillColorSpace=m.ColorSpace.singletons.gray;M=m.ColorSpace.singletons.gray.getRgb(M,0);D=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeGray:S.state.strokeColorSpace=m.ColorSpace.singletons.gray;M=m.ColorSpace.singletons.gray.getRgb(M,0);D=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillCMYKColor:S.state.fillColorSpace=m.ColorSpace.singletons.cmyk;M=m.ColorSpace.singletons.cmyk.getRgb(M,0);D=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeCMYKColor:S.state.strokeColorSpace=m.ColorSpace.singletons.cmyk;M=m.ColorSpace.singletons.cmyk.getRgb(M,0);D=a.OPS.setStrokeRGBColor;break;case a.OPS.setFillRGBColor:S.state.fillColorSpace=m.ColorSpace.singletons.rgb;M=m.ColorSpace.singletons.rgb.getRgb(M,0);break;case a.OPS.setStrokeRGBColor:S.state.strokeColorSpace=m.ColorSpace.singletons.rgb;M=m.ColorSpace.singletons.rgb.getRgb(M,0);break;case a.OPS.setFillColorN:if("Pattern"===(O=S.state.fillColorSpace).name){next(c.handleColorN(i,a.OPS.setFillColorN,M,O,w,r,t,f,b));return}M=O.getRgb(M,0);D=a.OPS.setFillRGBColor;break;case a.OPS.setStrokeColorN:if("Pattern"===(O=S.state.strokeColorSpace).name){next(c.handleColorN(i,a.OPS.setStrokeColorN,M,O,w,r,t,f,b));return}M=O.getRgb(M,0);D=a.OPS.setStrokeRGBColor;break;case a.OPS.shadingFill:var q=r.get("Shading");if(!q)throw new a.FormatError("No shading resource found");var $=q.get(M[0].name);if(!$)throw new a.FormatError("No shading object found");M=[u.Pattern.parseShading($,null,l,r,c.handler,c._pdfFunctionFactory,f).getIR()];D=a.OPS.shadingFill;break;case a.OPS.setGState:if(T=M[0].name){const e=p.getByName(T);if(e){e.length>0&&i.addOp(a.OPS.setGState,[e]);M=null;continue}}next(new Promise((function(e,s){if(!T)throw new a.FormatError("GState must be referred to by name.");const o=r.get("ExtGState");if(!(o instanceof n.Dict))throw new a.FormatError("ExtGState should be a dictionary.");const l=o.get(T);if(!(l instanceof n.Dict))throw new a.FormatError("GState should be a dictionary.");c.setGState({resources:r,gState:l,operatorList:i,cacheKey:T,task:t,stateManager:S,localGStateCache:p,localColorSpaceCache:f}).then(e,s)})).catch((function(e){if(!(e instanceof a.AbortException)){if(!c.options.ignoreErrors)throw e;c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorExtGState});(0,a.warn)(`getOperatorList - ignoring ExtGState: "${e}".`)}})));return;case a.OPS.moveTo:case a.OPS.lineTo:case a.OPS.curveTo:case a.OPS.curveTo2:case a.OPS.curveTo3:case a.OPS.closePath:case a.OPS.rectangle:c.buildPath(i,D,M,h);continue;case a.OPS.markPoint:case a.OPS.markPointProps:case a.OPS.beginCompat:case a.OPS.endCompat:continue;case a.OPS.beginMarkedContentProps:if(!(0,n.isName)(M[0])){(0,a.warn)(`Expected name for beginMarkedContentProps arg0=${M[0]}`);continue}if("OC"===M[0].name){next(c.parseMarkedContentProps(M[1],r).then((e=>{i.addOp(a.OPS.beginMarkedContentProps,["OC",e])})).catch((e=>{if(!(e instanceof a.AbortException)){if(!c.options.ignoreErrors)throw e;c.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorMarkedContent});(0,a.warn)(`getOperatorList - ignoring beginMarkedContentProps: "${e}".`)}})));return}M=[M[0].name];break;case a.OPS.beginMarkedContent:case a.OPS.endMarkedContent:default:if(null!==M){for(x=0,C=M.length;x<C&&!(M[x]instanceof n.Dict);x++);if(x<C){(0,a.warn)("getOperatorList - ignoring operator: "+D);continue}}}i.addOp(D,M)}if(g)next(F);else{closePendingRestoreOPS();e()}})).catch((e=>{if(!(e instanceof a.AbortException)){if(!this.options.ignoreErrors)throw e;this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorOperatorList});(0,a.warn)(`getOperatorList - ignoring errors during "${t.name}" task: "${e}".`);closePendingRestoreOPS()}}))}getTextContent({stream:e,task:t,resources:r,stateManager:i=null,normalizeWhitespace:s=!1,combineTextItems:o=!1,sink:c,seenStyles:h=new Set}){r=r||n.Dict.empty;i=i||new StateManager(new TextState);var u=/\s/g,d={items:[],styles:Object.create(null)},f={initialized:!1,str:[],width:0,height:0,vertical:!1,lastAdvanceWidth:0,lastAdvanceHeight:0,textAdvanceScale:0,spaceWidth:0,fakeSpaceMin:1/0,fakeMultiSpaceMin:1/0,fakeMultiSpaceMax:-0,textRunBreakAllowed:!1,transform:null,fontName:null},m=this,b=this.xref,y=null;const w=new g.LocalImageCache,S=new g.LocalGStateCache;var v,k=new EvaluatorPreprocessor(e,b,i);function ensureTextContentItem(){if(f.initialized)return f;const e=v.font,t=e.loadedName;if(!h.has(t)){h.add(t);d.styles[t]={fontFamily:e.fallbackName,ascent:e.ascent,descent:e.descent,vertical:e.vertical}}f.fontName=t;var r=[v.fontSize*v.textHScale,0,0,v.fontSize,0,v.textRise];if(e.isType3Font&&v.fontSize<=1&&!(0,a.isArrayEqual)(v.fontMatrix,a.FONT_IDENTITY_MATRIX)){const t=e.bbox[3]-e.bbox[1];t>0&&(r[3]*=t*v.fontMatrix[3])}var i=a.Util.transform(v.ctm,a.Util.transform(v.textMatrix,r));f.transform=i;if(e.vertical){f.width=Math.hypot(i[0],i[1]);f.height=0;f.vertical=!0}else{f.width=0;f.height=Math.hypot(i[2],i[3]);f.vertical=!1}const n=Math.hypot(v.textLineMatrix[0],v.textLineMatrix[1]),s=Math.hypot(v.ctm[0],v.ctm[1]);f.textAdvanceScale=s*n;f.lastAdvanceWidth=0;f.lastAdvanceHeight=0;var o=e.spaceWidth/1e3*v.fontSize;if(o){f.spaceWidth=o;f.fakeSpaceMin=.3*o;f.fakeMultiSpaceMin=1.5*o;f.fakeMultiSpaceMax=4*o;f.textRunBreakAllowed=!e.isMonospace}else{f.spaceWidth=0;f.fakeSpaceMin=1/0;f.fakeMultiSpaceMin=1/0;f.fakeMultiSpaceMax=0;f.textRunBreakAllowed=!1}f.initialized=!0;return f}function replaceWhitespace(e){for(var t,r=0,a=e.length;r<a&&(t=e.charCodeAt(r))>=32&&t<=127;)r++;return r<a?e.replace(u," "):e}function handleSetFont(e,t){return m.loadFont(e,t,r).then((function(e){v.font=e.font;v.fontMatrix=e.font.fontMatrix||a.FONT_IDENTITY_MATRIX}))}function buildTextContentItem(e){for(var t=v.font,r=ensureTextContentItem(),a=0,i=0,n=t.charsToGlyphs(e),s=0;s<n.length;s++){var o=n[s],c=null;c=t.vertical&&o.vmetric?o.vmetric[0]:o.width;var h=o.unicode,u=(0,l.getNormalizedUnicodes)();void 0!==u[h]&&(h=u[h]);h=(0,l.reverseIfRtl)(h);var d=v.charSpacing;if(o.isSpace){var f=v.wordSpacing;d+=f;f>0&&addFakeSpaces(f,r.str)}var g=0,p=0;if(t.vertical){i+=p=c*v.fontMatrix[0]*v.fontSize+d}else{a+=g=(c*v.fontMatrix[0]*v.fontSize+d)*v.textHScale}v.translateTextMatrix(g,p);r.str.push(h)}if(t.vertical){r.lastAdvanceHeight=i;r.height+=Math.abs(i)}else{r.lastAdvanceWidth=a;r.width+=a}return r}function addFakeSpaces(e,t){if(!(e<f.fakeSpaceMin))if(e<f.fakeMultiSpaceMin)t.push(" ");else for(var r=Math.round(e/f.spaceWidth);r-- >0;)t.push(" ")}function flushTextContentItem(){if(f.initialized){f.vertical?f.height*=f.textAdvanceScale:f.width*=f.textAdvanceScale;d.items.push(function runBidiTransform(e){var t=e.str.join(""),r=(0,p.bidi)(t,-1,e.vertical);return{str:s?replaceWhitespace(r.str):r.str,dir:r.dir,width:e.width,height:e.height,transform:e.transform,fontName:e.fontName}}(f));f.initialized=!1;f.str.length=0}}function enqueueChunk(){const e=d.items.length;if(e>0){c.enqueue(d,e);d.items=[];d.styles=Object.create(null)}}var x=new TimeSlotManager;return new Promise((function promiseBody(e,l){const next=function(t){enqueueChunk();Promise.all([t,c.ready]).then((function(){try{promiseBody(e,l)}catch(e){l(e)}}),l)};t.ensureNotTerminated();x.reset();for(var u,g={},p=[];!(u=x.check());){p.length=0;g.args=p;if(!k.read(g))break;v=i.state;var C,O=g.fn;p=g.args;switch(0|O){case a.OPS.setFont:var T=p[0].name,E=p[1];if(v.font&&T===v.fontName&&E===v.fontSize)break;flushTextContentItem();v.fontName=T;v.fontSize=E;next(handleSetFont(T,null));return;case a.OPS.setTextRise:flushTextContentItem();v.textRise=p[0];break;case a.OPS.setHScale:flushTextContentItem();v.textHScale=p[0]/100;break;case a.OPS.setLeading:flushTextContentItem();v.leading=p[0];break;case a.OPS.moveText:var M=!!v.font&&0===(v.font.vertical?p[0]:p[1]);C=p[0]-p[1];if(o&&M&&f.initialized&&C>0&&C<=f.fakeMultiSpaceMax){v.translateTextLineMatrix(p[0],p[1]);f.width+=p[0]-f.lastAdvanceWidth;f.height+=p[1]-f.lastAdvanceHeight;addFakeSpaces(p[0]-f.lastAdvanceWidth-(p[1]-f.lastAdvanceHeight),f.str);break}flushTextContentItem();v.translateTextLineMatrix(p[0],p[1]);v.textMatrix=v.textLineMatrix.slice();break;case a.OPS.setLeadingMoveText:flushTextContentItem();v.leading=-p[1];v.translateTextLineMatrix(p[0],p[1]);v.textMatrix=v.textLineMatrix.slice();break;case a.OPS.nextLine:flushTextContentItem();v.carriageReturn();break;case a.OPS.setTextMatrix:C=v.calcTextLineMatrixAdvance(p[0],p[1],p[2],p[3],p[4],p[5]);if(o&&null!==C&&f.initialized&&C.value>0&&C.value<=f.fakeMultiSpaceMax){v.translateTextLineMatrix(C.width,C.height);f.width+=C.width-f.lastAdvanceWidth;f.height+=C.height-f.lastAdvanceHeight;addFakeSpaces(C.width-f.lastAdvanceWidth-(C.height-f.lastAdvanceHeight),f.str);break}flushTextContentItem();v.setTextMatrix(p[0],p[1],p[2],p[3],p[4],p[5]);v.setTextLineMatrix(p[0],p[1],p[2],p[3],p[4],p[5]);break;case a.OPS.setCharSpacing:v.charSpacing=p[0];break;case a.OPS.setWordSpacing:v.wordSpacing=p[0];break;case a.OPS.beginText:flushTextContentItem();v.textMatrix=a.IDENTITY_MATRIX.slice();v.textLineMatrix=a.IDENTITY_MATRIX.slice();break;case a.OPS.showSpacedText:if(!i.state.font){m.ensureStateFont(i.state);continue}for(var D,N=p[0],R=0,j=N.length;R<j;R++)if("string"==typeof N[R])buildTextContentItem(N[R]);else if((0,a.isNum)(N[R])){ensureTextContentItem();C=N[R]*v.fontSize/1e3;var L=!1;if(v.font.vertical){D=C;v.translateTextMatrix(0,D);(L=f.textRunBreakAllowed&&C>f.fakeMultiSpaceMax)||(f.height+=D)}else{D=(C=-C)*v.textHScale;v.translateTextMatrix(D,0);(L=f.textRunBreakAllowed&&C>f.fakeMultiSpaceMax)||(f.width+=D)}L?flushTextContentItem():C>0&&addFakeSpaces(C,f.str)}break;case a.OPS.showText:if(!i.state.font){m.ensureStateFont(i.state);continue}buildTextContentItem(p[0]);break;case a.OPS.nextLineShowText:if(!i.state.font){m.ensureStateFont(i.state);continue}flushTextContentItem();v.carriageReturn();buildTextContentItem(p[0]);break;case a.OPS.nextLineSetSpacingShowText:if(!i.state.font){m.ensureStateFont(i.state);continue}flushTextContentItem();v.wordSpacing=p[0];v.charSpacing=p[1];v.carriageReturn();buildTextContentItem(p[2]);break;case a.OPS.paintXObject:flushTextContentItem();y||(y=r.get("XObject")||n.Dict.empty);var _=p[0].name;if(_&&w.getByName(_))break;next(new Promise((function(e,l){if(!_)throw new a.FormatError("XObject must be referred to by name.");let u=y.getRaw(_);if(u instanceof n.Ref){if(w.getByRef(u)){e();return}if(m.globalImageCache.getData(u,m.pageIndex)){e();return}u=b.fetch(u)}if(!(0,n.isStream)(u))throw new a.FormatError("XObject should be a stream");const d=u.dict.get("Subtype");if(!(0,n.isName)(d))throw new a.FormatError("XObject should have a Name subtype");if("Form"!==d.name){w.set(_,u.dict.objId,!0);e();return}const f=i.state.clone(),g=new StateManager(f),p=u.dict.getArray("Matrix");Array.isArray(p)&&6===p.length&&g.transform(p);enqueueChunk();const S={enqueueInvoked:!1,enqueue(e,t){this.enqueueInvoked=!0;c.enqueue(e,t)},get desiredSize(){return c.desiredSize},get ready(){return c.ready}};m.getTextContent({stream:u,task:t,resources:u.dict.get("Resources")||r,stateManager:g,normalizeWhitespace:s,combineTextItems:o,sink:S,seenStyles:h}).then((function(){S.enqueueInvoked||w.set(_,u.dict.objId,!0);e()}),l)})).catch((function(e){if(!(e instanceof a.AbortException)){if(!m.options.ignoreErrors)throw e;(0,a.warn)(`getTextContent - ignoring XObject: "${e}".`)}})));return;case a.OPS.setGState:if((_=p[0].name)&&S.getByName(_))break;next(new Promise((function(e,t){if(!_)throw new a.FormatError("GState must be referred to by name.");const i=r.get("ExtGState");if(!(i instanceof n.Dict))throw new a.FormatError("ExtGState should be a dictionary.");const s=i.get(_);if(!(s instanceof n.Dict))throw new a.FormatError("GState should be a dictionary.");const o=s.get("Font");if(o){flushTextContentItem();v.fontName=null;v.fontSize=o[1];handleSetFont(null,o[0]).then(e,t)}else{S.set(_,s.objId,!0);e()}})).catch((function(e){if(!(e instanceof a.AbortException)){if(!m.options.ignoreErrors)throw e;(0,a.warn)(`getTextContent - ignoring ExtGState: "${e}".`)}})));return}if(d.items.length>=c.desiredSize){u=!0;break}}if(u)next(F);else{flushTextContentItem();enqueueChunk();e()}})).catch((e=>{if(!(e instanceof a.AbortException)){if(!this.options.ignoreErrors)throw e;(0,a.warn)(`getTextContent - ignoring errors during "${t.name}" task: "${e}".`);flushTextContentItem();enqueueChunk()}}))}extractDataStructures(e,t,r){const i=this.xref;let s;var l=e.get("ToUnicode")||t.get("ToUnicode"),h=l?this.readToUnicode(l):Promise.resolve(void 0);if(r.composite){var u=e.get("CIDSystemInfo");(0,n.isDict)(u)&&(r.cidSystemInfo={registry:(0,a.stringToPDFString)(u.get("Registry")),ordering:(0,a.stringToPDFString)(u.get("Ordering")),supplement:u.get("Supplement")});var d=e.get("CIDToGIDMap");(0,n.isStream)(d)&&(s=d.getBytes())}var f,g=[],p=null;if(e.has("Encoding")){f=e.get("Encoding");if((0,n.isDict)(f)){p=f.get("BaseEncoding");p=(0,n.isName)(p)?p.name:null;if(f.has("Differences"))for(var m=f.get("Differences"),b=0,y=0,w=m.length;y<w;y++){var S=i.fetchIfRef(m[y]);if((0,a.isNum)(S))b=S;else{if(!(0,n.isName)(S))throw new a.FormatError(`Invalid entry in 'Differences' array: ${S}`);g[b++]=S.name}}}else{if(!(0,n.isName)(f))throw new a.FormatError("Encoding is not a Name nor a Dict");p=f.name}"MacRomanEncoding"!==p&&"MacExpertEncoding"!==p&&"WinAnsiEncoding"!==p&&(p=null)}if(p)r.defaultEncoding=(0,c.getEncoding)(p).slice();else{var v=!!(r.flags&o.FontFlags.Symbolic),k=!!(r.flags&o.FontFlags.Nonsymbolic);f=c.StandardEncoding;"TrueType"!==r.type||k||(f=c.WinAnsiEncoding);if(v){f=c.MacRomanEncoding;r.file||(/Symbol/i.test(r.name)?f=c.SymbolSetEncoding:/Dingbats|Wingdings/i.test(r.name)&&(f=c.ZapfDingbatsEncoding))}r.defaultEncoding=f}r.differences=g;r.baseEncodingName=p;r.hasEncoding=!!p||g.length>0;r.dict=e;return h.then((e=>{r.toUnicode=e;return this.buildToUnicode(r)})).then((e=>{r.toUnicode=e;s&&(r.cidToGidMap=this.readCidToGidMap(s,e));return r}))}_buildSimpleFontToUnicode(e,t=!1){(0,a.assert)(!e.composite,"Must be a simple font.");const r=[],i=e.defaultEncoding.slice(),n=e.baseEncodingName,s=e.differences;for(const e in s){const t=s[e];".notdef"!==t&&(i[e]=t)}const h=(0,b.getGlyphsUnicode)();for(const a in i){let s=i[a];if(""!==s)if(void 0!==h[s])r[a]=String.fromCharCode(h[s]);else{let i=0;switch(s[0]){case"G":3===s.length&&(i=parseInt(s.substring(1),16));break;case"g":5===s.length&&(i=parseInt(s.substring(1),16));break;case"C":case"c":if(s.length>=3&&s.length<=4){const r=s.substring(1);if(t){i=parseInt(r,16);break}i=+r;if(Number.isNaN(i)&&Number.isInteger(parseInt(r,16)))return this._buildSimpleFontToUnicode(e,!0)}break;default:const r=(0,l.getUnicodeForGlyph)(s,h);-1!==r&&(i=r)}if(i>0&&i<=1114111&&Number.isInteger(i)){if(n&&i===+a){const e=(0,c.getEncoding)(n);if(e&&(s=e[a])){r[a]=String.fromCharCode(h[s]);continue}}r[a]=String.fromCodePoint(i)}}}return new o.ToUnicodeMap(r)}buildToUnicode(e){e.hasIncludedToUnicodeMap=!!e.toUnicode&&e.toUnicode.length>0;if(e.hasIncludedToUnicodeMap){!e.composite&&e.hasEncoding&&(e.fallbackToUnicode=this._buildSimpleFontToUnicode(e));return Promise.resolve(e.toUnicode)}if(!e.composite)return Promise.resolve(this._buildSimpleFontToUnicode(e));if(e.composite&&(e.cMap.builtInCMap&&!(e.cMap instanceof i.IdentityCMap)||"Adobe"===e.cidSystemInfo.registry&&("GB1"===e.cidSystemInfo.ordering||"CNS1"===e.cidSystemInfo.ordering||"Japan1"===e.cidSystemInfo.ordering||"Korea1"===e.cidSystemInfo.ordering))){const t=e.cidSystemInfo.registry,r=e.cidSystemInfo.ordering,s=n.Name.get(t+"-"+r+"-UCS2");return i.CMapFactory.create({encoding:s,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(t){const r=e.cMap,i=[];r.forEach((function(e,r){if(r>65535)throw new a.FormatError("Max size of CID is 65,535");const n=t.lookup(r);n&&(i[e]=String.fromCharCode((n.charCodeAt(0)<<8)+n.charCodeAt(1)))}));return new o.ToUnicodeMap(i)}))}return Promise.resolve(new o.IdentityToUnicodeMap(e.firstChar,e.lastChar))}readToUnicode(e){var t=e;return(0,n.isName)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(e){return e instanceof i.IdentityCMap?new o.IdentityToUnicodeMap(0,65535):new o.ToUnicodeMap(e.getMap())})):(0,n.isStream)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then((function(e){if(e instanceof i.IdentityCMap)return new o.IdentityToUnicodeMap(0,65535);var t=new Array(e.length);e.forEach((function(e,r){for(var a=[],i=0;i<r.length;i+=2){var n=r.charCodeAt(i)<<8|r.charCodeAt(i+1);if(55296==(63488&n)){i+=2;var s=r.charCodeAt(i)<<8|r.charCodeAt(i+1);a.push(((1023&n)<<10)+(1023&s)+65536)}else a.push(n)}t[e]=String.fromCodePoint.apply(String,a)}));return new o.ToUnicodeMap(t)}),(e=>{if(e instanceof a.AbortException)return null;if(this.options.ignoreErrors){this.handler.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.errorFontToUnicode});(0,a.warn)(`readToUnicode - ignoring ToUnicode data: "${e}".`);return null}throw e})):Promise.resolve(null)}readCidToGidMap(e,t){for(var r=[],a=0,i=e.length;a<i;a++){var n=e[a++]<<8|e[a];const i=a>>1;(0!==n||t.has(i))&&(r[i]=n)}return r}extractWidths(e,t,r){var a,i,s,c,l,h,u,d,f=this.xref,g=[],p=0,m=[];if(r.composite){p=e.has("DW")?e.get("DW"):1e3;if(d=e.get("W"))for(i=0,s=d.length;i<s;i++){h=f.fetchIfRef(d[i++]);u=f.fetchIfRef(d[i]);if(Array.isArray(u))for(c=0,l=u.length;c<l;c++)g[h++]=f.fetchIfRef(u[c]);else{var b=f.fetchIfRef(d[++i]);for(c=h;c<=u;c++)g[c]=b}}if(r.vertical){var y=e.getArray("DW2")||[880,-1e3];a=[y[1],.5*p,y[0]];if(y=e.get("W2"))for(i=0,s=y.length;i<s;i++){h=f.fetchIfRef(y[i++]);u=f.fetchIfRef(y[i]);if(Array.isArray(u))for(c=0,l=u.length;c<l;c++)m[h++]=[f.fetchIfRef(u[c++]),f.fetchIfRef(u[c++]),f.fetchIfRef(u[c])];else{var w=[f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i])];for(c=h;c<=u;c++)m[c]=w}}}}else{var S=r.firstChar;if(d=e.get("Widths")){c=S;for(i=0,s=d.length;i<s;i++)g[c++]=f.fetchIfRef(d[i]);p=parseFloat(t.get("MissingWidth"))||0}else{var v=e.get("BaseFont");if((0,n.isName)(v)){var k=this.getBaseFontMetrics(v.name);g=this.buildCharCodeToWidth(k.widths,r);p=k.defaultWidth}}}var x=!0,C=p;for(var O in g){var F=g[O];if(F)if(C){if(C!==F){x=!1;break}}else C=F}x&&(r.flags|=o.FontFlags.FixedPitch);r.defaultWidth=p;r.widths=g;r.defaultVMetrics=a;r.vmetrics=m}isSerifFont(e){var t=e.split("-")[0];return t in(0,h.getSerifFonts)()||-1!==t.search(/serif/gi)}getBaseFontMetrics(e){var t=0,r=Object.create(null),i=!1,n=(0,h.getStdFontMap)()[e]||e,s=(0,w.getMetrics)();n in s||(n=this.isSerifFont(e)?"Times-Roman":"Helvetica");var o=s[n];if((0,a.isNum)(o)){t=o;i=!0}else r=o();return{defaultWidth:t,monospace:i,widths:r}}buildCharCodeToWidth(e,t){for(var r=Object.create(null),a=t.differences,i=t.defaultEncoding,n=0;n<256;n++)n in a&&e[a[n]]?r[n]=e[a[n]]:n in i&&e[i[n]]&&(r[n]=e[i[n]]);return r}preEvaluateFont(e){var t=e,r=e.get("Subtype");if(!(0,n.isName)(r))throw new a.FormatError("invalid font Subtype");var i,s=!1;if("Type0"===r.name){var o=e.get("DescendantFonts");if(!o)throw new a.FormatError("Descendant fonts are not specified");if(!((e=Array.isArray(o)?this.xref.fetchIfRef(o[0]):o)instanceof n.Dict))throw new a.FormatError("Descendant font is not a dictionary.");r=e.get("Subtype");if(!(0,n.isName)(r))throw new a.FormatError("invalid font Subtype");s=!0}var c=e.get("FontDescriptor");if(c){var l=new S.MurmurHash3_64,h=t.getRaw("Encoding");if((0,n.isName)(h))l.update(h.name);else if((0,n.isRef)(h))l.update(h.toString());else if((0,n.isDict)(h))for(const e of h.getRawValues())if((0,n.isName)(e))l.update(e.name);else if((0,n.isRef)(e))l.update(e.toString());else if(Array.isArray(e)){for(var u=e.length,d=new Array(u),f=0;f<u;f++){var g=e[f];(0,n.isName)(g)?d[f]=g.name:((0,a.isNum)(g)||(0,n.isRef)(g))&&(d[f]=g.toString())}l.update(d.join())}const r=e.get("FirstChar")||0,o=e.get("LastChar")||(s?65535:255);l.update(`${r}-${o}`);var p=e.get("ToUnicode")||t.get("ToUnicode");if((0,n.isStream)(p)){var m=p.str||p;i=m.buffer?new Uint8Array(m.buffer.buffer,0,m.bufferLength):new Uint8Array(m.bytes.buffer,m.start,m.end-m.start);l.update(i)}else(0,n.isName)(p)&&l.update(p.name);var b=e.get("Widths")||t.get("Widths");if(b){i=new Uint8Array(new Uint32Array(b).buffer);l.update(i)}}return{descriptor:c,dict:e,baseDict:t,composite:s,type:r.name,hash:l?l.hexdigest():""}}async translateFont(e){var t,r=e.baseDict,c=e.dict,l=e.composite,u=e.descriptor,d=e.type,f=l?65535:255;const g=c.get("FirstChar")||0,p=c.get("LastChar")||f;if(!u){if("Type3"!==d){var m=c.get("BaseFont");if(!(0,n.isName)(m))throw new a.FormatError("Base font is not specified");m=m.name.replace(/[,_]/g,"-");var b=this.getBaseFontMetrics(m),y=m.split("-")[0],w=(this.isSerifFont(y)?o.FontFlags.Serif:0)|(b.monospace?o.FontFlags.FixedPitch:0)|((0,h.getSymbolsFonts)()[y]?o.FontFlags.Symbolic:o.FontFlags.Nonsymbolic);t={type:d,name:m,widths:b.widths,defaultWidth:b.defaultWidth,flags:w,firstChar:g,lastChar:p};const e=c.get("Widths");return this.extractDataStructures(c,c,t).then((t=>{if(e){const r=[];let a=g;for(let t=0,i=e.length;t<i;t++)r[a++]=this.xref.fetchIfRef(e[t]);t.widths=r}else t.widths=this.buildCharCodeToWidth(b.widths,t);return new o.Font(m,null,t)}))}(u=new n.Dict(null)).set("FontName",n.Name.get(d));u.set("FontBBox",c.getArray("FontBBox")||[0,0,0,0])}var S=u.get("FontName"),v=c.get("BaseFont");(0,a.isString)(S)&&(S=n.Name.get(S));(0,a.isString)(v)&&(v=n.Name.get(v));if("Type3"!==d){var k=S&&S.name,x=v&&v.name;if(k!==x){(0,a.info)(`The FontDescriptor's FontName is "${k}" but should be the same as the Font's BaseFont "${x}".`);k&&x&&x.startsWith(k)&&(S=v)}}S=S||v;if(!(0,n.isName)(S))throw new a.FormatError("invalid font name");let C;try{C=u.get("FontFile","FontFile2","FontFile3")}catch(e){if(!this.options.ignoreErrors)throw e;(0,a.warn)(`translateFont - fetching "${S.name}" font file: "${e}".`);C=new s.NullStream}if(C&&C.dict){var O=C.dict.get("Subtype");O&&(O=O.name);var F=C.dict.get("Length1"),T=C.dict.get("Length2"),E=C.dict.get("Length3")}t={type:d,name:S.name,subtype:O,file:C,length1:F,length2:T,length3:E,loadedName:r.loadedName,composite:l,fixedPitch:!1,fontMatrix:c.getArray("FontMatrix")||a.FONT_IDENTITY_MATRIX,firstChar:g||0,lastChar:p||f,bbox:u.getArray("FontBBox"),ascent:u.get("Ascent"),descent:u.get("Descent"),xHeight:u.get("XHeight"),capHeight:u.get("CapHeight"),flags:u.get("Flags"),italicAngle:u.get("ItalicAngle"),isType3Font:!1};if(l){const e=r.get("Encoding");(0,n.isName)(e)&&(t.cidEncoding=e.name);const a=await i.CMapFactory.create({encoding:e,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null});t.cMap=a;t.vertical=t.cMap.vertical}return this.extractDataStructures(c,r,t).then((e=>{this.extractWidths(c,u,e);"Type3"===d&&(e.isType3Font=!0);return new o.Font(S.name,C,e)}))}static buildFontPaths(e,t,r){function buildPath(t){e.renderer.hasBuiltPath(t)||r.send("commonobj",[`${e.loadedName}_path_${t}`,"FontPath",e.renderer.getPathJs(t)])}for(const e of t){buildPath(e.fontChar);const t=e.accent;t&&t.fontChar&&buildPath(t.fontChar)}}static get fallbackFontDict(){const e=new n.Dict;e.set("BaseFont",n.Name.get("PDFJS-FallbackFont"));e.set("Type",n.Name.get("FallbackType"));e.set("Subtype",n.Name.get("FallbackType"));e.set("Encoding",n.Name.get("WinAnsiEncoding"));return(0,a.shadow)(this,"fallbackFontDict",e)}}t.PartialEvaluator=PartialEvaluator;class TranslatedFont{constructor({loadedName:e,font:t,dict:r,extraProperties:a=!1}){this.loadedName=e;this.font=t;this.dict=r;this._extraProperties=a;this.type3Loaded=null;this.type3Dependencies=t.isType3Font?new Set:null;this.sent=!1}send(e){if(!this.sent){this.sent=!0;e.send("commonobj",[this.loadedName,"Font",this.font.exportData(this._extraProperties)])}}fallback(e){if(!this.font.data)return;this.font.disableFontFace=!0;const t=this.font.glyphCacheValues;PartialEvaluator.buildFontPaths(this.font,t,e)}loadType3Data(e,t,r){if(this.type3Loaded)return this.type3Loaded;if(!this.font.isType3Font)throw new Error("Must be a Type3 font.");var i=Object.create(e.options);i.ignoreErrors=!1;var n=e.clone(i);n.parsingType3Font=!0;const s=this.font,o=this.type3Dependencies;var c=Promise.resolve(),l=this.dict.get("CharProcs"),h=this.dict.get("Resources")||t,u=Object.create(null);for(const e of l.getKeys())c=c.then((()=>{var t=l.get(e),i=new v.OperatorList;return n.getOperatorList({stream:t,task:r,resources:h,operatorList:i}).then((()=>{i.fnArray[0]===a.OPS.setCharWidthAndBounds&&this._removeType3ColorOperators(i);u[e]=i.getIR();for(const e of i.dependencies)o.add(e)})).catch((function(t){(0,a.warn)(`Type3 font resource "${e}" is not available.`);const r=new v.OperatorList;u[e]=r.getIR()}))}));this.type3Loaded=c.then((function(){s.charProcOperatorList=u}));return this.type3Loaded}_removeType3ColorOperators(e){let t=1,r=e.length;for(;t<r;){switch(e.fnArray[t]){case a.OPS.setStrokeColorSpace:case a.OPS.setFillColorSpace:case a.OPS.setStrokeColor:case a.OPS.setStrokeColorN:case a.OPS.setFillColor:case a.OPS.setFillColorN:case a.OPS.setStrokeGray:case a.OPS.setFillGray:case a.OPS.setStrokeRGBColor:case a.OPS.setFillRGBColor:case a.OPS.setStrokeCMYKColor:case a.OPS.setFillCMYKColor:case a.OPS.shadingFill:case a.OPS.setRenderingIntent:e.fnArray.splice(t,1);e.argsArray.splice(t,1);r--;continue;case a.OPS.setGState:const[i]=e.argsArray[t];let n=0,s=i.length;for(;n<s;){const[e]=i[n];switch(e){case"TR":case"TR2":case"HT":case"BG":case"BG2":case"UCR":case"UCR2":i.splice(n,1);s--;continue}n++}}t++}}}class StateManager{constructor(e=new EvalState){this.state=e;this.stateStack=[]}save(){var e=this.state;this.stateStack.push(this.state);this.state=e.clone()}restore(){var e=this.stateStack.pop();e&&(this.state=e)}transform(e){this.state.ctm=a.Util.transform(this.state.ctm,e)}}class TextState{constructor(){this.ctm=new Float32Array(a.IDENTITY_MATRIX);this.fontName=null;this.fontSize=0;this.font=null;this.fontMatrix=a.FONT_IDENTITY_MATRIX;this.textMatrix=a.IDENTITY_MATRIX.slice();this.textLineMatrix=a.IDENTITY_MATRIX.slice();this.charSpacing=0;this.wordSpacing=0;this.leading=0;this.textHScale=1;this.textRise=0}setTextMatrix(e,t,r,a,i,n){var s=this.textMatrix;s[0]=e;s[1]=t;s[2]=r;s[3]=a;s[4]=i;s[5]=n}setTextLineMatrix(e,t,r,a,i,n){var s=this.textLineMatrix;s[0]=e;s[1]=t;s[2]=r;s[3]=a;s[4]=i;s[5]=n}translateTextMatrix(e,t){var r=this.textMatrix;r[4]=r[0]*e+r[2]*t+r[4];r[5]=r[1]*e+r[3]*t+r[5]}translateTextLineMatrix(e,t){var r=this.textLineMatrix;r[4]=r[0]*e+r[2]*t+r[4];r[5]=r[1]*e+r[3]*t+r[5]}calcTextLineMatrixAdvance(e,t,r,a,i,n){var s=this.font;if(!s)return null;var o=this.textLineMatrix;if(e!==o[0]||t!==o[1]||r!==o[2]||a!==o[3])return null;var c=i-o[4],l=n-o[5];if(s.vertical&&0!==c||!s.vertical&&0!==l)return null;var h,u,d=e*a-t*r;if(s.vertical){h=-l*r/d;u=l*e/d}else{h=c*a/d;u=-c*t/d}return{width:h,height:u,value:s.vertical?u:h}}calcRenderMatrix(e){var t=[this.fontSize*this.textHScale,0,0,this.fontSize,0,this.textRise];return a.Util.transform(e,a.Util.transform(this.textMatrix,t))}carriageReturn(){this.translateTextLineMatrix(0,-this.leading);this.textMatrix=this.textLineMatrix.slice()}clone(){var e=Object.create(this);e.textMatrix=this.textMatrix.slice();e.textLineMatrix=this.textLineMatrix.slice();e.fontMatrix=this.fontMatrix.slice();return e}}class EvalState{constructor(){this.ctm=new Float32Array(a.IDENTITY_MATRIX);this.font=null;this.textRenderingMode=a.TextRenderingMode.FILL;this.fillColorSpace=m.ColorSpace.singletons.gray;this.strokeColorSpace=m.ColorSpace.singletons.gray}clone(){return Object.create(this)}}class EvaluatorPreprocessor{static get opMap(){const e=(0,y.getLookupTableFactory)((function(e){e.w={id:a.OPS.setLineWidth,numArgs:1,variableArgs:!1};e.J={id:a.OPS.setLineCap,numArgs:1,variableArgs:!1};e.j={id:a.OPS.setLineJoin,numArgs:1,variableArgs:!1};e.M={id:a.OPS.setMiterLimit,numArgs:1,variableArgs:!1};e.d={id:a.OPS.setDash,numArgs:2,variableArgs:!1};e.ri={id:a.OPS.setRenderingIntent,numArgs:1,variableArgs:!1};e.i={id:a.OPS.setFlatness,numArgs:1,variableArgs:!1};e.gs={id:a.OPS.setGState,numArgs:1,variableArgs:!1};e.q={id:a.OPS.save,numArgs:0,variableArgs:!1};e.Q={id:a.OPS.restore,numArgs:0,variableArgs:!1};e.cm={id:a.OPS.transform,numArgs:6,variableArgs:!1};e.m={id:a.OPS.moveTo,numArgs:2,variableArgs:!1};e.l={id:a.OPS.lineTo,numArgs:2,variableArgs:!1};e.c={id:a.OPS.curveTo,numArgs:6,variableArgs:!1};e.v={id:a.OPS.curveTo2,numArgs:4,variableArgs:!1};e.y={id:a.OPS.curveTo3,numArgs:4,variableArgs:!1};e.h={id:a.OPS.closePath,numArgs:0,variableArgs:!1};e.re={id:a.OPS.rectangle,numArgs:4,variableArgs:!1};e.S={id:a.OPS.stroke,numArgs:0,variableArgs:!1};e.s={id:a.OPS.closeStroke,numArgs:0,variableArgs:!1};e.f={id:a.OPS.fill,numArgs:0,variableArgs:!1};e.F={id:a.OPS.fill,numArgs:0,variableArgs:!1};e["f*"]={id:a.OPS.eoFill,numArgs:0,variableArgs:!1};e.B={id:a.OPS.fillStroke,numArgs:0,variableArgs:!1};e["B*"]={id:a.OPS.eoFillStroke,numArgs:0,variableArgs:!1};e.b={id:a.OPS.closeFillStroke,numArgs:0,variableArgs:!1};e["b*"]={id:a.OPS.closeEOFillStroke,numArgs:0,variableArgs:!1};e.n={id:a.OPS.endPath,numArgs:0,variableArgs:!1};e.W={id:a.OPS.clip,numArgs:0,variableArgs:!1};e["W*"]={id:a.OPS.eoClip,numArgs:0,variableArgs:!1};e.BT={id:a.OPS.beginText,numArgs:0,variableArgs:!1};e.ET={id:a.OPS.endText,numArgs:0,variableArgs:!1};e.Tc={id:a.OPS.setCharSpacing,numArgs:1,variableArgs:!1};e.Tw={id:a.OPS.setWordSpacing,numArgs:1,variableArgs:!1};e.Tz={id:a.OPS.setHScale,numArgs:1,variableArgs:!1};e.TL={id:a.OPS.setLeading,numArgs:1,variableArgs:!1};e.Tf={id:a.OPS.setFont,numArgs:2,variableArgs:!1};e.Tr={id:a.OPS.setTextRenderingMode,numArgs:1,variableArgs:!1};e.Ts={id:a.OPS.setTextRise,numArgs:1,variableArgs:!1};e.Td={id:a.OPS.moveText,numArgs:2,variableArgs:!1};e.TD={id:a.OPS.setLeadingMoveText,numArgs:2,variableArgs:!1};e.Tm={id:a.OPS.setTextMatrix,numArgs:6,variableArgs:!1};e["T*"]={id:a.OPS.nextLine,numArgs:0,variableArgs:!1};e.Tj={id:a.OPS.showText,numArgs:1,variableArgs:!1};e.TJ={id:a.OPS.showSpacedText,numArgs:1,variableArgs:!1};e["'"]={id:a.OPS.nextLineShowText,numArgs:1,variableArgs:!1};e['"']={id:a.OPS.nextLineSetSpacingShowText,numArgs:3,variableArgs:!1};e.d0={id:a.OPS.setCharWidth,numArgs:2,variableArgs:!1};e.d1={id:a.OPS.setCharWidthAndBounds,numArgs:6,variableArgs:!1};e.CS={id:a.OPS.setStrokeColorSpace,numArgs:1,variableArgs:!1};e.cs={id:a.OPS.setFillColorSpace,numArgs:1,variableArgs:!1};e.SC={id:a.OPS.setStrokeColor,numArgs:4,variableArgs:!0};e.SCN={id:a.OPS.setStrokeColorN,numArgs:33,variableArgs:!0};e.sc={id:a.OPS.setFillColor,numArgs:4,variableArgs:!0};e.scn={id:a.OPS.setFillColorN,numArgs:33,variableArgs:!0};e.G={id:a.OPS.setStrokeGray,numArgs:1,variableArgs:!1};e.g={id:a.OPS.setFillGray,numArgs:1,variableArgs:!1};e.RG={id:a.OPS.setStrokeRGBColor,numArgs:3,variableArgs:!1};e.rg={id:a.OPS.setFillRGBColor,numArgs:3,variableArgs:!1};e.K={id:a.OPS.setStrokeCMYKColor,numArgs:4,variableArgs:!1};e.k={id:a.OPS.setFillCMYKColor,numArgs:4,variableArgs:!1};e.sh={id:a.OPS.shadingFill,numArgs:1,variableArgs:!1};e.BI={id:a.OPS.beginInlineImage,numArgs:0,variableArgs:!1};e.ID={id:a.OPS.beginImageData,numArgs:0,variableArgs:!1};e.EI={id:a.OPS.endInlineImage,numArgs:1,variableArgs:!1};e.Do={id:a.OPS.paintXObject,numArgs:1,variableArgs:!1};e.MP={id:a.OPS.markPoint,numArgs:1,variableArgs:!1};e.DP={id:a.OPS.markPointProps,numArgs:2,variableArgs:!1};e.BMC={id:a.OPS.beginMarkedContent,numArgs:1,variableArgs:!1};e.BDC={id:a.OPS.beginMarkedContentProps,numArgs:2,variableArgs:!1};e.EMC={id:a.OPS.endMarkedContent,numArgs:0,variableArgs:!1};e.BX={id:a.OPS.beginCompat,numArgs:0,variableArgs:!1};e.EX={id:a.OPS.endCompat,numArgs:0,variableArgs:!1};e.BM=null;e.BD=null;e.true=null;e.fa=null;e.fal=null;e.fals=null;e.false=null;e.nu=null;e.nul=null;e.null=null}));return(0,a.shadow)(this,"opMap",e())}static get MAX_INVALID_PATH_OPS(){return(0,a.shadow)(this,"MAX_INVALID_PATH_OPS",20)}constructor(e,t,r=new StateManager){this.parser=new f.Parser({lexer:new f.Lexer(e,EvaluatorPreprocessor.opMap),xref:t});this.stateManager=r;this.nonProcessedArgs=[];this._numInvalidPathOPS=0}get savedStatesDepth(){return this.stateManager.stateStack.length}read(e){for(var t=e.args;;){var r=this.parser.getObj();if(r instanceof n.Cmd){var i=r.cmd,s=EvaluatorPreprocessor.opMap[i];if(!s){(0,a.warn)(`Unknown command "${i}".`);continue}var o=s.id,c=s.numArgs,l=null!==t?t.length:0;if(s.variableArgs)l>c&&(0,a.info)(`Command ${i}: expected [0, ${c}] args, but received ${l} args.`);else{if(l!==c){for(var h=this.nonProcessedArgs;l>c;){h.push(t.shift());l--}for(;l<c&&0!==h.length;){null===t&&(t=[]);t.unshift(h.pop());l++}}if(l<c){const e=`command ${i}: expected ${c} args, but received ${l} args.`;if(o>=a.OPS.moveTo&&o<=a.OPS.endPath&&++this._numInvalidPathOPS>EvaluatorPreprocessor.MAX_INVALID_PATH_OPS)throw new a.FormatError(`Invalid ${e}`);(0,a.warn)(`Skipping ${e}`);null!==t&&(t.length=0);continue}}this.preprocessCommand(o,t);e.fn=o;e.args=t;return!0}if(r===n.EOF)return!1;if(null!==r){null===t&&(t=[]);t.push(r);if(t.length>33)throw new a.FormatError("Too many arguments")}}}preprocessCommand(e,t){switch(0|e){case a.OPS.save:this.stateManager.save();break;case a.OPS.restore:this.stateManager.restore();break;case a.OPS.transform:this.stateManager.transform(t)}}}t.EvaluatorPreprocessor=EvaluatorPreprocessor},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.IdentityCMap=t.CMapFactory=t.CMap=void 0;var a=r(2),i=r(5),n=r(11),s=r(8),o=r(12),c=["Adobe-GB1-UCS2","Adobe-CNS1-UCS2","Adobe-Japan1-UCS2","Adobe-Korea1-UCS2","78-EUC-H","78-EUC-V","78-H","78-RKSJ-H","78-RKSJ-V","78-V","78ms-RKSJ-H","78ms-RKSJ-V","83pv-RKSJ-H","90ms-RKSJ-H","90ms-RKSJ-V","90msp-RKSJ-H","90msp-RKSJ-V","90pv-RKSJ-H","90pv-RKSJ-V","Add-H","Add-RKSJ-H","Add-RKSJ-V","Add-V","Adobe-CNS1-0","Adobe-CNS1-1","Adobe-CNS1-2","Adobe-CNS1-3","Adobe-CNS1-4","Adobe-CNS1-5","Adobe-CNS1-6","Adobe-GB1-0","Adobe-GB1-1","Adobe-GB1-2","Adobe-GB1-3","Adobe-GB1-4","Adobe-GB1-5","Adobe-Japan1-0","Adobe-Japan1-1","Adobe-Japan1-2","Adobe-Japan1-3","Adobe-Japan1-4","Adobe-Japan1-5","Adobe-Japan1-6","Adobe-Korea1-0","Adobe-Korea1-1","Adobe-Korea1-2","B5-H","B5-V","B5pc-H","B5pc-V","CNS-EUC-H","CNS-EUC-V","CNS1-H","CNS1-V","CNS2-H","CNS2-V","ETHK-B5-H","ETHK-B5-V","ETen-B5-H","ETen-B5-V","ETenms-B5-H","ETenms-B5-V","EUC-H","EUC-V","Ext-H","Ext-RKSJ-H","Ext-RKSJ-V","Ext-V","GB-EUC-H","GB-EUC-V","GB-H","GB-V","GBK-EUC-H","GBK-EUC-V","GBK2K-H","GBK2K-V","GBKp-EUC-H","GBKp-EUC-V","GBT-EUC-H","GBT-EUC-V","GBT-H","GBT-V","GBTpc-EUC-H","GBTpc-EUC-V","GBpc-EUC-H","GBpc-EUC-V","H","HKdla-B5-H","HKdla-B5-V","HKdlb-B5-H","HKdlb-B5-V","HKgccs-B5-H","HKgccs-B5-V","HKm314-B5-H","HKm314-B5-V","HKm471-B5-H","HKm471-B5-V","HKscs-B5-H","HKscs-B5-V","Hankaku","Hiragana","KSC-EUC-H","KSC-EUC-V","KSC-H","KSC-Johab-H","KSC-Johab-V","KSC-V","KSCms-UHC-H","KSCms-UHC-HW-H","KSCms-UHC-HW-V","KSCms-UHC-V","KSCpc-EUC-H","KSCpc-EUC-V","Katakana","NWP-H","NWP-V","RKSJ-H","RKSJ-V","Roman","UniCNS-UCS2-H","UniCNS-UCS2-V","UniCNS-UTF16-H","UniCNS-UTF16-V","UniCNS-UTF32-H","UniCNS-UTF32-V","UniCNS-UTF8-H","UniCNS-UTF8-V","UniGB-UCS2-H","UniGB-UCS2-V","UniGB-UTF16-H","UniGB-UTF16-V","UniGB-UTF32-H","UniGB-UTF32-V","UniGB-UTF8-H","UniGB-UTF8-V","UniJIS-UCS2-H","UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-V","UniJIS-UCS2-V","UniJIS-UTF16-H","UniJIS-UTF16-V","UniJIS-UTF32-H","UniJIS-UTF32-V","UniJIS-UTF8-H","UniJIS-UTF8-V","UniJIS2004-UTF16-H","UniJIS2004-UTF16-V","UniJIS2004-UTF32-H","UniJIS2004-UTF32-V","UniJIS2004-UTF8-H","UniJIS2004-UTF8-V","UniJISPro-UCS2-HW-V","UniJISPro-UCS2-V","UniJISPro-UTF8-V","UniJISX0213-UTF32-H","UniJISX0213-UTF32-V","UniJISX02132004-UTF32-H","UniJISX02132004-UTF32-V","UniKS-UCS2-H","UniKS-UCS2-V","UniKS-UTF16-H","UniKS-UTF16-V","UniKS-UTF32-H","UniKS-UTF32-V","UniKS-UTF8-H","UniKS-UTF8-V","V","WP-Symbol"];const l=2**24-1;class CMap{constructor(e=!1){this.codespaceRanges=[[],[],[],[]];this.numCodespaceRanges=0;this._map=[];this.name="";this.vertical=!1;this.useCMap=null;this.builtInCMap=e}addCodespaceRange(e,t,r){this.codespaceRanges[e-1].push(t,r);this.numCodespaceRanges++}mapCidRange(e,t,r){if(t-e>l)throw new Error("mapCidRange - ignoring data above MAX_MAP_RANGE.");for(;e<=t;)this._map[e++]=r++}mapBfRange(e,t,r){if(t-e>l)throw new Error("mapBfRange - ignoring data above MAX_MAP_RANGE.");for(var a=r.length-1;e<=t;){this._map[e++]=r;r=r.substring(0,a)+String.fromCharCode(r.charCodeAt(a)+1)}}mapBfRangeToArray(e,t,r){if(t-e>l)throw new Error("mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.");const a=r.length;let i=0;for(;e<=t&&i<a;){this._map[e]=r[i++];++e}}mapOne(e,t){this._map[e]=t}lookup(e){return this._map[e]}contains(e){return void 0!==this._map[e]}forEach(e){const t=this._map,r=t.length;if(r<=65536)for(let a=0;a<r;a++)void 0!==t[a]&&e(a,t[a]);else for(const r in t)e(r,t[r])}charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const r in t)if(t[r]===e)return 0|r;return-1}getMap(){return this._map}readCharCode(e,t,r){let a=0;const i=this.codespaceRanges;for(let n=0,s=i.length;n<s;n++){a=(a<<8|e.charCodeAt(t+n))>>>0;const s=i[n];for(let e=0,t=s.length;e<t;){const t=s[e++],i=s[e++];if(a>=t&&a<=i){r.charcode=a;r.length=n+1;return}}}r.charcode=0;r.length=1}getCharCodeLength(e){const t=this.codespaceRanges;for(let r=0,a=t.length;r<a;r++){const a=t[r];for(let t=0,i=a.length;t<i;){const i=a[t++],n=a[t++];if(e>=i&&e<=n)return r+1}}return 1}get length(){return this._map.length}get isIdentityCMap(){if("Identity-H"!==this.name&&"Identity-V"!==this.name)return!1;if(65536!==this._map.length)return!1;for(let e=0;e<65536;e++)if(this._map[e]!==e)return!1;return!0}}t.CMap=CMap;class IdentityCMap extends CMap{constructor(e,t){super();this.vertical=e;this.addCodespaceRange(t,0,65535)}mapCidRange(e,t,r){(0,a.unreachable)("should not call mapCidRange")}mapBfRange(e,t,r){(0,a.unreachable)("should not call mapBfRange")}mapBfRangeToArray(e,t,r){(0,a.unreachable)("should not call mapBfRangeToArray")}mapOne(e,t){(0,a.unreachable)("should not call mapCidOne")}lookup(e){return Number.isInteger(e)&&e<=65535?e:void 0}contains(e){return Number.isInteger(e)&&e<=65535}forEach(e){for(let t=0;t<=65535;t++)e(t,t)}charCodeOf(e){return Number.isInteger(e)&&e<=65535?e:-1}getMap(){const e=new Array(65536);for(let t=0;t<=65535;t++)e[t]=t;return e}get length(){return 65536}get isIdentityCMap(){(0,a.unreachable)("should not access .isIdentityCMap")}}t.IdentityCMap=IdentityCMap;var h=function BinaryCMapReaderClosure(){function hexToInt(e,t){for(var r=0,a=0;a<=t;a++)r=r<<8|e[a];return r>>>0}function hexToStr(e,t){return 1===t?String.fromCharCode(e[0],e[1]):3===t?String.fromCharCode(e[0],e[1],e[2],e[3]):String.fromCharCode.apply(null,e.subarray(0,t+1))}function addHex(e,t,r){for(var a=0,i=r;i>=0;i--){a+=e[i]+t[i];e[i]=255&a;a>>=8}}function incHex(e,t){for(var r=1,a=t;a>=0&&r>0;a--){r+=e[a];e[a]=255&r;r>>=8}}var e=16;class BinaryCMapStream{constructor(e){this.buffer=e;this.pos=0;this.end=e.length;this.tmpBuf=new Uint8Array(19)}readByte(){return this.pos>=this.end?-1:this.buffer[this.pos++]}readNumber(){var e,t=0;do{var r=this.readByte();if(r<0)throw new a.FormatError("unexpected EOF in bcmap");e=!(128&r);t=t<<7|127&r}while(!e);return t}readSigned(){var e=this.readNumber();return 1&e?~(e>>>1):e>>>1}readHex(e,t){e.set(this.buffer.subarray(this.pos,this.pos+t+1));this.pos+=t+1}readHexNumber(e,t){var r,i=this.tmpBuf,n=0;do{var s=this.readByte();if(s<0)throw new a.FormatError("unexpected EOF in bcmap");r=!(128&s);i[n++]=127&s}while(!r);for(var o=t,c=0,l=0;o>=0;){for(;l<8&&i.length>0;){c=i[--n]<<l|c;l+=7}e[o]=255&c;o--;c>>=8;l-=8}}readHexSigned(e,t){this.readHexNumber(e,t);for(var r=1&e[t]?255:0,a=0,i=0;i<=t;i++){a=(1&a)<<8|e[i];e[i]=a>>1^r}}readString(){for(var e=this.readNumber(),t="",r=0;r<e;r++)t+=String.fromCharCode(this.readNumber());return t}}return class BinaryCMapReader{async process(t,r,a){var i=new BinaryCMapStream(t),n=i.readByte();r.vertical=!!(1&n);for(var s,o,c=null,l=new Uint8Array(e),h=new Uint8Array(e),u=new Uint8Array(e),d=new Uint8Array(e),f=new Uint8Array(e);(o=i.readByte())>=0;){var g=o>>5;if(7!==g){var p=!!(16&o),m=15&o;if(m+1>e)throw new Error("BinaryCMapReader.process: Invalid dataSize.");var b,y=i.readNumber();switch(g){case 0:i.readHex(l,m);i.readHexNumber(h,m);addHex(h,l,m);r.addCodespaceRange(m+1,hexToInt(l,m),hexToInt(h,m));for(b=1;b<y;b++){incHex(h,m);i.readHexNumber(l,m);addHex(l,h,m);i.readHexNumber(h,m);addHex(h,l,m);r.addCodespaceRange(m+1,hexToInt(l,m),hexToInt(h,m))}break;case 1:i.readHex(l,m);i.readHexNumber(h,m);addHex(h,l,m);i.readNumber();for(b=1;b<y;b++){incHex(h,m);i.readHexNumber(l,m);addHex(l,h,m);i.readHexNumber(h,m);addHex(h,l,m);i.readNumber()}break;case 2:i.readHex(u,m);s=i.readNumber();r.mapOne(hexToInt(u,m),s);for(b=1;b<y;b++){incHex(u,m);if(!p){i.readHexNumber(f,m);addHex(u,f,m)}s=i.readSigned()+(s+1);r.mapOne(hexToInt(u,m),s)}break;case 3:i.readHex(l,m);i.readHexNumber(h,m);addHex(h,l,m);s=i.readNumber();r.mapCidRange(hexToInt(l,m),hexToInt(h,m),s);for(b=1;b<y;b++){incHex(h,m);if(p)l.set(h);else{i.readHexNumber(l,m);addHex(l,h,m)}i.readHexNumber(h,m);addHex(h,l,m);s=i.readNumber();r.mapCidRange(hexToInt(l,m),hexToInt(h,m),s)}break;case 4:i.readHex(u,1);i.readHex(d,m);r.mapOne(hexToInt(u,1),hexToStr(d,m));for(b=1;b<y;b++){incHex(u,1);if(!p){i.readHexNumber(f,1);addHex(u,f,1)}incHex(d,m);i.readHexSigned(f,m);addHex(d,f,m);r.mapOne(hexToInt(u,1),hexToStr(d,m))}break;case 5:i.readHex(l,1);i.readHexNumber(h,1);addHex(h,l,1);i.readHex(d,m);r.mapBfRange(hexToInt(l,1),hexToInt(h,1),hexToStr(d,m));for(b=1;b<y;b++){incHex(h,1);if(p)l.set(h);else{i.readHexNumber(l,1);addHex(l,h,1)}i.readHexNumber(h,1);addHex(h,l,1);i.readHex(d,m);r.mapBfRange(hexToInt(l,1),hexToInt(h,1),hexToStr(d,m))}break;default:throw new Error(`BinaryCMapReader.process - unknown type: ${g}`)}}else switch(31&o){case 0:i.readString();break;case 1:c=i.readString()}}return c?a(c):r}}}(),u=function CMapFactoryClosure(){function strToInt(e){for(var t=0,r=0;r<e.length;r++)t=t<<8|e.charCodeAt(r);return t>>>0}function expectString(e){if(!(0,a.isString)(e))throw new a.FormatError("Malformed CMap: expected string.")}function expectInt(e){if(!Number.isInteger(e))throw new a.FormatError("Malformed CMap: expected int.")}function parseBfChar(e,t){for(;;){var r=t.getObj();if((0,i.isEOF)(r))break;if((0,i.isCmd)(r,"endbfchar"))return;expectString(r);var a=strToInt(r);expectString(r=t.getObj());var n=r;e.mapOne(a,n)}}function parseBfRange(e,t){for(;;){var r=t.getObj();if((0,i.isEOF)(r))break;if((0,i.isCmd)(r,"endbfrange"))return;expectString(r);var n=strToInt(r);expectString(r=t.getObj());var s=strToInt(r);r=t.getObj();if(Number.isInteger(r)||(0,a.isString)(r)){var o=Number.isInteger(r)?String.fromCharCode(r):r;e.mapBfRange(n,s,o)}else{if(!(0,i.isCmd)(r,"["))break;r=t.getObj();for(var c=[];!(0,i.isCmd)(r,"]")&&!(0,i.isEOF)(r);){c.push(r);r=t.getObj()}e.mapBfRangeToArray(n,s,c)}}throw new a.FormatError("Invalid bf range.")}function parseCidChar(e,t){for(;;){var r=t.getObj();if((0,i.isEOF)(r))break;if((0,i.isCmd)(r,"endcidchar"))return;expectString(r);var a=strToInt(r);expectInt(r=t.getObj());var n=r;e.mapOne(a,n)}}function parseCidRange(e,t){for(;;){var r=t.getObj();if((0,i.isEOF)(r))break;if((0,i.isCmd)(r,"endcidrange"))return;expectString(r);var a=strToInt(r);expectString(r=t.getObj());var n=strToInt(r);expectInt(r=t.getObj());var s=r;e.mapCidRange(a,n,s)}}function parseCodespaceRange(e,t){for(;;){var r=t.getObj();if((0,i.isEOF)(r))break;if((0,i.isCmd)(r,"endcodespacerange"))return;if(!(0,a.isString)(r))break;var n=strToInt(r);r=t.getObj();if(!(0,a.isString)(r))break;var s=strToInt(r);e.addCodespaceRange(r.length,n,s)}throw new a.FormatError("Invalid codespace range.")}function parseWMode(e,t){var r=t.getObj();Number.isInteger(r)&&(e.vertical=!!r)}function parseCMapName(e,t){var r=t.getObj();(0,i.isName)(r)&&(0,a.isString)(r.name)&&(e.name=r.name)}async function parseCMap(e,t,r,n){var o,c;e:for(;;)try{var l=t.getObj();if((0,i.isEOF)(l))break;if((0,i.isName)(l)){"WMode"===l.name?parseWMode(e,t):"CMapName"===l.name&&parseCMapName(e,t);o=l}else if((0,i.isCmd)(l))switch(l.cmd){case"endcmap":break e;case"usecmap":(0,i.isName)(o)&&(c=o.name);break;case"begincodespacerange":parseCodespaceRange(e,t);break;case"beginbfchar":parseBfChar(e,t);break;case"begincidchar":parseCidChar(e,t);break;case"beginbfrange":parseBfRange(e,t);break;case"begincidrange":parseCidRange(e,t)}}catch(e){if(e instanceof s.MissingDataException)throw e;(0,a.warn)("Invalid cMap data: "+e);continue}!n&&c&&(n=c);return n?extendCMap(e,r,n):e}async function extendCMap(e,t,r){e.useCMap=await createBuiltInCMap(r,t);if(0===e.numCodespaceRanges){for(var a=e.useCMap.codespaceRanges,i=0;i<a.length;i++)e.codespaceRanges[i]=a[i].slice();e.numCodespaceRanges=e.useCMap.numCodespaceRanges}e.useCMap.forEach((function(t,r){e.contains(t)||e.mapOne(t,e.useCMap.lookup(t))}));return e}async function createBuiltInCMap(e,t){if("Identity-H"===e)return new IdentityCMap(!1,2);if("Identity-V"===e)return new IdentityCMap(!0,2);if(!c.includes(e))throw new Error("Unknown CMap name: "+e);if(!t)throw new Error("Built-in CMap parameters are not provided.");const{cMapData:r,compressionType:i}=await t(e);var s=new CMap(!0);if(i===a.CMapCompressionType.BINARY)return(new h).process(r,s,(e=>extendCMap(s,t,e)));if(i===a.CMapCompressionType.NONE){var l=new n.Lexer(new o.Stream(r));return parseCMap(s,l,t,null)}throw new Error("TODO: Only BINARY/NONE CMap compression is currently supported.")}return{async create(e){var t=e.encoding,r=e.fetchBuiltInCMap,a=e.useCMap;if((0,i.isName)(t))return createBuiltInCMap(t.name,r);if((0,i.isStream)(t)){const e=await parseCMap(new CMap,new n.Lexer(t),r,a);return e.isIdentityCMap?createBuiltInCMap(e.name,r):e}throw new Error("Encoding required.")}}}();t.CMapFactory=u},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getFontType=getFontType;t.ToUnicodeMap=t.SEAC_ANALYSIS_ENABLED=t.IdentityToUnicodeMap=t.FontFlags=t.Font=t.ErrorFont=void 0;var a=r(2),i=r(32),n=r(35),s=r(34),o=r(36),c=r(37),l=r(8),h=r(38),u=r(30),d=r(12),f=r(39);const g=[[57344,63743],[1048576,1114109]];var p=1e3,m=!0;t.SEAC_ANALYSIS_ENABLED=m;const b=["ascent","bbox","black","bold","charProcOperatorList","composite","data","defaultVMetrics","defaultWidth","descent","fallbackName","fontMatrix","fontType","isMonospace","isSerifFont","isType3Font","italic","loadedName","mimetype","missingFile","name","remeasure","subtype","type","vertical"],y=["cMap","defaultEncoding","differences","isSymbolicFont","seacMap","toFontChar","toUnicode","vmetrics","widths"];var w={FixedPitch:1,Serif:2,Symbolic:4,Script:8,Nonsymbolic:32,Italic:64,AllCap:65536,SmallCap:131072,ForceBold:262144};t.FontFlags=w;var S=[".notdef",".null","nonmarkingreturn","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","nonbreakingspace","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron","Lslash","lslash","Scaron","scaron","Zcaron","zcaron","brokenbar","Eth","eth","Yacute","yacute","Thorn","thorn","minus","multiply","onesuperior","twosuperior","threesuperior","onehalf","onequarter","threequarters","franc","Gbreve","gbreve","Idotaccent","Scedilla","scedilla","Cacute","cacute","Ccaron","ccaron","dcroat"];function adjustWidths(e){if(e.fontMatrix&&e.fontMatrix[0]!==a.FONT_IDENTITY_MATRIX[0]){var t=.001/e.fontMatrix[0],r=e.widths;for(var i in r)r[i]*=t;e.defaultWidth*=t}}function getFontType(e,t){switch(e){case"Type1":return"Type1C"===t?a.FontType.TYPE1C:a.FontType.TYPE1;case"CIDFontType0":return"CIDFontType0C"===t?a.FontType.CIDFONTTYPE0C:a.FontType.CIDFONTTYPE0;case"OpenType":return a.FontType.OPENTYPE;case"TrueType":return a.FontType.TRUETYPE;case"CIDFontType2":return a.FontType.CIDFONTTYPE2;case"MMType1":return a.FontType.MMTYPE1;case"Type0":return a.FontType.TYPE0;default:return a.FontType.UNKNOWN}}function recoverGlyphName(e,t){if(void 0!==t[e])return e;var r=(0,c.getUnicodeForGlyph)(e,t);if(-1!==r)for(var i in t)if(t[i]===r)return i;(0,a.info)("Unable to recover a standard glyph name for: "+e);return e}var v=function GlyphClosure(){function Glyph(e,t,r,a,i,n,s,o){this.fontChar=e;this.unicode=t;this.accent=r;this.width=a;this.vmetric=i;this.operatorListId=n;this.isSpace=s;this.isInFont=o}Glyph.prototype.matchesForCache=function(e,t,r,a,i,n,s,o){return this.fontChar===e&&this.unicode===t&&this.accent===r&&this.width===a&&this.vmetric===i&&this.operatorListId===n&&this.isSpace===s&&this.isInFont===o};return Glyph}(),k=function ToUnicodeMapClosure(){function ToUnicodeMap(e=[]){this._map=e}ToUnicodeMap.prototype={get length(){return this._map.length},forEach(e){for(var t in this._map)e(t,this._map[t].charCodeAt(0))},has(e){return void 0!==this._map[e]},get(e){return this._map[e]},charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const r in t)if(t[r]===e)return 0|r;return-1},amend(e){for(var t in e)this._map[t]=e[t]}};return ToUnicodeMap}();t.ToUnicodeMap=k;var x=function IdentityToUnicodeMapClosure(){function IdentityToUnicodeMap(e,t){this.firstChar=e;this.lastChar=t}IdentityToUnicodeMap.prototype={get length(){return this.lastChar+1-this.firstChar},forEach(e){for(var t=this.firstChar,r=this.lastChar;t<=r;t++)e(t,t)},has(e){return this.firstChar<=e&&e<=this.lastChar},get(e){if(this.firstChar<=e&&e<=this.lastChar)return String.fromCharCode(e)},charCodeOf(e){return Number.isInteger(e)&&e>=this.firstChar&&e<=this.lastChar?e:-1},amend(e){(0,a.unreachable)("Should not call amend()")}};return IdentityToUnicodeMap}();t.IdentityToUnicodeMap=x;var C=function OpenTypeFileBuilderClosure(){function writeInt16(e,t,r){e[t]=r>>8&255;e[t+1]=255&r}function writeInt32(e,t,r){e[t]=r>>24&255;e[t+1]=r>>16&255;e[t+2]=r>>8&255;e[t+3]=255&r}function writeData(e,t,r){var a,i;if(r instanceof Uint8Array)e.set(r,t);else if("string"==typeof r)for(a=0,i=r.length;a<i;a++)e[t++]=255&r.charCodeAt(a);else for(a=0,i=r.length;a<i;a++)e[t++]=255&r[a]}function OpenTypeFileBuilder(e){this.sfnt=e;this.tables=Object.create(null)}OpenTypeFileBuilder.getSearchParams=function OpenTypeFileBuilder_getSearchParams(e,t){for(var r=1,a=0;(r^e)>r;){r<<=1;a++}var i=r*t;return{range:i,entry:a,rangeShift:t*e-i}};OpenTypeFileBuilder.prototype={toArray:function OpenTypeFileBuilder_toArray(){var e=this.sfnt,t=this.tables,r=Object.keys(t);r.sort();var i,n,s,o,c,h=r.length,u=12+16*h,d=[u];for(i=0;i<h;i++){u+=((o=t[r[i]]).length+3&-4)>>>0;d.push(u)}var f=new Uint8Array(u);for(i=0;i<h;i++){o=t[r[i]];writeData(f,d[i],o)}"true"===e&&(e=(0,a.string32)(65536));f[0]=255&e.charCodeAt(0);f[1]=255&e.charCodeAt(1);f[2]=255&e.charCodeAt(2);f[3]=255&e.charCodeAt(3);writeInt16(f,4,h);var g=OpenTypeFileBuilder.getSearchParams(h,16);writeInt16(f,6,g.range);writeInt16(f,8,g.entry);writeInt16(f,10,g.rangeShift);u=12;for(i=0;i<h;i++){c=r[i];f[u]=255&c.charCodeAt(0);f[u+1]=255&c.charCodeAt(1);f[u+2]=255&c.charCodeAt(2);f[u+3]=255&c.charCodeAt(3);var p=0;for(n=d[i],s=d[i+1];n<s;n+=4){p=p+(0,l.readUint32)(f,n)>>>0}writeInt32(f,u+4,p);writeInt32(f,u+8,d[i]);writeInt32(f,u+12,t[c].length);u+=16}return f},addTable:function OpenTypeFileBuilder_addTable(e,t){if(e in this.tables)throw new Error("Table "+e+" already exists");this.tables[e]=t}};return OpenTypeFileBuilder}(),O=function FontClosure(){function Font(e,t,r){var i;this.name=e;this.loadedName=r.loadedName;this.isType3Font=r.isType3Font;this.missingFile=!1;this.glyphCache=Object.create(null);this.isSerifFont=!!(r.flags&w.Serif);this.isSymbolicFont=!!(r.flags&w.Symbolic);this.isMonospace=!!(r.flags&w.FixedPitch);var n=r.type,s=r.subtype;this.type=n;this.subtype=s;let o="sans-serif";this.isMonospace?o="monospace":this.isSerifFont&&(o="serif");this.fallbackName=o;this.differences=r.differences;this.widths=r.widths;this.defaultWidth=r.defaultWidth;this.composite=r.composite;this.cMap=r.cMap;this.capHeight=r.capHeight/p;this.ascent=r.ascent/p;this.descent=r.descent/p;this.fontMatrix=r.fontMatrix;this.bbox=r.bbox;this.defaultEncoding=r.defaultEncoding;this.toUnicode=r.toUnicode;this.fallbackToUnicode=r.fallbackToUnicode||new k;this.toFontChar=[];if("Type3"!==r.type){this.cidEncoding=r.cidEncoding;this.vertical=!!r.vertical;if(this.vertical){this.vmetrics=r.vmetrics;this.defaultVMetrics=r.defaultVMetrics}if(t&&!t.isEmpty){[n,s]=function getFontFileType(e,{type:t,subtype:r,composite:i}){let n,s;if(function isTrueTypeFile(e){var t=e.peekBytes(4);return 65536===(0,l.readUint32)(t,0)||"true"===(0,a.bytesToString)(t)}(e)||isTrueTypeCollectionFile(e))n=i?"CIDFontType2":"TrueType";else if(function isOpenTypeFile(e){var t=e.peekBytes(4);return"OTTO"===(0,a.bytesToString)(t)}(e))n=i?"CIDFontType2":"OpenType";else if(function isType1File(e){var t=e.peekBytes(2);if(37===t[0]&&33===t[1])return!0;if(128===t[0]&&1===t[1])return!0;return!1}(e))n=i?"CIDFontType0":"MMType1"===t?"MMType1":"Type1";else if(function isCFFFile(e){const t=e.peekBytes(4);if(t[0]>=1&&t[3]>=1&&t[3]<=4)return!0;return!1}(e))if(i){n="CIDFontType0";s="CIDFontType0C"}else{n="MMType1"===t?"MMType1":"Type1";s="Type1C"}else{(0,a.warn)("getFontFileType: Unable to detect correct font file Type/Subtype.");n=t;s=r}return[n,s]}(t,r);n===this.type&&s===this.subtype||(0,a.info)(`Inconsistent font file Type/SubType, expected: ${this.type}/${this.subtype} but found: ${n}/${s}.`);try{var c;switch(n){case"MMType1":(0,a.info)("MMType1 font ("+e+"), falling back to Type1.");case"Type1":case"CIDFontType0":this.mimetype="font/opentype";var h="Type1C"===s||"CIDFontType0C"===s?new E(t,r):new T(e,t,r);adjustWidths(r);c=this.convert(e,h,r);break;case"OpenType":case"TrueType":case"CIDFontType2":this.mimetype="font/opentype";c=this.checkAndRepair(e,t,r);if(this.isOpenType){adjustWidths(r);n="OpenType"}break;default:throw new a.FormatError(`Font ${n} is not supported`)}}catch(e){(0,a.warn)(e);this.fallbackToSystemFont(r);return}this.data=c;this.fontType=getFontType(n,s);this.fontMatrix=r.fontMatrix;this.widths=r.widths;this.defaultWidth=r.defaultWidth;this.toUnicode=r.toUnicode;this.seacMap=r.seacMap}else{t&&(0,a.warn)('Font file is empty in "'+e+'" ('+this.loadedName+")");this.fallbackToSystemFont(r)}}else{for(i=0;i<256;i++)this.toFontChar[i]=this.differences[i]||r.defaultEncoding[i];this.fontType=a.FontType.TYPE3}}function int16(e,t){return(e<<8)+t}function signedInt16(e,t){var r=(e<<8)+t;return 32768&r?r-65536:r}function string16(e){return String.fromCharCode(e>>8&255,255&e)}function safeString16(e){e>32767?e=32767:e<-32768&&(e=-32768);return String.fromCharCode(e>>8&255,255&e)}function isTrueTypeCollectionFile(e){const t=e.peekBytes(4);return"ttcf"===(0,a.bytesToString)(t)}function buildToFontChar(e,t,r){for(var a,i=[],n=0,s=e.length;n<s;n++)-1!==(a=(0,c.getUnicodeForGlyph)(e[n],t))&&(i[n]=a);for(var o in r)-1!==(a=(0,c.getUnicodeForGlyph)(r[o],t))&&(i[+o]=a);return i}function adjustMapping(e,t,r){var i=Object.create(null),n=[],s=0,o=g[s][0],c=g[s][1];for(var l in e){var h=e[l|=0];if(t(h)){if(o>c){if(++s>=g.length){(0,a.warn)("Ran out of space in font private use area.");break}o=g[s][0];c=g[s][1]}var u=o++;0===h&&(h=r);i[u]=h;n[l]=u}}return{toFontChar:n,charCodeToGlyphId:i,nextAvailableFontCharCode:o}}function createCmapTable(e,t){var r,i,n,s,o=function getRanges(e,t){var r=[];for(var a in e)e[a]>=t||r.push({fontCharCode:0|a,glyphId:e[a]});0===r.length&&r.push({fontCharCode:0,glyphId:0});r.sort((function fontGetRangesSort(e,t){return e.fontCharCode-t.fontCharCode}));for(var i=[],n=r.length,s=0;s<n;){var o=r[s].fontCharCode,c=[r[s].glyphId];++s;for(var l=o;s<n&&l+1===r[s].fontCharCode;){c.push(r[s].glyphId);++s;if(65535==++l)break}i.push([o,l,c])}return i}(e,t),c=o[o.length-1][1]>65535?2:1,l="\0\0"+string16(c)+"\0\0"+(0,a.string32)(4+8*c);for(r=o.length-1;r>=0&&!(o[r][0]<=65535);--r);var h=r+1;o[r][0]<65535&&65535===o[r][1]&&(o[r][1]=65534);var u,d,f,g,p=o[r][1]<65535?1:0,m=h+p,b=C.getSearchParams(m,2),y="",w="",S="",v="",k="",x=0;for(r=0,i=h;r<i;r++){d=(u=o[r])[0];f=u[1];y+=string16(d);w+=string16(f);var O=!0;for(n=1,s=(g=u[2]).length;n<s;++n)if(g[n]!==g[n-1]+1){O=!1;break}if(O){S+=string16(g[0]-d&65535);v+=string16(0)}else{var F=2*(m-r)+2*x;x+=f-d+1;S+=string16(0);v+=string16(F);for(n=0,s=g.length;n<s;++n)k+=string16(g[n])}}if(p>0){w+="ÿÿ";y+="ÿÿ";S+="\0";v+="\0\0"}var T="\0\0"+string16(2*m)+string16(b.range)+string16(b.entry)+string16(b.rangeShift)+w+"\0\0"+y+S+v+k,E="",M="";if(c>1){l+="\0\0\n"+(0,a.string32)(4+8*c+4+T.length);E="";for(r=0,i=o.length;r<i;r++){d=(u=o[r])[0];var D=(g=u[2])[0];for(n=1,s=g.length;n<s;++n)if(g[n]!==g[n-1]+1){f=u[0]+n-1;E+=(0,a.string32)(d)+(0,a.string32)(f)+(0,a.string32)(D);d=f+1;D=g[n]}E+=(0,a.string32)(d)+(0,a.string32)(u[1])+(0,a.string32)(D)}M="\0\f\0\0"+(0,a.string32)(E.length+16)+"\0\0\0\0"+(0,a.string32)(E.length/12)}return l+"\0"+string16(T.length+4)+T+M+E}function createOS2Table(e,t,r){r=r||{unitsPerEm:0,yMax:0,yMin:0,ascent:0,descent:0};var i=0,n=0,s=0,o=0,l=null,h=0;if(t){for(var u in t){(l>(u|=0)||!l)&&(l=u);h<u&&(h=u);var d=(0,c.getUnicodeRangeFor)(u);if(d<32)i|=1<<d;else if(d<64)n|=1<<d-32;else if(d<96)s|=1<<d-64;else{if(!(d<123))throw new a.FormatError("Unicode ranges Bits > 123 are reserved for internal usage");o|=1<<d-96}}h>65535&&(h=65535)}else{l=0;h=255}var f=e.bbox||[0,0,0,0],g=r.unitsPerEm||1/(e.fontMatrix||a.FONT_IDENTITY_MATRIX)[0],m=e.ascentScaled?1:g/p,b=r.ascent||Math.round(m*(e.ascent||f[3])),y=r.descent||Math.round(m*(e.descent||f[1]));y>0&&e.descent>0&&f[1]<0&&(y=-y);var w=r.yMax||b,S=-r.yMin||-y;return"\0$ô\0\0\0»\0\0\0»\0\0ß\x001\0\0\0\0"+String.fromCharCode(e.fixedPitch?9:0)+"\0\0\0\0\0\0"+(0,a.string32)(i)+(0,a.string32)(n)+(0,a.string32)(s)+(0,a.string32)(o)+"*21*"+string16(e.italicAngle?1:0)+string16(l||e.firstChar)+string16(h||e.lastChar)+string16(b)+string16(y)+"\0d"+string16(w)+string16(S)+"\0\0\0\0\0\0\0\0"+string16(e.xHeight)+string16(e.capHeight)+string16(0)+string16(l||e.firstChar)+"\0"}function createPostTable(e){var t=Math.floor(65536*e.italicAngle);return"\0\0\0"+(0,a.string32)(t)+"\0\0\0\0"+(0,a.string32)(e.fixedPitch)+"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"}function createNameTable(e,t){t||(t=[[],[]]);var r,a,i,n,s,o=[t[0][0]||"Original licence",t[0][1]||e,t[0][2]||"Unknown",t[0][3]||"uniqueID",t[0][4]||e,t[0][5]||"Version 0.11",t[0][6]||"",t[0][7]||"Unknown",t[0][8]||"Unknown",t[0][9]||"Unknown"],c=[];for(r=0,a=o.length;r<a;r++){var l=[];for(i=0,n=(s=t[1][r]||o[r]).length;i<n;i++)l.push(string16(s.charCodeAt(i)));c.push(l.join(""))}var h=[o,c],u=["\0","\0"],d=["\0\0","\0"],f=["\0\0","\t"],g=o.length*u.length,p="\0\0"+string16(g)+string16(12*g+6),m=0;for(r=0,a=u.length;r<a;r++){var b=h[r];for(i=0,n=b.length;i<n;i++){s=b[i];p+=u[r]+d[r]+f[r]+string16(i)+string16(s.length)+string16(m);m+=s.length}}return p+=o.join("")+c.join("")}Font.prototype={name:null,font:null,mimetype:null,disableFontFace:!1,get renderer(){var e=h.FontRendererFactory.create(this,m);return(0,a.shadow)(this,"renderer",e)},exportData(e=!1){const t=e?[...b,...y]:b,r=Object.create(null);let a,i;for(a of t){i=this[a];void 0!==i&&(r[a]=i)}return r},fallbackToSystemFont(e){this.missingFile=!0;var t=this.name,r=this.type,i=this.subtype;let l=t.replace(/[,_]/g,"-").replace(/\s/g,"");var h=(0,o.getStdFontMap)(),u=(0,o.getNonStdFontMap)();const d=!!h[l],f=!(!u[l]||!h[u[l]]);l=h[l]||u[l]||l;this.bold=-1!==l.search(/bold/gi);this.italic=-1!==l.search(/oblique/gi)||-1!==l.search(/italic/gi);this.black=-1!==t.search(/Black/g);const g=-1!==t.search(/Narrow/g);this.remeasure=(!d||g)&&Object.keys(this.widths).length>0;if((d||f)&&"CIDFontType2"===r&&this.cidEncoding.startsWith("Identity-")){const r=(0,o.getGlyphMapForStandardFonts)(),a=e.cidToGidMap,i=[];for(const e in r)i[+e]=r[e];if(/Arial-?Black/i.test(t)){var p=(0,o.getSupplementalGlyphMapForArialBlack)();for(const e in p)i[+e]=p[e]}else if(/Calibri/i.test(t)){const e=(0,o.getSupplementalGlyphMapForCalibri)();for(const t in e)i[+t]=e[t]}if(a)for(const e in i){const t=i[e];void 0!==a[t]&&(i[+e]=a[t])}this.toUnicode instanceof x||this.toUnicode.forEach((function(e,t){i[+e]=t}));this.toFontChar=i;this.toUnicode=new k(i)}else if(/Symbol/i.test(l))this.toFontChar=buildToFontChar(s.SymbolSetEncoding,(0,n.getGlyphsUnicode)(),this.differences);else if(/Dingbats/i.test(l)){/Wingdings/i.test(t)&&(0,a.warn)("Non-embedded Wingdings font, falling back to ZapfDingbats.");this.toFontChar=buildToFontChar(s.ZapfDingbatsEncoding,(0,n.getDingbatsGlyphsUnicode)(),this.differences)}else if(d)this.toFontChar=buildToFontChar(this.defaultEncoding,(0,n.getGlyphsUnicode)(),this.differences);else{const e=(0,n.getGlyphsUnicode)(),r=[];this.toUnicode.forEach(((t,a)=>{if(!this.composite){var i=this.differences[t]||this.defaultEncoding[t];const r=(0,c.getUnicodeForGlyph)(i,e);-1!==r&&(a=r)}r[+t]=a}));if(this.composite&&this.toUnicode instanceof x&&/Verdana/i.test(t)){const e=(0,o.getGlyphMapForStandardFonts)();for(const t in e)r[+t]=e[t]}this.toFontChar=r}this.loadedName=l.split("-")[0];this.fontType=getFontType(r,i)},checkAndRepair:function Font_checkAndRepair(e,t,r){const o=["OS/2","cmap","head","hhea","hmtx","maxp","name","post","loca","glyf","fpgm","prep","cvt ","CFF "];function readTables(e,t){const r=Object.create(null);r["OS/2"]=null;r.cmap=null;r.head=null;r.hhea=null;r.hmtx=null;r.maxp=null;r.name=null;r.post=null;for(let a=0;a<t;a++){const t=readTableEntry(e);o.includes(t.tag)&&(0!==t.length&&(r[t.tag]=t))}return r}function readTableEntry(e){var t=(0,a.bytesToString)(e.getBytes(4)),r=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0,s=e.pos;e.pos=e.start?e.start:0;e.skip(i);var o=e.getBytes(n);e.pos=s;if("head"===t){o[8]=o[9]=o[10]=o[11]=0;o[17]|=32}return{tag:t,checksum:r,length:n,offset:i,data:o}}function readOpenTypeHeader(e){return{version:(0,a.bytesToString)(e.getBytes(4)),numTables:e.getUint16(),searchRange:e.getUint16(),entrySelector:e.getUint16(),rangeShift:e.getUint16()}}function sanitizeGlyph(e,t,r,a,i,n){var s={length:0,sizeOfInstructions:0};if(r-t<=12)return s;var o=e.subarray(t,r),c=signedInt16(o[0],o[1]);if(c<0){!function writeSignedInt16(e,t,r){e[t+1]=r;e[t]=r>>>8}(o,0,c=-1);a.set(o,i);s.length=o.length;return s}var l,h=10,u=0;for(l=0;l<c;l++){u=(o[h]<<8|o[h+1])+1;h+=2}var d=h,f=o[h]<<8|o[h+1];s.sizeOfInstructions=f;var g=h+=2+f,p=0;for(l=0;l<u;l++){var m=o[h++];192&m&&(o[h-1]=63&m);let e=2;2&m?e=1:16&m&&(e=0);let t=2;4&m?t=1:32&m&&(t=0);const r=e+t;p+=r;if(8&m){var b=o[h++];l+=b;p+=b*r}}if(0===p)return s;var y=h+p;if(y>o.length)return s;if(!n&&f>0){a.set(o.subarray(0,d),i);a.set([0,0],i+d);a.set(o.subarray(g,y),i+d+2);y-=f;o.length-y>3&&(y=y+3&-4);s.length=y;return s}if(o.length-y>3){y=y+3&-4;a.set(o.subarray(0,y),i);s.length=y;return s}a.set(o,i);s.length=o.length;return s}function readNameTable(e){var r=(t.start?t.start:0)+e.offset;t.pos=r;var i=[[],[]],n=e.length,s=r+n;if(0!==t.getUint16()||n<6)return i;var o,c,l=t.getUint16(),h=t.getUint16(),u=[];for(o=0;o<l&&t.pos+12<=s;o++){var d={platform:t.getUint16(),encoding:t.getUint16(),language:t.getUint16(),name:t.getUint16(),length:t.getUint16(),offset:t.getUint16()};(1===d.platform&&0===d.encoding&&0===d.language||3===d.platform&&1===d.encoding&&1033===d.language)&&u.push(d)}for(o=0,c=u.length;o<c;o++){var f=u[o];if(!(f.length<=0)){var g=r+h+f.offset;if(!(g+f.length>s)){t.pos=g;var p=f.name;if(f.encoding){for(var m="",b=0,y=f.length;b<y;b+=2)m+=String.fromCharCode(t.getUint16());i[1][p]=m}else i[0][p]=(0,a.bytesToString)(t.getBytes(f.length))}}}return i}var c=[0,0,0,0,0,0,0,0,-2,-2,-2,-2,0,0,-2,-5,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,-1,-1,1,-1,-999,0,1,0,-1,-2,0,-1,-2,-1,-1,0,-1,-1,0,0,-999,-999,-1,-1,-1,-1,-2,-999,-2,-2,-999,0,-2,-2,0,0,-2,0,-2,0,0,0,-2,-1,-1,1,1,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,0,-999,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,-2,-999,-999,-999,-999,-999,-1,-1,-2,-2,0,0,0,0,-1,-1,-999,-2,-2,0,0,-1,-2,-2,0,0,0,-1,-1,-1,-2];function sanitizeTTProgram(e,t){for(var r,i,n,s,o,l=e.data,h=0,u=0,d=0,f=[],g=[],p=[],m=t.tooComplexToFollowFunctions,b=!1,y=0,w=0,S=l.length;h<S;){var v=l[h++];if(64===v){i=l[h++];if(b||w)h+=i;else for(r=0;r<i;r++)f.push(l[h++])}else if(65===v){i=l[h++];if(b||w)h+=2*i;else for(r=0;r<i;r++){n=l[h++];f.push(n<<8|l[h++])}}else if(176==(248&v)){i=v-176+1;if(b||w)h+=i;else for(r=0;r<i;r++)f.push(l[h++])}else if(184==(248&v)){i=v-184+1;if(b||w)h+=2*i;else for(r=0;r<i;r++){n=l[h++];f.push(n<<8|l[h++])}}else if(43!==v||m)if(44!==v||m){if(45===v)if(b){b=!1;u=h}else{if(!(o=g.pop())){(0,a.warn)("TT: ENDF bad stack");t.hintsValid=!1;return}s=p.pop();l=o.data;h=o.i;t.functionsStackDeltas[s]=f.length-o.stackTop}else if(137===v){if(b||w){(0,a.warn)("TT: nested IDEFs not allowed");m=!0}b=!0;d=h}else if(88===v)++y;else if(27===v)w=y;else if(89===v){w===y&&(w=0);--y}else if(28===v&&!b&&!w){var k=f[f.length-1];k>0&&(h+=k-1)}}else{if(b||w){(0,a.warn)("TT: nested FDEFs not allowed");m=!0}b=!0;d=h;s=f.pop();t.functionsDefined[s]={data:l,i:h}}else if(!b&&!w){s=f[f.length-1];if(isNaN(s))(0,a.info)("TT: CALL empty stack (or invalid entry).");else{t.functionsUsed[s]=!0;if(s in t.functionsStackDeltas){const e=f.length+t.functionsStackDeltas[s];if(e<0){(0,a.warn)("TT: CALL invalid functions stack delta.");t.hintsValid=!1;return}f.length=e}else if(s in t.functionsDefined&&!p.includes(s)){g.push({data:l,i:h,stackTop:f.length-1});p.push(s);if(!(o=t.functionsDefined[s])){(0,a.warn)("TT: CALL non-existent function");t.hintsValid=!1;return}l=o.data;h=o.i}}}if(!b&&!w){let e=0;v<=142?e=c[v]:v>=192&&v<=223?e=-1:v>=224&&(e=-2);if(v>=113&&v<=117){i=f.pop();isNaN(i)||(e=2*-i)}for(;e<0&&f.length>0;){f.pop();e++}for(;e>0;){f.push(NaN);e--}}}t.tooComplexToFollowFunctions=m;var x=[l];h>l.length&&x.push(new Uint8Array(h-l.length));if(d>u){(0,a.warn)("TT: complementing a missing function tail");x.push(new Uint8Array([34,45]))}!function foldTTTable(e,t){if(t.length>1){var r,a,i=0;for(r=0,a=t.length;r<a;r++)i+=t[r].length;i=i+3&-4;var n=new Uint8Array(i),s=0;for(r=0,a=t.length;r<a;r++){n.set(t[r],s);s+=t[r].length}e.data=n;e.length=i}}(e,x)}let l,h,f,g;if(isTrueTypeCollectionFile(t=new d.Stream(new Uint8Array(t.getBytes())))){const e=function readTrueTypeCollectionData(e,t){const{numFonts:r,offsetTable:i}=function readTrueTypeCollectionHeader(e){const t=(0,a.bytesToString)(e.getBytes(4));(0,a.assert)("ttcf"===t,"Must be a TrueType Collection font.");const r=e.getUint16(),i=e.getUint16(),n=e.getInt32()>>>0,s=[];for(let t=0;t<n;t++)s.push(e.getInt32()>>>0);const o={ttcTag:t,majorVersion:r,minorVersion:i,numFonts:n,offsetTable:s};switch(r){case 1:return o;case 2:o.dsigTag=e.getInt32()>>>0;o.dsigLength=e.getInt32()>>>0;o.dsigOffset=e.getInt32()>>>0;return o}throw new a.FormatError(`Invalid TrueType Collection majorVersion: ${r}.`)}(e);for(let n=0;n<r;n++){e.pos=(e.start||0)+i[n];const r=readOpenTypeHeader(e),s=readTables(e,r.numTables);if(!s.name)throw new a.FormatError('TrueType Collection font must contain a "name" table.');const o=readNameTable(s.name);for(let e=0,a=o.length;e<a;e++)for(let a=0,i=o[e].length;a<i;a++){const i=o[e][a];if(i&&i.replace(/\s/g,"")===t)return{header:r,tables:s}}}throw new a.FormatError(`TrueType Collection does not contain "${t}" font.`)}(t,this.name);l=e.header;h=e.tables}else{l=readOpenTypeHeader(t);h=readTables(t,l.numTables)}var p=!h["CFF "];if(p){if(!h.loca)throw new a.FormatError('Required "loca" table is not found');if(!h.glyf){(0,a.warn)('Required "glyf" table is not found -- trying to recover.');h.glyf={tag:"glyf",data:new Uint8Array(0)}}this.isOpenType=!1}else{const t=r.composite&&((r.cidToGidMap||[]).length>0||!(r.cMap instanceof u.IdentityCMap));if("OTTO"===l.version&&!t||!h.head||!h.hhea||!h.maxp||!h.post){g=new d.Stream(h["CFF "].data);f=new E(g,r);adjustWidths(r);return this.convert(e,f,r)}delete h.glyf;delete h.loca;delete h.fpgm;delete h.prep;delete h["cvt "];this.isOpenType=!0}if(!h.maxp)throw new a.FormatError('Required "maxp" table is not found');t.pos=(t.start||0)+h.maxp.offset;var b=t.getInt32();const y=t.getUint16();let w=y+1,v=!0;if(w>65535){v=!1;w=y;(0,a.warn)("Not enough space in glyfs to duplicate first glyph.")}var k=0,x=0;if(b>=65536&&h.maxp.length>=22){t.pos+=8;if(t.getUint16()>2){h.maxp.data[14]=0;h.maxp.data[15]=2}t.pos+=4;k=t.getUint16();t.pos+=4;x=t.getUint16()}h.maxp.data[4]=w>>8;h.maxp.data[5]=255&w;var O=function sanitizeTTPrograms(e,t,r,i){var n={functionsDefined:[],functionsUsed:[],functionsStackDeltas:[],tooComplexToFollowFunctions:!1,hintsValid:!0};e&&sanitizeTTProgram(e,n);t&&sanitizeTTProgram(t,n);e&&function checkInvalidFunctions(e,t){if(!e.tooComplexToFollowFunctions)if(e.functionsDefined.length>t){(0,a.warn)("TT: more functions defined than expected");e.hintsValid=!1}else for(var r=0,i=e.functionsUsed.length;r<i;r++){if(r>t){(0,a.warn)("TT: invalid function id: "+r);e.hintsValid=!1;return}if(e.functionsUsed[r]&&!e.functionsDefined[r]){(0,a.warn)("TT: undefined function: "+r);e.hintsValid=!1;return}}}(n,i);if(r&&1&r.length){var s=new Uint8Array(r.length+1);s.set(r.data);r.data=s}return n.hintsValid}(h.fpgm,h.prep,h["cvt "],k);if(!O){delete h.fpgm;delete h.prep;delete h["cvt "]}!function sanitizeMetrics(e,t,r,i,n){if(t){e.pos=(e.start?e.start:0)+t.offset;e.pos+=4;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=8;e.pos+=2;var s=e.getUint16();if(s>i){(0,a.info)("The numOfMetrics ("+s+") should not be greater than the numGlyphs ("+i+")");s=i;t.data[34]=(65280&s)>>8;t.data[35]=255&s}var o=i-s-(r.length-4*s>>1);if(o>0){var c=new Uint8Array(r.length+2*o);c.set(r.data);if(n){c[r.length]=r.data[2];c[r.length+1]=r.data[3]}r.data=c}}else r&&(r.data=null)}(t,h.hhea,h.hmtx,w,v);if(!h.head)throw new a.FormatError('Required "head" table is not found');!function sanitizeHead(e,t,r){var i=e.data,n=function int32(e,t,r,a){return(e<<24)+(t<<16)+(r<<8)+a}(i[0],i[1],i[2],i[3]);if(n>>16!=1){(0,a.info)("Attempting to fix invalid version in head table: "+n);i[0]=0;i[1]=1;i[2]=0;i[3]=0}var s=int16(i[50],i[51]);if(s<0||s>1){(0,a.info)("Attempting to fix invalid indexToLocFormat in head table: "+s);var o=t+1;if(r===o<<1){i[50]=0;i[51]=0}else{if(r!==o<<2)throw new a.FormatError("Could not fix indexToLocFormat: "+s);i[50]=0;i[51]=1}}}(h.head,y,p?h.loca.length:0);var F=Object.create(null);if(p){var T=int16(h.head.data[50],h.head.data[51]),M=function sanitizeGlyphLocations(e,t,r,a,i,n,s){var o,c,l;if(a){o=4;c=function fontItemDecodeLong(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]};l=function fontItemEncodeLong(e,t,r){e[t]=r>>>24&255;e[t+1]=r>>16&255;e[t+2]=r>>8&255;e[t+3]=255&r}}else{o=2;c=function fontItemDecode(e,t){return e[t]<<9|e[t+1]<<1};l=function fontItemEncode(e,t,r){e[t]=r>>9&255;e[t+1]=r>>1&255}}var h=n?r+1:r,u=o*(1+h),d=new Uint8Array(u);d.set(e.data.subarray(0,u));e.data=d;var f,g,p=t.data,m=p.length,b=new Uint8Array(m);const y=[];for(f=0,g=0;f<r+1;f++,g+=o){let e=c(d,g);e>m&&(e=m);y.push({index:f,offset:e,endOffset:0})}y.sort(((e,t)=>e.offset-t.offset));for(f=0;f<r;f++)y[f].endOffset=y[f+1].offset;y.sort(((e,t)=>e.index-t.index));var w=Object.create(null),S=0;l(d,0,S);for(f=0,g=o;f<r;f++,g+=o){var v=sanitizeGlyph(p,y[f].offset,y[f].endOffset,b,S,i),k=v.length;0===k&&(w[f]=!0);v.sizeOfInstructions>s&&(s=v.sizeOfInstructions);l(d,g,S+=k)}if(0===S){var x=new Uint8Array([0,1,0,0,0,0,0,0,0,0,0,0,0,0,49,0]);for(f=0,g=o;f<h;f++,g+=o)l(d,g,x.length);t.data=x}else if(n){var C=c(d,o);if(b.length>C+S)t.data=b.subarray(0,C+S);else{t.data=new Uint8Array(C+S);t.data.set(b.subarray(0,S))}t.data.set(b.subarray(0,C),S);l(e.data,d.length-o,S+C)}else t.data=b.subarray(0,S);return{missingGlyphs:w,maxSizeOfInstructions:s}}(h.loca,h.glyf,y,T,O,v,x);F=M.missingGlyphs;if(b>=65536&&h.maxp.length>=22){h.maxp.data[26]=M.maxSizeOfInstructions>>8;h.maxp.data[27]=255&M.maxSizeOfInstructions}}if(!h.hhea)throw new a.FormatError('Required "hhea" table is not found');if(0===h.hhea.data[10]&&0===h.hhea.data[11]){h.hhea.data[10]=255;h.hhea.data[11]=255}var D={unitsPerEm:int16(h.head.data[18],h.head.data[19]),yMax:int16(h.head.data[42],h.head.data[43]),yMin:signedInt16(h.head.data[38],h.head.data[39]),ascent:int16(h.hhea.data[4],h.hhea.data[5]),descent:signedInt16(h.hhea.data[6],h.hhea.data[7])};this.ascent=D.ascent/D.unitsPerEm;this.descent=D.descent/D.unitsPerEm;h.post&&function readPostScriptTable(e,r,i){var n=(t.start?t.start:0)+e.offset;t.pos=n;var s,o=n+e.length,c=t.getInt32();t.skip(28);var l,h=!0;switch(c){case 65536:s=S;break;case 131072:var u=t.getUint16();if(u!==i){h=!1;break}var d=[];for(l=0;l<u;++l){var f=t.getUint16();if(f>=32768){h=!1;break}d.push(f)}if(!h)break;for(var g=[],p=[];t.pos<o;){var m=t.getByte();p.length=m;for(l=0;l<m;++l)p[l]=String.fromCharCode(t.getByte());g.push(p.join(""))}s=[];for(l=0;l<u;++l){var b=d[l];b<258?s.push(S[b]):s.push(g[b-258])}break;case 196608:break;default:(0,a.warn)("Unknown/unsupported post table version "+c);h=!1;r.defaultEncoding&&(s=r.defaultEncoding)}r.glyphNames=s;return h}(h.post,r,y);h.post={tag:"post",data:createPostTable(r)};const N=[];function hasGlyph(e){return!F[e]}if(r.composite){var R=r.cidToGidMap||[],j=0===R.length;r.cMap.forEach((function(e,t){if(t>65535)throw new a.FormatError("Max size of CID is 65,535");var r=-1;j?r=t:void 0!==R[t]&&(r=R[t]);r>=0&&r<y&&hasGlyph(r)&&(N[e]=r)}))}else{var L=function readCmapTable(e,t,r,i){if(!e){(0,a.warn)("No cmap table available.");return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var n,s=(t.start?t.start:0)+e.offset;t.pos=s;t.skip(2);for(var o,c=t.getUint16(),l=!1,h=0;h<c;h++){var u=t.getUint16(),d=t.getUint16(),f=t.getInt32()>>>0,g=!1;if(!o||o.platformId!==u||o.encodingId!==d){if(0!==u||0!==d&&1!==d&&3!==d)if(1===u&&0===d)g=!0;else if(3!==u||1!==d||!i&&o){if(r&&3===u&&0===d){g=!0;l=!0}}else{g=!0;r||(l=!0)}else g=!0;g&&(o={platformId:u,encodingId:d,offset:f});if(l)break}}o&&(t.pos=s+o.offset);if(!o||-1===t.peekByte()){(0,a.warn)("Could not find a preferred cmap table.");return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var p=t.getUint16();t.skip(4);var m,b,y=!1,w=[];if(0===p){for(m=0;m<256;m++){var S=t.getByte();S&&w.push({charCode:m,glyphId:S})}y=!0}else if(4===p){var v=t.getUint16()>>1;t.skip(6);var k,x=[];for(k=0;k<v;k++)x.push({end:t.getUint16()});t.skip(2);for(k=0;k<v;k++)x[k].start=t.getUint16();for(k=0;k<v;k++)x[k].delta=t.getUint16();var C=0;for(k=0;k<v;k++){n=x[k];var O=t.getUint16();if(O){var F=(O>>1)-(v-k);n.offsetIndex=F;C=Math.max(C,F+n.end-n.start+1)}else n.offsetIndex=-1}var T=[];for(m=0;m<C;m++)T.push(t.getUint16());for(k=0;k<v;k++){s=(n=x[k]).start;var E=n.end,M=n.delta;F=n.offsetIndex;for(m=s;m<=E;m++)if(65535!==m){b=(b=F<0?m:T[F+m-s])+M&65535;w.push({charCode:m,glyphId:b})}}}else{if(6!==p){(0,a.warn)("cmap table has unsupported format: "+p);return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var D=t.getUint16(),N=t.getUint16();for(m=0;m<N;m++){b=t.getUint16();var R=D+m;w.push({charCode:R,glyphId:b})}}w.sort((function(e,t){return e.charCode-t.charCode}));for(h=1;h<w.length;h++)if(w[h-1].charCode===w[h].charCode){w.splice(h,1);h--}return{platformId:o.platformId,encodingId:o.encodingId,mappings:w,hasShortCmap:y}}(h.cmap,t,this.isSymbolicFont,r.hasEncoding),_=L.platformId,U=L.encodingId,X=L.mappings,q=X.length;let e=[];!r.hasEncoding||"MacRomanEncoding"!==r.baseEncodingName&&"WinAnsiEncoding"!==r.baseEncodingName||(e=(0,s.getEncoding)(r.baseEncodingName));if(r.hasEncoding&&!this.isSymbolicFont&&(3===_&&1===U||1===_&&0===U)){var $=(0,n.getGlyphsUnicode)();for(let t=0;t<256;t++){var H,z;if(H=this.differences&&t in this.differences?this.differences[t]:t in e&&""!==e[t]?e[t]:s.StandardEncoding[t]){z=recoverGlyphName(H,$);var G;3===_&&1===U?G=$[z]:1===_&&0===U&&(G=s.MacRomanEncoding.indexOf(z));for(let e=0;e<q;++e)if(X[e].charCode===G){N[t]=X[e].glyphId;break}}}}else if(0===_)for(let e=0;e<q;++e)N[X[e].charCode]=X[e].glyphId;else for(let e=0;e<q;++e){let t=X[e].charCode;3===_&&t>=61440&&t<=61695&&(t&=255);N[t]=X[e].glyphId}if(r.glyphNames&&(e.length||this.differences.length))for(let t=0;t<256;++t){if(void 0!==N[t])continue;if(!(H=this.differences[t]||e[t]))continue;const a=r.glyphNames.indexOf(H);a>0&&hasGlyph(a)&&(N[t]=a)}}0===N.length&&(N[0]=0);let W=w-1;v||(W=0);var V=adjustMapping(N,hasGlyph,W);this.toFontChar=V.toFontChar;h.cmap={tag:"cmap",data:createCmapTable(V.charCodeToGlyphId,w)};h["OS/2"]&&function validateOS2Table(e,t){t.pos=(t.start||0)+e.offset;var r=t.getUint16();t.skip(60);var a=t.getUint16();if(r<4&&768&a)return!1;if(t.getUint16()>t.getUint16())return!1;t.skip(6);if(0===t.getUint16())return!1;e.data[8]=e.data[9]=0;return!0}(h["OS/2"],t)||(h["OS/2"]={tag:"OS/2",data:createOS2Table(r,V.charCodeToGlyphId,D)});if(!p)try{g=new d.Stream(h["CFF "].data);f=new i.CFFParser(g,r,m).parse();f.duplicateFirstGlyph();var J=new i.CFFCompiler(f);h["CFF "].data=J.compile()}catch(e){(0,a.warn)("Failed to compile font "+r.loadedName)}if(h.name){var K=readNameTable(h.name);h.name.data=createNameTable(e,K)}else h.name={tag:"name",data:createNameTable(this.name)};var Y=new C(l.version);for(var Z in h)Y.addTable(Z,h[Z].data);return Y.toArray()},convert:function Font_convert(e,t,r){r.fixedPitch=!1;r.builtInEncoding&&function adjustToUnicode(e,t){if(!e.hasIncludedToUnicodeMap&&!(e.hasEncoding||t===e.defaultEncoding||e.toUnicode instanceof x)){var r=[],a=(0,n.getGlyphsUnicode)();for(var i in t){var s=t[i],o=(0,c.getUnicodeForGlyph)(s,a);-1!==o&&(r[i]=String.fromCharCode(o))}e.toUnicode.amend(r)}}(r,r.builtInEncoding);let i=1;t instanceof E&&(i=t.numGlyphs-1);var o=t.getGlyphMapping(r),l=adjustMapping(o,t.hasGlyphId.bind(t),i);this.toFontChar=l.toFontChar;var h=t.numGlyphs;function getCharCodes(e,t){var r=null;for(var a in e)if(t===e[a]){r||(r=[]);r.push(0|a)}return r}function createCharCode(e,t){for(var r in e)if(t===e[r])return 0|r;l.charCodeToGlyphId[l.nextAvailableFontCharCode]=t;return l.nextAvailableFontCharCode++}var u=t.seacs;if(u&&u.length){var d=r.fontMatrix||a.FONT_IDENTITY_MATRIX,f=t.getCharset(),g=Object.create(null);for(var p in u){var m=u[p|=0],b=s.StandardEncoding[m[2]],y=s.StandardEncoding[m[3]],w=f.indexOf(b),S=f.indexOf(y);if(!(w<0||S<0)){var v={x:m[0]*d[0]+m[1]*d[2]+d[4],y:m[0]*d[1]+m[1]*d[3]+d[5]},k=getCharCodes(o,p);if(k)for(let e=0,t=k.length;e<t;e++){var O=k[e],F=l.charCodeToGlyphId,T=createCharCode(F,w),M=createCharCode(F,S);g[O]={baseFontCharCode:T,accentFontCharCode:M,accentOffset:v}}}}r.seacMap=g}var D=1/(r.fontMatrix||a.FONT_IDENTITY_MATRIX)[0],N=new C("OTTO");N.addTable("CFF ",t.data);N.addTable("OS/2",createOS2Table(r,l.charCodeToGlyphId));N.addTable("cmap",createCmapTable(l.charCodeToGlyphId,h));N.addTable("head","\0\0\0\0\0\0\0\0\0\0_<õ\0\0"+safeString16(D)+"\0\0\0\0\v~'\0\0\0\0\v~'\0\0"+safeString16(r.descent)+"ÿ"+safeString16(r.ascent)+string16(r.italicAngle?2:0)+"\0\0\0\0\0\0\0");N.addTable("hhea","\0\0\0"+safeString16(r.ascent)+safeString16(r.descent)+"\0\0ÿÿ\0\0\0\0\0\0"+safeString16(r.capHeight)+safeString16(Math.tan(r.italicAngle)*r.xHeight)+"\0\0\0\0\0\0\0\0\0\0\0\0"+string16(h));N.addTable("hmtx",function fontFieldsHmtx(){var e=t.charstrings,r=t.cff?t.cff.widths:null,a="\0\0\0\0";for(let t=1,s=h;t<s;t++){var i=0;if(e){var n=e[t-1];i="width"in n?n.width:0}else r&&(i=Math.ceil(r[t]||0));a+=string16(i)+string16(0)}return a}());N.addTable("maxp","\0\0P\0"+string16(h));N.addTable("name",createNameTable(e));N.addTable("post",createPostTable(r));return N.toArray()},get spaceWidth(){for(var e,t=["space","minus","one","i","I"],r=0,i=t.length;r<i;r++){var s=t[r];if(s in this.widths){e=this.widths[s];break}var o=(0,n.getGlyphsUnicode)()[s],c=0;this.composite&&this.cMap.contains(o)&&(c=this.cMap.lookup(o));!c&&this.toUnicode&&(c=this.toUnicode.charCodeOf(o));c<=0&&(c=o);if(e=this.widths[c])break}e=e||this.defaultWidth;return(0,a.shadow)(this,"spaceWidth",e)},_charToGlyph(e,t=!1){var r,i,n,s=e;this.cMap&&this.cMap.contains(e)&&(s=this.cMap.lookup(e));i=this.widths[s];i=(0,a.isNum)(i)?i:this.defaultWidth;var o=this.vmetrics&&this.vmetrics[s];let l=this.toUnicode.get(e)||this.fallbackToUnicode.get(e)||e;"number"==typeof l&&(l=String.fromCharCode(l));var h=e in this.toFontChar;r=this.toFontChar[e]||e;if(this.missingFile){const t=this.differences[e]||this.defaultEncoding[e];".notdef"!==t&&""!==t||"Type1"!==this.type||(r=32);r=(0,c.mapSpecialUnicodeValues)(r)}this.isType3Font&&(n=r);var u=null;if(this.seacMap&&this.seacMap[e]){h=!0;var d=this.seacMap[e];r=d.baseFontCharCode;u={fontChar:String.fromCodePoint(d.accentFontCharCode),offset:d.accentOffset}}let f="";"number"==typeof r&&(r<=1114111?f=String.fromCodePoint(r):(0,a.warn)(`charToGlyph - invalid fontCharCode: ${r}`));var g=this.glyphCache[e];if(!g||!g.matchesForCache(f,l,u,i,o,n,t,h)){g=new v(f,l,u,i,o,n,t,h);this.glyphCache[e]=g}return g},charsToGlyphs:function Font_charsToGlyphs(e){var t,r,a,i=this.charsCache;if(i&&(t=i[e]))return t;i||(i=this.charsCache=Object.create(null));t=[];var n,s=e,o=0;if(this.cMap)for(var c=Object.create(null);o<e.length;){this.cMap.readCharCode(e,o,c);a=c.charcode;var l=c.length;o+=l;var h=1===l&&32===e.charCodeAt(o-1);r=this._charToGlyph(a,h);t.push(r)}else for(o=0,n=e.length;o<n;++o){a=e.charCodeAt(o);r=this._charToGlyph(a,32===a);t.push(r)}return i[s]=t},getCharPositions(e){const t=[];if(this.cMap){const r=Object.create(null);let a=0;for(;a<e.length;){this.cMap.readCharCode(e,a,r);const i=r.length;t.push([a,a+i]);a+=i}}else for(let r=0,a=e.length;r<a;++r)t.push([r,r+1]);return t},get glyphCacheValues(){return Object.values(this.glyphCache)},encodeString(e){const t=[],r=[],hasCurrentBufErrors=()=>t.length%2==1;for(let a=0,i=e.length;a<i;a++){const i=e.codePointAt(a);i>55295&&(i<57344||i>65533)&&a++;if(this.toUnicode){const e=String.fromCodePoint(i),a=this.toUnicode.charCodeOf(e);if(-1!==a){if(hasCurrentBufErrors()){t.push(r.join(""));r.length=0}for(let e=(this.cMap?this.cMap.getCharCodeLength(a):1)-1;e>=0;e--)r.push(String.fromCharCode(a>>8*e&255));continue}}if(!hasCurrentBufErrors()){t.push(r.join(""));r.length=0}r.push(String.fromCodePoint(i))}t.push(r.join(""));return t}};return Font}();t.Font=O;var F=function ErrorFontClosure(){function ErrorFont(e){this.error=e;this.loadedName="g_font_error";this.missingFile=!0}ErrorFont.prototype={charsToGlyphs:function ErrorFont_charsToGlyphs(){return[]},encodeString:function ErrorFont_encodeString(e){return[e]},exportData(e=!1){return{error:this.error}}};return ErrorFont}();t.ErrorFont=F;function type1FontGlyphMapping(e,t,r){var a,i,o,c=Object.create(null),l=!!(e.flags&w.Symbolic);if(e.baseEncodingName){o=(0,s.getEncoding)(e.baseEncodingName);for(i=0;i<o.length;i++){a=r.indexOf(o[i]);c[i]=a>=0?a:0}}else if(l)for(i in t)c[i]=t[i];else{o=s.StandardEncoding;for(i=0;i<o.length;i++){a=r.indexOf(o[i]);c[i]=a>=0?a:0}}var h,u=e.differences;if(u)for(i in u){var d=u[i];if(-1===(a=r.indexOf(d))){h||(h=(0,n.getGlyphsUnicode)());var f=recoverGlyphName(d,h);f!==d&&(a=r.indexOf(f))}c[i]=a>=0?a:0}return c}var T=function Type1FontClosure(){function findBlock(e,t,r){for(var a,i=e.length,n=t.length,s=i-n,o=r,c=!1;o<s;){a=0;for(;a<n&&e[o+a]===t[a];)a++;if(a>=n){o+=a;for(;o<i&&(0,l.isWhiteSpace)(e[o]);)o++;c=!0;break}o++}return{found:c,length:o}}function Type1Font(e,t,r){var i=r.length1,n=(r.length2,t.peekBytes(6)),s=128===n[0]&&1===n[1];if(s){t.skip(6);i=n[5]<<24|n[4]<<16|n[3]<<8|n[2]}var o=function getHeaderBlock(e,t){var r,i,n,s,o=[101,101,120,101,99],c=e.pos;try{i=(r=e.getBytes(t)).length}catch(e){if(e instanceof l.MissingDataException)throw e}if(i===t&&(n=findBlock(r,o,t-2*o.length)).found&&n.length===t)return{stream:new d.Stream(r),length:t};(0,a.warn)('Invalid "Length1" property in Type1 font -- trying to recover.');e.pos=c;for(;0!==(n=findBlock(e.peekBytes(2048),o,0)).length;){e.pos+=n.length;if(n.found){s=e.pos-c;break}}e.pos=c;if(s)return{stream:new d.Stream(e.getBytes(s)),length:s};(0,a.warn)('Unable to recover "Length1" property in Type1 font -- using as is.');return{stream:new d.Stream(e.getBytes(t)),length:t}}(t,i);new f.Type1Parser(o.stream,!1,m).extractFontHeader(r);s&&(n=t.getBytes(6))[5]<<24|n[4]<<16|n[3]<<8|n[2];var c=function getEexecBlock(e,t){var r=e.getBytes();return{stream:new d.Stream(r),length:r.length}}(t),h=new f.Type1Parser(c.stream,!0,m).extractFontProgram(r);for(const e in h.properties)r[e]=h.properties[e];var u=h.charstrings,g=this.getType2Charstrings(u),p=this.getType2Subrs(h.subrs);this.charstrings=u;this.data=this.wrap(e,g,this.charstrings,p,r);this.seacs=this.getSeacs(h.charstrings)}Type1Font.prototype={get numGlyphs(){return this.charstrings.length+1},getCharset:function Type1Font_getCharset(){for(var e=[".notdef"],t=this.charstrings,r=0;r<t.length;r++)e.push(t[r].glyphName);return e},getGlyphMapping:function Type1Font_getGlyphMapping(e){var t=this.charstrings;if(e.composite){const r=Object.create(null);for(let a=0,i=t.length;a<i;a++){r[e.cMap.charCodeOf(a)]=a+1}return r}var r,a=[".notdef"];for(r=0;r<t.length;r++)a.push(t[r].glyphName);var i=e.builtInEncoding;if(i){var n=Object.create(null);for(var s in i)(r=a.indexOf(i[s]))>=0&&(n[s]=r)}return type1FontGlyphMapping(e,n,a)},hasGlyphId:function Type1Font_hasGlyphID(e){return!(e<0||e>=this.numGlyphs)&&(0===e||this.charstrings[e-1].charstring.length>0)},getSeacs:function Type1Font_getSeacs(e){var t,r,a=[];for(t=0,r=e.length;t<r;t++){var i=e[t];i.seac&&(a[t+1]=i.seac)}return a},getType2Charstrings:function Type1Font_getType2Charstrings(e){for(var t=[],r=0,a=e.length;r<a;r++)t.push(e[r].charstring);return t},getType2Subrs:function Type1Font_getType2Subrs(e){var t=0,r=e.length;t=r<1133?107:r<33769?1131:32768;var a,i=[];for(a=0;a<t;a++)i.push([11]);for(a=0;a<r;a++)i.push(e[a]);return i},wrap:function Type1Font_wrap(e,t,r,a,n){var s=new i.CFF;s.header=new i.CFFHeader(1,0,4,4);s.names=[e];var o=new i.CFFTopDict;o.setByName("version",391);o.setByName("Notice",392);o.setByName("FullName",393);o.setByName("FamilyName",394);o.setByName("Weight",395);o.setByName("Encoding",null);o.setByName("FontMatrix",n.fontMatrix);o.setByName("FontBBox",n.bbox);o.setByName("charset",null);o.setByName("CharStrings",null);o.setByName("Private",null);s.topDict=o;var c=new i.CFFStrings;c.add("Version 0.11");c.add("See original notice");c.add(e);c.add(e);c.add("Medium");s.strings=c;s.globalSubrIndex=new i.CFFIndex;var l,h,u=t.length,d=[".notdef"];for(l=0;l<u;l++){const e=r[l].glyphName;-1===i.CFFStandardStrings.indexOf(e)&&c.add(e);d.push(e)}s.charset=new i.CFFCharset(!1,0,d);var f=new i.CFFIndex;f.add([139,14]);for(l=0;l<u;l++)f.add(t[l]);s.charStrings=f;var g=new i.CFFPrivateDict;g.setByName("Subrs",null);var p=["BlueValues","OtherBlues","FamilyBlues","FamilyOtherBlues","StemSnapH","StemSnapV","BlueShift","BlueFuzz","BlueScale","LanguageGroup","ExpansionFactor","ForceBold","StdHW","StdVW"];for(l=0,h=p.length;l<h;l++){var m=p[l];if(m in n.privateData){var b=n.privateData[m];if(Array.isArray(b))for(var y=b.length-1;y>0;y--)b[y]-=b[y-1];g.setByName(m,b)}}s.topDict.privateDict=g;var w=new i.CFFIndex;for(l=0,h=a.length;l<h;l++)w.add(a[l]);g.subrsIndex=w;return new i.CFFCompiler(s).compile()}};return Type1Font}(),E=function CFFFontClosure(){function CFFFont(e,t){this.properties=t;var r=new i.CFFParser(e,t,m);this.cff=r.parse();this.cff.duplicateFirstGlyph();var n=new i.CFFCompiler(this.cff);this.seacs=this.cff.seacs;try{this.data=n.compile()}catch(r){(0,a.warn)("Failed to compile font "+t.loadedName);this.data=e}}CFFFont.prototype={get numGlyphs(){return this.cff.charStrings.count},getCharset:function CFFFont_getCharset(){return this.cff.charset.charset},getGlyphMapping:function CFFFont_getGlyphMapping(){var e,t,r=this.cff,a=this.properties,i=r.charset.charset;if(a.composite){e=Object.create(null);let s;if(r.isCIDFont)for(t=0;t<i.length;t++){var n=i[t];s=a.cMap.charCodeOf(n);e[s]=t}else for(t=0;t<r.charStrings.count;t++){s=a.cMap.charCodeOf(t);e[s]=t}return e}return e=type1FontGlyphMapping(a,r.encoding?r.encoding.encoding:null,i)},hasGlyphId:function CFFFont_hasGlyphID(e){return this.cff.hasGlyphId(e)}};return CFFFont}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.CFFTopDict=t.CFFStrings=t.CFFStandardStrings=t.CFFPrivateDict=t.CFFParser=t.CFFIndex=t.CFFHeader=t.CFFFDSelect=t.CFFCompiler=t.CFFCharset=t.CFF=void 0;var a=r(2),i=r(33),n=r(34);const s=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall","001.000","001.001","001.002","001.003","Black","Bold","Book","Light","Medium","Regular","Roman","Semibold"];t.CFFStandardStrings=s;const o=391,c=function CFFParserClosure(){const e=[null,{id:"hstem",min:2,stackClearing:!0,stem:!0},null,{id:"vstem",min:2,stackClearing:!0,stem:!0},{id:"vmoveto",min:1,stackClearing:!0},{id:"rlineto",min:2,resetStack:!0},{id:"hlineto",min:1,resetStack:!0},{id:"vlineto",min:1,resetStack:!0},{id:"rrcurveto",min:6,resetStack:!0},null,{id:"callsubr",min:1,undefStack:!0},{id:"return",min:0,undefStack:!0},null,null,{id:"endchar",min:0,stackClearing:!0},null,null,null,{id:"hstemhm",min:2,stackClearing:!0,stem:!0},{id:"hintmask",min:0,stackClearing:!0},{id:"cntrmask",min:0,stackClearing:!0},{id:"rmoveto",min:2,stackClearing:!0},{id:"hmoveto",min:1,stackClearing:!0},{id:"vstemhm",min:2,stackClearing:!0,stem:!0},{id:"rcurveline",min:8,resetStack:!0},{id:"rlinecurve",min:8,resetStack:!0},{id:"vvcurveto",min:4,resetStack:!0},{id:"hhcurveto",min:4,resetStack:!0},null,{id:"callgsubr",min:1,undefStack:!0},{id:"vhcurveto",min:4,resetStack:!0},{id:"hvcurveto",min:4,resetStack:!0}],t=[null,null,null,{id:"and",min:2,stackDelta:-1},{id:"or",min:2,stackDelta:-1},{id:"not",min:1,stackDelta:0},null,null,null,{id:"abs",min:1,stackDelta:0},{id:"add",min:2,stackDelta:-1,stackFn:function stack_div(e,t){e[t-2]=e[t-2]+e[t-1]}},{id:"sub",min:2,stackDelta:-1,stackFn:function stack_div(e,t){e[t-2]=e[t-2]-e[t-1]}},{id:"div",min:2,stackDelta:-1,stackFn:function stack_div(e,t){e[t-2]=e[t-2]/e[t-1]}},null,{id:"neg",min:1,stackDelta:0,stackFn:function stack_div(e,t){e[t-1]=-e[t-1]}},{id:"eq",min:2,stackDelta:-1},null,null,{id:"drop",min:1,stackDelta:-1},null,{id:"put",min:2,stackDelta:-2},{id:"get",min:1,stackDelta:0},{id:"ifelse",min:4,stackDelta:-3},{id:"random",min:0,stackDelta:1},{id:"mul",min:2,stackDelta:-1,stackFn:function stack_div(e,t){e[t-2]=e[t-2]*e[t-1]}},null,{id:"sqrt",min:1,stackDelta:0},{id:"dup",min:1,stackDelta:1},{id:"exch",min:2,stackDelta:0},{id:"index",min:2,stackDelta:0},{id:"roll",min:3,stackDelta:-2},null,null,null,{id:"hflex",min:7,resetStack:!0},{id:"flex",min:13,resetStack:!0},{id:"hflex1",min:9,resetStack:!0},{id:"flex1",min:11,resetStack:!0}];return class CFFParser{constructor(e,t,r){this.bytes=e.getBytes();this.properties=t;this.seacAnalysisEnabled=!!r}parse(){const e=this.properties,t=new CFF;this.cff=t;const r=this.parseHeader(),a=this.parseIndex(r.endPos),i=this.parseIndex(a.endPos),n=this.parseIndex(i.endPos),s=this.parseIndex(n.endPos),o=this.parseDict(i.obj.get(0)),c=this.createDict(l,o,t.strings);t.header=r.obj;t.names=this.parseNameIndex(a.obj);t.strings=this.parseStringIndex(n.obj);t.topDict=c;t.globalSubrIndex=s.obj;this.parsePrivateDict(t.topDict);t.isCIDFont=c.hasName("ROS");const h=c.getByName("CharStrings"),u=this.parseIndex(h).obj,d=c.getByName("FontMatrix");d&&(e.fontMatrix=d);const f=c.getByName("FontBBox");if(f){e.ascent=Math.max(f[3],f[1]);e.descent=Math.min(f[1],f[3]);e.ascentScaled=!0}let g,p;if(t.isCIDFont){const e=this.parseIndex(c.getByName("FDArray")).obj;for(let r=0,a=e.count;r<a;++r){const a=e.get(r),i=this.createDict(l,this.parseDict(a),t.strings);this.parsePrivateDict(i);t.fdArray.push(i)}p=null;g=this.parseCharsets(c.getByName("charset"),u.count,t.strings,!0);t.fdSelect=this.parseFDSelect(c.getByName("FDSelect"),u.count)}else{g=this.parseCharsets(c.getByName("charset"),u.count,t.strings,!1);p=this.parseEncoding(c.getByName("Encoding"),e,t.strings,g.charset)}t.charset=g;t.encoding=p;const m=this.parseCharStrings({charStrings:u,localSubrIndex:c.privateDict.subrsIndex,globalSubrIndex:s.obj,fdSelect:t.fdSelect,fdArray:t.fdArray,privateDict:c.privateDict});t.charStrings=m.charStrings;t.seacs=m.seacs;t.widths=m.widths;return t}parseHeader(){let e=this.bytes;const t=e.length;let r=0;for(;r<t&&1!==e[r];)++r;if(r>=t)throw new a.FormatError("Invalid CFF header");if(0!==r){(0,a.info)("cff data is shifted");e=e.subarray(r);this.bytes=e}const i=e[0],n=e[1],s=e[2],o=e[3];return{obj:new CFFHeader(i,n,s,o),endPos:s}}parseDict(e){let t=0;function parseOperand(){let r=e[t++];if(30===r)return function parseFloatOperand(){let r="";const a=15,i=["0","1","2","3","4","5","6","7","8","9",".","E","E-",null,"-"],n=e.length;for(;t<n;){const n=e[t++],s=n>>4,o=15&n;if(s===a)break;r+=i[s];if(o===a)break;r+=i[o]}return parseFloat(r)}();if(28===r){r=e[t++];r=(r<<24|e[t++]<<16)>>16;return r}if(29===r){r=e[t++];r=r<<8|e[t++];r=r<<8|e[t++];r=r<<8|e[t++];return r}if(r>=32&&r<=246)return r-139;if(r>=247&&r<=250)return 256*(r-247)+e[t++]+108;if(r>=251&&r<=254)return-256*(r-251)-e[t++]-108;(0,a.warn)('CFFParser_parseDict: "'+r+'" is a reserved command.');return NaN}let r=[];const i=[];t=0;const n=e.length;for(;t<n;){let a=e[t];if(a<=21){12===a&&(a=a<<8|e[++t]);i.push([a,r]);r=[];++t}else r.push(parseOperand())}return i}parseIndex(e){const t=new CFFIndex,r=this.bytes,a=r[e++]<<8|r[e++],i=[];let n,s,o=e;if(0!==a){const t=r[e++],c=e+(a+1)*t-1;for(n=0,s=a+1;n<s;++n){let a=0;for(let i=0;i<t;++i){a<<=8;a+=r[e++]}i.push(c+a)}o=i[a]}for(n=0,s=i.length-1;n<s;++n){const e=i[n],a=i[n+1];t.add(r.subarray(e,a))}return{obj:t,endPos:o}}parseNameIndex(e){const t=[];for(let r=0,i=e.count;r<i;++r){const i=e.get(r);t.push((0,a.bytesToString)(i))}return t}parseStringIndex(e){const t=new CFFStrings;for(let r=0,i=e.count;r<i;++r){const i=e.get(r);t.add((0,a.bytesToString)(i))}return t}createDict(e,t,r){const a=new e(r);for(let e=0,r=t.length;e<r;++e){const r=t[e],i=r[0],n=r[1];a.setByKey(i,n)}return a}parseCharString(r,i,n,s){if(!i||r.callDepth>10)return!1;let o=r.stackSize;const c=r.stack,l=i.length;for(let h=0;h<l;){const l=i[h++];let u=null;if(12===l){const e=i[h++];if(0===e){i[h-2]=139;i[h-1]=22;o=0}else u=t[e]}else if(28===l){c[o]=(i[h]<<24|i[h+1]<<16)>>16;h+=2;o++}else if(14===l){if(o>=4){o-=4;if(this.seacAnalysisEnabled){r.seac=c.slice(o,o+4);return!1}}u=e[l]}else if(l>=32&&l<=246){c[o]=l-139;o++}else if(l>=247&&l<=254){c[o]=l<251?(l-247<<8)+i[h]+108:-(l-251<<8)-i[h]-108;h++;o++}else if(255===l){c[o]=(i[h]<<24|i[h+1]<<16|i[h+2]<<8|i[h+3])/65536;h+=4;o++}else if(19===l||20===l){r.hints+=o>>1;h+=r.hints+7>>3;o%=2;u=e[l]}else{if(10===l||29===l){let t;t=10===l?n:s;if(!t){u=e[l];(0,a.warn)("Missing subrsIndex for "+u.id);return!1}let i=32768;t.count<1240?i=107:t.count<33900&&(i=1131);const h=c[--o]+i;if(h<0||h>=t.count||isNaN(h)){u=e[l];(0,a.warn)("Out of bounds subrIndex for "+u.id);return!1}r.stackSize=o;r.callDepth++;if(!this.parseCharString(r,t.get(h),n,s))return!1;r.callDepth--;o=r.stackSize;continue}if(11===l){r.stackSize=o;return!0}u=e[l]}if(u){if(u.stem){r.hints+=o>>1;if(3===l||23===l)r.hasVStems=!0;else if(r.hasVStems&&(1===l||18===l)){(0,a.warn)("CFF stem hints are in wrong order");i[h-1]=1===l?3:23}}if("min"in u&&!r.undefStack&&o<u.min){(0,a.warn)("Not enough parameters for "+u.id+"; actual: "+o+", expected: "+u.min);return!1}if(r.firstStackClearing&&u.stackClearing){r.firstStackClearing=!1;o-=u.min;o>=2&&u.stem?o%=2:o>1&&(0,a.warn)("Found too many parameters for stack-clearing command");o>0&&c[o-1]>=0&&(r.width=c[o-1])}if("stackDelta"in u){"stackFn"in u&&u.stackFn(c,o);o+=u.stackDelta}else if(u.stackClearing)o=0;else if(u.resetStack){o=0;r.undefStack=!1}else if(u.undefStack){o=0;r.undefStack=!0;r.firstStackClearing=!1}}}r.stackSize=o;return!0}parseCharStrings({charStrings:e,localSubrIndex:t,globalSubrIndex:r,fdSelect:i,fdArray:n,privateDict:s}){const o=[],c=[],l=e.count;for(let h=0;h<l;h++){const l=e.get(h),u={callDepth:0,stackSize:0,stack:[],undefStack:!0,hints:0,firstStackClearing:!0,seac:null,width:null,hasVStems:!1};let d=!0,f=null,g=s;if(i&&n.length){const e=i.getFDIndex(h);if(-1===e){(0,a.warn)("Glyph index is not in fd select.");d=!1}if(e>=n.length){(0,a.warn)("Invalid fd index for glyph index.");d=!1}if(d){g=n[e].privateDict;f=g.subrsIndex}}else t&&(f=t);d&&(d=this.parseCharString(u,l,f,r));if(null!==u.width){const e=g.getByName("nominalWidthX");c[h]=e+u.width}else{const e=g.getByName("defaultWidthX");c[h]=e}null!==u.seac&&(o[h]=u.seac);d||e.set(h,new Uint8Array([14]))}return{charStrings:e,seacs:o,widths:c}}emptyPrivateDictionary(e){const t=this.createDict(h,[],e.strings);e.setByKey(18,[0,0]);e.privateDict=t}parsePrivateDict(e){if(!e.hasName("Private")){this.emptyPrivateDictionary(e);return}const t=e.getByName("Private");if(!Array.isArray(t)||2!==t.length){e.removeByName("Private");return}const r=t[0],a=t[1];if(0===r||a>=this.bytes.length){this.emptyPrivateDictionary(e);return}const i=a+r,n=this.bytes.subarray(a,i),s=this.parseDict(n),o=this.createDict(h,s,e.strings);e.privateDict=o;if(!o.getByName("Subrs"))return;const c=o.getByName("Subrs"),l=a+c;if(0===c||l>=this.bytes.length){this.emptyPrivateDictionary(e);return}const u=this.parseIndex(l);o.subrsIndex=u.obj}parseCharsets(e,t,r,n){if(0===e)return new CFFCharset(!0,u.ISO_ADOBE,i.ISOAdobeCharset);if(1===e)return new CFFCharset(!0,u.EXPERT,i.ExpertCharset);if(2===e)return new CFFCharset(!0,u.EXPERT_SUBSET,i.ExpertSubsetCharset);const s=this.bytes,o=e,c=s[e++],l=[n?0:".notdef"];let h,d,f;t-=1;switch(c){case 0:for(f=0;f<t;f++){h=s[e++]<<8|s[e++];l.push(n?h:r.get(h))}break;case 1:for(;l.length<=t;){h=s[e++]<<8|s[e++];d=s[e++];for(f=0;f<=d;f++)l.push(n?h++:r.get(h++))}break;case 2:for(;l.length<=t;){h=s[e++]<<8|s[e++];d=s[e++]<<8|s[e++];for(f=0;f<=d;f++)l.push(n?h++:r.get(h++))}break;default:throw new a.FormatError("Unknown charset format")}const g=e,p=s.subarray(o,g);return new CFFCharset(!1,c,l,p)}parseEncoding(e,t,r,i){const s=Object.create(null),o=this.bytes;let c,l,h,u=!1,d=null;if(0===e||1===e){u=!0;c=e;const t=e?n.ExpertEncoding:n.StandardEncoding;for(l=0,h=i.length;l<h;l++){const e=t.indexOf(i[l]);-1!==e&&(s[e]=l)}}else{const t=e;c=o[e++];switch(127&c){case 0:const t=o[e++];for(l=1;l<=t;l++)s[o[e++]]=l;break;case 1:const r=o[e++];let i=1;for(l=0;l<r;l++){const t=o[e++],r=o[e++];for(let e=t;e<=t+r;e++)s[e]=i++}break;default:throw new a.FormatError(`Unknown encoding format: ${c} in CFF`)}const n=e;if(128&c){o[t]&=127;!function readSupplement(){const t=o[e++];for(l=0;l<t;l++){const t=o[e++],a=(o[e++]<<8)+(255&o[e++]);s[t]=i.indexOf(r.get(a))}}()}d=o.subarray(t,n)}c&=127;return new CFFEncoding(u,c,s,d)}parseFDSelect(e,t){const r=this.bytes,i=r[e++],n=[];let s;switch(i){case 0:for(s=0;s<t;++s){const t=r[e++];n.push(t)}break;case 3:const o=r[e++]<<8|r[e++];for(s=0;s<o;++s){let t=r[e++]<<8|r[e++];if(0===s&&0!==t){(0,a.warn)("parseFDSelect: The first range must have a first GID of 0 -- trying to recover.");t=0}const i=r[e++],o=r[e]<<8|r[e+1];for(let e=t;e<o;++e)n.push(i)}e+=2;break;default:throw new a.FormatError(`parseFDSelect: Unknown format "${i}".`)}if(n.length!==t)throw new a.FormatError("parseFDSelect: Invalid font data.");return new CFFFDSelect(i,n)}}}();t.CFFParser=c;class CFF{constructor(){this.header=null;this.names=[];this.topDict=null;this.strings=new CFFStrings;this.globalSubrIndex=null;this.encoding=null;this.charset=null;this.charStrings=null;this.fdArray=[];this.fdSelect=null;this.isCIDFont=!1}duplicateFirstGlyph(){if(this.charStrings.count>=65535){(0,a.warn)("Not enough space in charstrings to duplicate first glyph.");return}const e=this.charStrings.get(0);this.charStrings.add(e);this.isCIDFont&&this.fdSelect.fdSelect.push(this.fdSelect.fdSelect[0])}hasGlyphId(e){if(e<0||e>=this.charStrings.count)return!1;return this.charStrings.get(e).length>0}}t.CFF=CFF;class CFFHeader{constructor(e,t,r,a){this.major=e;this.minor=t;this.hdrSize=r;this.offSize=a}}t.CFFHeader=CFFHeader;class CFFStrings{constructor(){this.strings=[]}get(e){return e>=0&&e<=390?s[e]:e-o<=this.strings.length?this.strings[e-o]:s[0]}getSID(e){let t=s.indexOf(e);if(-1!==t)return t;t=this.strings.indexOf(e);return-1!==t?t+o:-1}add(e){this.strings.push(e)}get count(){return this.strings.length}}t.CFFStrings=CFFStrings;class CFFIndex{constructor(){this.objects=[];this.length=0}add(e){this.length+=e.length;this.objects.push(e)}set(e,t){this.length+=t.length-this.objects[e].length;this.objects[e]=t}get(e){return this.objects[e]}get count(){return this.objects.length}}t.CFFIndex=CFFIndex;class CFFDict{constructor(e,t){this.keyToNameMap=e.keyToNameMap;this.nameToKeyMap=e.nameToKeyMap;this.defaults=e.defaults;this.types=e.types;this.opcodes=e.opcodes;this.order=e.order;this.strings=t;this.values=Object.create(null)}setByKey(e,t){if(!(e in this.keyToNameMap))return!1;const r=t.length;if(0===r)return!0;for(let i=0;i<r;i++)if(isNaN(t[i])){(0,a.warn)('Invalid CFFDict value: "'+t+'" for key "'+e+'".');return!0}const i=this.types[e];"num"!==i&&"sid"!==i&&"offset"!==i||(t=t[0]);this.values[e]=t;return!0}setByName(e,t){if(!(e in this.nameToKeyMap))throw new a.FormatError(`Invalid dictionary name "${e}"`);this.values[this.nameToKeyMap[e]]=t}hasName(e){return this.nameToKeyMap[e]in this.values}getByName(e){if(!(e in this.nameToKeyMap))throw new a.FormatError(`Invalid dictionary name ${e}"`);const t=this.nameToKeyMap[e];return t in this.values?this.values[t]:this.defaults[t]}removeByName(e){delete this.values[this.nameToKeyMap[e]]}static createTables(e){const t={keyToNameMap:{},nameToKeyMap:{},defaults:{},types:{},opcodes:{},order:[]};for(let r=0,a=e.length;r<a;++r){const a=e[r],i=Array.isArray(a[0])?(a[0][0]<<8)+a[0][1]:a[0];t.keyToNameMap[i]=a[1];t.nameToKeyMap[a[1]]=i;t.types[i]=a[2];t.defaults[i]=a[3];t.opcodes[i]=Array.isArray(a[0])?a[0]:[a[0]];t.order.push(i)}return t}}const l=function CFFTopDictClosure(){const e=[[[12,30],"ROS",["sid","sid","num"],null],[[12,20],"SyntheticBase","num",null],[0,"version","sid",null],[1,"Notice","sid",null],[[12,0],"Copyright","sid",null],[2,"FullName","sid",null],[3,"FamilyName","sid",null],[4,"Weight","sid",null],[[12,1],"isFixedPitch","num",0],[[12,2],"ItalicAngle","num",0],[[12,3],"UnderlinePosition","num",-100],[[12,4],"UnderlineThickness","num",50],[[12,5],"PaintType","num",0],[[12,6],"CharstringType","num",2],[[12,7],"FontMatrix",["num","num","num","num","num","num"],[.001,0,0,.001,0,0]],[13,"UniqueID","num",null],[5,"FontBBox",["num","num","num","num"],[0,0,0,0]],[[12,8],"StrokeWidth","num",0],[14,"XUID","array",null],[15,"charset","offset",0],[16,"Encoding","offset",0],[17,"CharStrings","offset",0],[18,"Private",["offset","offset"],null],[[12,21],"PostScript","sid",null],[[12,22],"BaseFontName","sid",null],[[12,23],"BaseFontBlend","delta",null],[[12,31],"CIDFontVersion","num",0],[[12,32],"CIDFontRevision","num",0],[[12,33],"CIDFontType","num",0],[[12,34],"CIDCount","num",8720],[[12,35],"UIDBase","num",null],[[12,37],"FDSelect","offset",null],[[12,36],"FDArray","offset",null],[[12,38],"FontName","sid",null]];let t=null;return class CFFTopDict extends CFFDict{constructor(r){null===t&&(t=CFFDict.createTables(e));super(t,r);this.privateDict=null}}}();t.CFFTopDict=l;const h=function CFFPrivateDictClosure(){const e=[[6,"BlueValues","delta",null],[7,"OtherBlues","delta",null],[8,"FamilyBlues","delta",null],[9,"FamilyOtherBlues","delta",null],[[12,9],"BlueScale","num",.039625],[[12,10],"BlueShift","num",7],[[12,11],"BlueFuzz","num",1],[10,"StdHW","num",null],[11,"StdVW","num",null],[[12,12],"StemSnapH","delta",null],[[12,13],"StemSnapV","delta",null],[[12,14],"ForceBold","num",0],[[12,17],"LanguageGroup","num",0],[[12,18],"ExpansionFactor","num",.06],[[12,19],"initialRandomSeed","num",0],[20,"defaultWidthX","num",0],[21,"nominalWidthX","num",0],[19,"Subrs","offset",null]];let t=null;return class CFFPrivateDict extends CFFDict{constructor(r){null===t&&(t=CFFDict.createTables(e));super(t,r);this.subrsIndex=null}}}();t.CFFPrivateDict=h;const u={ISO_ADOBE:0,EXPERT:1,EXPERT_SUBSET:2};class CFFCharset{constructor(e,t,r,a){this.predefined=e;this.format=t;this.charset=r;this.raw=a}}t.CFFCharset=CFFCharset;class CFFEncoding{constructor(e,t,r,a){this.predefined=e;this.format=t;this.encoding=r;this.raw=a}}class CFFFDSelect{constructor(e,t){this.format=e;this.fdSelect=t}getFDIndex(e){return e<0||e>=this.fdSelect.length?-1:this.fdSelect[e]}}t.CFFFDSelect=CFFFDSelect;class CFFOffsetTracker{constructor(){this.offsets=Object.create(null)}isTracking(e){return e in this.offsets}track(e,t){if(e in this.offsets)throw new a.FormatError(`Already tracking location of ${e}`);this.offsets[e]=t}offset(e){for(const t in this.offsets)this.offsets[t]+=e}setEntryLocation(e,t,r){if(!(e in this.offsets))throw new a.FormatError(`Not tracking location of ${e}`);const i=r.data,n=this.offsets[e];for(let e=0,r=t.length;e<r;++e){const r=5*e+n,s=r+1,o=r+2,c=r+3,l=r+4;if(29!==i[r]||0!==i[s]||0!==i[o]||0!==i[c]||0!==i[l])throw new a.FormatError("writing to an offset that is not empty");const h=t[e];i[r]=29;i[s]=h>>24&255;i[o]=h>>16&255;i[c]=h>>8&255;i[l]=255&h}}}class CFFCompiler{constructor(e){this.cff=e}compile(){const e=this.cff,t={data:[],length:0,add:function CFFCompiler_add(e){this.data=this.data.concat(e);this.length=this.data.length}},r=this.compileHeader(e.header);t.add(r);const i=this.compileNameIndex(e.names);t.add(i);if(e.isCIDFont&&e.topDict.hasName("FontMatrix")){const t=e.topDict.getByName("FontMatrix");e.topDict.removeByName("FontMatrix");for(let r=0,i=e.fdArray.length;r<i;r++){const i=e.fdArray[r];let n=t.slice(0);i.hasName("FontMatrix")&&(n=a.Util.transform(n,i.getByName("FontMatrix")));i.setByName("FontMatrix",n)}}const n=e.topDict.getByName("XUID");n&&n.length>16&&e.topDict.removeByName("XUID");e.topDict.setByName("charset",0);let s=this.compileTopDicts([e.topDict],t.length,e.isCIDFont);t.add(s.output);const o=s.trackers[0],c=this.compileStringIndex(e.strings.strings);t.add(c);const l=this.compileIndex(e.globalSubrIndex);t.add(l);if(e.encoding&&e.topDict.hasName("Encoding"))if(e.encoding.predefined)o.setEntryLocation("Encoding",[e.encoding.format],t);else{const r=this.compileEncoding(e.encoding);o.setEntryLocation("Encoding",[t.length],t);t.add(r)}const h=this.compileCharset(e.charset,e.charStrings.count,e.strings,e.isCIDFont);o.setEntryLocation("charset",[t.length],t);t.add(h);const u=this.compileCharStrings(e.charStrings);o.setEntryLocation("CharStrings",[t.length],t);t.add(u);if(e.isCIDFont){o.setEntryLocation("FDSelect",[t.length],t);const r=this.compileFDSelect(e.fdSelect);t.add(r);s=this.compileTopDicts(e.fdArray,t.length,!0);o.setEntryLocation("FDArray",[t.length],t);t.add(s.output);const a=s.trackers;this.compilePrivateDicts(e.fdArray,a,t)}this.compilePrivateDicts([e.topDict],[o],t);t.add([0]);return t.data}encodeNumber(e){return Number.isInteger(e)?this.encodeInteger(e):this.encodeFloat(e)}static get EncodeFloatRegExp(){return(0,a.shadow)(this,"EncodeFloatRegExp",/\.(\d*?)(?:9{5,20}|0{5,20})\d{0,2}(?:e(.+)|$)/)}encodeFloat(e){let t=e.toString();const r=CFFCompiler.EncodeFloatRegExp.exec(t);if(r){const a=parseFloat("1e"+((r[2]?+r[2]:0)+r[1].length));t=(Math.round(e*a)/a).toString()}let a,i,n="";for(a=0,i=t.length;a<i;++a){const e=t[a];n+="e"===e?"-"===t[++a]?"c":"b":"."===e?"a":"-"===e?"e":e}n+=1&n.length?"f":"ff";const s=[30];for(a=0,i=n.length;a<i;a+=2)s.push(parseInt(n.substring(a,a+2),16));return s}encodeInteger(e){let t;t=e>=-107&&e<=107?[e+139]:e>=108&&e<=1131?[247+((e-=108)>>8),255&e]:e>=-1131&&e<=-108?[251+((e=-e-108)>>8),255&e]:e>=-32768&&e<=32767?[28,e>>8&255,255&e]:[29,e>>24&255,e>>16&255,e>>8&255,255&e];return t}compileHeader(e){return[e.major,e.minor,4,e.offSize]}compileNameIndex(e){const t=new CFFIndex;for(let r=0,i=e.length;r<i;++r){const i=e[r],n=Math.min(i.length,127);let s=new Array(n);for(let e=0;e<n;e++){let t=i[e];(t<"!"||t>"~"||"["===t||"]"===t||"("===t||")"===t||"{"===t||"}"===t||"<"===t||">"===t||"/"===t||"%"===t)&&(t="_");s[e]=t}s=s.join("");""===s&&(s="Bad_Font_Name");t.add((0,a.stringToBytes)(s))}return this.compileIndex(t)}compileTopDicts(e,t,r){const a=[];let i=new CFFIndex;for(let n=0,s=e.length;n<s;++n){const s=e[n];if(r){s.removeByName("CIDFontVersion");s.removeByName("CIDFontRevision");s.removeByName("CIDFontType");s.removeByName("CIDCount");s.removeByName("UIDBase")}const o=new CFFOffsetTracker,c=this.compileDict(s,o);a.push(o);i.add(c);o.offset(t)}i=this.compileIndex(i,a);return{trackers:a,output:i}}compilePrivateDicts(e,t,r){for(let i=0,n=e.length;i<n;++i){const n=e[i],s=n.privateDict;if(!s||!n.hasName("Private"))throw new a.FormatError("There must be a private dictionary.");const o=new CFFOffsetTracker,c=this.compileDict(s,o);let l=r.length;o.offset(l);c.length||(l=0);t[i].setEntryLocation("Private",[c.length,l],r);r.add(c);if(s.subrsIndex&&s.hasName("Subrs")){const e=this.compileIndex(s.subrsIndex);o.setEntryLocation("Subrs",[c.length],r);r.add(e)}}}compileDict(e,t){let r=[];const i=e.order;for(let n=0;n<i.length;++n){const s=i[n];if(!(s in e.values))continue;let o=e.values[s],c=e.types[s];Array.isArray(c)||(c=[c]);Array.isArray(o)||(o=[o]);if(0!==o.length){for(let i=0,n=c.length;i<n;++i){const n=c[i],l=o[i];switch(n){case"num":case"sid":r=r.concat(this.encodeNumber(l));break;case"offset":const i=e.keyToNameMap[s];t.isTracking(i)||t.track(i,r.length);r=r.concat([29,0,0,0,0]);break;case"array":case"delta":r=r.concat(this.encodeNumber(l));for(let e=1,t=o.length;e<t;++e)r=r.concat(this.encodeNumber(o[e]));break;default:throw new a.FormatError(`Unknown data type of ${n}`)}}r=r.concat(e.opcodes[s])}}return r}compileStringIndex(e){const t=new CFFIndex;for(let r=0,i=e.length;r<i;++r)t.add((0,a.stringToBytes)(e[r]));return this.compileIndex(t)}compileGlobalSubrIndex(){const e=this.cff.globalSubrIndex;this.out.writeByteArray(this.compileIndex(e))}compileCharStrings(e){const t=new CFFIndex;for(let r=0;r<e.count;r++){const a=e.get(r);0!==a.length?t.add(a):t.add(new Uint8Array([139,14]))}return this.compileIndex(t)}compileCharset(e,t,r,i){let n;const s=t-1;if(i)n=new Uint8Array([2,0,0,s>>8&255,255&s]);else{n=new Uint8Array(1+2*s);n[0]=0;let t=0;const i=e.charset.length;let o=!1;for(let s=1;s<n.length;s+=2){let c=0;if(t<i){const i=e.charset[t++];c=r.getSID(i);if(-1===c){c=0;if(!o){o=!0;(0,a.warn)(`Couldn't find ${i} in CFF strings`)}}}n[s]=c>>8&255;n[s+1]=255&c}}return this.compileTypedArray(n)}compileEncoding(e){return this.compileTypedArray(e.raw)}compileFDSelect(e){const t=e.format;let r,a;switch(t){case 0:r=new Uint8Array(1+e.fdSelect.length);r[0]=t;for(a=0;a<e.fdSelect.length;a++)r[a+1]=e.fdSelect[a];break;case 3:const i=0;let n=e.fdSelect[0];const s=[t,0,0,i>>8&255,255&i,n];for(a=1;a<e.fdSelect.length;a++){const t=e.fdSelect[a];if(t!==n){s.push(a>>8&255,255&a,t);n=t}}const o=(s.length-3)/3;s[1]=o>>8&255;s[2]=255&o;s.push(a>>8&255,255&a);r=new Uint8Array(s)}return this.compileTypedArray(r)}compileTypedArray(e){const t=[];for(let r=0,a=e.length;r<a;++r)t[r]=e[r];return t}compileIndex(e,t=[]){const r=e.objects,a=r.length;if(0===a)return[0,0,0];const i=[a>>8&255,255&a];let n,s,o=1;for(n=0;n<a;++n)o+=r[n].length;s=o<256?1:o<65536?2:o<16777216?3:4;i.push(s);let c=1;for(n=0;n<a+1;n++){1===s?i.push(255&c):2===s?i.push(c>>8&255,255&c):3===s?i.push(c>>16&255,c>>8&255,255&c):i.push(c>>>24&255,c>>16&255,c>>8&255,255&c);r[n]&&(c+=r[n].length)}for(n=0;n<a;n++){t[n]&&t[n].offset(i.length);for(let e=0,t=r[n].length;e<t;e++)i.push(r[n][e])}return i}}t.CFFCompiler=CFFCompiler},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ISOAdobeCharset=t.ExpertSubsetCharset=t.ExpertCharset=void 0;t.ISOAdobeCharset=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron"];t.ExpertCharset=[".notdef","space","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertSubsetCharset=[".notdef","space","dollaroldstyle","dollarsuperior","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","hyphensuperior","colonmonetary","onefitted","rupiah","centoldstyle","figuredash","hypheninferior","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior"]},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getEncoding=function getEncoding(e){switch(e){case"WinAnsiEncoding":return s;case"StandardEncoding":return n;case"MacRomanEncoding":return i;case"SymbolSetEncoding":return o;case"ZapfDingbatsEncoding":return c;case"ExpertEncoding":return r;case"MacExpertEncoding":return a;default:return null}};t.ZapfDingbatsEncoding=t.WinAnsiEncoding=t.SymbolSetEncoding=t.StandardEncoding=t.MacRomanEncoding=t.ExpertEncoding=void 0;const r=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","","asuperior","bsuperior","centsuperior","dsuperior","esuperior","","","","isuperior","","","lsuperior","msuperior","nsuperior","osuperior","","","rsuperior","ssuperior","tsuperior","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdownsmall","centoldstyle","Lslashsmall","","","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","","Dotaccentsmall","","","Macronsmall","","","figuredash","hypheninferior","","","Ogoneksmall","Ringsmall","Cedillasmall","","","","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertEncoding=r;const a=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","centoldstyle","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","","threequartersemdash","","questionsmall","","","","","Ethsmall","","","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","","","","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hypheninferior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","asuperior","centsuperior","","","","","Aacutesmall","Agravesmall","Acircumflexsmall","Adieresissmall","Atildesmall","Aringsmall","Ccedillasmall","Eacutesmall","Egravesmall","Ecircumflexsmall","Edieresissmall","Iacutesmall","Igravesmall","Icircumflexsmall","Idieresissmall","Ntildesmall","Oacutesmall","Ogravesmall","Ocircumflexsmall","Odieresissmall","Otildesmall","Uacutesmall","Ugravesmall","Ucircumflexsmall","Udieresissmall","","eightsuperior","fourinferior","threeinferior","sixinferior","eightinferior","seveninferior","Scaronsmall","","centinferior","twoinferior","","Dieresissmall","","Caronsmall","osuperior","fiveinferior","","commainferior","periodinferior","Yacutesmall","","dollarinferior","","","Thornsmall","","nineinferior","zeroinferior","Zcaronsmall","AEsmall","Oslashsmall","questiondownsmall","oneinferior","Lslashsmall","","","","","","","Cedillasmall","","","","","","OEsmall","figuredash","hyphensuperior","","","","","exclamdownsmall","","Ydieresissmall","","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","ninesuperior","zerosuperior","","esuperior","rsuperior","tsuperior","","","isuperior","ssuperior","dsuperior","","","","","","lsuperior","Ogoneksmall","Brevesmall","Macronsmall","bsuperior","nsuperior","msuperior","commasuperior","periodsuperior","Dotaccentsmall","Ringsmall","","","",""],i=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","space","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron"];t.MacRomanEncoding=i;const n=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","","endash","dagger","daggerdbl","periodcentered","","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","","questiondown","","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","","ring","cedilla","","hungarumlaut","ogonek","caron","emdash","","","","","","","","","","","","","","","","","AE","","ordfeminine","","","","","Lslash","Oslash","OE","ordmasculine","","","","","","ae","","","","dotlessi","","","lslash","oslash","oe","germandbls","","","",""];t.StandardEncoding=n;const s=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","bullet","Euro","bullet","quotesinglbase","florin","quotedblbase","ellipsis","dagger","daggerdbl","circumflex","perthousand","Scaron","guilsinglleft","OE","bullet","Zcaron","bullet","bullet","quoteleft","quoteright","quotedblleft","quotedblright","bullet","endash","emdash","tilde","trademark","scaron","guilsinglright","oe","bullet","zcaron","Ydieresis","space","exclamdown","cent","sterling","currency","yen","brokenbar","section","dieresis","copyright","ordfeminine","guillemotleft","logicalnot","hyphen","registered","macron","degree","plusminus","twosuperior","threesuperior","acute","mu","paragraph","periodcentered","cedilla","onesuperior","ordmasculine","guillemotright","onequarter","onehalf","threequarters","questiondown","Agrave","Aacute","Acircumflex","Atilde","Adieresis","Aring","AE","Ccedilla","Egrave","Eacute","Ecircumflex","Edieresis","Igrave","Iacute","Icircumflex","Idieresis","Eth","Ntilde","Ograve","Oacute","Ocircumflex","Otilde","Odieresis","multiply","Oslash","Ugrave","Uacute","Ucircumflex","Udieresis","Yacute","Thorn","germandbls","agrave","aacute","acircumflex","atilde","adieresis","aring","ae","ccedilla","egrave","eacute","ecircumflex","edieresis","igrave","iacute","icircumflex","idieresis","eth","ntilde","ograve","oacute","ocircumflex","otilde","odieresis","divide","oslash","ugrave","uacute","ucircumflex","udieresis","yacute","thorn","ydieresis"];t.WinAnsiEncoding=s;const o=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","universal","numbersign","existential","percent","ampersand","suchthat","parenleft","parenright","asteriskmath","plus","comma","minus","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","congruent","Alpha","Beta","Chi","Delta","Epsilon","Phi","Gamma","Eta","Iota","theta1","Kappa","Lambda","Mu","Nu","Omicron","Pi","Theta","Rho","Sigma","Tau","Upsilon","sigma1","Omega","Xi","Psi","Zeta","bracketleft","therefore","bracketright","perpendicular","underscore","radicalex","alpha","beta","chi","delta","epsilon","phi","gamma","eta","iota","phi1","kappa","lambda","mu","nu","omicron","pi","theta","rho","sigma","tau","upsilon","omega1","omega","xi","psi","zeta","braceleft","bar","braceright","similar","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","Euro","Upsilon1","minute","lessequal","fraction","infinity","florin","club","diamond","heart","spade","arrowboth","arrowleft","arrowup","arrowright","arrowdown","degree","plusminus","second","greaterequal","multiply","proportional","partialdiff","bullet","divide","notequal","equivalence","approxequal","ellipsis","arrowvertex","arrowhorizex","carriagereturn","aleph","Ifraktur","Rfraktur","weierstrass","circlemultiply","circleplus","emptyset","intersection","union","propersuperset","reflexsuperset","notsubset","propersubset","reflexsubset","element","notelement","angle","gradient","registerserif","copyrightserif","trademarkserif","product","radical","dotmath","logicalnot","logicaland","logicalor","arrowdblboth","arrowdblleft","arrowdblup","arrowdblright","arrowdbldown","lozenge","angleleft","registersans","copyrightsans","trademarksans","summation","parenlefttp","parenleftex","parenleftbt","bracketlefttp","bracketleftex","bracketleftbt","bracelefttp","braceleftmid","braceleftbt","braceex","","angleright","integral","integraltp","integralex","integralbt","parenrighttp","parenrightex","parenrightbt","bracketrighttp","bracketrightex","bracketrightbt","bracerighttp","bracerightmid","bracerightbt",""];t.SymbolSetEncoding=o;const c=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","a1","a2","a202","a3","a4","a5","a119","a118","a117","a11","a12","a13","a14","a15","a16","a105","a17","a18","a19","a20","a21","a22","a23","a24","a25","a26","a27","a28","a6","a7","a8","a9","a10","a29","a30","a31","a32","a33","a34","a35","a36","a37","a38","a39","a40","a41","a42","a43","a44","a45","a46","a47","a48","a49","a50","a51","a52","a53","a54","a55","a56","a57","a58","a59","a60","a61","a62","a63","a64","a65","a66","a67","a68","a69","a70","a71","a72","a73","a74","a203","a75","a204","a76","a77","a78","a79","a81","a82","a83","a84","a97","a98","a99","a100","","a89","a90","a93","a94","a91","a92","a205","a85","a206","a86","a87","a88","a95","a96","","","","","","","","","","","","","","","","","","","","a101","a102","a103","a104","a106","a107","a108","a112","a111","a110","a109","a120","a121","a122","a123","a124","a125","a126","a127","a128","a129","a130","a131","a132","a133","a134","a135","a136","a137","a138","a139","a140","a141","a142","a143","a144","a145","a146","a147","a148","a149","a150","a151","a152","a153","a154","a155","a156","a157","a158","a159","a160","a161","a163","a164","a196","a165","a192","a166","a167","a168","a169","a170","a171","a172","a173","a162","a174","a175","a176","a177","a178","a179","a193","a180","a199","a181","a200","a182","","a201","a183","a184","a197","a185","a194","a198","a186","a195","a187","a188","a189","a190","a191",""];t.ZapfDingbatsEncoding=c},(e,t,r)=>{r.r(t);r.d(t,{getDingbatsGlyphsUnicode:()=>n,getGlyphsUnicode:()=>i});var a=r(8);const i=(0,a.getArrayLookupTableFactory)((function(){return["A",65,"AE",198,"AEacute",508,"AEmacron",482,"AEsmall",63462,"Aacute",193,"Aacutesmall",63457,"Abreve",258,"Abreveacute",7854,"Abrevecyrillic",1232,"Abrevedotbelow",7862,"Abrevegrave",7856,"Abrevehookabove",7858,"Abrevetilde",7860,"Acaron",461,"Acircle",9398,"Acircumflex",194,"Acircumflexacute",7844,"Acircumflexdotbelow",7852,"Acircumflexgrave",7846,"Acircumflexhookabove",7848,"Acircumflexsmall",63458,"Acircumflextilde",7850,"Acute",63177,"Acutesmall",63412,"Acyrillic",1040,"Adblgrave",512,"Adieresis",196,"Adieresiscyrillic",1234,"Adieresismacron",478,"Adieresissmall",63460,"Adotbelow",7840,"Adotmacron",480,"Agrave",192,"Agravesmall",63456,"Ahookabove",7842,"Aiecyrillic",1236,"Ainvertedbreve",514,"Alpha",913,"Alphatonos",902,"Amacron",256,"Amonospace",65313,"Aogonek",260,"Aring",197,"Aringacute",506,"Aringbelow",7680,"Aringsmall",63461,"Asmall",63329,"Atilde",195,"Atildesmall",63459,"Aybarmenian",1329,"B",66,"Bcircle",9399,"Bdotaccent",7682,"Bdotbelow",7684,"Becyrillic",1041,"Benarmenian",1330,"Beta",914,"Bhook",385,"Blinebelow",7686,"Bmonospace",65314,"Brevesmall",63220,"Bsmall",63330,"Btopbar",386,"C",67,"Caarmenian",1342,"Cacute",262,"Caron",63178,"Caronsmall",63221,"Ccaron",268,"Ccedilla",199,"Ccedillaacute",7688,"Ccedillasmall",63463,"Ccircle",9400,"Ccircumflex",264,"Cdot",266,"Cdotaccent",266,"Cedillasmall",63416,"Chaarmenian",1353,"Cheabkhasiancyrillic",1212,"Checyrillic",1063,"Chedescenderabkhasiancyrillic",1214,"Chedescendercyrillic",1206,"Chedieresiscyrillic",1268,"Cheharmenian",1347,"Chekhakassiancyrillic",1227,"Cheverticalstrokecyrillic",1208,"Chi",935,"Chook",391,"Circumflexsmall",63222,"Cmonospace",65315,"Coarmenian",1361,"Csmall",63331,"D",68,"DZ",497,"DZcaron",452,"Daarmenian",1332,"Dafrican",393,"Dcaron",270,"Dcedilla",7696,"Dcircle",9401,"Dcircumflexbelow",7698,"Dcroat",272,"Ddotaccent",7690,"Ddotbelow",7692,"Decyrillic",1044,"Deicoptic",1006,"Delta",8710,"Deltagreek",916,"Dhook",394,"Dieresis",63179,"DieresisAcute",63180,"DieresisGrave",63181,"Dieresissmall",63400,"Digammagreek",988,"Djecyrillic",1026,"Dlinebelow",7694,"Dmonospace",65316,"Dotaccentsmall",63223,"Dslash",272,"Dsmall",63332,"Dtopbar",395,"Dz",498,"Dzcaron",453,"Dzeabkhasiancyrillic",1248,"Dzecyrillic",1029,"Dzhecyrillic",1039,"E",69,"Eacute",201,"Eacutesmall",63465,"Ebreve",276,"Ecaron",282,"Ecedillabreve",7708,"Echarmenian",1333,"Ecircle",9402,"Ecircumflex",202,"Ecircumflexacute",7870,"Ecircumflexbelow",7704,"Ecircumflexdotbelow",7878,"Ecircumflexgrave",7872,"Ecircumflexhookabove",7874,"Ecircumflexsmall",63466,"Ecircumflextilde",7876,"Ecyrillic",1028,"Edblgrave",516,"Edieresis",203,"Edieresissmall",63467,"Edot",278,"Edotaccent",278,"Edotbelow",7864,"Efcyrillic",1060,"Egrave",200,"Egravesmall",63464,"Eharmenian",1335,"Ehookabove",7866,"Eightroman",8551,"Einvertedbreve",518,"Eiotifiedcyrillic",1124,"Elcyrillic",1051,"Elevenroman",8554,"Emacron",274,"Emacronacute",7702,"Emacrongrave",7700,"Emcyrillic",1052,"Emonospace",65317,"Encyrillic",1053,"Endescendercyrillic",1186,"Eng",330,"Enghecyrillic",1188,"Enhookcyrillic",1223,"Eogonek",280,"Eopen",400,"Epsilon",917,"Epsilontonos",904,"Ercyrillic",1056,"Ereversed",398,"Ereversedcyrillic",1069,"Escyrillic",1057,"Esdescendercyrillic",1194,"Esh",425,"Esmall",63333,"Eta",919,"Etarmenian",1336,"Etatonos",905,"Eth",208,"Ethsmall",63472,"Etilde",7868,"Etildebelow",7706,"Euro",8364,"Ezh",439,"Ezhcaron",494,"Ezhreversed",440,"F",70,"Fcircle",9403,"Fdotaccent",7710,"Feharmenian",1366,"Feicoptic",996,"Fhook",401,"Fitacyrillic",1138,"Fiveroman",8548,"Fmonospace",65318,"Fourroman",8547,"Fsmall",63334,"G",71,"GBsquare",13191,"Gacute",500,"Gamma",915,"Gammaafrican",404,"Gangiacoptic",1002,"Gbreve",286,"Gcaron",486,"Gcedilla",290,"Gcircle",9404,"Gcircumflex",284,"Gcommaaccent",290,"Gdot",288,"Gdotaccent",288,"Gecyrillic",1043,"Ghadarmenian",1346,"Ghemiddlehookcyrillic",1172,"Ghestrokecyrillic",1170,"Gheupturncyrillic",1168,"Ghook",403,"Gimarmenian",1331,"Gjecyrillic",1027,"Gmacron",7712,"Gmonospace",65319,"Grave",63182,"Gravesmall",63328,"Gsmall",63335,"Gsmallhook",667,"Gstroke",484,"H",72,"H18533",9679,"H18543",9642,"H18551",9643,"H22073",9633,"HPsquare",13259,"Haabkhasiancyrillic",1192,"Hadescendercyrillic",1202,"Hardsigncyrillic",1066,"Hbar",294,"Hbrevebelow",7722,"Hcedilla",7720,"Hcircle",9405,"Hcircumflex",292,"Hdieresis",7718,"Hdotaccent",7714,"Hdotbelow",7716,"Hmonospace",65320,"Hoarmenian",1344,"Horicoptic",1e3,"Hsmall",63336,"Hungarumlaut",63183,"Hungarumlautsmall",63224,"Hzsquare",13200,"I",73,"IAcyrillic",1071,"IJ",306,"IUcyrillic",1070,"Iacute",205,"Iacutesmall",63469,"Ibreve",300,"Icaron",463,"Icircle",9406,"Icircumflex",206,"Icircumflexsmall",63470,"Icyrillic",1030,"Idblgrave",520,"Idieresis",207,"Idieresisacute",7726,"Idieresiscyrillic",1252,"Idieresissmall",63471,"Idot",304,"Idotaccent",304,"Idotbelow",7882,"Iebrevecyrillic",1238,"Iecyrillic",1045,"Ifraktur",8465,"Igrave",204,"Igravesmall",63468,"Ihookabove",7880,"Iicyrillic",1048,"Iinvertedbreve",522,"Iishortcyrillic",1049,"Imacron",298,"Imacroncyrillic",1250,"Imonospace",65321,"Iniarmenian",1339,"Iocyrillic",1025,"Iogonek",302,"Iota",921,"Iotaafrican",406,"Iotadieresis",938,"Iotatonos",906,"Ismall",63337,"Istroke",407,"Itilde",296,"Itildebelow",7724,"Izhitsacyrillic",1140,"Izhitsadblgravecyrillic",1142,"J",74,"Jaarmenian",1345,"Jcircle",9407,"Jcircumflex",308,"Jecyrillic",1032,"Jheharmenian",1355,"Jmonospace",65322,"Jsmall",63338,"K",75,"KBsquare",13189,"KKsquare",13261,"Kabashkircyrillic",1184,"Kacute",7728,"Kacyrillic",1050,"Kadescendercyrillic",1178,"Kahookcyrillic",1219,"Kappa",922,"Kastrokecyrillic",1182,"Kaverticalstrokecyrillic",1180,"Kcaron",488,"Kcedilla",310,"Kcircle",9408,"Kcommaaccent",310,"Kdotbelow",7730,"Keharmenian",1364,"Kenarmenian",1343,"Khacyrillic",1061,"Kheicoptic",998,"Khook",408,"Kjecyrillic",1036,"Klinebelow",7732,"Kmonospace",65323,"Koppacyrillic",1152,"Koppagreek",990,"Ksicyrillic",1134,"Ksmall",63339,"L",76,"LJ",455,"LL",63167,"Lacute",313,"Lambda",923,"Lcaron",317,"Lcedilla",315,"Lcircle",9409,"Lcircumflexbelow",7740,"Lcommaaccent",315,"Ldot",319,"Ldotaccent",319,"Ldotbelow",7734,"Ldotbelowmacron",7736,"Liwnarmenian",1340,"Lj",456,"Ljecyrillic",1033,"Llinebelow",7738,"Lmonospace",65324,"Lslash",321,"Lslashsmall",63225,"Lsmall",63340,"M",77,"MBsquare",13190,"Macron",63184,"Macronsmall",63407,"Macute",7742,"Mcircle",9410,"Mdotaccent",7744,"Mdotbelow",7746,"Menarmenian",1348,"Mmonospace",65325,"Msmall",63341,"Mturned",412,"Mu",924,"N",78,"NJ",458,"Nacute",323,"Ncaron",327,"Ncedilla",325,"Ncircle",9411,"Ncircumflexbelow",7754,"Ncommaaccent",325,"Ndotaccent",7748,"Ndotbelow",7750,"Nhookleft",413,"Nineroman",8552,"Nj",459,"Njecyrillic",1034,"Nlinebelow",7752,"Nmonospace",65326,"Nowarmenian",1350,"Nsmall",63342,"Ntilde",209,"Ntildesmall",63473,"Nu",925,"O",79,"OE",338,"OEsmall",63226,"Oacute",211,"Oacutesmall",63475,"Obarredcyrillic",1256,"Obarreddieresiscyrillic",1258,"Obreve",334,"Ocaron",465,"Ocenteredtilde",415,"Ocircle",9412,"Ocircumflex",212,"Ocircumflexacute",7888,"Ocircumflexdotbelow",7896,"Ocircumflexgrave",7890,"Ocircumflexhookabove",7892,"Ocircumflexsmall",63476,"Ocircumflextilde",7894,"Ocyrillic",1054,"Odblacute",336,"Odblgrave",524,"Odieresis",214,"Odieresiscyrillic",1254,"Odieresissmall",63478,"Odotbelow",7884,"Ogoneksmall",63227,"Ograve",210,"Ogravesmall",63474,"Oharmenian",1365,"Ohm",8486,"Ohookabove",7886,"Ohorn",416,"Ohornacute",7898,"Ohorndotbelow",7906,"Ohorngrave",7900,"Ohornhookabove",7902,"Ohorntilde",7904,"Ohungarumlaut",336,"Oi",418,"Oinvertedbreve",526,"Omacron",332,"Omacronacute",7762,"Omacrongrave",7760,"Omega",8486,"Omegacyrillic",1120,"Omegagreek",937,"Omegaroundcyrillic",1146,"Omegatitlocyrillic",1148,"Omegatonos",911,"Omicron",927,"Omicrontonos",908,"Omonospace",65327,"Oneroman",8544,"Oogonek",490,"Oogonekmacron",492,"Oopen",390,"Oslash",216,"Oslashacute",510,"Oslashsmall",63480,"Osmall",63343,"Ostrokeacute",510,"Otcyrillic",1150,"Otilde",213,"Otildeacute",7756,"Otildedieresis",7758,"Otildesmall",63477,"P",80,"Pacute",7764,"Pcircle",9413,"Pdotaccent",7766,"Pecyrillic",1055,"Peharmenian",1354,"Pemiddlehookcyrillic",1190,"Phi",934,"Phook",420,"Pi",928,"Piwrarmenian",1363,"Pmonospace",65328,"Psi",936,"Psicyrillic",1136,"Psmall",63344,"Q",81,"Qcircle",9414,"Qmonospace",65329,"Qsmall",63345,"R",82,"Raarmenian",1356,"Racute",340,"Rcaron",344,"Rcedilla",342,"Rcircle",9415,"Rcommaaccent",342,"Rdblgrave",528,"Rdotaccent",7768,"Rdotbelow",7770,"Rdotbelowmacron",7772,"Reharmenian",1360,"Rfraktur",8476,"Rho",929,"Ringsmall",63228,"Rinvertedbreve",530,"Rlinebelow",7774,"Rmonospace",65330,"Rsmall",63346,"Rsmallinverted",641,"Rsmallinvertedsuperior",694,"S",83,"SF010000",9484,"SF020000",9492,"SF030000",9488,"SF040000",9496,"SF050000",9532,"SF060000",9516,"SF070000",9524,"SF080000",9500,"SF090000",9508,"SF100000",9472,"SF110000",9474,"SF190000",9569,"SF200000",9570,"SF210000",9558,"SF220000",9557,"SF230000",9571,"SF240000",9553,"SF250000",9559,"SF260000",9565,"SF270000",9564,"SF280000",9563,"SF360000",9566,"SF370000",9567,"SF380000",9562,"SF390000",9556,"SF400000",9577,"SF410000",9574,"SF420000",9568,"SF430000",9552,"SF440000",9580,"SF450000",9575,"SF460000",9576,"SF470000",9572,"SF480000",9573,"SF490000",9561,"SF500000",9560,"SF510000",9554,"SF520000",9555,"SF530000",9579,"SF540000",9578,"Sacute",346,"Sacutedotaccent",7780,"Sampigreek",992,"Scaron",352,"Scarondotaccent",7782,"Scaronsmall",63229,"Scedilla",350,"Schwa",399,"Schwacyrillic",1240,"Schwadieresiscyrillic",1242,"Scircle",9416,"Scircumflex",348,"Scommaaccent",536,"Sdotaccent",7776,"Sdotbelow",7778,"Sdotbelowdotaccent",7784,"Seharmenian",1357,"Sevenroman",8550,"Shaarmenian",1351,"Shacyrillic",1064,"Shchacyrillic",1065,"Sheicoptic",994,"Shhacyrillic",1210,"Shimacoptic",1004,"Sigma",931,"Sixroman",8549,"Smonospace",65331,"Softsigncyrillic",1068,"Ssmall",63347,"Stigmagreek",986,"T",84,"Tau",932,"Tbar",358,"Tcaron",356,"Tcedilla",354,"Tcircle",9417,"Tcircumflexbelow",7792,"Tcommaaccent",354,"Tdotaccent",7786,"Tdotbelow",7788,"Tecyrillic",1058,"Tedescendercyrillic",1196,"Tenroman",8553,"Tetsecyrillic",1204,"Theta",920,"Thook",428,"Thorn",222,"Thornsmall",63486,"Threeroman",8546,"Tildesmall",63230,"Tiwnarmenian",1359,"Tlinebelow",7790,"Tmonospace",65332,"Toarmenian",1337,"Tonefive",444,"Tonesix",388,"Tonetwo",423,"Tretroflexhook",430,"Tsecyrillic",1062,"Tshecyrillic",1035,"Tsmall",63348,"Twelveroman",8555,"Tworoman",8545,"U",85,"Uacute",218,"Uacutesmall",63482,"Ubreve",364,"Ucaron",467,"Ucircle",9418,"Ucircumflex",219,"Ucircumflexbelow",7798,"Ucircumflexsmall",63483,"Ucyrillic",1059,"Udblacute",368,"Udblgrave",532,"Udieresis",220,"Udieresisacute",471,"Udieresisbelow",7794,"Udieresiscaron",473,"Udieresiscyrillic",1264,"Udieresisgrave",475,"Udieresismacron",469,"Udieresissmall",63484,"Udotbelow",7908,"Ugrave",217,"Ugravesmall",63481,"Uhookabove",7910,"Uhorn",431,"Uhornacute",7912,"Uhorndotbelow",7920,"Uhorngrave",7914,"Uhornhookabove",7916,"Uhorntilde",7918,"Uhungarumlaut",368,"Uhungarumlautcyrillic",1266,"Uinvertedbreve",534,"Ukcyrillic",1144,"Umacron",362,"Umacroncyrillic",1262,"Umacrondieresis",7802,"Umonospace",65333,"Uogonek",370,"Upsilon",933,"Upsilon1",978,"Upsilonacutehooksymbolgreek",979,"Upsilonafrican",433,"Upsilondieresis",939,"Upsilondieresishooksymbolgreek",980,"Upsilonhooksymbol",978,"Upsilontonos",910,"Uring",366,"Ushortcyrillic",1038,"Usmall",63349,"Ustraightcyrillic",1198,"Ustraightstrokecyrillic",1200,"Utilde",360,"Utildeacute",7800,"Utildebelow",7796,"V",86,"Vcircle",9419,"Vdotbelow",7806,"Vecyrillic",1042,"Vewarmenian",1358,"Vhook",434,"Vmonospace",65334,"Voarmenian",1352,"Vsmall",63350,"Vtilde",7804,"W",87,"Wacute",7810,"Wcircle",9420,"Wcircumflex",372,"Wdieresis",7812,"Wdotaccent",7814,"Wdotbelow",7816,"Wgrave",7808,"Wmonospace",65335,"Wsmall",63351,"X",88,"Xcircle",9421,"Xdieresis",7820,"Xdotaccent",7818,"Xeharmenian",1341,"Xi",926,"Xmonospace",65336,"Xsmall",63352,"Y",89,"Yacute",221,"Yacutesmall",63485,"Yatcyrillic",1122,"Ycircle",9422,"Ycircumflex",374,"Ydieresis",376,"Ydieresissmall",63487,"Ydotaccent",7822,"Ydotbelow",7924,"Yericyrillic",1067,"Yerudieresiscyrillic",1272,"Ygrave",7922,"Yhook",435,"Yhookabove",7926,"Yiarmenian",1349,"Yicyrillic",1031,"Yiwnarmenian",1362,"Ymonospace",65337,"Ysmall",63353,"Ytilde",7928,"Yusbigcyrillic",1130,"Yusbigiotifiedcyrillic",1132,"Yuslittlecyrillic",1126,"Yuslittleiotifiedcyrillic",1128,"Z",90,"Zaarmenian",1334,"Zacute",377,"Zcaron",381,"Zcaronsmall",63231,"Zcircle",9423,"Zcircumflex",7824,"Zdot",379,"Zdotaccent",379,"Zdotbelow",7826,"Zecyrillic",1047,"Zedescendercyrillic",1176,"Zedieresiscyrillic",1246,"Zeta",918,"Zhearmenian",1338,"Zhebrevecyrillic",1217,"Zhecyrillic",1046,"Zhedescendercyrillic",1174,"Zhedieresiscyrillic",1244,"Zlinebelow",7828,"Zmonospace",65338,"Zsmall",63354,"Zstroke",437,"a",97,"aabengali",2438,"aacute",225,"aadeva",2310,"aagujarati",2694,"aagurmukhi",2566,"aamatragurmukhi",2622,"aarusquare",13059,"aavowelsignbengali",2494,"aavowelsigndeva",2366,"aavowelsigngujarati",2750,"abbreviationmarkarmenian",1375,"abbreviationsigndeva",2416,"abengali",2437,"abopomofo",12570,"abreve",259,"abreveacute",7855,"abrevecyrillic",1233,"abrevedotbelow",7863,"abrevegrave",7857,"abrevehookabove",7859,"abrevetilde",7861,"acaron",462,"acircle",9424,"acircumflex",226,"acircumflexacute",7845,"acircumflexdotbelow",7853,"acircumflexgrave",7847,"acircumflexhookabove",7849,"acircumflextilde",7851,"acute",180,"acutebelowcmb",791,"acutecmb",769,"acutecomb",769,"acutedeva",2388,"acutelowmod",719,"acutetonecmb",833,"acyrillic",1072,"adblgrave",513,"addakgurmukhi",2673,"adeva",2309,"adieresis",228,"adieresiscyrillic",1235,"adieresismacron",479,"adotbelow",7841,"adotmacron",481,"ae",230,"aeacute",509,"aekorean",12624,"aemacron",483,"afii00208",8213,"afii08941",8356,"afii10017",1040,"afii10018",1041,"afii10019",1042,"afii10020",1043,"afii10021",1044,"afii10022",1045,"afii10023",1025,"afii10024",1046,"afii10025",1047,"afii10026",1048,"afii10027",1049,"afii10028",1050,"afii10029",1051,"afii10030",1052,"afii10031",1053,"afii10032",1054,"afii10033",1055,"afii10034",1056,"afii10035",1057,"afii10036",1058,"afii10037",1059,"afii10038",1060,"afii10039",1061,"afii10040",1062,"afii10041",1063,"afii10042",1064,"afii10043",1065,"afii10044",1066,"afii10045",1067,"afii10046",1068,"afii10047",1069,"afii10048",1070,"afii10049",1071,"afii10050",1168,"afii10051",1026,"afii10052",1027,"afii10053",1028,"afii10054",1029,"afii10055",1030,"afii10056",1031,"afii10057",1032,"afii10058",1033,"afii10059",1034,"afii10060",1035,"afii10061",1036,"afii10062",1038,"afii10063",63172,"afii10064",63173,"afii10065",1072,"afii10066",1073,"afii10067",1074,"afii10068",1075,"afii10069",1076,"afii10070",1077,"afii10071",1105,"afii10072",1078,"afii10073",1079,"afii10074",1080,"afii10075",1081,"afii10076",1082,"afii10077",1083,"afii10078",1084,"afii10079",1085,"afii10080",1086,"afii10081",1087,"afii10082",1088,"afii10083",1089,"afii10084",1090,"afii10085",1091,"afii10086",1092,"afii10087",1093,"afii10088",1094,"afii10089",1095,"afii10090",1096,"afii10091",1097,"afii10092",1098,"afii10093",1099,"afii10094",1100,"afii10095",1101,"afii10096",1102,"afii10097",1103,"afii10098",1169,"afii10099",1106,"afii10100",1107,"afii10101",1108,"afii10102",1109,"afii10103",1110,"afii10104",1111,"afii10105",1112,"afii10106",1113,"afii10107",1114,"afii10108",1115,"afii10109",1116,"afii10110",1118,"afii10145",1039,"afii10146",1122,"afii10147",1138,"afii10148",1140,"afii10192",63174,"afii10193",1119,"afii10194",1123,"afii10195",1139,"afii10196",1141,"afii10831",63175,"afii10832",63176,"afii10846",1241,"afii299",8206,"afii300",8207,"afii301",8205,"afii57381",1642,"afii57388",1548,"afii57392",1632,"afii57393",1633,"afii57394",1634,"afii57395",1635,"afii57396",1636,"afii57397",1637,"afii57398",1638,"afii57399",1639,"afii57400",1640,"afii57401",1641,"afii57403",1563,"afii57407",1567,"afii57409",1569,"afii57410",1570,"afii57411",1571,"afii57412",1572,"afii57413",1573,"afii57414",1574,"afii57415",1575,"afii57416",1576,"afii57417",1577,"afii57418",1578,"afii57419",1579,"afii57420",1580,"afii57421",1581,"afii57422",1582,"afii57423",1583,"afii57424",1584,"afii57425",1585,"afii57426",1586,"afii57427",1587,"afii57428",1588,"afii57429",1589,"afii57430",1590,"afii57431",1591,"afii57432",1592,"afii57433",1593,"afii57434",1594,"afii57440",1600,"afii57441",1601,"afii57442",1602,"afii57443",1603,"afii57444",1604,"afii57445",1605,"afii57446",1606,"afii57448",1608,"afii57449",1609,"afii57450",1610,"afii57451",1611,"afii57452",1612,"afii57453",1613,"afii57454",1614,"afii57455",1615,"afii57456",1616,"afii57457",1617,"afii57458",1618,"afii57470",1607,"afii57505",1700,"afii57506",1662,"afii57507",1670,"afii57508",1688,"afii57509",1711,"afii57511",1657,"afii57512",1672,"afii57513",1681,"afii57514",1722,"afii57519",1746,"afii57534",1749,"afii57636",8362,"afii57645",1470,"afii57658",1475,"afii57664",1488,"afii57665",1489,"afii57666",1490,"afii57667",1491,"afii57668",1492,"afii57669",1493,"afii57670",1494,"afii57671",1495,"afii57672",1496,"afii57673",1497,"afii57674",1498,"afii57675",1499,"afii57676",1500,"afii57677",1501,"afii57678",1502,"afii57679",1503,"afii57680",1504,"afii57681",1505,"afii57682",1506,"afii57683",1507,"afii57684",1508,"afii57685",1509,"afii57686",1510,"afii57687",1511,"afii57688",1512,"afii57689",1513,"afii57690",1514,"afii57694",64298,"afii57695",64299,"afii57700",64331,"afii57705",64287,"afii57716",1520,"afii57717",1521,"afii57718",1522,"afii57723",64309,"afii57793",1460,"afii57794",1461,"afii57795",1462,"afii57796",1467,"afii57797",1464,"afii57798",1463,"afii57799",1456,"afii57800",1458,"afii57801",1457,"afii57802",1459,"afii57803",1474,"afii57804",1473,"afii57806",1465,"afii57807",1468,"afii57839",1469,"afii57841",1471,"afii57842",1472,"afii57929",700,"afii61248",8453,"afii61289",8467,"afii61352",8470,"afii61573",8236,"afii61574",8237,"afii61575",8238,"afii61664",8204,"afii63167",1645,"afii64937",701,"agrave",224,"agujarati",2693,"agurmukhi",2565,"ahiragana",12354,"ahookabove",7843,"aibengali",2448,"aibopomofo",12574,"aideva",2320,"aiecyrillic",1237,"aigujarati",2704,"aigurmukhi",2576,"aimatragurmukhi",2632,"ainarabic",1593,"ainfinalarabic",65226,"aininitialarabic",65227,"ainmedialarabic",65228,"ainvertedbreve",515,"aivowelsignbengali",2504,"aivowelsigndeva",2376,"aivowelsigngujarati",2760,"akatakana",12450,"akatakanahalfwidth",65393,"akorean",12623,"alef",1488,"alefarabic",1575,"alefdageshhebrew",64304,"aleffinalarabic",65166,"alefhamzaabovearabic",1571,"alefhamzaabovefinalarabic",65156,"alefhamzabelowarabic",1573,"alefhamzabelowfinalarabic",65160,"alefhebrew",1488,"aleflamedhebrew",64335,"alefmaddaabovearabic",1570,"alefmaddaabovefinalarabic",65154,"alefmaksuraarabic",1609,"alefmaksurafinalarabic",65264,"alefmaksurainitialarabic",65267,"alefmaksuramedialarabic",65268,"alefpatahhebrew",64302,"alefqamatshebrew",64303,"aleph",8501,"allequal",8780,"alpha",945,"alphatonos",940,"amacron",257,"amonospace",65345,"ampersand",38,"ampersandmonospace",65286,"ampersandsmall",63270,"amsquare",13250,"anbopomofo",12578,"angbopomofo",12580,"angbracketleft",12296,"angbracketright",12297,"angkhankhuthai",3674,"angle",8736,"anglebracketleft",12296,"anglebracketleftvertical",65087,"anglebracketright",12297,"anglebracketrightvertical",65088,"angleleft",9001,"angleright",9002,"angstrom",8491,"anoteleia",903,"anudattadeva",2386,"anusvarabengali",2434,"anusvaradeva",2306,"anusvaragujarati",2690,"aogonek",261,"apaatosquare",13056,"aparen",9372,"apostrophearmenian",1370,"apostrophemod",700,"apple",63743,"approaches",8784,"approxequal",8776,"approxequalorimage",8786,"approximatelyequal",8773,"araeaekorean",12686,"araeakorean",12685,"arc",8978,"arighthalfring",7834,"aring",229,"aringacute",507,"aringbelow",7681,"arrowboth",8596,"arrowdashdown",8675,"arrowdashleft",8672,"arrowdashright",8674,"arrowdashup",8673,"arrowdblboth",8660,"arrowdbldown",8659,"arrowdblleft",8656,"arrowdblright",8658,"arrowdblup",8657,"arrowdown",8595,"arrowdownleft",8601,"arrowdownright",8600,"arrowdownwhite",8681,"arrowheaddownmod",709,"arrowheadleftmod",706,"arrowheadrightmod",707,"arrowheadupmod",708,"arrowhorizex",63719,"arrowleft",8592,"arrowleftdbl",8656,"arrowleftdblstroke",8653,"arrowleftoverright",8646,"arrowleftwhite",8678,"arrowright",8594,"arrowrightdblstroke",8655,"arrowrightheavy",10142,"arrowrightoverleft",8644,"arrowrightwhite",8680,"arrowtableft",8676,"arrowtabright",8677,"arrowup",8593,"arrowupdn",8597,"arrowupdnbse",8616,"arrowupdownbase",8616,"arrowupleft",8598,"arrowupleftofdown",8645,"arrowupright",8599,"arrowupwhite",8679,"arrowvertex",63718,"asciicircum",94,"asciicircummonospace",65342,"asciitilde",126,"asciitildemonospace",65374,"ascript",593,"ascriptturned",594,"asmallhiragana",12353,"asmallkatakana",12449,"asmallkatakanahalfwidth",65383,"asterisk",42,"asteriskaltonearabic",1645,"asteriskarabic",1645,"asteriskmath",8727,"asteriskmonospace",65290,"asterisksmall",65121,"asterism",8258,"asuperior",63209,"asymptoticallyequal",8771,"at",64,"atilde",227,"atmonospace",65312,"atsmall",65131,"aturned",592,"aubengali",2452,"aubopomofo",12576,"audeva",2324,"augujarati",2708,"augurmukhi",2580,"aulengthmarkbengali",2519,"aumatragurmukhi",2636,"auvowelsignbengali",2508,"auvowelsigndeva",2380,"auvowelsigngujarati",2764,"avagrahadeva",2365,"aybarmenian",1377,"ayin",1506,"ayinaltonehebrew",64288,"ayinhebrew",1506,"b",98,"babengali",2476,"backslash",92,"backslashmonospace",65340,"badeva",2348,"bagujarati",2732,"bagurmukhi",2604,"bahiragana",12400,"bahtthai",3647,"bakatakana",12496,"bar",124,"barmonospace",65372,"bbopomofo",12549,"bcircle",9425,"bdotaccent",7683,"bdotbelow",7685,"beamedsixteenthnotes",9836,"because",8757,"becyrillic",1073,"beharabic",1576,"behfinalarabic",65168,"behinitialarabic",65169,"behiragana",12409,"behmedialarabic",65170,"behmeeminitialarabic",64671,"behmeemisolatedarabic",64520,"behnoonfinalarabic",64621,"bekatakana",12505,"benarmenian",1378,"bet",1489,"beta",946,"betasymbolgreek",976,"betdagesh",64305,"betdageshhebrew",64305,"bethebrew",1489,"betrafehebrew",64332,"bhabengali",2477,"bhadeva",2349,"bhagujarati",2733,"bhagurmukhi",2605,"bhook",595,"bihiragana",12403,"bikatakana",12499,"bilabialclick",664,"bindigurmukhi",2562,"birusquare",13105,"blackcircle",9679,"blackdiamond",9670,"blackdownpointingtriangle",9660,"blackleftpointingpointer",9668,"blackleftpointingtriangle",9664,"blacklenticularbracketleft",12304,"blacklenticularbracketleftvertical",65083,"blacklenticularbracketright",12305,"blacklenticularbracketrightvertical",65084,"blacklowerlefttriangle",9699,"blacklowerrighttriangle",9698,"blackrectangle",9644,"blackrightpointingpointer",9658,"blackrightpointingtriangle",9654,"blacksmallsquare",9642,"blacksmilingface",9787,"blacksquare",9632,"blackstar",9733,"blackupperlefttriangle",9700,"blackupperrighttriangle",9701,"blackuppointingsmalltriangle",9652,"blackuppointingtriangle",9650,"blank",9251,"blinebelow",7687,"block",9608,"bmonospace",65346,"bobaimaithai",3610,"bohiragana",12412,"bokatakana",12508,"bparen",9373,"bqsquare",13251,"braceex",63732,"braceleft",123,"braceleftbt",63731,"braceleftmid",63730,"braceleftmonospace",65371,"braceleftsmall",65115,"bracelefttp",63729,"braceleftvertical",65079,"braceright",125,"bracerightbt",63742,"bracerightmid",63741,"bracerightmonospace",65373,"bracerightsmall",65116,"bracerighttp",63740,"bracerightvertical",65080,"bracketleft",91,"bracketleftbt",63728,"bracketleftex",63727,"bracketleftmonospace",65339,"bracketlefttp",63726,"bracketright",93,"bracketrightbt",63739,"bracketrightex",63738,"bracketrightmonospace",65341,"bracketrighttp",63737,"breve",728,"brevebelowcmb",814,"brevecmb",774,"breveinvertedbelowcmb",815,"breveinvertedcmb",785,"breveinverteddoublecmb",865,"bridgebelowcmb",810,"bridgeinvertedbelowcmb",826,"brokenbar",166,"bstroke",384,"bsuperior",63210,"btopbar",387,"buhiragana",12406,"bukatakana",12502,"bullet",8226,"bulletinverse",9688,"bulletoperator",8729,"bullseye",9678,"c",99,"caarmenian",1390,"cabengali",2458,"cacute",263,"cadeva",2330,"cagujarati",2714,"cagurmukhi",2586,"calsquare",13192,"candrabindubengali",2433,"candrabinducmb",784,"candrabindudeva",2305,"candrabindugujarati",2689,"capslock",8682,"careof",8453,"caron",711,"caronbelowcmb",812,"caroncmb",780,"carriagereturn",8629,"cbopomofo",12568,"ccaron",269,"ccedilla",231,"ccedillaacute",7689,"ccircle",9426,"ccircumflex",265,"ccurl",597,"cdot",267,"cdotaccent",267,"cdsquare",13253,"cedilla",184,"cedillacmb",807,"cent",162,"centigrade",8451,"centinferior",63199,"centmonospace",65504,"centoldstyle",63394,"centsuperior",63200,"chaarmenian",1401,"chabengali",2459,"chadeva",2331,"chagujarati",2715,"chagurmukhi",2587,"chbopomofo",12564,"cheabkhasiancyrillic",1213,"checkmark",10003,"checyrillic",1095,"chedescenderabkhasiancyrillic",1215,"chedescendercyrillic",1207,"chedieresiscyrillic",1269,"cheharmenian",1395,"chekhakassiancyrillic",1228,"cheverticalstrokecyrillic",1209,"chi",967,"chieuchacirclekorean",12919,"chieuchaparenkorean",12823,"chieuchcirclekorean",12905,"chieuchkorean",12618,"chieuchparenkorean",12809,"chochangthai",3594,"chochanthai",3592,"chochingthai",3593,"chochoethai",3596,"chook",392,"cieucacirclekorean",12918,"cieucaparenkorean",12822,"cieuccirclekorean",12904,"cieuckorean",12616,"cieucparenkorean",12808,"cieucuparenkorean",12828,"circle",9675,"circlecopyrt",169,"circlemultiply",8855,"circleot",8857,"circleplus",8853,"circlepostalmark",12342,"circlewithlefthalfblack",9680,"circlewithrighthalfblack",9681,"circumflex",710,"circumflexbelowcmb",813,"circumflexcmb",770,"clear",8999,"clickalveolar",450,"clickdental",448,"clicklateral",449,"clickretroflex",451,"club",9827,"clubsuitblack",9827,"clubsuitwhite",9831,"cmcubedsquare",13220,"cmonospace",65347,"cmsquaredsquare",13216,"coarmenian",1409,"colon",58,"colonmonetary",8353,"colonmonospace",65306,"colonsign",8353,"colonsmall",65109,"colontriangularhalfmod",721,"colontriangularmod",720,"comma",44,"commaabovecmb",787,"commaaboverightcmb",789,"commaaccent",63171,"commaarabic",1548,"commaarmenian",1373,"commainferior",63201,"commamonospace",65292,"commareversedabovecmb",788,"commareversedmod",701,"commasmall",65104,"commasuperior",63202,"commaturnedabovecmb",786,"commaturnedmod",699,"compass",9788,"congruent",8773,"contourintegral",8750,"control",8963,"controlACK",6,"controlBEL",7,"controlBS",8,"controlCAN",24,"controlCR",13,"controlDC1",17,"controlDC2",18,"controlDC3",19,"controlDC4",20,"controlDEL",127,"controlDLE",16,"controlEM",25,"controlENQ",5,"controlEOT",4,"controlESC",27,"controlETB",23,"controlETX",3,"controlFF",12,"controlFS",28,"controlGS",29,"controlHT",9,"controlLF",10,"controlNAK",21,"controlNULL",0,"controlRS",30,"controlSI",15,"controlSO",14,"controlSOT",2,"controlSTX",1,"controlSUB",26,"controlSYN",22,"controlUS",31,"controlVT",11,"copyright",169,"copyrightsans",63721,"copyrightserif",63193,"cornerbracketleft",12300,"cornerbracketlefthalfwidth",65378,"cornerbracketleftvertical",65089,"cornerbracketright",12301,"cornerbracketrighthalfwidth",65379,"cornerbracketrightvertical",65090,"corporationsquare",13183,"cosquare",13255,"coverkgsquare",13254,"cparen",9374,"cruzeiro",8354,"cstretched",663,"curlyand",8911,"curlyor",8910,"currency",164,"cyrBreve",63185,"cyrFlex",63186,"cyrbreve",63188,"cyrflex",63189,"d",100,"daarmenian",1380,"dabengali",2470,"dadarabic",1590,"dadeva",2342,"dadfinalarabic",65214,"dadinitialarabic",65215,"dadmedialarabic",65216,"dagesh",1468,"dageshhebrew",1468,"dagger",8224,"daggerdbl",8225,"dagujarati",2726,"dagurmukhi",2598,"dahiragana",12384,"dakatakana",12480,"dalarabic",1583,"dalet",1491,"daletdagesh",64307,"daletdageshhebrew",64307,"dalethebrew",1491,"dalfinalarabic",65194,"dammaarabic",1615,"dammalowarabic",1615,"dammatanaltonearabic",1612,"dammatanarabic",1612,"danda",2404,"dargahebrew",1447,"dargalefthebrew",1447,"dasiapneumatacyrilliccmb",1157,"dblGrave",63187,"dblanglebracketleft",12298,"dblanglebracketleftvertical",65085,"dblanglebracketright",12299,"dblanglebracketrightvertical",65086,"dblarchinvertedbelowcmb",811,"dblarrowleft",8660,"dblarrowright",8658,"dbldanda",2405,"dblgrave",63190,"dblgravecmb",783,"dblintegral",8748,"dbllowline",8215,"dbllowlinecmb",819,"dbloverlinecmb",831,"dblprimemod",698,"dblverticalbar",8214,"dblverticallineabovecmb",782,"dbopomofo",12553,"dbsquare",13256,"dcaron",271,"dcedilla",7697,"dcircle",9427,"dcircumflexbelow",7699,"dcroat",273,"ddabengali",2465,"ddadeva",2337,"ddagujarati",2721,"ddagurmukhi",2593,"ddalarabic",1672,"ddalfinalarabic",64393,"dddhadeva",2396,"ddhabengali",2466,"ddhadeva",2338,"ddhagujarati",2722,"ddhagurmukhi",2594,"ddotaccent",7691,"ddotbelow",7693,"decimalseparatorarabic",1643,"decimalseparatorpersian",1643,"decyrillic",1076,"degree",176,"dehihebrew",1453,"dehiragana",12391,"deicoptic",1007,"dekatakana",12487,"deleteleft",9003,"deleteright",8998,"delta",948,"deltaturned",397,"denominatorminusonenumeratorbengali",2552,"dezh",676,"dhabengali",2471,"dhadeva",2343,"dhagujarati",2727,"dhagurmukhi",2599,"dhook",599,"dialytikatonos",901,"dialytikatonoscmb",836,"diamond",9830,"diamondsuitwhite",9826,"dieresis",168,"dieresisacute",63191,"dieresisbelowcmb",804,"dieresiscmb",776,"dieresisgrave",63192,"dieresistonos",901,"dihiragana",12386,"dikatakana",12482,"dittomark",12291,"divide",247,"divides",8739,"divisionslash",8725,"djecyrillic",1106,"dkshade",9619,"dlinebelow",7695,"dlsquare",13207,"dmacron",273,"dmonospace",65348,"dnblock",9604,"dochadathai",3598,"dodekthai",3604,"dohiragana",12393,"dokatakana",12489,"dollar",36,"dollarinferior",63203,"dollarmonospace",65284,"dollaroldstyle",63268,"dollarsmall",65129,"dollarsuperior",63204,"dong",8363,"dorusquare",13094,"dotaccent",729,"dotaccentcmb",775,"dotbelowcmb",803,"dotbelowcomb",803,"dotkatakana",12539,"dotlessi",305,"dotlessj",63166,"dotlessjstrokehook",644,"dotmath",8901,"dottedcircle",9676,"doubleyodpatah",64287,"doubleyodpatahhebrew",64287,"downtackbelowcmb",798,"downtackmod",725,"dparen",9375,"dsuperior",63211,"dtail",598,"dtopbar",396,"duhiragana",12389,"dukatakana",12485,"dz",499,"dzaltone",675,"dzcaron",454,"dzcurl",677,"dzeabkhasiancyrillic",1249,"dzecyrillic",1109,"dzhecyrillic",1119,"e",101,"eacute",233,"earth",9793,"ebengali",2447,"ebopomofo",12572,"ebreve",277,"ecandradeva",2317,"ecandragujarati",2701,"ecandravowelsigndeva",2373,"ecandravowelsigngujarati",2757,"ecaron",283,"ecedillabreve",7709,"echarmenian",1381,"echyiwnarmenian",1415,"ecircle",9428,"ecircumflex",234,"ecircumflexacute",7871,"ecircumflexbelow",7705,"ecircumflexdotbelow",7879,"ecircumflexgrave",7873,"ecircumflexhookabove",7875,"ecircumflextilde",7877,"ecyrillic",1108,"edblgrave",517,"edeva",2319,"edieresis",235,"edot",279,"edotaccent",279,"edotbelow",7865,"eegurmukhi",2575,"eematragurmukhi",2631,"efcyrillic",1092,"egrave",232,"egujarati",2703,"eharmenian",1383,"ehbopomofo",12573,"ehiragana",12360,"ehookabove",7867,"eibopomofo",12575,"eight",56,"eightarabic",1640,"eightbengali",2542,"eightcircle",9319,"eightcircleinversesansserif",10129,"eightdeva",2414,"eighteencircle",9329,"eighteenparen",9349,"eighteenperiod",9369,"eightgujarati",2798,"eightgurmukhi",2670,"eighthackarabic",1640,"eighthangzhou",12328,"eighthnotebeamed",9835,"eightideographicparen",12839,"eightinferior",8328,"eightmonospace",65304,"eightoldstyle",63288,"eightparen",9339,"eightperiod",9359,"eightpersian",1784,"eightroman",8567,"eightsuperior",8312,"eightthai",3672,"einvertedbreve",519,"eiotifiedcyrillic",1125,"ekatakana",12456,"ekatakanahalfwidth",65396,"ekonkargurmukhi",2676,"ekorean",12628,"elcyrillic",1083,"element",8712,"elevencircle",9322,"elevenparen",9342,"elevenperiod",9362,"elevenroman",8570,"ellipsis",8230,"ellipsisvertical",8942,"emacron",275,"emacronacute",7703,"emacrongrave",7701,"emcyrillic",1084,"emdash",8212,"emdashvertical",65073,"emonospace",65349,"emphasismarkarmenian",1371,"emptyset",8709,"enbopomofo",12579,"encyrillic",1085,"endash",8211,"endashvertical",65074,"endescendercyrillic",1187,"eng",331,"engbopomofo",12581,"enghecyrillic",1189,"enhookcyrillic",1224,"enspace",8194,"eogonek",281,"eokorean",12627,"eopen",603,"eopenclosed",666,"eopenreversed",604,"eopenreversedclosed",606,"eopenreversedhook",605,"eparen",9376,"epsilon",949,"epsilontonos",941,"equal",61,"equalmonospace",65309,"equalsmall",65126,"equalsuperior",8316,"equivalence",8801,"erbopomofo",12582,"ercyrillic",1088,"ereversed",600,"ereversedcyrillic",1101,"escyrillic",1089,"esdescendercyrillic",1195,"esh",643,"eshcurl",646,"eshortdeva",2318,"eshortvowelsigndeva",2374,"eshreversedloop",426,"eshsquatreversed",645,"esmallhiragana",12359,"esmallkatakana",12455,"esmallkatakanahalfwidth",65386,"estimated",8494,"esuperior",63212,"eta",951,"etarmenian",1384,"etatonos",942,"eth",240,"etilde",7869,"etildebelow",7707,"etnahtafoukhhebrew",1425,"etnahtafoukhlefthebrew",1425,"etnahtahebrew",1425,"etnahtalefthebrew",1425,"eturned",477,"eukorean",12641,"euro",8364,"evowelsignbengali",2503,"evowelsigndeva",2375,"evowelsigngujarati",2759,"exclam",33,"exclamarmenian",1372,"exclamdbl",8252,"exclamdown",161,"exclamdownsmall",63393,"exclammonospace",65281,"exclamsmall",63265,"existential",8707,"ezh",658,"ezhcaron",495,"ezhcurl",659,"ezhreversed",441,"ezhtail",442,"f",102,"fadeva",2398,"fagurmukhi",2654,"fahrenheit",8457,"fathaarabic",1614,"fathalowarabic",1614,"fathatanarabic",1611,"fbopomofo",12552,"fcircle",9429,"fdotaccent",7711,"feharabic",1601,"feharmenian",1414,"fehfinalarabic",65234,"fehinitialarabic",65235,"fehmedialarabic",65236,"feicoptic",997,"female",9792,"ff",64256,"f_f",64256,"ffi",64259,"ffl",64260,"fi",64257,"fifteencircle",9326,"fifteenparen",9346,"fifteenperiod",9366,"figuredash",8210,"filledbox",9632,"filledrect",9644,"finalkaf",1498,"finalkafdagesh",64314,"finalkafdageshhebrew",64314,"finalkafhebrew",1498,"finalmem",1501,"finalmemhebrew",1501,"finalnun",1503,"finalnunhebrew",1503,"finalpe",1507,"finalpehebrew",1507,"finaltsadi",1509,"finaltsadihebrew",1509,"firsttonechinese",713,"fisheye",9673,"fitacyrillic",1139,"five",53,"fivearabic",1637,"fivebengali",2539,"fivecircle",9316,"fivecircleinversesansserif",10126,"fivedeva",2411,"fiveeighths",8541,"fivegujarati",2795,"fivegurmukhi",2667,"fivehackarabic",1637,"fivehangzhou",12325,"fiveideographicparen",12836,"fiveinferior",8325,"fivemonospace",65301,"fiveoldstyle",63285,"fiveparen",9336,"fiveperiod",9356,"fivepersian",1781,"fiveroman",8564,"fivesuperior",8309,"fivethai",3669,"fl",64258,"florin",402,"fmonospace",65350,"fmsquare",13209,"fofanthai",3615,"fofathai",3613,"fongmanthai",3663,"forall",8704,"four",52,"fourarabic",1636,"fourbengali",2538,"fourcircle",9315,"fourcircleinversesansserif",10125,"fourdeva",2410,"fourgujarati",2794,"fourgurmukhi",2666,"fourhackarabic",1636,"fourhangzhou",12324,"fourideographicparen",12835,"fourinferior",8324,"fourmonospace",65300,"fournumeratorbengali",2551,"fouroldstyle",63284,"fourparen",9335,"fourperiod",9355,"fourpersian",1780,"fourroman",8563,"foursuperior",8308,"fourteencircle",9325,"fourteenparen",9345,"fourteenperiod",9365,"fourthai",3668,"fourthtonechinese",715,"fparen",9377,"fraction",8260,"franc",8355,"g",103,"gabengali",2455,"gacute",501,"gadeva",2327,"gafarabic",1711,"gaffinalarabic",64403,"gafinitialarabic",64404,"gafmedialarabic",64405,"gagujarati",2711,"gagurmukhi",2583,"gahiragana",12364,"gakatakana",12460,"gamma",947,"gammalatinsmall",611,"gammasuperior",736,"gangiacoptic",1003,"gbopomofo",12557,"gbreve",287,"gcaron",487,"gcedilla",291,"gcircle",9430,"gcircumflex",285,"gcommaaccent",291,"gdot",289,"gdotaccent",289,"gecyrillic",1075,"gehiragana",12370,"gekatakana",12466,"geometricallyequal",8785,"gereshaccenthebrew",1436,"gereshhebrew",1523,"gereshmuqdamhebrew",1437,"germandbls",223,"gershayimaccenthebrew",1438,"gershayimhebrew",1524,"getamark",12307,"ghabengali",2456,"ghadarmenian",1394,"ghadeva",2328,"ghagujarati",2712,"ghagurmukhi",2584,"ghainarabic",1594,"ghainfinalarabic",65230,"ghaininitialarabic",65231,"ghainmedialarabic",65232,"ghemiddlehookcyrillic",1173,"ghestrokecyrillic",1171,"gheupturncyrillic",1169,"ghhadeva",2394,"ghhagurmukhi",2650,"ghook",608,"ghzsquare",13203,"gihiragana",12366,"gikatakana",12462,"gimarmenian",1379,"gimel",1490,"gimeldagesh",64306,"gimeldageshhebrew",64306,"gimelhebrew",1490,"gjecyrillic",1107,"glottalinvertedstroke",446,"glottalstop",660,"glottalstopinverted",662,"glottalstopmod",704,"glottalstopreversed",661,"glottalstopreversedmod",705,"glottalstopreversedsuperior",740,"glottalstopstroke",673,"glottalstopstrokereversed",674,"gmacron",7713,"gmonospace",65351,"gohiragana",12372,"gokatakana",12468,"gparen",9378,"gpasquare",13228,"gradient",8711,"grave",96,"gravebelowcmb",790,"gravecmb",768,"gravecomb",768,"gravedeva",2387,"gravelowmod",718,"gravemonospace",65344,"gravetonecmb",832,"greater",62,"greaterequal",8805,"greaterequalorless",8923,"greatermonospace",65310,"greaterorequivalent",8819,"greaterorless",8823,"greateroverequal",8807,"greatersmall",65125,"gscript",609,"gstroke",485,"guhiragana",12368,"guillemotleft",171,"guillemotright",187,"guilsinglleft",8249,"guilsinglright",8250,"gukatakana",12464,"guramusquare",13080,"gysquare",13257,"h",104,"haabkhasiancyrillic",1193,"haaltonearabic",1729,"habengali",2489,"hadescendercyrillic",1203,"hadeva",2361,"hagujarati",2745,"hagurmukhi",2617,"haharabic",1581,"hahfinalarabic",65186,"hahinitialarabic",65187,"hahiragana",12399,"hahmedialarabic",65188,"haitusquare",13098,"hakatakana",12495,"hakatakanahalfwidth",65418,"halantgurmukhi",2637,"hamzaarabic",1569,"hamzalowarabic",1569,"hangulfiller",12644,"hardsigncyrillic",1098,"harpoonleftbarbup",8636,"harpoonrightbarbup",8640,"hasquare",13258,"hatafpatah",1458,"hatafpatah16",1458,"hatafpatah23",1458,"hatafpatah2f",1458,"hatafpatahhebrew",1458,"hatafpatahnarrowhebrew",1458,"hatafpatahquarterhebrew",1458,"hatafpatahwidehebrew",1458,"hatafqamats",1459,"hatafqamats1b",1459,"hatafqamats28",1459,"hatafqamats34",1459,"hatafqamatshebrew",1459,"hatafqamatsnarrowhebrew",1459,"hatafqamatsquarterhebrew",1459,"hatafqamatswidehebrew",1459,"hatafsegol",1457,"hatafsegol17",1457,"hatafsegol24",1457,"hatafsegol30",1457,"hatafsegolhebrew",1457,"hatafsegolnarrowhebrew",1457,"hatafsegolquarterhebrew",1457,"hatafsegolwidehebrew",1457,"hbar",295,"hbopomofo",12559,"hbrevebelow",7723,"hcedilla",7721,"hcircle",9431,"hcircumflex",293,"hdieresis",7719,"hdotaccent",7715,"hdotbelow",7717,"he",1492,"heart",9829,"heartsuitblack",9829,"heartsuitwhite",9825,"hedagesh",64308,"hedageshhebrew",64308,"hehaltonearabic",1729,"heharabic",1607,"hehebrew",1492,"hehfinalaltonearabic",64423,"hehfinalalttwoarabic",65258,"hehfinalarabic",65258,"hehhamzaabovefinalarabic",64421,"hehhamzaaboveisolatedarabic",64420,"hehinitialaltonearabic",64424,"hehinitialarabic",65259,"hehiragana",12408,"hehmedialaltonearabic",64425,"hehmedialarabic",65260,"heiseierasquare",13179,"hekatakana",12504,"hekatakanahalfwidth",65421,"hekutaarusquare",13110,"henghook",615,"herutusquare",13113,"het",1495,"hethebrew",1495,"hhook",614,"hhooksuperior",689,"hieuhacirclekorean",12923,"hieuhaparenkorean",12827,"hieuhcirclekorean",12909,"hieuhkorean",12622,"hieuhparenkorean",12813,"hihiragana",12402,"hikatakana",12498,"hikatakanahalfwidth",65419,"hiriq",1460,"hiriq14",1460,"hiriq21",1460,"hiriq2d",1460,"hiriqhebrew",1460,"hiriqnarrowhebrew",1460,"hiriqquarterhebrew",1460,"hiriqwidehebrew",1460,"hlinebelow",7830,"hmonospace",65352,"hoarmenian",1392,"hohipthai",3627,"hohiragana",12411,"hokatakana",12507,"hokatakanahalfwidth",65422,"holam",1465,"holam19",1465,"holam26",1465,"holam32",1465,"holamhebrew",1465,"holamnarrowhebrew",1465,"holamquarterhebrew",1465,"holamwidehebrew",1465,"honokhukthai",3630,"hookabovecomb",777,"hookcmb",777,"hookpalatalizedbelowcmb",801,"hookretroflexbelowcmb",802,"hoonsquare",13122,"horicoptic",1001,"horizontalbar",8213,"horncmb",795,"hotsprings",9832,"house",8962,"hparen",9379,"hsuperior",688,"hturned",613,"huhiragana",12405,"huiitosquare",13107,"hukatakana",12501,"hukatakanahalfwidth",65420,"hungarumlaut",733,"hungarumlautcmb",779,"hv",405,"hyphen",45,"hypheninferior",63205,"hyphenmonospace",65293,"hyphensmall",65123,"hyphensuperior",63206,"hyphentwo",8208,"i",105,"iacute",237,"iacyrillic",1103,"ibengali",2439,"ibopomofo",12583,"ibreve",301,"icaron",464,"icircle",9432,"icircumflex",238,"icyrillic",1110,"idblgrave",521,"ideographearthcircle",12943,"ideographfirecircle",12939,"ideographicallianceparen",12863,"ideographiccallparen",12858,"ideographiccentrecircle",12965,"ideographicclose",12294,"ideographiccomma",12289,"ideographiccommaleft",65380,"ideographiccongratulationparen",12855,"ideographiccorrectcircle",12963,"ideographicearthparen",12847,"ideographicenterpriseparen",12861,"ideographicexcellentcircle",12957,"ideographicfestivalparen",12864,"ideographicfinancialcircle",12950,"ideographicfinancialparen",12854,"ideographicfireparen",12843,"ideographichaveparen",12850,"ideographichighcircle",12964,"ideographiciterationmark",12293,"ideographiclaborcircle",12952,"ideographiclaborparen",12856,"ideographicleftcircle",12967,"ideographiclowcircle",12966,"ideographicmedicinecircle",12969,"ideographicmetalparen",12846,"ideographicmoonparen",12842,"ideographicnameparen",12852,"ideographicperiod",12290,"ideographicprintcircle",12958,"ideographicreachparen",12867,"ideographicrepresentparen",12857,"ideographicresourceparen",12862,"ideographicrightcircle",12968,"ideographicsecretcircle",12953,"ideographicselfparen",12866,"ideographicsocietyparen",12851,"ideographicspace",12288,"ideographicspecialparen",12853,"ideographicstockparen",12849,"ideographicstudyparen",12859,"ideographicsunparen",12848,"ideographicsuperviseparen",12860,"ideographicwaterparen",12844,"ideographicwoodparen",12845,"ideographiczero",12295,"ideographmetalcircle",12942,"ideographmooncircle",12938,"ideographnamecircle",12948,"ideographsuncircle",12944,"ideographwatercircle",12940,"ideographwoodcircle",12941,"ideva",2311,"idieresis",239,"idieresisacute",7727,"idieresiscyrillic",1253,"idotbelow",7883,"iebrevecyrillic",1239,"iecyrillic",1077,"ieungacirclekorean",12917,"ieungaparenkorean",12821,"ieungcirclekorean",12903,"ieungkorean",12615,"ieungparenkorean",12807,"igrave",236,"igujarati",2695,"igurmukhi",2567,"ihiragana",12356,"ihookabove",7881,"iibengali",2440,"iicyrillic",1080,"iideva",2312,"iigujarati",2696,"iigurmukhi",2568,"iimatragurmukhi",2624,"iinvertedbreve",523,"iishortcyrillic",1081,"iivowelsignbengali",2496,"iivowelsigndeva",2368,"iivowelsigngujarati",2752,"ij",307,"ikatakana",12452,"ikatakanahalfwidth",65394,"ikorean",12643,"ilde",732,"iluyhebrew",1452,"imacron",299,"imacroncyrillic",1251,"imageorapproximatelyequal",8787,"imatragurmukhi",2623,"imonospace",65353,"increment",8710,"infinity",8734,"iniarmenian",1387,"integral",8747,"integralbottom",8993,"integralbt",8993,"integralex",63733,"integraltop",8992,"integraltp",8992,"intersection",8745,"intisquare",13061,"invbullet",9688,"invcircle",9689,"invsmileface",9787,"iocyrillic",1105,"iogonek",303,"iota",953,"iotadieresis",970,"iotadieresistonos",912,"iotalatin",617,"iotatonos",943,"iparen",9380,"irigurmukhi",2674,"ismallhiragana",12355,"ismallkatakana",12451,"ismallkatakanahalfwidth",65384,"issharbengali",2554,"istroke",616,"isuperior",63213,"iterationhiragana",12445,"iterationkatakana",12541,"itilde",297,"itildebelow",7725,"iubopomofo",12585,"iucyrillic",1102,"ivowelsignbengali",2495,"ivowelsigndeva",2367,"ivowelsigngujarati",2751,"izhitsacyrillic",1141,"izhitsadblgravecyrillic",1143,"j",106,"jaarmenian",1393,"jabengali",2460,"jadeva",2332,"jagujarati",2716,"jagurmukhi",2588,"jbopomofo",12560,"jcaron",496,"jcircle",9433,"jcircumflex",309,"jcrossedtail",669,"jdotlessstroke",607,"jecyrillic",1112,"jeemarabic",1580,"jeemfinalarabic",65182,"jeeminitialarabic",65183,"jeemmedialarabic",65184,"jeharabic",1688,"jehfinalarabic",64395,"jhabengali",2461,"jhadeva",2333,"jhagujarati",2717,"jhagurmukhi",2589,"jheharmenian",1403,"jis",12292,"jmonospace",65354,"jparen",9381,"jsuperior",690,"k",107,"kabashkircyrillic",1185,"kabengali",2453,"kacute",7729,"kacyrillic",1082,"kadescendercyrillic",1179,"kadeva",2325,"kaf",1499,"kafarabic",1603,"kafdagesh",64315,"kafdageshhebrew",64315,"kaffinalarabic",65242,"kafhebrew",1499,"kafinitialarabic",65243,"kafmedialarabic",65244,"kafrafehebrew",64333,"kagujarati",2709,"kagurmukhi",2581,"kahiragana",12363,"kahookcyrillic",1220,"kakatakana",12459,"kakatakanahalfwidth",65398,"kappa",954,"kappasymbolgreek",1008,"kapyeounmieumkorean",12657,"kapyeounphieuphkorean",12676,"kapyeounpieupkorean",12664,"kapyeounssangpieupkorean",12665,"karoriisquare",13069,"kashidaautoarabic",1600,"kashidaautonosidebearingarabic",1600,"kasmallkatakana",12533,"kasquare",13188,"kasraarabic",1616,"kasratanarabic",1613,"kastrokecyrillic",1183,"katahiraprolongmarkhalfwidth",65392,"kaverticalstrokecyrillic",1181,"kbopomofo",12558,"kcalsquare",13193,"kcaron",489,"kcedilla",311,"kcircle",9434,"kcommaaccent",311,"kdotbelow",7731,"keharmenian",1412,"kehiragana",12369,"kekatakana",12465,"kekatakanahalfwidth",65401,"kenarmenian",1391,"kesmallkatakana",12534,"kgreenlandic",312,"khabengali",2454,"khacyrillic",1093,"khadeva",2326,"khagujarati",2710,"khagurmukhi",2582,"khaharabic",1582,"khahfinalarabic",65190,"khahinitialarabic",65191,"khahmedialarabic",65192,"kheicoptic",999,"khhadeva",2393,"khhagurmukhi",2649,"khieukhacirclekorean",12920,"khieukhaparenkorean",12824,"khieukhcirclekorean",12906,"khieukhkorean",12619,"khieukhparenkorean",12810,"khokhaithai",3586,"khokhonthai",3589,"khokhuatthai",3587,"khokhwaithai",3588,"khomutthai",3675,"khook",409,"khorakhangthai",3590,"khzsquare",13201,"kihiragana",12365,"kikatakana",12461,"kikatakanahalfwidth",65399,"kiroguramusquare",13077,"kiromeetorusquare",13078,"kirosquare",13076,"kiyeokacirclekorean",12910,"kiyeokaparenkorean",12814,"kiyeokcirclekorean",12896,"kiyeokkorean",12593,"kiyeokparenkorean",12800,"kiyeoksioskorean",12595,"kjecyrillic",1116,"klinebelow",7733,"klsquare",13208,"kmcubedsquare",13222,"kmonospace",65355,"kmsquaredsquare",13218,"kohiragana",12371,"kohmsquare",13248,"kokaithai",3585,"kokatakana",12467,"kokatakanahalfwidth",65402,"kooposquare",13086,"koppacyrillic",1153,"koreanstandardsymbol",12927,"koroniscmb",835,"kparen",9382,"kpasquare",13226,"ksicyrillic",1135,"ktsquare",13263,"kturned",670,"kuhiragana",12367,"kukatakana",12463,"kukatakanahalfwidth",65400,"kvsquare",13240,"kwsquare",13246,"l",108,"labengali",2482,"lacute",314,"ladeva",2354,"lagujarati",2738,"lagurmukhi",2610,"lakkhangyaothai",3653,"lamaleffinalarabic",65276,"lamalefhamzaabovefinalarabic",65272,"lamalefhamzaaboveisolatedarabic",65271,"lamalefhamzabelowfinalarabic",65274,"lamalefhamzabelowisolatedarabic",65273,"lamalefisolatedarabic",65275,"lamalefmaddaabovefinalarabic",65270,"lamalefmaddaaboveisolatedarabic",65269,"lamarabic",1604,"lambda",955,"lambdastroke",411,"lamed",1500,"lameddagesh",64316,"lameddageshhebrew",64316,"lamedhebrew",1500,"lamfinalarabic",65246,"lamhahinitialarabic",64714,"laminitialarabic",65247,"lamjeeminitialarabic",64713,"lamkhahinitialarabic",64715,"lamlamhehisolatedarabic",65010,"lammedialarabic",65248,"lammeemhahinitialarabic",64904,"lammeeminitialarabic",64716,"largecircle",9711,"lbar",410,"lbelt",620,"lbopomofo",12556,"lcaron",318,"lcedilla",316,"lcircle",9435,"lcircumflexbelow",7741,"lcommaaccent",316,"ldot",320,"ldotaccent",320,"ldotbelow",7735,"ldotbelowmacron",7737,"leftangleabovecmb",794,"lefttackbelowcmb",792,"less",60,"lessequal",8804,"lessequalorgreater",8922,"lessmonospace",65308,"lessorequivalent",8818,"lessorgreater",8822,"lessoverequal",8806,"lesssmall",65124,"lezh",622,"lfblock",9612,"lhookretroflex",621,"lira",8356,"liwnarmenian",1388,"lj",457,"ljecyrillic",1113,"ll",63168,"lladeva",2355,"llagujarati",2739,"llinebelow",7739,"llladeva",2356,"llvocalicbengali",2529,"llvocalicdeva",2401,"llvocalicvowelsignbengali",2531,"llvocalicvowelsigndeva",2403,"lmiddletilde",619,"lmonospace",65356,"lmsquare",13264,"lochulathai",3628,"logicaland",8743,"logicalnot",172,"logicalnotreversed",8976,"logicalor",8744,"lolingthai",3621,"longs",383,"lowlinecenterline",65102,"lowlinecmb",818,"lowlinedashed",65101,"lozenge",9674,"lparen",9383,"lslash",322,"lsquare",8467,"lsuperior",63214,"ltshade",9617,"luthai",3622,"lvocalicbengali",2444,"lvocalicdeva",2316,"lvocalicvowelsignbengali",2530,"lvocalicvowelsigndeva",2402,"lxsquare",13267,"m",109,"mabengali",2478,"macron",175,"macronbelowcmb",817,"macroncmb",772,"macronlowmod",717,"macronmonospace",65507,"macute",7743,"madeva",2350,"magujarati",2734,"magurmukhi",2606,"mahapakhhebrew",1444,"mahapakhlefthebrew",1444,"mahiragana",12414,"maichattawalowleftthai",63637,"maichattawalowrightthai",63636,"maichattawathai",3659,"maichattawaupperleftthai",63635,"maieklowleftthai",63628,"maieklowrightthai",63627,"maiekthai",3656,"maiekupperleftthai",63626,"maihanakatleftthai",63620,"maihanakatthai",3633,"maitaikhuleftthai",63625,"maitaikhuthai",3655,"maitholowleftthai",63631,"maitholowrightthai",63630,"maithothai",3657,"maithoupperleftthai",63629,"maitrilowleftthai",63634,"maitrilowrightthai",63633,"maitrithai",3658,"maitriupperleftthai",63632,"maiyamokthai",3654,"makatakana",12510,"makatakanahalfwidth",65423,"male",9794,"mansyonsquare",13127,"maqafhebrew",1470,"mars",9794,"masoracirclehebrew",1455,"masquare",13187,"mbopomofo",12551,"mbsquare",13268,"mcircle",9436,"mcubedsquare",13221,"mdotaccent",7745,"mdotbelow",7747,"meemarabic",1605,"meemfinalarabic",65250,"meeminitialarabic",65251,"meemmedialarabic",65252,"meemmeeminitialarabic",64721,"meemmeemisolatedarabic",64584,"meetorusquare",13133,"mehiragana",12417,"meizierasquare",13182,"mekatakana",12513,"mekatakanahalfwidth",65426,"mem",1502,"memdagesh",64318,"memdageshhebrew",64318,"memhebrew",1502,"menarmenian",1396,"merkhahebrew",1445,"merkhakefulahebrew",1446,"merkhakefulalefthebrew",1446,"merkhalefthebrew",1445,"mhook",625,"mhzsquare",13202,"middledotkatakanahalfwidth",65381,"middot",183,"mieumacirclekorean",12914,"mieumaparenkorean",12818,"mieumcirclekorean",12900,"mieumkorean",12609,"mieumpansioskorean",12656,"mieumparenkorean",12804,"mieumpieupkorean",12654,"mieumsioskorean",12655,"mihiragana",12415,"mikatakana",12511,"mikatakanahalfwidth",65424,"minus",8722,"minusbelowcmb",800,"minuscircle",8854,"minusmod",727,"minusplus",8723,"minute",8242,"miribaarusquare",13130,"mirisquare",13129,"mlonglegturned",624,"mlsquare",13206,"mmcubedsquare",13219,"mmonospace",65357,"mmsquaredsquare",13215,"mohiragana",12418,"mohmsquare",13249,"mokatakana",12514,"mokatakanahalfwidth",65427,"molsquare",13270,"momathai",3617,"moverssquare",13223,"moverssquaredsquare",13224,"mparen",9384,"mpasquare",13227,"mssquare",13235,"msuperior",63215,"mturned",623,"mu",181,"mu1",181,"muasquare",13186,"muchgreater",8811,"muchless",8810,"mufsquare",13196,"mugreek",956,"mugsquare",13197,"muhiragana",12416,"mukatakana",12512,"mukatakanahalfwidth",65425,"mulsquare",13205,"multiply",215,"mumsquare",13211,"munahhebrew",1443,"munahlefthebrew",1443,"musicalnote",9834,"musicalnotedbl",9835,"musicflatsign",9837,"musicsharpsign",9839,"mussquare",13234,"muvsquare",13238,"muwsquare",13244,"mvmegasquare",13241,"mvsquare",13239,"mwmegasquare",13247,"mwsquare",13245,"n",110,"nabengali",2472,"nabla",8711,"nacute",324,"nadeva",2344,"nagujarati",2728,"nagurmukhi",2600,"nahiragana",12394,"nakatakana",12490,"nakatakanahalfwidth",65413,"napostrophe",329,"nasquare",13185,"nbopomofo",12555,"nbspace",160,"ncaron",328,"ncedilla",326,"ncircle",9437,"ncircumflexbelow",7755,"ncommaaccent",326,"ndotaccent",7749,"ndotbelow",7751,"nehiragana",12397,"nekatakana",12493,"nekatakanahalfwidth",65416,"newsheqelsign",8362,"nfsquare",13195,"ngabengali",2457,"ngadeva",2329,"ngagujarati",2713,"ngagurmukhi",2585,"ngonguthai",3591,"nhiragana",12435,"nhookleft",626,"nhookretroflex",627,"nieunacirclekorean",12911,"nieunaparenkorean",12815,"nieuncieuckorean",12597,"nieuncirclekorean",12897,"nieunhieuhkorean",12598,"nieunkorean",12596,"nieunpansioskorean",12648,"nieunparenkorean",12801,"nieunsioskorean",12647,"nieuntikeutkorean",12646,"nihiragana",12395,"nikatakana",12491,"nikatakanahalfwidth",65414,"nikhahitleftthai",63641,"nikhahitthai",3661,"nine",57,"ninearabic",1641,"ninebengali",2543,"ninecircle",9320,"ninecircleinversesansserif",10130,"ninedeva",2415,"ninegujarati",2799,"ninegurmukhi",2671,"ninehackarabic",1641,"ninehangzhou",12329,"nineideographicparen",12840,"nineinferior",8329,"ninemonospace",65305,"nineoldstyle",63289,"nineparen",9340,"nineperiod",9360,"ninepersian",1785,"nineroman",8568,"ninesuperior",8313,"nineteencircle",9330,"nineteenparen",9350,"nineteenperiod",9370,"ninethai",3673,"nj",460,"njecyrillic",1114,"nkatakana",12531,"nkatakanahalfwidth",65437,"nlegrightlong",414,"nlinebelow",7753,"nmonospace",65358,"nmsquare",13210,"nnabengali",2467,"nnadeva",2339,"nnagujarati",2723,"nnagurmukhi",2595,"nnnadeva",2345,"nohiragana",12398,"nokatakana",12494,"nokatakanahalfwidth",65417,"nonbreakingspace",160,"nonenthai",3603,"nonuthai",3609,"noonarabic",1606,"noonfinalarabic",65254,"noonghunnaarabic",1722,"noonghunnafinalarabic",64415,"nooninitialarabic",65255,"noonjeeminitialarabic",64722,"noonjeemisolatedarabic",64587,"noonmedialarabic",65256,"noonmeeminitialarabic",64725,"noonmeemisolatedarabic",64590,"noonnoonfinalarabic",64653,"notcontains",8716,"notelement",8713,"notelementof",8713,"notequal",8800,"notgreater",8815,"notgreaternorequal",8817,"notgreaternorless",8825,"notidentical",8802,"notless",8814,"notlessnorequal",8816,"notparallel",8742,"notprecedes",8832,"notsubset",8836,"notsucceeds",8833,"notsuperset",8837,"nowarmenian",1398,"nparen",9385,"nssquare",13233,"nsuperior",8319,"ntilde",241,"nu",957,"nuhiragana",12396,"nukatakana",12492,"nukatakanahalfwidth",65415,"nuktabengali",2492,"nuktadeva",2364,"nuktagujarati",2748,"nuktagurmukhi",2620,"numbersign",35,"numbersignmonospace",65283,"numbersignsmall",65119,"numeralsigngreek",884,"numeralsignlowergreek",885,"numero",8470,"nun",1504,"nundagesh",64320,"nundageshhebrew",64320,"nunhebrew",1504,"nvsquare",13237,"nwsquare",13243,"nyabengali",2462,"nyadeva",2334,"nyagujarati",2718,"nyagurmukhi",2590,"o",111,"oacute",243,"oangthai",3629,"obarred",629,"obarredcyrillic",1257,"obarreddieresiscyrillic",1259,"obengali",2451,"obopomofo",12571,"obreve",335,"ocandradeva",2321,"ocandragujarati",2705,"ocandravowelsigndeva",2377,"ocandravowelsigngujarati",2761,"ocaron",466,"ocircle",9438,"ocircumflex",244,"ocircumflexacute",7889,"ocircumflexdotbelow",7897,"ocircumflexgrave",7891,"ocircumflexhookabove",7893,"ocircumflextilde",7895,"ocyrillic",1086,"odblacute",337,"odblgrave",525,"odeva",2323,"odieresis",246,"odieresiscyrillic",1255,"odotbelow",7885,"oe",339,"oekorean",12634,"ogonek",731,"ogonekcmb",808,"ograve",242,"ogujarati",2707,"oharmenian",1413,"ohiragana",12362,"ohookabove",7887,"ohorn",417,"ohornacute",7899,"ohorndotbelow",7907,"ohorngrave",7901,"ohornhookabove",7903,"ohorntilde",7905,"ohungarumlaut",337,"oi",419,"oinvertedbreve",527,"okatakana",12458,"okatakanahalfwidth",65397,"okorean",12631,"olehebrew",1451,"omacron",333,"omacronacute",7763,"omacrongrave",7761,"omdeva",2384,"omega",969,"omega1",982,"omegacyrillic",1121,"omegalatinclosed",631,"omegaroundcyrillic",1147,"omegatitlocyrillic",1149,"omegatonos",974,"omgujarati",2768,"omicron",959,"omicrontonos",972,"omonospace",65359,"one",49,"onearabic",1633,"onebengali",2535,"onecircle",9312,"onecircleinversesansserif",10122,"onedeva",2407,"onedotenleader",8228,"oneeighth",8539,"onefitted",63196,"onegujarati",2791,"onegurmukhi",2663,"onehackarabic",1633,"onehalf",189,"onehangzhou",12321,"oneideographicparen",12832,"oneinferior",8321,"onemonospace",65297,"onenumeratorbengali",2548,"oneoldstyle",63281,"oneparen",9332,"oneperiod",9352,"onepersian",1777,"onequarter",188,"oneroman",8560,"onesuperior",185,"onethai",3665,"onethird",8531,"oogonek",491,"oogonekmacron",493,"oogurmukhi",2579,"oomatragurmukhi",2635,"oopen",596,"oparen",9386,"openbullet",9702,"option",8997,"ordfeminine",170,"ordmasculine",186,"orthogonal",8735,"oshortdeva",2322,"oshortvowelsigndeva",2378,"oslash",248,"oslashacute",511,"osmallhiragana",12361,"osmallkatakana",12457,"osmallkatakanahalfwidth",65387,"ostrokeacute",511,"osuperior",63216,"otcyrillic",1151,"otilde",245,"otildeacute",7757,"otildedieresis",7759,"oubopomofo",12577,"overline",8254,"overlinecenterline",65098,"overlinecmb",773,"overlinedashed",65097,"overlinedblwavy",65100,"overlinewavy",65099,"overscore",175,"ovowelsignbengali",2507,"ovowelsigndeva",2379,"ovowelsigngujarati",2763,"p",112,"paampssquare",13184,"paasentosquare",13099,"pabengali",2474,"pacute",7765,"padeva",2346,"pagedown",8671,"pageup",8670,"pagujarati",2730,"pagurmukhi",2602,"pahiragana",12401,"paiyannoithai",3631,"pakatakana",12497,"palatalizationcyrilliccmb",1156,"palochkacyrillic",1216,"pansioskorean",12671,"paragraph",182,"parallel",8741,"parenleft",40,"parenleftaltonearabic",64830,"parenleftbt",63725,"parenleftex",63724,"parenleftinferior",8333,"parenleftmonospace",65288,"parenleftsmall",65113,"parenleftsuperior",8317,"parenlefttp",63723,"parenleftvertical",65077,"parenright",41,"parenrightaltonearabic",64831,"parenrightbt",63736,"parenrightex",63735,"parenrightinferior",8334,"parenrightmonospace",65289,"parenrightsmall",65114,"parenrightsuperior",8318,"parenrighttp",63734,"parenrightvertical",65078,"partialdiff",8706,"paseqhebrew",1472,"pashtahebrew",1433,"pasquare",13225,"patah",1463,"patah11",1463,"patah1d",1463,"patah2a",1463,"patahhebrew",1463,"patahnarrowhebrew",1463,"patahquarterhebrew",1463,"patahwidehebrew",1463,"pazerhebrew",1441,"pbopomofo",12550,"pcircle",9439,"pdotaccent",7767,"pe",1508,"pecyrillic",1087,"pedagesh",64324,"pedageshhebrew",64324,"peezisquare",13115,"pefinaldageshhebrew",64323,"peharabic",1662,"peharmenian",1402,"pehebrew",1508,"pehfinalarabic",64343,"pehinitialarabic",64344,"pehiragana",12410,"pehmedialarabic",64345,"pekatakana",12506,"pemiddlehookcyrillic",1191,"perafehebrew",64334,"percent",37,"percentarabic",1642,"percentmonospace",65285,"percentsmall",65130,"period",46,"periodarmenian",1417,"periodcentered",183,"periodhalfwidth",65377,"periodinferior",63207,"periodmonospace",65294,"periodsmall",65106,"periodsuperior",63208,"perispomenigreekcmb",834,"perpendicular",8869,"perthousand",8240,"peseta",8359,"pfsquare",13194,"phabengali",2475,"phadeva",2347,"phagujarati",2731,"phagurmukhi",2603,"phi",966,"phi1",981,"phieuphacirclekorean",12922,"phieuphaparenkorean",12826,"phieuphcirclekorean",12908,"phieuphkorean",12621,"phieuphparenkorean",12812,"philatin",632,"phinthuthai",3642,"phisymbolgreek",981,"phook",421,"phophanthai",3614,"phophungthai",3612,"phosamphaothai",3616,"pi",960,"pieupacirclekorean",12915,"pieupaparenkorean",12819,"pieupcieuckorean",12662,"pieupcirclekorean",12901,"pieupkiyeokkorean",12658,"pieupkorean",12610,"pieupparenkorean",12805,"pieupsioskiyeokkorean",12660,"pieupsioskorean",12612,"pieupsiostikeutkorean",12661,"pieupthieuthkorean",12663,"pieuptikeutkorean",12659,"pihiragana",12404,"pikatakana",12500,"pisymbolgreek",982,"piwrarmenian",1411,"plus",43,"plusbelowcmb",799,"pluscircle",8853,"plusminus",177,"plusmod",726,"plusmonospace",65291,"plussmall",65122,"plussuperior",8314,"pmonospace",65360,"pmsquare",13272,"pohiragana",12413,"pointingindexdownwhite",9759,"pointingindexleftwhite",9756,"pointingindexrightwhite",9758,"pointingindexupwhite",9757,"pokatakana",12509,"poplathai",3611,"postalmark",12306,"postalmarkface",12320,"pparen",9387,"precedes",8826,"prescription",8478,"primemod",697,"primereversed",8245,"product",8719,"projective",8965,"prolongedkana",12540,"propellor",8984,"propersubset",8834,"propersuperset",8835,"proportion",8759,"proportional",8733,"psi",968,"psicyrillic",1137,"psilipneumatacyrilliccmb",1158,"pssquare",13232,"puhiragana",12407,"pukatakana",12503,"pvsquare",13236,"pwsquare",13242,"q",113,"qadeva",2392,"qadmahebrew",1448,"qafarabic",1602,"qaffinalarabic",65238,"qafinitialarabic",65239,"qafmedialarabic",65240,"qamats",1464,"qamats10",1464,"qamats1a",1464,"qamats1c",1464,"qamats27",1464,"qamats29",1464,"qamats33",1464,"qamatsde",1464,"qamatshebrew",1464,"qamatsnarrowhebrew",1464,"qamatsqatanhebrew",1464,"qamatsqatannarrowhebrew",1464,"qamatsqatanquarterhebrew",1464,"qamatsqatanwidehebrew",1464,"qamatsquarterhebrew",1464,"qamatswidehebrew",1464,"qarneyparahebrew",1439,"qbopomofo",12561,"qcircle",9440,"qhook",672,"qmonospace",65361,"qof",1511,"qofdagesh",64327,"qofdageshhebrew",64327,"qofhebrew",1511,"qparen",9388,"quarternote",9833,"qubuts",1467,"qubuts18",1467,"qubuts25",1467,"qubuts31",1467,"qubutshebrew",1467,"qubutsnarrowhebrew",1467,"qubutsquarterhebrew",1467,"qubutswidehebrew",1467,"question",63,"questionarabic",1567,"questionarmenian",1374,"questiondown",191,"questiondownsmall",63423,"questiongreek",894,"questionmonospace",65311,"questionsmall",63295,"quotedbl",34,"quotedblbase",8222,"quotedblleft",8220,"quotedblmonospace",65282,"quotedblprime",12318,"quotedblprimereversed",12317,"quotedblright",8221,"quoteleft",8216,"quoteleftreversed",8219,"quotereversed",8219,"quoteright",8217,"quoterightn",329,"quotesinglbase",8218,"quotesingle",39,"quotesinglemonospace",65287,"r",114,"raarmenian",1404,"rabengali",2480,"racute",341,"radeva",2352,"radical",8730,"radicalex",63717,"radoverssquare",13230,"radoverssquaredsquare",13231,"radsquare",13229,"rafe",1471,"rafehebrew",1471,"ragujarati",2736,"ragurmukhi",2608,"rahiragana",12425,"rakatakana",12521,"rakatakanahalfwidth",65431,"ralowerdiagonalbengali",2545,"ramiddlediagonalbengali",2544,"ramshorn",612,"ratio",8758,"rbopomofo",12566,"rcaron",345,"rcedilla",343,"rcircle",9441,"rcommaaccent",343,"rdblgrave",529,"rdotaccent",7769,"rdotbelow",7771,"rdotbelowmacron",7773,"referencemark",8251,"reflexsubset",8838,"reflexsuperset",8839,"registered",174,"registersans",63720,"registerserif",63194,"reharabic",1585,"reharmenian",1408,"rehfinalarabic",65198,"rehiragana",12428,"rekatakana",12524,"rekatakanahalfwidth",65434,"resh",1512,"reshdageshhebrew",64328,"reshhebrew",1512,"reversedtilde",8765,"reviahebrew",1431,"reviamugrashhebrew",1431,"revlogicalnot",8976,"rfishhook",638,"rfishhookreversed",639,"rhabengali",2525,"rhadeva",2397,"rho",961,"rhook",637,"rhookturned",635,"rhookturnedsuperior",693,"rhosymbolgreek",1009,"rhotichookmod",734,"rieulacirclekorean",12913,"rieulaparenkorean",12817,"rieulcirclekorean",12899,"rieulhieuhkorean",12608,"rieulkiyeokkorean",12602,"rieulkiyeoksioskorean",12649,"rieulkorean",12601,"rieulmieumkorean",12603,"rieulpansioskorean",12652,"rieulparenkorean",12803,"rieulphieuphkorean",12607,"rieulpieupkorean",12604,"rieulpieupsioskorean",12651,"rieulsioskorean",12605,"rieulthieuthkorean",12606,"rieultikeutkorean",12650,"rieulyeorinhieuhkorean",12653,"rightangle",8735,"righttackbelowcmb",793,"righttriangle",8895,"rihiragana",12426,"rikatakana",12522,"rikatakanahalfwidth",65432,"ring",730,"ringbelowcmb",805,"ringcmb",778,"ringhalfleft",703,"ringhalfleftarmenian",1369,"ringhalfleftbelowcmb",796,"ringhalfleftcentered",723,"ringhalfright",702,"ringhalfrightbelowcmb",825,"ringhalfrightcentered",722,"rinvertedbreve",531,"rittorusquare",13137,"rlinebelow",7775,"rlongleg",636,"rlonglegturned",634,"rmonospace",65362,"rohiragana",12429,"rokatakana",12525,"rokatakanahalfwidth",65435,"roruathai",3619,"rparen",9389,"rrabengali",2524,"rradeva",2353,"rragurmukhi",2652,"rreharabic",1681,"rrehfinalarabic",64397,"rrvocalicbengali",2528,"rrvocalicdeva",2400,"rrvocalicgujarati",2784,"rrvocalicvowelsignbengali",2500,"rrvocalicvowelsigndeva",2372,"rrvocalicvowelsigngujarati",2756,"rsuperior",63217,"rtblock",9616,"rturned",633,"rturnedsuperior",692,"ruhiragana",12427,"rukatakana",12523,"rukatakanahalfwidth",65433,"rupeemarkbengali",2546,"rupeesignbengali",2547,"rupiah",63197,"ruthai",3620,"rvocalicbengali",2443,"rvocalicdeva",2315,"rvocalicgujarati",2699,"rvocalicvowelsignbengali",2499,"rvocalicvowelsigndeva",2371,"rvocalicvowelsigngujarati",2755,"s",115,"sabengali",2488,"sacute",347,"sacutedotaccent",7781,"sadarabic",1589,"sadeva",2360,"sadfinalarabic",65210,"sadinitialarabic",65211,"sadmedialarabic",65212,"sagujarati",2744,"sagurmukhi",2616,"sahiragana",12373,"sakatakana",12469,"sakatakanahalfwidth",65403,"sallallahoualayhewasallamarabic",65018,"samekh",1505,"samekhdagesh",64321,"samekhdageshhebrew",64321,"samekhhebrew",1505,"saraaathai",3634,"saraaethai",3649,"saraaimaimalaithai",3652,"saraaimaimuanthai",3651,"saraamthai",3635,"saraathai",3632,"saraethai",3648,"saraiileftthai",63622,"saraiithai",3637,"saraileftthai",63621,"saraithai",3636,"saraothai",3650,"saraueeleftthai",63624,"saraueethai",3639,"saraueleftthai",63623,"sarauethai",3638,"sarauthai",3640,"sarauuthai",3641,"sbopomofo",12569,"scaron",353,"scarondotaccent",7783,"scedilla",351,"schwa",601,"schwacyrillic",1241,"schwadieresiscyrillic",1243,"schwahook",602,"scircle",9442,"scircumflex",349,"scommaaccent",537,"sdotaccent",7777,"sdotbelow",7779,"sdotbelowdotaccent",7785,"seagullbelowcmb",828,"second",8243,"secondtonechinese",714,"section",167,"seenarabic",1587,"seenfinalarabic",65202,"seeninitialarabic",65203,"seenmedialarabic",65204,"segol",1462,"segol13",1462,"segol1f",1462,"segol2c",1462,"segolhebrew",1462,"segolnarrowhebrew",1462,"segolquarterhebrew",1462,"segoltahebrew",1426,"segolwidehebrew",1462,"seharmenian",1405,"sehiragana",12379,"sekatakana",12475,"sekatakanahalfwidth",65406,"semicolon",59,"semicolonarabic",1563,"semicolonmonospace",65307,"semicolonsmall",65108,"semivoicedmarkkana",12444,"semivoicedmarkkanahalfwidth",65439,"sentisquare",13090,"sentosquare",13091,"seven",55,"sevenarabic",1639,"sevenbengali",2541,"sevencircle",9318,"sevencircleinversesansserif",10128,"sevendeva",2413,"seveneighths",8542,"sevengujarati",2797,"sevengurmukhi",2669,"sevenhackarabic",1639,"sevenhangzhou",12327,"sevenideographicparen",12838,"seveninferior",8327,"sevenmonospace",65303,"sevenoldstyle",63287,"sevenparen",9338,"sevenperiod",9358,"sevenpersian",1783,"sevenroman",8566,"sevensuperior",8311,"seventeencircle",9328,"seventeenparen",9348,"seventeenperiod",9368,"seventhai",3671,"sfthyphen",173,"shaarmenian",1399,"shabengali",2486,"shacyrillic",1096,"shaddaarabic",1617,"shaddadammaarabic",64609,"shaddadammatanarabic",64606,"shaddafathaarabic",64608,"shaddakasraarabic",64610,"shaddakasratanarabic",64607,"shade",9618,"shadedark",9619,"shadelight",9617,"shademedium",9618,"shadeva",2358,"shagujarati",2742,"shagurmukhi",2614,"shalshelethebrew",1427,"shbopomofo",12565,"shchacyrillic",1097,"sheenarabic",1588,"sheenfinalarabic",65206,"sheeninitialarabic",65207,"sheenmedialarabic",65208,"sheicoptic",995,"sheqel",8362,"sheqelhebrew",8362,"sheva",1456,"sheva115",1456,"sheva15",1456,"sheva22",1456,"sheva2e",1456,"shevahebrew",1456,"shevanarrowhebrew",1456,"shevaquarterhebrew",1456,"shevawidehebrew",1456,"shhacyrillic",1211,"shimacoptic",1005,"shin",1513,"shindagesh",64329,"shindageshhebrew",64329,"shindageshshindot",64300,"shindageshshindothebrew",64300,"shindageshsindot",64301,"shindageshsindothebrew",64301,"shindothebrew",1473,"shinhebrew",1513,"shinshindot",64298,"shinshindothebrew",64298,"shinsindot",64299,"shinsindothebrew",64299,"shook",642,"sigma",963,"sigma1",962,"sigmafinal",962,"sigmalunatesymbolgreek",1010,"sihiragana",12375,"sikatakana",12471,"sikatakanahalfwidth",65404,"siluqhebrew",1469,"siluqlefthebrew",1469,"similar",8764,"sindothebrew",1474,"siosacirclekorean",12916,"siosaparenkorean",12820,"sioscieuckorean",12670,"sioscirclekorean",12902,"sioskiyeokkorean",12666,"sioskorean",12613,"siosnieunkorean",12667,"siosparenkorean",12806,"siospieupkorean",12669,"siostikeutkorean",12668,"six",54,"sixarabic",1638,"sixbengali",2540,"sixcircle",9317,"sixcircleinversesansserif",10127,"sixdeva",2412,"sixgujarati",2796,"sixgurmukhi",2668,"sixhackarabic",1638,"sixhangzhou",12326,"sixideographicparen",12837,"sixinferior",8326,"sixmonospace",65302,"sixoldstyle",63286,"sixparen",9337,"sixperiod",9357,"sixpersian",1782,"sixroman",8565,"sixsuperior",8310,"sixteencircle",9327,"sixteencurrencydenominatorbengali",2553,"sixteenparen",9347,"sixteenperiod",9367,"sixthai",3670,"slash",47,"slashmonospace",65295,"slong",383,"slongdotaccent",7835,"smileface",9786,"smonospace",65363,"sofpasuqhebrew",1475,"softhyphen",173,"softsigncyrillic",1100,"sohiragana",12381,"sokatakana",12477,"sokatakanahalfwidth",65407,"soliduslongoverlaycmb",824,"solidusshortoverlaycmb",823,"sorusithai",3625,"sosalathai",3624,"sosothai",3595,"sosuathai",3626,"space",32,"spacehackarabic",32,"spade",9824,"spadesuitblack",9824,"spadesuitwhite",9828,"sparen",9390,"squarebelowcmb",827,"squarecc",13252,"squarecm",13213,"squarediagonalcrosshatchfill",9641,"squarehorizontalfill",9636,"squarekg",13199,"squarekm",13214,"squarekmcapital",13262,"squareln",13265,"squarelog",13266,"squaremg",13198,"squaremil",13269,"squaremm",13212,"squaremsquared",13217,"squareorthogonalcrosshatchfill",9638,"squareupperlefttolowerrightfill",9639,"squareupperrighttolowerleftfill",9640,"squareverticalfill",9637,"squarewhitewithsmallblack",9635,"srsquare",13275,"ssabengali",2487,"ssadeva",2359,"ssagujarati",2743,"ssangcieuckorean",12617,"ssanghieuhkorean",12677,"ssangieungkorean",12672,"ssangkiyeokkorean",12594,"ssangnieunkorean",12645,"ssangpieupkorean",12611,"ssangsioskorean",12614,"ssangtikeutkorean",12600,"ssuperior",63218,"sterling",163,"sterlingmonospace",65505,"strokelongoverlaycmb",822,"strokeshortoverlaycmb",821,"subset",8834,"subsetnotequal",8842,"subsetorequal",8838,"succeeds",8827,"suchthat",8715,"suhiragana",12377,"sukatakana",12473,"sukatakanahalfwidth",65405,"sukunarabic",1618,"summation",8721,"sun",9788,"superset",8835,"supersetnotequal",8843,"supersetorequal",8839,"svsquare",13276,"syouwaerasquare",13180,"t",116,"tabengali",2468,"tackdown",8868,"tackleft",8867,"tadeva",2340,"tagujarati",2724,"tagurmukhi",2596,"taharabic",1591,"tahfinalarabic",65218,"tahinitialarabic",65219,"tahiragana",12383,"tahmedialarabic",65220,"taisyouerasquare",13181,"takatakana",12479,"takatakanahalfwidth",65408,"tatweelarabic",1600,"tau",964,"tav",1514,"tavdages",64330,"tavdagesh",64330,"tavdageshhebrew",64330,"tavhebrew",1514,"tbar",359,"tbopomofo",12554,"tcaron",357,"tccurl",680,"tcedilla",355,"tcheharabic",1670,"tchehfinalarabic",64379,"tchehinitialarabic",64380,"tchehmedialarabic",64381,"tcircle",9443,"tcircumflexbelow",7793,"tcommaaccent",355,"tdieresis",7831,"tdotaccent",7787,"tdotbelow",7789,"tecyrillic",1090,"tedescendercyrillic",1197,"teharabic",1578,"tehfinalarabic",65174,"tehhahinitialarabic",64674,"tehhahisolatedarabic",64524,"tehinitialarabic",65175,"tehiragana",12390,"tehjeeminitialarabic",64673,"tehjeemisolatedarabic",64523,"tehmarbutaarabic",1577,"tehmarbutafinalarabic",65172,"tehmedialarabic",65176,"tehmeeminitialarabic",64676,"tehmeemisolatedarabic",64526,"tehnoonfinalarabic",64627,"tekatakana",12486,"tekatakanahalfwidth",65411,"telephone",8481,"telephoneblack",9742,"telishagedolahebrew",1440,"telishaqetanahebrew",1449,"tencircle",9321,"tenideographicparen",12841,"tenparen",9341,"tenperiod",9361,"tenroman",8569,"tesh",679,"tet",1496,"tetdagesh",64312,"tetdageshhebrew",64312,"tethebrew",1496,"tetsecyrillic",1205,"tevirhebrew",1435,"tevirlefthebrew",1435,"thabengali",2469,"thadeva",2341,"thagujarati",2725,"thagurmukhi",2597,"thalarabic",1584,"thalfinalarabic",65196,"thanthakhatlowleftthai",63640,"thanthakhatlowrightthai",63639,"thanthakhatthai",3660,"thanthakhatupperleftthai",63638,"theharabic",1579,"thehfinalarabic",65178,"thehinitialarabic",65179,"thehmedialarabic",65180,"thereexists",8707,"therefore",8756,"theta",952,"theta1",977,"thetasymbolgreek",977,"thieuthacirclekorean",12921,"thieuthaparenkorean",12825,"thieuthcirclekorean",12907,"thieuthkorean",12620,"thieuthparenkorean",12811,"thirteencircle",9324,"thirteenparen",9344,"thirteenperiod",9364,"thonangmonthothai",3601,"thook",429,"thophuthaothai",3602,"thorn",254,"thothahanthai",3607,"thothanthai",3600,"thothongthai",3608,"thothungthai",3606,"thousandcyrillic",1154,"thousandsseparatorarabic",1644,"thousandsseparatorpersian",1644,"three",51,"threearabic",1635,"threebengali",2537,"threecircle",9314,"threecircleinversesansserif",10124,"threedeva",2409,"threeeighths",8540,"threegujarati",2793,"threegurmukhi",2665,"threehackarabic",1635,"threehangzhou",12323,"threeideographicparen",12834,"threeinferior",8323,"threemonospace",65299,"threenumeratorbengali",2550,"threeoldstyle",63283,"threeparen",9334,"threeperiod",9354,"threepersian",1779,"threequarters",190,"threequartersemdash",63198,"threeroman",8562,"threesuperior",179,"threethai",3667,"thzsquare",13204,"tihiragana",12385,"tikatakana",12481,"tikatakanahalfwidth",65409,"tikeutacirclekorean",12912,"tikeutaparenkorean",12816,"tikeutcirclekorean",12898,"tikeutkorean",12599,"tikeutparenkorean",12802,"tilde",732,"tildebelowcmb",816,"tildecmb",771,"tildecomb",771,"tildedoublecmb",864,"tildeoperator",8764,"tildeoverlaycmb",820,"tildeverticalcmb",830,"timescircle",8855,"tipehahebrew",1430,"tipehalefthebrew",1430,"tippigurmukhi",2672,"titlocyrilliccmb",1155,"tiwnarmenian",1407,"tlinebelow",7791,"tmonospace",65364,"toarmenian",1385,"tohiragana",12392,"tokatakana",12488,"tokatakanahalfwidth",65412,"tonebarextrahighmod",741,"tonebarextralowmod",745,"tonebarhighmod",742,"tonebarlowmod",744,"tonebarmidmod",743,"tonefive",445,"tonesix",389,"tonetwo",424,"tonos",900,"tonsquare",13095,"topatakthai",3599,"tortoiseshellbracketleft",12308,"tortoiseshellbracketleftsmall",65117,"tortoiseshellbracketleftvertical",65081,"tortoiseshellbracketright",12309,"tortoiseshellbracketrightsmall",65118,"tortoiseshellbracketrightvertical",65082,"totaothai",3605,"tpalatalhook",427,"tparen",9391,"trademark",8482,"trademarksans",63722,"trademarkserif",63195,"tretroflexhook",648,"triagdn",9660,"triaglf",9668,"triagrt",9658,"triagup",9650,"ts",678,"tsadi",1510,"tsadidagesh",64326,"tsadidageshhebrew",64326,"tsadihebrew",1510,"tsecyrillic",1094,"tsere",1461,"tsere12",1461,"tsere1e",1461,"tsere2b",1461,"tserehebrew",1461,"tserenarrowhebrew",1461,"tserequarterhebrew",1461,"tserewidehebrew",1461,"tshecyrillic",1115,"tsuperior",63219,"ttabengali",2463,"ttadeva",2335,"ttagujarati",2719,"ttagurmukhi",2591,"tteharabic",1657,"ttehfinalarabic",64359,"ttehinitialarabic",64360,"ttehmedialarabic",64361,"tthabengali",2464,"tthadeva",2336,"tthagujarati",2720,"tthagurmukhi",2592,"tturned",647,"tuhiragana",12388,"tukatakana",12484,"tukatakanahalfwidth",65410,"tusmallhiragana",12387,"tusmallkatakana",12483,"tusmallkatakanahalfwidth",65391,"twelvecircle",9323,"twelveparen",9343,"twelveperiod",9363,"twelveroman",8571,"twentycircle",9331,"twentyhangzhou",21316,"twentyparen",9351,"twentyperiod",9371,"two",50,"twoarabic",1634,"twobengali",2536,"twocircle",9313,"twocircleinversesansserif",10123,"twodeva",2408,"twodotenleader",8229,"twodotleader",8229,"twodotleadervertical",65072,"twogujarati",2792,"twogurmukhi",2664,"twohackarabic",1634,"twohangzhou",12322,"twoideographicparen",12833,"twoinferior",8322,"twomonospace",65298,"twonumeratorbengali",2549,"twooldstyle",63282,"twoparen",9333,"twoperiod",9353,"twopersian",1778,"tworoman",8561,"twostroke",443,"twosuperior",178,"twothai",3666,"twothirds",8532,"u",117,"uacute",250,"ubar",649,"ubengali",2441,"ubopomofo",12584,"ubreve",365,"ucaron",468,"ucircle",9444,"ucircumflex",251,"ucircumflexbelow",7799,"ucyrillic",1091,"udattadeva",2385,"udblacute",369,"udblgrave",533,"udeva",2313,"udieresis",252,"udieresisacute",472,"udieresisbelow",7795,"udieresiscaron",474,"udieresiscyrillic",1265,"udieresisgrave",476,"udieresismacron",470,"udotbelow",7909,"ugrave",249,"ugujarati",2697,"ugurmukhi",2569,"uhiragana",12358,"uhookabove",7911,"uhorn",432,"uhornacute",7913,"uhorndotbelow",7921,"uhorngrave",7915,"uhornhookabove",7917,"uhorntilde",7919,"uhungarumlaut",369,"uhungarumlautcyrillic",1267,"uinvertedbreve",535,"ukatakana",12454,"ukatakanahalfwidth",65395,"ukcyrillic",1145,"ukorean",12636,"umacron",363,"umacroncyrillic",1263,"umacrondieresis",7803,"umatragurmukhi",2625,"umonospace",65365,"underscore",95,"underscoredbl",8215,"underscoremonospace",65343,"underscorevertical",65075,"underscorewavy",65103,"union",8746,"universal",8704,"uogonek",371,"uparen",9392,"upblock",9600,"upperdothebrew",1476,"upsilon",965,"upsilondieresis",971,"upsilondieresistonos",944,"upsilonlatin",650,"upsilontonos",973,"uptackbelowcmb",797,"uptackmod",724,"uragurmukhi",2675,"uring",367,"ushortcyrillic",1118,"usmallhiragana",12357,"usmallkatakana",12453,"usmallkatakanahalfwidth",65385,"ustraightcyrillic",1199,"ustraightstrokecyrillic",1201,"utilde",361,"utildeacute",7801,"utildebelow",7797,"uubengali",2442,"uudeva",2314,"uugujarati",2698,"uugurmukhi",2570,"uumatragurmukhi",2626,"uuvowelsignbengali",2498,"uuvowelsigndeva",2370,"uuvowelsigngujarati",2754,"uvowelsignbengali",2497,"uvowelsigndeva",2369,"uvowelsigngujarati",2753,"v",118,"vadeva",2357,"vagujarati",2741,"vagurmukhi",2613,"vakatakana",12535,"vav",1493,"vavdagesh",64309,"vavdagesh65",64309,"vavdageshhebrew",64309,"vavhebrew",1493,"vavholam",64331,"vavholamhebrew",64331,"vavvavhebrew",1520,"vavyodhebrew",1521,"vcircle",9445,"vdotbelow",7807,"vecyrillic",1074,"veharabic",1700,"vehfinalarabic",64363,"vehinitialarabic",64364,"vehmedialarabic",64365,"vekatakana",12537,"venus",9792,"verticalbar",124,"verticallineabovecmb",781,"verticallinebelowcmb",809,"verticallinelowmod",716,"verticallinemod",712,"vewarmenian",1406,"vhook",651,"vikatakana",12536,"viramabengali",2509,"viramadeva",2381,"viramagujarati",2765,"visargabengali",2435,"visargadeva",2307,"visargagujarati",2691,"vmonospace",65366,"voarmenian",1400,"voicediterationhiragana",12446,"voicediterationkatakana",12542,"voicedmarkkana",12443,"voicedmarkkanahalfwidth",65438,"vokatakana",12538,"vparen",9393,"vtilde",7805,"vturned",652,"vuhiragana",12436,"vukatakana",12532,"w",119,"wacute",7811,"waekorean",12633,"wahiragana",12431,"wakatakana",12527,"wakatakanahalfwidth",65436,"wakorean",12632,"wasmallhiragana",12430,"wasmallkatakana",12526,"wattosquare",13143,"wavedash",12316,"wavyunderscorevertical",65076,"wawarabic",1608,"wawfinalarabic",65262,"wawhamzaabovearabic",1572,"wawhamzaabovefinalarabic",65158,"wbsquare",13277,"wcircle",9446,"wcircumflex",373,"wdieresis",7813,"wdotaccent",7815,"wdotbelow",7817,"wehiragana",12433,"weierstrass",8472,"wekatakana",12529,"wekorean",12638,"weokorean",12637,"wgrave",7809,"whitebullet",9702,"whitecircle",9675,"whitecircleinverse",9689,"whitecornerbracketleft",12302,"whitecornerbracketleftvertical",65091,"whitecornerbracketright",12303,"whitecornerbracketrightvertical",65092,"whitediamond",9671,"whitediamondcontainingblacksmalldiamond",9672,"whitedownpointingsmalltriangle",9663,"whitedownpointingtriangle",9661,"whiteleftpointingsmalltriangle",9667,"whiteleftpointingtriangle",9665,"whitelenticularbracketleft",12310,"whitelenticularbracketright",12311,"whiterightpointingsmalltriangle",9657,"whiterightpointingtriangle",9655,"whitesmallsquare",9643,"whitesmilingface",9786,"whitesquare",9633,"whitestar",9734,"whitetelephone",9743,"whitetortoiseshellbracketleft",12312,"whitetortoiseshellbracketright",12313,"whiteuppointingsmalltriangle",9653,"whiteuppointingtriangle",9651,"wihiragana",12432,"wikatakana",12528,"wikorean",12639,"wmonospace",65367,"wohiragana",12434,"wokatakana",12530,"wokatakanahalfwidth",65382,"won",8361,"wonmonospace",65510,"wowaenthai",3623,"wparen",9394,"wring",7832,"wsuperior",695,"wturned",653,"wynn",447,"x",120,"xabovecmb",829,"xbopomofo",12562,"xcircle",9447,"xdieresis",7821,"xdotaccent",7819,"xeharmenian",1389,"xi",958,"xmonospace",65368,"xparen",9395,"xsuperior",739,"y",121,"yaadosquare",13134,"yabengali",2479,"yacute",253,"yadeva",2351,"yaekorean",12626,"yagujarati",2735,"yagurmukhi",2607,"yahiragana",12420,"yakatakana",12516,"yakatakanahalfwidth",65428,"yakorean",12625,"yamakkanthai",3662,"yasmallhiragana",12419,"yasmallkatakana",12515,"yasmallkatakanahalfwidth",65388,"yatcyrillic",1123,"ycircle",9448,"ycircumflex",375,"ydieresis",255,"ydotaccent",7823,"ydotbelow",7925,"yeharabic",1610,"yehbarreearabic",1746,"yehbarreefinalarabic",64431,"yehfinalarabic",65266,"yehhamzaabovearabic",1574,"yehhamzaabovefinalarabic",65162,"yehhamzaaboveinitialarabic",65163,"yehhamzaabovemedialarabic",65164,"yehinitialarabic",65267,"yehmedialarabic",65268,"yehmeeminitialarabic",64733,"yehmeemisolatedarabic",64600,"yehnoonfinalarabic",64660,"yehthreedotsbelowarabic",1745,"yekorean",12630,"yen",165,"yenmonospace",65509,"yeokorean",12629,"yeorinhieuhkorean",12678,"yerahbenyomohebrew",1450,"yerahbenyomolefthebrew",1450,"yericyrillic",1099,"yerudieresiscyrillic",1273,"yesieungkorean",12673,"yesieungpansioskorean",12675,"yesieungsioskorean",12674,"yetivhebrew",1434,"ygrave",7923,"yhook",436,"yhookabove",7927,"yiarmenian",1397,"yicyrillic",1111,"yikorean",12642,"yinyang",9775,"yiwnarmenian",1410,"ymonospace",65369,"yod",1497,"yoddagesh",64313,"yoddageshhebrew",64313,"yodhebrew",1497,"yodyodhebrew",1522,"yodyodpatahhebrew",64287,"yohiragana",12424,"yoikorean",12681,"yokatakana",12520,"yokatakanahalfwidth",65430,"yokorean",12635,"yosmallhiragana",12423,"yosmallkatakana",12519,"yosmallkatakanahalfwidth",65390,"yotgreek",1011,"yoyaekorean",12680,"yoyakorean",12679,"yoyakthai",3618,"yoyingthai",3597,"yparen",9396,"ypogegrammeni",890,"ypogegrammenigreekcmb",837,"yr",422,"yring",7833,"ysuperior",696,"ytilde",7929,"yturned",654,"yuhiragana",12422,"yuikorean",12684,"yukatakana",12518,"yukatakanahalfwidth",65429,"yukorean",12640,"yusbigcyrillic",1131,"yusbigiotifiedcyrillic",1133,"yuslittlecyrillic",1127,"yuslittleiotifiedcyrillic",1129,"yusmallhiragana",12421,"yusmallkatakana",12517,"yusmallkatakanahalfwidth",65389,"yuyekorean",12683,"yuyeokorean",12682,"yyabengali",2527,"yyadeva",2399,"z",122,"zaarmenian",1382,"zacute",378,"zadeva",2395,"zagurmukhi",2651,"zaharabic",1592,"zahfinalarabic",65222,"zahinitialarabic",65223,"zahiragana",12374,"zahmedialarabic",65224,"zainarabic",1586,"zainfinalarabic",65200,"zakatakana",12470,"zaqefgadolhebrew",1429,"zaqefqatanhebrew",1428,"zarqahebrew",1432,"zayin",1494,"zayindagesh",64310,"zayindageshhebrew",64310,"zayinhebrew",1494,"zbopomofo",12567,"zcaron",382,"zcircle",9449,"zcircumflex",7825,"zcurl",657,"zdot",380,"zdotaccent",380,"zdotbelow",7827,"zecyrillic",1079,"zedescendercyrillic",1177,"zedieresiscyrillic",1247,"zehiragana",12380,"zekatakana",12476,"zero",48,"zeroarabic",1632,"zerobengali",2534,"zerodeva",2406,"zerogujarati",2790,"zerogurmukhi",2662,"zerohackarabic",1632,"zeroinferior",8320,"zeromonospace",65296,"zerooldstyle",63280,"zeropersian",1776,"zerosuperior",8304,"zerothai",3664,"zerowidthjoiner",65279,"zerowidthnonjoiner",8204,"zerowidthspace",8203,"zeta",950,"zhbopomofo",12563,"zhearmenian",1386,"zhebrevecyrillic",1218,"zhecyrillic",1078,"zhedescendercyrillic",1175,"zhedieresiscyrillic",1245,"zihiragana",12376,"zikatakana",12472,"zinorhebrew",1454,"zlinebelow",7829,"zmonospace",65370,"zohiragana",12382,"zokatakana",12478,"zparen",9397,"zretroflexhook",656,"zstroke",438,"zuhiragana",12378,"zukatakana",12474,".notdef",0,"angbracketleftbig",9001,"angbracketleftBig",9001,"angbracketleftbigg",9001,"angbracketleftBigg",9001,"angbracketrightBig",9002,"angbracketrightbig",9002,"angbracketrightBigg",9002,"angbracketrightbigg",9002,"arrowhookleft",8618,"arrowhookright",8617,"arrowlefttophalf",8636,"arrowleftbothalf",8637,"arrownortheast",8599,"arrownorthwest",8598,"arrowrighttophalf",8640,"arrowrightbothalf",8641,"arrowsoutheast",8600,"arrowsouthwest",8601,"backslashbig",8726,"backslashBig",8726,"backslashBigg",8726,"backslashbigg",8726,"bardbl",8214,"bracehtipdownleft",65079,"bracehtipdownright",65079,"bracehtipupleft",65080,"bracehtipupright",65080,"braceleftBig",123,"braceleftbig",123,"braceleftbigg",123,"braceleftBigg",123,"bracerightBig",125,"bracerightbig",125,"bracerightbigg",125,"bracerightBigg",125,"bracketleftbig",91,"bracketleftBig",91,"bracketleftbigg",91,"bracketleftBigg",91,"bracketrightBig",93,"bracketrightbig",93,"bracketrightbigg",93,"bracketrightBigg",93,"ceilingleftbig",8968,"ceilingleftBig",8968,"ceilingleftBigg",8968,"ceilingleftbigg",8968,"ceilingrightbig",8969,"ceilingrightBig",8969,"ceilingrightbigg",8969,"ceilingrightBigg",8969,"circledotdisplay",8857,"circledottext",8857,"circlemultiplydisplay",8855,"circlemultiplytext",8855,"circleplusdisplay",8853,"circleplustext",8853,"contintegraldisplay",8750,"contintegraltext",8750,"coproductdisplay",8720,"coproducttext",8720,"floorleftBig",8970,"floorleftbig",8970,"floorleftbigg",8970,"floorleftBigg",8970,"floorrightbig",8971,"floorrightBig",8971,"floorrightBigg",8971,"floorrightbigg",8971,"hatwide",770,"hatwider",770,"hatwidest",770,"intercal",7488,"integraldisplay",8747,"integraltext",8747,"intersectiondisplay",8898,"intersectiontext",8898,"logicalanddisplay",8743,"logicalandtext",8743,"logicalordisplay",8744,"logicalortext",8744,"parenleftBig",40,"parenleftbig",40,"parenleftBigg",40,"parenleftbigg",40,"parenrightBig",41,"parenrightbig",41,"parenrightBigg",41,"parenrightbigg",41,"prime",8242,"productdisplay",8719,"producttext",8719,"radicalbig",8730,"radicalBig",8730,"radicalBigg",8730,"radicalbigg",8730,"radicalbt",8730,"radicaltp",8730,"radicalvertex",8730,"slashbig",47,"slashBig",47,"slashBigg",47,"slashbigg",47,"summationdisplay",8721,"summationtext",8721,"tildewide",732,"tildewider",732,"tildewidest",732,"uniondisplay",8899,"unionmultidisplay",8846,"unionmultitext",8846,"unionsqdisplay",8852,"unionsqtext",8852,"uniontext",8899,"vextenddouble",8741,"vextendsingle",8739]})),n=(0,a.getArrayLookupTableFactory)((function(){return["space",32,"a1",9985,"a2",9986,"a202",9987,"a3",9988,"a4",9742,"a5",9990,"a119",9991,"a118",9992,"a117",9993,"a11",9755,"a12",9758,"a13",9996,"a14",9997,"a15",9998,"a16",9999,"a105",1e4,"a17",10001,"a18",10002,"a19",10003,"a20",10004,"a21",10005,"a22",10006,"a23",10007,"a24",10008,"a25",10009,"a26",10010,"a27",10011,"a28",10012,"a6",10013,"a7",10014,"a8",10015,"a9",10016,"a10",10017,"a29",10018,"a30",10019,"a31",10020,"a32",10021,"a33",10022,"a34",10023,"a35",9733,"a36",10025,"a37",10026,"a38",10027,"a39",10028,"a40",10029,"a41",10030,"a42",10031,"a43",10032,"a44",10033,"a45",10034,"a46",10035,"a47",10036,"a48",10037,"a49",10038,"a50",10039,"a51",10040,"a52",10041,"a53",10042,"a54",10043,"a55",10044,"a56",10045,"a57",10046,"a58",10047,"a59",10048,"a60",10049,"a61",10050,"a62",10051,"a63",10052,"a64",10053,"a65",10054,"a66",10055,"a67",10056,"a68",10057,"a69",10058,"a70",10059,"a71",9679,"a72",10061,"a73",9632,"a74",10063,"a203",10064,"a75",10065,"a204",10066,"a76",9650,"a77",9660,"a78",9670,"a79",10070,"a81",9687,"a82",10072,"a83",10073,"a84",10074,"a97",10075,"a98",10076,"a99",10077,"a100",10078,"a101",10081,"a102",10082,"a103",10083,"a104",10084,"a106",10085,"a107",10086,"a108",10087,"a112",9827,"a111",9830,"a110",9829,"a109",9824,"a120",9312,"a121",9313,"a122",9314,"a123",9315,"a124",9316,"a125",9317,"a126",9318,"a127",9319,"a128",9320,"a129",9321,"a130",10102,"a131",10103,"a132",10104,"a133",10105,"a134",10106,"a135",10107,"a136",10108,"a137",10109,"a138",10110,"a139",10111,"a140",10112,"a141",10113,"a142",10114,"a143",10115,"a144",10116,"a145",10117,"a146",10118,"a147",10119,"a148",10120,"a149",10121,"a150",10122,"a151",10123,"a152",10124,"a153",10125,"a154",10126,"a155",10127,"a156",10128,"a157",10129,"a158",10130,"a159",10131,"a160",10132,"a161",8594,"a163",8596,"a164",8597,"a196",10136,"a165",10137,"a192",10138,"a166",10139,"a167",10140,"a168",10141,"a169",10142,"a170",10143,"a171",10144,"a172",10145,"a173",10146,"a162",10147,"a174",10148,"a175",10149,"a176",10150,"a177",10151,"a178",10152,"a179",10153,"a193",10154,"a180",10155,"a199",10156,"a181",10157,"a200",10158,"a182",10159,"a201",10161,"a183",10162,"a184",10163,"a197",10164,"a185",10165,"a194",10166,"a198",10167,"a186",10168,"a195",10169,"a187",10170,"a188",10171,"a189",10172,"a190",10173,"a191",10174,"a89",10088,"a90",10089,"a93",10090,"a94",10091,"a91",10092,"a92",10093,"a205",10094,"a85",10095,"a206",10096,"a86",10097,"a87",10098,"a88",10099,"a95",10100,"a96",10101,".notdef",0]}))},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getSymbolsFonts=t.getSupplementalGlyphMapForCalibri=t.getSupplementalGlyphMapForArialBlack=t.getStdFontMap=t.getSerifFonts=t.getNonStdFontMap=t.getGlyphMapForStandardFonts=void 0;var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e.ArialNarrow="Helvetica";e["ArialNarrow-Bold"]="Helvetica-Bold";e["ArialNarrow-BoldItalic"]="Helvetica-BoldOblique";e["ArialNarrow-Italic"]="Helvetica-Oblique";e.ArialBlack="Helvetica";e["ArialBlack-Bold"]="Helvetica-Bold";e["ArialBlack-BoldItalic"]="Helvetica-BoldOblique";e["ArialBlack-Italic"]="Helvetica-Oblique";e["Arial-Black"]="Helvetica";e["Arial-Black-Bold"]="Helvetica-Bold";e["Arial-Black-BoldItalic"]="Helvetica-BoldOblique";e["Arial-Black-Italic"]="Helvetica-Oblique";e.Arial="Helvetica";e["Arial-Bold"]="Helvetica-Bold";e["Arial-BoldItalic"]="Helvetica-BoldOblique";e["Arial-Italic"]="Helvetica-Oblique";e["Arial-BoldItalicMT"]="Helvetica-BoldOblique";e["Arial-BoldMT"]="Helvetica-Bold";e["Arial-ItalicMT"]="Helvetica-Oblique";e.ArialMT="Helvetica";e["Courier-Bold"]="Courier-Bold";e["Courier-BoldItalic"]="Courier-BoldOblique";e["Courier-Italic"]="Courier-Oblique";e.CourierNew="Courier";e["CourierNew-Bold"]="Courier-Bold";e["CourierNew-BoldItalic"]="Courier-BoldOblique";e["CourierNew-Italic"]="Courier-Oblique";e["CourierNewPS-BoldItalicMT"]="Courier-BoldOblique";e["CourierNewPS-BoldMT"]="Courier-Bold";e["CourierNewPS-ItalicMT"]="Courier-Oblique";e.CourierNewPSMT="Courier";e.Helvetica="Helvetica";e["Helvetica-Bold"]="Helvetica-Bold";e["Helvetica-BoldItalic"]="Helvetica-BoldOblique";e["Helvetica-BoldOblique"]="Helvetica-BoldOblique";e["Helvetica-Italic"]="Helvetica-Oblique";e["Helvetica-Oblique"]="Helvetica-Oblique";e["Symbol-Bold"]="Symbol";e["Symbol-BoldItalic"]="Symbol";e["Symbol-Italic"]="Symbol";e.TimesNewRoman="Times-Roman";e["TimesNewRoman-Bold"]="Times-Bold";e["TimesNewRoman-BoldItalic"]="Times-BoldItalic";e["TimesNewRoman-Italic"]="Times-Italic";e.TimesNewRomanPS="Times-Roman";e["TimesNewRomanPS-Bold"]="Times-Bold";e["TimesNewRomanPS-BoldItalic"]="Times-BoldItalic";e["TimesNewRomanPS-BoldItalicMT"]="Times-BoldItalic";e["TimesNewRomanPS-BoldMT"]="Times-Bold";e["TimesNewRomanPS-Italic"]="Times-Italic";e["TimesNewRomanPS-ItalicMT"]="Times-Italic";e.TimesNewRomanPSMT="Times-Roman";e["TimesNewRomanPSMT-Bold"]="Times-Bold";e["TimesNewRomanPSMT-BoldItalic"]="Times-BoldItalic";e["TimesNewRomanPSMT-Italic"]="Times-Italic"}));t.getStdFontMap=i;const n=(0,a.getLookupTableFactory)((function(e){e.Calibri="Helvetica";e["Calibri-Bold"]="Helvetica-Bold";e["Calibri-BoldItalic"]="Helvetica-BoldOblique";e["Calibri-Italic"]="Helvetica-Oblique";e.CenturyGothic="Helvetica";e["CenturyGothic-Bold"]="Helvetica-Bold";e["CenturyGothic-BoldItalic"]="Helvetica-BoldOblique";e["CenturyGothic-Italic"]="Helvetica-Oblique";e.ComicSansMS="Comic Sans MS";e["ComicSansMS-Bold"]="Comic Sans MS-Bold";e["ComicSansMS-BoldItalic"]="Comic Sans MS-BoldItalic";e["ComicSansMS-Italic"]="Comic Sans MS-Italic";e.LucidaConsole="Courier";e["LucidaConsole-Bold"]="Courier-Bold";e["LucidaConsole-BoldItalic"]="Courier-BoldOblique";e["LucidaConsole-Italic"]="Courier-Oblique";e["LucidaSans-Demi"]="Helvetica-Bold";e["MS-Gothic"]="MS Gothic";e["MS-Gothic-Bold"]="MS Gothic-Bold";e["MS-Gothic-BoldItalic"]="MS Gothic-BoldItalic";e["MS-Gothic-Italic"]="MS Gothic-Italic";e["MS-Mincho"]="MS Mincho";e["MS-Mincho-Bold"]="MS Mincho-Bold";e["MS-Mincho-BoldItalic"]="MS Mincho-BoldItalic";e["MS-Mincho-Italic"]="MS Mincho-Italic";e["MS-PGothic"]="MS PGothic";e["MS-PGothic-Bold"]="MS PGothic-Bold";e["MS-PGothic-BoldItalic"]="MS PGothic-BoldItalic";e["MS-PGothic-Italic"]="MS PGothic-Italic";e["MS-PMincho"]="MS PMincho";e["MS-PMincho-Bold"]="MS PMincho-Bold";e["MS-PMincho-BoldItalic"]="MS PMincho-BoldItalic";e["MS-PMincho-Italic"]="MS PMincho-Italic";e.NuptialScript="Times-Italic";e.SegoeUISymbol="Helvetica";e.Wingdings="ZapfDingbats";e["Wingdings-Regular"]="ZapfDingbats"}));t.getNonStdFontMap=n;const s=(0,a.getLookupTableFactory)((function(e){e["Adobe Jenson"]=!0;e["Adobe Text"]=!0;e.Albertus=!0;e.Aldus=!0;e.Alexandria=!0;e.Algerian=!0;e["American Typewriter"]=!0;e.Antiqua=!0;e.Apex=!0;e.Arno=!0;e.Aster=!0;e.Aurora=!0;e.Baskerville=!0;e.Bell=!0;e.Bembo=!0;e["Bembo Schoolbook"]=!0;e.Benguiat=!0;e["Berkeley Old Style"]=!0;e["Bernhard Modern"]=!0;e["Berthold City"]=!0;e.Bodoni=!0;e["Bauer Bodoni"]=!0;e["Book Antiqua"]=!0;e.Bookman=!0;e["Bordeaux Roman"]=!0;e["Californian FB"]=!0;e.Calisto=!0;e.Calvert=!0;e.Capitals=!0;e.Cambria=!0;e.Cartier=!0;e.Caslon=!0;e.Catull=!0;e.Centaur=!0;e["Century Old Style"]=!0;e["Century Schoolbook"]=!0;e.Chaparral=!0;e["Charis SIL"]=!0;e.Cheltenham=!0;e["Cholla Slab"]=!0;e.Clarendon=!0;e.Clearface=!0;e.Cochin=!0;e.Colonna=!0;e["Computer Modern"]=!0;e["Concrete Roman"]=!0;e.Constantia=!0;e["Cooper Black"]=!0;e.Corona=!0;e.Ecotype=!0;e.Egyptienne=!0;e.Elephant=!0;e.Excelsior=!0;e.Fairfield=!0;e["FF Scala"]=!0;e.Folkard=!0;e.Footlight=!0;e.FreeSerif=!0;e["Friz Quadrata"]=!0;e.Garamond=!0;e.Gentium=!0;e.Georgia=!0;e.Gloucester=!0;e["Goudy Old Style"]=!0;e["Goudy Schoolbook"]=!0;e["Goudy Pro Font"]=!0;e.Granjon=!0;e["Guardian Egyptian"]=!0;e.Heather=!0;e.Hercules=!0;e["High Tower Text"]=!0;e.Hiroshige=!0;e["Hoefler Text"]=!0;e["Humana Serif"]=!0;e.Imprint=!0;e["Ionic No. 5"]=!0;e.Janson=!0;e.Joanna=!0;e.Korinna=!0;e.Lexicon=!0;e["Liberation Serif"]=!0;e["Linux Libertine"]=!0;e.Literaturnaya=!0;e.Lucida=!0;e["Lucida Bright"]=!0;e.Melior=!0;e.Memphis=!0;e.Miller=!0;e.Minion=!0;e.Modern=!0;e["Mona Lisa"]=!0;e["Mrs Eaves"]=!0;e["MS Serif"]=!0;e["Museo Slab"]=!0;e["New York"]=!0;e["Nimbus Roman"]=!0;e["NPS Rawlinson Roadway"]=!0;e.NuptialScript=!0;e.Palatino=!0;e.Perpetua=!0;e.Plantin=!0;e["Plantin Schoolbook"]=!0;e.Playbill=!0;e["Poor Richard"]=!0;e["Rawlinson Roadway"]=!0;e.Renault=!0;e.Requiem=!0;e.Rockwell=!0;e.Roman=!0;e["Rotis Serif"]=!0;e.Sabon=!0;e.Scala=!0;e.Seagull=!0;e.Sistina=!0;e.Souvenir=!0;e.STIX=!0;e["Stone Informal"]=!0;e["Stone Serif"]=!0;e.Sylfaen=!0;e.Times=!0;e.Trajan=!0;e["Trinité"]=!0;e["Trump Mediaeval"]=!0;e.Utopia=!0;e["Vale Type"]=!0;e["Bitstream Vera"]=!0;e["Vera Serif"]=!0;e.Versailles=!0;e.Wanted=!0;e.Weiss=!0;e["Wide Latin"]=!0;e.Windsor=!0;e.XITS=!0}));t.getSerifFonts=s;const o=(0,a.getLookupTableFactory)((function(e){e.Dingbats=!0;e.Symbol=!0;e.ZapfDingbats=!0}));t.getSymbolsFonts=o;const c=(0,a.getLookupTableFactory)((function(e){e[2]=10;e[3]=32;e[4]=33;e[5]=34;e[6]=35;e[7]=36;e[8]=37;e[9]=38;e[10]=39;e[11]=40;e[12]=41;e[13]=42;e[14]=43;e[15]=44;e[16]=45;e[17]=46;e[18]=47;e[19]=48;e[20]=49;e[21]=50;e[22]=51;e[23]=52;e[24]=53;e[25]=54;e[26]=55;e[27]=56;e[28]=57;e[29]=58;e[30]=894;e[31]=60;e[32]=61;e[33]=62;e[34]=63;e[35]=64;e[36]=65;e[37]=66;e[38]=67;e[39]=68;e[40]=69;e[41]=70;e[42]=71;e[43]=72;e[44]=73;e[45]=74;e[46]=75;e[47]=76;e[48]=77;e[49]=78;e[50]=79;e[51]=80;e[52]=81;e[53]=82;e[54]=83;e[55]=84;e[56]=85;e[57]=86;e[58]=87;e[59]=88;e[60]=89;e[61]=90;e[62]=91;e[63]=92;e[64]=93;e[65]=94;e[66]=95;e[67]=96;e[68]=97;e[69]=98;e[70]=99;e[71]=100;e[72]=101;e[73]=102;e[74]=103;e[75]=104;e[76]=105;e[77]=106;e[78]=107;e[79]=108;e[80]=109;e[81]=110;e[82]=111;e[83]=112;e[84]=113;e[85]=114;e[86]=115;e[87]=116;e[88]=117;e[89]=118;e[90]=119;e[91]=120;e[92]=121;e[93]=122;e[94]=123;e[95]=124;e[96]=125;e[97]=126;e[98]=196;e[99]=197;e[100]=199;e[101]=201;e[102]=209;e[103]=214;e[104]=220;e[105]=225;e[106]=224;e[107]=226;e[108]=228;e[109]=227;e[110]=229;e[111]=231;e[112]=233;e[113]=232;e[114]=234;e[115]=235;e[116]=237;e[117]=236;e[118]=238;e[119]=239;e[120]=241;e[121]=243;e[122]=242;e[123]=244;e[124]=246;e[125]=245;e[126]=250;e[127]=249;e[128]=251;e[129]=252;e[130]=8224;e[131]=176;e[132]=162;e[133]=163;e[134]=167;e[135]=8226;e[136]=182;e[137]=223;e[138]=174;e[139]=169;e[140]=8482;e[141]=180;e[142]=168;e[143]=8800;e[144]=198;e[145]=216;e[146]=8734;e[147]=177;e[148]=8804;e[149]=8805;e[150]=165;e[151]=181;e[152]=8706;e[153]=8721;e[154]=8719;e[156]=8747;e[157]=170;e[158]=186;e[159]=8486;e[160]=230;e[161]=248;e[162]=191;e[163]=161;e[164]=172;e[165]=8730;e[166]=402;e[167]=8776;e[168]=8710;e[169]=171;e[170]=187;e[171]=8230;e[210]=218;e[223]=711;e[224]=321;e[225]=322;e[227]=353;e[229]=382;e[234]=253;e[252]=263;e[253]=268;e[254]=269;e[258]=258;e[260]=260;e[261]=261;e[265]=280;e[266]=281;e[268]=283;e[269]=313;e[275]=323;e[276]=324;e[278]=328;e[284]=345;e[285]=346;e[286]=347;e[292]=367;e[295]=377;e[296]=378;e[298]=380;e[305]=963;e[306]=964;e[307]=966;e[308]=8215;e[309]=8252;e[310]=8319;e[311]=8359;e[312]=8592;e[313]=8593;e[337]=9552;e[493]=1039;e[494]=1040;e[705]=1524;e[706]=8362;e[710]=64288;e[711]=64298;e[759]=1617;e[761]=1776;e[763]=1778;e[775]=1652;e[777]=1764;e[778]=1780;e[779]=1781;e[780]=1782;e[782]=771;e[783]=64726;e[786]=8363;e[788]=8532;e[790]=768;e[791]=769;e[792]=768;e[795]=803;e[797]=64336;e[798]=64337;e[799]=64342;e[800]=64343;e[801]=64344;e[802]=64345;e[803]=64362;e[804]=64363;e[805]=64364;e[2424]=7821;e[2425]=7822;e[2426]=7823;e[2427]=7824;e[2428]=7825;e[2429]=7826;e[2430]=7827;e[2433]=7682;e[2678]=8045;e[2679]=8046;e[2830]=1552;e[2838]=686;e[2840]=751;e[2842]=753;e[2843]=754;e[2844]=755;e[2846]=757;e[2856]=767;e[2857]=848;e[2858]=849;e[2862]=853;e[2863]=854;e[2864]=855;e[2865]=861;e[2866]=862;e[2906]=7460;e[2908]=7462;e[2909]=7463;e[2910]=7464;e[2912]=7466;e[2913]=7467;e[2914]=7468;e[2916]=7470;e[2917]=7471;e[2918]=7472;e[2920]=7474;e[2921]=7475;e[2922]=7476;e[2924]=7478;e[2925]=7479;e[2926]=7480;e[2928]=7482;e[2929]=7483;e[2930]=7484;e[2932]=7486;e[2933]=7487;e[2934]=7488;e[2936]=7490;e[2937]=7491;e[2938]=7492;e[2940]=7494;e[2941]=7495;e[2942]=7496;e[2944]=7498;e[2946]=7500;e[2948]=7502;e[2950]=7504;e[2951]=7505;e[2952]=7506;e[2954]=7508;e[2955]=7509;e[2956]=7510;e[2958]=7512;e[2959]=7513;e[2960]=7514;e[2962]=7516;e[2963]=7517;e[2964]=7518;e[2966]=7520;e[2967]=7521;e[2968]=7522;e[2970]=7524;e[2971]=7525;e[2972]=7526;e[2974]=7528;e[2975]=7529;e[2976]=7530;e[2978]=1537;e[2979]=1538;e[2980]=1539;e[2982]=1549;e[2983]=1551;e[2984]=1552;e[2986]=1554;e[2987]=1555;e[2988]=1556;e[2990]=1623;e[2991]=1624;e[2995]=1775;e[2999]=1791;e[3002]=64290;e[3003]=64291;e[3004]=64292;e[3006]=64294;e[3007]=64295;e[3008]=64296;e[3011]=1900;e[3014]=8223;e[3015]=8244;e[3017]=7532;e[3018]=7533;e[3019]=7534;e[3075]=7590;e[3076]=7591;e[3079]=7594;e[3080]=7595;e[3083]=7598;e[3084]=7599;e[3087]=7602;e[3088]=7603;e[3091]=7606;e[3092]=7607;e[3095]=7610;e[3096]=7611;e[3099]=7614;e[3100]=7615;e[3103]=7618;e[3104]=7619;e[3107]=8337;e[3108]=8338;e[3116]=1884;e[3119]=1885;e[3120]=1885;e[3123]=1886;e[3124]=1886;e[3127]=1887;e[3128]=1887;e[3131]=1888;e[3132]=1888;e[3135]=1889;e[3136]=1889;e[3139]=1890;e[3140]=1890;e[3143]=1891;e[3144]=1891;e[3147]=1892;e[3148]=1892;e[3153]=580;e[3154]=581;e[3157]=584;e[3158]=585;e[3161]=588;e[3162]=589;e[3165]=891;e[3166]=892;e[3169]=1274;e[3170]=1275;e[3173]=1278;e[3174]=1279;e[3181]=7622;e[3182]=7623;e[3282]=11799;e[3316]=578;e[3379]=42785;e[3393]=1159;e[3416]=8377}));t.getGlyphMapForStandardFonts=c;const l=(0,a.getLookupTableFactory)((function(e){e[227]=322;e[264]=261;e[291]=346}));t.getSupplementalGlyphMapForArialBlack=l;const h=(0,a.getLookupTableFactory)((function(e){e[1]=32;e[4]=65;e[17]=66;e[18]=67;e[24]=68;e[28]=69;e[38]=70;e[39]=71;e[44]=72;e[47]=73;e[58]=74;e[60]=75;e[62]=76;e[68]=77;e[69]=78;e[75]=79;e[87]=80;e[89]=81;e[90]=82;e[94]=83;e[100]=84;e[104]=85;e[115]=86;e[116]=87;e[121]=88;e[122]=89;e[127]=90;e[258]=97;e[268]=261;e[271]=98;e[272]=99;e[273]=263;e[282]=100;e[286]=101;e[295]=281;e[296]=102;e[336]=103;e[346]=104;e[349]=105;e[361]=106;e[364]=107;e[367]=108;e[371]=322;e[373]=109;e[374]=110;e[381]=111;e[383]=243;e[393]=112;e[395]=113;e[396]=114;e[400]=115;e[401]=347;e[410]=116;e[437]=117;e[448]=118;e[449]=119;e[454]=120;e[455]=121;e[460]=122;e[463]=380;e[853]=44;e[855]=58;e[856]=46;e[876]=47;e[878]=45;e[882]=45;e[894]=40;e[895]=41;e[896]=91;e[897]=93;e[923]=64;e[1004]=48;e[1005]=49;e[1006]=50;e[1007]=51;e[1008]=52;e[1009]=53;e[1010]=54;e[1011]=55;e[1012]=56;e[1013]=57;e[1081]=37;e[1085]=43;e[1086]=45}));t.getSupplementalGlyphMapForCalibri=h},(e,t,r)=>{r.r(t);r.d(t,{getNormalizedUnicodes:()=>s,getUnicodeForGlyph:()=>getUnicodeForGlyph,getUnicodeRangeFor:()=>getUnicodeRangeFor,mapSpecialUnicodeValues:()=>mapSpecialUnicodeValues,reverseIfRtl:()=>reverseIfRtl});var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e[63721]=169;e[63193]=169;e[63720]=174;e[63194]=174;e[63722]=8482;e[63195]=8482;e[63729]=9127;e[63730]=9128;e[63731]=9129;e[63740]=9131;e[63741]=9132;e[63742]=9133;e[63726]=9121;e[63727]=9122;e[63728]=9123;e[63737]=9124;e[63738]=9125;e[63739]=9126;e[63723]=9115;e[63724]=9116;e[63725]=9117;e[63734]=9118;e[63735]=9119;e[63736]=9120}));function mapSpecialUnicodeValues(e){return e>=65520&&e<=65535?0:e>=62976&&e<=63743?i()[e]||e:173===e?45:e}function getUnicodeForGlyph(e,t){let r=t[e];if(void 0!==r)return r;if(!e)return-1;if("u"===e[0]){const t=e.length;let a;if(7===t&&"n"===e[1]&&"i"===e[2])a=e.substring(3);else{if(!(t>=5&&t<=7))return-1;a=e.substring(1)}if(a===a.toUpperCase()){r=parseInt(a,16);if(r>=0)return r}}return-1}const n=[{begin:0,end:127},{begin:128,end:255},{begin:256,end:383},{begin:384,end:591},{begin:592,end:687},{begin:688,end:767},{begin:768,end:879},{begin:880,end:1023},{begin:11392,end:11519},{begin:1024,end:1279},{begin:1328,end:1423},{begin:1424,end:1535},{begin:42240,end:42559},{begin:1536,end:1791},{begin:1984,end:2047},{begin:2304,end:2431},{begin:2432,end:2559},{begin:2560,end:2687},{begin:2688,end:2815},{begin:2816,end:2943},{begin:2944,end:3071},{begin:3072,end:3199},{begin:3200,end:3327},{begin:3328,end:3455},{begin:3584,end:3711},{begin:3712,end:3839},{begin:4256,end:4351},{begin:6912,end:7039},{begin:4352,end:4607},{begin:7680,end:7935},{begin:7936,end:8191},{begin:8192,end:8303},{begin:8304,end:8351},{begin:8352,end:8399},{begin:8400,end:8447},{begin:8448,end:8527},{begin:8528,end:8591},{begin:8592,end:8703},{begin:8704,end:8959},{begin:8960,end:9215},{begin:9216,end:9279},{begin:9280,end:9311},{begin:9312,end:9471},{begin:9472,end:9599},{begin:9600,end:9631},{begin:9632,end:9727},{begin:9728,end:9983},{begin:9984,end:10175},{begin:12288,end:12351},{begin:12352,end:12447},{begin:12448,end:12543},{begin:12544,end:12591},{begin:12592,end:12687},{begin:43072,end:43135},{begin:12800,end:13055},{begin:13056,end:13311},{begin:44032,end:55215},{begin:55296,end:57343},{begin:67840,end:67871},{begin:19968,end:40959},{begin:57344,end:63743},{begin:12736,end:12783},{begin:64256,end:64335},{begin:64336,end:65023},{begin:65056,end:65071},{begin:65040,end:65055},{begin:65104,end:65135},{begin:65136,end:65279},{begin:65280,end:65519},{begin:65520,end:65535},{begin:3840,end:4095},{begin:1792,end:1871},{begin:1920,end:1983},{begin:3456,end:3583},{begin:4096,end:4255},{begin:4608,end:4991},{begin:5024,end:5119},{begin:5120,end:5759},{begin:5760,end:5791},{begin:5792,end:5887},{begin:6016,end:6143},{begin:6144,end:6319},{begin:10240,end:10495},{begin:40960,end:42127},{begin:5888,end:5919},{begin:66304,end:66351},{begin:66352,end:66383},{begin:66560,end:66639},{begin:118784,end:119039},{begin:119808,end:120831},{begin:1044480,end:1048573},{begin:65024,end:65039},{begin:917504,end:917631},{begin:6400,end:6479},{begin:6480,end:6527},{begin:6528,end:6623},{begin:6656,end:6687},{begin:11264,end:11359},{begin:11568,end:11647},{begin:19904,end:19967},{begin:43008,end:43055},{begin:65536,end:65663},{begin:65856,end:65935},{begin:66432,end:66463},{begin:66464,end:66527},{begin:66640,end:66687},{begin:66688,end:66735},{begin:67584,end:67647},{begin:68096,end:68191},{begin:119552,end:119647},{begin:73728,end:74751},{begin:119648,end:119679},{begin:7040,end:7103},{begin:7168,end:7247},{begin:7248,end:7295},{begin:43136,end:43231},{begin:43264,end:43311},{begin:43312,end:43359},{begin:43520,end:43615},{begin:65936,end:65999},{begin:66e3,end:66047},{begin:66208,end:66271},{begin:127024,end:127135}];function getUnicodeRangeFor(e){for(let t=0,r=n.length;t<r;t++){const r=n[t];if(e>=r.begin&&e<r.end)return t}return-1}const s=(0,a.getArrayLookupTableFactory)((function(){return["¨"," ̈","¯"," ̄","´"," ́","µ","μ","¸"," ̧","Ĳ","IJ","ĳ","ij","Ŀ","L·","ŀ","l·","ŉ","ʼn","ſ","s","Ǆ","DŽ","ǅ","Dž","ǆ","dž","Ǉ","LJ","ǈ","Lj","ǉ","lj","Ǌ","NJ","ǋ","Nj","ǌ","nj","Ǳ","DZ","ǲ","Dz","ǳ","dz","˘"," ̆","˙"," ̇","˚"," ̊","˛"," ̨","˜"," ̃","˝"," ̋","ͺ"," ͅ","΄"," ́","ϐ","β","ϑ","θ","ϒ","Υ","ϕ","φ","ϖ","π","ϰ","κ","ϱ","ρ","ϲ","ς","ϴ","Θ","ϵ","ε","Ϲ","Σ","և","եւ","ٵ","اٴ","ٶ","وٴ","ٷ","ۇٴ","ٸ","يٴ","ำ","ํา","ຳ","ໍາ","ໜ","ຫນ","ໝ","ຫມ","ཷ","ྲཱྀ","ཹ","ླཱྀ","ẚ","aʾ","᾽"," ̓","᾿"," ̓","῀"," ͂","῾"," ̔"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","‗"," ̳","․",".","‥","..","…","...","″","′′","‴","′′′","‶","‵‵","‷","‵‵‵","‼","!!","‾"," ̅","⁇","??","⁈","?!","⁉","!?","⁗","′′′′"," "," ","₨","Rs","℀","a/c","℁","a/s","℃","°C","℅","c/o","℆","c/u","ℇ","Ɛ","℉","°F","№","No","℡","TEL","ℵ","א","ℶ","ב","ℷ","ג","ℸ","ד","℻","FAX","Ⅰ","I","Ⅱ","II","Ⅲ","III","Ⅳ","IV","Ⅴ","V","Ⅵ","VI","Ⅶ","VII","Ⅷ","VIII","Ⅸ","IX","Ⅹ","X","Ⅺ","XI","Ⅻ","XII","Ⅼ","L","Ⅽ","C","Ⅾ","D","Ⅿ","M","ⅰ","i","ⅱ","ii","ⅲ","iii","ⅳ","iv","ⅴ","v","ⅵ","vi","ⅶ","vii","ⅷ","viii","ⅸ","ix","ⅹ","x","ⅺ","xi","ⅻ","xii","ⅼ","l","ⅽ","c","ⅾ","d","ⅿ","m","∬","∫∫","∭","∫∫∫","∯","∮∮","∰","∮∮∮","⑴","(1)","⑵","(2)","⑶","(3)","⑷","(4)","⑸","(5)","⑹","(6)","⑺","(7)","⑻","(8)","⑼","(9)","⑽","(10)","⑾","(11)","⑿","(12)","⒀","(13)","⒁","(14)","⒂","(15)","⒃","(16)","⒄","(17)","⒅","(18)","⒆","(19)","⒇","(20)","⒈","1.","⒉","2.","⒊","3.","⒋","4.","⒌","5.","⒍","6.","⒎","7.","⒏","8.","⒐","9.","⒑","10.","⒒","11.","⒓","12.","⒔","13.","⒕","14.","⒖","15.","⒗","16.","⒘","17.","⒙","18.","⒚","19.","⒛","20.","⒜","(a)","⒝","(b)","⒞","(c)","⒟","(d)","⒠","(e)","⒡","(f)","⒢","(g)","⒣","(h)","⒤","(i)","⒥","(j)","⒦","(k)","⒧","(l)","⒨","(m)","⒩","(n)","⒪","(o)","⒫","(p)","⒬","(q)","⒭","(r)","⒮","(s)","⒯","(t)","⒰","(u)","⒱","(v)","⒲","(w)","⒳","(x)","⒴","(y)","⒵","(z)","⨌","∫∫∫∫","⩴","::=","⩵","==","⩶","===","⺟","母","⻳","龟","⼀","一","⼁","丨","⼂","丶","⼃","丿","⼄","乙","⼅","亅","⼆","二","⼇","亠","⼈","人","⼉","儿","⼊","入","⼋","八","⼌","冂","⼍","冖","⼎","冫","⼏","几","⼐","凵","⼑","刀","⼒","力","⼓","勹","⼔","匕","⼕","匚","⼖","匸","⼗","十","⼘","卜","⼙","卩","⼚","厂","⼛","厶","⼜","又","⼝","口","⼞","囗","⼟","土","⼠","士","⼡","夂","⼢","夊","⼣","夕","⼤","大","⼥","女","⼦","子","⼧","宀","⼨","寸","⼩","小","⼪","尢","⼫","尸","⼬","屮","⼭","山","⼮","巛","⼯","工","⼰","己","⼱","巾","⼲","干","⼳","幺","⼴","广","⼵","廴","⼶","廾","⼷","弋","⼸","弓","⼹","彐","⼺","彡","⼻","彳","⼼","心","⼽","戈","⼾","戶","⼿","手","⽀","支","⽁","攴","⽂","文","⽃","斗","⽄","斤","⽅","方","⽆","无","⽇","日","⽈","曰","⽉","月","⽊","木","⽋","欠","⽌","止","⽍","歹","⽎","殳","⽏","毋","⽐","比","⽑","毛","⽒","氏","⽓","气","⽔","水","⽕","火","⽖","爪","⽗","父","⽘","爻","⽙","爿","⽚","片","⽛","牙","⽜","牛","⽝","犬","⽞","玄","⽟","玉","⽠","瓜","⽡","瓦","⽢","甘","⽣","生","⽤","用","⽥","田","⽦","疋","⽧","疒","⽨","癶","⽩","白","⽪","皮","⽫","皿","⽬","目","⽭","矛","⽮","矢","⽯","石","⽰","示","⽱","禸","⽲","禾","⽳","穴","⽴","立","⽵","竹","⽶","米","⽷","糸","⽸","缶","⽹","网","⽺","羊","⽻","羽","⽼","老","⽽","而","⽾","耒","⽿","耳","⾀","聿","⾁","肉","⾂","臣","⾃","自","⾄","至","⾅","臼","⾆","舌","⾇","舛","⾈","舟","⾉","艮","⾊","色","⾋","艸","⾌","虍","⾍","虫","⾎","血","⾏","行","⾐","衣","⾑","襾","⾒","見","⾓","角","⾔","言","⾕","谷","⾖","豆","⾗","豕","⾘","豸","⾙","貝","⾚","赤","⾛","走","⾜","足","⾝","身","⾞","車","⾟","辛","⾠","辰","⾡","辵","⾢","邑","⾣","酉","⾤","釆","⾥","里","⾦","金","⾧","長","⾨","門","⾩","阜","⾪","隶","⾫","隹","⾬","雨","⾭","靑","⾮","非","⾯","面","⾰","革","⾱","韋","⾲","韭","⾳","音","⾴","頁","⾵","風","⾶","飛","⾷","食","⾸","首","⾹","香","⾺","馬","⾻","骨","⾼","高","⾽","髟","⾾","鬥","⾿","鬯","⿀","鬲","⿁","鬼","⿂","魚","⿃","鳥","⿄","鹵","⿅","鹿","⿆","麥","⿇","麻","⿈","黃","⿉","黍","⿊","黑","⿋","黹","⿌","黽","⿍","鼎","⿎","鼓","⿏","鼠","⿐","鼻","⿑","齊","⿒","齒","⿓","龍","⿔","龜","⿕","龠","〶","〒","〸","十","〹","卄","〺","卅","゛"," ゙","゜"," ゚","ㄱ","ᄀ","ㄲ","ᄁ","ㄳ","ᆪ","ㄴ","ᄂ","ㄵ","ᆬ","ㄶ","ᆭ","ㄷ","ᄃ","ㄸ","ᄄ","ㄹ","ᄅ","ㄺ","ᆰ","ㄻ","ᆱ","ㄼ","ᆲ","ㄽ","ᆳ","ㄾ","ᆴ","ㄿ","ᆵ","ㅀ","ᄚ","ㅁ","ᄆ","ㅂ","ᄇ","ㅃ","ᄈ","ㅄ","ᄡ","ㅅ","ᄉ","ㅆ","ᄊ","ㅇ","ᄋ","ㅈ","ᄌ","ㅉ","ᄍ","ㅊ","ᄎ","ㅋ","ᄏ","ㅌ","ᄐ","ㅍ","ᄑ","ㅎ","ᄒ","ㅏ","ᅡ","ㅐ","ᅢ","ㅑ","ᅣ","ㅒ","ᅤ","ㅓ","ᅥ","ㅔ","ᅦ","ㅕ","ᅧ","ㅖ","ᅨ","ㅗ","ᅩ","ㅘ","ᅪ","ㅙ","ᅫ","ㅚ","ᅬ","ㅛ","ᅭ","ㅜ","ᅮ","ㅝ","ᅯ","ㅞ","ᅰ","ㅟ","ᅱ","ㅠ","ᅲ","ㅡ","ᅳ","ㅢ","ᅴ","ㅣ","ᅵ","ㅤ","ᅠ","ㅥ","ᄔ","ㅦ","ᄕ","ㅧ","ᇇ","ㅨ","ᇈ","ㅩ","ᇌ","ㅪ","ᇎ","ㅫ","ᇓ","ㅬ","ᇗ","ㅭ","ᇙ","ㅮ","ᄜ","ㅯ","ᇝ","ㅰ","ᇟ","ㅱ","ᄝ","ㅲ","ᄞ","ㅳ","ᄠ","ㅴ","ᄢ","ㅵ","ᄣ","ㅶ","ᄧ","ㅷ","ᄩ","ㅸ","ᄫ","ㅹ","ᄬ","ㅺ","ᄭ","ㅻ","ᄮ","ㅼ","ᄯ","ㅽ","ᄲ","ㅾ","ᄶ","ㅿ","ᅀ","ㆀ","ᅇ","ㆁ","ᅌ","ㆂ","ᇱ","ㆃ","ᇲ","ㆄ","ᅗ","ㆅ","ᅘ","ㆆ","ᅙ","ㆇ","ᆄ","ㆈ","ᆅ","ㆉ","ᆈ","ㆊ","ᆑ","ㆋ","ᆒ","ㆌ","ᆔ","ㆍ","ᆞ","ㆎ","ᆡ","㈀","(ᄀ)","㈁","(ᄂ)","㈂","(ᄃ)","㈃","(ᄅ)","㈄","(ᄆ)","㈅","(ᄇ)","㈆","(ᄉ)","㈇","(ᄋ)","㈈","(ᄌ)","㈉","(ᄎ)","㈊","(ᄏ)","㈋","(ᄐ)","㈌","(ᄑ)","㈍","(ᄒ)","㈎","(가)","㈏","(나)","㈐","(다)","㈑","(라)","㈒","(마)","㈓","(바)","㈔","(사)","㈕","(아)","㈖","(자)","㈗","(차)","㈘","(카)","㈙","(타)","㈚","(파)","㈛","(하)","㈜","(주)","㈝","(오전)","㈞","(오후)","㈠","(一)","㈡","(二)","㈢","(三)","㈣","(四)","㈤","(五)","㈥","(六)","㈦","(七)","㈧","(八)","㈨","(九)","㈩","(十)","㈪","(月)","㈫","(火)","㈬","(水)","㈭","(木)","㈮","(金)","㈯","(土)","㈰","(日)","㈱","(株)","㈲","(有)","㈳","(社)","㈴","(名)","㈵","(特)","㈶","(財)","㈷","(祝)","㈸","(労)","㈹","(代)","㈺","(呼)","㈻","(学)","㈼","(監)","㈽","(企)","㈾","(資)","㈿","(協)","㉀","(祭)","㉁","(休)","㉂","(自)","㉃","(至)","㋀","1月","㋁","2月","㋂","3月","㋃","4月","㋄","5月","㋅","6月","㋆","7月","㋇","8月","㋈","9月","㋉","10月","㋊","11月","㋋","12月","㍘","0点","㍙","1点","㍚","2点","㍛","3点","㍜","4点","㍝","5点","㍞","6点","㍟","7点","㍠","8点","㍡","9点","㍢","10点","㍣","11点","㍤","12点","㍥","13点","㍦","14点","㍧","15点","㍨","16点","㍩","17点","㍪","18点","㍫","19点","㍬","20点","㍭","21点","㍮","22点","㍯","23点","㍰","24点","㏠","1日","㏡","2日","㏢","3日","㏣","4日","㏤","5日","㏥","6日","㏦","7日","㏧","8日","㏨","9日","㏩","10日","㏪","11日","㏫","12日","㏬","13日","㏭","14日","㏮","15日","㏯","16日","㏰","17日","㏱","18日","㏲","19日","㏳","20日","㏴","21日","㏵","22日","㏶","23日","㏷","24日","㏸","25日","㏹","26日","㏺","27日","㏻","28日","㏼","29日","㏽","30日","㏾","31日","ﬀ","ff","ﬁ","fi","ﬂ","fl","ﬃ","ffi","ﬄ","ffl","ﬅ","ſt","ﬆ","st","ﬓ","մն","ﬔ","մե","ﬕ","մի","ﬖ","վն","ﬗ","մխ","ﭏ","אל","ﭐ","ٱ","ﭑ","ٱ","ﭒ","ٻ","ﭓ","ٻ","ﭔ","ٻ","ﭕ","ٻ","ﭖ","پ","ﭗ","پ","ﭘ","پ","ﭙ","پ","ﭚ","ڀ","ﭛ","ڀ","ﭜ","ڀ","ﭝ","ڀ","ﭞ","ٺ","ﭟ","ٺ","ﭠ","ٺ","ﭡ","ٺ","ﭢ","ٿ","ﭣ","ٿ","ﭤ","ٿ","ﭥ","ٿ","ﭦ","ٹ","ﭧ","ٹ","ﭨ","ٹ","ﭩ","ٹ","ﭪ","ڤ","ﭫ","ڤ","ﭬ","ڤ","ﭭ","ڤ","ﭮ","ڦ","ﭯ","ڦ","ﭰ","ڦ","ﭱ","ڦ","ﭲ","ڄ","ﭳ","ڄ","ﭴ","ڄ","ﭵ","ڄ","ﭶ","ڃ","ﭷ","ڃ","ﭸ","ڃ","ﭹ","ڃ","ﭺ","چ","ﭻ","چ","ﭼ","چ","ﭽ","چ","ﭾ","ڇ","ﭿ","ڇ","ﮀ","ڇ","ﮁ","ڇ","ﮂ","ڍ","ﮃ","ڍ","ﮄ","ڌ","ﮅ","ڌ","ﮆ","ڎ","ﮇ","ڎ","ﮈ","ڈ","ﮉ","ڈ","ﮊ","ژ","ﮋ","ژ","ﮌ","ڑ","ﮍ","ڑ","ﮎ","ک","ﮏ","ک","ﮐ","ک","ﮑ","ک","ﮒ","گ","ﮓ","گ","ﮔ","گ","ﮕ","گ","ﮖ","ڳ","ﮗ","ڳ","ﮘ","ڳ","ﮙ","ڳ","ﮚ","ڱ","ﮛ","ڱ","ﮜ","ڱ","ﮝ","ڱ","ﮞ","ں","ﮟ","ں","ﮠ","ڻ","ﮡ","ڻ","ﮢ","ڻ","ﮣ","ڻ","ﮤ","ۀ","ﮥ","ۀ","ﮦ","ہ","ﮧ","ہ","ﮨ","ہ","ﮩ","ہ","ﮪ","ھ","ﮫ","ھ","ﮬ","ھ","ﮭ","ھ","ﮮ","ے","ﮯ","ے","ﮰ","ۓ","ﮱ","ۓ","ﯓ","ڭ","ﯔ","ڭ","ﯕ","ڭ","ﯖ","ڭ","ﯗ","ۇ","ﯘ","ۇ","ﯙ","ۆ","ﯚ","ۆ","ﯛ","ۈ","ﯜ","ۈ","ﯝ","ٷ","ﯞ","ۋ","ﯟ","ۋ","ﯠ","ۅ","ﯡ","ۅ","ﯢ","ۉ","ﯣ","ۉ","ﯤ","ې","ﯥ","ې","ﯦ","ې","ﯧ","ې","ﯨ","ى","ﯩ","ى","ﯪ","ئا","ﯫ","ئا","ﯬ","ئە","ﯭ","ئە","ﯮ","ئو","ﯯ","ئو","ﯰ","ئۇ","ﯱ","ئۇ","ﯲ","ئۆ","ﯳ","ئۆ","ﯴ","ئۈ","ﯵ","ئۈ","ﯶ","ئې","ﯷ","ئې","ﯸ","ئې","ﯹ","ئى","ﯺ","ئى","ﯻ","ئى","ﯼ","ی","ﯽ","ی","ﯾ","ی","ﯿ","ی","ﰀ","ئج","ﰁ","ئح","ﰂ","ئم","ﰃ","ئى","ﰄ","ئي","ﰅ","بج","ﰆ","بح","ﰇ","بخ","ﰈ","بم","ﰉ","بى","ﰊ","بي","ﰋ","تج","ﰌ","تح","ﰍ","تخ","ﰎ","تم","ﰏ","تى","ﰐ","تي","ﰑ","ثج","ﰒ","ثم","ﰓ","ثى","ﰔ","ثي","ﰕ","جح","ﰖ","جم","ﰗ","حج","ﰘ","حم","ﰙ","خج","ﰚ","خح","ﰛ","خم","ﰜ","سج","ﰝ","سح","ﰞ","سخ","ﰟ","سم","ﰠ","صح","ﰡ","صم","ﰢ","ضج","ﰣ","ضح","ﰤ","ضخ","ﰥ","ضم","ﰦ","طح","ﰧ","طم","ﰨ","ظم","ﰩ","عج","ﰪ","عم","ﰫ","غج","ﰬ","غم","ﰭ","فج","ﰮ","فح","ﰯ","فخ","ﰰ","فم","ﰱ","فى","ﰲ","في","ﰳ","قح","ﰴ","قم","ﰵ","قى","ﰶ","قي","ﰷ","كا","ﰸ","كج","ﰹ","كح","ﰺ","كخ","ﰻ","كل","ﰼ","كم","ﰽ","كى","ﰾ","كي","ﰿ","لج","ﱀ","لح","ﱁ","لخ","ﱂ","لم","ﱃ","لى","ﱄ","لي","ﱅ","مج","ﱆ","مح","ﱇ","مخ","ﱈ","مم","ﱉ","مى","ﱊ","مي","ﱋ","نج","ﱌ","نح","ﱍ","نخ","ﱎ","نم","ﱏ","نى","ﱐ","ني","ﱑ","هج","ﱒ","هم","ﱓ","هى","ﱔ","هي","ﱕ","يج","ﱖ","يح","ﱗ","يخ","ﱘ","يم","ﱙ","يى","ﱚ","يي","ﱛ","ذٰ","ﱜ","رٰ","ﱝ","ىٰ","ﱞ"," ٌّ","ﱟ"," ٍّ","ﱠ"," َّ","ﱡ"," ُّ","ﱢ"," ِّ","ﱣ"," ّٰ","ﱤ","ئر","ﱥ","ئز","ﱦ","ئم","ﱧ","ئن","ﱨ","ئى","ﱩ","ئي","ﱪ","بر","ﱫ","بز","ﱬ","بم","ﱭ","بن","ﱮ","بى","ﱯ","بي","ﱰ","تر","ﱱ","تز","ﱲ","تم","ﱳ","تن","ﱴ","تى","ﱵ","تي","ﱶ","ثر","ﱷ","ثز","ﱸ","ثم","ﱹ","ثن","ﱺ","ثى","ﱻ","ثي","ﱼ","فى","ﱽ","في","ﱾ","قى","ﱿ","قي","ﲀ","كا","ﲁ","كل","ﲂ","كم","ﲃ","كى","ﲄ","كي","ﲅ","لم","ﲆ","لى","ﲇ","لي","ﲈ","ما","ﲉ","مم","ﲊ","نر","ﲋ","نز","ﲌ","نم","ﲍ","نن","ﲎ","نى","ﲏ","ني","ﲐ","ىٰ","ﲑ","ير","ﲒ","يز","ﲓ","يم","ﲔ","ين","ﲕ","يى","ﲖ","يي","ﲗ","ئج","ﲘ","ئح","ﲙ","ئخ","ﲚ","ئم","ﲛ","ئه","ﲜ","بج","ﲝ","بح","ﲞ","بخ","ﲟ","بم","ﲠ","به","ﲡ","تج","ﲢ","تح","ﲣ","تخ","ﲤ","تم","ﲥ","ته","ﲦ","ثم","ﲧ","جح","ﲨ","جم","ﲩ","حج","ﲪ","حم","ﲫ","خج","ﲬ","خم","ﲭ","سج","ﲮ","سح","ﲯ","سخ","ﲰ","سم","ﲱ","صح","ﲲ","صخ","ﲳ","صم","ﲴ","ضج","ﲵ","ضح","ﲶ","ضخ","ﲷ","ضم","ﲸ","طح","ﲹ","ظم","ﲺ","عج","ﲻ","عم","ﲼ","غج","ﲽ","غم","ﲾ","فج","ﲿ","فح","ﳀ","فخ","ﳁ","فم","ﳂ","قح","ﳃ","قم","ﳄ","كج","ﳅ","كح","ﳆ","كخ","ﳇ","كل","ﳈ","كم","ﳉ","لج","ﳊ","لح","ﳋ","لخ","ﳌ","لم","ﳍ","له","ﳎ","مج","ﳏ","مح","ﳐ","مخ","ﳑ","مم","ﳒ","نج","ﳓ","نح","ﳔ","نخ","ﳕ","نم","ﳖ","نه","ﳗ","هج","ﳘ","هم","ﳙ","هٰ","ﳚ","يج","ﳛ","يح","ﳜ","يخ","ﳝ","يم","ﳞ","يه","ﳟ","ئم","ﳠ","ئه","ﳡ","بم","ﳢ","به","ﳣ","تم","ﳤ","ته","ﳥ","ثم","ﳦ","ثه","ﳧ","سم","ﳨ","سه","ﳩ","شم","ﳪ","شه","ﳫ","كل","ﳬ","كم","ﳭ","لم","ﳮ","نم","ﳯ","نه","ﳰ","يم","ﳱ","يه","ﳲ","ـَّ","ﳳ","ـُّ","ﳴ","ـِّ","ﳵ","طى","ﳶ","طي","ﳷ","عى","ﳸ","عي","ﳹ","غى","ﳺ","غي","ﳻ","سى","ﳼ","سي","ﳽ","شى","ﳾ","شي","ﳿ","حى","ﴀ","حي","ﴁ","جى","ﴂ","جي","ﴃ","خى","ﴄ","خي","ﴅ","صى","ﴆ","صي","ﴇ","ضى","ﴈ","ضي","ﴉ","شج","ﴊ","شح","ﴋ","شخ","ﴌ","شم","ﴍ","شر","ﴎ","سر","ﴏ","صر","ﴐ","ضر","ﴑ","طى","ﴒ","طي","ﴓ","عى","ﴔ","عي","ﴕ","غى","ﴖ","غي","ﴗ","سى","ﴘ","سي","ﴙ","شى","ﴚ","شي","ﴛ","حى","ﴜ","حي","ﴝ","جى","ﴞ","جي","ﴟ","خى","ﴠ","خي","ﴡ","صى","ﴢ","صي","ﴣ","ضى","ﴤ","ضي","ﴥ","شج","ﴦ","شح","ﴧ","شخ","ﴨ","شم","ﴩ","شر","ﴪ","سر","ﴫ","صر","ﴬ","ضر","ﴭ","شج","ﴮ","شح","ﴯ","شخ","ﴰ","شم","ﴱ","سه","ﴲ","شه","ﴳ","طم","ﴴ","سج","ﴵ","سح","ﴶ","سخ","ﴷ","شج","ﴸ","شح","ﴹ","شخ","ﴺ","طم","ﴻ","ظم","ﴼ","اً","ﴽ","اً","ﵐ","تجم","ﵑ","تحج","ﵒ","تحج","ﵓ","تحم","ﵔ","تخم","ﵕ","تمج","ﵖ","تمح","ﵗ","تمخ","ﵘ","جمح","ﵙ","جمح","ﵚ","حمي","ﵛ","حمى","ﵜ","سحج","ﵝ","سجح","ﵞ","سجى","ﵟ","سمح","ﵠ","سمح","ﵡ","سمج","ﵢ","سمم","ﵣ","سمم","ﵤ","صحح","ﵥ","صحح","ﵦ","صمم","ﵧ","شحم","ﵨ","شحم","ﵩ","شجي","ﵪ","شمخ","ﵫ","شمخ","ﵬ","شمم","ﵭ","شمم","ﵮ","ضحى","ﵯ","ضخم","ﵰ","ضخم","ﵱ","طمح","ﵲ","طمح","ﵳ","طمم","ﵴ","طمي","ﵵ","عجم","ﵶ","عمم","ﵷ","عمم","ﵸ","عمى","ﵹ","غمم","ﵺ","غمي","ﵻ","غمى","ﵼ","فخم","ﵽ","فخم","ﵾ","قمح","ﵿ","قمم","ﶀ","لحم","ﶁ","لحي","ﶂ","لحى","ﶃ","لجج","ﶄ","لجج","ﶅ","لخم","ﶆ","لخم","ﶇ","لمح","ﶈ","لمح","ﶉ","محج","ﶊ","محم","ﶋ","محي","ﶌ","مجح","ﶍ","مجم","ﶎ","مخج","ﶏ","مخم","ﶒ","مجخ","ﶓ","همج","ﶔ","همم","ﶕ","نحم","ﶖ","نحى","ﶗ","نجم","ﶘ","نجم","ﶙ","نجى","ﶚ","نمي","ﶛ","نمى","ﶜ","يمم","ﶝ","يمم","ﶞ","بخي","ﶟ","تجي","ﶠ","تجى","ﶡ","تخي","ﶢ","تخى","ﶣ","تمي","ﶤ","تمى","ﶥ","جمي","ﶦ","جحى","ﶧ","جمى","ﶨ","سخى","ﶩ","صحي","ﶪ","شحي","ﶫ","ضحي","ﶬ","لجي","ﶭ","لمي","ﶮ","يحي","ﶯ","يجي","ﶰ","يمي","ﶱ","ممي","ﶲ","قمي","ﶳ","نحي","ﶴ","قمح","ﶵ","لحم","ﶶ","عمي","ﶷ","كمي","ﶸ","نجح","ﶹ","مخي","ﶺ","لجم","ﶻ","كمم","ﶼ","لجم","ﶽ","نجح","ﶾ","جحي","ﶿ","حجي","ﷀ","مجي","ﷁ","فمي","ﷂ","بحي","ﷃ","كمم","ﷄ","عجم","ﷅ","صمم","ﷆ","سخي","ﷇ","نجي","﹉","‾","﹊","‾","﹋","‾","﹌","‾","﹍","_","﹎","_","﹏","_","ﺀ","ء","ﺁ","آ","ﺂ","آ","ﺃ","أ","ﺄ","أ","ﺅ","ؤ","ﺆ","ؤ","ﺇ","إ","ﺈ","إ","ﺉ","ئ","ﺊ","ئ","ﺋ","ئ","ﺌ","ئ","ﺍ","ا","ﺎ","ا","ﺏ","ب","ﺐ","ب","ﺑ","ب","ﺒ","ب","ﺓ","ة","ﺔ","ة","ﺕ","ت","ﺖ","ت","ﺗ","ت","ﺘ","ت","ﺙ","ث","ﺚ","ث","ﺛ","ث","ﺜ","ث","ﺝ","ج","ﺞ","ج","ﺟ","ج","ﺠ","ج","ﺡ","ح","ﺢ","ح","ﺣ","ح","ﺤ","ح","ﺥ","خ","ﺦ","خ","ﺧ","خ","ﺨ","خ","ﺩ","د","ﺪ","د","ﺫ","ذ","ﺬ","ذ","ﺭ","ر","ﺮ","ر","ﺯ","ز","ﺰ","ز","ﺱ","س","ﺲ","س","ﺳ","س","ﺴ","س","ﺵ","ش","ﺶ","ش","ﺷ","ش","ﺸ","ش","ﺹ","ص","ﺺ","ص","ﺻ","ص","ﺼ","ص","ﺽ","ض","ﺾ","ض","ﺿ","ض","ﻀ","ض","ﻁ","ط","ﻂ","ط","ﻃ","ط","ﻄ","ط","ﻅ","ظ","ﻆ","ظ","ﻇ","ظ","ﻈ","ظ","ﻉ","ع","ﻊ","ع","ﻋ","ع","ﻌ","ع","ﻍ","غ","ﻎ","غ","ﻏ","غ","ﻐ","غ","ﻑ","ف","ﻒ","ف","ﻓ","ف","ﻔ","ف","ﻕ","ق","ﻖ","ق","ﻗ","ق","ﻘ","ق","ﻙ","ك","ﻚ","ك","ﻛ","ك","ﻜ","ك","ﻝ","ل","ﻞ","ل","ﻟ","ل","ﻠ","ل","ﻡ","م","ﻢ","م","ﻣ","م","ﻤ","م","ﻥ","ن","ﻦ","ن","ﻧ","ن","ﻨ","ن","ﻩ","ه","ﻪ","ه","ﻫ","ه","ﻬ","ه","ﻭ","و","ﻮ","و","ﻯ","ى","ﻰ","ى","ﻱ","ي","ﻲ","ي","ﻳ","ي","ﻴ","ي","ﻵ","لآ","ﻶ","لآ","ﻷ","لأ","ﻸ","لأ","ﻹ","لإ","ﻺ","لإ","ﻻ","لا","ﻼ","لا"]}));function reverseIfRtl(e){const t=e.length;if(t<=1||!function isRTLRangeFor(e){let t=n[13];if(e>=t.begin&&e<t.end)return!0;t=n[11];return e>=t.begin&&e<t.end}(e.charCodeAt(0)))return e;const r=[];for(let a=t-1;a>=0;a--)r.push(e[a]);return r.join("")}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.FontRendererFactory=void 0;var a=r(2),i=r(32),n=r(35),s=r(34),o=r(12);const c=function FontRendererFactoryClosure(){function getLong(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}function getUshort(e,t){return e[t]<<8|e[t+1]}function getSubroutineBias(e){const t=e.length;let r=32768;t<1240?r=107:t<33900&&(r=1131);return r}function parseCmap(e,t,r){const i=1===getUshort(e,t+2)?getLong(e,t+8):getLong(e,t+16),n=getUshort(e,t+i);let s,o,c;if(4===n){getUshort(e,t+i+2);const r=getUshort(e,t+i+6)>>1;o=t+i+14;s=[];for(c=0;c<r;c++,o+=2)s[c]={end:getUshort(e,o)};o+=2;for(c=0;c<r;c++,o+=2)s[c].start=getUshort(e,o);for(c=0;c<r;c++,o+=2)s[c].idDelta=getUshort(e,o);for(c=0;c<r;c++,o+=2){let t=getUshort(e,o);if(0!==t){s[c].ids=[];for(let r=0,a=s[c].end-s[c].start+1;r<a;r++){s[c].ids[r]=getUshort(e,o+t);t+=2}}}return s}if(12===n){getLong(e,t+i+4);const r=getLong(e,t+i+12);o=t+i+16;s=[];for(c=0;c<r;c++){s.push({start:getLong(e,o),end:getLong(e,o+4),idDelta:getLong(e,o+8)-getLong(e,o)});o+=12}return s}throw new a.FormatError(`unsupported cmap: ${n}`)}function parseCff(e,t,r,a){const n=new i.CFFParser(new o.Stream(e,t,r-t),{},a).parse();return{glyphs:n.charStrings.objects,subrs:n.topDict.privateDict&&n.topDict.privateDict.subrsIndex&&n.topDict.privateDict.subrsIndex.objects,gsubrs:n.globalSubrIndex&&n.globalSubrIndex.objects,isCFFCIDFont:n.isCIDFont,fdSelect:n.fdSelect,fdArray:n.fdArray}}function lookupCmap(e,t){const r=t.codePointAt(0);let a=0,i=0,n=e.length-1;for(;i<n;){const t=i+n+1>>1;r<e[t].start?n=t-1:i=t}e[i].start<=r&&r<=e[i].end&&(a=e[i].idDelta+(e[i].ids?e[i].ids[r-e[i].start]:r)&65535);return{charCode:r,glyphId:a}}function compileGlyf(e,t,r){function moveTo(e,r){t.push({cmd:"moveTo",args:[e,r]})}function lineTo(e,r){t.push({cmd:"lineTo",args:[e,r]})}function quadraticCurveTo(e,r,a,i){t.push({cmd:"quadraticCurveTo",args:[e,r,a,i]})}let a=0;const i=(e[a]<<24|e[a+1]<<16)>>16;let n,s=0,o=0;a+=10;if(i<0)do{n=e[a]<<8|e[a+1];const i=e[a+2]<<8|e[a+3];a+=4;let c,l;if(1&n){c=(e[a]<<24|e[a+1]<<16)>>16;l=(e[a+2]<<24|e[a+3]<<16)>>16;a+=4}else{c=e[a++];l=e[a++]}if(2&n){s=c;o=l}else{s=0;o=0}let h=1,u=1,d=0,f=0;if(8&n){h=u=(e[a]<<24|e[a+1]<<16)/1073741824;a+=2}else if(64&n){h=(e[a]<<24|e[a+1]<<16)/1073741824;u=(e[a+2]<<24|e[a+3]<<16)/1073741824;a+=4}else if(128&n){h=(e[a]<<24|e[a+1]<<16)/1073741824;d=(e[a+2]<<24|e[a+3]<<16)/1073741824;f=(e[a+4]<<24|e[a+5]<<16)/1073741824;u=(e[a+6]<<24|e[a+7]<<16)/1073741824;a+=8}const g=r.glyphs[i];if(g){t.push({cmd:"save"});t.push({cmd:"transform",args:[h,d,f,u,s,o]});compileGlyf(g,t,r);t.push({cmd:"restore"})}}while(32&n);else{const t=[];let r,c;for(r=0;r<i;r++){t.push(e[a]<<8|e[a+1]);a+=2}a+=2+(e[a]<<8|e[a+1]);const l=t[t.length-1]+1,h=[];for(;h.length<l;){n=e[a++];let t=1;8&n&&(t+=e[a++]);for(;t-- >0;)h.push({flags:n})}for(r=0;r<l;r++){switch(18&h[r].flags){case 0:s+=(e[a]<<24|e[a+1]<<16)>>16;a+=2;break;case 2:s-=e[a++];break;case 18:s+=e[a++]}h[r].x=s}for(r=0;r<l;r++){switch(36&h[r].flags){case 0:o+=(e[a]<<24|e[a+1]<<16)>>16;a+=2;break;case 4:o-=e[a++];break;case 36:o+=e[a++]}h[r].y=o}let u=0;for(a=0;a<i;a++){const e=t[a],i=h.slice(u,e+1);if(1&i[0].flags)i.push(i[0]);else if(1&i[i.length-1].flags)i.unshift(i[i.length-1]);else{const e={flags:1,x:(i[0].x+i[i.length-1].x)/2,y:(i[0].y+i[i.length-1].y)/2};i.unshift(e);i.push(e)}moveTo(i[0].x,i[0].y);for(r=1,c=i.length;r<c;r++)if(1&i[r].flags)lineTo(i[r].x,i[r].y);else if(1&i[r+1].flags){quadraticCurveTo(i[r].x,i[r].y,i[r+1].x,i[r+1].y);r++}else quadraticCurveTo(i[r].x,i[r].y,(i[r].x+i[r+1].x)/2,(i[r].y+i[r+1].y)/2);u=e+1}}}function compileCharString(e,t,r,i){function moveTo(e,r){t.push({cmd:"moveTo",args:[e,r]})}function lineTo(e,r){t.push({cmd:"lineTo",args:[e,r]})}function bezierCurveTo(e,r,a,i,n,s){t.push({cmd:"bezierCurveTo",args:[e,r,a,i,n,s]})}const n=[];let o=0,c=0,l=0;!function parse(e){let h=0;for(;h<e.length;){let u,d,f,g,p,m,b,y,w,S=!1,v=e[h++];switch(v){case 1:case 3:l+=n.length>>1;S=!0;break;case 4:c+=n.pop();moveTo(o,c);S=!0;break;case 5:for(;n.length>0;){o+=n.shift();c+=n.shift();lineTo(o,c)}break;case 6:for(;n.length>0;){o+=n.shift();lineTo(o,c);if(0===n.length)break;c+=n.shift();lineTo(o,c)}break;case 7:for(;n.length>0;){c+=n.shift();lineTo(o,c);if(0===n.length)break;o+=n.shift();lineTo(o,c)}break;case 8:for(;n.length>0;){u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c)}break;case 10:y=n.pop();w=null;if(r.isCFFCIDFont){const e=r.fdSelect.getFDIndex(i);if(e>=0&&e<r.fdArray.length){const t=r.fdArray[e];let a;t.privateDict&&t.privateDict.subrsIndex&&(a=t.privateDict.subrsIndex.objects);if(a){y+=getSubroutineBias(a);w=a[y]}}else(0,a.warn)("Invalid fd index for glyph index.")}else w=r.subrs[y+r.subrsBias];w&&parse(w);break;case 11:return;case 12:v=e[h++];switch(v){case 34:u=o+n.shift();d=u+n.shift();p=c+n.shift();o=d+n.shift();bezierCurveTo(u,c,d,p,o,p);u=o+n.shift();d=u+n.shift();o=d+n.shift();bezierCurveTo(u,p,d,c,o,c);break;case 35:u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c);u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c);n.pop();break;case 36:u=o+n.shift();p=c+n.shift();d=u+n.shift();m=p+n.shift();o=d+n.shift();bezierCurveTo(u,p,d,m,o,m);u=o+n.shift();d=u+n.shift();b=m+n.shift();o=d+n.shift();bezierCurveTo(u,m,d,b,o,c);break;case 37:const e=o,t=c;u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c);u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d;c=g;Math.abs(o-e)>Math.abs(c-t)?o+=n.shift():c+=n.shift();bezierCurveTo(u,f,d,g,o,c);break;default:throw new a.FormatError(`unknown operator: 12 ${v}`)}break;case 14:if(n.length>=4){const e=n.pop(),a=n.pop();c=n.pop();o=n.pop();t.push({cmd:"save"});t.push({cmd:"translate",args:[o,c]});let i=lookupCmap(r.cmap,String.fromCharCode(r.glyphNameMap[s.StandardEncoding[e]]));compileCharString(r.glyphs[i.glyphId],t,r,i.glyphId);t.push({cmd:"restore"});i=lookupCmap(r.cmap,String.fromCharCode(r.glyphNameMap[s.StandardEncoding[a]]));compileCharString(r.glyphs[i.glyphId],t,r,i.glyphId)}return;case 18:l+=n.length>>1;S=!0;break;case 19:case 20:l+=n.length>>1;h+=l+7>>3;S=!0;break;case 21:c+=n.pop();o+=n.pop();moveTo(o,c);S=!0;break;case 22:o+=n.pop();moveTo(o,c);S=!0;break;case 23:l+=n.length>>1;S=!0;break;case 24:for(;n.length>2;){u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c)}o+=n.shift();c+=n.shift();lineTo(o,c);break;case 25:for(;n.length>6;){o+=n.shift();c+=n.shift();lineTo(o,c)}u=o+n.shift();f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+n.shift();bezierCurveTo(u,f,d,g,o,c);break;case 26:n.length%2&&(o+=n.shift());for(;n.length>0;){u=o;f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d;c=g+n.shift();bezierCurveTo(u,f,d,g,o,c)}break;case 27:n.length%2&&(c+=n.shift());for(;n.length>0;){u=o+n.shift();f=c;d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g;bezierCurveTo(u,f,d,g,o,c)}break;case 28:n.push((e[h]<<24|e[h+1]<<16)>>16);h+=2;break;case 29:y=n.pop()+r.gsubrsBias;w=r.gsubrs[y];w&&parse(w);break;case 30:for(;n.length>0;){u=o;f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+(1===n.length?n.shift():0);bezierCurveTo(u,f,d,g,o,c);if(0===n.length)break;u=o+n.shift();f=c;d=u+n.shift();g=f+n.shift();c=g+n.shift();o=d+(1===n.length?n.shift():0);bezierCurveTo(u,f,d,g,o,c)}break;case 31:for(;n.length>0;){u=o+n.shift();f=c;d=u+n.shift();g=f+n.shift();c=g+n.shift();o=d+(1===n.length?n.shift():0);bezierCurveTo(u,f,d,g,o,c);if(0===n.length)break;u=o;f=c+n.shift();d=u+n.shift();g=f+n.shift();o=d+n.shift();c=g+(1===n.length?n.shift():0);bezierCurveTo(u,f,d,g,o,c)}break;default:if(v<32)throw new a.FormatError(`unknown operator: ${v}`);if(v<247)n.push(v-139);else if(v<251)n.push(256*(v-247)+e[h++]+108);else if(v<255)n.push(256*-(v-251)-e[h++]-108);else{n.push((e[h]<<24|e[h+1]<<16|e[h+2]<<8|e[h+3])/65536);h+=4}}S&&(n.length=0)}}(e)}const e=[];class CompiledFont{constructor(e){this.constructor===CompiledFont&&(0,a.unreachable)("Cannot initialize CompiledFont.");this.fontMatrix=e;this.compiledGlyphs=Object.create(null);this.compiledCharCodeToGlyphId=Object.create(null)}getPathJs(e){const t=lookupCmap(this.cmap,e);let r=this.compiledGlyphs[t.glyphId];if(!r){r=this.compileGlyph(this.glyphs[t.glyphId],t.glyphId);this.compiledGlyphs[t.glyphId]=r}void 0===this.compiledCharCodeToGlyphId[t.charCode]&&(this.compiledCharCodeToGlyphId[t.charCode]=t.glyphId);return r}compileGlyph(t,r){if(!t||0===t.length||14===t[0])return e;let i=this.fontMatrix;if(this.isCFFCIDFont){const e=this.fdSelect.getFDIndex(r);if(e>=0&&e<this.fdArray.length){i=this.fdArray[e].getByName("FontMatrix")||a.FONT_IDENTITY_MATRIX}else(0,a.warn)("Invalid fd index for glyph index.")}const n=[];n.push({cmd:"save"});n.push({cmd:"transform",args:i.slice()});n.push({cmd:"scale",args:["size","-size"]});this.compileGlyphImpl(t,n,r);n.push({cmd:"restore"});return n}compileGlyphImpl(){(0,a.unreachable)("Children classes should implement this.")}hasBuiltPath(e){const t=lookupCmap(this.cmap,e);return void 0!==this.compiledGlyphs[t.glyphId]&&void 0!==this.compiledCharCodeToGlyphId[t.charCode]}}class TrueTypeCompiled extends CompiledFont{constructor(e,t,r){super(r||[488e-6,0,0,488e-6,0,0]);this.glyphs=e;this.cmap=t}compileGlyphImpl(e,t){compileGlyf(e,t,this)}}class Type2Compiled extends CompiledFont{constructor(e,t,r,a){super(r||[.001,0,0,.001,0,0]);this.glyphs=e.glyphs;this.gsubrs=e.gsubrs||[];this.subrs=e.subrs||[];this.cmap=t;this.glyphNameMap=a||(0,n.getGlyphsUnicode)();this.gsubrsBias=getSubroutineBias(this.gsubrs);this.subrsBias=getSubroutineBias(this.subrs);this.isCFFCIDFont=e.isCFFCIDFont;this.fdSelect=e.fdSelect;this.fdArray=e.fdArray}compileGlyphImpl(e,t,r){compileCharString(e,t,this,r)}}return{create:function FontRendererFactory_create(e,t){const r=new Uint8Array(e.data);let i,n,s,o,c,l;const h=getUshort(r,4);for(let e=0,u=12;e<h;e++,u+=16){const e=(0,a.bytesToString)(r.subarray(u,u+4)),h=getLong(r,u+8),d=getLong(r,u+12);switch(e){case"cmap":i=parseCmap(r,h);break;case"glyf":n=r.subarray(h,h+d);break;case"loca":s=r.subarray(h,h+d);break;case"head":l=getUshort(r,h+18);c=getUshort(r,h+50);break;case"CFF ":o=parseCff(r,h,h+d,t)}}if(n){const t=l?[1/l,0,0,1/l,0,0]:e.fontMatrix;return new TrueTypeCompiled(function parseGlyfTable(e,t,r){let a,i;if(r){a=4;i=function fontItemDecodeLong(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}}else{a=2;i=function fontItemDecode(e,t){return e[t]<<9|e[t+1]<<1}}const n=[];let s=i(t,0);for(let r=a;r<t.length;r+=a){const a=i(t,r);n.push(e.subarray(s,a));s=a}return n}(n,s,c),i,t)}return new Type2Compiled(o,i,e.fontMatrix,e.glyphNameMap)}}}();t.FontRendererFactory=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Type1Parser=void 0;var a=r(34),i=r(8),n=r(12),s=r(2);const o=function Type1CharStringClosure(){const e=[4],t=[5],r=[6],a=[7],i=[8],n=[12,35],o=[14],c=[21],l=[22],h=[30],u=[31];return class Type1CharString{constructor(){this.width=0;this.lsb=0;this.flexing=!1;this.output=[];this.stack=[]}convert(d,f,g){const p=d.length;let m,b,y,w=!1;for(let S=0;S<p;S++){let p=d[S];if(p<32){12===p&&(p=(p<<8)+d[++S]);switch(p){case 1:case 3:this.stack=[];break;case 4:if(this.flexing){if(this.stack.length<1){w=!0;break}const e=this.stack.pop();this.stack.push(0,e);break}w=this.executeCommand(1,e);break;case 5:w=this.executeCommand(2,t);break;case 6:w=this.executeCommand(1,r);break;case 7:w=this.executeCommand(1,a);break;case 8:w=this.executeCommand(6,i);break;case 9:this.stack=[];break;case 10:if(this.stack.length<1){w=!0;break}y=this.stack.pop();if(!f[y]){w=!0;break}w=this.convert(f[y],f,g);break;case 11:return w;case 13:if(this.stack.length<2){w=!0;break}m=this.stack.pop();b=this.stack.pop();this.lsb=b;this.width=m;this.stack.push(m,b);w=this.executeCommand(2,l);break;case 14:this.output.push(o[0]);break;case 21:if(this.flexing)break;w=this.executeCommand(2,c);break;case 22:if(this.flexing){this.stack.push(0);break}w=this.executeCommand(1,l);break;case 30:w=this.executeCommand(4,h);break;case 31:w=this.executeCommand(4,u);break;case 3072:case 3073:case 3074:this.stack=[];break;case 3078:if(g){const e=this.stack[this.stack.length-5];this.seac=this.stack.splice(-4,4);this.seac[0]+=this.lsb-e;w=this.executeCommand(0,o)}else w=this.executeCommand(4,o);break;case 3079:if(this.stack.length<4){w=!0;break}this.stack.pop();m=this.stack.pop();const d=this.stack.pop();b=this.stack.pop();this.lsb=b;this.width=m;this.stack.push(m,b,d);w=this.executeCommand(3,c);break;case 3084:if(this.stack.length<2){w=!0;break}const S=this.stack.pop(),v=this.stack.pop();this.stack.push(v/S);break;case 3088:if(this.stack.length<2){w=!0;break}y=this.stack.pop();const k=this.stack.pop();if(0===y&&3===k){const e=this.stack.splice(this.stack.length-17,17);this.stack.push(e[2]+e[0],e[3]+e[1],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14]);w=this.executeCommand(13,n,!0);this.flexing=!1;this.stack.push(e[15],e[16])}else 1===y&&0===k&&(this.flexing=!0);break;case 3089:break;case 3105:this.stack=[];break;default:(0,s.warn)('Unknown type 1 charstring command of "'+p+'"')}if(w)break}else{p<=246?p-=139:p=p<=250?256*(p-247)+d[++S]+108:p<=254?-256*(p-251)-d[++S]-108:(255&d[++S])<<24|(255&d[++S])<<16|(255&d[++S])<<8|(255&d[++S])<<0;this.stack.push(p)}}return w}executeCommand(e,t,r){const a=this.stack.length;if(e>a)return!0;const i=a-e;for(let e=i;e<a;e++){let t=this.stack[e];if(Number.isInteger(t))this.output.push(28,t>>8&255,255&t);else{t=65536*t|0;this.output.push(255,t>>24&255,t>>16&255,t>>8&255,255&t)}}this.output.push.apply(this.output,t);r?this.stack.splice(i,e):this.stack.length=0;return!1}}}(),c=function Type1ParserClosure(){function isHexDigit(e){return e>=48&&e<=57||e>=65&&e<=70||e>=97&&e<=102}function decrypt(e,t,r){if(r>=e.length)return new Uint8Array(0);let a,i,n=0|t;for(a=0;a<r;a++)n=52845*(e[a]+n)+22719&65535;const s=e.length-r,o=new Uint8Array(s);for(a=r,i=0;i<s;a++,i++){const t=e[a];o[i]=t^n>>8;n=52845*(t+n)+22719&65535}return o}function isSpecial(e){return 47===e||91===e||93===e||123===e||125===e||40===e||41===e}return class Type1Parser{constructor(e,t,r){if(t){const t=e.getBytes(),r=!((isHexDigit(t[0])||(0,i.isWhiteSpace)(t[0]))&&isHexDigit(t[1])&&isHexDigit(t[2])&&isHexDigit(t[3])&&isHexDigit(t[4])&&isHexDigit(t[5])&&isHexDigit(t[6])&&isHexDigit(t[7]));e=new n.Stream(r?decrypt(t,55665,4):function decryptAscii(e,t,r){let a=0|t;const i=e.length,n=new Uint8Array(i>>>1);let s,o;for(s=0,o=0;s<i;s++){const t=e[s];if(!isHexDigit(t))continue;s++;let r;for(;s<i&&!isHexDigit(r=e[s]);)s++;if(s<i){const e=parseInt(String.fromCharCode(t,r),16);n[o++]=e^a>>8;a=52845*(e+a)+22719&65535}}return n.slice(r,o)}(t,55665,4))}this.seacAnalysisEnabled=!!r;this.stream=e;this.nextChar()}readNumberArray(){this.getToken();const e=[];for(;;){const t=this.getToken();if(null===t||"]"===t||"}"===t)break;e.push(parseFloat(t||0))}return e}readNumber(){const e=this.getToken();return parseFloat(e||0)}readInt(){const e=this.getToken();return 0|parseInt(e||0,10)}readBoolean(){return"true"===this.getToken()?1:0}nextChar(){return this.currentChar=this.stream.getByte()}getToken(){let e=!1,t=this.currentChar;for(;;){if(-1===t)return null;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,i.isWhiteSpace)(t))break;t=this.nextChar()}if(isSpecial(t)){this.nextChar();return String.fromCharCode(t)}let r="";do{r+=String.fromCharCode(t);t=this.nextChar()}while(t>=0&&!(0,i.isWhiteSpace)(t)&&!isSpecial(t));return r}readCharStrings(e,t){return-1===t?e:decrypt(e,4330,t)}extractFontProgram(e){const t=this.stream,r=[],a=[],i=Object.create(null);i.lenIV=4;const n={subrs:[],charstrings:[],properties:{privateData:i}};let s,c,l,h,u;for(;null!==(s=this.getToken());)if("/"===s){s=this.getToken();switch(s){case"CharStrings":this.getToken();this.getToken();this.getToken();this.getToken();for(;;){s=this.getToken();if(null===s||"end"===s)break;if("/"!==s)continue;const e=this.getToken();c=this.readInt();this.getToken();l=c>0?t.getBytes(c):new Uint8Array(0);h=n.properties.privateData.lenIV;u=this.readCharStrings(l,h);this.nextChar();s=this.getToken();"noaccess"===s&&this.getToken();a.push({glyph:e,encoded:u})}break;case"Subrs":this.readInt();this.getToken();for(;"dup"===this.getToken();){const e=this.readInt();c=this.readInt();this.getToken();l=c>0?t.getBytes(c):new Uint8Array(0);h=n.properties.privateData.lenIV;u=this.readCharStrings(l,h);this.nextChar();s=this.getToken();"noaccess"===s&&this.getToken();r[e]=u}break;case"BlueValues":case"OtherBlues":case"FamilyBlues":case"FamilyOtherBlues":const e=this.readNumberArray();e.length>0&&e.length,0;break;case"StemSnapH":case"StemSnapV":n.properties.privateData[s]=this.readNumberArray();break;case"StdHW":case"StdVW":n.properties.privateData[s]=this.readNumberArray()[0];break;case"BlueShift":case"lenIV":case"BlueFuzz":case"BlueScale":case"LanguageGroup":case"ExpansionFactor":n.properties.privateData[s]=this.readNumber();break;case"ForceBold":n.properties.privateData[s]=this.readBoolean()}}for(let t=0;t<a.length;t++){const i=a[t].glyph;u=a[t].encoded;const s=new o,c=s.convert(u,r,this.seacAnalysisEnabled);let l=s.output;c&&(l=[14]);const h={glyphName:i,charstring:l,width:s.width,lsb:s.lsb,seac:s.seac};".notdef"===i?n.charstrings.unshift(h):n.charstrings.push(h);if(e.builtInEncoding){const t=e.builtInEncoding.indexOf(i);t>-1&&void 0===e.widths[t]&&t>=e.firstChar&&t<=e.lastChar&&(e.widths[t]=s.width)}}return n}extractFontHeader(e){let t;for(;null!==(t=this.getToken());)if("/"===t){t=this.getToken();switch(t){case"FontMatrix":const r=this.readNumberArray();e.fontMatrix=r;break;case"Encoding":const i=this.getToken();let n;if(/^\d+$/.test(i)){n=[];const e=0|parseInt(i,10);this.getToken();for(let r=0;r<e;r++){t=this.getToken();for(;"dup"!==t&&"def"!==t;){t=this.getToken();if(null===t)return}if("def"===t)break;const e=this.readInt();this.getToken();const r=this.getToken();n[e]=r;this.getToken()}}else n=(0,a.getEncoding)(i);e.builtInEncoding=n;break;case"FontBBox":const s=this.readNumberArray();e.ascent=Math.max(s[3],s[1]);e.descent=Math.min(s[1],s[3]);e.ascentScaled=!0}}}}}();t.Type1Parser=c},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getTilingPatternIR=function getTilingPatternIR(e,t,r){const i=t.getArray("Matrix"),n=a.Util.normalizeRect(t.getArray("BBox")),s=t.get("XStep"),o=t.get("YStep"),c=t.get("PaintType"),l=t.get("TilingType");if(n[2]-n[0]==0||n[3]-n[1]==0)throw new a.FormatError(`Invalid getTilingPatternIR /BBox array: [${n}].`);return["TilingPattern",r,e,i,n,s,o,c,l]};t.Pattern=void 0;var a=r(2),i=r(23),n=r(5),s=r(8);const o=2,c=3,l=4,h=5,u=6,d=7,f=function PatternClosure(){function Pattern(){(0,a.unreachable)("should not call Pattern constructor")}Pattern.prototype={getPattern:function Pattern_getPattern(e){(0,a.unreachable)(`Should not call Pattern.getStyle: ${e}`)}};Pattern.parseShading=function(e,t,r,i,f,p,m){const b=(0,n.isStream)(e)?e.dict:e,y=b.get("ShadingType");try{switch(y){case o:case c:return new g.RadialAxial(b,t,r,i,p,m);case l:case h:case u:case d:return new g.Mesh(e,t,r,i,p,m);default:throw new a.FormatError("Unsupported ShadingType: "+y)}}catch(e){if(e instanceof s.MissingDataException)throw e;f.send("UnsupportedFeature",{featureId:a.UNSUPPORTED_FEATURES.shadingPattern});(0,a.warn)(e);return new g.Dummy}};return Pattern}();t.Pattern=f;const g={SMALL_NUMBER:1e-6};g.RadialAxial=function RadialAxialClosure(){function RadialAxial(e,t,r,n,s,o){this.matrix=t;this.coordsArr=e.getArray("Coords");this.shadingType=e.get("ShadingType");this.type="Pattern";const l=i.ColorSpace.parse({cs:e.getRaw("ColorSpace")||e.getRaw("CS"),xref:r,resources:n,pdfFunctionFactory:s,localColorSpaceCache:o});this.cs=l;const h=e.getArray("BBox");Array.isArray(h)&&4===h.length?this.bbox=a.Util.normalizeRect(h):this.bbox=null;let u=0,d=1;if(e.has("Domain")){const t=e.getArray("Domain");u=t[0];d=t[1]}let f=!1,p=!1;if(e.has("Extend")){const t=e.getArray("Extend");f=t[0];p=t[1]}if(!(this.shadingType!==c||f&&p)){const[e,t,r,i,n,s]=this.coordsArr,o=Math.hypot(e-i,t-n);r<=s+o&&s<=r+o&&(0,a.warn)("Unsupported radial gradient.")}this.extendStart=f;this.extendEnd=p;const m=e.getRaw("Function"),b=s.createFromArray(m),y=(d-u)/10,w=this.colorStops=[];if(u>=d||y<=0){(0,a.info)("Bad shading domain.");return}const S=new Float32Array(l.numComps),v=new Float32Array(1);let k;for(let e=0;e<=10;e++){v[0]=u+e*y;b(v,0,S,0);k=l.getRgb(S,0);const t=a.Util.makeHexColor(k[0],k[1],k[2]);w.push([e/10,t])}let x="transparent";if(e.has("Background")){k=l.getRgb(e.get("Background"),0);x=a.Util.makeHexColor(k[0],k[1],k[2])}if(!f){w.unshift([0,x]);w[1][0]+=g.SMALL_NUMBER}if(!p){w[w.length-1][0]-=g.SMALL_NUMBER;w.push([1,x])}this.colorStops=w}RadialAxial.prototype={getIR:function RadialAxial_getIR(){const e=this.coordsArr,t=this.shadingType;let r,i,n,s,l;if(t===o){i=[e[0],e[1]];n=[e[2],e[3]];s=null;l=null;r="axial"}else if(t===c){i=[e[0],e[1]];n=[e[3],e[4]];s=e[2];l=e[5];r="radial"}else(0,a.unreachable)(`getPattern type unknown: ${t}`);const h=this.matrix;if(h){i=a.Util.applyTransform(i,h);n=a.Util.applyTransform(n,h);if(t===c){const e=a.Util.singularValueDecompose2dScale(h);s*=e[0];l*=e[1]}}return["RadialAxial",r,this.bbox,this.colorStops,i,n,s,l]}};return RadialAxial}();g.Mesh=function MeshClosure(){function MeshStreamReader(e,t){this.stream=e;this.context=t;this.buffer=0;this.bufferLength=0;const r=t.numComps;this.tmpCompsBuf=new Float32Array(r);const a=t.colorSpace.numComps;this.tmpCsCompsBuf=t.colorFn?new Float32Array(a):this.tmpCompsBuf}MeshStreamReader.prototype={get hasData(){if(this.stream.end)return this.stream.pos<this.stream.end;if(this.bufferLength>0)return!0;const e=this.stream.getByte();if(e<0)return!1;this.buffer=e;this.bufferLength=8;return!0},readBits:function MeshStreamReader_readBits(e){let t=this.buffer,r=this.bufferLength;if(32===e){if(0===r)return(this.stream.getByte()<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte())>>>0;t=t<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte();const e=this.stream.getByte();this.buffer=e&(1<<r)-1;return(t<<8-r|(255&e)>>r)>>>0}if(8===e&&0===r)return this.stream.getByte();for(;r<e;){t=t<<8|this.stream.getByte();r+=8}r-=e;this.bufferLength=r;this.buffer=t&(1<<r)-1;return t>>r},align:function MeshStreamReader_align(){this.buffer=0;this.bufferLength=0},readFlag:function MeshStreamReader_readFlag(){return this.readBits(this.context.bitsPerFlag)},readCoordinate:function MeshStreamReader_readCoordinate(){const e=this.context.bitsPerCoordinate,t=this.readBits(e),r=this.readBits(e),a=this.context.decode,i=e<32?1/((1<<e)-1):2.3283064365386963e-10;return[t*i*(a[1]-a[0])+a[0],r*i*(a[3]-a[2])+a[2]]},readComponents:function MeshStreamReader_readComponents(){const e=this.context.numComps,t=this.context.bitsPerComponent,r=t<32?1/((1<<t)-1):2.3283064365386963e-10,a=this.context.decode,i=this.tmpCompsBuf;for(let n=0,s=4;n<e;n++,s+=2){const e=this.readBits(t);i[n]=e*r*(a[s+1]-a[s])+a[s]}const n=this.tmpCsCompsBuf;this.context.colorFn&&this.context.colorFn(i,0,n,0);return this.context.colorSpace.getRgb(n,0)}};const e=function getBClosure(){const e=[];return function getB(t){e[t]||(e[t]=function buildB(e){const t=[];for(let r=0;r<=e;r++){const a=r/e,i=1-a;t.push(new Float32Array([i*i*i,3*a*i*i,3*a*a*i,a*a*a]))}return t}(t));return e[t]}}();function buildFigureFromPatch(t,r){const i=t.figures[r];(0,a.assert)("patch"===i.type,"Unexpected patch mesh figure");const n=t.coords,s=t.colors,o=i.coords,c=i.colors,l=Math.min(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),h=Math.min(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]),u=Math.max(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),d=Math.max(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]);let f=Math.ceil(20*(u-l)/(t.bounds[2]-t.bounds[0]));f=Math.max(3,Math.min(20,f));let g=Math.ceil(20*(d-h)/(t.bounds[3]-t.bounds[1]));g=Math.max(3,Math.min(20,g));const p=f+1,m=new Int32Array((g+1)*p),b=new Int32Array((g+1)*p);let y=0;const w=new Uint8Array(3),S=new Uint8Array(3),v=s[c[0]],k=s[c[1]],x=s[c[2]],C=s[c[3]],O=e(g),F=e(f);for(let e=0;e<=g;e++){w[0]=(v[0]*(g-e)+x[0]*e)/g|0;w[1]=(v[1]*(g-e)+x[1]*e)/g|0;w[2]=(v[2]*(g-e)+x[2]*e)/g|0;S[0]=(k[0]*(g-e)+C[0]*e)/g|0;S[1]=(k[1]*(g-e)+C[1]*e)/g|0;S[2]=(k[2]*(g-e)+C[2]*e)/g|0;for(let t=0;t<=f;t++,y++){if(!(0!==e&&e!==g||0!==t&&t!==f))continue;let r=0,a=0,i=0;for(let s=0;s<=3;s++)for(let c=0;c<=3;c++,i++){const l=O[e][s]*F[t][c];r+=n[o[i]][0]*l;a+=n[o[i]][1]*l}m[y]=n.length;n.push([r,a]);b[y]=s.length;const c=new Uint8Array(3);c[0]=(w[0]*(f-t)+S[0]*t)/f|0;c[1]=(w[1]*(f-t)+S[1]*t)/f|0;c[2]=(w[2]*(f-t)+S[2]*t)/f|0;s.push(c)}}m[0]=o[0];b[0]=c[0];m[f]=o[3];b[f]=c[1];m[p*g]=o[12];b[p*g]=c[2];m[p*g+f]=o[15];b[p*g+f]=c[3];t.figures[r]={type:"lattice",coords:m,colors:b,verticesPerRow:p}}function updateBounds(e){let t=e.coords[0][0],r=e.coords[0][1],a=t,i=r;for(let n=1,s=e.coords.length;n<s;n++){const s=e.coords[n][0],o=e.coords[n][1];t=t>s?s:t;r=r>o?o:r;a=a<s?s:a;i=i<o?o:i}e.bounds=[t,r,a,i]}function Mesh(e,t,r,s,o,c){if(!(0,n.isStream)(e))throw new a.FormatError("Mesh data is not a stream");const f=e.dict;this.matrix=t;this.shadingType=f.get("ShadingType");this.type="Pattern";const g=f.getArray("BBox");Array.isArray(g)&&4===g.length?this.bbox=a.Util.normalizeRect(g):this.bbox=null;const p=i.ColorSpace.parse({cs:f.getRaw("ColorSpace")||f.getRaw("CS"),xref:r,resources:s,pdfFunctionFactory:o,localColorSpaceCache:c});this.cs=p;this.background=f.has("Background")?p.getRgb(f.get("Background"),0):null;const m=f.getRaw("Function"),b=m?o.createFromArray(m):null;this.coords=[];this.colors=[];this.figures=[];const y=new MeshStreamReader(e,{bitsPerCoordinate:f.get("BitsPerCoordinate"),bitsPerComponent:f.get("BitsPerComponent"),bitsPerFlag:f.get("BitsPerFlag"),decode:f.getArray("Decode"),colorFn:b,colorSpace:p,numComps:b?1:p.numComps});let w=!1;switch(this.shadingType){case l:!function decodeType4Shading(e,t){const r=e.coords,i=e.colors,n=[],s=[];let o=0;for(;t.hasData;){const e=t.readFlag(),c=t.readCoordinate(),l=t.readComponents();if(0===o){if(!(0<=e&&e<=2))throw new a.FormatError("Unknown type4 flag");switch(e){case 0:o=3;break;case 1:s.push(s[s.length-2],s[s.length-1]);o=1;break;case 2:s.push(s[s.length-3],s[s.length-1]);o=1}n.push(e)}s.push(r.length);r.push(c);i.push(l);o--;t.align()}e.figures.push({type:"triangles",coords:new Int32Array(s),colors:new Int32Array(s)})}(this,y);break;case h:const e=0|f.get("VerticesPerRow");if(e<2)throw new a.FormatError("Invalid VerticesPerRow");!function decodeType5Shading(e,t,r){const a=e.coords,i=e.colors,n=[];for(;t.hasData;){const e=t.readCoordinate(),r=t.readComponents();n.push(a.length);a.push(e);i.push(r)}e.figures.push({type:"lattice",coords:new Int32Array(n),colors:new Int32Array(n),verticesPerRow:r})}(this,y,e);break;case u:!function decodeType6Shading(e,t){const r=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);for(;t.hasData;){const o=t.readFlag();if(!(0<=o&&o<=3))throw new a.FormatError("Unknown type6 flag");const c=r.length;for(let e=0,a=0!==o?8:12;e<a;e++)r.push(t.readCoordinate());const l=i.length;for(let e=0,r=0!==o?2:4;e<r;e++)i.push(t.readComponents());let h,u,d,f;switch(o){case 0:n[12]=c+3;n[13]=c+4;n[14]=c+5;n[15]=c+6;n[8]=c+2;n[11]=c+7;n[4]=c+1;n[7]=c+8;n[0]=c;n[1]=c+11;n[2]=c+10;n[3]=c+9;s[2]=l+1;s[3]=l+2;s[0]=l;s[1]=l+3;break;case 1:h=n[12];u=n[13];d=n[14];f=n[15];n[12]=f;n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=d;n[11]=c+3;n[4]=u;n[7]=c+4;n[0]=h;n[1]=c+7;n[2]=c+6;n[3]=c+5;h=s[2];u=s[3];s[2]=u;s[3]=l;s[0]=h;s[1]=l+1;break;case 2:h=n[15];u=n[11];n[12]=n[3];n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=n[7];n[11]=c+3;n[4]=u;n[7]=c+4;n[0]=h;n[1]=c+7;n[2]=c+6;n[3]=c+5;h=s[3];s[2]=s[1];s[3]=l;s[0]=h;s[1]=l+1;break;case 3:n[12]=n[0];n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=n[1];n[11]=c+3;n[4]=n[2];n[7]=c+4;n[0]=n[3];n[1]=c+7;n[2]=c+6;n[3]=c+5;s[2]=s[0];s[3]=l;s[0]=s[1];s[1]=l+1}n[5]=r.length;r.push([(-4*r[n[0]][0]-r[n[15]][0]+6*(r[n[4]][0]+r[n[1]][0])-2*(r[n[12]][0]+r[n[3]][0])+3*(r[n[13]][0]+r[n[7]][0]))/9,(-4*r[n[0]][1]-r[n[15]][1]+6*(r[n[4]][1]+r[n[1]][1])-2*(r[n[12]][1]+r[n[3]][1])+3*(r[n[13]][1]+r[n[7]][1]))/9]);n[6]=r.length;r.push([(-4*r[n[3]][0]-r[n[12]][0]+6*(r[n[2]][0]+r[n[7]][0])-2*(r[n[0]][0]+r[n[15]][0])+3*(r[n[4]][0]+r[n[14]][0]))/9,(-4*r[n[3]][1]-r[n[12]][1]+6*(r[n[2]][1]+r[n[7]][1])-2*(r[n[0]][1]+r[n[15]][1])+3*(r[n[4]][1]+r[n[14]][1]))/9]);n[9]=r.length;r.push([(-4*r[n[12]][0]-r[n[3]][0]+6*(r[n[8]][0]+r[n[13]][0])-2*(r[n[0]][0]+r[n[15]][0])+3*(r[n[11]][0]+r[n[1]][0]))/9,(-4*r[n[12]][1]-r[n[3]][1]+6*(r[n[8]][1]+r[n[13]][1])-2*(r[n[0]][1]+r[n[15]][1])+3*(r[n[11]][1]+r[n[1]][1]))/9]);n[10]=r.length;r.push([(-4*r[n[15]][0]-r[n[0]][0]+6*(r[n[11]][0]+r[n[14]][0])-2*(r[n[12]][0]+r[n[3]][0])+3*(r[n[2]][0]+r[n[8]][0]))/9,(-4*r[n[15]][1]-r[n[0]][1]+6*(r[n[11]][1]+r[n[14]][1])-2*(r[n[12]][1]+r[n[3]][1])+3*(r[n[2]][1]+r[n[8]][1]))/9]);e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,y);w=!0;break;case d:!function decodeType7Shading(e,t){const r=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);for(;t.hasData;){const o=t.readFlag();if(!(0<=o&&o<=3))throw new a.FormatError("Unknown type7 flag");const c=r.length;for(let e=0,a=0!==o?12:16;e<a;e++)r.push(t.readCoordinate());const l=i.length;for(let e=0,r=0!==o?2:4;e<r;e++)i.push(t.readComponents());let h,u,d,f;switch(o){case 0:n[12]=c+3;n[13]=c+4;n[14]=c+5;n[15]=c+6;n[8]=c+2;n[9]=c+13;n[10]=c+14;n[11]=c+7;n[4]=c+1;n[5]=c+12;n[6]=c+15;n[7]=c+8;n[0]=c;n[1]=c+11;n[2]=c+10;n[3]=c+9;s[2]=l+1;s[3]=l+2;s[0]=l;s[1]=l+3;break;case 1:h=n[12];u=n[13];d=n[14];f=n[15];n[12]=f;n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=d;n[9]=c+9;n[10]=c+10;n[11]=c+3;n[4]=u;n[5]=c+8;n[6]=c+11;n[7]=c+4;n[0]=h;n[1]=c+7;n[2]=c+6;n[3]=c+5;h=s[2];u=s[3];s[2]=u;s[3]=l;s[0]=h;s[1]=l+1;break;case 2:h=n[15];u=n[11];n[12]=n[3];n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=n[7];n[9]=c+9;n[10]=c+10;n[11]=c+3;n[4]=u;n[5]=c+8;n[6]=c+11;n[7]=c+4;n[0]=h;n[1]=c+7;n[2]=c+6;n[3]=c+5;h=s[3];s[2]=s[1];s[3]=l;s[0]=h;s[1]=l+1;break;case 3:n[12]=n[0];n[13]=c+0;n[14]=c+1;n[15]=c+2;n[8]=n[1];n[9]=c+9;n[10]=c+10;n[11]=c+3;n[4]=n[2];n[5]=c+8;n[6]=c+11;n[7]=c+4;n[0]=n[3];n[1]=c+7;n[2]=c+6;n[3]=c+5;s[2]=s[0];s[3]=l;s[0]=s[1];s[1]=l+1}e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,y);w=!0;break;default:(0,a.unreachable)("Unsupported mesh type.")}if(w){updateBounds(this);for(let e=0,t=this.figures.length;e<t;e++)buildFigureFromPatch(this,e)}updateBounds(this);!function packData(e){let t,r,a,i;const n=e.coords,s=new Float32Array(2*n.length);for(t=0,a=0,r=n.length;t<r;t++){const e=n[t];s[a++]=e[0];s[a++]=e[1]}e.coords=s;const o=e.colors,c=new Uint8Array(3*o.length);for(t=0,a=0,r=o.length;t<r;t++){const e=o[t];c[a++]=e[0];c[a++]=e[1];c[a++]=e[2]}e.colors=c;const l=e.figures;for(t=0,r=l.length;t<r;t++){const e=l[t],r=e.coords,n=e.colors;for(a=0,i=r.length;a<i;a++){r[a]*=2;n[a]*=3}}}(this)}Mesh.prototype={getIR:function Mesh_getIR(){return["Mesh",this.shadingType,this.coords,this.colors,this.figures,this.bounds,this.matrix,this.bbox,this.background]}};return Mesh}();g.Dummy=function DummyClosure(){function Dummy(){this.type="Pattern"}Dummy.prototype={getIR:function Dummy_getIR(){return["Dummy"]}};return Dummy}()},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.isPDFFunction=function isPDFFunction(e){var t;if("object"!=typeof e)return!1;if((0,a.isDict)(e))t=e;else{if(!(0,a.isStream)(e))return!1;t=e.dict}return t.has("FunctionType")};t.PostScriptEvaluator=t.PostScriptCompiler=t.PDFFunctionFactory=void 0;var a=r(5),i=r(2),n=r(42),s=r(24);t.PDFFunctionFactory=class PDFFunctionFactory{constructor({xref:e,isEvalSupported:t=!0}){this.xref=e;this.isEvalSupported=!1!==t}create(e){const t=this.getCached(e);if(t)return t;const r=o.parse({xref:this.xref,isEvalSupported:this.isEvalSupported,fn:e instanceof a.Ref?this.xref.fetch(e):e});this._cache(e,r);return r}createFromArray(e){const t=this.getCached(e);if(t)return t;const r=o.parseArray({xref:this.xref,isEvalSupported:this.isEvalSupported,fnObj:e instanceof a.Ref?this.xref.fetch(e):e});this._cache(e,r);return r}getCached(e){let t;e instanceof a.Ref?t=e:e instanceof a.Dict?t=e.objId:(0,a.isStream)(e)&&(t=e.dict&&e.dict.objId);if(t){const e=this._localFunctionCache.getByRef(t);if(e)return e}return null}_cache(e,t){if(!t)throw new Error('PDFFunctionFactory._cache - expected "parsedFunction" argument.');let r;e instanceof a.Ref?r=e:e instanceof a.Dict?r=e.objId:(0,a.isStream)(e)&&(r=e.dict&&e.dict.objId);r&&this._localFunctionCache.set(null,r,t)}get _localFunctionCache(){return(0,i.shadow)(this,"_localFunctionCache",new s.LocalFunctionCache)}};function toNumberArray(e){if(!Array.isArray(e))return null;const t=e.length;for(let r=0;r<t;r++)if("number"!=typeof e[r]){const r=new Array(t);for(let a=0;a<t;a++)r[a]=+e[a];return r}return e}var o=function PDFFunctionClosure(){return{getSampleArray(e,t,r,a){var i,n,s=1;for(i=0,n=e.length;i<n;i++)s*=e[i];s*=t;var o=new Array(s),c=0,l=0,h=1/(2**r-1),u=a.getBytes((s*r+7)/8),d=0;for(i=0;i<s;i++){for(;c<r;){l<<=8;l|=u[d++];c+=8}c-=r;o[i]=(l>>c)*h;l&=(1<<c)-1}return o},getIR({xref:e,isEvalSupported:t,fn:r}){var a=r.dict;a||(a=r);var n=[this.constructSampled,null,this.constructInterpolated,this.constructStiched,this.constructPostScript][a.get("FunctionType")];if(!n)throw new i.FormatError("Unknown type of function");return n.call(this,{xref:e,isEvalSupported:t,fn:r,dict:a})},fromIR({xref:e,isEvalSupported:t,IR:r}){switch(r[0]){case 0:return this.constructSampledFromIR({xref:e,isEvalSupported:t,IR:r});case 2:return this.constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:r});case 3:return this.constructStichedFromIR({xref:e,isEvalSupported:t,IR:r});default:return this.constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:r})}},parse({xref:e,isEvalSupported:t,fn:r}){const a=this.getIR({xref:e,isEvalSupported:t,fn:r});return this.fromIR({xref:e,isEvalSupported:t,IR:a})},parseArray({xref:e,isEvalSupported:t,fnObj:r}){if(!Array.isArray(r))return this.parse({xref:e,isEvalSupported:t,fn:r});for(var a=[],i=0,n=r.length;i<n;i++)a.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(r[i])}));return function(e,t,r,i){for(var n=0,s=a.length;n<s;n++)a[n](e,t,r,i+n)}},constructSampled({xref:e,isEvalSupported:t,fn:r,dict:a}){function toMultiArray(e){for(var t=e.length,r=[],a=0,i=0;i<t;i+=2){r[a]=[e[i],e[i+1]];++a}return r}var n=toNumberArray(a.getArray("Domain")),s=toNumberArray(a.getArray("Range"));if(!n||!s)throw new i.FormatError("No domain or range");var o=n.length/2,c=s.length/2;n=toMultiArray(n);s=toMultiArray(s);var l=toNumberArray(a.getArray("Size")),h=a.get("BitsPerSample"),u=a.get("Order")||1;1!==u&&(0,i.info)("No support for cubic spline interpolation: "+u);var d=toNumberArray(a.getArray("Encode"));if(d)d=toMultiArray(d);else{d=[];for(var f=0;f<o;++f)d.push([0,l[f]-1])}var g=toNumberArray(a.getArray("Decode"));return[0,o,n,d,g=g?toMultiArray(g):s,this.getSampleArray(l,c,h,r),l,c,2**h-1,s]},constructSampledFromIR({xref:e,isEvalSupported:t,IR:r}){function interpolate(e,t,r,a,i){return a+(i-a)/(r-t)*(e-t)}return function constructSampledFromIRResult(e,t,a,i){var n,s,o=r[1],c=r[2],l=r[3],h=r[4],u=r[5],d=r[6],f=r[7],g=r[9],p=1<<o,m=new Float64Array(p),b=new Uint32Array(p);for(s=0;s<p;s++)m[s]=1;var y=f,w=1;for(n=0;n<o;++n){var S=c[n][0],v=c[n][1],k=interpolate(Math.min(Math.max(e[t+n],S),v),S,v,l[n][0],l[n][1]),x=d[n],C=(k=Math.min(Math.max(k,0),x-1))<x-1?Math.floor(k):k-1,O=C+1-k,F=k-C,T=C*y,E=T+y;for(s=0;s<p;s++)if(s&w){m[s]*=F;b[s]+=E}else{m[s]*=O;b[s]+=T}y*=x;w<<=1}for(s=0;s<f;++s){var M=0;for(n=0;n<p;n++)M+=u[b[n]+s]*m[n];M=interpolate(M,0,1,h[s][0],h[s][1]);a[i+s]=Math.min(Math.max(M,g[s][0]),g[s][1])}}},constructInterpolated({xref:e,isEvalSupported:t,fn:r,dict:a}){for(var i=toNumberArray(a.getArray("C0"))||[0],n=toNumberArray(a.getArray("C1"))||[1],s=a.get("N"),o=i.length,c=[],l=0;l<o;++l)c.push(n[l]-i[l]);return[2,i,c,s]},constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],i=r[2],n=r[3],s=i.length;return function constructInterpolatedFromIRResult(e,t,r,o){for(var c=1===n?e[t]:e[t]**n,l=0;l<s;++l)r[o+l]=a[l]+c*i[l]}},constructStiched({xref:e,isEvalSupported:t,fn:r,dict:a}){var n=toNumberArray(a.getArray("Domain"));if(!n)throw new i.FormatError("No domain");if(1!==n.length/2)throw new i.FormatError("Bad domain for stiched function");for(var s=a.get("Functions"),o=[],c=0,l=s.length;c<l;++c)o.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(s[c])}));return[3,n,toNumberArray(a.getArray("Bounds")),toNumberArray(a.getArray("Encode")),o]},constructStichedFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],i=r[2],n=r[3],s=r[4],o=new Float32Array(1);return function constructStichedFromIRResult(e,t,r,c){for(var l=function constructStichedFromIRClip(e,t,r){e>r?e=r:e<t&&(e=t);return e}(e[t],a[0],a[1]),h=0,u=i.length;h<u&&!(l<i[h]);++h);var d=a[0];h>0&&(d=i[h-1]);var f=a[1];h<i.length&&(f=i[h]);var g=n[2*h],p=n[2*h+1];o[0]=d===f?g:g+(l-d)*(p-g)/(f-d);s[h](o,0,r,c)}},constructPostScript({xref:e,isEvalSupported:t,fn:r,dict:a}){var s=toNumberArray(a.getArray("Domain")),o=toNumberArray(a.getArray("Range"));if(!s)throw new i.FormatError("No domain.");if(!o)throw new i.FormatError("No range.");var c=new n.PostScriptLexer(r);return[4,s,o,new n.PostScriptParser(c).parse()]},constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:r}){var a=r[1],n=r[2],s=r[3];if(t&&i.IsEvalSupportedCached.value){const e=(new l).compile(s,a,n);if(e)return new Function("src","srcOffset","dest","destOffset",e)}(0,i.info)("Unable to compile PS function");var o=n.length>>1,c=a.length>>1,h=new PostScriptEvaluator(s),u=Object.create(null),d=8192,f=new Float32Array(c);return function constructPostScriptFromIRResult(e,t,r,a){var i,s,l="",g=f;for(i=0;i<c;i++){s=e[t+i];g[i]=s;l+=s+"_"}var p=u[l];if(void 0===p){var m=new Float32Array(o),b=h.execute(g),y=b.length-o;for(i=0;i<o;i++){s=b[y+i];var w=n[2*i];(s<w||s>(w=n[2*i+1]))&&(s=w);m[i]=s}if(d>0){d--;u[l]=m}r.set(m,a)}else r.set(p,a)}}}}();var c=function PostScriptStackClosure(){return class PostScriptStack{constructor(e){this.stack=e?Array.prototype.slice.call(e,0):[]}push(e){if(this.stack.length>=100)throw new Error("PostScript function stack overflow.");this.stack.push(e)}pop(){if(this.stack.length<=0)throw new Error("PostScript function stack underflow.");return this.stack.pop()}copy(e){if(this.stack.length+e>=100)throw new Error("PostScript function stack overflow.");for(var t=this.stack,r=t.length-e,a=e-1;a>=0;a--,r++)t.push(t[r])}index(e){this.push(this.stack[this.stack.length-e-1])}roll(e,t){var r,a,i,n=this.stack,s=n.length-e,o=n.length-1,c=s+(t-Math.floor(t/e)*e);for(r=s,a=o;r<a;r++,a--){i=n[r];n[r]=n[a];n[a]=i}for(r=s,a=c-1;r<a;r++,a--){i=n[r];n[r]=n[a];n[a]=i}for(r=c,a=o;r<a;r++,a--){i=n[r];n[r]=n[a];n[a]=i}}}}();class PostScriptEvaluator{constructor(e){this.operators=e}execute(e){for(var t,r,a,n=new c(e),s=0,o=this.operators,l=o.length;s<l;)if("number"!=typeof(t=o[s++]))switch(t){case"jz":a=n.pop();(r=n.pop())||(s=a);break;case"j":s=r=n.pop();break;case"abs":r=n.pop();n.push(Math.abs(r));break;case"add":a=n.pop();r=n.pop();n.push(r+a);break;case"and":a=n.pop();r=n.pop();(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r&&a):n.push(r&a);break;case"atan":r=n.pop();n.push(Math.atan(r));break;case"bitshift":a=n.pop();(r=n.pop())>0?n.push(r<<a):n.push(r>>a);break;case"ceiling":r=n.pop();n.push(Math.ceil(r));break;case"copy":r=n.pop();n.copy(r);break;case"cos":r=n.pop();n.push(Math.cos(r));break;case"cvi":r=0|n.pop();n.push(r);break;case"cvr":break;case"div":a=n.pop();r=n.pop();n.push(r/a);break;case"dup":n.copy(1);break;case"eq":a=n.pop();r=n.pop();n.push(r===a);break;case"exch":n.roll(2,1);break;case"exp":a=n.pop();r=n.pop();n.push(r**a);break;case"false":n.push(!1);break;case"floor":r=n.pop();n.push(Math.floor(r));break;case"ge":a=n.pop();r=n.pop();n.push(r>=a);break;case"gt":a=n.pop();r=n.pop();n.push(r>a);break;case"idiv":a=n.pop();r=n.pop();n.push(r/a|0);break;case"index":r=n.pop();n.index(r);break;case"le":a=n.pop();r=n.pop();n.push(r<=a);break;case"ln":r=n.pop();n.push(Math.log(r));break;case"log":r=n.pop();n.push(Math.log(r)/Math.LN10);break;case"lt":a=n.pop();r=n.pop();n.push(r<a);break;case"mod":a=n.pop();r=n.pop();n.push(r%a);break;case"mul":a=n.pop();r=n.pop();n.push(r*a);break;case"ne":a=n.pop();r=n.pop();n.push(r!==a);break;case"neg":r=n.pop();n.push(-r);break;case"not":r=n.pop();(0,i.isBool)(r)?n.push(!r):n.push(~r);break;case"or":a=n.pop();r=n.pop();(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r||a):n.push(r|a);break;case"pop":n.pop();break;case"roll":a=n.pop();r=n.pop();n.roll(r,a);break;case"round":r=n.pop();n.push(Math.round(r));break;case"sin":r=n.pop();n.push(Math.sin(r));break;case"sqrt":r=n.pop();n.push(Math.sqrt(r));break;case"sub":a=n.pop();r=n.pop();n.push(r-a);break;case"true":n.push(!0);break;case"truncate":r=(r=n.pop())<0?Math.ceil(r):Math.floor(r);n.push(r);break;case"xor":a=n.pop();r=n.pop();(0,i.isBool)(r)&&(0,i.isBool)(a)?n.push(r!==a):n.push(r^a);break;default:throw new i.FormatError(`Unknown operator ${t}`)}else n.push(t);return n.stack}}t.PostScriptEvaluator=PostScriptEvaluator;var l=function PostScriptCompilerClosure(){class AstNode{constructor(e){this.type=e}visit(e){(0,i.unreachable)("abstract method")}}class AstArgument extends AstNode{constructor(e,t,r){super("args");this.index=e;this.min=t;this.max=r}visit(e){e.visitArgument(this)}}class AstLiteral extends AstNode{constructor(e){super("literal");this.number=e;this.min=e;this.max=e}visit(e){e.visitLiteral(this)}}class AstBinaryOperation extends AstNode{constructor(e,t,r,a,i){super("binary");this.op=e;this.arg1=t;this.arg2=r;this.min=a;this.max=i}visit(e){e.visitBinaryOperation(this)}}class AstMin extends AstNode{constructor(e,t){super("max");this.arg=e;this.min=e.min;this.max=t}visit(e){e.visitMin(this)}}class AstVariable extends AstNode{constructor(e,t,r){super("var");this.index=e;this.min=t;this.max=r}visit(e){e.visitVariable(this)}}class AstVariableDefinition extends AstNode{constructor(e,t){super("definition");this.variable=e;this.arg=t}visit(e){e.visitVariableDefinition(this)}}class ExpressionBuilderVisitor{constructor(){this.parts=[]}visitArgument(e){this.parts.push("Math.max(",e.min,", Math.min(",e.max,", src[srcOffset + ",e.index,"]))")}visitVariable(e){this.parts.push("v",e.index)}visitLiteral(e){this.parts.push(e.number)}visitBinaryOperation(e){this.parts.push("(");e.arg1.visit(this);this.parts.push(" ",e.op," ");e.arg2.visit(this);this.parts.push(")")}visitVariableDefinition(e){this.parts.push("var ");e.variable.visit(this);this.parts.push(" = ");e.arg.visit(this);this.parts.push(";")}visitMin(e){this.parts.push("Math.min(");e.arg.visit(this);this.parts.push(", ",e.max,")")}toString(){return this.parts.join("")}}function buildAddOperation(e,t){return"literal"===t.type&&0===t.number?e:"literal"===e.type&&0===e.number?t:"literal"===t.type&&"literal"===e.type?new AstLiteral(e.number+t.number):new AstBinaryOperation("+",e,t,e.min+t.min,e.max+t.max)}function buildMulOperation(e,t){if("literal"===t.type){if(0===t.number)return new AstLiteral(0);if(1===t.number)return e;if("literal"===e.type)return new AstLiteral(e.number*t.number)}if("literal"===e.type){if(0===e.number)return new AstLiteral(0);if(1===e.number)return t}var r=Math.min(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max),a=Math.max(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max);return new AstBinaryOperation("*",e,t,r,a)}function buildSubOperation(e,t){if("literal"===t.type){if(0===t.number)return e;if("literal"===e.type)return new AstLiteral(e.number-t.number)}return"binary"===t.type&&"-"===t.op&&"literal"===e.type&&1===e.number&&"literal"===t.arg1.type&&1===t.arg1.number?t.arg2:new AstBinaryOperation("-",e,t,e.min-t.max,e.max-t.min)}function buildMinOperation(e,t){return e.min>=t?new AstLiteral(t):e.max<=t?e:new AstMin(e,t)}return class PostScriptCompiler{compile(e,t,r){var a,i,n,s,o,c,l,h,u=[],d=[],f=t.length>>1,g=r.length>>1,p=0;for(let e=0;e<f;e++)u.push(new AstArgument(e,t[2*e],t[2*e+1]));for(let t=0,r=e.length;t<r;t++)if("number"!=typeof(h=e[t]))switch(h){case"add":if(u.length<2)return null;s=u.pop();n=u.pop();u.push(buildAddOperation(n,s));break;case"cvr":if(u.length<1)return null;break;case"mul":if(u.length<2)return null;s=u.pop();n=u.pop();u.push(buildMulOperation(n,s));break;case"sub":if(u.length<2)return null;s=u.pop();n=u.pop();u.push(buildSubOperation(n,s));break;case"exch":if(u.length<2)return null;o=u.pop();c=u.pop();u.push(o,c);break;case"pop":if(u.length<1)return null;u.pop();break;case"index":if(u.length<1)return null;if("literal"!==(n=u.pop()).type)return null;if((a=n.number)<0||!Number.isInteger(a)||u.length<a)return null;if("literal"===(o=u[u.length-a-1]).type||"var"===o.type){u.push(o);break}l=new AstVariable(p++,o.min,o.max);u[u.length-a-1]=l;u.push(l);d.push(new AstVariableDefinition(l,o));break;case"dup":if(u.length<1)return null;if("number"==typeof e[t+1]&&"gt"===e[t+2]&&e[t+3]===t+7&&"jz"===e[t+4]&&"pop"===e[t+5]&&e[t+6]===e[t+1]){n=u.pop();u.push(buildMinOperation(n,e[t+1]));t+=6;break}if("literal"===(o=u[u.length-1]).type||"var"===o.type){u.push(o);break}l=new AstVariable(p++,o.min,o.max);u[u.length-1]=l;u.push(l);d.push(new AstVariableDefinition(l,o));break;case"roll":if(u.length<2)return null;s=u.pop();n=u.pop();if("literal"!==s.type||"literal"!==n.type)return null;i=s.number;if((a=n.number)<=0||!Number.isInteger(a)||!Number.isInteger(i)||u.length<a)return null;if(0===(i=(i%a+a)%a))break;Array.prototype.push.apply(u,u.splice(u.length-a,a-i));break;default:return null}else u.push(new AstLiteral(h));if(u.length!==g)return null;var m=[];d.forEach((function(e){var t=new ExpressionBuilderVisitor;e.visit(t);m.push(t.toString())}));u.forEach((function(e,t){var a=new ExpressionBuilderVisitor;e.visit(a);var i=r[2*t],n=r[2*t+1],s=[a.toString()];if(i>e.min){s.unshift("Math.max(",i,", ");s.push(")")}if(n<e.max){s.unshift("Math.min(",n,", ");s.push(")")}s.unshift("dest[destOffset + ",t,"] = ");s.push(";");m.push(s.join(""))}));return m.join("\n")}}}();t.PostScriptCompiler=l},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PostScriptParser=t.PostScriptLexer=void 0;var a=r(2),i=r(5),n=r(8);t.PostScriptParser=class PostScriptParser{constructor(e){this.lexer=e;this.operators=[];this.token=null;this.prev=null}nextToken(){this.prev=this.token;this.token=this.lexer.getToken()}accept(e){if(this.token.type===e){this.nextToken();return!0}return!1}expect(e){if(this.accept(e))return!0;throw new a.FormatError(`Unexpected symbol: found ${this.token.type} expected ${e}.`)}parse(){this.nextToken();this.expect(s.LBRACE);this.parseBlock();this.expect(s.RBRACE);return this.operators}parseBlock(){for(;;)if(this.accept(s.NUMBER))this.operators.push(this.prev.value);else if(this.accept(s.OPERATOR))this.operators.push(this.prev.value);else{if(!this.accept(s.LBRACE))return;this.parseCondition()}}parseCondition(){const e=this.operators.length;this.operators.push(null,null);this.parseBlock();this.expect(s.RBRACE);if(this.accept(s.IF)){this.operators[e]=this.operators.length;this.operators[e+1]="jz"}else{if(!this.accept(s.LBRACE))throw new a.FormatError("PS Function: error parsing conditional.");{const t=this.operators.length;this.operators.push(null,null);const r=this.operators.length;this.parseBlock();this.expect(s.RBRACE);this.expect(s.IFELSE);this.operators[t]=this.operators.length;this.operators[t+1]="j";this.operators[e]=r;this.operators[e+1]="jz"}}}};const s={LBRACE:0,RBRACE:1,NUMBER:2,OPERATOR:3,IF:4,IFELSE:5},o=function PostScriptTokenClosure(){const e=Object.create(null);class PostScriptToken{constructor(e,t){this.type=e;this.value=t}static getOperator(t){const r=e[t];return r||(e[t]=new PostScriptToken(s.OPERATOR,t))}static get LBRACE(){return(0,a.shadow)(this,"LBRACE",new PostScriptToken(s.LBRACE,"{"))}static get RBRACE(){return(0,a.shadow)(this,"RBRACE",new PostScriptToken(s.RBRACE,"}"))}static get IF(){return(0,a.shadow)(this,"IF",new PostScriptToken(s.IF,"IF"))}static get IFELSE(){return(0,a.shadow)(this,"IFELSE",new PostScriptToken(s.IFELSE,"IFELSE"))}}return PostScriptToken}();t.PostScriptLexer=class PostScriptLexer{constructor(e){this.stream=e;this.nextChar();this.strBuf=[]}nextChar(){return this.currentChar=this.stream.getByte()}getToken(){let e=!1,t=this.currentChar;for(;;){if(t<0)return i.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,n.isWhiteSpace)(t))break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return new o(s.NUMBER,this.getNumber());case 123:this.nextChar();return o.LBRACE;case 125:this.nextChar();return o.RBRACE}const r=this.strBuf;r.length=0;r[0]=String.fromCharCode(t);for(;(t=this.nextChar())>=0&&(t>=65&&t<=90||t>=97&&t<=122);)r.push(String.fromCharCode(t));const a=r.join("");switch(a.toLowerCase()){case"if":return o.IF;case"ifelse":return o.IFELSE;default:return o.getOperator(a)}}getNumber(){let e=this.currentChar;const t=this.strBuf;t.length=0;t[0]=String.fromCharCode(e);for(;(e=this.nextChar())>=0&&(e>=48&&e<=57||45===e||46===e);)t.push(String.fromCharCode(e));const r=parseFloat(t.join(""));if(isNaN(r))throw new a.FormatError(`Invalid floating point number: ${r}`);return r}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.bidi=function bidi(e,t,r){var c=!0,l=e.length;if(0===l||r)return createBidiText(e,c,r);s.length=l;o.length=l;var h,u,d=0;for(h=0;h<l;++h){s[h]=e.charAt(h);var f=e.charCodeAt(h),g="L";f<=255?g=i[f]:1424<=f&&f<=1524?g="R":1536<=f&&f<=1791?(g=n[255&f])||(0,a.warn)("Bidi: invalid Unicode character "+f.toString(16)):1792<=f&&f<=2220&&(g="AL");"R"!==g&&"AL"!==g&&"AN"!==g||d++;o[h]=g}if(0===d)return createBidiText(e,c=!0);if(-1===t)if(d/l<.3){c=!0;t=0}else{c=!1;t=1}var p=[];for(h=0;h<l;++h)p[h]=t;var m,b=isOdd(t)?"R":"L",y=b,w=y,S=y;for(h=0;h<l;++h)"NSM"===o[h]?o[h]=S:S=o[h];S=y;for(h=0;h<l;++h)"EN"===(m=o[h])?o[h]="AL"===S?"AN":"EN":"R"!==m&&"L"!==m&&"AL"!==m||(S=m);for(h=0;h<l;++h)"AL"===(m=o[h])&&(o[h]="R");for(h=1;h<l-1;++h){"ES"===o[h]&&"EN"===o[h-1]&&"EN"===o[h+1]&&(o[h]="EN");"CS"!==o[h]||"EN"!==o[h-1]&&"AN"!==o[h-1]||o[h+1]!==o[h-1]||(o[h]=o[h-1])}for(h=0;h<l;++h)if("EN"===o[h]){var v;for(v=h-1;v>=0&&"ET"===o[v];--v)o[v]="EN";for(v=h+1;v<l&&"ET"===o[v];++v)o[v]="EN"}for(h=0;h<l;++h)"WS"!==(m=o[h])&&"ES"!==m&&"ET"!==m&&"CS"!==m||(o[h]="ON");S=y;for(h=0;h<l;++h)"EN"===(m=o[h])?o[h]="L"===S?"L":"EN":"R"!==m&&"L"!==m||(S=m);for(h=0;h<l;++h)if("ON"===o[h]){var k=findUnequal(o,h+1,"ON"),x=y;h>0&&(x=o[h-1]);var C=w;k+1<l&&(C=o[k+1]);"L"!==x&&(x="R");"L"!==C&&(C="R");x===C&&setValues(o,h,k,x);h=k-1}for(h=0;h<l;++h)"ON"===o[h]&&(o[h]=b);for(h=0;h<l;++h){m=o[h];isEven(p[h])?"R"===m?p[h]+=1:"AN"!==m&&"EN"!==m||(p[h]+=2):"L"!==m&&"AN"!==m&&"EN"!==m||(p[h]+=1)}var O,F=-1,T=99;for(h=0,u=p.length;h<u;++h){O=p[h];F<O&&(F=O);T>O&&isOdd(O)&&(T=O)}for(O=F;O>=T;--O){var E=-1;for(h=0,u=p.length;h<u;++h)if(p[h]<O){if(E>=0){reverseValues(s,E,h);E=-1}}else E<0&&(E=h);E>=0&&reverseValues(s,E,p.length)}for(h=0,u=s.length;h<u;++h){var M=s[h];"<"!==M&&">"!==M||(s[h]="")}return createBidiText(s.join(""),c)};var a=r(2),i=["BN","BN","BN","BN","BN","BN","BN","BN","BN","S","B","S","WS","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","B","B","B","S","WS","ON","ON","ET","ET","ET","ON","ON","ON","ON","ON","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","BN","BN","BN","BN","BN","BN","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","CS","ON","ET","ET","ET","ET","ON","ON","ON","ON","L","ON","ON","BN","ON","ON","ET","ET","EN","EN","ON","L","ON","ON","ON","EN","L","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L"],n=["AN","AN","AN","AN","AN","AN","ON","ON","AL","ET","ET","AL","CS","AL","ON","ON","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","AN","AN","AN","AN","AN","AN","AN","AN","AN","ET","AN","AN","AL","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","ON","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","NSM","NSM","ON","NSM","NSM","NSM","NSM","AL","AL","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","AL","AL","AL","AL","AL","AL"];function isOdd(e){return 0!=(1&e)}function isEven(e){return 0==(1&e)}function findUnequal(e,t,r){for(var a=t,i=e.length;a<i;++a)if(e[a]!==r)return a;return a}function setValues(e,t,r,a){for(var i=t;i<r;++i)e[i]=a}function reverseValues(e,t,r){for(var a=t,i=r-1;a<i;++a,--i){var n=e[a];e[a]=e[i];e[i]=n}}function createBidiText(e,t,r=!1){let a="ltr";r?a="ttb":t||(a="rtl");return{str:e,dir:a}}var s=[],o=[]},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getMetrics=void 0;var a=r(8);const i=(0,a.getLookupTableFactory)((function(e){e.Courier=600;e["Courier-Bold"]=600;e["Courier-BoldOblique"]=600;e["Courier-Oblique"]=600;e.Helvetica=(0,a.getLookupTableFactory)((function(e){e.space=278;e.exclam=278;e.quotedbl=355;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=667;e.quoteright=222;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=278;e.semicolon=278;e.less=584;e.equal=584;e.greater=584;e.question=556;e.at=1015;e.A=667;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=500;e.K=667;e.L=556;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=278;e.backslash=278;e.bracketright=278;e.asciicircum=469;e.underscore=556;e.quoteleft=222;e.a=556;e.b=556;e.c=500;e.d=556;e.e=556;e.f=278;e.g=556;e.h=556;e.i=222;e.j=222;e.k=500;e.l=222;e.m=833;e.n=556;e.o=556;e.p=556;e.q=556;e.r=333;e.s=500;e.t=278;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=500;e.braceleft=334;e.bar=260;e.braceright=334;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=191;e.quotedblleft=333;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=537;e.bullet=350;e.quotesinglbase=222;e.quotedblbase=333;e.quotedblright=333;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=556;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=222;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=556;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=667;e.aacute=556;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=500;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=500;e.aring=556;e.Ncommaaccent=722;e.lacute=222;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=500;e.scedilla=500;e.iacute=278;e.lozenge=471;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=556;e.Amacron=667;e.rcaron=333;e.ccedilla=500;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=643;e.Umacron=722;e.uring=556;e.threesuperior=333;e.Ograve=778;e.Agrave=667;e.Abreve=667;e.multiply=584;e.uacute=556;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=500;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=260;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=333;e.omacron=556;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=222;e.tcaron=317;e.eogonek=556;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=556;e.zacute=500;e.iogonek=222;e.Oacute=778;e.oacute=556;e.amacron=556;e.sacute=500;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=333;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=556;e.Eogonek=667;e.dcroat=556;e.threequarters=834;e.Scedilla=667;e.lcaron=299;e.Kcommaaccent=667;e.Lacute=556;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=556;e.onehalf=834;e.lessequal=549;e.ocircumflex=556;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=556;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=556;e.Ccaron=722;e.ugrave=556;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=556;e.Rcommaaccent=722;e.Lcommaaccent=556;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=500;e.minus=584;e.Icircumflex=278;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=584;e.odieresis=556;e.udieresis=556;e.notequal=549;e.gcommaaccent=556;e.eth=556;e.zcaron=500;e.ncommaaccent=556;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-Bold"]=(0,a.getLookupTableFactory)((function(e){e.space=278;e.exclam=333;e.quotedbl=474;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=722;e.quoteright=278;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=333;e.semicolon=333;e.less=584;e.equal=584;e.greater=584;e.question=611;e.at=975;e.A=722;e.B=722;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=556;e.K=722;e.L=611;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=584;e.underscore=556;e.quoteleft=278;e.a=556;e.b=611;e.c=556;e.d=611;e.e=556;e.f=333;e.g=611;e.h=611;e.i=278;e.j=278;e.k=556;e.l=278;e.m=889;e.n=611;e.o=611;e.p=611;e.q=611;e.r=389;e.s=556;e.t=333;e.u=611;e.v=556;e.w=778;e.x=556;e.y=556;e.z=500;e.braceleft=389;e.bar=280;e.braceright=389;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=238;e.quotedblleft=500;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=611;e.fl=611;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=556;e.bullet=350;e.quotesinglbase=278;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=611;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=278;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=611;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=722;e.aacute=556;e.Ucircumflex=722;e.yacute=556;e.scommaaccent=556;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=611;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=556;e.aring=556;e.Ncommaaccent=722;e.lacute=278;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=556;e.scedilla=556;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=611;e.acircumflex=556;e.Amacron=722;e.rcaron=389;e.ccedilla=556;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=743;e.Umacron=722;e.uring=611;e.threesuperior=333;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=584;e.uacute=611;e.Tcaron=611;e.partialdiff=494;e.ydieresis=556;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=556;e.nacute=611;e.umacron=611;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=280;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=611;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=389;e.eogonek=556;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=556;e.zacute=500;e.iogonek=278;e.Oacute=778;e.oacute=611;e.amacron=556;e.sacute=556;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=611;e.twosuperior=333;e.Odieresis=778;e.mu=611;e.igrave=278;e.ohungarumlaut=611;e.Eogonek=667;e.dcroat=611;e.threequarters=834;e.Scedilla=667;e.lcaron=400;e.Kcommaaccent=722;e.Lacute=611;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=611;e.onehalf=834;e.lessequal=549;e.ocircumflex=611;e.ntilde=611;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=611;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=611;e.Ccaron=722;e.ugrave=611;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=611;e.Rcommaaccent=722;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=556;e.minus=584;e.Icircumflex=278;e.ncaron=611;e.tcommaaccent=333;e.logicalnot=584;e.odieresis=611;e.udieresis=611;e.notequal=549;e.gcommaaccent=611;e.eth=611;e.zcaron=500;e.ncommaaccent=611;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-BoldOblique"]=(0,a.getLookupTableFactory)((function(e){e.space=278;e.exclam=333;e.quotedbl=474;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=722;e.quoteright=278;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=333;e.semicolon=333;e.less=584;e.equal=584;e.greater=584;e.question=611;e.at=975;e.A=722;e.B=722;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=556;e.K=722;e.L=611;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=584;e.underscore=556;e.quoteleft=278;e.a=556;e.b=611;e.c=556;e.d=611;e.e=556;e.f=333;e.g=611;e.h=611;e.i=278;e.j=278;e.k=556;e.l=278;e.m=889;e.n=611;e.o=611;e.p=611;e.q=611;e.r=389;e.s=556;e.t=333;e.u=611;e.v=556;e.w=778;e.x=556;e.y=556;e.z=500;e.braceleft=389;e.bar=280;e.braceright=389;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=238;e.quotedblleft=500;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=611;e.fl=611;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=556;e.bullet=350;e.quotesinglbase=278;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=611;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=278;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=611;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=722;e.aacute=556;e.Ucircumflex=722;e.yacute=556;e.scommaaccent=556;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=611;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=556;e.aring=556;e.Ncommaaccent=722;e.lacute=278;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=556;e.scedilla=556;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=611;e.acircumflex=556;e.Amacron=722;e.rcaron=389;e.ccedilla=556;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=743;e.Umacron=722;e.uring=611;e.threesuperior=333;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=584;e.uacute=611;e.Tcaron=611;e.partialdiff=494;e.ydieresis=556;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=556;e.nacute=611;e.umacron=611;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=280;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=611;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=389;e.eogonek=556;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=556;e.zacute=500;e.iogonek=278;e.Oacute=778;e.oacute=611;e.amacron=556;e.sacute=556;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=611;e.twosuperior=333;e.Odieresis=778;e.mu=611;e.igrave=278;e.ohungarumlaut=611;e.Eogonek=667;e.dcroat=611;e.threequarters=834;e.Scedilla=667;e.lcaron=400;e.Kcommaaccent=722;e.Lacute=611;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=611;e.onehalf=834;e.lessequal=549;e.ocircumflex=611;e.ntilde=611;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=611;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=611;e.Ccaron=722;e.ugrave=611;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=611;e.Rcommaaccent=722;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=556;e.minus=584;e.Icircumflex=278;e.ncaron=611;e.tcommaaccent=333;e.logicalnot=584;e.odieresis=611;e.udieresis=611;e.notequal=549;e.gcommaaccent=611;e.eth=611;e.zcaron=500;e.ncommaaccent=611;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-Oblique"]=(0,a.getLookupTableFactory)((function(e){e.space=278;e.exclam=278;e.quotedbl=355;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=667;e.quoteright=222;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=278;e.semicolon=278;e.less=584;e.equal=584;e.greater=584;e.question=556;e.at=1015;e.A=667;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=500;e.K=667;e.L=556;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=278;e.backslash=278;e.bracketright=278;e.asciicircum=469;e.underscore=556;e.quoteleft=222;e.a=556;e.b=556;e.c=500;e.d=556;e.e=556;e.f=278;e.g=556;e.h=556;e.i=222;e.j=222;e.k=500;e.l=222;e.m=833;e.n=556;e.o=556;e.p=556;e.q=556;e.r=333;e.s=500;e.t=278;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=500;e.braceleft=334;e.bar=260;e.braceright=334;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=191;e.quotedblleft=333;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=537;e.bullet=350;e.quotesinglbase=222;e.quotedblbase=333;e.quotedblright=333;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=556;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=222;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=556;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=667;e.aacute=556;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=500;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=500;e.aring=556;e.Ncommaaccent=722;e.lacute=222;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=500;e.scedilla=500;e.iacute=278;e.lozenge=471;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=556;e.Amacron=667;e.rcaron=333;e.ccedilla=500;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=643;e.Umacron=722;e.uring=556;e.threesuperior=333;e.Ograve=778;e.Agrave=667;e.Abreve=667;e.multiply=584;e.uacute=556;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=500;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=260;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=333;e.omacron=556;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=222;e.tcaron=317;e.eogonek=556;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=556;e.zacute=500;e.iogonek=222;e.Oacute=778;e.oacute=556;e.amacron=556;e.sacute=500;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=333;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=556;e.Eogonek=667;e.dcroat=556;e.threequarters=834;e.Scedilla=667;e.lcaron=299;e.Kcommaaccent=667;e.Lacute=556;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=556;e.onehalf=834;e.lessequal=549;e.ocircumflex=556;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=556;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=556;e.Ccaron=722;e.ugrave=556;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=556;e.Rcommaaccent=722;e.Lcommaaccent=556;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=500;e.minus=584;e.Icircumflex=278;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=584;e.odieresis=556;e.udieresis=556;e.notequal=549;e.gcommaaccent=556;e.eth=556;e.zcaron=500;e.ncommaaccent=556;e.onesuperior=333;e.imacron=278;e.Euro=556}));e.Symbol=(0,a.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.universal=713;e.numbersign=500;e.existential=549;e.percent=833;e.ampersand=778;e.suchthat=439;e.parenleft=333;e.parenright=333;e.asteriskmath=500;e.plus=549;e.comma=250;e.minus=549;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=278;e.semicolon=278;e.less=549;e.equal=549;e.greater=549;e.question=444;e.congruent=549;e.Alpha=722;e.Beta=667;e.Chi=722;e.Delta=612;e.Epsilon=611;e.Phi=763;e.Gamma=603;e.Eta=722;e.Iota=333;e.theta1=631;e.Kappa=722;e.Lambda=686;e.Mu=889;e.Nu=722;e.Omicron=722;e.Pi=768;e.Theta=741;e.Rho=556;e.Sigma=592;e.Tau=611;e.Upsilon=690;e.sigma1=439;e.Omega=768;e.Xi=645;e.Psi=795;e.Zeta=611;e.bracketleft=333;e.therefore=863;e.bracketright=333;e.perpendicular=658;e.underscore=500;e.radicalex=500;e.alpha=631;e.beta=549;e.chi=549;e.delta=494;e.epsilon=439;e.phi=521;e.gamma=411;e.eta=603;e.iota=329;e.phi1=603;e.kappa=549;e.lambda=549;e.mu=576;e.nu=521;e.omicron=549;e.pi=549;e.theta=521;e.rho=549;e.sigma=603;e.tau=439;e.upsilon=576;e.omega1=713;e.omega=686;e.xi=493;e.psi=686;e.zeta=494;e.braceleft=480;e.bar=200;e.braceright=480;e.similar=549;e.Euro=750;e.Upsilon1=620;e.minute=247;e.lessequal=549;e.fraction=167;e.infinity=713;e.florin=500;e.club=753;e.diamond=753;e.heart=753;e.spade=753;e.arrowboth=1042;e.arrowleft=987;e.arrowup=603;e.arrowright=987;e.arrowdown=603;e.degree=400;e.plusminus=549;e.second=411;e.greaterequal=549;e.multiply=549;e.proportional=713;e.partialdiff=494;e.bullet=460;e.divide=549;e.notequal=549;e.equivalence=549;e.approxequal=549;e.ellipsis=1e3;e.arrowvertex=603;e.arrowhorizex=1e3;e.carriagereturn=658;e.aleph=823;e.Ifraktur=686;e.Rfraktur=795;e.weierstrass=987;e.circlemultiply=768;e.circleplus=768;e.emptyset=823;e.intersection=768;e.union=768;e.propersuperset=713;e.reflexsuperset=713;e.notsubset=713;e.propersubset=713;e.reflexsubset=713;e.element=713;e.notelement=713;e.angle=768;e.gradient=713;e.registerserif=790;e.copyrightserif=790;e.trademarkserif=890;e.product=823;e.radical=549;e.dotmath=250;e.logicalnot=713;e.logicaland=603;e.logicalor=603;e.arrowdblboth=1042;e.arrowdblleft=987;e.arrowdblup=603;e.arrowdblright=987;e.arrowdbldown=603;e.lozenge=494;e.angleleft=329;e.registersans=790;e.copyrightsans=790;e.trademarksans=786;e.summation=713;e.parenlefttp=384;e.parenleftex=384;e.parenleftbt=384;e.bracketlefttp=384;e.bracketleftex=384;e.bracketleftbt=384;e.bracelefttp=494;e.braceleftmid=494;e.braceleftbt=494;e.braceex=494;e.angleright=329;e.integral=274;e.integraltp=686;e.integralex=686;e.integralbt=686;e.parenrighttp=384;e.parenrightex=384;e.parenrightbt=384;e.bracketrighttp=384;e.bracketrightex=384;e.bracketrightbt=384;e.bracerighttp=494;e.bracerightmid=494;e.bracerightbt=494;e.apple=790}));e["Times-Roman"]=(0,a.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=408;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=564;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=278;e.semicolon=278;e.less=564;e.equal=564;e.greater=564;e.question=444;e.at=921;e.A=722;e.B=667;e.C=667;e.D=722;e.E=611;e.F=556;e.G=722;e.H=722;e.I=333;e.J=389;e.K=722;e.L=611;e.M=889;e.N=722;e.O=722;e.P=556;e.Q=722;e.R=667;e.S=556;e.T=611;e.U=722;e.V=722;e.W=944;e.X=722;e.Y=722;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=469;e.underscore=500;e.quoteleft=333;e.a=444;e.b=500;e.c=444;e.d=500;e.e=444;e.f=333;e.g=500;e.h=500;e.i=278;e.j=278;e.k=500;e.l=278;e.m=778;e.n=500;e.o=500;e.p=500;e.q=500;e.r=333;e.s=389;e.t=278;e.u=500;e.v=500;e.w=722;e.x=500;e.y=500;e.z=444;e.braceleft=480;e.bar=200;e.braceright=480;e.asciitilde=541;e.exclamdown=333;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=180;e.quotedblleft=444;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=453;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=444;e.quotedblright=444;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=444;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=889;e.ordfeminine=276;e.Lslash=611;e.Oslash=722;e.OE=889;e.ordmasculine=310;e.ae=667;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=500;e.Idieresis=333;e.eacute=444;e.abreve=444;e.uhungarumlaut=500;e.ecaron=444;e.Ydieresis=722;e.divide=564;e.Yacute=722;e.Acircumflex=722;e.aacute=444;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=444;e.Uacute=722;e.uogonek=500;e.Edieresis=611;e.Dcroat=722;e.commaaccent=250;e.copyright=760;e.Emacron=611;e.ccaron=444;e.aring=444;e.Ncommaaccent=722;e.lacute=278;e.agrave=444;e.Tcommaaccent=611;e.Cacute=667;e.atilde=444;e.Edotaccent=611;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=471;e.Rcaron=667;e.Gcommaaccent=722;e.ucircumflex=500;e.acircumflex=444;e.Amacron=722;e.rcaron=333;e.ccedilla=444;e.Zdotaccent=611;e.Thorn=556;e.Omacron=722;e.Racute=667;e.Sacute=556;e.dcaron=588;e.Umacron=722;e.uring=500;e.threesuperior=300;e.Ograve=722;e.Agrave=722;e.Abreve=722;e.multiply=564;e.uacute=500;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=611;e.adieresis=444;e.edieresis=444;e.cacute=444;e.nacute=500;e.umacron=500;e.Ncaron=722;e.Iacute=333;e.plusminus=564;e.brokenbar=200;e.registered=760;e.Gbreve=722;e.Idotaccent=333;e.summation=600;e.Egrave=611;e.racute=333;e.omacron=500;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=326;e.eogonek=444;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=444;e.zacute=444;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=444;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=500;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=611;e.dcroat=500;e.threequarters=750;e.Scedilla=556;e.lcaron=344;e.Kcommaaccent=722;e.Lacute=611;e.trademark=980;e.edotaccent=444;e.Igrave=333;e.Imacron=333;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=500;e.Uhungarumlaut=722;e.Eacute=611;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=500;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=667;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=722;e.zdotaccent=444;e.Ecaron=611;e.Iogonek=333;e.kcommaaccent=500;e.minus=564;e.Icircumflex=333;e.ncaron=500;e.tcommaaccent=278;e.logicalnot=564;e.odieresis=500;e.udieresis=500;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=444;e.ncommaaccent=500;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-Bold"]=(0,a.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=555;e.numbersign=500;e.dollar=500;e.percent=1e3;e.ampersand=833;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=570;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=570;e.equal=570;e.greater=570;e.question=500;e.at=930;e.A=722;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=778;e.I=389;e.J=500;e.K=778;e.L=667;e.M=944;e.N=722;e.O=778;e.P=611;e.Q=778;e.R=722;e.S=556;e.T=667;e.U=722;e.V=722;e.W=1e3;e.X=722;e.Y=722;e.Z=667;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=581;e.underscore=500;e.quoteleft=333;e.a=500;e.b=556;e.c=444;e.d=556;e.e=444;e.f=333;e.g=500;e.h=556;e.i=278;e.j=333;e.k=556;e.l=278;e.m=833;e.n=556;e.o=500;e.p=556;e.q=556;e.r=444;e.s=389;e.t=333;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=444;e.braceleft=394;e.bar=220;e.braceright=394;e.asciitilde=520;e.exclamdown=333;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=278;e.quotedblleft=500;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=540;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=300;e.Lslash=667;e.Oslash=778;e.OE=1e3;e.ordmasculine=330;e.ae=722;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=556;e.Idieresis=389;e.eacute=444;e.abreve=500;e.uhungarumlaut=556;e.ecaron=444;e.Ydieresis=722;e.divide=570;e.Yacute=722;e.Acircumflex=722;e.aacute=500;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=747;e.Emacron=667;e.ccaron=444;e.aring=500;e.Ncommaaccent=722;e.lacute=278;e.agrave=500;e.Tcommaaccent=667;e.Cacute=722;e.atilde=500;e.Edotaccent=667;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=500;e.Amacron=722;e.rcaron=444;e.ccedilla=444;e.Zdotaccent=667;e.Thorn=611;e.Omacron=778;e.Racute=722;e.Sacute=556;e.dcaron=672;e.Umacron=722;e.uring=556;e.threesuperior=300;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=570;e.uacute=556;e.Tcaron=667;e.partialdiff=494;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=389;e.plusminus=570;e.brokenbar=220;e.registered=747;e.Gbreve=778;e.Idotaccent=389;e.summation=600;e.Egrave=667;e.racute=444;e.omacron=500;e.Zacute=667;e.Zcaron=667;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=416;e.eogonek=444;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=444;e.zacute=444;e.iogonek=278;e.Oacute=778;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=300;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=667;e.dcroat=556;e.threequarters=750;e.Scedilla=556;e.lcaron=394;e.Kcommaaccent=778;e.Lacute=667;e.trademark=1e3;e.edotaccent=444;e.Igrave=389;e.Imacron=389;e.Lcaron=667;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=778;e.degree=400;e.ograve=500;e.Ccaron=722;e.ugrave=556;e.radical=549;e.Dcaron=722;e.rcommaaccent=444;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=722;e.Lcommaaccent=667;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=444;e.Ecaron=667;e.Iogonek=389;e.kcommaaccent=556;e.minus=570;e.Icircumflex=389;e.ncaron=556;e.tcommaaccent=333;e.logicalnot=570;e.odieresis=500;e.udieresis=556;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=444;e.ncommaaccent=556;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-BoldItalic"]=(0,a.getLookupTableFactory)((function(e){e.space=250;e.exclam=389;e.quotedbl=555;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=570;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=570;e.equal=570;e.greater=570;e.question=500;e.at=832;e.A=667;e.B=667;e.C=667;e.D=722;e.E=667;e.F=667;e.G=722;e.H=778;e.I=389;e.J=500;e.K=667;e.L=611;e.M=889;e.N=722;e.O=722;e.P=611;e.Q=722;e.R=667;e.S=556;e.T=611;e.U=722;e.V=667;e.W=889;e.X=667;e.Y=611;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=570;e.underscore=500;e.quoteleft=333;e.a=500;e.b=500;e.c=444;e.d=500;e.e=444;e.f=333;e.g=500;e.h=556;e.i=278;e.j=278;e.k=500;e.l=278;e.m=778;e.n=556;e.o=500;e.p=500;e.q=500;e.r=389;e.s=389;e.t=278;e.u=556;e.v=444;e.w=667;e.x=500;e.y=444;e.z=389;e.braceleft=348;e.bar=220;e.braceright=348;e.asciitilde=570;e.exclamdown=389;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=278;e.quotedblleft=500;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=500;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=944;e.ordfeminine=266;e.Lslash=611;e.Oslash=722;e.OE=944;e.ordmasculine=300;e.ae=722;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=500;e.Idieresis=389;e.eacute=444;e.abreve=500;e.uhungarumlaut=556;e.ecaron=444;e.Ydieresis=611;e.divide=570;e.Yacute=611;e.Acircumflex=667;e.aacute=500;e.Ucircumflex=722;e.yacute=444;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=747;e.Emacron=667;e.ccaron=444;e.aring=500;e.Ncommaaccent=722;e.lacute=278;e.agrave=500;e.Tcommaaccent=611;e.Cacute=667;e.atilde=500;e.Edotaccent=667;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=494;e.Rcaron=667;e.Gcommaaccent=722;e.ucircumflex=556;e.acircumflex=500;e.Amacron=667;e.rcaron=389;e.ccedilla=444;e.Zdotaccent=611;e.Thorn=611;e.Omacron=722;e.Racute=667;e.Sacute=556;e.dcaron=608;e.Umacron=722;e.uring=556;e.threesuperior=300;e.Ograve=722;e.Agrave=667;e.Abreve=667;e.multiply=570;e.uacute=556;e.Tcaron=611;e.partialdiff=494;e.ydieresis=444;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=389;e.plusminus=570;e.brokenbar=220;e.registered=747;e.Gbreve=722;e.Idotaccent=389;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=500;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=366;e.eogonek=444;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=444;e.zacute=389;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=576;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=667;e.dcroat=500;e.threequarters=750;e.Scedilla=556;e.lcaron=382;e.Kcommaaccent=667;e.Lacute=611;e.trademark=1e3;e.edotaccent=444;e.Igrave=389;e.Imacron=389;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=556;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=667;e.Lcommaaccent=611;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=722;e.zdotaccent=389;e.Ecaron=667;e.Iogonek=389;e.kcommaaccent=500;e.minus=606;e.Icircumflex=389;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=606;e.odieresis=500;e.udieresis=556;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=389;e.ncommaaccent=556;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-Italic"]=(0,a.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=420;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=675;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=675;e.equal=675;e.greater=675;e.question=500;e.at=920;e.A=611;e.B=611;e.C=667;e.D=722;e.E=611;e.F=611;e.G=722;e.H=722;e.I=333;e.J=444;e.K=667;e.L=556;e.M=833;e.N=667;e.O=722;e.P=611;e.Q=722;e.R=611;e.S=500;e.T=556;e.U=722;e.V=611;e.W=833;e.X=611;e.Y=556;e.Z=556;e.bracketleft=389;e.backslash=278;e.bracketright=389;e.asciicircum=422;e.underscore=500;e.quoteleft=333;e.a=500;e.b=500;e.c=444;e.d=500;e.e=444;e.f=278;e.g=500;e.h=500;e.i=278;e.j=278;e.k=444;e.l=278;e.m=722;e.n=500;e.o=500;e.p=500;e.q=500;e.r=389;e.s=389;e.t=278;e.u=500;e.v=444;e.w=667;e.x=444;e.y=444;e.z=389;e.braceleft=400;e.bar=275;e.braceright=400;e.asciitilde=541;e.exclamdown=389;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=214;e.quotedblleft=556;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=523;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=556;e.quotedblright=556;e.guillemotright=500;e.ellipsis=889;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=889;e.AE=889;e.ordfeminine=276;e.Lslash=556;e.Oslash=722;e.OE=944;e.ordmasculine=310;e.ae=667;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=667;e.germandbls=500;e.Idieresis=333;e.eacute=444;e.abreve=500;e.uhungarumlaut=500;e.ecaron=444;e.Ydieresis=556;e.divide=675;e.Yacute=556;e.Acircumflex=611;e.aacute=500;e.Ucircumflex=722;e.yacute=444;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=500;e.Edieresis=611;e.Dcroat=722;e.commaaccent=250;e.copyright=760;e.Emacron=611;e.ccaron=444;e.aring=500;e.Ncommaaccent=667;e.lacute=278;e.agrave=500;e.Tcommaaccent=556;e.Cacute=667;e.atilde=500;e.Edotaccent=611;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=471;e.Rcaron=611;e.Gcommaaccent=722;e.ucircumflex=500;e.acircumflex=500;e.Amacron=611;e.rcaron=389;e.ccedilla=444;e.Zdotaccent=556;e.Thorn=611;e.Omacron=722;e.Racute=611;e.Sacute=500;e.dcaron=544;e.Umacron=722;e.uring=500;e.threesuperior=300;e.Ograve=722;e.Agrave=611;e.Abreve=611;e.multiply=675;e.uacute=500;e.Tcaron=556;e.partialdiff=476;e.ydieresis=444;e.Nacute=667;e.icircumflex=278;e.Ecircumflex=611;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=500;e.umacron=500;e.Ncaron=667;e.Iacute=333;e.plusminus=675;e.brokenbar=275;e.registered=760;e.Gbreve=722;e.Idotaccent=333;e.summation=600;e.Egrave=611;e.racute=389;e.omacron=500;e.Zacute=556;e.Zcaron=556;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=300;e.eogonek=444;e.Uogonek=722;e.Aacute=611;e.Adieresis=611;e.egrave=444;e.zacute=389;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=500;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=611;e.dcroat=500;e.threequarters=750;e.Scedilla=500;e.lcaron=300;e.Kcommaaccent=667;e.Lacute=556;e.trademark=980;e.edotaccent=444;e.Igrave=333;e.Imacron=333;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=500;e.Uhungarumlaut=722;e.Eacute=611;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=500;e.Scommaaccent=500;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=500;e.radical=453;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=667;e.otilde=500;e.Rcommaaccent=611;e.Lcommaaccent=556;e.Atilde=611;e.Aogonek=611;e.Aring=611;e.Otilde=722;e.zdotaccent=389;e.Ecaron=611;e.Iogonek=333;e.kcommaaccent=444;e.minus=675;e.Icircumflex=333;e.ncaron=500;e.tcommaaccent=278;e.logicalnot=675;e.odieresis=500;e.udieresis=500;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=389;e.ncommaaccent=500;e.onesuperior=300;e.imacron=278;e.Euro=500}));e.ZapfDingbats=(0,a.getLookupTableFactory)((function(e){e.space=278;e.a1=974;e.a2=961;e.a202=974;e.a3=980;e.a4=719;e.a5=789;e.a119=790;e.a118=791;e.a117=690;e.a11=960;e.a12=939;e.a13=549;e.a14=855;e.a15=911;e.a16=933;e.a105=911;e.a17=945;e.a18=974;e.a19=755;e.a20=846;e.a21=762;e.a22=761;e.a23=571;e.a24=677;e.a25=763;e.a26=760;e.a27=759;e.a28=754;e.a6=494;e.a7=552;e.a8=537;e.a9=577;e.a10=692;e.a29=786;e.a30=788;e.a31=788;e.a32=790;e.a33=793;e.a34=794;e.a35=816;e.a36=823;e.a37=789;e.a38=841;e.a39=823;e.a40=833;e.a41=816;e.a42=831;e.a43=923;e.a44=744;e.a45=723;e.a46=749;e.a47=790;e.a48=792;e.a49=695;e.a50=776;e.a51=768;e.a52=792;e.a53=759;e.a54=707;e.a55=708;e.a56=682;e.a57=701;e.a58=826;e.a59=815;e.a60=789;e.a61=789;e.a62=707;e.a63=687;e.a64=696;e.a65=689;e.a66=786;e.a67=787;e.a68=713;e.a69=791;e.a70=785;e.a71=791;e.a72=873;e.a73=761;e.a74=762;e.a203=762;e.a75=759;e.a204=759;e.a76=892;e.a77=892;e.a78=788;e.a79=784;e.a81=438;e.a82=138;e.a83=277;e.a84=415;e.a97=392;e.a98=392;e.a99=668;e.a100=668;e.a89=390;e.a90=390;e.a93=317;e.a94=317;e.a91=276;e.a92=276;e.a205=509;e.a85=509;e.a206=410;e.a86=410;e.a87=234;e.a88=234;e.a95=334;e.a96=334;e.a101=732;e.a102=544;e.a103=544;e.a104=910;e.a106=667;e.a107=760;e.a108=760;e.a112=776;e.a111=595;e.a110=694;e.a109=626;e.a120=788;e.a121=788;e.a122=788;e.a123=788;e.a124=788;e.a125=788;e.a126=788;e.a127=788;e.a128=788;e.a129=788;e.a130=788;e.a131=788;e.a132=788;e.a133=788;e.a134=788;e.a135=788;e.a136=788;e.a137=788;e.a138=788;e.a139=788;e.a140=788;e.a141=788;e.a142=788;e.a143=788;e.a144=788;e.a145=788;e.a146=788;e.a147=788;e.a148=788;e.a149=788;e.a150=788;e.a151=788;e.a152=788;e.a153=788;e.a154=788;e.a155=788;e.a156=788;e.a157=788;e.a158=788;e.a159=788;e.a160=894;e.a161=838;e.a163=1016;e.a164=458;e.a196=748;e.a165=924;e.a192=748;e.a166=918;e.a167=927;e.a168=928;e.a169=928;e.a170=834;e.a171=873;e.a172=828;e.a173=924;e.a162=924;e.a174=917;e.a175=930;e.a176=931;e.a177=463;e.a178=883;e.a179=836;e.a193=836;e.a180=867;e.a199=867;e.a181=696;e.a200=696;e.a182=874;e.a201=874;e.a183=760;e.a184=946;e.a197=771;e.a185=865;e.a194=771;e.a198=888;e.a186=967;e.a195=888;e.a187=831;e.a188=873;e.a189=927;e.a190=970;e.a191=918}))}));t.getMetrics=i},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.MurmurHash3_64=void 0;var a=r(2);const i=3285377520,n=4294901760,s=65535;t.MurmurHash3_64=class MurmurHash3_64{constructor(e){this.h1=e?4294967295&e:i;this.h2=e?4294967295&e:i}update(e){let t,r;if((0,a.isString)(e)){t=new Uint8Array(2*e.length);r=0;for(let a=0,i=e.length;a<i;a++){const i=e.charCodeAt(a);if(i<=255)t[r++]=i;else{t[r++]=i>>>8;t[r++]=255&i}}}else{if(!(0,a.isArrayBuffer)(e))throw new Error("Wrong data format in MurmurHash3_64_update. Input must be a string or array.");t=e.slice();r=t.byteLength}const i=r>>2,o=r-4*i,c=new Uint32Array(t.buffer,0,i);let l=0,h=0,u=this.h1,d=this.h2;const f=3432918353,g=461845907,p=11601,m=13715;for(let e=0;e<i;e++)if(1&e){l=c[e];l=l*f&n|l*p&s;l=l<<15|l>>>17;l=l*g&n|l*m&s;u^=l;u=u<<13|u>>>19;u=5*u+3864292196}else{h=c[e];h=h*f&n|h*p&s;h=h<<15|h>>>17;h=h*g&n|h*m&s;d^=h;d=d<<13|d>>>19;d=5*d+3864292196}l=0;switch(o){case 3:l^=t[4*i+2]<<16;case 2:l^=t[4*i+1]<<8;case 1:l^=t[4*i];l=l*f&n|l*p&s;l=l<<15|l>>>17;l=l*g&n|l*m&s;1&i?u^=l:d^=l}this.h1=u;this.h2=d}hexdigest(){let e=this.h1,t=this.h2;e^=t>>>1;e=3981806797*e&n|36045*e&s;t=4283543511*t&n|(2950163797*(t<<16|e>>>16)&n)>>>16;e^=t>>>1;e=444984403*e&n|60499*e&s;t=3301882366*t&n|(3120437893*(t<<16|e>>>16)&n)>>>16;e^=t>>>1;const r=(e>>>0).toString(16),a=(t>>>0).toString(16);return r.padStart(8,"0")+a.padStart(8,"0")}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.OperatorList=void 0;var a=r(2);const i=function QueueOptimizerClosure(){function addState(e,t,r,a,i){let n=e;for(let e=0,r=t.length-1;e<r;e++){const r=t[e];n=n[r]||(n[r]=[])}n[t[t.length-1]]={checkFn:r,iterateFn:a,processFn:i}}const e=[];addState(e,[a.OPS.save,a.OPS.transform,a.OPS.paintInlineImageXObject,a.OPS.restore],null,(function iterateInlineImageGroup(e,t){const r=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return r[t]===a.OPS.save;case 1:return r[t]===a.OPS.transform;case 2:return r[t]===a.OPS.paintInlineImageXObject;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateInlineImageGroup - invalid pos: ${i}`)}),(function foundInlineImageGroup(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=n-1,l=Math.min(Math.floor((t-s)/4),200);if(l<10)return t-(t-s)%4;let h=0;const u=[];let d=0,f=1,g=1;for(let e=0;e<l;e++){const t=i[o+(e<<2)],r=i[c+(e<<2)][0];if(f+r.width>1e3){h=Math.max(h,f);g+=d+2;f=0;d=0}u.push({transform:t,x:f,y:g,w:r.width,h:r.height});f+=r.width+2;d=Math.max(d,r.height)}const p=Math.max(h,f)+1,m=g+d+1,b=new Uint8ClampedArray(p*m*4),y=p<<2;for(let e=0;e<l;e++){const t=i[c+(e<<2)][0].data,r=u[e].w<<2;let a=0,n=u[e].x+u[e].y*p<<2;b.set(t.subarray(0,r),n-y);for(let i=0,s=u[e].h;i<s;i++){b.set(t.subarray(a,a+r),n);a+=r;n+=y}b.set(t.subarray(a-r,a),n);for(;n>=0;){t[n-4]=t[n];t[n-3]=t[n+1];t[n-2]=t[n+2];t[n-1]=t[n+3];t[n+r]=t[n+r-4];t[n+r+1]=t[n+r-3];t[n+r+2]=t[n+r-2];t[n+r+3]=t[n+r-1];n-=y}}r.splice(s,4*l,a.OPS.paintInlineImageXObjectGroup);i.splice(s,4*l,[{width:p,height:m,kind:a.ImageKind.RGBA_32BPP,data:b},u]);return s+1}));addState(e,[a.OPS.save,a.OPS.transform,a.OPS.paintImageMaskXObject,a.OPS.restore],null,(function iterateImageMaskGroup(e,t){const r=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return r[t]===a.OPS.save;case 1:return r[t]===a.OPS.transform;case 2:return r[t]===a.OPS.paintImageMaskXObject;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateImageMaskGroup - invalid pos: ${i}`)}),(function foundImageMaskGroup(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=n-1;let l=Math.floor((t-s)/4);l=function handlePaintSolidColorImageMask(e,t,r,i){const n=e+2;let s;for(s=0;s<t;s++){const e=i[n+4*s],t=1===e.length&&e[0];if(!t||1!==t.width||1!==t.height||t.data.length&&(1!==t.data.length||0!==t.data[0]))break;r[n+4*s]=a.OPS.paintSolidColorImageMask}return t-s}(s,l,r,i);if(l<10)return t-(t-s)%4;let h,u,d=!1;const f=i[c][0],g=i[o][0],p=i[o][1],m=i[o][2],b=i[o][3];if(p===m){d=!0;h=o+4;let e=c+4;for(let t=1;t<l;t++,h+=4,e+=4){u=i[h];if(i[e][0]!==f||u[0]!==g||u[1]!==p||u[2]!==m||u[3]!==b){t<10?d=!1:l=t;break}}}if(d){l=Math.min(l,1e3);const e=new Float32Array(2*l);h=o;for(let t=0;t<l;t++,h+=4){u=i[h];e[t<<1]=u[4];e[1+(t<<1)]=u[5]}r.splice(s,4*l,a.OPS.paintImageMaskXObjectRepeat);i.splice(s,4*l,[f,g,p,m,b,e])}else{l=Math.min(l,100);const e=[];for(let t=0;t<l;t++){u=i[o+(t<<2)];const r=i[c+(t<<2)][0];e.push({data:r.data,width:r.width,height:r.height,transform:u})}r.splice(s,4*l,a.OPS.paintImageMaskXObjectGroup);i.splice(s,4*l,[e])}return s+1}));addState(e,[a.OPS.save,a.OPS.transform,a.OPS.paintImageXObject,a.OPS.restore],(function(e){const t=e.argsArray,r=e.iCurr-2;return 0===t[r][1]&&0===t[r][2]}),(function iterateImageGroup(e,t){const r=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-3))%4;switch(n){case 0:return r[t]===a.OPS.save;case 1:if(r[t]!==a.OPS.transform)return!1;const n=e.iCurr-2,s=i[n][0],o=i[n][3];return i[t][0]===s&&0===i[t][1]&&0===i[t][2]&&i[t][3]===o;case 2:if(r[t]!==a.OPS.paintImageXObject)return!1;const c=i[e.iCurr-1][0];return i[t][0]===c;case 3:return r[t]===a.OPS.restore}throw new Error(`iterateImageGroup - invalid pos: ${n}`)}),(function(e,t){const r=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=i[n-1][0],l=i[o][0],h=i[o][3],u=Math.min(Math.floor((t-s)/4),1e3);if(u<3)return t-(t-s)%4;const d=new Float32Array(2*u);let f=o;for(let e=0;e<u;e++,f+=4){const t=i[f];d[e<<1]=t[4];d[1+(e<<1)]=t[5]}const g=[c,l,h,d];r.splice(s,4*u,a.OPS.paintImageXObjectRepeat);i.splice(s,4*u,g);return s+1}));addState(e,[a.OPS.beginText,a.OPS.setFont,a.OPS.setTextMatrix,a.OPS.showText,a.OPS.endText],null,(function iterateShowTextGroup(e,t){const r=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-4))%5;switch(n){case 0:return r[t]===a.OPS.beginText;case 1:return r[t]===a.OPS.setFont;case 2:return r[t]===a.OPS.setTextMatrix;case 3:if(r[t]!==a.OPS.showText)return!1;const n=e.iCurr-3,s=i[n][0],o=i[n][1];return i[t][0]===s&&i[t][1]===o;case 4:return r[t]===a.OPS.endText}throw new Error(`iterateShowTextGroup - invalid pos: ${n}`)}),(function(e,t){const r=e.fnArray,a=e.argsArray,i=e.iCurr,n=i-4,s=i-3,o=i-2,c=i-1,l=i,h=a[s][0],u=a[s][1];let d=Math.min(Math.floor((t-n)/5),1e3);if(d<3)return t-(t-n)%5;let f=n;if(n>=4&&r[n-4]===r[s]&&r[n-3]===r[o]&&r[n-2]===r[c]&&r[n-1]===r[l]&&a[n-4][0]===h&&a[n-4][1]===u){d++;f-=5}let g=f+4;for(let e=1;e<d;e++){r.splice(g,3);a.splice(g,3);g+=2}return g+1}));function QueueOptimizer(e){this.queue=e;this.state=null;this.context={iCurr:0,fnArray:e.fnArray,argsArray:e.argsArray};this.match=null;this.lastProcessed=0}QueueOptimizer.prototype={_optimize(){const t=this.queue.fnArray;let r=this.lastProcessed,a=t.length,i=this.state,n=this.match;if(!i&&!n&&r+1===a&&!e[t[r]]){this.lastProcessed=a;return}const s=this.context;for(;r<a;){if(n){if((0,n.iterateFn)(s,r)){r++;continue}r=(0,n.processFn)(s,r+1);a=t.length;n=null;i=null;if(r>=a)break}i=(i||e)[t[r]];if(i&&!Array.isArray(i)){s.iCurr=r;r++;if(!i.checkFn||(0,i.checkFn)(s)){n=i;i=null}else i=null}else r++}this.state=i;this.match=n;this.lastProcessed=r},push(e,t){this.queue.fnArray.push(e);this.queue.argsArray.push(t);this._optimize()},flush(){for(;this.match;){const e=this.queue.fnArray.length;this.lastProcessed=(0,this.match.processFn)(this.context,e);this.match=null;this.state=null;this._optimize()}},reset(){this.state=null;this.match=null;this.lastProcessed=0}};return QueueOptimizer}(),n=function NullOptimizerClosure(){function NullOptimizer(e){this.queue=e}NullOptimizer.prototype={push(e,t){this.queue.fnArray.push(e);this.queue.argsArray.push(t)},flush(){},reset(){}};return NullOptimizer}(),s=function OperatorListClosure(){function OperatorList(e,t){this._streamSink=t;this.fnArray=[];this.argsArray=[];this.optimizer=t&&"oplist"!==e?new i(this):new n(this);this.dependencies=new Set;this._totalLength=0;this.weight=0;this._resolved=t?null:Promise.resolve()}OperatorList.prototype={get length(){return this.argsArray.length},get ready(){return this._resolved||this._streamSink.ready},get totalLength(){return this._totalLength+this.length},addOp(e,t){this.optimizer.push(e,t);this.weight++;this._streamSink&&(this.weight>=1e3||this.weight>=995&&(e===a.OPS.restore||e===a.OPS.endText))&&this.flush()},addDependency(e){if(!this.dependencies.has(e)){this.dependencies.add(e);this.addOp(a.OPS.dependency,[e])}},addDependencies(e){for(const t of e)this.addDependency(t)},addOpList(e){if(e instanceof OperatorList){for(const t of e.dependencies)this.dependencies.add(t);for(let t=0,r=e.length;t<r;t++)this.addOp(e.fnArray[t],e.argsArray[t])}else(0,a.warn)('addOpList - ignoring invalid "opList" parameter.')},getIR(){return{fnArray:this.fnArray,argsArray:this.argsArray,length:this.length}},get _transfers(){const e=[],{fnArray:t,argsArray:r,length:i}=this;for(let n=0;n<i;n++)switch(t[n]){case a.OPS.paintInlineImageXObject:case a.OPS.paintInlineImageXObjectGroup:case a.OPS.paintImageMaskXObject:const t=r[n][0];t.cached||e.push(t.data.buffer)}return e},flush(e=!1){this.optimizer.flush();const t=this.length;this._totalLength+=t;this._streamSink.enqueue({fnArray:this.fnArray,argsArray:this.argsArray,lastChunk:e,length:t},1,this._transfers);this.dependencies.clear();this.fnArray.length=0;this.argsArray.length=0;this.weight=0;this.optimizer.reset()}};return OperatorList}();t.OperatorList=s},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFImage=void 0;var a=r(2),i=r(5),n=r(23),s=r(12),o=r(18),c=r(21);function decodeAndClamp(e,t,r,a){(e=t+e*r)<0?e=0:e>a&&(e=a);return e}function resizeImageMask(e,t,r,a,i,n){var s=i*n;let o;o=t<=8?new Uint8Array(s):t<=16?new Uint16Array(s):new Uint32Array(s);var c,l,h,u,d=r/i,f=a/n,g=0,p=new Uint16Array(i),m=r;for(c=0;c<i;c++)p[c]=Math.floor(c*d);for(c=0;c<n;c++){h=Math.floor(c*f)*m;for(l=0;l<i;l++){u=h+p[l];o[g++]=e[u]}}return o}class PDFImage{constructor({xref:e,res:t,image:r,isInline:s=!1,smask:o=null,mask:l=null,isMask:h=!1,pdfFunctionFactory:u,localColorSpaceCache:d}){this.image=r;var f=r.dict;const g=f.get("Filter");if((0,i.isName)(g))switch(g.name){case"JPXDecode":var p=new c.JpxImage;p.parseImageProperties(r.stream);r.stream.reset();r.width=p.width;r.height=p.height;r.bitsPerComponent=p.bitsPerComponent;r.numComps=p.componentsCount;break;case"JBIG2Decode":r.bitsPerComponent=1;r.numComps=1}let m=f.get("Width","W"),b=f.get("Height","H");if(Number.isInteger(r.width)&&r.width>0&&Number.isInteger(r.height)&&r.height>0&&(r.width!==m||r.height!==b)){(0,a.warn)("PDFImage - using the Width/Height of the image data, rather than the image dictionary.");m=r.width;b=r.height}if(m<1||b<1)throw new a.FormatError(`Invalid image width: ${m} or height: ${b}`);this.width=m;this.height=b;this.interpolate=f.get("Interpolate","I")||!1;this.imageMask=f.get("ImageMask","IM")||!1;this.matte=f.get("Matte")||!1;var y=r.bitsPerComponent;if(!y&&!(y=f.get("BitsPerComponent","BPC"))){if(!this.imageMask)throw new a.FormatError(`Bits per component missing in image: ${this.imageMask}`);y=1}this.bpc=y;if(!this.imageMask){let o=f.getRaw("ColorSpace")||f.getRaw("CS");if(!o){(0,a.info)("JPX images (which do not require color spaces)");switch(r.numComps){case 1:o=i.Name.get("DeviceGray");break;case 3:o=i.Name.get("DeviceRGB");break;case 4:o=i.Name.get("DeviceCMYK");break;default:throw new Error(`JPX images with ${r.numComps} color components not supported.`)}}this.colorSpace=n.ColorSpace.parse({cs:o,xref:e,resources:s?t:null,pdfFunctionFactory:u,localColorSpaceCache:d});this.numComps=this.colorSpace.numComps}this.decode=f.getArray("Decode","D");this.needsDecode=!1;if(this.decode&&(this.colorSpace&&!this.colorSpace.isDefaultDecode(this.decode,y)||h&&!n.ColorSpace.isDefaultDecode(this.decode,1))){this.needsDecode=!0;var w=(1<<y)-1;this.decodeCoefficients=[];this.decodeAddends=[];const e=this.colorSpace&&"Indexed"===this.colorSpace.name;for(var S=0,v=0;S<this.decode.length;S+=2,++v){var k=this.decode[S],x=this.decode[S+1];this.decodeCoefficients[v]=e?(x-k)/w:x-k;this.decodeAddends[v]=e?k:w*k}}if(o)this.smask=new PDFImage({xref:e,res:t,image:o,isInline:s,pdfFunctionFactory:u,localColorSpaceCache:d});else if(l)if((0,i.isStream)(l)){l.dict.get("ImageMask","IM")?this.mask=new PDFImage({xref:e,res:t,image:l,isInline:s,isMask:!0,pdfFunctionFactory:u,localColorSpaceCache:d}):(0,a.warn)("Ignoring /Mask in image without /ImageMask.")}else this.mask=l}static async buildImage({xref:e,res:t,image:r,isInline:n=!1,pdfFunctionFactory:s,localColorSpaceCache:o}){const c=r;let l=null,h=null;const u=r.dict.get("SMask"),d=r.dict.get("Mask");u?l=u:d&&((0,i.isStream)(d)||Array.isArray(d)?h=d:(0,a.warn)("Unsupported mask format."));return new PDFImage({xref:e,res:t,image:c,isInline:n,smask:l,mask:h,pdfFunctionFactory:s,localColorSpaceCache:o})}static createMask({imgArray:e,width:t,height:r,imageIsFromDecodeStream:a,inverseDecode:i}){var n,s,o=(t+7>>3)*r,c=e.byteLength;if(!a||i&&!(o===c))if(i){(n=new Uint8ClampedArray(o)).set(e);for(s=c;s<o;s++)n[s]=255}else(n=new Uint8ClampedArray(c)).set(e);else n=e;if(i)for(s=0;s<c;s++)n[s]^=255;return{data:n,width:t,height:r}}get drawWidth(){return Math.max(this.width,this.smask&&this.smask.width||0,this.mask&&this.mask.width||0)}get drawHeight(){return Math.max(this.height,this.smask&&this.smask.height||0,this.mask&&this.mask.height||0)}decodeBuffer(e){var t,r,a=this.bpc,i=this.numComps,n=this.decodeAddends,s=this.decodeCoefficients,o=(1<<a)-1;if(1!==a){var c=0;for(t=0,r=this.width*this.height;t<r;t++)for(var l=0;l<i;l++){e[c]=decodeAndClamp(e[c],n[l],s[l],o);c++}}else for(t=0,r=e.length;t<r;t++)e[t]=+!e[t]}getComponents(e){var t=this.bpc;if(8===t)return e;var r=this.width,a=this.height,i=this.numComps,n=r*a*i,s=0;let o;o=t<=8?new Uint8Array(n):t<=16?new Uint16Array(n):new Uint32Array(n);var c,l,h=r*i,u=(1<<t)-1,d=0;if(1===t)for(var f,g,p,m=0;m<a;m++){g=d+(-8&h);p=d+h;for(;d<g;){l=e[s++];o[d]=l>>7&1;o[d+1]=l>>6&1;o[d+2]=l>>5&1;o[d+3]=l>>4&1;o[d+4]=l>>3&1;o[d+5]=l>>2&1;o[d+6]=l>>1&1;o[d+7]=1&l;d+=8}if(d<p){l=e[s++];f=128;for(;d<p;){o[d++]=+!!(l&f);f>>=1}}}else{var b=0;l=0;for(d=0,c=n;d<c;++d){if(d%h==0){l=0;b=0}for(;b<t;){l=l<<8|e[s++];b+=8}var y=b-t;let r=l>>y;r<0?r=0:r>u&&(r=u);o[d]=r;l&=(1<<y)-1;b=y}}return o}fillOpacity(e,t,r,i,n){var s,o,c,l,h,u,d=this.smask,f=this.mask;if(d){o=d.width;c=d.height;s=new Uint8ClampedArray(o*c);d.fillGrayBuffer(s);o===t&&c===r||(s=resizeImageMask(s,d.bpc,o,c,t,r))}else if(f)if(f instanceof PDFImage){o=f.width;c=f.height;s=new Uint8ClampedArray(o*c);f.numComps=1;f.fillGrayBuffer(s);for(l=0,h=o*c;l<h;++l)s[l]=255-s[l];o===t&&c===r||(s=resizeImageMask(s,f.bpc,o,c,t,r))}else{if(!Array.isArray(f))throw new a.FormatError("Unknown mask format.");s=new Uint8ClampedArray(t*r);var g=this.numComps;for(l=0,h=t*r;l<h;++l){var p=0,m=l*g;for(u=0;u<g;++u){var b=n[m+u],y=2*u;if(b<f[y]||b>f[y+1]){p=255;break}}s[l]=p}}if(s)for(l=0,u=3,h=t*i;l<h;++l,u+=4)e[u]=s[l];else for(l=0,u=3,h=t*i;l<h;++l,u+=4)e[u]=255}undoPreblend(e,t,r){var a=this.smask&&this.smask.matte;if(a)for(var i=this.colorSpace.getRgb(a,0),n=i[0],s=i[1],o=i[2],c=t*r*4,l=0;l<c;l+=4){var h=e[l+3];if(0!==h){var u=255/h;e[l]=(e[l]-n)*u+n;e[l+1]=(e[l+1]-s)*u+s;e[l+2]=(e[l+2]-o)*u+o}else{e[l]=255;e[l+1]=255;e[l+2]=255}}}createImageData(e=!1){var t,r=this.drawWidth,i=this.drawHeight,n={width:r,height:i,kind:0,data:null},c=this.numComps,l=this.width,h=this.height,u=this.bpc,d=l*c*u+7>>3;if(!e){var f;"DeviceGray"===this.colorSpace.name&&1===u?f=a.ImageKind.GRAYSCALE_1BPP:"DeviceRGB"!==this.colorSpace.name||8!==u||this.needsDecode||(f=a.ImageKind.RGB_24BPP);if(f&&!this.smask&&!this.mask&&r===l&&i===h){n.kind=f;t=this.getImageBytes(h*d);if(this.image instanceof s.DecodeStream)n.data=t;else{var g=new Uint8ClampedArray(t.length);g.set(t);n.data=g}if(this.needsDecode){(0,a.assert)(f===a.ImageKind.GRAYSCALE_1BPP,"PDFImage.createImageData: The image must be grayscale.");for(var p=n.data,m=0,b=p.length;m<b;m++)p[m]^=255}return n}if(this.image instanceof o.JpegStream&&!this.smask&&!this.mask){let e=h*d;switch(this.colorSpace.name){case"DeviceGray":e*=3;case"DeviceRGB":case"DeviceCMYK":n.kind=a.ImageKind.RGB_24BPP;n.data=this.getImageBytes(e,r,i,!0);return n}}}var y,w,S=0|(t=this.getImageBytes(h*d)).length/d*i/h,v=this.getComponents(t);if(e||this.smask||this.mask){n.kind=a.ImageKind.RGBA_32BPP;n.data=new Uint8ClampedArray(r*i*4);y=1;w=!0;this.fillOpacity(n.data,r,i,S,v)}else{n.kind=a.ImageKind.RGB_24BPP;n.data=new Uint8ClampedArray(r*i*3);y=0;w=!1}this.needsDecode&&this.decodeBuffer(v);this.colorSpace.fillRgb(n.data,l,h,r,i,S,u,v,y);w&&this.undoPreblend(n.data,r,S);return n}fillGrayBuffer(e){var t=this.numComps;if(1!==t)throw new a.FormatError(`Reading gray scale from a color image: ${t}`);var r,i,n=this.width,s=this.height,o=this.bpc,c=n*t*o+7>>3,l=this.getImageBytes(s*c),h=this.getComponents(l);if(1!==o){this.needsDecode&&this.decodeBuffer(h);i=n*s;var u=255/((1<<o)-1);for(r=0;r<i;++r)e[r]=u*h[r]}else{i=n*s;if(this.needsDecode)for(r=0;r<i;++r)e[r]=h[r]-1&255;else for(r=0;r<i;++r)e[r]=255&-h[r]}}getImageBytes(e,t,r,a=!1){this.image.reset();this.image.drawWidth=t||this.width;this.image.drawHeight=r||this.height;this.image.forceRGB=!!a;return this.image.getBytes(e,!0)}}t.PDFImage=PDFImage},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.incrementalUpdate=function incrementalUpdate({originalData:e,xrefInfo:t,newRefs:r,xref:c=null,datasetsRef:l=null}){!function updateXFA(e,t,r){if(null===e||null===r)return;const i=r.fetchIfRef(e),o=(0,a.bytesToString)(i.getBytes()),c=new s.SimpleXMLParser({hasAttributes:!0}).parseFromString(o);for(const{xfa:e}of t){if(!e)continue;const{path:t,value:r}=e;if(!t)continue;const i=c.documentElement.searchNode((0,n.parseXFAPath)(t),0);i?i.childNodes=[new s.SimpleDOMNode("#text",r)]:(0,a.warn)(`Node not found for path: ${t}`)}const l=[];c.documentElement.dump(l);let h=l.join("");const u=r.encrypt;if(u){h=u.createCipherTransform(e.num,e.gen).encryptString(h)}const d=`${e.num} ${e.gen} obj\n<< /Type /EmbeddedFile /Length ${h.length}>>\nstream\n`+h+"\nendstream\nendobj\n";t.push({ref:e,data:d})}(l,r,c);const h=new i.Dict(null),u=t.newRef;let d,f;const g=e[e.length-1];if(10===g||13===g){d=[];f=e.length}else{d=["\n"];f=e.length+1}h.set("Size",u.num+1);h.set("Prev",t.startXRef);h.set("Type",i.Name.get("XRef"));null!==t.rootRef&&h.set("Root",t.rootRef);null!==t.infoRef&&h.set("Info",t.infoRef);null!==t.encrypt&&h.set("Encrypt",t.encrypt);r.push({ref:u,data:""});r=r.sort(((e,t)=>e.ref.num-t.ref.num));const p=[[0,1,65535]],m=[0,1];let b=0;for(const{ref:e,data:t}of r){b=Math.max(b,f);p.push([1,f,Math.min(e.gen,65535)]);f+=t.length;m.push(e.num);m.push(1);d.push(t)}h.set("Index",m);if(0!==t.fileIds.length){const e=function computeMD5(e,t){const r=Math.floor(Date.now()/1e3),i=t.filename||"",n=[r.toString(),i,e.toString()];let s=n.reduce(((e,t)=>e+t.length),0);for(const e of Object.values(t.info)){n.push(e);s+=e.length}const c=new Uint8Array(s);let l=0;for(const e of n){writeString(e,l,c);l+=e.length}return(0,a.bytesToString)((0,o.calculateMD5)(c))}(f,t);h.set("ID",[t.fileIds[0],e])}const y=[1,Math.ceil(Math.log2(b)/8),2],w=(y[0]+y[1]+y[2])*p.length;h.set("W",y);h.set("Length",w);d.push(`${u.num} ${u.gen} obj\n`);writeDict(h,d,null);d.push(" stream\n");const S=d.reduce(((e,t)=>e+t.length),0),v=`\nendstream\nendobj\nstartxref\n${f}\n%%EOF\n`,k=new Uint8Array(e.length+S+w+v.length);k.set(e);let x=e.length;for(const e of d){writeString(e,x,k);x+=e.length}for(const[e,t,r]of p){x=writeInt(e,y[0],x,k);x=writeInt(t,y[1],x,k);x=writeInt(r,y[2],x,k)}writeString(v,x,k);return k};t.writeDict=writeDict;var a=r(2),i=r(5),n=r(8),s=r(26),o=r(22);function writeDict(e,t,r){t.push("<<");for(const a of e.getKeys()){t.push(` /${(0,n.escapePDFName)(a)} `);writeValue(e.getRaw(a),t,r)}t.push(">>")}function writeValue(e,t,r){if((0,i.isName)(e))t.push(`/${(0,n.escapePDFName)(e.name)}`);else if((0,i.isRef)(e))t.push(`${e.num} ${e.gen} R`);else if(Array.isArray(e))!function writeArray(e,t,r){t.push("[");let a=!0;for(const i of e){a?a=!1:t.push(" ");writeValue(i,t,r)}t.push("]")}(e,t,r);else if("string"==typeof e){null!==r&&(e=r.encryptString(e));t.push(`(${(0,a.escapeString)(e)})`)}else"number"==typeof e?t.push(function numberToString(e){if(Number.isInteger(e))return e.toString();const t=Math.round(100*e);return t%100==0?(t/100).toString():t%10==0?e.toFixed(1):e.toFixed(2)}(e)):(0,i.isDict)(e)?writeDict(e,t,r):(0,i.isStream)(e)&&function writeStream(e,t,r){writeDict(e.dict,t,r);t.push(" stream\n");let i=(0,a.bytesToString)(e.getBytes());null!==r&&(i=r.encryptString(i));t.push(i);t.push("\nendstream\n")}(e,t,r)}function writeInt(e,t,r,a){for(let i=t+r-1;i>r-1;i--){a[i]=255&e;e>>=8}return r+t}function writeString(e,t,r){for(let a=0,i=e.length;a<i;a++)r[t+a]=255&e.charCodeAt(a)}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XFAFactory=void 0;var a=r(50),i=r(53),n=r(57);class XFAFactory{constructor(e){try{this.root=(new n.XFAParser).parse(XFAFactory._createDocument(e));this.form=new i.Binder(this.root).bind();this.pages=this.form[a.$toHTML]()}catch(e){console.log(e)}}getPage(e){return this.pages.children[e]}get numberPages(){return this.pages.children.length}static _createDocument(e){return e["/xdp:xdp"]?Object.values(e).join(""):e["xdp:xdp"]}}t.XFAFactory=XFAFactory},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XmlObject=t.XFAObjectArray=t.XFAObject=t.XFAAttribute=t.StringObject=t.OptionObject=t.Option10=t.Option01=t.IntegerObject=t.ContentObject=t.$uid=t.$toStyle=t.$toHTML=t.$text=t.$setValue=t.$setSetAttributes=t.$setId=t.$resolvePrototypes=t.$removeChild=t.$onText=t.$onChildCheck=t.$onChild=t.$nsAttributes=t.$nodeName=t.$namespaceId=t.$isTransparent=t.$isDescendent=t.$isDataValue=t.$insertAt=t.$indexOf=t.$hasSettableValue=t.$hasItem=t.$global=t.$getRealChildrenByNameIt=t.$getParent=t.$getChildrenByNameIt=t.$getChildrenByName=t.$getChildrenByClass=t.$getChildren=t.$getAttributeIt=t.$finalize=t.$extra=t.$dump=t.$data=t.$content=t.$consumed=t.$clone=t.$cleanup=t.$clean=t.$childrenToHTML=t.$appendChild=void 0;var a=r(51),i=r(2),n=r(52);const s=Symbol();t.$appendChild=s;const o=Symbol();t.$childrenToHTML=o;const c=Symbol();t.$clean=c;const l=Symbol();t.$cleanup=l;const h=Symbol();t.$clone=h;const u=Symbol();t.$consumed=u;const d=Symbol("content");t.$content=d;const f=Symbol("data");t.$data=f;const g=Symbol();t.$dump=g;const p=Symbol("extra");t.$extra=p;const m=Symbol();t.$finalize=m;const b=Symbol();t.$getAttributeIt=b;const y=Symbol();t.$getChildrenByClass=y;const w=Symbol();t.$getChildrenByName=w;const S=Symbol();t.$getChildrenByNameIt=S;const v=Symbol();t.$getRealChildrenByNameIt=v;const k=Symbol();t.$getChildren=k;const x=Symbol();t.$getParent=x;const C=Symbol();t.$global=C;const O=Symbol();t.$hasItem=O;const F=Symbol();t.$hasSettableValue=F;const T=Symbol();t.$indexOf=T;const E=Symbol();t.$insertAt=E;const M=Symbol();t.$isDataValue=M;const D=Symbol();t.$isDescendent=D;const N=Symbol();t.$isTransparent=N;const R=Symbol(),j=Symbol("namespaceId");t.$namespaceId=j;const L=Symbol("nodeName");t.$nodeName=L;const _=Symbol();t.$nsAttributes=_;const U=Symbol();t.$onChild=U;const X=Symbol();t.$onChildCheck=X;const q=Symbol();t.$onText=q;const $=Symbol();t.$removeChild=$;const H=Symbol();t.$resolvePrototypes=H;const z=Symbol();t.$setId=z;const G=Symbol();t.$setSetAttributes=G;const W=Symbol();t.$setValue=W;const V=Symbol();t.$text=V;const J=Symbol();t.$toHTML=J;const K=Symbol();t.$toStyle=K;const Y=Symbol("uid");t.$uid=Y;const Z=Symbol(),Q=Symbol(),ee=Symbol(),te=Symbol("_children"),re=Symbol(),ae=Symbol(),ie=Symbol(),ne=Symbol(),se=Symbol(),oe=Symbol(),ce=Symbol(),le=Symbol(),he=Symbol("parent"),ue=Symbol(),de=Symbol();let fe=0;class XFAObject{constructor(e,t,r=!1){this[j]=e;this[L]=t;this[oe]=r;this[he]=null;this[te]=[];this[Y]=`${t}${fe++}`}[U](e){if(!this[oe]||!this[X](e))return!1;const t=e[L],r=this[t];if(!(r instanceof XFAObjectArray)){null!==r&&this[$](r);this[t]=e;this[s](e);return!0}if(r.push(e)){this[s](e);return!0}let a="";this.id?a=` (id: ${this.id})`:this.name&&(a=` (name: ${this.name} ${this.h.value})`);(0,i.warn)(`XFA - node "${this[L]}"${a} has already enough "${t}"!`);return!1}[X](e){return this.hasOwnProperty(e[L])&&e[j]===this[j]}[z](e){this.id&&this[j]===n.NamespaceIds.template.id&&e.set(this.id,this)}[s](e){e[he]=this;this[te].push(e)}[$](e){const t=this[te].indexOf(e);this[te].splice(t,1)}[F](){return this.hasOwnProperty("value")}[W](e){}[q](e){}[m](){}[c](e){delete this[oe];if(this[l]){e.clean(this[l]);delete this[l]}}[O](){return!1}[T](e){return this[te].indexOf(e)}[E](e,t){t[he]=this;this[te].splice(e,0,t)}[N](){return""===this.name}[R](){return""}[V](){return 0===this[te].length?this[d]:this[te].map((e=>e[V]())).join("")}get[ee](){const e=Object.getPrototypeOf(this);if(!e._attributes){const t=e._attributes=new Set;for(const e of Object.getOwnPropertyNames(this)){if(null===this[e]||this[e]instanceof XFAObject||this[e]instanceof XFAObjectArray)break;t.add(e)}}return(0,i.shadow)(this,ee,e._attributes)}[D](e){let t=this;for(;t;){if(t===e)return!0;t=t[x]()}return!1}[x](){return this[he]}[k](e=null){return e?this[e]:this[te]}[g](){const e=Object.create(null);this[d]&&(e.$content=this[d]);for(const t of Object.getOwnPropertyNames(this)){const r=this[t];null!==r&&(r instanceof XFAObject?e[t]=r[g]():r instanceof XFAObjectArray?r.isEmpty()||(e[t]=r.dump()):e[t]=r)}return e}[K](){return null}[J](){return null}[o]({filter:e=null,include:t=!0}){const r=[];this[k]().forEach((a=>{if(!e||t===e.has(a[L])){const e=a[J]();e&&r.push(e)}}));return r}[G](e){(e.use||e.id)&&(this[ue]=new Set(Object.keys(e)))}[se](e){const t=this[ee],r=this[ue];return[...e].filter((e=>t.has(e)&&!r.has(e)))}[H](e,t=new Set){for(const r of this[te]){const a=r[ne](e,t);a?r[Z](a,e,t):r[H](e,t)}}[ne](e,t){const{use:r}=this;if(r&&r.startsWith("#")){const a=r.slice(1),n=e.get(a);this.use="";if(!n){(0,i.warn)(`XFA - Invalid prototype id: ${a}.`);return null}if(n[L]!==this[L]){(0,i.warn)(`XFA - Incompatible prototype: ${n[L]} !== ${this[L]}.`);return null}if(t.has(n)){(0,i.warn)("XFA - Cycle detected in prototypes use.");return null}t.add(n);const s=n[ne](e,t);if(!s){t.delete(n);return n}n[Z](s,e,t);t.delete(n);return n}return null}[Z](e,t,r){if(r.has(e)){(0,i.warn)("XFA - Cycle detected in prototypes use.");return}!this[d]&&e[d]&&(this[d]=e[d]);const a=new Set(r);a.add(e);for(const t of this[se](e[ue])){this[t]=e[t];this[ue]&&this[ue].add(t)}for(const i of Object.getOwnPropertyNames(this)){if(this[ee].has(i))continue;const n=this[i],s=e[i];if(n instanceof XFAObjectArray){for(const e of n[te])e[H](t,r);for(let r=n[te].length,i=s[te].length;r<i;r++){const i=e[te][r][h]();if(!n.push(i))break;i[he]=this;this[te].push(i);i[H](t,a)}}else if(null===n){if(null!==s){const e=s[h]();e[he]=this;this[i]=e;this[te].push(e);e[H](t,a)}}else n[H](t,r)}}static[re](e){return Array.isArray(e)?e.map((e=>XFAObject[re](e))):e instanceof Object?Object.assign({},e):e}[h](){const e=Object.create(Object.getPrototypeOf(this));for(const t of Object.getOwnPropertySymbols(this))try{e[t]=this[t]}catch(r){(0,i.shadow)(e,t,this[t])}e[te]=[];for(const t of Object.getOwnPropertyNames(this)){if(this[ee].has(t)){e[t]=XFAObject[re](this[t]);continue}const r=this[t];e[t]=r instanceof XFAObjectArray?new XFAObjectArray(r[ce]):null}for(const t of this[te]){const r=t[L],a=t[h]();e[te].push(a);a[he]=e;null===e[r]?e[r]=a:e[r][te].push(a)}return e}[k](e=null){return e?this[te].filter((t=>t[L]===e)):this[te]}[y](e){return this[e]}[w](e,t,r=!0){return Array.from(this[S](e,t,r))}*[S](e,t,r=!0){if("parent"!==e){for(const r of this[te]){r[L]===e&&(yield r);r.name===e&&(yield r);(t||r[N]())&&(yield*r[S](e,t,!1))}r&&this[ee].has(e)&&(yield new XFAAttribute(this,e,this[e]))}else yield this[he]}}t.XFAObject=XFAObject;class XFAObjectArray{constructor(e=1/0){this[ce]=e;this[te]=[]}push(e){if(this[te].length<=this[ce]){this[te].push(e);return!0}(0,i.warn)(`XFA - node "${e[L]}" accepts no more than ${this[ce]} children`);return!1}isEmpty(){return 0===this[te].length}dump(){return 1===this[te].length?this[te][0][g]():this[te].map((e=>e[g]()))}[h](){const e=new XFAObjectArray(this[ce]);e[te]=this[te].map((e=>e[h]()));return e}get children(){return this[te]}clear(){this[te].length=0}}t.XFAObjectArray=XFAObjectArray;class XFAAttribute{constructor(e,t,r){this[he]=e;this[L]=t;this[d]=r;this[u]=!1}[x](){return this[he]}[M](){return!0}[V](){return this[d]}[D](e){return this[he]===e||this[he][D](e)}}t.XFAAttribute=XFAAttribute;class XmlObject extends XFAObject{constructor(e,t,r={}){super(e,t);this[d]="";this[ae]=null;if("#text"!==t){const e=new Map;this[Q]=e;for(const[t,a]of Object.entries(r))e.set(t,new XFAAttribute(this,t,a));if(r.hasOwnProperty(_)){const e=r[_].xfa.dataNode;void 0!==e&&("dataGroup"===e?this[ae]=!1:"dataValue"===e&&(this[ae]=!0))}}this[u]=!1}[U](e){if(this[d]){const e=new XmlObject(this[j],"#text");this[s](e);e[d]=this[d];this[d]=""}this[s](e);return!0}[q](e){this[d]+=e}[m](){if(this[d]&&this[te].length>0){const e=new XmlObject(this[j],"#text");this[s](e);e[d]=this[d];delete this[d]}}[J](){return"#text"===this[L]?{name:"#text",value:this[d]}:null}[k](e=null){return e?this[te].filter((t=>t[L]===e)):this[te]}[y](e){const t=this[Q].get(e);return void 0!==t?t:this[k](e)}*[S](e,t){const r=this[Q].get(e);r&&(yield r);for(const r of this[te]){r[L]===e&&(yield r);t&&(yield*r[S](e,t))}}*[b](e,t){const r=this[Q].get(e);!r||t&&r[u]||(yield r);for(const r of this[te])yield*r[b](e,t)}*[v](e,t,r){for(const a of this[te]){a[L]!==e||r&&a[u]||(yield a);t&&(yield*a[v](e,t,r))}}[M](){return null===this[ae]?0===this[te].length:this[ae]}[g](){const e=Object.create(null);this[d]&&(e.$content=this[d]);e.$name=this[L];e.children=[];for(const t of this[te])e.children.push(t[g]());e.attributes=Object.create(null);for(const[t,r]of this[Q])e.attributes[t]=r[d];return e}}t.XmlObject=XmlObject;class ContentObject extends XFAObject{constructor(e,t){super(e,t);this[d]=""}[q](e){this[d]+=e}[m](){}}t.ContentObject=ContentObject;t.OptionObject=class OptionObject extends ContentObject{constructor(e,t,r){super(e,t);this[le]=r}[m](){this[d]=(0,a.getKeyword)({data:this[d],defaultValue:this[le][0],validate:e=>this[le].includes(e)})}[c](e){super[c](e);delete this[le]}};t.StringObject=class StringObject extends ContentObject{[m](){this[d]=this[d].trim()}};class IntegerObject extends ContentObject{constructor(e,t,r,a){super(e,t);this[ie]=r;this[de]=a}[m](){this[d]=(0,a.getInteger)({data:this[d],defaultValue:this[ie],validate:this[de]})}[c](e){super[c](e);delete this[ie];delete this[de]}}t.IntegerObject=IntegerObject;t.Option01=class Option01 extends IntegerObject{constructor(e,t){super(e,t,0,(e=>1===e))}};t.Option10=class Option10 extends IntegerObject{constructor(e,t){super(e,t,1,(e=>0===e))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.getBBox=function getBBox(e){const t=-1;if(!e)return{x:t,y:t,width:t,height:t};const r=e.trim().split(/\s*,\s*/).map((e=>getMeasurement(e,"-1")));if(r.length<4||r[2]<0||r[3]<0)return{x:t,y:t,width:t,height:t};const[a,i,n,s]=r;return{x:a,y:i,width:n,height:s}};t.getColor=function getColor(e,t=[0,0,0]){let[r,a,i]=t;if(!e)return{r:r,g:a,b:i};const n=e.trim().split(/\s*,\s*/).map((e=>Math.min(Math.max(0,parseInt(e.trim(),10)),255))).map((e=>isNaN(e)?0:e));if(n.length<3)return{r:r,g:a,b:i};[r,a,i]=n;return{r:r,g:a,b:i}};t.getFloat=function getFloat({data:e,defaultValue:t,validate:r}){if(!e)return t;e=e.trim();const a=parseFloat(e);if(!isNaN(a)&&r(a))return a;return t};t.getInteger=function getInteger({data:e,defaultValue:t,validate:r}){if(!e)return t;e=e.trim();const a=parseInt(e,10);if(!isNaN(a)&&r(a))return a;return t};t.getKeyword=getKeyword;t.getMeasurement=getMeasurement;t.getRatio=function getRatio(e){if(!e)return{num:1,den:1};const t=e.trim().split(/\s*:\s*/).map((e=>parseFloat(e))).filter((e=>!isNaN(e)));1===t.length&&t.push(1);if(0===t.length)return{num:1,den:1};const[r,a]=t;return{num:r,den:a}};t.getRelevant=function getRelevant(e){if(!e)return[];return e.trim().split(/\s+/).map((e=>({excluded:"-"===e[0],viewname:e.substring(1)})))};t.getStringOption=function getStringOption(e,t){return getKeyword({data:e,defaultValue:t[0],validate:e=>t.includes(e)})};const r={pt:e=>e,cm:e=>e/2.54*72,mm:e=>e/25.4*72,in:e=>72*e},a=/([+-]?[0-9]+\.?[0-9]*)(.*)/;function getKeyword({data:e,defaultValue:t,validate:r}){return e&&r(e=e.trim())?e:t}function getMeasurement(e,t="0"){t=t||"0";if(!e)return getMeasurement(t);const i=e.trim().match(a);if(!i)return getMeasurement(t);const[,n,s]=i,o=parseFloat(n);if(isNaN(o))return getMeasurement(t);if(0===o)return 0;const c=r[s];return c?c(o):o}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NamespaceIds=t.$buildXFAObject=void 0;const r=Symbol();t.$buildXFAObject=r;t.NamespaceIds={config:{id:0,check:e=>e.startsWith("http://www.xfa.org/schema/xci/")},connectionSet:{id:1,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-connection-set/")},datasets:{id:2,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-data/")},form:{id:3,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-form/")},localeSet:{id:4,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-locale-set/")},pdf:{id:5,check:e=>"http://ns.adobe.com/xdp/pdf/"===e},signature:{id:6,check:e=>"http://www.w3.org/2000/09/xmldsig#"===e},sourceSet:{id:7,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-source-set/")},stylesheet:{id:8,check:e=>"http://www.w3.org/1999/XSL/Transform"===e},template:{id:9,check:e=>e.startsWith("http://www.xfa.org/schema/xfa-template/")},xdc:{id:10,check:e=>e.startsWith("http://www.xfa.org/schema/xdc/")},xdp:{id:11,check:e=>"http://ns.adobe.com/xdp/"===e},xfdf:{id:12,check:e=>"http://ns.adobe.com/xfdf/"===e},xhtml:{id:13,check:e=>"http://www.w3.org/1999/xhtml"===e},xmpmeta:{id:14,check:e=>"http://ns.adobe.com/xmpmeta/"===e}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Binder=void 0;var a=r(50),i=r(54),n=r(56),s=r(52),o=r(2);function createText(e){const t=new i.Text({});t[a.$content]=e;return t}t.Binder=class Binder{constructor(e){this.root=e;this.datasets=e.datasets;if(e.datasets&&e.datasets.data){this.emptyMerge=!1;this.data=e.datasets.data}else{this.emptyMerge=!0;this.data=new a.XmlObject(s.NamespaceIds.datasets.id,"data")}this.root.form=this.form=e.template[a.$clone]()}_isConsumeData(){return!this.emptyMerge&&this._mergeMode}_isMatchTemplate(){return!this._isConsumeData()}bind(){this._bindElement(this.form,this.data);return this.form}getData(){return this.data}_bindValue(e,t,r){if(e[a.$hasSettableValue]())if(t[a.$isDataValue]()){const r=t[a.$content].trim();e[a.$setValue](createText(r));e[a.$data]=t}else if(e instanceof i.Field&&e.ui&&e.ui.choiceList&&"multiSelect"===e.ui.choiceList.open){const r=t[a.$getChildren]().map((e=>e[a.$content].trim())).join("\n");e[a.$setValue](createText(r));e[a.$data]=t}else this._isConsumeData()&&(0,o.warn)("XFA - Nodes haven't the same type.");else if(!t[a.$isDataValue]()||this._isMatchTemplate()){this._bindElement(e,t);e[a.$data]=t}else(0,o.warn)("XFA - Nodes haven't the same type.")}_findDataByNameToConsume(e,t,r){if(!e)return null;let i,n;for(let r=0;r<3;r++){i=t[a.$getRealChildrenByNameIt](e,!1,!0);n=i.next().value;if(n)return n;if(t[a.$namespaceId]===s.NamespaceIds.datasets.id&&"data"===t[a.$nodeName])break;t=t[a.$getParent]()}if(!r)return null;i=this.datasets[a.$getRealChildrenByNameIt](e,!1,!1);for(;;){n=i.next().value;if(!n)break;if(n[a.$global])return n}i=this.data[a.$getAttributeIt](e,!0);n=i.next().value;return n&&n[a.$isDataValue]()?n:null}_setProperties(e,t){if(e.hasOwnProperty("setProperty"))for(const{ref:r,target:s,connection:c}of e.setProperty.children){if(c)continue;if(!r)continue;const[l]=(0,n.searchNode)(this.root,t,r,!1,!1);if(!l){(0,o.warn)(`XFA - Invalid reference: ${r}.`);continue}if(!l[a.$isDescendent](this.data)){(0,o.warn)("XFA - Invalid node: must be a data node.");continue}const[h]=(0,n.searchNode)(this.root,e,s,!1,!1);if(!h){(0,o.warn)(`XFA - Invalid target: ${s}.`);continue}if(!h[a.$isDescendent](e)){(0,o.warn)("XFA - Invalid target: must be a property or subproperty.");continue}const u=h[a.$getParent]();if(h instanceof i.SetProperty||u instanceof i.SetProperty){(0,o.warn)("XFA - Invalid target: cannot be a setProperty or one of its properties.");continue}if(h instanceof i.BindItems||u instanceof i.BindItems){(0,o.warn)("XFA - Invalid target: cannot be a bindItems or one of its properties.");continue}const d=l[a.$text](),f=h[a.$nodeName];if(h instanceof a.XFAAttribute){const e=Object.create(null);e[f]=d;const t=Reflect.construct(Object.getPrototypeOf(u).constructor,[e]);u[f]=t[f]}else if(h.hasOwnProperty(a.$content)){h[a.$data]=l;h[a.$content]=d;h[a.$finalize]()}else(0,o.warn)("XFA - Invalid node to use in setProperty")}}_bindItems(e,t){if(!e.hasOwnProperty("items")||!e.hasOwnProperty("bindItems")||e.bindItems.isEmpty())return;for(const t of e.items.children)e[a.$removeChild](t);e.items.clear();const r=new i.Items({}),s=new i.Items({});e[a.$appendChild](r);e.items.push(r);e[a.$appendChild](s);e.items.push(s);for(const{ref:i,labelRef:c,valueRef:l,connection:h}of e.bindItems.children){if(h)continue;if(!i)continue;const e=(0,n.searchNode)(this.root,t,i,!1,!1);if(e)for(const t of e){if(!t[a.$isDescendent](this.datasets)){(0,o.warn)(`XFA - Invalid ref (${i}): must be a datasets child.`);continue}const[e]=(0,n.searchNode)(this.root,t,c,!0,!1);if(!e){(0,o.warn)(`XFA - Invalid label: ${c}.`);continue}if(!e[a.$isDescendent](this.datasets)){(0,o.warn)("XFA - Invalid label: must be a datasets child.");continue}const[h]=(0,n.searchNode)(this.root,t,l,!0,!1);if(!h){(0,o.warn)(`XFA - Invalid value: ${l}.`);continue}if(!h[a.$isDescendent](this.datasets)){(0,o.warn)("XFA - Invalid value: must be a datasets child.");continue}const u=createText(e[a.$text]()),d=createText(h[a.$text]());r[a.$appendChild](u);r.text.push(u);s[a.$appendChild](d);s.text.push(d)}else(0,o.warn)(`XFA - Invalid reference: ${i}.`)}}_bindOccurrences(e,t,r){let i;t.length>1&&(i=e[a.$clone]());this._bindValue(e,t[0],r);this._setProperties(e,t[0]);this._bindItems(e,t[0]);if(1===t.length)return;const n=e[a.$getParent](),s=e[a.$nodeName],o=n[a.$indexOf](e);for(let e=1,c=t.length;e<c;e++){const c=t[e],l=i[a.$clone]();l.occur.min=1;l.occur.max=1;l.occur.initial=1;n[s].push(l);n[a.$insertAt](o+e,l);this._bindValue(l,c,r);this._setProperties(l,c);this._bindItems(l,c)}}_createOccurrences(e){if(!this.emptyMerge)return;const{occur:t}=e;if(!t||t.initial<=1)return;const r=e[a.$getParent](),i=e[a.$nodeName];for(let n=0,s=t.initial;n<s;n++){const t=e[a.$clone]();t.occur.min=1;t.occur.max=1;t.occur.initial=1;r[i].push(t);r[a.$appendChild](t)}}_getOccurInfo(e){const{occur:t}=e,r=e.name;if(!t||!r)return[1,1];const a=-1===t.max?1/0:t.max;return[t.min,a]}_bindElement(e,t){const r=[];this._createOccurrences(e);for(const i of e[a.$getChildren]()){if(i[a.$data])continue;void 0===this._mergeMode&&"subform"===i[a.$nodeName]&&(this._mergeMode="consumeData"===i.mergeMode);let s=!1,c=null,l=null,h=null;if(i.bind){switch(i.bind.match){case"none":continue;case"global":s=!0;break;case"dataRef":if(!i.bind.ref){(0,o.warn)(`XFA - ref is empty in node ${i[a.$nodeName]}.`);continue}l=i.bind.ref}i.bind.picture&&(c=i.bind.picture[a.$content])}const[u,d]=this._getOccurInfo(i);if(l){h=(0,n.searchNode)(this.root,t,l,!0,!1);if(null===h){h=(0,n.createDataNode)(this.data,t,l);this._isConsumeData()&&(h[a.$consumed]=!0);h=[h]}else{this._isConsumeData()&&(h=h.filter((e=>!e[a.$consumed])));h.length>d?h=h.slice(0,d):0===h.length&&(h=null);h&&this._isConsumeData()&&h.forEach((e=>{e[a.$consumed]=!0}))}}else{if(!i.name){this._bindElement(i,t);continue}if(this._isConsumeData()){const e=[];for(;e.length<d;){const r=this._findDataByNameToConsume(i.name,t,s);if(!r)break;r[a.$consumed]=!0;e.push(r)}h=e.length>0?e:null}else{h=t[a.$getRealChildrenByNameIt](i.name,!1,!1).next().value;if(!h){h=new a.XmlObject(t[a.$namespaceId],i.name);t[a.$appendChild](h)}h=[h]}}if(h){if(h.length<u){(0,o.warn)(`XFA - Must have at least ${u} occurrences: ${e[a.$nodeName]}.`);continue}this._bindOccurrences(i,h,c)}else u>0?this._bindElement(i,t):r.push(i)}r.forEach((e=>e[a.$getParent]()[a.$removeChild](e)))}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Value=t.Text=t.TemplateNamespace=t.Template=t.SetProperty=t.Items=t.Field=t.BindItems=void 0;var a=r(50),i=r(52),n=r(51),s=r(55),o=r(2);const c=i.NamespaceIds.template.id;function _setValue(e,t){if(!e.value){const t=new Value({});e[a.$appendChild](t);e.value=t}e.value[a.$setValue](t)}class AppearanceFilter extends a.StringObject{constructor(e){super(c,"appearanceFilter");this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Arc extends a.XFAObject{constructor(e){super(c,"arc",!0);this.circular=(0,n.getInteger)({data:e.circular,defaultValue:0,validate:e=>1===e});this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]);this.id=e.id||"";this.startAngle=(0,n.getFloat)({data:e.startAngle,defaultValue:0,validate:e=>!0});this.sweepAngle=(0,n.getFloat)({data:e.sweepAngle,defaultValue:360,validate:e=>!0});this.use=e.use||"";this.usehref=e.usehref||"";this.edge=null;this.fill=null}}class Area extends a.XFAObject{constructor(e){super(c,"area",!0);this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1});this.id=e.id||"";this.name=e.name||"";this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.desc=null;this.extras=null;this.area=new a.XFAObjectArray;this.draw=new a.XFAObjectArray;this.exObject=new a.XFAObjectArray;this.exclGroup=new a.XFAObjectArray;this.field=new a.XFAObjectArray;this.subform=new a.XFAObjectArray;this.subformSet=new a.XFAObjectArray}[a.$isTransparent](){return!0}}class Assist extends a.XFAObject{constructor(e){super(c,"assist",!0);this.id=e.id||"";this.role=e.role||"";this.use=e.use||"";this.usehref=e.usehref||"";this.speak=null;this.toolTip=null}}class Barcode extends a.XFAObject{constructor(e){super(c,"barcode",!0);this.charEncoding=(0,n.getKeyword)({data:e.charEncoding?e.charEncoding.toLowerCase():"",defaultValue:"",validate:e=>["utf-8","big-five","fontspecific","gbk","gb-18030","gb-2312","ksc-5601","none","shift-jis","ucs-2","utf-16"].includes(e)||e.match(/iso-8859-[0-9]{2}/)});this.checksum=(0,n.getStringOption)(e.checksum,["none","1mod10","1mod10_1mod11","2mod10","auto"]);this.dataColumnCount=(0,n.getInteger)({data:e.dataColumnCount,defaultValue:-1,validate:e=>e>=0});this.dataLength=(0,n.getInteger)({data:e.dataLength,defaultValue:-1,validate:e=>e>=0});this.dataPrep=(0,n.getStringOption)(e.dataPrep,["none","flateCompress"]);this.dataRowCount=(0,n.getInteger)({data:e.dataRowCount,defaultValue:-1,validate:e=>e>=0});this.endChar=e.endChar||"";this.errorCorrectionLevel=(0,n.getInteger)({data:e.errorCorrectionLevel,defaultValue:-1,validate:e=>e>=0&&e<=8});this.id=e.id||"";this.moduleHeight=(0,n.getMeasurement)(e.moduleHeight,"5mm");this.moduleWidth=(0,n.getMeasurement)(e.moduleWidth,"0.25mm");this.printCheckDigit=(0,n.getInteger)({data:e.printCheckDigit,defaultValue:0,validate:e=>1===e});this.rowColumnRatio=(0,n.getRatio)(e.rowColumnRatio);this.startChar=e.startChar||"";this.textLocation=(0,n.getStringOption)(e.textLocation,["below","above","aboveEmbedded","belowEmbedded","none"]);this.truncate=(0,n.getInteger)({data:e.truncate,defaultValue:0,validate:e=>1===e});this.type=(0,n.getStringOption)(e.type?e.type.toLowerCase():"",["aztec","codabar","code2of5industrial","code2of5interleaved","code2of5matrix","code2of5standard","code3of9","code3of9extended","code11","code49","code93","code128","code128a","code128b","code128c","code128sscc","datamatrix","ean8","ean8add2","ean8add5","ean13","ean13add2","ean13add5","ean13pwcd","fim","logmars","maxicode","msi","pdf417","pdf417macro","plessey","postauscust2","postauscust3","postausreplypaid","postausstandard","postukrm4scc","postusdpbc","postusimb","postusstandard","postus5zip","qrcode","rfid","rss14","rss14expanded","rss14limited","rss14stacked","rss14stackedomni","rss14truncated","telepen","ucc128","ucc128random","ucc128sscc","upca","upcaadd2","upcaadd5","upcapwcd","upce","upceadd2","upceadd5","upcean2","upcean5","upsmaxicode"]);this.upsMode=(0,n.getStringOption)(e.upsMode,["usCarrier","internationalCarrier","secureSymbol","standardSymbol"]);this.use=e.use||"";this.usehref=e.usehref||"";this.wideNarrowRatio=(0,n.getRatio)(e.wideNarrowRatio);this.encrypt=null;this.extras=null}}class Bind extends a.XFAObject{constructor(e){super(c,"bind",!0);this.match=(0,n.getStringOption)(e.match,["once","dataRef","global","none"]);this.ref=e.ref||"";this.picture=null}}class BindItems extends a.XFAObject{constructor(e){super(c,"bindItems");this.connection=e.connection||"";this.labelRef=e.labelRef||"";this.ref=e.ref||"";this.valueRef=e.valueRef||""}}t.BindItems=BindItems;class Bookend extends a.XFAObject{constructor(e){super(c,"bookend");this.id=e.id||"";this.leader=e.leader||"";this.trailer=e.trailer||"";this.use=e.use||"";this.usehref=e.usehref||""}}class BooleanElement extends a.Option01{constructor(e){super(c,"boolean");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$toHTML](){return 1===this[a.$content]}}class Border extends a.XFAObject{constructor(e){super(c,"border",!0);this.break=(0,n.getStringOption)(e.break,["close","open"]);this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]);this.id=e.id||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.corner=new a.XFAObjectArray(4);this.edge=new a.XFAObjectArray(4);this.extras=null;this.fill=null;this.margin=null}[a.$toStyle](e,t){const r=this.edge.children.map((e=>e[a.$toStyle]())),i=this.edge.children.map((e=>e[a.$toStyle]()));let n;if(this.margin){n=this.margin[a.$toStyle]();t&&t.push(this.margin.topInset,this.margin.rightInset,this.margin.bottomInset,this.margin.leftInset)}else{n=Object.create(null);t&&t.push(0,0,0,0)}this.fill&&Object.assign(n,this.fill[a.$toStyle]());if(r.length>0){if(e){this.edge.children.forEach((t=>e.push(t.thickness)));if(e.length<4){const t=e[e.length-1];for(let r=e.length;r<4;r++)e.push(t)}}if(2===r.length||3===r.length){const e=r[r.length-1];for(let t=r.length;t<4;t++)r.push(e)}n.borderWidth=r.map((e=>e.width)).join(" ");n.borderColor=r.map((e=>e.color)).join(" ");n.borderStyle=r.map((e=>e.style)).join(" ")}else e&&e.push(0,0,0,0);if(i.length>0){if(2===i.length||3===i.length){const e=i[i.length-1];for(let t=i.length;t<4;t++)i.push(e)}n.borderRadius=i.map((e=>e.radius)).join(" ")}switch(this.presence){case"invisible":case"hidden":n.borderStyle="";break;case"inactive":n.borderStyle="none"}return n}}class Break extends a.XFAObject{constructor(e){super(c,"break",!0);this.after=(0,n.getStringOption)(e.after,["auto","contentArea","pageArea","pageEven","pageOdd"]);this.afterTarget=e.afterTarget||"";this.before=(0,n.getStringOption)(e.before,["auto","contentArea","pageArea","pageEven","pageOdd"]);this.beforeTarget=e.beforeTarget||"";this.bookendLeader=e.bookendLeader||"";this.bookendTrailer=e.bookendTrailer||"";this.id=e.id||"";this.overflowLeader=e.overflowLeader||"";this.overflowTarget=e.overflowTarget||"";this.overflowTrailer=e.overflowTrailer||"";this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e});this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}}class BreakAfter extends a.XFAObject{constructor(e){super(c,"breakAfter",!0);this.id=e.id||"";this.leader=e.leader||"";this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e});this.target=e.target||"";this.targetType=(0,n.getStringOption)(e.targetType,["auto","contentArea","pageArea","pageEven","pageOdd"]);this.trailer=e.trailer||"";this.use=e.use||"";this.usehref=e.usehref||"";this.script=null}}class BreakBefore extends a.XFAObject{constructor(e){super(c,"breakBefore",!0);this.id=e.id||"";this.leader=e.leader||"";this.startNew=(0,n.getInteger)({data:e.startNew,defaultValue:0,validate:e=>1===e});this.target=e.target||"";this.targetType=(0,n.getStringOption)(e.targetType,["auto","contentArea","pageArea","pageEven","pageOdd"]);this.trailer=e.trailer||"";this.use=e.use||"";this.usehref=e.usehref||"";this.script=null}}class Button extends a.XFAObject{constructor(e){super(c,"button",!0);this.highlight=(0,n.getStringOption)(e.highlight,["inverted","none","outline","push"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}[a.$toHTML](){return{name:"button",attributes:{class:"xfaButton",style:{}}}}}class Calculate extends a.XFAObject{constructor(e){super(c,"calculate",!0);this.id=e.id||"";this.override=(0,n.getStringOption)(e.override,["disabled","error","ignore","warning"]);this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.message=null;this.script=null}}class Caption extends a.XFAObject{constructor(e){super(c,"caption",!0);this.id=e.id||"";this.placement=(0,n.getStringOption)(e.placement,["left","bottom","inline","right","top"]);this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.reserve=(0,n.getMeasurement)(e.reserve);this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.font=null;this.margin=null;this.para=null;this.value=null}[a.$setValue](e){_setValue(this,e)}[a.$toHTML](){if(!this.value)return null;const e=this.value[a.$toHTML]();if(!e)return null;const t=[];"string"==typeof e?t.push({name:"#text",value:e}):t.push(e);const r=(0,s.toStyle)(this,"font","margin","para","visibility");switch(this.placement){case"left":case"right":r.minWidth=(0,s.measureToString)(this.reserve);break;case"top":case"bottom":r.minHeight=(0,s.measureToString)(this.reserve)}return{name:"div",attributes:{style:r},children:t}}}class Certificate extends a.StringObject{constructor(e){super(c,"certificate");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Certificates extends a.XFAObject{constructor(e){super(c,"certificates",!0);this.credentialServerPolicy=(0,n.getStringOption)(e.credentialServerPolicy,["optional","required"]);this.id=e.id||"";this.url=e.url||"";this.urlPolicy=e.urlPolicy||"";this.use=e.use||"";this.usehref=e.usehref||"";this.encryption=null;this.issuers=null;this.keyUsage=null;this.oids=null;this.signing=null;this.subjectDNs=null}}class CheckButton extends a.XFAObject{constructor(e){super(c,"checkButton",!0);this.id=e.id||"";this.mark=(0,n.getStringOption)(e.mark,["default","check","circle","cross","diamond","square","star"]);this.shape=(0,n.getStringOption)(e.shape,["square","round"]);this.size=(0,n.getMeasurement)(e.size,"10pt");this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.extras=null;this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","margin"),t=(0,s.measureToString)(this.size);e.width=e.height=t;let r,a;if("square"===this.shape){r="■";a="10%"}else{r="●";a="50%"}e.borderRadius||(e.borderRadius=a);if("default"!==this.mark)switch(this.mark){case"check":r="✓";break;case"circle":r="●";break;case"cross":r="✕";break;case"diamond":r="♦";break;case"square":r="■";break;case"star":r="★"}if("10px"!==t){e.fontSize=t;e.lineHeight=t;e.width=t;e.height=t}return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{class:"xfaCheckbox",type:"checkbox"}},{name:"span",attributes:{class:"xfaCheckboxMark",mark:r,style:e}}]}}}class ChoiceList extends a.XFAObject{constructor(e){super(c,"choiceList",!0);this.commitOn=(0,n.getStringOption)(e.commitOn,["select","exit"]);this.id=e.id||"";this.open=(0,n.getStringOption)(e.open,["userControl","always","multiSelect","onEntry"]);this.textEntry=(0,n.getInteger)({data:e.textEntry,defaultValue:0,validate:e=>1===e});this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.extras=null;this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","margin");return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"select",attributes:{class:"xfaSxelect",multiple:"multiSelect"===this.open,style:e}}]}}}class Color extends a.XFAObject{constructor(e){super(c,"color",!0);this.cSpace=(0,n.getStringOption)(e.cSpace,["SRGB"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.value=(0,n.getColor)(e.value);this.extras=null}[a.$hasSettableValue](){return!1}[a.$toStyle](){return o.Util.makeHexColor(this.value.r,this.value.g,this.value.b)}}class Comb extends a.XFAObject{constructor(e){super(c,"comb");this.id=e.id||"";this.numberOfCells=(0,n.getInteger)({data:e.numberOfCells,defaultValue:0,validate:e=>e>=0});this.use=e.use||"";this.usehref=e.usehref||""}}class Connect extends a.XFAObject{constructor(e){super(c,"connect",!0);this.connection=e.connection||"";this.id=e.id||"";this.ref=e.ref||"";this.usage=(0,n.getStringOption)(e.usage,["exportAndImport","exportOnly","importOnly"]);this.use=e.use||"";this.usehref=e.usehref||"";this.picture=null}}class ContentArea extends a.XFAObject{constructor(e){super(c,"contentArea",!0);this.h=(0,n.getMeasurement)(e.h);this.id=e.id||"";this.name=e.name||"";this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.w=(0,n.getMeasurement)(e.w);this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.desc=null;this.extras=null}[a.$toHTML](){return{name:"div",children:[],attributes:{style:{position:"absolute",left:(0,s.measureToString)(this.x),top:(0,s.measureToString)(this.y),width:(0,s.measureToString)(this.w),height:(0,s.measureToString)(this.h)},class:"xfaContentarea",id:this[a.$uid]}}}}class Corner extends a.XFAObject{constructor(e){super(c,"corner",!0);this.id=e.id||"";this.inverted=(0,n.getInteger)({data:e.inverted,defaultValue:0,validate:e=>1===e});this.join=(0,n.getStringOption)(e.join,["square","round"]);this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.radius=(0,n.getMeasurement)(e.radius);this.stroke=(0,n.getStringOption)(e.stroke,["solid","dashDot","dashDotDot","dashed","dotted","embossed","etched","lowered","raised"]);this.thickness=(0,n.getMeasurement)(e.thickness,"0.5pt");this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"visibility");e.radius=(0,s.measureToString)(this.radius);return e}}class DateElement extends a.ContentObject{constructor(e){super(c,"date");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content].trim())}[a.$toHTML](){return this[a.$content].toString()}}class DateTime extends a.ContentObject{constructor(e){super(c,"dateTime");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content].trim())}[a.$toHTML](){return this[a.$content].toString()}}class DateTimeEdit extends a.XFAObject{constructor(e){super(c,"dateTimeEdit",!0);this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]);this.id=e.id||"";this.picker=(0,n.getStringOption)(e.picker,["host","none"]);this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.comb=null;this.extras=null;this.margin=null}[a.$toHTML](){return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{type:"text",class:"xfaTextfield",style:(0,s.toStyle)(this,"border","font","margin")}}]}}}class Decimal extends a.ContentObject{constructor(e){super(c,"decimal");this.fracDigits=(0,n.getInteger)({data:e.fracDigits,defaultValue:2,validate:e=>!0});this.id=e.id||"";this.leadDigits=(0,n.getInteger)({data:e.leadDigits,defaultValue:-1,validate:e=>!0});this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){const e=parseFloat(this[a.$content].trim());this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class DefaultUi extends a.XFAObject{constructor(e){super(c,"defaultUi",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}}class Desc extends a.XFAObject{constructor(e){super(c,"desc",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.boolean=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.time=new a.XFAObjectArray}}class DigestMethod extends a.OptionObject{constructor(e){super(c,"digestMethod",["","SHA1","SHA256","SHA512","RIPEMD160"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||""}}class DigestMethods extends a.XFAObject{constructor(e){super(c,"digestMethods",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.digestMethod=new a.XFAObjectArray}}class Draw extends a.XFAObject{constructor(e){super(c,"draw",!0);this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]);this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1});this.h=e.h?(0,n.getMeasurement)(e.h):"";this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]);this.id=e.id||"";this.locale=e.locale||"";this.maxH=(0,n.getMeasurement)(e.maxH,"0pt");this.maxW=(0,n.getMeasurement)(e.maxW,"0pt");this.minH=(0,n.getMeasurement)(e.minH,"0pt");this.minW=(0,n.getMeasurement)(e.minW,"0pt");this.name=e.name||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.relevant=(0,n.getRelevant)(e.relevant);this.rotate=(0,n.getInteger)({data:e.rotate,defaultValue:0,validate:e=>e%90==0});this.use=e.use||"";this.usehref=e.usehref||"";this.w=e.w?(0,n.getMeasurement)(e.w):"";this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.assist=null;this.border=null;this.caption=null;this.desc=null;this.extras=null;this.font=null;this.keep=null;this.margin=null;this.para=null;this.traversal=null;this.ui=null;this.value=null;this.setProperty=new a.XFAObjectArray}[a.$setValue](e){_setValue(this,e)}[a.$toHTML](){if(!this.value)return null;const e=(0,s.toStyle)(this,"font","dimensions","position","presence","rotate","anchorType"),t=["xfaDraw"];this.font&&t.push("xfaFont");const r={style:e,id:this[a.$uid],class:t.join(" ")};this.name&&(r.xfaName=this.name);return{name:"div",attributes:r,children:[]}}}class Edge extends a.XFAObject{constructor(e){super(c,"edge",!0);this.cap=(0,n.getStringOption)(e.cap,["square","butt","round"]);this.id=e.id||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.stroke=(0,n.getStringOption)(e.stroke,["solid","dashDot","dashDotDot","dashed","dotted","embossed","etched","lowered","raised"]);this.thickness=(0,n.getMeasurement)(e.thickness,"0.5pt");this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"visibility");Object.assign(e,{linecap:this.cap,width:(0,s.measureToString)(this.thickness),color:this.color?this.color[a.$toHTML]():"#000000",style:""});if("visible"!==this.presence)e.style="none";else switch(this.stroke){case"solid":e.style="solid";break;case"dashDot":case"dashDotDot":case"dashed":e.style="dashed";break;case"dotted":e.style="dotted";break;case"embossed":e.style="ridge";break;case"etched":e.style="groove";break;case"lowered":e.style="inset";break;case"raised":e.style="outset"}return e}}class Encoding extends a.OptionObject{constructor(e){super(c,"encoding",["adbe.x509.rsa_sha1","adbe.pkcs7.detached","adbe.pkcs7.sha1"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Encodings extends a.XFAObject{constructor(e){super(c,"encodings",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.encoding=new a.XFAObjectArray}}class Encrypt extends a.XFAObject{constructor(e){super(c,"encrypt",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.certificate=null}}class EncryptData extends a.XFAObject{constructor(e){super(c,"encryptData",!0);this.id=e.id||"";this.operation=(0,n.getStringOption)(e.operation,["encrypt","decrypt"]);this.target=e.target||"";this.use=e.use||"";this.usehref=e.usehref||"";this.filter=null;this.manifest=null}}class Encryption extends a.XFAObject{constructor(e){super(c,"encryption",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.certificate=new a.XFAObjectArray}}class EncryptionMethod extends a.OptionObject{constructor(e){super(c,"encryptionMethod",["","AES256-CBC","TRIPLEDES-CBC","AES128-CBC","AES192-CBC"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||""}}class EncryptionMethods extends a.XFAObject{constructor(e){super(c,"encryptionMethods",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.encryptionMethod=new a.XFAObjectArray}}class Event extends a.XFAObject{constructor(e){super(c,"event",!0);this.activity=(0,n.getStringOption)(e.activity,["click","change","docClose","docReady","enter","exit","full","indexChange","initialize","mouseDown","mouseEnter","mouseExit","mouseUp","postExecute","postOpen","postPrint","postSave","postSign","postSubmit","preExecute","preOpen","prePrint","preSave","preSign","preSubmit","ready","validationState"]);this.id=e.id||"";this.listen=(0,n.getStringOption)(e.listen,["refOnly","refAndDescendents"]);this.name=e.name||"";this.ref=e.ref||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.encryptData=null;this.execute=null;this.script=null;this.signData=null;this.submit=null}}class ExData extends a.ContentObject{constructor(e){super(c,"exData");this.contentType=e.contentType||"";this.href=e.href||"";this.id=e.id||"";this.maxLength=(0,n.getInteger)({data:e.maxLength,defaultValue:-1,validate:e=>e>=-1});this.name=e.name||"";this.rid=e.rid||"";this.transferEncoding=(0,n.getStringOption)(e.transferEncoding,["none","base64","package"]);this.use=e.use||"";this.usehref=e.usehref||""}[a.$onChild](e){if("text/html"===this.contentType&&e[a.$namespaceId]===i.NamespaceIds.xhtml.id){this[a.$content]=e;return!0}if("text/xml"===this.contentType){this[a.$content]=e;return!0}return!1}}class ExObject extends a.XFAObject{constructor(e){super(c,"exObject",!0);this.archive=e.archive||"";this.classId=e.classId||"";this.codeBase=e.codeBase||"";this.codeType=e.codeType||"";this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.boolean=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.exObject=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.time=new a.XFAObjectArray}}class ExclGroup extends a.XFAObject{constructor(e){super(c,"exclGroup",!0);this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]);this.accessKey=e.accessKey||"";this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]);this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1});this.h=e.h?(0,n.getMeasurement)(e.h):"";this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]);this.id=e.id||"";this.layout=(0,n.getStringOption)(e.layout,["position","lr-tb","rl-row","rl-tb","row","table","tb"]);this.maxH=(0,n.getMeasurement)(e.maxH,"0pt");this.maxW=(0,n.getMeasurement)(e.maxW,"0pt");this.minH=(0,n.getMeasurement)(e.minH,"0pt");this.minW=(0,n.getMeasurement)(e.minW,"0pt");this.name=e.name||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.w=e.w?(0,n.getMeasurement)(e.w):"";this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.assist=null;this.bind=null;this.border=null;this.calculate=null;this.caption=null;this.desc=null;this.extras=null;this.margin=null;this.para=null;this.traversal=null;this.validate=null;this.connect=new a.XFAObjectArray;this.event=new a.XFAObjectArray;this.field=new a.XFAObjectArray;this.setProperty=new a.XFAObjectArray}[a.$hasSettableValue](){return!0}[a.$setValue](e){for(const t of this.field.children){if(!t.value){const e=new Value({});t[a.$appendChild](e);t.value=e}const r=new BooleanElement({});r[a.$content]=0;for(const i of t.items.children)if(i[a.$hasItem](e)){r[a.$content]=1;break}t.value[a.$setValue](r)}}[a.$toHTML](){if(!this.value)return null;return{name:"div",attributes:{style:(0,s.toStyle)(this,"dimensions","position","anchorType"),id:this[a.$uid],class:"xfaExclgroup"},children:this[a.$childrenToHTML]({filter:new Set(["field"]),include:!0})}}}class Execute extends a.XFAObject{constructor(e){super(c,"execute");this.connection=e.connection||"";this.executeType=(0,n.getStringOption)(e.executeType,["import","remerge"]);this.id=e.id||"";this.runAt=(0,n.getStringOption)(e.runAt,["client","both","server"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Extras extends a.XFAObject{constructor(e){super(c,"extras",!0);this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||"";this.boolean=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.extras=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.time=new a.XFAObjectArray}}class Field extends a.XFAObject{constructor(e){super(c,"field",!0);this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]);this.accessKey=e.accessKey||"";this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]);this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1});this.h=e.h?(0,n.getMeasurement)(e.h):"";this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]);this.id=e.id||"";this.locale=e.locale||"";this.maxH=(0,n.getMeasurement)(e.maxH,"0pt");this.maxW=(0,n.getMeasurement)(e.maxW,"0pt");this.minH=(0,n.getMeasurement)(e.minH,"0pt");this.minW=(0,n.getMeasurement)(e.minW,"0pt");this.name=e.name||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.relevant=(0,n.getRelevant)(e.relevant);this.rotate=(0,n.getInteger)({data:e.rotate,defaultValue:0,validate:e=>e%90==0});this.use=e.use||"";this.usehref=e.usehref||"";this.w=e.w?(0,n.getMeasurement)(e.w):"";this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.assist=null;this.bind=null;this.border=null;this.calculate=null;this.caption=null;this.desc=null;this.extras=null;this.font=null;this.format=null;this.items=new a.XFAObjectArray(2);this.keep=null;this.margin=null;this.para=null;this.traversal=null;this.ui=null;this.validate=null;this.value=null;this.bindItems=new a.XFAObjectArray;this.connect=new a.XFAObjectArray;this.event=new a.XFAObjectArray;this.setProperty=new a.XFAObjectArray}[a.$setValue](e){_setValue(this,e)}[a.$toHTML](){if(!this.ui)return null;const e=(0,s.toStyle)(this,"font","dimensions","position","rotate","anchorType","presence"),t=[],r=[];this.border&&Object.assign(e,this.border[a.$toStyle](t,r));if(this.margin){e.paddingTop=(0,s.measureToString)(this.margin.topInset-t[0]-r[0]);e.paddingRight=(0,s.measureToString)(this.margin.rightInset-t[1]-r[1]);e.paddingBottom=(0,s.measureToString)(this.margin.bottomInset-t[2]-r[2]);e.paddingLeft=(0,s.measureToString)(this.margin.leftInset-t[3]-r[3])}else{e.paddingTop=(0,s.measureToString)(-t[0]-r[0]);e.paddingRight=(0,s.measureToString)(-t[1]-r[1]);e.paddingBottom=(0,s.measureToString)(-t[2]-r[2]);e.paddingLeft=(0,s.measureToString)(-t[3]-r[3])}const i=["xfaField"];this.font&&i.push("xfaFont");const n={style:e,id:this[a.$uid],class:i.join(" ")};this.name&&(n.xfaName=this.name);const o=[],c={name:"div",attributes:n,children:o},l=this.ui?this.ui[a.$toHTML]():null;if(!l)return c;l.attributes.style||(l.attributes.style=Object.create(null));o.push(l);this.value&&"button"!==l.name&&(l.children[0].attributes.value=this.value[a.$toHTML]());const h=this.caption?this.caption[a.$toHTML]():null;if(!h)return c;if("button"===l.name){l.attributes.style.background=e.color;delete e.color;"div"===h.name&&(h.name="span");l.children=[h];return c}l.children.splice(0,0,h);switch(this.caption.placement){case"left":l.attributes.style.flexDirection="row";break;case"right":l.attributes.style.flexDirection="row-reverse";break;case"top":l.attributes.style.flexDirection="column";break;case"bottom":l.attributes.style.flexDirection="column-reverse";break;case"inline":delete l.attributes.class;h.attributes.style.float="left"}return c}}t.Field=Field;class Fill extends a.XFAObject{constructor(e){super(c,"fill",!0);this.id=e.id||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null;this.linear=null;this.pattern=null;this.radial=null;this.solid=null;this.stipple=null}[a.$toStyle](){for(const e of Object.getOwnPropertyNames(this)){if("extras"===e||"color"===e)continue;const t=this[e];if(t instanceof a.XFAObject)return{color:t[a.$toStyle](this.color)}}return{color:this.color?this.color[a.$toStyle]():"#000000"}}}class Filter extends a.XFAObject{constructor(e){super(c,"filter",!0);this.addRevocationInfo=(0,n.getStringOption)(e.addRevocationInfo,["","required","optional","none"]);this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||"";this.version=(0,n.getInteger)({data:this.version,defaultValue:5,validate:e=>e>=1&&e<=5});this.appearanceFilter=null;this.certificates=null;this.digestMethods=null;this.encodings=null;this.encryptionMethods=null;this.handler=null;this.lockDocument=null;this.mdp=null;this.reasons=null;this.timeStamp=null}}class Float extends a.ContentObject{constructor(e){super(c,"float");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){const e=parseFloat(this[a.$content].trim());this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class Font extends a.XFAObject{constructor(e){super(c,"font",!0);this.baselineShift=(0,n.getMeasurement)(e.baselineShift);this.fontHorizontalScale=(0,n.getFloat)({data:e.fontHorizontalScale,defaultValue:100,validate:e=>e>=0});this.fontVerticalScale=(0,n.getFloat)({data:e.fontVerticalScale,defaultValue:100,validate:e=>e>=0});this.id=e.id||"";this.kerningMode=(0,n.getStringOption)(e.kerningMode,["none","pair"]);this.letterSpacing=(0,n.getMeasurement)(e.letterSpacing,"0");this.lineThrough=(0,n.getInteger)({data:e.lineThrough,defaultValue:0,validate:e=>1===e||2===e});this.lineThroughPeriod=(0,n.getStringOption)(e.lineThroughPeriod,["all","word"]);this.overline=(0,n.getInteger)({data:e.overline,defaultValue:0,validate:e=>1===e||2===e});this.overlinePeriod=(0,n.getStringOption)(e.overlinePeriod,["all","word"]);this.posture=(0,n.getStringOption)(e.posture,["normal","italic"]);this.size=(0,n.getMeasurement)(e.size,"10pt");this.typeface=e.typeface||"";this.underline=(0,n.getInteger)({data:e.underline,defaultValue:0,validate:e=>1===e||2===e});this.underlinePeriod=(0,n.getStringOption)(e.underlinePeriod,["all","word"]);this.use=e.use||"";this.usehref=e.usehref||"";this.weight=(0,n.getStringOption)(e.weight,["normal","bold"]);this.extras=null;this.fill=null}[a.$toStyle](){const e=(0,s.toStyle)(this,"fill");if(e.color)if(e.color.startsWith("#"))"#000000"===e.color&&delete e.color;else{e.backgroundClip="text";e.background=e.color;e.color="transparent"}this.baselineShift&&(e.verticalAlign=(0,s.measureToString)(this.baselineShift));"none"!==this.kerningMode&&(e.fontKerning="normal");this.letterSpacing&&(e.letterSpacing=(0,s.measureToString)(this.letterSpacing));if(0!==this.lineThrough){e.textDecoration="line-through";2===this.lineThrough&&(e.textDecorationStyle="double")}if(0!==this.overline){e.textDecoration="overline";2===this.overline&&(e.textDecorationStyle="double")}"normal"!==this.posture&&(e.fontStyle=this.posture);const t=(0,s.measureToString)(this.size);"10px"!==t&&(e.fontSize=t);e.fontFamily=this.typeface;if(0!==this.underline){e.textDecoration="underline";2===this.underline&&(e.textDecorationStyle="double")}"normal"!==this.weight&&(e.fontWeight=this.weight);return e}}class Format extends a.XFAObject{constructor(e){super(c,"format",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.picture=null}}class Handler extends a.StringObject{constructor(e){super(c,"handler");this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Hyphenation extends a.XFAObject{constructor(e){super(c,"hyphenation");this.excludeAllCaps=(0,n.getInteger)({data:e.excludeAllCaps,defaultValue:0,validate:e=>1===e});this.excludeInitialCap=(0,n.getInteger)({data:e.excludeInitialCap,defaultValue:0,validate:e=>1===e});this.hyphenate=(0,n.getInteger)({data:e.hyphenate,defaultValue:0,validate:e=>1===e});this.id=e.id||"";this.pushCharacterCount=(0,n.getInteger)({data:e.pushCharacterCount,defaultValue:3,validate:e=>e>=0});this.remainCharacterCount=(0,n.getInteger)({data:e.remainCharacterCount,defaultValue:3,validate:e=>e>=0});this.use=e.use||"";this.usehref=e.usehref||"";this.wordCharacterCount=(0,n.getInteger)({data:e.wordCharacterCount,defaultValue:7,validate:e=>e>=0})}}class Image extends a.StringObject{constructor(e){super(c,"image");this.aspect=(0,n.getStringOption)(e.aspect,["fit","actual","height","none","width"]);this.contentType=e.contentType||"";this.href=e.href||"";this.id=e.id||"";this.name=e.name||"";this.transferEncoding=(0,n.getStringOption)(e.transferEncoding,["base64","none","package"]);this.use=e.use||"";this.usehref=e.usehref||""}[a.$toHTML](){const e={name:"img",attributes:{style:{}}};if(this.href){e.attributes.src=new URL(this.href);return e}if("base64"===this.transferEncoding){const t=Uint8Array.from(atob(this[a.$content]),(e=>e.charCodeAt(0))),r=new Blob([t],{type:this.contentType});e.attributes.src=URL.createObjectURL(r);return e}return null}}class ImageEdit extends a.XFAObject{constructor(e){super(c,"imageEdit",!0);this.data=(0,n.getStringOption)(e.data,["link","embed"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.extras=null;this.margin=null}}class Integer extends a.ContentObject{constructor(e){super(c,"integer");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){const e=parseInt(this[a.$content].trim(),10);this[a.$content]=isNaN(e)?null:e}[a.$toHTML](){return null!==this[a.$content]?this[a.$content].toString():""}}class Issuers extends a.XFAObject{constructor(e){super(c,"issuers",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.certificate=new a.XFAObjectArray}}class Items extends a.XFAObject{constructor(e){super(c,"items",!0);this.id=e.id||"";this.name=e.name||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.ref=e.ref||"";this.save=(0,n.getInteger)({data:e.save,defaultValue:0,validate:e=>1===e});this.use=e.use||"";this.usehref=e.usehref||"";this.boolean=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.time=new a.XFAObjectArray}[a.$hasItem](e){return this.hasOwnProperty(e[a.$nodeName])&&this[e[a.$nodeName]].children.some((t=>t[a.$content]===e[a.$content]))}}t.Items=Items;class Keep extends a.XFAObject{constructor(e){super(c,"keep",!0);this.id=e.id||"";const t=["none","contentArea","pageArea"];this.intact=(0,n.getStringOption)(e.intact,t);this.next=(0,n.getStringOption)(e.next,t);this.previous=(0,n.getStringOption)(e.previous,t);this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}}class KeyUsage extends a.XFAObject{constructor(e){super(c,"keyUsage");const t=["","yes","no"];this.crlSign=(0,n.getStringOption)(e.crlSign,t);this.dataEncipherment=(0,n.getStringOption)(e.dataEncipherment,t);this.decipherOnly=(0,n.getStringOption)(e.decipherOnly,t);this.digitalSignature=(0,n.getStringOption)(e.digitalSignature,t);this.encipherOnly=(0,n.getStringOption)(e.encipherOnly,t);this.id=e.id||"";this.keyAgreement=(0,n.getStringOption)(e.keyAgreement,t);this.keyCertSign=(0,n.getStringOption)(e.keyCertSign,t);this.keyEncipherment=(0,n.getStringOption)(e.keyEncipherment,t);this.nonRepudiation=(0,n.getStringOption)(e.nonRepudiation,t);this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Line extends a.XFAObject{constructor(e){super(c,"line",!0);this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]);this.id=e.id||"";this.slope=(0,n.getStringOption)(e.slope,["\\","/"]);this.use=e.use||"";this.usehref=e.usehref||"";this.edge=null}}class Linear extends a.XFAObject{constructor(e){super(c,"linear",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["toRight","toBottom","toLeft","toTop"]);this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";return`linear-gradient(${this.type.replace(/([RBLT])/," $1").toLowerCase()}, ${e}, ${this.color?this.color[a.$toStyle]():"#000000"})`}}class LockDocument extends a.ContentObject{constructor(e){super(c,"lockDocument");this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=(0,n.getStringOption)(this[a.$content],["auto","0","1"])}}class Manifest extends a.XFAObject{constructor(e){super(c,"manifest",!0);this.action=(0,n.getStringOption)(e.action,["include","all","exclude"]);this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.ref=new a.XFAObjectArray}}class Margin extends a.XFAObject{constructor(e){super(c,"margin",!0);this.bottomInset=(0,n.getMeasurement)(e.bottomInset,"0");this.id=e.id||"";this.leftInset=(0,n.getMeasurement)(e.leftInset,"0");this.rightInset=(0,n.getMeasurement)(e.rightInset,"0");this.topInset=(0,n.getMeasurement)(e.topInset,"0");this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}[a.$toStyle](){return{marginLeft:(0,s.measureToString)(this.leftInset),marginRight:(0,s.measureToString)(this.rightInset),marginTop:(0,s.measureToString)(this.topInset),marginBottom:(0,s.measureToString)(this.bottomInset)}}}class Mdp extends a.XFAObject{constructor(e){super(c,"mdp");this.id=e.id||"";this.permissions=(0,n.getInteger)({data:e.permissions,defaultValue:2,validate:e=>1===e||3===e});this.signatureType=(0,n.getStringOption)(e.signatureType,["filler","author"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Medium extends a.XFAObject{constructor(e){super(c,"medium");this.id=e.id||"";this.imagingBBox=(0,n.getBBox)(e.imagingBBox);this.long=(0,n.getMeasurement)(e.long);this.orientation=(0,n.getStringOption)(e.orientation,["portrait","landscape"]);this.short=(0,n.getMeasurement)(e.short);this.stock=e.stock||"";this.trayIn=(0,n.getStringOption)(e.trayIn,["auto","delegate","pageFront"]);this.trayOut=(0,n.getStringOption)(e.trayOut,["auto","delegate"]);this.use=e.use||"";this.usehref=e.usehref||""}}class Message extends a.XFAObject{constructor(e){super(c,"message",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.text=new a.XFAObjectArray}}class NumericEdit extends a.XFAObject{constructor(e){super(c,"numericEdit",!0);this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.comb=null;this.extras=null;this.margin=null}[a.$toHTML](){return{name:"label",attributes:{class:"xfaLabel"},children:[{name:"input",attributes:{type:"text",class:"xfaTextfield",style:(0,s.toStyle)(this,"border","font","margin")}}]}}}class Occur extends a.XFAObject{constructor(e){super(c,"occur",!0);this.id=e.id||"";this.initial=(0,n.getInteger)({data:e.initial,defaultValue:1,validate:e=>!0});this.max=(0,n.getInteger)({data:e.max,defaultValue:1,validate:e=>!0});this.min=(0,n.getInteger)({data:e.min,defaultValue:1,validate:e=>!0});this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}}class Oid extends a.StringObject{constructor(e){super(c,"oid");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Oids extends a.XFAObject{constructor(e){super(c,"oids",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.oid=new a.XFAObjectArray}}class Overflow extends a.XFAObject{constructor(e){super(c,"overflow");this.id=e.id||"";this.leader=e.leader||"";this.target=e.target||"";this.trailer=e.trailer||"";this.use=e.use||"";this.usehref=e.usehref||""}}class PageArea extends a.XFAObject{constructor(e){super(c,"pageArea",!0);this.blankOrNotBlank=(0,n.getStringOption)(e.blankOrNotBlank,["any","blank","notBlank"]);this.id=e.id||"";this.initialNumber=(0,n.getInteger)({data:e.initialNumber,defaultValue:1,validate:e=>!0});this.name=e.name||"";this.numbered=(0,n.getInteger)({data:e.numbered,defaultValue:1,validate:e=>!0});this.oddOrEven=(0,n.getStringOption)(e.oddOrEven,["any","even","odd"]);this.pagePosition=(0,n.getStringOption)(e.pagePosition,["any","first","last","only","rest"]);this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.desc=null;this.extras=null;this.medium=null;this.occur=null;this.area=new a.XFAObjectArray;this.contentArea=new a.XFAObjectArray;this.draw=new a.XFAObjectArray;this.exclGroup=new a.XFAObjectArray;this.field=new a.XFAObjectArray;this.subform=new a.XFAObjectArray}[a.$toHTML](){if(0===this.contentArea.children.length)return null;const e=this[a.$childrenToHTML]({filter:new Set(["area","draw","field","subform","contentArea"]),include:!0}),t=e.find((e=>"xfaContentarea"===e.attributes.class)),r=Object.create(null);if(this.medium&&this.medium.short&&this.medium.long){r.width=(0,s.measureToString)(this.medium.short);r.height=(0,s.measureToString)(this.medium.long)}return{name:"div",children:e,attributes:{id:this[a.$uid],style:r},contentArea:t}}}class PageSet extends a.XFAObject{constructor(e){super(c,"pageSet",!0);this.duplexImposition=(0,n.getStringOption)(e.duplexImposition,["longEdge","shortEdge"]);this.id=e.id||"";this.name=e.name||"";this.relation=(0,n.getStringOption)(e.relation,["orderedOccurrence","duplexPaginated","simplexPaginated"]);this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.occur=null;this.pageArea=new a.XFAObjectArray;this.pageSet=new a.XFAObjectArray}[a.$toHTML](){return{name:"div",children:this[a.$childrenToHTML]({filter:new Set(["pageArea","pageSet"]),include:!0}),attributes:{id:this[a.$uid]}}}}class Para extends a.XFAObject{constructor(e){super(c,"para",!0);this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]);this.id=e.id||"";this.lineHeight=(0,n.getMeasurement)(e.lineHeight,"0pt");this.marginLeft=(0,n.getMeasurement)(e.marginLeft,"0");this.marginRight=(0,n.getMeasurement)(e.marginRight,"0");this.orphans=(0,n.getInteger)({data:e.orphans,defaultValue:0,validate:e=>e>=0});this.preserve=e.preserve||"";this.radixOffset=(0,n.getMeasurement)(e.radixOffset,"0");this.spaceAbove=(0,n.getMeasurement)(e.spaceAbove,"0");this.spaceBelow=(0,n.getMeasurement)(e.spaceBelow,"0");this.tabDefault=e.tabDefault?(0,n.getMeasurement)(this.tabDefault):null;this.tabStops=(e.tabStops||"").trim().split(/\s+/).map(((e,t)=>t%2==1?(0,n.getMeasurement)(e):e));this.textIndent=(0,n.getMeasurement)(e.textIndent,"0");this.use=e.use||"";this.usehref=e.usehref||"";this.vAlign=(0,n.getStringOption)(e.vAlign,["top","bottom","middle"]);this.widows=(0,n.getInteger)({data:e.widows,defaultValue:0,validate:e=>e>=0});this.hyphenation=null}[a.$toHTML](){const e={marginLeft:(0,s.measureToString)(this.marginLeft),marginRight:(0,s.measureToString)(this.marginRight),paddingTop:(0,s.measureToString)(this.spaceAbove),paddingBottom:(0,s.measureToString)(this.spaceBelow),textIndent:(0,s.measureToString)(this.textIndent),verticalAlign:this.vAlign};this.lineHeight.value>=0&&(e.lineHeight=(0,s.measureToString)(this.lineHeight));this.tabDefault&&(e.tabSize=(0,s.measureToString)(this.tabDefault));this.tabStops.length;this.hyphenatation&&Object.assign(e,this.hyphenatation[a.$toHTML]());return e}}class PasswordEdit extends a.XFAObject{constructor(e){super(c,"passwordEdit",!0);this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]);this.id=e.id||"";this.passwordChar=e.passwordChar||"*";this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.extras=null;this.margin=null}}class Pattern extends a.XFAObject{constructor(e){super(c,"pattern",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["crossHatch","crossDiagonal","diagonalLeft","diagonalRight","horizontal","vertical"]);this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";const t=this.color?this.color[a.$toStyle]():"#000000",r="repeating-linear-gradient",i=`${e},${e} 5px,${t} 5px,${t} 10px`;switch(this.type){case"crossHatch":return`${r}(to top,${i}) ${r}(to right,${i})`;case"crossDiagonal":return`${r}(45deg,${i}) ${r}(-45deg,${i})`;case"diagonalLeft":return`${r}(45deg,${i})`;case"diagonalRight":return`${r}(-45deg,${i})`;case"horizontal":return`${r}(to top,${i})`;case"vertical":return`${r}(to right,${i})`}return""}}class Picture extends a.StringObject{constructor(e){super(c,"picture");this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Proto extends a.XFAObject{constructor(e){super(c,"proto",!0);this.appearanceFilter=new a.XFAObjectArray;this.arc=new a.XFAObjectArray;this.area=new a.XFAObjectArray;this.assist=new a.XFAObjectArray;this.barcode=new a.XFAObjectArray;this.bindItems=new a.XFAObjectArray;this.bookend=new a.XFAObjectArray;this.boolean=new a.XFAObjectArray;this.border=new a.XFAObjectArray;this.break=new a.XFAObjectArray;this.breakAfter=new a.XFAObjectArray;this.breakBefore=new a.XFAObjectArray;this.button=new a.XFAObjectArray;this.calculate=new a.XFAObjectArray;this.caption=new a.XFAObjectArray;this.certificate=new a.XFAObjectArray;this.certificates=new a.XFAObjectArray;this.checkButton=new a.XFAObjectArray;this.choiceList=new a.XFAObjectArray;this.color=new a.XFAObjectArray;this.comb=new a.XFAObjectArray;this.connect=new a.XFAObjectArray;this.contentArea=new a.XFAObjectArray;this.corner=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.dateTimeEdit=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.defaultUi=new a.XFAObjectArray;this.desc=new a.XFAObjectArray;this.digestMethod=new a.XFAObjectArray;this.digestMethods=new a.XFAObjectArray;this.draw=new a.XFAObjectArray;this.edge=new a.XFAObjectArray;this.encoding=new a.XFAObjectArray;this.encodings=new a.XFAObjectArray;this.encrypt=new a.XFAObjectArray;this.encryptData=new a.XFAObjectArray;this.encryption=new a.XFAObjectArray;this.encryptionMethod=new a.XFAObjectArray;this.encryptionMethods=new a.XFAObjectArray;this.event=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.exObject=new a.XFAObjectArray;this.exclGroup=new a.XFAObjectArray;this.execute=new a.XFAObjectArray;this.extras=new a.XFAObjectArray;this.field=new a.XFAObjectArray;this.fill=new a.XFAObjectArray;this.filter=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.font=new a.XFAObjectArray;this.format=new a.XFAObjectArray;this.handler=new a.XFAObjectArray;this.hyphenation=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.imageEdit=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.issuers=new a.XFAObjectArray;this.items=new a.XFAObjectArray;this.keep=new a.XFAObjectArray;this.keyUsage=new a.XFAObjectArray;this.line=new a.XFAObjectArray;this.linear=new a.XFAObjectArray;this.lockDocument=new a.XFAObjectArray;this.manifest=new a.XFAObjectArray;this.margin=new a.XFAObjectArray;this.mdp=new a.XFAObjectArray;this.medium=new a.XFAObjectArray;this.message=new a.XFAObjectArray;this.numericEdit=new a.XFAObjectArray;this.occur=new a.XFAObjectArray;this.oid=new a.XFAObjectArray;this.oids=new a.XFAObjectArray;this.overflow=new a.XFAObjectArray;this.pageArea=new a.XFAObjectArray;this.pageSet=new a.XFAObjectArray;this.para=new a.XFAObjectArray;this.passwordEdit=new a.XFAObjectArray;this.pattern=new a.XFAObjectArray;this.picture=new a.XFAObjectArray;this.radial=new a.XFAObjectArray;this.reason=new a.XFAObjectArray;this.reasons=new a.XFAObjectArray;this.rectangle=new a.XFAObjectArray;this.ref=new a.XFAObjectArray;this.script=new a.XFAObjectArray;this.setProperty=new a.XFAObjectArray;this.signData=new a.XFAObjectArray;this.signature=new a.XFAObjectArray;this.signing=new a.XFAObjectArray;this.solid=new a.XFAObjectArray;this.speak=new a.XFAObjectArray;this.stipple=new a.XFAObjectArray;this.subform=new a.XFAObjectArray;this.subformSet=new a.XFAObjectArray;this.subjectDN=new a.XFAObjectArray;this.subjectDNs=new a.XFAObjectArray;this.submit=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.textEdit=new a.XFAObjectArray;this.time=new a.XFAObjectArray;this.timeStamp=new a.XFAObjectArray;this.toolTip=new a.XFAObjectArray;this.traversal=new a.XFAObjectArray;this.traverse=new a.XFAObjectArray;this.ui=new a.XFAObjectArray;this.validate=new a.XFAObjectArray;this.value=new a.XFAObjectArray;this.variables=new a.XFAObjectArray}}class Radial extends a.XFAObject{constructor(e){super(c,"radial",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["toEdge","toCenter"]);this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](e){e=e?e[a.$toStyle]():"#FFFFFF";const t=this.color?this.color[a.$toStyle]():"#000000";return`radial-gradient(circle to center, ${"toEdge"===this.type?`${e},${t}`:`${t},${e}`})`}}class Reason extends a.StringObject{constructor(e){super(c,"reason");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Reasons extends a.XFAObject{constructor(e){super(c,"reasons",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.reason=new a.XFAObjectArray}}class Rectangle extends a.XFAObject{constructor(e){super(c,"rectangle",!0);this.hand=(0,n.getStringOption)(e.hand,["even","left","right"]);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.corner=new a.XFAObjectArray(4);this.edge=new a.XFAObjectArray(4);this.fill=null}}class RefElement extends a.StringObject{constructor(e){super(c,"ref");this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Script extends a.StringObject{constructor(e){super(c,"script");this.binding=e.binding||"";this.contentType=e.contentType||"";this.id=e.id||"";this.name=e.name||"";this.runAt=(0,n.getStringOption)(e.runAt,["client","both","server"]);this.use=e.use||"";this.usehref=e.usehref||""}}class SetProperty extends a.XFAObject{constructor(e){super(c,"setProperty");this.connection=e.connection||"";this.ref=e.ref||"";this.target=e.target||""}}t.SetProperty=SetProperty;class SignData extends a.XFAObject{constructor(e){super(c,"signData",!0);this.id=e.id||"";this.operation=(0,n.getStringOption)(e.operation,["sign","clear","verify"]);this.ref=e.ref||"";this.target=e.target||"";this.use=e.use||"";this.usehref=e.usehref||"";this.filter=null;this.manifest=null}}class Signature extends a.XFAObject{constructor(e){super(c,"signature",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["PDF1.3","PDF1.6"]);this.use=e.use||"";this.usehref=e.usehref||"";this.border=null;this.extras=null;this.filter=null;this.manifest=null;this.margin=null}}class Signing extends a.XFAObject{constructor(e){super(c,"signing",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.certificate=new a.XFAObjectArray}}class Solid extends a.XFAObject{constructor(e){super(c,"solid",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null}[a.$toStyle](e){return e?e[a.$toStyle]():"#FFFFFF"}}class Speak extends a.StringObject{constructor(e){super(c,"speak");this.disable=(0,n.getInteger)({data:e.disable,defaultValue:0,validate:e=>1===e});this.id=e.id||"";this.priority=(0,n.getStringOption)(e.priority,["custom","caption","name","toolTip"]);this.rid=e.rid||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Stipple extends a.XFAObject{constructor(e){super(c,"stipple",!0);this.id=e.id||"";this.rate=(0,n.getInteger)({data:e.rate,defaultValue:50,validate:e=>e>=0&&e<=100});this.use=e.use||"";this.usehref=e.usehref||"";this.color=null;this.extras=null}[a.$toStyle](e){const t=this.rate/100;return o.Util.makeHexColor(Math.round(e.value.r*(1-t)+this.value.r*t),Math.round(e.value.g*(1-t)+this.value.g*t),Math.round(e.value.b*(1-t)+this.value.b*t))}}class Subform extends a.XFAObject{constructor(e){super(c,"subform",!0);this.access=(0,n.getStringOption)(e.access,["open","nonInteractive","protected","readOnly"]);this.allowMacro=(0,n.getInteger)({data:e.allowMacro,defaultValue:0,validate:e=>1===e});this.anchorType=(0,n.getStringOption)(e.anchorType,["topLeft","bottomCenter","bottomLeft","bottomRight","middleCenter","middleLeft","middleRight","topCenter","topRight"]);this.colSpan=(0,n.getInteger)({data:e.colSpan,defaultValue:1,validate:e=>e>=1});this.columnWidths=(e.columnWidths||"").trim().split(/\s+/).map((e=>"-1"===e?-1:(0,n.getMeasurement)(e)));this.h=e.h?(0,n.getMeasurement)(e.h):"";this.hAlign=(0,n.getStringOption)(e.hAlign,["left","center","justify","justifyAll","radix","right"]);this.id=e.id||"";this.layout=(0,n.getStringOption)(e.layout,["position","lr-tb","rl-row","rl-tb","row","table","tb"]);this.locale=e.locale||"";this.maxH=(0,n.getMeasurement)(e.maxH,"0pt");this.maxW=(0,n.getMeasurement)(e.maxW,"0pt");this.mergeMode=(0,n.getStringOption)(e.mergeMode,["consumeData","matchTemplate"]);this.minH=(0,n.getMeasurement)(e.minH,"0pt");this.minW=(0,n.getMeasurement)(e.minW,"0pt");this.name=e.name||"";this.presence=(0,n.getStringOption)(e.presence,["visible","hidden","inactive","invisible"]);this.relevant=(0,n.getRelevant)(e.relevant);this.restoreState=(0,n.getStringOption)(e.restoreState,["manual","auto"]);this.scope=(0,n.getStringOption)(e.scope,["name","none"]);this.use=e.use||"";this.usehref=e.usehref||"";this.w=e.w?(0,n.getMeasurement)(e.w):"";this.x=(0,n.getMeasurement)(e.x,"0pt");this.y=(0,n.getMeasurement)(e.y,"0pt");this.assist=null;this.bind=null;this.bookend=null;this.border=null;this.break=null;this.calculate=null;this.desc=null;this.extras=null;this.keep=null;this.margin=null;this.occur=null;this.overflow=null;this.pageSet=null;this.para=null;this.traversal=null;this.validate=null;this.variables=null;this.area=new a.XFAObjectArray;this.breakAfter=new a.XFAObjectArray;this.breakBefore=new a.XFAObjectArray;this.connect=new a.XFAObjectArray;this.draw=new a.XFAObjectArray;this.event=new a.XFAObjectArray;this.exObject=new a.XFAObjectArray;this.exclGroup=new a.XFAObjectArray;this.field=new a.XFAObjectArray;this.proto=new a.XFAObjectArray;this.setProperty=new a.XFAObjectArray;this.subform=new a.XFAObjectArray;this.subformSet=new a.XFAObjectArray}[a.$toHTML](){this[a.$extra]=Object.create(null);const e=this[a.$getParent]();let t=null;if("template"===e[a.$nodeName])null!==this.pageSet?this[a.$extra].pageNumber=0:(0,o.warn)("XFA - No pageSet in root subform");else if(e[a.$extra]&&void 0!==e[a.$extra].pageNumber){const r=e[a.$extra].pageNumber,i=e.pageSet.pageArea.children;e[a.$extra].pageNumber=(e[a.$extra].pageNumber+1)%i.length;t=i[r][a.$toHTML]()}const r=(0,s.toStyle)(this,"dimensions","position","presence"),i=["xfaSubform"],n=(0,s.layoutClass)(this);n&&i.push(n);const c={style:r,id:this[a.$uid],class:i.join(" ")};this.name&&(c.xfaName=this.name);const l={name:"div",attributes:c,children:this[a.$childrenToHTML]({filter:new Set(["area","draw","field","subform","subformSet"]),include:!0})};if(t){t.contentArea.children.push(l);delete t.contentArea;return t}return l}}class SubformSet extends a.XFAObject{constructor(e){super(c,"subformSet",!0);this.id=e.id||"";this.name=e.name||"";this.relation=(0,n.getStringOption)(e.relation,["ordered","choice","unordered"]);this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.bookend=null;this.break=null;this.desc=null;this.extras=null;this.occur=null;this.overflow=null;this.breakAfter=new a.XFAObjectArray;this.breakBefore=new a.XFAObjectArray;this.subform=new a.XFAObjectArray;this.subformSet=new a.XFAObjectArray}}class SubjectDN extends a.ContentObject{constructor(e){super(c,"subjectDN");this.delimiter=e.delimiter||",";this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Map(this[a.$content].split(this.delimiter).map((e=>{(e=e.split("=",2))[0]=e[0].trim();return e})))}}class SubjectDNs extends a.XFAObject{constructor(e){super(c,"subjectDNs",!0);this.id=e.id||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||"";this.subjectDN=new a.XFAObjectArray}}class Submit extends a.XFAObject{constructor(e){super(c,"submit",!0);this.embedPDF=(0,n.getInteger)({data:e.embedPDF,defaultValue:0,validate:e=>1===e});this.format=(0,n.getStringOption)(e.format,["xdp","formdata","pdf","urlencoded","xfd","xml"]);this.id=e.id||"";this.target=e.target||"";this.textEncoding=(0,n.getKeyword)({data:e.textEncoding?e.textEncoding.toLowerCase():"",defaultValue:"",validate:e=>["utf-8","big-five","fontspecific","gbk","gb-18030","gb-2312","ksc-5601","none","shift-jis","ucs-2","utf-16"].includes(e)||e.match(/iso-8859-[0-9]{2}/)});this.use=e.use||"";this.usehref=e.usehref||"";this.xdpContent=e.xdpContent||"";this.encrypt=null;this.encryptData=new a.XFAObjectArray;this.signData=new a.XFAObjectArray}}class Template extends a.XFAObject{constructor(e){super(c,"template",!0);this.baseProfile=(0,n.getStringOption)(e.baseProfile,["full","interactiveForms"]);this.extras=null;this.subform=new a.XFAObjectArray}[a.$finalize](){0===this.subform.children.length&&(0,o.warn)("XFA - No subforms in template node.");this.subform.children.length>=2&&(0,o.warn)("XFA - Several subforms in template node: please file a bug.")}[a.$toHTML](){return this.subform.children.length>0?this.subform.children[0][a.$toHTML]():{name:"div",children:[]}}}t.Template=Template;class Text extends a.ContentObject{constructor(e){super(c,"text");this.id=e.id||"";this.maxChars=(0,n.getInteger)({data:e.maxChars,defaultValue:0,validate:e=>e>=0});this.name=e.name||"";this.rid=e.rid||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$onChild](e){if(e[a.$namespaceId]===i.NamespaceIds.xhtml.id){this[a.$content]=e;return!0}(0,o.warn)(`XFA - Invalid content in Text: ${e[a.$nodeName]}.`);return!1}[a.$toHTML](){return"string"==typeof this[a.$content]?this[a.$content]:this[a.$content][a.$toHTML]()}}t.Text=Text;class TextEdit extends a.XFAObject{constructor(e){super(c,"textEdit",!0);this.allowRichText=(0,n.getInteger)({data:e.allowRichText,defaultValue:0,validate:e=>1===e});this.hScrollPolicy=(0,n.getStringOption)(e.hScrollPolicy,["auto","off","on"]);this.id=e.id||"";this.multiLine=(0,n.getInteger)({data:e.multiLine,defaultValue:1,validate:e=>0===e});this.use=e.use||"";this.usehref=e.usehref||"";this.vScrollPolicy=(0,n.getStringOption)(e.vScrollPolicy,["auto","off","on"]);this.border=null;this.comb=null;this.extras=null;this.margin=null}[a.$toHTML](){const e=(0,s.toStyle)(this,"border","font","margin");let t;t=1===this.multiline?{name:"textarea",attributes:{style:e}}:{name:"input",attributes:{type:"text",class:"xfaTextfield",style:e}};return{name:"label",attributes:{class:"xfaLabel"},children:[t]}}}class Time extends a.StringObject{constructor(e){super(c,"time");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}[a.$finalize](){this[a.$content]=new Date(this[a.$content])}[a.$toHTML](){return this[a.$content].toString()}}class TimeStamp extends a.XFAObject{constructor(e){super(c,"timeStamp");this.id=e.id||"";this.server=e.server||"";this.type=(0,n.getStringOption)(e.type,["optional","required"]);this.use=e.use||"";this.usehref=e.usehref||""}}class ToolTip extends a.StringObject{constructor(e){super(c,"toolTip");this.id=e.id||"";this.rid=e.rid||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Traversal extends a.XFAObject{constructor(e){super(c,"traversal",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.traverse=new a.XFAObjectArray}}class Traverse extends a.XFAObject{constructor(e){super(c,"traverse",!0);this.id=e.id||"";this.operation=(0,n.getStringOption)(e.operation,["next","back","down","first","left","right","up"]);this.ref=e.ref||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.script=null}get name(){return this.operation}[a.$isTransparent](){return!1}}class Ui extends a.XFAObject{constructor(e){super(c,"ui",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.picture=null;this.barcode=null;this.button=null;this.checkButton=null;this.choiceList=null;this.dateTimeEdit=null;this.defaultUi=null;this.imageEdit=null;this.numericEdit=null;this.passwordEdit=null;this.signature=null;this.textEdit=null}[a.$toHTML](){for(const e of Object.getOwnPropertyNames(this)){if("extras"===e||"picture"===e)continue;const t=this[e];if(t instanceof a.XFAObject)return t[a.$toHTML]()}return null}}class Validate extends a.XFAObject{constructor(e){super(c,"validate",!0);this.formatTest=(0,n.getStringOption)(e.formatTest,["warning","disabled","error"]);this.id=e.id||"";this.nullTest=(0,n.getStringOption)(e.nullTest,["disabled","error","warning"]);this.scriptTest=(0,n.getStringOption)(e.scriptTest,["error","disabled","warning"]);this.use=e.use||"";this.usehref=e.usehref||"";this.extras=null;this.message=null;this.picture=null;this.script=null}}class Value extends a.XFAObject{constructor(e){super(c,"value",!0);this.id=e.id||"";this.override=(0,n.getInteger)({data:e.override,defaultValue:0,validate:e=>1===e});this.relevant=(0,n.getRelevant)(e.relevant);this.use=e.use||"";this.usehref=e.usehref||"";this.arc=null;this.boolean=null;this.date=null;this.dateTime=null;this.decimal=null;this.exData=null;this.float=null;this.image=null;this.integer=null;this.line=null;this.rectangle=null;this.text=null;this.time=null}[a.$setValue](e){const t=e[a.$nodeName];if(null===this[t]){for(const e of Object.getOwnPropertyNames(this)){const t=this[e];if(t instanceof a.XFAObject){this[e]=null;this[a.$removeChild](t)}}this[e[a.$nodeName]]=e;this[a.$appendChild](e)}else this[t][a.$content]=e[a.$content]}[a.$toHTML](){for(const e of Object.getOwnPropertyNames(this)){const t=this[e];if(t instanceof a.XFAObject)return t[a.$toHTML]()}return null}}t.Value=Value;class Variables extends a.XFAObject{constructor(e){super(c,"variables",!0);this.id=e.id||"";this.use=e.use||"";this.usehref=e.usehref||"";this.boolean=new a.XFAObjectArray;this.date=new a.XFAObjectArray;this.dateTime=new a.XFAObjectArray;this.decimal=new a.XFAObjectArray;this.exData=new a.XFAObjectArray;this.float=new a.XFAObjectArray;this.image=new a.XFAObjectArray;this.integer=new a.XFAObjectArray;this.manifest=new a.XFAObjectArray;this.script=new a.XFAObjectArray;this.text=new a.XFAObjectArray;this.time=new a.XFAObjectArray}[a.$isTransparent](){return!0}}class TemplateNamespace{static[i.$buildXFAObject](e,t){if(TemplateNamespace.hasOwnProperty(e)){const r=TemplateNamespace[e](t);r[a.$setSetAttributes](t);return r}}static appearanceFilter(e){return new AppearanceFilter(e)}static arc(e){return new Arc(e)}static area(e){return new Area(e)}static assist(e){return new Assist(e)}static barcode(e){return new Barcode(e)}static bind(e){return new Bind(e)}static bindItems(e){return new BindItems(e)}static bookend(e){return new Bookend(e)}static boolean(e){return new BooleanElement(e)}static border(e){return new Border(e)}static break(e){return new Break(e)}static breakAfter(e){return new BreakAfter(e)}static breakBefore(e){return new BreakBefore(e)}static button(e){return new Button(e)}static calculate(e){return new Calculate(e)}static caption(e){return new Caption(e)}static certificate(e){return new Certificate(e)}static certificates(e){return new Certificates(e)}static checkButton(e){return new CheckButton(e)}static choiceList(e){return new ChoiceList(e)}static color(e){return new Color(e)}static comb(e){return new Comb(e)}static connect(e){return new Connect(e)}static contentArea(e){return new ContentArea(e)}static corner(e){return new Corner(e)}static date(e){return new DateElement(e)}static dateTime(e){return new DateTime(e)}static dateTimeEdit(e){return new DateTimeEdit(e)}static decimal(e){return new Decimal(e)}static defaultUi(e){return new DefaultUi(e)}static desc(e){return new Desc(e)}static digestMethod(e){return new DigestMethod(e)}static digestMethods(e){return new DigestMethods(e)}static draw(e){return new Draw(e)}static edge(e){return new Edge(e)}static encoding(e){return new Encoding(e)}static encodings(e){return new Encodings(e)}static encrypt(e){return new Encrypt(e)}static encryptData(e){return new EncryptData(e)}static encryption(e){return new Encryption(e)}static encryptionMethod(e){return new EncryptionMethod(e)}static encryptionMethods(e){return new EncryptionMethods(e)}static event(e){return new Event(e)}static exData(e){return new ExData(e)}static exObject(e){return new ExObject(e)}static exclGroup(e){return new ExclGroup(e)}static execute(e){return new Execute(e)}static extras(e){return new Extras(e)}static field(e){return new Field(e)}static fill(e){return new Fill(e)}static filter(e){return new Filter(e)}static float(e){return new Float(e)}static font(e){return new Font(e)}static format(e){return new Format(e)}static handler(e){return new Handler(e)}static hyphenation(e){return new Hyphenation(e)}static image(e){return new Image(e)}static imageEdit(e){return new ImageEdit(e)}static integer(e){return new Integer(e)}static issuers(e){return new Issuers(e)}static items(e){return new Items(e)}static keep(e){return new Keep(e)}static keyUsage(e){return new KeyUsage(e)}static line(e){return new Line(e)}static linear(e){return new Linear(e)}static lockDocument(e){return new LockDocument(e)}static manifest(e){return new Manifest(e)}static margin(e){return new Margin(e)}static mdp(e){return new Mdp(e)}static medium(e){return new Medium(e)}static message(e){return new Message(e)}static numericEdit(e){return new NumericEdit(e)}static occur(e){return new Occur(e)}static oid(e){return new Oid(e)}static oids(e){return new Oids(e)}static overflow(e){return new Overflow(e)}static pageArea(e){return new PageArea(e)}static pageSet(e){return new PageSet(e)}static para(e){return new Para(e)}static passwordEdit(e){return new PasswordEdit(e)}static pattern(e){return new Pattern(e)}static picture(e){return new Picture(e)}static proto(e){return new Proto(e)}static radial(e){return new Radial(e)}static reason(e){return new Reason(e)}static reasons(e){return new Reasons(e)}static rectangle(e){return new Rectangle(e)}static ref(e){return new RefElement(e)}static script(e){return new Script(e)}static setProperty(e){return new SetProperty(e)}static signData(e){return new SignData(e)}static signature(e){return new Signature(e)}static signing(e){return new Signing(e)}static solid(e){return new Solid(e)}static speak(e){return new Speak(e)}static stipple(e){return new Stipple(e)}static subform(e){return new Subform(e)}static subformSet(e){return new SubformSet(e)}static subjectDN(e){return new SubjectDN(e)}static subjectDNs(e){return new SubjectDNs(e)}static submit(e){return new Submit(e)}static template(e){return new Template(e)}static text(e){return new Text(e)}static textEdit(e){return new TextEdit(e)}static time(e){return new Time(e)}static timeStamp(e){return new TimeStamp(e)}static toolTip(e){return new ToolTip(e)}static traversal(e){return new Traversal(e)}static traverse(e){return new Traverse(e)}static ui(e){return new Ui(e)}static validate(e){return new Validate(e)}static value(e){return new Value(e)}static variables(e){return new Variables(e)}}t.TemplateNamespace=TemplateNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.layoutClass=function layoutClass(e){switch(e.layout){case"position":return"xfaPosition";case"lr-tb":return"xfaLrTb";case"rl-row":return"xfaRlRow";case"rl-tb":return"xfaRlTb";case"row":return"xfaRow";case"table":return"xfaTable";case"tb":return"xfaTb";default:return"xfaPosition"}};t.measureToString=measureToString;t.toStyle=function toStyle(e,...t){const r=Object.create(null);for(const s of t){const t=e[s];if(null!==t)if(t instanceof a.XFAObject){const e=t[a.$toStyle]();e?Object.assign(r,e):(0,i.warn)(`(DEBUG) - XFA - style for ${s} not implemented yet`)}else n.hasOwnProperty(s)&&n[s](e,r)}return r};var a=r(50),i=r(2);function measureToString(e){return"string"==typeof e?"0px":Number.isInteger(e)?`${e}px`:`${e.toFixed(2)}px`}const n={anchorType(e,t){"transform"in t||(t.transform="");switch(e.anchorType){case"bottomCenter":t.transform+="translate(-50%, -100%)";break;case"bottomLeft":t.transform+="translate(0,-100%)";break;case"bottomRight":t.transform+="translate(-100%,-100%)";break;case"middleCenter":t.transform+="translate(-50%,-50%)";break;case"middleLeft":t.transform+="translate(0,-50%)";break;case"middleRight":t.transform+="translate(-100%,-50%)";break;case"topCenter":t.transform+="translate(-50%,0)";break;case"topRight":t.transform+="translate(-100%,0)"}},dimensions(e,t){if(e.w)t.width=measureToString(e.w);else{t.width="auto";e.maxW>0&&(t.maxWidth=measureToString(e.maxW));t.minWidth=measureToString(e.minW)}if(e.h)t.height=measureToString(e.h);else{t.height="auto";e.maxH>0&&(t.maxHeight=measureToString(e.maxH));t.minHeight=measureToString(e.minH)}},position(e,t){const r=e[a.$getParent]();if(!r||!r.layout||"position"===r.layout){t.position="absolute";t.left=measureToString(e.x);t.top=measureToString(e.y)}},rotate(e,t){if(e.rotate){"transform"in t||(t.transform="");t.transform+=`rotate(-${e.rotate}deg)`;t.transformOrigin="top left"}},presence(e,t){switch(e.presence){case"invisible":t.visibility="hidden";break;case"hidden":case"inactive":t.display="none"}}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.createDataNode=function createDataNode(e,t,r){const n=parseExpression(r);if(!n)return null;if(n.some((e=>e.operator===c)))return null;const s=d.get(n[0].name);let o=0;if(s){e=s(e,t);o=1}else e=t||e;for(let t=n.length;o<t;o++){const{cacheName:t,index:r}=n[o];if(!isFinite(r)){n[o].index=0;return createNodes(e,n.slice(o))}const s=f.get(e);if(!s){(0,i.warn)("XFA - createDataNode must be called after searchNode.");return null}const c=s.get(t);if(0===c.length)return createNodes(e,n.slice(o));if(!(r<c.length)){n[o].index=c.length-r;return createNodes(e,n.slice(o))}{const t=c[r];if(!(t instanceof a.XFAObject)){(0,i.warn)("XFA - Cannot create a node.");return null}e=t}}return null};t.searchNode=function searchNode(e,t,r,i=!0,n=!0){const s=parseExpression(r,i);if(!s)return null;const h=d.get(s[0].name);let u,g=0;if(h){u=!0;e=[h(e,t)];g=1}else{u=null===t;e=[t||e]}for(let r=s.length;g<r;g++){const{name:r,cacheName:i,operator:h,index:d}=s[g],p=[];for(const t of e){if(!(t instanceof a.XFAObject))continue;let e,s;if(n){s=f.get(t);if(!s){s=new Map;f.set(t,s)}e=s.get(i)}if(!e){switch(h){case o:e=t[a.$getChildrenByName](r,!1);break;case c:e=t[a.$getChildrenByName](r,!0);break;case l:e=t[a.$getChildrenByClass](r);e=e instanceof a.XFAObjectArray?e.children:[e]}n&&s.set(i,e)}e.length>0&&p.push(e)}if(0!==p.length||u||0!==g)e=isFinite(d)?p.filter((e=>d<e.length)).map((e=>e[d])):p.reduce(((e,t)=>e.concat(t)),[]);else{const r=t[a.$getParent]();if(!(t=r))return null;g=-1;e=[t]}}if(0===e.length)return null;return e};var a=r(50),i=r(2);const n=/^[^.[]+/,s=/^[^\]]+/,o=0,c=1,l=2,h=3,u=4,d=new Map([["$data",(e,t)=>e.datasets.data],["$template",(e,t)=>e.template],["$connectionSet",(e,t)=>e.connectionSet],["$form",(e,t)=>e.form],["$layout",(e,t)=>e.layout],["$host",(e,t)=>e.host],["$dataWindow",(e,t)=>e.dataWindow],["$event",(e,t)=>e.event],["!",(e,t)=>e.datasets],["$xfa",(e,t)=>e],["xfa",(e,t)=>e],["$",(e,t)=>t]]),f=new WeakMap;function parseExpression(e,t){let r=e.match(n);if(!r)return null;let[a]=r;const d=[{name:a,cacheName:"."+a,index:0,js:null,formCalc:null,operator:o}];let f=a.length;for(;f<e.length;){const p=f;if("["===e.charAt(f++)){r=e.slice(f).match(s);if(!r){(0,i.warn)("XFA - Invalid index in SOM expression");return null}d[d.length-1].index="*"===(g=(g=r[0]).trim())?1/0:parseInt(g,10)||0;f+=r[0].length+1;continue}let m;switch(e.charAt(f)){case".":if(!t)return null;f++;m=c;break;case"#":f++;m=l;break;case"[":m=h;break;case"(":m=u;break;default:m=o}r=e.slice(f).match(n);if(!r)break;[a]=r;f+=a.length;d.push({name:a,cacheName:e.slice(p,f),operator:m,index:0,js:null,formCalc:null})}var g;return d}function createNodes(e,t){let r=null;for(const{name:i,index:n}of t){for(let t=0;t<=n;t++){r=new a.XmlObject(e[a.$namespaceId],i);e[a.$appendChild](r)}e=r}return r}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XFAParser=void 0;var a=r(50),i=r(26),n=r(58),s=r(2);class XFAParser extends i.XMLParserBase{constructor(){super();this._builder=new n.Builder;this._stack=[];this._ids=new Map;this._current=this._builder.buildRoot(this._ids);this._errorCode=i.XMLParserErrorCode.NoError;this._whiteRegex=/^\s+$/}parse(e){this.parseXml(e);if(this._errorCode===i.XMLParserErrorCode.NoError){this._current[a.$finalize]();return this._current.element}}onText(e){this._whiteRegex.test(e)||this._current[a.$onText](e.trim())}onCdata(e){this._current[a.$onText](e)}_mkAttributes(e,t){let r=null,i=null;const n=Object.create({});for(const{name:o,value:c}of e)if("xmlns"===o)r?(0,s.warn)(`XFA - multiple namespace definition in <${t}>`):r=c;else if(o.startsWith("xmlns:")){const e=o.substring("xmlns:".length);i||(i=[]);i.push({prefix:e,value:c})}else{const e=o.indexOf(":");if(-1===e)n[o]=c;else{let t=n[a.$nsAttributes];t||(t=n[a.$nsAttributes]=Object.create(null));const[r,i]=[o.slice(0,e),o.slice(e+1)];let s=t[r];s||(s=t[r]=Object.create(null));s[i]=c}}return[r,i,n]}_getNameAndPrefix(e){const t=e.indexOf(":");return-1===t?[e,null]:[e.substring(t+1),e.substring(0,t)]}onBeginElement(e,t,r){const[i,n,s]=this._mkAttributes(t,e),[o,c]=this._getNameAndPrefix(e),l=this._builder.build({nsPrefix:c,name:o,attributes:s,namespace:i,prefixes:n});if(r){l[a.$finalize]();this._current[a.$onChild](l)&&l[a.$setId](this._ids);l[a.$clean](this._builder)}else{this._stack.push(this._current);this._current=l}}onEndElement(e){const t=this._current;t[a.$finalize]();this._current=this._stack.pop();this._current[a.$onChild](t)&&t[a.$setId](this._ids);t[a.$clean](this._builder)}onError(e){this._errorCode=e}}t.XFAParser=XFAParser},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.Builder=void 0;var a=r(52),i=r(50),n=r(59),s=r(54),o=r(68),c=r(2);const l=Symbol();class Root extends i.XFAObject{constructor(e){super(-1,"root",Object.create(null));this.element=null;this[l]=e}[i.$onChild](e){this.element=e;return!0}[i.$finalize](){super[i.$finalize]();this.element.template instanceof s.Template&&this.element.template[i.$resolvePrototypes](this[l])}}class Empty extends i.XFAObject{constructor(){super(-1,"",Object.create(null))}[i.$onChild](e){return!1}}t.Builder=class Builder{constructor(){this._namespaceStack=[];this._namespacePrefixes=new Map;this._namespaces=new Map;this._nextNsId=Math.max(...Object.values(a.NamespaceIds).map((({id:e})=>e)));this._currentNamespace=new o.UnknownNamespace(++this._nextNsId)}buildRoot(e){return new Root(e)}build({nsPrefix:e,name:t,attributes:r,namespace:s,prefixes:o}){const c=null!==s;if(c){this._namespaceStack.push(this._currentNamespace);this._currentNamespace=this._searchNamespace(s)}o&&this._addNamespacePrefix(o);if(r.hasOwnProperty(i.$nsAttributes)){const e=n.NamespaceSetUp.datasets,t=r[i.$nsAttributes];let a=null;for(const[r,i]of Object.entries(t)){if(this._getNamespaceToUse(r)===e){a={xfa:i};break}}a?r[i.$nsAttributes]=a:delete r[i.$nsAttributes]}const l=this._getNamespaceToUse(e),h=l&&l[a.$buildXFAObject](t,r)||new Empty;(c||o)&&(h[i.$cleanup]={hasNamespace:c,prefixes:o});return h}_searchNamespace(e){let t=this._namespaces.get(e);if(t)return t;for(const[r,{check:i}]of Object.entries(a.NamespaceIds))if(i(e)){t=n.NamespaceSetUp[r];if(t){this._namespaces.set(e,t);return t}break}t=new o.UnknownNamespace(++this._nextNsId);this._namespaces.set(e,t);return t}_addNamespacePrefix(e){for(const{prefix:t,value:r}of e){const e=this._searchNamespace(r);let a=this._namespacePrefixes.get(t);if(!a){a=[];this._namespacePrefixes.set(t,a)}a.push(e)}}_getNamespaceToUse(e){if(!e)return this._currentNamespace;const t=this._namespacePrefixes.get(e);if(t&&t.length>0)return t[t.length-1];(0,c.warn)(`Unknown namespace prefix: ${e}.`);return null}clean(e){const{hasNamespace:t,prefixes:r}=e;t&&(this._currentNamespace=this._namespaceStack.pop());r&&r.forEach((({prefix:e})=>{this._namespacePrefixes.get(e).pop()}))}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.NamespaceSetUp=void 0;var a=r(60),i=r(61),n=r(62),s=r(63),o=r(64),c=r(65),l=r(54),h=r(66),u=r(67);const d={config:a.ConfigNamespace,connection:i.ConnectionSetNamespace,datasets:n.DatasetsNamespace,localeSet:s.LocaleSetNamespace,signature:o.SignatureNamespace,stylesheet:c.StylesheetNamespace,template:l.TemplateNamespace,xdp:h.XdpNamespace,xhtml:u.XhtmlNamespace};t.NamespaceSetUp=d},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ConfigNamespace=void 0;var a=r(52),i=r(50),n=r(51),s=r(2);const o=a.NamespaceIds.config.id;class Acrobat extends i.XFAObject{constructor(e){super(o,"acrobat",!0);this.acrobat7=null;this.autoSave=null;this.common=null;this.validate=null;this.validateApprovalSignatures=null;this.submitUrl=new i.XFAObjectArray}}class Acrobat7 extends i.XFAObject{constructor(e){super(o,"acrobat7",!0);this.dynamicRender=null}}class ADBE_JSConsole extends i.OptionObject{constructor(e){super(o,"ADBE_JSConsole",["delegate","Enable","Disable"])}}class ADBE_JSDebugger extends i.OptionObject{constructor(e){super(o,"ADBE_JSDebugger",["delegate","Enable","Disable"])}}class AddSilentPrint extends i.Option01{constructor(e){super(o,"addSilentPrint")}}class AddViewerPreferences extends i.Option01{constructor(e){super(o,"addViewerPreferences")}}class AdjustData extends i.Option10{constructor(e){super(o,"adjustData")}}class AdobeExtensionLevel extends i.IntegerObject{constructor(e){super(o,"adobeExtensionLevel",0,(e=>e>=1&&e<=8))}}class Agent extends i.XFAObject{constructor(e){super(o,"agent",!0);this.name=e.name?e.name.trim():"";this.common=new i.XFAObjectArray}}class AlwaysEmbed extends i.ContentObject{constructor(e){super(o,"alwaysEmbed")}}class Amd extends i.StringObject{constructor(e){super(o,"amd")}}class Area extends i.XFAObject{constructor(e){super(o,"area");this.level=(0,n.getInteger)({data:e.level,defaultValue:0,validator:e=>e>=1&&e<=3});this.name=(0,n.getStringOption)(e.name,["","barcode","coreinit","deviceDriver","font","general","layout","merge","script","signature","sourceSet","templateCache"])}}class Attributes extends i.OptionObject{constructor(e){super(o,"attributes",["preserve","delegate","ignore"])}}class AutoSave extends i.OptionObject{constructor(e){super(o,"autoSave",["disabled","enabled"])}}class Base extends i.StringObject{constructor(e){super(o,"base")}}class BatchOutput extends i.XFAObject{constructor(e){super(o,"batchOutput");this.format=(0,n.getStringOption)(e.format,["none","concat","zip","zipCompress"])}}class BehaviorOverride extends i.ContentObject{constructor(e){super(o,"behaviorOverride")}[i.$finalize](){this[i.$content]=new Map(this[i.$content].trim().split(/\s+/).filter((e=>!!e&&e.include(":"))).map((e=>e.split(":",2))))}}class Cache extends i.XFAObject{constructor(e){super(o,"cache",!0);this.templateCache=null}}class Change extends i.Option01{constructor(e){super(o,"change")}}class Common extends i.XFAObject{constructor(e){super(o,"common",!0);this.data=null;this.locale=null;this.localeSet=null;this.messaging=null;this.suppressBanner=null;this.template=null;this.validationMessaging=null;this.versionControl=null;this.log=new i.XFAObjectArray}}class Compress extends i.XFAObject{constructor(e){super(o,"compress");this.scope=(0,n.getStringOption)(e.scope,["imageOnly","document"])}}class CompressLogicalStructure extends i.Option01{constructor(e){super(o,"compressLogicalStructure")}}class CompressObjectStream extends i.Option10{constructor(e){super(o,"compressObjectStream")}}class Compression extends i.XFAObject{constructor(e){super(o,"compression",!0);this.compressLogicalStructure=null;this.compressObjectStream=null;this.level=null;this.type=null}}class Config extends i.XFAObject{constructor(e){super(o,"config",!0);this.acrobat=null;this.present=null;this.trace=null;this.agent=new i.XFAObjectArray}}class Conformance extends i.OptionObject{constructor(e){super(o,"conformance",["A","B"])}}class ContentCopy extends i.Option01{constructor(e){super(o,"contentCopy")}}class Copies extends i.IntegerObject{constructor(e){super(o,"copies",1,(e=>e>=1))}}class Creator extends i.StringObject{constructor(e){super(o,"creator")}}class CurrentPage extends i.IntegerObject{constructor(e){super(o,"currentPage",0,(e=>e>=0))}}class Data extends i.XFAObject{constructor(e){super(o,"data",!0);this.adjustData=null;this.attributes=null;this.incrementalLoad=null;this.outputXSL=null;this.range=null;this.record=null;this.startNode=null;this.uri=null;this.window=null;this.xsl=null;this.excludeNS=new i.XFAObjectArray;this.transform=new i.XFAObjectArray}}class Debug extends i.XFAObject{constructor(e){super(o,"debug",!0);this.uri=null}}class DefaultTypeface extends i.ContentObject{constructor(e){super(o,"defaultTypeface");this.writingScript=(0,n.getStringOption)(e.writingScript,["*","Arabic","Cyrillic","EastEuropeanRoman","Greek","Hebrew","Japanese","Korean","Roman","SimplifiedChinese","Thai","TraditionalChinese","Vietnamese"])}}class Destination extends i.OptionObject{constructor(e){super(o,"destination",["pdf","pcl","ps","webClient","zpl"])}}class DocumentAssembly extends i.Option01{constructor(e){super(o,"documentAssembly")}}class Driver extends i.XFAObject{constructor(e){super(o,"driver",!0);this.name=e.name?e.name.trim():"";this.fontInfo=null;this.xdc=null}}class DuplexOption extends i.OptionObject{constructor(e){super(o,"duplexOption",["simplex","duplexFlipLongEdge","duplexFlipShortEdge"])}}class DynamicRender extends i.OptionObject{constructor(e){super(o,"dynamicRender",["forbidden","required"])}}class Embed extends i.Option01{constructor(e){super(o,"embed")}}class Encrypt extends i.Option01{constructor(e){super(o,"encrypt")}}class Encryption extends i.XFAObject{constructor(e){super(o,"encryption",!0);this.encrypt=null;this.encryptionLevel=null;this.permissions=null}}class EncryptionLevel extends i.OptionObject{constructor(e){super(o,"encryptionLevel",["40bit","128bit"])}}class Enforce extends i.StringObject{constructor(e){super(o,"enforce")}}class Equate extends i.XFAObject{constructor(e){super(o,"equate");this.force=(0,n.getInteger)({data:e.force,defaultValue:1,validator:e=>0===e});this.from=e.from||"";this.to=e.to||""}}class EquateRange extends i.XFAObject{constructor(e){super(o,"equateRange");this.from=e.from||"";this.to=e.to||"";this._unicodeRange=e.unicodeRange||""}get unicodeRange(){const e=[],t=/U\+([0-9a-fA-F]+)/,r=this._unicodeRange;for(let a of r.split(",").map((e=>e.trim())).filter((e=>!!e))){a=a.split("-",2).map((e=>{const r=e.match(t);return r?parseInt(r[1],16):0}));1===a.length&&a.push(a[0]);e.push(a)}return(0,s.shadow)(this,"unicodeRange",e)}}class Exclude extends i.ContentObject{constructor(e){super(o,"exclude")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>e&&["calculate","close","enter","exit","initialize","ready","validate"].includes(e)))}}class ExcludeNS extends i.StringObject{constructor(e){super(o,"excludeNS")}}class FlipLabel extends i.OptionObject{constructor(e){super(o,"flipLabel",["usePrinterSetting","on","off"])}}class FontInfo extends i.XFAObject{constructor(e){super(o,"fontInfo",!0);this.embed=null;this.map=null;this.subsetBelow=null;this.alwaysEmbed=new i.XFAObjectArray;this.defaultTypeface=new i.XFAObjectArray;this.neverEmbed=new i.XFAObjectArray}}class FormFieldFilling extends i.Option01{constructor(e){super(o,"formFieldFilling")}}class GroupParent extends i.StringObject{constructor(e){super(o,"groupParent")}}class IfEmpty extends i.OptionObject{constructor(e){super(o,"ifEmpty",["dataValue","dataGroup","ignore","remove"])}}class IncludeXDPContent extends i.StringObject{constructor(e){super(o,"includeXDPContent")}}class IncrementalLoad extends i.OptionObject{constructor(e){super(o,"incrementalLoad",["none","forwardOnly"])}}class IncrementalMerge extends i.Option01{constructor(e){super(o,"incrementalMerge")}}class Interactive extends i.Option01{constructor(e){super(o,"interactive")}}class Jog extends i.OptionObject{constructor(e){super(o,"jog",["usePrinterSetting","none","pageSet"])}}class LabelPrinter extends i.XFAObject{constructor(e){super(o,"labelPrinter",!0);this.name=(0,n.getStringOption)(e.name,["zpl","dpl","ipl","tcpl"]);this.batchOutput=null;this.flipLabel=null;this.fontInfo=null;this.xdc=null}}class Layout extends i.OptionObject{constructor(e){super(o,"layout",["paginate","panel"])}}class Level extends i.IntegerObject{constructor(e){super(o,"level",0,(e=>e>0))}}class Linearized extends i.Option01{constructor(e){super(o,"linearized")}}class Locale extends i.StringObject{constructor(e){super(o,"locale")}}class LocaleSet extends i.StringObject{constructor(e){super(o,"localeSet")}}class Log extends i.XFAObject{constructor(e){super(o,"log",!0);this.mode=null;this.threshold=null;this.to=null;this.uri=null}}class MapElement extends i.XFAObject{constructor(e){super(o,"map",!0);this.equate=new i.XFAObjectArray;this.equateRange=new i.XFAObjectArray}}class MediumInfo extends i.XFAObject{constructor(e){super(o,"mediumInfo",!0);this.map=null}}class Message extends i.XFAObject{constructor(e){super(o,"message",!0);this.msgId=null;this.severity=null}}class Messaging extends i.XFAObject{constructor(e){super(o,"messaging",!0);this.message=new i.XFAObjectArray}}class Mode extends i.OptionObject{constructor(e){super(o,"mode",["append","overwrite"])}}class ModifyAnnots extends i.Option01{constructor(e){super(o,"modifyAnnots")}}class MsgId extends i.IntegerObject{constructor(e){super(o,"msgId",1,(e=>e>=1))}}class NameAttr extends i.StringObject{constructor(e){super(o,"nameAttr")}}class NeverEmbed extends i.ContentObject{constructor(e){super(o,"neverEmbed")}}class NumberOfCopies extends i.IntegerObject{constructor(e){super(o,"numberOfCopies",null,(e=>e>=2&&e<=5))}}class OpenAction extends i.XFAObject{constructor(e){super(o,"openAction",!0);this.destination=null}}class Output extends i.XFAObject{constructor(e){super(o,"output",!0);this.to=null;this.type=null;this.uri=null}}class OutputBin extends i.StringObject{constructor(e){super(o,"outputBin")}}class OutputXSL extends i.XFAObject{constructor(e){super(o,"outputXSL",!0);this.uri=null}}class Overprint extends i.OptionObject{constructor(e){super(o,"overprint",["none","both","draw","field"])}}class Packets extends i.StringObject{constructor(e){super(o,"packets")}[i.$finalize](){"*"!==this[i.$content]&&(this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>["config","datasets","template","xfdf","xslt"].includes(e))))}}class PageOffset extends i.XFAObject{constructor(e){super(o,"pageOffset");this.x=(0,n.getInteger)({data:e.x,defaultValue:"useXDCSetting",validator:e=>!0});this.y=(0,n.getInteger)({data:e.y,defaultValue:"useXDCSetting",validator:e=>!0})}}class PageRange extends i.StringObject{constructor(e){super(o,"pageRange")}[i.$finalize](){const e=this[i.$content].trim().split(/\s+/).map((e=>parseInt(e,10))),t=[];for(let r=0,a=e.length;r<a;r+=2)t.push(e.slice(r,r+2));this[i.$content]=t}}class Pagination extends i.OptionObject{constructor(e){super(o,"pagination",["simplex","duplexShortEdge","duplexLongEdge"])}}class PaginationOverride extends i.OptionObject{constructor(e){super(o,"paginationOverride",["none","forceDuplex","forceDuplexLongEdge","forceDuplexShortEdge","forceSimplex"])}}class Part extends i.IntegerObject{constructor(e){super(o,"part",1,(e=>!1))}}class Pcl extends i.XFAObject{constructor(e){super(o,"pcl",!0);this.name=e.name||"";this.batchOutput=null;this.fontInfo=null;this.jog=null;this.mediumInfo=null;this.outputBin=null;this.pageOffset=null;this.staple=null;this.xdc=null}}class Pdf extends i.XFAObject{constructor(e){super(o,"pdf",!0);this.name=e.name||"";this.adobeExtensionLevel=null;this.batchOutput=null;this.compression=null;this.creator=null;this.encryption=null;this.fontInfo=null;this.interactive=null;this.linearized=null;this.openAction=null;this.pdfa=null;this.producer=null;this.renderPolicy=null;this.scriptModel=null;this.silentPrint=null;this.submitFormat=null;this.tagged=null;this.version=null;this.viewerPreferences=null;this.xdc=null}}class Pdfa extends i.XFAObject{constructor(e){super(o,"pdfa",!0);this.amd=null;this.conformance=null;this.includeXDPContent=null;this.part=null}}class Permissions extends i.XFAObject{constructor(e){super(o,"permissions",!0);this.accessibleContent=null;this.change=null;this.contentCopy=null;this.documentAssembly=null;this.formFieldFilling=null;this.modifyAnnots=null;this.plaintextMetadata=null;this.print=null;this.printHighQuality=null}}class PickTrayByPDFSize extends i.Option01{constructor(e){super(o,"pickTrayByPDFSize")}}class Picture extends i.StringObject{constructor(e){super(o,"picture")}}class PlaintextMetadata extends i.Option01{constructor(e){super(o,"plaintextMetadata")}}class Presence extends i.OptionObject{constructor(e){super(o,"presence",["preserve","dissolve","dissolveStructure","ignore","remove"])}}class Present extends i.XFAObject{constructor(e){super(o,"present",!0);this.behaviorOverride=null;this.cache=null;this.common=null;this.copies=null;this.destination=null;this.incrementalMerge=null;this.layout=null;this.output=null;this.overprint=null;this.pagination=null;this.paginationOverride=null;this.script=null;this.validate=null;this.xdp=null;this.driver=new i.XFAObjectArray;this.labelPrinter=new i.XFAObjectArray;this.pcl=new i.XFAObjectArray;this.pdf=new i.XFAObjectArray;this.ps=new i.XFAObjectArray;this.submitUrl=new i.XFAObjectArray;this.webClient=new i.XFAObjectArray;this.zpl=new i.XFAObjectArray}}class Print extends i.Option01{constructor(e){super(o,"print")}}class PrintHighQuality extends i.Option01{constructor(e){super(o,"printHighQuality")}}class PrintScaling extends i.OptionObject{constructor(e){super(o,"printScaling",["appdefault","noScaling"])}}class PrinterName extends i.StringObject{constructor(e){super(o,"printerName")}}class Producer extends i.StringObject{constructor(e){super(o,"producer")}}class Ps extends i.XFAObject{constructor(e){super(o,"ps",!0);this.name=e.name||"";this.batchOutput=null;this.fontInfo=null;this.jog=null;this.mediumInfo=null;this.outputBin=null;this.staple=null;this.xdc=null}}class Range extends i.ContentObject{constructor(e){super(o,"range")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s*,\s*/,2).map((e=>e.split("-").map((e=>parseInt(e.trim(),10))))).filter((e=>e.every((e=>!isNaN(e))))).map((e=>{1===e.length&&e.push(e[0]);return e}))}}class Record extends i.ContentObject{constructor(e){super(o,"record")}[i.$finalize](){this[i.$content]=this[i.$content].trim();const e=parseInt(this[i.$content],10);!isNaN(e)&&e>=0&&(this[i.$content]=e)}}class Relevant extends i.ContentObject{constructor(e){super(o,"relevant")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/)}}class Rename extends i.ContentObject{constructor(e){super(o,"rename")}[i.$finalize](){this[i.$content]=this[i.$content].trim();(this[i.$content].toLowerCase().startsWith("xml")||this[i.$content].match(new RegExp("[\\p{L}_][\\p{L}\\d._\\p{M}-]*","u")))&&(0,s.warn)("XFA - Rename: invalid XFA name")}}class RenderPolicy extends i.OptionObject{constructor(e){super(o,"renderPolicy",["server","client"])}}class RunScripts extends i.OptionObject{constructor(e){super(o,"runScripts",["both","client","none","server"])}}class Script extends i.XFAObject{constructor(e){super(o,"script",!0);this.currentPage=null;this.exclude=null;this.runScripts=null}}class ScriptModel extends i.OptionObject{constructor(e){super(o,"scriptModel",["XFA","none"])}}class Severity extends i.OptionObject{constructor(e){super(o,"severity",["ignore","error","information","trace","warning"])}}class SilentPrint extends i.XFAObject{constructor(e){super(o,"silentPrint",!0);this.addSilentPrint=null;this.printerName=null}}class Staple extends i.XFAObject{constructor(e){super(o,"staple");this.mode=(0,n.getStringOption)(e.mode,["usePrinterSetting","on","off"])}}class StartNode extends i.StringObject{constructor(e){super(o,"startNode")}}class StartPage extends i.IntegerObject{constructor(e){super(o,"startPage",0,(e=>!0))}}class SubmitFormat extends i.OptionObject{constructor(e){super(o,"submitFormat",["html","delegate","fdf","xml","pdf"])}}class SubmitUrl extends i.StringObject{constructor(e){super(o,"submitUrl")}}class SubsetBelow extends i.IntegerObject{constructor(e){super(o,"subsetBelow",100,(e=>e>=0&&e<=100))}}class SuppressBanner extends i.Option01{constructor(e){super(o,"suppressBanner")}}class Tagged extends i.Option01{constructor(e){super(o,"tagged")}}class Template extends i.XFAObject{constructor(e){super(o,"template",!0);this.base=null;this.relevant=null;this.startPage=null;this.uri=null;this.xsl=null}}class Threshold extends i.OptionObject{constructor(e){super(o,"threshold",["trace","error","information","warning"])}}class To extends i.OptionObject{constructor(e){super(o,"to",["null","memory","stderr","stdout","system","uri"])}}class TemplateCache extends i.XFAObject{constructor(e){super(o,"templateCache");this.maxEntries=(0,n.getInteger)({data:e.maxEntries,defaultValue:5,validator:e=>e>=0})}}class Trace extends i.XFAObject{constructor(e){super(o,"trace",!0);this.area=new i.XFAObjectArray}}class Transform extends i.XFAObject{constructor(e){super(o,"transform",!0);this.groupParent=null;this.ifEmpty=null;this.nameAttr=null;this.picture=null;this.presence=null;this.rename=null;this.whitespace=null}}class Type extends i.OptionObject{constructor(e){super(o,"type",["none","ascii85","asciiHex","ccittfax","flate","lzw","runLength","native","xdp","mergedXDP"])}}class Uri extends i.StringObject{constructor(e){super(o,"uri")}}class Validate extends i.OptionObject{constructor(e){super(o,"validate",["preSubmit","prePrint","preExecute","preSave"])}}class ValidateApprovalSignatures extends i.ContentObject{constructor(e){super(o,"validateApprovalSignatures")}[i.$finalize](){this[i.$content]=this[i.$content].trim().split(/\s+/).filter((e=>["docReady","postSign"].includes(e)))}}class ValidationMessaging extends i.OptionObject{constructor(e){super(o,"validationMessaging",["allMessagesIndividually","allMessagesTogether","firstMessageOnly","noMessages"])}}class Version extends i.OptionObject{constructor(e){super(o,"version",["1.7","1.6","1.5","1.4","1.3","1.2"])}}class VersionControl extends i.XFAObject{constructor(e){super(o,"VersionControl");this.outputBelow=(0,n.getStringOption)(e.outputBelow,["warn","error","update"]);this.sourceAbove=(0,n.getStringOption)(e.sourceAbove,["warn","error"]);this.sourceBelow=(0,n.getStringOption)(e.sourceBelow,["update","maintain"])}}class ViewerPreferences extends i.XFAObject{constructor(e){super(o,"viewerPreferences",!0);this.ADBE_JSConsole=null;this.ADBE_JSDebugger=null;this.addViewerPreferences=null;this.duplexOption=null;this.enforce=null;this.numberOfCopies=null;this.pageRange=null;this.pickTrayByPDFSize=null;this.printScaling=null}}class WebClient extends i.XFAObject{constructor(e){super(o,"webClient",!0);this.name=e.name?e.name.trim():"";this.fontInfo=null;this.xdc=null}}class Whitespace extends i.OptionObject{constructor(e){super(o,"whitespace",["preserve","ltrim","normalize","rtrim","trim"])}}class Window extends i.ContentObject{constructor(e){super(o,"window")}[i.$finalize](){const e=this[i.$content].trim().split(/\s*,\s*/,2).map((e=>parseInt(e,10)));if(e.some((e=>isNaN(e))))this[i.$content]=[0,0];else{1===e.length&&e.push(e[0]);this[i.$content]=e}}}class Xdc extends i.XFAObject{constructor(e){super(o,"xdc",!0);this.uri=new i.XFAObjectArray;this.xsl=new i.XFAObjectArray}}class Xdp extends i.XFAObject{constructor(e){super(o,"xdp",!0);this.packets=null}}class Xsl extends i.XFAObject{constructor(e){super(o,"xsl",!0);this.debug=null;this.uri=null}}class Zpl extends i.XFAObject{constructor(e){super(o,"zpl",!0);this.name=e.name?e.name.trim():"";this.batchOutput=null;this.flipLabel=null;this.fontInfo=null;this.xdc=null}}class ConfigNamespace{static[a.$buildXFAObject](e,t){if(ConfigNamespace.hasOwnProperty(e))return ConfigNamespace[e](t)}static acrobat(e){return new Acrobat(e)}static acrobat7(e){return new Acrobat7(e)}static ADBE_JSConsole(e){return new ADBE_JSConsole(e)}static ADBE_JSDebugger(e){return new ADBE_JSDebugger(e)}static addSilentPrint(e){return new AddSilentPrint(e)}static addViewerPreferences(e){return new AddViewerPreferences(e)}static adjustData(e){return new AdjustData(e)}static adobeExtensionLevel(e){return new AdobeExtensionLevel(e)}static agent(e){return new Agent(e)}static alwaysEmbed(e){return new AlwaysEmbed(e)}static amd(e){return new Amd(e)}static area(e){return new Area(e)}static attributes(e){return new Attributes(e)}static autoSave(e){return new AutoSave(e)}static base(e){return new Base(e)}static batchOutput(e){return new BatchOutput(e)}static behaviorOverride(e){return new BehaviorOverride(e)}static cache(e){return new Cache(e)}static change(e){return new Change(e)}static common(e){return new Common(e)}static compress(e){return new Compress(e)}static compressLogicalStructure(e){return new CompressLogicalStructure(e)}static compressObjectStream(e){return new CompressObjectStream(e)}static compression(e){return new Compression(e)}static config(e){return new Config(e)}static conformance(e){return new Conformance(e)}static contentCopy(e){return new ContentCopy(e)}static copies(e){return new Copies(e)}static creator(e){return new Creator(e)}static currentPage(e){return new CurrentPage(e)}static data(e){return new Data(e)}static debug(e){return new Debug(e)}static defaultTypeface(e){return new DefaultTypeface(e)}static destination(e){return new Destination(e)}static documentAssembly(e){return new DocumentAssembly(e)}static driver(e){return new Driver(e)}static duplexOption(e){return new DuplexOption(e)}static dynamicRender(e){return new DynamicRender(e)}static embed(e){return new Embed(e)}static encrypt(e){return new Encrypt(e)}static encryption(e){return new Encryption(e)}static encryptionLevel(e){return new EncryptionLevel(e)}static enforce(e){return new Enforce(e)}static equate(e){return new Equate(e)}static equateRange(e){return new EquateRange(e)}static exclude(e){return new Exclude(e)}static excludeNS(e){return new ExcludeNS(e)}static flipLabel(e){return new FlipLabel(e)}static fontInfo(e){return new FontInfo(e)}static formFieldFilling(e){return new FormFieldFilling(e)}static groupParent(e){return new GroupParent(e)}static ifEmpty(e){return new IfEmpty(e)}static includeXDPContent(e){return new IncludeXDPContent(e)}static incrementalLoad(e){return new IncrementalLoad(e)}static incrementalMerge(e){return new IncrementalMerge(e)}static interactive(e){return new Interactive(e)}static jog(e){return new Jog(e)}static labelPrinter(e){return new LabelPrinter(e)}static layout(e){return new Layout(e)}static level(e){return new Level(e)}static linearized(e){return new Linearized(e)}static locale(e){return new Locale(e)}static localeSet(e){return new LocaleSet(e)}static log(e){return new Log(e)}static map(e){return new MapElement(e)}static mediumInfo(e){return new MediumInfo(e)}static message(e){return new Message(e)}static messaging(e){return new Messaging(e)}static mode(e){return new Mode(e)}static modifyAnnots(e){return new ModifyAnnots(e)}static msgId(e){return new MsgId(e)}static nameAttr(e){return new NameAttr(e)}static neverEmbed(e){return new NeverEmbed(e)}static numberOfCopies(e){return new NumberOfCopies(e)}static openAction(e){return new OpenAction(e)}static output(e){return new Output(e)}static outputBin(e){return new OutputBin(e)}static outputXSL(e){return new OutputXSL(e)}static overprint(e){return new Overprint(e)}static packets(e){return new Packets(e)}static pageOffset(e){return new PageOffset(e)}static pageRange(e){return new PageRange(e)}static pagination(e){return new Pagination(e)}static paginationOverride(e){return new PaginationOverride(e)}static part(e){return new Part(e)}static pcl(e){return new Pcl(e)}static pdf(e){return new Pdf(e)}static pdfa(e){return new Pdfa(e)}static permissions(e){return new Permissions(e)}static pickTrayByPDFSize(e){return new PickTrayByPDFSize(e)}static picture(e){return new Picture(e)}static plaintextMetadata(e){return new PlaintextMetadata(e)}static presence(e){return new Presence(e)}static present(e){return new Present(e)}static print(e){return new Print(e)}static printHighQuality(e){return new PrintHighQuality(e)}static printScaling(e){return new PrintScaling(e)}static printerName(e){return new PrinterName(e)}static producer(e){return new Producer(e)}static ps(e){return new Ps(e)}static range(e){return new Range(e)}static record(e){return new Record(e)}static relevant(e){return new Relevant(e)}static rename(e){return new Rename(e)}static renderPolicy(e){return new RenderPolicy(e)}static runScripts(e){return new RunScripts(e)}static script(e){return new Script(e)}static scriptModel(e){return new ScriptModel(e)}static severity(e){return new Severity(e)}static silentPrint(e){return new SilentPrint(e)}static staple(e){return new Staple(e)}static startNode(e){return new StartNode(e)}static startPage(e){return new StartPage(e)}static submitFormat(e){return new SubmitFormat(e)}static submitUrl(e){return new SubmitUrl(e)}static subsetBelow(e){return new SubsetBelow(e)}static suppressBanner(e){return new SuppressBanner(e)}static tagged(e){return new Tagged(e)}static template(e){return new Template(e)}static templateCache(e){return new TemplateCache(e)}static threshold(e){return new Threshold(e)}static to(e){return new To(e)}static trace(e){return new Trace(e)}static transform(e){return new Transform(e)}static type(e){return new Type(e)}static uri(e){return new Uri(e)}static validate(e){return new Validate(e)}static validateApprovalSignatures(e){return new ValidateApprovalSignatures(e)}static validationMessaging(e){return new ValidationMessaging(e)}static version(e){return new Version(e)}static versionControl(e){return new VersionControl(e)}static viewerPreferences(e){return new ViewerPreferences(e)}static webClient(e){return new WebClient(e)}static whitespace(e){return new Whitespace(e)}static window(e){return new Window(e)}static xdc(e){return new Xdc(e)}static xdp(e){return new Xdp(e)}static xsl(e){return new Xsl(e)}static zpl(e){return new Zpl(e)}}t.ConfigNamespace=ConfigNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.ConnectionSetNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.connectionSet.id;class ConnectionSet extends i.XFAObject{constructor(e){super(n,"connectionSet",!0);this.wsdlConnection=new i.XFAObjectArray;this.xmlConnection=new i.XFAObjectArray;this.xsdConnection=new i.XFAObjectArray}}class EffectiveInputPolicy extends i.XFAObject{constructor(e){super(n,"effectiveInputPolicy");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class EffectiveOutputPolicy extends i.XFAObject{constructor(e){super(n,"effectiveOutputPolicy");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Operation extends i.StringObject{constructor(e){super(n,"operation");this.id=e.id||"";this.input=e.input||"";this.name=e.name||"";this.output=e.output||"";this.use=e.use||"";this.usehref=e.usehref||""}}class RootElement extends i.StringObject{constructor(e){super(n,"rootElement");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class SoapAction extends i.StringObject{constructor(e){super(n,"soapAction");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class SoapAddress extends i.StringObject{constructor(e){super(n,"soapAddress");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class Uri extends i.StringObject{constructor(e){super(n,"uri");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class WsdlAddress extends i.StringObject{constructor(e){super(n,"wsdlAddress");this.id=e.id||"";this.name=e.name||"";this.use=e.use||"";this.usehref=e.usehref||""}}class WsdlConnection extends i.XFAObject{constructor(e){super(n,"wsdlConnection",!0);this.dataDescription=e.dataDescription||"";this.name=e.name||"";this.effectiveInputPolicy=null;this.effectiveOutputPolicy=null;this.operation=null;this.soapAction=null;this.soapAddress=null;this.wsdlAddress=null}}class XmlConnection extends i.XFAObject{constructor(e){super(n,"xmlConnection",!0);this.dataDescription=e.dataDescription||"";this.name=e.name||"";this.uri=null}}class XsdConnection extends i.XFAObject{constructor(e){super(n,"xsdConnection",!0);this.dataDescription=e.dataDescription||"";this.name=e.name||"";this.rootElement=null;this.uri=null}}class ConnectionSetNamespace{static[a.$buildXFAObject](e,t){if(ConnectionSetNamespace.hasOwnProperty(e))return ConnectionSetNamespace[e](t)}static connectionSet(e){return new ConnectionSet(e)}static effectiveInputPolicy(e){return new EffectiveInputPolicy(e)}static effectiveOutputPolicy(e){return new EffectiveOutputPolicy(e)}static operation(e){return new Operation(e)}static rootElement(e){return new RootElement(e)}static soapAction(e){return new SoapAction(e)}static soapAddress(e){return new SoapAddress(e)}static uri(e){return new Uri(e)}static wsdlAddress(e){return new WsdlAddress(e)}static wsdlConnection(e){return new WsdlConnection(e)}static xmlConnection(e){return new XmlConnection(e)}static xsdConnection(e){return new XsdConnection(e)}}t.ConnectionSetNamespace=ConnectionSetNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.DatasetsNamespace=void 0;var a=r(50),i=r(52);const n=i.NamespaceIds.datasets.id;class Data extends a.XmlObject{constructor(e){super(n,"data",e)}}class Datasets extends a.XFAObject{constructor(e){super(n,"datasets",!0);this.data=null;this.Signature=null}[a.$onChild](e){const t=e[a.$nodeName];"data"===t&&e[a.$namespaceId]===n||"Signature"===t&&e[a.$namespaceId]===i.NamespaceIds.signature.id?this[t]=e:e[a.$global]=!0;this[a.$appendChild](e)}}class DatasetsNamespace{static[i.$buildXFAObject](e,t){if(DatasetsNamespace.hasOwnProperty(e))return DatasetsNamespace[e](t)}static datasets(e){return new Datasets(e)}static data(e){return new Data(e)}}t.DatasetsNamespace=DatasetsNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.LocaleSetNamespace=void 0;var a=r(52),i=r(50),n=r(51);const s=a.NamespaceIds.localeSet.id;class CalendarSymbols extends i.XFAObject{constructor(e){super(s,"calendarSymbols",!0);this.name="gregorian";this.dayNames=new i.XFAObjectArray(2);this.eraNames=null;this.meridiemNames=null;this.monthNames=new i.XFAObjectArray(2)}}class CurrencySymbol extends i.StringObject{constructor(e){super(s,"currencySymbol");this.name=(0,n.getStringOption)(e.name,["symbol","isoname","decimal"])}}class CurrencySymbols extends i.XFAObject{constructor(e){super(s,"currencySymbols",!0);this.currencySymbol=new i.XFAObjectArray(3)}}class DatePattern extends i.StringObject{constructor(e){super(s,"datePattern");this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class DatePatterns extends i.XFAObject{constructor(e){super(s,"datePatterns",!0);this.datePattern=new i.XFAObjectArray(4)}}class DateTimeSymbols extends i.ContentObject{constructor(e){super(s,"dateTimeSymbols")}}class Day extends i.StringObject{constructor(e){super(s,"day")}}class DayNames extends i.XFAObject{constructor(e){super(s,"dayNames",!0);this.abbr=(0,n.getInteger)({data:e.abbr,defaultValue:0,validate:e=>1===e});this.day=new i.XFAObjectArray(7)}}class Era extends i.StringObject{constructor(e){super(s,"era")}}class EraNames extends i.XFAObject{constructor(e){super(s,"eraNames",!0);this.era=new i.XFAObjectArray(2)}}class Locale extends i.XFAObject{constructor(e){super(s,"locale",!0);this.desc=e.desc||"";this.name="isoname";this.calendarSymbols=null;this.currencySymbols=null;this.datePatterns=null;this.dateTimeSymbols=null;this.numberPatterns=null;this.numberSymbols=null;this.timePatterns=null;this.typeFaces=null}}class LocaleSet extends i.XFAObject{constructor(e){super(s,"localeSet",!0);this.locale=new i.XFAObjectArray}}class Meridiem extends i.StringObject{constructor(e){super(s,"meridiem")}}class MeridiemNames extends i.XFAObject{constructor(e){super(s,"meridiemNames",!0);this.meridiem=new i.XFAObjectArray(2)}}class Month extends i.StringObject{constructor(e){super(s,"month")}}class MonthNames extends i.XFAObject{constructor(e){super(s,"monthNames",!0);this.abbr=(0,n.getInteger)({data:e.abbr,defaultValue:0,validate:e=>1===e});this.month=new i.XFAObjectArray(12)}}class NumberPattern extends i.StringObject{constructor(e){super(s,"numberPattern");this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class NumberPatterns extends i.XFAObject{constructor(e){super(s,"numberPatterns",!0);this.numberPattern=new i.XFAObjectArray(4)}}class NumberSymbol extends i.StringObject{constructor(e){super(s,"numberSymbol");this.name=(0,n.getStringOption)(e.name,["decimal","grouping","percent","minus","zero"])}}class NumberSymbols extends i.XFAObject{constructor(e){super(s,"numberSymbols",!0);this.numberSymbol=new i.XFAObjectArray(5)}}class TimePattern extends i.StringObject{constructor(e){super(s,"timePattern");this.name=(0,n.getStringOption)(e.name,["full","long","med","short"])}}class TimePatterns extends i.XFAObject{constructor(e){super(s,"timePatterns",!0);this.timePattern=new i.XFAObjectArray(4)}}class TypeFace extends i.XFAObject{constructor(e){super(s,"typeFace",!0);this.name=""|e.name}}class TypeFaces extends i.XFAObject{constructor(e){super(s,"typeFaces",!0);this.typeFace=new i.XFAObjectArray}}class LocaleSetNamespace{static[a.$buildXFAObject](e,t){if(LocaleSetNamespace.hasOwnProperty(e))return LocaleSetNamespace[e](t)}static calendarSymbols(e){return new CalendarSymbols(e)}static currencySymbol(e){return new CurrencySymbol(e)}static currencySymbols(e){return new CurrencySymbols(e)}static datePattern(e){return new DatePattern(e)}static datePatterns(e){return new DatePatterns(e)}static dateTimeSymbols(e){return new DateTimeSymbols(e)}static day(e){return new Day(e)}static dayNames(e){return new DayNames(e)}static era(e){return new Era(e)}static eraNames(e){return new EraNames(e)}static locale(e){return new Locale(e)}static localeSet(e){return new LocaleSet(e)}static meridiem(e){return new Meridiem(e)}static meridiemNames(e){return new MeridiemNames(e)}static month(e){return new Month(e)}static monthNames(e){return new MonthNames(e)}static numberPattern(e){return new NumberPattern(e)}static numberPatterns(e){return new NumberPatterns(e)}static numberSymbol(e){return new NumberSymbol(e)}static numberSymbols(e){return new NumberSymbols(e)}static timePattern(e){return new TimePattern(e)}static timePatterns(e){return new TimePatterns(e)}static typeFace(e){return new TypeFace(e)}static typeFaces(e){return new TypeFaces(e)}}t.LocaleSetNamespace=LocaleSetNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.SignatureNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.signature.id;class Signature extends i.XFAObject{constructor(e){super(n,"signature",!0)}}class SignatureNamespace{static[a.$buildXFAObject](e,t){if(SignatureNamespace.hasOwnProperty(e))return SignatureNamespace[e](t)}static signature(e){return new Signature(e)}}t.SignatureNamespace=SignatureNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.StylesheetNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.stylesheet.id;class Stylesheet extends i.XFAObject{constructor(e){super(n,"stylesheet",!0)}}class StylesheetNamespace{static[a.$buildXFAObject](e,t){if(StylesheetNamespace.hasOwnProperty(e))return StylesheetNamespace[e](t)}static stylesheet(e){return new Stylesheet(e)}}t.StylesheetNamespace=StylesheetNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XdpNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.xdp.id;class Xdp extends i.XFAObject{constructor(e){super(n,"xdp",!0);this.uuid=e.uuid||"";this.timeStamp=e.timeStamp||"";this.config=null;this.connectionSet=null;this.datasets=null;this.localeSet=null;this.stylesheet=new i.XFAObjectArray;this.template=null}[i.$onChildCheck](e){const t=a.NamespaceIds[e[i.$nodeName]];return t&&e[i.$namespaceId]===t.id}}class XdpNamespace{static[a.$buildXFAObject](e,t){if(XdpNamespace.hasOwnProperty(e))return XdpNamespace[e](t)}static xdp(e){return new Xdp(e)}}t.XdpNamespace=XdpNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.XhtmlNamespace=void 0;var a=r(52),i=r(50);const n=a.NamespaceIds.xhtml.id,s=new Set(["color","font","font-family","font-size","font-stretch","font-style","font-weight","margin","margin-bottom","margin-left","margin-right","margin-top","letter-spacing","line-height","orphans","page-break-after","page-break-before","page-break-inside","tab-interval","tab-stop","text-decoration","text-indent","vertical-align","widows","kerning-mode","xfa-font-horizontal-scale","xfa-font-vertical-scale","xfa-tab-stops"]);function checkStyle(e){return e?e.trim().split(/\s*;\s*/).filter((e=>!!e)).map((e=>e.split(/\s*:\s*/,2))).filter((([e])=>s.has(e))).map((e=>e.join(":"))).join(";"):""}class A extends i.XmlObject{constructor(e){super(n,"a");this.href=e.href||"";this.style=checkStyle(e.style)}}class B extends i.XmlObject{constructor(e){super(n,"b");this.style=checkStyle(e.style)}}class Body extends i.XmlObject{constructor(e){super(n,"body");this.style=checkStyle(e.style)}}class Br extends i.XmlObject{constructor(e){super(n,"br");this.style=checkStyle(e.style)}[i.$text](){return"\n"}}class Html extends i.XmlObject{constructor(e){super(n,"html");this.style=checkStyle(e.style)}}class I extends i.XmlObject{constructor(e){super(n,"i");this.style=checkStyle(e.style)}}class Li extends i.XmlObject{constructor(e){super(n,"li");this.style=checkStyle(e.style)}}class Ol extends i.XmlObject{constructor(e){super(n,"ol");this.style=checkStyle(e.style)}}class P extends i.XmlObject{constructor(e){super(n,"p");this.style=checkStyle(e.style)}}class Span extends i.XmlObject{constructor(e){super(n,"span");this.style=checkStyle(e.style)}}class Sub extends i.XmlObject{constructor(e){super(n,"sub");this.style=checkStyle(e.style)}}class Sup extends i.XmlObject{constructor(e){super(n,"sup");this.style=checkStyle(e.style)}}class Ul extends i.XmlObject{constructor(e){super(n,"ul");this.style=checkStyle(e.style)}}class XhtmlNamespace{static[a.$buildXFAObject](e,t){if(XhtmlNamespace.hasOwnProperty(e))return XhtmlNamespace[e](t)}static a(e){return new A(e)}static b(e){return new B(e)}static body(e){return new Body(e)}static br(e){return new Br(e)}static html(e){return new Html(e)}static i(e){return new I(e)}static li(e){return new Li(e)}static ol(e){return new Ol(e)}static p(e){return new P(e)}static span(e){return new Span(e)}static sub(e){return new Sub(e)}static sup(e){return new Sup(e)}static ul(e){return new Ul(e)}}t.XhtmlNamespace=XhtmlNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.UnknownNamespace=void 0;var a=r(52),i=r(50);class UnknownNamespace{constructor(e){this.namespaceId=e}[a.$buildXFAObject](e,t){return new i.XmlObject(this.namespaceId,e,t)}}t.UnknownNamespace=UnknownNamespace},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.MessageHandler=void 0;var a=r(2);const i=1,n=2,s=1,o=2,c=3,l=4,h=5,u=6,d=7,f=8;function wrapReason(e){if("object"!=typeof e||null===e)return e;switch(e.name){case"AbortException":return new a.AbortException(e.message);case"MissingPDFException":return new a.MissingPDFException(e.message);case"UnexpectedResponseException":return new a.UnexpectedResponseException(e.message,e.status);case"UnknownErrorException":return new a.UnknownErrorException(e.message,e.details);default:return new a.UnknownErrorException(e.message,e.toString())}}t.MessageHandler=class MessageHandler{constructor(e,t,r){this.sourceName=e;this.targetName=t;this.comObj=r;this.callbackId=1;this.streamId=1;this.postMessageTransfers=!0;this.streamSinks=Object.create(null);this.streamControllers=Object.create(null);this.callbackCapabilities=Object.create(null);this.actionHandler=Object.create(null);this._onComObjOnMessage=e=>{const t=e.data;if(t.targetName!==this.sourceName)return;if(t.stream){this._processStreamMessage(t);return}if(t.callback){const e=t.callbackId,r=this.callbackCapabilities[e];if(!r)throw new Error(`Cannot resolve callback ${e}`);delete this.callbackCapabilities[e];if(t.callback===i)r.resolve(t.data);else{if(t.callback!==n)throw new Error("Unexpected callback case");r.reject(wrapReason(t.reason))}return}const a=this.actionHandler[t.action];if(!a)throw new Error(`Unknown action from worker: ${t.action}`);if(t.callbackId){const e=this.sourceName,s=t.sourceName;new Promise((function(e){e(a(t.data))})).then((function(a){r.postMessage({sourceName:e,targetName:s,callback:i,callbackId:t.callbackId,data:a})}),(function(a){r.postMessage({sourceName:e,targetName:s,callback:n,callbackId:t.callbackId,reason:wrapReason(a)})}))}else t.streamId?this._createStreamSink(t):a(t.data)};r.addEventListener("message",this._onComObjOnMessage)}on(e,t){const r=this.actionHandler;if(r[e])throw new Error(`There is already an actionName called "${e}"`);r[e]=t}send(e,t,r){this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,data:t},r)}sendWithPromise(e,t,r){const i=this.callbackId++,n=(0,a.createPromiseCapability)();this.callbackCapabilities[i]=n;try{this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,callbackId:i,data:t},r)}catch(e){n.reject(e)}return n.promise}sendWithStream(e,t,r,i){const n=this.streamId++,o=this.sourceName,c=this.targetName,l=this.comObj;return new ReadableStream({start:r=>{const s=(0,a.createPromiseCapability)();this.streamControllers[n]={controller:r,startCall:s,pullCall:null,cancelCall:null,isClosed:!1};this._postMessage({sourceName:o,targetName:c,action:e,streamId:n,data:t,desiredSize:r.desiredSize},i);return s.promise},pull:e=>{const t=(0,a.createPromiseCapability)();this.streamControllers[n].pullCall=t;l.postMessage({sourceName:o,targetName:c,stream:u,streamId:n,desiredSize:e.desiredSize});return t.promise},cancel:e=>{(0,a.assert)(e instanceof Error,"cancel must have a valid reason");const t=(0,a.createPromiseCapability)();this.streamControllers[n].cancelCall=t;this.streamControllers[n].isClosed=!0;l.postMessage({sourceName:o,targetName:c,stream:s,streamId:n,reason:wrapReason(e)});return t.promise}},r)}_createStreamSink(e){const t=this,r=this.actionHandler[e.action],i=e.streamId,n=this.sourceName,s=e.sourceName,o=this.comObj,u={enqueue(e,r=1,o){if(this.isCancelled)return;const c=this.desiredSize;this.desiredSize-=r;if(c>0&&this.desiredSize<=0){this.sinkCapability=(0,a.createPromiseCapability)();this.ready=this.sinkCapability.promise}t._postMessage({sourceName:n,targetName:s,stream:l,streamId:i,chunk:e},o)},close(){if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:n,targetName:s,stream:c,streamId:i});delete t.streamSinks[i]}},error(e){(0,a.assert)(e instanceof Error,"error must have a valid reason");if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:n,targetName:s,stream:h,streamId:i,reason:wrapReason(e)})}},sinkCapability:(0,a.createPromiseCapability)(),onPull:null,onCancel:null,isCancelled:!1,desiredSize:e.desiredSize,ready:null};u.sinkCapability.resolve();u.ready=u.sinkCapability.promise;this.streamSinks[i]=u;new Promise((function(t){t(r(e.data,u))})).then((function(){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,success:!0})}),(function(e){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,reason:wrapReason(e)})}))}_processStreamMessage(e){const t=e.streamId,r=this.sourceName,i=e.sourceName,n=this.comObj;switch(e.stream){case f:e.success?this.streamControllers[t].startCall.resolve():this.streamControllers[t].startCall.reject(wrapReason(e.reason));break;case d:e.success?this.streamControllers[t].pullCall.resolve():this.streamControllers[t].pullCall.reject(wrapReason(e.reason));break;case u:if(!this.streamSinks[t]){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,success:!0});break}this.streamSinks[t].desiredSize<=0&&e.desiredSize>0&&this.streamSinks[t].sinkCapability.resolve();this.streamSinks[t].desiredSize=e.desiredSize;const{onPull:g}=this.streamSinks[e.streamId];new Promise((function(e){e(g&&g())})).then((function(){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:r,targetName:i,stream:d,streamId:t,reason:wrapReason(e)})}));break;case l:(0,a.assert)(this.streamControllers[t],"enqueue should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].controller.enqueue(e.chunk);break;case c:(0,a.assert)(this.streamControllers[t],"close should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].isClosed=!0;this.streamControllers[t].controller.close();this._deleteStreamController(t);break;case h:(0,a.assert)(this.streamControllers[t],"error should have stream controller");this.streamControllers[t].controller.error(wrapReason(e.reason));this._deleteStreamController(t);break;case o:e.success?this.streamControllers[t].cancelCall.resolve():this.streamControllers[t].cancelCall.reject(wrapReason(e.reason));this._deleteStreamController(t);break;case s:if(!this.streamSinks[t])break;const{onCancel:p}=this.streamSinks[e.streamId];new Promise((function(t){t(p&&p(wrapReason(e.reason)))})).then((function(){n.postMessage({sourceName:r,targetName:i,stream:o,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:r,targetName:i,stream:o,streamId:t,reason:wrapReason(e)})}));this.streamSinks[t].sinkCapability.reject(wrapReason(e.reason));this.streamSinks[t].isCancelled=!0;delete this.streamSinks[t];break;default:throw new Error("Unexpected stream case")}}async _deleteStreamController(e){await Promise.allSettled([this.streamControllers[e].startCall,this.streamControllers[e].pullCall,this.streamControllers[e].cancelCall].map((function(e){return e&&e.promise})));delete this.streamControllers[e]}_postMessage(e,t){t&&this.postMessageTransfers?this.comObj.postMessage(e,t):this.comObj.postMessage(e)}destroy(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}}},(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:!0});t.PDFWorkerStream=void 0;var a=r(2);t.PDFWorkerStream=class PDFWorkerStream{constructor(e){this._msgHandler=e;this._contentLength=null;this._fullRequestReader=null;this._rangeRequestReaders=[]}getFullReader(){(0,a.assert)(!this._fullRequestReader,"PDFWorkerStream.getFullReader can only be called once.");this._fullRequestReader=new PDFWorkerStreamReader(this._msgHandler);return this._fullRequestReader}getRangeReader(e,t){const r=new PDFWorkerStreamRangeReader(e,t,this._msgHandler);this._rangeRequestReaders.push(r);return r}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);this._rangeRequestReaders.slice(0).forEach((function(t){t.cancel(e)}))}};class PDFWorkerStreamReader{constructor(e){this._msgHandler=e;this.onProgress=null;this._contentLength=null;this._isRangeSupported=!1;this._isStreamingSupported=!1;const t=this._msgHandler.sendWithStream("GetReader");this._reader=t.getReader();this._headersReady=this._msgHandler.sendWithPromise("ReaderHeadersReady").then((e=>{this._isStreamingSupported=e.isStreamingSupported;this._isRangeSupported=e.isRangeSupported;this._contentLength=e.contentLength}))}get headersReady(){return this._headersReady}get contentLength(){return this._contentLength}get isStreamingSupported(){return this._isStreamingSupported}get isRangeSupported(){return this._isRangeSupported}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}class PDFWorkerStreamRangeReader{constructor(e,t,r){this._msgHandler=r;this.onProgress=null;const a=this._msgHandler.sendWithStream("GetRangeReader",{begin:e,end:t});this._reader=a.getReader()}get isStreamingSupported(){return!1}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}}],t={};function __w_pdfjs_require__(r){var a=t[r];if(void 0!==a)return a.exports;var i=t[r]={exports:{}};e[r](i,i.exports,__w_pdfjs_require__);return i.exports}__w_pdfjs_require__.d=(e,t)=>{for(var r in t)__w_pdfjs_require__.o(t,r)&&!__w_pdfjs_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})};__w_pdfjs_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t);__w_pdfjs_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"});Object.defineProperty(e,"__esModule",{value:!0})};var r={};(()=>{var e=r;Object.defineProperty(e,"__esModule",{value:!0});Object.defineProperty(e,"WorkerMessageHandler",{enumerable:!0,get:function(){return t.WorkerMessageHandler}});var t=__w_pdfjs_require__(1)})();return r})()}));