export class CanvasGraphics {
    constructor(canvasCtx: any, commonObjs: any, objs: any, canvasFactory: any, filterFactory: any, { optionalContentConfig, markedContentStack }: {
        optionalContentConfig: any;
        markedContentStack?: null | undefined;
    }, annotationCanvasMap: any, pageColors: any, dependencyTracker: any);
    ctx: any;
    current: CanvasExtraState;
    stateStack: any[];
    pendingClip: {} | {} | null;
    pendingEOFill: boolean;
    res: any;
    xobjs: any;
    commonObjs: any;
    objs: any;
    canvasFactory: any;
    filterFactory: any;
    groupStack: any[];
    baseTransform: any;
    baseTransformStack: any[];
    groupLevel: number;
    smaskStack: any[];
    smaskCounter: number;
    tempSMask: any;
    suspendedCtx: any;
    contentVisible: boolean;
    markedContentStack: never[];
    optionalContentConfig: any;
    cachedCanvases: CachedCanvases;
    cachedPatterns: Map<any, any>;
    annotationCanvasMap: any;
    viewportScale: number;
    outputScaleX: number;
    outputScaleY: number;
    pageColors: any;
    _cachedScaleForStroking: number[];
    _cachedGetSinglePixelWidth: number | null;
    _cachedBitmapsMap: Map<any, any>;
    dependencyTracker: any;
    getObject(opIdx: any, data: any, fallback?: null): any;
    beginDrawing({ transform, viewport, transparency, background, }: {
        transform: any;
        viewport: any;
        transparency?: boolean | undefined;
        background?: null | undefined;
    }): void;
    compositeCtx: any;
    transparentCanvas: any;
    executeOperatorList(operatorList: any, executionStartIdx: any, continueCallback: any, stepper: any, filteredOperationIndexes: any): any;
    endDrawing(): void;
    _scaleImage(img: any, inverseTransform: any): {
        img: any;
        paintWidth: any;
        paintHeight: any;
    };
    _createMaskCanvas(opIdx: any, img: any): {
        canvas: any;
        offsetX: number;
        offsetY: number;
    };
    setLineWidth(opIdx: any, width: any): void;
    setLineCap(opIdx: any, style: any): void;
    setLineJoin(opIdx: any, style: any): void;
    setMiterLimit(opIdx: any, limit: any): void;
    setDash(opIdx: any, dashArray: any, dashPhase: any): void;
    setRenderingIntent(opIdx: any, intent: any): void;
    setFlatness(opIdx: any, flatness: any): void;
    setGState(opIdx: any, states: any): void;
    get inSMaskMode(): boolean;
    checkSMaskState(): void;
    /**
     * Soft mask mode takes the current main drawing canvas and replaces it with
     * a temporary canvas. Any drawing operations that happen on the temporary
     * canvas need to be composed with the main canvas that was suspended (see
     * `compose()`). The temporary canvas also duplicates many of its operations
     * on the suspended canvas to keep them in sync, so that when the soft mask
     * mode ends any clipping paths or transformations will still be active and in
     * the right order on the canvas' graphics state stack.
     */
    beginSMaskMode(opIdx: any): void;
    endSMaskMode(): void;
    compose(dirtyBox: any): void;
    composeSMask(ctx: any, smask: any, layerCtx: any, layerBox: any): void;
    genericComposeSMask(maskCtx: any, layerCtx: any, width: any, height: any, subtype: any, backdrop: any, transferMap: any, layerOffsetX: any, layerOffsetY: any, maskOffsetX: any, maskOffsetY: any): void;
    save(opIdx: any): void;
    restore(opIdx: any): void;
    transform(opIdx: any, a: any, b: any, c: any, d: any, e: any, f: any): void;
    constructPath(opIdx: any, op: any, data: any, minMax: any): void;
    _pathStartIdx: any;
    closePath(opIdx: any): void;
    stroke(opIdx: any, path: any, consumePath?: boolean): void;
    closeStroke(opIdx: any, path: any): void;
    fill(opIdx: any, path: any, consumePath?: boolean): void;
    eoFill(opIdx: any, path: any): void;
    fillStroke(opIdx: any, path: any): void;
    eoFillStroke(opIdx: any, path: any): void;
    closeFillStroke(opIdx: any, path: any): void;
    closeEOFillStroke(opIdx: any, path: any): void;
    endPath(opIdx: any, path: any): void;
    rawFillPath(opIdx: any, path: any): void;
    clip(opIdx: any): void;
    eoClip(opIdx: any): void;
    beginText(opIdx: any): void;
    endText(opIdx: any): void;
    setCharSpacing(opIdx: any, spacing: any): void;
    setWordSpacing(opIdx: any, spacing: any): void;
    setHScale(opIdx: any, scale: any): void;
    setLeading(opIdx: any, leading: any): void;
    setFont(opIdx: any, fontRefName: any, size: any): void;
    setTextRenderingMode(opIdx: any, mode: any): void;
    setTextRise(opIdx: any, rise: any): void;
    moveText(opIdx: any, x: any, y: any): void;
    setLeadingMoveText(opIdx: any, x: any, y: any): void;
    setTextMatrix(opIdx: any, matrix: any): void;
    nextLine(opIdx: any): void;
    paintChar(opIdx: any, character: any, x: any, y: any, patternFillTransform: any, patternStrokeTransform: any): void;
    get isFontSubpixelAAEnabled(): any;
    showText(opIdx: any, glyphs: any): undefined;
    showType3Text(opIdx: any, glyphs: any): void;
    setCharWidth(opIdx: any, xWidth: any, yWidth: any): void;
    setCharWidthAndBounds(opIdx: any, xWidth: any, yWidth: any, llx: any, lly: any, urx: any, ury: any): void;
    getColorN_Pattern(opIdx: any, IR: any): any;
    setStrokeColorN(opIdx: any, ...args: any[]): void;
    setFillColorN(opIdx: any, ...args: any[]): void;
    setStrokeRGBColor(opIdx: any, color: any): void;
    setStrokeTransparent(opIdx: any): void;
    setFillRGBColor(opIdx: any, color: any): void;
    setFillTransparent(opIdx: any): void;
    _getPattern(opIdx: any, objId: any, matrix?: null): any;
    shadingFill(opIdx: any, objId: any): void;
    beginInlineImage(): void;
    beginImageData(): void;
    paintFormXObjectBegin(opIdx: any, matrix: any, bbox: any): void;
    paintFormXObjectEnd(opIdx: any): void;
    beginGroup(opIdx: any, group: any): void;
    endGroup(opIdx: any, group: any): void;
    beginAnnotation(opIdx: any, id: any, rect: any, transform: any, matrix: any, hasOwnCanvas: any): void;
    annotationCanvas: any;
    endAnnotation(opIdx: any): void;
    paintImageMaskXObject(opIdx: any, img: any): void;
    paintImageMaskXObjectRepeat(opIdx: any, img: any, scaleX: any, skewX: number | undefined, skewY: number | undefined, scaleY: any, positions: any): void;
    paintImageMaskXObjectGroup(opIdx: any, images: any): void;
    paintImageXObject(opIdx: any, objId: any): void;
    paintImageXObjectRepeat(opIdx: any, objId: any, scaleX: any, scaleY: any, positions: any): void;
    applyTransferMapsToCanvas(ctx: any): any;
    applyTransferMapsToBitmap(imgData: any): any;
    paintInlineImageXObject(opIdx: any, imgData: any): void;
    paintInlineImageXObjectGroup(opIdx: any, imgData: any, map: any): void;
    paintSolidColorImageMask(opIdx: any): void;
    markPoint(opIdx: any, tag: any): void;
    markPointProps(opIdx: any, tag: any, properties: any): void;
    beginMarkedContent(opIdx: any, tag: any): void;
    beginMarkedContentProps(opIdx: any, tag: any, properties: any): void;
    endMarkedContent(opIdx: any): void;
    beginCompat(opIdx: any): void;
    endCompat(opIdx: any): void;
    consumePath(opIdx: any, path: any, clipBox: any): void;
    getSinglePixelWidth(): number;
    getScaleForStroking(): number[];
    rescaleAndStroke(path: any, saveRestore: any): void;
    isContentVisible(): boolean;
    #private;
}
declare class CanvasExtraState {
    constructor(width: any, height: any, preInit: any);
    alphaIsShape: boolean;
    fontSize: number;
    fontSizeScale: number;
    textMatrix: null;
    textMatrixScale: number;
    fontMatrix: number[];
    leading: number;
    x: number;
    y: number;
    lineX: number;
    lineY: number;
    charSpacing: number;
    wordSpacing: number;
    textHScale: number;
    textRenderingMode: number;
    textRise: number;
    fillColor: string;
    strokeColor: string;
    patternFill: boolean;
    patternStroke: boolean;
    fillAlpha: number;
    strokeAlpha: number;
    lineWidth: number;
    activeSMask: null;
    transferMaps: string;
    clipBox: Float32Array<ArrayBuffer>;
    minMax: Float32Array<ArrayBuffer>;
    clone(): any;
    getPathBoundingBox(pathType?: string, transform?: null): Float32Array<ArrayBuffer>;
    updateClipFromPath(): void;
    isEmptyClip(): boolean;
    startNewPathAndClipBox(box: any): void;
    getClippedPathBoundingBox(pathType?: string, transform?: null): number[] | null;
}
declare class CachedCanvases {
    constructor(canvasFactory: any);
    canvasFactory: any;
    cache: any;
    getCanvas(id: any, width: any, height: any): any;
    delete(id: any): void;
    clear(): void;
}
export {};
