// Generated by CoffeeScript 1.10.0
(function() {
  var DFont, Data, Directory, NameTable, fs;

  fs = require('fs');

  Data = require('../data');

  Directory = require('./directory');

  NameTable = require('./tables/name');

  DFont = (function() {
    DFont.open = function(filename) {
      var contents;
      contents = fs.readFileSync(filename);
      return new DFont(contents);
    };

    function DFont(contents) {
      this.contents = new Data(contents);
      this.parse(this.contents);
    }

    DFont.prototype.parse = function(data) {
      var attr, b2, b3, b4, dataLength, dataOffset, dataOfs, entry, font, handle, i, id, j, k, l, len, length, mapLength, mapOffset, maxIndex, maxTypeIndex, name, nameListOffset, nameOfs, p, pos, ref, ref1, refListOffset, type, typeListOffset;
      dataOffset = data.readInt();
      mapOffset = data.readInt();
      dataLength = data.readInt();
      mapLength = data.readInt();
      this.map = {};
      data.pos = mapOffset + 24;
      typeListOffset = data.readShort() + mapOffset;
      nameListOffset = data.readShort() + mapOffset;
      data.pos = typeListOffset;
      maxIndex = data.readShort();
      for (i = k = 0, ref = maxIndex; k <= ref; i = k += 1) {
        type = data.readString(4);
        maxTypeIndex = data.readShort();
        refListOffset = data.readShort();
        this.map[type] = {
          list: [],
          named: {}
        };
        pos = data.pos;
        data.pos = typeListOffset + refListOffset;
        for (j = l = 0, ref1 = maxTypeIndex; l <= ref1; j = l += 1) {
          id = data.readShort();
          nameOfs = data.readShort();
          attr = data.readByte();
          b2 = data.readByte() << 16;
          b3 = data.readByte() << 8;
          b4 = data.readByte();
          dataOfs = dataOffset + (0 | b2 | b3 | b4);
          handle = data.readUInt32();
          entry = {
            id: id,
            attributes: attr,
            offset: dataOfs,
            handle: handle
          };
          p = data.pos;
          if (nameOfs !== -1 && (nameListOffset + nameOfs < mapOffset + mapLength)) {
            data.pos = nameListOffset + nameOfs;
            len = data.readByte();
            entry.name = data.readString(len);
          } else if (type === 'sfnt') {
            data.pos = entry.offset;
            length = data.readUInt32();
            font = {};
            font.contents = new Data(data.slice(data.pos, data.pos + length));
            font.directory = new Directory(font.contents);
            name = new NameTable(font);
            entry.name = name.fontName[0].raw;
          }
          data.pos = p;
          this.map[type].list.push(entry);
          if (entry.name) {
            this.map[type].named[entry.name] = entry;
          }
        }
        data.pos = pos;
      }
    };

    DFont.prototype.getNamedFont = function(name) {
      var data, entry, length, pos, ref, ret;
      data = this.contents;
      pos = data.pos;
      entry = (ref = this.map.sfnt) != null ? ref.named[name] : void 0;
      if (!entry) {
        throw new Error("Font " + name + " not found in DFont file.");
      }
      data.pos = entry.offset;
      length = data.readUInt32();
      ret = data.slice(data.pos, data.pos + length);
      data.pos = pos;
      return ret;
    };

    return DFont;

  })();

  module.exports = DFont;

}).call(this);
