// Generated by CoffeeScript 1.10.0
(function() {
  var CompoundGlyph, Data, GlyfTable, SimpleGlyph, Table,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty,
    slice = [].slice;

  Table = require('../table');

  Data = require('../../data');

  GlyfTable = (function(superClass) {
    extend(GlyfTable, superClass);

    function GlyfTable() {
      return GlyfTable.__super__.constructor.apply(this, arguments);
    }

    GlyfTable.prototype.tag = 'glyf';

    GlyfTable.prototype.parse = function(data) {
      return this.cache = {};
    };

    GlyfTable.prototype.glyphFor = function(id) {
      var data, index, length, loca, numberOfContours, raw, xMax, xMin, yMax, yMin;
      if (id in this.cache) {
        return this.cache[id];
      }
      loca = this.file.loca;
      data = this.file.contents;
      index = loca.indexOf(id);
      length = loca.lengthOf(id);
      if (length === 0) {
        return this.cache[id] = null;
      }
      data.pos = this.offset + index;
      raw = new Data(data.read(length));
      numberOfContours = raw.readShort();
      xMin = raw.readShort();
      yMin = raw.readShort();
      xMax = raw.readShort();
      yMax = raw.readShort();
      if (numberOfContours === -1) {
        this.cache[id] = new CompoundGlyph(raw, xMin, yMin, xMax, yMax);
      } else {
        this.cache[id] = new SimpleGlyph(raw, numberOfContours, xMin, yMin, xMax, yMax);
      }
      return this.cache[id];
    };

    GlyfTable.prototype.encode = function(glyphs, mapping, old2new) {
      var glyph, id, j, len, offsets, table;
      table = [];
      offsets = [];
      for (j = 0, len = mapping.length; j < len; j++) {
        id = mapping[j];
        glyph = glyphs[id];
        offsets.push(table.length);
        if (glyph) {
          table = table.concat(glyph.encode(old2new));
        }
      }
      offsets.push(table.length);
      return {
        table: table,
        offsets: offsets
      };
    };

    return GlyfTable;

  })(Table);

  SimpleGlyph = (function() {
    function SimpleGlyph(raw1, numberOfContours1, xMin1, yMin1, xMax1, yMax1) {
      this.raw = raw1;
      this.numberOfContours = numberOfContours1;
      this.xMin = xMin1;
      this.yMin = yMin1;
      this.xMax = xMax1;
      this.yMax = yMax1;
      this.compound = false;
    }

    SimpleGlyph.prototype.encode = function() {
      return this.raw.data;
    };

    return SimpleGlyph;

  })();

  CompoundGlyph = (function() {
    var ARG_1_AND_2_ARE_WORDS, MORE_COMPONENTS, WE_HAVE_AN_X_AND_Y_SCALE, WE_HAVE_A_SCALE, WE_HAVE_A_TWO_BY_TWO, WE_HAVE_INSTRUCTIONS;

    ARG_1_AND_2_ARE_WORDS = 0x0001;

    WE_HAVE_A_SCALE = 0x0008;

    MORE_COMPONENTS = 0x0020;

    WE_HAVE_AN_X_AND_Y_SCALE = 0x0040;

    WE_HAVE_A_TWO_BY_TWO = 0x0080;

    WE_HAVE_INSTRUCTIONS = 0x0100;

    function CompoundGlyph(raw1, xMin1, yMin1, xMax1, yMax1) {
      var data, flags;
      this.raw = raw1;
      this.xMin = xMin1;
      this.yMin = yMin1;
      this.xMax = xMax1;
      this.yMax = yMax1;
      this.compound = true;
      this.glyphIDs = [];
      this.glyphOffsets = [];
      data = this.raw;
      while (true) {
        flags = data.readShort();
        this.glyphOffsets.push(data.pos);
        this.glyphIDs.push(data.readShort());
        if (!(flags & MORE_COMPONENTS)) {
          break;
        }
        if (flags & ARG_1_AND_2_ARE_WORDS) {
          data.pos += 4;
        } else {
          data.pos += 2;
        }
        if (flags & WE_HAVE_A_TWO_BY_TWO) {
          data.pos += 8;
        } else if (flags & WE_HAVE_AN_X_AND_Y_SCALE) {
          data.pos += 4;
        } else if (flags & WE_HAVE_A_SCALE) {
          data.pos += 2;
        }
      }
    }

    CompoundGlyph.prototype.encode = function(mapping) {
      var i, id, j, len, ref, result;
      result = new Data(slice.call(this.raw.data));
      ref = this.glyphIDs;
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        id = ref[i];
        result.pos = this.glyphOffsets[i];
        result.writeShort(mapping[id]);
      }
      return result.data;
    };

    return CompoundGlyph;

  })();

  module.exports = GlyfTable;

}).call(this);
