// Generated by CoffeeScript 1.10.0
(function() {
  var CmapTable, DFont, Data, Directory, GlyfTable, HeadTable, HheaTable, HmtxTable, LocaTable, MaxpTable, NameTable, OS2Table, PostTable, TTFFont, fs;

  fs = require('fs');

  Data = require('../data');

  DFont = require('./dfont');

  Directory = require('./directory');

  NameTable = require('./tables/name');

  HeadTable = require('./tables/head');

  CmapTable = require('./tables/cmap');

  HmtxTable = require('./tables/hmtx');

  HheaTable = require('./tables/hhea');

  MaxpTable = require('./tables/maxp');

  PostTable = require('./tables/post');

  OS2Table = require('./tables/os2');

  LocaTable = require('./tables/loca');

  GlyfTable = require('./tables/glyf');

  TTFFont = (function() {
    TTFFont.open = function(filename, name) {
      var contents;
      contents = fs.readFileSync(filename);
      return new TTFFont(contents, name);
    };

    TTFFont.fromDFont = function(filename, family) {
      var dfont;
      dfont = DFont.open(filename);
      return new TTFFont(dfont.getNamedFont(family));
    };

    TTFFont.fromBuffer = function(buffer, family) {
      var dfont, e, error, ttf;
      try {
        ttf = new TTFFont(buffer, family);
        if (!(ttf.head.exists && ttf.name.exists && ttf.cmap.exists)) {
          dfont = new DFont(buffer);
          ttf = new TTFFont(dfont.getNamedFont(family));
          if (!(ttf.head.exists && ttf.name.exists && ttf.cmap.exists)) {
            throw new Error('Invalid TTF file in DFont');
          }
        }
        return ttf;
      } catch (error) {
        e = error;
        throw new Error('Unknown font format in buffer: ' + e.message);
      }
    };

    function TTFFont(rawData, name) {
      var data, i, j, k, len, numFonts, offset, offsets, ref, version;
      this.rawData = rawData;
      data = this.contents = new Data(this.rawData);
      if (data.readString(4) === 'ttcf') {
        if (!name) {
          throw new Error("Must specify a font name for TTC files.");
        }
        version = data.readInt();
        numFonts = data.readInt();
        offsets = [];
        for (i = j = 0, ref = numFonts; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
          offsets[i] = data.readInt();
        }
        for (i = k = 0, len = offsets.length; k < len; i = ++k) {
          offset = offsets[i];
          data.pos = offset;
          this.parse();
          if (this.name.postscriptName === name) {
            return;
          }
        }
        throw new Error("Font " + name + " not found in TTC file.");
      } else {
        data.pos = 0;
        this.parse();
      }
    }

    TTFFont.prototype.parse = function() {
      this.directory = new Directory(this.contents);
      this.head = new HeadTable(this);
      this.name = new NameTable(this);
      this.cmap = new CmapTable(this);
      this.hhea = new HheaTable(this);
      this.maxp = new MaxpTable(this);
      this.hmtx = new HmtxTable(this);
      this.post = new PostTable(this);
      this.os2 = new OS2Table(this);
      this.loca = new LocaTable(this);
      this.glyf = new GlyfTable(this);
      this.ascender = (this.os2.exists && this.os2.ascender) || this.hhea.ascender;
      this.decender = (this.os2.exists && this.os2.decender) || this.hhea.decender;
      this.lineGap = (this.os2.exists && this.os2.lineGap) || this.hhea.lineGap;
      return this.bbox = [this.head.xMin, this.head.yMin, this.head.xMax, this.head.yMax];
    };

    TTFFont.prototype.characterToGlyph = function(character) {
      var ref;
      return ((ref = this.cmap.unicode) != null ? ref.codeMap[character] : void 0) || 0;
    };

    TTFFont.prototype.widthOfGlyph = function(glyph) {
      var scale;
      scale = 1000.0 / this.head.unitsPerEm;
      return this.hmtx.forGlyph(glyph).advance * scale;
    };

    return TTFFont;

  })();

  module.exports = TTFFont;

}).call(this);
