/*! pdfmake v0.1.34, @license MIT, @link http://pdfmake.org */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {module.exports = global["pdfMake"] = __webpack_require__(1);
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, global) {/* jslint node: true */
	/* jslint browser: true */
	'use strict';

	var PdfPrinter = __webpack_require__(6);
	var isFunction = __webpack_require__(8).isFunction;
	var FileSaver = __webpack_require__(304);
	var saveAs = FileSaver.saveAs;

	var defaultClientFonts = {
		Roboto: {
			normal: 'Roboto-Regular.ttf',
			bold: 'Roboto-Medium.ttf',
			italics: 'Roboto-Italic.ttf',
			bolditalics: 'Roboto-MediumItalic.ttf'
		}
	};

	function Document(docDefinition, tableLayouts, fonts, vfs) {
		this.docDefinition = docDefinition;
		this.tableLayouts = tableLayouts || null;
		this.fonts = fonts || defaultClientFonts;
		this.vfs = vfs;
	}

	function canCreatePdf() {
		// Ensure the browser provides the level of support needed
		if (!Object.keys) {
			return false;
		}
		return true;
	}

	Document.prototype._createDoc = function (options, callback) {
		options = options || {};
		if (this.tableLayouts) {
			options.tableLayouts = this.tableLayouts;
		}

		var printer = new PdfPrinter(this.fonts);
		printer.fs.bindFS(this.vfs);

		var doc = printer.createPdfKitDocument(this.docDefinition, options);
		var chunks = [];
		var result;

		doc.on('readable', function () {
			var chunk;
			while ((chunk = doc.read(9007199254740991)) !== null) {
				chunks.push(chunk);
			}
		});
		doc.on('end', function () {
			result = Buffer.concat(chunks);
			callback(result, doc._pdfMakePages);
		});
		doc.end();
	};

	Document.prototype._getPages = function (options, cb) {
		if (!cb) {
			throw '_getPages is an async method and needs a callback argument';
		}
		this._createDoc(options, function (ignoreBuffer, pages) {
			cb(pages);
		});
	};

	Document.prototype._bufferToBlob = function (buffer) {
		var blob;
		try {
			blob = new Blob([buffer], {type: 'application/pdf'});
		} catch (e) {
			// Old browser which can't handle it without making it an byte array (ie10)
			if (e.name === 'InvalidStateError') {
				var byteArray = new Uint8Array(buffer);
				blob = new Blob([byteArray.buffer], {type: 'application/pdf'});
			}
		}

		if (!blob) {
			throw 'Could not generate blob';
		}

		return blob;
	};

	Document.prototype._openWindow = function () {
		// we have to open the window immediately and store the reference
		// otherwise popup blockers will stop us
		var win = global.open('', '_blank');
		if (win === null) {
			throw 'Open PDF in new window blocked by browser';
		}

		return win;
	};

	Document.prototype._openPdf = function (options, win) {
		if (!win) {
			win = this._openWindow();
		}
		try {
			this.getBlob(function (result) {
				var urlCreator = global.URL || global.webkitURL;
				var pdfUrl = urlCreator.createObjectURL(result);
				win.location.href = pdfUrl;
			}, options);
		} catch (e) {
			win.close();
			throw e;
		}
	};

	Document.prototype.open = function (options, win) {
		options = options || {};
		options.autoPrint = false;
		win = win || null;

		this._openPdf(options, win);
	};


	Document.prototype.print = function (options, win) {
		options = options || {};
		options.autoPrint = true;
		win = win || null;

		this._openPdf(options, win);
	};

	Document.prototype.download = function (defaultFileName, cb, options) {
		if (isFunction(defaultFileName)) {
			cb = defaultFileName;
			defaultFileName = null;
		}

		defaultFileName = defaultFileName || 'file.pdf';
		this.getBlob(function (result) {
			saveAs(result, defaultFileName);

			if (isFunction(cb)) {
				cb();
			}
		}, options);
	};

	Document.prototype.getBase64 = function (cb, options) {
		if (!cb) {
			throw 'getBase64 is an async method and needs a callback argument';
		}
		this.getBuffer(function (buffer) {
			cb(buffer.toString('base64'));
		}, options);
	};

	Document.prototype.getDataUrl = function (cb, options) {
		if (!cb) {
			throw 'getDataUrl is an async method and needs a callback argument';
		}
		this.getBuffer(function (buffer) {
			cb('data:application/pdf;base64,' + buffer.toString('base64'));
		}, options);
	};

	Document.prototype.getBlob = function (cb, options) {
		if (!cb) {
			throw 'getBlob is an async method and needs a callback argument';
		}
		var that = this;
		this.getBuffer(function (result) {
			var blob = that._bufferToBlob(result);
			cb(blob);
		}, options);
	};

	Document.prototype.getBuffer = function (cb, options) {
		if (!cb) {
			throw 'getBuffer is an async method and needs a callback argument';
		}
		this._createDoc(options, function (buffer) {
			cb(buffer);
		});
	};

	module.exports = {
		createPdf: function (docDefinition) {
			if (!canCreatePdf()) {
				throw 'Your browser does not provide the level of support needed';
			}
			return new Document(docDefinition, global.pdfMake.tableLayouts, global.pdfMake.fonts, global.pdfMake.vfs);
		}
	};

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer, (function() { return this; }())))

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */

	'use strict'

	var base64 = __webpack_require__(3)
	var ieee754 = __webpack_require__(4)
	var isArray = __webpack_require__(5)

	exports.Buffer = Buffer
	exports.SlowBuffer = SlowBuffer
	exports.INSPECT_MAX_BYTES = 50

	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.

	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
	  ? global.TYPED_ARRAY_SUPPORT
	  : typedArraySupport()

	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	exports.kMaxLength = kMaxLength()

	function typedArraySupport () {
	  try {
	    var arr = new Uint8Array(1)
	    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
	    return arr.foo() === 42 && // typed array instances can be augmented
	        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
	        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
	  } catch (e) {
	    return false
	  }
	}

	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}

	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length)
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer(length)
	    }
	    that.length = length
	  }

	  return that
	}

	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */

	function Buffer (arg, encodingOrOffset, length) {
	  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
	    return new Buffer(arg, encodingOrOffset, length)
	  }

	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}

	Buffer.poolSize = 8192 // not used by this implementation

	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer._augment = function (arr) {
	  arr.__proto__ = Buffer.prototype
	  return arr
	}

	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }

	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }

	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }

	  return fromObject(that, value)
	}

	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	}

	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype
	  Buffer.__proto__ = Uint8Array
	  if (typeof Symbol !== 'undefined' && Symbol.species &&
	      Buffer[Symbol.species] === Buffer) {
	    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
	    Object.defineProperty(Buffer, Symbol.species, {
	      value: null,
	      configurable: true
	    })
	  }
	}

	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}

	function alloc (that, size, fill, encoding) {
	  assertSize(size)
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}

	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	}

	function allocUnsafe (that, size) {
	  assertSize(size)
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0
	    }
	  }
	  return that
	}

	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	}
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	}

	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8'
	  }

	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }

	  var length = byteLength(string, encoding) | 0
	  that = createBuffer(that, length)

	  var actual = that.write(string, encoding)

	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual)
	  }

	  return that
	}

	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0
	  that = createBuffer(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}

	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength // this throws if `array` is not a valid ArrayBuffer

	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }

	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }

	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array)
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset)
	  } else {
	    array = new Uint8Array(array, byteOffset, length)
	  }

	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array)
	  }
	  return that
	}

	function fromObject (that, obj) {
	  if (Buffer.isBuffer(obj)) {
	    var len = checked(obj.length) | 0
	    that = createBuffer(that, len)

	    if (that.length === 0) {
	      return that
	    }

	    obj.copy(that, 0, 0, len)
	    return that
	  }

	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }

	    if (obj.type === 'Buffer' && isArray(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }

	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}

	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}

	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0
	  }
	  return Buffer.alloc(+length)
	}

	Buffer.isBuffer = function isBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}

	Buffer.compare = function compare (a, b) {
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }

	  if (a === b) return 0

	  var x = a.length
	  var y = b.length

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i]
	      y = b[i]
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}

	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	}

	Buffer.concat = function concat (list, length) {
	  if (!isArray(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }

	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }

	  var i
	  if (length === undefined) {
	    length = 0
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length
	    }
	  }

	  var buffer = Buffer.allocUnsafe(length)
	  var pos = 0
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i]
	    if (!Buffer.isBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos)
	    pos += buf.length
	  }
	  return buffer
	}

	function byteLength (string, encoding) {
	  if (Buffer.isBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string
	  }

	  var len = string.length
	  if (len === 0) return 0

	  // Use a for loop to avoid recursion
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	Buffer.byteLength = byteLength

	function slowToString (encoding, start, end) {
	  var loweredCase = false

	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.

	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }

	  if (end === undefined || end > this.length) {
	    end = this.length
	  }

	  if (end <= 0) {
	    return ''
	  }

	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0
	  start >>>= 0

	  if (end <= start) {
	    return ''
	  }

	  if (!encoding) encoding = 'utf8'

	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)

	      case 'ascii':
	        return asciiSlice(this, start, end)

	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)

	      case 'base64':
	        return base64Slice(this, start, end)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase()
	        loweredCase = true
	    }
	  }
	}

	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer.prototype._isBuffer = true

	function swap (b, n, m) {
	  var i = b[n]
	  b[n] = b[m]
	  b[m] = i
	}

	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1)
	  }
	  return this
	}

	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3)
	    swap(this, i + 1, i + 2)
	  }
	  return this
	}

	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7)
	    swap(this, i + 1, i + 6)
	    swap(this, i + 2, i + 5)
	    swap(this, i + 3, i + 4)
	  }
	  return this
	}

	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	}

	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	}

	Buffer.prototype.inspect = function inspect () {
	  var str = ''
	  var max = exports.INSPECT_MAX_BYTES
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
	    if (this.length > max) str += ' ... '
	  }
	  return '<Buffer ' + str + '>'
	}

	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!Buffer.isBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }

	  if (start === undefined) {
	    start = 0
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0
	  }
	  if (thisStart === undefined) {
	    thisStart = 0
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length
	  }

	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }

	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }

	  start >>>= 0
	  end >>>= 0
	  thisStart >>>= 0
	  thisEnd >>>= 0

	  if (this === target) return 0

	  var x = thisEnd - thisStart
	  var y = end - start
	  var len = Math.min(x, y)

	  var thisCopy = this.slice(thisStart, thisEnd)
	  var targetCopy = target.slice(start, end)

	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i]
	      y = targetCopy[i]
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}

	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1

	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset
	    byteOffset = 0
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000
	  }
	  byteOffset = +byteOffset  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1)
	  }

	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0
	    else return -1
	  }

	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding)
	  }

	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (Buffer.isBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF // Search for a byte value [0-255]
	    if (Buffer.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }

	  throw new TypeError('val must be string, number or Buffer')
	}

	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1
	  var arrLength = arr.length
	  var valLength = val.length

	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase()
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2
	      arrLength /= 2
	      valLength /= 2
	      byteOffset /= 2
	    }
	  }

	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }

	  var i
	  if (dir) {
	    var foundIndex = -1
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex
	        foundIndex = -1
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false
	          break
	        }
	      }
	      if (found) return i
	    }
	  }

	  return -1
	}

	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	}

	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	}

	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	}

	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0
	  var remaining = buf.length - offset
	  if (!length) {
	    length = remaining
	  } else {
	    length = Number(length)
	    if (length > remaining) {
	      length = remaining
	    }
	  }

	  // must be an even number of digits
	  var strLen = string.length
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

	  if (length > strLen / 2) {
	    length = strLen / 2
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16)
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed
	  }
	  return i
	}

	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}

	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}

	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}

	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}

	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}

	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8'
	    length = this.length
	    offset = 0
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset
	    length = this.length
	    offset = 0
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0
	    if (isFinite(length)) {
	      length = length | 0
	      if (encoding === undefined) encoding = 'utf8'
	    } else {
	      encoding = length
	      length = undefined
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }

	  var remaining = this.length - offset
	  if (length === undefined || length > remaining) length = remaining

	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }

	  if (!encoding) encoding = 'utf8'

	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)

	      case 'ascii':
	        return asciiWrite(this, string, offset, length)

	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)

	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}

	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	}

	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}

	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end)
	  var res = []

	  var i = start
	  while (i < end) {
	    var firstByte = buf[i]
	    var codePoint = null
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1

	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint

	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1]
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          fourthByte = buf[i + 3]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint
	            }
	          }
	      }
	    }

	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD
	      bytesPerSequence = 1
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
	      codePoint = 0xDC00 | codePoint & 0x3FF
	    }

	    res.push(codePoint)
	    i += bytesPerSequence
	  }

	  return decodeCodePointsArray(res)
	}

	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000

	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }

	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = ''
	  var i = 0
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    )
	  }
	  return res
	}

	function asciiSlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F)
	  }
	  return ret
	}

	function latin1Slice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i])
	  }
	  return ret
	}

	function hexSlice (buf, start, end) {
	  var len = buf.length

	  if (!start || start < 0) start = 0
	  if (!end || end < 0 || end > len) end = len

	  var out = ''
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i])
	  }
	  return out
	}

	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end)
	  var res = ''
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
	  }
	  return res
	}

	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length
	  start = ~~start
	  end = end === undefined ? len : ~~end

	  if (start < 0) {
	    start += len
	    if (start < 0) start = 0
	  } else if (start > len) {
	    start = len
	  }

	  if (end < 0) {
	    end += len
	    if (end < 0) end = 0
	  } else if (end > len) {
	    end = len
	  }

	  if (end < start) end = start

	  var newBuf
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end)
	    newBuf.__proto__ = Buffer.prototype
	  } else {
	    var sliceLen = end - start
	    newBuf = new Buffer(sliceLen, undefined)
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start]
	    }
	  }

	  return newBuf
	}

	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}

	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }

	  return val
	}

	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length)
	  }

	  var val = this[offset + --byteLength]
	  var mul = 1
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul
	  }

	  return val
	}

	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  return this[offset]
	}

	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return this[offset] | (this[offset + 1] << 8)
	}

	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return (this[offset] << 8) | this[offset + 1]
	}

	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	}

	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	}

	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	  mul *= 0x80

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

	  return val
	}

	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var i = byteLength
	  var mul = 1
	  var val = this[offset + --i]
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul
	  }
	  mul *= 0x80

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

	  return val
	}

	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	}

	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset] | (this[offset + 1] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}

	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset + 1] | (this[offset] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}

	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	}

	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	}

	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, true, 23, 4)
	}

	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, false, 23, 4)
	}

	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, true, 52, 8)
	}

	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, false, 52, 8)
	}

	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}

	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }

	  var mul = 1
	  var i = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }

	  var i = byteLength - 1
	  var mul = 1
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  this[offset] = (value & 0xff)
	  return offset + 1
	}

	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8
	  }
	}

	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}

	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
	  }
	}

	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 1] = (value >>> 8)
	    this[offset] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)

	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }

	  var i = 0
	  var mul = 1
	  var sub = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)

	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }

	  var i = byteLength - 1
	  var mul = 1
	  var sub = 0
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  if (value < 0) value = 0xff + value + 1
	  this[offset] = (value & 0xff)
	  return offset + 1
	}

	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 3] = (value >>> 24)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (value < 0) value = 0xffffffff + value + 1
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}

	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}

	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4)
	  return offset + 4
	}

	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	}

	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	}

	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8)
	  return offset + 8
	}

	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	}

	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	}

	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0
	  if (!end && end !== 0) end = this.length
	  if (targetStart >= target.length) targetStart = target.length
	  if (!targetStart) targetStart = 0
	  if (end > 0 && end < start) end = start

	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0

	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')

	  // Are we oob?
	  if (end > this.length) end = this.length
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start
	  }

	  var len = end - start
	  var i

	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    )
	  }

	  return len
	}

	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start
	      start = 0
	      end = this.length
	    } else if (typeof end === 'string') {
	      encoding = end
	      end = this.length
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0)
	      if (code < 256) {
	        val = code
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255
	  }

	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return this
	  }

	  start = start >>> 0
	  end = end === undefined ? this.length : end >>> 0

	  if (!val) val = 0

	  var i
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val
	    }
	  } else {
	    var bytes = Buffer.isBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer(val, encoding).toString())
	    var len = bytes.length
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len]
	    }
	  }

	  return this
	}

	// HELPER FUNCTIONS
	// ================

	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '='
	  }
	  return str
	}

	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}

	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}

	function utf8ToBytes (string, units) {
	  units = units || Infinity
	  var codePoint
	  var length = string.length
	  var leadSurrogate = null
	  var bytes = []

	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i)

	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        }

	        // valid lead
	        leadSurrogate = codePoint

	        continue
	      }

	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	        leadSurrogate = codePoint
	        continue
	      }

	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	    }

	    leadSurrogate = null

	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint)
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }

	  return bytes
	}

	function asciiToBytes (str) {
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF)
	  }
	  return byteArray
	}

	function utf16leToBytes (str, units) {
	  var c, hi, lo
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break

	    c = str.charCodeAt(i)
	    hi = c >> 8
	    lo = c % 256
	    byteArray.push(lo)
	    byteArray.push(hi)
	  }

	  return byteArray
	}

	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}

	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i]
	  }
	  return i
	}

	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 3 */
/***/ (function(module, exports) {

	'use strict'

	exports.byteLength = byteLength
	exports.toByteArray = toByteArray
	exports.fromByteArray = fromByteArray

	var lookup = []
	var revLookup = []
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

	var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
	for (var i = 0, len = code.length; i < len; ++i) {
	  lookup[i] = code[i]
	  revLookup[code.charCodeAt(i)] = i
	}

	revLookup['-'.charCodeAt(0)] = 62
	revLookup['_'.charCodeAt(0)] = 63

	function placeHoldersCount (b64) {
	  var len = b64.length
	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  return b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0
	}

	function byteLength (b64) {
	  // base64 is 4/3 + up to two characters of the original data
	  return (b64.length * 3 / 4) - placeHoldersCount(b64)
	}

	function toByteArray (b64) {
	  var i, l, tmp, placeHolders, arr
	  var len = b64.length
	  placeHolders = placeHoldersCount(b64)

	  arr = new Arr((len * 3 / 4) - placeHolders)

	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len

	  var L = 0

	  for (i = 0; i < l; i += 4) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]
	    arr[L++] = (tmp >> 16) & 0xFF
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }

	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)
	    arr[L++] = tmp & 0xFF
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp
	  var output = []
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
	    output.push(tripletToBase64(tmp))
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  var tmp
	  var len = uint8.length
	  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
	  var output = ''
	  var parts = []
	  var maxChunkLength = 16383 // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1]
	    output += lookup[tmp >> 2]
	    output += lookup[(tmp << 4) & 0x3F]
	    output += '=='
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])
	    output += lookup[tmp >> 10]
	    output += lookup[(tmp >> 4) & 0x3F]
	    output += lookup[(tmp << 2) & 0x3F]
	    output += '='
	  }

	  parts.push(output)

	  return parts.join('')
	}


/***/ }),
/* 4 */
/***/ (function(module, exports) {

	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var nBits = -7
	  var i = isLE ? (nBytes - 1) : 0
	  var d = isLE ? -1 : 1
	  var s = buffer[offset + i]

	  i += d

	  e = s & ((1 << (-nBits)) - 1)
	  s >>= (-nBits)
	  nBits += eLen
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1)
	  e >>= (-nBits)
	  nBits += mLen
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen)
	    e = e - eBias
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}

	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
	  var i = isLE ? 0 : (nBytes - 1)
	  var d = isLE ? 1 : -1
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

	  value = Math.abs(value)

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0
	    e = eMax
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2)
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--
	      c *= 2
	    }
	    if (e + eBias >= 1) {
	      value += rt / c
	    } else {
	      value += rt * Math.pow(2, 1 - eBias)
	    }
	    if (value * c >= 2) {
	      e++
	      c /= 2
	    }

	    if (e + eBias >= eMax) {
	      m = 0
	      e = eMax
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen)
	      e = e + eBias
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
	      e = 0
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m
	  eLen += mLen
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128
	}


/***/ }),
/* 5 */
/***/ (function(module, exports) {

	var toString = {}.toString;

	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var FontProvider = __webpack_require__(7);
	var LayoutBuilder = __webpack_require__(9);
	var PdfKit = __webpack_require__(28);
	var sizes = __webpack_require__(301);
	var ImageMeasure = __webpack_require__(302);
	var textDecorator = __webpack_require__(303);
	var TextTools = __webpack_require__(13);
	var isFunction = __webpack_require__(8).isFunction;
	var isString = __webpack_require__(8).isString;
	var isNumber = __webpack_require__(8).isNumber;
	var isBoolean = __webpack_require__(8).isBoolean;
	var isArray = __webpack_require__(8).isArray;

	////////////////////////////////////////
	// PdfPrinter

	/**
	 * @class Creates an instance of a PdfPrinter which turns document definition into a pdf
	 *
	 * @param {Object} fontDescriptors font definition dictionary
	 *
	 * @example
	 * var fontDescriptors = {
	 *	Roboto: {
	 *		normal: 'fonts/Roboto-Regular.ttf',
	 *		bold: 'fonts/Roboto-Medium.ttf',
	 *		italics: 'fonts/Roboto-Italic.ttf',
	 *		bolditalics: 'fonts/Roboto-MediumItalic.ttf'
	 *	}
	 * };
	 *
	 * var printer = new PdfPrinter(fontDescriptors);
	 */
	function PdfPrinter(fontDescriptors) {
		this.fontDescriptors = fontDescriptors;
	}

	/**
	 * Executes layout engine for the specified document and renders it into a pdfkit document
	 * ready to be saved.
	 *
	 * @param {Object} docDefinition document definition
	 * @param {Object} docDefinition.content an array describing the pdf structure (for more information take a look at the examples in the /examples folder)
	 * @param {Object} [docDefinition.defaultStyle] default (implicit) style definition
	 * @param {Object} [docDefinition.styles] dictionary defining all styles which can be used in the document
	 * @param {Object} [docDefinition.pageSize] page size (pdfkit units, A4 dimensions by default)
	 * @param {Number} docDefinition.pageSize.width width
	 * @param {Number} docDefinition.pageSize.height height
	 * @param {Object} [docDefinition.pageMargins] page margins (pdfkit units)
	 * @param {Number} docDefinition.maxPagesNumber maximum number of pages to render
	 *
	 * @example
	 *
	 * var docDefinition = {
	 * 	info: {
	 *		title: 'awesome Document',
	 *		author: 'john doe',
	 *		subject: 'subject of document',
	 *		keywords: 'keywords for document',
	 * 	},
	 *	content: [
	 *		'First paragraph',
	 *		'Second paragraph, this time a little bit longer',
	 *		{ text: 'Third paragraph, slightly bigger font size', fontSize: 20 },
	 *		{ text: 'Another paragraph using a named style', style: 'header' },
	 *		{ text: ['playing with ', 'inlines' ] },
	 *		{ text: ['and ', { text: 'restyling ', bold: true }, 'them'] },
	 *	],
	 *	styles: {
	 *		header: { fontSize: 30, bold: true }
	 *	}
	 * }
	 *
	 * var pdfKitDoc = printer.createPdfKitDocument(docDefinition);
	 *
	 * pdfKitDoc.pipe(fs.createWriteStream('sample.pdf'));
	 * pdfKitDoc.end();
	 *
	 * @return {Object} a pdfKit document object which can be saved or encode to data-url
	 */
	PdfPrinter.prototype.createPdfKitDocument = function (docDefinition, options) {
		options = options || {};

		var pageSize = fixPageSize(docDefinition.pageSize, docDefinition.pageOrientation);
		var compressPdf = isBoolean(docDefinition.compress) ? docDefinition.compress : true;

		this.pdfKitDoc = new PdfKit({size: [pageSize.width, pageSize.height], autoFirstPage: false, compress: compressPdf});
		setMetadata(docDefinition, this.pdfKitDoc);

		this.fontProvider = new FontProvider(this.fontDescriptors, this.pdfKitDoc);

		docDefinition.images = docDefinition.images || {};

		var builder = new LayoutBuilder(pageSize, fixPageMargins(docDefinition.pageMargins || 40), new ImageMeasure(this.pdfKitDoc, docDefinition.images));

		registerDefaultTableLayouts(builder);
		if (options.tableLayouts) {
			builder.registerTableLayouts(options.tableLayouts);
		}

		var pages = builder.layoutDocument(docDefinition.content, this.fontProvider, docDefinition.styles || {}, docDefinition.defaultStyle || {fontSize: 12, font: 'Roboto'}, docDefinition.background, docDefinition.header, docDefinition.footer, docDefinition.images, docDefinition.watermark, docDefinition.pageBreakBefore);
		var maxNumberPages = docDefinition.maxPagesNumber || -1;
		if (isNumber(maxNumberPages) && maxNumberPages > -1) {
			pages = pages.slice(0, maxNumberPages);
		}

		// if pageSize.height is set to Infinity, calculate the actual height of the page that
		// was laid out using the height of each of the items in the page.
		if (pageSize.height === Infinity) {
			var pageHeight = calculatePageHeight(pages, docDefinition.pageMargins);
			this.pdfKitDoc.options.size = [pageSize.width, pageHeight];
		}

		renderPages(pages, this.fontProvider, this.pdfKitDoc, options.progressCallback);

		if (options.autoPrint) {
			var printActionRef = this.pdfKitDoc.ref({
				Type: 'Action',
				S: 'Named',
				N: 'Print'
			});
			this.pdfKitDoc._root.data.OpenAction = printActionRef;
			printActionRef.end();
		}
		return this.pdfKitDoc;
	};

	function setMetadata(docDefinition, pdfKitDoc) {
		// PDF standard has these properties reserved: Title, Author, Subject, Keywords,
		// Creator, Producer, CreationDate, ModDate, Trapped.
		// To keep the pdfmake api consistent, the info field are defined lowercase.
		// Custom properties don't contain a space.
		function standardizePropertyKey(key) {
			var standardProperties = ['Title', 'Author', 'Subject', 'Keywords',
				'Creator', 'Producer', 'CreationDate', 'ModDate', 'Trapped'];
			var standardizedKey = key.charAt(0).toUpperCase() + key.slice(1);
			if (standardProperties.indexOf(standardizedKey) !== -1) {
				return standardizedKey;
			}

			return key.replace(/\s+/g, '');
		}

		pdfKitDoc.info.Producer = 'pdfmake';
		pdfKitDoc.info.Creator = 'pdfmake';

		if (docDefinition.info) {
			for (var key in docDefinition.info) {
				var value = docDefinition.info[key];
				if (value) {
					key = standardizePropertyKey(key);
					pdfKitDoc.info[key] = value;
				}
			}
		}
	}

	function calculatePageHeight(pages, margins) {
		function getItemHeight(item) {
			if (isFunction(item.item.getHeight)) {
				return item.item.getHeight();
			} else if (item.item._height) {
				return item.item._height;
			} else {
				// TODO: add support for next item types
				return 0;
			}
		}

		var fixedMargins = fixPageMargins(margins || 40);
		var height = fixedMargins.top + fixedMargins.bottom;
		pages.forEach(function (page) {
			page.items.forEach(function (item) {
				height += getItemHeight(item);
			});
		});
		return height;
	}

	function fixPageSize(pageSize, pageOrientation) {
		function isNeedSwapPageSizes(pageOrientation) {
			if (isString(pageOrientation)) {
				pageOrientation = pageOrientation.toLowerCase();
				return ((pageOrientation === 'portrait') && (size.width > size.height)) ||
					((pageOrientation === 'landscape') && (size.width < size.height));
			}
			return false;
		}

		// if pageSize.height is set to auto, set the height to infinity so there are no page breaks.
		if (pageSize && pageSize.height === 'auto') {
			pageSize.height = Infinity;
		}

		var size = pageSize2widthAndHeight(pageSize || 'A4');
		if (isNeedSwapPageSizes(pageOrientation)) { // swap page sizes
			size = {width: size.height, height: size.width};
		}
		size.orientation = size.width > size.height ? 'landscape' : 'portrait';
		return size;
	}

	function fixPageMargins(margin) {
		if (!margin) {
			return null;
		}

		if (isNumber(margin)) {
			margin = {left: margin, right: margin, top: margin, bottom: margin};
		} else if (isArray(margin)) {
			if (margin.length === 2) {
				margin = {left: margin[0], top: margin[1], right: margin[0], bottom: margin[1]};
			} else if (margin.length === 4) {
				margin = {left: margin[0], top: margin[1], right: margin[2], bottom: margin[3]};
			} else {
				throw 'Invalid pageMargins definition';
			}
		}

		return margin;
	}

	function registerDefaultTableLayouts(layoutBuilder) {
		/*jshint unused: false */
		layoutBuilder.registerTableLayouts({
			noBorders: {
				hLineWidth: function (i) {
					return 0;
				},
				vLineWidth: function (i) {
					return 0;
				},
				paddingLeft: function (i) {
					return i && 4 || 0;
				},
				paddingRight: function (i, node) {
					return (i < node.table.widths.length - 1) ? 4 : 0;
				}
			},
			headerLineOnly: {
				hLineWidth: function (i, node) {
					if (i === 0 || i === node.table.body.length) {
						return 0;
					}
					return (i === node.table.headerRows) ? 2 : 0;
				},
				vLineWidth: function (i) {
					return 0;
				},
				paddingLeft: function (i) {
					return i === 0 ? 0 : 8;
				},
				paddingRight: function (i, node) {
					return (i === node.table.widths.length - 1) ? 0 : 8;
				}
			},
			lightHorizontalLines: {
				hLineWidth: function (i, node) {
					if (i === 0 || i === node.table.body.length) {
						return 0;
					}
					return (i === node.table.headerRows) ? 2 : 1;
				},
				vLineWidth: function (i) {
					return 0;
				},
				hLineColor: function (i) {
					return i === 1 ? 'black' : '#aaa';
				},
				paddingLeft: function (i) {
					return i === 0 ? 0 : 8;
				},
				paddingRight: function (i, node) {
					return (i === node.table.widths.length - 1) ? 0 : 8;
				}
			}
		});
	}

	function pageSize2widthAndHeight(pageSize) {
		if (isString(pageSize)) {
			var size = sizes[pageSize.toUpperCase()];
			if (!size) {
				throw 'Page size ' + pageSize + ' not recognized';
			}
			return {width: size[0], height: size[1]};
		}

		return pageSize;
	}

	function updatePageOrientationInOptions(currentPage, pdfKitDoc) {
		var previousPageOrientation = pdfKitDoc.options.size[0] > pdfKitDoc.options.size[1] ? 'landscape' : 'portrait';

		if (currentPage.pageSize.orientation !== previousPageOrientation) {
			var width = pdfKitDoc.options.size[0];
			var height = pdfKitDoc.options.size[1];
			pdfKitDoc.options.size = [height, width];
		}
	}

	function renderPages(pages, fontProvider, pdfKitDoc, progressCallback) {
		pdfKitDoc._pdfMakePages = pages;
		pdfKitDoc.addPage();

		var totalItems = 0;
		if (progressCallback) {
			pages.forEach(function (page) {
				totalItems += page.items.length;
			});
		}

		var renderedItems = 0;
		progressCallback = progressCallback || function () {};

		for (var i = 0; i < pages.length; i++) {
			if (i > 0) {
				updatePageOrientationInOptions(pages[i], pdfKitDoc);
				pdfKitDoc.addPage(pdfKitDoc.options);
			}

			var page = pages[i];
			for (var ii = 0, il = page.items.length; ii < il; ii++) {
				var item = page.items[ii];
				switch (item.type) {
					case 'vector':
						renderVector(item.item, pdfKitDoc);
						break;
					case 'line':
						renderLine(item.item, item.item.x, item.item.y, pdfKitDoc);
						break;
					case 'image':
						renderImage(item.item, item.item.x, item.item.y, pdfKitDoc);
						break;
					case 'beginClip':
						beginClip(item.item, pdfKitDoc);
						break;
					case 'endClip':
						endClip(pdfKitDoc);
						break;
				}
				renderedItems++;
				progressCallback(renderedItems / totalItems);
			}
			if (page.watermark) {
				renderWatermark(page, pdfKitDoc);
			}
		}
	}

	function renderLine(line, x, y, pdfKitDoc) {
		if (line._tocItemNode) {
			var newWidth;
			var diffWidth;
			var textTools = new TextTools(null);
			var pageNumber = line._tocItemNode.positions[0].pageNumber.toString();

			line.inlines[0].text = pageNumber;
			line.inlines[0].linkToPage = pageNumber;
			newWidth = textTools.widthOfString(line.inlines[0].text, line.inlines[0].font, line.inlines[0].fontSize, line.inlines[0].characterSpacing, line.inlines[0].fontFeatures);
			diffWidth = line.inlines[0].width - newWidth;
			line.inlines[0].width = newWidth;

			switch (line.inlines[0].alignment) {
				case 'right':
					line.inlines[0].x += diffWidth;
					break;
				case 'center':
					line.inlines[0].x += diffWidth / 2;
					break;
			}
		}

		x = x || 0;
		y = y || 0;

		var lineHeight = line.getHeight();
		var ascenderHeight = line.getAscenderHeight();
		var descent = lineHeight - ascenderHeight;

		textDecorator.drawBackground(line, x, y, pdfKitDoc);

		//TODO: line.optimizeInlines();
		for (var i = 0, l = line.inlines.length; i < l; i++) {
			var inline = line.inlines[i];
			var shiftToBaseline = lineHeight - ((inline.font.ascender / 1000) * inline.fontSize) - descent;
			var options = {
				lineBreak: false,
				textWidth: inline.width,
				characterSpacing: inline.characterSpacing,
				wordCount: 1,
				link: inline.link
			};

			if (inline.fontFeatures) {
				options.features = inline.fontFeatures;
			}

			pdfKitDoc.fill(inline.color || 'black');

			pdfKitDoc._font = inline.font;
			pdfKitDoc.fontSize(inline.fontSize);
			pdfKitDoc.text(inline.text, x + inline.x, y + shiftToBaseline, options);

			if (inline.linkToPage) {
				var _ref = pdfKitDoc.ref({Type: 'Action', S: 'GoTo', D: [inline.linkToPage, 0, 0]}).end();
				pdfKitDoc.annotate(x + inline.x, y + shiftToBaseline, inline.width, inline.height, {Subtype: 'Link', Dest: [inline.linkToPage - 1, 'XYZ', null, null, null]});
			}

		}

		textDecorator.drawDecorations(line, x, y, pdfKitDoc);
	}

	function renderWatermark(page, pdfKitDoc) {
		var watermark = page.watermark;

		pdfKitDoc.fill(watermark.color);
		pdfKitDoc.opacity(watermark.opacity);

		pdfKitDoc.save();

		var angle = Math.atan2(pdfKitDoc.page.height, pdfKitDoc.page.width) * -180 / Math.PI;
		pdfKitDoc.rotate(angle, {origin: [pdfKitDoc.page.width / 2, pdfKitDoc.page.height / 2]});

		var x = pdfKitDoc.page.width / 2 - watermark.size.size.width / 2;
		var y = pdfKitDoc.page.height / 2 - watermark.size.size.height / 4;

		pdfKitDoc._font = watermark.font;
		pdfKitDoc.fontSize(watermark.size.fontSize);
		pdfKitDoc.text(watermark.text, x, y, {lineBreak: false});

		pdfKitDoc.restore();
	}

	function renderVector(vector, pdfKitDoc) {
		//TODO: pdf optimization (there's no need to write all properties everytime)
		pdfKitDoc.lineWidth(vector.lineWidth || 1);
		if (vector.dash) {
			pdfKitDoc.dash(vector.dash.length, {space: vector.dash.space || vector.dash.length, phase: vector.dash.phase || 0});
		} else {
			pdfKitDoc.undash();
		}
		pdfKitDoc.lineJoin(vector.lineJoin || 'miter');
		pdfKitDoc.lineCap(vector.lineCap || 'butt');

		//TODO: clipping

		switch (vector.type) {
			case 'ellipse':
				pdfKitDoc.ellipse(vector.x, vector.y, vector.r1, vector.r2);
				break;
			case 'rect':
				if (vector.r) {
					pdfKitDoc.roundedRect(vector.x, vector.y, vector.w, vector.h, vector.r);
				} else {
					pdfKitDoc.rect(vector.x, vector.y, vector.w, vector.h);
				}

				if (vector.linearGradient) {
					var gradient = pdfKitDoc.linearGradient(vector.x, vector.y, vector.x + vector.w, vector.y);
					var step = 1 / (vector.linearGradient.length - 1);

					for (var i = 0; i < vector.linearGradient.length; i++) {
						gradient.stop(i * step, vector.linearGradient[i]);
					}

					vector.color = gradient;
				}
				break;
			case 'line':
				pdfKitDoc.moveTo(vector.x1, vector.y1);
				pdfKitDoc.lineTo(vector.x2, vector.y2);
				break;
			case 'polyline':
				if (vector.points.length === 0) {
					break;
				}

				pdfKitDoc.moveTo(vector.points[0].x, vector.points[0].y);
				for (var i = 1, l = vector.points.length; i < l; i++) {
					pdfKitDoc.lineTo(vector.points[i].x, vector.points[i].y);
				}

				if (vector.points.length > 1) {
					var p1 = vector.points[0];
					var pn = vector.points[vector.points.length - 1];

					if (vector.closePath || p1.x === pn.x && p1.y === pn.y) {
						pdfKitDoc.closePath();
					}
				}
				break;
			case 'path':
				pdfKitDoc.path(vector.d);
				break;
		}

		if (vector.color && vector.lineColor) {
			pdfKitDoc.fillColor(vector.color, vector.fillOpacity || 1);
			pdfKitDoc.strokeColor(vector.lineColor, vector.strokeOpacity || 1);
			pdfKitDoc.fillAndStroke();
		} else if (vector.color) {
			pdfKitDoc.fillColor(vector.color, vector.fillOpacity || 1);
			pdfKitDoc.fill();
		} else {
			pdfKitDoc.strokeColor(vector.lineColor || 'black', vector.strokeOpacity || 1);
			pdfKitDoc.stroke();
		}
	}

	function renderImage(image, x, y, pdfKitDoc) {
		pdfKitDoc.image(image.image, image.x, image.y, {width: image._width, height: image._height});
		if (image.link) {
			pdfKitDoc.link(image.x, image.y, image._width, image._height, image.link);
		}
	}

	function beginClip(rect, pdfKitDoc) {
		pdfKitDoc.save();
		pdfKitDoc.addContent('' + rect.x + ' ' + rect.y + ' ' + rect.width + ' ' + rect.height + ' re');
		pdfKitDoc.clip();
	}

	function endClip(pdfKitDoc) {
		pdfKitDoc.restore();
	}

	module.exports = PdfPrinter;


	/* temporary browser extension */
	PdfPrinter.prototype.fs = __webpack_require__(54);


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var isArray = __webpack_require__(8).isArray;

	function typeName(bold, italics) {
		var type = 'normal';
		if (bold && italics) {
			type = 'bolditalics';
		} else if (bold) {
			type = 'bold';
		} else if (italics) {
			type = 'italics';
		}
		return type;
	}

	function FontProvider(fontDescriptors, pdfKitDoc) {
		this.fonts = {};
		this.pdfKitDoc = pdfKitDoc;
		this.fontCache = {};

		for (var font in fontDescriptors) {
			if (fontDescriptors.hasOwnProperty(font)) {
				var fontDef = fontDescriptors[font];

				this.fonts[font] = {
					normal: fontDef.normal,
					bold: fontDef.bold,
					italics: fontDef.italics,
					bolditalics: fontDef.bolditalics
				};
			}
		}
	}

	FontProvider.prototype.provideFont = function (familyName, bold, italics) {
		var type = typeName(bold, italics);
		if (!this.fonts[familyName] || !this.fonts[familyName][type]) {
			throw new Error('Font \'' + familyName + '\' in style \'' + type + '\' is not defined in the font section of the document definition.');
		}

		this.fontCache[familyName] = this.fontCache[familyName] || {};

		if (!this.fontCache[familyName][type]) {
			var def = this.fonts[familyName][type];
			if (!isArray(def)) {
				def = [def];
			}
			this.fontCache[familyName][type] = this.pdfKitDoc.font.apply(this.pdfKitDoc, def)._font;
		}

		return this.fontCache[familyName][type];
	};

	module.exports = FontProvider;


/***/ }),
/* 8 */
/***/ (function(module, exports) {

	/* jslint node: true */
	'use strict';

	function isString(variable) {
		return typeof variable === 'string' || variable instanceof String;
	}

	function isNumber(variable) {
		return typeof variable === 'number' || variable instanceof Number;
	}

	function isBoolean(variable) {
		return typeof variable === 'boolean';
	}

	function isArray(variable) {
		return Array.isArray(variable);
	}

	function isFunction(variable) {
		return typeof variable === 'function';
	}

	function isObject(variable) {
		return variable !== null && typeof variable === 'object';
	}

	function pack() {
		var result = {};

		for (var i = 0, l = arguments.length; i < l; i++) {
			var obj = arguments[i];

			if (obj) {
				for (var key in obj) {
					if (obj.hasOwnProperty(key)) {
						result[key] = obj[key];
					}
				}
			}
		}

		return result;
	}

	function offsetVector(vector, x, y) {
		switch (vector.type) {
			case 'ellipse':
			case 'rect':
				vector.x += x;
				vector.y += y;
				break;
			case 'line':
				vector.x1 += x;
				vector.x2 += x;
				vector.y1 += y;
				vector.y2 += y;
				break;
			case 'polyline':
				for (var i = 0, l = vector.points.length; i < l; i++) {
					vector.points[i].x += x;
					vector.points[i].y += y;
				}
				break;
		}
	}

	function fontStringify(key, val) {
		if (key === 'font') {
			return 'font';
		}
		return val;
	}

	module.exports = {
		isString: isString,
		isNumber: isNumber,
		isBoolean: isBoolean,
		isArray: isArray,
		isFunction: isFunction,
		isObject: isObject,
		pack: pack,
		fontStringify: fontStringify,
		offsetVector: offsetVector
	};


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var TraversalTracker = __webpack_require__(10);
	var DocPreprocessor = __webpack_require__(11);
	var DocMeasure = __webpack_require__(12);
	var DocumentContext = __webpack_require__(23);
	var PageElementWriter = __webpack_require__(24);
	var ColumnCalculator = __webpack_require__(21);
	var TableProcessor = __webpack_require__(27);
	var Line = __webpack_require__(26);
	var isString = __webpack_require__(8).isString;
	var isArray = __webpack_require__(8).isArray;
	var pack = __webpack_require__(8).pack;
	var offsetVector = __webpack_require__(8).offsetVector;
	var fontStringify = __webpack_require__(8).fontStringify;
	var isFunction = __webpack_require__(8).isFunction;
	var TextTools = __webpack_require__(13);
	var StyleContextStack = __webpack_require__(20);

	function addAll(target, otherArray) {
		otherArray.forEach(function (item) {
			target.push(item);
		});
	}

	/**
	 * Creates an instance of LayoutBuilder - layout engine which turns document-definition-object
	 * into a set of pages, lines, inlines and vectors ready to be rendered into a PDF
	 *
	 * @param {Object} pageSize - an object defining page width and height
	 * @param {Object} pageMargins - an object defining top, left, right and bottom margins
	 */
	function LayoutBuilder(pageSize, pageMargins, imageMeasure) {
		this.pageSize = pageSize;
		this.pageMargins = pageMargins;
		this.tracker = new TraversalTracker();
		this.imageMeasure = imageMeasure;
		this.tableLayouts = {};
	}

	LayoutBuilder.prototype.registerTableLayouts = function (tableLayouts) {
		this.tableLayouts = pack(this.tableLayouts, tableLayouts);
	};

	/**
	 * Executes layout engine on document-definition-object and creates an array of pages
	 * containing positioned Blocks, Lines and inlines
	 *
	 * @param {Object} docStructure document-definition-object
	 * @param {Object} fontProvider font provider
	 * @param {Object} styleDictionary dictionary with style definitions
	 * @param {Object} defaultStyle default style definition
	 * @return {Array} an array of pages
	 */
	LayoutBuilder.prototype.layoutDocument = function (docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark, pageBreakBeforeFct) {

		function addPageBreaksIfNecessary(linearNodeList, pages) {

			if (!isFunction(pageBreakBeforeFct)) {
				return false;
			}

			linearNodeList = linearNodeList.filter(function (node) {
				return node.positions.length > 0;
			});

			linearNodeList.forEach(function (node) {
				var nodeInfo = {};
				[
					'id', 'text', 'ul', 'ol', 'table', 'image', 'qr', 'canvas', 'columns',
					'headlineLevel', 'style', 'pageBreak', 'pageOrientation',
					'width', 'height'
				].forEach(function (key) {
					if (node[key] !== undefined) {
						nodeInfo[key] = node[key];
					}
				});
				nodeInfo.startPosition = node.positions[0];
				nodeInfo.pageNumbers = node.positions.map(function (node) {
					return node.pageNumber;
				}).filter(function (element, position, array) {
					return array.indexOf(element) === position;
				});
				nodeInfo.pages = pages.length;
				nodeInfo.stack = isArray(node.stack);

				node.nodeInfo = nodeInfo;
			});

			return linearNodeList.some(function (node, index, followingNodeList) {
				if (node.pageBreak !== 'before' && !node.pageBreakCalculated) {
					node.pageBreakCalculated = true;
					var pageNumber = node.nodeInfo.pageNumbers[0];

					var followingNodesOnPage = followingNodeList.slice(index + 1).filter(function (node0) {
						return node0.nodeInfo.pageNumbers.indexOf(pageNumber) > -1;
					});

					var nodesOnNextPage = followingNodeList.slice(index + 1).filter(function (node0) {
						return node0.nodeInfo.pageNumbers.indexOf(pageNumber + 1) > -1;
					});

					var previousNodesOnPage = followingNodeList.slice(0, index).filter(function (node0) {
						return node0.nodeInfo.pageNumbers.indexOf(pageNumber) > -1;
					});

					if (
						pageBreakBeforeFct(
							node.nodeInfo,
							followingNodesOnPage.map(function (node) {
								return node.nodeInfo;
							}),
							nodesOnNextPage.map(function (node) {
								return node.nodeInfo;
							}),
							previousNodesOnPage.map(function (node) {
								return node.nodeInfo;
							}))) {
						node.pageBreak = 'before';
						return true;
					}
				}
			});
		}

		this.docPreprocessor = new DocPreprocessor();
		this.docMeasure = new DocMeasure(fontProvider, styleDictionary, defaultStyle, this.imageMeasure, this.tableLayouts, images);


		function resetXYs(result) {
			result.linearNodeList.forEach(function (node) {
				node.resetXY();
			});
		}

		var result = this.tryLayoutDocument(docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark);
		while (addPageBreaksIfNecessary(result.linearNodeList, result.pages)) {
			resetXYs(result);
			result = this.tryLayoutDocument(docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark);
		}

		return result.pages;
	};

	LayoutBuilder.prototype.tryLayoutDocument = function (docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark, pageBreakBeforeFct) {

		this.linearNodeList = [];
		docStructure = this.docPreprocessor.preprocessDocument(docStructure);
		docStructure = this.docMeasure.measureDocument(docStructure);

		this.writer = new PageElementWriter(
			new DocumentContext(this.pageSize, this.pageMargins), this.tracker);

		var _this = this;
		this.writer.context().tracker.startTracking('pageAdded', function () {
			_this.addBackground(background);
		});

		this.addBackground(background);
		this.processNode(docStructure);
		this.addHeadersAndFooters(header, footer);
		/* jshint eqnull:true */
		if (watermark != null) {
			this.addWatermark(watermark, fontProvider, defaultStyle);
		}

		return {pages: this.writer.context().pages, linearNodeList: this.linearNodeList};
	};


	LayoutBuilder.prototype.addBackground = function (background) {
		var backgroundGetter = isFunction(background) ? background : function () {
			return background;
		};

		var pageBackground = backgroundGetter(this.writer.context().page + 1);

		if (pageBackground) {
			var pageSize = this.writer.context().getCurrentPage().pageSize;
			this.writer.beginUnbreakableBlock(pageSize.width, pageSize.height);
			pageBackground = this.docPreprocessor.preprocessDocument(pageBackground);
			this.processNode(this.docMeasure.measureDocument(pageBackground));
			this.writer.commitUnbreakableBlock(0, 0);
		}
	};

	LayoutBuilder.prototype.addStaticRepeatable = function (headerOrFooter, sizeFunction) {
		this.addDynamicRepeatable(function () {
			return JSON.parse(JSON.stringify(headerOrFooter)); // copy to new object
		}, sizeFunction);
	};

	LayoutBuilder.prototype.addDynamicRepeatable = function (nodeGetter, sizeFunction) {
		var pages = this.writer.context().pages;

		for (var pageIndex = 0, l = pages.length; pageIndex < l; pageIndex++) {
			this.writer.context().page = pageIndex;

			var node = nodeGetter(pageIndex + 1, l, this.writer.context().pages[pageIndex].pageSize);

			if (node) {
				var sizes = sizeFunction(this.writer.context().getCurrentPage().pageSize, this.pageMargins);
				this.writer.beginUnbreakableBlock(sizes.width, sizes.height);
				node = this.docPreprocessor.preprocessDocument(node);
				this.processNode(this.docMeasure.measureDocument(node));
				this.writer.commitUnbreakableBlock(sizes.x, sizes.y);
			}
		}
	};

	LayoutBuilder.prototype.addHeadersAndFooters = function (header, footer) {
		var headerSizeFct = function (pageSize, pageMargins) {
			return {
				x: 0,
				y: 0,
				width: pageSize.width,
				height: pageMargins.top
			};
		};

		var footerSizeFct = function (pageSize, pageMargins) {
			return {
				x: 0,
				y: pageSize.height - pageMargins.bottom,
				width: pageSize.width,
				height: pageMargins.bottom
			};
		};

		if (isFunction(header)) {
			this.addDynamicRepeatable(header, headerSizeFct);
		} else if (header) {
			this.addStaticRepeatable(header, headerSizeFct);
		}

		if (isFunction(footer)) {
			this.addDynamicRepeatable(footer, footerSizeFct);
		} else if (footer) {
			this.addStaticRepeatable(footer, footerSizeFct);
		}
	};

	LayoutBuilder.prototype.addWatermark = function (watermark, fontProvider, defaultStyle) {
		if (isString(watermark)) {
			watermark = {'text': watermark};
		}

		if (!watermark.text) { // empty watermark text
			return;
		}

		watermark.font = watermark.font || defaultStyle.font || 'Roboto';
		watermark.color = watermark.color || 'black';
		watermark.opacity = watermark.opacity || 0.6;
		watermark.bold = watermark.bold || false;
		watermark.italics = watermark.italics || false;

		var watermarkObject = {
			text: watermark.text,
			font: fontProvider.provideFont(watermark.font, watermark.bold, watermark.italics),
			size: getSize(this.pageSize, watermark, fontProvider),
			color: watermark.color,
			opacity: watermark.opacity
		};

		var pages = this.writer.context().pages;
		for (var i = 0, l = pages.length; i < l; i++) {
			pages[i].watermark = watermarkObject;
		}

		function getSize(pageSize, watermark, fontProvider) {
			var width = pageSize.width;
			var height = pageSize.height;
			var targetWidth = Math.sqrt(width * width + height * height) * 0.8; /* page diagonal * sample factor */
			var textTools = new TextTools(fontProvider);
			var styleContextStack = new StyleContextStack(null, {font: watermark.font, bold: watermark.bold, italics: watermark.italics});
			var size;

			/**
			 * Binary search the best font size.
			 * Initial bounds [0, 1000]
			 * Break when range < 1
			 */
			var a = 0;
			var b = 1000;
			var c = (a + b) / 2;
			while (Math.abs(a - b) > 1) {
				styleContextStack.push({
					fontSize: c
				});
				size = textTools.sizeOfString(watermark.text, styleContextStack);
				if (size.width > targetWidth) {
					b = c;
					c = (a + b) / 2;
				} else if (size.width < targetWidth) {
					a = c;
					c = (a + b) / 2;
				}
				styleContextStack.pop();
			}
			/*
			 End binary search
			 */
			return {size: size, fontSize: c};
		}
	};

	function decorateNode(node) {
		var x = node.x, y = node.y;
		node.positions = [];

		if (isArray(node.canvas)) {
			node.canvas.forEach(function (vector) {
				var x = vector.x, y = vector.y, x1 = vector.x1, y1 = vector.y1, x2 = vector.x2, y2 = vector.y2;
				vector.resetXY = function () {
					vector.x = x;
					vector.y = y;
					vector.x1 = x1;
					vector.y1 = y1;
					vector.x2 = x2;
					vector.y2 = y2;
				};
			});
		}

		node.resetXY = function () {
			node.x = x;
			node.y = y;
			if (isArray(node.canvas)) {
				node.canvas.forEach(function (vector) {
					vector.resetXY();
				});
			}
		};
	}

	LayoutBuilder.prototype.processNode = function (node) {
		var self = this;

		this.linearNodeList.push(node);
		decorateNode(node);

		applyMargins(function () {
			var unbreakable = node.unbreakable;
			if (unbreakable) {
				self.writer.beginUnbreakableBlock();
			}

			var absPosition = node.absolutePosition;
			if (absPosition) {
				self.writer.context().beginDetachedBlock();
				self.writer.context().moveTo(absPosition.x || 0, absPosition.y || 0);
			}

			var relPosition = node.relativePosition;
			if (relPosition) {
				self.writer.context().beginDetachedBlock();
				self.writer.context().moveTo((relPosition.x || 0) + self.writer.context().x, (relPosition.y || 0) + self.writer.context().y);
			}

			if (node.stack) {
				self.processVerticalContainer(node);
			} else if (node.columns) {
				self.processColumns(node);
			} else if (node.ul) {
				self.processList(false, node);
			} else if (node.ol) {
				self.processList(true, node);
			} else if (node.table) {
				self.processTable(node);
			} else if (node.text !== undefined) {
				self.processLeaf(node);
			} else if (node.toc) {
				self.processToc(node);
			} else if (node.image) {
				self.processImage(node);
			} else if (node.canvas) {
				self.processCanvas(node);
			} else if (node.qr) {
				self.processQr(node);
			} else if (!node._span) {
				throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
			}

			if (absPosition || relPosition) {
				self.writer.context().endDetachedBlock();
			}

			if (unbreakable) {
				self.writer.commitUnbreakableBlock();
			}
		});

		function applyMargins(callback) {
			var margin = node._margin;

			if (node.pageBreak === 'before') {
				self.writer.moveToNextPage(node.pageOrientation);
			}

			if (margin) {
				self.writer.context().moveDown(margin[1]);
				self.writer.context().addMargin(margin[0], margin[2]);
			}

			callback();

			if (margin) {
				self.writer.context().addMargin(-margin[0], -margin[2]);
				self.writer.context().moveDown(margin[3]);
			}

			if (node.pageBreak === 'after') {
				self.writer.moveToNextPage(node.pageOrientation);
			}
		}
	};

	// vertical container
	LayoutBuilder.prototype.processVerticalContainer = function (node) {
		var self = this;
		node.stack.forEach(function (item) {
			self.processNode(item);
			addAll(node.positions, item.positions);

			//TODO: paragraph gap
		});
	};

	// columns
	LayoutBuilder.prototype.processColumns = function (columnNode) {
		var columns = columnNode.columns;
		var availableWidth = this.writer.context().availableWidth;
		var gaps = gapArray(columnNode._gap);

		if (gaps) {
			availableWidth -= (gaps.length - 1) * columnNode._gap;
		}

		ColumnCalculator.buildColumnWidths(columns, availableWidth);
		var result = this.processRow(columns, columns, gaps);
		addAll(columnNode.positions, result.positions);


		function gapArray(gap) {
			if (!gap) {
				return null;
			}

			var gaps = [];
			gaps.push(0);

			for (var i = columns.length - 1; i > 0; i--) {
				gaps.push(gap);
			}

			return gaps;
		}
	};

	LayoutBuilder.prototype.processRow = function (columns, widths, gaps, tableBody, tableRow, height) {
		var self = this;
		var pageBreaks = [], positions = [];

		this.tracker.auto('pageChanged', storePageBreakData, function () {
			widths = widths || columns;

			self.writer.context().beginColumnGroup();

			for (var i = 0, l = columns.length; i < l; i++) {
				var column = columns[i];
				var width = widths[i]._calcWidth;
				var leftOffset = colLeftOffset(i);

				if (column.colSpan && column.colSpan > 1) {
					for (var j = 1; j < column.colSpan; j++) {
						width += widths[++i]._calcWidth + gaps[i];
					}
				}

				self.writer.context().beginColumn(width, leftOffset, getEndingCell(column, i));
				if (!column._span) {
					self.processNode(column);
					addAll(positions, column.positions);
				} else if (column._columnEndingContext) {
					// row-span ending
					self.writer.context().markEnding(column);
				}
			}

			self.writer.context().completeColumnGroup(height);
		});

		return {pageBreaks: pageBreaks, positions: positions};

		function storePageBreakData(data) {
			var pageDesc;

			for (var i = 0, l = pageBreaks.length; i < l; i++) {
				var desc = pageBreaks[i];
				if (desc.prevPage === data.prevPage) {
					pageDesc = desc;
					break;
				}
			}

			if (!pageDesc) {
				pageDesc = data;
				pageBreaks.push(pageDesc);
			}
			pageDesc.prevY = Math.max(pageDesc.prevY, data.prevY);
			pageDesc.y = Math.min(pageDesc.y, data.y);
		}

		function colLeftOffset(i) {
			if (gaps && gaps.length > i) {
				return gaps[i];
			}
			return 0;
		}

		function getEndingCell(column, columnIndex) {
			if (column.rowSpan && column.rowSpan > 1) {
				var endingRow = tableRow + column.rowSpan - 1;
				if (endingRow >= tableBody.length) {
					throw 'Row span for column ' + columnIndex + ' (with indexes starting from 0) exceeded row count';
				}
				return tableBody[endingRow][columnIndex];
			}

			return null;
		}
	};

	// lists
	LayoutBuilder.prototype.processList = function (orderedList, node) {
		var self = this,
			items = orderedList ? node.ol : node.ul,
			gapSize = node._gapSize;

		this.writer.context().addMargin(gapSize.width);

		var nextMarker;
		this.tracker.auto('lineAdded', addMarkerToFirstLeaf, function () {
			items.forEach(function (item) {
				nextMarker = item.listMarker;
				self.processNode(item);
				addAll(node.positions, item.positions);
			});
		});

		this.writer.context().addMargin(-gapSize.width);

		function addMarkerToFirstLeaf(line) {
			// I'm not very happy with the way list processing is implemented
			// (both code and algorithm should be rethinked)
			if (nextMarker) {
				var marker = nextMarker;
				nextMarker = null;

				if (marker.canvas) {
					var vector = marker.canvas[0];

					offsetVector(vector, -marker._minWidth, 0);
					self.writer.addVector(vector);
				} else if (marker._inlines) {
					var markerLine = new Line(self.pageSize.width);
					markerLine.addInline(marker._inlines[0]);
					markerLine.x = -marker._minWidth;
					markerLine.y = line.getAscenderHeight() - markerLine.getAscenderHeight();
					self.writer.addLine(markerLine, true);
				}
			}
		}
	};

	// tables
	LayoutBuilder.prototype.processTable = function (tableNode) {
		var processor = new TableProcessor(tableNode);

		processor.beginTable(this.writer);

		var rowHeights = tableNode.table.heights;
		for (var i = 0, l = tableNode.table.body.length; i < l; i++) {
			processor.beginRow(i, this.writer);

			var height;
			if (isFunction(rowHeights)) {
				height = rowHeights(i);
			} else if (isArray(rowHeights)) {
				height = rowHeights[i];
			} else {
				height = rowHeights;
			}

			if (height === 'auto') {
				height = undefined;
			}

			var result = this.processRow(tableNode.table.body[i], tableNode.table.widths, tableNode._offsets.offsets, tableNode.table.body, i, height);
			addAll(tableNode.positions, result.positions);

			processor.endRow(i, this.writer, result.pageBreaks);
		}

		processor.endTable(this.writer);
	};

	// leafs (texts)
	LayoutBuilder.prototype.processLeaf = function (node) {
		var line = this.buildNextLine(node);
		var currentHeight = (line) ? line.getHeight() : 0;
		var maxHeight = node.maxHeight || -1;

		if (node._tocItemRef) {
			line._tocItemNode = node._tocItemRef;
		}

		while (line && (maxHeight === -1 || currentHeight < maxHeight)) {
			var positions = this.writer.addLine(line);
			node.positions.push(positions);
			line = this.buildNextLine(node);
			if (line) {
				currentHeight += line.getHeight();
			}
		}
	};

	LayoutBuilder.prototype.processToc = function (node) {
		if (node.toc.title) {
			this.processNode(node.toc.title);
		}
		this.processNode(node.toc._table);
	};

	LayoutBuilder.prototype.buildNextLine = function (textNode) {

		function cloneInline(inline) {
			var newInline = inline.constructor();
			for (var key in inline) {
				newInline[key] = inline[key];
			}
			return newInline;
		}

		if (!textNode._inlines || textNode._inlines.length === 0) {
			return null;
		}

		var line = new Line(this.writer.context().availableWidth);
		var textTools = new TextTools(null);

		while (textNode._inlines && textNode._inlines.length > 0 && line.hasEnoughSpaceForInline(textNode._inlines[0])) {
			var inline = textNode._inlines.shift();

			if (!inline.noWrap && inline.text.length > 1 && inline.width > line.maxWidth) {
				var widthPerChar = inline.width / inline.text.length;
				var maxChars = Math.floor(line.maxWidth / widthPerChar);
				if (maxChars < 1) {
					maxChars = 1;
				}
				if (maxChars < inline.text.length) {
					var newInline = cloneInline(inline);

					newInline.text = inline.text.substr(maxChars);
					inline.text = inline.text.substr(0, maxChars);

					newInline.width = textTools.widthOfString(newInline.text, newInline.font, newInline.fontSize, newInline.characterSpacing, newInline.fontFeatures);
					inline.width = textTools.widthOfString(inline.text, inline.font, inline.fontSize, inline.characterSpacing, inline.fontFeatures);

					textNode._inlines.unshift(newInline);
				}
			}

			line.addInline(inline);
		}

		line.lastLineInParagraph = textNode._inlines.length === 0;

		return line;
	};

	// images
	LayoutBuilder.prototype.processImage = function (node) {
		var position = this.writer.addImage(node);
		node.positions.push(position);
	};

	LayoutBuilder.prototype.processCanvas = function (node) {
		var height = node._minHeight;

		if (node.absolutePosition === undefined && this.writer.context().availableHeight < height) {
			// TODO: support for canvas larger than a page
			// TODO: support for other overflow methods

			this.writer.moveToNextPage();
		}

		this.writer.alignCanvas(node);

		node.canvas.forEach(function (vector) {
			var position = this.writer.addVector(vector);
			node.positions.push(position);
		}, this);

		this.writer.context().moveDown(height);
	};

	LayoutBuilder.prototype.processQr = function (node) {
		var position = this.writer.addQr(node);
		node.positions.push(position);
	};

	module.exports = LayoutBuilder;


/***/ }),
/* 10 */
/***/ (function(module, exports) {

	/* jslint node: true */
	'use strict';

	/**
	 * Creates an instance of TraversalTracker
	 *
	 * @constructor
	 */
	function TraversalTracker() {
		this.events = {};
	}

	TraversalTracker.prototype.startTracking = function (event, cb) {
		var callbacks = (this.events[event] || (this.events[event] = []));

		if (callbacks.indexOf(cb) < 0) {
			callbacks.push(cb);
		}
	};

	TraversalTracker.prototype.stopTracking = function (event, cb) {
		var callbacks = this.events[event];

		if (callbacks) {
			var index = callbacks.indexOf(cb);
			if (index >= 0) {
				callbacks.splice(index, 1);
			}
		}
	};

	TraversalTracker.prototype.emit = function (event) {
		var args = Array.prototype.slice.call(arguments, 1);

		var callbacks = this.events[event];

		if (callbacks) {
			callbacks.forEach(function (cb) {
				cb.apply(this, args);
			});
		}
	};

	TraversalTracker.prototype.auto = function (event, cb, innerBlock) {
		this.startTracking(event, cb);
		innerBlock();
		this.stopTracking(event, cb);
	};

	module.exports = TraversalTracker;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var isString = __webpack_require__(8).isString;
	var isNumber = __webpack_require__(8).isNumber;
	var isBoolean = __webpack_require__(8).isBoolean;
	var isArray = __webpack_require__(8).isArray;
	var fontStringify = __webpack_require__(8).fontStringify;

	function DocPreprocessor() {

	}

	DocPreprocessor.prototype.preprocessDocument = function (docStructure) {
		this.tocs = [];
		return this.preprocessNode(docStructure);
	};

	DocPreprocessor.prototype.preprocessNode = function (node) {
		// expand shortcuts and casting values
		if (isArray(node)) {
			node = {stack: node};
		} else if (isString(node)) {
			node = {text: node};
		} else if (isNumber(node) || isBoolean(node)) {
			node = {text: node.toString()};
		} else if (node === null) {
			node = {text: ''};
		} else if (Object.keys(node).length === 0) { // empty object
			node = {text: ''};
		}

		if (node.columns) {
			return this.preprocessColumns(node);
		} else if (node.stack) {
			return this.preprocessVerticalContainer(node);
		} else if (node.ul) {
			return this.preprocessList(node);
		} else if (node.ol) {
			return this.preprocessList(node);
		} else if (node.table) {
			return this.preprocessTable(node);
		} else if (node.text !== undefined) {
			return this.preprocessText(node);
		} else if (node.toc) {
			return this.preprocessToc(node);
		} else if (node.image) {
			return this.preprocessImage(node);
		} else if (node.canvas) {
			return this.preprocessCanvas(node);
		} else if (node.qr) {
			return this.preprocessQr(node);
		} else {
			throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
		}
	};

	DocPreprocessor.prototype.preprocessColumns = function (node) {
		var columns = node.columns;

		for (var i = 0, l = columns.length; i < l; i++) {
			columns[i] = this.preprocessNode(columns[i]);
		}

		return node;
	};

	DocPreprocessor.prototype.preprocessVerticalContainer = function (node) {
		var items = node.stack;

		for (var i = 0, l = items.length; i < l; i++) {
			items[i] = this.preprocessNode(items[i]);
		}

		return node;
	};

	DocPreprocessor.prototype.preprocessList = function (node) {
		var items = node.ul || node.ol;

		for (var i = 0, l = items.length; i < l; i++) {
			items[i] = this.preprocessNode(items[i]);
		}

		return node;
	};

	DocPreprocessor.prototype.preprocessTable = function (node) {
		var col, row, cols, rows;

		for (col = 0, cols = node.table.body[0].length; col < cols; col++) {
			for (row = 0, rows = node.table.body.length; row < rows; row++) {
				var rowData = node.table.body[row];
				var data = rowData[col];
				if (data !== undefined) {
					if (data === null) { // transform to object
						data = '';
					}
					if (!data._span) {
						rowData[col] = this.preprocessNode(data);
					}
				}
			}
		}

		return node;
	};

	DocPreprocessor.prototype.preprocessText = function (node) {
		if (node.tocItem) {
			if (!isArray(node.tocItem)) {
				node.tocItem = [node.tocItem];
			}

			for (var i = 0, l = node.tocItem.length; i < l; i++) {
				if (!isString(node.tocItem[i])) {
					node.tocItem[i] = '_default_';
				}

				var tocItemId = node.tocItem[i];

				if (!this.tocs[tocItemId]) {
					this.tocs[tocItemId] = {toc: {_items: [], _pseudo: true}};
				}

				this.tocs[tocItemId].toc._items.push(node);
			}
		}

		if (node.text && node.text.text) {
			node.text = [this.preprocessNode(node.text)];
		}

		return node;
	};

	DocPreprocessor.prototype.preprocessToc = function (node) {
		if (!node.toc.id) {
			node.toc.id = '_default_';
		}

		node.toc.title = node.toc.title ? this.preprocessNode(node.toc.title) : null;
		node.toc._items = [];

		if (this.tocs[node.toc.id]) {
			if (!this.tocs[node.toc.id].toc._pseudo) {
				throw "TOC '" + node.toc.id + "' already exists";
			}

			node.toc._items = this.tocs[node.toc.id].toc._items;
		}

		this.tocs[node.toc.id] = node;

		return node;
	};

	DocPreprocessor.prototype.preprocessImage = function (node) {
		return node;
	};

	DocPreprocessor.prototype.preprocessCanvas = function (node) {
		return node;
	};

	DocPreprocessor.prototype.preprocessQr = function (node) {
		return node;
	};

	module.exports = DocPreprocessor;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var TextTools = __webpack_require__(13);
	var StyleContextStack = __webpack_require__(20);
	var ColumnCalculator = __webpack_require__(21);
	var isString = __webpack_require__(8).isString;
	var isNumber = __webpack_require__(8).isNumber;
	var isObject = __webpack_require__(8).isObject;
	var isArray = __webpack_require__(8).isArray;
	var fontStringify = __webpack_require__(8).fontStringify;
	var pack = __webpack_require__(8).pack;
	var qrEncoder = __webpack_require__(22);

	/**
	 * @private
	 */
	function DocMeasure(fontProvider, styleDictionary, defaultStyle, imageMeasure, tableLayouts, images) {
		this.textTools = new TextTools(fontProvider);
		this.styleStack = new StyleContextStack(styleDictionary, defaultStyle);
		this.imageMeasure = imageMeasure;
		this.tableLayouts = tableLayouts;
		this.images = images;
		this.autoImageIndex = 1;
	}

	/**
	 * Measures all nodes and sets min/max-width properties required for the second
	 * layout-pass.
	 * @param  {Object} docStructure document-definition-object
	 * @return {Object}              document-measurement-object
	 */
	DocMeasure.prototype.measureDocument = function (docStructure) {
		return this.measureNode(docStructure);
	};

	DocMeasure.prototype.measureNode = function (node) {

		var self = this;

		return this.styleStack.auto(node, function () {
			// TODO: refactor + rethink whether this is the proper way to handle margins
			node._margin = getNodeMargin(node);

			if (node.columns) {
				return extendMargins(self.measureColumns(node));
			} else if (node.stack) {
				return extendMargins(self.measureVerticalContainer(node));
			} else if (node.ul) {
				return extendMargins(self.measureUnorderedList(node));
			} else if (node.ol) {
				return extendMargins(self.measureOrderedList(node));
			} else if (node.table) {
				return extendMargins(self.measureTable(node));
			} else if (node.text !== undefined) {
				return extendMargins(self.measureLeaf(node));
			} else if (node.toc) {
				return extendMargins(self.measureToc(node));
			} else if (node.image) {
				return extendMargins(self.measureImage(node));
			} else if (node.canvas) {
				return extendMargins(self.measureCanvas(node));
			} else if (node.qr) {
				return extendMargins(self.measureQr(node));
			} else {
				throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
			}
		});

		function extendMargins(node) {
			var margin = node._margin;

			if (margin) {
				node._minWidth += margin[0] + margin[2];
				node._maxWidth += margin[0] + margin[2];
			}

			return node;
		}

		function getNodeMargin() {

			function processSingleMargins(node, currentMargin) {
				if (node.marginLeft || node.marginTop || node.marginRight || node.marginBottom) {
					return [
						node.marginLeft || currentMargin[0] || 0,
						node.marginTop || currentMargin[1] || 0,
						node.marginRight || currentMargin[2] || 0,
						node.marginBottom || currentMargin[3] || 0
					];
				}
				return currentMargin;
			}

			function flattenStyleArray(styleArray) {
				var flattenedStyles = {};
				for (var i = styleArray.length - 1; i >= 0; i--) {
					var styleName = styleArray[i];
					var style = self.styleStack.styleDictionary[styleName];
					for (var key in style) {
						if (style.hasOwnProperty(key)) {
							flattenedStyles[key] = style[key];
						}
					}
				}
				return flattenedStyles;
			}

			function convertMargin(margin) {
				if (isNumber(margin)) {
					margin = [margin, margin, margin, margin];
				} else if (isArray(margin)) {
					if (margin.length === 2) {
						margin = [margin[0], margin[1], margin[0], margin[1]];
					}
				}
				return margin;
			}

			var margin = [undefined, undefined, undefined, undefined];

			if (node.style) {
				var styleArray = isArray(node.style) ? node.style : [node.style];
				var flattenedStyleArray = flattenStyleArray(styleArray);

				if (flattenedStyleArray) {
					margin = processSingleMargins(flattenedStyleArray, margin);
				}

				if (flattenedStyleArray.margin) {
					margin = convertMargin(flattenedStyleArray.margin);
				}
			}

			margin = processSingleMargins(node, margin);

			if (node.margin) {
				margin = convertMargin(node.margin);
			}

			if (margin[0] === undefined && margin[1] === undefined && margin[2] === undefined && margin[3] === undefined) {
				return null;
			} else {
				return margin;
			}
		}
	};

	DocMeasure.prototype.convertIfBase64Image = function (node) {
		if (/^data:image\/(jpeg|jpg|png);base64,/.test(node.image)) {
			var label = '$$pdfmake$$' + this.autoImageIndex++;
			this.images[label] = node.image;
			node.image = label;
		}
	};

	DocMeasure.prototype.measureImage = function (node) {
		if (this.images) {
			this.convertIfBase64Image(node);
		}

		var imageSize = this.imageMeasure.measureImage(node.image);

		if (node.fit) {
			var factor = (imageSize.width / imageSize.height > node.fit[0] / node.fit[1]) ? node.fit[0] / imageSize.width : node.fit[1] / imageSize.height;
			node._width = node._minWidth = node._maxWidth = imageSize.width * factor;
			node._height = imageSize.height * factor;
		} else {
			node._width = node._minWidth = node._maxWidth = node.width || imageSize.width;
			node._height = node.height || (imageSize.height * node._width / imageSize.width);

			if (isNumber(node.maxWidth) && node.maxWidth < node._width) {
				node._width = node._minWidth = node._maxWidth = node.maxWidth;
				node._height = node._width * imageSize.height / imageSize.width;
			}

			if (isNumber(node.maxHeight) && node.maxHeight < node._height) {
				node._height = node.maxHeight;
				node._width = node._minWidth = node._maxWidth = node._height * imageSize.width / imageSize.height;
			}

			if (isNumber(node.minWidth) && node.minWidth > node._width) {
				node._width = node._minWidth = node._maxWidth = node.minWidth;
				node._height = node._width * imageSize.height / imageSize.width;
			}

			if (isNumber(node.minHeight) && node.minHeight > node._height) {
				node._height = node.minHeight;
				node._width = node._minWidth = node._maxWidth = node._height * imageSize.width / imageSize.height;
			}
		}

		node._alignment = this.styleStack.getProperty('alignment');
		return node;
	};

	DocMeasure.prototype.measureLeaf = function (node) {

		// Make sure style properties of the node itself are considered when building inlines.
		// We could also just pass [node] to buildInlines, but that fails for bullet points.
		var styleStack = this.styleStack.clone();
		styleStack.push(node);

		var data = this.textTools.buildInlines(node.text, styleStack);

		node._inlines = data.items;
		node._minWidth = data.minWidth;
		node._maxWidth = data.maxWidth;

		return node;
	};

	DocMeasure.prototype.measureToc = function (node) {
		if (node.toc.title) {
			node.toc.title = this.measureNode(node.toc.title);
		}

		var body = [];
		var textStyle = node.toc.textStyle || {};
		var numberStyle = node.toc.numberStyle || textStyle;
		var textMargin = node.toc.textMargin || [0, 0, 0, 0];
		for (var i = 0, l = node.toc._items.length; i < l; i++) {
			var item = node.toc._items[i];
			var lineStyle = node.toc._items[i].tocStyle || textStyle;
			var lineMargin = node.toc._items[i].tocMargin || textMargin;
			body.push([
				{text: item.text, alignment: 'left', style: lineStyle, margin: lineMargin},
				{text: '00000', alignment: 'right', _tocItemRef: item, style: numberStyle, margin: [0, lineMargin[1], 0, lineMargin[3]]}
			]);
		}


		node.toc._table = {
			table: {
				dontBreakRows: true,
				widths: ['*', 'auto'],
				body: body
			},
			layout: 'noBorders'
		};

		node.toc._table = this.measureNode(node.toc._table);

		return node;
	};

	DocMeasure.prototype.measureVerticalContainer = function (node) {
		var items = node.stack;

		node._minWidth = 0;
		node._maxWidth = 0;

		for (var i = 0, l = items.length; i < l; i++) {
			items[i] = this.measureNode(items[i]);

			node._minWidth = Math.max(node._minWidth, items[i]._minWidth);
			node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth);
		}

		return node;
	};

	DocMeasure.prototype.gapSizeForList = function () {
		return this.textTools.sizeOfString('9. ', this.styleStack);
	};

	DocMeasure.prototype.buildUnorderedMarker = function (styleStack, gapSize, type) {
		function buildDisc(gapSize, color) {
			// TODO: ascender-based calculations
			var radius = gapSize.fontSize / 6;
			return {
				canvas: [{
						x: radius,
						y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - gapSize.fontSize / 3,
						r1: radius,
						r2: radius,
						type: 'ellipse',
						color: color
					}]
			};
		}

		function buildSquare(gapSize, color) {
			// TODO: ascender-based calculations
			var size = gapSize.fontSize / 3;
			return {
				canvas: [{
						x: 0,
						y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - (gapSize.fontSize / 3) - (size / 2),
						h: size,
						w: size,
						type: 'rect',
						color: color
					}]
			};
		}

		function buildCircle(gapSize, color) {
			// TODO: ascender-based calculations
			var radius = gapSize.fontSize / 6;
			return {
				canvas: [{
						x: radius,
						y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - gapSize.fontSize / 3,
						r1: radius,
						r2: radius,
						type: 'ellipse',
						lineColor: color
					}]
			};
		}

		var marker;
		var color = styleStack.getProperty('markerColor') || styleStack.getProperty('color') || 'black';

		switch (type) {
			case 'circle':
				marker = buildCircle(gapSize, color);
				break;

			case 'square':
				marker = buildSquare(gapSize, color);
				break;

			case 'none':
				marker = {};
				break;

			case 'disc':
			default:
				marker = buildDisc(gapSize, color);
				break;
		}

		marker._minWidth = marker._maxWidth = gapSize.width;
		marker._minHeight = marker._maxHeight = gapSize.height;

		return marker;
	};

	DocMeasure.prototype.buildOrderedMarker = function (counter, styleStack, type, separator) {
		function prepareAlpha(counter) {
			function toAlpha(num) {
				return (num >= 26 ? toAlpha((num / 26 >> 0) - 1) : '') + 'abcdefghijklmnopqrstuvwxyz'[num % 26 >> 0];
			}

			if (counter < 1) {
				return counter.toString();
			}

			return toAlpha(counter - 1);
		}

		function prepareRoman(counter) {
			if (counter < 1 || counter > 4999) {
				return counter.toString();
			}
			var num = counter;
			var lookup = {M: 1000, CM: 900, D: 500, CD: 400, C: 100, XC: 90, L: 50, XL: 40, X: 10, IX: 9, V: 5, IV: 4, I: 1}, roman = '', i;
			for (i in lookup) {
				while (num >= lookup[i]) {
					roman += i;
					num -= lookup[i];
				}
			}
			return roman;
		}

		function prepareDecimal(counter) {
			return counter.toString();
		}

		var counterText;
		switch (type) {
			case 'none':
				counterText = null;
				break;

			case 'upper-alpha':
				counterText = prepareAlpha(counter).toUpperCase();
				break;

			case 'lower-alpha':
				counterText = prepareAlpha(counter);
				break;

			case 'upper-roman':
				counterText = prepareRoman(counter);
				break;

			case 'lower-roman':
				counterText = prepareRoman(counter).toLowerCase();
				break;

			case 'decimal':
			default:
				counterText = prepareDecimal(counter);
				break;
		}

		if (counterText === null) {
			return {};
		}

		if (separator) {
			if (isArray(separator)) {
				if (separator[0]) {
					counterText = separator[0] + counterText;
				}

				if (separator[1]) {
					counterText += separator[1];
				}
				counterText += ' ';
			} else {
				counterText += separator + ' ';
			}
		}

		var textArray = {text: counterText};
		var markerColor = styleStack.getProperty('markerColor');
		if (markerColor) {
			textArray.color = markerColor;
		}

		return {_inlines: this.textTools.buildInlines(textArray, styleStack).items};
	};

	DocMeasure.prototype.measureUnorderedList = function (node) {
		var style = this.styleStack.clone();
		var items = node.ul;
		node.type = node.type || 'disc';
		node._gapSize = this.gapSizeForList();
		node._minWidth = 0;
		node._maxWidth = 0;

		for (var i = 0, l = items.length; i < l; i++) {
			var item = items[i] = this.measureNode(items[i]);

			if (!item.ol && !item.ul) {
				item.listMarker = this.buildUnorderedMarker(style, node._gapSize, item.listType || node.type);
			}

			node._minWidth = Math.max(node._minWidth, items[i]._minWidth + node._gapSize.width);
			node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth + node._gapSize.width);
		}

		return node;
	};

	DocMeasure.prototype.measureOrderedList = function (node) {
		var style = this.styleStack.clone();
		var items = node.ol;
		node.type = node.type || 'decimal';
		node.separator = node.separator || '.';
		node.reversed = node.reversed || false;
		if (!node.start) {
			node.start = node.reversed ? items.length : 1;
		}
		node._gapSize = this.gapSizeForList();
		node._minWidth = 0;
		node._maxWidth = 0;

		var counter = node.start;
		for (var i = 0, l = items.length; i < l; i++) {
			var item = items[i] = this.measureNode(items[i]);

			if (!item.ol && !item.ul) {
				item.listMarker = this.buildOrderedMarker(item.counter || counter, style, item.listType || node.type, node.separator);
				if (item.listMarker._inlines) {
					node._gapSize.width = Math.max(node._gapSize.width, item.listMarker._inlines[0].width);
				}
			}  // TODO: else - nested lists numbering

			node._minWidth = Math.max(node._minWidth, items[i]._minWidth);
			node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth);

			if (node.reversed) {
				counter--;
			} else {
				counter++;
			}
		}

		node._minWidth += node._gapSize.width;
		node._maxWidth += node._gapSize.width;

		for (var i = 0, l = items.length; i < l; i++) {
			var item = items[i];
			if (!item.ol && !item.ul) {
				item.listMarker._minWidth = item.listMarker._maxWidth = node._gapSize.width;
			}
		}

		return node;
	};

	DocMeasure.prototype.measureColumns = function (node) {
		var columns = node.columns;
		node._gap = this.styleStack.getProperty('columnGap') || 0;

		for (var i = 0, l = columns.length; i < l; i++) {
			columns[i] = this.measureNode(columns[i]);
		}

		var measures = ColumnCalculator.measureMinMax(columns);

		var numGaps = (columns.length > 0) ? (columns.length - 1) : 0;
		node._minWidth = measures.min + node._gap * numGaps;
		node._maxWidth = measures.max + node._gap * numGaps;

		return node;
	};

	DocMeasure.prototype.measureTable = function (node) {
		extendTableWidths(node);
		node._layout = getLayout(this.tableLayouts);
		node._offsets = getOffsets(node._layout);

		var colSpans = [];
		var col, row, cols, rows;

		for (col = 0, cols = node.table.body[0].length; col < cols; col++) {
			var c = node.table.widths[col];
			c._minWidth = 0;
			c._maxWidth = 0;

			for (row = 0, rows = node.table.body.length; row < rows; row++) {
				var rowData = node.table.body[row];
				var data = rowData[col];
				if (data === undefined) {
					console.error('Malformed table row ', rowData, 'in node ', node);
					throw 'Malformed table row, a cell is undefined.';
				}
				if (data === null) { // transform to object
					data = '';
				}

				if (!data._span) {
					data = rowData[col] = this.styleStack.auto(data, measureCb(this, data));

					if (data.colSpan && data.colSpan > 1) {
						markSpans(rowData, col, data.colSpan);
						colSpans.push({col: col, span: data.colSpan, minWidth: data._minWidth, maxWidth: data._maxWidth});
					} else {
						c._minWidth = Math.max(c._minWidth, data._minWidth);
						c._maxWidth = Math.max(c._maxWidth, data._maxWidth);
					}
				}

				if (data.rowSpan && data.rowSpan > 1) {
					markVSpans(node.table, row, col, data.rowSpan);
				}
			}
		}

		extendWidthsForColSpans();

		var measures = ColumnCalculator.measureMinMax(node.table.widths);

		node._minWidth = measures.min + node._offsets.total;
		node._maxWidth = measures.max + node._offsets.total;

		return node;

		function measureCb(_this, data) {
			return function () {
				if (isObject(data)) {
					data.fillColor = _this.styleStack.getProperty('fillColor');
				}
				return _this.measureNode(data);
			};
		}

		function getLayout(tableLayouts) {
			var layout = node.layout;

			if (isString(layout)) {
				layout = tableLayouts[layout];
			}

			/*jshint unused: false */
			var defaultLayout = {
				hLineWidth: function (i, node) {
					return 1;
				},
				vLineWidth: function (i, node) {
					return 1;
				},
				hLineColor: function (i, node) {
					return 'black';
				},
				vLineColor: function (i, node) {
					return 'black';
				},
				paddingLeft: function (i, node) {
					return 4;
				},
				paddingRight: function (i, node) {
					return 4;
				},
				paddingTop: function (i, node) {
					return 2;
				},
				paddingBottom: function (i, node) {
					return 2;
				},
				fillColor: function (i, node) {
					return null;
				},
				defaultBorder: true
			};

			return pack(defaultLayout, layout);
		}

		function getOffsets(layout) {
			var offsets = [];
			var totalOffset = 0;
			var prevRightPadding = 0;

			for (var i = 0, l = node.table.widths.length; i < l; i++) {
				var lOffset = prevRightPadding + layout.vLineWidth(i, node) + layout.paddingLeft(i, node);
				offsets.push(lOffset);
				totalOffset += lOffset;
				prevRightPadding = layout.paddingRight(i, node);
			}

			totalOffset += prevRightPadding + layout.vLineWidth(node.table.widths.length, node);

			return {
				total: totalOffset,
				offsets: offsets
			};
		}

		function extendWidthsForColSpans() {
			var q, j;

			for (var i = 0, l = colSpans.length; i < l; i++) {
				var span = colSpans[i];

				var currentMinMax = getMinMax(span.col, span.span, node._offsets);
				var minDifference = span.minWidth - currentMinMax.minWidth;
				var maxDifference = span.maxWidth - currentMinMax.maxWidth;

				if (minDifference > 0) {
					q = minDifference / span.span;

					for (j = 0; j < span.span; j++) {
						node.table.widths[span.col + j]._minWidth += q;
					}
				}

				if (maxDifference > 0) {
					q = maxDifference / span.span;

					for (j = 0; j < span.span; j++) {
						node.table.widths[span.col + j]._maxWidth += q;
					}
				}
			}
		}

		function getMinMax(col, span, offsets) {
			var result = {minWidth: 0, maxWidth: 0};

			for (var i = 0; i < span; i++) {
				result.minWidth += node.table.widths[col + i]._minWidth + (i ? offsets.offsets[col + i] : 0);
				result.maxWidth += node.table.widths[col + i]._maxWidth + (i ? offsets.offsets[col + i] : 0);
			}

			return result;
		}

		function markSpans(rowData, col, span) {
			for (var i = 1; i < span; i++) {
				rowData[col + i] = {
					_span: true,
					_minWidth: 0,
					_maxWidth: 0,
					rowSpan: rowData[col].rowSpan
				};
			}
		}

		function markVSpans(table, row, col, span) {
			for (var i = 1; i < span; i++) {
				table.body[row + i][col] = {
					_span: true,
					_minWidth: 0,
					_maxWidth: 0,
					fillColor: table.body[row][col].fillColor
				};
			}
		}

		function extendTableWidths(node) {
			if (!node.table.widths) {
				node.table.widths = 'auto';
			}

			if (isString(node.table.widths)) {
				node.table.widths = [node.table.widths];

				while (node.table.widths.length < node.table.body[0].length) {
					node.table.widths.push(node.table.widths[node.table.widths.length - 1]);
				}
			}

			for (var i = 0, l = node.table.widths.length; i < l; i++) {
				var w = node.table.widths[i];
				if (isNumber(w) || isString(w)) {
					node.table.widths[i] = {width: w};
				}
			}
		}
	};

	DocMeasure.prototype.measureCanvas = function (node) {
		var w = 0, h = 0;

		for (var i = 0, l = node.canvas.length; i < l; i++) {
			var vector = node.canvas[i];

			switch (vector.type) {
				case 'ellipse':
					w = Math.max(w, vector.x + vector.r1);
					h = Math.max(h, vector.y + vector.r2);
					break;
				case 'rect':
					w = Math.max(w, vector.x + vector.w);
					h = Math.max(h, vector.y + vector.h);
					break;
				case 'line':
					w = Math.max(w, vector.x1, vector.x2);
					h = Math.max(h, vector.y1, vector.y2);
					break;
				case 'polyline':
					for (var i2 = 0, l2 = vector.points.length; i2 < l2; i2++) {
						w = Math.max(w, vector.points[i2].x);
						h = Math.max(h, vector.points[i2].y);
					}
					break;
			}
		}

		node._minWidth = node._maxWidth = w;
		node._minHeight = node._maxHeight = h;
		node._alignment = this.styleStack.getProperty('alignment');

		return node;
	};

	DocMeasure.prototype.measureQr = function (node) {
		node = qrEncoder.measure(node);
		node._alignment = this.styleStack.getProperty('alignment');
		return node;
	};

	module.exports = DocMeasure;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var isString = __webpack_require__(8).isString;
	var isNumber = __webpack_require__(8).isNumber;
	var isObject = __webpack_require__(8).isObject;
	var isArray = __webpack_require__(8).isArray;
	var LineBreaker = __webpack_require__(14);

	var LEADING = /^(\s)+/g;
	var TRAILING = /(\s)+$/g;

	/**
	 * Creates an instance of TextTools - text measurement utility
	 *
	 * @constructor
	 * @param {FontProvider} fontProvider
	 */
	function TextTools(fontProvider) {
		this.fontProvider = fontProvider;
	}

	/**
	 * Converts an array of strings (or inline-definition-objects) into a collection
	 * of inlines and calculated minWidth/maxWidth.
	 * and their min/max widths
	 * @param  {Object} textArray - an array of inline-definition-objects (or strings)
	 * @param  {Object} styleContextStack current style stack
	 * @return {Object}                   collection of inlines, minWidth, maxWidth
	 */
	TextTools.prototype.buildInlines = function (textArray, styleContextStack) {
		var measured = measure(this.fontProvider, textArray, styleContextStack);

		var minWidth = 0,
			maxWidth = 0,
			currentLineWidth;

		measured.forEach(function (inline) {
			minWidth = Math.max(minWidth, inline.width - inline.leadingCut - inline.trailingCut);

			if (!currentLineWidth) {
				currentLineWidth = {width: 0, leadingCut: inline.leadingCut, trailingCut: 0};
			}

			currentLineWidth.width += inline.width;
			currentLineWidth.trailingCut = inline.trailingCut;

			maxWidth = Math.max(maxWidth, getTrimmedWidth(currentLineWidth));

			if (inline.lineEnd) {
				currentLineWidth = null;
			}
		});

		if (getStyleProperty({}, styleContextStack, 'noWrap', false)) {
			minWidth = maxWidth;
		}

		return {
			items: measured,
			minWidth: minWidth,
			maxWidth: maxWidth
		};

		function getTrimmedWidth(item) {
			return Math.max(0, item.width - item.leadingCut - item.trailingCut);
		}
	};

	/**
	 * Returns size of the specified string (without breaking it) using the current style
	 * @param  {String} text              text to be measured
	 * @param  {Object} styleContextStack current style stack
	 * @return {Object}                   size of the specified string
	 */
	TextTools.prototype.sizeOfString = function (text, styleContextStack) {
		text = text ? text.toString().replace(/\t/g, '    ') : '';

		//TODO: refactor - extract from measure
		var fontName = getStyleProperty({}, styleContextStack, 'font', 'Roboto');
		var fontSize = getStyleProperty({}, styleContextStack, 'fontSize', 12);
		var fontFeatures = getStyleProperty({}, styleContextStack, 'fontFeatures', null);
		var bold = getStyleProperty({}, styleContextStack, 'bold', false);
		var italics = getStyleProperty({}, styleContextStack, 'italics', false);
		var lineHeight = getStyleProperty({}, styleContextStack, 'lineHeight', 1);
		var characterSpacing = getStyleProperty({}, styleContextStack, 'characterSpacing', 0);

		var font = this.fontProvider.provideFont(fontName, bold, italics);

		return {
			width: widthOfString(text, font, fontSize, characterSpacing, fontFeatures),
			height: font.lineHeight(fontSize) * lineHeight,
			fontSize: fontSize,
			lineHeight: lineHeight,
			ascender: font.ascender / 1000 * fontSize,
			descender: font.descender / 1000 * fontSize
		};
	};

	TextTools.prototype.widthOfString = function (text, font, fontSize, characterSpacing, fontFeatures) {
		return widthOfString(text, font, fontSize, characterSpacing, fontFeatures);
	};

	function splitWords(text, noWrap) {
		var results = [];
		text = text.replace(/\t/g, '    ');

		if (noWrap) {
			results.push({text: text});
			return results;
		}

		var breaker = new LineBreaker(text);
		var last = 0;
		var bk;

		while (bk = breaker.nextBreak()) {
			var word = text.slice(last, bk.position);

			if (bk.required || word.match(/\r?\n$|\r$/)) { // new line
				word = word.replace(/\r?\n$|\r$/, '');
				results.push({text: word, lineEnd: true});
			} else {
				results.push({text: word});
			}

			last = bk.position;
		}

		return results;
	}

	function copyStyle(source, destination) {
		destination = destination || {};
		source = source || {}; //TODO: default style

		for (var key in source) {
			if (key != 'text' && source.hasOwnProperty(key)) {
				destination[key] = source[key];
			}
		}

		return destination;
	}

	function normalizeTextArray(array, styleContextStack) {
		function flatten(array) {
			return array.reduce(function (prev, cur) {
				var current = isArray(cur.text) ? flatten(cur.text) : cur;
				var more = [].concat(current).some(Array.isArray);
				return prev.concat(more ? flatten(current) : current);
			}, []);
		}

		var results = [];

		if (!isArray(array)) {
			array = [array];
		}

		array = flatten(array);

		for (var i = 0, l = array.length; i < l; i++) {
			var item = array[i];
			var style = null;
			var words;

			var noWrap = getStyleProperty(item || {}, styleContextStack, 'noWrap', false);
			if (isObject(item)) {
				words = splitWords(normalizeString(item.text), noWrap);
				style = copyStyle(item);
			} else {
				words = splitWords(normalizeString(item), noWrap);
			}

			for (var i2 = 0, l2 = words.length; i2 < l2; i2++) {
				var result = {
					text: words[i2].text
				};

				if (words[i2].lineEnd) {
					result.lineEnd = true;
				}

				copyStyle(style, result);

				results.push(result);
			}
		}

		return results;
	}

	function normalizeString(value) {
		if (value === undefined || value === null) {
			return '';
		} else if (isNumber(value)) {
			return value.toString();
		} else if (isString(value)) {
			return value;
		} else {
			return value.toString();
		}
	}

	function getStyleProperty(item, styleContextStack, property, defaultValue) {
		var value;

		if (item[property] !== undefined && item[property] !== null) {
			// item defines this property
			return item[property];
		}

		if (!styleContextStack) {
			return defaultValue;
		}

		styleContextStack.auto(item, function () {
			value = styleContextStack.getProperty(property);
		});

		if (value !== null && value !== undefined) {
			return value;
		} else {
			return defaultValue;
		}
	}

	function measure(fontProvider, textArray, styleContextStack) {
		var normalized = normalizeTextArray(textArray, styleContextStack);

		if (normalized.length) {
			var leadingIndent = getStyleProperty(normalized[0], styleContextStack, 'leadingIndent', 0);

			if (leadingIndent) {
				normalized[0].leadingCut = -leadingIndent;
				normalized[0].leadingIndent = leadingIndent;
			}
		}

		normalized.forEach(function (item) {
			var fontName = getStyleProperty(item, styleContextStack, 'font', 'Roboto');
			var fontSize = getStyleProperty(item, styleContextStack, 'fontSize', 12);
			var fontFeatures = getStyleProperty(item, styleContextStack, 'fontFeatures', null);
			var bold = getStyleProperty(item, styleContextStack, 'bold', false);
			var italics = getStyleProperty(item, styleContextStack, 'italics', false);
			var color = getStyleProperty(item, styleContextStack, 'color', 'black');
			var decoration = getStyleProperty(item, styleContextStack, 'decoration', null);
			var decorationColor = getStyleProperty(item, styleContextStack, 'decorationColor', null);
			var decorationStyle = getStyleProperty(item, styleContextStack, 'decorationStyle', null);
			var background = getStyleProperty(item, styleContextStack, 'background', null);
			var lineHeight = getStyleProperty(item, styleContextStack, 'lineHeight', 1);
			var characterSpacing = getStyleProperty(item, styleContextStack, 'characterSpacing', 0);
			var link = getStyleProperty(item, styleContextStack, 'link', null);
			var linkToPage = getStyleProperty(item, styleContextStack, 'linkToPage', null);
			var noWrap = getStyleProperty(item, styleContextStack, 'noWrap', null);
			var preserveLeadingSpaces = getStyleProperty(item, styleContextStack, 'preserveLeadingSpaces', false);

			var font = fontProvider.provideFont(fontName, bold, italics);

			item.width = widthOfString(item.text, font, fontSize, characterSpacing, fontFeatures);
			item.height = font.lineHeight(fontSize) * lineHeight;

			var leadingSpaces = item.text.match(LEADING);

			if (!item.leadingCut) {
				item.leadingCut = 0;
			}

			if (leadingSpaces && !preserveLeadingSpaces) {
				item.leadingCut += widthOfString(leadingSpaces[0], font, fontSize, characterSpacing, fontFeatures);
			}

			var trailingSpaces = item.text.match(TRAILING);
			if (trailingSpaces) {
				item.trailingCut = widthOfString(trailingSpaces[0], font, fontSize, characterSpacing, fontFeatures);
			} else {
				item.trailingCut = 0;
			}

			item.alignment = getStyleProperty(item, styleContextStack, 'alignment', 'left');
			item.font = font;
			item.fontSize = fontSize;
			item.fontFeatures = fontFeatures;
			item.characterSpacing = characterSpacing;
			item.color = color;
			item.decoration = decoration;
			item.decorationColor = decorationColor;
			item.decorationStyle = decorationStyle;
			item.background = background;
			item.link = link;
			item.linkToPage = linkToPage;
			item.noWrap = noWrap;
		});

		return normalized;
	}

	function widthOfString(text, font, fontSize, characterSpacing, fontFeatures) {
		return font.widthOfString(text, fontSize, fontFeatures) + ((characterSpacing || 0) * (text.length - 1));
	}

	/****TESTS**** (add a leading '/' to uncomment)
	 TextTools.prototype.splitWords = splitWords;
	 TextTools.prototype.normalizeTextArray = normalizeTextArray;
	 TextTools.prototype.measure = measure;
	 // */


	module.exports = TextTools;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.7.1
	(function() {
	  var AI, AL, BA, BK, CB, CI_BRK, CJ, CP_BRK, CR, DI_BRK, ID, IN_BRK, LF, LineBreaker, NL, NS, PR_BRK, SA, SG, SP, UnicodeTrie, WJ, XX, base64, characterClasses, classTrie, data, fs, pairTable, _ref, _ref1;

	  UnicodeTrie = __webpack_require__(15);

	  

	  base64 = __webpack_require__(17);

	  _ref = __webpack_require__(18), BK = _ref.BK, CR = _ref.CR, LF = _ref.LF, NL = _ref.NL, CB = _ref.CB, BA = _ref.BA, SP = _ref.SP, WJ = _ref.WJ, SP = _ref.SP, BK = _ref.BK, LF = _ref.LF, NL = _ref.NL, AI = _ref.AI, AL = _ref.AL, SA = _ref.SA, SG = _ref.SG, XX = _ref.XX, CJ = _ref.CJ, ID = _ref.ID, NS = _ref.NS, characterClasses = _ref.characterClasses;

	  _ref1 = __webpack_require__(19), DI_BRK = _ref1.DI_BRK, IN_BRK = _ref1.IN_BRK, CI_BRK = _ref1.CI_BRK, CP_BRK = _ref1.CP_BRK, PR_BRK = _ref1.PR_BRK, pairTable = _ref1.pairTable;

	  data = base64.toByteArray("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");

	  classTrie = new UnicodeTrie(data);

	  LineBreaker = (function() {
	    var Break, mapClass, mapFirst;

	    function LineBreaker(string) {
	      this.string = string;
	      this.pos = 0;
	      this.lastPos = 0;
	      this.curClass = null;
	      this.nextClass = null;
	    }

	    LineBreaker.prototype.nextCodePoint = function() {
	      var code, next;
	      code = this.string.charCodeAt(this.pos++);
	      next = this.string.charCodeAt(this.pos);
	      if ((0xd800 <= code && code <= 0xdbff) && (0xdc00 <= next && next <= 0xdfff)) {
	        this.pos++;
	        return ((code - 0xd800) * 0x400) + (next - 0xdc00) + 0x10000;
	      }
	      return code;
	    };

	    mapClass = function(c) {
	      switch (c) {
	        case AI:
	          return AL;
	        case SA:
	        case SG:
	        case XX:
	          return AL;
	        case CJ:
	          return NS;
	        default:
	          return c;
	      }
	    };

	    mapFirst = function(c) {
	      switch (c) {
	        case LF:
	        case NL:
	          return BK;
	        case CB:
	          return BA;
	        case SP:
	          return WJ;
	        default:
	          return c;
	      }
	    };

	    LineBreaker.prototype.nextCharClass = function(first) {
	      if (first == null) {
	        first = false;
	      }
	      return mapClass(classTrie.get(this.nextCodePoint()));
	    };

	    Break = (function() {
	      function Break(position, required) {
	        this.position = position;
	        this.required = required != null ? required : false;
	      }

	      return Break;

	    })();

	    LineBreaker.prototype.nextBreak = function() {
	      var cur, lastClass, shouldBreak;
	      if (this.curClass == null) {
	        this.curClass = mapFirst(this.nextCharClass());
	      }
	      while (this.pos < this.string.length) {
	        this.lastPos = this.pos;
	        lastClass = this.nextClass;
	        this.nextClass = this.nextCharClass();
	        if (this.curClass === BK || (this.curClass === CR && this.nextClass !== LF)) {
	          this.curClass = mapFirst(mapClass(this.nextClass));
	          return new Break(this.lastPos, true);
	        }
	        cur = (function() {
	          switch (this.nextClass) {
	            case SP:
	              return this.curClass;
	            case BK:
	            case LF:
	            case NL:
	              return BK;
	            case CR:
	              return CR;
	            case CB:
	              return BA;
	          }
	        }).call(this);
	        if (cur != null) {
	          this.curClass = cur;
	          if (this.nextClass === CB) {
	            return new Break(this.lastPos);
	          }
	          continue;
	        }
	        shouldBreak = false;
	        switch (pairTable[this.curClass][this.nextClass]) {
	          case DI_BRK:
	            shouldBreak = true;
	            break;
	          case IN_BRK:
	            shouldBreak = lastClass === SP;
	            break;
	          case CI_BRK:
	            shouldBreak = lastClass === SP;
	            if (!shouldBreak) {
	              continue;
	            }
	            break;
	          case CP_BRK:
	            if (lastClass !== SP) {
	              continue;
	            }
	        }
	        this.curClass = this.nextClass;
	        if (shouldBreak) {
	          return new Break(this.lastPos);
	        }
	      }
	      if (this.pos >= this.string.length) {
	        if (this.lastPos < this.string.length) {
	          this.lastPos = this.string.length;
	          return new Break(this.string.length);
	        } else {
	          return null;
	        }
	      }
	    };

	    return LineBreaker;

	  })();

	  module.exports = LineBreaker;

	}).call(this);


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.7.1
	var UnicodeTrie, inflate;

	inflate = __webpack_require__(16);

	UnicodeTrie = (function() {
	  var DATA_BLOCK_LENGTH, DATA_GRANULARITY, DATA_MASK, INDEX_1_OFFSET, INDEX_2_BLOCK_LENGTH, INDEX_2_BMP_LENGTH, INDEX_2_MASK, INDEX_SHIFT, LSCP_INDEX_2_LENGTH, LSCP_INDEX_2_OFFSET, OMITTED_BMP_INDEX_1_LENGTH, SHIFT_1, SHIFT_1_2, SHIFT_2, UTF8_2B_INDEX_2_LENGTH, UTF8_2B_INDEX_2_OFFSET;

	  SHIFT_1 = 6 + 5;

	  SHIFT_2 = 5;

	  SHIFT_1_2 = SHIFT_1 - SHIFT_2;

	  OMITTED_BMP_INDEX_1_LENGTH = 0x10000 >> SHIFT_1;

	  INDEX_2_BLOCK_LENGTH = 1 << SHIFT_1_2;

	  INDEX_2_MASK = INDEX_2_BLOCK_LENGTH - 1;

	  INDEX_SHIFT = 2;

	  DATA_BLOCK_LENGTH = 1 << SHIFT_2;

	  DATA_MASK = DATA_BLOCK_LENGTH - 1;

	  LSCP_INDEX_2_OFFSET = 0x10000 >> SHIFT_2;

	  LSCP_INDEX_2_LENGTH = 0x400 >> SHIFT_2;

	  INDEX_2_BMP_LENGTH = LSCP_INDEX_2_OFFSET + LSCP_INDEX_2_LENGTH;

	  UTF8_2B_INDEX_2_OFFSET = INDEX_2_BMP_LENGTH;

	  UTF8_2B_INDEX_2_LENGTH = 0x800 >> 6;

	  INDEX_1_OFFSET = UTF8_2B_INDEX_2_OFFSET + UTF8_2B_INDEX_2_LENGTH;

	  DATA_GRANULARITY = 1 << INDEX_SHIFT;

	  function UnicodeTrie(data) {
	    var isBuffer, uncompressedLength, view;
	    isBuffer = typeof data.readUInt32BE === 'function' && typeof data.slice === 'function';
	    if (isBuffer || data instanceof Uint8Array) {
	      if (isBuffer) {
	        this.highStart = data.readUInt32BE(0);
	        this.errorValue = data.readUInt32BE(4);
	        uncompressedLength = data.readUInt32BE(8);
	        data = data.slice(12);
	      } else {
	        view = new DataView(data.buffer);
	        this.highStart = view.getUint32(0);
	        this.errorValue = view.getUint32(4);
	        uncompressedLength = view.getUint32(8);
	        data = data.subarray(12);
	      }
	      data = inflate(data, new Uint8Array(uncompressedLength));
	      data = inflate(data, new Uint8Array(uncompressedLength));
	      this.data = new Uint32Array(data.buffer);
	    } else {
	      this.data = data.data, this.highStart = data.highStart, this.errorValue = data.errorValue;
	    }
	  }

	  UnicodeTrie.prototype.get = function(codePoint) {
	    var index;
	    if (codePoint < 0 || codePoint > 0x10ffff) {
	      return this.errorValue;
	    }
	    if (codePoint < 0xd800 || (codePoint > 0xdbff && codePoint <= 0xffff)) {
	      index = (this.data[codePoint >> SHIFT_2] << INDEX_SHIFT) + (codePoint & DATA_MASK);
	      return this.data[index];
	    }
	    if (codePoint <= 0xffff) {
	      index = (this.data[LSCP_INDEX_2_OFFSET + ((codePoint - 0xd800) >> SHIFT_2)] << INDEX_SHIFT) + (codePoint & DATA_MASK);
	      return this.data[index];
	    }
	    if (codePoint < this.highStart) {
	      index = this.data[(INDEX_1_OFFSET - OMITTED_BMP_INDEX_1_LENGTH) + (codePoint >> SHIFT_1)];
	      index = this.data[index + ((codePoint >> SHIFT_2) & INDEX_2_MASK)];
	      index = (index << INDEX_SHIFT) + (codePoint & DATA_MASK);
	      return this.data[index];
	    }
	    return this.data[this.data.length - DATA_GRANULARITY];
	  };

	  return UnicodeTrie;

	})();

	module.exports = UnicodeTrie;


/***/ }),
/* 16 */
/***/ (function(module, exports) {

	var TINF_OK = 0;
	var TINF_DATA_ERROR = -3;

	function Tree() {
	  this.table = new Uint16Array(16);   /* table of code length counts */
	  this.trans = new Uint16Array(288);  /* code -> symbol translation table */
	}

	function Data(source, dest) {
	  this.source = source;
	  this.sourceIndex = 0;
	  this.tag = 0;
	  this.bitcount = 0;
	  
	  this.dest = dest;
	  this.destLen = 0;
	  
	  this.ltree = new Tree();  /* dynamic length/symbol tree */
	  this.dtree = new Tree();  /* dynamic distance tree */
	}

	/* --------------------------------------------------- *
	 * -- uninitialized global data (static structures) -- *
	 * --------------------------------------------------- */

	var sltree = new Tree();
	var sdtree = new Tree();

	/* extra bits and base tables for length codes */
	var length_bits = new Uint8Array(30);
	var length_base = new Uint16Array(30);

	/* extra bits and base tables for distance codes */
	var dist_bits = new Uint8Array(30);
	var dist_base = new Uint16Array(30);

	/* special ordering of code length codes */
	var clcidx = new Uint8Array([
	  16, 17, 18, 0, 8, 7, 9, 6,
	  10, 5, 11, 4, 12, 3, 13, 2,
	  14, 1, 15
	]);

	/* used by tinf_decode_trees, avoids allocations every call */
	var code_tree = new Tree();
	var lengths = new Uint8Array(288 + 32);

	/* ----------------------- *
	 * -- utility functions -- *
	 * ----------------------- */

	/* build extra bits and base tables */
	function tinf_build_bits_base(bits, base, delta, first) {
	  var i, sum;

	  /* build bits table */
	  for (i = 0; i < delta; ++i) bits[i] = 0;
	  for (i = 0; i < 30 - delta; ++i) bits[i + delta] = i / delta | 0;

	  /* build base table */
	  for (sum = first, i = 0; i < 30; ++i) {
	    base[i] = sum;
	    sum += 1 << bits[i];
	  }
	}

	/* build the fixed huffman trees */
	function tinf_build_fixed_trees(lt, dt) {
	  var i;

	  /* build fixed length tree */
	  for (i = 0; i < 7; ++i) lt.table[i] = 0;

	  lt.table[7] = 24;
	  lt.table[8] = 152;
	  lt.table[9] = 112;

	  for (i = 0; i < 24; ++i) lt.trans[i] = 256 + i;
	  for (i = 0; i < 144; ++i) lt.trans[24 + i] = i;
	  for (i = 0; i < 8; ++i) lt.trans[24 + 144 + i] = 280 + i;
	  for (i = 0; i < 112; ++i) lt.trans[24 + 144 + 8 + i] = 144 + i;

	  /* build fixed distance tree */
	  for (i = 0; i < 5; ++i) dt.table[i] = 0;

	  dt.table[5] = 32;

	  for (i = 0; i < 32; ++i) dt.trans[i] = i;
	}

	/* given an array of code lengths, build a tree */
	var offs = new Uint16Array(16);

	function tinf_build_tree(t, lengths, off, num) {
	  var i, sum;

	  /* clear code length count table */
	  for (i = 0; i < 16; ++i) t.table[i] = 0;

	  /* scan symbol lengths, and sum code length counts */
	  for (i = 0; i < num; ++i) t.table[lengths[off + i]]++;

	  t.table[0] = 0;

	  /* compute offset table for distribution sort */
	  for (sum = 0, i = 0; i < 16; ++i) {
	    offs[i] = sum;
	    sum += t.table[i];
	  }

	  /* create code->symbol translation table (symbols sorted by code) */
	  for (i = 0; i < num; ++i) {
	    if (lengths[off + i]) t.trans[offs[lengths[off + i]]++] = i;
	  }
	}

	/* ---------------------- *
	 * -- decode functions -- *
	 * ---------------------- */

	/* get one bit from source stream */
	function tinf_getbit(d) {
	  /* check if tag is empty */
	  if (!d.bitcount--) {
	    /* load next tag */
	    d.tag = d.source[d.sourceIndex++];
	    d.bitcount = 7;
	  }

	  /* shift bit out of tag */
	  var bit = d.tag & 1;
	  d.tag >>>= 1;

	  return bit;
	}

	/* read a num bit value from a stream and add base */
	function tinf_read_bits(d, num, base) {
	  if (!num)
	    return base;

	  while (d.bitcount < 24) {
	    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
	    d.bitcount += 8;
	  }

	  var val = d.tag & (0xffff >>> (16 - num));
	  d.tag >>>= num;
	  d.bitcount -= num;
	  return val + base;
	}

	/* given a data stream and a tree, decode a symbol */
	function tinf_decode_symbol(d, t) {
	  while (d.bitcount < 24) {
	    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
	    d.bitcount += 8;
	  }
	  
	  var sum = 0, cur = 0, len = 0;
	  var tag = d.tag;

	  /* get more bits while code value is above sum */
	  do {
	    cur = 2 * cur + (tag & 1);
	    tag >>>= 1;
	    ++len;

	    sum += t.table[len];
	    cur -= t.table[len];
	  } while (cur >= 0);
	  
	  d.tag = tag;
	  d.bitcount -= len;

	  return t.trans[sum + cur];
	}

	/* given a data stream, decode dynamic trees from it */
	function tinf_decode_trees(d, lt, dt) {
	  var hlit, hdist, hclen;
	  var i, num, length;

	  /* get 5 bits HLIT (257-286) */
	  hlit = tinf_read_bits(d, 5, 257);

	  /* get 5 bits HDIST (1-32) */
	  hdist = tinf_read_bits(d, 5, 1);

	  /* get 4 bits HCLEN (4-19) */
	  hclen = tinf_read_bits(d, 4, 4);

	  for (i = 0; i < 19; ++i) lengths[i] = 0;

	  /* read code lengths for code length alphabet */
	  for (i = 0; i < hclen; ++i) {
	    /* get 3 bits code length (0-7) */
	    var clen = tinf_read_bits(d, 3, 0);
	    lengths[clcidx[i]] = clen;
	  }

	  /* build code length tree */
	  tinf_build_tree(code_tree, lengths, 0, 19);

	  /* decode code lengths for the dynamic trees */
	  for (num = 0; num < hlit + hdist;) {
	    var sym = tinf_decode_symbol(d, code_tree);

	    switch (sym) {
	      case 16:
	        /* copy previous code length 3-6 times (read 2 bits) */
	        var prev = lengths[num - 1];
	        for (length = tinf_read_bits(d, 2, 3); length; --length) {
	          lengths[num++] = prev;
	        }
	        break;
	      case 17:
	        /* repeat code length 0 for 3-10 times (read 3 bits) */
	        for (length = tinf_read_bits(d, 3, 3); length; --length) {
	          lengths[num++] = 0;
	        }
	        break;
	      case 18:
	        /* repeat code length 0 for 11-138 times (read 7 bits) */
	        for (length = tinf_read_bits(d, 7, 11); length; --length) {
	          lengths[num++] = 0;
	        }
	        break;
	      default:
	        /* values 0-15 represent the actual code lengths */
	        lengths[num++] = sym;
	        break;
	    }
	  }

	  /* build dynamic trees */
	  tinf_build_tree(lt, lengths, 0, hlit);
	  tinf_build_tree(dt, lengths, hlit, hdist);
	}

	/* ----------------------------- *
	 * -- block inflate functions -- *
	 * ----------------------------- */

	/* given a stream and two trees, inflate a block of data */
	function tinf_inflate_block_data(d, lt, dt) {
	  while (1) {
	    var sym = tinf_decode_symbol(d, lt);

	    /* check for end of block */
	    if (sym === 256) {
	      return TINF_OK;
	    }

	    if (sym < 256) {
	      d.dest[d.destLen++] = sym;
	    } else {
	      var length, dist, offs;
	      var i;

	      sym -= 257;

	      /* possibly get more bits from length code */
	      length = tinf_read_bits(d, length_bits[sym], length_base[sym]);

	      dist = tinf_decode_symbol(d, dt);

	      /* possibly get more bits from distance code */
	      offs = d.destLen - tinf_read_bits(d, dist_bits[dist], dist_base[dist]);

	      /* copy match */
	      for (i = offs; i < offs + length; ++i) {
	        d.dest[d.destLen++] = d.dest[i];
	      }
	    }
	  }
	}

	/* inflate an uncompressed block of data */
	function tinf_inflate_uncompressed_block(d) {
	  var length, invlength;
	  var i;
	  
	  /* unread from bitbuffer */
	  while (d.bitcount > 8) {
	    d.sourceIndex--;
	    d.bitcount -= 8;
	  }

	  /* get length */
	  length = d.source[d.sourceIndex + 1];
	  length = 256 * length + d.source[d.sourceIndex];

	  /* get one's complement of length */
	  invlength = d.source[d.sourceIndex + 3];
	  invlength = 256 * invlength + d.source[d.sourceIndex + 2];

	  /* check length */
	  if (length !== (~invlength & 0x0000ffff))
	    return TINF_DATA_ERROR;

	  d.sourceIndex += 4;

	  /* copy block */
	  for (i = length; i; --i)
	    d.dest[d.destLen++] = d.source[d.sourceIndex++];

	  /* make sure we start next block on a byte boundary */
	  d.bitcount = 0;

	  return TINF_OK;
	}

	/* inflate stream from source to dest */
	function tinf_uncompress(source, dest) {
	  var d = new Data(source, dest);
	  var bfinal, btype, res;

	  do {
	    /* read final block flag */
	    bfinal = tinf_getbit(d);

	    /* read block type (2 bits) */
	    btype = tinf_read_bits(d, 2, 0);

	    /* decompress block */
	    switch (btype) {
	      case 0:
	        /* decompress uncompressed block */
	        res = tinf_inflate_uncompressed_block(d);
	        break;
	      case 1:
	        /* decompress block with fixed huffman trees */
	        res = tinf_inflate_block_data(d, sltree, sdtree);
	        break;
	      case 2:
	        /* decompress block with dynamic huffman trees */
	        tinf_decode_trees(d, d.ltree, d.dtree);
	        res = tinf_inflate_block_data(d, d.ltree, d.dtree);
	        break;
	      default:
	        res = TINF_DATA_ERROR;
	    }

	    if (res !== TINF_OK)
	      throw new Error('Data error');

	  } while (!bfinal);

	  if (d.destLen < d.dest.length) {
	    if (typeof d.dest.slice === 'function')
	      return d.dest.slice(0, d.destLen);
	    else
	      return d.dest.subarray(0, d.destLen);
	  }
	  
	  return d.dest;
	}

	/* -------------------- *
	 * -- initialization -- *
	 * -------------------- */

	/* build fixed huffman trees */
	tinf_build_fixed_trees(sltree, sdtree);

	/* build extra bits and base tables */
	tinf_build_bits_base(length_bits, length_base, 4, 3);
	tinf_build_bits_base(dist_bits, dist_base, 2, 1);

	/* fix a special case */
	length_bits[28] = 0;
	length_base[28] = 258;

	module.exports = tinf_uncompress;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	var lookup = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

	;(function (exports) {
		'use strict';

	  var Arr = (typeof Uint8Array !== 'undefined')
	    ? Uint8Array
	    : Array

		var PLUS   = '+'.charCodeAt(0)
		var SLASH  = '/'.charCodeAt(0)
		var NUMBER = '0'.charCodeAt(0)
		var LOWER  = 'a'.charCodeAt(0)
		var UPPER  = 'A'.charCodeAt(0)
		var PLUS_URL_SAFE = '-'.charCodeAt(0)
		var SLASH_URL_SAFE = '_'.charCodeAt(0)

		function decode (elt) {
			var code = elt.charCodeAt(0)
			if (code === PLUS ||
			    code === PLUS_URL_SAFE)
				return 62 // '+'
			if (code === SLASH ||
			    code === SLASH_URL_SAFE)
				return 63 // '/'
			if (code < NUMBER)
				return -1 //no match
			if (code < NUMBER + 10)
				return code - NUMBER + 26 + 26
			if (code < UPPER + 26)
				return code - UPPER
			if (code < LOWER + 26)
				return code - LOWER + 26
		}

		function b64ToByteArray (b64) {
			var i, j, l, tmp, placeHolders, arr

			if (b64.length % 4 > 0) {
				throw new Error('Invalid string. Length must be a multiple of 4')
			}

			// the number of equal signs (place holders)
			// if there are two placeholders, than the two characters before it
			// represent one byte
			// if there is only one, then the three characters before it represent 2 bytes
			// this is just a cheap hack to not do indexOf twice
			var len = b64.length
			placeHolders = '=' === b64.charAt(len - 2) ? 2 : '=' === b64.charAt(len - 1) ? 1 : 0

			// base64 is 4/3 + up to two characters of the original data
			arr = new Arr(b64.length * 3 / 4 - placeHolders)

			// if there are placeholders, only get up to the last complete 4 chars
			l = placeHolders > 0 ? b64.length - 4 : b64.length

			var L = 0

			function push (v) {
				arr[L++] = v
			}

			for (i = 0, j = 0; i < l; i += 4, j += 3) {
				tmp = (decode(b64.charAt(i)) << 18) | (decode(b64.charAt(i + 1)) << 12) | (decode(b64.charAt(i + 2)) << 6) | decode(b64.charAt(i + 3))
				push((tmp & 0xFF0000) >> 16)
				push((tmp & 0xFF00) >> 8)
				push(tmp & 0xFF)
			}

			if (placeHolders === 2) {
				tmp = (decode(b64.charAt(i)) << 2) | (decode(b64.charAt(i + 1)) >> 4)
				push(tmp & 0xFF)
			} else if (placeHolders === 1) {
				tmp = (decode(b64.charAt(i)) << 10) | (decode(b64.charAt(i + 1)) << 4) | (decode(b64.charAt(i + 2)) >> 2)
				push((tmp >> 8) & 0xFF)
				push(tmp & 0xFF)
			}

			return arr
		}

		function uint8ToBase64 (uint8) {
			var i,
				extraBytes = uint8.length % 3, // if we have 1 byte left, pad 2 bytes
				output = "",
				temp, length

			function encode (num) {
				return lookup.charAt(num)
			}

			function tripletToBase64 (num) {
				return encode(num >> 18 & 0x3F) + encode(num >> 12 & 0x3F) + encode(num >> 6 & 0x3F) + encode(num & 0x3F)
			}

			// go through the array every three bytes, we'll deal with trailing stuff later
			for (i = 0, length = uint8.length - extraBytes; i < length; i += 3) {
				temp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
				output += tripletToBase64(temp)
			}

			// pad the end with zeros, but make sure to not forget the extra bytes
			switch (extraBytes) {
				case 1:
					temp = uint8[uint8.length - 1]
					output += encode(temp >> 2)
					output += encode((temp << 4) & 0x3F)
					output += '=='
					break
				case 2:
					temp = (uint8[uint8.length - 2] << 8) + (uint8[uint8.length - 1])
					output += encode(temp >> 10)
					output += encode((temp >> 4) & 0x3F)
					output += encode((temp << 2) & 0x3F)
					output += '='
					break
			}

			return output
		}

		exports.toByteArray = b64ToByteArray
		exports.fromByteArray = uint8ToBase64
	}( false ? (this.base64js = {}) : exports))


/***/ }),
/* 18 */
/***/ (function(module, exports) {

	// Generated by CoffeeScript 1.7.1
	(function() {
	  var AI, AL, B2, BA, BB, BK, CB, CJ, CL, CM, CP, CR, EX, GL, H2, H3, HL, HY, ID, IN, IS, JL, JT, JV, LF, NL, NS, NU, OP, PO, PR, QU, RI, SA, SG, SP, SY, WJ, XX, ZW;

	  exports.OP = OP = 0;

	  exports.CL = CL = 1;

	  exports.CP = CP = 2;

	  exports.QU = QU = 3;

	  exports.GL = GL = 4;

	  exports.NS = NS = 5;

	  exports.EX = EX = 6;

	  exports.SY = SY = 7;

	  exports.IS = IS = 8;

	  exports.PR = PR = 9;

	  exports.PO = PO = 10;

	  exports.NU = NU = 11;

	  exports.AL = AL = 12;

	  exports.HL = HL = 13;

	  exports.ID = ID = 14;

	  exports.IN = IN = 15;

	  exports.HY = HY = 16;

	  exports.BA = BA = 17;

	  exports.BB = BB = 18;

	  exports.B2 = B2 = 19;

	  exports.ZW = ZW = 20;

	  exports.CM = CM = 21;

	  exports.WJ = WJ = 22;

	  exports.H2 = H2 = 23;

	  exports.H3 = H3 = 24;

	  exports.JL = JL = 25;

	  exports.JV = JV = 26;

	  exports.JT = JT = 27;

	  exports.RI = RI = 28;

	  exports.AI = AI = 29;

	  exports.BK = BK = 30;

	  exports.CB = CB = 31;

	  exports.CJ = CJ = 32;

	  exports.CR = CR = 33;

	  exports.LF = LF = 34;

	  exports.NL = NL = 35;

	  exports.SA = SA = 36;

	  exports.SG = SG = 37;

	  exports.SP = SP = 38;

	  exports.XX = XX = 39;

	}).call(this);


/***/ }),
/* 19 */
/***/ (function(module, exports) {

	// Generated by CoffeeScript 1.7.1
	(function() {
	  var CI_BRK, CP_BRK, DI_BRK, IN_BRK, PR_BRK;

	  exports.DI_BRK = DI_BRK = 0;

	  exports.IN_BRK = IN_BRK = 1;

	  exports.CI_BRK = CI_BRK = 2;

	  exports.CP_BRK = CP_BRK = 3;

	  exports.PR_BRK = PR_BRK = 4;

	  exports.pairTable = [[PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, CP_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, DI_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, DI_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, PR_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK]];

	}).call(this);


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var isString = __webpack_require__(8).isString;
	var isArray = __webpack_require__(8).isArray;

	/**
	 * Creates an instance of StyleContextStack used for style inheritance and style overrides
	 *
	 * @constructor
	 * @this {StyleContextStack}
	 * @param {Object} named styles dictionary
	 * @param {Object} optional default style definition
	 */
	function StyleContextStack(styleDictionary, defaultStyle) {
		this.defaultStyle = defaultStyle || {};
		this.styleDictionary = styleDictionary;
		this.styleOverrides = [];
	}

	/**
	 * Creates cloned version of current stack
	 * @return {StyleContextStack} current stack snapshot
	 */
	StyleContextStack.prototype.clone = function () {
		var stack = new StyleContextStack(this.styleDictionary, this.defaultStyle);

		this.styleOverrides.forEach(function (item) {
			stack.styleOverrides.push(item);
		});

		return stack;
	};

	/**
	 * Pushes style-name or style-overrides-object onto the stack for future evaluation
	 *
	 * @param {String|Object} styleNameOrOverride style-name (referring to styleDictionary) or
	 *                                            a new dictionary defining overriding properties
	 */
	StyleContextStack.prototype.push = function (styleNameOrOverride) {
		this.styleOverrides.push(styleNameOrOverride);
	};

	/**
	 * Removes last style-name or style-overrides-object from the stack
	 *
	 * @param {Number} howMany - optional number of elements to be popped (if not specified,
	 *                           one element will be removed from the stack)
	 */
	StyleContextStack.prototype.pop = function (howMany) {
		howMany = howMany || 1;

		while (howMany-- > 0) {
			this.styleOverrides.pop();
		}
	};

	/**
	 * Creates a set of named styles or/and a style-overrides-object based on the item,
	 * pushes those elements onto the stack for future evaluation and returns the number
	 * of elements pushed, so they can be easily poped then.
	 *
	 * @param {Object} item - an object with optional style property and/or style overrides
	 * @return the number of items pushed onto the stack
	 */
	StyleContextStack.prototype.autopush = function (item) {
		if (isString(item)) {
			return 0;
		}

		var styleNames = [];

		if (item.style) {
			if (isArray(item.style)) {
				styleNames = item.style;
			} else {
				styleNames = [item.style];
			}
		}

		for (var i = 0, l = styleNames.length; i < l; i++) {
			this.push(styleNames[i]);
		}

		var styleOverrideObject = {};
		var pushSOO = false;

		[
			'font',
			'fontSize',
			'fontFeatures',
			'bold',
			'italics',
			'alignment',
			'color',
			'columnGap',
			'fillColor',
			'decoration',
			'decorationStyle',
			'decorationColor',
			'background',
			'lineHeight',
			'characterSpacing',
			'noWrap',
			'markerColor',
			'leadingIndent'
				//'tableCellPadding'
				// 'cellBorder',
				// 'headerCellBorder',
				// 'oddRowCellBorder',
				// 'evenRowCellBorder',
				// 'tableBorder'
		].forEach(function (key) {
			if (item[key] !== undefined && item[key] !== null) {
				styleOverrideObject[key] = item[key];
				pushSOO = true;
			}
		});

		if (pushSOO) {
			this.push(styleOverrideObject);
		}

		return styleNames.length + (pushSOO ? 1 : 0);
	};

	/**
	 * Automatically pushes elements onto the stack, using autopush based on item,
	 * executes callback and then pops elements back. Returns value returned by callback
	 *
	 * @param  {Object}   item - an object with optional style property and/or style overrides
	 * @param  {Function} function to be called between autopush and pop
	 * @return {Object} value returned by callback
	 */
	StyleContextStack.prototype.auto = function (item, callback) {
		var pushedItems = this.autopush(item);
		var result = callback();

		if (pushedItems > 0) {
			this.pop(pushedItems);
		}

		return result;
	};

	/**
	 * Evaluates stack and returns value of a named property
	 *
	 * @param {String} property - property name
	 * @return property value or null if not found
	 */
	StyleContextStack.prototype.getProperty = function (property) {
		if (this.styleOverrides) {
			for (var i = this.styleOverrides.length - 1; i >= 0; i--) {
				var item = this.styleOverrides[i];

				if (isString(item)) {
					// named-style-override

					var style = this.styleDictionary[item];
					if (style && style[property] !== null && style[property] !== undefined) {
						return style[property];
					}
				} else {
					// style-overrides-object
					if (item[property] !== undefined && item[property] !== null) {
						return item[property];
					}
				}
			}
		}

		return this.defaultStyle && this.defaultStyle[property];
	};

	module.exports = StyleContextStack;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var isString = __webpack_require__(8).isString;

	function buildColumnWidths(columns, availableWidth) {
		var autoColumns = [],
			autoMin = 0, autoMax = 0,
			starColumns = [],
			starMaxMin = 0,
			starMaxMax = 0,
			fixedColumns = [],
			initial_availableWidth = availableWidth;

		columns.forEach(function (column) {
			if (isAutoColumn(column)) {
				autoColumns.push(column);
				autoMin += column._minWidth;
				autoMax += column._maxWidth;
			} else if (isStarColumn(column)) {
				starColumns.push(column);
				starMaxMin = Math.max(starMaxMin, column._minWidth);
				starMaxMax = Math.max(starMaxMax, column._maxWidth);
			} else {
				fixedColumns.push(column);
			}
		});

		fixedColumns.forEach(function (col) {
			// width specified as %
			if (isString(col.width) && /\d+%/.test(col.width)) {
				col.width = parseFloat(col.width) * initial_availableWidth / 100;
			}
			if (col.width < (col._minWidth) && col.elasticWidth) {
				col._calcWidth = col._minWidth;
			} else {
				col._calcWidth = col.width;
			}

			availableWidth -= col._calcWidth;
		});

		// http://www.freesoft.org/CIE/RFC/1942/18.htm
		// http://www.w3.org/TR/CSS2/tables.html#width-layout
		// http://dev.w3.org/csswg/css3-tables-algorithms/Overview.src.htm
		var minW = autoMin + starMaxMin * starColumns.length;
		var maxW = autoMax + starMaxMax * starColumns.length;
		if (minW >= availableWidth) {
			// case 1 - there's no way to fit all columns within available width
			// that's actually pretty bad situation with PDF as we have no horizontal scroll
			// no easy workaround (unless we decide, in the future, to split single words)
			// currently we simply use minWidths for all columns
			autoColumns.forEach(function (col) {
				col._calcWidth = col._minWidth;
			});

			starColumns.forEach(function (col) {
				col._calcWidth = starMaxMin; // starMaxMin already contains padding
			});
		} else {
			if (maxW < availableWidth) {
				// case 2 - we can fit rest of the table within available space
				autoColumns.forEach(function (col) {
					col._calcWidth = col._maxWidth;
					availableWidth -= col._calcWidth;
				});
			} else {
				// maxW is too large, but minW fits within available width
				var W = availableWidth - minW;
				var D = maxW - minW;

				autoColumns.forEach(function (col) {
					var d = col._maxWidth - col._minWidth;
					col._calcWidth = col._minWidth + d * W / D;
					availableWidth -= col._calcWidth;
				});
			}

			if (starColumns.length > 0) {
				var starSize = availableWidth / starColumns.length;

				starColumns.forEach(function (col) {
					col._calcWidth = starSize;
				});
			}
		}
	}

	function isAutoColumn(column) {
		return column.width === 'auto';
	}

	function isStarColumn(column) {
		return column.width === null || column.width === undefined || column.width === '*' || column.width === 'star';
	}

	//TODO: refactor and reuse in measureTable
	function measureMinMax(columns) {
		var result = {min: 0, max: 0};

		var maxStar = {min: 0, max: 0};
		var starCount = 0;

		for (var i = 0, l = columns.length; i < l; i++) {
			var c = columns[i];

			if (isStarColumn(c)) {
				maxStar.min = Math.max(maxStar.min, c._minWidth);
				maxStar.max = Math.max(maxStar.max, c._maxWidth);
				starCount++;
			} else if (isAutoColumn(c)) {
				result.min += c._minWidth;
				result.max += c._maxWidth;
			} else {
				result.min += ((c.width !== undefined && c.width) || c._minWidth);
				result.max += ((c.width !== undefined && c.width) || c._maxWidth);
			}
		}

		if (starCount) {
			result.min += starCount * maxStar.min;
			result.max += starCount * maxStar.max;
		}

		return result;
	}

	/**
	 * Calculates column widths
	 * @private
	 */
	module.exports = {
		buildColumnWidths: buildColumnWidths,
		measureMinMax: measureMinMax,
		isAutoColumn: isAutoColumn,
		isStarColumn: isStarColumn
	};


/***/ }),
/* 22 */
/***/ (function(module, exports) {

	/* jslint node: true */
	'use strict';
	/*jshint -W004 */
	/* qr.js -- QR code generator in Javascript (revision 2011-01-19)
	 * Written by Kang Seonghoon <public+qrjs@mearie.org>.
	 *
	 * This source code is in the public domain; if your jurisdiction does not
	 * recognize the public domain the terms of Creative Commons CC0 license
	 * apply. In the other words, you can always do what you want.
	 */


	// per-version information (cf. JIS X 0510:2004 pp. 30--36, 71)
	//
	// [0]: the degree of generator polynomial by ECC levels
	// [1]: # of code blocks by ECC levels
	// [2]: left-top positions of alignment patterns
	//
	// the number in this table (in particular, [0]) does not exactly match with
	// the numbers in the specficiation. see augumenteccs below for the reason.
	var VERSIONS = [
		null,
		[[10, 7, 17, 13], [1, 1, 1, 1], []],
		[[16, 10, 28, 22], [1, 1, 1, 1], [4, 16]],
		[[26, 15, 22, 18], [1, 1, 2, 2], [4, 20]],
		[[18, 20, 16, 26], [2, 1, 4, 2], [4, 24]],
		[[24, 26, 22, 18], [2, 1, 4, 4], [4, 28]],
		[[16, 18, 28, 24], [4, 2, 4, 4], [4, 32]],
		[[18, 20, 26, 18], [4, 2, 5, 6], [4, 20, 36]],
		[[22, 24, 26, 22], [4, 2, 6, 6], [4, 22, 40]],
		[[22, 30, 24, 20], [5, 2, 8, 8], [4, 24, 44]],
		[[26, 18, 28, 24], [5, 4, 8, 8], [4, 26, 48]],
		[[30, 20, 24, 28], [5, 4, 11, 8], [4, 28, 52]],
		[[22, 24, 28, 26], [8, 4, 11, 10], [4, 30, 56]],
		[[22, 26, 22, 24], [9, 4, 16, 12], [4, 32, 60]],
		[[24, 30, 24, 20], [9, 4, 16, 16], [4, 24, 44, 64]],
		[[24, 22, 24, 30], [10, 6, 18, 12], [4, 24, 46, 68]],
		[[28, 24, 30, 24], [10, 6, 16, 17], [4, 24, 48, 72]],
		[[28, 28, 28, 28], [11, 6, 19, 16], [4, 28, 52, 76]],
		[[26, 30, 28, 28], [13, 6, 21, 18], [4, 28, 54, 80]],
		[[26, 28, 26, 26], [14, 7, 25, 21], [4, 28, 56, 84]],
		[[26, 28, 28, 30], [16, 8, 25, 20], [4, 32, 60, 88]],
		[[26, 28, 30, 28], [17, 8, 25, 23], [4, 26, 48, 70, 92]],
		[[28, 28, 24, 30], [17, 9, 34, 23], [4, 24, 48, 72, 96]],
		[[28, 30, 30, 30], [18, 9, 30, 25], [4, 28, 52, 76, 100]],
		[[28, 30, 30, 30], [20, 10, 32, 27], [4, 26, 52, 78, 104]],
		[[28, 26, 30, 30], [21, 12, 35, 29], [4, 30, 56, 82, 108]],
		[[28, 28, 30, 28], [23, 12, 37, 34], [4, 28, 56, 84, 112]],
		[[28, 30, 30, 30], [25, 12, 40, 34], [4, 32, 60, 88, 116]],
		[[28, 30, 30, 30], [26, 13, 42, 35], [4, 24, 48, 72, 96, 120]],
		[[28, 30, 30, 30], [28, 14, 45, 38], [4, 28, 52, 76, 100, 124]],
		[[28, 30, 30, 30], [29, 15, 48, 40], [4, 24, 50, 76, 102, 128]],
		[[28, 30, 30, 30], [31, 16, 51, 43], [4, 28, 54, 80, 106, 132]],
		[[28, 30, 30, 30], [33, 17, 54, 45], [4, 32, 58, 84, 110, 136]],
		[[28, 30, 30, 30], [35, 18, 57, 48], [4, 28, 56, 84, 112, 140]],
		[[28, 30, 30, 30], [37, 19, 60, 51], [4, 32, 60, 88, 116, 144]],
		[[28, 30, 30, 30], [38, 19, 63, 53], [4, 28, 52, 76, 100, 124, 148]],
		[[28, 30, 30, 30], [40, 20, 66, 56], [4, 22, 48, 74, 100, 126, 152]],
		[[28, 30, 30, 30], [43, 21, 70, 59], [4, 26, 52, 78, 104, 130, 156]],
		[[28, 30, 30, 30], [45, 22, 74, 62], [4, 30, 56, 82, 108, 134, 160]],
		[[28, 30, 30, 30], [47, 24, 77, 65], [4, 24, 52, 80, 108, 136, 164]],
		[[28, 30, 30, 30], [49, 25, 81, 68], [4, 28, 56, 84, 112, 140, 168]]];

	// mode constants (cf. Table 2 in JIS X 0510:2004 p. 16)
	var MODE_TERMINATOR = 0;
	var MODE_NUMERIC = 1, MODE_ALPHANUMERIC = 2, MODE_OCTET = 4, MODE_KANJI = 8;

	// validation regexps
	var NUMERIC_REGEXP = /^\d*$/;
	var ALPHANUMERIC_REGEXP = /^[A-Za-z0-9 $%*+\-./:]*$/;
	var ALPHANUMERIC_OUT_REGEXP = /^[A-Z0-9 $%*+\-./:]*$/;

	// ECC levels (cf. Table 22 in JIS X 0510:2004 p. 45)
	var ECCLEVEL_L = 1, ECCLEVEL_M = 0, ECCLEVEL_Q = 3, ECCLEVEL_H = 2;

	// GF(2^8)-to-integer mapping with a reducing polynomial x^8+x^4+x^3+x^2+1
	// invariant: GF256_MAP[GF256_INVMAP[i]] == i for all i in [1,256)
	var GF256_MAP = [], GF256_INVMAP = [-1];
	for (var i = 0, v = 1; i < 255; ++i) {
		GF256_MAP.push(v);
		GF256_INVMAP[v] = i;
		v = (v * 2) ^ (v >= 128 ? 0x11d : 0);
	}

	// generator polynomials up to degree 30
	// (should match with polynomials in JIS X 0510:2004 Appendix A)
	//
	// generator polynomial of degree K is product of (x-\alpha^0), (x-\alpha^1),
	// ..., (x-\alpha^(K-1)). by convention, we omit the K-th coefficient (always 1)
	// from the result; also other coefficients are written in terms of the exponent
	// to \alpha to avoid the redundant calculation. (see also calculateecc below.)
	var GF256_GENPOLY = [[]];
	for (var i = 0; i < 30; ++i) {
		var prevpoly = GF256_GENPOLY[i], poly = [];
		for (var j = 0; j <= i; ++j) {
			var a = (j < i ? GF256_MAP[prevpoly[j]] : 0);
			var b = GF256_MAP[(i + (prevpoly[j - 1] || 0)) % 255];
			poly.push(GF256_INVMAP[a ^ b]);
		}
		GF256_GENPOLY.push(poly);
	}

	// alphanumeric character mapping (cf. Table 5 in JIS X 0510:2004 p. 19)
	var ALPHANUMERIC_MAP = {};
	for (var i = 0; i < 45; ++i) {
		ALPHANUMERIC_MAP['0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:'.charAt(i)] = i;
	}

	// mask functions in terms of row # and column #
	// (cf. Table 20 in JIS X 0510:2004 p. 42)
	/*jshint unused: false */
	var MASKFUNCS = [
		function (i, j) {
			return (i + j) % 2 === 0;
		},
		function (i, j) {
			return i % 2 === 0;
		},
		function (i, j) {
			return j % 3 === 0;
		},
		function (i, j) {
			return (i + j) % 3 === 0;
		},
		function (i, j) {
			return (((i / 2) | 0) + ((j / 3) | 0)) % 2 === 0;
		},
		function (i, j) {
			return (i * j) % 2 + (i * j) % 3 === 0;
		},
		function (i, j) {
			return ((i * j) % 2 + (i * j) % 3) % 2 === 0;
		},
		function (i, j) {
			return ((i + j) % 2 + (i * j) % 3) % 2 === 0;
		}];

	// returns true when the version information has to be embeded.
	var needsverinfo = function (ver) {
		return ver > 6;
	};

	// returns the size of entire QR code for given version.
	var getsizebyver = function (ver) {
		return 4 * ver + 17;
	};

	// returns the number of bits available for code words in this version.
	var nfullbits = function (ver) {
		/*
		 * |<--------------- n --------------->|
		 * |        |<----- n-17 ---->|        |
		 * +-------+                ///+-------+ ----
		 * |       |                ///|       |    ^
		 * |  9x9  |       @@@@@    ///|  9x8  |    |
		 * |       | # # # @5x5@ # # # |       |    |
		 * +-------+       @@@@@       +-------+    |
		 *       #                               ---|
		 *                                        ^ |
		 *       #                                |
		 *     @@@@@       @@@@@       @@@@@      | n
		 *     @5x5@       @5x5@       @5x5@   n-17
		 *     @@@@@       @@@@@       @@@@@      | |
		 *       #                                | |
		 * //////                                 v |
		 * //////#                               ---|
		 * +-------+       @@@@@       @@@@@        |
		 * |       |       @5x5@       @5x5@        |
		 * |  8x9  |       @@@@@       @@@@@        |
		 * |       |                                v
		 * +-------+                             ----
		 *
		 * when the entire code has n^2 modules and there are m^2-3 alignment
		 * patterns, we have:
		 * - 225 (= 9x9 + 9x8 + 8x9) modules for finder patterns and
		 *   format information;
		 * - 2n-34 (= 2(n-17)) modules for timing patterns;
		 * - 36 (= 3x6 + 6x3) modules for version information, if any;
		 * - 25m^2-75 (= (m^2-3)(5x5)) modules for alignment patterns
		 *   if any, but 10m-20 (= 2(m-2)x5) of them overlaps with
		 *   timing patterns.
		 */
		var v = VERSIONS[ver];
		var nbits = 16 * ver * ver + 128 * ver + 64; // finder, timing and format info.
		if (needsverinfo(ver))
			nbits -= 36; // version information
		if (v[2].length) { // alignment patterns
			nbits -= 25 * v[2].length * v[2].length - 10 * v[2].length - 55;
		}
		return nbits;
	};

	// returns the number of bits available for data portions (i.e. excludes ECC
	// bits but includes mode and length bits) in this version and ECC level.
	var ndatabits = function (ver, ecclevel) {
		var nbits = nfullbits(ver) & ~7; // no sub-octet code words
		var v = VERSIONS[ver];
		nbits -= 8 * v[0][ecclevel] * v[1][ecclevel]; // ecc bits
		return nbits;
	};

	// returns the number of bits required for the length of data.
	// (cf. Table 3 in JIS X 0510:2004 p. 16)
	var ndatalenbits = function (ver, mode) {
		switch (mode) {
			case MODE_NUMERIC:
				return (ver < 10 ? 10 : ver < 27 ? 12 : 14);
			case MODE_ALPHANUMERIC:
				return (ver < 10 ? 9 : ver < 27 ? 11 : 13);
			case MODE_OCTET:
				return (ver < 10 ? 8 : 16);
			case MODE_KANJI:
				return (ver < 10 ? 8 : ver < 27 ? 10 : 12);
		}
	};

	// returns the maximum length of data possible in given configuration.
	var getmaxdatalen = function (ver, mode, ecclevel) {
		var nbits = ndatabits(ver, ecclevel) - 4 - ndatalenbits(ver, mode); // 4 for mode bits
		switch (mode) {
			case MODE_NUMERIC:
				return ((nbits / 10) | 0) * 3 + (nbits % 10 < 4 ? 0 : nbits % 10 < 7 ? 1 : 2);
			case MODE_ALPHANUMERIC:
				return ((nbits / 11) | 0) * 2 + (nbits % 11 < 6 ? 0 : 1);
			case MODE_OCTET:
				return (nbits / 8) | 0;
			case MODE_KANJI:
				return (nbits / 13) | 0;
		}
	};

	// checks if the given data can be encoded in given mode, and returns
	// the converted data for the further processing if possible. otherwise
	// returns null.
	//
	// this function does not check the length of data; it is a duty of
	// encode function below (as it depends on the version and ECC level too).
	var validatedata = function (mode, data) {
		switch (mode) {
			case MODE_NUMERIC:
				if (!data.match(NUMERIC_REGEXP))
					return null;
				return data;

			case MODE_ALPHANUMERIC:
				if (!data.match(ALPHANUMERIC_REGEXP))
					return null;
				return data.toUpperCase();

			case MODE_OCTET:
				if (typeof data === 'string') { // encode as utf-8 string
					var newdata = [];
					for (var i = 0; i < data.length; ++i) {
						var ch = data.charCodeAt(i);
						if (ch < 0x80) {
							newdata.push(ch);
						} else if (ch < 0x800) {
							newdata.push(0xc0 | (ch >> 6),
								0x80 | (ch & 0x3f));
						} else if (ch < 0x10000) {
							newdata.push(0xe0 | (ch >> 12),
								0x80 | ((ch >> 6) & 0x3f),
								0x80 | (ch & 0x3f));
						} else {
							newdata.push(0xf0 | (ch >> 18),
								0x80 | ((ch >> 12) & 0x3f),
								0x80 | ((ch >> 6) & 0x3f),
								0x80 | (ch & 0x3f));
						}
					}
					return newdata;
				} else {
					return data;
				}
		}
	};

	// returns the code words (sans ECC bits) for given data and configurations.
	// requires data to be preprocessed by validatedata. no length check is
	// performed, and everything has to be checked before calling this function.
	var encode = function (ver, mode, data, maxbuflen) {
		var buf = [];
		var bits = 0, remaining = 8;
		var datalen = data.length;

		// this function is intentionally no-op when n=0.
		var pack = function (x, n) {
			if (n >= remaining) {
				buf.push(bits | (x >> (n -= remaining)));
				while (n >= 8)
					buf.push((x >> (n -= 8)) & 255);
				bits = 0;
				remaining = 8;
			}
			if (n > 0)
				bits |= (x & ((1 << n) - 1)) << (remaining -= n);
		};

		var nlenbits = ndatalenbits(ver, mode);
		pack(mode, 4);
		pack(datalen, nlenbits);

		switch (mode) {
			case MODE_NUMERIC:
				for (var i = 2; i < datalen; i += 3) {
					pack(parseInt(data.substring(i - 2, i + 1), 10), 10);
				}
				pack(parseInt(data.substring(i - 2), 10), [0, 4, 7][datalen % 3]);
				break;

			case MODE_ALPHANUMERIC:
				for (var i = 1; i < datalen; i += 2) {
					pack(ALPHANUMERIC_MAP[data.charAt(i - 1)] * 45 +
						ALPHANUMERIC_MAP[data.charAt(i)], 11);
				}
				if (datalen % 2 == 1) {
					pack(ALPHANUMERIC_MAP[data.charAt(i - 1)], 6);
				}
				break;

			case MODE_OCTET:
				for (var i = 0; i < datalen; ++i) {
					pack(data[i], 8);
				}
				break;
		}

		// final bits. it is possible that adding terminator causes the buffer
		// to overflow, but then the buffer truncated to the maximum size will
		// be valid as the truncated terminator mode bits and padding is
		// identical in appearance (cf. JIS X 0510:2004 sec 8.4.8).
		pack(MODE_TERMINATOR, 4);
		if (remaining < 8)
			buf.push(bits);

		// the padding to fill up the remaining space. we should not add any
		// words when the overflow already occurred.
		while (buf.length + 1 < maxbuflen)
			buf.push(0xec, 0x11);
		if (buf.length < maxbuflen)
			buf.push(0xec);
		return buf;
	};

	// calculates ECC code words for given code words and generator polynomial.
	//
	// this is quite similar to CRC calculation as both Reed-Solomon and CRC use
	// the certain kind of cyclic codes, which is effectively the division of
	// zero-augumented polynomial by the generator polynomial. the only difference
	// is that Reed-Solomon uses GF(2^8), instead of CRC's GF(2), and Reed-Solomon
	// uses the different generator polynomial than CRC's.
	var calculateecc = function (poly, genpoly) {
		var modulus = poly.slice(0);
		var polylen = poly.length, genpolylen = genpoly.length;
		for (var i = 0; i < genpolylen; ++i)
			modulus.push(0);
		for (var i = 0; i < polylen; ) {
			var quotient = GF256_INVMAP[modulus[i++]];
			if (quotient >= 0) {
				for (var j = 0; j < genpolylen; ++j) {
					modulus[i + j] ^= GF256_MAP[(quotient + genpoly[j]) % 255];
				}
			}
		}
		return modulus.slice(polylen);
	};

	// auguments ECC code words to given code words. the resulting words are
	// ready to be encoded in the matrix.
	//
	// the much of actual augumenting procedure follows JIS X 0510:2004 sec 8.7.
	// the code is simplified using the fact that the size of each code & ECC
	// blocks is almost same; for example, when we have 4 blocks and 46 data words
	// the number of code words in those blocks are 11, 11, 12, 12 respectively.
	var augumenteccs = function (poly, nblocks, genpoly) {
		var subsizes = [];
		var subsize = (poly.length / nblocks) | 0, subsize0 = 0;
		var pivot = nblocks - poly.length % nblocks;
		for (var i = 0; i < pivot; ++i) {
			subsizes.push(subsize0);
			subsize0 += subsize;
		}
		for (var i = pivot; i < nblocks; ++i) {
			subsizes.push(subsize0);
			subsize0 += subsize + 1;
		}
		subsizes.push(subsize0);

		var eccs = [];
		for (var i = 0; i < nblocks; ++i) {
			eccs.push(calculateecc(poly.slice(subsizes[i], subsizes[i + 1]), genpoly));
		}

		var result = [];
		var nitemsperblock = (poly.length / nblocks) | 0;
		for (var i = 0; i < nitemsperblock; ++i) {
			for (var j = 0; j < nblocks; ++j) {
				result.push(poly[subsizes[j] + i]);
			}
		}
		for (var j = pivot; j < nblocks; ++j) {
			result.push(poly[subsizes[j + 1] - 1]);
		}
		for (var i = 0; i < genpoly.length; ++i) {
			for (var j = 0; j < nblocks; ++j) {
				result.push(eccs[j][i]);
			}
		}
		return result;
	};

	// auguments BCH(p+q,q) code to the polynomial over GF(2), given the proper
	// genpoly. the both input and output are in binary numbers, and unlike
	// calculateecc genpoly should include the 1 bit for the highest degree.
	//
	// actual polynomials used for this procedure are as follows:
	// - p=10, q=5, genpoly=x^10+x^8+x^5+x^4+x^2+x+1 (JIS X 0510:2004 Appendix C)
	// - p=18, q=6, genpoly=x^12+x^11+x^10+x^9+x^8+x^5+x^2+1 (ibid. Appendix D)
	var augumentbch = function (poly, p, genpoly, q) {
		var modulus = poly << q;
		for (var i = p - 1; i >= 0; --i) {
			if ((modulus >> (q + i)) & 1)
				modulus ^= genpoly << i;
		}
		return (poly << q) | modulus;
	};

	// creates the base matrix for given version. it returns two matrices, one of
	// them is the actual one and the another represents the "reserved" portion
	// (e.g. finder and timing patterns) of the matrix.
	//
	// some entries in the matrix may be undefined, rather than 0 or 1. this is
	// intentional (no initialization needed!), and putdata below will fill
	// the remaining ones.
	var makebasematrix = function (ver) {
		var v = VERSIONS[ver], n = getsizebyver(ver);
		var matrix = [], reserved = [];
		for (var i = 0; i < n; ++i) {
			matrix.push([]);
			reserved.push([]);
		}

		var blit = function (y, x, h, w, bits) {
			for (var i = 0; i < h; ++i) {
				for (var j = 0; j < w; ++j) {
					matrix[y + i][x + j] = (bits[i] >> j) & 1;
					reserved[y + i][x + j] = 1;
				}
			}
		};

		// finder patterns and a part of timing patterns
		// will also mark the format information area (not yet written) as reserved.
		blit(0, 0, 9, 9, [0x7f, 0x41, 0x5d, 0x5d, 0x5d, 0x41, 0x17f, 0x00, 0x40]);
		blit(n - 8, 0, 8, 9, [0x100, 0x7f, 0x41, 0x5d, 0x5d, 0x5d, 0x41, 0x7f]);
		blit(0, n - 8, 9, 8, [0xfe, 0x82, 0xba, 0xba, 0xba, 0x82, 0xfe, 0x00, 0x00]);

		// the rest of timing patterns
		for (var i = 9; i < n - 8; ++i) {
			matrix[6][i] = matrix[i][6] = ~i & 1;
			reserved[6][i] = reserved[i][6] = 1;
		}

		// alignment patterns
		var aligns = v[2], m = aligns.length;
		for (var i = 0; i < m; ++i) {
			var minj = (i === 0 || i === m - 1 ? 1 : 0), maxj = (i === 0 ? m - 1 : m);
			for (var j = minj; j < maxj; ++j) {
				blit(aligns[i], aligns[j], 5, 5, [0x1f, 0x11, 0x15, 0x11, 0x1f]);
			}
		}

		// version information
		if (needsverinfo(ver)) {
			var code = augumentbch(ver, 6, 0x1f25, 12);
			var k = 0;
			for (var i = 0; i < 6; ++i) {
				for (var j = 0; j < 3; ++j) {
					matrix[i][(n - 11) + j] = matrix[(n - 11) + j][i] = (code >> k++) & 1;
					reserved[i][(n - 11) + j] = reserved[(n - 11) + j][i] = 1;
				}
			}
		}

		return {matrix: matrix, reserved: reserved};
	};

	// fills the data portion (i.e. unmarked in reserved) of the matrix with given
	// code words. the size of code words should be no more than available bits,
	// and remaining bits are padded to 0 (cf. JIS X 0510:2004 sec 8.7.3).
	var putdata = function (matrix, reserved, buf) {
		var n = matrix.length;
		var k = 0, dir = -1;
		for (var i = n - 1; i >= 0; i -= 2) {
			if (i == 6)
				--i; // skip the entire timing pattern column
			var jj = (dir < 0 ? n - 1 : 0);
			for (var j = 0; j < n; ++j) {
				for (var ii = i; ii > i - 2; --ii) {
					if (!reserved[jj][ii]) {
						// may overflow, but (undefined >> x)
						// is 0 so it will auto-pad to zero.
						matrix[jj][ii] = (buf[k >> 3] >> (~k & 7)) & 1;
						++k;
					}
				}
				jj += dir;
			}
			dir = -dir;
		}
		return matrix;
	};

	// XOR-masks the data portion of the matrix. repeating the call with the same
	// arguments will revert the prior call (convenient in the matrix evaluation).
	var maskdata = function (matrix, reserved, mask) {
		var maskf = MASKFUNCS[mask];
		var n = matrix.length;
		for (var i = 0; i < n; ++i) {
			for (var j = 0; j < n; ++j) {
				if (!reserved[i][j])
					matrix[i][j] ^= maskf(i, j);
			}
		}
		return matrix;
	};

	// puts the format information.
	var putformatinfo = function (matrix, reserved, ecclevel, mask) {
		var n = matrix.length;
		var code = augumentbch((ecclevel << 3) | mask, 5, 0x537, 10) ^ 0x5412;
		for (var i = 0; i < 15; ++i) {
			var r = [0, 1, 2, 3, 4, 5, 7, 8, n - 7, n - 6, n - 5, n - 4, n - 3, n - 2, n - 1][i];
			var c = [n - 1, n - 2, n - 3, n - 4, n - 5, n - 6, n - 7, n - 8, 7, 5, 4, 3, 2, 1, 0][i];
			matrix[r][8] = matrix[8][c] = (code >> i) & 1;
			// we don't have to mark those bits reserved; always done
			// in makebasematrix above.
		}
		return matrix;
	};

	// evaluates the resulting matrix and returns the score (lower is better).
	// (cf. JIS X 0510:2004 sec 8.8.2)
	//
	// the evaluation procedure tries to avoid the problematic patterns naturally
	// occuring from the original matrix. for example, it penaltizes the patterns
	// which just look like the finder pattern which will confuse the decoder.
	// we choose the mask which results in the lowest score among 8 possible ones.
	//
	// note: zxing seems to use the same procedure and in many cases its choice
	// agrees to ours, but sometimes it does not. practically it doesn't matter.
	var evaluatematrix = function (matrix) {
		// N1+(k-5) points for each consecutive row of k same-colored modules,
		// where k >= 5. no overlapping row counts.
		var PENALTY_CONSECUTIVE = 3;
		// N2 points for each 2x2 block of same-colored modules.
		// overlapping block does count.
		var PENALTY_TWOBYTWO = 3;
		// N3 points for each pattern with >4W:1B:1W:3B:1W:1B or
		// 1B:1W:3B:1W:1B:>4W, or their multiples (e.g. highly unlikely,
		// but 13W:3B:3W:9B:3W:3B counts).
		var PENALTY_FINDERLIKE = 40;
		// N4*k points for every (5*k)% deviation from 50% black density.
		// i.e. k=1 for 55~60% and 40~45%, k=2 for 60~65% and 35~40%, etc.
		var PENALTY_DENSITY = 10;

		var evaluategroup = function (groups) { // assumes [W,B,W,B,W,...,B,W]
			var score = 0;
			for (var i = 0; i < groups.length; ++i) {
				if (groups[i] >= 5)
					score += PENALTY_CONSECUTIVE + (groups[i] - 5);
			}
			for (var i = 5; i < groups.length; i += 2) {
				var p = groups[i];
				if (groups[i - 1] == p && groups[i - 2] == 3 * p && groups[i - 3] == p &&
					groups[i - 4] == p && (groups[i - 5] >= 4 * p || groups[i + 1] >= 4 * p)) {
					// this part differs from zxing...
					score += PENALTY_FINDERLIKE;
				}
			}
			return score;
		};

		var n = matrix.length;
		var score = 0, nblacks = 0;
		for (var i = 0; i < n; ++i) {
			var row = matrix[i];
			var groups;

			// evaluate the current row
			groups = [0]; // the first empty group of white
			for (var j = 0; j < n; ) {
				var k;
				for (k = 0; j < n && row[j]; ++k)
					++j;
				groups.push(k);
				for (k = 0; j < n && !row[j]; ++k)
					++j;
				groups.push(k);
			}
			score += evaluategroup(groups);

			// evaluate the current column
			groups = [0];
			for (var j = 0; j < n; ) {
				var k;
				for (k = 0; j < n && matrix[j][i]; ++k)
					++j;
				groups.push(k);
				for (k = 0; j < n && !matrix[j][i]; ++k)
					++j;
				groups.push(k);
			}
			score += evaluategroup(groups);

			// check the 2x2 box and calculate the density
			var nextrow = matrix[i + 1] || [];
			nblacks += row[0];
			for (var j = 1; j < n; ++j) {
				var p = row[j];
				nblacks += p;
				// at least comparison with next row should be strict...
				if (row[j - 1] == p && nextrow[j] === p && nextrow[j - 1] === p) {
					score += PENALTY_TWOBYTWO;
				}
			}
		}

		score += PENALTY_DENSITY * ((Math.abs(nblacks / n / n - 0.5) / 0.05) | 0);
		return score;
	};

	// returns the fully encoded QR code matrix which contains given data.
	// it also chooses the best mask automatically when mask is -1.
	var generate = function (data, ver, mode, ecclevel, mask) {
		var v = VERSIONS[ver];
		var buf = encode(ver, mode, data, ndatabits(ver, ecclevel) >> 3);
		buf = augumenteccs(buf, v[1][ecclevel], GF256_GENPOLY[v[0][ecclevel]]);

		var result = makebasematrix(ver);
		var matrix = result.matrix, reserved = result.reserved;
		putdata(matrix, reserved, buf);

		if (mask < 0) {
			// find the best mask
			maskdata(matrix, reserved, 0);
			putformatinfo(matrix, reserved, ecclevel, 0);
			var bestmask = 0, bestscore = evaluatematrix(matrix);
			maskdata(matrix, reserved, 0);
			for (mask = 1; mask < 8; ++mask) {
				maskdata(matrix, reserved, mask);
				putformatinfo(matrix, reserved, ecclevel, mask);
				var score = evaluatematrix(matrix);
				if (bestscore > score) {
					bestscore = score;
					bestmask = mask;
				}
				maskdata(matrix, reserved, mask);
			}
			mask = bestmask;
		}

		maskdata(matrix, reserved, mask);
		putformatinfo(matrix, reserved, ecclevel, mask);
		return matrix;
	};

	// the public interface is trivial; the options available are as follows:
	//
	// - version: an integer in [1,40]. when omitted (or -1) the smallest possible
	//   version is chosen.
	// - mode: one of 'numeric', 'alphanumeric', 'octet'. when omitted the smallest
	//   possible mode is chosen.
	// - eccLevel: one of 'L', 'M', 'Q', 'H'. defaults to 'L'.
	// - mask: an integer in [0,7]. when omitted (or -1) the best mask is chosen.
	//

	function generateFrame(data, options) {
		var MODES = {'numeric': MODE_NUMERIC, 'alphanumeric': MODE_ALPHANUMERIC,
			'octet': MODE_OCTET};
		var ECCLEVELS = {'L': ECCLEVEL_L, 'M': ECCLEVEL_M, 'Q': ECCLEVEL_Q,
			'H': ECCLEVEL_H};

		options = options || {};
		var ver = options.version || -1;
		var ecclevel = ECCLEVELS[(options.eccLevel || 'L').toUpperCase()];
		var mode = options.mode ? MODES[options.mode.toLowerCase()] : -1;
		var mask = 'mask' in options ? options.mask : -1;

		if (mode < 0) {
			if (typeof data === 'string') {
				if (data.match(NUMERIC_REGEXP)) {
					mode = MODE_NUMERIC;
				} else if (data.match(ALPHANUMERIC_OUT_REGEXP)) {
					// while encode supports case-insensitive encoding, we restrict the data to be uppercased when auto-selecting the mode.
					mode = MODE_ALPHANUMERIC;
				} else {
					mode = MODE_OCTET;
				}
			} else {
				mode = MODE_OCTET;
			}
		} else if (!(mode == MODE_NUMERIC || mode == MODE_ALPHANUMERIC ||
			mode == MODE_OCTET)) {
			throw 'invalid or unsupported mode';
		}

		data = validatedata(mode, data);
		if (data === null)
			throw 'invalid data format';

		if (ecclevel < 0 || ecclevel > 3)
			throw 'invalid ECC level';

		if (ver < 0) {
			for (ver = 1; ver <= 40; ++ver) {
				if (data.length <= getmaxdatalen(ver, mode, ecclevel))
					break;
			}
			if (ver > 40)
				throw 'too large data for the Qr format';
		} else if (ver < 1 || ver > 40) {
			throw 'invalid Qr version! should be between 1 and 40';
		}

		if (mask != -1 && (mask < 0 || mask > 8))
			throw 'invalid mask';
		//console.log('version:', ver, 'mode:', mode, 'ECC:', ecclevel, 'mask:', mask )
		return generate(data, ver, mode, ecclevel, mask);
	}


	// options
	// - modulesize: a number. this is a size of each modules in pixels, and
	//   defaults to 5px.
	// - margin: a number. this is a size of margin in *modules*, and defaults to
	//   4 (white modules). the specficiation mandates the margin no less than 4
	//   modules, so it is better not to alter this value unless you know what
	//   you're doing.
	function buildCanvas(data, options) {

		var canvas = [];
		var background = options.background || '#fff';
		var foreground = options.foreground || '#000';
		//var margin = options.margin || 4;
		var matrix = generateFrame(data, options);
		var n = matrix.length;
		var modSize = Math.floor(options.fit ? options.fit / n : 5);
		var size = n * modSize;

		canvas.push({
			type: 'rect',
			x: 0, y: 0, w: size, h: size, lineWidth: 0, color: background
		});

		for (var i = 0; i < n; ++i) {
			for (var j = 0; j < n; ++j) {
				if (matrix[i][j]) {
					canvas.push({
						type: 'rect',
						x: modSize * j,
						y: modSize * i,
						w: modSize,
						h: modSize,
						lineWidth: 0,
						color: foreground
					});
				}
			}
		}

		return {
			canvas: canvas,
			size: size
		};

	}

	function measure(node) {
		var cd = buildCanvas(node.qr, node);
		node._canvas = cd.canvas;
		node._width = node._height = node._minWidth = node._maxWidth = node._minHeight = node._maxHeight = cd.size;
		return node;
	}

	module.exports = {
		measure: measure
	};

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var TraversalTracker = __webpack_require__(10);
	var isString = __webpack_require__(8).isString;

	/**
	 * Creates an instance of DocumentContext - a store for current x, y positions and available width/height.
	 * It facilitates column divisions and vertical sync
	 */
	function DocumentContext(pageSize, pageMargins) {
		this.pages = [];

		this.pageMargins = pageMargins;

		this.x = pageMargins.left;
		this.availableWidth = pageSize.width - pageMargins.left - pageMargins.right;
		this.availableHeight = 0;
		this.page = -1;

		this.snapshots = [];

		this.endingCell = null;

		this.tracker = new TraversalTracker();

		this.addPage(pageSize);
	}

	DocumentContext.prototype.beginColumnGroup = function () {
		this.snapshots.push({
			x: this.x,
			y: this.y,
			availableHeight: this.availableHeight,
			availableWidth: this.availableWidth,
			page: this.page,
			bottomMost: {
				x: this.x,
				y: this.y,
				availableHeight: this.availableHeight,
				availableWidth: this.availableWidth,
				page: this.page
			},
			endingCell: this.endingCell,
			lastColumnWidth: this.lastColumnWidth
		});

		this.lastColumnWidth = 0;
	};

	DocumentContext.prototype.beginColumn = function (width, offset, endingCell) {
		var saved = this.snapshots[this.snapshots.length - 1];

		this.calculateBottomMost(saved);

		this.endingCell = endingCell;
		this.page = saved.page;
		this.x = this.x + this.lastColumnWidth + (offset || 0);
		this.y = saved.y;
		this.availableWidth = width;	//saved.availableWidth - offset;
		this.availableHeight = saved.availableHeight;

		this.lastColumnWidth = width;
	};

	DocumentContext.prototype.calculateBottomMost = function (destContext) {
		if (this.endingCell) {
			this.saveContextInEndingCell(this.endingCell);
			this.endingCell = null;
		} else {
			destContext.bottomMost = bottomMostContext(this, destContext.bottomMost);
		}
	};

	DocumentContext.prototype.markEnding = function (endingCell) {
		this.page = endingCell._columnEndingContext.page;
		this.x = endingCell._columnEndingContext.x;
		this.y = endingCell._columnEndingContext.y;
		this.availableWidth = endingCell._columnEndingContext.availableWidth;
		this.availableHeight = endingCell._columnEndingContext.availableHeight;
		this.lastColumnWidth = endingCell._columnEndingContext.lastColumnWidth;
	};

	DocumentContext.prototype.saveContextInEndingCell = function (endingCell) {
		endingCell._columnEndingContext = {
			page: this.page,
			x: this.x,
			y: this.y,
			availableHeight: this.availableHeight,
			availableWidth: this.availableWidth,
			lastColumnWidth: this.lastColumnWidth
		};
	};

	DocumentContext.prototype.completeColumnGroup = function (height) {
		var saved = this.snapshots.pop();

		this.calculateBottomMost(saved);

		this.endingCell = null;
		this.x = saved.x;

		var y = saved.bottomMost.y;
		if (height) {
			if (saved.page === saved.bottomMost.page) {
				if ((saved.y + height) > y) {
					y = saved.y + height;
				}
			} else {
				y += height;
			}
		}

		this.y = y;
		this.page = saved.bottomMost.page;
		this.availableWidth = saved.availableWidth;
		this.availableHeight = saved.bottomMost.availableHeight;
		if (height) {
			this.availableHeight -= (y - saved.bottomMost.y);
		}
		this.lastColumnWidth = saved.lastColumnWidth;
	};

	DocumentContext.prototype.addMargin = function (left, right) {
		this.x += left;
		this.availableWidth -= left + (right || 0);
	};

	DocumentContext.prototype.moveDown = function (offset) {
		this.y += offset;
		this.availableHeight -= offset;

		return this.availableHeight > 0;
	};

	DocumentContext.prototype.initializePage = function () {
		this.y = this.pageMargins.top;
		this.availableHeight = this.getCurrentPage().pageSize.height - this.pageMargins.top - this.pageMargins.bottom;
		this.pageSnapshot().availableWidth = this.getCurrentPage().pageSize.width - this.pageMargins.left - this.pageMargins.right;
	};

	DocumentContext.prototype.pageSnapshot = function () {
		if (this.snapshots[0]) {
			return this.snapshots[0];
		} else {
			return this;
		}
	};

	DocumentContext.prototype.moveTo = function (x, y) {
		if (x !== undefined && x !== null) {
			this.x = x;
			this.availableWidth = this.getCurrentPage().pageSize.width - this.x - this.pageMargins.right;
		}
		if (y !== undefined && y !== null) {
			this.y = y;
			this.availableHeight = this.getCurrentPage().pageSize.height - this.y - this.pageMargins.bottom;
		}
	};

	DocumentContext.prototype.beginDetachedBlock = function () {
		this.snapshots.push({
			x: this.x,
			y: this.y,
			availableHeight: this.availableHeight,
			availableWidth: this.availableWidth,
			page: this.page,
			endingCell: this.endingCell,
			lastColumnWidth: this.lastColumnWidth
		});
	};

	DocumentContext.prototype.endDetachedBlock = function () {
		var saved = this.snapshots.pop();

		this.x = saved.x;
		this.y = saved.y;
		this.availableWidth = saved.availableWidth;
		this.availableHeight = saved.availableHeight;
		this.page = saved.page;
		this.endingCell = saved.endingCell;
		this.lastColumnWidth = saved.lastColumnWidth;
	};

	function pageOrientation(pageOrientationString, currentPageOrientation) {
		if (pageOrientationString === undefined) {
			return currentPageOrientation;
		} else if (isString(pageOrientationString) && (pageOrientationString.toLowerCase() === 'landscape')) {
			return 'landscape';
		} else {
			return 'portrait';
		}
	}

	var getPageSize = function (currentPage, newPageOrientation) {

		newPageOrientation = pageOrientation(newPageOrientation, currentPage.pageSize.orientation);

		if (newPageOrientation !== currentPage.pageSize.orientation) {
			return {
				orientation: newPageOrientation,
				width: currentPage.pageSize.height,
				height: currentPage.pageSize.width
			};
		} else {
			return {
				orientation: currentPage.pageSize.orientation,
				width: currentPage.pageSize.width,
				height: currentPage.pageSize.height
			};
		}

	};


	DocumentContext.prototype.moveToNextPage = function (pageOrientation) {
		var nextPageIndex = this.page + 1;

		var prevPage = this.page;
		var prevY = this.y;

		var createNewPage = nextPageIndex >= this.pages.length;
		if (createNewPage) {
			var currentAvailableWidth = this.availableWidth;
			var currentPageOrientation = this.getCurrentPage().pageSize.orientation;

			var pageSize = getPageSize(this.getCurrentPage(), pageOrientation);
			this.addPage(pageSize);

			if (currentPageOrientation === pageSize.orientation) {
				this.availableWidth = currentAvailableWidth;
			}
		} else {
			this.page = nextPageIndex;
			this.initializePage();
		}

		return {
			newPageCreated: createNewPage,
			prevPage: prevPage,
			prevY: prevY,
			y: this.y
		};
	};


	DocumentContext.prototype.addPage = function (pageSize) {
		var page = {items: [], pageSize: pageSize};
		this.pages.push(page);
		this.page = this.pages.length - 1;
		this.initializePage();

		this.tracker.emit('pageAdded');

		return page;
	};

	DocumentContext.prototype.getCurrentPage = function () {
		if (this.page < 0 || this.page >= this.pages.length) {
			return null;
		}

		return this.pages[this.page];
	};

	DocumentContext.prototype.getCurrentPosition = function () {
		var pageSize = this.getCurrentPage().pageSize;
		var innerHeight = pageSize.height - this.pageMargins.top - this.pageMargins.bottom;
		var innerWidth = pageSize.width - this.pageMargins.left - this.pageMargins.right;

		return {
			pageNumber: this.page + 1,
			pageOrientation: pageSize.orientation,
			pageInnerHeight: innerHeight,
			pageInnerWidth: innerWidth,
			left: this.x,
			top: this.y,
			verticalRatio: ((this.y - this.pageMargins.top) / innerHeight),
			horizontalRatio: ((this.x - this.pageMargins.left) / innerWidth)
		};
	};

	function bottomMostContext(c1, c2) {
		var r;

		if (c1.page > c2.page) {
			r = c1;
		} else if (c2.page > c1.page) {
			r = c2;
		} else {
			r = (c1.y > c2.y) ? c1 : c2;
		}

		return {
			page: r.page,
			x: r.x,
			y: r.y,
			availableHeight: r.availableHeight,
			availableWidth: r.availableWidth
		};
	}

	/****TESTS**** (add a leading '/' to uncomment)
	 DocumentContext.bottomMostContext = bottomMostContext;
	 // */

	module.exports = DocumentContext;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var ElementWriter = __webpack_require__(25);

	/**
	 * Creates an instance of PageElementWriter - an extended ElementWriter
	 * which can handle:
	 * - page-breaks (it adds new pages when there's not enough space left),
	 * - repeatable fragments (like table-headers, which are repeated everytime
	 *                         a page-break occurs)
	 * - transactions (used for unbreakable-blocks when we want to make sure
	 *                 whole block will be rendered on the same page)
	 */
	function PageElementWriter(context, tracker) {
		this.transactionLevel = 0;
		this.repeatables = [];
		this.tracker = tracker;
		this.writer = new ElementWriter(context, tracker);
	}

	function fitOnPage(self, addFct) {
		var position = addFct(self);
		if (!position) {
			self.moveToNextPage();
			position = addFct(self);
		}
		return position;
	}

	PageElementWriter.prototype.addLine = function (line, dontUpdateContextPosition, index) {
		return fitOnPage(this, function (self) {
			return self.writer.addLine(line, dontUpdateContextPosition, index);
		});
	};

	PageElementWriter.prototype.addImage = function (image, index) {
		return fitOnPage(this, function (self) {
			return self.writer.addImage(image, index);
		});
	};

	PageElementWriter.prototype.addQr = function (qr, index) {
		return fitOnPage(this, function (self) {
			return self.writer.addQr(qr, index);
		});
	};

	PageElementWriter.prototype.addVector = function (vector, ignoreContextX, ignoreContextY, index) {
		return this.writer.addVector(vector, ignoreContextX, ignoreContextY, index);
	};

	PageElementWriter.prototype.beginClip = function (width, height) {
		return this.writer.beginClip(width, height);
	};

	PageElementWriter.prototype.endClip = function () {
		return this.writer.endClip();
	};

	PageElementWriter.prototype.alignCanvas = function (node) {
		this.writer.alignCanvas(node);
	};

	PageElementWriter.prototype.addFragment = function (fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition) {
		if (!this.writer.addFragment(fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition)) {
			this.moveToNextPage();
			this.writer.addFragment(fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition);
		}
	};

	PageElementWriter.prototype.moveToNextPage = function (pageOrientation) {

		var nextPage = this.writer.context.moveToNextPage(pageOrientation);

		if (nextPage.newPageCreated) {
			this.repeatables.forEach(function (rep) {
				this.writer.addFragment(rep, true);
			}, this);
		} else {
			this.repeatables.forEach(function (rep) {
				this.writer.context.moveDown(rep.height);
			}, this);
		}

		this.writer.tracker.emit('pageChanged', {
			prevPage: nextPage.prevPage,
			prevY: nextPage.prevY,
			y: nextPage.y
		});
	};

	PageElementWriter.prototype.beginUnbreakableBlock = function (width, height) {
		if (this.transactionLevel++ === 0) {
			this.originalX = this.writer.context.x;
			this.writer.pushContext(width, height);
		}
	};

	PageElementWriter.prototype.commitUnbreakableBlock = function (forcedX, forcedY) {
		if (--this.transactionLevel === 0) {
			var unbreakableContext = this.writer.context;
			this.writer.popContext();

			var nbPages = unbreakableContext.pages.length;
			if (nbPages > 0) {
				// no support for multi-page unbreakableBlocks
				var fragment = unbreakableContext.pages[0];
				fragment.xOffset = forcedX;
				fragment.yOffset = forcedY;

				//TODO: vectors can influence height in some situations
				if (nbPages > 1) {
					// on out-of-context blocs (headers, footers, background) height should be the whole DocumentContext height
					if (forcedX !== undefined || forcedY !== undefined) {
						fragment.height = unbreakableContext.getCurrentPage().pageSize.height - unbreakableContext.pageMargins.top - unbreakableContext.pageMargins.bottom;
					} else {
						fragment.height = this.writer.context.getCurrentPage().pageSize.height - this.writer.context.pageMargins.top - this.writer.context.pageMargins.bottom;
						for (var i = 0, l = this.repeatables.length; i < l; i++) {
							fragment.height -= this.repeatables[i].height;
						}
					}
				} else {
					fragment.height = unbreakableContext.y;
				}

				if (forcedX !== undefined || forcedY !== undefined) {
					this.writer.addFragment(fragment, true, true, true);
				} else {
					this.addFragment(fragment);
				}
			}
		}
	};

	PageElementWriter.prototype.currentBlockToRepeatable = function () {
		var unbreakableContext = this.writer.context;
		var rep = {items: []};

		unbreakableContext.pages[0].items.forEach(function (item) {
			rep.items.push(item);
		});

		rep.xOffset = this.originalX;

		//TODO: vectors can influence height in some situations
		rep.height = unbreakableContext.y;

		return rep;
	};

	PageElementWriter.prototype.pushToRepeatables = function (rep) {
		this.repeatables.push(rep);
	};

	PageElementWriter.prototype.popFromRepeatables = function () {
		this.repeatables.pop();
	};

	PageElementWriter.prototype.context = function () {
		return this.writer.context;
	};

	module.exports = PageElementWriter;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var Line = __webpack_require__(26);
	var isNumber = __webpack_require__(8).isNumber;
	var pack = __webpack_require__(8).pack;
	var offsetVector = __webpack_require__(8).offsetVector;
	var DocumentContext = __webpack_require__(23);

	/**
	 * Creates an instance of ElementWriter - a line/vector writer, which adds
	 * elements to current page and sets their positions based on the context
	 */
	function ElementWriter(context, tracker) {
		this.context = context;
		this.contextStack = [];
		this.tracker = tracker;
	}

	function addPageItem(page, item, index) {
		if (index === null || index === undefined || index < 0 || index > page.items.length) {
			page.items.push(item);
		} else {
			page.items.splice(index, 0, item);
		}
	}

	ElementWriter.prototype.addLine = function (line, dontUpdateContextPosition, index) {
		var height = line.getHeight();
		var context = this.context;
		var page = context.getCurrentPage(),
			position = this.getCurrentPositionOnPage();

		if (context.availableHeight < height || !page) {
			return false;
		}

		line.x = context.x + (line.x || 0);
		line.y = context.y + (line.y || 0);

		this.alignLine(line);

		addPageItem(page, {
			type: 'line',
			item: line
		}, index);
		this.tracker.emit('lineAdded', line);

		if (!dontUpdateContextPosition) {
			context.moveDown(height);
		}

		return position;
	};

	ElementWriter.prototype.alignLine = function (line) {
		var width = this.context.availableWidth;
		var lineWidth = line.getWidth();

		var alignment = line.inlines && line.inlines.length > 0 && line.inlines[0].alignment;

		var offset = 0;
		switch (alignment) {
			case 'right':
				offset = width - lineWidth;
				break;
			case 'center':
				offset = (width - lineWidth) / 2;
				break;
		}

		if (offset) {
			line.x = (line.x || 0) + offset;
		}

		if (alignment === 'justify' &&
			!line.newLineForced &&
			!line.lastLineInParagraph &&
			line.inlines.length > 1) {
			var additionalSpacing = (width - lineWidth) / (line.inlines.length - 1);

			for (var i = 1, l = line.inlines.length; i < l; i++) {
				offset = i * additionalSpacing;

				line.inlines[i].x += offset;
				line.inlines[i].justifyShift = additionalSpacing;
			}
		}
	};

	ElementWriter.prototype.addImage = function (image, index) {
		var context = this.context;
		var page = context.getCurrentPage(),
			position = this.getCurrentPositionOnPage();

		if (!page || (image.absolutePosition === undefined && context.availableHeight < image._height && page.items.length > 0)) {
			return false;
		}

		if (image._x === undefined) {
			image._x = image.x || 0;
		}

		image.x = context.x + image._x;
		image.y = context.y;

		this.alignImage(image);

		addPageItem(page, {
			type: 'image',
			item: image
		}, index);

		context.moveDown(image._height);

		return position;
	};

	ElementWriter.prototype.addQr = function (qr, index) {
		var context = this.context;
		var page = context.getCurrentPage(),
			position = this.getCurrentPositionOnPage();

		if (!page || (qr.absolutePosition === undefined && context.availableHeight < qr._height)) {
			return false;
		}

		if (qr._x === undefined) {
			qr._x = qr.x || 0;
		}

		qr.x = context.x + qr._x;
		qr.y = context.y;

		this.alignImage(qr);

		for (var i = 0, l = qr._canvas.length; i < l; i++) {
			var vector = qr._canvas[i];
			vector.x += qr.x;
			vector.y += qr.y;
			this.addVector(vector, true, true, index);
		}

		context.moveDown(qr._height);

		return position;
	};

	ElementWriter.prototype.alignImage = function (image) {
		var width = this.context.availableWidth;
		var imageWidth = image._minWidth;
		var offset = 0;
		switch (image._alignment) {
			case 'right':
				offset = width - imageWidth;
				break;
			case 'center':
				offset = (width - imageWidth) / 2;
				break;
		}

		if (offset) {
			image.x = (image.x || 0) + offset;
		}
	};

	ElementWriter.prototype.alignCanvas = function (node) {
		var width = this.context.availableWidth;
		var canvasWidth = node._minWidth;
		var offset = 0;
		switch (node._alignment) {
			case 'right':
				offset = width - canvasWidth;
				break;
			case 'center':
				offset = (width - canvasWidth) / 2;
				break;
		}
		if (offset) {
			node.canvas.forEach(function (vector) {
				offsetVector(vector, offset, 0);
			});
		}
	};

	ElementWriter.prototype.addVector = function (vector, ignoreContextX, ignoreContextY, index) {
		var context = this.context;
		var page = context.getCurrentPage(),
			position = this.getCurrentPositionOnPage();

		if (page) {
			offsetVector(vector, ignoreContextX ? 0 : context.x, ignoreContextY ? 0 : context.y);
			addPageItem(page, {
				type: 'vector',
				item: vector
			}, index);
			return position;
		}
	};

	ElementWriter.prototype.beginClip = function (width, height) {
		var ctx = this.context;
		var page = ctx.getCurrentPage();
		page.items.push({
			type: 'beginClip',
			item: {x: ctx.x, y: ctx.y, width: width, height: height}
		});
		return true;
	};

	ElementWriter.prototype.endClip = function () {
		var ctx = this.context;
		var page = ctx.getCurrentPage();
		page.items.push({
			type: 'endClip'
		});
		return true;
	};

	function cloneLine(line) {
		var result = new Line(line.maxWidth);

		for (var key in line) {
			if (line.hasOwnProperty(key)) {
				result[key] = line[key];
			}
		}

		return result;
	}

	ElementWriter.prototype.addFragment = function (block, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition) {
		var ctx = this.context;
		var page = ctx.getCurrentPage();

		if (!useBlockXOffset && block.height > ctx.availableHeight) {
			return false;
		}

		block.items.forEach(function (item) {
			switch (item.type) {
				case 'line':
					var l = cloneLine(item.item);

					l.x = (l.x || 0) + (useBlockXOffset ? (block.xOffset || 0) : ctx.x);
					l.y = (l.y || 0) + (useBlockYOffset ? (block.yOffset || 0) : ctx.y);

					page.items.push({
						type: 'line',
						item: l
					});
					break;

				case 'vector':
					var v = pack(item.item);

					offsetVector(v, useBlockXOffset ? (block.xOffset || 0) : ctx.x, useBlockYOffset ? (block.yOffset || 0) : ctx.y);
					page.items.push({
						type: 'vector',
						item: v
					});
					break;

				case 'image':
					var img = pack(item.item);

					img.x = (img.x || 0) + (useBlockXOffset ? (block.xOffset || 0) : ctx.x);
					img.y = (img.y || 0) + (useBlockYOffset ? (block.yOffset || 0) : ctx.y);

					page.items.push({
						type: 'image',
						item: img
					});
					break;
			}
		});

		if (!dontUpdateContextPosition) {
			ctx.moveDown(block.height);
		}

		return true;
	};

	/**
	 * Pushes the provided context onto the stack or creates a new one
	 *
	 * pushContext(context) - pushes the provided context and makes it current
	 * pushContext(width, height) - creates and pushes a new context with the specified width and height
	 * pushContext() - creates a new context for unbreakable blocks (with current availableWidth and full-page-height)
	 */
	ElementWriter.prototype.pushContext = function (contextOrWidth, height) {
		if (contextOrWidth === undefined) {
			height = this.context.getCurrentPage().height - this.context.pageMargins.top - this.context.pageMargins.bottom;
			contextOrWidth = this.context.availableWidth;
		}

		if (isNumber(contextOrWidth)) {
			contextOrWidth = new DocumentContext({width: contextOrWidth, height: height}, {left: 0, right: 0, top: 0, bottom: 0});
		}

		this.contextStack.push(this.context);
		this.context = contextOrWidth;
	};

	ElementWriter.prototype.popContext = function () {
		this.context = this.contextStack.pop();
	};

	ElementWriter.prototype.getCurrentPositionOnPage = function () {
		return (this.contextStack[0] || this.context).getCurrentPosition();
	};


	module.exports = ElementWriter;


/***/ }),
/* 26 */
/***/ (function(module, exports) {

	/* jslint node: true */
	'use strict';

	/**
	 * Creates an instance of Line
	 *
	 * @constructor
	 * @this {Line}
	 * @param {Number} Maximum width this line can have
	 */
	function Line(maxWidth) {
		this.maxWidth = maxWidth;
		this.leadingCut = 0;
		this.trailingCut = 0;
		this.inlineWidths = 0;
		this.inlines = [];
	}

	Line.prototype.getAscenderHeight = function () {
		var y = 0;

		this.inlines.forEach(function (inline) {
			y = Math.max(y, inline.font.ascender / 1000 * inline.fontSize);
		});
		return y;
	};

	Line.prototype.hasEnoughSpaceForInline = function (inline) {
		if (this.inlines.length === 0) {
			return true;
		}
		if (this.newLineForced) {
			return false;
		}

		return this.inlineWidths + inline.width - this.leadingCut - (inline.trailingCut || 0) <= this.maxWidth;
	};

	Line.prototype.addInline = function (inline) {
		if (this.inlines.length === 0) {
			this.leadingCut = inline.leadingCut || 0;
		}
		this.trailingCut = inline.trailingCut || 0;

		inline.x = this.inlineWidths - this.leadingCut;

		this.inlines.push(inline);
		this.inlineWidths += inline.width;

		if (inline.lineEnd) {
			this.newLineForced = true;
		}
	};

	Line.prototype.getWidth = function () {
		return this.inlineWidths - this.leadingCut - this.trailingCut;
	};

	/**
	 * Returns line height
	 * @return {Number}
	 */
	Line.prototype.getHeight = function () {
		var max = 0;

		this.inlines.forEach(function (item) {
			max = Math.max(max, item.height || 0);
		});

		return max;
	};

	module.exports = Line;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

	/* jslint node: true */
	'use strict';

	var ColumnCalculator = __webpack_require__(21);
	var isFunction = __webpack_require__(8).isFunction;

	function TableProcessor(tableNode) {
		this.tableNode = tableNode;
	}

	TableProcessor.prototype.beginTable = function (writer) {
		var tableNode;
		var availableWidth;
		var self = this;

		tableNode = this.tableNode;
		this.offsets = tableNode._offsets;
		this.layout = tableNode._layout;

		availableWidth = writer.context().availableWidth - this.offsets.total;
		ColumnCalculator.buildColumnWidths(tableNode.table.widths, availableWidth);

		this.tableWidth = tableNode._offsets.total + getTableInnerContentWidth();
		this.rowSpanData = prepareRowSpanData();
		this.cleanUpRepeatables = false;

		this.headerRows = tableNode.table.headerRows || 0;
		this.rowsWithoutPageBreak = this.headerRows + (tableNode.table.keepWithHeaderRows || 0);
		this.dontBreakRows = tableNode.table.dontBreakRows || false;

		if (this.rowsWithoutPageBreak) {
			writer.beginUnbreakableBlock();
		}

		// update the border properties of all cells before drawing any lines
		prepareCellBorders(this.tableNode.table.body);

		this.drawHorizontalLine(0, writer);

		function getTableInnerContentWidth() {
			var width = 0;

			tableNode.table.widths.forEach(function (w) {
				width += w._calcWidth;
			});

			return width;
		}

		function prepareRowSpanData() {
			var rsd = [];
			var x = 0;
			var lastWidth = 0;

			rsd.push({left: 0, rowSpan: 0});

			for (var i = 0, l = self.tableNode.table.body[0].length; i < l; i++) {
				var paddings = self.layout.paddingLeft(i, self.tableNode) + self.layout.paddingRight(i, self.tableNode);
				var lBorder = self.layout.vLineWidth(i, self.tableNode);
				lastWidth = paddings + lBorder + self.tableNode.table.widths[i]._calcWidth;
				rsd[rsd.length - 1].width = lastWidth;
				x += lastWidth;
				rsd.push({left: x, rowSpan: 0, width: 0});
			}

			return rsd;
		}

		// Iterate through all cells. If the current cell is the start of a
		// rowSpan/colSpan, update the border property of the cells on its
		// bottom/right accordingly. This is needed since each iteration of the
		// line-drawing loops draws lines for a single cell, not for an entire
		// rowSpan/colSpan.
		function prepareCellBorders(body) {
			for (var rowIndex = 0; rowIndex < body.length; rowIndex++) {
				var row = body[rowIndex];

				for (var colIndex = 0; colIndex < row.length; colIndex++) {
					var cell = row[colIndex];

					if (cell.border) {
						var rowSpan = cell.rowSpan || 1;
						var colSpan = cell.colSpan || 1;

						for (var rowOffset = 0; rowOffset < rowSpan; rowOffset++) {
							// set left border
							if (cell.border[0] !== undefined && rowOffset > 0) {
								setBorder(rowIndex + rowOffset, colIndex, 0, cell.border[0]);
							}

							// set right border
							if (cell.border[2] !== undefined) {
								setBorder(rowIndex + rowOffset, colIndex + colSpan - 1, 2, cell.border[2]);
							}
						}

						for (var colOffset = 0; colOffset < colSpan; colOffset++) {
							// set top border
							if (cell.border[1] !== undefined && colOffset > 0) {
								setBorder(rowIndex, colIndex + colOffset, 1, cell.border[1]);
							}

							// set bottom border
							if (cell.border[3] !== undefined) {
								setBorder(rowIndex + rowSpan - 1, colIndex + colOffset, 3, cell.border[3]);
							}
						}
					}
				}
			}

			// helper function to set the border for a given cell
			function setBorder(rowIndex, colIndex, borderIndex, borderValue) {
				var cell = body[rowIndex][colIndex];
				cell.border = cell.border || {};
				cell.border[borderIndex] = borderValue;
			}
		}
	};

	TableProcessor.prototype.onRowBreak = function (rowIndex, writer) {
		var self = this;
		return function () {
			var offset = self.rowPaddingTop + (!self.headerRows ? self.topLineWidth : 0);
			writer.context().availableHeight -= self.reservedAtBottom;
			writer.context().moveDown(offset);
		};
	};

	TableProcessor.prototype.beginRow = function (rowIndex, writer) {
		this.topLineWidth = this.layout.hLineWidth(rowIndex, this.tableNode);
		this.rowPaddingTop = this.layout.paddingTop(rowIndex, this.tableNode);
		this.bottomLineWidth = this.layout.hLineWidth(rowIndex + 1, this.tableNode);
		this.rowPaddingBottom = this.layout.paddingBottom(rowIndex, this.tableNode);

		this.rowCallback = this.onRowBreak(rowIndex, writer);
		writer.tracker.startTracking('pageChanged', this.rowCallback);
		if (this.dontBreakRows) {
			writer.beginUnbreakableBlock();
		}
		this.rowTopY = writer.context().y;
		this.reservedAtBottom = this.bottomLineWidth + this.rowPaddingBottom;

		writer.context().availableHeight -= this.reservedAtBottom;

		writer.context().moveDown(this.rowPaddingTop);
	};

	TableProcessor.prototype.drawHorizontalLine = function (lineIndex, writer, overrideY) {
		var lineWidth = this.layout.hLineWidth(lineIndex, this.tableNode);
		if (lineWidth) {
			var offset = lineWidth / 2;
			var currentLine = null;
			var body = this.tableNode.table.body;

			for (var i = 0, l = this.rowSpanData.length; i < l; i++) {
				var data = this.rowSpanData[i];
				var shouldDrawLine = !data.rowSpan;

				// draw only if the current cell requires a top border or the cell in the
				// row above requires a bottom border
				if (shouldDrawLine && i < l - 1) {
					var topBorder = false, bottomBorder = false;

					// the current cell
					if (lineIndex < body.length) {
						var cell = body[lineIndex][i];
						topBorder = cell.border ? cell.border[1] : this.layout.defaultBorder;
					}

					// the cell in the row above
					if (lineIndex > 0) {
						var cellAbove = body[lineIndex - 1][i];
						bottomBorder = cellAbove.border ? cellAbove.border[3] : this.layout.defaultBorder;
					}

					shouldDrawLine = topBorder || bottomBorder;
				}

				if (!currentLine && shouldDrawLine) {
					currentLine = {left: data.left, width: 0};
				}

				if (shouldDrawLine) {
					currentLine.width += (data.width || 0);
				}

				var y = (overrideY || 0) + offset;

				if (!shouldDrawLine || i === l - 1) {
					if (currentLine && currentLine.width) {
						writer.addVector({
							type: 'line',
							x1: currentLine.left,
							x2: currentLine.left + currentLine.width,
							y1: y,
							y2: y,
							lineWidth: lineWidth,
							lineColor: isFunction(this.layout.hLineColor) ? this.layout.hLineColor(lineIndex, this.tableNode) : this.layout.hLineColor
						}, false, overrideY);
						currentLine = null;
					}
				}
			}

			writer.context().moveDown(lineWidth);
		}
	};

	TableProcessor.prototype.drawVerticalLine = function (x, y0, y1, vLineIndex, writer) {
		var width = this.layout.vLineWidth(vLineIndex, this.tableNode);
		if (width === 0) {
			return;
		}
		writer.addVector({
			type: 'line',
			x1: x + width / 2,
			x2: x + width / 2,
			y1: y0,
			y2: y1,
			lineWidth: width,
			lineColor: isFunction(this.layout.vLineColor) ? this.layout.vLineColor(vLineIndex, this.tableNode) : this.layout.vLineColor
		}, false, true);
	};

	TableProcessor.prototype.endTable = function (writer) {
		if (this.cleanUpRepeatables) {
			writer.popFromRepeatables();
			this.headerRepeatableHeight = null;
		}
	};

	TableProcessor.prototype.endRow = function (rowIndex, writer, pageBreaks) {
		var l, i;
		var self = this;
		writer.tracker.stopTracking('pageChanged', this.rowCallback);
		writer.context().moveDown(this.layout.paddingBottom(rowIndex, this.tableNode));
		writer.context().availableHeight += this.reservedAtBottom;

		var endingPage = writer.context().page;
		var endingY = writer.context().y;

		var xs = getLineXs();

		var ys = [];

		var hasBreaks = pageBreaks && pageBreaks.length > 0;
		var body = this.tableNode.table.body;

		ys.push({
			y0: this.rowTopY,
			page: hasBreaks ? pageBreaks[0].prevPage : endingPage
		});

		if (hasBreaks) {
			for (i = 0, l = pageBreaks.length; i < l; i++) {
				var pageBreak = pageBreaks[i];
				ys[ys.length - 1].y1 = pageBreak.prevY;

				ys.push({y0: pageBreak.y, page: pageBreak.prevPage + 1});

				if (this.headerRepeatableHeight) {
					ys[ys.length - 1].y0 += this.headerRepeatableHeight;
				}
			}
		}

		ys[ys.length - 1].y1 = endingY;

		var skipOrphanePadding = (ys[0].y1 - ys[0].y0 === this.rowPaddingTop);
		for (var yi = (skipOrphanePadding ? 1 : 0), yl = ys.length; yi < yl; yi++) {
			var willBreak = yi < ys.length - 1;
			var rowBreakWithoutHeader = (yi > 0 && !this.headerRows);
			var hzLineOffset = rowBreakWithoutHeader ? 0 : this.topLineWidth;
			var y1 = ys[yi].y0;
			var y2 = ys[yi].y1;

			if (willBreak) {
				y2 = y2 + this.rowPaddingBottom;
			}

			if (writer.context().page != ys[yi].page) {
				writer.context().page = ys[yi].page;

				//TODO: buggy, availableHeight should be updated on every pageChanged event
				// TableProcessor should be pageChanged listener, instead of processRow
				this.reservedAtBottom = 0;
			}

			for (i = 0, l = xs.length; i < l; i++) {
				var leftBorder = false, rightBorder = false;
				var colIndex = xs[i].index;

				// the current cell
				if (colIndex < body[rowIndex].length) {
					var cell = body[rowIndex][colIndex];
					leftBorder = cell.border ? cell.border[0] : this.layout.defaultBorder;
				}

				// the cell from before column
				if (colIndex > 0) {
					var cell = body[rowIndex][colIndex - 1];
					rightBorder = cell.border ? cell.border[2] : this.layout.defaultBorder;
				}

				if (leftBorder || rightBorder) {
					this.drawVerticalLine(xs[i].x, y1 - hzLineOffset, y2 + this.bottomLineWidth, xs[i].index, writer);
				}

				if (i < l - 1) {
					var fillColor = body[rowIndex][colIndex].fillColor;
					if (!fillColor) {
						fillColor = isFunction(this.layout.fillColor) ? this.layout.fillColor(rowIndex, this.tableNode) : this.layout.fillColor;
					}
					if (fillColor) {
						var wBorder = (leftBorder || rightBorder) ? this.layout.vLineWidth(colIndex, this.tableNode) : 0;
						var xf = xs[i].x + wBorder;
						var yf = this.dontBreakRows ? y1 : y1 - hzLineOffset;
						writer.addVector({
							type: 'rect',
							x: xf,
							y: yf,
							w: xs[i + 1].x - xf,
							h: y2 + this.bottomLineWidth - yf,
							lineWidth: 0,
							color: fillColor
						}, false, true, 0);
					}
				}
			}

			if (willBreak && this.layout.hLineWhenBroken !== false) {
				this.drawHorizontalLine(rowIndex + 1, writer, y2);
			}
			if (rowBreakWithoutHeader && this.layout.hLineWhenBroken !== false) {
				this.drawHorizontalLine(rowIndex, writer, y1);
			}
		}

		writer.context().page = endingPage;
		writer.context().y = endingY;

		var row = this.tableNode.table.body[rowIndex];
		for (i = 0, l = row.length; i < l; i++) {
			if (row[i].rowSpan) {
				this.rowSpanData[i].rowSpan = row[i].rowSpan;

				// fix colSpans
				if (row[i].colSpan && row[i].colSpan > 1) {
					for (var j = 1; j < row[i].rowSpan; j++) {
						this.tableNode.table.body[rowIndex + j][i]._colSpan = row[i].colSpan;
					}
				}
			}

			if (this.rowSpanData[i].rowSpan > 0) {
				this.rowSpanData[i].rowSpan--;
			}
		}

		this.drawHorizontalLine(rowIndex + 1, writer);

		if (this.headerRows && rowIndex === this.headerRows - 1) {
			this.headerRepeatable = writer.currentBlockToRepeatable();
		}

		if (this.dontBreakRows) {
			writer.tracker.auto('pageChanged',
				function () {
					if (!self.headerRows && self.layout.hLineWhenBroken !== false) {
						self.drawHorizontalLine(rowIndex, writer);
					}
				},
				function () {
					writer.commitUnbreakableBlock();
				}
			);
		}

		if (this.headerRepeatable && (rowIndex === (this.rowsWithoutPageBreak - 1) || rowIndex === this.tableNode.table.body.length - 1)) {
			this.headerRepeatableHeight = this.headerRepeatable.height;
			writer.commitUnbreakableBlock();
			writer.pushToRepeatables(this.headerRepeatable);
			this.cleanUpRepeatables = true;
			this.headerRepeatable = null;
		}

		function getLineXs() {
			var result = [];
			var cols = 0;

			for (var i = 0, l = self.tableNode.table.body[rowIndex].length; i < l; i++) {
				if (!cols) {
					result.push({x: self.rowSpanData[i].left, index: i});

					var item = self.tableNode.table.body[rowIndex][i];
					cols = (item._colSpan || item.colSpan || 0);
				}
				if (cols > 0) {
					cols--;
				}
			}

			result.push({x: self.rowSpanData[self.rowSpanData.length - 1].left, index: self.rowSpanData.length - 1});

			return result;
		}
	};

	module.exports = TableProcessor;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

	/*
	PDFDocument - represents an entire PDF document
	By Devon Govett
	 */

	(function() {
	  var PDFDocument, PDFObject, PDFPage, PDFReference, fs, stream,
	    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	    hasProp = {}.hasOwnProperty;

	  stream = __webpack_require__(29);

	  fs = __webpack_require__(54);

	  PDFObject = __webpack_require__(55);

	  PDFReference = __webpack_require__(56);

	  PDFPage = __webpack_require__(74);

	  PDFDocument = (function(superClass) {
	    var mixin;

	    extend(PDFDocument, superClass);

	    function PDFDocument(options1) {
	      var key, ref1, ref2, val;
	      this.options = options1 != null ? options1 : {};
	      PDFDocument.__super__.constructor.apply(this, arguments);
	      this.version = 1.3;
	      this.compress = (ref1 = this.options.compress) != null ? ref1 : true;
	      this._pageBuffer = [];
	      this._pageBufferStart = 0;
	      this._offsets = [];
	      this._waiting = 0;
	      this._ended = false;
	      this._offset = 0;
	      this._root = this.ref({
	        Type: 'Catalog',
	        Pages: this.ref({
	          Type: 'Pages',
	          Count: 0,
	          Kids: []
	        })
	      });
	      this.page = null;
	      this.initColor();
	      this.initVector();
	      this.initFonts();
	      this.initText();
	      this.initImages();
	      this.info = {
	        Producer: 'PDFKit',
	        Creator: 'PDFKit',
	        CreationDate: new Date()
	      };
	      if (this.options.info) {
	        ref2 = this.options.info;
	        for (key in ref2) {
	          val = ref2[key];
	          this.info[key] = val;
	        }
	      }
	      this._write("%PDF-" + this.version);
	      this._write("%\xFF\xFF\xFF\xFF");
	      if (this.options.autoFirstPage !== false) {
	        this.addPage();
	      }
	    }

	    mixin = function(methods) {
	      var method, name, results;
	      results = [];
	      for (name in methods) {
	        method = methods[name];
	        results.push(PDFDocument.prototype[name] = method);
	      }
	      return results;
	    };

	    mixin(__webpack_require__(75));

	    mixin(__webpack_require__(77));

	    mixin(__webpack_require__(79));

	    mixin(__webpack_require__(292));

	    mixin(__webpack_require__(294));

	    mixin(__webpack_require__(300));

	    PDFDocument.prototype.addPage = function(options) {
	      var pages;
	      if (options == null) {
	        options = this.options;
	      }
	      if (!this.options.bufferPages) {
	        this.flushPages();
	      }
	      this.page = new PDFPage(this, options);
	      this._pageBuffer.push(this.page);
	      pages = this._root.data.Pages.data;
	      pages.Kids.push(this.page.dictionary);
	      pages.Count++;
	      this.x = this.page.margins.left;
	      this.y = this.page.margins.top;
	      this._ctm = [1, 0, 0, 1, 0, 0];
	      this.transform(1, 0, 0, -1, 0, this.page.height);
	      this.emit('pageAdded');
	      return this;
	    };

	    PDFDocument.prototype.bufferedPageRange = function() {
	      return {
	        start: this._pageBufferStart,
	        count: this._pageBuffer.length
	      };
	    };

	    PDFDocument.prototype.switchToPage = function(n) {
	      var page;
	      if (!(page = this._pageBuffer[n - this._pageBufferStart])) {
	        throw new Error("switchToPage(" + n + ") out of bounds, current buffer covers pages " + this._pageBufferStart + " to " + (this._pageBufferStart + this._pageBuffer.length - 1));
	      }
	      return this.page = page;
	    };

	    PDFDocument.prototype.flushPages = function() {
	      var i, len, page, pages;
	      pages = this._pageBuffer;
	      this._pageBuffer = [];
	      this._pageBufferStart += pages.length;
	      for (i = 0, len = pages.length; i < len; i++) {
	        page = pages[i];
	        page.end();
	      }
	    };

	    PDFDocument.prototype.ref = function(data) {
	      var ref;
	      ref = new PDFReference(this, this._offsets.length + 1, data);
	      this._offsets.push(null);
	      this._waiting++;
	      return ref;
	    };

	    PDFDocument.prototype._read = function() {};

	    PDFDocument.prototype._write = function(data) {
	      if (!Buffer.isBuffer(data)) {
	        data = new Buffer(data + '\n', 'binary');
	      }
	      this.push(data);
	      return this._offset += data.length;
	    };

	    PDFDocument.prototype.addContent = function(data) {
	      this.page.write(data);
	      return this;
	    };

	    PDFDocument.prototype._refEnd = function(ref) {
	      this._offsets[ref.id - 1] = ref.offset;
	      if (--this._waiting === 0 && this._ended) {
	        this._finalize();
	        return this._ended = false;
	      }
	    };

	    PDFDocument.prototype.write = function(filename, fn) {
	      var err;
	      err = new Error('PDFDocument#write is deprecated, and will be removed in a future version of PDFKit. Please pipe the document into a Node stream.');
	      console.warn(err.stack);
	      this.pipe(fs.createWriteStream(filename));
	      this.end();
	      return this.once('end', fn);
	    };

	    PDFDocument.prototype.output = function(fn) {
	      throw new Error('PDFDocument#output is deprecated, and has been removed from PDFKit. Please pipe the document into a Node stream.');
	    };

	    PDFDocument.prototype.end = function() {
	      var font, key, name, ref1, ref2, val;
	      this.flushPages();
	      this._info = this.ref();
	      ref1 = this.info;
	      for (key in ref1) {
	        val = ref1[key];
	        if (typeof val === 'string') {
	          val = new String(val);
	        }
	        this._info.data[key] = val;
	      }
	      this._info.end();
	      ref2 = this._fontFamilies;
	      for (name in ref2) {
	        font = ref2[name];
	        font.finalize();
	      }
	      this._root.end();
	      this._root.data.Pages.end();
	      if (this._waiting === 0) {
	        return this._finalize();
	      } else {
	        return this._ended = true;
	      }
	    };

	    PDFDocument.prototype._finalize = function(fn) {
	      var i, len, offset, ref1, xRefOffset;
	      xRefOffset = this._offset;
	      this._write("xref");
	      this._write("0 " + (this._offsets.length + 1));
	      this._write("0000000000 65535 f ");
	      ref1 = this._offsets;
	      for (i = 0, len = ref1.length; i < len; i++) {
	        offset = ref1[i];
	        offset = ('0000000000' + offset).slice(-10);
	        this._write(offset + ' 00000 n ');
	      }
	      this._write('trailer');
	      this._write(PDFObject.convert({
	        Size: this._offsets.length + 1,
	        Root: this._root,
	        Info: this._info
	      }));
	      this._write('startxref');
	      this._write("" + xRefOffset);
	      this._write('%%EOF');
	      return this.push(null);
	    };

	    PDFDocument.prototype.toString = function() {
	      return "[object PDFDocument]";
	    };

	    return PDFDocument;

	  })(stream.Readable);

	  module.exports = PDFDocument;

	}).call(this);

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer))

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	module.exports = Stream;

	var EE = __webpack_require__(30).EventEmitter;
	var inherits = __webpack_require__(31);

	inherits(Stream, EE);
	Stream.Readable = __webpack_require__(32);
	Stream.Writable = __webpack_require__(50);
	Stream.Duplex = __webpack_require__(51);
	Stream.Transform = __webpack_require__(52);
	Stream.PassThrough = __webpack_require__(53);

	// Backwards-compat with node 0.4.x
	Stream.Stream = Stream;



	// old-style streams.  Note that the pipe method (the only relevant
	// part of this class) is overridden in the Readable class.

	function Stream() {
	  EE.call(this);
	}

	Stream.prototype.pipe = function(dest, options) {
	  var source = this;

	  function ondata(chunk) {
	    if (dest.writable) {
	      if (false === dest.write(chunk) && source.pause) {
	        source.pause();
	      }
	    }
	  }

	  source.on('data', ondata);

	  function ondrain() {
	    if (source.readable && source.resume) {
	      source.resume();
	    }
	  }

	  dest.on('drain', ondrain);

	  // If the 'end' option is not supplied, dest.end() will be called when
	  // source gets the 'end' or 'close' events.  Only dest.end() once.
	  if (!dest._isStdio && (!options || options.end !== false)) {
	    source.on('end', onend);
	    source.on('close', onclose);
	  }

	  var didOnEnd = false;
	  function onend() {
	    if (didOnEnd) return;
	    didOnEnd = true;

	    dest.end();
	  }


	  function onclose() {
	    if (didOnEnd) return;
	    didOnEnd = true;

	    if (typeof dest.destroy === 'function') dest.destroy();
	  }

	  // don't leave dangling pipes when there are errors.
	  function onerror(er) {
	    cleanup();
	    if (EE.listenerCount(this, 'error') === 0) {
	      throw er; // Unhandled stream error in pipe.
	    }
	  }

	  source.on('error', onerror);
	  dest.on('error', onerror);

	  // remove all the event listeners that were added.
	  function cleanup() {
	    source.removeListener('data', ondata);
	    dest.removeListener('drain', ondrain);

	    source.removeListener('end', onend);
	    source.removeListener('close', onclose);

	    source.removeListener('error', onerror);
	    dest.removeListener('error', onerror);

	    source.removeListener('end', cleanup);
	    source.removeListener('close', cleanup);

	    dest.removeListener('close', cleanup);
	  }

	  source.on('end', cleanup);
	  source.on('close', cleanup);

	  dest.on('close', cleanup);

	  dest.emit('pipe', source);

	  // Allow for unix-like usage: A.pipe(B).pipe(C)
	  return dest;
	};


/***/ }),
/* 30 */
/***/ (function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;

	  if (!this._events)
	    this._events = {};

	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }

	  handler = this._events[type];

	  if (isUndefined(handler))
	    return false;

	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }

	  return true;
	};

	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events)
	    this._events = {};

	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);

	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];

	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }

	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }

	  return this;
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  var fired = false;

	  function g() {
	    this.removeListener(type, g);

	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }

	  g.listener = listener;
	  this.on(type, g);

	  return this;
	};

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events || !this._events[type])
	    return this;

	  list = this._events[type];
	  length = list.length;
	  position = -1;

	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);

	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }

	    if (position < 0)
	      return this;

	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }

	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }

	  return this;
	};

	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;

	  if (!this._events)
	    return this;

	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }

	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }

	  listeners = this._events[type];

	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];

	  return this;
	};

	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};

	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];

	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ }),
/* 31 */
/***/ (function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(33);
	exports.Stream = exports;
	exports.Readable = exports;
	exports.Writable = __webpack_require__(43);
	exports.Duplex = __webpack_require__(42);
	exports.Transform = __webpack_require__(48);
	exports.PassThrough = __webpack_require__(49);


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	'use strict';

	/*<replacement>*/

	var processNextTick = __webpack_require__(35);
	/*</replacement>*/

	module.exports = Readable;

	/*<replacement>*/
	var isArray = __webpack_require__(5);
	/*</replacement>*/

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Readable.ReadableState = ReadableState;

	/*<replacement>*/
	var EE = __webpack_require__(30).EventEmitter;

	var EElistenerCount = function (emitter, type) {
	  return emitter.listeners(type).length;
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = __webpack_require__(36);
	/*</replacement>*/

	// TODO(bmeurer): Change this back to const once hole checks are
	// properly optimized away early in Ignition+TurboFan.
	/*<replacement>*/
	var Buffer = __webpack_require__(37).Buffer;
	var OurUint8Array = global.Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}
	/*</replacement>*/

	/*<replacement>*/
	var util = __webpack_require__(38);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/

	/*<replacement>*/
	var debugUtil = __webpack_require__(39);
	var debug = void 0;
	if (debugUtil && debugUtil.debuglog) {
	  debug = debugUtil.debuglog('stream');
	} else {
	  debug = function () {};
	}
	/*</replacement>*/

	var BufferList = __webpack_require__(40);
	var destroyImpl = __webpack_require__(41);
	var StringDecoder;

	util.inherits(Readable, Stream);

	var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') {
	    return emitter.prependListener(event, fn);
	  } else {
	    // This is a hack to make sure that our error handler is attached before any
	    // userland ones.  NEVER DO THIS. This is here only because this code needs
	    // to continue to work with older versions of Node.js that do not include
	    // the prependListener() method. The goal is to eventually remove this hack.
	    if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
	  }
	}

	function ReadableState(options, stream) {
	  Duplex = Duplex || __webpack_require__(42);

	  options = options || {};

	  // object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away
	  this.objectMode = !!options.objectMode;

	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

	  // the point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);

	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift()
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = null;
	  this.pipesCount = 0;
	  this.flowing = null;
	  this.ended = false;
	  this.endEmitted = false;
	  this.reading = false;

	  // a flag to be able to tell if the event 'readable'/'data' is emitted
	  // immediately, or on a later tick.  We set this to true at first, because
	  // any actions that shouldn't happen until "later" should generally also
	  // not happen before the first read call.
	  this.sync = true;

	  // whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  this.needReadable = false;
	  this.emittedReadable = false;
	  this.readableListening = false;
	  this.resumeScheduled = false;

	  // has it been destroyed
	  this.destroyed = false;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // the number of writers that are awaiting a drain event in .pipe()s
	  this.awaitDrain = 0;

	  // if true, a maybeReadMore has been scheduled
	  this.readingMore = false;

	  this.decoder = null;
	  this.encoding = null;
	  if (options.encoding) {
	    if (!StringDecoder) StringDecoder = __webpack_require__(47).StringDecoder;
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}

	function Readable(options) {
	  Duplex = Duplex || __webpack_require__(42);

	  if (!(this instanceof Readable)) return new Readable(options);

	  this._readableState = new ReadableState(options, this);

	  // legacy
	  this.readable = true;

	  if (options) {
	    if (typeof options.read === 'function') this._read = options.read;

	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	  }

	  Stream.call(this);
	}

	Object.defineProperty(Readable.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._readableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	  }
	});

	Readable.prototype.destroy = destroyImpl.destroy;
	Readable.prototype._undestroy = destroyImpl.undestroy;
	Readable.prototype._destroy = function (err, cb) {
	  this.push(null);
	  cb(err);
	};

	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  var state = this._readableState;
	  var skipChunkCheck;

	  if (!state.objectMode) {
	    if (typeof chunk === 'string') {
	      encoding = encoding || state.defaultEncoding;
	      if (encoding !== state.encoding) {
	        chunk = Buffer.from(chunk, encoding);
	        encoding = '';
	      }
	      skipChunkCheck = true;
	    }
	  } else {
	    skipChunkCheck = true;
	  }

	  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
	};

	// Unshift should *always* be something directly out of read()
	Readable.prototype.unshift = function (chunk) {
	  return readableAddChunk(this, chunk, null, true, false);
	};

	function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
	  var state = stream._readableState;
	  if (chunk === null) {
	    state.reading = false;
	    onEofChunk(stream, state);
	  } else {
	    var er;
	    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
	    if (er) {
	      stream.emit('error', er);
	    } else if (state.objectMode || chunk && chunk.length > 0) {
	      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
	        chunk = _uint8ArrayToBuffer(chunk);
	      }

	      if (addToFront) {
	        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
	      } else if (state.ended) {
	        stream.emit('error', new Error('stream.push() after EOF'));
	      } else {
	        state.reading = false;
	        if (state.decoder && !encoding) {
	          chunk = state.decoder.write(chunk);
	          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
	        } else {
	          addChunk(stream, state, chunk, false);
	        }
	      }
	    } else if (!addToFront) {
	      state.reading = false;
	    }
	  }

	  return needMoreData(state);
	}

	function addChunk(stream, state, chunk, addToFront) {
	  if (state.flowing && state.length === 0 && !state.sync) {
	    stream.emit('data', chunk);
	    stream.read(0);
	  } else {
	    // update the buffer info.
	    state.length += state.objectMode ? 1 : chunk.length;
	    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

	    if (state.needReadable) emitReadable(stream);
	  }
	  maybeReadMore(stream, state);
	}

	function chunkInvalid(state, chunk) {
	  var er;
	  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  return er;
	}

	// if it's past the high water mark, we can push in some more.
	// Also, if we have no data yet, we can stand some
	// more bytes.  This is to work around cases where hwm=0,
	// such as the repl.  Also, if the push() triggered a
	// readable event, and the user called read(largeNumber) such that
	// needReadable was set, then we ought to push more, so that another
	// 'readable' event will be triggered.
	function needMoreData(state) {
	  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
	}

	Readable.prototype.isPaused = function () {
	  return this._readableState.flowing === false;
	};

	// backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  if (!StringDecoder) StringDecoder = __webpack_require__(47).StringDecoder;
	  this._readableState.decoder = new StringDecoder(enc);
	  this._readableState.encoding = enc;
	  return this;
	};

	// Don't raise the hwm > 8MB
	var MAX_HWM = 0x800000;
	function computeNewHighWaterMark(n) {
	  if (n >= MAX_HWM) {
	    n = MAX_HWM;
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n;
	}

	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || state.length === 0 && state.ended) return 0;
	  if (state.objectMode) return 1;
	  if (n !== n) {
	    // Only flow one buffer at a time
	    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
	  }
	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n <= state.length) return n;
	  // Don't have enough
	  if (!state.ended) {
	    state.needReadable = true;
	    return 0;
	  }
	  return state.length;
	}

	// you can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  n = parseInt(n, 10);
	  var state = this._readableState;
	  var nOrig = n;

	  if (n !== 0) state.emittedReadable = false;

	  // if we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
	    return null;
	  }

	  n = howMuchToRead(n, state);

	  // if we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null;
	  }

	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.

	  // if we need a readable event, then we need to do some reading.
	  var doRead = state.needReadable;
	  debug('need readable', doRead);

	  // if we currently have less than the highWaterMark, then also read some
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }

	  // however, if we've ended, then there's no point, and if we're already
	  // reading, then it's unnecessary.
	  if (state.ended || state.reading) {
	    doRead = false;
	    debug('reading or ended', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.reading = true;
	    state.sync = true;
	    // if the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.needReadable = true;
	    // call internal read method
	    this._read(state.highWaterMark);
	    state.sync = false;
	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }

	  var ret;
	  if (n > 0) ret = fromList(n, state);else ret = null;

	  if (ret === null) {
	    state.needReadable = true;
	    n = 0;
	  } else {
	    state.length -= n;
	  }

	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;

	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }

	  if (ret !== null) this.emit('data', ret);

	  return ret;
	};

	function onEofChunk(stream, state) {
	  if (state.ended) return;
	  if (state.decoder) {
	    var chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;

	  // emit 'readable' now to make sure it gets picked up.
	  emitReadable(stream);
	}

	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  var state = stream._readableState;
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    if (state.sync) processNextTick(emitReadable_, stream);else emitReadable_(stream);
	  }
	}

	function emitReadable_(stream) {
	  debug('emit readable');
	  stream.emit('readable');
	  flow(stream);
	}

	// at this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore) {
	    state.readingMore = true;
	    processNextTick(maybeReadMore_, stream, state);
	  }
	}

	function maybeReadMore_(stream, state) {
	  var len = state.length;
	  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // didn't get any data, stop spinning.
	      break;else len = state.length;
	  }
	  state.readingMore = false;
	}

	// abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  this.emit('error', new Error('_read() is not implemented'));
	};

	Readable.prototype.pipe = function (dest, pipeOpts) {
	  var src = this;
	  var state = this._readableState;

	  switch (state.pipesCount) {
	    case 0:
	      state.pipes = dest;
	      break;
	    case 1:
	      state.pipes = [state.pipes, dest];
	      break;
	    default:
	      state.pipes.push(dest);
	      break;
	  }
	  state.pipesCount += 1;
	  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

	  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

	  var endFn = doEnd ? onend : unpipe;
	  if (state.endEmitted) processNextTick(endFn);else src.once('end', endFn);

	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable, unpipeInfo) {
	    debug('onunpipe');
	    if (readable === src) {
	      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
	        unpipeInfo.hasUnpiped = true;
	        cleanup();
	      }
	    }
	  }

	  function onend() {
	    debug('onend');
	    dest.end();
	  }

	  // when the dest drains, it reduces the awaitDrain counter
	  // on the source.  This would be more elegant with a .once()
	  // handler in flow(), but adding and removing repeatedly is
	  // too slow.
	  var ondrain = pipeOnDrain(src);
	  dest.on('drain', ondrain);

	  var cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // cleanup event handlers once the pipe is broken
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    dest.removeListener('drain', ondrain);
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', unpipe);
	    src.removeListener('data', ondata);

	    cleanedUp = true;

	    // if the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }

	  // If the user pushes more data while we're writing to dest then we'll end up
	  // in ondata again. However, we only want to increase awaitDrain once because
	  // dest will only emit one 'drain' event for the multiple writes.
	  // => Introduce a guard on increasing awaitDrain.
	  var increasedAwaitDrain = false;
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    increasedAwaitDrain = false;
	    var ret = dest.write(chunk);
	    if (false === ret && !increasedAwaitDrain) {
	      // If the user unpiped during `dest.write()`, it is possible
	      // to get stuck in a permanently paused state if that write
	      // also returned false.
	      // => Check whether `dest` is still a piping destination.
	      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
	        debug('false write response, pause', src._readableState.awaitDrain);
	        src._readableState.awaitDrain++;
	        increasedAwaitDrain = true;
	      }
	      src.pause();
	    }
	  }

	  // if the dest has an error, then stop piping into it.
	  // however, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
	  }

	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);

	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);

	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }

	  // tell the dest that it's being piped to
	  dest.emit('pipe', src);

	  // start the flow if it hasn't been started already.
	  if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }

	  return dest;
	};

	function pipeOnDrain(src) {
	  return function () {
	    var state = src._readableState;
	    debug('pipeOnDrain', state.awaitDrain);
	    if (state.awaitDrain) state.awaitDrain--;
	    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
	      state.flowing = true;
	      flow(src);
	    }
	  };
	}

	Readable.prototype.unpipe = function (dest) {
	  var state = this._readableState;
	  var unpipeInfo = { hasUnpiped: false };

	  // if we're not piping anywhere, then do nothing.
	  if (state.pipesCount === 0) return this;

	  // just one destination.  most common case.
	  if (state.pipesCount === 1) {
	    // passed in one, but it's not the right one.
	    if (dest && dest !== state.pipes) return this;

	    if (!dest) dest = state.pipes;

	    // got a match.
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    if (dest) dest.emit('unpipe', this, unpipeInfo);
	    return this;
	  }

	  // slow case. multiple pipe destinations.

	  if (!dest) {
	    // remove all.
	    var dests = state.pipes;
	    var len = state.pipesCount;
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;

	    for (var i = 0; i < len; i++) {
	      dests[i].emit('unpipe', this, unpipeInfo);
	    }return this;
	  }

	  // try to find the right one.
	  var index = indexOf(state.pipes, dest);
	  if (index === -1) return this;

	  state.pipes.splice(index, 1);
	  state.pipesCount -= 1;
	  if (state.pipesCount === 1) state.pipes = state.pipes[0];

	  dest.emit('unpipe', this, unpipeInfo);

	  return this;
	};

	// set up data events if they are asked for
	// Ensure readable listeners eventually get something
	Readable.prototype.on = function (ev, fn) {
	  var res = Stream.prototype.on.call(this, ev, fn);

	  if (ev === 'data') {
	    // Start flowing on next tick if stream isn't explicitly paused
	    if (this._readableState.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    var state = this._readableState;
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.emittedReadable = false;
	      if (!state.reading) {
	        processNextTick(nReadingNextTick, this);
	      } else if (state.length) {
	        emitReadable(this);
	      }
	    }
	  }

	  return res;
	};
	Readable.prototype.addListener = Readable.prototype.on;

	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}

	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  var state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    state.flowing = true;
	    resume(this, state);
	  }
	  return this;
	};

	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    processNextTick(resume_, stream, state);
	  }
	}

	function resume_(stream, state) {
	  if (!state.reading) {
	    debug('resume read 0');
	    stream.read(0);
	  }

	  state.resumeScheduled = false;
	  state.awaitDrain = 0;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}

	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (false !== this._readableState.flowing) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  return this;
	};

	function flow(stream) {
	  var state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null) {}
	}

	// wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  var state = this._readableState;
	  var paused = false;

	  var self = this;
	  stream.on('end', function () {
	    debug('wrapped end');
	    if (state.decoder && !state.ended) {
	      var chunk = state.decoder.end();
	      if (chunk && chunk.length) self.push(chunk);
	    }

	    self.push(null);
	  });

	  stream.on('data', function (chunk) {
	    debug('wrapped data');
	    if (state.decoder) chunk = state.decoder.write(chunk);

	    // don't skip over falsy values in objectMode
	    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

	    var ret = self.push(chunk);
	    if (!ret) {
	      paused = true;
	      stream.pause();
	    }
	  });

	  // proxy all the other methods.
	  // important when wrapping filters and duplexes.
	  for (var i in stream) {
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = function (method) {
	        return function () {
	          return stream[method].apply(stream, arguments);
	        };
	      }(i);
	    }
	  }

	  // proxy certain important events.
	  for (var n = 0; n < kProxyEvents.length; n++) {
	    stream.on(kProxyEvents[n], self.emit.bind(self, kProxyEvents[n]));
	  }

	  // when we try to consume some more bytes, simply unpause the
	  // underlying stream.
	  self._read = function (n) {
	    debug('wrapped _read', n);
	    if (paused) {
	      paused = false;
	      stream.resume();
	    }
	  };

	  return self;
	};

	// exposed for testing purposes only.
	Readable._fromList = fromList;

	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered
	  if (state.length === 0) return null;

	  var ret;
	  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
	    // read it all, truncate the list
	    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list
	    ret = fromListPartial(n, state.buffer, state.decoder);
	  }

	  return ret;
	}

	// Extracts only enough buffered data to satisfy the amount requested.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromListPartial(n, list, hasStrings) {
	  var ret;
	  if (n < list.head.data.length) {
	    // slice is the same for buffers and strings
	    ret = list.head.data.slice(0, n);
	    list.head.data = list.head.data.slice(n);
	  } else if (n === list.head.data.length) {
	    // first chunk is a perfect match
	    ret = list.shift();
	  } else {
	    // result spans more than one buffer
	    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
	  }
	  return ret;
	}

	// Copies a specified amount of characters from the list of buffered data
	// chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBufferString(n, list) {
	  var p = list.head;
	  var c = 1;
	  var ret = p.data;
	  n -= ret.length;
	  while (p = p.next) {
	    var str = p.data;
	    var nb = n > str.length ? str.length : n;
	    if (nb === str.length) ret += str;else ret += str.slice(0, n);
	    n -= nb;
	    if (n === 0) {
	      if (nb === str.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = str.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	// Copies a specified amount of bytes from the list of buffered data chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBuffer(n, list) {
	  var ret = Buffer.allocUnsafe(n);
	  var p = list.head;
	  var c = 1;
	  p.data.copy(ret);
	  n -= p.data.length;
	  while (p = p.next) {
	    var buf = p.data;
	    var nb = n > buf.length ? buf.length : n;
	    buf.copy(ret, ret.length - n, 0, nb);
	    n -= nb;
	    if (n === 0) {
	      if (nb === buf.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = buf.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	function endReadable(stream) {
	  var state = stream._readableState;

	  // If we get here before consuming all the bytes, then that is a
	  // bug in node.  Should never happen.
	  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

	  if (!state.endEmitted) {
	    state.ended = true;
	    processNextTick(endReadableNT, state, stream);
	  }
	}

	function endReadableNT(state, stream) {
	  // Check that we didn't get one last unshift.
	  if (!state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.readable = false;
	    stream.emit('end');
	  }
	}

	function forEach(xs, f) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    f(xs[i], i);
	  }
	}

	function indexOf(xs, x) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    if (xs[i] === x) return i;
	  }
	  return -1;
	}
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(34)))

/***/ }),
/* 34 */
/***/ (function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};

	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.

	var cachedSetTimeout;
	var cachedClearTimeout;

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	(function () {
	    try {
	        if (typeof setTimeout === 'function') {
	            cachedSetTimeout = setTimeout;
	        } else {
	            cachedSetTimeout = defaultSetTimout;
	        }
	    } catch (e) {
	        cachedSetTimeout = defaultSetTimout;
	    }
	    try {
	        if (typeof clearTimeout === 'function') {
	            cachedClearTimeout = clearTimeout;
	        } else {
	            cachedClearTimeout = defaultClearTimeout;
	        }
	    } catch (e) {
	        cachedClearTimeout = defaultClearTimeout;
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}

	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};

	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};

	function noop() {}

	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	process.prependListener = noop;
	process.prependOnceListener = noop;

	process.listeners = function (name) { return [] }

	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};

	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {'use strict';

	if (!process.version ||
	    process.version.indexOf('v0.') === 0 ||
	    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
	  module.exports = nextTick;
	} else {
	  module.exports = process.nextTick;
	}

	function nextTick(fn, arg1, arg2, arg3) {
	  if (typeof fn !== 'function') {
	    throw new TypeError('"callback" argument must be a function');
	  }
	  var len = arguments.length;
	  var args, i;
	  switch (len) {
	  case 0:
	  case 1:
	    return process.nextTick(fn);
	  case 2:
	    return process.nextTick(function afterTickOne() {
	      fn.call(null, arg1);
	    });
	  case 3:
	    return process.nextTick(function afterTickTwo() {
	      fn.call(null, arg1, arg2);
	    });
	  case 4:
	    return process.nextTick(function afterTickThree() {
	      fn.call(null, arg1, arg2, arg3);
	    });
	  default:
	    args = new Array(len - 1);
	    i = 0;
	    while (i < args.length) {
	      args[i++] = arguments[i];
	    }
	    return process.nextTick(function afterTick() {
	      fn.apply(null, args);
	    });
	  }
	}

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(34)))

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(30).EventEmitter;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

	/* eslint-disable node/no-deprecated-api */
	var buffer = __webpack_require__(2)
	var Buffer = buffer.Buffer

	// alternative to using Object.keys for old browsers
	function copyProps (src, dst) {
	  for (var key in src) {
	    dst[key] = src[key]
	  }
	}
	if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
	  module.exports = buffer
	} else {
	  // Copy properties from require('buffer')
	  copyProps(buffer, exports)
	  exports.Buffer = SafeBuffer
	}

	function SafeBuffer (arg, encodingOrOffset, length) {
	  return Buffer(arg, encodingOrOffset, length)
	}

	// Copy static methods from Buffer
	copyProps(Buffer, SafeBuffer)

	SafeBuffer.from = function (arg, encodingOrOffset, length) {
	  if (typeof arg === 'number') {
	    throw new TypeError('Argument must not be a number')
	  }
	  return Buffer(arg, encodingOrOffset, length)
	}

	SafeBuffer.alloc = function (size, fill, encoding) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  var buf = Buffer(size)
	  if (fill !== undefined) {
	    if (typeof encoding === 'string') {
	      buf.fill(fill, encoding)
	    } else {
	      buf.fill(fill)
	    }
	  } else {
	    buf.fill(0)
	  }
	  return buf
	}

	SafeBuffer.allocUnsafe = function (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  return Buffer(size)
	}

	SafeBuffer.allocUnsafeSlow = function (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('Argument must be a number')
	  }
	  return buffer.SlowBuffer(size)
	}


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.

	function isArray(arg) {
	  if (Array.isArray) {
	    return Array.isArray(arg);
	  }
	  return objectToString(arg) === '[object Array]';
	}
	exports.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;

	function isRegExp(re) {
	  return objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;

	function isDate(d) {
	  return objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;

	function isError(e) {
	  return (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;

	exports.isBuffer = Buffer.isBuffer;

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer))

/***/ }),
/* 39 */
/***/ (function(module, exports) {

	/* (ignored) */

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	/*<replacement>*/

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	var Buffer = __webpack_require__(37).Buffer;
	/*</replacement>*/

	function copyBuffer(src, target, offset) {
	  src.copy(target, offset);
	}

	module.exports = function () {
	  function BufferList() {
	    _classCallCheck(this, BufferList);

	    this.head = null;
	    this.tail = null;
	    this.length = 0;
	  }

	  BufferList.prototype.push = function push(v) {
	    var entry = { data: v, next: null };
	    if (this.length > 0) this.tail.next = entry;else this.head = entry;
	    this.tail = entry;
	    ++this.length;
	  };

	  BufferList.prototype.unshift = function unshift(v) {
	    var entry = { data: v, next: this.head };
	    if (this.length === 0) this.tail = entry;
	    this.head = entry;
	    ++this.length;
	  };

	  BufferList.prototype.shift = function shift() {
	    if (this.length === 0) return;
	    var ret = this.head.data;
	    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
	    --this.length;
	    return ret;
	  };

	  BufferList.prototype.clear = function clear() {
	    this.head = this.tail = null;
	    this.length = 0;
	  };

	  BufferList.prototype.join = function join(s) {
	    if (this.length === 0) return '';
	    var p = this.head;
	    var ret = '' + p.data;
	    while (p = p.next) {
	      ret += s + p.data;
	    }return ret;
	  };

	  BufferList.prototype.concat = function concat(n) {
	    if (this.length === 0) return Buffer.alloc(0);
	    if (this.length === 1) return this.head.data;
	    var ret = Buffer.allocUnsafe(n >>> 0);
	    var p = this.head;
	    var i = 0;
	    while (p) {
	      copyBuffer(p.data, ret, i);
	      i += p.data.length;
	      p = p.next;
	    }
	    return ret;
	  };

	  return BufferList;
	}();

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	/*<replacement>*/

	var processNextTick = __webpack_require__(35);
	/*</replacement>*/

	// undocumented cb() API, needed for core, not for public API
	function destroy(err, cb) {
	  var _this = this;

	  var readableDestroyed = this._readableState && this._readableState.destroyed;
	  var writableDestroyed = this._writableState && this._writableState.destroyed;

	  if (readableDestroyed || writableDestroyed) {
	    if (cb) {
	      cb(err);
	    } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
	      processNextTick(emitErrorNT, this, err);
	    }
	    return;
	  }

	  // we set destroyed to true before firing error callbacks in order
	  // to make it re-entrance safe in case destroy() is called within callbacks

	  if (this._readableState) {
	    this._readableState.destroyed = true;
	  }

	  // if this is a duplex stream mark the writable part as destroyed as well
	  if (this._writableState) {
	    this._writableState.destroyed = true;
	  }

	  this._destroy(err || null, function (err) {
	    if (!cb && err) {
	      processNextTick(emitErrorNT, _this, err);
	      if (_this._writableState) {
	        _this._writableState.errorEmitted = true;
	      }
	    } else if (cb) {
	      cb(err);
	    }
	  });
	}

	function undestroy() {
	  if (this._readableState) {
	    this._readableState.destroyed = false;
	    this._readableState.reading = false;
	    this._readableState.ended = false;
	    this._readableState.endEmitted = false;
	  }

	  if (this._writableState) {
	    this._writableState.destroyed = false;
	    this._writableState.ended = false;
	    this._writableState.ending = false;
	    this._writableState.finished = false;
	    this._writableState.errorEmitted = false;
	  }
	}

	function emitErrorNT(self, err) {
	  self.emit('error', err);
	}

	module.exports = {
	  destroy: destroy,
	  undestroy: undestroy
	};

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// a duplex stream is just a stream that is both readable and writable.
	// Since JS doesn't have multiple prototypal inheritance, this class
	// prototypally inherits from Readable, and then parasitically from
	// Writable.

	'use strict';

	/*<replacement>*/

	var processNextTick = __webpack_require__(35);
	/*</replacement>*/

	/*<replacement>*/
	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) {
	    keys.push(key);
	  }return keys;
	};
	/*</replacement>*/

	module.exports = Duplex;

	/*<replacement>*/
	var util = __webpack_require__(38);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/

	var Readable = __webpack_require__(33);
	var Writable = __webpack_require__(43);

	util.inherits(Duplex, Readable);

	var keys = objectKeys(Writable.prototype);
	for (var v = 0; v < keys.length; v++) {
	  var method = keys[v];
	  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	}

	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options);

	  Readable.call(this, options);
	  Writable.call(this, options);

	  if (options && options.readable === false) this.readable = false;

	  if (options && options.writable === false) this.writable = false;

	  this.allowHalfOpen = true;
	  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

	  this.once('end', onend);
	}

	// the no-half-open enforcer
	function onend() {
	  // if we allow half-open state, or if the writable side ended,
	  // then we're ok.
	  if (this.allowHalfOpen || this._writableState.ended) return;

	  // no more data can be written.
	  // But allow more writes to happen in this tick.
	  processNextTick(onEndNT, this);
	}

	function onEndNT(self) {
	  self.end();
	}

	Object.defineProperty(Duplex.prototype, 'destroyed', {
	  get: function () {
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return false;
	    }
	    return this._readableState.destroyed && this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (this._readableState === undefined || this._writableState === undefined) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._readableState.destroyed = value;
	    this._writableState.destroyed = value;
	  }
	});

	Duplex.prototype._destroy = function (err, cb) {
	  this.push(null);
	  this.end();

	  processNextTick(cb, err);
	};

	function forEach(xs, f) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    f(xs[i], i);
	  }
	}

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// A bit simpler than readable streams.
	// Implement an async ._write(chunk, encoding, cb), and it'll handle all
	// the drain event emission and buffering.

	'use strict';

	/*<replacement>*/

	var processNextTick = __webpack_require__(35);
	/*</replacement>*/

	module.exports = Writable;

	/* <replacement> */
	function WriteReq(chunk, encoding, cb) {
	  this.chunk = chunk;
	  this.encoding = encoding;
	  this.callback = cb;
	  this.next = null;
	}

	// It seems a linked list but it is not
	// there will be only 2 of these for each stream
	function CorkedRequest(state) {
	  var _this = this;

	  this.next = null;
	  this.entry = null;
	  this.finish = function () {
	    onCorkedFinish(_this, state);
	  };
	}
	/* </replacement> */

	/*<replacement>*/
	var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
	/*</replacement>*/

	/*<replacement>*/
	var Duplex;
	/*</replacement>*/

	Writable.WritableState = WritableState;

	/*<replacement>*/
	var util = __webpack_require__(38);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/

	/*<replacement>*/
	var internalUtil = {
	  deprecate: __webpack_require__(46)
	};
	/*</replacement>*/

	/*<replacement>*/
	var Stream = __webpack_require__(36);
	/*</replacement>*/

	/*<replacement>*/
	var Buffer = __webpack_require__(37).Buffer;
	var OurUint8Array = global.Uint8Array || function () {};
	function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk);
	}
	function _isUint8Array(obj) {
	  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
	}
	/*</replacement>*/

	var destroyImpl = __webpack_require__(41);

	util.inherits(Writable, Stream);

	function nop() {}

	function WritableState(options, stream) {
	  Duplex = Duplex || __webpack_require__(42);

	  options = options || {};

	  // object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!options.objectMode;

	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

	  // the point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write()
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

	  // cast to ints.
	  this.highWaterMark = Math.floor(this.highWaterMark);

	  // if _final has been called
	  this.finalCalled = false;

	  // drain event flag.
	  this.needDrain = false;
	  // at the start of calling end()
	  this.ending = false;
	  // when end() has been called, and returned
	  this.ended = false;
	  // when 'finish' is emitted
	  this.finished = false;

	  // has it been destroyed
	  this.destroyed = false;

	  // should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  var noDecode = options.decodeStrings === false;
	  this.decodeStrings = !noDecode;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;

	  // a flag to see when we're in the middle of a write.
	  this.writing = false;

	  // when true all writes will be buffered until .uncork() call
	  this.corked = 0;

	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // a flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;

	  // the callback that's passed to _write(chunk,cb)
	  this.onwrite = function (er) {
	    onwrite(stream, er);
	  };

	  // the callback that the user supplies to write(chunk,encoding,cb)
	  this.writecb = null;

	  // the amount that is being written when _write is called.
	  this.writelen = 0;

	  this.bufferedRequest = null;
	  this.lastBufferedRequest = null;

	  // number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted
	  this.pendingcb = 0;

	  // emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams
	  this.prefinished = false;

	  // True if the error was already emitted and should not be thrown again
	  this.errorEmitted = false;

	  // count buffered requests
	  this.bufferedRequestCount = 0;

	  // allocate the first CorkedRequest, there is always
	  // one allocated and free to use, and we maintain at most two
	  this.corkedRequestsFree = new CorkedRequest(this);
	}

	WritableState.prototype.getBuffer = function getBuffer() {
	  var current = this.bufferedRequest;
	  var out = [];
	  while (current) {
	    out.push(current);
	    current = current.next;
	  }
	  return out;
	};

	(function () {
	  try {
	    Object.defineProperty(WritableState.prototype, 'buffer', {
	      get: internalUtil.deprecate(function () {
	        return this.getBuffer();
	      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
	    });
	  } catch (_) {}
	})();

	// Test _writableState for inheritance to account for Duplex streams,
	// whose prototype chain only points to Readable.
	var realHasInstance;
	if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
	  realHasInstance = Function.prototype[Symbol.hasInstance];
	  Object.defineProperty(Writable, Symbol.hasInstance, {
	    value: function (object) {
	      if (realHasInstance.call(this, object)) return true;

	      return object && object._writableState instanceof WritableState;
	    }
	  });
	} else {
	  realHasInstance = function (object) {
	    return object instanceof this;
	  };
	}

	function Writable(options) {
	  Duplex = Duplex || __webpack_require__(42);

	  // Writable ctor is applied to Duplexes, too.
	  // `realHasInstance` is necessary because using plain `instanceof`
	  // would return false, as no `_writableState` property is attached.

	  // Trying to use the custom `instanceof` for Writable here will also break the
	  // Node.js LazyTransform implementation, which has a non-trivial getter for
	  // `_writableState` that would lead to infinite recursion.
	  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
	    return new Writable(options);
	  }

	  this._writableState = new WritableState(options, this);

	  // legacy.
	  this.writable = true;

	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;

	    if (typeof options.writev === 'function') this._writev = options.writev;

	    if (typeof options.destroy === 'function') this._destroy = options.destroy;

	    if (typeof options.final === 'function') this._final = options.final;
	  }

	  Stream.call(this);
	}

	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  this.emit('error', new Error('Cannot pipe, not readable'));
	};

	function writeAfterEnd(stream, cb) {
	  var er = new Error('write after end');
	  // TODO: defer error events consistently everywhere, not just the cb
	  stream.emit('error', er);
	  processNextTick(cb, er);
	}

	// Checks that a user-supplied chunk is valid, especially for the particular
	// mode the stream is in. Currently this means that `null` is never accepted
	// and undefined/non-string values are only allowed in object mode.
	function validChunk(stream, state, chunk, cb) {
	  var valid = true;
	  var er = false;

	  if (chunk === null) {
	    er = new TypeError('May not write null values to stream');
	  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  if (er) {
	    stream.emit('error', er);
	    processNextTick(cb, er);
	    valid = false;
	  }
	  return valid;
	}

	Writable.prototype.write = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  var ret = false;
	  var isBuf = _isUint8Array(chunk) && !state.objectMode;

	  if (isBuf && !Buffer.isBuffer(chunk)) {
	    chunk = _uint8ArrayToBuffer(chunk);
	  }

	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

	  if (typeof cb !== 'function') cb = nop;

	  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
	    state.pendingcb++;
	    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
	  }

	  return ret;
	};

	Writable.prototype.cork = function () {
	  var state = this._writableState;

	  state.corked++;
	};

	Writable.prototype.uncork = function () {
	  var state = this._writableState;

	  if (state.corked) {
	    state.corked--;

	    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
	  }
	};

	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
	  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
	  this._writableState.defaultEncoding = encoding;
	  return this;
	};

	function decodeChunk(state, chunk, encoding) {
	  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
	    chunk = Buffer.from(chunk, encoding);
	  }
	  return chunk;
	}

	// if we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
	  if (!isBuf) {
	    var newChunk = decodeChunk(state, chunk, encoding);
	    if (chunk !== newChunk) {
	      isBuf = true;
	      encoding = 'buffer';
	      chunk = newChunk;
	    }
	  }
	  var len = state.objectMode ? 1 : chunk.length;

	  state.length += len;

	  var ret = state.length < state.highWaterMark;
	  // we must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;

	  if (state.writing || state.corked) {
	    var last = state.lastBufferedRequest;
	    state.lastBufferedRequest = {
	      chunk: chunk,
	      encoding: encoding,
	      isBuf: isBuf,
	      callback: cb,
	      next: null
	    };
	    if (last) {
	      last.next = state.lastBufferedRequest;
	    } else {
	      state.bufferedRequest = state.lastBufferedRequest;
	    }
	    state.bufferedRequestCount += 1;
	  } else {
	    doWrite(stream, state, false, len, chunk, encoding, cb);
	  }

	  return ret;
	}

	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}

	function onwriteError(stream, state, sync, er, cb) {
	  --state.pendingcb;

	  if (sync) {
	    // defer the callback if we are being called synchronously
	    // to avoid piling up things on the stack
	    processNextTick(cb, er);
	    // this can emit finish, and it will always happen
	    // after error
	    processNextTick(finishMaybe, stream, state);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	  } else {
	    // the caller expect this to happen before if
	    // it is async
	    cb(er);
	    stream._writableState.errorEmitted = true;
	    stream.emit('error', er);
	    // this can emit finish, but finish must
	    // always follow error
	    finishMaybe(stream, state);
	  }
	}

	function onwriteStateUpdate(state) {
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	}

	function onwrite(stream, er) {
	  var state = stream._writableState;
	  var sync = state.sync;
	  var cb = state.writecb;

	  onwriteStateUpdate(state);

	  if (er) onwriteError(stream, state, sync, er, cb);else {
	    // Check if we're actually ready to finish, but don't emit yet
	    var finished = needFinish(state);

	    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
	      clearBuffer(stream, state);
	    }

	    if (sync) {
	      /*<replacement>*/
	      asyncWrite(afterWrite, stream, state, finished, cb);
	      /*</replacement>*/
	    } else {
	      afterWrite(stream, state, finished, cb);
	    }
	  }
	}

	function afterWrite(stream, state, finished, cb) {
	  if (!finished) onwriteDrain(stream, state);
	  state.pendingcb--;
	  cb();
	  finishMaybe(stream, state);
	}

	// Must force callback to be called on nextTick, so that we don't
	// emit 'drain' before the write() consumer gets the 'false' return
	// value, and has a chance to attach a 'drain' listener.
	function onwriteDrain(stream, state) {
	  if (state.length === 0 && state.needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	}

	// if there's something in the buffer waiting, then process it
	function clearBuffer(stream, state) {
	  state.bufferProcessing = true;
	  var entry = state.bufferedRequest;

	  if (stream._writev && entry && entry.next) {
	    // Fast case, write everything using _writev()
	    var l = state.bufferedRequestCount;
	    var buffer = new Array(l);
	    var holder = state.corkedRequestsFree;
	    holder.entry = entry;

	    var count = 0;
	    var allBuffers = true;
	    while (entry) {
	      buffer[count] = entry;
	      if (!entry.isBuf) allBuffers = false;
	      entry = entry.next;
	      count += 1;
	    }
	    buffer.allBuffers = allBuffers;

	    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

	    // doWrite is almost always async, defer these to save a bit of time
	    // as the hot path ends with doWrite
	    state.pendingcb++;
	    state.lastBufferedRequest = null;
	    if (holder.next) {
	      state.corkedRequestsFree = holder.next;
	      holder.next = null;
	    } else {
	      state.corkedRequestsFree = new CorkedRequest(state);
	    }
	  } else {
	    // Slow case, write chunks one-by-one
	    while (entry) {
	      var chunk = entry.chunk;
	      var encoding = entry.encoding;
	      var cb = entry.callback;
	      var len = state.objectMode ? 1 : chunk.length;

	      doWrite(stream, state, false, len, chunk, encoding, cb);
	      entry = entry.next;
	      // if we didn't call the onwrite immediately, then
	      // it means that we need to wait until it does.
	      // also, that means that the chunk and cb are currently
	      // being processed, so move the buffer counter past them.
	      if (state.writing) {
	        break;
	      }
	    }

	    if (entry === null) state.lastBufferedRequest = null;
	  }

	  state.bufferedRequestCount = 0;
	  state.bufferedRequest = entry;
	  state.bufferProcessing = false;
	}

	Writable.prototype._write = function (chunk, encoding, cb) {
	  cb(new Error('_write() is not implemented'));
	};

	Writable.prototype._writev = null;

	Writable.prototype.end = function (chunk, encoding, cb) {
	  var state = this._writableState;

	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

	  // .end() fully uncorks
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }

	  // ignore unnecessary end() calls.
	  if (!state.ending && !state.finished) endWritable(this, state, cb);
	};

	function needFinish(state) {
	  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
	}
	function callFinal(stream, state) {
	  stream._final(function (err) {
	    state.pendingcb--;
	    if (err) {
	      stream.emit('error', err);
	    }
	    state.prefinished = true;
	    stream.emit('prefinish');
	    finishMaybe(stream, state);
	  });
	}
	function prefinish(stream, state) {
	  if (!state.prefinished && !state.finalCalled) {
	    if (typeof stream._final === 'function') {
	      state.pendingcb++;
	      state.finalCalled = true;
	      processNextTick(callFinal, stream, state);
	    } else {
	      state.prefinished = true;
	      stream.emit('prefinish');
	    }
	  }
	}

	function finishMaybe(stream, state) {
	  var need = needFinish(state);
	  if (need) {
	    prefinish(stream, state);
	    if (state.pendingcb === 0) {
	      state.finished = true;
	      stream.emit('finish');
	    }
	  }
	  return need;
	}

	function endWritable(stream, state, cb) {
	  state.ending = true;
	  finishMaybe(stream, state);
	  if (cb) {
	    if (state.finished) processNextTick(cb);else stream.once('finish', cb);
	  }
	  state.ended = true;
	  stream.writable = false;
	}

	function onCorkedFinish(corkReq, state, err) {
	  var entry = corkReq.entry;
	  corkReq.entry = null;
	  while (entry) {
	    var cb = entry.callback;
	    state.pendingcb--;
	    cb(err);
	    entry = entry.next;
	  }
	  if (state.corkedRequestsFree) {
	    state.corkedRequestsFree.next = corkReq;
	  } else {
	    state.corkedRequestsFree = corkReq;
	  }
	}

	Object.defineProperty(Writable.prototype, 'destroyed', {
	  get: function () {
	    if (this._writableState === undefined) {
	      return false;
	    }
	    return this._writableState.destroyed;
	  },
	  set: function (value) {
	    // we ignore the value if the stream
	    // has not been initialized yet
	    if (!this._writableState) {
	      return;
	    }

	    // backward compatibility, the user is explicitly
	    // managing destroyed
	    this._writableState.destroyed = value;
	  }
	});

	Writable.prototype.destroy = destroyImpl.destroy;
	Writable.prototype._undestroy = destroyImpl.undestroy;
	Writable.prototype._destroy = function (err, cb) {
	  this.end();
	  cb(err);
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(34), __webpack_require__(44).setImmediate, (function() { return this; }())))

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

	var apply = Function.prototype.apply;

	// DOM APIs, for completeness

	exports.setTimeout = function() {
	  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
	};
	exports.setInterval = function() {
	  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
	};
	exports.clearTimeout =
	exports.clearInterval = function(timeout) {
	  if (timeout) {
	    timeout.close();
	  }
	};

	function Timeout(id, clearFn) {
	  this._id = id;
	  this._clearFn = clearFn;
	}
	Timeout.prototype.unref = Timeout.prototype.ref = function() {};
	Timeout.prototype.close = function() {
	  this._clearFn.call(window, this._id);
	};

	// Does not start the time, just sets up the members needed.
	exports.enroll = function(item, msecs) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = msecs;
	};

	exports.unenroll = function(item) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = -1;
	};

	exports._unrefActive = exports.active = function(item) {
	  clearTimeout(item._idleTimeoutId);

	  var msecs = item._idleTimeout;
	  if (msecs >= 0) {
	    item._idleTimeoutId = setTimeout(function onTimeout() {
	      if (item._onTimeout)
	        item._onTimeout();
	    }, msecs);
	  }
	};

	// setimmediate attaches itself to the global object
	__webpack_require__(45);
	exports.setImmediate = setImmediate;
	exports.clearImmediate = clearImmediate;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {(function (global, undefined) {
	    "use strict";

	    if (global.setImmediate) {
	        return;
	    }

	    var nextHandle = 1; // Spec says greater than zero
	    var tasksByHandle = {};
	    var currentlyRunningATask = false;
	    var doc = global.document;
	    var registerImmediate;

	    function setImmediate(callback) {
	      // Callback can either be a function or a string
	      if (typeof callback !== "function") {
	        callback = new Function("" + callback);
	      }
	      // Copy function arguments
	      var args = new Array(arguments.length - 1);
	      for (var i = 0; i < args.length; i++) {
	          args[i] = arguments[i + 1];
	      }
	      // Store and register the task
	      var task = { callback: callback, args: args };
	      tasksByHandle[nextHandle] = task;
	      registerImmediate(nextHandle);
	      return nextHandle++;
	    }

	    function clearImmediate(handle) {
	        delete tasksByHandle[handle];
	    }

	    function run(task) {
	        var callback = task.callback;
	        var args = task.args;
	        switch (args.length) {
	        case 0:
	            callback();
	            break;
	        case 1:
	            callback(args[0]);
	            break;
	        case 2:
	            callback(args[0], args[1]);
	            break;
	        case 3:
	            callback(args[0], args[1], args[2]);
	            break;
	        default:
	            callback.apply(undefined, args);
	            break;
	        }
	    }

	    function runIfPresent(handle) {
	        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
	        // So if we're currently running a task, we'll need to delay this invocation.
	        if (currentlyRunningATask) {
	            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
	            // "too much recursion" error.
	            setTimeout(runIfPresent, 0, handle);
	        } else {
	            var task = tasksByHandle[handle];
	            if (task) {
	                currentlyRunningATask = true;
	                try {
	                    run(task);
	                } finally {
	                    clearImmediate(handle);
	                    currentlyRunningATask = false;
	                }
	            }
	        }
	    }

	    function installNextTickImplementation() {
	        registerImmediate = function(handle) {
	            process.nextTick(function () { runIfPresent(handle); });
	        };
	    }

	    function canUsePostMessage() {
	        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
	        // where `global.postMessage` means something completely different and can't be used for this purpose.
	        if (global.postMessage && !global.importScripts) {
	            var postMessageIsAsynchronous = true;
	            var oldOnMessage = global.onmessage;
	            global.onmessage = function() {
	                postMessageIsAsynchronous = false;
	            };
	            global.postMessage("", "*");
	            global.onmessage = oldOnMessage;
	            return postMessageIsAsynchronous;
	        }
	    }

	    function installPostMessageImplementation() {
	        // Installs an event handler on `global` for the `message` event: see
	        // * https://developer.mozilla.org/en/DOM/window.postMessage
	        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages

	        var messagePrefix = "setImmediate$" + Math.random() + "$";
	        var onGlobalMessage = function(event) {
	            if (event.source === global &&
	                typeof event.data === "string" &&
	                event.data.indexOf(messagePrefix) === 0) {
	                runIfPresent(+event.data.slice(messagePrefix.length));
	            }
	        };

	        if (global.addEventListener) {
	            global.addEventListener("message", onGlobalMessage, false);
	        } else {
	            global.attachEvent("onmessage", onGlobalMessage);
	        }

	        registerImmediate = function(handle) {
	            global.postMessage(messagePrefix + handle, "*");
	        };
	    }

	    function installMessageChannelImplementation() {
	        var channel = new MessageChannel();
	        channel.port1.onmessage = function(event) {
	            var handle = event.data;
	            runIfPresent(handle);
	        };

	        registerImmediate = function(handle) {
	            channel.port2.postMessage(handle);
	        };
	    }

	    function installReadyStateChangeImplementation() {
	        var html = doc.documentElement;
	        registerImmediate = function(handle) {
	            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
	            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
	            var script = doc.createElement("script");
	            script.onreadystatechange = function () {
	                runIfPresent(handle);
	                script.onreadystatechange = null;
	                html.removeChild(script);
	                script = null;
	            };
	            html.appendChild(script);
	        };
	    }

	    function installSetTimeoutImplementation() {
	        registerImmediate = function(handle) {
	            setTimeout(runIfPresent, 0, handle);
	        };
	    }

	    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
	    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
	    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;

	    // Don't get fooled by e.g. browserify environments.
	    if ({}.toString.call(global.process) === "[object process]") {
	        // For Node.js before 0.9
	        installNextTickImplementation();

	    } else if (canUsePostMessage()) {
	        // For non-IE10 modern browsers
	        installPostMessageImplementation();

	    } else if (global.MessageChannel) {
	        // For web workers, where supported
	        installMessageChannelImplementation();

	    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
	        // For IE 6–8
	        installReadyStateChangeImplementation();

	    } else {
	        // For older browsers
	        installSetTimeoutImplementation();
	    }

	    attachTo.setImmediate = setImmediate;
	    attachTo.clearImmediate = clearImmediate;
	}(typeof self === "undefined" ? typeof global === "undefined" ? this : global : self));

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(34)))

/***/ }),
/* 46 */
/***/ (function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {
	/**
	 * Module exports.
	 */

	module.exports = deprecate;

	/**
	 * Mark that a method should not be used.
	 * Returns a modified function which warns once by default.
	 *
	 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
	 *
	 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
	 * will throw an Error when invoked.
	 *
	 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
	 * will invoke `console.trace()` instead of `console.error()`.
	 *
	 * @param {Function} fn - the function to deprecate
	 * @param {String} msg - the string to print to the console when `fn` is invoked
	 * @returns {Function} a new "deprecated" version of `fn`
	 * @api public
	 */

	function deprecate (fn, msg) {
	  if (config('noDeprecation')) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (config('throwDeprecation')) {
	        throw new Error(msg);
	      } else if (config('traceDeprecation')) {
	        console.trace(msg);
	      } else {
	        console.warn(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	/**
	 * Checks `localStorage` for boolean values for the given `name`.
	 *
	 * @param {String} name
	 * @returns {Boolean}
	 * @api private
	 */

	function config (name) {
	  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
	  try {
	    if (!global.localStorage) return false;
	  } catch (_) {
	    return false;
	  }
	  var val = global.localStorage[name];
	  if (null == val) return false;
	  return String(val).toLowerCase() === 'true';
	}

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	var Buffer = __webpack_require__(37).Buffer;

	var isEncoding = Buffer.isEncoding || function (encoding) {
	  encoding = '' + encoding;
	  switch (encoding && encoding.toLowerCase()) {
	    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
	      return true;
	    default:
	      return false;
	  }
	};

	function _normalizeEncoding(enc) {
	  if (!enc) return 'utf8';
	  var retried;
	  while (true) {
	    switch (enc) {
	      case 'utf8':
	      case 'utf-8':
	        return 'utf8';
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return 'utf16le';
	      case 'latin1':
	      case 'binary':
	        return 'latin1';
	      case 'base64':
	      case 'ascii':
	      case 'hex':
	        return enc;
	      default:
	        if (retried) return; // undefined
	        enc = ('' + enc).toLowerCase();
	        retried = true;
	    }
	  }
	};

	// Do not cache `Buffer.isEncoding` when checking encoding names as some
	// modules monkey-patch it to support additional encodings
	function normalizeEncoding(enc) {
	  var nenc = _normalizeEncoding(enc);
	  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
	  return nenc || enc;
	}

	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters.
	exports.StringDecoder = StringDecoder;
	function StringDecoder(encoding) {
	  this.encoding = normalizeEncoding(encoding);
	  var nb;
	  switch (this.encoding) {
	    case 'utf16le':
	      this.text = utf16Text;
	      this.end = utf16End;
	      nb = 4;
	      break;
	    case 'utf8':
	      this.fillLast = utf8FillLast;
	      nb = 4;
	      break;
	    case 'base64':
	      this.text = base64Text;
	      this.end = base64End;
	      nb = 3;
	      break;
	    default:
	      this.write = simpleWrite;
	      this.end = simpleEnd;
	      return;
	  }
	  this.lastNeed = 0;
	  this.lastTotal = 0;
	  this.lastChar = Buffer.allocUnsafe(nb);
	}

	StringDecoder.prototype.write = function (buf) {
	  if (buf.length === 0) return '';
	  var r;
	  var i;
	  if (this.lastNeed) {
	    r = this.fillLast(buf);
	    if (r === undefined) return '';
	    i = this.lastNeed;
	    this.lastNeed = 0;
	  } else {
	    i = 0;
	  }
	  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
	  return r || '';
	};

	StringDecoder.prototype.end = utf8End;

	// Returns only complete characters in a Buffer
	StringDecoder.prototype.text = utf8Text;

	// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
	StringDecoder.prototype.fillLast = function (buf) {
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
	  this.lastNeed -= buf.length;
	};

	// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
	// continuation byte.
	function utf8CheckByte(byte) {
	  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
	  return -1;
	}

	// Checks at most 3 bytes at the end of a Buffer in order to detect an
	// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
	// needed to complete the UTF-8 character (if applicable) are returned.
	function utf8CheckIncomplete(self, buf, i) {
	  var j = buf.length - 1;
	  if (j < i) return 0;
	  var nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 1;
	    return nb;
	  }
	  if (--j < i) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 2;
	    return nb;
	  }
	  if (--j < i) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) {
	      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
	    }
	    return nb;
	  }
	  return 0;
	}

	// Validates as many continuation bytes for a multi-byte UTF-8 character as
	// needed or are available. If we see a non-continuation byte where we expect
	// one, we "replace" the validated continuation bytes we've seen so far with
	// UTF-8 replacement characters ('\ufffd'), to match v8's UTF-8 decoding
	// behavior. The continuation byte check is included three times in the case
	// where all of the continuation bytes for a character exist in the same buffer.
	// It is also done this way as a slight performance increase instead of using a
	// loop.
	function utf8CheckExtraBytes(self, buf, p) {
	  if ((buf[0] & 0xC0) !== 0x80) {
	    self.lastNeed = 0;
	    return '\ufffd'.repeat(p);
	  }
	  if (self.lastNeed > 1 && buf.length > 1) {
	    if ((buf[1] & 0xC0) !== 0x80) {
	      self.lastNeed = 1;
	      return '\ufffd'.repeat(p + 1);
	    }
	    if (self.lastNeed > 2 && buf.length > 2) {
	      if ((buf[2] & 0xC0) !== 0x80) {
	        self.lastNeed = 2;
	        return '\ufffd'.repeat(p + 2);
	      }
	    }
	  }
	}

	// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
	function utf8FillLast(buf) {
	  var p = this.lastTotal - this.lastNeed;
	  var r = utf8CheckExtraBytes(this, buf, p);
	  if (r !== undefined) return r;
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, p, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, p, 0, buf.length);
	  this.lastNeed -= buf.length;
	}

	// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
	// partial character, the character's bytes are buffered until the required
	// number of bytes are available.
	function utf8Text(buf, i) {
	  var total = utf8CheckIncomplete(this, buf, i);
	  if (!this.lastNeed) return buf.toString('utf8', i);
	  this.lastTotal = total;
	  var end = buf.length - (total - this.lastNeed);
	  buf.copy(this.lastChar, 0, end);
	  return buf.toString('utf8', i, end);
	}

	// For UTF-8, a replacement character for each buffered byte of a (partial)
	// character needs to be added to the output.
	function utf8End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + '\ufffd'.repeat(this.lastTotal - this.lastNeed);
	  return r;
	}

	// UTF-16LE typically needs two bytes per character, but even if we have an even
	// number of bytes available, we need to check if we end on a leading/high
	// surrogate. In that case, we need to wait for the next two bytes in order to
	// decode the last character properly.
	function utf16Text(buf, i) {
	  if ((buf.length - i) % 2 === 0) {
	    var r = buf.toString('utf16le', i);
	    if (r) {
	      var c = r.charCodeAt(r.length - 1);
	      if (c >= 0xD800 && c <= 0xDBFF) {
	        this.lastNeed = 2;
	        this.lastTotal = 4;
	        this.lastChar[0] = buf[buf.length - 2];
	        this.lastChar[1] = buf[buf.length - 1];
	        return r.slice(0, -1);
	      }
	    }
	    return r;
	  }
	  this.lastNeed = 1;
	  this.lastTotal = 2;
	  this.lastChar[0] = buf[buf.length - 1];
	  return buf.toString('utf16le', i, buf.length - 1);
	}

	// For UTF-16LE we do not explicitly append special replacement characters if we
	// end on a partial character, we simply let v8 handle that.
	function utf16End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) {
	    var end = this.lastTotal - this.lastNeed;
	    return r + this.lastChar.toString('utf16le', 0, end);
	  }
	  return r;
	}

	function base64Text(buf, i) {
	  var n = (buf.length - i) % 3;
	  if (n === 0) return buf.toString('base64', i);
	  this.lastNeed = 3 - n;
	  this.lastTotal = 3;
	  if (n === 1) {
	    this.lastChar[0] = buf[buf.length - 1];
	  } else {
	    this.lastChar[0] = buf[buf.length - 2];
	    this.lastChar[1] = buf[buf.length - 1];
	  }
	  return buf.toString('base64', i, buf.length - n);
	}

	function base64End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
	  return r;
	}

	// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
	function simpleWrite(buf) {
	  return buf.toString(this.encoding);
	}

	function simpleEnd(buf) {
	  return buf && buf.length ? this.write(buf) : '';
	}

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// a transform stream is a readable/writable stream where you do
	// something with the data.  Sometimes it's called a "filter",
	// but that's not a great name for it, since that implies a thing where
	// some bits pass through, and others are simply ignored.  (That would
	// be a valid example of a transform, of course.)
	//
	// While the output is causally related to the input, it's not a
	// necessarily symmetric or synchronous transformation.  For example,
	// a zlib stream might take multiple plain-text writes(), and then
	// emit a single compressed chunk some time in the future.
	//
	// Here's how this works:
	//
	// The Transform stream has all the aspects of the readable and writable
	// stream classes.  When you write(chunk), that calls _write(chunk,cb)
	// internally, and returns false if there's a lot of pending writes
	// buffered up.  When you call read(), that calls _read(n) until
	// there's enough pending readable data buffered up.
	//
	// In a transform stream, the written data is placed in a buffer.  When
	// _read(n) is called, it transforms the queued up data, calling the
	// buffered _write cb's as it consumes chunks.  If consuming a single
	// written chunk would result in multiple output chunks, then the first
	// outputted bit calls the readcb, and subsequent chunks just go into
	// the read buffer, and will cause it to emit 'readable' if necessary.
	//
	// This way, back-pressure is actually determined by the reading side,
	// since _read has to be called to start processing a new chunk.  However,
	// a pathological inflate type of transform can cause excessive buffering
	// here.  For example, imagine a stream where every byte of input is
	// interpreted as an integer from 0-255, and then results in that many
	// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
	// 1kb of data being output.  In this case, you could write a very small
	// amount of input, and end up with a very large amount of output.  In
	// such a pathological inflating mechanism, there'd be no way to tell
	// the system to stop doing the transform.  A single 4MB write could
	// cause the system to run out of memory.
	//
	// However, even in such a pathological case, only a single written chunk
	// would be consumed, and then the rest would wait (un-transformed) until
	// the results of the previous transformed chunk were consumed.

	'use strict';

	module.exports = Transform;

	var Duplex = __webpack_require__(42);

	/*<replacement>*/
	var util = __webpack_require__(38);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/

	util.inherits(Transform, Duplex);

	function TransformState(stream) {
	  this.afterTransform = function (er, data) {
	    return afterTransform(stream, er, data);
	  };

	  this.needTransform = false;
	  this.transforming = false;
	  this.writecb = null;
	  this.writechunk = null;
	  this.writeencoding = null;
	}

	function afterTransform(stream, er, data) {
	  var ts = stream._transformState;
	  ts.transforming = false;

	  var cb = ts.writecb;

	  if (!cb) {
	    return stream.emit('error', new Error('write callback called multiple times'));
	  }

	  ts.writechunk = null;
	  ts.writecb = null;

	  if (data !== null && data !== undefined) stream.push(data);

	  cb(er);

	  var rs = stream._readableState;
	  rs.reading = false;
	  if (rs.needReadable || rs.length < rs.highWaterMark) {
	    stream._read(rs.highWaterMark);
	  }
	}

	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options);

	  Duplex.call(this, options);

	  this._transformState = new TransformState(this);

	  var stream = this;

	  // start out asking for a readable event once data is transformed.
	  this._readableState.needReadable = true;

	  // we have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;

	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;

	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }

	  // When the writable side finishes, then flush out anything remaining.
	  this.once('prefinish', function () {
	    if (typeof this._flush === 'function') this._flush(function (er, data) {
	      done(stream, er, data);
	    });else done(stream);
	  });
	}

	Transform.prototype.push = function (chunk, encoding) {
	  this._transformState.needTransform = false;
	  return Duplex.prototype.push.call(this, chunk, encoding);
	};

	// This is the part where you do stuff!
	// override this function in implementation classes.
	// 'chunk' is an input chunk.
	//
	// Call `push(newChunk)` to pass along transformed output
	// to the readable side.  You may call 'push' zero or more times.
	//
	// Call `cb(err)` when you are done with this chunk.  If you pass
	// an error, then that'll put the hurt on the whole operation.  If you
	// never call cb(), then you'll never get another chunk.
	Transform.prototype._transform = function (chunk, encoding, cb) {
	  throw new Error('_transform() is not implemented');
	};

	Transform.prototype._write = function (chunk, encoding, cb) {
	  var ts = this._transformState;
	  ts.writecb = cb;
	  ts.writechunk = chunk;
	  ts.writeencoding = encoding;
	  if (!ts.transforming) {
	    var rs = this._readableState;
	    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
	  }
	};

	// Doesn't matter what the args are here.
	// _transform does all the work.
	// That we got here means that the readable side wants more data.
	Transform.prototype._read = function (n) {
	  var ts = this._transformState;

	  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
	    ts.transforming = true;
	    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
	  } else {
	    // mark that we need a transform, so that any data that comes in
	    // will get processed, now that we've asked for it.
	    ts.needTransform = true;
	  }
	};

	Transform.prototype._destroy = function (err, cb) {
	  var _this = this;

	  Duplex.prototype._destroy.call(this, err, function (err2) {
	    cb(err2);
	    _this.emit('close');
	  });
	};

	function done(stream, er, data) {
	  if (er) return stream.emit('error', er);

	  if (data !== null && data !== undefined) stream.push(data);

	  // if there's nothing in the write buffer, then that means
	  // that nothing more will ever be provided
	  var ws = stream._writableState;
	  var ts = stream._transformState;

	  if (ws.length) throw new Error('Calling transform done when ws.length != 0');

	  if (ts.transforming) throw new Error('Calling transform done when still transforming');

	  return stream.push(null);
	}

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// a passthrough stream.
	// basically just the most minimal sort of Transform stream.
	// Every written chunk gets output as-is.

	'use strict';

	module.exports = PassThrough;

	var Transform = __webpack_require__(48);

	/*<replacement>*/
	var util = __webpack_require__(38);
	util.inherits = __webpack_require__(31);
	/*</replacement>*/

	util.inherits(PassThrough, Transform);

	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options);

	  Transform.call(this, options);
	}

	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(43);


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(42);


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(32).Transform


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(32).PassThrough


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, __dirname) {/* jslint node: true */
	'use strict';

	function VirtualFileSystem() {
		this.fileSystem = {};
		this.baseSystem = {};
	}

	VirtualFileSystem.prototype.readFileSync = function (filename) {
		filename = fixFilename(filename);

		var base64content = this.baseSystem[filename];
		if (base64content) {
			return new Buffer(base64content, 'base64');
		}

		var content = this.fileSystem[filename];
		if (content) {
			return content;
		}

		throw 'File \'' + filename + '\' not found in virtual file system';
	};

	VirtualFileSystem.prototype.writeFileSync = function (filename, content) {
		this.fileSystem[fixFilename(filename)] = content;
	};

	VirtualFileSystem.prototype.bindFS = function (data) {
		this.baseSystem = data || {};
	};


	function fixFilename(filename) {
		if (filename.indexOf(__dirname) === 0) {
			filename = filename.substring(__dirname.length);
		}

		if (filename.indexOf('/') === 0) {
			filename = filename.substring(1);
		}

		return filename;
	}

	module.exports = new VirtualFileSystem();

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer, "/"))

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

	/*
	PDFObject - converts JavaScript types into their corrisponding PDF types.
	By Devon Govett
	 */

	(function() {
	  var PDFObject, PDFReference;

	  PDFObject = (function() {
	    var escapable, escapableRe, pad, swapBytes;

	    function PDFObject() {}

	    pad = function(str, length) {
	      return (Array(length + 1).join('0') + str).slice(-length);
	    };

	    escapableRe = /[\n\r\t\b\f\(\)\\]/g;

	    escapable = {
	      '\n': '\\n',
	      '\r': '\\r',
	      '\t': '\\t',
	      '\b': '\\b',
	      '\f': '\\f',
	      '\\': '\\\\',
	      '(': '\\(',
	      ')': '\\)'
	    };

	    swapBytes = function(buff) {
	      var a, i, j, l, ref;
	      l = buff.length;
	      if (l & 0x01) {
	        throw new Error("Buffer length must be even");
	      } else {
	        for (i = j = 0, ref = l - 1; j < ref; i = j += 2) {
	          a = buff[i];
	          buff[i] = buff[i + 1];
	          buff[i + 1] = a;
	        }
	      }
	      return buff;
	    };

	    PDFObject.convert = function(object) {
	      var e, i, isUnicode, items, j, key, out, ref, string, val;
	      if (typeof object === 'string') {
	        return '/' + object;
	      } else if (object instanceof String) {
	        string = object;
	        isUnicode = false;
	        for (i = j = 0, ref = string.length; j < ref; i = j += 1) {
	          if (string.charCodeAt(i) > 0x7f) {
	            isUnicode = true;
	            break;
	          }
	        }
	        if (isUnicode) {
	          string = swapBytes(new Buffer('\ufeff' + string, 'utf16le')).toString('binary');
	        }
	        string = string.replace(escapableRe, function(c) {
	          return escapable[c];
	        });
	        return '(' + string + ')';
	      } else if (Buffer.isBuffer(object)) {
	        return '<' + object.toString('hex') + '>';
	      } else if (object instanceof PDFReference) {
	        return object.toString();
	      } else if (object instanceof Date) {
	        return '(D:' + pad(object.getUTCFullYear(), 4) + pad(object.getUTCMonth() + 1, 2) + pad(object.getUTCDate(), 2) + pad(object.getUTCHours(), 2) + pad(object.getUTCMinutes(), 2) + pad(object.getUTCSeconds(), 2) + 'Z)';
	      } else if (Array.isArray(object)) {
	        items = ((function() {
	          var k, len, results;
	          results = [];
	          for (k = 0, len = object.length; k < len; k++) {
	            e = object[k];
	            results.push(PDFObject.convert(e));
	          }
	          return results;
	        })()).join(' ');
	        return '[' + items + ']';
	      } else if ({}.toString.call(object) === '[object Object]') {
	        out = ['<<'];
	        for (key in object) {
	          val = object[key];
	          out.push('/' + key + ' ' + PDFObject.convert(val));
	        }
	        out.push('>>');
	        return out.join('\n');
	      } else if (typeof object === 'number') {
	        return PDFObject.number(object);
	      } else {
	        return '' + object;
	      }
	    };

	    PDFObject.number = function(n) {
	      if (n > -1e21 && n < 1e21) {
	        return Math.round(n * 1e6) / 1e6;
	      }
	      throw new Error("unsupported number: " + n);
	    };

	    return PDFObject;

	  })();

	  module.exports = PDFObject;

	  PDFReference = __webpack_require__(56);

	}).call(this);

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer))

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

	/*
	PDFReference - represents a reference to another object in the PDF object heirarchy
	By Devon Govett
	 */

	(function() {
	  var PDFObject, PDFReference, stream, zlib,
	    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	    hasProp = {}.hasOwnProperty;

	  zlib = __webpack_require__(57);

	  stream = __webpack_require__(29);

	  PDFReference = (function(superClass) {
	    extend(PDFReference, superClass);

	    function PDFReference(document, id, data) {
	      this.document = document;
	      this.id = id;
	      this.data = data != null ? data : {};
	      this.finalize = bind(this.finalize, this);
	      PDFReference.__super__.constructor.call(this, {
	        decodeStrings: false
	      });
	      this.gen = 0;
	      this.deflate = null;
	      this.compress = this.document.compress && !this.data.Filter;
	      this.uncompressedLength = 0;
	      this.chunks = [];
	    }

	    PDFReference.prototype.initDeflate = function() {
	      this.data.Filter = 'FlateDecode';
	      this.deflate = zlib.createDeflate();
	      this.deflate.on('data', (function(_this) {
	        return function(chunk) {
	          _this.chunks.push(chunk);
	          return _this.data.Length += chunk.length;
	        };
	      })(this));
	      return this.deflate.on('end', this.finalize);
	    };

	    PDFReference.prototype._write = function(chunk, encoding, callback) {
	      var base;
	      if (!Buffer.isBuffer(chunk)) {
	        chunk = new Buffer(chunk + '\n', 'binary');
	      }
	      this.uncompressedLength += chunk.length;
	      if ((base = this.data).Length == null) {
	        base.Length = 0;
	      }
	      if (this.compress) {
	        if (!this.deflate) {
	          this.initDeflate();
	        }
	        this.deflate.write(chunk);
	      } else {
	        this.chunks.push(chunk);
	        this.data.Length += chunk.length;
	      }
	      return callback();
	    };

	    PDFReference.prototype.end = function(chunk) {
	      PDFReference.__super__.end.apply(this, arguments);
	      if (this.deflate) {
	        return this.deflate.end();
	      } else {
	        return this.finalize();
	      }
	    };

	    PDFReference.prototype.finalize = function() {
	      var chunk, i, len, ref;
	      this.offset = this.document._offset;
	      this.document._write(this.id + " " + this.gen + " obj");
	      this.document._write(PDFObject.convert(this.data));
	      if (this.chunks.length) {
	        this.document._write('stream');
	        ref = this.chunks;
	        for (i = 0, len = ref.length; i < len; i++) {
	          chunk = ref[i];
	          this.document._write(chunk);
	        }
	        this.chunks.length = 0;
	        this.document._write('\nendstream');
	      }
	      this.document._write('endobj');
	      return this.document._refEnd(this);
	    };

	    PDFReference.prototype.toString = function() {
	      return this.id + " " + this.gen + " R";
	    };

	    return PDFReference;

	  })(stream.Writable);

	  module.exports = PDFReference;

	  PDFObject = __webpack_require__(55);

	}).call(this);

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer))

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var Transform = __webpack_require__(52);

	var binding = __webpack_require__(58);
	var util = __webpack_require__(70);
	var assert = __webpack_require__(73).ok;

	// zlib doesn't provide these, so kludge them in following the same
	// const naming scheme zlib uses.
	binding.Z_MIN_WINDOWBITS = 8;
	binding.Z_MAX_WINDOWBITS = 15;
	binding.Z_DEFAULT_WINDOWBITS = 15;

	// fewer than 64 bytes per chunk is stupid.
	// technically it could work with as few as 8, but even 64 bytes
	// is absurdly low.  Usually a MB or more is best.
	binding.Z_MIN_CHUNK = 64;
	binding.Z_MAX_CHUNK = Infinity;
	binding.Z_DEFAULT_CHUNK = (16 * 1024);

	binding.Z_MIN_MEMLEVEL = 1;
	binding.Z_MAX_MEMLEVEL = 9;
	binding.Z_DEFAULT_MEMLEVEL = 8;

	binding.Z_MIN_LEVEL = -1;
	binding.Z_MAX_LEVEL = 9;
	binding.Z_DEFAULT_LEVEL = binding.Z_DEFAULT_COMPRESSION;

	// expose all the zlib constants
	Object.keys(binding).forEach(function(k) {
	  if (k.match(/^Z/)) exports[k] = binding[k];
	});

	// translation table for return codes.
	exports.codes = {
	  Z_OK: binding.Z_OK,
	  Z_STREAM_END: binding.Z_STREAM_END,
	  Z_NEED_DICT: binding.Z_NEED_DICT,
	  Z_ERRNO: binding.Z_ERRNO,
	  Z_STREAM_ERROR: binding.Z_STREAM_ERROR,
	  Z_DATA_ERROR: binding.Z_DATA_ERROR,
	  Z_MEM_ERROR: binding.Z_MEM_ERROR,
	  Z_BUF_ERROR: binding.Z_BUF_ERROR,
	  Z_VERSION_ERROR: binding.Z_VERSION_ERROR
	};

	Object.keys(exports.codes).forEach(function(k) {
	  exports.codes[exports.codes[k]] = k;
	});

	exports.Deflate = Deflate;
	exports.Inflate = Inflate;
	exports.Gzip = Gzip;
	exports.Gunzip = Gunzip;
	exports.DeflateRaw = DeflateRaw;
	exports.InflateRaw = InflateRaw;
	exports.Unzip = Unzip;

	exports.createDeflate = function(o) {
	  return new Deflate(o);
	};

	exports.createInflate = function(o) {
	  return new Inflate(o);
	};

	exports.createDeflateRaw = function(o) {
	  return new DeflateRaw(o);
	};

	exports.createInflateRaw = function(o) {
	  return new InflateRaw(o);
	};

	exports.createGzip = function(o) {
	  return new Gzip(o);
	};

	exports.createGunzip = function(o) {
	  return new Gunzip(o);
	};

	exports.createUnzip = function(o) {
	  return new Unzip(o);
	};


	// Convenience methods.
	// compress/decompress a string or buffer in one step.
	exports.deflate = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Deflate(opts), buffer, callback);
	};

	exports.deflateSync = function(buffer, opts) {
	  return zlibBufferSync(new Deflate(opts), buffer);
	};

	exports.gzip = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Gzip(opts), buffer, callback);
	};

	exports.gzipSync = function(buffer, opts) {
	  return zlibBufferSync(new Gzip(opts), buffer);
	};

	exports.deflateRaw = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new DeflateRaw(opts), buffer, callback);
	};

	exports.deflateRawSync = function(buffer, opts) {
	  return zlibBufferSync(new DeflateRaw(opts), buffer);
	};

	exports.unzip = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Unzip(opts), buffer, callback);
	};

	exports.unzipSync = function(buffer, opts) {
	  return zlibBufferSync(new Unzip(opts), buffer);
	};

	exports.inflate = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Inflate(opts), buffer, callback);
	};

	exports.inflateSync = function(buffer, opts) {
	  return zlibBufferSync(new Inflate(opts), buffer);
	};

	exports.gunzip = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Gunzip(opts), buffer, callback);
	};

	exports.gunzipSync = function(buffer, opts) {
	  return zlibBufferSync(new Gunzip(opts), buffer);
	};

	exports.inflateRaw = function(buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new InflateRaw(opts), buffer, callback);
	};

	exports.inflateRawSync = function(buffer, opts) {
	  return zlibBufferSync(new InflateRaw(opts), buffer);
	};

	function zlibBuffer(engine, buffer, callback) {
	  var buffers = [];
	  var nread = 0;

	  engine.on('error', onError);
	  engine.on('end', onEnd);

	  engine.end(buffer);
	  flow();

	  function flow() {
	    var chunk;
	    while (null !== (chunk = engine.read())) {
	      buffers.push(chunk);
	      nread += chunk.length;
	    }
	    engine.once('readable', flow);
	  }

	  function onError(err) {
	    engine.removeListener('end', onEnd);
	    engine.removeListener('readable', flow);
	    callback(err);
	  }

	  function onEnd() {
	    var buf = Buffer.concat(buffers, nread);
	    buffers = [];
	    callback(null, buf);
	    engine.close();
	  }
	}

	function zlibBufferSync(engine, buffer) {
	  if (typeof buffer === 'string')
	    buffer = new Buffer(buffer);
	  if (!Buffer.isBuffer(buffer))
	    throw new TypeError('Not a string or buffer');

	  var flushFlag = binding.Z_FINISH;

	  return engine._processChunk(buffer, flushFlag);
	}

	// generic zlib
	// minimal 2-byte header
	function Deflate(opts) {
	  if (!(this instanceof Deflate)) return new Deflate(opts);
	  Zlib.call(this, opts, binding.DEFLATE);
	}

	function Inflate(opts) {
	  if (!(this instanceof Inflate)) return new Inflate(opts);
	  Zlib.call(this, opts, binding.INFLATE);
	}



	// gzip - bigger header, same deflate compression
	function Gzip(opts) {
	  if (!(this instanceof Gzip)) return new Gzip(opts);
	  Zlib.call(this, opts, binding.GZIP);
	}

	function Gunzip(opts) {
	  if (!(this instanceof Gunzip)) return new Gunzip(opts);
	  Zlib.call(this, opts, binding.GUNZIP);
	}



	// raw - no header
	function DeflateRaw(opts) {
	  if (!(this instanceof DeflateRaw)) return new DeflateRaw(opts);
	  Zlib.call(this, opts, binding.DEFLATERAW);
	}

	function InflateRaw(opts) {
	  if (!(this instanceof InflateRaw)) return new InflateRaw(opts);
	  Zlib.call(this, opts, binding.INFLATERAW);
	}


	// auto-detect header.
	function Unzip(opts) {
	  if (!(this instanceof Unzip)) return new Unzip(opts);
	  Zlib.call(this, opts, binding.UNZIP);
	}


	// the Zlib class they all inherit from
	// This thing manages the queue of requests, and returns
	// true or false if there is anything in the queue when
	// you call the .write() method.

	function Zlib(opts, mode) {
	  this._opts = opts = opts || {};
	  this._chunkSize = opts.chunkSize || exports.Z_DEFAULT_CHUNK;

	  Transform.call(this, opts);

	  if (opts.flush) {
	    if (opts.flush !== binding.Z_NO_FLUSH &&
	        opts.flush !== binding.Z_PARTIAL_FLUSH &&
	        opts.flush !== binding.Z_SYNC_FLUSH &&
	        opts.flush !== binding.Z_FULL_FLUSH &&
	        opts.flush !== binding.Z_FINISH &&
	        opts.flush !== binding.Z_BLOCK) {
	      throw new Error('Invalid flush flag: ' + opts.flush);
	    }
	  }
	  this._flushFlag = opts.flush || binding.Z_NO_FLUSH;

	  if (opts.chunkSize) {
	    if (opts.chunkSize < exports.Z_MIN_CHUNK ||
	        opts.chunkSize > exports.Z_MAX_CHUNK) {
	      throw new Error('Invalid chunk size: ' + opts.chunkSize);
	    }
	  }

	  if (opts.windowBits) {
	    if (opts.windowBits < exports.Z_MIN_WINDOWBITS ||
	        opts.windowBits > exports.Z_MAX_WINDOWBITS) {
	      throw new Error('Invalid windowBits: ' + opts.windowBits);
	    }
	  }

	  if (opts.level) {
	    if (opts.level < exports.Z_MIN_LEVEL ||
	        opts.level > exports.Z_MAX_LEVEL) {
	      throw new Error('Invalid compression level: ' + opts.level);
	    }
	  }

	  if (opts.memLevel) {
	    if (opts.memLevel < exports.Z_MIN_MEMLEVEL ||
	        opts.memLevel > exports.Z_MAX_MEMLEVEL) {
	      throw new Error('Invalid memLevel: ' + opts.memLevel);
	    }
	  }

	  if (opts.strategy) {
	    if (opts.strategy != exports.Z_FILTERED &&
	        opts.strategy != exports.Z_HUFFMAN_ONLY &&
	        opts.strategy != exports.Z_RLE &&
	        opts.strategy != exports.Z_FIXED &&
	        opts.strategy != exports.Z_DEFAULT_STRATEGY) {
	      throw new Error('Invalid strategy: ' + opts.strategy);
	    }
	  }

	  if (opts.dictionary) {
	    if (!Buffer.isBuffer(opts.dictionary)) {
	      throw new Error('Invalid dictionary: it should be a Buffer instance');
	    }
	  }

	  this._binding = new binding.Zlib(mode);

	  var self = this;
	  this._hadError = false;
	  this._binding.onerror = function(message, errno) {
	    // there is no way to cleanly recover.
	    // continuing only obscures problems.
	    self._binding = null;
	    self._hadError = true;

	    var error = new Error(message);
	    error.errno = errno;
	    error.code = exports.codes[errno];
	    self.emit('error', error);
	  };

	  var level = exports.Z_DEFAULT_COMPRESSION;
	  if (typeof opts.level === 'number') level = opts.level;

	  var strategy = exports.Z_DEFAULT_STRATEGY;
	  if (typeof opts.strategy === 'number') strategy = opts.strategy;

	  this._binding.init(opts.windowBits || exports.Z_DEFAULT_WINDOWBITS,
	                     level,
	                     opts.memLevel || exports.Z_DEFAULT_MEMLEVEL,
	                     strategy,
	                     opts.dictionary);

	  this._buffer = new Buffer(this._chunkSize);
	  this._offset = 0;
	  this._closed = false;
	  this._level = level;
	  this._strategy = strategy;

	  this.once('end', this.close);
	}

	util.inherits(Zlib, Transform);

	Zlib.prototype.params = function(level, strategy, callback) {
	  if (level < exports.Z_MIN_LEVEL ||
	      level > exports.Z_MAX_LEVEL) {
	    throw new RangeError('Invalid compression level: ' + level);
	  }
	  if (strategy != exports.Z_FILTERED &&
	      strategy != exports.Z_HUFFMAN_ONLY &&
	      strategy != exports.Z_RLE &&
	      strategy != exports.Z_FIXED &&
	      strategy != exports.Z_DEFAULT_STRATEGY) {
	    throw new TypeError('Invalid strategy: ' + strategy);
	  }

	  if (this._level !== level || this._strategy !== strategy) {
	    var self = this;
	    this.flush(binding.Z_SYNC_FLUSH, function() {
	      self._binding.params(level, strategy);
	      if (!self._hadError) {
	        self._level = level;
	        self._strategy = strategy;
	        if (callback) callback();
	      }
	    });
	  } else {
	    process.nextTick(callback);
	  }
	};

	Zlib.prototype.reset = function() {
	  return this._binding.reset();
	};

	// This is the _flush function called by the transform class,
	// internally, when the last chunk has been written.
	Zlib.prototype._flush = function(callback) {
	  this._transform(new Buffer(0), '', callback);
	};

	Zlib.prototype.flush = function(kind, callback) {
	  var ws = this._writableState;

	  if (typeof kind === 'function' || (kind === void 0 && !callback)) {
	    callback = kind;
	    kind = binding.Z_FULL_FLUSH;
	  }

	  if (ws.ended) {
	    if (callback)
	      process.nextTick(callback);
	  } else if (ws.ending) {
	    if (callback)
	      this.once('end', callback);
	  } else if (ws.needDrain) {
	    var self = this;
	    this.once('drain', function() {
	      self.flush(callback);
	    });
	  } else {
	    this._flushFlag = kind;
	    this.write(new Buffer(0), '', callback);
	  }
	};

	Zlib.prototype.close = function(callback) {
	  if (callback)
	    process.nextTick(callback);

	  if (this._closed)
	    return;

	  this._closed = true;

	  this._binding.close();

	  var self = this;
	  process.nextTick(function() {
	    self.emit('close');
	  });
	};

	Zlib.prototype._transform = function(chunk, encoding, cb) {
	  var flushFlag;
	  var ws = this._writableState;
	  var ending = ws.ending || ws.ended;
	  var last = ending && (!chunk || ws.length === chunk.length);

	  if (!chunk === null && !Buffer.isBuffer(chunk))
	    return cb(new Error('invalid input'));

	  // If it's the last chunk, or a final flush, we use the Z_FINISH flush flag.
	  // If it's explicitly flushing at some other time, then we use
	  // Z_FULL_FLUSH. Otherwise, use Z_NO_FLUSH for maximum compression
	  // goodness.
	  if (last)
	    flushFlag = binding.Z_FINISH;
	  else {
	    flushFlag = this._flushFlag;
	    // once we've flushed the last of the queue, stop flushing and
	    // go back to the normal behavior.
	    if (chunk.length >= ws.length) {
	      this._flushFlag = this._opts.flush || binding.Z_NO_FLUSH;
	    }
	  }

	  var self = this;
	  this._processChunk(chunk, flushFlag, cb);
	};

	Zlib.prototype._processChunk = function(chunk, flushFlag, cb) {
	  var availInBefore = chunk && chunk.length;
	  var availOutBefore = this._chunkSize - this._offset;
	  var inOff = 0;

	  var self = this;

	  var async = typeof cb === 'function';

	  if (!async) {
	    var buffers = [];
	    var nread = 0;

	    var error;
	    this.on('error', function(er) {
	      error = er;
	    });

	    do {
	      var res = this._binding.writeSync(flushFlag,
	                                        chunk, // in
	                                        inOff, // in_off
	                                        availInBefore, // in_len
	                                        this._buffer, // out
	                                        this._offset, //out_off
	                                        availOutBefore); // out_len
	    } while (!this._hadError && callback(res[0], res[1]));

	    if (this._hadError) {
	      throw error;
	    }

	    var buf = Buffer.concat(buffers, nread);
	    this.close();

	    return buf;
	  }

	  var req = this._binding.write(flushFlag,
	                                chunk, // in
	                                inOff, // in_off
	                                availInBefore, // in_len
	                                this._buffer, // out
	                                this._offset, //out_off
	                                availOutBefore); // out_len

	  req.buffer = chunk;
	  req.callback = callback;

	  function callback(availInAfter, availOutAfter) {
	    if (self._hadError)
	      return;

	    var have = availOutBefore - availOutAfter;
	    assert(have >= 0, 'have should not go down');

	    if (have > 0) {
	      var out = self._buffer.slice(self._offset, self._offset + have);
	      self._offset += have;
	      // serve some output to the consumer.
	      if (async) {
	        self.push(out);
	      } else {
	        buffers.push(out);
	        nread += out.length;
	      }
	    }

	    // exhausted the output buffer, or used all the input create a new one.
	    if (availOutAfter === 0 || self._offset >= self._chunkSize) {
	      availOutBefore = self._chunkSize;
	      self._offset = 0;
	      self._buffer = new Buffer(self._chunkSize);
	    }

	    if (availOutAfter === 0) {
	      // Not actually done.  Need to reprocess.
	      // Also, update the availInBefore to the availInAfter value,
	      // so that if we have to hit it a third (fourth, etc.) time,
	      // it'll have the correct byte counts.
	      inOff += (availInBefore - availInAfter);
	      availInBefore = availInAfter;

	      if (!async)
	        return true;

	      var newReq = self._binding.write(flushFlag,
	                                       chunk,
	                                       inOff,
	                                       availInBefore,
	                                       self._buffer,
	                                       self._offset,
	                                       self._chunkSize);
	      newReq.callback = callback; // this same function
	      newReq.buffer = chunk;
	      return;
	    }

	    if (!async)
	      return false;

	    // finished with the chunk.
	    cb();
	  }
	};

	util.inherits(Deflate, Zlib);
	util.inherits(Inflate, Zlib);
	util.inherits(Gzip, Zlib);
	util.inherits(Gunzip, Zlib);
	util.inherits(DeflateRaw, Zlib);
	util.inherits(InflateRaw, Zlib);
	util.inherits(Unzip, Zlib);

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer, __webpack_require__(34)))

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process, Buffer) {var msg = __webpack_require__(59);
	var zstream = __webpack_require__(60);
	var zlib_deflate = __webpack_require__(61);
	var zlib_inflate = __webpack_require__(66);
	var constants = __webpack_require__(69);

	for (var key in constants) {
	  exports[key] = constants[key];
	}

	// zlib modes
	exports.NONE = 0;
	exports.DEFLATE = 1;
	exports.INFLATE = 2;
	exports.GZIP = 3;
	exports.GUNZIP = 4;
	exports.DEFLATERAW = 5;
	exports.INFLATERAW = 6;
	exports.UNZIP = 7;

	/**
	 * Emulate Node's zlib C++ layer for use by the JS layer in index.js
	 */
	function Zlib(mode) {
	  if (mode < exports.DEFLATE || mode > exports.UNZIP)
	    throw new TypeError("Bad argument");
	    
	  this.mode = mode;
	  this.init_done = false;
	  this.write_in_progress = false;
	  this.pending_close = false;
	  this.windowBits = 0;
	  this.level = 0;
	  this.memLevel = 0;
	  this.strategy = 0;
	  this.dictionary = null;
	}

	Zlib.prototype.init = function(windowBits, level, memLevel, strategy, dictionary) {
	  this.windowBits = windowBits;
	  this.level = level;
	  this.memLevel = memLevel;
	  this.strategy = strategy;
	  // dictionary not supported.
	  
	  if (this.mode === exports.GZIP || this.mode === exports.GUNZIP)
	    this.windowBits += 16;
	    
	  if (this.mode === exports.UNZIP)
	    this.windowBits += 32;
	    
	  if (this.mode === exports.DEFLATERAW || this.mode === exports.INFLATERAW)
	    this.windowBits = -this.windowBits;
	    
	  this.strm = new zstream();
	  
	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.GZIP:
	    case exports.DEFLATERAW:
	      var status = zlib_deflate.deflateInit2(
	        this.strm,
	        this.level,
	        exports.Z_DEFLATED,
	        this.windowBits,
	        this.memLevel,
	        this.strategy
	      );
	      break;
	    case exports.INFLATE:
	    case exports.GUNZIP:
	    case exports.INFLATERAW:
	    case exports.UNZIP:
	      var status  = zlib_inflate.inflateInit2(
	        this.strm,
	        this.windowBits
	      );
	      break;
	    default:
	      throw new Error("Unknown mode " + this.mode);
	  }
	  
	  if (status !== exports.Z_OK) {
	    this._error(status);
	    return;
	  }
	  
	  this.write_in_progress = false;
	  this.init_done = true;
	};

	Zlib.prototype.params = function() {
	  throw new Error("deflateParams Not supported");
	};

	Zlib.prototype._writeCheck = function() {
	  if (!this.init_done)
	    throw new Error("write before init");
	    
	  if (this.mode === exports.NONE)
	    throw new Error("already finalized");
	    
	  if (this.write_in_progress)
	    throw new Error("write already in progress");
	    
	  if (this.pending_close)
	    throw new Error("close is pending");
	};

	Zlib.prototype.write = function(flush, input, in_off, in_len, out, out_off, out_len) {    
	  this._writeCheck();
	  this.write_in_progress = true;
	  
	  var self = this;
	  process.nextTick(function() {
	    self.write_in_progress = false;
	    var res = self._write(flush, input, in_off, in_len, out, out_off, out_len);
	    self.callback(res[0], res[1]);
	    
	    if (self.pending_close)
	      self.close();
	  });
	  
	  return this;
	};

	// set method for Node buffers, used by pako
	function bufferSet(data, offset) {
	  for (var i = 0; i < data.length; i++) {
	    this[offset + i] = data[i];
	  }
	}

	Zlib.prototype.writeSync = function(flush, input, in_off, in_len, out, out_off, out_len) {
	  this._writeCheck();
	  return this._write(flush, input, in_off, in_len, out, out_off, out_len);
	};

	Zlib.prototype._write = function(flush, input, in_off, in_len, out, out_off, out_len) {
	  this.write_in_progress = true;
	  
	  if (flush !== exports.Z_NO_FLUSH &&
	      flush !== exports.Z_PARTIAL_FLUSH &&
	      flush !== exports.Z_SYNC_FLUSH &&
	      flush !== exports.Z_FULL_FLUSH &&
	      flush !== exports.Z_FINISH &&
	      flush !== exports.Z_BLOCK) {
	    throw new Error("Invalid flush value");
	  }
	  
	  if (input == null) {
	    input = new Buffer(0);
	    in_len = 0;
	    in_off = 0;
	  }
	  
	  if (out._set)
	    out.set = out._set;
	  else
	    out.set = bufferSet;
	  
	  var strm = this.strm;
	  strm.avail_in = in_len;
	  strm.input = input;
	  strm.next_in = in_off;
	  strm.avail_out = out_len;
	  strm.output = out;
	  strm.next_out = out_off;
	  
	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.GZIP:
	    case exports.DEFLATERAW:
	      var status = zlib_deflate.deflate(strm, flush);
	      break;
	    case exports.UNZIP:
	    case exports.INFLATE:
	    case exports.GUNZIP:
	    case exports.INFLATERAW:
	      var status = zlib_inflate.inflate(strm, flush);
	      break;
	    default:
	      throw new Error("Unknown mode " + this.mode);
	  }
	  
	  if (status !== exports.Z_STREAM_END && status !== exports.Z_OK) {
	    this._error(status);
	  }
	  
	  this.write_in_progress = false;
	  return [strm.avail_in, strm.avail_out];
	};

	Zlib.prototype.close = function() {
	  if (this.write_in_progress) {
	    this.pending_close = true;
	    return;
	  }
	  
	  this.pending_close = false;
	  
	  if (this.mode === exports.DEFLATE || this.mode === exports.GZIP || this.mode === exports.DEFLATERAW) {
	    zlib_deflate.deflateEnd(this.strm);
	  } else {
	    zlib_inflate.inflateEnd(this.strm);
	  }
	  
	  this.mode = exports.NONE;
	};

	Zlib.prototype.reset = function() {
	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.DEFLATERAW:
	      var status = zlib_deflate.deflateReset(this.strm);
	      break;
	    case exports.INFLATE:
	    case exports.INFLATERAW:
	      var status = zlib_inflate.inflateReset(this.strm);
	      break;
	  }
	  
	  if (status !== exports.Z_OK) {
	    this._error(status);
	  }
	};

	Zlib.prototype._error = function(status) {
	  this.onerror(msg[status] + ': ' + this.strm.msg, status);
	  
	  this.write_in_progress = false;
	  if (this.pending_close)
	    this.close();
	};

	exports.Zlib = Zlib;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(34), __webpack_require__(2).Buffer))

/***/ }),
/* 59 */
/***/ (function(module, exports) {

	'use strict';

	module.exports = {
	  2:      'need dictionary',     /* Z_NEED_DICT       2  */
	  1:      'stream end',          /* Z_STREAM_END      1  */
	  0:      '',                    /* Z_OK              0  */
	  '-1':   'file error',          /* Z_ERRNO         (-1) */
	  '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
	  '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
	  '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
	  '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
	  '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
	};


/***/ }),
/* 60 */
/***/ (function(module, exports) {

	'use strict';


	function ZStream() {
	  /* next input byte */
	  this.input = null; // JS specific, because we have no pointers
	  this.next_in = 0;
	  /* number of bytes available at input */
	  this.avail_in = 0;
	  /* total number of input bytes read so far */
	  this.total_in = 0;
	  /* next output byte should be put there */
	  this.output = null; // JS specific, because we have no pointers
	  this.next_out = 0;
	  /* remaining free space at output */
	  this.avail_out = 0;
	  /* total number of bytes output so far */
	  this.total_out = 0;
	  /* last error message, NULL if no error */
	  this.msg = ''/*Z_NULL*/;
	  /* not visible by applications */
	  this.state = null;
	  /* best guess about the data type: binary or text */
	  this.data_type = 2/*Z_UNKNOWN*/;
	  /* adler32 value of the uncompressed data */
	  this.adler = 0;
	}

	module.exports = ZStream;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	var utils   = __webpack_require__(62);
	var trees   = __webpack_require__(63);
	var adler32 = __webpack_require__(64);
	var crc32   = __webpack_require__(65);
	var msg     = __webpack_require__(59);

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	/* Allowed flush values; see deflate() and inflate() below for details */
	var Z_NO_FLUSH      = 0;
	var Z_PARTIAL_FLUSH = 1;
	//var Z_SYNC_FLUSH    = 2;
	var Z_FULL_FLUSH    = 3;
	var Z_FINISH        = 4;
	var Z_BLOCK         = 5;
	//var Z_TREES         = 6;


	/* Return codes for the compression/decompression functions. Negative values
	 * are errors, positive values are used for special but normal events.
	 */
	var Z_OK            = 0;
	var Z_STREAM_END    = 1;
	//var Z_NEED_DICT     = 2;
	//var Z_ERRNO         = -1;
	var Z_STREAM_ERROR  = -2;
	var Z_DATA_ERROR    = -3;
	//var Z_MEM_ERROR     = -4;
	var Z_BUF_ERROR     = -5;
	//var Z_VERSION_ERROR = -6;


	/* compression levels */
	//var Z_NO_COMPRESSION      = 0;
	//var Z_BEST_SPEED          = 1;
	//var Z_BEST_COMPRESSION    = 9;
	var Z_DEFAULT_COMPRESSION = -1;


	var Z_FILTERED            = 1;
	var Z_HUFFMAN_ONLY        = 2;
	var Z_RLE                 = 3;
	var Z_FIXED               = 4;
	var Z_DEFAULT_STRATEGY    = 0;

	/* Possible values of the data_type field (though see inflate()) */
	//var Z_BINARY              = 0;
	//var Z_TEXT                = 1;
	//var Z_ASCII               = 1; // = Z_TEXT
	var Z_UNKNOWN             = 2;


	/* The deflate compression method */
	var Z_DEFLATED  = 8;

	/*============================================================================*/


	var MAX_MEM_LEVEL = 9;
	/* Maximum value for memLevel in deflateInit2 */
	var MAX_WBITS = 15;
	/* 32K LZ77 window */
	var DEF_MEM_LEVEL = 8;


	var LENGTH_CODES  = 29;
	/* number of length codes, not counting the special END_BLOCK code */
	var LITERALS      = 256;
	/* number of literal bytes 0..255 */
	var L_CODES       = LITERALS + 1 + LENGTH_CODES;
	/* number of Literal or Length codes, including the END_BLOCK code */
	var D_CODES       = 30;
	/* number of distance codes */
	var BL_CODES      = 19;
	/* number of codes used to transfer the bit lengths */
	var HEAP_SIZE     = 2 * L_CODES + 1;
	/* maximum heap size */
	var MAX_BITS  = 15;
	/* All codes must not exceed MAX_BITS bits */

	var MIN_MATCH = 3;
	var MAX_MATCH = 258;
	var MIN_LOOKAHEAD = (MAX_MATCH + MIN_MATCH + 1);

	var PRESET_DICT = 0x20;

	var INIT_STATE = 42;
	var EXTRA_STATE = 69;
	var NAME_STATE = 73;
	var COMMENT_STATE = 91;
	var HCRC_STATE = 103;
	var BUSY_STATE = 113;
	var FINISH_STATE = 666;

	var BS_NEED_MORE      = 1; /* block not completed, need more input or more output */
	var BS_BLOCK_DONE     = 2; /* block flush performed */
	var BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */
	var BS_FINISH_DONE    = 4; /* finish done, accept no more input or output */

	var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

	function err(strm, errorCode) {
	  strm.msg = msg[errorCode];
	  return errorCode;
	}

	function rank(f) {
	  return ((f) << 1) - ((f) > 4 ? 9 : 0);
	}

	function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }


	/* =========================================================================
	 * Flush as much pending output as possible. All deflate() output goes
	 * through this function so some applications may wish to modify it
	 * to avoid allocating a large strm->output buffer and copying into it.
	 * (See also read_buf()).
	 */
	function flush_pending(strm) {
	  var s = strm.state;

	  //_tr_flush_bits(s);
	  var len = s.pending;
	  if (len > strm.avail_out) {
	    len = strm.avail_out;
	  }
	  if (len === 0) { return; }

	  utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
	  strm.next_out += len;
	  s.pending_out += len;
	  strm.total_out += len;
	  strm.avail_out -= len;
	  s.pending -= len;
	  if (s.pending === 0) {
	    s.pending_out = 0;
	  }
	}


	function flush_block_only(s, last) {
	  trees._tr_flush_block(s, (s.block_start >= 0 ? s.block_start : -1), s.strstart - s.block_start, last);
	  s.block_start = s.strstart;
	  flush_pending(s.strm);
	}


	function put_byte(s, b) {
	  s.pending_buf[s.pending++] = b;
	}


	/* =========================================================================
	 * Put a short in the pending buffer. The 16-bit value is put in MSB order.
	 * IN assertion: the stream state is correct and there is enough room in
	 * pending_buf.
	 */
	function putShortMSB(s, b) {
	//  put_byte(s, (Byte)(b >> 8));
	//  put_byte(s, (Byte)(b & 0xff));
	  s.pending_buf[s.pending++] = (b >>> 8) & 0xff;
	  s.pending_buf[s.pending++] = b & 0xff;
	}


	/* ===========================================================================
	 * Read a new buffer from the current input stream, update the adler32
	 * and total number of bytes read.  All deflate() input goes through
	 * this function so some applications may wish to modify it to avoid
	 * allocating a large strm->input buffer and copying from it.
	 * (See also flush_pending()).
	 */
	function read_buf(strm, buf, start, size) {
	  var len = strm.avail_in;

	  if (len > size) { len = size; }
	  if (len === 0) { return 0; }

	  strm.avail_in -= len;

	  // zmemcpy(buf, strm->next_in, len);
	  utils.arraySet(buf, strm.input, strm.next_in, len, start);
	  if (strm.state.wrap === 1) {
	    strm.adler = adler32(strm.adler, buf, len, start);
	  }

	  else if (strm.state.wrap === 2) {
	    strm.adler = crc32(strm.adler, buf, len, start);
	  }

	  strm.next_in += len;
	  strm.total_in += len;

	  return len;
	}


	/* ===========================================================================
	 * Set match_start to the longest match starting at the given string and
	 * return its length. Matches shorter or equal to prev_length are discarded,
	 * in which case the result is equal to prev_length and match_start is
	 * garbage.
	 * IN assertions: cur_match is the head of the hash chain for the current
	 *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
	 * OUT assertion: the match length is not greater than s->lookahead.
	 */
	function longest_match(s, cur_match) {
	  var chain_length = s.max_chain_length;      /* max hash chain length */
	  var scan = s.strstart; /* current string */
	  var match;                       /* matched string */
	  var len;                           /* length of current match */
	  var best_len = s.prev_length;              /* best match length so far */
	  var nice_match = s.nice_match;             /* stop if match long enough */
	  var limit = (s.strstart > (s.w_size - MIN_LOOKAHEAD)) ?
	      s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0/*NIL*/;

	  var _win = s.window; // shortcut

	  var wmask = s.w_mask;
	  var prev  = s.prev;

	  /* Stop when cur_match becomes <= limit. To simplify the code,
	   * we prevent matches with the string of window index 0.
	   */

	  var strend = s.strstart + MAX_MATCH;
	  var scan_end1  = _win[scan + best_len - 1];
	  var scan_end   = _win[scan + best_len];

	  /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
	   * It is easy to get rid of this optimization if necessary.
	   */
	  // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

	  /* Do not waste too much time if we already have a good match: */
	  if (s.prev_length >= s.good_match) {
	    chain_length >>= 2;
	  }
	  /* Do not look for matches beyond the end of the input. This is necessary
	   * to make deflate deterministic.
	   */
	  if (nice_match > s.lookahead) { nice_match = s.lookahead; }

	  // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");

	  do {
	    // Assert(cur_match < s->strstart, "no future");
	    match = cur_match;

	    /* Skip to next match if the match length cannot increase
	     * or if the match length is less than 2.  Note that the checks below
	     * for insufficient lookahead only occur occasionally for performance
	     * reasons.  Therefore uninitialized memory will be accessed, and
	     * conditional jumps will be made that depend on those values.
	     * However the length of the match is limited to the lookahead, so
	     * the output of deflate is not affected by the uninitialized values.
	     */

	    if (_win[match + best_len]     !== scan_end  ||
	        _win[match + best_len - 1] !== scan_end1 ||
	        _win[match]                !== _win[scan] ||
	        _win[++match]              !== _win[scan + 1]) {
	      continue;
	    }

	    /* The check at best_len-1 can be removed because it will be made
	     * again later. (This heuristic is not always a win.)
	     * It is not necessary to compare scan[2] and match[2] since they
	     * are always equal when the other bytes match, given that
	     * the hash keys are equal and that HASH_BITS >= 8.
	     */
	    scan += 2;
	    match++;
	    // Assert(*scan == *match, "match[2]?");

	    /* We check for insufficient lookahead only every 8th comparison;
	     * the 256th check will be made at strstart+258.
	     */
	    do {
	      /*jshint noempty:false*/
	    } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             scan < strend);

	    // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");

	    len = MAX_MATCH - (strend - scan);
	    scan = strend - MAX_MATCH;

	    if (len > best_len) {
	      s.match_start = cur_match;
	      best_len = len;
	      if (len >= nice_match) {
	        break;
	      }
	      scan_end1  = _win[scan + best_len - 1];
	      scan_end   = _win[scan + best_len];
	    }
	  } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

	  if (best_len <= s.lookahead) {
	    return best_len;
	  }
	  return s.lookahead;
	}


	/* ===========================================================================
	 * Fill the window when the lookahead becomes insufficient.
	 * Updates strstart and lookahead.
	 *
	 * IN assertion: lookahead < MIN_LOOKAHEAD
	 * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
	 *    At least one byte has been read, or avail_in == 0; reads are
	 *    performed for at least two bytes (required for the zip translate_eol
	 *    option -- not supported here).
	 */
	function fill_window(s) {
	  var _w_size = s.w_size;
	  var p, n, m, more, str;

	  //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

	  do {
	    more = s.window_size - s.lookahead - s.strstart;

	    // JS ints have 32 bit, block below not needed
	    /* Deal with !@#$% 64K limit: */
	    //if (sizeof(int) <= 2) {
	    //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
	    //        more = wsize;
	    //
	    //  } else if (more == (unsigned)(-1)) {
	    //        /* Very unlikely, but possible on 16 bit machine if
	    //         * strstart == 0 && lookahead == 1 (input done a byte at time)
	    //         */
	    //        more--;
	    //    }
	    //}


	    /* If the window is almost full and there is insufficient lookahead,
	     * move the upper half to the lower one to make room in the upper half.
	     */
	    if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {

	      utils.arraySet(s.window, s.window, _w_size, _w_size, 0);
	      s.match_start -= _w_size;
	      s.strstart -= _w_size;
	      /* we now have strstart >= MAX_DIST */
	      s.block_start -= _w_size;

	      /* Slide the hash table (could be avoided with 32 bit values
	       at the expense of memory usage). We slide even when level == 0
	       to keep the hash table consistent if we switch back to level > 0
	       later. (Using level 0 permanently is not an optimal usage of
	       zlib, so we don't care about this pathological case.)
	       */

	      n = s.hash_size;
	      p = n;
	      do {
	        m = s.head[--p];
	        s.head[p] = (m >= _w_size ? m - _w_size : 0);
	      } while (--n);

	      n = _w_size;
	      p = n;
	      do {
	        m = s.prev[--p];
	        s.prev[p] = (m >= _w_size ? m - _w_size : 0);
	        /* If n is not on any hash chain, prev[n] is garbage but
	         * its value will never be used.
	         */
	      } while (--n);

	      more += _w_size;
	    }
	    if (s.strm.avail_in === 0) {
	      break;
	    }

	    /* If there was no sliding:
	     *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
	     *    more == window_size - lookahead - strstart
	     * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
	     * => more >= window_size - 2*WSIZE + 2
	     * In the BIG_MEM or MMAP case (not yet supported),
	     *   window_size == input_size + MIN_LOOKAHEAD  &&
	     *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
	     * Otherwise, window_size == 2*WSIZE so more >= 2.
	     * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
	     */
	    //Assert(more >= 2, "more < 2");
	    n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
	    s.lookahead += n;

	    /* Initialize the hash value now that we have some input: */
	    if (s.lookahead + s.insert >= MIN_MATCH) {
	      str = s.strstart - s.insert;
	      s.ins_h = s.window[str];

	      /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + 1]) & s.hash_mask;
	//#if MIN_MATCH != 3
	//        Call update_hash() MIN_MATCH-3 more times
	//#endif
	      while (s.insert) {
	        /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
	        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

	        s.prev[str & s.w_mask] = s.head[s.ins_h];
	        s.head[s.ins_h] = str;
	        str++;
	        s.insert--;
	        if (s.lookahead + s.insert < MIN_MATCH) {
	          break;
	        }
	      }
	    }
	    /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
	     * but this is not important since only literal bytes will be emitted.
	     */

	  } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);

	  /* If the WIN_INIT bytes after the end of the current data have never been
	   * written, then zero those bytes in order to avoid memory check reports of
	   * the use of uninitialized (or uninitialised as Julian writes) bytes by
	   * the longest match routines.  Update the high water mark for the next
	   * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
	   * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
	   */
	//  if (s.high_water < s.window_size) {
	//    var curr = s.strstart + s.lookahead;
	//    var init = 0;
	//
	//    if (s.high_water < curr) {
	//      /* Previous high water mark below current data -- zero WIN_INIT
	//       * bytes or up to end of window, whichever is less.
	//       */
	//      init = s.window_size - curr;
	//      if (init > WIN_INIT)
	//        init = WIN_INIT;
	//      zmemzero(s->window + curr, (unsigned)init);
	//      s->high_water = curr + init;
	//    }
	//    else if (s->high_water < (ulg)curr + WIN_INIT) {
	//      /* High water mark at or above current data, but below current data
	//       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
	//       * to end of window, whichever is less.
	//       */
	//      init = (ulg)curr + WIN_INIT - s->high_water;
	//      if (init > s->window_size - s->high_water)
	//        init = s->window_size - s->high_water;
	//      zmemzero(s->window + s->high_water, (unsigned)init);
	//      s->high_water += init;
	//    }
	//  }
	//
	//  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
	//    "not enough room for search");
	}

	/* ===========================================================================
	 * Copy without compression as much as possible from the input stream, return
	 * the current block state.
	 * This function does not insert new strings in the dictionary since
	 * uncompressible data is probably not useful. This function is used
	 * only for the level=0 compression option.
	 * NOTE: this function should be optimized to avoid extra copying from
	 * window to pending_buf.
	 */
	function deflate_stored(s, flush) {
	  /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
	   * to pending_buf_size, and each stored block has a 5 byte header:
	   */
	  var max_block_size = 0xffff;

	  if (max_block_size > s.pending_buf_size - 5) {
	    max_block_size = s.pending_buf_size - 5;
	  }

	  /* Copy as much as possible from input to output: */
	  for (;;) {
	    /* Fill the window as much as possible: */
	    if (s.lookahead <= 1) {

	      //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
	      //  s->block_start >= (long)s->w_size, "slide too late");
	//      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
	//        s.block_start >= s.w_size)) {
	//        throw  new Error("slide too late");
	//      }

	      fill_window(s);
	      if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }

	      if (s.lookahead === 0) {
	        break;
	      }
	      /* flush the current block */
	    }
	    //Assert(s->block_start >= 0L, "block gone");
	//    if (s.block_start < 0) throw new Error("block gone");

	    s.strstart += s.lookahead;
	    s.lookahead = 0;

	    /* Emit a stored block if pending_buf will be full: */
	    var max_start = s.block_start + max_block_size;

	    if (s.strstart === 0 || s.strstart >= max_start) {
	      /* strstart == 0 is possible when wraparound on 16-bit machine */
	      s.lookahead = s.strstart - max_start;
	      s.strstart = max_start;
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/


	    }
	    /* Flush if we may have to slide, otherwise block_start may become
	     * negative and the data will be gone:
	     */
	    if (s.strstart - s.block_start >= (s.w_size - MIN_LOOKAHEAD)) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }

	  s.insert = 0;

	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }

	  if (s.strstart > s.block_start) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }

	  return BS_NEED_MORE;
	}

	/* ===========================================================================
	 * Compress as much as possible from the input stream, return the current
	 * block state.
	 * This function does not perform lazy evaluation of matches and inserts
	 * new strings in the dictionary only for unmatched strings or for short
	 * matches. It is used only for the fast compression options.
	 */
	function deflate_fast(s, flush) {
	  var hash_head;        /* head of the hash chain */
	  var bflush;           /* set if current block must be flushed */

	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the next match, plus MIN_MATCH bytes to insert the
	     * string following the next match.
	     */
	    if (s.lookahead < MIN_LOOKAHEAD) {
	      fill_window(s);
	      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) {
	        break; /* flush the current block */
	      }
	    }

	    /* Insert the string window[strstart .. strstart+2] in the
	     * dictionary, and set hash_head to the head of the hash chain:
	     */
	    hash_head = 0/*NIL*/;
	    if (s.lookahead >= MIN_MATCH) {
	      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	      s.head[s.ins_h] = s.strstart;
	      /***/
	    }

	    /* Find the longest match, discarding those <= prev_length.
	     * At this point we have always match_length < MIN_MATCH
	     */
	    if (hash_head !== 0/*NIL*/ && ((s.strstart - hash_head) <= (s.w_size - MIN_LOOKAHEAD))) {
	      /* To simplify the code, we prevent matches with the string
	       * of window index 0 (in particular we have to avoid a match
	       * of the string with itself at the start of the input file).
	       */
	      s.match_length = longest_match(s, hash_head);
	      /* longest_match() sets match_start */
	    }
	    if (s.match_length >= MIN_MATCH) {
	      // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

	      /*** _tr_tally_dist(s, s.strstart - s.match_start,
	                     s.match_length - MIN_MATCH, bflush); ***/
	      bflush = trees._tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);

	      s.lookahead -= s.match_length;

	      /* Insert new strings in the hash table only if the match length
	       * is not too large. This saves time but degrades compression.
	       */
	      if (s.match_length <= s.max_lazy_match/*max_insert_length*/ && s.lookahead >= MIN_MATCH) {
	        s.match_length--; /* string at strstart already in table */
	        do {
	          s.strstart++;
	          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	          s.head[s.ins_h] = s.strstart;
	          /***/
	          /* strstart never exceeds WSIZE-MAX_MATCH, so there are
	           * always MIN_MATCH bytes ahead.
	           */
	        } while (--s.match_length !== 0);
	        s.strstart++;
	      } else
	      {
	        s.strstart += s.match_length;
	        s.match_length = 0;
	        s.ins_h = s.window[s.strstart];
	        /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */
	        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + 1]) & s.hash_mask;

	//#if MIN_MATCH != 3
	//                Call UPDATE_HASH() MIN_MATCH-3 more times
	//#endif
	        /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
	         * matter since it will be recomputed at next deflate call.
	         */
	      }
	    } else {
	      /* No match, output a literal byte */
	      //Tracevv((stderr,"%c", s.window[s.strstart]));
	      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

	      s.lookahead--;
	      s.strstart++;
	    }
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = ((s.strstart < (MIN_MATCH - 1)) ? s.strstart : MIN_MATCH - 1);
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* ===========================================================================
	 * Same as above, but achieves better compression. We use a lazy
	 * evaluation for matches: a match is finally adopted only if there is
	 * no better match at the next window position.
	 */
	function deflate_slow(s, flush) {
	  var hash_head;          /* head of hash chain */
	  var bflush;              /* set if current block must be flushed */

	  var max_insert;

	  /* Process the input block. */
	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the next match, plus MIN_MATCH bytes to insert the
	     * string following the next match.
	     */
	    if (s.lookahead < MIN_LOOKAHEAD) {
	      fill_window(s);
	      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) { break; } /* flush the current block */
	    }

	    /* Insert the string window[strstart .. strstart+2] in the
	     * dictionary, and set hash_head to the head of the hash chain:
	     */
	    hash_head = 0/*NIL*/;
	    if (s.lookahead >= MIN_MATCH) {
	      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	      s.head[s.ins_h] = s.strstart;
	      /***/
	    }

	    /* Find the longest match, discarding those <= prev_length.
	     */
	    s.prev_length = s.match_length;
	    s.prev_match = s.match_start;
	    s.match_length = MIN_MATCH - 1;

	    if (hash_head !== 0/*NIL*/ && s.prev_length < s.max_lazy_match &&
	        s.strstart - hash_head <= (s.w_size - MIN_LOOKAHEAD)/*MAX_DIST(s)*/) {
	      /* To simplify the code, we prevent matches with the string
	       * of window index 0 (in particular we have to avoid a match
	       * of the string with itself at the start of the input file).
	       */
	      s.match_length = longest_match(s, hash_head);
	      /* longest_match() sets match_start */

	      if (s.match_length <= 5 &&
	         (s.strategy === Z_FILTERED || (s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096/*TOO_FAR*/))) {

	        /* If prev_match is also MIN_MATCH, match_start is garbage
	         * but we will ignore the current match anyway.
	         */
	        s.match_length = MIN_MATCH - 1;
	      }
	    }
	    /* If there was a match at the previous step and the current
	     * match is not better, output the previous match:
	     */
	    if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
	      max_insert = s.strstart + s.lookahead - MIN_MATCH;
	      /* Do not insert strings in hash table beyond this. */

	      //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

	      /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
	                     s.prev_length - MIN_MATCH, bflush);***/
	      bflush = trees._tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH);
	      /* Insert in hash table all strings up to the end of the match.
	       * strstart-1 and strstart are already inserted. If there is not
	       * enough lookahead, the last two strings are not inserted in
	       * the hash table.
	       */
	      s.lookahead -= s.prev_length - 1;
	      s.prev_length -= 2;
	      do {
	        if (++s.strstart <= max_insert) {
	          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	          s.head[s.ins_h] = s.strstart;
	          /***/
	        }
	      } while (--s.prev_length !== 0);
	      s.match_available = 0;
	      s.match_length = MIN_MATCH - 1;
	      s.strstart++;

	      if (bflush) {
	        /*** FLUSH_BLOCK(s, 0); ***/
	        flush_block_only(s, false);
	        if (s.strm.avail_out === 0) {
	          return BS_NEED_MORE;
	        }
	        /***/
	      }

	    } else if (s.match_available) {
	      /* If there was no match at the previous position, output a
	       * single literal. If there was a match but the current match
	       * is longer, truncate the previous match to a single literal.
	       */
	      //Tracevv((stderr,"%c", s->window[s->strstart-1]));
	      /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

	      if (bflush) {
	        /*** FLUSH_BLOCK_ONLY(s, 0) ***/
	        flush_block_only(s, false);
	        /***/
	      }
	      s.strstart++;
	      s.lookahead--;
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	    } else {
	      /* There is no previous match to compare with, wait for
	       * the next step to decide.
	       */
	      s.match_available = 1;
	      s.strstart++;
	      s.lookahead--;
	    }
	  }
	  //Assert (flush != Z_NO_FLUSH, "no flush?");
	  if (s.match_available) {
	    //Tracevv((stderr,"%c", s->window[s->strstart-1]));
	    /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
	    bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

	    s.match_available = 0;
	  }
	  s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }

	  return BS_BLOCK_DONE;
	}


	/* ===========================================================================
	 * For Z_RLE, simply look for runs of bytes, generate matches only of distance
	 * one.  Do not maintain a hash table.  (It will be regenerated if this run of
	 * deflate switches away from Z_RLE.)
	 */
	function deflate_rle(s, flush) {
	  var bflush;            /* set if current block must be flushed */
	  var prev;              /* byte at distance one to match */
	  var scan, strend;      /* scan goes up to strend for length of run */

	  var _win = s.window;

	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the longest run, plus one for the unrolled loop.
	     */
	    if (s.lookahead <= MAX_MATCH) {
	      fill_window(s);
	      if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) { break; } /* flush the current block */
	    }

	    /* See how many times the previous byte repeats */
	    s.match_length = 0;
	    if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
	      scan = s.strstart - 1;
	      prev = _win[scan];
	      if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
	        strend = s.strstart + MAX_MATCH;
	        do {
	          /*jshint noempty:false*/
	        } while (prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 scan < strend);
	        s.match_length = MAX_MATCH - (strend - scan);
	        if (s.match_length > s.lookahead) {
	          s.match_length = s.lookahead;
	        }
	      }
	      //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");
	    }

	    /* Emit match if have run of MIN_MATCH or longer, else emit literal */
	    if (s.match_length >= MIN_MATCH) {
	      //check_match(s, s.strstart, s.strstart - 1, s.match_length);

	      /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
	      bflush = trees._tr_tally(s, 1, s.match_length - MIN_MATCH);

	      s.lookahead -= s.match_length;
	      s.strstart += s.match_length;
	      s.match_length = 0;
	    } else {
	      /* No match, output a literal byte */
	      //Tracevv((stderr,"%c", s->window[s->strstart]));
	      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

	      s.lookahead--;
	      s.strstart++;
	    }
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = 0;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* ===========================================================================
	 * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
	 * (It will be regenerated if this run of deflate switches away from Huffman.)
	 */
	function deflate_huff(s, flush) {
	  var bflush;             /* set if current block must be flushed */

	  for (;;) {
	    /* Make sure that we have a literal to write. */
	    if (s.lookahead === 0) {
	      fill_window(s);
	      if (s.lookahead === 0) {
	        if (flush === Z_NO_FLUSH) {
	          return BS_NEED_MORE;
	        }
	        break;      /* flush the current block */
	      }
	    }

	    /* Output a literal byte */
	    s.match_length = 0;
	    //Tracevv((stderr,"%c", s->window[s->strstart]));
	    /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	    bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
	    s.lookahead--;
	    s.strstart++;
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = 0;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* Values for max_lazy_match, good_match and max_chain_length, depending on
	 * the desired pack level (0..9). The values given below have been tuned to
	 * exclude worst case performance for pathological files. Better values may be
	 * found for specific files.
	 */
	function Config(good_length, max_lazy, nice_length, max_chain, func) {
	  this.good_length = good_length;
	  this.max_lazy = max_lazy;
	  this.nice_length = nice_length;
	  this.max_chain = max_chain;
	  this.func = func;
	}

	var configuration_table;

	configuration_table = [
	  /*      good lazy nice chain */
	  new Config(0, 0, 0, 0, deflate_stored),          /* 0 store only */
	  new Config(4, 4, 8, 4, deflate_fast),            /* 1 max speed, no lazy matches */
	  new Config(4, 5, 16, 8, deflate_fast),           /* 2 */
	  new Config(4, 6, 32, 32, deflate_fast),          /* 3 */

	  new Config(4, 4, 16, 16, deflate_slow),          /* 4 lazy matches */
	  new Config(8, 16, 32, 32, deflate_slow),         /* 5 */
	  new Config(8, 16, 128, 128, deflate_slow),       /* 6 */
	  new Config(8, 32, 128, 256, deflate_slow),       /* 7 */
	  new Config(32, 128, 258, 1024, deflate_slow),    /* 8 */
	  new Config(32, 258, 258, 4096, deflate_slow)     /* 9 max compression */
	];


	/* ===========================================================================
	 * Initialize the "longest match" routines for a new zlib stream
	 */
	function lm_init(s) {
	  s.window_size = 2 * s.w_size;

	  /*** CLEAR_HASH(s); ***/
	  zero(s.head); // Fill with NIL (= 0);

	  /* Set the default configuration parameters:
	   */
	  s.max_lazy_match = configuration_table[s.level].max_lazy;
	  s.good_match = configuration_table[s.level].good_length;
	  s.nice_match = configuration_table[s.level].nice_length;
	  s.max_chain_length = configuration_table[s.level].max_chain;

	  s.strstart = 0;
	  s.block_start = 0;
	  s.lookahead = 0;
	  s.insert = 0;
	  s.match_length = s.prev_length = MIN_MATCH - 1;
	  s.match_available = 0;
	  s.ins_h = 0;
	}


	function DeflateState() {
	  this.strm = null;            /* pointer back to this zlib stream */
	  this.status = 0;            /* as the name implies */
	  this.pending_buf = null;      /* output still pending */
	  this.pending_buf_size = 0;  /* size of pending_buf */
	  this.pending_out = 0;       /* next pending byte to output to the stream */
	  this.pending = 0;           /* nb of bytes in the pending buffer */
	  this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip */
	  this.gzhead = null;         /* gzip header information to write */
	  this.gzindex = 0;           /* where in extra, name, or comment */
	  this.method = Z_DEFLATED; /* can only be DEFLATED */
	  this.last_flush = -1;   /* value of flush param for previous deflate call */

	  this.w_size = 0;  /* LZ77 window size (32K by default) */
	  this.w_bits = 0;  /* log2(w_size)  (8..16) */
	  this.w_mask = 0;  /* w_size - 1 */

	  this.window = null;
	  /* Sliding window. Input bytes are read into the second half of the window,
	   * and move to the first half later to keep a dictionary of at least wSize
	   * bytes. With this organization, matches are limited to a distance of
	   * wSize-MAX_MATCH bytes, but this ensures that IO is always
	   * performed with a length multiple of the block size.
	   */

	  this.window_size = 0;
	  /* Actual size of window: 2*wSize, except when the user input buffer
	   * is directly used as sliding window.
	   */

	  this.prev = null;
	  /* Link to older string with same hash index. To limit the size of this
	   * array to 64K, this link is maintained only for the last 32K strings.
	   * An index in this array is thus a window index modulo 32K.
	   */

	  this.head = null;   /* Heads of the hash chains or NIL. */

	  this.ins_h = 0;       /* hash index of string to be inserted */
	  this.hash_size = 0;   /* number of elements in hash table */
	  this.hash_bits = 0;   /* log2(hash_size) */
	  this.hash_mask = 0;   /* hash_size-1 */

	  this.hash_shift = 0;
	  /* Number of bits by which ins_h must be shifted at each input
	   * step. It must be such that after MIN_MATCH steps, the oldest
	   * byte no longer takes part in the hash key, that is:
	   *   hash_shift * MIN_MATCH >= hash_bits
	   */

	  this.block_start = 0;
	  /* Window position at the beginning of the current output block. Gets
	   * negative when the window is moved backwards.
	   */

	  this.match_length = 0;      /* length of best match */
	  this.prev_match = 0;        /* previous match */
	  this.match_available = 0;   /* set if previous match exists */
	  this.strstart = 0;          /* start of string to insert */
	  this.match_start = 0;       /* start of matching string */
	  this.lookahead = 0;         /* number of valid bytes ahead in window */

	  this.prev_length = 0;
	  /* Length of the best match at previous step. Matches not greater than this
	   * are discarded. This is used in the lazy match evaluation.
	   */

	  this.max_chain_length = 0;
	  /* To speed up deflation, hash chains are never searched beyond this
	   * length.  A higher limit improves compression ratio but degrades the
	   * speed.
	   */

	  this.max_lazy_match = 0;
	  /* Attempt to find a better match only when the current match is strictly
	   * smaller than this value. This mechanism is used only for compression
	   * levels >= 4.
	   */
	  // That's alias to max_lazy_match, don't use directly
	  //this.max_insert_length = 0;
	  /* Insert new strings in the hash table only if the match length is not
	   * greater than this length. This saves time but degrades compression.
	   * max_insert_length is used only for compression levels <= 3.
	   */

	  this.level = 0;     /* compression level (1..9) */
	  this.strategy = 0;  /* favor or force Huffman coding*/

	  this.good_match = 0;
	  /* Use a faster search when the previous match is longer than this */

	  this.nice_match = 0; /* Stop searching when current match exceeds this */

	              /* used by trees.c: */

	  /* Didn't use ct_data typedef below to suppress compiler warning */

	  // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
	  // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
	  // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */

	  // Use flat array of DOUBLE size, with interleaved fata,
	  // because JS does not support effective
	  this.dyn_ltree  = new utils.Buf16(HEAP_SIZE * 2);
	  this.dyn_dtree  = new utils.Buf16((2 * D_CODES + 1) * 2);
	  this.bl_tree    = new utils.Buf16((2 * BL_CODES + 1) * 2);
	  zero(this.dyn_ltree);
	  zero(this.dyn_dtree);
	  zero(this.bl_tree);

	  this.l_desc   = null;         /* desc. for literal tree */
	  this.d_desc   = null;         /* desc. for distance tree */
	  this.bl_desc  = null;         /* desc. for bit length tree */

	  //ush bl_count[MAX_BITS+1];
	  this.bl_count = new utils.Buf16(MAX_BITS + 1);
	  /* number of codes at each bit length for an optimal tree */

	  //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */
	  this.heap = new utils.Buf16(2 * L_CODES + 1);  /* heap used to build the Huffman trees */
	  zero(this.heap);

	  this.heap_len = 0;               /* number of elements in the heap */
	  this.heap_max = 0;               /* element of largest frequency */
	  /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
	   * The same heap array is used to build all trees.
	   */

	  this.depth = new utils.Buf16(2 * L_CODES + 1); //uch depth[2*L_CODES+1];
	  zero(this.depth);
	  /* Depth of each subtree used as tie breaker for trees of equal frequency
	   */

	  this.l_buf = 0;          /* buffer index for literals or lengths */

	  this.lit_bufsize = 0;
	  /* Size of match buffer for literals/lengths.  There are 4 reasons for
	   * limiting lit_bufsize to 64K:
	   *   - frequencies can be kept in 16 bit counters
	   *   - if compression is not successful for the first block, all input
	   *     data is still in the window so we can still emit a stored block even
	   *     when input comes from standard input.  (This can also be done for
	   *     all blocks if lit_bufsize is not greater than 32K.)
	   *   - if compression is not successful for a file smaller than 64K, we can
	   *     even emit a stored file instead of a stored block (saving 5 bytes).
	   *     This is applicable only for zip (not gzip or zlib).
	   *   - creating new Huffman trees less frequently may not provide fast
	   *     adaptation to changes in the input data statistics. (Take for
	   *     example a binary file with poorly compressible code followed by
	   *     a highly compressible string table.) Smaller buffer sizes give
	   *     fast adaptation but have of course the overhead of transmitting
	   *     trees more frequently.
	   *   - I can't count above 4
	   */

	  this.last_lit = 0;      /* running index in l_buf */

	  this.d_buf = 0;
	  /* Buffer index for distances. To simplify the code, d_buf and l_buf have
	   * the same number of elements. To use different lengths, an extra flag
	   * array would be necessary.
	   */

	  this.opt_len = 0;       /* bit length of current block with optimal trees */
	  this.static_len = 0;    /* bit length of current block with static trees */
	  this.matches = 0;       /* number of string matches in current block */
	  this.insert = 0;        /* bytes at end of window left to insert */


	  this.bi_buf = 0;
	  /* Output buffer. bits are inserted starting at the bottom (least
	   * significant bits).
	   */
	  this.bi_valid = 0;
	  /* Number of valid bits in bi_buf.  All bits above the last valid bit
	   * are always zero.
	   */

	  // Used for window memory init. We safely ignore it for JS. That makes
	  // sense only for pointers and memory check tools.
	  //this.high_water = 0;
	  /* High water mark offset in window for initialized bytes -- bytes above
	   * this are set to zero in order to avoid memory check warnings when
	   * longest match routines access bytes past the input.  This is then
	   * updated to the new high water mark.
	   */
	}


	function deflateResetKeep(strm) {
	  var s;

	  if (!strm || !strm.state) {
	    return err(strm, Z_STREAM_ERROR);
	  }

	  strm.total_in = strm.total_out = 0;
	  strm.data_type = Z_UNKNOWN;

	  s = strm.state;
	  s.pending = 0;
	  s.pending_out = 0;

	  if (s.wrap < 0) {
	    s.wrap = -s.wrap;
	    /* was made negative by deflate(..., Z_FINISH); */
	  }
	  s.status = (s.wrap ? INIT_STATE : BUSY_STATE);
	  strm.adler = (s.wrap === 2) ?
	    0  // crc32(0, Z_NULL, 0)
	  :
	    1; // adler32(0, Z_NULL, 0)
	  s.last_flush = Z_NO_FLUSH;
	  trees._tr_init(s);
	  return Z_OK;
	}


	function deflateReset(strm) {
	  var ret = deflateResetKeep(strm);
	  if (ret === Z_OK) {
	    lm_init(strm.state);
	  }
	  return ret;
	}


	function deflateSetHeader(strm, head) {
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  if (strm.state.wrap !== 2) { return Z_STREAM_ERROR; }
	  strm.state.gzhead = head;
	  return Z_OK;
	}


	function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
	  if (!strm) { // === Z_NULL
	    return Z_STREAM_ERROR;
	  }
	  var wrap = 1;

	  if (level === Z_DEFAULT_COMPRESSION) {
	    level = 6;
	  }

	  if (windowBits < 0) { /* suppress zlib wrapper */
	    wrap = 0;
	    windowBits = -windowBits;
	  }

	  else if (windowBits > 15) {
	    wrap = 2;           /* write gzip wrapper instead */
	    windowBits -= 16;
	  }


	  if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED ||
	    windowBits < 8 || windowBits > 15 || level < 0 || level > 9 ||
	    strategy < 0 || strategy > Z_FIXED) {
	    return err(strm, Z_STREAM_ERROR);
	  }


	  if (windowBits === 8) {
	    windowBits = 9;
	  }
	  /* until 256-byte window bug fixed */

	  var s = new DeflateState();

	  strm.state = s;
	  s.strm = strm;

	  s.wrap = wrap;
	  s.gzhead = null;
	  s.w_bits = windowBits;
	  s.w_size = 1 << s.w_bits;
	  s.w_mask = s.w_size - 1;

	  s.hash_bits = memLevel + 7;
	  s.hash_size = 1 << s.hash_bits;
	  s.hash_mask = s.hash_size - 1;
	  s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);

	  s.window = new utils.Buf8(s.w_size * 2);
	  s.head = new utils.Buf16(s.hash_size);
	  s.prev = new utils.Buf16(s.w_size);

	  // Don't need mem init magic for JS.
	  //s.high_water = 0;  /* nothing written to s->window yet */

	  s.lit_bufsize = 1 << (memLevel + 6); /* 16K elements by default */

	  s.pending_buf_size = s.lit_bufsize * 4;

	  //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
	  //s->pending_buf = (uchf *) overlay;
	  s.pending_buf = new utils.Buf8(s.pending_buf_size);

	  // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
	  //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);
	  s.d_buf = 1 * s.lit_bufsize;

	  //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;
	  s.l_buf = (1 + 2) * s.lit_bufsize;

	  s.level = level;
	  s.strategy = strategy;
	  s.method = method;

	  return deflateReset(strm);
	}

	function deflateInit(strm, level) {
	  return deflateInit2(strm, level, Z_DEFLATED, MAX_WBITS, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY);
	}


	function deflate(strm, flush) {
	  var old_flush, s;
	  var beg, val; // for gzip header write only

	  if (!strm || !strm.state ||
	    flush > Z_BLOCK || flush < 0) {
	    return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
	  }

	  s = strm.state;

	  if (!strm.output ||
	      (!strm.input && strm.avail_in !== 0) ||
	      (s.status === FINISH_STATE && flush !== Z_FINISH)) {
	    return err(strm, (strm.avail_out === 0) ? Z_BUF_ERROR : Z_STREAM_ERROR);
	  }

	  s.strm = strm; /* just in case */
	  old_flush = s.last_flush;
	  s.last_flush = flush;

	  /* Write the header */
	  if (s.status === INIT_STATE) {

	    if (s.wrap === 2) { // GZIP header
	      strm.adler = 0;  //crc32(0L, Z_NULL, 0);
	      put_byte(s, 31);
	      put_byte(s, 139);
	      put_byte(s, 8);
	      if (!s.gzhead) { // s->gzhead == Z_NULL
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, s.level === 9 ? 2 :
	                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
	                     4 : 0));
	        put_byte(s, OS_CODE);
	        s.status = BUSY_STATE;
	      }
	      else {
	        put_byte(s, (s.gzhead.text ? 1 : 0) +
	                    (s.gzhead.hcrc ? 2 : 0) +
	                    (!s.gzhead.extra ? 0 : 4) +
	                    (!s.gzhead.name ? 0 : 8) +
	                    (!s.gzhead.comment ? 0 : 16)
	                );
	        put_byte(s, s.gzhead.time & 0xff);
	        put_byte(s, (s.gzhead.time >> 8) & 0xff);
	        put_byte(s, (s.gzhead.time >> 16) & 0xff);
	        put_byte(s, (s.gzhead.time >> 24) & 0xff);
	        put_byte(s, s.level === 9 ? 2 :
	                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
	                     4 : 0));
	        put_byte(s, s.gzhead.os & 0xff);
	        if (s.gzhead.extra && s.gzhead.extra.length) {
	          put_byte(s, s.gzhead.extra.length & 0xff);
	          put_byte(s, (s.gzhead.extra.length >> 8) & 0xff);
	        }
	        if (s.gzhead.hcrc) {
	          strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
	        }
	        s.gzindex = 0;
	        s.status = EXTRA_STATE;
	      }
	    }
	    else // DEFLATE header
	    {
	      var header = (Z_DEFLATED + ((s.w_bits - 8) << 4)) << 8;
	      var level_flags = -1;

	      if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
	        level_flags = 0;
	      } else if (s.level < 6) {
	        level_flags = 1;
	      } else if (s.level === 6) {
	        level_flags = 2;
	      } else {
	        level_flags = 3;
	      }
	      header |= (level_flags << 6);
	      if (s.strstart !== 0) { header |= PRESET_DICT; }
	      header += 31 - (header % 31);

	      s.status = BUSY_STATE;
	      putShortMSB(s, header);

	      /* Save the adler32 of the preset dictionary: */
	      if (s.strstart !== 0) {
	        putShortMSB(s, strm.adler >>> 16);
	        putShortMSB(s, strm.adler & 0xffff);
	      }
	      strm.adler = 1; // adler32(0L, Z_NULL, 0);
	    }
	  }

	//#ifdef GZIP
	  if (s.status === EXTRA_STATE) {
	    if (s.gzhead.extra/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */

	      while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            break;
	          }
	        }
	        put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
	        s.gzindex++;
	      }
	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (s.gzindex === s.gzhead.extra.length) {
	        s.gzindex = 0;
	        s.status = NAME_STATE;
	      }
	    }
	    else {
	      s.status = NAME_STATE;
	    }
	  }
	  if (s.status === NAME_STATE) {
	    if (s.gzhead.name/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */
	      //int val;

	      do {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            val = 1;
	            break;
	          }
	        }
	        // JS specific: little magic to add zero terminator to end of string
	        if (s.gzindex < s.gzhead.name.length) {
	          val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
	        } else {
	          val = 0;
	        }
	        put_byte(s, val);
	      } while (val !== 0);

	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (val === 0) {
	        s.gzindex = 0;
	        s.status = COMMENT_STATE;
	      }
	    }
	    else {
	      s.status = COMMENT_STATE;
	    }
	  }
	  if (s.status === COMMENT_STATE) {
	    if (s.gzhead.comment/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */
	      //int val;

	      do {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            val = 1;
	            break;
	          }
	        }
	        // JS specific: little magic to add zero terminator to end of string
	        if (s.gzindex < s.gzhead.comment.length) {
	          val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
	        } else {
	          val = 0;
	        }
	        put_byte(s, val);
	      } while (val !== 0);

	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (val === 0) {
	        s.status = HCRC_STATE;
	      }
	    }
	    else {
	      s.status = HCRC_STATE;
	    }
	  }
	  if (s.status === HCRC_STATE) {
	    if (s.gzhead.hcrc) {
	      if (s.pending + 2 > s.pending_buf_size) {
	        flush_pending(strm);
	      }
	      if (s.pending + 2 <= s.pending_buf_size) {
	        put_byte(s, strm.adler & 0xff);
	        put_byte(s, (strm.adler >> 8) & 0xff);
	        strm.adler = 0; //crc32(0L, Z_NULL, 0);
	        s.status = BUSY_STATE;
	      }
	    }
	    else {
	      s.status = BUSY_STATE;
	    }
	  }
	//#endif

	  /* Flush as much pending output as possible */
	  if (s.pending !== 0) {
	    flush_pending(strm);
	    if (strm.avail_out === 0) {
	      /* Since avail_out is 0, deflate will be called again with
	       * more output space, but possibly with both pending and
	       * avail_in equal to zero. There won't be anything to do,
	       * but this is not an error situation so make sure we
	       * return OK instead of BUF_ERROR at next call of deflate:
	       */
	      s.last_flush = -1;
	      return Z_OK;
	    }

	    /* Make sure there is something to do and avoid duplicate consecutive
	     * flushes. For repeated and useless calls with Z_FINISH, we keep
	     * returning Z_STREAM_END instead of Z_BUF_ERROR.
	     */
	  } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) &&
	    flush !== Z_FINISH) {
	    return err(strm, Z_BUF_ERROR);
	  }

	  /* User must not provide more input after the first FINISH: */
	  if (s.status === FINISH_STATE && strm.avail_in !== 0) {
	    return err(strm, Z_BUF_ERROR);
	  }

	  /* Start a new block or continue the current one.
	   */
	  if (strm.avail_in !== 0 || s.lookahead !== 0 ||
	    (flush !== Z_NO_FLUSH && s.status !== FINISH_STATE)) {
	    var bstate = (s.strategy === Z_HUFFMAN_ONLY) ? deflate_huff(s, flush) :
	      (s.strategy === Z_RLE ? deflate_rle(s, flush) :
	        configuration_table[s.level].func(s, flush));

	    if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
	      s.status = FINISH_STATE;
	    }
	    if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
	      if (strm.avail_out === 0) {
	        s.last_flush = -1;
	        /* avoid BUF_ERROR next call, see above */
	      }
	      return Z_OK;
	      /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
	       * of deflate should use the same flush parameter to make sure
	       * that the flush is complete. So we don't have to output an
	       * empty block here, this will be done at next call. This also
	       * ensures that for a very small output buffer, we emit at most
	       * one empty block.
	       */
	    }
	    if (bstate === BS_BLOCK_DONE) {
	      if (flush === Z_PARTIAL_FLUSH) {
	        trees._tr_align(s);
	      }
	      else if (flush !== Z_BLOCK) { /* FULL_FLUSH or SYNC_FLUSH */

	        trees._tr_stored_block(s, 0, 0, false);
	        /* For a full flush, this empty block will be recognized
	         * as a special marker by inflate_sync().
	         */
	        if (flush === Z_FULL_FLUSH) {
	          /*** CLEAR_HASH(s); ***/             /* forget history */
	          zero(s.head); // Fill with NIL (= 0);

	          if (s.lookahead === 0) {
	            s.strstart = 0;
	            s.block_start = 0;
	            s.insert = 0;
	          }
	        }
	      }
	      flush_pending(strm);
	      if (strm.avail_out === 0) {
	        s.last_flush = -1; /* avoid BUF_ERROR at next call, see above */
	        return Z_OK;
	      }
	    }
	  }
	  //Assert(strm->avail_out > 0, "bug2");
	  //if (strm.avail_out <= 0) { throw new Error("bug2");}

	  if (flush !== Z_FINISH) { return Z_OK; }
	  if (s.wrap <= 0) { return Z_STREAM_END; }

	  /* Write the trailer */
	  if (s.wrap === 2) {
	    put_byte(s, strm.adler & 0xff);
	    put_byte(s, (strm.adler >> 8) & 0xff);
	    put_byte(s, (strm.adler >> 16) & 0xff);
	    put_byte(s, (strm.adler >> 24) & 0xff);
	    put_byte(s, strm.total_in & 0xff);
	    put_byte(s, (strm.total_in >> 8) & 0xff);
	    put_byte(s, (strm.total_in >> 16) & 0xff);
	    put_byte(s, (strm.total_in >> 24) & 0xff);
	  }
	  else
	  {
	    putShortMSB(s, strm.adler >>> 16);
	    putShortMSB(s, strm.adler & 0xffff);
	  }

	  flush_pending(strm);
	  /* If avail_out is zero, the application will call deflate again
	   * to flush the rest.
	   */
	  if (s.wrap > 0) { s.wrap = -s.wrap; }
	  /* write the trailer only once! */
	  return s.pending !== 0 ? Z_OK : Z_STREAM_END;
	}

	function deflateEnd(strm) {
	  var status;

	  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
	    return Z_STREAM_ERROR;
	  }

	  status = strm.state.status;
	  if (status !== INIT_STATE &&
	    status !== EXTRA_STATE &&
	    status !== NAME_STATE &&
	    status !== COMMENT_STATE &&
	    status !== HCRC_STATE &&
	    status !== BUSY_STATE &&
	    status !== FINISH_STATE
	  ) {
	    return err(strm, Z_STREAM_ERROR);
	  }

	  strm.state = null;

	  return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
	}


	/* =========================================================================
	 * Initializes the compression dictionary from the given byte
	 * sequence without producing any compressed output.
	 */
	function deflateSetDictionary(strm, dictionary) {
	  var dictLength = dictionary.length;

	  var s;
	  var str, n;
	  var wrap;
	  var avail;
	  var next;
	  var input;
	  var tmpDict;

	  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
	    return Z_STREAM_ERROR;
	  }

	  s = strm.state;
	  wrap = s.wrap;

	  if (wrap === 2 || (wrap === 1 && s.status !== INIT_STATE) || s.lookahead) {
	    return Z_STREAM_ERROR;
	  }

	  /* when using zlib wrappers, compute Adler-32 for provided dictionary */
	  if (wrap === 1) {
	    /* adler32(strm->adler, dictionary, dictLength); */
	    strm.adler = adler32(strm.adler, dictionary, dictLength, 0);
	  }

	  s.wrap = 0;   /* avoid computing Adler-32 in read_buf */

	  /* if dictionary would fill window, just replace the history */
	  if (dictLength >= s.w_size) {
	    if (wrap === 0) {            /* already empty otherwise */
	      /*** CLEAR_HASH(s); ***/
	      zero(s.head); // Fill with NIL (= 0);
	      s.strstart = 0;
	      s.block_start = 0;
	      s.insert = 0;
	    }
	    /* use the tail */
	    // dictionary = dictionary.slice(dictLength - s.w_size);
	    tmpDict = new utils.Buf8(s.w_size);
	    utils.arraySet(tmpDict, dictionary, dictLength - s.w_size, s.w_size, 0);
	    dictionary = tmpDict;
	    dictLength = s.w_size;
	  }
	  /* insert dictionary into window and hash */
	  avail = strm.avail_in;
	  next = strm.next_in;
	  input = strm.input;
	  strm.avail_in = dictLength;
	  strm.next_in = 0;
	  strm.input = dictionary;
	  fill_window(s);
	  while (s.lookahead >= MIN_MATCH) {
	    str = s.strstart;
	    n = s.lookahead - (MIN_MATCH - 1);
	    do {
	      /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

	      s.prev[str & s.w_mask] = s.head[s.ins_h];

	      s.head[s.ins_h] = str;
	      str++;
	    } while (--n);
	    s.strstart = str;
	    s.lookahead = MIN_MATCH - 1;
	    fill_window(s);
	  }
	  s.strstart += s.lookahead;
	  s.block_start = s.strstart;
	  s.insert = s.lookahead;
	  s.lookahead = 0;
	  s.match_length = s.prev_length = MIN_MATCH - 1;
	  s.match_available = 0;
	  strm.next_in = next;
	  strm.input = input;
	  strm.avail_in = avail;
	  s.wrap = wrap;
	  return Z_OK;
	}


	exports.deflateInit = deflateInit;
	exports.deflateInit2 = deflateInit2;
	exports.deflateReset = deflateReset;
	exports.deflateResetKeep = deflateResetKeep;
	exports.deflateSetHeader = deflateSetHeader;
	exports.deflate = deflate;
	exports.deflateEnd = deflateEnd;
	exports.deflateSetDictionary = deflateSetDictionary;
	exports.deflateInfo = 'pako deflate (from Nodeca project)';

	/* Not implemented
	exports.deflateBound = deflateBound;
	exports.deflateCopy = deflateCopy;
	exports.deflateParams = deflateParams;
	exports.deflatePending = deflatePending;
	exports.deflatePrime = deflatePrime;
	exports.deflateTune = deflateTune;
	*/


/***/ }),
/* 62 */
/***/ (function(module, exports) {

	'use strict';


	var TYPED_OK =  (typeof Uint8Array !== 'undefined') &&
	                (typeof Uint16Array !== 'undefined') &&
	                (typeof Int32Array !== 'undefined');


	exports.assign = function (obj /*from1, from2, from3, ...*/) {
	  var sources = Array.prototype.slice.call(arguments, 1);
	  while (sources.length) {
	    var source = sources.shift();
	    if (!source) { continue; }

	    if (typeof source !== 'object') {
	      throw new TypeError(source + 'must be non-object');
	    }

	    for (var p in source) {
	      if (source.hasOwnProperty(p)) {
	        obj[p] = source[p];
	      }
	    }
	  }

	  return obj;
	};


	// reduce buffer size, avoiding mem copy
	exports.shrinkBuf = function (buf, size) {
	  if (buf.length === size) { return buf; }
	  if (buf.subarray) { return buf.subarray(0, size); }
	  buf.length = size;
	  return buf;
	};


	var fnTyped = {
	  arraySet: function (dest, src, src_offs, len, dest_offs) {
	    if (src.subarray && dest.subarray) {
	      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
	      return;
	    }
	    // Fallback to ordinary array
	    for (var i = 0; i < len; i++) {
	      dest[dest_offs + i] = src[src_offs + i];
	    }
	  },
	  // Join array of chunks to single array.
	  flattenChunks: function (chunks) {
	    var i, l, len, pos, chunk, result;

	    // calculate data length
	    len = 0;
	    for (i = 0, l = chunks.length; i < l; i++) {
	      len += chunks[i].length;
	    }

	    // join chunks
	    result = new Uint8Array(len);
	    pos = 0;
	    for (i = 0, l = chunks.length; i < l; i++) {
	      chunk = chunks[i];
	      result.set(chunk, pos);
	      pos += chunk.length;
	    }

	    return result;
	  }
	};

	var fnUntyped = {
	  arraySet: function (dest, src, src_offs, len, dest_offs) {
	    for (var i = 0; i < len; i++) {
	      dest[dest_offs + i] = src[src_offs + i];
	    }
	  },
	  // Join array of chunks to single array.
	  flattenChunks: function (chunks) {
	    return [].concat.apply([], chunks);
	  }
	};


	// Enable/Disable typed arrays use, for testing
	//
	exports.setTyped = function (on) {
	  if (on) {
	    exports.Buf8  = Uint8Array;
	    exports.Buf16 = Uint16Array;
	    exports.Buf32 = Int32Array;
	    exports.assign(exports, fnTyped);
	  } else {
	    exports.Buf8  = Array;
	    exports.Buf16 = Array;
	    exports.Buf32 = Array;
	    exports.assign(exports, fnUntyped);
	  }
	};

	exports.setTyped(TYPED_OK);


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';


	var utils = __webpack_require__(62);

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	//var Z_FILTERED          = 1;
	//var Z_HUFFMAN_ONLY      = 2;
	//var Z_RLE               = 3;
	var Z_FIXED               = 4;
	//var Z_DEFAULT_STRATEGY  = 0;

	/* Possible values of the data_type field (though see inflate()) */
	var Z_BINARY              = 0;
	var Z_TEXT                = 1;
	//var Z_ASCII             = 1; // = Z_TEXT
	var Z_UNKNOWN             = 2;

	/*============================================================================*/


	function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }

	// From zutil.h

	var STORED_BLOCK = 0;
	var STATIC_TREES = 1;
	var DYN_TREES    = 2;
	/* The three kinds of block type */

	var MIN_MATCH    = 3;
	var MAX_MATCH    = 258;
	/* The minimum and maximum match lengths */

	// From deflate.h
	/* ===========================================================================
	 * Internal compression state.
	 */

	var LENGTH_CODES  = 29;
	/* number of length codes, not counting the special END_BLOCK code */

	var LITERALS      = 256;
	/* number of literal bytes 0..255 */

	var L_CODES       = LITERALS + 1 + LENGTH_CODES;
	/* number of Literal or Length codes, including the END_BLOCK code */

	var D_CODES       = 30;
	/* number of distance codes */

	var BL_CODES      = 19;
	/* number of codes used to transfer the bit lengths */

	var HEAP_SIZE     = 2 * L_CODES + 1;
	/* maximum heap size */

	var MAX_BITS      = 15;
	/* All codes must not exceed MAX_BITS bits */

	var Buf_size      = 16;
	/* size of bit buffer in bi_buf */


	/* ===========================================================================
	 * Constants
	 */

	var MAX_BL_BITS = 7;
	/* Bit length codes must not exceed MAX_BL_BITS bits */

	var END_BLOCK   = 256;
	/* end of block literal code */

	var REP_3_6     = 16;
	/* repeat previous bit length 3-6 times (2 bits of repeat count) */

	var REPZ_3_10   = 17;
	/* repeat a zero length 3-10 times  (3 bits of repeat count) */

	var REPZ_11_138 = 18;
	/* repeat a zero length 11-138 times  (7 bits of repeat count) */

	/* eslint-disable comma-spacing,array-bracket-spacing */
	var extra_lbits =   /* extra bits for each length code */
	  [0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0];

	var extra_dbits =   /* extra bits for each distance code */
	  [0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];

	var extra_blbits =  /* extra bits for each bit length code */
	  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7];

	var bl_order =
	  [16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];
	/* eslint-enable comma-spacing,array-bracket-spacing */

	/* The lengths of the bit length codes are sent in order of decreasing
	 * probability, to avoid transmitting the lengths for unused bit length codes.
	 */

	/* ===========================================================================
	 * Local data. These are initialized only once.
	 */

	// We pre-fill arrays with 0 to avoid uninitialized gaps

	var DIST_CODE_LEN = 512; /* see definition of array dist_code below */

	// !!!! Use flat array insdead of structure, Freq = i*2, Len = i*2+1
	var static_ltree  = new Array((L_CODES + 2) * 2);
	zero(static_ltree);
	/* The static literal tree. Since the bit lengths are imposed, there is no
	 * need for the L_CODES extra codes used during heap construction. However
	 * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
	 * below).
	 */

	var static_dtree  = new Array(D_CODES * 2);
	zero(static_dtree);
	/* The static distance tree. (Actually a trivial tree since all codes use
	 * 5 bits.)
	 */

	var _dist_code    = new Array(DIST_CODE_LEN);
	zero(_dist_code);
	/* Distance codes. The first 256 values correspond to the distances
	 * 3 .. 258, the last 256 values correspond to the top 8 bits of
	 * the 15 bit distances.
	 */

	var _length_code  = new Array(MAX_MATCH - MIN_MATCH + 1);
	zero(_length_code);
	/* length code for each normalized match length (0 == MIN_MATCH) */

	var base_length   = new Array(LENGTH_CODES);
	zero(base_length);
	/* First normalized length for each code (0 = MIN_MATCH) */

	var base_dist     = new Array(D_CODES);
	zero(base_dist);
	/* First normalized distance for each code (0 = distance of 1) */


	function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {

	  this.static_tree  = static_tree;  /* static tree or NULL */
	  this.extra_bits   = extra_bits;   /* extra bits for each code or NULL */
	  this.extra_base   = extra_base;   /* base index for extra_bits */
	  this.elems        = elems;        /* max number of elements in the tree */
	  this.max_length   = max_length;   /* max bit length for the codes */

	  // show if `static_tree` has data or dummy - needed for monomorphic objects
	  this.has_stree    = static_tree && static_tree.length;
	}


	var static_l_desc;
	var static_d_desc;
	var static_bl_desc;


	function TreeDesc(dyn_tree, stat_desc) {
	  this.dyn_tree = dyn_tree;     /* the dynamic tree */
	  this.max_code = 0;            /* largest code with non zero frequency */
	  this.stat_desc = stat_desc;   /* the corresponding static tree */
	}



	function d_code(dist) {
	  return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
	}


	/* ===========================================================================
	 * Output a short LSB first on the stream.
	 * IN assertion: there is enough room in pendingBuf.
	 */
	function put_short(s, w) {
	//    put_byte(s, (uch)((w) & 0xff));
	//    put_byte(s, (uch)((ush)(w) >> 8));
	  s.pending_buf[s.pending++] = (w) & 0xff;
	  s.pending_buf[s.pending++] = (w >>> 8) & 0xff;
	}


	/* ===========================================================================
	 * Send a value on a given number of bits.
	 * IN assertion: length <= 16 and value fits in length bits.
	 */
	function send_bits(s, value, length) {
	  if (s.bi_valid > (Buf_size - length)) {
	    s.bi_buf |= (value << s.bi_valid) & 0xffff;
	    put_short(s, s.bi_buf);
	    s.bi_buf = value >> (Buf_size - s.bi_valid);
	    s.bi_valid += length - Buf_size;
	  } else {
	    s.bi_buf |= (value << s.bi_valid) & 0xffff;
	    s.bi_valid += length;
	  }
	}


	function send_code(s, c, tree) {
	  send_bits(s, tree[c * 2]/*.Code*/, tree[c * 2 + 1]/*.Len*/);
	}


	/* ===========================================================================
	 * Reverse the first len bits of a code, using straightforward code (a faster
	 * method would use a table)
	 * IN assertion: 1 <= len <= 15
	 */
	function bi_reverse(code, len) {
	  var res = 0;
	  do {
	    res |= code & 1;
	    code >>>= 1;
	    res <<= 1;
	  } while (--len > 0);
	  return res >>> 1;
	}


	/* ===========================================================================
	 * Flush the bit buffer, keeping at most 7 bits in it.
	 */
	function bi_flush(s) {
	  if (s.bi_valid === 16) {
	    put_short(s, s.bi_buf);
	    s.bi_buf = 0;
	    s.bi_valid = 0;

	  } else if (s.bi_valid >= 8) {
	    s.pending_buf[s.pending++] = s.bi_buf & 0xff;
	    s.bi_buf >>= 8;
	    s.bi_valid -= 8;
	  }
	}


	/* ===========================================================================
	 * Compute the optimal bit lengths for a tree and update the total bit length
	 * for the current block.
	 * IN assertion: the fields freq and dad are set, heap[heap_max] and
	 *    above are the tree nodes sorted by increasing frequency.
	 * OUT assertions: the field len is set to the optimal bit length, the
	 *     array bl_count contains the frequencies for each bit length.
	 *     The length opt_len is updated; static_len is also updated if stree is
	 *     not null.
	 */
	function gen_bitlen(s, desc)
	//    deflate_state *s;
	//    tree_desc *desc;    /* the tree descriptor */
	{
	  var tree            = desc.dyn_tree;
	  var max_code        = desc.max_code;
	  var stree           = desc.stat_desc.static_tree;
	  var has_stree       = desc.stat_desc.has_stree;
	  var extra           = desc.stat_desc.extra_bits;
	  var base            = desc.stat_desc.extra_base;
	  var max_length      = desc.stat_desc.max_length;
	  var h;              /* heap index */
	  var n, m;           /* iterate over the tree elements */
	  var bits;           /* bit length */
	  var xbits;          /* extra bits */
	  var f;              /* frequency */
	  var overflow = 0;   /* number of elements with bit length too large */

	  for (bits = 0; bits <= MAX_BITS; bits++) {
	    s.bl_count[bits] = 0;
	  }

	  /* In a first pass, compute the optimal bit lengths (which may
	   * overflow in the case of the bit length tree).
	   */
	  tree[s.heap[s.heap_max] * 2 + 1]/*.Len*/ = 0; /* root of the heap */

	  for (h = s.heap_max + 1; h < HEAP_SIZE; h++) {
	    n = s.heap[h];
	    bits = tree[tree[n * 2 + 1]/*.Dad*/ * 2 + 1]/*.Len*/ + 1;
	    if (bits > max_length) {
	      bits = max_length;
	      overflow++;
	    }
	    tree[n * 2 + 1]/*.Len*/ = bits;
	    /* We overwrite tree[n].Dad which is no longer needed */

	    if (n > max_code) { continue; } /* not a leaf node */

	    s.bl_count[bits]++;
	    xbits = 0;
	    if (n >= base) {
	      xbits = extra[n - base];
	    }
	    f = tree[n * 2]/*.Freq*/;
	    s.opt_len += f * (bits + xbits);
	    if (has_stree) {
	      s.static_len += f * (stree[n * 2 + 1]/*.Len*/ + xbits);
	    }
	  }
	  if (overflow === 0) { return; }

	  // Trace((stderr,"\nbit length overflow\n"));
	  /* This happens for example on obj2 and pic of the Calgary corpus */

	  /* Find the first bit length which could increase: */
	  do {
	    bits = max_length - 1;
	    while (s.bl_count[bits] === 0) { bits--; }
	    s.bl_count[bits]--;      /* move one leaf down the tree */
	    s.bl_count[bits + 1] += 2; /* move one overflow item as its brother */
	    s.bl_count[max_length]--;
	    /* The brother of the overflow item also moves one step up,
	     * but this does not affect bl_count[max_length]
	     */
	    overflow -= 2;
	  } while (overflow > 0);

	  /* Now recompute all bit lengths, scanning in increasing frequency.
	   * h is still equal to HEAP_SIZE. (It is simpler to reconstruct all
	   * lengths instead of fixing only the wrong ones. This idea is taken
	   * from 'ar' written by Haruhiko Okumura.)
	   */
	  for (bits = max_length; bits !== 0; bits--) {
	    n = s.bl_count[bits];
	    while (n !== 0) {
	      m = s.heap[--h];
	      if (m > max_code) { continue; }
	      if (tree[m * 2 + 1]/*.Len*/ !== bits) {
	        // Trace((stderr,"code %d bits %d->%d\n", m, tree[m].Len, bits));
	        s.opt_len += (bits - tree[m * 2 + 1]/*.Len*/) * tree[m * 2]/*.Freq*/;
	        tree[m * 2 + 1]/*.Len*/ = bits;
	      }
	      n--;
	    }
	  }
	}


	/* ===========================================================================
	 * Generate the codes for a given tree and bit counts (which need not be
	 * optimal).
	 * IN assertion: the array bl_count contains the bit length statistics for
	 * the given tree and the field len is set for all tree elements.
	 * OUT assertion: the field code is set for all tree elements of non
	 *     zero code length.
	 */
	function gen_codes(tree, max_code, bl_count)
	//    ct_data *tree;             /* the tree to decorate */
	//    int max_code;              /* largest code with non zero frequency */
	//    ushf *bl_count;            /* number of codes at each bit length */
	{
	  var next_code = new Array(MAX_BITS + 1); /* next code value for each bit length */
	  var code = 0;              /* running code value */
	  var bits;                  /* bit index */
	  var n;                     /* code index */

	  /* The distribution counts are first used to generate the code values
	   * without bit reversal.
	   */
	  for (bits = 1; bits <= MAX_BITS; bits++) {
	    next_code[bits] = code = (code + bl_count[bits - 1]) << 1;
	  }
	  /* Check that the bit counts in bl_count are consistent. The last code
	   * must be all ones.
	   */
	  //Assert (code + bl_count[MAX_BITS]-1 == (1<<MAX_BITS)-1,
	  //        "inconsistent bit counts");
	  //Tracev((stderr,"\ngen_codes: max_code %d ", max_code));

	  for (n = 0;  n <= max_code; n++) {
	    var len = tree[n * 2 + 1]/*.Len*/;
	    if (len === 0) { continue; }
	    /* Now reverse the bits */
	    tree[n * 2]/*.Code*/ = bi_reverse(next_code[len]++, len);

	    //Tracecv(tree != static_ltree, (stderr,"\nn %3d %c l %2d c %4x (%x) ",
	    //     n, (isgraph(n) ? n : ' '), len, tree[n].Code, next_code[len]-1));
	  }
	}


	/* ===========================================================================
	 * Initialize the various 'constant' tables.
	 */
	function tr_static_init() {
	  var n;        /* iterates over tree elements */
	  var bits;     /* bit counter */
	  var length;   /* length value */
	  var code;     /* code value */
	  var dist;     /* distance index */
	  var bl_count = new Array(MAX_BITS + 1);
	  /* number of codes at each bit length for an optimal tree */

	  // do check in _tr_init()
	  //if (static_init_done) return;

	  /* For some embedded targets, global variables are not initialized: */
	/*#ifdef NO_INIT_GLOBAL_POINTERS
	  static_l_desc.static_tree = static_ltree;
	  static_l_desc.extra_bits = extra_lbits;
	  static_d_desc.static_tree = static_dtree;
	  static_d_desc.extra_bits = extra_dbits;
	  static_bl_desc.extra_bits = extra_blbits;
	#endif*/

	  /* Initialize the mapping length (0..255) -> length code (0..28) */
	  length = 0;
	  for (code = 0; code < LENGTH_CODES - 1; code++) {
	    base_length[code] = length;
	    for (n = 0; n < (1 << extra_lbits[code]); n++) {
	      _length_code[length++] = code;
	    }
	  }
	  //Assert (length == 256, "tr_static_init: length != 256");
	  /* Note that the length 255 (match length 258) can be represented
	   * in two different ways: code 284 + 5 bits or code 285, so we
	   * overwrite length_code[255] to use the best encoding:
	   */
	  _length_code[length - 1] = code;

	  /* Initialize the mapping dist (0..32K) -> dist code (0..29) */
	  dist = 0;
	  for (code = 0; code < 16; code++) {
	    base_dist[code] = dist;
	    for (n = 0; n < (1 << extra_dbits[code]); n++) {
	      _dist_code[dist++] = code;
	    }
	  }
	  //Assert (dist == 256, "tr_static_init: dist != 256");
	  dist >>= 7; /* from now on, all distances are divided by 128 */
	  for (; code < D_CODES; code++) {
	    base_dist[code] = dist << 7;
	    for (n = 0; n < (1 << (extra_dbits[code] - 7)); n++) {
	      _dist_code[256 + dist++] = code;
	    }
	  }
	  //Assert (dist == 256, "tr_static_init: 256+dist != 512");

	  /* Construct the codes of the static literal tree */
	  for (bits = 0; bits <= MAX_BITS; bits++) {
	    bl_count[bits] = 0;
	  }

	  n = 0;
	  while (n <= 143) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 8;
	    n++;
	    bl_count[8]++;
	  }
	  while (n <= 255) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 9;
	    n++;
	    bl_count[9]++;
	  }
	  while (n <= 279) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 7;
	    n++;
	    bl_count[7]++;
	  }
	  while (n <= 287) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 8;
	    n++;
	    bl_count[8]++;
	  }
	  /* Codes 286 and 287 do not exist, but we must include them in the
	   * tree construction to get a canonical Huffman tree (longest code
	   * all ones)
	   */
	  gen_codes(static_ltree, L_CODES + 1, bl_count);

	  /* The static distance tree is trivial: */
	  for (n = 0; n < D_CODES; n++) {
	    static_dtree[n * 2 + 1]/*.Len*/ = 5;
	    static_dtree[n * 2]/*.Code*/ = bi_reverse(n, 5);
	  }

	  // Now data ready and we can init static trees
	  static_l_desc = new StaticTreeDesc(static_ltree, extra_lbits, LITERALS + 1, L_CODES, MAX_BITS);
	  static_d_desc = new StaticTreeDesc(static_dtree, extra_dbits, 0,          D_CODES, MAX_BITS);
	  static_bl_desc = new StaticTreeDesc(new Array(0), extra_blbits, 0,         BL_CODES, MAX_BL_BITS);

	  //static_init_done = true;
	}


	/* ===========================================================================
	 * Initialize a new block.
	 */
	function init_block(s) {
	  var n; /* iterates over tree elements */

	  /* Initialize the trees. */
	  for (n = 0; n < L_CODES;  n++) { s.dyn_ltree[n * 2]/*.Freq*/ = 0; }
	  for (n = 0; n < D_CODES;  n++) { s.dyn_dtree[n * 2]/*.Freq*/ = 0; }
	  for (n = 0; n < BL_CODES; n++) { s.bl_tree[n * 2]/*.Freq*/ = 0; }

	  s.dyn_ltree[END_BLOCK * 2]/*.Freq*/ = 1;
	  s.opt_len = s.static_len = 0;
	  s.last_lit = s.matches = 0;
	}


	/* ===========================================================================
	 * Flush the bit buffer and align the output on a byte boundary
	 */
	function bi_windup(s)
	{
	  if (s.bi_valid > 8) {
	    put_short(s, s.bi_buf);
	  } else if (s.bi_valid > 0) {
	    //put_byte(s, (Byte)s->bi_buf);
	    s.pending_buf[s.pending++] = s.bi_buf;
	  }
	  s.bi_buf = 0;
	  s.bi_valid = 0;
	}

	/* ===========================================================================
	 * Copy a stored block, storing first the length and its
	 * one's complement if requested.
	 */
	function copy_block(s, buf, len, header)
	//DeflateState *s;
	//charf    *buf;    /* the input data */
	//unsigned len;     /* its length */
	//int      header;  /* true if block header must be written */
	{
	  bi_windup(s);        /* align on byte boundary */

	  if (header) {
	    put_short(s, len);
	    put_short(s, ~len);
	  }
	//  while (len--) {
	//    put_byte(s, *buf++);
	//  }
	  utils.arraySet(s.pending_buf, s.window, buf, len, s.pending);
	  s.pending += len;
	}

	/* ===========================================================================
	 * Compares to subtrees, using the tree depth as tie breaker when
	 * the subtrees have equal frequency. This minimizes the worst case length.
	 */
	function smaller(tree, n, m, depth) {
	  var _n2 = n * 2;
	  var _m2 = m * 2;
	  return (tree[_n2]/*.Freq*/ < tree[_m2]/*.Freq*/ ||
	         (tree[_n2]/*.Freq*/ === tree[_m2]/*.Freq*/ && depth[n] <= depth[m]));
	}

	/* ===========================================================================
	 * Restore the heap property by moving down the tree starting at node k,
	 * exchanging a node with the smallest of its two sons if necessary, stopping
	 * when the heap property is re-established (each father smaller than its
	 * two sons).
	 */
	function pqdownheap(s, tree, k)
	//    deflate_state *s;
	//    ct_data *tree;  /* the tree to restore */
	//    int k;               /* node to move down */
	{
	  var v = s.heap[k];
	  var j = k << 1;  /* left son of k */
	  while (j <= s.heap_len) {
	    /* Set j to the smallest of the two sons: */
	    if (j < s.heap_len &&
	      smaller(tree, s.heap[j + 1], s.heap[j], s.depth)) {
	      j++;
	    }
	    /* Exit if v is smaller than both sons */
	    if (smaller(tree, v, s.heap[j], s.depth)) { break; }

	    /* Exchange v with the smallest son */
	    s.heap[k] = s.heap[j];
	    k = j;

	    /* And continue down the tree, setting j to the left son of k */
	    j <<= 1;
	  }
	  s.heap[k] = v;
	}


	// inlined manually
	// var SMALLEST = 1;

	/* ===========================================================================
	 * Send the block data compressed using the given Huffman trees
	 */
	function compress_block(s, ltree, dtree)
	//    deflate_state *s;
	//    const ct_data *ltree; /* literal tree */
	//    const ct_data *dtree; /* distance tree */
	{
	  var dist;           /* distance of matched string */
	  var lc;             /* match length or unmatched char (if dist == 0) */
	  var lx = 0;         /* running index in l_buf */
	  var code;           /* the code to send */
	  var extra;          /* number of extra bits to send */

	  if (s.last_lit !== 0) {
	    do {
	      dist = (s.pending_buf[s.d_buf + lx * 2] << 8) | (s.pending_buf[s.d_buf + lx * 2 + 1]);
	      lc = s.pending_buf[s.l_buf + lx];
	      lx++;

	      if (dist === 0) {
	        send_code(s, lc, ltree); /* send a literal byte */
	        //Tracecv(isgraph(lc), (stderr," '%c' ", lc));
	      } else {
	        /* Here, lc is the match length - MIN_MATCH */
	        code = _length_code[lc];
	        send_code(s, code + LITERALS + 1, ltree); /* send the length code */
	        extra = extra_lbits[code];
	        if (extra !== 0) {
	          lc -= base_length[code];
	          send_bits(s, lc, extra);       /* send the extra length bits */
	        }
	        dist--; /* dist is now the match distance - 1 */
	        code = d_code(dist);
	        //Assert (code < D_CODES, "bad d_code");

	        send_code(s, code, dtree);       /* send the distance code */
	        extra = extra_dbits[code];
	        if (extra !== 0) {
	          dist -= base_dist[code];
	          send_bits(s, dist, extra);   /* send the extra distance bits */
	        }
	      } /* literal or match pair ? */

	      /* Check that the overlay between pending_buf and d_buf+l_buf is ok: */
	      //Assert((uInt)(s->pending) < s->lit_bufsize + 2*lx,
	      //       "pendingBuf overflow");

	    } while (lx < s.last_lit);
	  }

	  send_code(s, END_BLOCK, ltree);
	}


	/* ===========================================================================
	 * Construct one Huffman tree and assigns the code bit strings and lengths.
	 * Update the total bit length for the current block.
	 * IN assertion: the field freq is set for all tree elements.
	 * OUT assertions: the fields len and code are set to the optimal bit length
	 *     and corresponding code. The length opt_len is updated; static_len is
	 *     also updated if stree is not null. The field max_code is set.
	 */
	function build_tree(s, desc)
	//    deflate_state *s;
	//    tree_desc *desc; /* the tree descriptor */
	{
	  var tree     = desc.dyn_tree;
	  var stree    = desc.stat_desc.static_tree;
	  var has_stree = desc.stat_desc.has_stree;
	  var elems    = desc.stat_desc.elems;
	  var n, m;          /* iterate over heap elements */
	  var max_code = -1; /* largest code with non zero frequency */
	  var node;          /* new node being created */

	  /* Construct the initial heap, with least frequent element in
	   * heap[SMALLEST]. The sons of heap[n] are heap[2*n] and heap[2*n+1].
	   * heap[0] is not used.
	   */
	  s.heap_len = 0;
	  s.heap_max = HEAP_SIZE;

	  for (n = 0; n < elems; n++) {
	    if (tree[n * 2]/*.Freq*/ !== 0) {
	      s.heap[++s.heap_len] = max_code = n;
	      s.depth[n] = 0;

	    } else {
	      tree[n * 2 + 1]/*.Len*/ = 0;
	    }
	  }

	  /* The pkzip format requires that at least one distance code exists,
	   * and that at least one bit should be sent even if there is only one
	   * possible code. So to avoid special checks later on we force at least
	   * two codes of non zero frequency.
	   */
	  while (s.heap_len < 2) {
	    node = s.heap[++s.heap_len] = (max_code < 2 ? ++max_code : 0);
	    tree[node * 2]/*.Freq*/ = 1;
	    s.depth[node] = 0;
	    s.opt_len--;

	    if (has_stree) {
	      s.static_len -= stree[node * 2 + 1]/*.Len*/;
	    }
	    /* node is 0 or 1 so it does not have extra bits */
	  }
	  desc.max_code = max_code;

	  /* The elements heap[heap_len/2+1 .. heap_len] are leaves of the tree,
	   * establish sub-heaps of increasing lengths:
	   */
	  for (n = (s.heap_len >> 1/*int /2*/); n >= 1; n--) { pqdownheap(s, tree, n); }

	  /* Construct the Huffman tree by repeatedly combining the least two
	   * frequent nodes.
	   */
	  node = elems;              /* next internal node of the tree */
	  do {
	    //pqremove(s, tree, n);  /* n = node of least frequency */
	    /*** pqremove ***/
	    n = s.heap[1/*SMALLEST*/];
	    s.heap[1/*SMALLEST*/] = s.heap[s.heap_len--];
	    pqdownheap(s, tree, 1/*SMALLEST*/);
	    /***/

	    m = s.heap[1/*SMALLEST*/]; /* m = node of next least frequency */

	    s.heap[--s.heap_max] = n; /* keep the nodes sorted by frequency */
	    s.heap[--s.heap_max] = m;

	    /* Create a new node father of n and m */
	    tree[node * 2]/*.Freq*/ = tree[n * 2]/*.Freq*/ + tree[m * 2]/*.Freq*/;
	    s.depth[node] = (s.depth[n] >= s.depth[m] ? s.depth[n] : s.depth[m]) + 1;
	    tree[n * 2 + 1]/*.Dad*/ = tree[m * 2 + 1]/*.Dad*/ = node;

	    /* and insert the new node in the heap */
	    s.heap[1/*SMALLEST*/] = node++;
	    pqdownheap(s, tree, 1/*SMALLEST*/);

	  } while (s.heap_len >= 2);

	  s.heap[--s.heap_max] = s.heap[1/*SMALLEST*/];

	  /* At this point, the fields freq and dad are set. We can now
	   * generate the bit lengths.
	   */
	  gen_bitlen(s, desc);

	  /* The field len is now set, we can generate the bit codes */
	  gen_codes(tree, max_code, s.bl_count);
	}


	/* ===========================================================================
	 * Scan a literal or distance tree to determine the frequencies of the codes
	 * in the bit length tree.
	 */
	function scan_tree(s, tree, max_code)
	//    deflate_state *s;
	//    ct_data *tree;   /* the tree to be scanned */
	//    int max_code;    /* and its largest code of non zero frequency */
	{
	  var n;                     /* iterates over all tree elements */
	  var prevlen = -1;          /* last emitted length */
	  var curlen;                /* length of current code */

	  var nextlen = tree[0 * 2 + 1]/*.Len*/; /* length of next code */

	  var count = 0;             /* repeat count of the current code */
	  var max_count = 7;         /* max repeat count */
	  var min_count = 4;         /* min repeat count */

	  if (nextlen === 0) {
	    max_count = 138;
	    min_count = 3;
	  }
	  tree[(max_code + 1) * 2 + 1]/*.Len*/ = 0xffff; /* guard */

	  for (n = 0; n <= max_code; n++) {
	    curlen = nextlen;
	    nextlen = tree[(n + 1) * 2 + 1]/*.Len*/;

	    if (++count < max_count && curlen === nextlen) {
	      continue;

	    } else if (count < min_count) {
	      s.bl_tree[curlen * 2]/*.Freq*/ += count;

	    } else if (curlen !== 0) {

	      if (curlen !== prevlen) { s.bl_tree[curlen * 2]/*.Freq*/++; }
	      s.bl_tree[REP_3_6 * 2]/*.Freq*/++;

	    } else if (count <= 10) {
	      s.bl_tree[REPZ_3_10 * 2]/*.Freq*/++;

	    } else {
	      s.bl_tree[REPZ_11_138 * 2]/*.Freq*/++;
	    }

	    count = 0;
	    prevlen = curlen;

	    if (nextlen === 0) {
	      max_count = 138;
	      min_count = 3;

	    } else if (curlen === nextlen) {
	      max_count = 6;
	      min_count = 3;

	    } else {
	      max_count = 7;
	      min_count = 4;
	    }
	  }
	}


	/* ===========================================================================
	 * Send a literal or distance tree in compressed form, using the codes in
	 * bl_tree.
	 */
	function send_tree(s, tree, max_code)
	//    deflate_state *s;
	//    ct_data *tree; /* the tree to be scanned */
	//    int max_code;       /* and its largest code of non zero frequency */
	{
	  var n;                     /* iterates over all tree elements */
	  var prevlen = -1;          /* last emitted length */
	  var curlen;                /* length of current code */

	  var nextlen = tree[0 * 2 + 1]/*.Len*/; /* length of next code */

	  var count = 0;             /* repeat count of the current code */
	  var max_count = 7;         /* max repeat count */
	  var min_count = 4;         /* min repeat count */

	  /* tree[max_code+1].Len = -1; */  /* guard already set */
	  if (nextlen === 0) {
	    max_count = 138;
	    min_count = 3;
	  }

	  for (n = 0; n <= max_code; n++) {
	    curlen = nextlen;
	    nextlen = tree[(n + 1) * 2 + 1]/*.Len*/;

	    if (++count < max_count && curlen === nextlen) {
	      continue;

	    } else if (count < min_count) {
	      do { send_code(s, curlen, s.bl_tree); } while (--count !== 0);

	    } else if (curlen !== 0) {
	      if (curlen !== prevlen) {
	        send_code(s, curlen, s.bl_tree);
	        count--;
	      }
	      //Assert(count >= 3 && count <= 6, " 3_6?");
	      send_code(s, REP_3_6, s.bl_tree);
	      send_bits(s, count - 3, 2);

	    } else if (count <= 10) {
	      send_code(s, REPZ_3_10, s.bl_tree);
	      send_bits(s, count - 3, 3);

	    } else {
	      send_code(s, REPZ_11_138, s.bl_tree);
	      send_bits(s, count - 11, 7);
	    }

	    count = 0;
	    prevlen = curlen;
	    if (nextlen === 0) {
	      max_count = 138;
	      min_count = 3;

	    } else if (curlen === nextlen) {
	      max_count = 6;
	      min_count = 3;

	    } else {
	      max_count = 7;
	      min_count = 4;
	    }
	  }
	}


	/* ===========================================================================
	 * Construct the Huffman tree for the bit lengths and return the index in
	 * bl_order of the last bit length code to send.
	 */
	function build_bl_tree(s) {
	  var max_blindex;  /* index of last bit length code of non zero freq */

	  /* Determine the bit length frequencies for literal and distance trees */
	  scan_tree(s, s.dyn_ltree, s.l_desc.max_code);
	  scan_tree(s, s.dyn_dtree, s.d_desc.max_code);

	  /* Build the bit length tree: */
	  build_tree(s, s.bl_desc);
	  /* opt_len now includes the length of the tree representations, except
	   * the lengths of the bit lengths codes and the 5+5+4 bits for the counts.
	   */

	  /* Determine the number of bit length codes to send. The pkzip format
	   * requires that at least 4 bit length codes be sent. (appnote.txt says
	   * 3 but the actual value used is 4.)
	   */
	  for (max_blindex = BL_CODES - 1; max_blindex >= 3; max_blindex--) {
	    if (s.bl_tree[bl_order[max_blindex] * 2 + 1]/*.Len*/ !== 0) {
	      break;
	    }
	  }
	  /* Update opt_len to include the bit length tree and counts */
	  s.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4;
	  //Tracev((stderr, "\ndyn trees: dyn %ld, stat %ld",
	  //        s->opt_len, s->static_len));

	  return max_blindex;
	}


	/* ===========================================================================
	 * Send the header for a block using dynamic Huffman trees: the counts, the
	 * lengths of the bit length codes, the literal tree and the distance tree.
	 * IN assertion: lcodes >= 257, dcodes >= 1, blcodes >= 4.
	 */
	function send_all_trees(s, lcodes, dcodes, blcodes)
	//    deflate_state *s;
	//    int lcodes, dcodes, blcodes; /* number of codes for each tree */
	{
	  var rank;                    /* index in bl_order */

	  //Assert (lcodes >= 257 && dcodes >= 1 && blcodes >= 4, "not enough codes");
	  //Assert (lcodes <= L_CODES && dcodes <= D_CODES && blcodes <= BL_CODES,
	  //        "too many codes");
	  //Tracev((stderr, "\nbl counts: "));
	  send_bits(s, lcodes - 257, 5); /* not +255 as stated in appnote.txt */
	  send_bits(s, dcodes - 1,   5);
	  send_bits(s, blcodes - 4,  4); /* not -3 as stated in appnote.txt */
	  for (rank = 0; rank < blcodes; rank++) {
	    //Tracev((stderr, "\nbl code %2d ", bl_order[rank]));
	    send_bits(s, s.bl_tree[bl_order[rank] * 2 + 1]/*.Len*/, 3);
	  }
	  //Tracev((stderr, "\nbl tree: sent %ld", s->bits_sent));

	  send_tree(s, s.dyn_ltree, lcodes - 1); /* literal tree */
	  //Tracev((stderr, "\nlit tree: sent %ld", s->bits_sent));

	  send_tree(s, s.dyn_dtree, dcodes - 1); /* distance tree */
	  //Tracev((stderr, "\ndist tree: sent %ld", s->bits_sent));
	}


	/* ===========================================================================
	 * Check if the data type is TEXT or BINARY, using the following algorithm:
	 * - TEXT if the two conditions below are satisfied:
	 *    a) There are no non-portable control characters belonging to the
	 *       "black list" (0..6, 14..25, 28..31).
	 *    b) There is at least one printable character belonging to the
	 *       "white list" (9 {TAB}, 10 {LF}, 13 {CR}, 32..255).
	 * - BINARY otherwise.
	 * - The following partially-portable control characters form a
	 *   "gray list" that is ignored in this detection algorithm:
	 *   (7 {BEL}, 8 {BS}, 11 {VT}, 12 {FF}, 26 {SUB}, 27 {ESC}).
	 * IN assertion: the fields Freq of dyn_ltree are set.
	 */
	function detect_data_type(s) {
	  /* black_mask is the bit mask of black-listed bytes
	   * set bits 0..6, 14..25, and 28..31
	   * 0xf3ffc07f = binary 11110011111111111100000001111111
	   */
	  var black_mask = 0xf3ffc07f;
	  var n;

	  /* Check for non-textual ("black-listed") bytes. */
	  for (n = 0; n <= 31; n++, black_mask >>>= 1) {
	    if ((black_mask & 1) && (s.dyn_ltree[n * 2]/*.Freq*/ !== 0)) {
	      return Z_BINARY;
	    }
	  }

	  /* Check for textual ("white-listed") bytes. */
	  if (s.dyn_ltree[9 * 2]/*.Freq*/ !== 0 || s.dyn_ltree[10 * 2]/*.Freq*/ !== 0 ||
	      s.dyn_ltree[13 * 2]/*.Freq*/ !== 0) {
	    return Z_TEXT;
	  }
	  for (n = 32; n < LITERALS; n++) {
	    if (s.dyn_ltree[n * 2]/*.Freq*/ !== 0) {
	      return Z_TEXT;
	    }
	  }

	  /* There are no "black-listed" or "white-listed" bytes:
	   * this stream either is empty or has tolerated ("gray-listed") bytes only.
	   */
	  return Z_BINARY;
	}


	var static_init_done = false;

	/* ===========================================================================
	 * Initialize the tree data structures for a new zlib stream.
	 */
	function _tr_init(s)
	{

	  if (!static_init_done) {
	    tr_static_init();
	    static_init_done = true;
	  }

	  s.l_desc  = new TreeDesc(s.dyn_ltree, static_l_desc);
	  s.d_desc  = new TreeDesc(s.dyn_dtree, static_d_desc);
	  s.bl_desc = new TreeDesc(s.bl_tree, static_bl_desc);

	  s.bi_buf = 0;
	  s.bi_valid = 0;

	  /* Initialize the first block of the first file: */
	  init_block(s);
	}


	/* ===========================================================================
	 * Send a stored block
	 */
	function _tr_stored_block(s, buf, stored_len, last)
	//DeflateState *s;
	//charf *buf;       /* input block */
	//ulg stored_len;   /* length of input block */
	//int last;         /* one if this is the last block for a file */
	{
	  send_bits(s, (STORED_BLOCK << 1) + (last ? 1 : 0), 3);    /* send block type */
	  copy_block(s, buf, stored_len, true); /* with header */
	}


	/* ===========================================================================
	 * Send one empty static block to give enough lookahead for inflate.
	 * This takes 10 bits, of which 7 may remain in the bit buffer.
	 */
	function _tr_align(s) {
	  send_bits(s, STATIC_TREES << 1, 3);
	  send_code(s, END_BLOCK, static_ltree);
	  bi_flush(s);
	}


	/* ===========================================================================
	 * Determine the best encoding for the current block: dynamic trees, static
	 * trees or store, and output the encoded block to the zip file.
	 */
	function _tr_flush_block(s, buf, stored_len, last)
	//DeflateState *s;
	//charf *buf;       /* input block, or NULL if too old */
	//ulg stored_len;   /* length of input block */
	//int last;         /* one if this is the last block for a file */
	{
	  var opt_lenb, static_lenb;  /* opt_len and static_len in bytes */
	  var max_blindex = 0;        /* index of last bit length code of non zero freq */

	  /* Build the Huffman trees unless a stored block is forced */
	  if (s.level > 0) {

	    /* Check if the file is binary or text */
	    if (s.strm.data_type === Z_UNKNOWN) {
	      s.strm.data_type = detect_data_type(s);
	    }

	    /* Construct the literal and distance trees */
	    build_tree(s, s.l_desc);
	    // Tracev((stderr, "\nlit data: dyn %ld, stat %ld", s->opt_len,
	    //        s->static_len));

	    build_tree(s, s.d_desc);
	    // Tracev((stderr, "\ndist data: dyn %ld, stat %ld", s->opt_len,
	    //        s->static_len));
	    /* At this point, opt_len and static_len are the total bit lengths of
	     * the compressed block data, excluding the tree representations.
	     */

	    /* Build the bit length tree for the above two trees, and get the index
	     * in bl_order of the last bit length code to send.
	     */
	    max_blindex = build_bl_tree(s);

	    /* Determine the best encoding. Compute the block lengths in bytes. */
	    opt_lenb = (s.opt_len + 3 + 7) >>> 3;
	    static_lenb = (s.static_len + 3 + 7) >>> 3;

	    // Tracev((stderr, "\nopt %lu(%lu) stat %lu(%lu) stored %lu lit %u ",
	    //        opt_lenb, s->opt_len, static_lenb, s->static_len, stored_len,
	    //        s->last_lit));

	    if (static_lenb <= opt_lenb) { opt_lenb = static_lenb; }

	  } else {
	    // Assert(buf != (char*)0, "lost buf");
	    opt_lenb = static_lenb = stored_len + 5; /* force a stored block */
	  }

	  if ((stored_len + 4 <= opt_lenb) && (buf !== -1)) {
	    /* 4: two words for the lengths */

	    /* The test buf != NULL is only necessary if LIT_BUFSIZE > WSIZE.
	     * Otherwise we can't have processed more than WSIZE input bytes since
	     * the last block flush, because compression would have been
	     * successful. If LIT_BUFSIZE <= WSIZE, it is never too late to
	     * transform a block into a stored block.
	     */
	    _tr_stored_block(s, buf, stored_len, last);

	  } else if (s.strategy === Z_FIXED || static_lenb === opt_lenb) {

	    send_bits(s, (STATIC_TREES << 1) + (last ? 1 : 0), 3);
	    compress_block(s, static_ltree, static_dtree);

	  } else {
	    send_bits(s, (DYN_TREES << 1) + (last ? 1 : 0), 3);
	    send_all_trees(s, s.l_desc.max_code + 1, s.d_desc.max_code + 1, max_blindex + 1);
	    compress_block(s, s.dyn_ltree, s.dyn_dtree);
	  }
	  // Assert (s->compressed_len == s->bits_sent, "bad compressed size");
	  /* The above check is made mod 2^32, for files larger than 512 MB
	   * and uLong implemented on 32 bits.
	   */
	  init_block(s);

	  if (last) {
	    bi_windup(s);
	  }
	  // Tracev((stderr,"\ncomprlen %lu(%lu) ", s->compressed_len>>3,
	  //       s->compressed_len-7*last));
	}

	/* ===========================================================================
	 * Save the match info and tally the frequency counts. Return true if
	 * the current block must be flushed.
	 */
	function _tr_tally(s, dist, lc)
	//    deflate_state *s;
	//    unsigned dist;  /* distance of matched string */
	//    unsigned lc;    /* match length-MIN_MATCH or unmatched char (if dist==0) */
	{
	  //var out_length, in_length, dcode;

	  s.pending_buf[s.d_buf + s.last_lit * 2]     = (dist >>> 8) & 0xff;
	  s.pending_buf[s.d_buf + s.last_lit * 2 + 1] = dist & 0xff;

	  s.pending_buf[s.l_buf + s.last_lit] = lc & 0xff;
	  s.last_lit++;

	  if (dist === 0) {
	    /* lc is the unmatched char */
	    s.dyn_ltree[lc * 2]/*.Freq*/++;
	  } else {
	    s.matches++;
	    /* Here, lc is the match length - MIN_MATCH */
	    dist--;             /* dist = match distance - 1 */
	    //Assert((ush)dist < (ush)MAX_DIST(s) &&
	    //       (ush)lc <= (ush)(MAX_MATCH-MIN_MATCH) &&
	    //       (ush)d_code(dist) < (ush)D_CODES,  "_tr_tally: bad match");

	    s.dyn_ltree[(_length_code[lc] + LITERALS + 1) * 2]/*.Freq*/++;
	    s.dyn_dtree[d_code(dist) * 2]/*.Freq*/++;
	  }

	// (!) This block is disabled in zlib defailts,
	// don't enable it for binary compatibility

	//#ifdef TRUNCATE_BLOCK
	//  /* Try to guess if it is profitable to stop the current block here */
	//  if ((s.last_lit & 0x1fff) === 0 && s.level > 2) {
	//    /* Compute an upper bound for the compressed length */
	//    out_length = s.last_lit*8;
	//    in_length = s.strstart - s.block_start;
	//
	//    for (dcode = 0; dcode < D_CODES; dcode++) {
	//      out_length += s.dyn_dtree[dcode*2]/*.Freq*/ * (5 + extra_dbits[dcode]);
	//    }
	//    out_length >>>= 3;
	//    //Tracev((stderr,"\nlast_lit %u, in %ld, out ~%ld(%ld%%) ",
	//    //       s->last_lit, in_length, out_length,
	//    //       100L - out_length*100L/in_length));
	//    if (s.matches < (s.last_lit>>1)/*int /2*/ && out_length < (in_length>>1)/*int /2*/) {
	//      return true;
	//    }
	//  }
	//#endif

	  return (s.last_lit === s.lit_bufsize - 1);
	  /* We avoid equality with lit_bufsize because of wraparound at 64K
	   * on 16 bit machines and because stored blocks are restricted to
	   * 64K-1 bytes.
	   */
	}

	exports._tr_init  = _tr_init;
	exports._tr_stored_block = _tr_stored_block;
	exports._tr_flush_block  = _tr_flush_block;
	exports._tr_tally = _tr_tally;
	exports._tr_align = _tr_align;


/***/ }),
/* 64 */
/***/ (function(module, exports) {

	'use strict';

	// Note: adler32 takes 12% for level 0 and 2% for level 6.
	// It doesn't worth to make additional optimizationa as in original.
	// Small size is preferable.

	function adler32(adler, buf, len, pos) {
	  var s1 = (adler & 0xffff) |0,
	      s2 = ((adler >>> 16) & 0xffff) |0,
	      n = 0;

	  while (len !== 0) {
	    // Set limit ~ twice less than 5552, to keep
	    // s2 in 31-bits, because we force signed ints.
	    // in other case %= will fail.
	    n = len > 2000 ? 2000 : len;
	    len -= n;

	    do {
	      s1 = (s1 + buf[pos++]) |0;
	      s2 = (s2 + s1) |0;
	    } while (--n);

	    s1 %= 65521;
	    s2 %= 65521;
	  }

	  return (s1 | (s2 << 16)) |0;
	}


	module.exports = adler32;


/***/ }),
/* 65 */
/***/ (function(module, exports) {

	'use strict';

	// Note: we can't get significant speed boost here.
	// So write code to minimize size - no pregenerated tables
	// and array tools dependencies.


	// Use ordinary array, since untyped makes no boost here
	function makeTable() {
	  var c, table = [];

	  for (var n = 0; n < 256; n++) {
	    c = n;
	    for (var k = 0; k < 8; k++) {
	      c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
	    }
	    table[n] = c;
	  }

	  return table;
	}

	// Create table on load. Just 255 signed longs. Not a problem.
	var crcTable = makeTable();


	function crc32(crc, buf, len, pos) {
	  var t = crcTable,
	      end = pos + len;

	  crc ^= -1;

	  for (var i = pos; i < end; i++) {
	    crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
	  }

	  return (crc ^ (-1)); // >>> 0;
	}


	module.exports = crc32;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';


	var utils         = __webpack_require__(62);
	var adler32       = __webpack_require__(64);
	var crc32         = __webpack_require__(65);
	var inflate_fast  = __webpack_require__(67);
	var inflate_table = __webpack_require__(68);

	var CODES = 0;
	var LENS = 1;
	var DISTS = 2;

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	/* Allowed flush values; see deflate() and inflate() below for details */
	//var Z_NO_FLUSH      = 0;
	//var Z_PARTIAL_FLUSH = 1;
	//var Z_SYNC_FLUSH    = 2;
	//var Z_FULL_FLUSH    = 3;
	var Z_FINISH        = 4;
	var Z_BLOCK         = 5;
	var Z_TREES         = 6;


	/* Return codes for the compression/decompression functions. Negative values
	 * are errors, positive values are used for special but normal events.
	 */
	var Z_OK            = 0;
	var Z_STREAM_END    = 1;
	var Z_NEED_DICT     = 2;
	//var Z_ERRNO         = -1;
	var Z_STREAM_ERROR  = -2;
	var Z_DATA_ERROR    = -3;
	var Z_MEM_ERROR     = -4;
	var Z_BUF_ERROR     = -5;
	//var Z_VERSION_ERROR = -6;

	/* The deflate compression method */
	var Z_DEFLATED  = 8;


	/* STATES ====================================================================*/
	/* ===========================================================================*/


	var    HEAD = 1;       /* i: waiting for magic header */
	var    FLAGS = 2;      /* i: waiting for method and flags (gzip) */
	var    TIME = 3;       /* i: waiting for modification time (gzip) */
	var    OS = 4;         /* i: waiting for extra flags and operating system (gzip) */
	var    EXLEN = 5;      /* i: waiting for extra length (gzip) */
	var    EXTRA = 6;      /* i: waiting for extra bytes (gzip) */
	var    NAME = 7;       /* i: waiting for end of file name (gzip) */
	var    COMMENT = 8;    /* i: waiting for end of comment (gzip) */
	var    HCRC = 9;       /* i: waiting for header crc (gzip) */
	var    DICTID = 10;    /* i: waiting for dictionary check value */
	var    DICT = 11;      /* waiting for inflateSetDictionary() call */
	var        TYPE = 12;      /* i: waiting for type bits, including last-flag bit */
	var        TYPEDO = 13;    /* i: same, but skip check to exit inflate on new block */
	var        STORED = 14;    /* i: waiting for stored size (length and complement) */
	var        COPY_ = 15;     /* i/o: same as COPY below, but only first time in */
	var        COPY = 16;      /* i/o: waiting for input or output to copy stored block */
	var        TABLE = 17;     /* i: waiting for dynamic block table lengths */
	var        LENLENS = 18;   /* i: waiting for code length code lengths */
	var        CODELENS = 19;  /* i: waiting for length/lit and distance code lengths */
	var            LEN_ = 20;      /* i: same as LEN below, but only first time in */
	var            LEN = 21;       /* i: waiting for length/lit/eob code */
	var            LENEXT = 22;    /* i: waiting for length extra bits */
	var            DIST = 23;      /* i: waiting for distance code */
	var            DISTEXT = 24;   /* i: waiting for distance extra bits */
	var            MATCH = 25;     /* o: waiting for output space to copy string */
	var            LIT = 26;       /* o: waiting for output space to write literal */
	var    CHECK = 27;     /* i: waiting for 32-bit check value */
	var    LENGTH = 28;    /* i: waiting for 32-bit length (gzip) */
	var    DONE = 29;      /* finished check, done -- remain here until reset */
	var    BAD = 30;       /* got a data error -- remain here until reset */
	var    MEM = 31;       /* got an inflate() memory error -- remain here until reset */
	var    SYNC = 32;      /* looking for synchronization bytes to restart inflate() */

	/* ===========================================================================*/



	var ENOUGH_LENS = 852;
	var ENOUGH_DISTS = 592;
	//var ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

	var MAX_WBITS = 15;
	/* 32K LZ77 window */
	var DEF_WBITS = MAX_WBITS;


	function zswap32(q) {
	  return  (((q >>> 24) & 0xff) +
	          ((q >>> 8) & 0xff00) +
	          ((q & 0xff00) << 8) +
	          ((q & 0xff) << 24));
	}


	function InflateState() {
	  this.mode = 0;             /* current inflate mode */
	  this.last = false;          /* true if processing last block */
	  this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip */
	  this.havedict = false;      /* true if dictionary provided */
	  this.flags = 0;             /* gzip header method and flags (0 if zlib) */
	  this.dmax = 0;              /* zlib header max distance (INFLATE_STRICT) */
	  this.check = 0;             /* protected copy of check value */
	  this.total = 0;             /* protected copy of output count */
	  // TODO: may be {}
	  this.head = null;           /* where to save gzip header information */

	  /* sliding window */
	  this.wbits = 0;             /* log base 2 of requested window size */
	  this.wsize = 0;             /* window size or zero if not using window */
	  this.whave = 0;             /* valid bytes in the window */
	  this.wnext = 0;             /* window write index */
	  this.window = null;         /* allocated sliding window, if needed */

	  /* bit accumulator */
	  this.hold = 0;              /* input bit accumulator */
	  this.bits = 0;              /* number of bits in "in" */

	  /* for string and stored block copying */
	  this.length = 0;            /* literal or length of data to copy */
	  this.offset = 0;            /* distance back to copy string from */

	  /* for table and code decoding */
	  this.extra = 0;             /* extra bits needed */

	  /* fixed and dynamic code tables */
	  this.lencode = null;          /* starting table for length/literal codes */
	  this.distcode = null;         /* starting table for distance codes */
	  this.lenbits = 0;           /* index bits for lencode */
	  this.distbits = 0;          /* index bits for distcode */

	  /* dynamic table building */
	  this.ncode = 0;             /* number of code length code lengths */
	  this.nlen = 0;              /* number of length code lengths */
	  this.ndist = 0;             /* number of distance code lengths */
	  this.have = 0;              /* number of code lengths in lens[] */
	  this.next = null;              /* next available space in codes[] */

	  this.lens = new utils.Buf16(320); /* temporary storage for code lengths */
	  this.work = new utils.Buf16(288); /* work area for code table building */

	  /*
	   because we don't have pointers in js, we use lencode and distcode directly
	   as buffers so we don't need codes
	  */
	  //this.codes = new utils.Buf32(ENOUGH);       /* space for code tables */
	  this.lendyn = null;              /* dynamic table for length/literal codes (JS specific) */
	  this.distdyn = null;             /* dynamic table for distance codes (JS specific) */
	  this.sane = 0;                   /* if false, allow invalid distance too far */
	  this.back = 0;                   /* bits back of last unprocessed length/lit */
	  this.was = 0;                    /* initial length of match */
	}

	function inflateResetKeep(strm) {
	  var state;

	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  strm.total_in = strm.total_out = state.total = 0;
	  strm.msg = ''; /*Z_NULL*/
	  if (state.wrap) {       /* to support ill-conceived Java test suite */
	    strm.adler = state.wrap & 1;
	  }
	  state.mode = HEAD;
	  state.last = 0;
	  state.havedict = 0;
	  state.dmax = 32768;
	  state.head = null/*Z_NULL*/;
	  state.hold = 0;
	  state.bits = 0;
	  //state.lencode = state.distcode = state.next = state.codes;
	  state.lencode = state.lendyn = new utils.Buf32(ENOUGH_LENS);
	  state.distcode = state.distdyn = new utils.Buf32(ENOUGH_DISTS);

	  state.sane = 1;
	  state.back = -1;
	  //Tracev((stderr, "inflate: reset\n"));
	  return Z_OK;
	}

	function inflateReset(strm) {
	  var state;

	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  state.wsize = 0;
	  state.whave = 0;
	  state.wnext = 0;
	  return inflateResetKeep(strm);

	}

	function inflateReset2(strm, windowBits) {
	  var wrap;
	  var state;

	  /* get the state */
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;

	  /* extract wrap request from windowBits parameter */
	  if (windowBits < 0) {
	    wrap = 0;
	    windowBits = -windowBits;
	  }
	  else {
	    wrap = (windowBits >> 4) + 1;
	    if (windowBits < 48) {
	      windowBits &= 15;
	    }
	  }

	  /* set number of window bits, free window if different */
	  if (windowBits && (windowBits < 8 || windowBits > 15)) {
	    return Z_STREAM_ERROR;
	  }
	  if (state.window !== null && state.wbits !== windowBits) {
	    state.window = null;
	  }

	  /* update state and reset the rest of it */
	  state.wrap = wrap;
	  state.wbits = windowBits;
	  return inflateReset(strm);
	}

	function inflateInit2(strm, windowBits) {
	  var ret;
	  var state;

	  if (!strm) { return Z_STREAM_ERROR; }
	  //strm.msg = Z_NULL;                 /* in case we return an error */

	  state = new InflateState();

	  //if (state === Z_NULL) return Z_MEM_ERROR;
	  //Tracev((stderr, "inflate: allocated\n"));
	  strm.state = state;
	  state.window = null/*Z_NULL*/;
	  ret = inflateReset2(strm, windowBits);
	  if (ret !== Z_OK) {
	    strm.state = null/*Z_NULL*/;
	  }
	  return ret;
	}

	function inflateInit(strm) {
	  return inflateInit2(strm, DEF_WBITS);
	}


	/*
	 Return state with length and distance decoding tables and index sizes set to
	 fixed code decoding.  Normally this returns fixed tables from inffixed.h.
	 If BUILDFIXED is defined, then instead this routine builds the tables the
	 first time it's called, and returns those tables the first time and
	 thereafter.  This reduces the size of the code by about 2K bytes, in
	 exchange for a little execution time.  However, BUILDFIXED should not be
	 used for threaded applications, since the rewriting of the tables and virgin
	 may not be thread-safe.
	 */
	var virgin = true;

	var lenfix, distfix; // We have no pointers in JS, so keep tables separate

	function fixedtables(state) {
	  /* build fixed huffman tables if first call (may not be thread safe) */
	  if (virgin) {
	    var sym;

	    lenfix = new utils.Buf32(512);
	    distfix = new utils.Buf32(32);

	    /* literal/length table */
	    sym = 0;
	    while (sym < 144) { state.lens[sym++] = 8; }
	    while (sym < 256) { state.lens[sym++] = 9; }
	    while (sym < 280) { state.lens[sym++] = 7; }
	    while (sym < 288) { state.lens[sym++] = 8; }

	    inflate_table(LENS,  state.lens, 0, 288, lenfix,   0, state.work, { bits: 9 });

	    /* distance table */
	    sym = 0;
	    while (sym < 32) { state.lens[sym++] = 5; }

	    inflate_table(DISTS, state.lens, 0, 32,   distfix, 0, state.work, { bits: 5 });

	    /* do this just once */
	    virgin = false;
	  }

	  state.lencode = lenfix;
	  state.lenbits = 9;
	  state.distcode = distfix;
	  state.distbits = 5;
	}


	/*
	 Update the window with the last wsize (normally 32K) bytes written before
	 returning.  If window does not exist yet, create it.  This is only called
	 when a window is already in use, or when output has been written during this
	 inflate call, but the end of the deflate stream has not been reached yet.
	 It is also called to create a window for dictionary data when a dictionary
	 is loaded.

	 Providing output buffers larger than 32K to inflate() should provide a speed
	 advantage, since only the last 32K of output is copied to the sliding window
	 upon return from inflate(), and since all distances after the first 32K of
	 output will fall in the output data, making match copies simpler and faster.
	 The advantage may be dependent on the size of the processor's data caches.
	 */
	function updatewindow(strm, src, end, copy) {
	  var dist;
	  var state = strm.state;

	  /* if it hasn't been done already, allocate space for the window */
	  if (state.window === null) {
	    state.wsize = 1 << state.wbits;
	    state.wnext = 0;
	    state.whave = 0;

	    state.window = new utils.Buf8(state.wsize);
	  }

	  /* copy state->wsize or less output bytes into the circular window */
	  if (copy >= state.wsize) {
	    utils.arraySet(state.window, src, end - state.wsize, state.wsize, 0);
	    state.wnext = 0;
	    state.whave = state.wsize;
	  }
	  else {
	    dist = state.wsize - state.wnext;
	    if (dist > copy) {
	      dist = copy;
	    }
	    //zmemcpy(state->window + state->wnext, end - copy, dist);
	    utils.arraySet(state.window, src, end - copy, dist, state.wnext);
	    copy -= dist;
	    if (copy) {
	      //zmemcpy(state->window, end - copy, copy);
	      utils.arraySet(state.window, src, end - copy, copy, 0);
	      state.wnext = copy;
	      state.whave = state.wsize;
	    }
	    else {
	      state.wnext += dist;
	      if (state.wnext === state.wsize) { state.wnext = 0; }
	      if (state.whave < state.wsize) { state.whave += dist; }
	    }
	  }
	  return 0;
	}

	function inflate(strm, flush) {
	  var state;
	  var input, output;          // input/output buffers
	  var next;                   /* next input INDEX */
	  var put;                    /* next output INDEX */
	  var have, left;             /* available input and output */
	  var hold;                   /* bit buffer */
	  var bits;                   /* bits in bit buffer */
	  var _in, _out;              /* save starting available input and output */
	  var copy;                   /* number of stored or match bytes to copy */
	  var from;                   /* where to copy match bytes from */
	  var from_source;
	  var here = 0;               /* current decoding table entry */
	  var here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
	  //var last;                   /* parent table entry */
	  var last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
	  var len;                    /* length to copy for repeats, bits to drop */
	  var ret;                    /* return code */
	  var hbuf = new utils.Buf8(4);    /* buffer for gzip header crc calculation */
	  var opts;

	  var n; // temporary var for NEED_BITS

	  var order = /* permutation of code lengths */
	    [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];


	  if (!strm || !strm.state || !strm.output ||
	      (!strm.input && strm.avail_in !== 0)) {
	    return Z_STREAM_ERROR;
	  }

	  state = strm.state;
	  if (state.mode === TYPE) { state.mode = TYPEDO; }    /* skip check */


	  //--- LOAD() ---
	  put = strm.next_out;
	  output = strm.output;
	  left = strm.avail_out;
	  next = strm.next_in;
	  input = strm.input;
	  have = strm.avail_in;
	  hold = state.hold;
	  bits = state.bits;
	  //---

	  _in = have;
	  _out = left;
	  ret = Z_OK;

	  inf_leave: // goto emulation
	  for (;;) {
	    switch (state.mode) {
	    case HEAD:
	      if (state.wrap === 0) {
	        state.mode = TYPEDO;
	        break;
	      }
	      //=== NEEDBITS(16);
	      while (bits < 16) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      if ((state.wrap & 2) && hold === 0x8b1f) {  /* gzip header */
	        state.check = 0/*crc32(0L, Z_NULL, 0)*/;
	        //=== CRC2(state.check, hold);
	        hbuf[0] = hold & 0xff;
	        hbuf[1] = (hold >>> 8) & 0xff;
	        state.check = crc32(state.check, hbuf, 2, 0);
	        //===//

	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = FLAGS;
	        break;
	      }
	      state.flags = 0;           /* expect zlib header */
	      if (state.head) {
	        state.head.done = false;
	      }
	      if (!(state.wrap & 1) ||   /* check if zlib header allowed */
	        (((hold & 0xff)/*BITS(8)*/ << 8) + (hold >> 8)) % 31) {
	        strm.msg = 'incorrect header check';
	        state.mode = BAD;
	        break;
	      }
	      if ((hold & 0x0f)/*BITS(4)*/ !== Z_DEFLATED) {
	        strm.msg = 'unknown compression method';
	        state.mode = BAD;
	        break;
	      }
	      //--- DROPBITS(4) ---//
	      hold >>>= 4;
	      bits -= 4;
	      //---//
	      len = (hold & 0x0f)/*BITS(4)*/ + 8;
	      if (state.wbits === 0) {
	        state.wbits = len;
	      }
	      else if (len > state.wbits) {
	        strm.msg = 'invalid window size';
	        state.mode = BAD;
	        break;
	      }
	      state.dmax = 1 << len;
	      //Tracev((stderr, "inflate:   zlib header ok\n"));
	      strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
	      state.mode = hold & 0x200 ? DICTID : TYPE;
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      break;
	    case FLAGS:
	      //=== NEEDBITS(16); */
	      while (bits < 16) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      state.flags = hold;
	      if ((state.flags & 0xff) !== Z_DEFLATED) {
	        strm.msg = 'unknown compression method';
	        state.mode = BAD;
	        break;
	      }
	      if (state.flags & 0xe000) {
	        strm.msg = 'unknown header flags set';
	        state.mode = BAD;
	        break;
	      }
	      if (state.head) {
	        state.head.text = ((hold >> 8) & 1);
	      }
	      if (state.flags & 0x0200) {
	        //=== CRC2(state.check, hold);
	        hbuf[0] = hold & 0xff;
	        hbuf[1] = (hold >>> 8) & 0xff;
	        state.check = crc32(state.check, hbuf, 2, 0);
	        //===//
	      }
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      state.mode = TIME;
	      /* falls through */
	    case TIME:
	      //=== NEEDBITS(32); */
	      while (bits < 32) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      if (state.head) {
	        state.head.time = hold;
	      }
	      if (state.flags & 0x0200) {
	        //=== CRC4(state.check, hold)
	        hbuf[0] = hold & 0xff;
	        hbuf[1] = (hold >>> 8) & 0xff;
	        hbuf[2] = (hold >>> 16) & 0xff;
	        hbuf[3] = (hold >>> 24) & 0xff;
	        state.check = crc32(state.check, hbuf, 4, 0);
	        //===
	      }
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      state.mode = OS;
	      /* falls through */
	    case OS:
	      //=== NEEDBITS(16); */
	      while (bits < 16) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      if (state.head) {
	        state.head.xflags = (hold & 0xff);
	        state.head.os = (hold >> 8);
	      }
	      if (state.flags & 0x0200) {
	        //=== CRC2(state.check, hold);
	        hbuf[0] = hold & 0xff;
	        hbuf[1] = (hold >>> 8) & 0xff;
	        state.check = crc32(state.check, hbuf, 2, 0);
	        //===//
	      }
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      state.mode = EXLEN;
	      /* falls through */
	    case EXLEN:
	      if (state.flags & 0x0400) {
	        //=== NEEDBITS(16); */
	        while (bits < 16) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.length = hold;
	        if (state.head) {
	          state.head.extra_len = hold;
	        }
	        if (state.flags & 0x0200) {
	          //=== CRC2(state.check, hold);
	          hbuf[0] = hold & 0xff;
	          hbuf[1] = (hold >>> 8) & 0xff;
	          state.check = crc32(state.check, hbuf, 2, 0);
	          //===//
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	      }
	      else if (state.head) {
	        state.head.extra = null/*Z_NULL*/;
	      }
	      state.mode = EXTRA;
	      /* falls through */
	    case EXTRA:
	      if (state.flags & 0x0400) {
	        copy = state.length;
	        if (copy > have) { copy = have; }
	        if (copy) {
	          if (state.head) {
	            len = state.head.extra_len - state.length;
	            if (!state.head.extra) {
	              // Use untyped array for more conveniend processing later
	              state.head.extra = new Array(state.head.extra_len);
	            }
	            utils.arraySet(
	              state.head.extra,
	              input,
	              next,
	              // extra field is limited to 65536 bytes
	              // - no need for additional size check
	              copy,
	              /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
	              len
	            );
	            //zmemcpy(state.head.extra + len, next,
	            //        len + copy > state.head.extra_max ?
	            //        state.head.extra_max - len : copy);
	          }
	          if (state.flags & 0x0200) {
	            state.check = crc32(state.check, input, copy, next);
	          }
	          have -= copy;
	          next += copy;
	          state.length -= copy;
	        }
	        if (state.length) { break inf_leave; }
	      }
	      state.length = 0;
	      state.mode = NAME;
	      /* falls through */
	    case NAME:
	      if (state.flags & 0x0800) {
	        if (have === 0) { break inf_leave; }
	        copy = 0;
	        do {
	          // TODO: 2 or 1 bytes?
	          len = input[next + copy++];
	          /* use constant limit because in js we should not preallocate memory */
	          if (state.head && len &&
	              (state.length < 65536 /*state.head.name_max*/)) {
	            state.head.name += String.fromCharCode(len);
	          }
	        } while (len && copy < have);

	        if (state.flags & 0x0200) {
	          state.check = crc32(state.check, input, copy, next);
	        }
	        have -= copy;
	        next += copy;
	        if (len) { break inf_leave; }
	      }
	      else if (state.head) {
	        state.head.name = null;
	      }
	      state.length = 0;
	      state.mode = COMMENT;
	      /* falls through */
	    case COMMENT:
	      if (state.flags & 0x1000) {
	        if (have === 0) { break inf_leave; }
	        copy = 0;
	        do {
	          len = input[next + copy++];
	          /* use constant limit because in js we should not preallocate memory */
	          if (state.head && len &&
	              (state.length < 65536 /*state.head.comm_max*/)) {
	            state.head.comment += String.fromCharCode(len);
	          }
	        } while (len && copy < have);
	        if (state.flags & 0x0200) {
	          state.check = crc32(state.check, input, copy, next);
	        }
	        have -= copy;
	        next += copy;
	        if (len) { break inf_leave; }
	      }
	      else if (state.head) {
	        state.head.comment = null;
	      }
	      state.mode = HCRC;
	      /* falls through */
	    case HCRC:
	      if (state.flags & 0x0200) {
	        //=== NEEDBITS(16); */
	        while (bits < 16) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if (hold !== (state.check & 0xffff)) {
	          strm.msg = 'header crc mismatch';
	          state.mode = BAD;
	          break;
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	      }
	      if (state.head) {
	        state.head.hcrc = ((state.flags >> 9) & 1);
	        state.head.done = true;
	      }
	      strm.adler = state.check = 0;
	      state.mode = TYPE;
	      break;
	    case DICTID:
	      //=== NEEDBITS(32); */
	      while (bits < 32) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      strm.adler = state.check = zswap32(hold);
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      state.mode = DICT;
	      /* falls through */
	    case DICT:
	      if (state.havedict === 0) {
	        //--- RESTORE() ---
	        strm.next_out = put;
	        strm.avail_out = left;
	        strm.next_in = next;
	        strm.avail_in = have;
	        state.hold = hold;
	        state.bits = bits;
	        //---
	        return Z_NEED_DICT;
	      }
	      strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
	      state.mode = TYPE;
	      /* falls through */
	    case TYPE:
	      if (flush === Z_BLOCK || flush === Z_TREES) { break inf_leave; }
	      /* falls through */
	    case TYPEDO:
	      if (state.last) {
	        //--- BYTEBITS() ---//
	        hold >>>= bits & 7;
	        bits -= bits & 7;
	        //---//
	        state.mode = CHECK;
	        break;
	      }
	      //=== NEEDBITS(3); */
	      while (bits < 3) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      state.last = (hold & 0x01)/*BITS(1)*/;
	      //--- DROPBITS(1) ---//
	      hold >>>= 1;
	      bits -= 1;
	      //---//

	      switch ((hold & 0x03)/*BITS(2)*/) {
	      case 0:                             /* stored block */
	        //Tracev((stderr, "inflate:     stored block%s\n",
	        //        state.last ? " (last)" : ""));
	        state.mode = STORED;
	        break;
	      case 1:                             /* fixed block */
	        fixedtables(state);
	        //Tracev((stderr, "inflate:     fixed codes block%s\n",
	        //        state.last ? " (last)" : ""));
	        state.mode = LEN_;             /* decode codes */
	        if (flush === Z_TREES) {
	          //--- DROPBITS(2) ---//
	          hold >>>= 2;
	          bits -= 2;
	          //---//
	          break inf_leave;
	        }
	        break;
	      case 2:                             /* dynamic block */
	        //Tracev((stderr, "inflate:     dynamic codes block%s\n",
	        //        state.last ? " (last)" : ""));
	        state.mode = TABLE;
	        break;
	      case 3:
	        strm.msg = 'invalid block type';
	        state.mode = BAD;
	      }
	      //--- DROPBITS(2) ---//
	      hold >>>= 2;
	      bits -= 2;
	      //---//
	      break;
	    case STORED:
	      //--- BYTEBITS() ---// /* go to byte boundary */
	      hold >>>= bits & 7;
	      bits -= bits & 7;
	      //---//
	      //=== NEEDBITS(32); */
	      while (bits < 32) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      if ((hold & 0xffff) !== ((hold >>> 16) ^ 0xffff)) {
	        strm.msg = 'invalid stored block lengths';
	        state.mode = BAD;
	        break;
	      }
	      state.length = hold & 0xffff;
	      //Tracev((stderr, "inflate:       stored length %u\n",
	      //        state.length));
	      //=== INITBITS();
	      hold = 0;
	      bits = 0;
	      //===//
	      state.mode = COPY_;
	      if (flush === Z_TREES) { break inf_leave; }
	      /* falls through */
	    case COPY_:
	      state.mode = COPY;
	      /* falls through */
	    case COPY:
	      copy = state.length;
	      if (copy) {
	        if (copy > have) { copy = have; }
	        if (copy > left) { copy = left; }
	        if (copy === 0) { break inf_leave; }
	        //--- zmemcpy(put, next, copy); ---
	        utils.arraySet(output, input, next, copy, put);
	        //---//
	        have -= copy;
	        next += copy;
	        left -= copy;
	        put += copy;
	        state.length -= copy;
	        break;
	      }
	      //Tracev((stderr, "inflate:       stored end\n"));
	      state.mode = TYPE;
	      break;
	    case TABLE:
	      //=== NEEDBITS(14); */
	      while (bits < 14) {
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	      }
	      //===//
	      state.nlen = (hold & 0x1f)/*BITS(5)*/ + 257;
	      //--- DROPBITS(5) ---//
	      hold >>>= 5;
	      bits -= 5;
	      //---//
	      state.ndist = (hold & 0x1f)/*BITS(5)*/ + 1;
	      //--- DROPBITS(5) ---//
	      hold >>>= 5;
	      bits -= 5;
	      //---//
	      state.ncode = (hold & 0x0f)/*BITS(4)*/ + 4;
	      //--- DROPBITS(4) ---//
	      hold >>>= 4;
	      bits -= 4;
	      //---//
	//#ifndef PKZIP_BUG_WORKAROUND
	      if (state.nlen > 286 || state.ndist > 30) {
	        strm.msg = 'too many length or distance symbols';
	        state.mode = BAD;
	        break;
	      }
	//#endif
	      //Tracev((stderr, "inflate:       table sizes ok\n"));
	      state.have = 0;
	      state.mode = LENLENS;
	      /* falls through */
	    case LENLENS:
	      while (state.have < state.ncode) {
	        //=== NEEDBITS(3);
	        while (bits < 3) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.lens[order[state.have++]] = (hold & 0x07);//BITS(3);
	        //--- DROPBITS(3) ---//
	        hold >>>= 3;
	        bits -= 3;
	        //---//
	      }
	      while (state.have < 19) {
	        state.lens[order[state.have++]] = 0;
	      }
	      // We have separate tables & no pointers. 2 commented lines below not needed.
	      //state.next = state.codes;
	      //state.lencode = state.next;
	      // Switch to use dynamic table
	      state.lencode = state.lendyn;
	      state.lenbits = 7;

	      opts = { bits: state.lenbits };
	      ret = inflate_table(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
	      state.lenbits = opts.bits;

	      if (ret) {
	        strm.msg = 'invalid code lengths set';
	        state.mode = BAD;
	        break;
	      }
	      //Tracev((stderr, "inflate:       code lengths ok\n"));
	      state.have = 0;
	      state.mode = CODELENS;
	      /* falls through */
	    case CODELENS:
	      while (state.have < state.nlen + state.ndist) {
	        for (;;) {
	          here = state.lencode[hold & ((1 << state.lenbits) - 1)];/*BITS(state.lenbits)*/
	          here_bits = here >>> 24;
	          here_op = (here >>> 16) & 0xff;
	          here_val = here & 0xffff;

	          if ((here_bits) <= bits) { break; }
	          //--- PULLBYTE() ---//
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	          //---//
	        }
	        if (here_val < 16) {
	          //--- DROPBITS(here.bits) ---//
	          hold >>>= here_bits;
	          bits -= here_bits;
	          //---//
	          state.lens[state.have++] = here_val;
	        }
	        else {
	          if (here_val === 16) {
	            //=== NEEDBITS(here.bits + 2);
	            n = here_bits + 2;
	            while (bits < n) {
	              if (have === 0) { break inf_leave; }
	              have--;
	              hold += input[next++] << bits;
	              bits += 8;
	            }
	            //===//
	            //--- DROPBITS(here.bits) ---//
	            hold >>>= here_bits;
	            bits -= here_bits;
	            //---//
	            if (state.have === 0) {
	              strm.msg = 'invalid bit length repeat';
	              state.mode = BAD;
	              break;
	            }
	            len = state.lens[state.have - 1];
	            copy = 3 + (hold & 0x03);//BITS(2);
	            //--- DROPBITS(2) ---//
	            hold >>>= 2;
	            bits -= 2;
	            //---//
	          }
	          else if (here_val === 17) {
	            //=== NEEDBITS(here.bits + 3);
	            n = here_bits + 3;
	            while (bits < n) {
	              if (have === 0) { break inf_leave; }
	              have--;
	              hold += input[next++] << bits;
	              bits += 8;
	            }
	            //===//
	            //--- DROPBITS(here.bits) ---//
	            hold >>>= here_bits;
	            bits -= here_bits;
	            //---//
	            len = 0;
	            copy = 3 + (hold & 0x07);//BITS(3);
	            //--- DROPBITS(3) ---//
	            hold >>>= 3;
	            bits -= 3;
	            //---//
	          }
	          else {
	            //=== NEEDBITS(here.bits + 7);
	            n = here_bits + 7;
	            while (bits < n) {
	              if (have === 0) { break inf_leave; }
	              have--;
	              hold += input[next++] << bits;
	              bits += 8;
	            }
	            //===//
	            //--- DROPBITS(here.bits) ---//
	            hold >>>= here_bits;
	            bits -= here_bits;
	            //---//
	            len = 0;
	            copy = 11 + (hold & 0x7f);//BITS(7);
	            //--- DROPBITS(7) ---//
	            hold >>>= 7;
	            bits -= 7;
	            //---//
	          }
	          if (state.have + copy > state.nlen + state.ndist) {
	            strm.msg = 'invalid bit length repeat';
	            state.mode = BAD;
	            break;
	          }
	          while (copy--) {
	            state.lens[state.have++] = len;
	          }
	        }
	      }

	      /* handle error breaks in while */
	      if (state.mode === BAD) { break; }

	      /* check for end-of-block code (better have one) */
	      if (state.lens[256] === 0) {
	        strm.msg = 'invalid code -- missing end-of-block';
	        state.mode = BAD;
	        break;
	      }

	      /* build code tables -- note: do not change the lenbits or distbits
	         values here (9 and 6) without reading the comments in inftrees.h
	         concerning the ENOUGH constants, which depend on those values */
	      state.lenbits = 9;

	      opts = { bits: state.lenbits };
	      ret = inflate_table(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
	      // We have separate tables & no pointers. 2 commented lines below not needed.
	      // state.next_index = opts.table_index;
	      state.lenbits = opts.bits;
	      // state.lencode = state.next;

	      if (ret) {
	        strm.msg = 'invalid literal/lengths set';
	        state.mode = BAD;
	        break;
	      }

	      state.distbits = 6;
	      //state.distcode.copy(state.codes);
	      // Switch to use dynamic table
	      state.distcode = state.distdyn;
	      opts = { bits: state.distbits };
	      ret = inflate_table(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
	      // We have separate tables & no pointers. 2 commented lines below not needed.
	      // state.next_index = opts.table_index;
	      state.distbits = opts.bits;
	      // state.distcode = state.next;

	      if (ret) {
	        strm.msg = 'invalid distances set';
	        state.mode = BAD;
	        break;
	      }
	      //Tracev((stderr, 'inflate:       codes ok\n'));
	      state.mode = LEN_;
	      if (flush === Z_TREES) { break inf_leave; }
	      /* falls through */
	    case LEN_:
	      state.mode = LEN;
	      /* falls through */
	    case LEN:
	      if (have >= 6 && left >= 258) {
	        //--- RESTORE() ---
	        strm.next_out = put;
	        strm.avail_out = left;
	        strm.next_in = next;
	        strm.avail_in = have;
	        state.hold = hold;
	        state.bits = bits;
	        //---
	        inflate_fast(strm, _out);
	        //--- LOAD() ---
	        put = strm.next_out;
	        output = strm.output;
	        left = strm.avail_out;
	        next = strm.next_in;
	        input = strm.input;
	        have = strm.avail_in;
	        hold = state.hold;
	        bits = state.bits;
	        //---

	        if (state.mode === TYPE) {
	          state.back = -1;
	        }
	        break;
	      }
	      state.back = 0;
	      for (;;) {
	        here = state.lencode[hold & ((1 << state.lenbits) - 1)];  /*BITS(state.lenbits)*/
	        here_bits = here >>> 24;
	        here_op = (here >>> 16) & 0xff;
	        here_val = here & 0xffff;

	        if (here_bits <= bits) { break; }
	        //--- PULLBYTE() ---//
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	        //---//
	      }
	      if (here_op && (here_op & 0xf0) === 0) {
	        last_bits = here_bits;
	        last_op = here_op;
	        last_val = here_val;
	        for (;;) {
	          here = state.lencode[last_val +
	                  ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
	          here_bits = here >>> 24;
	          here_op = (here >>> 16) & 0xff;
	          here_val = here & 0xffff;

	          if ((last_bits + here_bits) <= bits) { break; }
	          //--- PULLBYTE() ---//
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	          //---//
	        }
	        //--- DROPBITS(last.bits) ---//
	        hold >>>= last_bits;
	        bits -= last_bits;
	        //---//
	        state.back += last_bits;
	      }
	      //--- DROPBITS(here.bits) ---//
	      hold >>>= here_bits;
	      bits -= here_bits;
	      //---//
	      state.back += here_bits;
	      state.length = here_val;
	      if (here_op === 0) {
	        //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
	        //        "inflate:         literal '%c'\n" :
	        //        "inflate:         literal 0x%02x\n", here.val));
	        state.mode = LIT;
	        break;
	      }
	      if (here_op & 32) {
	        //Tracevv((stderr, "inflate:         end of block\n"));
	        state.back = -1;
	        state.mode = TYPE;
	        break;
	      }
	      if (here_op & 64) {
	        strm.msg = 'invalid literal/length code';
	        state.mode = BAD;
	        break;
	      }
	      state.extra = here_op & 15;
	      state.mode = LENEXT;
	      /* falls through */
	    case LENEXT:
	      if (state.extra) {
	        //=== NEEDBITS(state.extra);
	        n = state.extra;
	        while (bits < n) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.length += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
	        //--- DROPBITS(state.extra) ---//
	        hold >>>= state.extra;
	        bits -= state.extra;
	        //---//
	        state.back += state.extra;
	      }
	      //Tracevv((stderr, "inflate:         length %u\n", state.length));
	      state.was = state.length;
	      state.mode = DIST;
	      /* falls through */
	    case DIST:
	      for (;;) {
	        here = state.distcode[hold & ((1 << state.distbits) - 1)];/*BITS(state.distbits)*/
	        here_bits = here >>> 24;
	        here_op = (here >>> 16) & 0xff;
	        here_val = here & 0xffff;

	        if ((here_bits) <= bits) { break; }
	        //--- PULLBYTE() ---//
	        if (have === 0) { break inf_leave; }
	        have--;
	        hold += input[next++] << bits;
	        bits += 8;
	        //---//
	      }
	      if ((here_op & 0xf0) === 0) {
	        last_bits = here_bits;
	        last_op = here_op;
	        last_val = here_val;
	        for (;;) {
	          here = state.distcode[last_val +
	                  ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
	          here_bits = here >>> 24;
	          here_op = (here >>> 16) & 0xff;
	          here_val = here & 0xffff;

	          if ((last_bits + here_bits) <= bits) { break; }
	          //--- PULLBYTE() ---//
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	          //---//
	        }
	        //--- DROPBITS(last.bits) ---//
	        hold >>>= last_bits;
	        bits -= last_bits;
	        //---//
	        state.back += last_bits;
	      }
	      //--- DROPBITS(here.bits) ---//
	      hold >>>= here_bits;
	      bits -= here_bits;
	      //---//
	      state.back += here_bits;
	      if (here_op & 64) {
	        strm.msg = 'invalid distance code';
	        state.mode = BAD;
	        break;
	      }
	      state.offset = here_val;
	      state.extra = (here_op) & 15;
	      state.mode = DISTEXT;
	      /* falls through */
	    case DISTEXT:
	      if (state.extra) {
	        //=== NEEDBITS(state.extra);
	        n = state.extra;
	        while (bits < n) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.offset += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
	        //--- DROPBITS(state.extra) ---//
	        hold >>>= state.extra;
	        bits -= state.extra;
	        //---//
	        state.back += state.extra;
	      }
	//#ifdef INFLATE_STRICT
	      if (state.offset > state.dmax) {
	        strm.msg = 'invalid distance too far back';
	        state.mode = BAD;
	        break;
	      }
	//#endif
	      //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
	      state.mode = MATCH;
	      /* falls through */
	    case MATCH:
	      if (left === 0) { break inf_leave; }
	      copy = _out - left;
	      if (state.offset > copy) {         /* copy from window */
	        copy = state.offset - copy;
	        if (copy > state.whave) {
	          if (state.sane) {
	            strm.msg = 'invalid distance too far back';
	            state.mode = BAD;
	            break;
	          }
	// (!) This block is disabled in zlib defailts,
	// don't enable it for binary compatibility
	//#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
	//          Trace((stderr, "inflate.c too far\n"));
	//          copy -= state.whave;
	//          if (copy > state.length) { copy = state.length; }
	//          if (copy > left) { copy = left; }
	//          left -= copy;
	//          state.length -= copy;
	//          do {
	//            output[put++] = 0;
	//          } while (--copy);
	//          if (state.length === 0) { state.mode = LEN; }
	//          break;
	//#endif
	        }
	        if (copy > state.wnext) {
	          copy -= state.wnext;
	          from = state.wsize - copy;
	        }
	        else {
	          from = state.wnext - copy;
	        }
	        if (copy > state.length) { copy = state.length; }
	        from_source = state.window;
	      }
	      else {                              /* copy from output */
	        from_source = output;
	        from = put - state.offset;
	        copy = state.length;
	      }
	      if (copy > left) { copy = left; }
	      left -= copy;
	      state.length -= copy;
	      do {
	        output[put++] = from_source[from++];
	      } while (--copy);
	      if (state.length === 0) { state.mode = LEN; }
	      break;
	    case LIT:
	      if (left === 0) { break inf_leave; }
	      output[put++] = state.length;
	      left--;
	      state.mode = LEN;
	      break;
	    case CHECK:
	      if (state.wrap) {
	        //=== NEEDBITS(32);
	        while (bits < 32) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          // Use '|' insdead of '+' to make sure that result is signed
	          hold |= input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        _out -= left;
	        strm.total_out += _out;
	        state.total += _out;
	        if (_out) {
	          strm.adler = state.check =
	              /*UPDATE(state.check, put - _out, _out);*/
	              (state.flags ? crc32(state.check, output, _out, put - _out) : adler32(state.check, output, _out, put - _out));

	        }
	        _out = left;
	        // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
	        if ((state.flags ? hold : zswap32(hold)) !== state.check) {
	          strm.msg = 'incorrect data check';
	          state.mode = BAD;
	          break;
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        //Tracev((stderr, "inflate:   check matches trailer\n"));
	      }
	      state.mode = LENGTH;
	      /* falls through */
	    case LENGTH:
	      if (state.wrap && state.flags) {
	        //=== NEEDBITS(32);
	        while (bits < 32) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if (hold !== (state.total & 0xffffffff)) {
	          strm.msg = 'incorrect length check';
	          state.mode = BAD;
	          break;
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        //Tracev((stderr, "inflate:   length matches trailer\n"));
	      }
	      state.mode = DONE;
	      /* falls through */
	    case DONE:
	      ret = Z_STREAM_END;
	      break inf_leave;
	    case BAD:
	      ret = Z_DATA_ERROR;
	      break inf_leave;
	    case MEM:
	      return Z_MEM_ERROR;
	    case SYNC:
	      /* falls through */
	    default:
	      return Z_STREAM_ERROR;
	    }
	  }

	  // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

	  /*
	     Return from inflate(), updating the total counts and the check value.
	     If there was no progress during the inflate() call, return a buffer
	     error.  Call updatewindow() to create and/or update the window state.
	     Note: a memory error from inflate() is non-recoverable.
	   */

	  //--- RESTORE() ---
	  strm.next_out = put;
	  strm.avail_out = left;
	  strm.next_in = next;
	  strm.avail_in = have;
	  state.hold = hold;
	  state.bits = bits;
	  //---

	  if (state.wsize || (_out !== strm.avail_out && state.mode < BAD &&
	                      (state.mode < CHECK || flush !== Z_FINISH))) {
	    if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) {
	      state.mode = MEM;
	      return Z_MEM_ERROR;
	    }
	  }
	  _in -= strm.avail_in;
	  _out -= strm.avail_out;
	  strm.total_in += _in;
	  strm.total_out += _out;
	  state.total += _out;
	  if (state.wrap && _out) {
	    strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/
	      (state.flags ? crc32(state.check, output, _out, strm.next_out - _out) : adler32(state.check, output, _out, strm.next_out - _out));
	  }
	  strm.data_type = state.bits + (state.last ? 64 : 0) +
	                    (state.mode === TYPE ? 128 : 0) +
	                    (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
	  if (((_in === 0 && _out === 0) || flush === Z_FINISH) && ret === Z_OK) {
	    ret = Z_BUF_ERROR;
	  }
	  return ret;
	}

	function inflateEnd(strm) {

	  if (!strm || !strm.state /*|| strm->zfree == (free_func)0*/) {
	    return Z_STREAM_ERROR;
	  }

	  var state = strm.state;
	  if (state.window) {
	    state.window = null;
	  }
	  strm.state = null;
	  return Z_OK;
	}

	function inflateGetHeader(strm, head) {
	  var state;

	  /* check state */
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  if ((state.wrap & 2) === 0) { return Z_STREAM_ERROR; }

	  /* save header structure */
	  state.head = head;
	  head.done = false;
	  return Z_OK;
	}

	function inflateSetDictionary(strm, dictionary) {
	  var dictLength = dictionary.length;

	  var state;
	  var dictid;
	  var ret;

	  /* check state */
	  if (!strm /* == Z_NULL */ || !strm.state /* == Z_NULL */) { return Z_STREAM_ERROR; }
	  state = strm.state;

	  if (state.wrap !== 0 && state.mode !== DICT) {
	    return Z_STREAM_ERROR;
	  }

	  /* check for correct dictionary identifier */
	  if (state.mode === DICT) {
	    dictid = 1; /* adler32(0, null, 0)*/
	    /* dictid = adler32(dictid, dictionary, dictLength); */
	    dictid = adler32(dictid, dictionary, dictLength, 0);
	    if (dictid !== state.check) {
	      return Z_DATA_ERROR;
	    }
	  }
	  /* copy dictionary to window using updatewindow(), which will amend the
	   existing dictionary if appropriate */
	  ret = updatewindow(strm, dictionary, dictLength, dictLength);
	  if (ret) {
	    state.mode = MEM;
	    return Z_MEM_ERROR;
	  }
	  state.havedict = 1;
	  // Tracev((stderr, "inflate:   dictionary set\n"));
	  return Z_OK;
	}

	exports.inflateReset = inflateReset;
	exports.inflateReset2 = inflateReset2;
	exports.inflateResetKeep = inflateResetKeep;
	exports.inflateInit = inflateInit;
	exports.inflateInit2 = inflateInit2;
	exports.inflate = inflate;
	exports.inflateEnd = inflateEnd;
	exports.inflateGetHeader = inflateGetHeader;
	exports.inflateSetDictionary = inflateSetDictionary;
	exports.inflateInfo = 'pako inflate (from Nodeca project)';

	/* Not implemented
	exports.inflateCopy = inflateCopy;
	exports.inflateGetDictionary = inflateGetDictionary;
	exports.inflateMark = inflateMark;
	exports.inflatePrime = inflatePrime;
	exports.inflateSync = inflateSync;
	exports.inflateSyncPoint = inflateSyncPoint;
	exports.inflateUndermine = inflateUndermine;
	*/


/***/ }),
/* 67 */
/***/ (function(module, exports) {

	'use strict';

	// See state defs from inflate.js
	var BAD = 30;       /* got a data error -- remain here until reset */
	var TYPE = 12;      /* i: waiting for type bits, including last-flag bit */

	/*
	   Decode literal, length, and distance codes and write out the resulting
	   literal and match bytes until either not enough input or output is
	   available, an end-of-block is encountered, or a data error is encountered.
	   When large enough input and output buffers are supplied to inflate(), for
	   example, a 16K input buffer and a 64K output buffer, more than 95% of the
	   inflate execution time is spent in this routine.

	   Entry assumptions:

	        state.mode === LEN
	        strm.avail_in >= 6
	        strm.avail_out >= 258
	        start >= strm.avail_out
	        state.bits < 8

	   On return, state.mode is one of:

	        LEN -- ran out of enough output space or enough available input
	        TYPE -- reached end of block code, inflate() to interpret next block
	        BAD -- error in block data

	   Notes:

	    - The maximum input bits used by a length/distance pair is 15 bits for the
	      length code, 5 bits for the length extra, 15 bits for the distance code,
	      and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
	      Therefore if strm.avail_in >= 6, then there is enough input to avoid
	      checking for available input while decoding.

	    - The maximum bytes that a single length/distance pair can output is 258
	      bytes, which is the maximum length that can be coded.  inflate_fast()
	      requires strm.avail_out >= 258 for each loop to avoid checking for
	      output space.
	 */
	module.exports = function inflate_fast(strm, start) {
	  var state;
	  var _in;                    /* local strm.input */
	  var last;                   /* have enough input while in < last */
	  var _out;                   /* local strm.output */
	  var beg;                    /* inflate()'s initial strm.output */
	  var end;                    /* while out < end, enough space available */
	//#ifdef INFLATE_STRICT
	  var dmax;                   /* maximum distance from zlib header */
	//#endif
	  var wsize;                  /* window size or zero if not using window */
	  var whave;                  /* valid bytes in the window */
	  var wnext;                  /* window write index */
	  // Use `s_window` instead `window`, avoid conflict with instrumentation tools
	  var s_window;               /* allocated sliding window, if wsize != 0 */
	  var hold;                   /* local strm.hold */
	  var bits;                   /* local strm.bits */
	  var lcode;                  /* local strm.lencode */
	  var dcode;                  /* local strm.distcode */
	  var lmask;                  /* mask for first level of length codes */
	  var dmask;                  /* mask for first level of distance codes */
	  var here;                   /* retrieved table entry */
	  var op;                     /* code bits, operation, extra bits, or */
	                              /*  window position, window bytes to copy */
	  var len;                    /* match length, unused bytes */
	  var dist;                   /* match distance */
	  var from;                   /* where to copy match from */
	  var from_source;


	  var input, output; // JS specific, because we have no pointers

	  /* copy state to local variables */
	  state = strm.state;
	  //here = state.here;
	  _in = strm.next_in;
	  input = strm.input;
	  last = _in + (strm.avail_in - 5);
	  _out = strm.next_out;
	  output = strm.output;
	  beg = _out - (start - strm.avail_out);
	  end = _out + (strm.avail_out - 257);
	//#ifdef INFLATE_STRICT
	  dmax = state.dmax;
	//#endif
	  wsize = state.wsize;
	  whave = state.whave;
	  wnext = state.wnext;
	  s_window = state.window;
	  hold = state.hold;
	  bits = state.bits;
	  lcode = state.lencode;
	  dcode = state.distcode;
	  lmask = (1 << state.lenbits) - 1;
	  dmask = (1 << state.distbits) - 1;


	  /* decode literals and length/distances until end-of-block or not enough
	     input data or output space */

	  top:
	  do {
	    if (bits < 15) {
	      hold += input[_in++] << bits;
	      bits += 8;
	      hold += input[_in++] << bits;
	      bits += 8;
	    }

	    here = lcode[hold & lmask];

	    dolen:
	    for (;;) { // Goto emulation
	      op = here >>> 24/*here.bits*/;
	      hold >>>= op;
	      bits -= op;
	      op = (here >>> 16) & 0xff/*here.op*/;
	      if (op === 0) {                          /* literal */
	        //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
	        //        "inflate:         literal '%c'\n" :
	        //        "inflate:         literal 0x%02x\n", here.val));
	        output[_out++] = here & 0xffff/*here.val*/;
	      }
	      else if (op & 16) {                     /* length base */
	        len = here & 0xffff/*here.val*/;
	        op &= 15;                           /* number of extra bits */
	        if (op) {
	          if (bits < op) {
	            hold += input[_in++] << bits;
	            bits += 8;
	          }
	          len += hold & ((1 << op) - 1);
	          hold >>>= op;
	          bits -= op;
	        }
	        //Tracevv((stderr, "inflate:         length %u\n", len));
	        if (bits < 15) {
	          hold += input[_in++] << bits;
	          bits += 8;
	          hold += input[_in++] << bits;
	          bits += 8;
	        }
	        here = dcode[hold & dmask];

	        dodist:
	        for (;;) { // goto emulation
	          op = here >>> 24/*here.bits*/;
	          hold >>>= op;
	          bits -= op;
	          op = (here >>> 16) & 0xff/*here.op*/;

	          if (op & 16) {                      /* distance base */
	            dist = here & 0xffff/*here.val*/;
	            op &= 15;                       /* number of extra bits */
	            if (bits < op) {
	              hold += input[_in++] << bits;
	              bits += 8;
	              if (bits < op) {
	                hold += input[_in++] << bits;
	                bits += 8;
	              }
	            }
	            dist += hold & ((1 << op) - 1);
	//#ifdef INFLATE_STRICT
	            if (dist > dmax) {
	              strm.msg = 'invalid distance too far back';
	              state.mode = BAD;
	              break top;
	            }
	//#endif
	            hold >>>= op;
	            bits -= op;
	            //Tracevv((stderr, "inflate:         distance %u\n", dist));
	            op = _out - beg;                /* max distance in output */
	            if (dist > op) {                /* see if copy from window */
	              op = dist - op;               /* distance back in window */
	              if (op > whave) {
	                if (state.sane) {
	                  strm.msg = 'invalid distance too far back';
	                  state.mode = BAD;
	                  break top;
	                }

	// (!) This block is disabled in zlib defailts,
	// don't enable it for binary compatibility
	//#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
	//                if (len <= op - whave) {
	//                  do {
	//                    output[_out++] = 0;
	//                  } while (--len);
	//                  continue top;
	//                }
	//                len -= op - whave;
	//                do {
	//                  output[_out++] = 0;
	//                } while (--op > whave);
	//                if (op === 0) {
	//                  from = _out - dist;
	//                  do {
	//                    output[_out++] = output[from++];
	//                  } while (--len);
	//                  continue top;
	//                }
	//#endif
	              }
	              from = 0; // window index
	              from_source = s_window;
	              if (wnext === 0) {           /* very common case */
	                from += wsize - op;
	                if (op < len) {         /* some from window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = _out - dist;  /* rest from output */
	                  from_source = output;
	                }
	              }
	              else if (wnext < op) {      /* wrap around window */
	                from += wsize + wnext - op;
	                op -= wnext;
	                if (op < len) {         /* some from end of window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = 0;
	                  if (wnext < len) {  /* some from start of window */
	                    op = wnext;
	                    len -= op;
	                    do {
	                      output[_out++] = s_window[from++];
	                    } while (--op);
	                    from = _out - dist;      /* rest from output */
	                    from_source = output;
	                  }
	                }
	              }
	              else {                      /* contiguous in window */
	                from += wnext - op;
	                if (op < len) {         /* some from window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = _out - dist;  /* rest from output */
	                  from_source = output;
	                }
	              }
	              while (len > 2) {
	                output[_out++] = from_source[from++];
	                output[_out++] = from_source[from++];
	                output[_out++] = from_source[from++];
	                len -= 3;
	              }
	              if (len) {
	                output[_out++] = from_source[from++];
	                if (len > 1) {
	                  output[_out++] = from_source[from++];
	                }
	              }
	            }
	            else {
	              from = _out - dist;          /* copy direct from output */
	              do {                        /* minimum length is three */
	                output[_out++] = output[from++];
	                output[_out++] = output[from++];
	                output[_out++] = output[from++];
	                len -= 3;
	              } while (len > 2);
	              if (len) {
	                output[_out++] = output[from++];
	                if (len > 1) {
	                  output[_out++] = output[from++];
	                }
	              }
	            }
	          }
	          else if ((op & 64) === 0) {          /* 2nd level distance code */
	            here = dcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
	            continue dodist;
	          }
	          else {
	            strm.msg = 'invalid distance code';
	            state.mode = BAD;
	            break top;
	          }

	          break; // need to emulate goto via "continue"
	        }
	      }
	      else if ((op & 64) === 0) {              /* 2nd level length code */
	        here = lcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
	        continue dolen;
	      }
	      else if (op & 32) {                     /* end-of-block */
	        //Tracevv((stderr, "inflate:         end of block\n"));
	        state.mode = TYPE;
	        break top;
	      }
	      else {
	        strm.msg = 'invalid literal/length code';
	        state.mode = BAD;
	        break top;
	      }

	      break; // need to emulate goto via "continue"
	    }
	  } while (_in < last && _out < end);

	  /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
	  len = bits >> 3;
	  _in -= len;
	  bits -= len << 3;
	  hold &= (1 << bits) - 1;

	  /* update state and return */
	  strm.next_in = _in;
	  strm.next_out = _out;
	  strm.avail_in = (_in < last ? 5 + (last - _in) : 5 - (_in - last));
	  strm.avail_out = (_out < end ? 257 + (end - _out) : 257 - (_out - end));
	  state.hold = hold;
	  state.bits = bits;
	  return;
	};


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';


	var utils = __webpack_require__(62);

	var MAXBITS = 15;
	var ENOUGH_LENS = 852;
	var ENOUGH_DISTS = 592;
	//var ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

	var CODES = 0;
	var LENS = 1;
	var DISTS = 2;

	var lbase = [ /* Length codes 257..285 base */
	  3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
	  35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
	];

	var lext = [ /* Length codes 257..285 extra */
	  16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
	  19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78
	];

	var dbase = [ /* Distance codes 0..29 base */
	  1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
	  257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
	  8193, 12289, 16385, 24577, 0, 0
	];

	var dext = [ /* Distance codes 0..29 extra */
	  16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
	  23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
	  28, 28, 29, 29, 64, 64
	];

	module.exports = function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts)
	{
	  var bits = opts.bits;
	      //here = opts.here; /* table entry for duplication */

	  var len = 0;               /* a code's length in bits */
	  var sym = 0;               /* index of code symbols */
	  var min = 0, max = 0;          /* minimum and maximum code lengths */
	  var root = 0;              /* number of index bits for root table */
	  var curr = 0;              /* number of index bits for current table */
	  var drop = 0;              /* code bits to drop for sub-table */
	  var left = 0;                   /* number of prefix codes available */
	  var used = 0;              /* code entries in table used */
	  var huff = 0;              /* Huffman code */
	  var incr;              /* for incrementing code, index */
	  var fill;              /* index for replicating entries */
	  var low;               /* low bits for current root entry */
	  var mask;              /* mask for low root bits */
	  var next;             /* next available space in table */
	  var base = null;     /* base value table to use */
	  var base_index = 0;
	//  var shoextra;    /* extra bits table to use */
	  var end;                    /* use base and extra for symbol > end */
	  var count = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
	  var offs = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
	  var extra = null;
	  var extra_index = 0;

	  var here_bits, here_op, here_val;

	  /*
	   Process a set of code lengths to create a canonical Huffman code.  The
	   code lengths are lens[0..codes-1].  Each length corresponds to the
	   symbols 0..codes-1.  The Huffman code is generated by first sorting the
	   symbols by length from short to long, and retaining the symbol order
	   for codes with equal lengths.  Then the code starts with all zero bits
	   for the first code of the shortest length, and the codes are integer
	   increments for the same length, and zeros are appended as the length
	   increases.  For the deflate format, these bits are stored backwards
	   from their more natural integer increment ordering, and so when the
	   decoding tables are built in the large loop below, the integer codes
	   are incremented backwards.

	   This routine assumes, but does not check, that all of the entries in
	   lens[] are in the range 0..MAXBITS.  The caller must assure this.
	   1..MAXBITS is interpreted as that code length.  zero means that that
	   symbol does not occur in this code.

	   The codes are sorted by computing a count of codes for each length,
	   creating from that a table of starting indices for each length in the
	   sorted table, and then entering the symbols in order in the sorted
	   table.  The sorted table is work[], with that space being provided by
	   the caller.

	   The length counts are used for other purposes as well, i.e. finding
	   the minimum and maximum length codes, determining if there are any
	   codes at all, checking for a valid set of lengths, and looking ahead
	   at length counts to determine sub-table sizes when building the
	   decoding tables.
	   */

	  /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
	  for (len = 0; len <= MAXBITS; len++) {
	    count[len] = 0;
	  }
	  for (sym = 0; sym < codes; sym++) {
	    count[lens[lens_index + sym]]++;
	  }

	  /* bound code lengths, force root to be within code lengths */
	  root = bits;
	  for (max = MAXBITS; max >= 1; max--) {
	    if (count[max] !== 0) { break; }
	  }
	  if (root > max) {
	    root = max;
	  }
	  if (max === 0) {                     /* no symbols to code at all */
	    //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
	    //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
	    //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
	    table[table_index++] = (1 << 24) | (64 << 16) | 0;


	    //table.op[opts.table_index] = 64;
	    //table.bits[opts.table_index] = 1;
	    //table.val[opts.table_index++] = 0;
	    table[table_index++] = (1 << 24) | (64 << 16) | 0;

	    opts.bits = 1;
	    return 0;     /* no symbols, but wait for decoding to report error */
	  }
	  for (min = 1; min < max; min++) {
	    if (count[min] !== 0) { break; }
	  }
	  if (root < min) {
	    root = min;
	  }

	  /* check for an over-subscribed or incomplete set of lengths */
	  left = 1;
	  for (len = 1; len <= MAXBITS; len++) {
	    left <<= 1;
	    left -= count[len];
	    if (left < 0) {
	      return -1;
	    }        /* over-subscribed */
	  }
	  if (left > 0 && (type === CODES || max !== 1)) {
	    return -1;                      /* incomplete set */
	  }

	  /* generate offsets into symbol table for each length for sorting */
	  offs[1] = 0;
	  for (len = 1; len < MAXBITS; len++) {
	    offs[len + 1] = offs[len] + count[len];
	  }

	  /* sort symbols by length, by symbol order within each length */
	  for (sym = 0; sym < codes; sym++) {
	    if (lens[lens_index + sym] !== 0) {
	      work[offs[lens[lens_index + sym]]++] = sym;
	    }
	  }

	  /*
	   Create and fill in decoding tables.  In this loop, the table being
	   filled is at next and has curr index bits.  The code being used is huff
	   with length len.  That code is converted to an index by dropping drop
	   bits off of the bottom.  For codes where len is less than drop + curr,
	   those top drop + curr - len bits are incremented through all values to
	   fill the table with replicated entries.

	   root is the number of index bits for the root table.  When len exceeds
	   root, sub-tables are created pointed to by the root entry with an index
	   of the low root bits of huff.  This is saved in low to check for when a
	   new sub-table should be started.  drop is zero when the root table is
	   being filled, and drop is root when sub-tables are being filled.

	   When a new sub-table is needed, it is necessary to look ahead in the
	   code lengths to determine what size sub-table is needed.  The length
	   counts are used for this, and so count[] is decremented as codes are
	   entered in the tables.

	   used keeps track of how many table entries have been allocated from the
	   provided *table space.  It is checked for LENS and DIST tables against
	   the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
	   the initial root table size constants.  See the comments in inftrees.h
	   for more information.

	   sym increments through all symbols, and the loop terminates when
	   all codes of length max, i.e. all codes, have been processed.  This
	   routine permits incomplete codes, so another loop after this one fills
	   in the rest of the decoding tables with invalid code markers.
	   */

	  /* set up for code type */
	  // poor man optimization - use if-else instead of switch,
	  // to avoid deopts in old v8
	  if (type === CODES) {
	    base = extra = work;    /* dummy value--not used */
	    end = 19;

	  } else if (type === LENS) {
	    base = lbase;
	    base_index -= 257;
	    extra = lext;
	    extra_index -= 257;
	    end = 256;

	  } else {                    /* DISTS */
	    base = dbase;
	    extra = dext;
	    end = -1;
	  }

	  /* initialize opts for loop */
	  huff = 0;                   /* starting code */
	  sym = 0;                    /* starting code symbol */
	  len = min;                  /* starting code length */
	  next = table_index;              /* current table to fill in */
	  curr = root;                /* current table index bits */
	  drop = 0;                   /* current bits to drop from code for index */
	  low = -1;                   /* trigger new sub-table when len > root */
	  used = 1 << root;          /* use root table entries */
	  mask = used - 1;            /* mask for comparing low */

	  /* check available table space */
	  if ((type === LENS && used > ENOUGH_LENS) ||
	    (type === DISTS && used > ENOUGH_DISTS)) {
	    return 1;
	  }

	  var i = 0;
	  /* process all codes and make table entries */
	  for (;;) {
	    i++;
	    /* create table entry */
	    here_bits = len - drop;
	    if (work[sym] < end) {
	      here_op = 0;
	      here_val = work[sym];
	    }
	    else if (work[sym] > end) {
	      here_op = extra[extra_index + work[sym]];
	      here_val = base[base_index + work[sym]];
	    }
	    else {
	      here_op = 32 + 64;         /* end of block */
	      here_val = 0;
	    }

	    /* replicate for those indices with low len bits equal to huff */
	    incr = 1 << (len - drop);
	    fill = 1 << curr;
	    min = fill;                 /* save offset to next table */
	    do {
	      fill -= incr;
	      table[next + (huff >> drop) + fill] = (here_bits << 24) | (here_op << 16) | here_val |0;
	    } while (fill !== 0);

	    /* backwards increment the len-bit code huff */
	    incr = 1 << (len - 1);
	    while (huff & incr) {
	      incr >>= 1;
	    }
	    if (incr !== 0) {
	      huff &= incr - 1;
	      huff += incr;
	    } else {
	      huff = 0;
	    }

	    /* go to next symbol, update count, len */
	    sym++;
	    if (--count[len] === 0) {
	      if (len === max) { break; }
	      len = lens[lens_index + work[sym]];
	    }

	    /* create new sub-table if needed */
	    if (len > root && (huff & mask) !== low) {
	      /* if first time, transition to sub-tables */
	      if (drop === 0) {
	        drop = root;
	      }

	      /* increment past last table */
	      next += min;            /* here min is 1 << curr */

	      /* determine length of next table */
	      curr = len - drop;
	      left = 1 << curr;
	      while (curr + drop < max) {
	        left -= count[curr + drop];
	        if (left <= 0) { break; }
	        curr++;
	        left <<= 1;
	      }

	      /* check for enough space */
	      used += 1 << curr;
	      if ((type === LENS && used > ENOUGH_LENS) ||
	        (type === DISTS && used > ENOUGH_DISTS)) {
	        return 1;
	      }

	      /* point entry in root table to sub-table */
	      low = huff & mask;
	      /*table.op[low] = curr;
	      table.bits[low] = root;
	      table.val[low] = next - opts.table_index;*/
	      table[low] = (root << 24) | (curr << 16) | (next - table_index) |0;
	    }
	  }

	  /* fill in remaining table entry if code is incomplete (guaranteed to have
	   at most one remaining entry, since if the code is incomplete, the
	   maximum code length that was allowed to get this far is one bit) */
	  if (huff !== 0) {
	    //table.op[next + huff] = 64;            /* invalid code marker */
	    //table.bits[next + huff] = len - drop;
	    //table.val[next + huff] = 0;
	    table[next + huff] = ((len - drop) << 24) | (64 << 16) |0;
	  }

	  /* set return parameters */
	  //opts.table_index += used;
	  opts.bits = root;
	  return 0;
	};


/***/ }),
/* 69 */
/***/ (function(module, exports) {

	'use strict';


	module.exports = {

	  /* Allowed flush values; see deflate() and inflate() below for details */
	  Z_NO_FLUSH:         0,
	  Z_PARTIAL_FLUSH:    1,
	  Z_SYNC_FLUSH:       2,
	  Z_FULL_FLUSH:       3,
	  Z_FINISH:           4,
	  Z_BLOCK:            5,
	  Z_TREES:            6,

	  /* Return codes for the compression/decompression functions. Negative values
	  * are errors, positive values are used for special but normal events.
	  */
	  Z_OK:               0,
	  Z_STREAM_END:       1,
	  Z_NEED_DICT:        2,
	  Z_ERRNO:           -1,
	  Z_STREAM_ERROR:    -2,
	  Z_DATA_ERROR:      -3,
	  //Z_MEM_ERROR:     -4,
	  Z_BUF_ERROR:       -5,
	  //Z_VERSION_ERROR: -6,

	  /* compression levels */
	  Z_NO_COMPRESSION:         0,
	  Z_BEST_SPEED:             1,
	  Z_BEST_COMPRESSION:       9,
	  Z_DEFAULT_COMPRESSION:   -1,


	  Z_FILTERED:               1,
	  Z_HUFFMAN_ONLY:           2,
	  Z_RLE:                    3,
	  Z_FIXED:                  4,
	  Z_DEFAULT_STRATEGY:       0,

	  /* Possible values of the data_type field (though see inflate()) */
	  Z_BINARY:                 0,
	  Z_TEXT:                   1,
	  //Z_ASCII:                1, // = Z_TEXT (deprecated)
	  Z_UNKNOWN:                2,

	  /* The deflate compression method */
	  Z_DEFLATED:               8
	  //Z_NULL:                 null // Use -1 or null inline, depending on var type
	};


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var formatRegExp = /%[sdj%]/g;
	exports.format = function(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	};


	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	exports.deprecate = function(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return exports.deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (process.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	};


	var debugs = {};
	var debugEnviron;
	exports.debuglog = function(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = process.pid;
	      debugs[set] = function() {
	        var msg = exports.format.apply(exports, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	};


	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    exports._extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}
	exports.inspect = inspect;


	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== exports.inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var numLinesEst = 0;
	  var length = output.reduce(function(prev, cur) {
	    numLinesEst++;
	    if (cur.indexOf('\n') >= 0) numLinesEst++;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray(ar) {
	  return Array.isArray(ar);
	}
	exports.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;

	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;

	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;

	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;

	exports.isBuffer = __webpack_require__(71);

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}


	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}


	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];

	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}


	// log is just a thin wrapper to console.log that prepends a timestamp
	exports.log = function() {
	  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
	};


	/**
	 * Inherit the prototype methods from one constructor into another.
	 *
	 * The Function.prototype.inherits from lang.js rewritten as a standalone
	 * function (not on Function.prototype). NOTE: If this file is to be loaded
	 * during bootstrapping this function needs to be rewritten using some native
	 * functions as prototype setup using normal JavaScript does not work as
	 * expected during bootstrapping (see mirror.js in r114903).
	 *
	 * @param {function} ctor Constructor function which needs to inherit the
	 *     prototype.
	 * @param {function} superCtor Constructor function to inherit prototype from.
	 */
	exports.inherits = __webpack_require__(72);

	exports._extend = function(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	};

	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(34)))

/***/ }),
/* 71 */
/***/ (function(module, exports) {

	module.exports = function isBuffer(arg) {
	  return arg && typeof arg === 'object'
	    && typeof arg.copy === 'function'
	    && typeof arg.fill === 'function'
	    && typeof arg.readUInt8 === 'function';
	}

/***/ }),
/* 72 */
/***/ (function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {'use strict';

	// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
	// original notice:

	/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	function compare(a, b) {
	  if (a === b) {
	    return 0;
	  }

	  var x = a.length;
	  var y = b.length;

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i];
	      y = b[i];
	      break;
	    }
	  }

	  if (x < y) {
	    return -1;
	  }
	  if (y < x) {
	    return 1;
	  }
	  return 0;
	}
	function isBuffer(b) {
	  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
	    return global.Buffer.isBuffer(b);
	  }
	  return !!(b != null && b._isBuffer);
	}

	// based on node assert, original notice:

	// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
	//
	// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
	//
	// Originally from narwhal.js (http://narwhaljs.org)
	// Copyright (c) 2009 Thomas Robinson <280north.com>
	//
	// Permission is hereby granted, free of charge, to any person obtaining a copy
	// of this software and associated documentation files (the 'Software'), to
	// deal in the Software without restriction, including without limitation the
	// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
	// sell copies of the Software, and to permit persons to whom the Software is
	// furnished to do so, subject to the following conditions:
	//
	// The above copyright notice and this permission notice shall be included in
	// all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
	// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
	// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

	var util = __webpack_require__(70);
	var hasOwn = Object.prototype.hasOwnProperty;
	var pSlice = Array.prototype.slice;
	var functionsHaveNames = (function () {
	  return function foo() {}.name === 'foo';
	}());
	function pToString (obj) {
	  return Object.prototype.toString.call(obj);
	}
	function isView(arrbuf) {
	  if (isBuffer(arrbuf)) {
	    return false;
	  }
	  if (typeof global.ArrayBuffer !== 'function') {
	    return false;
	  }
	  if (typeof ArrayBuffer.isView === 'function') {
	    return ArrayBuffer.isView(arrbuf);
	  }
	  if (!arrbuf) {
	    return false;
	  }
	  if (arrbuf instanceof DataView) {
	    return true;
	  }
	  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
	    return true;
	  }
	  return false;
	}
	// 1. The assert module provides functions that throw
	// AssertionError's when particular conditions are not met. The
	// assert module must conform to the following interface.

	var assert = module.exports = ok;

	// 2. The AssertionError is defined in assert.
	// new assert.AssertionError({ message: message,
	//                             actual: actual,
	//                             expected: expected })

	var regex = /\s*function\s+([^\(\s]*)\s*/;
	// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
	function getName(func) {
	  if (!util.isFunction(func)) {
	    return;
	  }
	  if (functionsHaveNames) {
	    return func.name;
	  }
	  var str = func.toString();
	  var match = str.match(regex);
	  return match && match[1];
	}
	assert.AssertionError = function AssertionError(options) {
	  this.name = 'AssertionError';
	  this.actual = options.actual;
	  this.expected = options.expected;
	  this.operator = options.operator;
	  if (options.message) {
	    this.message = options.message;
	    this.generatedMessage = false;
	  } else {
	    this.message = getMessage(this);
	    this.generatedMessage = true;
	  }
	  var stackStartFunction = options.stackStartFunction || fail;
	  if (Error.captureStackTrace) {
	    Error.captureStackTrace(this, stackStartFunction);
	  } else {
	    // non v8 browsers so we can have a stacktrace
	    var err = new Error();
	    if (err.stack) {
	      var out = err.stack;

	      // try to strip useless frames
	      var fn_name = getName(stackStartFunction);
	      var idx = out.indexOf('\n' + fn_name);
	      if (idx >= 0) {
	        // once we have located the function frame
	        // we need to strip out everything before it (and its line)
	        var next_line = out.indexOf('\n', idx + 1);
	        out = out.substring(next_line + 1);
	      }

	      this.stack = out;
	    }
	  }
	};

	// assert.AssertionError instanceof Error
	util.inherits(assert.AssertionError, Error);

	function truncate(s, n) {
	  if (typeof s === 'string') {
	    return s.length < n ? s : s.slice(0, n);
	  } else {
	    return s;
	  }
	}
	function inspect(something) {
	  if (functionsHaveNames || !util.isFunction(something)) {
	    return util.inspect(something);
	  }
	  var rawname = getName(something);
	  var name = rawname ? ': ' + rawname : '';
	  return '[Function' +  name + ']';
	}
	function getMessage(self) {
	  return truncate(inspect(self.actual), 128) + ' ' +
	         self.operator + ' ' +
	         truncate(inspect(self.expected), 128);
	}

	// At present only the three keys mentioned above are used and
	// understood by the spec. Implementations or sub modules can pass
	// other keys to the AssertionError's constructor - they will be
	// ignored.

	// 3. All of the following functions must throw an AssertionError
	// when a corresponding condition is not met, with a message that
	// may be undefined if not provided.  All assertion methods provide
	// both the actual and expected values to the assertion error for
	// display purposes.

	function fail(actual, expected, message, operator, stackStartFunction) {
	  throw new assert.AssertionError({
	    message: message,
	    actual: actual,
	    expected: expected,
	    operator: operator,
	    stackStartFunction: stackStartFunction
	  });
	}

	// EXTENSION! allows for well behaved errors defined elsewhere.
	assert.fail = fail;

	// 4. Pure assertion tests whether a value is truthy, as determined
	// by !!guard.
	// assert.ok(guard, message_opt);
	// This statement is equivalent to assert.equal(true, !!guard,
	// message_opt);. To test strictly for the value true, use
	// assert.strictEqual(true, guard, message_opt);.

	function ok(value, message) {
	  if (!value) fail(value, true, message, '==', assert.ok);
	}
	assert.ok = ok;

	// 5. The equality assertion tests shallow, coercive equality with
	// ==.
	// assert.equal(actual, expected, message_opt);

	assert.equal = function equal(actual, expected, message) {
	  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
	};

	// 6. The non-equality assertion tests for whether two objects are not equal
	// with != assert.notEqual(actual, expected, message_opt);

	assert.notEqual = function notEqual(actual, expected, message) {
	  if (actual == expected) {
	    fail(actual, expected, message, '!=', assert.notEqual);
	  }
	};

	// 7. The equivalence assertion tests a deep equality relation.
	// assert.deepEqual(actual, expected, message_opt);

	assert.deepEqual = function deepEqual(actual, expected, message) {
	  if (!_deepEqual(actual, expected, false)) {
	    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
	  }
	};

	assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
	  if (!_deepEqual(actual, expected, true)) {
	    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
	  }
	};

	function _deepEqual(actual, expected, strict, memos) {
	  // 7.1. All identical values are equivalent, as determined by ===.
	  if (actual === expected) {
	    return true;
	  } else if (isBuffer(actual) && isBuffer(expected)) {
	    return compare(actual, expected) === 0;

	  // 7.2. If the expected value is a Date object, the actual value is
	  // equivalent if it is also a Date object that refers to the same time.
	  } else if (util.isDate(actual) && util.isDate(expected)) {
	    return actual.getTime() === expected.getTime();

	  // 7.3 If the expected value is a RegExp object, the actual value is
	  // equivalent if it is also a RegExp object with the same source and
	  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
	  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
	    return actual.source === expected.source &&
	           actual.global === expected.global &&
	           actual.multiline === expected.multiline &&
	           actual.lastIndex === expected.lastIndex &&
	           actual.ignoreCase === expected.ignoreCase;

	  // 7.4. Other pairs that do not both pass typeof value == 'object',
	  // equivalence is determined by ==.
	  } else if ((actual === null || typeof actual !== 'object') &&
	             (expected === null || typeof expected !== 'object')) {
	    return strict ? actual === expected : actual == expected;

	  // If both values are instances of typed arrays, wrap their underlying
	  // ArrayBuffers in a Buffer each to increase performance
	  // This optimization requires the arrays to have the same type as checked by
	  // Object.prototype.toString (aka pToString). Never perform binary
	  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
	  // bit patterns are not identical.
	  } else if (isView(actual) && isView(expected) &&
	             pToString(actual) === pToString(expected) &&
	             !(actual instanceof Float32Array ||
	               actual instanceof Float64Array)) {
	    return compare(new Uint8Array(actual.buffer),
	                   new Uint8Array(expected.buffer)) === 0;

	  // 7.5 For all other Object pairs, including Array objects, equivalence is
	  // determined by having the same number of owned properties (as verified
	  // with Object.prototype.hasOwnProperty.call), the same set of keys
	  // (although not necessarily the same order), equivalent values for every
	  // corresponding key, and an identical 'prototype' property. Note: this
	  // accounts for both named and indexed properties on Arrays.
	  } else if (isBuffer(actual) !== isBuffer(expected)) {
	    return false;
	  } else {
	    memos = memos || {actual: [], expected: []};

	    var actualIndex = memos.actual.indexOf(actual);
	    if (actualIndex !== -1) {
	      if (actualIndex === memos.expected.indexOf(expected)) {
	        return true;
	      }
	    }

	    memos.actual.push(actual);
	    memos.expected.push(expected);

	    return objEquiv(actual, expected, strict, memos);
	  }
	}

	function isArguments(object) {
	  return Object.prototype.toString.call(object) == '[object Arguments]';
	}

	function objEquiv(a, b, strict, actualVisitedObjects) {
	  if (a === null || a === undefined || b === null || b === undefined)
	    return false;
	  // if one is a primitive, the other must be same
	  if (util.isPrimitive(a) || util.isPrimitive(b))
	    return a === b;
	  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
	    return false;
	  var aIsArgs = isArguments(a);
	  var bIsArgs = isArguments(b);
	  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
	    return false;
	  if (aIsArgs) {
	    a = pSlice.call(a);
	    b = pSlice.call(b);
	    return _deepEqual(a, b, strict);
	  }
	  var ka = objectKeys(a);
	  var kb = objectKeys(b);
	  var key, i;
	  // having the same number of owned properties (keys incorporates
	  // hasOwnProperty)
	  if (ka.length !== kb.length)
	    return false;
	  //the same set of keys (although not necessarily the same order),
	  ka.sort();
	  kb.sort();
	  //~~~cheap key test
	  for (i = ka.length - 1; i >= 0; i--) {
	    if (ka[i] !== kb[i])
	      return false;
	  }
	  //equivalent values for every corresponding key, and
	  //~~~possibly expensive deep test
	  for (i = ka.length - 1; i >= 0; i--) {
	    key = ka[i];
	    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
	      return false;
	  }
	  return true;
	}

	// 8. The non-equivalence assertion tests for any deep inequality.
	// assert.notDeepEqual(actual, expected, message_opt);

	assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
	  if (_deepEqual(actual, expected, false)) {
	    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
	  }
	};

	assert.notDeepStrictEqual = notDeepStrictEqual;
	function notDeepStrictEqual(actual, expected, message) {
	  if (_deepEqual(actual, expected, true)) {
	    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
	  }
	}


	// 9. The strict equality assertion tests strict equality, as determined by ===.
	// assert.strictEqual(actual, expected, message_opt);

	assert.strictEqual = function strictEqual(actual, expected, message) {
	  if (actual !== expected) {
	    fail(actual, expected, message, '===', assert.strictEqual);
	  }
	};

	// 10. The strict non-equality assertion tests for strict inequality, as
	// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

	assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
	  if (actual === expected) {
	    fail(actual, expected, message, '!==', assert.notStrictEqual);
	  }
	};

	function expectedException(actual, expected) {
	  if (!actual || !expected) {
	    return false;
	  }

	  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
	    return expected.test(actual);
	  }

	  try {
	    if (actual instanceof expected) {
	      return true;
	    }
	  } catch (e) {
	    // Ignore.  The instanceof check doesn't work for arrow functions.
	  }

	  if (Error.isPrototypeOf(expected)) {
	    return false;
	  }

	  return expected.call({}, actual) === true;
	}

	function _tryBlock(block) {
	  var error;
	  try {
	    block();
	  } catch (e) {
	    error = e;
	  }
	  return error;
	}

	function _throws(shouldThrow, block, expected, message) {
	  var actual;

	  if (typeof block !== 'function') {
	    throw new TypeError('"block" argument must be a function');
	  }

	  if (typeof expected === 'string') {
	    message = expected;
	    expected = null;
	  }

	  actual = _tryBlock(block);

	  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
	            (message ? ' ' + message : '.');

	  if (shouldThrow && !actual) {
	    fail(actual, expected, 'Missing expected exception' + message);
	  }

	  var userProvidedMessage = typeof message === 'string';
	  var isUnwantedException = !shouldThrow && util.isError(actual);
	  var isUnexpectedException = !shouldThrow && actual && !expected;

	  if ((isUnwantedException &&
	      userProvidedMessage &&
	      expectedException(actual, expected)) ||
	      isUnexpectedException) {
	    fail(actual, expected, 'Got unwanted exception' + message);
	  }

	  if ((shouldThrow && actual && expected &&
	      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
	    throw actual;
	  }
	}

	// 11. Expected to throw an error:
	// assert.throws(block, Error_opt, message_opt);

	assert.throws = function(block, /*optional*/error, /*optional*/message) {
	  _throws(true, block, error, message);
	};

	// EXTENSION! This is annoying to write outside this module.
	assert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {
	  _throws(false, block, error, message);
	};

	assert.ifError = function(err) { if (err) throw err; };

	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) {
	    if (hasOwn.call(obj, key)) keys.push(key);
	  }
	  return keys;
	};

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ }),
/* 74 */
/***/ (function(module, exports) {

	// Generated by CoffeeScript 1.12.6

	/*
	PDFPage - represents a single page in the PDF document
	By Devon Govett
	 */

	(function() {
	  var PDFPage;

	  PDFPage = (function() {
	    var DEFAULT_MARGINS, SIZES;

	    function PDFPage(document, options) {
	      var dimensions;
	      this.document = document;
	      if (options == null) {
	        options = {};
	      }
	      this.size = options.size || 'letter';
	      this.layout = options.layout || 'portrait';
	      if (typeof options.margin === 'number') {
	        this.margins = {
	          top: options.margin,
	          left: options.margin,
	          bottom: options.margin,
	          right: options.margin
	        };
	      } else {
	        this.margins = options.margins || DEFAULT_MARGINS;
	      }
	      dimensions = Array.isArray(this.size) ? this.size : SIZES[this.size.toUpperCase()];
	      this.width = dimensions[this.layout === 'portrait' ? 0 : 1];
	      this.height = dimensions[this.layout === 'portrait' ? 1 : 0];
	      this.content = this.document.ref();
	      this.resources = this.document.ref({
	        ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI']
	      });
	      Object.defineProperties(this, {
	        fonts: {
	          get: (function(_this) {
	            return function() {
	              var base;
	              return (base = _this.resources.data).Font != null ? base.Font : base.Font = {};
	            };
	          })(this)
	        },
	        xobjects: {
	          get: (function(_this) {
	            return function() {
	              var base;
	              return (base = _this.resources.data).XObject != null ? base.XObject : base.XObject = {};
	            };
	          })(this)
	        },
	        ext_gstates: {
	          get: (function(_this) {
	            return function() {
	              var base;
	              return (base = _this.resources.data).ExtGState != null ? base.ExtGState : base.ExtGState = {};
	            };
	          })(this)
	        },
	        patterns: {
	          get: (function(_this) {
	            return function() {
	              var base;
	              return (base = _this.resources.data).Pattern != null ? base.Pattern : base.Pattern = {};
	            };
	          })(this)
	        },
	        annotations: {
	          get: (function(_this) {
	            return function() {
	              var base;
	              return (base = _this.dictionary.data).Annots != null ? base.Annots : base.Annots = [];
	            };
	          })(this)
	        }
	      });
	      this.dictionary = this.document.ref({
	        Type: 'Page',
	        Parent: this.document._root.data.Pages,
	        MediaBox: [0, 0, this.width, this.height],
	        Contents: this.content,
	        Resources: this.resources
	      });
	    }

	    PDFPage.prototype.maxY = function() {
	      return this.height - this.margins.bottom;
	    };

	    PDFPage.prototype.write = function(chunk) {
	      return this.content.write(chunk);
	    };

	    PDFPage.prototype.end = function() {
	      this.dictionary.end();
	      this.resources.end();
	      return this.content.end();
	    };

	    DEFAULT_MARGINS = {
	      top: 72,
	      left: 72,
	      bottom: 72,
	      right: 72
	    };

	    SIZES = {
	      '4A0': [4767.87, 6740.79],
	      '2A0': [3370.39, 4767.87],
	      A0: [2383.94, 3370.39],
	      A1: [1683.78, 2383.94],
	      A2: [1190.55, 1683.78],
	      A3: [841.89, 1190.55],
	      A4: [595.28, 841.89],
	      A5: [419.53, 595.28],
	      A6: [297.64, 419.53],
	      A7: [209.76, 297.64],
	      A8: [147.40, 209.76],
	      A9: [104.88, 147.40],
	      A10: [73.70, 104.88],
	      B0: [2834.65, 4008.19],
	      B1: [2004.09, 2834.65],
	      B2: [1417.32, 2004.09],
	      B3: [1000.63, 1417.32],
	      B4: [708.66, 1000.63],
	      B5: [498.90, 708.66],
	      B6: [354.33, 498.90],
	      B7: [249.45, 354.33],
	      B8: [175.75, 249.45],
	      B9: [124.72, 175.75],
	      B10: [87.87, 124.72],
	      C0: [2599.37, 3676.54],
	      C1: [1836.85, 2599.37],
	      C2: [1298.27, 1836.85],
	      C3: [918.43, 1298.27],
	      C4: [649.13, 918.43],
	      C5: [459.21, 649.13],
	      C6: [323.15, 459.21],
	      C7: [229.61, 323.15],
	      C8: [161.57, 229.61],
	      C9: [113.39, 161.57],
	      C10: [79.37, 113.39],
	      RA0: [2437.80, 3458.27],
	      RA1: [1729.13, 2437.80],
	      RA2: [1218.90, 1729.13],
	      RA3: [864.57, 1218.90],
	      RA4: [609.45, 864.57],
	      SRA0: [2551.18, 3628.35],
	      SRA1: [1814.17, 2551.18],
	      SRA2: [1275.59, 1814.17],
	      SRA3: [907.09, 1275.59],
	      SRA4: [637.80, 907.09],
	      EXECUTIVE: [521.86, 756.00],
	      FOLIO: [612.00, 936.00],
	      LEGAL: [612.00, 1008.00],
	      LETTER: [612.00, 792.00],
	      TABLOID: [792.00, 1224.00]
	    };

	    return PDFPage;

	  })();

	  module.exports = PDFPage;

	}).call(this);


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.12.6
	(function() {
	  var PDFGradient, PDFLinearGradient, PDFRadialGradient, namedColors, ref;

	  ref = __webpack_require__(76), PDFGradient = ref.PDFGradient, PDFLinearGradient = ref.PDFLinearGradient, PDFRadialGradient = ref.PDFRadialGradient;

	  module.exports = {
	    initColor: function() {
	      this._opacityRegistry = {};
	      this._opacityCount = 0;
	      return this._gradCount = 0;
	    },
	    _normalizeColor: function(color) {
	      var hex, part;
	      if (color instanceof PDFGradient) {
	        return color;
	      }
	      if (typeof color === 'string') {
	        if (color.charAt(0) === '#') {
	          if (color.length === 4) {
	            color = color.replace(/#([0-9A-F])([0-9A-F])([0-9A-F])/i, "#$1$1$2$2$3$3");
	          }
	          hex = parseInt(color.slice(1), 16);
	          color = [hex >> 16, hex >> 8 & 0xff, hex & 0xff];
	        } else if (namedColors[color]) {
	          color = namedColors[color];
	        }
	      }
	      if (Array.isArray(color)) {
	        if (color.length === 3) {
	          color = (function() {
	            var i, len, results;
	            results = [];
	            for (i = 0, len = color.length; i < len; i++) {
	              part = color[i];
	              results.push(part / 255);
	            }
	            return results;
	          })();
	        } else if (color.length === 4) {
	          color = (function() {
	            var i, len, results;
	            results = [];
	            for (i = 0, len = color.length; i < len; i++) {
	              part = color[i];
	              results.push(part / 100);
	            }
	            return results;
	          })();
	        }
	        return color;
	      }
	      return null;
	    },
	    _setColor: function(color, stroke) {
	      var op, space;
	      color = this._normalizeColor(color);
	      if (!color) {
	        return false;
	      }
	      op = stroke ? 'SCN' : 'scn';
	      if (color instanceof PDFGradient) {
	        this._setColorSpace('Pattern', stroke);
	        color.apply(op);
	      } else {
	        space = color.length === 4 ? 'DeviceCMYK' : 'DeviceRGB';
	        this._setColorSpace(space, stroke);
	        color = color.join(' ');
	        this.addContent(color + " " + op);
	      }
	      return true;
	    },
	    _setColorSpace: function(space, stroke) {
	      var op;
	      op = stroke ? 'CS' : 'cs';
	      return this.addContent("/" + space + " " + op);
	    },
	    fillColor: function(color, opacity) {
	      var set;
	      set = this._setColor(color, false);
	      if (set) {
	        this.fillOpacity(opacity);
	      }
	      this._fillColor = [color, opacity];
	      return this;
	    },
	    strokeColor: function(color, opacity) {
	      var set;
	      set = this._setColor(color, true);
	      if (set) {
	        this.strokeOpacity(opacity);
	      }
	      return this;
	    },
	    opacity: function(opacity) {
	      this._doOpacity(opacity, opacity);
	      return this;
	    },
	    fillOpacity: function(opacity) {
	      this._doOpacity(opacity, null);
	      return this;
	    },
	    strokeOpacity: function(opacity) {
	      this._doOpacity(null, opacity);
	      return this;
	    },
	    _doOpacity: function(fillOpacity, strokeOpacity) {
	      var dictionary, id, key, name, ref1;
	      if (!((fillOpacity != null) || (strokeOpacity != null))) {
	        return;
	      }
	      if (fillOpacity != null) {
	        fillOpacity = Math.max(0, Math.min(1, fillOpacity));
	      }
	      if (strokeOpacity != null) {
	        strokeOpacity = Math.max(0, Math.min(1, strokeOpacity));
	      }
	      key = fillOpacity + "_" + strokeOpacity;
	      if (this._opacityRegistry[key]) {
	        ref1 = this._opacityRegistry[key], dictionary = ref1[0], name = ref1[1];
	      } else {
	        dictionary = {
	          Type: 'ExtGState'
	        };
	        if (fillOpacity != null) {
	          dictionary.ca = fillOpacity;
	        }
	        if (strokeOpacity != null) {
	          dictionary.CA = strokeOpacity;
	        }
	        dictionary = this.ref(dictionary);
	        dictionary.end();
	        id = ++this._opacityCount;
	        name = "Gs" + id;
	        this._opacityRegistry[key] = [dictionary, name];
	      }
	      this.page.ext_gstates[name] = dictionary;
	      return this.addContent("/" + name + " gs");
	    },
	    linearGradient: function(x1, y1, x2, y2) {
	      return new PDFLinearGradient(this, x1, y1, x2, y2);
	    },
	    radialGradient: function(x1, y1, r1, x2, y2, r2) {
	      return new PDFRadialGradient(this, x1, y1, r1, x2, y2, r2);
	    }
	  };

	  namedColors = {
	    aliceblue: [240, 248, 255],
	    antiquewhite: [250, 235, 215],
	    aqua: [0, 255, 255],
	    aquamarine: [127, 255, 212],
	    azure: [240, 255, 255],
	    beige: [245, 245, 220],
	    bisque: [255, 228, 196],
	    black: [0, 0, 0],
	    blanchedalmond: [255, 235, 205],
	    blue: [0, 0, 255],
	    blueviolet: [138, 43, 226],
	    brown: [165, 42, 42],
	    burlywood: [222, 184, 135],
	    cadetblue: [95, 158, 160],
	    chartreuse: [127, 255, 0],
	    chocolate: [210, 105, 30],
	    coral: [255, 127, 80],
	    cornflowerblue: [100, 149, 237],
	    cornsilk: [255, 248, 220],
	    crimson: [220, 20, 60],
	    cyan: [0, 255, 255],
	    darkblue: [0, 0, 139],
	    darkcyan: [0, 139, 139],
	    darkgoldenrod: [184, 134, 11],
	    darkgray: [169, 169, 169],
	    darkgreen: [0, 100, 0],
	    darkgrey: [169, 169, 169],
	    darkkhaki: [189, 183, 107],
	    darkmagenta: [139, 0, 139],
	    darkolivegreen: [85, 107, 47],
	    darkorange: [255, 140, 0],
	    darkorchid: [153, 50, 204],
	    darkred: [139, 0, 0],
	    darksalmon: [233, 150, 122],
	    darkseagreen: [143, 188, 143],
	    darkslateblue: [72, 61, 139],
	    darkslategray: [47, 79, 79],
	    darkslategrey: [47, 79, 79],
	    darkturquoise: [0, 206, 209],
	    darkviolet: [148, 0, 211],
	    deeppink: [255, 20, 147],
	    deepskyblue: [0, 191, 255],
	    dimgray: [105, 105, 105],
	    dimgrey: [105, 105, 105],
	    dodgerblue: [30, 144, 255],
	    firebrick: [178, 34, 34],
	    floralwhite: [255, 250, 240],
	    forestgreen: [34, 139, 34],
	    fuchsia: [255, 0, 255],
	    gainsboro: [220, 220, 220],
	    ghostwhite: [248, 248, 255],
	    gold: [255, 215, 0],
	    goldenrod: [218, 165, 32],
	    gray: [128, 128, 128],
	    grey: [128, 128, 128],
	    green: [0, 128, 0],
	    greenyellow: [173, 255, 47],
	    honeydew: [240, 255, 240],
	    hotpink: [255, 105, 180],
	    indianred: [205, 92, 92],
	    indigo: [75, 0, 130],
	    ivory: [255, 255, 240],
	    khaki: [240, 230, 140],
	    lavender: [230, 230, 250],
	    lavenderblush: [255, 240, 245],
	    lawngreen: [124, 252, 0],
	    lemonchiffon: [255, 250, 205],
	    lightblue: [173, 216, 230],
	    lightcoral: [240, 128, 128],
	    lightcyan: [224, 255, 255],
	    lightgoldenrodyellow: [250, 250, 210],
	    lightgray: [211, 211, 211],
	    lightgreen: [144, 238, 144],
	    lightgrey: [211, 211, 211],
	    lightpink: [255, 182, 193],
	    lightsalmon: [255, 160, 122],
	    lightseagreen: [32, 178, 170],
	    lightskyblue: [135, 206, 250],
	    lightslategray: [119, 136, 153],
	    lightslategrey: [119, 136, 153],
	    lightsteelblue: [176, 196, 222],
	    lightyellow: [255, 255, 224],
	    lime: [0, 255, 0],
	    limegreen: [50, 205, 50],
	    linen: [250, 240, 230],
	    magenta: [255, 0, 255],
	    maroon: [128, 0, 0],
	    mediumaquamarine: [102, 205, 170],
	    mediumblue: [0, 0, 205],
	    mediumorchid: [186, 85, 211],
	    mediumpurple: [147, 112, 219],
	    mediumseagreen: [60, 179, 113],
	    mediumslateblue: [123, 104, 238],
	    mediumspringgreen: [0, 250, 154],
	    mediumturquoise: [72, 209, 204],
	    mediumvioletred: [199, 21, 133],
	    midnightblue: [25, 25, 112],
	    mintcream: [245, 255, 250],
	    mistyrose: [255, 228, 225],
	    moccasin: [255, 228, 181],
	    navajowhite: [255, 222, 173],
	    navy: [0, 0, 128],
	    oldlace: [253, 245, 230],
	    olive: [128, 128, 0],
	    olivedrab: [107, 142, 35],
	    orange: [255, 165, 0],
	    orangered: [255, 69, 0],
	    orchid: [218, 112, 214],
	    palegoldenrod: [238, 232, 170],
	    palegreen: [152, 251, 152],
	    paleturquoise: [175, 238, 238],
	    palevioletred: [219, 112, 147],
	    papayawhip: [255, 239, 213],
	    peachpuff: [255, 218, 185],
	    peru: [205, 133, 63],
	    pink: [255, 192, 203],
	    plum: [221, 160, 221],
	    powderblue: [176, 224, 230],
	    purple: [128, 0, 128],
	    red: [255, 0, 0],
	    rosybrown: [188, 143, 143],
	    royalblue: [65, 105, 225],
	    saddlebrown: [139, 69, 19],
	    salmon: [250, 128, 114],
	    sandybrown: [244, 164, 96],
	    seagreen: [46, 139, 87],
	    seashell: [255, 245, 238],
	    sienna: [160, 82, 45],
	    silver: [192, 192, 192],
	    skyblue: [135, 206, 235],
	    slateblue: [106, 90, 205],
	    slategray: [112, 128, 144],
	    slategrey: [112, 128, 144],
	    snow: [255, 250, 250],
	    springgreen: [0, 255, 127],
	    steelblue: [70, 130, 180],
	    tan: [210, 180, 140],
	    teal: [0, 128, 128],
	    thistle: [216, 191, 216],
	    tomato: [255, 99, 71],
	    turquoise: [64, 224, 208],
	    violet: [238, 130, 238],
	    wheat: [245, 222, 179],
	    white: [255, 255, 255],
	    whitesmoke: [245, 245, 245],
	    yellow: [255, 255, 0],
	    yellowgreen: [154, 205, 50]
	  };

	}).call(this);


/***/ }),
/* 76 */
/***/ (function(module, exports) {

	// Generated by CoffeeScript 1.12.6
	(function() {
	  var PDFGradient, PDFLinearGradient, PDFRadialGradient,
	    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	    hasProp = {}.hasOwnProperty;

	  PDFGradient = (function() {
	    function PDFGradient(doc) {
	      this.doc = doc;
	      this.stops = [];
	      this.embedded = false;
	      this.transform = [1, 0, 0, 1, 0, 0];
	      this._colorSpace = 'DeviceRGB';
	    }

	    PDFGradient.prototype.stop = function(pos, color, opacity) {
	      if (opacity == null) {
	        opacity = 1;
	      }
	      opacity = Math.max(0, Math.min(1, opacity));
	      this.stops.push([pos, this.doc._normalizeColor(color), opacity]);
	      return this;
	    };

	    PDFGradient.prototype.setTransform = function(m11, m12, m21, m22, dx, dy) {
	      this.transform = [m11, m12, m21, m22, dx, dy];
	      return this;
	    };

	    PDFGradient.prototype.embed = function(m) {
	      var bounds, encode, fn, form, grad, gstate, i, j, k, last, len, opacityPattern, pageBBox, pattern, ref, ref1, shader, stop, stops, v;
	      if (this.stops.length === 0) {
	        return;
	      }
	      this.embedded = true;
	      this.matrix = m;
	      last = this.stops[this.stops.length - 1];
	      if (last[0] < 1) {
	        this.stops.push([1, last[1], last[2]]);
	      }
	      bounds = [];
	      encode = [];
	      stops = [];
	      for (i = j = 0, ref = this.stops.length - 1; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
	        encode.push(0, 1);
	        if (i + 2 !== this.stops.length) {
	          bounds.push(this.stops[i + 1][0]);
	        }
	        fn = this.doc.ref({
	          FunctionType: 2,
	          Domain: [0, 1],
	          C0: this.stops[i + 0][1],
	          C1: this.stops[i + 1][1],
	          N: 1
	        });
	        stops.push(fn);
	        fn.end();
	      }
	      if (stops.length === 1) {
	        fn = stops[0];
	      } else {
	        fn = this.doc.ref({
	          FunctionType: 3,
	          Domain: [0, 1],
	          Functions: stops,
	          Bounds: bounds,
	          Encode: encode
	        });
	        fn.end();
	      }
	      this.id = 'Sh' + (++this.doc._gradCount);
	      shader = this.shader(fn);
	      shader.end();
	      pattern = this.doc.ref({
	        Type: 'Pattern',
	        PatternType: 2,
	        Shading: shader,
	        Matrix: (function() {
	          var k, len, ref1, results;
	          ref1 = this.matrix;
	          results = [];
	          for (k = 0, len = ref1.length; k < len; k++) {
	            v = ref1[k];
	            results.push(+v.toFixed(5));
	          }
	          return results;
	        }).call(this)
	      });
	      pattern.end();
	      if (this.stops.some(function(stop) {
	        return stop[2] < 1;
	      })) {
	        grad = this.opacityGradient();
	        grad._colorSpace = 'DeviceGray';
	        ref1 = this.stops;
	        for (k = 0, len = ref1.length; k < len; k++) {
	          stop = ref1[k];
	          grad.stop(stop[0], [stop[2]]);
	        }
	        grad = grad.embed(this.matrix);
	        pageBBox = [0, 0, this.doc.page.width, this.doc.page.height];
	        form = this.doc.ref({
	          Type: 'XObject',
	          Subtype: 'Form',
	          FormType: 1,
	          BBox: pageBBox,
	          Group: {
	            Type: 'Group',
	            S: 'Transparency',
	            CS: 'DeviceGray'
	          },
	          Resources: {
	            ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI'],
	            Pattern: {
	              Sh1: grad
	            }
	          }
	        });
	        form.write("/Pattern cs /Sh1 scn");
	        form.end((pageBBox.join(" ")) + " re f");
	        gstate = this.doc.ref({
	          Type: 'ExtGState',
	          SMask: {
	            Type: 'Mask',
	            S: 'Luminosity',
	            G: form
	          }
	        });
	        gstate.end();
	        opacityPattern = this.doc.ref({
	          Type: 'Pattern',
	          PatternType: 1,
	          PaintType: 1,
	          TilingType: 2,
	          BBox: pageBBox,
	          XStep: pageBBox[2],
	          YStep: pageBBox[3],
	          Resources: {
	            ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI'],
	            Pattern: {
	              Sh1: pattern
	            },
	            ExtGState: {
	              Gs1: gstate
	            }
	          }
	        });
	        opacityPattern.write("/Gs1 gs /Pattern cs /Sh1 scn");
	        opacityPattern.end((pageBBox.join(" ")) + " re f");
	        this.doc.page.patterns[this.id] = opacityPattern;
	      } else {
	        this.doc.page.patterns[this.id] = pattern;
	      }
	      return pattern;
	    };

	    PDFGradient.prototype.apply = function(op) {
	      var dx, dy, m, m0, m1, m11, m12, m2, m21, m22, m3, m4, m5, ref, ref1;
	      ref = this.doc._ctm.slice(), m0 = ref[0], m1 = ref[1], m2 = ref[2], m3 = ref[3], m4 = ref[4], m5 = ref[5];
	      ref1 = this.transform, m11 = ref1[0], m12 = ref1[1], m21 = ref1[2], m22 = ref1[3], dx = ref1[4], dy = ref1[5];
	      m = [m0 * m11 + m2 * m12, m1 * m11 + m3 * m12, m0 * m21 + m2 * m22, m1 * m21 + m3 * m22, m0 * dx + m2 * dy + m4, m1 * dx + m3 * dy + m5];
	      if (!(this.embedded && m.join(" ") === this.matrix.join(" "))) {
	        this.embed(m);
	      }
	      return this.doc.addContent("/" + this.id + " " + op);
	    };

	    return PDFGradient;

	  })();

	  PDFLinearGradient = (function(superClass) {
	    extend(PDFLinearGradient, superClass);

	    function PDFLinearGradient(doc, x1, y1, x2, y2) {
	      this.doc = doc;
	      this.x1 = x1;
	      this.y1 = y1;
	      this.x2 = x2;
	      this.y2 = y2;
	      PDFLinearGradient.__super__.constructor.apply(this, arguments);
	    }

	    PDFLinearGradient.prototype.shader = function(fn) {
	      return this.doc.ref({
	        ShadingType: 2,
	        ColorSpace: this._colorSpace,
	        Coords: [this.x1, this.y1, this.x2, this.y2],
	        Function: fn,
	        Extend: [true, true]
	      });
	    };

	    PDFLinearGradient.prototype.opacityGradient = function() {
	      return new PDFLinearGradient(this.doc, this.x1, this.y1, this.x2, this.y2);
	    };

	    return PDFLinearGradient;

	  })(PDFGradient);

	  PDFRadialGradient = (function(superClass) {
	    extend(PDFRadialGradient, superClass);

	    function PDFRadialGradient(doc, x1, y1, r1, x2, y2, r2) {
	      this.doc = doc;
	      this.x1 = x1;
	      this.y1 = y1;
	      this.r1 = r1;
	      this.x2 = x2;
	      this.y2 = y2;
	      this.r2 = r2;
	      PDFRadialGradient.__super__.constructor.apply(this, arguments);
	    }

	    PDFRadialGradient.prototype.shader = function(fn) {
	      return this.doc.ref({
	        ShadingType: 3,
	        ColorSpace: this._colorSpace,
	        Coords: [this.x1, this.y1, this.r1, this.x2, this.y2, this.r2],
	        Function: fn,
	        Extend: [true, true]
	      });
	    };

	    PDFRadialGradient.prototype.opacityGradient = function() {
	      return new PDFRadialGradient(this.doc, this.x1, this.y1, this.r1, this.x2, this.y2, this.r2);
	    };

	    return PDFRadialGradient;

	  })(PDFGradient);

	  module.exports = {
	    PDFGradient: PDFGradient,
	    PDFLinearGradient: PDFLinearGradient,
	    PDFRadialGradient: PDFRadialGradient
	  };

	}).call(this);


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.12.6
	(function() {
	  var KAPPA, SVGPath, number,
	    slice = [].slice;

	  SVGPath = __webpack_require__(78);

	  number = __webpack_require__(55).number;

	  KAPPA = 4.0 * ((Math.sqrt(2) - 1.0) / 3.0);

	  module.exports = {
	    initVector: function() {
	      this._ctm = [1, 0, 0, 1, 0, 0];
	      return this._ctmStack = [];
	    },
	    save: function() {
	      this._ctmStack.push(this._ctm.slice());
	      return this.addContent('q');
	    },
	    restore: function() {
	      this._ctm = this._ctmStack.pop() || [1, 0, 0, 1, 0, 0];
	      return this.addContent('Q');
	    },
	    closePath: function() {
	      return this.addContent('h');
	    },
	    lineWidth: function(w) {
	      return this.addContent((number(w)) + " w");
	    },
	    _CAP_STYLES: {
	      BUTT: 0,
	      ROUND: 1,
	      SQUARE: 2
	    },
	    lineCap: function(c) {
	      if (typeof c === 'string') {
	        c = this._CAP_STYLES[c.toUpperCase()];
	      }
	      return this.addContent(c + " J");
	    },
	    _JOIN_STYLES: {
	      MITER: 0,
	      ROUND: 1,
	      BEVEL: 2
	    },
	    lineJoin: function(j) {
	      if (typeof j === 'string') {
	        j = this._JOIN_STYLES[j.toUpperCase()];
	      }
	      return this.addContent(j + " j");
	    },
	    miterLimit: function(m) {
	      return this.addContent((number(m)) + " M");
	    },
	    dash: function(length, options) {
	      var phase, ref, space, v;
	      if (options == null) {
	        options = {};
	      }
	      if (length == null) {
	        return this;
	      }
	      if (Array.isArray(length)) {
	        length = ((function() {
	          var i, len, results;
	          results = [];
	          for (i = 0, len = length.length; i < len; i++) {
	            v = length[i];
	            results.push(number(v));
	          }
	          return results;
	        })()).join(' ');
	        phase = options.phase || 0;
	        return this.addContent("[" + length + "] " + (number(phase)) + " d");
	      } else {
	        space = (ref = options.space) != null ? ref : length;
	        phase = options.phase || 0;
	        return this.addContent("[" + (number(length)) + " " + (number(space)) + "] " + (number(phase)) + " d");
	      }
	    },
	    undash: function() {
	      return this.addContent("[] 0 d");
	    },
	    moveTo: function(x, y) {
	      return this.addContent((number(x)) + " " + (number(y)) + " m");
	    },
	    lineTo: function(x, y) {
	      return this.addContent((number(x)) + " " + (number(y)) + " l");
	    },
	    bezierCurveTo: function(cp1x, cp1y, cp2x, cp2y, x, y) {
	      return this.addContent((number(cp1x)) + " " + (number(cp1y)) + " " + (number(cp2x)) + " " + (number(cp2y)) + " " + (number(x)) + " " + (number(y)) + " c");
	    },
	    quadraticCurveTo: function(cpx, cpy, x, y) {
	      return this.addContent((number(cpx)) + " " + (number(cpy)) + " " + (number(x)) + " " + (number(y)) + " v");
	    },
	    rect: function(x, y, w, h) {
	      return this.addContent((number(x)) + " " + (number(y)) + " " + (number(w)) + " " + (number(h)) + " re");
	    },
	    roundedRect: function(x, y, w, h, r) {
	      var c;
	      if (r == null) {
	        r = 0;
	      }
	      r = Math.min(r, 0.5 * w, 0.5 * h);
	      c = r * (1.0 - KAPPA);
	      this.moveTo(x + r, y);
	      this.lineTo(x + w - r, y);
	      this.bezierCurveTo(x + w - c, y, x + w, y + c, x + w, y + r);
	      this.lineTo(x + w, y + h - r);
	      this.bezierCurveTo(x + w, y + h - c, x + w - c, y + h, x + w - r, y + h);
	      this.lineTo(x + r, y + h);
	      this.bezierCurveTo(x + c, y + h, x, y + h - c, x, y + h - r);
	      this.lineTo(x, y + r);
	      this.bezierCurveTo(x, y + c, x + c, y, x + r, y);
	      return this.closePath();
	    },
	    ellipse: function(x, y, r1, r2) {
	      var ox, oy, xe, xm, ye, ym;
	      if (r2 == null) {
	        r2 = r1;
	      }
	      x -= r1;
	      y -= r2;
	      ox = r1 * KAPPA;
	      oy = r2 * KAPPA;
	      xe = x + r1 * 2;
	      ye = y + r2 * 2;
	      xm = x + r1;
	      ym = y + r2;
	      this.moveTo(x, ym);
	      this.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
	      this.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
	      this.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
	      this.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
	      return this.closePath();
	    },
	    circle: function(x, y, radius) {
	      return this.ellipse(x, y, radius);
	    },
	    arc: function(x, y, radius, startAngle, endAngle, anticlockwise) {
	      var HALF_PI, TWO_PI, ax, ay, cp1x, cp1y, cp2x, cp2y, curAng, deltaAng, deltaCx, deltaCy, dir, handleLen, i, numSegs, ref, segAng, segIdx;
	      if (anticlockwise == null) {
	        anticlockwise = false;
	      }
	      TWO_PI = 2.0 * Math.PI;
	      HALF_PI = 0.5 * Math.PI;
	      deltaAng = endAngle - startAngle;
	      if (Math.abs(deltaAng) > TWO_PI) {
	        deltaAng = TWO_PI;
	      } else if (deltaAng !== 0 && anticlockwise !== (deltaAng < 0)) {
	        dir = anticlockwise ? -1 : 1;
	        deltaAng = dir * TWO_PI + deltaAng;
	      }
	      numSegs = Math.ceil(Math.abs(deltaAng) / HALF_PI);
	      segAng = deltaAng / numSegs;
	      handleLen = (segAng / HALF_PI) * KAPPA * radius;
	      curAng = startAngle;
	      deltaCx = -Math.sin(curAng) * handleLen;
	      deltaCy = Math.cos(curAng) * handleLen;
	      ax = x + Math.cos(curAng) * radius;
	      ay = y + Math.sin(curAng) * radius;
	      this.moveTo(ax, ay);
	      for (segIdx = i = 0, ref = numSegs; 0 <= ref ? i < ref : i > ref; segIdx = 0 <= ref ? ++i : --i) {
	        cp1x = ax + deltaCx;
	        cp1y = ay + deltaCy;
	        curAng += segAng;
	        ax = x + Math.cos(curAng) * radius;
	        ay = y + Math.sin(curAng) * radius;
	        deltaCx = -Math.sin(curAng) * handleLen;
	        deltaCy = Math.cos(curAng) * handleLen;
	        cp2x = ax - deltaCx;
	        cp2y = ay - deltaCy;
	        this.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, ax, ay);
	      }
	      return this;
	    },
	    polygon: function() {
	      var i, len, point, points;
	      points = 1 <= arguments.length ? slice.call(arguments, 0) : [];
	      this.moveTo.apply(this, points.shift());
	      for (i = 0, len = points.length; i < len; i++) {
	        point = points[i];
	        this.lineTo.apply(this, point);
	      }
	      return this.closePath();
	    },
	    path: function(path) {
	      SVGPath.apply(this, path);
	      return this;
	    },
	    _windingRule: function(rule) {
	      if (/even-?odd/.test(rule)) {
	        return '*';
	      }
	      return '';
	    },
	    fill: function(color, rule) {
	      if (/(even-?odd)|(non-?zero)/.test(color)) {
	        rule = color;
	        color = null;
	      }
	      if (color) {
	        this.fillColor(color);
	      }
	      return this.addContent('f' + this._windingRule(rule));
	    },
	    stroke: function(color) {
	      if (color) {
	        this.strokeColor(color);
	      }
	      return this.addContent('S');
	    },
	    fillAndStroke: function(fillColor, strokeColor, rule) {
	      var isFillRule;
	      if (strokeColor == null) {
	        strokeColor = fillColor;
	      }
	      isFillRule = /(even-?odd)|(non-?zero)/;
	      if (isFillRule.test(fillColor)) {
	        rule = fillColor;
	        fillColor = null;
	      }
	      if (isFillRule.test(strokeColor)) {
	        rule = strokeColor;
	        strokeColor = fillColor;
	      }
	      if (fillColor) {
	        this.fillColor(fillColor);
	        this.strokeColor(strokeColor);
	      }
	      return this.addContent('B' + this._windingRule(rule));
	    },
	    clip: function(rule) {
	      return this.addContent('W' + this._windingRule(rule) + ' n');
	    },
	    transform: function(m11, m12, m21, m22, dx, dy) {
	      var m, m0, m1, m2, m3, m4, m5, v, values;
	      m = this._ctm;
	      m0 = m[0], m1 = m[1], m2 = m[2], m3 = m[3], m4 = m[4], m5 = m[5];
	      m[0] = m0 * m11 + m2 * m12;
	      m[1] = m1 * m11 + m3 * m12;
	      m[2] = m0 * m21 + m2 * m22;
	      m[3] = m1 * m21 + m3 * m22;
	      m[4] = m0 * dx + m2 * dy + m4;
	      m[5] = m1 * dx + m3 * dy + m5;
	      values = ((function() {
	        var i, len, ref, results;
	        ref = [m11, m12, m21, m22, dx, dy];
	        results = [];
	        for (i = 0, len = ref.length; i < len; i++) {
	          v = ref[i];
	          results.push(number(v));
	        }
	        return results;
	      })()).join(' ');
	      return this.addContent(values + " cm");
	    },
	    translate: function(x, y) {
	      return this.transform(1, 0, 0, 1, x, y);
	    },
	    rotate: function(angle, options) {
	      var cos, rad, ref, sin, x, x1, y, y1;
	      if (options == null) {
	        options = {};
	      }
	      rad = angle * Math.PI / 180;
	      cos = Math.cos(rad);
	      sin = Math.sin(rad);
	      x = y = 0;
	      if (options.origin != null) {
	        ref = options.origin, x = ref[0], y = ref[1];
	        x1 = x * cos - y * sin;
	        y1 = x * sin + y * cos;
	        x -= x1;
	        y -= y1;
	      }
	      return this.transform(cos, sin, -sin, cos, x, y);
	    },
	    scale: function(xFactor, yFactor, options) {
	      var ref, x, y;
	      if (yFactor == null) {
	        yFactor = xFactor;
	      }
	      if (options == null) {
	        options = {};
	      }
	      if (typeof yFactor === "object") {
	        options = yFactor;
	        yFactor = xFactor;
	      }
	      x = y = 0;
	      if (options.origin != null) {
	        ref = options.origin, x = ref[0], y = ref[1];
	        x -= xFactor * x;
	        y -= yFactor * y;
	      }
	      return this.transform(xFactor, 0, 0, yFactor, x, y);
	    }
	  };

	}).call(this);


/***/ }),
/* 78 */
/***/ (function(module, exports) {

	// Generated by CoffeeScript 1.12.6
	(function() {
	  var SVGPath;

	  SVGPath = (function() {
	    var apply, arcToSegments, cx, cy, parameters, parse, px, py, runners, segmentToBezier, solveArc, sx, sy;

	    function SVGPath() {}

	    SVGPath.apply = function(doc, path) {
	      var commands;
	      commands = parse(path);
	      return apply(commands, doc);
	    };

	    parameters = {
	      A: 7,
	      a: 7,
	      C: 6,
	      c: 6,
	      H: 1,
	      h: 1,
	      L: 2,
	      l: 2,
	      M: 2,
	      m: 2,
	      Q: 4,
	      q: 4,
	      S: 4,
	      s: 4,
	      T: 2,
	      t: 2,
	      V: 1,
	      v: 1,
	      Z: 0,
	      z: 0
	    };

	    parse = function(path) {
	      var args, c, cmd, curArg, foundDecimal, j, len, params, ret;
	      ret = [];
	      args = [];
	      curArg = "";
	      foundDecimal = false;
	      params = 0;
	      for (j = 0, len = path.length; j < len; j++) {
	        c = path[j];
	        if (parameters[c] != null) {
	          params = parameters[c];
	          if (cmd) {
	            if (curArg.length > 0) {
	              args[args.length] = +curArg;
	            }
	            ret[ret.length] = {
	              cmd: cmd,
	              args: args
	            };
	            args = [];
	            curArg = "";
	            foundDecimal = false;
	          }
	          cmd = c;
	        } else if ((c === " " || c === ",") || (c === "-" && curArg.length > 0 && curArg[curArg.length - 1] !== 'e') || (c === "." && foundDecimal)) {
	          if (curArg.length === 0) {
	            continue;
	          }
	          if (args.length === params) {
	            ret[ret.length] = {
	              cmd: cmd,
	              args: args
	            };
	            args = [+curArg];
	            if (cmd === "M") {
	              cmd = "L";
	            }
	            if (cmd === "m") {
	              cmd = "l";
	            }
	          } else {
	            args[args.length] = +curArg;
	          }
	          foundDecimal = c === ".";
	          curArg = c === '-' || c === '.' ? c : '';
	        } else {
	          curArg += c;
	          if (c === '.') {
	            foundDecimal = true;
	          }
	        }
	      }
	      if (curArg.length > 0) {
	        if (args.length === params) {
	          ret[ret.length] = {
	            cmd: cmd,
	            args: args
	          };
	          args = [+curArg];
	          if (cmd === "M") {
	            cmd = "L";
	          }
	          if (cmd === "m") {
	            cmd = "l";
	          }
	        } else {
	          args[args.length] = +curArg;
	        }
	      }
	      ret[ret.length] = {
	        cmd: cmd,
	        args: args
	      };
	      return ret;
	    };

	    cx = cy = px = py = sx = sy = 0;

	    apply = function(commands, doc) {
	      var c, i, j, len, name;
	      cx = cy = px = py = sx = sy = 0;
	      for (i = j = 0, len = commands.length; j < len; i = ++j) {
	        c = commands[i];
	        if (typeof runners[name = c.cmd] === "function") {
	          runners[name](doc, c.args);
	        }
	      }
	      return cx = cy = px = py = 0;
	    };

	    runners = {
	      M: function(doc, a) {
	        cx = a[0];
	        cy = a[1];
	        px = py = null;
	        sx = cx;
	        sy = cy;
	        return doc.moveTo(cx, cy);
	      },
	      m: function(doc, a) {
	        cx += a[0];
	        cy += a[1];
	        px = py = null;
	        sx = cx;
	        sy = cy;
	        return doc.moveTo(cx, cy);
	      },
	      C: function(doc, a) {
	        cx = a[4];
	        cy = a[5];
	        px = a[2];
	        py = a[3];
	        return doc.bezierCurveTo.apply(doc, a);
	      },
	      c: function(doc, a) {
	        doc.bezierCurveTo(a[0] + cx, a[1] + cy, a[2] + cx, a[3] + cy, a[4] + cx, a[5] + cy);
	        px = cx + a[2];
	        py = cy + a[3];
	        cx += a[4];
	        return cy += a[5];
	      },
	      S: function(doc, a) {
	        if (px === null) {
	          px = cx;
	          py = cy;
	        }
	        doc.bezierCurveTo(cx - (px - cx), cy - (py - cy), a[0], a[1], a[2], a[3]);
	        px = a[0];
	        py = a[1];
	        cx = a[2];
	        return cy = a[3];
	      },
	      s: function(doc, a) {
	        if (px === null) {
	          px = cx;
	          py = cy;
	        }
	        doc.bezierCurveTo(cx - (px - cx), cy - (py - cy), cx + a[0], cy + a[1], cx + a[2], cy + a[3]);
	        px = cx + a[0];
	        py = cy + a[1];
	        cx += a[2];
	        return cy += a[3];
	      },
	      Q: function(doc, a) {
	        px = a[0];
	        py = a[1];
	        cx = a[2];
	        cy = a[3];
	        return doc.quadraticCurveTo(a[0], a[1], cx, cy);
	      },
	      q: function(doc, a) {
	        doc.quadraticCurveTo(a[0] + cx, a[1] + cy, a[2] + cx, a[3] + cy);
	        px = cx + a[0];
	        py = cy + a[1];
	        cx += a[2];
	        return cy += a[3];
	      },
	      T: function(doc, a) {
	        if (px === null) {
	          px = cx;
	          py = cy;
	        } else {
	          px = cx - (px - cx);
	          py = cy - (py - cy);
	        }
	        doc.quadraticCurveTo(px, py, a[0], a[1]);
	        px = cx - (px - cx);
	        py = cy - (py - cy);
	        cx = a[0];
	        return cy = a[1];
	      },
	      t: function(doc, a) {
	        if (px === null) {
	          px = cx;
	          py = cy;
	        } else {
	          px = cx - (px - cx);
	          py = cy - (py - cy);
	        }
	        doc.quadraticCurveTo(px, py, cx + a[0], cy + a[1]);
	        cx += a[0];
	        return cy += a[1];
	      },
	      A: function(doc, a) {
	        solveArc(doc, cx, cy, a);
	        cx = a[5];
	        return cy = a[6];
	      },
	      a: function(doc, a) {
	        a[5] += cx;
	        a[6] += cy;
	        solveArc(doc, cx, cy, a);
	        cx = a[5];
	        return cy = a[6];
	      },
	      L: function(doc, a) {
	        cx = a[0];
	        cy = a[1];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      l: function(doc, a) {
	        cx += a[0];
	        cy += a[1];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      H: function(doc, a) {
	        cx = a[0];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      h: function(doc, a) {
	        cx += a[0];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      V: function(doc, a) {
	        cy = a[0];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      v: function(doc, a) {
	        cy += a[0];
	        px = py = null;
	        return doc.lineTo(cx, cy);
	      },
	      Z: function(doc) {
	        doc.closePath();
	        cx = sx;
	        return cy = sy;
	      },
	      z: function(doc) {
	        doc.closePath();
	        cx = sx;
	        return cy = sy;
	      }
	    };

	    solveArc = function(doc, x, y, coords) {
	      var bez, ex, ey, j, large, len, results, rot, rx, ry, seg, segs, sweep;
	      rx = coords[0], ry = coords[1], rot = coords[2], large = coords[3], sweep = coords[4], ex = coords[5], ey = coords[6];
	      segs = arcToSegments(ex, ey, rx, ry, large, sweep, rot, x, y);
	      results = [];
	      for (j = 0, len = segs.length; j < len; j++) {
	        seg = segs[j];
	        bez = segmentToBezier.apply(null, seg);
	        results.push(doc.bezierCurveTo.apply(doc, bez));
	      }
	      return results;
	    };

	    arcToSegments = function(x, y, rx, ry, large, sweep, rotateX, ox, oy) {
	      var a00, a01, a10, a11, cos_th, d, i, j, pl, ref, result, segments, sfactor, sfactor_sq, sin_th, th, th0, th1, th2, th3, th_arc, x0, x1, xc, y0, y1, yc;
	      th = rotateX * (Math.PI / 180);
	      sin_th = Math.sin(th);
	      cos_th = Math.cos(th);
	      rx = Math.abs(rx);
	      ry = Math.abs(ry);
	      px = cos_th * (ox - x) * 0.5 + sin_th * (oy - y) * 0.5;
	      py = cos_th * (oy - y) * 0.5 - sin_th * (ox - x) * 0.5;
	      pl = (px * px) / (rx * rx) + (py * py) / (ry * ry);
	      if (pl > 1) {
	        pl = Math.sqrt(pl);
	        rx *= pl;
	        ry *= pl;
	      }
	      a00 = cos_th / rx;
	      a01 = sin_th / rx;
	      a10 = (-sin_th) / ry;
	      a11 = cos_th / ry;
	      x0 = a00 * ox + a01 * oy;
	      y0 = a10 * ox + a11 * oy;
	      x1 = a00 * x + a01 * y;
	      y1 = a10 * x + a11 * y;
	      d = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
	      sfactor_sq = 1 / d - 0.25;
	      if (sfactor_sq < 0) {
	        sfactor_sq = 0;
	      }
	      sfactor = Math.sqrt(sfactor_sq);
	      if (sweep === large) {
	        sfactor = -sfactor;
	      }
	      xc = 0.5 * (x0 + x1) - sfactor * (y1 - y0);
	      yc = 0.5 * (y0 + y1) + sfactor * (x1 - x0);
	      th0 = Math.atan2(y0 - yc, x0 - xc);
	      th1 = Math.atan2(y1 - yc, x1 - xc);
	      th_arc = th1 - th0;
	      if (th_arc < 0 && sweep === 1) {
	        th_arc += 2 * Math.PI;
	      } else if (th_arc > 0 && sweep === 0) {
	        th_arc -= 2 * Math.PI;
	      }
	      segments = Math.ceil(Math.abs(th_arc / (Math.PI * 0.5 + 0.001)));
	      result = [];
	      for (i = j = 0, ref = segments; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
	        th2 = th0 + i * th_arc / segments;
	        th3 = th0 + (i + 1) * th_arc / segments;
	        result[i] = [xc, yc, th2, th3, rx, ry, sin_th, cos_th];
	      }
	      return result;
	    };

	    segmentToBezier = function(cx, cy, th0, th1, rx, ry, sin_th, cos_th) {
	      var a00, a01, a10, a11, t, th_half, x1, x2, x3, y1, y2, y3;
	      a00 = cos_th * rx;
	      a01 = -sin_th * ry;
	      a10 = sin_th * rx;
	      a11 = cos_th * ry;
	      th_half = 0.5 * (th1 - th0);
	      t = (8 / 3) * Math.sin(th_half * 0.5) * Math.sin(th_half * 0.5) / Math.sin(th_half);
	      x1 = cx + Math.cos(th0) - t * Math.sin(th0);
	      y1 = cy + Math.sin(th0) + t * Math.cos(th0);
	      x3 = cx + Math.cos(th1);
	      y3 = cy + Math.sin(th1);
	      x2 = x3 + t * Math.sin(th1);
	      y2 = y3 - t * Math.cos(th1);
	      return [a00 * x1 + a01 * y1, a10 * x1 + a11 * y1, a00 * x2 + a01 * y2, a10 * x2 + a11 * y2, a00 * x3 + a01 * y3, a10 * x3 + a11 * y3];
	    };

	    return SVGPath;

	  })();

	  module.exports = SVGPath;

	}).call(this);


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.12.6
	(function() {
	  var PDFFont;

	  PDFFont = __webpack_require__(80);

	  module.exports = {
	    initFonts: function() {
	      this._fontFamilies = {};
	      this._fontCount = 0;
	      this._fontSize = 12;
	      this._font = null;
	      this._registeredFonts = {};
	      
	    },
	    font: function(src, family, size) {
	      var cacheKey, font, id, ref;
	      if (typeof family === 'number') {
	        size = family;
	        family = null;
	      }
	      if (typeof src === 'string' && this._registeredFonts[src]) {
	        cacheKey = src;
	        ref = this._registeredFonts[src], src = ref.src, family = ref.family;
	      } else {
	        cacheKey = family || src;
	        if (typeof cacheKey !== 'string') {
	          cacheKey = null;
	        }
	      }
	      if (size != null) {
	        this.fontSize(size);
	      }
	      if (font = this._fontFamilies[cacheKey]) {
	        this._font = font;
	        return this;
	      }
	      id = 'F' + (++this._fontCount);
	      this._font = PDFFont.open(this, src, family, id);
	      if (font = this._fontFamilies[this._font.name]) {
	        this._font = font;
	        return this;
	      }
	      if (cacheKey) {
	        this._fontFamilies[cacheKey] = this._font;
	      }
	      if (this._font.name) {
	        this._fontFamilies[this._font.name] = this._font;
	      }
	      return this;
	    },
	    fontSize: function(_fontSize) {
	      this._fontSize = _fontSize;
	      return this;
	    },
	    currentLineHeight: function(includeGap) {
	      if (includeGap == null) {
	        includeGap = false;
	      }
	      return this._font.lineHeight(this._fontSize, includeGap);
	    },
	    registerFont: function(name, src, family) {
	      this._registeredFonts[name] = {
	        src: src,
	        family: family
	      };
	      return this;
	    }
	  };

	}).call(this);


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6
	(function() {
	  var EmbeddedFont, PDFFont, StandardFont, fontkit;

	  fontkit = __webpack_require__(81);

	  PDFFont = (function() {
	    PDFFont.open = function(document, src, family, id) {
	      var font;
	      if (typeof src === 'string') {
	        if (StandardFont.isStandardFont(src)) {
	          return new StandardFont(document, src, id);
	        }
	        font = fontkit.openSync(src, family);
	      } else if (Buffer.isBuffer(src)) {
	        font = fontkit.create(src, family);
	      } else if (src instanceof Uint8Array) {
	        font = fontkit.create(new Buffer(src), family);
	      } else if (src instanceof ArrayBuffer) {
	        font = fontkit.create(new Buffer(new Uint8Array(src)), family);
	      }
	      if (font == null) {
	        throw new Error('Not a supported font format or standard PDF font.');
	      }
	      return new EmbeddedFont(document, font, id);
	    };

	    function PDFFont() {
	      throw new Error('Cannot construct a PDFFont directly.');
	    }

	    PDFFont.prototype.encode = function(text) {
	      throw new Error('Must be implemented by subclasses');
	    };

	    PDFFont.prototype.widthOfString = function(text) {
	      throw new Error('Must be implemented by subclasses');
	    };

	    PDFFont.prototype.ref = function() {
	      return this.dictionary != null ? this.dictionary : this.dictionary = this.document.ref();
	    };

	    PDFFont.prototype.finalize = function() {
	      if (this.embedded || (this.dictionary == null)) {
	        return;
	      }
	      this.embed();
	      return this.embedded = true;
	    };

	    PDFFont.prototype.embed = function() {
	      throw new Error('Must be implemented by subclasses');
	    };

	    PDFFont.prototype.lineHeight = function(size, includeGap) {
	      var gap;
	      if (includeGap == null) {
	        includeGap = false;
	      }
	      gap = includeGap ? this.lineGap : 0;
	      return (this.ascender + gap - this.descender) / 1000 * size;
	    };

	    return PDFFont;

	  })();

	  module.exports = PDFFont;

	  StandardFont = __webpack_require__(289);

	  EmbeddedFont = __webpack_require__(291);

	}).call(this);

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2).Buffer))

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, process) {'use strict';

	function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

	var r = _interopDefault(__webpack_require__(82));
	var _Object$getOwnPropertyDescriptor = _interopDefault(__webpack_require__(120));
	var _getIterator = _interopDefault(__webpack_require__(146));
	var _Object$freeze = _interopDefault(__webpack_require__(179));
	var _Object$keys = _interopDefault(__webpack_require__(183));
	var _typeof = _interopDefault(__webpack_require__(186));
	var _Object$defineProperty = _interopDefault(__webpack_require__(202));
	var _classCallCheck = _interopDefault(__webpack_require__(205));
	var _createClass = _interopDefault(__webpack_require__(206));
	var _Map = _interopDefault(__webpack_require__(207));
	var _possibleConstructorReturn = _interopDefault(__webpack_require__(229));
	var _inherits = _interopDefault(__webpack_require__(230));
	var restructure_src_utils = __webpack_require__(108);
	var _Object$defineProperties = _interopDefault(__webpack_require__(238));
	var isEqual = _interopDefault(__webpack_require__(241));
	var _Object$assign = _interopDefault(__webpack_require__(244));
	var _String$fromCodePoint = _interopDefault(__webpack_require__(248));
	var _Array$from = _interopDefault(__webpack_require__(251));
	var _Set = _interopDefault(__webpack_require__(256));
	var unicode = _interopDefault(__webpack_require__(262));
	var UnicodeTrie = _interopDefault(__webpack_require__(15));
	var StateMachine = _interopDefault(__webpack_require__(264));
	var _Number$EPSILON = _interopDefault(__webpack_require__(273));
	var cloneDeep = _interopDefault(__webpack_require__(276));
	var inflate = _interopDefault(__webpack_require__(16));
	var brotli = _interopDefault(__webpack_require__(277));



	var fontkit = {};
	fontkit.logErrors = false;

	var formats = [];
	fontkit.registerFormat = function (format) {
	  formats.push(format);
	};

	fontkit.openSync = function (filename, postscriptName) {
	  var buffer = __webpack_require__(54).readFileSync(filename);
	  return fontkit.create(buffer, postscriptName);
	};

	fontkit.open = function (filename, postscriptName, callback) {
	  if (typeof postscriptName === 'function') {
	    callback = postscriptName;
	    postscriptName = null;
	  }

	  __webpack_require__(54).readFile(filename, function (err, buffer) {
	    if (err) {
	      return callback(err);
	    }

	    try {
	      var font = fontkit.create(buffer, postscriptName);
	    } catch (e) {
	      return callback(e);
	    }

	    return callback(null, font);
	  });

	  return;
	};

	fontkit.create = function (buffer, postscriptName) {
	  for (var i = 0; i < formats.length; i++) {
	    var format = formats[i];
	    if (format.probe(buffer)) {
	      var font = new format(new r.DecodeStream(buffer));
	      if (postscriptName) {
	        return font.getFont(postscriptName);
	      }

	      return font;
	    }
	  }

	  throw new Error('Unknown font format');
	};

	/**
	 * This decorator caches the results of a getter or method such that
	 * the results are lazily computed once, and then cached.
	 * @private
	 */
	function cache(target, key, descriptor) {
	  if (descriptor.get) {
	    var get = descriptor.get;
	    descriptor.get = function () {
	      var value = get.call(this);
	      _Object$defineProperty(this, key, { value: value });
	      return value;
	    };
	  } else if (typeof descriptor.value === 'function') {
	    var fn = descriptor.value;

	    return {
	      get: function get() {
	        var cache = new _Map();
	        function memoized() {
	          for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	            args[_key] = arguments[_key];
	          }

	          var key = args.length > 0 ? args[0] : 'value';
	          if (cache.has(key)) {
	            return cache.get(key);
	          }

	          var result = fn.apply(this, args);
	          cache.set(key, result);
	          return result;
	        };

	        _Object$defineProperty(this, key, { value: memoized });
	        return memoized;
	      }
	    };
	  }
	}

	var SubHeader = new r.Struct({
	  firstCode: r.uint16,
	  entryCount: r.uint16,
	  idDelta: r.int16,
	  idRangeOffset: r.uint16
	});

	var CmapGroup = new r.Struct({
	  startCharCode: r.uint32,
	  endCharCode: r.uint32,
	  glyphID: r.uint32
	});

	var UnicodeValueRange = new r.Struct({
	  startUnicodeValue: r.uint24,
	  additionalCount: r.uint8
	});

	var UVSMapping = new r.Struct({
	  unicodeValue: r.uint24,
	  glyphID: r.uint16
	});

	var DefaultUVS = new r.Array(UnicodeValueRange, r.uint32);
	var NonDefaultUVS = new r.Array(UVSMapping, r.uint32);

	var VarSelectorRecord = new r.Struct({
	  varSelector: r.uint24,
	  defaultUVS: new r.Pointer(r.uint32, DefaultUVS, { type: 'parent' }),
	  nonDefaultUVS: new r.Pointer(r.uint32, NonDefaultUVS, { type: 'parent' })
	});

	var CmapSubtable = new r.VersionedStruct(r.uint16, {
	  0: { // Byte encoding
	    length: r.uint16, // Total table length in bytes (set to 262 for format 0)
	    language: r.uint16, // Language code for this encoding subtable, or zero if language-independent
	    codeMap: new r.LazyArray(r.uint8, 256)
	  },

	  2: { // High-byte mapping (CJK)
	    length: r.uint16,
	    language: r.uint16,
	    subHeaderKeys: new r.Array(r.uint16, 256),
	    subHeaderCount: function subHeaderCount(t) {
	      return Math.max.apply(Math, t.subHeaderKeys);
	    },
	    subHeaders: new r.LazyArray(SubHeader, 'subHeaderCount'),
	    glyphIndexArray: new r.LazyArray(r.uint16, 'subHeaderCount')
	  },

	  4: { // Segment mapping to delta values
	    length: r.uint16, // Total table length in bytes
	    language: r.uint16, // Language code
	    segCountX2: r.uint16,
	    segCount: function segCount(t) {
	      return t.segCountX2 >> 1;
	    },
	    searchRange: r.uint16,
	    entrySelector: r.uint16,
	    rangeShift: r.uint16,
	    endCode: new r.LazyArray(r.uint16, 'segCount'),
	    reservedPad: new r.Reserved(r.uint16), // This value should be zero
	    startCode: new r.LazyArray(r.uint16, 'segCount'),
	    idDelta: new r.LazyArray(r.int16, 'segCount'),
	    idRangeOffset: new r.LazyArray(r.uint16, 'segCount'),
	    glyphIndexArray: new r.LazyArray(r.uint16, function (t) {
	      return (t.length - t._currentOffset) / 2;
	    })
	  },

	  6: { // Trimmed table
	    length: r.uint16,
	    language: r.uint16,
	    firstCode: r.uint16,
	    entryCount: r.uint16,
	    glyphIndices: new r.LazyArray(r.uint16, 'entryCount')
	  },

	  8: { // mixed 16-bit and 32-bit coverage
	    reserved: new r.Reserved(r.uint16),
	    length: r.uint32,
	    language: r.uint16,
	    is32: new r.LazyArray(r.uint8, 8192),
	    nGroups: r.uint32,
	    groups: new r.LazyArray(CmapGroup, 'nGroups')
	  },

	  10: { // Trimmed Array
	    reserved: new r.Reserved(r.uint16),
	    length: r.uint32,
	    language: r.uint32,
	    firstCode: r.uint32,
	    entryCount: r.uint32,
	    glyphIndices: new r.LazyArray(r.uint16, 'numChars')
	  },

	  12: { // Segmented coverage
	    reserved: new r.Reserved(r.uint16),
	    length: r.uint32,
	    language: r.uint32,
	    nGroups: r.uint32,
	    groups: new r.LazyArray(CmapGroup, 'nGroups')
	  },

	  13: { // Many-to-one range mappings (same as 12 except for group.startGlyphID)
	    reserved: new r.Reserved(r.uint16),
	    length: r.uint32,
	    language: r.uint32,
	    nGroups: r.uint32,
	    groups: new r.LazyArray(CmapGroup, 'nGroups')
	  },

	  14: { // Unicode Variation Sequences
	    length: r.uint32,
	    numRecords: r.uint32,
	    varSelectors: new r.LazyArray(VarSelectorRecord, 'numRecords')
	  }
	});

	var CmapEntry = new r.Struct({
	  platformID: r.uint16, // Platform identifier
	  encodingID: r.uint16, // Platform-specific encoding identifier
	  table: new r.Pointer(r.uint32, CmapSubtable, { type: 'parent', lazy: true })
	});

	// character to glyph mapping
	var cmap = new r.Struct({
	  version: r.uint16,
	  numSubtables: r.uint16,
	  tables: new r.Array(CmapEntry, 'numSubtables')
	});

	// font header
	var head = new r.Struct({
	  version: r.int32, // 0x00010000 (version 1.0)
	  revision: r.int32, // set by font manufacturer
	  checkSumAdjustment: r.uint32,
	  magicNumber: r.uint32, // set to 0x5F0F3CF5
	  flags: r.uint16,
	  unitsPerEm: r.uint16, // range from 64 to 16384
	  created: new r.Array(r.int32, 2),
	  modified: new r.Array(r.int32, 2),
	  xMin: r.int16, // for all glyph bounding boxes
	  yMin: r.int16, // for all glyph bounding boxes
	  xMax: r.int16, // for all glyph bounding boxes
	  yMax: r.int16, // for all glyph bounding boxes
	  macStyle: new r.Bitfield(r.uint16, ['bold', 'italic', 'underline', 'outline', 'shadow', 'condensed', 'extended']),
	  lowestRecPPEM: r.uint16, // smallest readable size in pixels
	  fontDirectionHint: r.int16,
	  indexToLocFormat: r.int16, // 0 for short offsets, 1 for long
	  glyphDataFormat: r.int16 // 0 for current format
	});

	// horizontal header
	var hhea = new r.Struct({
	  version: r.int32,
	  ascent: r.int16, // Distance from baseline of highest ascender
	  descent: r.int16, // Distance from baseline of lowest descender
	  lineGap: r.int16, // Typographic line gap
	  advanceWidthMax: r.uint16, // Maximum advance width value in 'hmtx' table
	  minLeftSideBearing: r.int16, // Maximum advance width value in 'hmtx' table
	  minRightSideBearing: r.int16, // Minimum right sidebearing value
	  xMaxExtent: r.int16,
	  caretSlopeRise: r.int16, // Used to calculate the slope of the cursor (rise/run); 1 for vertical
	  caretSlopeRun: r.int16, // 0 for vertical
	  caretOffset: r.int16, // Set to 0 for non-slanted fonts
	  reserved: new r.Reserved(r.int16, 4),
	  metricDataFormat: r.int16, // 0 for current format
	  numberOfMetrics: r.uint16 // Number of advance widths in 'hmtx' table
	});

	var HmtxEntry = new r.Struct({
	  advance: r.uint16,
	  bearing: r.int16
	});

	var hmtx = new r.Struct({
	  metrics: new r.LazyArray(HmtxEntry, function (t) {
	    return t.parent.hhea.numberOfMetrics;
	  }),
	  bearings: new r.LazyArray(r.int16, function (t) {
	    return t.parent.maxp.numGlyphs - t.parent.hhea.numberOfMetrics;
	  })
	});

	// maxiumum profile
	var maxp = new r.Struct({
	  version: r.int32,
	  numGlyphs: r.uint16, // The number of glyphs in the font
	  maxPoints: r.uint16, // Maximum points in a non-composite glyph
	  maxContours: r.uint16, // Maximum contours in a non-composite glyph
	  maxComponentPoints: r.uint16, // Maximum points in a composite glyph
	  maxComponentContours: r.uint16, // Maximum contours in a composite glyph
	  maxZones: r.uint16, // 1 if instructions do not use the twilight zone, 2 otherwise
	  maxTwilightPoints: r.uint16, // Maximum points used in Z0
	  maxStorage: r.uint16, // Number of Storage Area locations
	  maxFunctionDefs: r.uint16, // Number of FDEFs
	  maxInstructionDefs: r.uint16, // Number of IDEFs
	  maxStackElements: r.uint16, // Maximum stack depth
	  maxSizeOfInstructions: r.uint16, // Maximum byte count for glyph instructions
	  maxComponentElements: r.uint16, // Maximum number of components referenced at “top level” for any composite glyph
	  maxComponentDepth: r.uint16 // Maximum levels of recursion; 1 for simple components
	});

	/**
	 * Gets an encoding name from platform, encoding, and language ids.
	 * Returned encoding names can be used in iconv-lite to decode text.
	 */
	function getEncoding(platformID, encodingID) {
	  var languageID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

	  if (platformID === 1 && MAC_LANGUAGE_ENCODINGS[languageID]) {
	    return MAC_LANGUAGE_ENCODINGS[languageID];
	  }

	  return ENCODINGS[platformID][encodingID];
	}

	// Map of platform ids to encoding ids.
	var ENCODINGS = [
	// unicode
	['utf16be', 'utf16be', 'utf16be', 'utf16be', 'utf16be', 'utf16be'],

	// macintosh
	// Mappings available at http://unicode.org/Public/MAPPINGS/VENDORS/APPLE/
	// 0	Roman                 17	Malayalam
	// 1	Japanese	            18	Sinhalese
	// 2	Traditional Chinese	  19	Burmese
	// 3	Korean	              20	Khmer
	// 4	Arabic	              21	Thai
	// 5	Hebrew	              22	Laotian
	// 6	Greek	                23	Georgian
	// 7	Russian	              24	Armenian
	// 8	RSymbol	              25	Simplified Chinese
	// 9	Devanagari	          26	Tibetan
	// 10	Gurmukhi	            27	Mongolian
	// 11	Gujarati	            28	Geez
	// 12	Oriya	                29	Slavic
	// 13	Bengali	              30	Vietnamese
	// 14	Tamil	                31	Sindhi
	// 15	Telugu	              32	(Uninterpreted)
	// 16	Kannada
	['macroman', 'shift-jis', 'big5', 'euc-kr', 'iso-8859-6', 'iso-8859-8', 'macgreek', 'maccyrillic', 'symbol', 'Devanagari', 'Gurmukhi', 'Gujarati', 'Oriya', 'Bengali', 'Tamil', 'Telugu', 'Kannada', 'Malayalam', 'Sinhalese', 'Burmese', 'Khmer', 'macthai', 'Laotian', 'Georgian', 'Armenian', 'gb-2312-80', 'Tibetan', 'Mongolian', 'Geez', 'maccenteuro', 'Vietnamese', 'Sindhi'],

	// ISO (deprecated)
	['ascii'],

	// windows
	// Docs here: http://msdn.microsoft.com/en-us/library/system.text.encoding(v=vs.110).aspx
	['symbol', 'utf16be', 'shift-jis', 'gb18030', 'big5', 'wansung', 'johab', null, null, null, 'utf16be']];

	// Overrides for Mac scripts by language id.
	// See http://unicode.org/Public/MAPPINGS/VENDORS/APPLE/Readme.txt
	var MAC_LANGUAGE_ENCODINGS = {
	  15: 'maciceland',
	  17: 'macturkish',
	  18: 'maccroatian',
	  24: 'maccenteuro',
	  25: 'maccenteuro',
	  26: 'maccenteuro',
	  27: 'maccenteuro',
	  28: 'maccenteuro',
	  30: 'maciceland',
	  37: 'macromania',
	  38: 'maccenteuro',
	  39: 'maccenteuro',
	  40: 'maccenteuro',
	  143: 'macinuit', // Unsupported by iconv-lite
	  146: 'macgaelic' // Unsupported by iconv-lite
	};

	// Map of platform ids to BCP-47 language codes.
	var LANGUAGES = [
	// unicode
	[], { // macintosh
	  0: 'en', 30: 'fo', 60: 'ks', 90: 'rw',
	  1: 'fr', 31: 'fa', 61: 'ku', 91: 'rn',
	  2: 'de', 32: 'ru', 62: 'sd', 92: 'ny',
	  3: 'it', 33: 'zh', 63: 'bo', 93: 'mg',
	  4: 'nl', 34: 'nl-BE', 64: 'ne', 94: 'eo',
	  5: 'sv', 35: 'ga', 65: 'sa', 128: 'cy',
	  6: 'es', 36: 'sq', 66: 'mr', 129: 'eu',
	  7: 'da', 37: 'ro', 67: 'bn', 130: 'ca',
	  8: 'pt', 38: 'cz', 68: 'as', 131: 'la',
	  9: 'no', 39: 'sk', 69: 'gu', 132: 'qu',
	  10: 'he', 40: 'si', 70: 'pa', 133: 'gn',
	  11: 'ja', 41: 'yi', 71: 'or', 134: 'ay',
	  12: 'ar', 42: 'sr', 72: 'ml', 135: 'tt',
	  13: 'fi', 43: 'mk', 73: 'kn', 136: 'ug',
	  14: 'el', 44: 'bg', 74: 'ta', 137: 'dz',
	  15: 'is', 45: 'uk', 75: 'te', 138: 'jv',
	  16: 'mt', 46: 'be', 76: 'si', 139: 'su',
	  17: 'tr', 47: 'uz', 77: 'my', 140: 'gl',
	  18: 'hr', 48: 'kk', 78: 'km', 141: 'af',
	  19: 'zh-Hant', 49: 'az-Cyrl', 79: 'lo', 142: 'br',
	  20: 'ur', 50: 'az-Arab', 80: 'vi', 143: 'iu',
	  21: 'hi', 51: 'hy', 81: 'id', 144: 'gd',
	  22: 'th', 52: 'ka', 82: 'tl', 145: 'gv',
	  23: 'ko', 53: 'mo', 83: 'ms', 146: 'ga',
	  24: 'lt', 54: 'ky', 84: 'ms-Arab', 147: 'to',
	  25: 'pl', 55: 'tg', 85: 'am', 148: 'el-polyton',
	  26: 'hu', 56: 'tk', 86: 'ti', 149: 'kl',
	  27: 'es', 57: 'mn-CN', 87: 'om', 150: 'az',
	  28: 'lv', 58: 'mn', 88: 'so', 151: 'nn',
	  29: 'se', 59: 'ps', 89: 'sw'
	},

	// ISO (deprecated)
	[], { // windows                                        
	  0x0436: 'af', 0x4009: 'en-IN', 0x0487: 'rw', 0x0432: 'tn',
	  0x041C: 'sq', 0x1809: 'en-IE', 0x0441: 'sw', 0x045B: 'si',
	  0x0484: 'gsw', 0x2009: 'en-JM', 0x0457: 'kok', 0x041B: 'sk',
	  0x045E: 'am', 0x4409: 'en-MY', 0x0412: 'ko', 0x0424: 'sl',
	  0x1401: 'ar-DZ', 0x1409: 'en-NZ', 0x0440: 'ky', 0x2C0A: 'es-AR',
	  0x3C01: 'ar-BH', 0x3409: 'en-PH', 0x0454: 'lo', 0x400A: 'es-BO',
	  0x0C01: 'ar', 0x4809: 'en-SG', 0x0426: 'lv', 0x340A: 'es-CL',
	  0x0801: 'ar-IQ', 0x1C09: 'en-ZA', 0x0427: 'lt', 0x240A: 'es-CO',
	  0x2C01: 'ar-JO', 0x2C09: 'en-TT', 0x082E: 'dsb', 0x140A: 'es-CR',
	  0x3401: 'ar-KW', 0x0809: 'en-GB', 0x046E: 'lb', 0x1C0A: 'es-DO',
	  0x3001: 'ar-LB', 0x0409: 'en', 0x042F: 'mk', 0x300A: 'es-EC',
	  0x1001: 'ar-LY', 0x3009: 'en-ZW', 0x083E: 'ms-BN', 0x440A: 'es-SV',
	  0x1801: 'ary', 0x0425: 'et', 0x043E: 'ms', 0x100A: 'es-GT',
	  0x2001: 'ar-OM', 0x0438: 'fo', 0x044C: 'ml', 0x480A: 'es-HN',
	  0x4001: 'ar-QA', 0x0464: 'fil', 0x043A: 'mt', 0x080A: 'es-MX',
	  0x0401: 'ar-SA', 0x040B: 'fi', 0x0481: 'mi', 0x4C0A: 'es-NI',
	  0x2801: 'ar-SY', 0x080C: 'fr-BE', 0x047A: 'arn', 0x180A: 'es-PA',
	  0x1C01: 'aeb', 0x0C0C: 'fr-CA', 0x044E: 'mr', 0x3C0A: 'es-PY',
	  0x3801: 'ar-AE', 0x040C: 'fr', 0x047C: 'moh', 0x280A: 'es-PE',
	  0x2401: 'ar-YE', 0x140C: 'fr-LU', 0x0450: 'mn', 0x500A: 'es-PR',
	  0x042B: 'hy', 0x180C: 'fr-MC', 0x0850: 'mn-CN', 0x0C0A: 'es',
	  0x044D: 'as', 0x100C: 'fr-CH', 0x0461: 'ne', 0x040A: 'es',
	  0x082C: 'az-Cyrl', 0x0462: 'fy', 0x0414: 'nb', 0x540A: 'es-US',
	  0x042C: 'az', 0x0456: 'gl', 0x0814: 'nn', 0x380A: 'es-UY',
	  0x046D: 'ba', 0x0437: 'ka', 0x0482: 'oc', 0x200A: 'es-VE',
	  0x042D: 'eu', 0x0C07: 'de-AT', 0x0448: 'or', 0x081D: 'sv-FI',
	  0x0423: 'be', 0x0407: 'de', 0x0463: 'ps', 0x041D: 'sv',
	  0x0845: 'bn', 0x1407: 'de-LI', 0x0415: 'pl', 0x045A: 'syr',
	  0x0445: 'bn-IN', 0x1007: 'de-LU', 0x0416: 'pt', 0x0428: 'tg',
	  0x201A: 'bs-Cyrl', 0x0807: 'de-CH', 0x0816: 'pt-PT', 0x085F: 'tzm',
	  0x141A: 'bs', 0x0408: 'el', 0x0446: 'pa', 0x0449: 'ta',
	  0x047E: 'br', 0x046F: 'kl', 0x046B: 'qu-BO', 0x0444: 'tt',
	  0x0402: 'bg', 0x0447: 'gu', 0x086B: 'qu-EC', 0x044A: 'te',
	  0x0403: 'ca', 0x0468: 'ha', 0x0C6B: 'qu', 0x041E: 'th',
	  0x0C04: 'zh-HK', 0x040D: 'he', 0x0418: 'ro', 0x0451: 'bo',
	  0x1404: 'zh-MO', 0x0439: 'hi', 0x0417: 'rm', 0x041F: 'tr',
	  0x0804: 'zh', 0x040E: 'hu', 0x0419: 'ru', 0x0442: 'tk',
	  0x1004: 'zh-SG', 0x040F: 'is', 0x243B: 'smn', 0x0480: 'ug',
	  0x0404: 'zh-TW', 0x0470: 'ig', 0x103B: 'smj-NO', 0x0422: 'uk',
	  0x0483: 'co', 0x0421: 'id', 0x143B: 'smj', 0x042E: 'hsb',
	  0x041A: 'hr', 0x045D: 'iu', 0x0C3B: 'se-FI', 0x0420: 'ur',
	  0x101A: 'hr-BA', 0x085D: 'iu-Latn', 0x043B: 'se', 0x0843: 'uz-Cyrl',
	  0x0405: 'cs', 0x083C: 'ga', 0x083B: 'se-SE', 0x0443: 'uz',
	  0x0406: 'da', 0x0434: 'xh', 0x203B: 'sms', 0x042A: 'vi',
	  0x048C: 'prs', 0x0435: 'zu', 0x183B: 'sma-NO', 0x0452: 'cy',
	  0x0465: 'dv', 0x0410: 'it', 0x1C3B: 'sms', 0x0488: 'wo',
	  0x0813: 'nl-BE', 0x0810: 'it-CH', 0x044F: 'sa', 0x0485: 'sah',
	  0x0413: 'nl', 0x0411: 'ja', 0x1C1A: 'sr-Cyrl-BA', 0x0478: 'ii',
	  0x0C09: 'en-AU', 0x044B: 'kn', 0x0C1A: 'sr', 0x046A: 'yo',
	  0x2809: 'en-BZ', 0x043F: 'kk', 0x181A: 'sr-Latn-BA',
	  0x1009: 'en-CA', 0x0453: 'km', 0x081A: 'sr-Latn',
	  0x2409: 'en-029', 0x0486: 'quc', 0x046C: 'nso'
	}];

	var NameRecord = new r.Struct({
	  platformID: r.uint16,
	  encodingID: r.uint16,
	  languageID: r.uint16,
	  nameID: r.uint16,
	  length: r.uint16,
	  string: new r.Pointer(r.uint16, new r.String('length', function (t) {
	    return getEncoding(t.platformID, t.encodingID, t.languageID);
	  }), { type: 'parent', relativeTo: 'parent.stringOffset', allowNull: false })
	});

	var LangTagRecord = new r.Struct({
	  length: r.uint16,
	  tag: new r.Pointer(r.uint16, new r.String('length', 'utf16be'), { type: 'parent', relativeTo: 'stringOffset' })
	});

	var NameTable = new r.VersionedStruct(r.uint16, {
	  0: {
	    count: r.uint16,
	    stringOffset: r.uint16,
	    records: new r.Array(NameRecord, 'count')
	  },
	  1: {
	    count: r.uint16,
	    stringOffset: r.uint16,
	    records: new r.Array(NameRecord, 'count'),
	    langTagCount: r.uint16,
	    langTags: new r.Array(LangTagRecord, 'langTagCount')
	  }
	});

	var NAMES = ['copyright', 'fontFamily', 'fontSubfamily', 'uniqueSubfamily', 'fullName', 'version', 'postscriptName', // Note: A font may have only one PostScript name and that name must be ASCII.
	'trademark', 'manufacturer', 'designer', 'description', 'vendorURL', 'designerURL', 'license', 'licenseURL', null, // reserved
	'preferredFamily', 'preferredSubfamily', 'compatibleFull', 'sampleText', 'postscriptCIDFontName', 'wwsFamilyName', 'wwsSubfamilyName'];

	NameTable.process = function (stream) {
	  var records = {};
	  for (var _iterator = this.records, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	    var _ref;

	    if (_isArray) {
	      if (_i >= _iterator.length) break;
	      _ref = _iterator[_i++];
	    } else {
	      _i = _iterator.next();
	      if (_i.done) break;
	      _ref = _i.value;
	    }

	    var record = _ref;

	    // find out what language this is for
	    var language = LANGUAGES[record.platformID][record.languageID];

	    if (language == null && this.langTags != null && record.languageID >= 0x8000) {
	      language = this.langTags[record.languageID - 0x8000].tag;
	    }

	    if (language == null) {
	      language = record.platformID + '-' + record.languageID;
	    }

	    // if the nameID is >= 256, it is a font feature record (AAT)
	    var key = record.nameID >= 256 ? 'fontFeatures' : NAMES[record.nameID] || record.nameID;
	    if (records[key] == null) {
	      records[key] = {};
	    }

	    var obj = records[key];
	    if (record.nameID >= 256) {
	      obj = obj[record.nameID] || (obj[record.nameID] = {});
	    }

	    if (typeof record.string === 'string' || typeof obj[language] !== 'string') {
	      obj[language] = record.string;
	    }
	  }

	  this.records = records;
	};

	NameTable.preEncode = function () {
	  if (Array.isArray(this.records)) return;
	  this.version = 0;

	  var records = [];
	  for (var key in this.records) {
	    var val = this.records[key];
	    if (key === 'fontFeatures') continue;

	    records.push({
	      platformID: 3,
	      encodingID: 1,
	      languageID: 0x409,
	      nameID: NAMES.indexOf(key),
	      length: Buffer.byteLength(val.en, 'utf16le'),
	      string: val.en
	    });

	    if (key === 'postscriptName') {
	      records.push({
	        platformID: 1,
	        encodingID: 0,
	        languageID: 0,
	        nameID: NAMES.indexOf(key),
	        length: val.en.length,
	        string: val.en
	      });
	    }
	  }

	  this.records = records;
	  this.count = records.length;
	  this.stringOffset = NameTable.size(this, null, false);
	};

	var OS2 = new r.VersionedStruct(r.uint16, {
	  header: {
	    xAvgCharWidth: r.int16, // average weighted advance width of lower case letters and space
	    usWeightClass: r.uint16, // visual weight of stroke in glyphs
	    usWidthClass: r.uint16, // relative change from the normal aspect ratio (width to height ratio)
	    fsType: new r.Bitfield(r.uint16, [// Indicates font embedding licensing rights
	    null, 'noEmbedding', 'viewOnly', 'editable', null, null, null, null, 'noSubsetting', 'bitmapOnly']),
	    ySubscriptXSize: r.int16, // recommended horizontal size in pixels for subscripts
	    ySubscriptYSize: r.int16, // recommended vertical size in pixels for subscripts
	    ySubscriptXOffset: r.int16, // recommended horizontal offset for subscripts
	    ySubscriptYOffset: r.int16, // recommended vertical offset form the baseline for subscripts
	    ySuperscriptXSize: r.int16, // recommended horizontal size in pixels for superscripts
	    ySuperscriptYSize: r.int16, // recommended vertical size in pixels for superscripts
	    ySuperscriptXOffset: r.int16, // recommended horizontal offset for superscripts
	    ySuperscriptYOffset: r.int16, // recommended vertical offset from the baseline for superscripts
	    yStrikeoutSize: r.int16, // width of the strikeout stroke
	    yStrikeoutPosition: r.int16, // position of the strikeout stroke relative to the baseline
	    sFamilyClass: r.int16, // classification of font-family design
	    panose: new r.Array(r.uint8, 10), // describe the visual characteristics of a given typeface
	    ulCharRange: new r.Array(r.uint32, 4),
	    vendorID: new r.String(4), // four character identifier for the font vendor
	    fsSelection: new r.Bitfield(r.uint16, [// bit field containing information about the font
	    'italic', 'underscore', 'negative', 'outlined', 'strikeout', 'bold', 'regular', 'useTypoMetrics', 'wws', 'oblique']),
	    usFirstCharIndex: r.uint16, // The minimum Unicode index in this font
	    usLastCharIndex: r.uint16 // The maximum Unicode index in this font
	  },

	  // The Apple version of this table ends here, but the Microsoft one continues on...
	  0: {},

	  1: {
	    typoAscender: r.int16,
	    typoDescender: r.int16,
	    typoLineGap: r.int16,
	    winAscent: r.uint16,
	    winDescent: r.uint16,
	    codePageRange: new r.Array(r.uint32, 2)
	  },

	  2: {
	    // these should be common with version 1 somehow
	    typoAscender: r.int16,
	    typoDescender: r.int16,
	    typoLineGap: r.int16,
	    winAscent: r.uint16,
	    winDescent: r.uint16,
	    codePageRange: new r.Array(r.uint32, 2),

	    xHeight: r.int16,
	    capHeight: r.int16,
	    defaultChar: r.uint16,
	    breakChar: r.uint16,
	    maxContent: r.uint16
	  },

	  5: {
	    typoAscender: r.int16,
	    typoDescender: r.int16,
	    typoLineGap: r.int16,
	    winAscent: r.uint16,
	    winDescent: r.uint16,
	    codePageRange: new r.Array(r.uint32, 2),

	    xHeight: r.int16,
	    capHeight: r.int16,
	    defaultChar: r.uint16,
	    breakChar: r.uint16,
	    maxContent: r.uint16,

	    usLowerOpticalPointSize: r.uint16,
	    usUpperOpticalPointSize: r.uint16
	  }
	});

	var versions = OS2.versions;
	versions[3] = versions[4] = versions[2];

	// PostScript information
	var post = new r.VersionedStruct(r.fixed32, {
	  header: { // these fields exist at the top of all versions
	    italicAngle: r.fixed32, // Italic angle in counter-clockwise degrees from the vertical.
	    underlinePosition: r.int16, // Suggested distance of the top of the underline from the baseline
	    underlineThickness: r.int16, // Suggested values for the underline thickness
	    isFixedPitch: r.uint32, // Whether the font is monospaced
	    minMemType42: r.uint32, // Minimum memory usage when a TrueType font is downloaded as a Type 42 font
	    maxMemType42: r.uint32, // Maximum memory usage when a TrueType font is downloaded as a Type 42 font
	    minMemType1: r.uint32, // Minimum memory usage when a TrueType font is downloaded as a Type 1 font
	    maxMemType1: r.uint32 // Maximum memory usage when a TrueType font is downloaded as a Type 1 font
	  },

	  1: {}, // version 1 has no additional fields

	  2: {
	    numberOfGlyphs: r.uint16,
	    glyphNameIndex: new r.Array(r.uint16, 'numberOfGlyphs'),
	    names: new r.Array(new r.String(r.uint8))
	  },

	  2.5: {
	    numberOfGlyphs: r.uint16,
	    offsets: new r.Array(r.uint8, 'numberOfGlyphs')
	  },

	  3: {}, // version 3 has no additional fields

	  4: {
	    map: new r.Array(r.uint32, function (t) {
	      return t.parent.maxp.numGlyphs;
	    })
	  }
	});

	// An array of predefined values accessible by instructions
	var cvt = new r.Struct({
	  controlValues: new r.Array(r.int16)
	});

	// A list of instructions that are executed once when a font is first used.
	// These instructions are known as the font program. The main use of this table
	// is for the definition of functions that are used in many different glyph programs.
	var fpgm = new r.Struct({
	  instructions: new r.Array(r.uint8)
	});

	var loca = new r.VersionedStruct('head.indexToLocFormat', {
	  0: {
	    offsets: new r.Array(r.uint16)
	  },
	  1: {
	    offsets: new r.Array(r.uint32)
	  }
	});

	loca.process = function () {
	  if (this.version === 0) {
	    for (var i = 0; i < this.offsets.length; i++) {
	      this.offsets[i] <<= 1;
	    }
	  }
	};

	loca.preEncode = function () {
	  if (this.version != null) return;

	  // assume this.offsets is a sorted array
	  this.version = this.offsets[this.offsets.length - 1] > 0xffff ? 1 : 0;

	  if (this.version === 0) {
	    for (var i = 0; i < this.offsets.length; i++) {
	      this.offsets[i] >>>= 1;
	    }
	  }
	};

	// Set of instructions executed whenever the point size or font transformation change
	var prep = new r.Struct({
	  controlValueProgram: new r.Array(r.uint8)
	});

	// only used for encoding
	var glyf = new r.Array(new r.Buffer());

	var CFFIndex = function () {
	  function CFFIndex(type) {
	    _classCallCheck(this, CFFIndex);

	    this.type = type;
	  }

	  CFFIndex.prototype.getCFFVersion = function getCFFVersion(ctx) {
	    while (ctx && !ctx.hdrSize) {
	      ctx = ctx.parent;
	    }

	    return ctx ? ctx.version : -1;
	  };

	  CFFIndex.prototype.decode = function decode(stream, parent) {
	    var version = this.getCFFVersion(parent);
	    var count = version >= 2 ? stream.readUInt32BE() : stream.readUInt16BE();

	    if (count === 0) {
	      return [];
	    }

	    var offSize = stream.readUInt8();
	    var offsetType = void 0;
	    if (offSize === 1) {
	      offsetType = r.uint8;
	    } else if (offSize === 2) {
	      offsetType = r.uint16;
	    } else if (offSize === 3) {
	      offsetType = r.uint24;
	    } else if (offSize === 4) {
	      offsetType = r.uint32;
	    } else {
	      throw new Error("Bad offset size in CFFIndex: " + offSize + " " + stream.pos);
	    }

	    var ret = [];
	    var startPos = stream.pos + (count + 1) * offSize - 1;

	    var start = offsetType.decode(stream);
	    for (var i = 0; i < count; i++) {
	      var end = offsetType.decode(stream);

	      if (this.type != null) {
	        var pos = stream.pos;
	        stream.pos = startPos + start;

	        parent.length = end - start;
	        ret.push(this.type.decode(stream, parent));
	        stream.pos = pos;
	      } else {
	        ret.push({
	          offset: startPos + start,
	          length: end - start
	        });
	      }

	      start = end;
	    }

	    stream.pos = startPos + start;
	    return ret;
	  };

	  CFFIndex.prototype.size = function size(arr, parent) {
	    var size = 2;
	    if (arr.length === 0) {
	      return size;
	    }

	    var type = this.type || new r.Buffer();

	    // find maximum offset to detminine offset type
	    var offset = 1;
	    for (var i = 0; i < arr.length; i++) {
	      var item = arr[i];
	      offset += type.size(item, parent);
	    }

	    var offsetType = void 0;
	    if (offset <= 0xff) {
	      offsetType = r.uint8;
	    } else if (offset <= 0xffff) {
	      offsetType = r.uint16;
	    } else if (offset <= 0xffffff) {
	      offsetType = r.uint24;
	    } else if (offset <= 0xffffffff) {
	      offsetType = r.uint32;
	    } else {
	      throw new Error("Bad offset in CFFIndex");
	    }

	    size += 1 + offsetType.size() * (arr.length + 1);
	    size += offset - 1;

	    return size;
	  };

	  CFFIndex.prototype.encode = function encode(stream, arr, parent) {
	    stream.writeUInt16BE(arr.length);
	    if (arr.length === 0) {
	      return;
	    }

	    var type = this.type || new r.Buffer();

	    // find maximum offset to detminine offset type
	    var sizes = [];
	    var offset = 1;
	    for (var _iterator = arr, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var item = _ref;

	      var s = type.size(item, parent);
	      sizes.push(s);
	      offset += s;
	    }

	    var offsetType = void 0;
	    if (offset <= 0xff) {
	      offsetType = r.uint8;
	    } else if (offset <= 0xffff) {
	      offsetType = r.uint16;
	    } else if (offset <= 0xffffff) {
	      offsetType = r.uint24;
	    } else if (offset <= 0xffffffff) {
	      offsetType = r.uint32;
	    } else {
	      throw new Error("Bad offset in CFFIndex");
	    }

	    // write offset size
	    stream.writeUInt8(offsetType.size());

	    // write elements
	    offset = 1;
	    offsetType.encode(stream, offset);

	    for (var _iterator2 = sizes, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	      var _ref2;

	      if (_isArray2) {
	        if (_i2 >= _iterator2.length) break;
	        _ref2 = _iterator2[_i2++];
	      } else {
	        _i2 = _iterator2.next();
	        if (_i2.done) break;
	        _ref2 = _i2.value;
	      }

	      var size = _ref2;

	      offset += size;
	      offsetType.encode(stream, offset);
	    }

	    for (var _iterator3 = arr, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	      var _ref3;

	      if (_isArray3) {
	        if (_i3 >= _iterator3.length) break;
	        _ref3 = _iterator3[_i3++];
	      } else {
	        _i3 = _iterator3.next();
	        if (_i3.done) break;
	        _ref3 = _i3.value;
	      }

	      var _item = _ref3;

	      type.encode(stream, _item, parent);
	    }

	    return;
	  };

	  return CFFIndex;
	}();

	var FLOAT_EOF = 0xf;
	var FLOAT_LOOKUP = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', 'E', 'E-', null, '-'];

	var FLOAT_ENCODE_LOOKUP = {
	  '.': 10,
	  'E': 11,
	  'E-': 12,
	  '-': 14
	};

	var CFFOperand = function () {
	  function CFFOperand() {
	    _classCallCheck(this, CFFOperand);
	  }

	  CFFOperand.decode = function decode(stream, value) {
	    if (32 <= value && value <= 246) {
	      return value - 139;
	    }

	    if (247 <= value && value <= 250) {
	      return (value - 247) * 256 + stream.readUInt8() + 108;
	    }

	    if (251 <= value && value <= 254) {
	      return -(value - 251) * 256 - stream.readUInt8() - 108;
	    }

	    if (value === 28) {
	      return stream.readInt16BE();
	    }

	    if (value === 29) {
	      return stream.readInt32BE();
	    }

	    if (value === 30) {
	      var str = '';
	      while (true) {
	        var b = stream.readUInt8();

	        var n1 = b >> 4;
	        if (n1 === FLOAT_EOF) {
	          break;
	        }
	        str += FLOAT_LOOKUP[n1];

	        var n2 = b & 15;
	        if (n2 === FLOAT_EOF) {
	          break;
	        }
	        str += FLOAT_LOOKUP[n2];
	      }

	      return parseFloat(str);
	    }

	    return null;
	  };

	  CFFOperand.size = function size(value) {
	    // if the value needs to be forced to the largest size (32 bit)
	    // e.g. for unknown pointers, set to 32768
	    if (value.forceLarge) {
	      value = 32768;
	    }

	    if ((value | 0) !== value) {
	      // floating point
	      var str = '' + value;
	      return 1 + Math.ceil((str.length + 1) / 2);
	    } else if (-107 <= value && value <= 107) {
	      return 1;
	    } else if (108 <= value && value <= 1131 || -1131 <= value && value <= -108) {
	      return 2;
	    } else if (-32768 <= value && value <= 32767) {
	      return 3;
	    } else {
	      return 5;
	    }
	  };

	  CFFOperand.encode = function encode(stream, value) {
	    // if the value needs to be forced to the largest size (32 bit)
	    // e.g. for unknown pointers, save the old value and set to 32768
	    var val = Number(value);

	    if (value.forceLarge) {
	      stream.writeUInt8(29);
	      return stream.writeInt32BE(val);
	    } else if ((val | 0) !== val) {
	      // floating point
	      stream.writeUInt8(30);

	      var str = '' + val;
	      for (var i = 0; i < str.length; i += 2) {
	        var c1 = str[i];
	        var n1 = FLOAT_ENCODE_LOOKUP[c1] || +c1;

	        if (i === str.length - 1) {
	          var n2 = FLOAT_EOF;
	        } else {
	          var c2 = str[i + 1];
	          var n2 = FLOAT_ENCODE_LOOKUP[c2] || +c2;
	        }

	        stream.writeUInt8(n1 << 4 | n2 & 15);
	      }

	      if (n2 !== FLOAT_EOF) {
	        return stream.writeUInt8(FLOAT_EOF << 4);
	      }
	    } else if (-107 <= val && val <= 107) {
	      return stream.writeUInt8(val + 139);
	    } else if (108 <= val && val <= 1131) {
	      val -= 108;
	      stream.writeUInt8((val >> 8) + 247);
	      return stream.writeUInt8(val & 0xff);
	    } else if (-1131 <= val && val <= -108) {
	      val = -val - 108;
	      stream.writeUInt8((val >> 8) + 251);
	      return stream.writeUInt8(val & 0xff);
	    } else if (-32768 <= val && val <= 32767) {
	      stream.writeUInt8(28);
	      return stream.writeInt16BE(val);
	    } else {
	      stream.writeUInt8(29);
	      return stream.writeInt32BE(val);
	    }
	  };

	  return CFFOperand;
	}();

	var CFFDict = function () {
	  function CFFDict() {
	    var ops = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

	    _classCallCheck(this, CFFDict);

	    this.ops = ops;
	    this.fields = {};
	    for (var _iterator = ops, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var field = _ref;

	      var key = Array.isArray(field[0]) ? field[0][0] << 8 | field[0][1] : field[0];
	      this.fields[key] = field;
	    }
	  }

	  CFFDict.prototype.decodeOperands = function decodeOperands(type, stream, ret, operands) {
	    var _this = this;

	    if (Array.isArray(type)) {
	      return operands.map(function (op, i) {
	        return _this.decodeOperands(type[i], stream, ret, [op]);
	      });
	    } else if (type.decode != null) {
	      return type.decode(stream, ret, operands);
	    } else {
	      switch (type) {
	        case 'number':
	        case 'offset':
	        case 'sid':
	          return operands[0];
	        case 'boolean':
	          return !!operands[0];
	        default:
	          return operands;
	      }
	    }
	  };

	  CFFDict.prototype.encodeOperands = function encodeOperands(type, stream, ctx, operands) {
	    var _this2 = this;

	    if (Array.isArray(type)) {
	      return operands.map(function (op, i) {
	        return _this2.encodeOperands(type[i], stream, ctx, op)[0];
	      });
	    } else if (type.encode != null) {
	      return type.encode(stream, operands, ctx);
	    } else if (typeof operands === 'number') {
	      return [operands];
	    } else if (typeof operands === 'boolean') {
	      return [+operands];
	    } else if (Array.isArray(operands)) {
	      return operands;
	    } else {
	      return [operands];
	    }
	  };

	  CFFDict.prototype.decode = function decode(stream, parent) {
	    var end = stream.pos + parent.length;
	    var ret = {};
	    var operands = [];

	    // define hidden properties
	    _Object$defineProperties(ret, {
	      parent: { value: parent },
	      _startOffset: { value: stream.pos }
	    });

	    // fill in defaults
	    for (var key in this.fields) {
	      var field = this.fields[key];
	      ret[field[1]] = field[3];
	    }

	    while (stream.pos < end) {
	      var b = stream.readUInt8();
	      if (b < 28) {
	        if (b === 12) {
	          b = b << 8 | stream.readUInt8();
	        }

	        var _field = this.fields[b];
	        if (!_field) {
	          throw new Error('Unknown operator ' + b);
	        }

	        var val = this.decodeOperands(_field[2], stream, ret, operands);
	        if (val != null) {
	          if (val instanceof restructure_src_utils.PropertyDescriptor) {
	            _Object$defineProperty(ret, _field[1], val);
	          } else {
	            ret[_field[1]] = val;
	          }
	        }

	        operands = [];
	      } else {
	        operands.push(CFFOperand.decode(stream, b));
	      }
	    }

	    return ret;
	  };

	  CFFDict.prototype.size = function size(dict, parent) {
	    var includePointers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

	    var ctx = {
	      parent: parent,
	      val: dict,
	      pointerSize: 0,
	      startOffset: parent.startOffset || 0
	    };

	    var len = 0;

	    for (var k in this.fields) {
	      var field = this.fields[k];
	      var val = dict[field[1]];
	      if (val == null || isEqual(val, field[3])) {
	        continue;
	      }

	      var operands = this.encodeOperands(field[2], null, ctx, val);
	      for (var _iterator2 = operands, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	        var _ref2;

	        if (_isArray2) {
	          if (_i2 >= _iterator2.length) break;
	          _ref2 = _iterator2[_i2++];
	        } else {
	          _i2 = _iterator2.next();
	          if (_i2.done) break;
	          _ref2 = _i2.value;
	        }

	        var op = _ref2;

	        len += CFFOperand.size(op);
	      }

	      var key = Array.isArray(field[0]) ? field[0] : [field[0]];
	      len += key.length;
	    }

	    if (includePointers) {
	      len += ctx.pointerSize;
	    }

	    return len;
	  };

	  CFFDict.prototype.encode = function encode(stream, dict, parent) {
	    var ctx = {
	      pointers: [],
	      startOffset: stream.pos,
	      parent: parent,
	      val: dict,
	      pointerSize: 0
	    };

	    ctx.pointerOffset = stream.pos + this.size(dict, ctx, false);

	    for (var _iterator3 = this.ops, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	      var _ref3;

	      if (_isArray3) {
	        if (_i3 >= _iterator3.length) break;
	        _ref3 = _iterator3[_i3++];
	      } else {
	        _i3 = _iterator3.next();
	        if (_i3.done) break;
	        _ref3 = _i3.value;
	      }

	      var field = _ref3;

	      var val = dict[field[1]];
	      if (val == null || isEqual(val, field[3])) {
	        continue;
	      }

	      var operands = this.encodeOperands(field[2], stream, ctx, val);
	      for (var _iterator4 = operands, _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : _getIterator(_iterator4);;) {
	        var _ref4;

	        if (_isArray4) {
	          if (_i4 >= _iterator4.length) break;
	          _ref4 = _iterator4[_i4++];
	        } else {
	          _i4 = _iterator4.next();
	          if (_i4.done) break;
	          _ref4 = _i4.value;
	        }

	        var op = _ref4;

	        CFFOperand.encode(stream, op);
	      }

	      var key = Array.isArray(field[0]) ? field[0] : [field[0]];
	      for (var _iterator5 = key, _isArray5 = Array.isArray(_iterator5), _i5 = 0, _iterator5 = _isArray5 ? _iterator5 : _getIterator(_iterator5);;) {
	        var _ref5;

	        if (_isArray5) {
	          if (_i5 >= _iterator5.length) break;
	          _ref5 = _iterator5[_i5++];
	        } else {
	          _i5 = _iterator5.next();
	          if (_i5.done) break;
	          _ref5 = _i5.value;
	        }

	        var _op = _ref5;

	        stream.writeUInt8(_op);
	      }
	    }

	    var i = 0;
	    while (i < ctx.pointers.length) {
	      var ptr = ctx.pointers[i++];
	      ptr.type.encode(stream, ptr.val, ptr.parent);
	    }

	    return;
	  };

	  return CFFDict;
	}();

	var CFFPointer = function (_r$Pointer) {
	  _inherits(CFFPointer, _r$Pointer);

	  function CFFPointer(type) {
	    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    _classCallCheck(this, CFFPointer);

	    if (options.type == null) {
	      options.type = 'global';
	    }

	    return _possibleConstructorReturn(this, _r$Pointer.call(this, null, type, options));
	  }

	  CFFPointer.prototype.decode = function decode(stream, parent, operands) {
	    this.offsetType = {
	      decode: function decode() {
	        return operands[0];
	      }
	    };

	    return _r$Pointer.prototype.decode.call(this, stream, parent, operands);
	  };

	  CFFPointer.prototype.encode = function encode(stream, value, ctx) {
	    if (!stream) {
	      // compute the size (so ctx.pointerSize is correct)
	      this.offsetType = {
	        size: function size() {
	          return 0;
	        }
	      };

	      this.size(value, ctx);
	      return [new Ptr(0)];
	    }

	    var ptr = null;
	    this.offsetType = {
	      encode: function encode(stream, val) {
	        return ptr = val;
	      }
	    };

	    _r$Pointer.prototype.encode.call(this, stream, value, ctx);
	    return [new Ptr(ptr)];
	  };

	  return CFFPointer;
	}(r.Pointer);

	var Ptr = function () {
	  function Ptr(val) {
	    _classCallCheck(this, Ptr);

	    this.val = val;
	    this.forceLarge = true;
	  }

	  Ptr.prototype.valueOf = function valueOf() {
	    return this.val;
	  };

	  return Ptr;
	}();

	var CFFBlendOp = function () {
	  function CFFBlendOp() {
	    _classCallCheck(this, CFFBlendOp);
	  }

	  CFFBlendOp.decode = function decode(stream, parent, operands) {
	    var numBlends = operands.pop();

	    // TODO: actually blend. For now just consume the deltas
	    // since we don't use any of the values anyway.
	    while (operands.length > numBlends) {
	      operands.pop();
	    }
	  };

	  return CFFBlendOp;
	}();

	var CFFPrivateDict = new CFFDict([
	// key       name                    type                                          default
	[6, 'BlueValues', 'delta', null], [7, 'OtherBlues', 'delta', null], [8, 'FamilyBlues', 'delta', null], [9, 'FamilyOtherBlues', 'delta', null], [[12, 9], 'BlueScale', 'number', 0.039625], [[12, 10], 'BlueShift', 'number', 7], [[12, 11], 'BlueFuzz', 'number', 1], [10, 'StdHW', 'number', null], [11, 'StdVW', 'number', null], [[12, 12], 'StemSnapH', 'delta', null], [[12, 13], 'StemSnapV', 'delta', null], [[12, 14], 'ForceBold', 'boolean', false], [[12, 17], 'LanguageGroup', 'number', 0], [[12, 18], 'ExpansionFactor', 'number', 0.06], [[12, 19], 'initialRandomSeed', 'number', 0], [20, 'defaultWidthX', 'number', 0], [21, 'nominalWidthX', 'number', 0], [22, 'vsindex', 'number', 0], [23, 'blend', CFFBlendOp, null], [19, 'Subrs', new CFFPointer(new CFFIndex(), { type: 'local' }), null]]);

	// Automatically generated from Appendix A of the CFF specification; do
	// not edit. Length should be 391.
	var standardStrings = [".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"];

	var StandardEncoding = ['', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quoteright', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'exclamdown', 'cent', 'sterling', 'fraction', 'yen', 'florin', 'section', 'currency', 'quotesingle', 'quotedblleft', 'guillemotleft', 'guilsinglleft', 'guilsinglright', 'fi', 'fl', '', 'endash', 'dagger', 'daggerdbl', 'periodcentered', '', 'paragraph', 'bullet', 'quotesinglbase', 'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis', 'perthousand', '', 'questiondown', '', 'grave', 'acute', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccent', 'dieresis', '', 'ring', 'cedilla', '', 'hungarumlaut', 'ogonek', 'caron', 'emdash', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'AE', '', 'ordfeminine', '', '', '', '', 'Lslash', 'Oslash', 'OE', 'ordmasculine', '', '', '', '', '', 'ae', '', '', '', 'dotlessi', '', '', 'lslash', 'oslash', 'oe', 'germandbls'];

	var ExpertEncoding = ['', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'space', 'exclamsmall', 'Hungarumlautsmall', '', 'dollaroldstyle', 'dollarsuperior', 'ampersandsmall', 'Acutesmall', 'parenleftsuperior', 'parenrightsuperior', 'twodotenleader', 'onedotenleader', 'comma', 'hyphen', 'period', 'fraction', 'zerooldstyle', 'oneoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'colon', 'semicolon', 'commasuperior', 'threequartersemdash', 'periodsuperior', 'questionsmall', '', 'asuperior', 'bsuperior', 'centsuperior', 'dsuperior', 'esuperior', '', '', 'isuperior', '', '', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', '', '', 'rsuperior', 'ssuperior', 'tsuperior', '', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior', '', 'parenrightinferior', 'Circumflexsmall', 'hyphensuperior', 'Gravesmall', 'Asmall', 'Bsmall', 'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall', 'Hsmall', 'Ismall', 'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall', 'Osmall', 'Psmall', 'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall', 'Vsmall', 'Wsmall', 'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary', 'onefitted', 'rupiah', 'Tildesmall', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'exclamdownsmall', 'centoldstyle', 'Lslashsmall', '', '', 'Scaronsmall', 'Zcaronsmall', 'Dieresissmall', 'Brevesmall', 'Caronsmall', '', 'Dotaccentsmall', '', '', 'Macronsmall', '', '', 'figuredash', 'hypheninferior', '', '', 'Ogoneksmall', 'Ringsmall', 'Cedillasmall', '', '', '', 'onequarter', 'onehalf', 'threequarters', 'questiondownsmall', 'oneeighth', 'threeeighths', 'fiveeighths', 'seveneighths', 'onethird', 'twothirds', '', '', 'zerosuperior', 'onesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', 'oneinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'centinferior', 'dollarinferior', 'periodinferior', 'commainferior', 'Agravesmall', 'Aacutesmall', 'Acircumflexsmall', 'Atildesmall', 'Adieresissmall', 'Aringsmall', 'AEsmall', 'Ccedillasmall', 'Egravesmall', 'Eacutesmall', 'Ecircumflexsmall', 'Edieresissmall', 'Igravesmall', 'Iacutesmall', 'Icircumflexsmall', 'Idieresissmall', 'Ethsmall', 'Ntildesmall', 'Ogravesmall', 'Oacutesmall', 'Ocircumflexsmall', 'Otildesmall', 'Odieresissmall', 'OEsmall', 'Oslashsmall', 'Ugravesmall', 'Uacutesmall', 'Ucircumflexsmall', 'Udieresissmall', 'Yacutesmall', 'Thornsmall', 'Ydieresissmall'];

	var ISOAdobeCharset = ['.notdef', 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quoteright', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'exclamdown', 'cent', 'sterling', 'fraction', 'yen', 'florin', 'section', 'currency', 'quotesingle', 'quotedblleft', 'guillemotleft', 'guilsinglleft', 'guilsinglright', 'fi', 'fl', 'endash', 'dagger', 'daggerdbl', 'periodcentered', 'paragraph', 'bullet', 'quotesinglbase', 'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis', 'perthousand', 'questiondown', 'grave', 'acute', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccent', 'dieresis', 'ring', 'cedilla', 'hungarumlaut', 'ogonek', 'caron', 'emdash', 'AE', 'ordfeminine', 'Lslash', 'Oslash', 'OE', 'ordmasculine', 'ae', 'dotlessi', 'lslash', 'oslash', 'oe', 'germandbls', 'onesuperior', 'logicalnot', 'mu', 'trademark', 'Eth', 'onehalf', 'plusminus', 'Thorn', 'onequarter', 'divide', 'brokenbar', 'degree', 'thorn', 'threequarters', 'twosuperior', 'registered', 'minus', 'eth', 'multiply', 'threesuperior', 'copyright', 'Aacute', 'Acircumflex', 'Adieresis', 'Agrave', 'Aring', 'Atilde', 'Ccedilla', 'Eacute', 'Ecircumflex', 'Edieresis', 'Egrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Igrave', 'Ntilde', 'Oacute', 'Ocircumflex', 'Odieresis', 'Ograve', 'Otilde', 'Scaron', 'Uacute', 'Ucircumflex', 'Udieresis', 'Ugrave', 'Yacute', 'Ydieresis', 'Zcaron', 'aacute', 'acircumflex', 'adieresis', 'agrave', 'aring', 'atilde', 'ccedilla', 'eacute', 'ecircumflex', 'edieresis', 'egrave', 'iacute', 'icircumflex', 'idieresis', 'igrave', 'ntilde', 'oacute', 'ocircumflex', 'odieresis', 'ograve', 'otilde', 'scaron', 'uacute', 'ucircumflex', 'udieresis', 'ugrave', 'yacute', 'ydieresis', 'zcaron'];

	var ExpertCharset = ['.notdef', 'space', 'exclamsmall', 'Hungarumlautsmall', 'dollaroldstyle', 'dollarsuperior', 'ampersandsmall', 'Acutesmall', 'parenleftsuperior', 'parenrightsuperior', 'twodotenleader', 'onedotenleader', 'comma', 'hyphen', 'period', 'fraction', 'zerooldstyle', 'oneoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'colon', 'semicolon', 'commasuperior', 'threequartersemdash', 'periodsuperior', 'questionsmall', 'asuperior', 'bsuperior', 'centsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior', 'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior', 'parenrightinferior', 'Circumflexsmall', 'hyphensuperior', 'Gravesmall', 'Asmall', 'Bsmall', 'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall', 'Hsmall', 'Ismall', 'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall', 'Osmall', 'Psmall', 'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall', 'Vsmall', 'Wsmall', 'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary', 'onefitted', 'rupiah', 'Tildesmall', 'exclamdownsmall', 'centoldstyle', 'Lslashsmall', 'Scaronsmall', 'Zcaronsmall', 'Dieresissmall', 'Brevesmall', 'Caronsmall', 'Dotaccentsmall', 'Macronsmall', 'figuredash', 'hypheninferior', 'Ogoneksmall', 'Ringsmall', 'Cedillasmall', 'onequarter', 'onehalf', 'threequarters', 'questiondownsmall', 'oneeighth', 'threeeighths', 'fiveeighths', 'seveneighths', 'onethird', 'twothirds', 'zerosuperior', 'onesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', 'oneinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'centinferior', 'dollarinferior', 'periodinferior', 'commainferior', 'Agravesmall', 'Aacutesmall', 'Acircumflexsmall', 'Atildesmall', 'Adieresissmall', 'Aringsmall', 'AEsmall', 'Ccedillasmall', 'Egravesmall', 'Eacutesmall', 'Ecircumflexsmall', 'Edieresissmall', 'Igravesmall', 'Iacutesmall', 'Icircumflexsmall', 'Idieresissmall', 'Ethsmall', 'Ntildesmall', 'Ogravesmall', 'Oacutesmall', 'Ocircumflexsmall', 'Otildesmall', 'Odieresissmall', 'OEsmall', 'Oslashsmall', 'Ugravesmall', 'Uacutesmall', 'Ucircumflexsmall', 'Udieresissmall', 'Yacutesmall', 'Thornsmall', 'Ydieresissmall'];

	var ExpertSubsetCharset = ['.notdef', 'space', 'dollaroldstyle', 'dollarsuperior', 'parenleftsuperior', 'parenrightsuperior', 'twodotenleader', 'onedotenleader', 'comma', 'hyphen', 'period', 'fraction', 'zerooldstyle', 'oneoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'colon', 'semicolon', 'commasuperior', 'threequartersemdash', 'periodsuperior', 'asuperior', 'bsuperior', 'centsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior', 'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior', 'parenrightinferior', 'hyphensuperior', 'colonmonetary', 'onefitted', 'rupiah', 'centoldstyle', 'figuredash', 'hypheninferior', 'onequarter', 'onehalf', 'threequarters', 'oneeighth', 'threeeighths', 'fiveeighths', 'seveneighths', 'onethird', 'twothirds', 'zerosuperior', 'onesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', 'oneinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'centinferior', 'dollarinferior', 'periodinferior', 'commainferior'];

	//########################
	// Scripts and Languages #
	//########################

	var LangSysTable = new r.Struct({
	  reserved: new r.Reserved(r.uint16),
	  reqFeatureIndex: r.uint16,
	  featureCount: r.uint16,
	  featureIndexes: new r.Array(r.uint16, 'featureCount')
	});

	var LangSysRecord = new r.Struct({
	  tag: new r.String(4),
	  langSys: new r.Pointer(r.uint16, LangSysTable, { type: 'parent' })
	});

	var Script = new r.Struct({
	  defaultLangSys: new r.Pointer(r.uint16, LangSysTable),
	  count: r.uint16,
	  langSysRecords: new r.Array(LangSysRecord, 'count')
	});

	var ScriptRecord = new r.Struct({
	  tag: new r.String(4),
	  script: new r.Pointer(r.uint16, Script, { type: 'parent' })
	});

	var ScriptList = new r.Array(ScriptRecord, r.uint16);

	//#######################
	// Features and Lookups #
	//#######################

	var Feature = new r.Struct({
	  featureParams: r.uint16, // pointer
	  lookupCount: r.uint16,
	  lookupListIndexes: new r.Array(r.uint16, 'lookupCount')
	});

	var FeatureRecord = new r.Struct({
	  tag: new r.String(4),
	  feature: new r.Pointer(r.uint16, Feature, { type: 'parent' })
	});

	var FeatureList = new r.Array(FeatureRecord, r.uint16);

	var LookupFlags = new r.Struct({
	  markAttachmentType: r.uint8,
	  flags: new r.Bitfield(r.uint8, ['rightToLeft', 'ignoreBaseGlyphs', 'ignoreLigatures', 'ignoreMarks', 'useMarkFilteringSet'])
	});

	function LookupList(SubTable) {
	  var Lookup = new r.Struct({
	    lookupType: r.uint16,
	    flags: LookupFlags,
	    subTableCount: r.uint16,
	    subTables: new r.Array(new r.Pointer(r.uint16, SubTable), 'subTableCount'),
	    markFilteringSet: new r.Optional(r.uint16, function (t) {
	      return t.flags.flags.useMarkFilteringSet;
	    })
	  });

	  return new r.LazyArray(new r.Pointer(r.uint16, Lookup), r.uint16);
	}

	//#################
	// Coverage Table #
	//#################

	var RangeRecord = new r.Struct({
	  start: r.uint16,
	  end: r.uint16,
	  startCoverageIndex: r.uint16
	});

	var Coverage = new r.VersionedStruct(r.uint16, {
	  1: {
	    glyphCount: r.uint16,
	    glyphs: new r.Array(r.uint16, 'glyphCount')
	  },
	  2: {
	    rangeCount: r.uint16,
	    rangeRecords: new r.Array(RangeRecord, 'rangeCount')
	  }
	});

	//#########################
	// Class Definition Table #
	//#########################

	var ClassRangeRecord = new r.Struct({
	  start: r.uint16,
	  end: r.uint16,
	  class: r.uint16
	});

	var ClassDef = new r.VersionedStruct(r.uint16, {
	  1: { // Class array
	    startGlyph: r.uint16,
	    glyphCount: r.uint16,
	    classValueArray: new r.Array(r.uint16, 'glyphCount')
	  },
	  2: { // Class ranges
	    classRangeCount: r.uint16,
	    classRangeRecord: new r.Array(ClassRangeRecord, 'classRangeCount')
	  }
	});

	//###############
	// Device Table #
	//###############

	var Device = new r.Struct({
	  a: r.uint16, // startSize for hinting Device, outerIndex for VariationIndex
	  b: r.uint16, // endSize for Device, innerIndex for VariationIndex
	  deltaFormat: r.uint16
	});

	//#############################################
	// Contextual Substitution/Positioning Tables #
	//#############################################

	var LookupRecord = new r.Struct({
	  sequenceIndex: r.uint16,
	  lookupListIndex: r.uint16
	});

	var Rule = new r.Struct({
	  glyphCount: r.uint16,
	  lookupCount: r.uint16,
	  input: new r.Array(r.uint16, function (t) {
	    return t.glyphCount - 1;
	  }),
	  lookupRecords: new r.Array(LookupRecord, 'lookupCount')
	});

	var RuleSet = new r.Array(new r.Pointer(r.uint16, Rule), r.uint16);

	var ClassRule = new r.Struct({
	  glyphCount: r.uint16,
	  lookupCount: r.uint16,
	  classes: new r.Array(r.uint16, function (t) {
	    return t.glyphCount - 1;
	  }),
	  lookupRecords: new r.Array(LookupRecord, 'lookupCount')
	});

	var ClassSet = new r.Array(new r.Pointer(r.uint16, ClassRule), r.uint16);

	var Context = new r.VersionedStruct(r.uint16, {
	  1: { // Simple context
	    coverage: new r.Pointer(r.uint16, Coverage),
	    ruleSetCount: r.uint16,
	    ruleSets: new r.Array(new r.Pointer(r.uint16, RuleSet), 'ruleSetCount')
	  },
	  2: { // Class-based context
	    coverage: new r.Pointer(r.uint16, Coverage),
	    classDef: new r.Pointer(r.uint16, ClassDef),
	    classSetCnt: r.uint16,
	    classSet: new r.Array(new r.Pointer(r.uint16, ClassSet), 'classSetCnt')
	  },
	  3: {
	    glyphCount: r.uint16,
	    lookupCount: r.uint16,
	    coverages: new r.Array(new r.Pointer(r.uint16, Coverage), 'glyphCount'),
	    lookupRecords: new r.Array(LookupRecord, 'lookupCount')
	  }
	});

	//######################################################
	// Chaining Contextual Substitution/Positioning Tables #
	//######################################################

	var ChainRule = new r.Struct({
	  backtrackGlyphCount: r.uint16,
	  backtrack: new r.Array(r.uint16, 'backtrackGlyphCount'),
	  inputGlyphCount: r.uint16,
	  input: new r.Array(r.uint16, function (t) {
	    return t.inputGlyphCount - 1;
	  }),
	  lookaheadGlyphCount: r.uint16,
	  lookahead: new r.Array(r.uint16, 'lookaheadGlyphCount'),
	  lookupCount: r.uint16,
	  lookupRecords: new r.Array(LookupRecord, 'lookupCount')
	});

	var ChainRuleSet = new r.Array(new r.Pointer(r.uint16, ChainRule), r.uint16);

	var ChainingContext = new r.VersionedStruct(r.uint16, {
	  1: { // Simple context glyph substitution
	    coverage: new r.Pointer(r.uint16, Coverage),
	    chainCount: r.uint16,
	    chainRuleSets: new r.Array(new r.Pointer(r.uint16, ChainRuleSet), 'chainCount')
	  },

	  2: { // Class-based chaining context
	    coverage: new r.Pointer(r.uint16, Coverage),
	    backtrackClassDef: new r.Pointer(r.uint16, ClassDef),
	    inputClassDef: new r.Pointer(r.uint16, ClassDef),
	    lookaheadClassDef: new r.Pointer(r.uint16, ClassDef),
	    chainCount: r.uint16,
	    chainClassSet: new r.Array(new r.Pointer(r.uint16, ChainRuleSet), 'chainCount')
	  },

	  3: { // Coverage-based chaining context
	    backtrackGlyphCount: r.uint16,
	    backtrackCoverage: new r.Array(new r.Pointer(r.uint16, Coverage), 'backtrackGlyphCount'),
	    inputGlyphCount: r.uint16,
	    inputCoverage: new r.Array(new r.Pointer(r.uint16, Coverage), 'inputGlyphCount'),
	    lookaheadGlyphCount: r.uint16,
	    lookaheadCoverage: new r.Array(new r.Pointer(r.uint16, Coverage), 'lookaheadGlyphCount'),
	    lookupCount: r.uint16,
	    lookupRecords: new r.Array(LookupRecord, 'lookupCount')
	  }
	});

	var _;

	/*******************
	 * Variation Store *
	 *******************/

	var F2DOT14 = new r.Fixed(16, 'BE', 14);
	var RegionAxisCoordinates = new r.Struct({
	  startCoord: F2DOT14,
	  peakCoord: F2DOT14,
	  endCoord: F2DOT14
	});

	var VariationRegionList = new r.Struct({
	  axisCount: r.uint16,
	  regionCount: r.uint16,
	  variationRegions: new r.Array(new r.Array(RegionAxisCoordinates, 'axisCount'), 'regionCount')
	});

	var DeltaSet = new r.Struct({
	  shortDeltas: new r.Array(r.int16, function (t) {
	    return t.parent.shortDeltaCount;
	  }),
	  regionDeltas: new r.Array(r.int8, function (t) {
	    return t.parent.regionIndexCount - t.parent.shortDeltaCount;
	  }),
	  deltas: function deltas(t) {
	    return t.shortDeltas.concat(t.regionDeltas);
	  }
	});

	var ItemVariationData = new r.Struct({
	  itemCount: r.uint16,
	  shortDeltaCount: r.uint16,
	  regionIndexCount: r.uint16,
	  regionIndexes: new r.Array(r.uint16, 'regionIndexCount'),
	  deltaSets: new r.Array(DeltaSet, 'itemCount')
	});

	var ItemVariationStore = new r.Struct({
	  format: r.uint16,
	  variationRegionList: new r.Pointer(r.uint32, VariationRegionList),
	  variationDataCount: r.uint16,
	  itemVariationData: new r.Array(new r.Pointer(r.uint32, ItemVariationData), 'variationDataCount')
	});

	/**********************
	 * Feature Variations *
	 **********************/

	var ConditionTable = new r.VersionedStruct(r.uint16, {
	  1: (_ = {
	    axisIndex: r.uint16
	  }, _['axisIndex'] = r.uint16, _.filterRangeMinValue = F2DOT14, _.filterRangeMaxValue = F2DOT14, _)
	});

	var ConditionSet = new r.Struct({
	  conditionCount: r.uint16,
	  conditionTable: new r.Array(new r.Pointer(r.uint32, ConditionTable), 'conditionCount')
	});

	var FeatureTableSubstitutionRecord = new r.Struct({
	  featureIndex: r.uint16,
	  alternateFeatureTable: new r.Pointer(r.uint32, Feature, { type: 'parent' })
	});

	var FeatureTableSubstitution = new r.Struct({
	  version: r.fixed32,
	  substitutionCount: r.uint16,
	  substitutions: new r.Array(FeatureTableSubstitutionRecord, 'substitutionCount')
	});

	var FeatureVariationRecord = new r.Struct({
	  conditionSet: new r.Pointer(r.uint32, ConditionSet, { type: 'parent' }),
	  featureTableSubstitution: new r.Pointer(r.uint32, FeatureTableSubstitution, { type: 'parent' })
	});

	var FeatureVariations = new r.Struct({
	  majorVersion: r.uint16,
	  minorVersion: r.uint16,
	  featureVariationRecordCount: r.uint32,
	  featureVariationRecords: new r.Array(FeatureVariationRecord, 'featureVariationRecordCount')
	});

	// Checks if an operand is an index of a predefined value,
	// otherwise delegates to the provided type.

	var PredefinedOp = function () {
	  function PredefinedOp(predefinedOps, type) {
	    _classCallCheck(this, PredefinedOp);

	    this.predefinedOps = predefinedOps;
	    this.type = type;
	  }

	  PredefinedOp.prototype.decode = function decode(stream, parent, operands) {
	    if (this.predefinedOps[operands[0]]) {
	      return this.predefinedOps[operands[0]];
	    }

	    return this.type.decode(stream, parent, operands);
	  };

	  PredefinedOp.prototype.size = function size(value, ctx) {
	    return this.type.size(value, ctx);
	  };

	  PredefinedOp.prototype.encode = function encode(stream, value, ctx) {
	    var index = this.predefinedOps.indexOf(value);
	    if (index !== -1) {
	      return index;
	    }

	    return this.type.encode(stream, value, ctx);
	  };

	  return PredefinedOp;
	}();

	var CFFEncodingVersion = function (_r$Number) {
	  _inherits(CFFEncodingVersion, _r$Number);

	  function CFFEncodingVersion() {
	    _classCallCheck(this, CFFEncodingVersion);

	    return _possibleConstructorReturn(this, _r$Number.call(this, 'UInt8'));
	  }

	  CFFEncodingVersion.prototype.decode = function decode(stream) {
	    return r.uint8.decode(stream) & 0x7f;
	  };

	  return CFFEncodingVersion;
	}(r.Number);

	var Range1 = new r.Struct({
	  first: r.uint16,
	  nLeft: r.uint8
	});

	var Range2 = new r.Struct({
	  first: r.uint16,
	  nLeft: r.uint16
	});

	var CFFCustomEncoding = new r.VersionedStruct(new CFFEncodingVersion(), {
	  0: {
	    nCodes: r.uint8,
	    codes: new r.Array(r.uint8, 'nCodes')
	  },

	  1: {
	    nRanges: r.uint8,
	    ranges: new r.Array(Range1, 'nRanges')
	  }

	  // TODO: supplement?
	});

	var CFFEncoding = new PredefinedOp([StandardEncoding, ExpertEncoding], new CFFPointer(CFFCustomEncoding, { lazy: true }));

	// Decodes an array of ranges until the total
	// length is equal to the provided length.

	var RangeArray = function (_r$Array) {
	  _inherits(RangeArray, _r$Array);

	  function RangeArray() {
	    _classCallCheck(this, RangeArray);

	    return _possibleConstructorReturn(this, _r$Array.apply(this, arguments));
	  }

	  RangeArray.prototype.decode = function decode(stream, parent) {
	    var length = restructure_src_utils.resolveLength(this.length, stream, parent);
	    var count = 0;
	    var res = [];
	    while (count < length) {
	      var range = this.type.decode(stream, parent);
	      range.offset = count;
	      count += range.nLeft + 1;
	      res.push(range);
	    }

	    return res;
	  };

	  return RangeArray;
	}(r.Array);

	var CFFCustomCharset = new r.VersionedStruct(r.uint8, {
	  0: {
	    glyphs: new r.Array(r.uint16, function (t) {
	      return t.parent.CharStrings.length - 1;
	    })
	  },

	  1: {
	    ranges: new RangeArray(Range1, function (t) {
	      return t.parent.CharStrings.length - 1;
	    })
	  },

	  2: {
	    ranges: new RangeArray(Range2, function (t) {
	      return t.parent.CharStrings.length - 1;
	    })
	  }
	});

	var CFFCharset = new PredefinedOp([ISOAdobeCharset, ExpertCharset, ExpertSubsetCharset], new CFFPointer(CFFCustomCharset, { lazy: true }));

	var FDRange3 = new r.Struct({
	  first: r.uint16,
	  fd: r.uint8
	});

	var FDRange4 = new r.Struct({
	  first: r.uint32,
	  fd: r.uint16
	});

	var FDSelect = new r.VersionedStruct(r.uint8, {
	  0: {
	    fds: new r.Array(r.uint8, function (t) {
	      return t.parent.CharStrings.length;
	    })
	  },

	  3: {
	    nRanges: r.uint16,
	    ranges: new r.Array(FDRange3, 'nRanges'),
	    sentinel: r.uint16
	  },

	  4: {
	    nRanges: r.uint32,
	    ranges: new r.Array(FDRange4, 'nRanges'),
	    sentinel: r.uint32
	  }
	});

	var ptr = new CFFPointer(CFFPrivateDict);

	var CFFPrivateOp = function () {
	  function CFFPrivateOp() {
	    _classCallCheck(this, CFFPrivateOp);
	  }

	  CFFPrivateOp.prototype.decode = function decode(stream, parent, operands) {
	    parent.length = operands[0];
	    return ptr.decode(stream, parent, [operands[1]]);
	  };

	  CFFPrivateOp.prototype.size = function size(dict, ctx) {
	    return [CFFPrivateDict.size(dict, ctx, false), ptr.size(dict, ctx)[0]];
	  };

	  CFFPrivateOp.prototype.encode = function encode(stream, dict, ctx) {
	    return [CFFPrivateDict.size(dict, ctx, false), ptr.encode(stream, dict, ctx)[0]];
	  };

	  return CFFPrivateOp;
	}();

	var FontDict = new CFFDict([
	// key       name                   type(s)                                 default
	[18, 'Private', new CFFPrivateOp(), null], [[12, 38], 'FontName', 'sid', null]]);

	var CFFTopDict = new CFFDict([
	// key       name                   type(s)                                 default
	[[12, 30], 'ROS', ['sid', 'sid', 'number'], null], [0, 'version', 'sid', null], [1, 'Notice', 'sid', null], [[12, 0], 'Copyright', 'sid', null], [2, 'FullName', 'sid', null], [3, 'FamilyName', 'sid', null], [4, 'Weight', 'sid', null], [[12, 1], 'isFixedPitch', 'boolean', false], [[12, 2], 'ItalicAngle', 'number', 0], [[12, 3], 'UnderlinePosition', 'number', -100], [[12, 4], 'UnderlineThickness', 'number', 50], [[12, 5], 'PaintType', 'number', 0], [[12, 6], 'CharstringType', 'number', 2], [[12, 7], 'FontMatrix', 'array', [0.001, 0, 0, 0.001, 0, 0]], [13, 'UniqueID', 'number', null], [5, 'FontBBox', 'array', [0, 0, 0, 0]], [[12, 8], 'StrokeWidth', 'number', 0], [14, 'XUID', 'array', null], [15, 'charset', CFFCharset, ISOAdobeCharset], [16, 'Encoding', CFFEncoding, StandardEncoding], [17, 'CharStrings', new CFFPointer(new CFFIndex()), null], [18, 'Private', new CFFPrivateOp(), null], [[12, 20], 'SyntheticBase', 'number', null], [[12, 21], 'PostScript', 'sid', null], [[12, 22], 'BaseFontName', 'sid', null], [[12, 23], 'BaseFontBlend', 'delta', null],

	// CID font specific
	[[12, 31], 'CIDFontVersion', 'number', 0], [[12, 32], 'CIDFontRevision', 'number', 0], [[12, 33], 'CIDFontType', 'number', 0], [[12, 34], 'CIDCount', 'number', 8720], [[12, 35], 'UIDBase', 'number', null], [[12, 37], 'FDSelect', new CFFPointer(FDSelect), null], [[12, 36], 'FDArray', new CFFPointer(new CFFIndex(FontDict)), null], [[12, 38], 'FontName', 'sid', null]]);

	var VariationStore = new r.Struct({
	  length: r.uint16,
	  itemVariationStore: ItemVariationStore
	});

	var CFF2TopDict = new CFFDict([[[12, 7], 'FontMatrix', 'array', [0.001, 0, 0, 0.001, 0, 0]], [17, 'CharStrings', new CFFPointer(new CFFIndex()), null], [[12, 37], 'FDSelect', new CFFPointer(FDSelect), null], [[12, 36], 'FDArray', new CFFPointer(new CFFIndex(FontDict)), null], [24, 'vstore', new CFFPointer(VariationStore), null], [25, 'maxstack', 'number', 193]]);

	var CFFTop = new r.VersionedStruct(r.fixed16, {
	  1: {
	    hdrSize: r.uint8,
	    offSize: r.uint8,
	    nameIndex: new CFFIndex(new r.String('length')),
	    topDictIndex: new CFFIndex(CFFTopDict),
	    stringIndex: new CFFIndex(new r.String('length')),
	    globalSubrIndex: new CFFIndex()
	  },

	  2: {
	    hdrSize: r.uint8,
	    length: r.uint16,
	    topDict: CFF2TopDict,
	    globalSubrIndex: new CFFIndex()
	  }
	});

	var CFFFont = function () {
	  function CFFFont(stream) {
	    _classCallCheck(this, CFFFont);

	    this.stream = stream;
	    this.decode();
	  }

	  CFFFont.decode = function decode(stream) {
	    return new CFFFont(stream);
	  };

	  CFFFont.prototype.decode = function decode() {
	    var start = this.stream.pos;
	    var top = CFFTop.decode(this.stream);
	    for (var key in top) {
	      var val = top[key];
	      this[key] = val;
	    }

	    if (this.version < 2) {
	      if (this.topDictIndex.length !== 1) {
	        throw new Error("Only a single font is allowed in CFF");
	      }

	      this.topDict = this.topDictIndex[0];
	    }

	    this.isCIDFont = this.topDict.ROS != null;
	    return this;
	  };

	  CFFFont.prototype.string = function string(sid) {
	    if (this.version >= 2) {
	      return null;
	    }

	    if (sid < standardStrings.length) {
	      return standardStrings[sid];
	    }

	    return this.stringIndex[sid - standardStrings.length];
	  };

	  CFFFont.prototype.getCharString = function getCharString(glyph) {
	    this.stream.pos = this.topDict.CharStrings[glyph].offset;
	    return this.stream.readBuffer(this.topDict.CharStrings[glyph].length);
	  };

	  CFFFont.prototype.getGlyphName = function getGlyphName(gid) {
	    // CFF2 glyph names are in the post table.
	    if (this.version >= 2) {
	      return null;
	    }

	    // CID-keyed fonts don't have glyph names
	    if (this.isCIDFont) {
	      return null;
	    }

	    var charset = this.topDict.charset;

	    if (Array.isArray(charset)) {
	      return charset[gid];
	    }

	    if (gid === 0) {
	      return '.notdef';
	    }

	    gid -= 1;

	    switch (charset.version) {
	      case 0:
	        return this.string(charset.glyphs[gid]);

	      case 1:
	      case 2:
	        for (var i = 0; i < charset.ranges.length; i++) {
	          var range = charset.ranges[i];
	          if (range.offset <= gid && gid <= range.offset + range.nLeft) {
	            return this.string(range.first + (gid - range.offset));
	          }
	        }
	        break;
	    }

	    return null;
	  };

	  CFFFont.prototype.fdForGlyph = function fdForGlyph(gid) {
	    if (!this.topDict.FDSelect) {
	      return null;
	    }

	    switch (this.topDict.FDSelect.version) {
	      case 0:
	        return this.topDict.FDSelect.fds[gid];

	      case 3:
	      case 4:
	        var ranges = this.topDict.FDSelect.ranges;

	        var low = 0;
	        var high = ranges.length - 1;

	        while (low <= high) {
	          var mid = low + high >> 1;

	          if (gid < ranges[mid].first) {
	            high = mid - 1;
	          } else if (mid < high && gid > ranges[mid + 1].first) {
	            low = mid + 1;
	          } else {
	            return ranges[mid].fd;
	          }
	        }
	      default:
	        throw new Error('Unknown FDSelect version: ' + this.topDict.FDSelect.version);
	    }
	  };

	  CFFFont.prototype.privateDictForGlyph = function privateDictForGlyph(gid) {
	    if (this.topDict.FDSelect) {
	      var fd = this.fdForGlyph(gid);
	      if (this.topDict.FDArray[fd]) {
	        return this.topDict.FDArray[fd].Private;
	      }

	      return null;
	    }

	    if (this.version < 2) {
	      return this.topDict.Private;
	    }

	    return this.topDict.FDArray[0].Private;
	  };

	  _createClass(CFFFont, [{
	    key: 'postscriptName',
	    get: function get() {
	      if (this.version < 2) {
	        return this.nameIndex[0];
	      }

	      return null;
	    }
	  }, {
	    key: 'fullName',
	    get: function get() {
	      return this.string(this.topDict.FullName);
	    }
	  }, {
	    key: 'familyName',
	    get: function get() {
	      return this.string(this.topDict.FamilyName);
	    }
	  }]);

	  return CFFFont;
	}();

	var VerticalOrigin = new r.Struct({
	  glyphIndex: r.uint16,
	  vertOriginY: r.int16
	});

	var VORG = new r.Struct({
	  majorVersion: r.uint16,
	  minorVersion: r.uint16,
	  defaultVertOriginY: r.int16,
	  numVertOriginYMetrics: r.uint16,
	  metrics: new r.Array(VerticalOrigin, 'numVertOriginYMetrics')
	});

	var BigMetrics = new r.Struct({
	  height: r.uint8,
	  width: r.uint8,
	  horiBearingX: r.int8,
	  horiBearingY: r.int8,
	  horiAdvance: r.uint8,
	  vertBearingX: r.int8,
	  vertBearingY: r.int8,
	  vertAdvance: r.uint8
	});

	var SmallMetrics = new r.Struct({
	  height: r.uint8,
	  width: r.uint8,
	  bearingX: r.int8,
	  bearingY: r.int8,
	  advance: r.uint8
	});

	var EBDTComponent = new r.Struct({
	  glyph: r.uint16,
	  xOffset: r.int8,
	  yOffset: r.int8
	});

	var ByteAligned = function ByteAligned() {
	  _classCallCheck(this, ByteAligned);
	};

	var BitAligned = function BitAligned() {
	  _classCallCheck(this, BitAligned);
	};

	var glyph = new r.VersionedStruct('version', {
	  1: {
	    metrics: SmallMetrics,
	    data: ByteAligned
	  },

	  2: {
	    metrics: SmallMetrics,
	    data: BitAligned
	  },

	  // format 3 is deprecated
	  // format 4 is not supported by Microsoft

	  5: {
	    data: BitAligned
	  },

	  6: {
	    metrics: BigMetrics,
	    data: ByteAligned
	  },

	  7: {
	    metrics: BigMetrics,
	    data: BitAligned
	  },

	  8: {
	    metrics: SmallMetrics,
	    pad: new r.Reserved(r.uint8),
	    numComponents: r.uint16,
	    components: new r.Array(EBDTComponent, 'numComponents')
	  },

	  9: {
	    metrics: BigMetrics,
	    pad: new r.Reserved(r.uint8),
	    numComponents: r.uint16,
	    components: new r.Array(EBDTComponent, 'numComponents')
	  },

	  17: {
	    metrics: SmallMetrics,
	    dataLen: r.uint32,
	    data: new r.Buffer('dataLen')
	  },

	  18: {
	    metrics: BigMetrics,
	    dataLen: r.uint32,
	    data: new r.Buffer('dataLen')
	  },

	  19: {
	    dataLen: r.uint32,
	    data: new r.Buffer('dataLen')
	  }
	});

	var SBitLineMetrics = new r.Struct({
	  ascender: r.int8,
	  descender: r.int8,
	  widthMax: r.uint8,
	  caretSlopeNumerator: r.int8,
	  caretSlopeDenominator: r.int8,
	  caretOffset: r.int8,
	  minOriginSB: r.int8,
	  minAdvanceSB: r.int8,
	  maxBeforeBL: r.int8,
	  minAfterBL: r.int8,
	  pad: new r.Reserved(r.int8, 2)
	});

	var CodeOffsetPair = new r.Struct({
	  glyphCode: r.uint16,
	  offset: r.uint16
	});

	var IndexSubtable = new r.VersionedStruct(r.uint16, {
	  header: {
	    imageFormat: r.uint16,
	    imageDataOffset: r.uint32
	  },

	  1: {
	    offsetArray: new r.Array(r.uint32, function (t) {
	      return t.parent.lastGlyphIndex - t.parent.firstGlyphIndex + 1;
	    })
	  },

	  2: {
	    imageSize: r.uint32,
	    bigMetrics: BigMetrics
	  },

	  3: {
	    offsetArray: new r.Array(r.uint16, function (t) {
	      return t.parent.lastGlyphIndex - t.parent.firstGlyphIndex + 1;
	    })
	  },

	  4: {
	    numGlyphs: r.uint32,
	    glyphArray: new r.Array(CodeOffsetPair, function (t) {
	      return t.numGlyphs + 1;
	    })
	  },

	  5: {
	    imageSize: r.uint32,
	    bigMetrics: BigMetrics,
	    numGlyphs: r.uint32,
	    glyphCodeArray: new r.Array(r.uint16, 'numGlyphs')
	  }
	});

	var IndexSubtableArray = new r.Struct({
	  firstGlyphIndex: r.uint16,
	  lastGlyphIndex: r.uint16,
	  subtable: new r.Pointer(r.uint32, IndexSubtable)
	});

	var BitmapSizeTable = new r.Struct({
	  indexSubTableArray: new r.Pointer(r.uint32, new r.Array(IndexSubtableArray, 1), { type: 'parent' }),
	  indexTablesSize: r.uint32,
	  numberOfIndexSubTables: r.uint32,
	  colorRef: r.uint32,
	  hori: SBitLineMetrics,
	  vert: SBitLineMetrics,
	  startGlyphIndex: r.uint16,
	  endGlyphIndex: r.uint16,
	  ppemX: r.uint8,
	  ppemY: r.uint8,
	  bitDepth: r.uint8,
	  flags: new r.Bitfield(r.uint8, ['horizontal', 'vertical'])
	});

	var EBLC = new r.Struct({
	  version: r.uint32, // 0x00020000
	  numSizes: r.uint32,
	  sizes: new r.Array(BitmapSizeTable, 'numSizes')
	});

	var ImageTable = new r.Struct({
	  ppem: r.uint16,
	  resolution: r.uint16,
	  imageOffsets: new r.Array(new r.Pointer(r.uint32, 'void'), function (t) {
	    return t.parent.parent.maxp.numGlyphs + 1;
	  })
	});

	// This is the Apple sbix table, used by the "Apple Color Emoji" font.
	// It includes several image tables with images for each bitmap glyph
	// of several different sizes.
	var sbix = new r.Struct({
	  version: r.uint16,
	  flags: new r.Bitfield(r.uint16, ['renderOutlines']),
	  numImgTables: r.uint32,
	  imageTables: new r.Array(new r.Pointer(r.uint32, ImageTable), 'numImgTables')
	});

	var LayerRecord = new r.Struct({
	  gid: r.uint16, // Glyph ID of layer glyph (must be in z-order from bottom to top).
	  paletteIndex: r.uint16 // Index value to use in the appropriate palette. This value must
	}); // be less than numPaletteEntries in the CPAL table, except for
	// the special case noted below. Each palette entry is 16 bits.
	// A palette index of 0xFFFF is a special case indicating that
	// the text foreground color should be used.

	var BaseGlyphRecord = new r.Struct({
	  gid: r.uint16, // Glyph ID of reference glyph. This glyph is for reference only
	  // and is not rendered for color.
	  firstLayerIndex: r.uint16, // Index (from beginning of the Layer Records) to the layer record.
	  // There will be numLayers consecutive entries for this base glyph.
	  numLayers: r.uint16
	});

	var COLR = new r.Struct({
	  version: r.uint16,
	  numBaseGlyphRecords: r.uint16,
	  baseGlyphRecord: new r.Pointer(r.uint32, new r.Array(BaseGlyphRecord, 'numBaseGlyphRecords')),
	  layerRecords: new r.Pointer(r.uint32, new r.Array(LayerRecord, 'numLayerRecords'), { lazy: true }),
	  numLayerRecords: r.uint16
	});

	var ColorRecord = new r.Struct({
	  blue: r.uint8,
	  green: r.uint8,
	  red: r.uint8,
	  alpha: r.uint8
	});

	var CPAL = new r.VersionedStruct(r.uint16, {
	  header: {
	    numPaletteEntries: r.uint16,
	    numPalettes: r.uint16,
	    numColorRecords: r.uint16,
	    colorRecords: new r.Pointer(r.uint32, new r.Array(ColorRecord, 'numColorRecords')),
	    colorRecordIndices: new r.Array(r.uint16, 'numPalettes')
	  },
	  0: {},
	  1: {
	    offsetPaletteTypeArray: new r.Pointer(r.uint32, new r.Array(r.uint32, 'numPalettes')),
	    offsetPaletteLabelArray: new r.Pointer(r.uint32, new r.Array(r.uint16, 'numPalettes')),
	    offsetPaletteEntryLabelArray: new r.Pointer(r.uint32, new r.Array(r.uint16, 'numPaletteEntries'))
	  }
	});

	var BaseCoord = new r.VersionedStruct(r.uint16, {
	  1: { // Design units only
	    coordinate: r.int16 // X or Y value, in design units
	  },

	  2: { // Design units plus contour point
	    coordinate: r.int16, // X or Y value, in design units
	    referenceGlyph: r.uint16, // GlyphID of control glyph
	    baseCoordPoint: r.uint16 // Index of contour point on the referenceGlyph
	  },

	  3: { // Design units plus Device table
	    coordinate: r.int16, // X or Y value, in design units
	    deviceTable: new r.Pointer(r.uint16, Device) // Device table for X or Y value
	  }
	});

	var BaseValues = new r.Struct({
	  defaultIndex: r.uint16, // Index of default baseline for this script-same index in the BaseTagList
	  baseCoordCount: r.uint16,
	  baseCoords: new r.Array(new r.Pointer(r.uint16, BaseCoord), 'baseCoordCount')
	});

	var FeatMinMaxRecord = new r.Struct({
	  tag: new r.String(4), // 4-byte feature identification tag-must match FeatureTag in FeatureList
	  minCoord: new r.Pointer(r.uint16, BaseCoord, { type: 'parent' }), // May be NULL
	  maxCoord: new r.Pointer(r.uint16, BaseCoord, { type: 'parent' }) // May be NULL
	});

	var MinMax = new r.Struct({
	  minCoord: new r.Pointer(r.uint16, BaseCoord), // May be NULL
	  maxCoord: new r.Pointer(r.uint16, BaseCoord), // May be NULL
	  featMinMaxCount: r.uint16, // May be 0
	  featMinMaxRecords: new r.Array(FeatMinMaxRecord, 'featMinMaxCount') // In alphabetical order
	});

	var BaseLangSysRecord = new r.Struct({
	  tag: new r.String(4), // 4-byte language system identification tag
	  minMax: new r.Pointer(r.uint16, MinMax, { type: 'parent' })
	});

	var BaseScript = new r.Struct({
	  baseValues: new r.Pointer(r.uint16, BaseValues), // May be NULL
	  defaultMinMax: new r.Pointer(r.uint16, MinMax), // May be NULL
	  baseLangSysCount: r.uint16, // May be 0
	  baseLangSysRecords: new r.Array(BaseLangSysRecord, 'baseLangSysCount') // in alphabetical order by BaseLangSysTag
	});

	var BaseScriptRecord = new r.Struct({
	  tag: new r.String(4), // 4-byte script identification tag
	  script: new r.Pointer(r.uint16, BaseScript, { type: 'parent' })
	});

	var BaseScriptList = new r.Array(BaseScriptRecord, r.uint16);

	// Array of 4-byte baseline identification tags-must be in alphabetical order
	var BaseTagList = new r.Array(new r.String(4), r.uint16);

	var Axis = new r.Struct({
	  baseTagList: new r.Pointer(r.uint16, BaseTagList), // May be NULL
	  baseScriptList: new r.Pointer(r.uint16, BaseScriptList)
	});

	var BASE = new r.VersionedStruct(r.uint32, {
	  header: {
	    horizAxis: new r.Pointer(r.uint16, Axis), // May be NULL
	    vertAxis: new r.Pointer(r.uint16, Axis) // May be NULL
	  },

	  0x00010000: {},
	  0x00010001: {
	    itemVariationStore: new r.Pointer(r.uint32, ItemVariationStore)
	  }
	});

	var AttachPoint = new r.Array(r.uint16, r.uint16);
	var AttachList = new r.Struct({
	  coverage: new r.Pointer(r.uint16, Coverage),
	  glyphCount: r.uint16,
	  attachPoints: new r.Array(new r.Pointer(r.uint16, AttachPoint), 'glyphCount')
	});

	var CaretValue = new r.VersionedStruct(r.uint16, {
	  1: { // Design units only
	    coordinate: r.int16
	  },

	  2: { // Contour point
	    caretValuePoint: r.uint16
	  },

	  3: { // Design units plus Device table
	    coordinate: r.int16,
	    deviceTable: new r.Pointer(r.uint16, Device)
	  }
	});

	var LigGlyph = new r.Array(new r.Pointer(r.uint16, CaretValue), r.uint16);

	var LigCaretList = new r.Struct({
	  coverage: new r.Pointer(r.uint16, Coverage),
	  ligGlyphCount: r.uint16,
	  ligGlyphs: new r.Array(new r.Pointer(r.uint16, LigGlyph), 'ligGlyphCount')
	});

	var MarkGlyphSetsDef = new r.Struct({
	  markSetTableFormat: r.uint16,
	  markSetCount: r.uint16,
	  coverage: new r.Array(new r.Pointer(r.uint32, Coverage), 'markSetCount')
	});

	var GDEF = new r.VersionedStruct(r.uint32, {
	  header: {
	    glyphClassDef: new r.Pointer(r.uint16, ClassDef),
	    attachList: new r.Pointer(r.uint16, AttachList),
	    ligCaretList: new r.Pointer(r.uint16, LigCaretList),
	    markAttachClassDef: new r.Pointer(r.uint16, ClassDef)
	  },

	  0x00010000: {},
	  0x00010002: {
	    markGlyphSetsDef: new r.Pointer(r.uint16, MarkGlyphSetsDef)
	  },
	  0x00010003: {
	    markGlyphSetsDef: new r.Pointer(r.uint16, MarkGlyphSetsDef),
	    itemVariationStore: new r.Pointer(r.uint32, ItemVariationStore)
	  }
	});

	var ValueFormat = new r.Bitfield(r.uint16, ['xPlacement', 'yPlacement', 'xAdvance', 'yAdvance', 'xPlaDevice', 'yPlaDevice', 'xAdvDevice', 'yAdvDevice']);

	var types = {
	  xPlacement: r.int16,
	  yPlacement: r.int16,
	  xAdvance: r.int16,
	  yAdvance: r.int16,
	  xPlaDevice: new r.Pointer(r.uint16, Device, { type: 'global', relativeTo: 'rel' }),
	  yPlaDevice: new r.Pointer(r.uint16, Device, { type: 'global', relativeTo: 'rel' }),
	  xAdvDevice: new r.Pointer(r.uint16, Device, { type: 'global', relativeTo: 'rel' }),
	  yAdvDevice: new r.Pointer(r.uint16, Device, { type: 'global', relativeTo: 'rel' })
	};

	var ValueRecord = function () {
	  function ValueRecord() {
	    var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'valueFormat';

	    _classCallCheck(this, ValueRecord);

	    this.key = key;
	  }

	  ValueRecord.prototype.buildStruct = function buildStruct(parent) {
	    var struct = parent;
	    while (!struct[this.key] && struct.parent) {
	      struct = struct.parent;
	    }

	    if (!struct[this.key]) return;

	    var fields = {};
	    fields.rel = function () {
	      return struct._startOffset;
	    };

	    var format = struct[this.key];
	    for (var key in format) {
	      if (format[key]) {
	        fields[key] = types[key];
	      }
	    }

	    return new r.Struct(fields);
	  };

	  ValueRecord.prototype.size = function size(val, ctx) {
	    return this.buildStruct(ctx).size(val, ctx);
	  };

	  ValueRecord.prototype.decode = function decode(stream, parent) {
	    var res = this.buildStruct(parent).decode(stream, parent);
	    delete res.rel;
	    return res;
	  };

	  return ValueRecord;
	}();

	var PairValueRecord = new r.Struct({
	  secondGlyph: r.uint16,
	  value1: new ValueRecord('valueFormat1'),
	  value2: new ValueRecord('valueFormat2')
	});

	var PairSet = new r.Array(PairValueRecord, r.uint16);

	var Class2Record = new r.Struct({
	  value1: new ValueRecord('valueFormat1'),
	  value2: new ValueRecord('valueFormat2')
	});

	var Anchor = new r.VersionedStruct(r.uint16, {
	  1: { // Design units only
	    xCoordinate: r.int16,
	    yCoordinate: r.int16
	  },

	  2: { // Design units plus contour point
	    xCoordinate: r.int16,
	    yCoordinate: r.int16,
	    anchorPoint: r.uint16
	  },

	  3: { // Design units plus Device tables
	    xCoordinate: r.int16,
	    yCoordinate: r.int16,
	    xDeviceTable: new r.Pointer(r.uint16, Device),
	    yDeviceTable: new r.Pointer(r.uint16, Device)
	  }
	});

	var EntryExitRecord = new r.Struct({
	  entryAnchor: new r.Pointer(r.uint16, Anchor, { type: 'parent' }),
	  exitAnchor: new r.Pointer(r.uint16, Anchor, { type: 'parent' })
	});

	var MarkRecord = new r.Struct({
	  class: r.uint16,
	  markAnchor: new r.Pointer(r.uint16, Anchor, { type: 'parent' })
	});

	var MarkArray = new r.Array(MarkRecord, r.uint16);

	var BaseRecord = new r.Array(new r.Pointer(r.uint16, Anchor), function (t) {
	  return t.parent.classCount;
	});
	var BaseArray = new r.Array(BaseRecord, r.uint16);

	var ComponentRecord = new r.Array(new r.Pointer(r.uint16, Anchor), function (t) {
	  return t.parent.parent.classCount;
	});
	var LigatureAttach = new r.Array(ComponentRecord, r.uint16);
	var LigatureArray = new r.Array(new r.Pointer(r.uint16, LigatureAttach), r.uint16);

	var GPOSLookup = new r.VersionedStruct('lookupType', {
	  1: new r.VersionedStruct(r.uint16, { // Single Adjustment
	    1: { // Single positioning value
	      coverage: new r.Pointer(r.uint16, Coverage),
	      valueFormat: ValueFormat,
	      value: new ValueRecord()
	    },
	    2: {
	      coverage: new r.Pointer(r.uint16, Coverage),
	      valueFormat: ValueFormat,
	      valueCount: r.uint16,
	      values: new r.LazyArray(new ValueRecord(), 'valueCount')
	    }
	  }),

	  2: new r.VersionedStruct(r.uint16, { // Pair Adjustment Positioning
	    1: { // Adjustments for glyph pairs
	      coverage: new r.Pointer(r.uint16, Coverage),
	      valueFormat1: ValueFormat,
	      valueFormat2: ValueFormat,
	      pairSetCount: r.uint16,
	      pairSets: new r.LazyArray(new r.Pointer(r.uint16, PairSet), 'pairSetCount')
	    },

	    2: { // Class pair adjustment
	      coverage: new r.Pointer(r.uint16, Coverage),
	      valueFormat1: ValueFormat,
	      valueFormat2: ValueFormat,
	      classDef1: new r.Pointer(r.uint16, ClassDef),
	      classDef2: new r.Pointer(r.uint16, ClassDef),
	      class1Count: r.uint16,
	      class2Count: r.uint16,
	      classRecords: new r.LazyArray(new r.LazyArray(Class2Record, 'class2Count'), 'class1Count')
	    }
	  }),

	  3: { // Cursive Attachment Positioning
	    format: r.uint16,
	    coverage: new r.Pointer(r.uint16, Coverage),
	    entryExitCount: r.uint16,
	    entryExitRecords: new r.Array(EntryExitRecord, 'entryExitCount')
	  },

	  4: { // MarkToBase Attachment Positioning
	    format: r.uint16,
	    markCoverage: new r.Pointer(r.uint16, Coverage),
	    baseCoverage: new r.Pointer(r.uint16, Coverage),
	    classCount: r.uint16,
	    markArray: new r.Pointer(r.uint16, MarkArray),
	    baseArray: new r.Pointer(r.uint16, BaseArray)
	  },

	  5: { // MarkToLigature Attachment Positioning
	    format: r.uint16,
	    markCoverage: new r.Pointer(r.uint16, Coverage),
	    ligatureCoverage: new r.Pointer(r.uint16, Coverage),
	    classCount: r.uint16,
	    markArray: new r.Pointer(r.uint16, MarkArray),
	    ligatureArray: new r.Pointer(r.uint16, LigatureArray)
	  },

	  6: { // MarkToMark Attachment Positioning
	    format: r.uint16,
	    mark1Coverage: new r.Pointer(r.uint16, Coverage),
	    mark2Coverage: new r.Pointer(r.uint16, Coverage),
	    classCount: r.uint16,
	    mark1Array: new r.Pointer(r.uint16, MarkArray),
	    mark2Array: new r.Pointer(r.uint16, BaseArray)
	  },

	  7: Context, // Contextual positioning
	  8: ChainingContext, // Chaining contextual positioning

	  9: { // Extension Positioning
	    posFormat: r.uint16,
	    lookupType: r.uint16, // cannot also be 9
	    extension: new r.Pointer(r.uint32, GPOSLookup)
	  }
	});

	// Fix circular reference
	GPOSLookup.versions[9].extension.type = GPOSLookup;

	var GPOS = new r.VersionedStruct(r.uint32, {
	  header: {
	    scriptList: new r.Pointer(r.uint16, ScriptList),
	    featureList: new r.Pointer(r.uint16, FeatureList),
	    lookupList: new r.Pointer(r.uint16, new LookupList(GPOSLookup))
	  },

	  0x00010000: {},
	  0x00010001: {
	    featureVariations: new r.Pointer(r.uint32, FeatureVariations)
	  }
	});

	var Sequence = new r.Array(r.uint16, r.uint16);
	var AlternateSet = Sequence;

	var Ligature = new r.Struct({
	  glyph: r.uint16,
	  compCount: r.uint16,
	  components: new r.Array(r.uint16, function (t) {
	    return t.compCount - 1;
	  })
	});

	var LigatureSet = new r.Array(new r.Pointer(r.uint16, Ligature), r.uint16);

	var GSUBLookup = new r.VersionedStruct('lookupType', {
	  1: new r.VersionedStruct(r.uint16, { // Single Substitution
	    1: {
	      coverage: new r.Pointer(r.uint16, Coverage),
	      deltaGlyphID: r.int16
	    },
	    2: {
	      coverage: new r.Pointer(r.uint16, Coverage),
	      glyphCount: r.uint16,
	      substitute: new r.LazyArray(r.uint16, 'glyphCount')
	    }
	  }),

	  2: { // Multiple Substitution
	    substFormat: r.uint16,
	    coverage: new r.Pointer(r.uint16, Coverage),
	    count: r.uint16,
	    sequences: new r.LazyArray(new r.Pointer(r.uint16, Sequence), 'count')
	  },

	  3: { // Alternate Substitution
	    substFormat: r.uint16,
	    coverage: new r.Pointer(r.uint16, Coverage),
	    count: r.uint16,
	    alternateSet: new r.LazyArray(new r.Pointer(r.uint16, AlternateSet), 'count')
	  },

	  4: { // Ligature Substitution
	    substFormat: r.uint16,
	    coverage: new r.Pointer(r.uint16, Coverage),
	    count: r.uint16,
	    ligatureSets: new r.LazyArray(new r.Pointer(r.uint16, LigatureSet), 'count')
	  },

	  5: Context, // Contextual Substitution
	  6: ChainingContext, // Chaining Contextual Substitution

	  7: { // Extension Substitution
	    substFormat: r.uint16,
	    lookupType: r.uint16, // cannot also be 7
	    extension: new r.Pointer(r.uint32, GSUBLookup)
	  },

	  8: { // Reverse Chaining Contextual Single Substitution
	    substFormat: r.uint16,
	    coverage: new r.Pointer(r.uint16, Coverage),
	    backtrackCoverage: new r.Array(new r.Pointer(r.uint16, Coverage), 'backtrackGlyphCount'),
	    lookaheadGlyphCount: r.uint16,
	    lookaheadCoverage: new r.Array(new r.Pointer(r.uint16, Coverage), 'lookaheadGlyphCount'),
	    glyphCount: r.uint16,
	    substitutes: new r.Array(r.uint16, 'glyphCount')
	  }
	});

	// Fix circular reference
	GSUBLookup.versions[7].extension.type = GSUBLookup;

	var GSUB = new r.VersionedStruct(r.uint32, {
	  header: {
	    scriptList: new r.Pointer(r.uint16, ScriptList),
	    featureList: new r.Pointer(r.uint16, FeatureList),
	    lookupList: new r.Pointer(r.uint16, new LookupList(GSUBLookup))
	  },

	  0x00010000: {},
	  0x00010001: {
	    featureVariations: new r.Pointer(r.uint32, FeatureVariations)
	  }
	});

	var JstfGSUBModList = new r.Array(r.uint16, r.uint16);

	var JstfPriority = new r.Struct({
	  shrinkageEnableGSUB: new r.Pointer(r.uint16, JstfGSUBModList),
	  shrinkageDisableGSUB: new r.Pointer(r.uint16, JstfGSUBModList),
	  shrinkageEnableGPOS: new r.Pointer(r.uint16, JstfGSUBModList),
	  shrinkageDisableGPOS: new r.Pointer(r.uint16, JstfGSUBModList),
	  shrinkageJstfMax: new r.Pointer(r.uint16, new LookupList(GPOSLookup)),
	  extensionEnableGSUB: new r.Pointer(r.uint16, JstfGSUBModList),
	  extensionDisableGSUB: new r.Pointer(r.uint16, JstfGSUBModList),
	  extensionEnableGPOS: new r.Pointer(r.uint16, JstfGSUBModList),
	  extensionDisableGPOS: new r.Pointer(r.uint16, JstfGSUBModList),
	  extensionJstfMax: new r.Pointer(r.uint16, new LookupList(GPOSLookup))
	});

	var JstfLangSys = new r.Array(new r.Pointer(r.uint16, JstfPriority), r.uint16);

	var JstfLangSysRecord = new r.Struct({
	  tag: new r.String(4),
	  jstfLangSys: new r.Pointer(r.uint16, JstfLangSys)
	});

	var JstfScript = new r.Struct({
	  extenderGlyphs: new r.Pointer(r.uint16, new r.Array(r.uint16, r.uint16)), // array of glyphs to extend line length
	  defaultLangSys: new r.Pointer(r.uint16, JstfLangSys),
	  langSysCount: r.uint16,
	  langSysRecords: new r.Array(JstfLangSysRecord, 'langSysCount')
	});

	var JstfScriptRecord = new r.Struct({
	  tag: new r.String(4),
	  script: new r.Pointer(r.uint16, JstfScript, { type: 'parent' })
	});

	var JSTF = new r.Struct({
	  version: r.uint32, // should be 0x00010000
	  scriptCount: r.uint16,
	  scriptList: new r.Array(JstfScriptRecord, 'scriptCount')
	});

	// TODO: add this to restructure

	var VariableSizeNumber = function () {
	  function VariableSizeNumber(size) {
	    _classCallCheck(this, VariableSizeNumber);

	    this._size = size;
	  }

	  VariableSizeNumber.prototype.decode = function decode(stream, parent) {
	    switch (this.size(0, parent)) {
	      case 1:
	        return stream.readUInt8();
	      case 2:
	        return stream.readUInt16BE();
	      case 3:
	        return stream.readUInt24BE();
	      case 4:
	        return stream.readUInt32BE();
	    }
	  };

	  VariableSizeNumber.prototype.size = function size(val, parent) {
	    return restructure_src_utils.resolveLength(this._size, null, parent);
	  };

	  return VariableSizeNumber;
	}();

	var MapDataEntry = new r.Struct({
	  entry: new VariableSizeNumber(function (t) {
	    return ((t.parent.entryFormat & 0x0030) >> 4) + 1;
	  }),
	  outerIndex: function outerIndex(t) {
	    return t.entry >> (t.parent.entryFormat & 0x000F) + 1;
	  },
	  innerIndex: function innerIndex(t) {
	    return t.entry & (1 << (t.parent.entryFormat & 0x000F) + 1) - 1;
	  }
	});

	var DeltaSetIndexMap = new r.Struct({
	  entryFormat: r.uint16,
	  mapCount: r.uint16,
	  mapData: new r.Array(MapDataEntry, 'mapCount')
	});

	var HVAR = new r.Struct({
	  majorVersion: r.uint16,
	  minorVersion: r.uint16,
	  itemVariationStore: new r.Pointer(r.uint32, ItemVariationStore),
	  advanceWidthMapping: new r.Pointer(r.uint32, DeltaSetIndexMap),
	  LSBMapping: new r.Pointer(r.uint32, DeltaSetIndexMap),
	  RSBMapping: new r.Pointer(r.uint32, DeltaSetIndexMap)
	});

	var Signature = new r.Struct({
	  format: r.uint32,
	  length: r.uint32,
	  offset: r.uint32
	});

	var SignatureBlock = new r.Struct({
	  reserved: new r.Reserved(r.uint16, 2),
	  cbSignature: r.uint32, // Length (in bytes) of the PKCS#7 packet in pbSignature
	  signature: new r.Buffer('cbSignature')
	});

	var DSIG = new r.Struct({
	  ulVersion: r.uint32, // Version number of the DSIG table (0x00000001)
	  usNumSigs: r.uint16, // Number of signatures in the table
	  usFlag: r.uint16, // Permission flags
	  signatures: new r.Array(Signature, 'usNumSigs'),
	  signatureBlocks: new r.Array(SignatureBlock, 'usNumSigs')
	});

	var GaspRange = new r.Struct({
	  rangeMaxPPEM: r.uint16, // Upper limit of range, in ppem
	  rangeGaspBehavior: new r.Bitfield(r.uint16, [// Flags describing desired rasterizer behavior
	  'grayscale', 'gridfit', 'symmetricSmoothing', 'symmetricGridfit' // only in version 1, for ClearType
	  ])
	});

	var gasp = new r.Struct({
	  version: r.uint16, // set to 0
	  numRanges: r.uint16,
	  gaspRanges: new r.Array(GaspRange, 'numRanges') // Sorted by ppem
	});

	var DeviceRecord = new r.Struct({
	  pixelSize: r.uint8,
	  maximumWidth: r.uint8,
	  widths: new r.Array(r.uint8, function (t) {
	    return t.parent.parent.maxp.numGlyphs;
	  })
	});

	// The Horizontal Device Metrics table stores integer advance widths scaled to particular pixel sizes
	var hdmx = new r.Struct({
	  version: r.uint16,
	  numRecords: r.int16,
	  sizeDeviceRecord: r.int32,
	  records: new r.Array(DeviceRecord, 'numRecords')
	});

	var KernPair = new r.Struct({
	  left: r.uint16,
	  right: r.uint16,
	  value: r.int16
	});

	var ClassTable = new r.Struct({
	  firstGlyph: r.uint16,
	  nGlyphs: r.uint16,
	  offsets: new r.Array(r.uint16, 'nGlyphs'),
	  max: function max(t) {
	    return t.offsets.length && Math.max.apply(Math, t.offsets);
	  }
	});

	var Kern2Array = new r.Struct({
	  off: function off(t) {
	    return t._startOffset - t.parent.parent._startOffset;
	  },
	  len: function len(t) {
	    return ((t.parent.leftTable.max - t.off) / t.parent.rowWidth + 1) * (t.parent.rowWidth / 2);
	  },
	  values: new r.LazyArray(r.int16, 'len')
	});

	var KernSubtable = new r.VersionedStruct('format', {
	  0: {
	    nPairs: r.uint16,
	    searchRange: r.uint16,
	    entrySelector: r.uint16,
	    rangeShift: r.uint16,
	    pairs: new r.Array(KernPair, 'nPairs')
	  },

	  2: {
	    rowWidth: r.uint16,
	    leftTable: new r.Pointer(r.uint16, ClassTable, { type: 'parent' }),
	    rightTable: new r.Pointer(r.uint16, ClassTable, { type: 'parent' }),
	    array: new r.Pointer(r.uint16, Kern2Array, { type: 'parent' })
	  },

	  3: {
	    glyphCount: r.uint16,
	    kernValueCount: r.uint8,
	    leftClassCount: r.uint8,
	    rightClassCount: r.uint8,
	    flags: r.uint8,
	    kernValue: new r.Array(r.int16, 'kernValueCount'),
	    leftClass: new r.Array(r.uint8, 'glyphCount'),
	    rightClass: new r.Array(r.uint8, 'glyphCount'),
	    kernIndex: new r.Array(r.uint8, function (t) {
	      return t.leftClassCount * t.rightClassCount;
	    })
	  }
	});

	var KernTable = new r.VersionedStruct('version', {
	  0: { // Microsoft uses this format
	    subVersion: r.uint16, // Microsoft has an extra sub-table version number
	    length: r.uint16, // Length of the subtable, in bytes
	    format: r.uint8, // Format of subtable
	    coverage: new r.Bitfield(r.uint8, ['horizontal', // 1 if table has horizontal data, 0 if vertical
	    'minimum', // If set to 1, the table has minimum values. If set to 0, the table has kerning values.
	    'crossStream', // If set to 1, kerning is perpendicular to the flow of the text
	    'override' // If set to 1 the value in this table replaces the accumulated value
	    ]),
	    subtable: KernSubtable,
	    padding: new r.Reserved(r.uint8, function (t) {
	      return t.length - t._currentOffset;
	    })
	  },
	  1: { // Apple uses this format
	    length: r.uint32,
	    coverage: new r.Bitfield(r.uint8, [null, null, null, null, null, 'variation', // Set if table has variation kerning values
	    'crossStream', // Set if table has cross-stream kerning values
	    'vertical' // Set if table has vertical kerning values
	    ]),
	    format: r.uint8,
	    tupleIndex: r.uint16,
	    subtable: KernSubtable,
	    padding: new r.Reserved(r.uint8, function (t) {
	      return t.length - t._currentOffset;
	    })
	  }
	});

	var kern = new r.VersionedStruct(r.uint16, {
	  0: { // Microsoft Version
	    nTables: r.uint16,
	    tables: new r.Array(KernTable, 'nTables')
	  },

	  1: { // Apple Version
	    reserved: new r.Reserved(r.uint16), // the other half of the version number
	    nTables: r.uint32,
	    tables: new r.Array(KernTable, 'nTables')
	  }
	});

	// Linear Threshold table
	// Records the ppem for each glyph at which the scaling becomes linear again,
	// despite instructions effecting the advance width
	var LTSH = new r.Struct({
	  version: r.uint16,
	  numGlyphs: r.uint16,
	  yPels: new r.Array(r.uint8, 'numGlyphs')
	});

	// PCL 5 Table
	// NOTE: The PCLT table is strongly discouraged for OpenType fonts with TrueType outlines
	var PCLT = new r.Struct({
	  version: r.uint16,
	  fontNumber: r.uint32,
	  pitch: r.uint16,
	  xHeight: r.uint16,
	  style: r.uint16,
	  typeFamily: r.uint16,
	  capHeight: r.uint16,
	  symbolSet: r.uint16,
	  typeface: new r.String(16),
	  characterComplement: new r.String(8),
	  fileName: new r.String(6),
	  strokeWeight: new r.String(1),
	  widthType: new r.String(1),
	  serifStyle: r.uint8,
	  reserved: new r.Reserved(r.uint8)
	});

	// VDMX tables contain ascender/descender overrides for certain (usually small)
	// sizes. This is needed in order to match font metrics on Windows.

	var Ratio = new r.Struct({
	  bCharSet: r.uint8, // Character set
	  xRatio: r.uint8, // Value to use for x-Ratio
	  yStartRatio: r.uint8, // Starting y-Ratio value
	  yEndRatio: r.uint8 // Ending y-Ratio value
	});

	var vTable = new r.Struct({
	  yPelHeight: r.uint16, // yPelHeight to which values apply
	  yMax: r.int16, // Maximum value (in pels) for this yPelHeight
	  yMin: r.int16 // Minimum value (in pels) for this yPelHeight
	});

	var VdmxGroup = new r.Struct({
	  recs: r.uint16, // Number of height records in this group
	  startsz: r.uint8, // Starting yPelHeight
	  endsz: r.uint8, // Ending yPelHeight
	  entries: new r.Array(vTable, 'recs') // The VDMX records
	});

	var VDMX = new r.Struct({
	  version: r.uint16, // Version number (0 or 1)
	  numRecs: r.uint16, // Number of VDMX groups present
	  numRatios: r.uint16, // Number of aspect ratio groupings
	  ratioRanges: new r.Array(Ratio, 'numRatios'), // Ratio ranges
	  offsets: new r.Array(r.uint16, 'numRatios'), // Offset to the VDMX group for this ratio range
	  groups: new r.Array(VdmxGroup, 'numRecs') // The actual VDMX groupings
	});

	// Vertical Header Table
	var vhea = new r.Struct({
	  version: r.uint16, // Version number of the Vertical Header Table
	  ascent: r.int16, // The vertical typographic ascender for this font
	  descent: r.int16, // The vertical typographic descender for this font
	  lineGap: r.int16, // The vertical typographic line gap for this font
	  advanceHeightMax: r.int16, // The maximum advance height measurement found in the font
	  minTopSideBearing: r.int16, // The minimum top side bearing measurement found in the font
	  minBottomSideBearing: r.int16, // The minimum bottom side bearing measurement found in the font
	  yMaxExtent: r.int16,
	  caretSlopeRise: r.int16, // Caret slope (rise/run)
	  caretSlopeRun: r.int16,
	  caretOffset: r.int16, // Set value equal to 0 for nonslanted fonts
	  reserved: new r.Reserved(r.int16, 4),
	  metricDataFormat: r.int16, // Set to 0
	  numberOfMetrics: r.uint16 // Number of advance heights in the Vertical Metrics table
	});

	var VmtxEntry = new r.Struct({
	  advance: r.uint16, // The advance height of the glyph
	  bearing: r.int16 // The top sidebearing of the glyph
	});

	// Vertical Metrics Table
	var vmtx = new r.Struct({
	  metrics: new r.LazyArray(VmtxEntry, function (t) {
	    return t.parent.vhea.numberOfMetrics;
	  }),
	  bearings: new r.LazyArray(r.int16, function (t) {
	    return t.parent.maxp.numGlyphs - t.parent.vhea.numberOfMetrics;
	  })
	});

	var shortFrac = new r.Fixed(16, 'BE', 14);

	var Correspondence = new r.Struct({
	  fromCoord: shortFrac,
	  toCoord: shortFrac
	});

	var Segment = new r.Struct({
	  pairCount: r.uint16,
	  correspondence: new r.Array(Correspondence, 'pairCount')
	});

	var avar = new r.Struct({
	  version: r.fixed32,
	  axisCount: r.uint32,
	  segment: new r.Array(Segment, 'axisCount')
	});

	var UnboundedArrayAccessor = function () {
	  function UnboundedArrayAccessor(type, stream, parent) {
	    _classCallCheck(this, UnboundedArrayAccessor);

	    this.type = type;
	    this.stream = stream;
	    this.parent = parent;
	    this.base = this.stream.pos;
	    this._items = [];
	  }

	  UnboundedArrayAccessor.prototype.getItem = function getItem(index) {
	    if (this._items[index] == null) {
	      var pos = this.stream.pos;
	      this.stream.pos = this.base + this.type.size(null, this.parent) * index;
	      this._items[index] = this.type.decode(this.stream, this.parent);
	      this.stream.pos = pos;
	    }

	    return this._items[index];
	  };

	  UnboundedArrayAccessor.prototype.inspect = function inspect() {
	    return '[UnboundedArray ' + this.type.constructor.name + ']';
	  };

	  return UnboundedArrayAccessor;
	}();

	var UnboundedArray = function (_r$Array) {
	  _inherits(UnboundedArray, _r$Array);

	  function UnboundedArray(type) {
	    _classCallCheck(this, UnboundedArray);

	    return _possibleConstructorReturn(this, _r$Array.call(this, type, 0));
	  }

	  UnboundedArray.prototype.decode = function decode(stream, parent) {
	    return new UnboundedArrayAccessor(this.type, stream, parent);
	  };

	  return UnboundedArray;
	}(r.Array);

	var LookupTable = function LookupTable() {
	  var ValueType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : r.uint16;

	  // Helper class that makes internal structures invisible to pointers
	  var Shadow = function () {
	    function Shadow(type) {
	      _classCallCheck(this, Shadow);

	      this.type = type;
	    }

	    Shadow.prototype.decode = function decode(stream, ctx) {
	      ctx = ctx.parent.parent;
	      return this.type.decode(stream, ctx);
	    };

	    Shadow.prototype.size = function size(val, ctx) {
	      ctx = ctx.parent.parent;
	      return this.type.size(val, ctx);
	    };

	    Shadow.prototype.encode = function encode(stream, val, ctx) {
	      ctx = ctx.parent.parent;
	      return this.type.encode(stream, val, ctx);
	    };

	    return Shadow;
	  }();

	  ValueType = new Shadow(ValueType);

	  var BinarySearchHeader = new r.Struct({
	    unitSize: r.uint16,
	    nUnits: r.uint16,
	    searchRange: r.uint16,
	    entrySelector: r.uint16,
	    rangeShift: r.uint16
	  });

	  var LookupSegmentSingle = new r.Struct({
	    lastGlyph: r.uint16,
	    firstGlyph: r.uint16,
	    value: ValueType
	  });

	  var LookupSegmentArray = new r.Struct({
	    lastGlyph: r.uint16,
	    firstGlyph: r.uint16,
	    values: new r.Pointer(r.uint16, new r.Array(ValueType, function (t) {
	      return t.lastGlyph - t.firstGlyph + 1;
	    }), { type: 'parent' })
	  });

	  var LookupSingle = new r.Struct({
	    glyph: r.uint16,
	    value: ValueType
	  });

	  return new r.VersionedStruct(r.uint16, {
	    0: {
	      values: new UnboundedArray(ValueType) // length == number of glyphs maybe?
	    },
	    2: {
	      binarySearchHeader: BinarySearchHeader,
	      segments: new r.Array(LookupSegmentSingle, function (t) {
	        return t.binarySearchHeader.nUnits;
	      })
	    },
	    4: {
	      binarySearchHeader: BinarySearchHeader,
	      segments: new r.Array(LookupSegmentArray, function (t) {
	        return t.binarySearchHeader.nUnits;
	      })
	    },
	    6: {
	      binarySearchHeader: BinarySearchHeader,
	      segments: new r.Array(LookupSingle, function (t) {
	        return t.binarySearchHeader.nUnits;
	      })
	    },
	    8: {
	      firstGlyph: r.uint16,
	      count: r.uint16,
	      values: new r.Array(ValueType, 'count')
	    }
	  });
	};

	function StateTable() {
	  var entryData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	  var lookupType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : r.uint16;

	  var entry = _Object$assign({
	    newState: r.uint16,
	    flags: r.uint16
	  }, entryData);

	  var Entry = new r.Struct(entry);
	  var StateArray = new UnboundedArray(new r.Array(r.uint16, function (t) {
	    return t.nClasses;
	  }));

	  var StateHeader = new r.Struct({
	    nClasses: r.uint32,
	    classTable: new r.Pointer(r.uint32, new LookupTable(lookupType)),
	    stateArray: new r.Pointer(r.uint32, StateArray),
	    entryTable: new r.Pointer(r.uint32, new UnboundedArray(Entry))
	  });

	  return StateHeader;
	}

	// This is the old version of the StateTable structure
	function StateTable1() {
	  var entryData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	  var lookupType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : r.uint16;

	  var ClassLookupTable = new r.Struct({
	    version: function version() {
	      return 8;
	    },
	    // simulate LookupTable
	    firstGlyph: r.uint16,
	    values: new r.Array(r.uint8, r.uint16)
	  });

	  var entry = _Object$assign({
	    newStateOffset: r.uint16,
	    // convert offset to stateArray index
	    newState: function newState(t) {
	      return (t.newStateOffset - (t.parent.stateArray.base - t.parent._startOffset)) / t.parent.nClasses;
	    },
	    flags: r.uint16
	  }, entryData);

	  var Entry = new r.Struct(entry);
	  var StateArray = new UnboundedArray(new r.Array(r.uint8, function (t) {
	    return t.nClasses;
	  }));

	  var StateHeader1 = new r.Struct({
	    nClasses: r.uint16,
	    classTable: new r.Pointer(r.uint16, ClassLookupTable),
	    stateArray: new r.Pointer(r.uint16, StateArray),
	    entryTable: new r.Pointer(r.uint16, new UnboundedArray(Entry))
	  });

	  return StateHeader1;
	}

	var BslnSubtable = new r.VersionedStruct('format', {
	  0: { // Distance-based, no mapping
	    deltas: new r.Array(r.int16, 32)
	  },

	  1: { // Distance-based, with mapping
	    deltas: new r.Array(r.int16, 32),
	    mappingData: new LookupTable(r.uint16)
	  },

	  2: { // Control point-based, no mapping
	    standardGlyph: r.uint16,
	    controlPoints: new r.Array(r.uint16, 32)
	  },

	  3: { // Control point-based, with mapping
	    standardGlyph: r.uint16,
	    controlPoints: new r.Array(r.uint16, 32),
	    mappingData: new LookupTable(r.uint16)
	  }
	});

	var bsln = new r.Struct({
	  version: r.fixed32,
	  format: r.uint16,
	  defaultBaseline: r.uint16,
	  subtable: BslnSubtable
	});

	var Setting = new r.Struct({
	  setting: r.uint16,
	  nameIndex: r.int16,
	  name: function name(t) {
	    return t.parent.parent.parent.name.records.fontFeatures[t.nameIndex];
	  }
	});

	var FeatureName = new r.Struct({
	  feature: r.uint16,
	  nSettings: r.uint16,
	  settingTable: new r.Pointer(r.uint32, new r.Array(Setting, 'nSettings'), { type: 'parent' }),
	  featureFlags: new r.Bitfield(r.uint8, [null, null, null, null, null, null, 'hasDefault', 'exclusive']),
	  defaultSetting: r.uint8,
	  nameIndex: r.int16,
	  name: function name(t) {
	    return t.parent.parent.name.records.fontFeatures[t.nameIndex];
	  }
	});

	var feat = new r.Struct({
	  version: r.fixed32,
	  featureNameCount: r.uint16,
	  reserved1: new r.Reserved(r.uint16),
	  reserved2: new r.Reserved(r.uint32),
	  featureNames: new r.Array(FeatureName, 'featureNameCount')
	});

	var Axis$1 = new r.Struct({
	  axisTag: new r.String(4),
	  minValue: r.fixed32,
	  defaultValue: r.fixed32,
	  maxValue: r.fixed32,
	  flags: r.uint16,
	  nameID: r.uint16,
	  name: function name(t) {
	    return t.parent.parent.name.records.fontFeatures[t.nameID];
	  }
	});

	var Instance = new r.Struct({
	  nameID: r.uint16,
	  name: function name(t) {
	    return t.parent.parent.name.records.fontFeatures[t.nameID];
	  },
	  flags: r.uint16,
	  coord: new r.Array(r.fixed32, function (t) {
	    return t.parent.axisCount;
	  }),
	  postscriptNameID: new r.Optional(r.uint16, function (t) {
	    return t.parent.instanceSize - t._currentOffset > 0;
	  })
	});

	var fvar = new r.Struct({
	  version: r.fixed32,
	  offsetToData: r.uint16,
	  countSizePairs: r.uint16,
	  axisCount: r.uint16,
	  axisSize: r.uint16,
	  instanceCount: r.uint16,
	  instanceSize: r.uint16,
	  axis: new r.Array(Axis$1, 'axisCount'),
	  instance: new r.Array(Instance, 'instanceCount')
	});

	var shortFrac$1 = new r.Fixed(16, 'BE', 14);

	var Offset = function () {
	  function Offset() {
	    _classCallCheck(this, Offset);
	  }

	  Offset.decode = function decode(stream, parent) {
	    // In short format, offsets are multiplied by 2.
	    // This doesn't seem to be documented by Apple, but it
	    // is implemented this way in Freetype.
	    return parent.flags ? stream.readUInt32BE() : stream.readUInt16BE() * 2;
	  };

	  return Offset;
	}();

	var gvar = new r.Struct({
	  version: r.uint16,
	  reserved: new r.Reserved(r.uint16),
	  axisCount: r.uint16,
	  globalCoordCount: r.uint16,
	  globalCoords: new r.Pointer(r.uint32, new r.Array(new r.Array(shortFrac$1, 'axisCount'), 'globalCoordCount')),
	  glyphCount: r.uint16,
	  flags: r.uint16,
	  offsetToData: r.uint32,
	  offsets: new r.Array(new r.Pointer(Offset, 'void', { relativeTo: 'offsetToData', allowNull: false }), function (t) {
	    return t.glyphCount + 1;
	  })
	});

	var ClassTable$1 = new r.Struct({
	  length: r.uint16,
	  coverage: r.uint16,
	  subFeatureFlags: r.uint32,
	  stateTable: new StateTable1()
	});

	var WidthDeltaRecord = new r.Struct({
	  justClass: r.uint32,
	  beforeGrowLimit: r.fixed32,
	  beforeShrinkLimit: r.fixed32,
	  afterGrowLimit: r.fixed32,
	  afterShrinkLimit: r.fixed32,
	  growFlags: r.uint16,
	  shrinkFlags: r.uint16
	});

	var WidthDeltaCluster = new r.Array(WidthDeltaRecord, r.uint32);

	var ActionData = new r.VersionedStruct('actionType', {
	  0: { // Decomposition action
	    lowerLimit: r.fixed32,
	    upperLimit: r.fixed32,
	    order: r.uint16,
	    glyphs: new r.Array(r.uint16, r.uint16)
	  },

	  1: { // Unconditional add glyph action
	    addGlyph: r.uint16
	  },

	  2: { // Conditional add glyph action
	    substThreshold: r.fixed32,
	    addGlyph: r.uint16,
	    substGlyph: r.uint16
	  },

	  3: {}, // Stretch glyph action (no data, not supported by CoreText)

	  4: { // Ductile glyph action (not supported by CoreText)
	    variationAxis: r.uint32,
	    minimumLimit: r.fixed32,
	    noStretchValue: r.fixed32,
	    maximumLimit: r.fixed32
	  },

	  5: { // Repeated add glyph action
	    flags: r.uint16,
	    glyph: r.uint16
	  }
	});

	var Action = new r.Struct({
	  actionClass: r.uint16,
	  actionType: r.uint16,
	  actionLength: r.uint32,
	  actionData: ActionData,
	  padding: new r.Reserved(r.uint8, function (t) {
	    return t.actionLength - t._currentOffset;
	  })
	});

	var PostcompensationAction = new r.Array(Action, r.uint32);
	var PostCompensationTable = new r.Struct({
	  lookupTable: new LookupTable(new r.Pointer(r.uint16, PostcompensationAction))
	});

	var JustificationTable = new r.Struct({
	  classTable: new r.Pointer(r.uint16, ClassTable$1, { type: 'parent' }),
	  wdcOffset: r.uint16,
	  postCompensationTable: new r.Pointer(r.uint16, PostCompensationTable, { type: 'parent' }),
	  widthDeltaClusters: new LookupTable(new r.Pointer(r.uint16, WidthDeltaCluster, { type: 'parent', relativeTo: 'wdcOffset' }))
	});

	var just = new r.Struct({
	  version: r.uint32,
	  format: r.uint16,
	  horizontal: new r.Pointer(r.uint16, JustificationTable),
	  vertical: new r.Pointer(r.uint16, JustificationTable)
	});

	var LigatureData = {
	  action: r.uint16
	};

	var ContextualData = {
	  markIndex: r.uint16,
	  currentIndex: r.uint16
	};

	var InsertionData = {
	  currentInsertIndex: r.uint16,
	  markedInsertIndex: r.uint16
	};

	var SubstitutionTable = new r.Struct({
	  items: new UnboundedArray(new r.Pointer(r.uint32, new LookupTable()))
	});

	var SubtableData = new r.VersionedStruct('type', {
	  0: { // Indic Rearrangement Subtable
	    stateTable: new StateTable()
	  },

	  1: { // Contextual Glyph Substitution Subtable
	    stateTable: new StateTable(ContextualData),
	    substitutionTable: new r.Pointer(r.uint32, SubstitutionTable)
	  },

	  2: { // Ligature subtable
	    stateTable: new StateTable(LigatureData),
	    ligatureActions: new r.Pointer(r.uint32, new UnboundedArray(r.uint32)),
	    components: new r.Pointer(r.uint32, new UnboundedArray(r.uint16)),
	    ligatureList: new r.Pointer(r.uint32, new UnboundedArray(r.uint16))
	  },

	  4: { // Non-contextual Glyph Substitution Subtable
	    lookupTable: new LookupTable()
	  },

	  5: { // Glyph Insertion Subtable
	    stateTable: new StateTable(InsertionData),
	    insertionActions: new r.Pointer(r.uint32, new UnboundedArray(r.uint16))
	  }
	});

	var Subtable = new r.Struct({
	  length: r.uint32,
	  coverage: r.uint24,
	  type: r.uint8,
	  subFeatureFlags: r.uint32,
	  table: SubtableData,
	  padding: new r.Reserved(r.uint8, function (t) {
	    return t.length - t._currentOffset;
	  })
	});

	var FeatureEntry = new r.Struct({
	  featureType: r.uint16,
	  featureSetting: r.uint16,
	  enableFlags: r.uint32,
	  disableFlags: r.uint32
	});

	var MorxChain = new r.Struct({
	  defaultFlags: r.uint32,
	  chainLength: r.uint32,
	  nFeatureEntries: r.uint32,
	  nSubtables: r.uint32,
	  features: new r.Array(FeatureEntry, 'nFeatureEntries'),
	  subtables: new r.Array(Subtable, 'nSubtables')
	});

	var morx = new r.Struct({
	  version: r.uint16,
	  unused: new r.Reserved(r.uint16),
	  nChains: r.uint32,
	  chains: new r.Array(MorxChain, 'nChains')
	});

	var OpticalBounds = new r.Struct({
	  left: r.int16,
	  top: r.int16,
	  right: r.int16,
	  bottom: r.int16
	});

	var opbd = new r.Struct({
	  version: r.fixed32,
	  format: r.uint16,
	  lookupTable: new LookupTable(OpticalBounds)
	});

	var tables = {};
	// Required Tables
	tables.cmap = cmap;
	tables.head = head;
	tables.hhea = hhea;
	tables.hmtx = hmtx;
	tables.maxp = maxp;
	tables.name = NameTable;
	tables['OS/2'] = OS2;
	tables.post = post;

	// TrueType Outlines
	tables.fpgm = fpgm;
	tables.loca = loca;
	tables.prep = prep;
	tables['cvt '] = cvt;
	tables.glyf = glyf;

	// PostScript Outlines
	tables['CFF '] = CFFFont;
	tables['CFF2'] = CFFFont;
	tables.VORG = VORG;

	// Bitmap Glyphs
	tables.EBLC = EBLC;
	tables.CBLC = tables.EBLC;
	tables.sbix = sbix;
	tables.COLR = COLR;
	tables.CPAL = CPAL;

	// Advanced OpenType Tables
	tables.BASE = BASE;
	tables.GDEF = GDEF;
	tables.GPOS = GPOS;
	tables.GSUB = GSUB;
	tables.JSTF = JSTF;

	// OpenType variations tables
	tables.HVAR = HVAR;

	// Other OpenType Tables
	tables.DSIG = DSIG;
	tables.gasp = gasp;
	tables.hdmx = hdmx;
	tables.kern = kern;
	tables.LTSH = LTSH;
	tables.PCLT = PCLT;
	tables.VDMX = VDMX;
	tables.vhea = vhea;
	tables.vmtx = vmtx;

	// Apple Advanced Typography Tables
	tables.avar = avar;
	tables.bsln = bsln;
	tables.feat = feat;
	tables.fvar = fvar;
	tables.gvar = gvar;
	tables.just = just;
	tables.morx = morx;
	tables.opbd = opbd;

	var TableEntry = new r.Struct({
	  tag: new r.String(4),
	  checkSum: r.uint32,
	  offset: new r.Pointer(r.uint32, 'void', { type: 'global' }),
	  length: r.uint32
	});

	var Directory = new r.Struct({
	  tag: new r.String(4),
	  numTables: r.uint16,
	  searchRange: r.uint16,
	  entrySelector: r.uint16,
	  rangeShift: r.uint16,
	  tables: new r.Array(TableEntry, 'numTables')
	});

	Directory.process = function () {
	  var tables = {};
	  for (var _iterator = this.tables, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	    var _ref;

	    if (_isArray) {
	      if (_i >= _iterator.length) break;
	      _ref = _iterator[_i++];
	    } else {
	      _i = _iterator.next();
	      if (_i.done) break;
	      _ref = _i.value;
	    }

	    var table = _ref;

	    tables[table.tag] = table;
	  }

	  this.tables = tables;
	};

	Directory.preEncode = function (stream) {
	  var tables$$ = [];
	  for (var tag in this.tables) {
	    var table = this.tables[tag];
	    if (table) {
	      tables$$.push({
	        tag: tag,
	        checkSum: 0,
	        offset: new r.VoidPointer(tables[tag], table),
	        length: tables[tag].size(table)
	      });
	    }
	  }

	  this.tag = 'true';
	  this.numTables = tables$$.length;
	  this.tables = tables$$;

	  this.searchRange = Math.floor(Math.log(this.numTables) / Math.LN2) * 16;
	  this.entrySelector = Math.floor(this.searchRange / Math.LN2);
	  this.rangeShift = this.numTables * 16 - this.searchRange;
	};

	function binarySearch(arr, cmp) {
	  var min = 0;
	  var max = arr.length - 1;
	  while (min <= max) {
	    var mid = min + max >> 1;
	    var res = cmp(arr[mid]);

	    if (res < 0) {
	      max = mid - 1;
	    } else if (res > 0) {
	      min = mid + 1;
	    } else {
	      return mid;
	    }
	  }

	  return -1;
	}

	function range(index, end) {
	  var range = [];
	  while (index < end) {
	    range.push(index++);
	  }
	  return range;
	}

	var _class$1;
	function _applyDecoratedDescriptor$1(target, property, decorators, descriptor, context) {
	  var desc = {};
	  Object['ke' + 'ys'](descriptor).forEach(function (key) {
	    desc[key] = descriptor[key];
	  });
	  desc.enumerable = !!desc.enumerable;
	  desc.configurable = !!desc.configurable;

	  if ('value' in desc || desc.initializer) {
	    desc.writable = true;
	  }

	  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
	    return decorator(target, property, desc) || desc;
	  }, desc);

	  if (context && desc.initializer !== void 0) {
	    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
	    desc.initializer = undefined;
	  }

	  if (desc.initializer === void 0) {
	    Object['define' + 'Property'](target, property, desc);
	    desc = null;
	  }

	  return desc;
	}

	// iconv-lite is an optional dependency.
	try {
	  var iconv = __webpack_require__(85);
	} catch (err) {}

	var CmapProcessor = (_class$1 = function () {
	  function CmapProcessor(cmapTable) {
	    _classCallCheck(this, CmapProcessor);

	    // Attempt to find a Unicode cmap first
	    this.encoding = null;
	    this.cmap = this.findSubtable(cmapTable, [
	    // 32-bit subtables
	    [3, 10], [0, 6], [0, 4],

	    // 16-bit subtables
	    [3, 1], [0, 3], [0, 2], [0, 1], [0, 0]]);

	    // If not unicode cmap was found, and iconv-lite is installed,
	    // take the first table with a supported encoding.
	    if (!this.cmap && iconv) {
	      for (var _iterator = cmapTable.tables, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	        var _ref;

	        if (_isArray) {
	          if (_i >= _iterator.length) break;
	          _ref = _iterator[_i++];
	        } else {
	          _i = _iterator.next();
	          if (_i.done) break;
	          _ref = _i.value;
	        }

	        var cmap = _ref;

	        var encoding = getEncoding(cmap.platformID, cmap.encodingID, cmap.table.language - 1);
	        if (iconv.encodingExists(encoding)) {
	          this.cmap = cmap.table;
	          this.encoding = encoding;
	        }
	      }
	    }

	    if (!this.cmap) {
	      throw new Error("Could not find a supported cmap table");
	    }

	    this.uvs = this.findSubtable(cmapTable, [[0, 5]]);
	    if (this.uvs && this.uvs.version !== 14) {
	      this.uvs = null;
	    }
	  }

	  CmapProcessor.prototype.findSubtable = function findSubtable(cmapTable, pairs) {
	    for (var _iterator2 = pairs, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	      var _ref2;

	      if (_isArray2) {
	        if (_i2 >= _iterator2.length) break;
	        _ref2 = _iterator2[_i2++];
	      } else {
	        _i2 = _iterator2.next();
	        if (_i2.done) break;
	        _ref2 = _i2.value;
	      }

	      var _ref3 = _ref2,
	          platformID = _ref3[0],
	          encodingID = _ref3[1];

	      for (var _iterator3 = cmapTable.tables, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	        var _ref4;

	        if (_isArray3) {
	          if (_i3 >= _iterator3.length) break;
	          _ref4 = _iterator3[_i3++];
	        } else {
	          _i3 = _iterator3.next();
	          if (_i3.done) break;
	          _ref4 = _i3.value;
	        }

	        var cmap = _ref4;

	        if (cmap.platformID === platformID && cmap.encodingID === encodingID) {
	          return cmap.table;
	        }
	      }
	    }

	    return null;
	  };

	  CmapProcessor.prototype.lookup = function lookup(codepoint, variationSelector) {
	    // If there is no Unicode cmap in this font, we need to re-encode
	    // the codepoint in the encoding that the cmap supports.
	    if (this.encoding) {
	      var buf = iconv.encode(_String$fromCodePoint(codepoint), this.encoding);
	      codepoint = 0;
	      for (var i = 0; i < buf.length; i++) {
	        codepoint = codepoint << 8 | buf[i];
	      }

	      // Otherwise, try to get a Unicode variation selector for this codepoint if one is provided.
	    } else if (variationSelector) {
	      var gid = this.getVariationSelector(codepoint, variationSelector);
	      if (gid) {
	        return gid;
	      }
	    }

	    var cmap = this.cmap;
	    switch (cmap.version) {
	      case 0:
	        return cmap.codeMap.get(codepoint) || 0;

	      case 4:
	        {
	          var min = 0;
	          var max = cmap.segCount - 1;
	          while (min <= max) {
	            var mid = min + max >> 1;

	            if (codepoint < cmap.startCode.get(mid)) {
	              max = mid - 1;
	            } else if (codepoint > cmap.endCode.get(mid)) {
	              min = mid + 1;
	            } else {
	              var rangeOffset = cmap.idRangeOffset.get(mid);
	              var _gid = void 0;

	              if (rangeOffset === 0) {
	                _gid = codepoint + cmap.idDelta.get(mid);
	              } else {
	                var index = rangeOffset / 2 + (codepoint - cmap.startCode.get(mid)) - (cmap.segCount - mid);
	                _gid = cmap.glyphIndexArray.get(index) || 0;
	                if (_gid !== 0) {
	                  _gid += cmap.idDelta.get(mid);
	                }
	              }

	              return _gid & 0xffff;
	            }
	          }

	          return 0;
	        }

	      case 8:
	        throw new Error('TODO: cmap format 8');

	      case 6:
	      case 10:
	        return cmap.glyphIndices.get(codepoint - cmap.firstCode) || 0;

	      case 12:
	      case 13:
	        {
	          var _min = 0;
	          var _max = cmap.nGroups - 1;
	          while (_min <= _max) {
	            var _mid = _min + _max >> 1;
	            var group = cmap.groups.get(_mid);

	            if (codepoint < group.startCharCode) {
	              _max = _mid - 1;
	            } else if (codepoint > group.endCharCode) {
	              _min = _mid + 1;
	            } else {
	              if (cmap.version === 12) {
	                return group.glyphID + (codepoint - group.startCharCode);
	              } else {
	                return group.glyphID;
	              }
	            }
	          }

	          return 0;
	        }

	      case 14:
	        throw new Error('TODO: cmap format 14');

	      default:
	        throw new Error('Unknown cmap format ' + cmap.version);
	    }
	  };

	  CmapProcessor.prototype.getVariationSelector = function getVariationSelector(codepoint, variationSelector) {
	    if (!this.uvs) {
	      return 0;
	    }

	    var selectors = this.uvs.varSelectors.toArray();
	    var i = binarySearch(selectors, function (x) {
	      return variationSelector - x.varSelector;
	    });
	    var sel = selectors[i];

	    if (i !== -1 && sel.defaultUVS) {
	      i = binarySearch(sel.defaultUVS, function (x) {
	        return codepoint < x.startUnicodeValue ? -1 : codepoint > x.startUnicodeValue + x.additionalCount ? +1 : 0;
	      });
	    }

	    if (i !== -1 && sel.nonDefaultUVS) {
	      i = binarySearch(sel.nonDefaultUVS, function (x) {
	        return codepoint - x.unicodeValue;
	      });
	      if (i !== -1) {
	        return sel.nonDefaultUVS[i].glyphID;
	      }
	    }

	    return 0;
	  };

	  CmapProcessor.prototype.getCharacterSet = function getCharacterSet() {
	    var cmap = this.cmap;
	    switch (cmap.version) {
	      case 0:
	        return range(0, cmap.codeMap.length);

	      case 4:
	        {
	          var res = [];
	          var endCodes = cmap.endCode.toArray();
	          for (var i = 0; i < endCodes.length; i++) {
	            var tail = endCodes[i] + 1;
	            var start = cmap.startCode.get(i);
	            res.push.apply(res, range(start, tail));
	          }

	          return res;
	        }

	      case 8:
	        throw new Error('TODO: cmap format 8');

	      case 6:
	      case 10:
	        return range(cmap.firstCode, cmap.firstCode + cmap.glyphIndices.length);

	      case 12:
	      case 13:
	        {
	          var _res = [];
	          for (var _iterator4 = cmap.groups.toArray(), _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : _getIterator(_iterator4);;) {
	            var _ref5;

	            if (_isArray4) {
	              if (_i4 >= _iterator4.length) break;
	              _ref5 = _iterator4[_i4++];
	            } else {
	              _i4 = _iterator4.next();
	              if (_i4.done) break;
	              _ref5 = _i4.value;
	            }

	            var group = _ref5;

	            _res.push.apply(_res, range(group.startCharCode, group.endCharCode + 1));
	          }

	          return _res;
	        }

	      case 14:
	        throw new Error('TODO: cmap format 14');

	      default:
	        throw new Error('Unknown cmap format ' + cmap.version);
	    }
	  };

	  CmapProcessor.prototype.codePointsForGlyph = function codePointsForGlyph(gid) {
	    var cmap = this.cmap;
	    switch (cmap.version) {
	      case 0:
	        {
	          var res = [];
	          for (var i = 0; i < 256; i++) {
	            if (cmap.codeMap.get(i) === gid) {
	              res.push(i);
	            }
	          }

	          return res;
	        }

	      case 4:
	        {
	          var _res2 = [];
	          for (var _i5 = 0; _i5 < cmap.segCount; _i5++) {
	            var end = cmap.endCode.get(_i5);
	            var start = cmap.startCode.get(_i5);
	            var rangeOffset = cmap.idRangeOffset.get(_i5);
	            var delta = cmap.idDelta.get(_i5);

	            for (var c = start; c <= end; c++) {
	              var g = 0;
	              if (rangeOffset === 0) {
	                g = c + delta;
	              } else {
	                var index = rangeOffset / 2 + (c - start) - (cmap.segCount - _i5);
	                g = cmap.glyphIndexArray.get(index) || 0;
	                if (g !== 0) {
	                  g += delta;
	                }
	              }

	              if (g === gid) {
	                _res2.push(c);
	              }
	            }
	          }

	          return _res2;
	        }

	      case 12:
	        {
	          var _res3 = [];
	          for (var _iterator5 = cmap.groups.toArray(), _isArray5 = Array.isArray(_iterator5), _i6 = 0, _iterator5 = _isArray5 ? _iterator5 : _getIterator(_iterator5);;) {
	            var _ref6;

	            if (_isArray5) {
	              if (_i6 >= _iterator5.length) break;
	              _ref6 = _iterator5[_i6++];
	            } else {
	              _i6 = _iterator5.next();
	              if (_i6.done) break;
	              _ref6 = _i6.value;
	            }

	            var group = _ref6;

	            if (gid >= group.glyphID && gid <= group.glyphID + (group.endCharCode - group.startCharCode)) {
	              _res3.push(group.startCharCode + (gid - group.glyphID));
	            }
	          }

	          return _res3;
	        }

	      case 13:
	        {
	          var _res4 = [];
	          for (var _iterator6 = cmap.groups.toArray(), _isArray6 = Array.isArray(_iterator6), _i7 = 0, _iterator6 = _isArray6 ? _iterator6 : _getIterator(_iterator6);;) {
	            var _ref7;

	            if (_isArray6) {
	              if (_i7 >= _iterator6.length) break;
	              _ref7 = _iterator6[_i7++];
	            } else {
	              _i7 = _iterator6.next();
	              if (_i7.done) break;
	              _ref7 = _i7.value;
	            }

	            var _group = _ref7;

	            if (gid === _group.glyphID) {
	              _res4.push.apply(_res4, range(_group.startCharCode, _group.endCharCode + 1));
	            }
	          }

	          return _res4;
	        }

	      default:
	        throw new Error('Unknown cmap format ' + cmap.version);
	    }
	  };

	  return CmapProcessor;
	}(), (_applyDecoratedDescriptor$1(_class$1.prototype, 'getCharacterSet', [cache], _Object$getOwnPropertyDescriptor(_class$1.prototype, 'getCharacterSet'), _class$1.prototype), _applyDecoratedDescriptor$1(_class$1.prototype, 'codePointsForGlyph', [cache], _Object$getOwnPropertyDescriptor(_class$1.prototype, 'codePointsForGlyph'), _class$1.prototype)), _class$1);

	var KernProcessor = function () {
	  function KernProcessor(font) {
	    _classCallCheck(this, KernProcessor);

	    this.kern = font.kern;
	  }

	  KernProcessor.prototype.process = function process(glyphs, positions) {
	    for (var glyphIndex = 0; glyphIndex < glyphs.length - 1; glyphIndex++) {
	      var left = glyphs[glyphIndex].id;
	      var right = glyphs[glyphIndex + 1].id;
	      positions[glyphIndex].xAdvance += this.getKerning(left, right);
	    }
	  };

	  KernProcessor.prototype.getKerning = function getKerning(left, right) {
	    var res = 0;

	    for (var _iterator = this.kern.tables, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var table = _ref;

	      if (table.coverage.crossStream) {
	        continue;
	      }

	      switch (table.version) {
	        case 0:
	          if (!table.coverage.horizontal) {
	            continue;
	          }

	          break;
	        case 1:
	          if (table.coverage.vertical || table.coverage.variation) {
	            continue;
	          }

	          break;
	        default:
	          throw new Error('Unsupported kerning table version ' + table.version);
	      }

	      var val = 0;
	      var s = table.subtable;
	      switch (table.format) {
	        case 0:
	          var pairIdx = binarySearch(s.pairs, function (pair) {
	            return left - pair.left || right - pair.right;
	          });

	          if (pairIdx >= 0) {
	            val = s.pairs[pairIdx].value;
	          }

	          break;

	        case 2:
	          var leftOffset = 0,
	              rightOffset = 0;
	          if (left >= s.leftTable.firstGlyph && left < s.leftTable.firstGlyph + s.leftTable.nGlyphs) {
	            leftOffset = s.leftTable.offsets[left - s.leftTable.firstGlyph];
	          } else {
	            leftOffset = s.array.off;
	          }

	          if (right >= s.rightTable.firstGlyph && right < s.rightTable.firstGlyph + s.rightTable.nGlyphs) {
	            rightOffset = s.rightTable.offsets[right - s.rightTable.firstGlyph];
	          }

	          var index = (leftOffset + rightOffset - s.array.off) / 2;
	          val = s.array.values.get(index);
	          break;

	        case 3:
	          if (left >= s.glyphCount || right >= s.glyphCount) {
	            return 0;
	          }

	          val = s.kernValue[s.kernIndex[s.leftClass[left] * s.rightClassCount + s.rightClass[right]]];
	          break;

	        default:
	          throw new Error('Unsupported kerning sub-table format ' + table.format);
	      }

	      // Microsoft supports the override flag, which resets the result
	      // Otherwise, the sum of the results from all subtables is returned
	      if (table.coverage.override) {
	        res = val;
	      } else {
	        res += val;
	      }
	    }

	    return res;
	  };

	  return KernProcessor;
	}();

	/**
	 * This class is used when GPOS does not define 'mark' or 'mkmk' features
	 * for positioning marks relative to base glyphs. It uses the unicode
	 * combining class property to position marks.
	 *
	 * Based on code from Harfbuzz, thanks!
	 * https://github.com/behdad/harfbuzz/blob/master/src/hb-ot-shape-fallback.cc
	 */

	var UnicodeLayoutEngine = function () {
	  function UnicodeLayoutEngine(font) {
	    _classCallCheck(this, UnicodeLayoutEngine);

	    this.font = font;
	  }

	  UnicodeLayoutEngine.prototype.positionGlyphs = function positionGlyphs(glyphs, positions) {
	    // find each base + mark cluster, and position the marks relative to the base
	    var clusterStart = 0;
	    var clusterEnd = 0;
	    for (var index = 0; index < glyphs.length; index++) {
	      var glyph = glyphs[index];
	      if (glyph.isMark) {
	        // TODO: handle ligatures
	        clusterEnd = index;
	      } else {
	        if (clusterStart !== clusterEnd) {
	          this.positionCluster(glyphs, positions, clusterStart, clusterEnd);
	        }

	        clusterStart = clusterEnd = index;
	      }
	    }

	    if (clusterStart !== clusterEnd) {
	      this.positionCluster(glyphs, positions, clusterStart, clusterEnd);
	    }

	    return positions;
	  };

	  UnicodeLayoutEngine.prototype.positionCluster = function positionCluster(glyphs, positions, clusterStart, clusterEnd) {
	    var base = glyphs[clusterStart];
	    var baseBox = base.cbox.copy();

	    // adjust bounding box for ligature glyphs
	    if (base.codePoints.length > 1) {
	      // LTR. TODO: RTL support.
	      baseBox.minX += (base.codePoints.length - 1) * baseBox.width / base.codePoints.length;
	    }

	    var xOffset = -positions[clusterStart].xAdvance;
	    var yOffset = 0;
	    var yGap = this.font.unitsPerEm / 16;

	    // position each of the mark glyphs relative to the base glyph
	    for (var index = clusterStart + 1; index <= clusterEnd; index++) {
	      var mark = glyphs[index];
	      var markBox = mark.cbox;
	      var position = positions[index];

	      var combiningClass = this.getCombiningClass(mark.codePoints[0]);

	      if (combiningClass !== 'Not_Reordered') {
	        position.xOffset = position.yOffset = 0;

	        // x positioning
	        switch (combiningClass) {
	          case 'Double_Above':
	          case 'Double_Below':
	            // LTR. TODO: RTL support.
	            position.xOffset += baseBox.minX - markBox.width / 2 - markBox.minX;
	            break;

	          case 'Attached_Below_Left':
	          case 'Below_Left':
	          case 'Above_Left':
	            // left align
	            position.xOffset += baseBox.minX - markBox.minX;
	            break;

	          case 'Attached_Above_Right':
	          case 'Below_Right':
	          case 'Above_Right':
	            // right align
	            position.xOffset += baseBox.maxX - markBox.width - markBox.minX;
	            break;

	          default:
	            // Attached_Below, Attached_Above, Below, Above, other
	            // center align
	            position.xOffset += baseBox.minX + (baseBox.width - markBox.width) / 2 - markBox.minX;
	        }

	        // y positioning
	        switch (combiningClass) {
	          case 'Double_Below':
	          case 'Below_Left':
	          case 'Below':
	          case 'Below_Right':
	          case 'Attached_Below_Left':
	          case 'Attached_Below':
	            // add a small gap between the glyphs if they are not attached
	            if (combiningClass === 'Attached_Below_Left' || combiningClass === 'Attached_Below') {
	              baseBox.minY += yGap;
	            }

	            position.yOffset = -baseBox.minY - markBox.maxY;
	            baseBox.minY += markBox.height;
	            break;

	          case 'Double_Above':
	          case 'Above_Left':
	          case 'Above':
	          case 'Above_Right':
	          case 'Attached_Above':
	          case 'Attached_Above_Right':
	            // add a small gap between the glyphs if they are not attached
	            if (combiningClass === 'Attached_Above' || combiningClass === 'Attached_Above_Right') {
	              baseBox.maxY += yGap;
	            }

	            position.yOffset = baseBox.maxY - markBox.minY;
	            baseBox.maxY += markBox.height;
	            break;
	        }

	        position.xAdvance = position.yAdvance = 0;
	        position.xOffset += xOffset;
	        position.yOffset += yOffset;
	      } else {
	        xOffset -= position.xAdvance;
	        yOffset -= position.yAdvance;
	      }
	    }

	    return;
	  };

	  UnicodeLayoutEngine.prototype.getCombiningClass = function getCombiningClass(codePoint) {
	    var combiningClass = unicode.getCombiningClass(codePoint);

	    // Thai / Lao need some per-character work
	    if ((codePoint & ~0xff) === 0x0e00) {
	      if (combiningClass === 'Not_Reordered') {
	        switch (codePoint) {
	          case 0x0e31:
	          case 0x0e34:
	          case 0x0e35:
	          case 0x0e36:
	          case 0x0e37:
	          case 0x0e47:
	          case 0x0e4c:
	          case 0x0e3d:
	          case 0x0e4e:
	            return 'Above_Right';

	          case 0x0eb1:
	          case 0x0eb4:
	          case 0x0eb5:
	          case 0x0eb6:
	          case 0x0eb7:
	          case 0x0ebb:
	          case 0x0ecc:
	          case 0x0ecd:
	            return 'Above';

	          case 0x0ebc:
	            return 'Below';
	        }
	      } else if (codePoint === 0x0e3a) {
	        // virama
	        return 'Below_Right';
	      }
	    }

	    switch (combiningClass) {
	      // Hebrew

	      case 'CCC10': // sheva
	      case 'CCC11': // hataf segol
	      case 'CCC12': // hataf patah
	      case 'CCC13': // hataf qamats
	      case 'CCC14': // hiriq
	      case 'CCC15': // tsere
	      case 'CCC16': // segol
	      case 'CCC17': // patah
	      case 'CCC18': // qamats
	      case 'CCC20': // qubuts
	      case 'CCC22':
	        // meteg
	        return 'Below';

	      case 'CCC23':
	        // rafe
	        return 'Attached_Above';

	      case 'CCC24':
	        // shin dot
	        return 'Above_Right';

	      case 'CCC25': // sin dot
	      case 'CCC19':
	        // holam
	        return 'Above_Left';

	      case 'CCC26':
	        // point varika
	        return 'Above';

	      case 'CCC21':
	        // dagesh
	        break;

	      // Arabic and Syriac

	      case 'CCC27': // fathatan
	      case 'CCC28': // dammatan
	      case 'CCC30': // fatha
	      case 'CCC31': // damma
	      case 'CCC33': // shadda
	      case 'CCC34': // sukun
	      case 'CCC35': // superscript alef
	      case 'CCC36':
	        // superscript alaph
	        return 'Above';

	      case 'CCC29': // kasratan
	      case 'CCC32':
	        // kasra
	        return 'Below';

	      // Thai

	      case 'CCC103':
	        // sara u / sara uu
	        return 'Below_Right';

	      case 'CCC107':
	        // mai
	        return 'Above_Right';

	      // Lao

	      case 'CCC118':
	        // sign u / sign uu
	        return 'Below';

	      case 'CCC122':
	        // mai
	        return 'Above';

	      // Tibetan

	      case 'CCC129': // sign aa
	      case 'CCC132':
	        // sign u
	        return 'Below';

	      case 'CCC130':
	        // sign i
	        return 'Above';
	    }

	    return combiningClass;
	  };

	  return UnicodeLayoutEngine;
	}();

	/**
	 * Represents a glyph bounding box
	 */
	var BBox = function () {
	  function BBox() {
	    var minX = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Infinity;
	    var minY = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Infinity;
	    var maxX = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : -Infinity;
	    var maxY = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : -Infinity;

	    _classCallCheck(this, BBox);

	    /**
	     * The minimum X position in the bounding box
	     * @type {number}
	     */
	    this.minX = minX;

	    /**
	     * The minimum Y position in the bounding box
	     * @type {number}
	     */
	    this.minY = minY;

	    /**
	     * The maxmimum X position in the bounding box
	     * @type {number}
	     */
	    this.maxX = maxX;

	    /**
	     * The maxmimum Y position in the bounding box
	     * @type {number}
	     */
	    this.maxY = maxY;
	  }

	  /**
	   * The width of the bounding box
	   * @type {number}
	   */


	  BBox.prototype.addPoint = function addPoint(x, y) {
	    if (Math.abs(x) !== Infinity) {
	      if (x < this.minX) {
	        this.minX = x;
	      }

	      if (x > this.maxX) {
	        this.maxX = x;
	      }
	    }

	    if (Math.abs(y) !== Infinity) {
	      if (y < this.minY) {
	        this.minY = y;
	      }

	      if (y > this.maxY) {
	        this.maxY = y;
	      }
	    }
	  };

	  BBox.prototype.copy = function copy() {
	    return new BBox(this.minX, this.minY, this.maxX, this.maxY);
	  };

	  _createClass(BBox, [{
	    key: "width",
	    get: function get() {
	      return this.maxX - this.minX;
	    }

	    /**
	     * The height of the bounding box
	     * @type {number}
	     */

	  }, {
	    key: "height",
	    get: function get() {
	      return this.maxY - this.minY;
	    }
	  }]);

	  return BBox;
	}();

	// This maps the Unicode Script property to an OpenType script tag
	// Data from http://www.microsoft.com/typography/otspec/scripttags.htm
	// and http://www.unicode.org/Public/UNIDATA/PropertyValueAliases.txt.
	var UNICODE_SCRIPTS = {
	  Caucasian_Albanian: 'aghb',
	  Arabic: 'arab',
	  Imperial_Aramaic: 'armi',
	  Armenian: 'armn',
	  Avestan: 'avst',
	  Balinese: 'bali',
	  Bamum: 'bamu',
	  Bassa_Vah: 'bass',
	  Batak: 'batk',
	  Bengali: ['bng2', 'beng'],
	  Bopomofo: 'bopo',
	  Brahmi: 'brah',
	  Braille: 'brai',
	  Buginese: 'bugi',
	  Buhid: 'buhd',
	  Chakma: 'cakm',
	  Canadian_Aboriginal: 'cans',
	  Carian: 'cari',
	  Cham: 'cham',
	  Cherokee: 'cher',
	  Coptic: 'copt',
	  Cypriot: 'cprt',
	  Cyrillic: 'cyrl',
	  Devanagari: ['dev2', 'deva'],
	  Deseret: 'dsrt',
	  Duployan: 'dupl',
	  Egyptian_Hieroglyphs: 'egyp',
	  Elbasan: 'elba',
	  Ethiopic: 'ethi',
	  Georgian: 'geor',
	  Glagolitic: 'glag',
	  Gothic: 'goth',
	  Grantha: 'gran',
	  Greek: 'grek',
	  Gujarati: ['gjr2', 'gujr'],
	  Gurmukhi: ['gur2', 'guru'],
	  Hangul: 'hang',
	  Han: 'hani',
	  Hanunoo: 'hano',
	  Hebrew: 'hebr',
	  Hiragana: 'hira',
	  Pahawh_Hmong: 'hmng',
	  Katakana_Or_Hiragana: 'hrkt',
	  Old_Italic: 'ital',
	  Javanese: 'java',
	  Kayah_Li: 'kali',
	  Katakana: 'kana',
	  Kharoshthi: 'khar',
	  Khmer: 'khmr',
	  Khojki: 'khoj',
	  Kannada: ['knd2', 'knda'],
	  Kaithi: 'kthi',
	  Tai_Tham: 'lana',
	  Lao: 'lao ',
	  Latin: 'latn',
	  Lepcha: 'lepc',
	  Limbu: 'limb',
	  Linear_A: 'lina',
	  Linear_B: 'linb',
	  Lisu: 'lisu',
	  Lycian: 'lyci',
	  Lydian: 'lydi',
	  Mahajani: 'mahj',
	  Mandaic: 'mand',
	  Manichaean: 'mani',
	  Mende_Kikakui: 'mend',
	  Meroitic_Cursive: 'merc',
	  Meroitic_Hieroglyphs: 'mero',
	  Malayalam: ['mlm2', 'mlym'],
	  Modi: 'modi',
	  Mongolian: 'mong',
	  Mro: 'mroo',
	  Meetei_Mayek: 'mtei',
	  Myanmar: ['mym2', 'mymr'],
	  Old_North_Arabian: 'narb',
	  Nabataean: 'nbat',
	  Nko: 'nko ',
	  Ogham: 'ogam',
	  Ol_Chiki: 'olck',
	  Old_Turkic: 'orkh',
	  Oriya: ['ory2', 'orya'],
	  Osmanya: 'osma',
	  Palmyrene: 'palm',
	  Pau_Cin_Hau: 'pauc',
	  Old_Permic: 'perm',
	  Phags_Pa: 'phag',
	  Inscriptional_Pahlavi: 'phli',
	  Psalter_Pahlavi: 'phlp',
	  Phoenician: 'phnx',
	  Miao: 'plrd',
	  Inscriptional_Parthian: 'prti',
	  Rejang: 'rjng',
	  Runic: 'runr',
	  Samaritan: 'samr',
	  Old_South_Arabian: 'sarb',
	  Saurashtra: 'saur',
	  Shavian: 'shaw',
	  Sharada: 'shrd',
	  Siddham: 'sidd',
	  Khudawadi: 'sind',
	  Sinhala: 'sinh',
	  Sora_Sompeng: 'sora',
	  Sundanese: 'sund',
	  Syloti_Nagri: 'sylo',
	  Syriac: 'syrc',
	  Tagbanwa: 'tagb',
	  Takri: 'takr',
	  Tai_Le: 'tale',
	  New_Tai_Lue: 'talu',
	  Tamil: ['tml2', 'taml'],
	  Tai_Viet: 'tavt',
	  Telugu: ['tel2', 'telu'],
	  Tifinagh: 'tfng',
	  Tagalog: 'tglg',
	  Thaana: 'thaa',
	  Thai: 'thai',
	  Tibetan: 'tibt',
	  Tirhuta: 'tirh',
	  Ugaritic: 'ugar',
	  Vai: 'vai ',
	  Warang_Citi: 'wara',
	  Old_Persian: 'xpeo',
	  Cuneiform: 'xsux',
	  Yi: 'yi  ',
	  Inherited: 'zinh',
	  Common: 'zyyy',
	  Unknown: 'zzzz'
	};

	var OPENTYPE_SCRIPTS = {};
	for (var script in UNICODE_SCRIPTS) {
	  var tag = UNICODE_SCRIPTS[script];
	  if (Array.isArray(tag)) {
	    for (var _iterator = tag, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var t = _ref;

	      OPENTYPE_SCRIPTS[t] = script;
	    }
	  } else {
	    OPENTYPE_SCRIPTS[tag] = script;
	  }
	}

	function fromOpenType(tag) {
	  return OPENTYPE_SCRIPTS[tag];
	}

	function forString(string) {
	  var len = string.length;
	  var idx = 0;
	  while (idx < len) {
	    var code = string.charCodeAt(idx++);

	    // Check if this is a high surrogate
	    if (0xd800 <= code && code <= 0xdbff && idx < len) {
	      var next = string.charCodeAt(idx);

	      // Check if this is a low surrogate
	      if (0xdc00 <= next && next <= 0xdfff) {
	        idx++;
	        code = ((code & 0x3FF) << 10) + (next & 0x3FF) + 0x10000;
	      }
	    }

	    var _script = unicode.getScript(code);
	    if (_script !== 'Common' && _script !== 'Inherited' && _script !== 'Unknown') {
	      return UNICODE_SCRIPTS[_script];
	    }
	  }

	  return UNICODE_SCRIPTS.Unknown;
	}

	function forCodePoints(codePoints) {
	  for (var i = 0; i < codePoints.length; i++) {
	    var codePoint = codePoints[i];
	    var _script2 = unicode.getScript(codePoint);
	    if (_script2 !== 'Common' && _script2 !== 'Inherited' && _script2 !== 'Unknown') {
	      return UNICODE_SCRIPTS[_script2];
	    }
	  }

	  return UNICODE_SCRIPTS.Unknown;
	}

	// The scripts in this map are written from right to left
	var RTL = {
	  arab: true, // Arabic
	  hebr: true, // Hebrew
	  syrc: true, // Syriac
	  thaa: true, // Thaana
	  cprt: true, // Cypriot Syllabary
	  khar: true, // Kharosthi
	  phnx: true, // Phoenician
	  'nko ': true, // N'Ko
	  lydi: true, // Lydian
	  avst: true, // Avestan
	  armi: true, // Imperial Aramaic
	  phli: true, // Inscriptional Pahlavi
	  prti: true, // Inscriptional Parthian
	  sarb: true, // Old South Arabian
	  orkh: true, // Old Turkic, Orkhon Runic
	  samr: true, // Samaritan
	  mand: true, // Mandaic, Mandaean
	  merc: true, // Meroitic Cursive
	  mero: true, // Meroitic Hieroglyphs

	  // Unicode 7.0 (not listed on http://www.microsoft.com/typography/otspec/scripttags.htm)
	  mani: true, // Manichaean
	  mend: true, // Mende Kikakui
	  nbat: true, // Nabataean
	  narb: true, // Old North Arabian
	  palm: true, // Palmyrene
	  phlp: true // Psalter Pahlavi
	};

	function direction(script) {
	  if (RTL[script]) {
	    return 'rtl';
	  }

	  return 'ltr';
	}

	/**
	 * Represents a run of Glyph and GlyphPosition objects.
	 * Returned by the font layout method.
	 */

	var GlyphRun = function () {
	  function GlyphRun(glyphs, features, script, language, direction$$) {
	    _classCallCheck(this, GlyphRun);

	    /**
	     * An array of Glyph objects in the run
	     * @type {Glyph[]}
	     */
	    this.glyphs = glyphs;

	    /**
	     * An array of GlyphPosition objects for each glyph in the run
	     * @type {GlyphPosition[]}
	     */
	    this.positions = null;

	    /**
	     * The script that was requested for shaping. This was either passed in or detected automatically.
	     * @type {string}
	     */
	    this.script = script;

	    /**
	     * The language requested for shaping, as passed in. If `null`, the default language for the
	     * script was used.
	     * @type {string}
	     */
	    this.language = language || null;

	    /**
	     * The direction requested for shaping, as passed in (either ltr or rtl).
	     * If `null`, the default direction of the script is used.
	     * @type {string}
	     */
	    this.direction = direction$$ || direction(script);

	    /**
	     * The features requested during shaping. This is a combination of user
	     * specified features and features chosen by the shaper.
	     * @type {object}
	     */
	    this.features = {};

	    // Convert features to an object
	    if (Array.isArray(features)) {
	      for (var _iterator = features, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	        var _ref;

	        if (_isArray) {
	          if (_i >= _iterator.length) break;
	          _ref = _iterator[_i++];
	        } else {
	          _i = _iterator.next();
	          if (_i.done) break;
	          _ref = _i.value;
	        }

	        var tag = _ref;

	        this.features[tag] = true;
	      }
	    } else if ((typeof features === 'undefined' ? 'undefined' : _typeof(features)) === 'object') {
	      this.features = features;
	    }
	  }

	  /**
	   * The total advance width of the run.
	   * @type {number}
	   */


	  _createClass(GlyphRun, [{
	    key: 'advanceWidth',
	    get: function get() {
	      var width = 0;
	      for (var _iterator2 = this.positions, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	        var _ref2;

	        if (_isArray2) {
	          if (_i2 >= _iterator2.length) break;
	          _ref2 = _iterator2[_i2++];
	        } else {
	          _i2 = _iterator2.next();
	          if (_i2.done) break;
	          _ref2 = _i2.value;
	        }

	        var position = _ref2;

	        width += position.xAdvance;
	      }

	      return width;
	    }

	    /**
	     * The total advance height of the run.
	     * @type {number}
	     */

	  }, {
	    key: 'advanceHeight',
	    get: function get() {
	      var height = 0;
	      for (var _iterator3 = this.positions, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	        var _ref3;

	        if (_isArray3) {
	          if (_i3 >= _iterator3.length) break;
	          _ref3 = _iterator3[_i3++];
	        } else {
	          _i3 = _iterator3.next();
	          if (_i3.done) break;
	          _ref3 = _i3.value;
	        }

	        var position = _ref3;

	        height += position.yAdvance;
	      }

	      return height;
	    }

	    /**
	     * The bounding box containing all glyphs in the run.
	     * @type {BBox}
	     */

	  }, {
	    key: 'bbox',
	    get: function get() {
	      var bbox = new BBox();

	      var x = 0;
	      var y = 0;
	      for (var index = 0; index < this.glyphs.length; index++) {
	        var glyph = this.glyphs[index];
	        var p = this.positions[index];
	        var b = glyph.bbox;

	        bbox.addPoint(b.minX + x + p.xOffset, b.minY + y + p.yOffset);
	        bbox.addPoint(b.maxX + x + p.xOffset, b.maxY + y + p.yOffset);

	        x += p.xAdvance;
	        y += p.yAdvance;
	      }

	      return bbox;
	    }
	  }]);

	  return GlyphRun;
	}();

	/**
	 * Represents positioning information for a glyph in a GlyphRun.
	 */
	var GlyphPosition = function GlyphPosition() {
	  var xAdvance = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
	  var yAdvance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	  var xOffset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
	  var yOffset = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

	  _classCallCheck(this, GlyphPosition);

	  /**
	   * The amount to move the virtual pen in the X direction after rendering this glyph.
	   * @type {number}
	   */
	  this.xAdvance = xAdvance;

	  /**
	   * The amount to move the virtual pen in the Y direction after rendering this glyph.
	   * @type {number}
	   */
	  this.yAdvance = yAdvance;

	  /**
	   * The offset from the pen position in the X direction at which to render this glyph.
	   * @type {number}
	   */
	  this.xOffset = xOffset;

	  /**
	   * The offset from the pen position in the Y direction at which to render this glyph.
	   * @type {number}
	   */
	  this.yOffset = yOffset;
	};

	// see https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html
	// and /System/Library/Frameworks/CoreText.framework/Versions/A/Headers/SFNTLayoutTypes.h on a Mac
	var features = {
	  allTypographicFeatures: {
	    code: 0,
	    exclusive: false,
	    allTypeFeatures: 0
	  },
	  ligatures: {
	    code: 1,
	    exclusive: false,
	    requiredLigatures: 0,
	    commonLigatures: 2,
	    rareLigatures: 4,
	    // logos: 6
	    rebusPictures: 8,
	    diphthongLigatures: 10,
	    squaredLigatures: 12,
	    abbrevSquaredLigatures: 14,
	    symbolLigatures: 16,
	    contextualLigatures: 18,
	    historicalLigatures: 20
	  },
	  cursiveConnection: {
	    code: 2,
	    exclusive: true,
	    unconnected: 0,
	    partiallyConnected: 1,
	    cursive: 2
	  },
	  letterCase: {
	    code: 3,
	    exclusive: true
	  },
	  // upperAndLowerCase: 0          # deprecated
	  // allCaps: 1                    # deprecated
	  // allLowerCase: 2               # deprecated
	  // smallCaps: 3                  # deprecated
	  // initialCaps: 4                # deprecated
	  // initialCapsAndSmallCaps: 5    # deprecated
	  verticalSubstitution: {
	    code: 4,
	    exclusive: false,
	    substituteVerticalForms: 0
	  },
	  linguisticRearrangement: {
	    code: 5,
	    exclusive: false,
	    linguisticRearrangement: 0
	  },
	  numberSpacing: {
	    code: 6,
	    exclusive: true,
	    monospacedNumbers: 0,
	    proportionalNumbers: 1,
	    thirdWidthNumbers: 2,
	    quarterWidthNumbers: 3
	  },
	  smartSwash: {
	    code: 8,
	    exclusive: false,
	    wordInitialSwashes: 0,
	    wordFinalSwashes: 2,
	    // lineInitialSwashes: 4
	    // lineFinalSwashes: 6
	    nonFinalSwashes: 8
	  },
	  diacritics: {
	    code: 9,
	    exclusive: true,
	    showDiacritics: 0,
	    hideDiacritics: 1,
	    decomposeDiacritics: 2
	  },
	  verticalPosition: {
	    code: 10,
	    exclusive: true,
	    normalPosition: 0,
	    superiors: 1,
	    inferiors: 2,
	    ordinals: 3,
	    scientificInferiors: 4
	  },
	  fractions: {
	    code: 11,
	    exclusive: true,
	    noFractions: 0,
	    verticalFractions: 1,
	    diagonalFractions: 2
	  },
	  overlappingCharacters: {
	    code: 13,
	    exclusive: false,
	    preventOverlap: 0
	  },
	  typographicExtras: {
	    code: 14,
	    exclusive: false,
	    // hyphensToEmDash: 0
	    // hyphenToEnDash: 2
	    slashedZero: 4
	  },
	  // formInterrobang: 6
	  // smartQuotes: 8
	  // periodsToEllipsis: 10
	  mathematicalExtras: {
	    code: 15,
	    exclusive: false,
	    // hyphenToMinus: 0
	    // asteristoMultiply: 2
	    // slashToDivide: 4
	    // inequalityLigatures: 6
	    // exponents: 8
	    mathematicalGreek: 10
	  },
	  ornamentSets: {
	    code: 16,
	    exclusive: true,
	    noOrnaments: 0,
	    dingbats: 1,
	    piCharacters: 2,
	    fleurons: 3,
	    decorativeBorders: 4,
	    internationalSymbols: 5,
	    mathSymbols: 6
	  },
	  characterAlternatives: {
	    code: 17,
	    exclusive: true,
	    noAlternates: 0
	  },
	  // user defined options
	  designComplexity: {
	    code: 18,
	    exclusive: true,
	    designLevel1: 0,
	    designLevel2: 1,
	    designLevel3: 2,
	    designLevel4: 3,
	    designLevel5: 4
	  },
	  styleOptions: {
	    code: 19,
	    exclusive: true,
	    noStyleOptions: 0,
	    displayText: 1,
	    engravedText: 2,
	    illuminatedCaps: 3,
	    titlingCaps: 4,
	    tallCaps: 5
	  },
	  characterShape: {
	    code: 20,
	    exclusive: true,
	    traditionalCharacters: 0,
	    simplifiedCharacters: 1,
	    JIS1978Characters: 2,
	    JIS1983Characters: 3,
	    JIS1990Characters: 4,
	    traditionalAltOne: 5,
	    traditionalAltTwo: 6,
	    traditionalAltThree: 7,
	    traditionalAltFour: 8,
	    traditionalAltFive: 9,
	    expertCharacters: 10,
	    JIS2004Characters: 11,
	    hojoCharacters: 12,
	    NLCCharacters: 13,
	    traditionalNamesCharacters: 14
	  },
	  numberCase: {
	    code: 21,
	    exclusive: true,
	    lowerCaseNumbers: 0,
	    upperCaseNumbers: 1
	  },
	  textSpacing: {
	    code: 22,
	    exclusive: true,
	    proportionalText: 0,
	    monospacedText: 1,
	    halfWidthText: 2,
	    thirdWidthText: 3,
	    quarterWidthText: 4,
	    altProportionalText: 5,
	    altHalfWidthText: 6
	  },
	  transliteration: {
	    code: 23,
	    exclusive: true,
	    noTransliteration: 0
	  },
	  // hanjaToHangul: 1
	  // hiraganaToKatakana: 2
	  // katakanaToHiragana: 3
	  // kanaToRomanization: 4
	  // romanizationToHiragana: 5
	  // romanizationToKatakana: 6
	  // hanjaToHangulAltOne: 7
	  // hanjaToHangulAltTwo: 8
	  // hanjaToHangulAltThree: 9
	  annotation: {
	    code: 24,
	    exclusive: true,
	    noAnnotation: 0,
	    boxAnnotation: 1,
	    roundedBoxAnnotation: 2,
	    circleAnnotation: 3,
	    invertedCircleAnnotation: 4,
	    parenthesisAnnotation: 5,
	    periodAnnotation: 6,
	    romanNumeralAnnotation: 7,
	    diamondAnnotation: 8,
	    invertedBoxAnnotation: 9,
	    invertedRoundedBoxAnnotation: 10
	  },
	  kanaSpacing: {
	    code: 25,
	    exclusive: true,
	    fullWidthKana: 0,
	    proportionalKana: 1
	  },
	  ideographicSpacing: {
	    code: 26,
	    exclusive: true,
	    fullWidthIdeographs: 0,
	    proportionalIdeographs: 1,
	    halfWidthIdeographs: 2
	  },
	  unicodeDecomposition: {
	    code: 27,
	    exclusive: false,
	    canonicalComposition: 0,
	    compatibilityComposition: 2,
	    transcodingComposition: 4
	  },
	  rubyKana: {
	    code: 28,
	    exclusive: false,
	    // noRubyKana: 0     # deprecated - use rubyKanaOff instead
	    // rubyKana: 1     # deprecated - use rubyKanaOn instead
	    rubyKana: 2
	  },
	  CJKSymbolAlternatives: {
	    code: 29,
	    exclusive: true,
	    noCJKSymbolAlternatives: 0,
	    CJKSymbolAltOne: 1,
	    CJKSymbolAltTwo: 2,
	    CJKSymbolAltThree: 3,
	    CJKSymbolAltFour: 4,
	    CJKSymbolAltFive: 5
	  },
	  ideographicAlternatives: {
	    code: 30,
	    exclusive: true,
	    noIdeographicAlternatives: 0,
	    ideographicAltOne: 1,
	    ideographicAltTwo: 2,
	    ideographicAltThree: 3,
	    ideographicAltFour: 4,
	    ideographicAltFive: 5
	  },
	  CJKVerticalRomanPlacement: {
	    code: 31,
	    exclusive: true,
	    CJKVerticalRomanCentered: 0,
	    CJKVerticalRomanHBaseline: 1
	  },
	  italicCJKRoman: {
	    code: 32,
	    exclusive: false,
	    // noCJKItalicRoman: 0     # deprecated - use CJKItalicRomanOff instead
	    // CJKItalicRoman: 1     # deprecated - use CJKItalicRomanOn instead
	    CJKItalicRoman: 2
	  },
	  caseSensitiveLayout: {
	    code: 33,
	    exclusive: false,
	    caseSensitiveLayout: 0,
	    caseSensitiveSpacing: 2
	  },
	  alternateKana: {
	    code: 34,
	    exclusive: false,
	    alternateHorizKana: 0,
	    alternateVertKana: 2
	  },
	  stylisticAlternatives: {
	    code: 35,
	    exclusive: false,
	    noStylisticAlternates: 0,
	    stylisticAltOne: 2,
	    stylisticAltTwo: 4,
	    stylisticAltThree: 6,
	    stylisticAltFour: 8,
	    stylisticAltFive: 10,
	    stylisticAltSix: 12,
	    stylisticAltSeven: 14,
	    stylisticAltEight: 16,
	    stylisticAltNine: 18,
	    stylisticAltTen: 20,
	    stylisticAltEleven: 22,
	    stylisticAltTwelve: 24,
	    stylisticAltThirteen: 26,
	    stylisticAltFourteen: 28,
	    stylisticAltFifteen: 30,
	    stylisticAltSixteen: 32,
	    stylisticAltSeventeen: 34,
	    stylisticAltEighteen: 36,
	    stylisticAltNineteen: 38,
	    stylisticAltTwenty: 40
	  },
	  contextualAlternates: {
	    code: 36,
	    exclusive: false,
	    contextualAlternates: 0,
	    swashAlternates: 2,
	    contextualSwashAlternates: 4
	  },
	  lowerCase: {
	    code: 37,
	    exclusive: true,
	    defaultLowerCase: 0,
	    lowerCaseSmallCaps: 1,
	    lowerCasePetiteCaps: 2
	  },
	  upperCase: {
	    code: 38,
	    exclusive: true,
	    defaultUpperCase: 0,
	    upperCaseSmallCaps: 1,
	    upperCasePetiteCaps: 2
	  },
	  languageTag: { // indices into ltag table
	    code: 39,
	    exclusive: true
	  },
	  CJKRomanSpacing: {
	    code: 103,
	    exclusive: true,
	    halfWidthCJKRoman: 0,
	    proportionalCJKRoman: 1,
	    defaultCJKRoman: 2,
	    fullWidthCJKRoman: 3
	  }
	};

	var feature = function feature(name, selector) {
	  return [features[name].code, features[name][selector]];
	};

	var OTMapping = {
	  rlig: feature('ligatures', 'requiredLigatures'),
	  clig: feature('ligatures', 'contextualLigatures'),
	  dlig: feature('ligatures', 'rareLigatures'),
	  hlig: feature('ligatures', 'historicalLigatures'),
	  liga: feature('ligatures', 'commonLigatures'),
	  hist: feature('ligatures', 'historicalLigatures'), // ??

	  smcp: feature('lowerCase', 'lowerCaseSmallCaps'),
	  pcap: feature('lowerCase', 'lowerCasePetiteCaps'),

	  frac: feature('fractions', 'diagonalFractions'),
	  dnom: feature('fractions', 'diagonalFractions'), // ??
	  numr: feature('fractions', 'diagonalFractions'), // ??
	  afrc: feature('fractions', 'verticalFractions'),
	  // aalt
	  // abvf, abvm, abvs, akhn, blwf, blwm, blws, cfar, cjct, cpsp, falt, isol, jalt, ljmo, mset?
	  // ltra, ltrm, nukt, pref, pres, pstf, psts, rand, rkrf, rphf, rtla, rtlm, size, tjmo, tnum?
	  // unic, vatu, vhal, vjmo, vpal, vrt2
	  // dist -> trak table?
	  // kern, vkrn -> kern table
	  // lfbd + opbd + rtbd -> opbd table?
	  // mark, mkmk -> acnt table?
	  // locl -> languageTag + ltag table

	  case: feature('caseSensitiveLayout', 'caseSensitiveLayout'), // also caseSensitiveSpacing
	  ccmp: feature('unicodeDecomposition', 'canonicalComposition'), // compatibilityComposition?
	  cpct: feature('CJKVerticalRomanPlacement', 'CJKVerticalRomanCentered'), // guess..., probably not given below
	  valt: feature('CJKVerticalRomanPlacement', 'CJKVerticalRomanCentered'),
	  swsh: feature('contextualAlternates', 'swashAlternates'),
	  cswh: feature('contextualAlternates', 'contextualSwashAlternates'),
	  curs: feature('cursiveConnection', 'cursive'), // ??
	  c2pc: feature('upperCase', 'upperCasePetiteCaps'),
	  c2sc: feature('upperCase', 'upperCaseSmallCaps'),

	  init: feature('smartSwash', 'wordInitialSwashes'), // ??
	  fin2: feature('smartSwash', 'wordFinalSwashes'), // ??
	  medi: feature('smartSwash', 'nonFinalSwashes'), // ??
	  med2: feature('smartSwash', 'nonFinalSwashes'), // ??
	  fin3: feature('smartSwash', 'wordFinalSwashes'), // ??
	  fina: feature('smartSwash', 'wordFinalSwashes'), // ??

	  pkna: feature('kanaSpacing', 'proportionalKana'),
	  half: feature('textSpacing', 'halfWidthText'), // also HalfWidthCJKRoman, HalfWidthIdeographs?
	  halt: feature('textSpacing', 'altHalfWidthText'),

	  hkna: feature('alternateKana', 'alternateHorizKana'),
	  vkna: feature('alternateKana', 'alternateVertKana'),
	  // hngl: feature 'transliteration', 'hanjaToHangulSelector' # deprecated

	  ital: feature('italicCJKRoman', 'CJKItalicRoman'),
	  lnum: feature('numberCase', 'upperCaseNumbers'),
	  onum: feature('numberCase', 'lowerCaseNumbers'),
	  mgrk: feature('mathematicalExtras', 'mathematicalGreek'),

	  // nalt: not enough info. what type of annotation?
	  // ornm: ditto, which ornament style?

	  calt: feature('contextualAlternates', 'contextualAlternates'), // or more?
	  vrt2: feature('verticalSubstitution', 'substituteVerticalForms'), // oh... below?
	  vert: feature('verticalSubstitution', 'substituteVerticalForms'),
	  tnum: feature('numberSpacing', 'monospacedNumbers'),
	  pnum: feature('numberSpacing', 'proportionalNumbers'),
	  sups: feature('verticalPosition', 'superiors'),
	  subs: feature('verticalPosition', 'inferiors'),
	  ordn: feature('verticalPosition', 'ordinals'),
	  pwid: feature('textSpacing', 'proportionalText'),
	  hwid: feature('textSpacing', 'halfWidthText'),
	  qwid: feature('textSpacing', 'quarterWidthText'), // also QuarterWidthNumbers?
	  twid: feature('textSpacing', 'thirdWidthText'), // also ThirdWidthNumbers?
	  fwid: feature('textSpacing', 'proportionalText'), //??
	  palt: feature('textSpacing', 'altProportionalText'),
	  trad: feature('characterShape', 'traditionalCharacters'),
	  smpl: feature('characterShape', 'simplifiedCharacters'),
	  jp78: feature('characterShape', 'JIS1978Characters'),
	  jp83: feature('characterShape', 'JIS1983Characters'),
	  jp90: feature('characterShape', 'JIS1990Characters'),
	  jp04: feature('characterShape', 'JIS2004Characters'),
	  expt: feature('characterShape', 'expertCharacters'),
	  hojo: feature('characterShape', 'hojoCharacters'),
	  nlck: feature('characterShape', 'NLCCharacters'),
	  tnam: feature('characterShape', 'traditionalNamesCharacters'),
	  ruby: feature('rubyKana', 'rubyKana'),
	  titl: feature('styleOptions', 'titlingCaps'),
	  zero: feature('typographicExtras', 'slashedZero'),

	  ss01: feature('stylisticAlternatives', 'stylisticAltOne'),
	  ss02: feature('stylisticAlternatives', 'stylisticAltTwo'),
	  ss03: feature('stylisticAlternatives', 'stylisticAltThree'),
	  ss04: feature('stylisticAlternatives', 'stylisticAltFour'),
	  ss05: feature('stylisticAlternatives', 'stylisticAltFive'),
	  ss06: feature('stylisticAlternatives', 'stylisticAltSix'),
	  ss07: feature('stylisticAlternatives', 'stylisticAltSeven'),
	  ss08: feature('stylisticAlternatives', 'stylisticAltEight'),
	  ss09: feature('stylisticAlternatives', 'stylisticAltNine'),
	  ss10: feature('stylisticAlternatives', 'stylisticAltTen'),
	  ss11: feature('stylisticAlternatives', 'stylisticAltEleven'),
	  ss12: feature('stylisticAlternatives', 'stylisticAltTwelve'),
	  ss13: feature('stylisticAlternatives', 'stylisticAltThirteen'),
	  ss14: feature('stylisticAlternatives', 'stylisticAltFourteen'),
	  ss15: feature('stylisticAlternatives', 'stylisticAltFifteen'),
	  ss16: feature('stylisticAlternatives', 'stylisticAltSixteen'),
	  ss17: feature('stylisticAlternatives', 'stylisticAltSeventeen'),
	  ss18: feature('stylisticAlternatives', 'stylisticAltEighteen'),
	  ss19: feature('stylisticAlternatives', 'stylisticAltNineteen'),
	  ss20: feature('stylisticAlternatives', 'stylisticAltTwenty')
	};

	// salt: feature 'stylisticAlternatives', 'stylisticAltOne' # hmm, which one to choose

	// Add cv01-cv99 features
	for (var i = 1; i <= 99; i++) {
	  OTMapping['cv' + ('00' + i).slice(-2)] = [features.characterAlternatives.code, i];
	}

	// create inverse mapping
	var AATMapping = {};
	for (var ot in OTMapping) {
	  var aat = OTMapping[ot];
	  if (AATMapping[aat[0]] == null) {
	    AATMapping[aat[0]] = {};
	  }

	  AATMapping[aat[0]][aat[1]] = ot;
	}

	// Maps an array of OpenType features to AAT features
	// in the form of {featureType:{featureSetting:true}}
	function mapOTToAAT(features) {
	  var res = {};
	  for (var k in features) {
	    var r = void 0;
	    if (r = OTMapping[k]) {
	      if (res[r[0]] == null) {
	        res[r[0]] = {};
	      }

	      res[r[0]][r[1]] = features[k];
	    }
	  }

	  return res;
	}

	// Maps strings in a [featureType, featureSetting]
	// to their equivalent number codes
	function mapFeatureStrings(f) {
	  var type = f[0],
	      setting = f[1];

	  if (isNaN(type)) {
	    var typeCode = features[type] && features[type].code;
	  } else {
	    var typeCode = type;
	  }

	  if (isNaN(setting)) {
	    var settingCode = features[type] && features[type][setting];
	  } else {
	    var settingCode = setting;
	  }

	  return [typeCode, settingCode];
	}

	// Maps AAT features to an array of OpenType features
	// Supports both arrays in the form of [[featureType, featureSetting]]
	// and objects in the form of {featureType:{featureSetting:true}}
	// featureTypes and featureSettings can be either strings or number codes
	function mapAATToOT(features) {
	  var res = {};
	  if (Array.isArray(features)) {
	    for (var k = 0; k < features.length; k++) {
	      var r = void 0;
	      var f = mapFeatureStrings(features[k]);
	      if (r = AATMapping[f[0]] && AATMapping[f[0]][f[1]]) {
	        res[r] = true;
	      }
	    }
	  } else if ((typeof features === 'undefined' ? 'undefined' : _typeof(features)) === 'object') {
	    for (var type in features) {
	      var _feature = features[type];
	      for (var setting in _feature) {
	        var _r = void 0;
	        var _f = mapFeatureStrings([type, setting]);
	        if (_feature[setting] && (_r = AATMapping[_f[0]] && AATMapping[_f[0]][_f[1]])) {
	          res[_r] = true;
	        }
	      }
	    }
	  }

	  return _Object$keys(res);
	}

	var _class$3;
	function _applyDecoratedDescriptor$3(target, property, decorators, descriptor, context) {
	  var desc = {};
	  Object['ke' + 'ys'](descriptor).forEach(function (key) {
	    desc[key] = descriptor[key];
	  });
	  desc.enumerable = !!desc.enumerable;
	  desc.configurable = !!desc.configurable;

	  if ('value' in desc || desc.initializer) {
	    desc.writable = true;
	  }

	  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
	    return decorator(target, property, desc) || desc;
	  }, desc);

	  if (context && desc.initializer !== void 0) {
	    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
	    desc.initializer = undefined;
	  }

	  if (desc.initializer === void 0) {
	    Object['define' + 'Property'](target, property, desc);
	    desc = null;
	  }

	  return desc;
	}

	var AATLookupTable = (_class$3 = function () {
	  function AATLookupTable(table) {
	    _classCallCheck(this, AATLookupTable);

	    this.table = table;
	  }

	  AATLookupTable.prototype.lookup = function lookup(glyph) {
	    switch (this.table.version) {
	      case 0:
	        // simple array format
	        return this.table.values.getItem(glyph);

	      case 2: // segment format
	      case 4:
	        {
	          var min = 0;
	          var max = this.table.binarySearchHeader.nUnits - 1;

	          while (min <= max) {
	            var mid = min + max >> 1;
	            var seg = this.table.segments[mid];

	            // special end of search value
	            if (seg.firstGlyph === 0xffff) {
	              return null;
	            }

	            if (glyph < seg.firstGlyph) {
	              max = mid - 1;
	            } else if (glyph > seg.lastGlyph) {
	              min = mid + 1;
	            } else {
	              if (this.table.version === 2) {
	                return seg.value;
	              } else {
	                return seg.values[glyph - seg.firstGlyph];
	              }
	            }
	          }

	          return null;
	        }

	      case 6:
	        {
	          // lookup single
	          var _min = 0;
	          var _max = this.table.binarySearchHeader.nUnits - 1;

	          while (_min <= _max) {
	            var mid = _min + _max >> 1;
	            var seg = this.table.segments[mid];

	            // special end of search value
	            if (seg.glyph === 0xffff) {
	              return null;
	            }

	            if (glyph < seg.glyph) {
	              _max = mid - 1;
	            } else if (glyph > seg.glyph) {
	              _min = mid + 1;
	            } else {
	              return seg.value;
	            }
	          }

	          return null;
	        }

	      case 8:
	        // lookup trimmed
	        return this.table.values[glyph - this.table.firstGlyph];

	      default:
	        throw new Error('Unknown lookup table format: ' + this.table.version);
	    }
	  };

	  AATLookupTable.prototype.glyphsForValue = function glyphsForValue(classValue) {
	    var res = [];

	    switch (this.table.version) {
	      case 2: // segment format
	      case 4:
	        {
	          for (var _iterator = this.table.segments, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	            var _ref;

	            if (_isArray) {
	              if (_i >= _iterator.length) break;
	              _ref = _iterator[_i++];
	            } else {
	              _i = _iterator.next();
	              if (_i.done) break;
	              _ref = _i.value;
	            }

	            var segment = _ref;

	            if (this.table.version === 2 && segment.value === classValue) {
	              res.push.apply(res, range(segment.firstGlyph, segment.lastGlyph + 1));
	            } else {
	              for (var index = 0; index < segment.values.length; index++) {
	                if (segment.values[index] === classValue) {
	                  res.push(segment.firstGlyph + index);
	                }
	              }
	            }
	          }

	          break;
	        }

	      case 6:
	        {
	          // lookup single
	          for (var _iterator2 = this.table.segments, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	            var _ref2;

	            if (_isArray2) {
	              if (_i2 >= _iterator2.length) break;
	              _ref2 = _iterator2[_i2++];
	            } else {
	              _i2 = _iterator2.next();
	              if (_i2.done) break;
	              _ref2 = _i2.value;
	            }

	            var _segment = _ref2;

	            if (_segment.value === classValue) {
	              res.push(_segment.glyph);
	            }
	          }

	          break;
	        }

	      case 8:
	        {
	          // lookup trimmed
	          for (var i = 0; i < this.table.values.length; i++) {
	            if (this.table.values[i] === classValue) {
	              res.push(this.table.firstGlyph + i);
	            }
	          }

	          break;
	        }

	      default:
	        throw new Error('Unknown lookup table format: ' + this.table.version);
	    }

	    return res;
	  };

	  return AATLookupTable;
	}(), (_applyDecoratedDescriptor$3(_class$3.prototype, 'glyphsForValue', [cache], _Object$getOwnPropertyDescriptor(_class$3.prototype, 'glyphsForValue'), _class$3.prototype)), _class$3);

	var START_OF_TEXT_STATE = 0;
	var END_OF_TEXT_CLASS = 0;
	var OUT_OF_BOUNDS_CLASS = 1;
	var DELETED_GLYPH_CLASS = 2;
	var DONT_ADVANCE = 0x4000;

	var AATStateMachine = function () {
	  function AATStateMachine(stateTable) {
	    _classCallCheck(this, AATStateMachine);

	    this.stateTable = stateTable;
	    this.lookupTable = new AATLookupTable(stateTable.classTable);
	  }

	  AATStateMachine.prototype.process = function process(glyphs, reverse, processEntry) {
	    var currentState = START_OF_TEXT_STATE; // START_OF_LINE_STATE is used for kashida glyph insertions sometimes I think?
	    var index = reverse ? glyphs.length - 1 : 0;
	    var dir = reverse ? -1 : 1;

	    while (dir === 1 && index <= glyphs.length || dir === -1 && index >= -1) {
	      var glyph = null;
	      var classCode = OUT_OF_BOUNDS_CLASS;
	      var shouldAdvance = true;

	      if (index === glyphs.length || index === -1) {
	        classCode = END_OF_TEXT_CLASS;
	      } else {
	        glyph = glyphs[index];
	        if (glyph.id === 0xffff) {
	          // deleted glyph
	          classCode = DELETED_GLYPH_CLASS;
	        } else {
	          classCode = this.lookupTable.lookup(glyph.id);
	          if (classCode == null) {
	            classCode = OUT_OF_BOUNDS_CLASS;
	          }
	        }
	      }

	      var row = this.stateTable.stateArray.getItem(currentState);
	      var entryIndex = row[classCode];
	      var entry = this.stateTable.entryTable.getItem(entryIndex);

	      if (classCode !== END_OF_TEXT_CLASS && classCode !== DELETED_GLYPH_CLASS) {
	        processEntry(glyph, entry, index);
	        shouldAdvance = !(entry.flags & DONT_ADVANCE);
	      }

	      currentState = entry.newState;
	      if (shouldAdvance) {
	        index += dir;
	      }
	    }

	    return glyphs;
	  };

	  /**
	   * Performs a depth-first traversal of the glyph strings
	   * represented by the state machine.
	   */


	  AATStateMachine.prototype.traverse = function traverse(opts) {
	    var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	    var visited = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new _Set();

	    if (visited.has(state)) {
	      return;
	    }

	    visited.add(state);

	    var _stateTable = this.stateTable,
	        nClasses = _stateTable.nClasses,
	        stateArray = _stateTable.stateArray,
	        entryTable = _stateTable.entryTable;

	    var row = stateArray.getItem(state);

	    // Skip predefined classes
	    for (var classCode = 4; classCode < nClasses; classCode++) {
	      var entryIndex = row[classCode];
	      var entry = entryTable.getItem(entryIndex);

	      // Try all glyphs in the class
	      for (var _iterator = this.lookupTable.glyphsForValue(classCode), _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	        var _ref;

	        if (_isArray) {
	          if (_i >= _iterator.length) break;
	          _ref = _iterator[_i++];
	        } else {
	          _i = _iterator.next();
	          if (_i.done) break;
	          _ref = _i.value;
	        }

	        var glyph = _ref;

	        if (opts.enter) {
	          opts.enter(glyph, entry);
	        }

	        if (entry.newState !== 0) {
	          this.traverse(opts, entry.newState, visited);
	        }

	        if (opts.exit) {
	          opts.exit(glyph, entry);
	        }
	      }
	    }
	  };

	  return AATStateMachine;
	}();

	var _class$2;
	function _applyDecoratedDescriptor$2(target, property, decorators, descriptor, context) {
	  var desc = {};
	  Object['ke' + 'ys'](descriptor).forEach(function (key) {
	    desc[key] = descriptor[key];
	  });
	  desc.enumerable = !!desc.enumerable;
	  desc.configurable = !!desc.configurable;

	  if ('value' in desc || desc.initializer) {
	    desc.writable = true;
	  }

	  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
	    return decorator(target, property, desc) || desc;
	  }, desc);

	  if (context && desc.initializer !== void 0) {
	    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
	    desc.initializer = undefined;
	  }

	  if (desc.initializer === void 0) {
	    Object['define' + 'Property'](target, property, desc);
	    desc = null;
	  }

	  return desc;
	}

	// indic replacement flags
	var MARK_FIRST = 0x8000;
	var MARK_LAST = 0x2000;
	var VERB = 0x000F;

	// contextual substitution and glyph insertion flag
	var SET_MARK = 0x8000;

	// ligature entry flags
	var SET_COMPONENT = 0x8000;
	var PERFORM_ACTION = 0x2000;

	// ligature action masks
	var LAST_MASK = 0x80000000;
	var STORE_MASK = 0x40000000;
	var OFFSET_MASK = 0x3FFFFFFF;

	var REVERSE_DIRECTION = 0x400000;
	var CURRENT_INSERT_BEFORE = 0x0800;
	var MARKED_INSERT_BEFORE = 0x0400;
	var CURRENT_INSERT_COUNT = 0x03E0;
	var MARKED_INSERT_COUNT = 0x001F;

	var AATMorxProcessor = (_class$2 = function () {
	  function AATMorxProcessor(font) {
	    _classCallCheck(this, AATMorxProcessor);

	    this.processIndicRearragement = this.processIndicRearragement.bind(this);
	    this.processContextualSubstitution = this.processContextualSubstitution.bind(this);
	    this.processLigature = this.processLigature.bind(this);
	    this.processNoncontextualSubstitutions = this.processNoncontextualSubstitutions.bind(this);
	    this.processGlyphInsertion = this.processGlyphInsertion.bind(this);
	    this.font = font;
	    this.morx = font.morx;
	    this.inputCache = null;
	  }

	  // Processes an array of glyphs and applies the specified features
	  // Features should be in the form of {featureType:{featureSetting:true}}


	  AATMorxProcessor.prototype.process = function process(glyphs) {
	    var features = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

	    for (var _iterator = this.morx.chains, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var chain = _ref;

	      var flags = chain.defaultFlags;

	      // enable/disable the requested features
	      for (var _iterator2 = chain.features, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	        var _ref2;

	        if (_isArray2) {
	          if (_i2 >= _iterator2.length) break;
	          _ref2 = _iterator2[_i2++];
	        } else {
	          _i2 = _iterator2.next();
	          if (_i2.done) break;
	          _ref2 = _i2.value;
	        }

	        var feature = _ref2;

	        var f = void 0;
	        if ((f = features[feature.featureType]) && f[feature.featureSetting]) {
	          flags &= feature.disableFlags;
	          flags |= feature.enableFlags;
	        }
	      }

	      for (var _iterator3 = chain.subtables, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	        var _ref3;

	        if (_isArray3) {
	          if (_i3 >= _iterator3.length) break;
	          _ref3 = _iterator3[_i3++];
	        } else {
	          _i3 = _iterator3.next();
	          if (_i3.done) break;
	          _ref3 = _i3.value;
	        }

	        var subtable = _ref3;

	        if (subtable.subFeatureFlags & flags) {
	          this.processSubtable(subtable, glyphs);
	        }
	      }
	    }

	    // remove deleted glyphs
	    var index = glyphs.length - 1;
	    while (index >= 0) {
	      if (glyphs[index].id === 0xffff) {
	        glyphs.splice(index, 1);
	      }

	      index--;
	    }

	    return glyphs;
	  };

	  AATMorxProcessor.prototype.processSubtable = function processSubtable(subtable, glyphs) {
	    this.subtable = subtable;
	    this.glyphs = glyphs;
	    if (this.subtable.type === 4) {
	      this.processNoncontextualSubstitutions(this.subtable, this.glyphs);
	      return;
	    }

	    this.ligatureStack = [];
	    this.markedGlyph = null;
	    this.firstGlyph = null;
	    this.lastGlyph = null;
	    this.markedIndex = null;

	    var stateMachine = this.getStateMachine(subtable);
	    var process = this.getProcessor();

	    var reverse = !!(this.subtable.coverage & REVERSE_DIRECTION);
	    return stateMachine.process(this.glyphs, reverse, process);
	  };

	  AATMorxProcessor.prototype.getStateMachine = function getStateMachine(subtable) {
	    return new AATStateMachine(subtable.table.stateTable);
	  };

	  AATMorxProcessor.prototype.getProcessor = function getProcessor() {
	    switch (this.subtable.type) {
	      case 0:
	        return this.processIndicRearragement;
	      case 1:
	        return this.processContextualSubstitution;
	      case 2:
	        return this.processLigature;
	      case 4:
	        return this.processNoncontextualSubstitutions;
	      case 5:
	        return this.processGlyphInsertion;
	      default:
	        throw new Error('Invalid morx subtable type: ' + this.subtable.type);
	    }
	  };

	  AATMorxProcessor.prototype.processIndicRearragement = function processIndicRearragement(glyph, entry, index) {
	    if (entry.flags & MARK_FIRST) {
	      this.firstGlyph = index;
	    }

	    if (entry.flags & MARK_LAST) {
	      this.lastGlyph = index;
	    }

	    reorderGlyphs(this.glyphs, entry.flags & VERB, this.firstGlyph, this.lastGlyph);
	  };

	  AATMorxProcessor.prototype.processContextualSubstitution = function processContextualSubstitution(glyph, entry, index) {
	    var subsitutions = this.subtable.table.substitutionTable.items;
	    if (entry.markIndex !== 0xffff) {
	      var lookup = subsitutions.getItem(entry.markIndex);
	      var lookupTable = new AATLookupTable(lookup);
	      glyph = this.glyphs[this.markedGlyph];
	      var gid = lookupTable.lookup(glyph.id);
	      if (gid) {
	        this.glyphs[this.markedGlyph] = this.font.getGlyph(gid, glyph.codePoints);
	      }
	    }

	    if (entry.currentIndex !== 0xffff) {
	      var _lookup = subsitutions.getItem(entry.currentIndex);
	      var _lookupTable = new AATLookupTable(_lookup);
	      glyph = this.glyphs[index];
	      var gid = _lookupTable.lookup(glyph.id);
	      if (gid) {
	        this.glyphs[index] = this.font.getGlyph(gid, glyph.codePoints);
	      }
	    }

	    if (entry.flags & SET_MARK) {
	      this.markedGlyph = index;
	    }
	  };

	  AATMorxProcessor.prototype.processLigature = function processLigature(glyph, entry, index) {
	    if (entry.flags & SET_COMPONENT) {
	      this.ligatureStack.push(index);
	    }

	    if (entry.flags & PERFORM_ACTION) {
	      var _ligatureStack;

	      var actions = this.subtable.table.ligatureActions;
	      var components = this.subtable.table.components;
	      var ligatureList = this.subtable.table.ligatureList;

	      var actionIndex = entry.action;
	      var last = false;
	      var ligatureIndex = 0;
	      var codePoints = [];
	      var ligatureGlyphs = [];

	      while (!last) {
	        var _codePoints;

	        var componentGlyph = this.ligatureStack.pop();
	        (_codePoints = codePoints).unshift.apply(_codePoints, this.glyphs[componentGlyph].codePoints);

	        var action = actions.getItem(actionIndex++);
	        last = !!(action & LAST_MASK);
	        var store = !!(action & STORE_MASK);
	        var offset = (action & OFFSET_MASK) << 2 >> 2; // sign extend 30 to 32 bits
	        offset += this.glyphs[componentGlyph].id;

	        var component = components.getItem(offset);
	        ligatureIndex += component;

	        if (last || store) {
	          var ligatureEntry = ligatureList.getItem(ligatureIndex);
	          this.glyphs[componentGlyph] = this.font.getGlyph(ligatureEntry, codePoints);
	          ligatureGlyphs.push(componentGlyph);
	          ligatureIndex = 0;
	          codePoints = [];
	        } else {
	          this.glyphs[componentGlyph] = this.font.getGlyph(0xffff);
	        }
	      }

	      // Put ligature glyph indexes back on the stack
	      (_ligatureStack = this.ligatureStack).push.apply(_ligatureStack, ligatureGlyphs);
	    }
	  };

	  AATMorxProcessor.prototype.processNoncontextualSubstitutions = function processNoncontextualSubstitutions(subtable, glyphs, index) {
	    var lookupTable = new AATLookupTable(subtable.table.lookupTable);

	    for (index = 0; index < glyphs.length; index++) {
	      var glyph = glyphs[index];
	      if (glyph.id !== 0xffff) {
	        var gid = lookupTable.lookup(glyph.id);
	        if (gid) {
	          // 0 means do nothing
	          glyphs[index] = this.font.getGlyph(gid, glyph.codePoints);
	        }
	      }
	    }
	  };

	  AATMorxProcessor.prototype._insertGlyphs = function _insertGlyphs(glyphIndex, insertionActionIndex, count, isBefore) {
	    var _glyphs;

	    var insertions = [];
	    while (count--) {
	      var gid = this.subtable.table.insertionActions.getItem(insertionActionIndex++);
	      insertions.push(this.font.getGlyph(gid));
	    }

	    if (!isBefore) {
	      glyphIndex++;
	    }

	    (_glyphs = this.glyphs).splice.apply(_glyphs, [glyphIndex, 0].concat(insertions));
	  };

	  AATMorxProcessor.prototype.processGlyphInsertion = function processGlyphInsertion(glyph, entry, index) {
	    if (entry.flags & SET_MARK) {
	      this.markedIndex = index;
	    }

	    if (entry.markedInsertIndex !== 0xffff) {
	      var count = (entry.flags & MARKED_INSERT_COUNT) >>> 5;
	      var isBefore = !!(entry.flags & MARKED_INSERT_BEFORE);
	      this._insertGlyphs(this.markedIndex, entry.markedInsertIndex, count, isBefore);
	    }

	    if (entry.currentInsertIndex !== 0xffff) {
	      var _count = (entry.flags & CURRENT_INSERT_COUNT) >>> 5;
	      var _isBefore = !!(entry.flags & CURRENT_INSERT_BEFORE);
	      this._insertGlyphs(index, entry.currentInsertIndex, _count, _isBefore);
	    }
	  };

	  AATMorxProcessor.prototype.getSupportedFeatures = function getSupportedFeatures() {
	    var features = [];
	    for (var _iterator4 = this.morx.chains, _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : _getIterator(_iterator4);;) {
	      var _ref4;

	      if (_isArray4) {
	        if (_i4 >= _iterator4.length) break;
	        _ref4 = _iterator4[_i4++];
	      } else {
	        _i4 = _iterator4.next();
	        if (_i4.done) break;
	        _ref4 = _i4.value;
	      }

	      var chain = _ref4;

	      for (var _iterator5 = chain.features, _isArray5 = Array.isArray(_iterator5), _i5 = 0, _iterator5 = _isArray5 ? _iterator5 : _getIterator(_iterator5);;) {
	        var _ref5;

	        if (_isArray5) {
	          if (_i5 >= _iterator5.length) break;
	          _ref5 = _iterator5[_i5++];
	        } else {
	          _i5 = _iterator5.next();
	          if (_i5.done) break;
	          _ref5 = _i5.value;
	        }

	        var feature = _ref5;

	        features.push([feature.featureType, feature.featureSetting]);
	      }
	    }

	    return features;
	  };

	  AATMorxProcessor.prototype.generateInputs = function generateInputs(gid) {
	    if (!this.inputCache) {
	      this.generateInputCache();
	    }

	    return this.inputCache[gid] || [];
	  };

	  AATMorxProcessor.prototype.generateInputCache = function generateInputCache() {
	    this.inputCache = {};

	    for (var _iterator6 = this.morx.chains, _isArray6 = Array.isArray(_iterator6), _i6 = 0, _iterator6 = _isArray6 ? _iterator6 : _getIterator(_iterator6);;) {
	      var _ref6;

	      if (_isArray6) {
	        if (_i6 >= _iterator6.length) break;
	        _ref6 = _iterator6[_i6++];
	      } else {
	        _i6 = _iterator6.next();
	        if (_i6.done) break;
	        _ref6 = _i6.value;
	      }

	      var chain = _ref6;

	      var flags = chain.defaultFlags;

	      for (var _iterator7 = chain.subtables, _isArray7 = Array.isArray(_iterator7), _i7 = 0, _iterator7 = _isArray7 ? _iterator7 : _getIterator(_iterator7);;) {
	        var _ref7;

	        if (_isArray7) {
	          if (_i7 >= _iterator7.length) break;
	          _ref7 = _iterator7[_i7++];
	        } else {
	          _i7 = _iterator7.next();
	          if (_i7.done) break;
	          _ref7 = _i7.value;
	        }

	        var subtable = _ref7;

	        if (subtable.subFeatureFlags & flags) {
	          this.generateInputsForSubtable(subtable);
	        }
	      }
	    }
	  };

	  AATMorxProcessor.prototype.generateInputsForSubtable = function generateInputsForSubtable(subtable) {
	    var _this = this;

	    // Currently, only supporting ligature subtables.
	    if (subtable.type !== 2) {
	      return;
	    }

	    var reverse = !!(subtable.coverage & REVERSE_DIRECTION);
	    if (reverse) {
	      throw new Error('Reverse subtable, not supported.');
	    }

	    this.subtable = subtable;
	    this.ligatureStack = [];

	    var stateMachine = this.getStateMachine(subtable);
	    var process = this.getProcessor();

	    var input = [];
	    var stack = [];
	    this.glyphs = [];

	    stateMachine.traverse({
	      enter: function enter(glyph, entry) {
	        var glyphs = _this.glyphs;
	        stack.push({
	          glyphs: glyphs.slice(),
	          ligatureStack: _this.ligatureStack.slice()
	        });

	        // Add glyph to input and glyphs to process.
	        var g = _this.font.getGlyph(glyph);
	        input.push(g);
	        glyphs.push(input[input.length - 1]);

	        // Process ligature substitution
	        process(glyphs[glyphs.length - 1], entry, glyphs.length - 1);

	        // Add input to result if only one matching (non-deleted) glyph remains.
	        var count = 0;
	        var found = 0;
	        for (var i = 0; i < glyphs.length && count <= 1; i++) {
	          if (glyphs[i].id !== 0xffff) {
	            count++;
	            found = glyphs[i].id;
	          }
	        }

	        if (count === 1) {
	          var result = input.map(function (g) {
	            return g.id;
	          });
	          var _cache = _this.inputCache[found];
	          if (_cache) {
	            _cache.push(result);
	          } else {
	            _this.inputCache[found] = [result];
	          }
	        }
	      },

	      exit: function exit() {
	        var _stack$pop = stack.pop();

	        _this.glyphs = _stack$pop.glyphs;
	        _this.ligatureStack = _stack$pop.ligatureStack;

	        input.pop();
	      }
	    });
	  };

	  return AATMorxProcessor;
	}(), (_applyDecoratedDescriptor$2(_class$2.prototype, 'getStateMachine', [cache], _Object$getOwnPropertyDescriptor(_class$2.prototype, 'getStateMachine'), _class$2.prototype)), _class$2);

	function swap(glyphs, rangeA, rangeB) {
	  var reverseA = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	  var reverseB = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

	  var end = glyphs.splice(rangeB[0] - (rangeB[1] - 1), rangeB[1]);
	  if (reverseB) {
	    end.reverse();
	  }

	  var start = glyphs.splice.apply(glyphs, [rangeA[0], rangeA[1]].concat(end));
	  if (reverseA) {
	    start.reverse();
	  }

	  glyphs.splice.apply(glyphs, [rangeB[0] - (rangeA[1] - 1), 0].concat(start));
	  return glyphs;
	}

	function reorderGlyphs(glyphs, verb, firstGlyph, lastGlyph) {
	  var length = lastGlyph - firstGlyph + 1;
	  switch (verb) {
	    case 0:
	      // no change
	      return glyphs;

	    case 1:
	      // Ax => xA
	      return swap(glyphs, [firstGlyph, 1], [lastGlyph, 0]);

	    case 2:
	      // xD => Dx
	      return swap(glyphs, [firstGlyph, 0], [lastGlyph, 1]);

	    case 3:
	      // AxD => DxA
	      return swap(glyphs, [firstGlyph, 1], [lastGlyph, 1]);

	    case 4:
	      // ABx => xAB
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 0]);

	    case 5:
	      // ABx => xBA
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 0], true, false);

	    case 6:
	      // xCD => CDx
	      return swap(glyphs, [firstGlyph, 0], [lastGlyph, 2]);

	    case 7:
	      // xCD => DCx
	      return swap(glyphs, [firstGlyph, 0], [lastGlyph, 2], false, true);

	    case 8:
	      // AxCD => CDxA
	      return swap(glyphs, [firstGlyph, 1], [lastGlyph, 2]);

	    case 9:
	      // AxCD => DCxA
	      return swap(glyphs, [firstGlyph, 1], [lastGlyph, 2], false, true);

	    case 10:
	      // ABxD => DxAB
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 1]);

	    case 11:
	      // ABxD => DxBA
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 1], true, false);

	    case 12:
	      // ABxCD => CDxAB
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 2]);

	    case 13:
	      // ABxCD => CDxBA
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 2], true, false);

	    case 14:
	      // ABxCD => DCxAB
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 2], false, true);

	    case 15:
	      // ABxCD => DCxBA
	      return swap(glyphs, [firstGlyph, 2], [lastGlyph, 2], true, true);

	    default:
	      throw new Error('Unknown verb: ' + verb);
	  }
	}

	var AATLayoutEngine = function () {
	  function AATLayoutEngine(font) {
	    _classCallCheck(this, AATLayoutEngine);

	    this.font = font;
	    this.morxProcessor = new AATMorxProcessor(font);
	    this.fallbackPosition = false;
	  }

	  AATLayoutEngine.prototype.substitute = function substitute(glyphRun) {
	    // AAT expects the glyphs to be in visual order prior to morx processing,
	    // so reverse the glyphs if the script is right-to-left.
	    if (glyphRun.direction === 'rtl') {
	      glyphRun.glyphs.reverse();
	    }

	    this.morxProcessor.process(glyphRun.glyphs, mapOTToAAT(glyphRun.features));
	  };

	  AATLayoutEngine.prototype.getAvailableFeatures = function getAvailableFeatures(script, language) {
	    return mapAATToOT(this.morxProcessor.getSupportedFeatures());
	  };

	  AATLayoutEngine.prototype.stringsForGlyph = function stringsForGlyph(gid) {
	    var glyphStrings = this.morxProcessor.generateInputs(gid);
	    var result = new _Set();

	    for (var _iterator = glyphStrings, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var glyphs = _ref;

	      this._addStrings(glyphs, 0, result, '');
	    }

	    return result;
	  };

	  AATLayoutEngine.prototype._addStrings = function _addStrings(glyphs, index, strings, string) {
	    var codePoints = this.font._cmapProcessor.codePointsForGlyph(glyphs[index]);

	    for (var _iterator2 = codePoints, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	      var _ref2;

	      if (_isArray2) {
	        if (_i2 >= _iterator2.length) break;
	        _ref2 = _iterator2[_i2++];
	      } else {
	        _i2 = _iterator2.next();
	        if (_i2.done) break;
	        _ref2 = _i2.value;
	      }

	      var codePoint = _ref2;

	      var s = string + _String$fromCodePoint(codePoint);
	      if (index < glyphs.length - 1) {
	        this._addStrings(glyphs, index + 1, strings, s);
	      } else {
	        strings.add(s);
	      }
	    }
	  };

	  return AATLayoutEngine;
	}();

	/**
	 * ShapingPlans are used by the OpenType shapers to store which
	 * features should by applied, and in what order to apply them.
	 * The features are applied in groups called stages. A feature
	 * can be applied globally to all glyphs, or locally to only
	 * specific glyphs.
	 *
	 * @private
	 */

	var ShapingPlan = function () {
	  function ShapingPlan(font, script, direction) {
	    _classCallCheck(this, ShapingPlan);

	    this.font = font;
	    this.script = script;
	    this.direction = direction;
	    this.stages = [];
	    this.globalFeatures = {};
	    this.allFeatures = {};
	  }

	  /**
	   * Adds the given features to the last stage.
	   * Ignores features that have already been applied.
	   */


	  ShapingPlan.prototype._addFeatures = function _addFeatures(features, global) {
	    var stageIndex = this.stages.length - 1;
	    var stage = this.stages[stageIndex];
	    for (var _iterator = features, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var feature = _ref;

	      if (this.allFeatures[feature] == null) {
	        stage.push(feature);
	        this.allFeatures[feature] = stageIndex;

	        if (global) {
	          this.globalFeatures[feature] = true;
	        }
	      }
	    }
	  };

	  /**
	   * Add features to the last stage
	   */


	  ShapingPlan.prototype.add = function add(arg) {
	    var global = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	    if (this.stages.length === 0) {
	      this.stages.push([]);
	    }

	    if (typeof arg === 'string') {
	      arg = [arg];
	    }

	    if (Array.isArray(arg)) {
	      this._addFeatures(arg, global);
	    } else if ((typeof arg === 'undefined' ? 'undefined' : _typeof(arg)) === 'object') {
	      this._addFeatures(arg.global || [], true);
	      this._addFeatures(arg.local || [], false);
	    } else {
	      throw new Error("Unsupported argument to ShapingPlan#add");
	    }
	  };

	  /**
	   * Add a new stage
	   */


	  ShapingPlan.prototype.addStage = function addStage(arg, global) {
	    if (typeof arg === 'function') {
	      this.stages.push(arg, []);
	    } else {
	      this.stages.push([]);
	      this.add(arg, global);
	    }
	  };

	  ShapingPlan.prototype.setFeatureOverrides = function setFeatureOverrides(features) {
	    if (Array.isArray(features)) {
	      this.add(features);
	    } else if ((typeof features === 'undefined' ? 'undefined' : _typeof(features)) === 'object') {
	      for (var tag in features) {
	        if (features[tag]) {
	          this.add(tag);
	        } else if (this.allFeatures[tag] != null) {
	          var stage = this.stages[this.allFeatures[tag]];
	          stage.splice(stage.indexOf(tag), 1);
	          delete this.allFeatures[tag];
	          delete this.globalFeatures[tag];
	        }
	      }
	    }
	  };

	  /**
	   * Assigns the global features to the given glyphs
	   */


	  ShapingPlan.prototype.assignGlobalFeatures = function assignGlobalFeatures(glyphs) {
	    for (var _iterator2 = glyphs, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	      var _ref2;

	      if (_isArray2) {
	        if (_i2 >= _iterator2.length) break;
	        _ref2 = _iterator2[_i2++];
	      } else {
	        _i2 = _iterator2.next();
	        if (_i2.done) break;
	        _ref2 = _i2.value;
	      }

	      var glyph = _ref2;

	      for (var feature in this.globalFeatures) {
	        glyph.features[feature] = true;
	      }
	    }
	  };

	  /**
	   * Executes the planned stages using the given OTProcessor
	   */


	  ShapingPlan.prototype.process = function process(processor, glyphs, positions) {
	    for (var _iterator3 = this.stages, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	      var _ref3;

	      if (_isArray3) {
	        if (_i3 >= _iterator3.length) break;
	        _ref3 = _iterator3[_i3++];
	      } else {
	        _i3 = _iterator3.next();
	        if (_i3.done) break;
	        _ref3 = _i3.value;
	      }

	      var stage = _ref3;

	      if (typeof stage === 'function') {
	        if (!positions) {
	          stage(this.font, glyphs, this);
	        }
	      } else if (stage.length > 0) {
	        processor.applyFeatures(stage, glyphs, positions);
	      }
	    }
	  };

	  return ShapingPlan;
	}();

	var _class$4;
	var _temp;
	var VARIATION_FEATURES = ['rvrn'];
	var COMMON_FEATURES = ['ccmp', 'locl', 'rlig', 'mark', 'mkmk'];
	var FRACTIONAL_FEATURES = ['frac', 'numr', 'dnom'];
	var HORIZONTAL_FEATURES = ['calt', 'clig', 'liga', 'rclt', 'curs', 'kern'];
	var DIRECTIONAL_FEATURES = {
	  ltr: ['ltra', 'ltrm'],
	  rtl: ['rtla', 'rtlm']
	};

	var DefaultShaper = (_temp = _class$4 = function () {
	  function DefaultShaper() {
	    _classCallCheck(this, DefaultShaper);
	  }

	  DefaultShaper.plan = function plan(_plan, glyphs, features) {
	    // Plan the features we want to apply
	    this.planPreprocessing(_plan);
	    this.planFeatures(_plan);
	    this.planPostprocessing(_plan, features);

	    // Assign the global features to all the glyphs
	    _plan.assignGlobalFeatures(glyphs);

	    // Assign local features to glyphs
	    this.assignFeatures(_plan, glyphs);
	  };

	  DefaultShaper.planPreprocessing = function planPreprocessing(plan) {
	    plan.add({
	      global: [].concat(VARIATION_FEATURES, DIRECTIONAL_FEATURES[plan.direction]),
	      local: FRACTIONAL_FEATURES
	    });
	  };

	  DefaultShaper.planFeatures = function planFeatures(plan) {
	    // Do nothing by default. Let subclasses override this.
	  };

	  DefaultShaper.planPostprocessing = function planPostprocessing(plan, userFeatures) {
	    plan.add([].concat(COMMON_FEATURES, HORIZONTAL_FEATURES));
	    plan.setFeatureOverrides(userFeatures);
	  };

	  DefaultShaper.assignFeatures = function assignFeatures(plan, glyphs) {
	    // Enable contextual fractions
	    for (var i = 0; i < glyphs.length; i++) {
	      var glyph = glyphs[i];
	      if (glyph.codePoints[0] === 0x2044) {
	        // fraction slash
	        var start = i;
	        var end = i + 1;

	        // Apply numerator
	        while (start > 0 && unicode.isDigit(glyphs[start - 1].codePoints[0])) {
	          glyphs[start - 1].features.numr = true;
	          glyphs[start - 1].features.frac = true;
	          start--;
	        }

	        // Apply denominator
	        while (end < glyphs.length && unicode.isDigit(glyphs[end].codePoints[0])) {
	          glyphs[end].features.dnom = true;
	          glyphs[end].features.frac = true;
	          end++;
	        }

	        // Apply fraction slash
	        glyph.features.frac = true;
	        i = end - 1;
	      }
	    }
	  };

	  return DefaultShaper;
	}(), _class$4.zeroMarkWidths = 'AFTER_GPOS', _temp);

	var trie = new UnicodeTrie(Buffer("AAEQAAAAAAAAADGgAZUBav7t2CtPA0EUBeDZB00pin9AJZIEgyUEj0QhweDAgQOJxCBRBElQSBwSicLgkOAwnNKZ5GaY2c7uzj4o5yZfZrrbefbuIx2nSq3CGmzAWH/+K+UO7MIe7MMhHMMpnMMFXMIVXIt2t3CnP088iPqjqNN8e4Ij7Rle4LUH82rLm6i/92A+RERERERERERNmfz/89GDeRARERERzbN8ceps2Iwt9H0C9/AJ6yOlDkbTczcot5VSm8Pm1vcFWfb7+BKOLTuOd2UlTX4wGP85Eg953lWPFbnuN7PkjtLmalOWbNenkHOSa7T3KmR9MVTZ2zZkVj1kHa68MueVKH0R4zqQ44WEXLM8VjcWHP0PtKLfPzQnMtGn3W4QYf6qxFxceVI394r2xnV+1rih0fV1Vzf3fO1n3evL5J78ruvZ5ptX2Rwy92Tfb1wlEqut3U+sZ3HXOeJ7/zDrbyuP6+Zz0fqa6Nv3vhY7Yu1xWnGevmsvsUpTT/RYIe8waUH/rvHMWKFzLfN8L+rTfp645mfX7ftlnfDtYxN59w0=","base64"));
	var FEATURES = ['isol', 'fina', 'fin2', 'fin3', 'medi', 'med2', 'init'];

	var ShapingClasses = {
	  Non_Joining: 0,
	  Left_Joining: 1,
	  Right_Joining: 2,
	  Dual_Joining: 3,
	  Join_Causing: 3,
	  ALAPH: 4,
	  'DALATH RISH': 5,
	  Transparent: 6
	};

	var ISOL = 'isol';
	var FINA = 'fina';
	var FIN2 = 'fin2';
	var FIN3 = 'fin3';
	var MEDI = 'medi';
	var MED2 = 'med2';
	var INIT = 'init';
	var NONE = null;

	// Each entry is [prevAction, curAction, nextState]
	var STATE_TABLE = [
	//   Non_Joining,        Left_Joining,       Right_Joining,     Dual_Joining,           ALAPH,            DALATH RISH
	// State 0: prev was U,  not willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [NONE, ISOL, 1], [NONE, ISOL, 2], [NONE, ISOL, 1], [NONE, ISOL, 6]],

	// State 1: prev was R or ISOL/ALAPH,  not willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [NONE, ISOL, 1], [NONE, ISOL, 2], [NONE, FIN2, 5], [NONE, ISOL, 6]],

	// State 2: prev was D/L in ISOL form,  willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [INIT, FINA, 1], [INIT, FINA, 3], [INIT, FINA, 4], [INIT, FINA, 6]],

	// State 3: prev was D in FINA form,  willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [MEDI, FINA, 1], [MEDI, FINA, 3], [MEDI, FINA, 4], [MEDI, FINA, 6]],

	// State 4: prev was FINA ALAPH,  not willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [MED2, ISOL, 1], [MED2, ISOL, 2], [MED2, FIN2, 5], [MED2, ISOL, 6]],

	// State 5: prev was FIN2/FIN3 ALAPH,  not willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [ISOL, ISOL, 1], [ISOL, ISOL, 2], [ISOL, FIN2, 5], [ISOL, ISOL, 6]],

	// State 6: prev was DALATH/RISH,  not willing to join.
	[[NONE, NONE, 0], [NONE, ISOL, 2], [NONE, ISOL, 1], [NONE, ISOL, 2], [NONE, FIN3, 5], [NONE, ISOL, 6]]];

	/**
	 * This is a shaper for Arabic, and other cursive scripts.
	 * It uses data from ArabicShaping.txt in the Unicode database,
	 * compiled to a UnicodeTrie by generate-data.coffee.
	 *
	 * The shaping state machine was ported from Harfbuzz.
	 * https://github.com/behdad/harfbuzz/blob/master/src/hb-ot-shape-complex-arabic.cc
	 */

	var ArabicShaper = function (_DefaultShaper) {
	  _inherits(ArabicShaper, _DefaultShaper);

	  function ArabicShaper() {
	    _classCallCheck(this, ArabicShaper);

	    return _possibleConstructorReturn(this, _DefaultShaper.apply(this, arguments));
	  }

	  ArabicShaper.planFeatures = function planFeatures(plan) {
	    plan.add(['ccmp', 'locl']);
	    for (var i = 0; i < FEATURES.length; i++) {
	      var feature = FEATURES[i];
	      plan.addStage(feature, false);
	    }

	    plan.addStage('mset');
	  };

	  ArabicShaper.assignFeatures = function assignFeatures(plan, glyphs) {
	    _DefaultShaper.assignFeatures.call(this, plan, glyphs);

	    var prev = -1;
	    var state = 0;
	    var actions = [];

	    // Apply the state machine to map glyphs to features
	    for (var i = 0; i < glyphs.length; i++) {
	      var curAction = void 0,
	          prevAction = void 0;
	      var glyph = glyphs[i];
	      var type = getShapingClass(glyph.codePoints[0]);
	      if (type === ShapingClasses.Transparent) {
	        actions[i] = NONE;
	        continue;
	      }

	      var _STATE_TABLE$state$ty = STATE_TABLE[state][type];
	      prevAction = _STATE_TABLE$state$ty[0];
	      curAction = _STATE_TABLE$state$ty[1];
	      state = _STATE_TABLE$state$ty[2];


	      if (prevAction !== NONE && prev !== -1) {
	        actions[prev] = prevAction;
	      }

	      actions[i] = curAction;
	      prev = i;
	    }

	    // Apply the chosen features to their respective glyphs
	    for (var index = 0; index < glyphs.length; index++) {
	      var feature = void 0;
	      var glyph = glyphs[index];
	      if (feature = actions[index]) {
	        glyph.features[feature] = true;
	      }
	    }
	  };

	  return ArabicShaper;
	}(DefaultShaper);

	function getShapingClass(codePoint) {
	  var res = trie.get(codePoint);
	  if (res) {
	    return res - 1;
	  }

	  var category = unicode.getCategory(codePoint);
	  if (category === 'Mn' || category === 'Me' || category === 'Cf') {
	    return ShapingClasses.Transparent;
	  }

	  return ShapingClasses.Non_Joining;
	}

	var GlyphIterator = function () {
	  function GlyphIterator(glyphs, options) {
	    _classCallCheck(this, GlyphIterator);

	    this.glyphs = glyphs;
	    this.reset(options);
	  }

	  GlyphIterator.prototype.reset = function reset() {
	    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

	    this.options = options;
	    this.flags = options.flags || {};
	    this.markAttachmentType = options.markAttachmentType || 0;
	    this.index = index;
	  };

	  GlyphIterator.prototype.shouldIgnore = function shouldIgnore(glyph) {
	    return this.flags.ignoreMarks && glyph.isMark || this.flags.ignoreBaseGlyphs && glyph.isBase || this.flags.ignoreLigatures && glyph.isLigature || this.markAttachmentType && glyph.isMark && glyph.markAttachmentType !== this.markAttachmentType;
	  };

	  GlyphIterator.prototype.move = function move(dir) {
	    this.index += dir;
	    while (0 <= this.index && this.index < this.glyphs.length && this.shouldIgnore(this.glyphs[this.index])) {
	      this.index += dir;
	    }

	    if (0 > this.index || this.index >= this.glyphs.length) {
	      return null;
	    }

	    return this.glyphs[this.index];
	  };

	  GlyphIterator.prototype.next = function next() {
	    return this.move(+1);
	  };

	  GlyphIterator.prototype.prev = function prev() {
	    return this.move(-1);
	  };

	  GlyphIterator.prototype.peek = function peek() {
	    var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

	    var idx = this.index;
	    var res = this.increment(count);
	    this.index = idx;
	    return res;
	  };

	  GlyphIterator.prototype.peekIndex = function peekIndex() {
	    var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

	    var idx = this.index;
	    this.increment(count);
	    var res = this.index;
	    this.index = idx;
	    return res;
	  };

	  GlyphIterator.prototype.increment = function increment() {
	    var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

	    var dir = count < 0 ? -1 : 1;
	    count = Math.abs(count);
	    while (count--) {
	      this.move(dir);
	    }

	    return this.glyphs[this.index];
	  };

	  _createClass(GlyphIterator, [{
	    key: "cur",
	    get: function get() {
	      return this.glyphs[this.index] || null;
	    }
	  }]);

	  return GlyphIterator;
	}();

	var DEFAULT_SCRIPTS = ['DFLT', 'dflt', 'latn'];

	var OTProcessor = function () {
	  function OTProcessor(font, table) {
	    _classCallCheck(this, OTProcessor);

	    this.font = font;
	    this.table = table;

	    this.script = null;
	    this.scriptTag = null;

	    this.language = null;
	    this.languageTag = null;

	    this.features = {};
	    this.lookups = {};

	    // Setup variation substitutions
	    this.variationsIndex = font._variationProcessor ? this.findVariationsIndex(font._variationProcessor.normalizedCoords) : -1;

	    // initialize to default script + language
	    this.selectScript();

	    // current context (set by applyFeatures)
	    this.glyphs = [];
	    this.positions = []; // only used by GPOS
	    this.ligatureID = 1;
	    this.currentFeature = null;
	  }

	  OTProcessor.prototype.findScript = function findScript(script) {
	    if (this.table.scriptList == null) {
	      return null;
	    }

	    if (!Array.isArray(script)) {
	      script = [script];
	    }

	    for (var _iterator = script, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	      var _ref;

	      if (_isArray) {
	        if (_i >= _iterator.length) break;
	        _ref = _iterator[_i++];
	      } else {
	        _i = _iterator.next();
	        if (_i.done) break;
	        _ref = _i.value;
	      }

	      var s = _ref;

	      for (var _iterator2 = this.table.scriptList, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	        var _ref2;

	        if (_isArray2) {
	          if (_i2 >= _iterator2.length) break;
	          _ref2 = _iterator2[_i2++];
	        } else {
	          _i2 = _iterator2.next();
	          if (_i2.done) break;
	          _ref2 = _i2.value;
	        }

	        var entry = _ref2;

	        if (entry.tag === s) {
	          return entry;
	        }
	      }
	    }

	    return null;
	  };

	  OTProcessor.prototype.selectScript = function selectScript(script, language, direction$$) {
	    var changed = false;
	    var entry = void 0;
	    if (!this.script || script !== this.scriptTag) {
	      entry = this.findScript(script);
	      if (!entry) {
	        entry = this.findScript(DEFAULT_SCRIPTS);
	      }

	      if (!entry) {
	        return this.scriptTag;
	      }

	      this.scriptTag = entry.tag;
	      this.script = entry.script;
	      this.language = null;
	      this.languageTag = null;
	      changed = true;
	    }

	    if (!direction$$ || direction$$ !== this.direction) {
	      this.direction = direction$$ || direction(script);
	    }

	    if (language && language.length < 4) {
	      language += ' '.repeat(4 - language.length);
	    }

	    if (!language || language !== this.languageTag) {
	      this.language = null;

	      for (var _iterator3 = this.script.langSysRecords, _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3);;) {
	        var _ref3;

	        if (_isArray3) {
	          if (_i3 >= _iterator3.length) break;
	          _ref3 = _iterator3[_i3++];
	        } else {
	          _i3 = _iterator3.next();
	          if (_i3.done) break;
	          _ref3 = _i3.value;
	        }

	        var lang = _ref3;

	        if (lang.tag === language) {
	          this.language = lang.langSys;
	          this.languageTag = lang.tag;
	          break;
	        }
	      }

	      if (!this.language) {
	        this.language = this.script.defaultLangSys;
	        this.languageTag = null;
	      }

	      changed = true;
	    }

	    // Build a feature lookup table
	    if (changed) {
	      this.features = {};
	      if (this.language) {
	        for (var _iterator4 = this.language.featureIndexes, _isArray4 = Array.isArray(_iterator4), _i4 = 0, _iterator4 = _isArray4 ? _iterator4 : _getIterator(_iterator4);;) {
	          var _ref4;

	          if (_isArray4) {
	            if (_i4 >= _iterator4.length) break;
	            _ref4 = _iterator4[_i4++];
	          } else {
	            _i4 = _iterator4.next();
	            if (_i4.done) break;
	            _ref4 = _i4.value;
	          }

	          var featureIndex = _ref4;

	          var record = this.table.featureList[featureIndex];
	          var substituteFeature = this.substituteFeatureForVariations(featureIndex);
	          this.features[record.tag] = substituteFeature || record.feature;
	        }
	      }
	    }

	    return this.scriptTag;
	  };

	  OTProcessor.prototype.lookupsForFeatures = function lookupsForFeatures() {
	    var userFeatures = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
	    var exclude = arguments[1];

	    var lookups = [];
	    for (var _iterator5 = userFeatures, _isArray5 = Array.isArray(_iterator5), _i5 = 0, _iterator5 = _isArray5 ? _iterator5 : _getIterator(_iterator5);;) {
	      var _ref5;

	      if (_isArray5) {
	        if (_i5 >= _iterator5.length) break;
	        _ref5 = _iterator5[_i5++];
	      } else {
	        _i5 = _iterator5.next();
	        if (_i5.done) break;
	        _ref5 = _i5.value;
	      }

	      var tag = _ref5;

	      var feature = this.features[tag];
	      if (!feature) {
	        continue;
	      }

	      for (var _iterator6 = feature.lookupListIndexes, _isArray6 = Array.isArray(_iterator6), _i6 = 0, _iterator6 = _isArray6 ? _iterator6 : _getIterator(_iterator6);;) {
	        var _ref6;

	        if (_isArray6) {
	          if (_i6 >= _iterator6.length) break;
	          _ref6 = _iterator6[_i6++];
	        } else {
	          _i6 = _iterator6.next();
	          if (_i6.done) break;
	          _ref6 = _i6.value;
	        }

	        var lookupIndex = _ref6;

	        if (exclude && exclude.indexOf(lookupIndex) !== -1) {
	          continue;
	        }

	        lookups.push({
	          feature: tag,
	          index: lookupIndex,
	          lookup: this.table.lookupList.get(lookupIndex)
	        });
	      }
	    }

	    lookups.sort(function (a, b) {
	      return a.index - b.index;
	    });
	    return lookups;
	  };

	  OTProcessor.prototype.substituteFeatureForVariations = function substituteFeatureForVariations(featureIndex) {
	    if (this.variationsIndex === -1) {
	      return null;
	    }

	    var record = this.table.featureVariations.featureVariationRecords[this.variationsIndex];
	    var substitutions = record.featureTableSubstitution.substitutions;
	    for (var _iterator7 = substitutions, _isArray7 = Array.isArray(_iterator7), _i7 = 0, _iterator7 = _isArray7 ? _iterator7 : _getIterator(_iterator7);;) {
	      var _ref7;

	      if (_isArray7) {
	        if (_i7 >= _iterator7.length) break;
	        _ref7 = _iterator7[_i7++];
	      } else {
	        _i7 = _iterator7.next();
	        if (_i7.done) break;
	        _ref7 = _i7.value;
	      }

	      var substitution = _ref7;

	      if (substitution.featureIndex === featureIndex) {
	        return substitution.alternateFeatureTable;
	      }
	    }

	    return null;
	  };

	  OTProcessor.prototype.findVariationsIndex = function findVariationsIndex(coords) {
	    var variations = this.table.featureVariations;
	    if (!variations) {
	      return -1;
	    }

	    var records = variations.featureVariationRecords;
	    for (var i = 0; i < records.length; i++) {
	      var conditions = records[i].conditionSet.conditionTable;
	      if (this.variationConditionsMatch(conditions, coords)) {
	        return i;
	      }
	    }

	    return -1;
	  };

	  OTProcessor.prototype.variationConditionsMatch = function variationConditionsMatch(conditions, coords) {
	    return conditions.every(function (condition) {
	      var coord = condition.axisIndex < coords.length ? coords[condition.axisIndex] : 0;
	      return condition.filterRangeMinValue <= coord && coord <= condition.filterRangeMaxValue;
	    });
	  };

	  OTProcessor.prototype.applyFeatures = function applyFeatures(userFeatures, glyphs, advances) {
	    var lookups = this.lookupsForFeatures(userFeatures);
	    this.applyLookups(lookups, glyphs, advances);
	  };

	  OTProcessor.prototype.applyLookups = function applyLookups(lookups, glyphs, positions) {
	    this.glyphs = glyphs;
	    this.positions = positions;
	    this.glyphIterator = new GlyphIterator(glyphs);

	    for (var _iterator8 = lookups, _isArray8 = Array.isArray(_iterator8), _i8 = 0, _iterator8 = _isArray8 ? _iterator8 : _getIterator(_iterator8);;) {
	      var _ref8;

	      if (_isArray8) {
	        if (_i8 >= _iterator8.length) break;
	        _ref8 = _iterator8[_i8++];
	      } else {
	        _i8 = _iterator8.next();
	        if (_i8.done) break;
	        _ref8 = _i8.value;
	      }

	      var _ref9 = _ref8,
	          feature = _ref9.feature,
	          lookup = _ref9.lookup;

	      this.currentFeature = feature;
	      this.glyphIterator.reset(lookup.flags);

	      while (this.glyphIterator.index < glyphs.length) {
	        if (!(feature in this.glyphIterator.cur.features)) {
	          this.glyphIterator.next();
	          continue;
	        }

	        for (var _iterator9 = lookup.subTables, _isArray9 = Array.isArray(_iterator9), _i9 = 0, _iterator9 = _isArray9 ? _iterator9 : _getIterator(_iterator9);;) {
	          var _ref10;

	          if (_isArray9) {
	            if (_i9 >= _iterator9.length) break;
	            _ref10 = _iterator9[_i9++];
	          } else {
	            _i9 = _iterator9.next();
	            if (_i9.done) break;
	            _ref10 = _i9.value;
	          }

	          var table = _ref10;

	          var res = this.applyLookup(lookup.lookupType, table);
	          if (res) {
	            break;
	          }
	        }

	        this.glyphIterator.next();
	      }
	    }
	  };

	  OTProcessor.prototype.applyLookup = function applyLookup(lookup, table) {
	    throw new Error("applyLookup must be implemented by subclasses");
	  };

	  OTProcessor.prototype.applyLookupList = function applyLookupList(lookupRecords) {
	    var options = this.glyphIterator.options;
	    var glyphIndex = this.glyphIterator.index;

	    for (var _iterator10 = lookupRecords, _isArray10 = Array.isArray(_iterator10), _i10 = 0, _iterator10 = _isArray10 ? _iterator10 : _getIterator(_iterator10);;) {
	      var _ref11;

	      if (_isArray10) {
	        if (_i10 >= _iterator10.length) break;
	        _ref11 = _iterator10[_i10++];
	      } else {
	        _i10 = _iterator10.next();
	        if (_i10.done) break;
	        _ref11 = _i10.value;
	      }

	      var lookupRecord = _ref11;

	      // Reset flags and find glyph index for this lookup record
	      this.glyphIterator.reset(options, glyphIndex);
	      this.glyphIterator.increment(lookupRecord.sequenceIndex);

	      // Get the lookup and setup flags for subtables
	      var lookup = this.table.lookupList.get(lookupRecord.lookupListIndex);
	      this.glyphIterator.reset(lookup.flags, this.glyphIterator.index);

	      // Apply lookup subtables until one matches
	      for (var _iterator11 = lookup.subTables, _isArray11 = Array.isArray(_iterator11), _i11 = 0, _iterator11 = _isArray11 ? _iterator11 : _getIterator(_iterator11);;) {
	        var _ref12;

	        if (_isArray11) {
	          if (_i11 >= _iterator11.length) break;
	          _ref12 = _iterator11[_i11++];
	        } else {
	          _i11 = _iterator11.next();
	          if (_i11.done) break;
	          _ref12 = _i11.value;
	        }

	        var table = _ref12;

	        if (this.applyLookup(lookup.lookupType, table)) {
	          break;
	        }
	      }
	    }

	    this.glyphIterator.reset(options, glyphIndex);
	    return true;
	  };

	  OTProcessor.prototype.coverageIndex = function coverageIndex(coverage, glyph) {
	    if (glyph == null) {
	      glyph = this.glyphIterator.cur.id;
	    }

	    switch (coverage.version) {
	      case 1:
	        return coverage.glyphs.indexOf(glyph);

	      case 2:
	        for (var _iterator12 = coverage.rangeRecords, _isArray12 = Array.isArray(_iterator12), _i12 = 0, _iterator12 = _isArray12 ? _iterator12 : _getIterator(_iterator12);;) {
	          var _ref13;

	          if (_isArray12) {
	            if (_i12 >= _iterator12.length) break;
	            _ref13 = _iterator12[_i12++];
	          } else {
	            _i12 = _iterator12.next();
	            if (_i12.done) break;
	            _ref13 = _i12.value;
	          }

	          var range = _ref13;

	          if (range.start <= glyph && glyph <= range.end) {
	            return range.startCoverageIndex + glyph - range.start;
	          }
	        }

	        break;
	    }

	    return -1;
	  };

	  OTProcessor.prototype.match = function match(sequenceIndex, sequence, fn, matched) {
	    var pos = this.glyphIterator.index;
	    var glyph = this.glyphIterator.increment(sequenceIndex);
	    var idx = 0;

	    while (idx < sequence.length && glyph && fn(sequence[idx], glyph)) {
	      if (matched) {
	        matched.push(this.glyphIterator.index);
	      }

	      idx++;
	      glyph = this.glyphIterator.next();
	    }

	    this.glyphIterator.index = pos;
	    if (idx < sequence.length) {
	      return false;
	    }

	    return matched || true;
	  };

	  OTProcessor.prototype.sequenceMatches = function sequenceMatches(sequenceIndex, sequence) {
	    return this.match(sequenceIndex, sequence, function (component, glyph) {
	      return component === glyph.id;
	    });
	  };

	  OTProcessor.prototype.sequenceMatchIndices = function sequenceMatchIndices(sequenceIndex, sequence) {
	    var _this = this;

	    return this.match(sequenceIndex, sequence, function (component, glyph) {
	      // If the current feature doesn't apply to this glyph,
	      if (!(_this.currentFeature in glyph.features)) {
	        return false;
	      }

	      return component === glyph.id;
	    }, []);
	  };

	  OTProcessor.prototype.coverageSequenceMatches = function coverageSequenceMatches(sequenceIndex, sequence) {
	    var _this2 = this;

	    return this.match(sequenceIndex, sequence, function (coverage, glyph) {
	      return _this2.coverageIndex(coverage, glyph.id) >= 0;
	    });
	  };

	  OTProcessor.prototype.getClassID = function getClassID(glyph, classDef) {
	    switch (classDef.version) {
	      case 1:
	        // Class array
	        var i = glyph - classDef.startGlyph;
	        if (i >= 0 && i < classDef.classValueArray.length) {
	          return classDef.classValueArray[i];
	        }

	        break;

	      case 2:
	        for (var _iterator13 = classDef.classRangeRecord, _isArray13 = Array.isArray(_iterator13), _i13 = 0, _iterator13 = _isArray13 ? _iterator13 : _getIterator(_iterator13);;) {
	          var _ref14;

	          if (_isArray13) {
	            if (_i13 >= _iterator13.length) break;
	            _ref14 = _iterator13[_i13++];
	          } else {
	            _i13 = _iterator13.next();
	            if (_i13.done) break;
	            _ref14 = _i13.value;
	          }

	          var range = _ref14;

	          if (range.start <= glyph && glyph <= range.end) {
	            return range.class;
	          }
	        }

	        break;
	    }

	    return 0;
	  };

	  OTProcessor.prototype.classSequenceMatches = function classSequenceMatches(sequenceIndex, sequence, classDef) {
	    var _this3 = this;

	    return this.match(sequenceIndex, sequence, function (classID, glyph) {
	      return classID === _this3.getClassID(glyph.id, classDef);
	    });
	  };

	  OTProcessor.prototype.applyContext = function applyContext(table) {
	    switch (table.version) {
	      case 1:
	        var index = this.coverageIndex(table.coverage);
	        if (index === -1) {
	          return false;
	        }

	        var set = table.ruleSets[index];
	        for (var _iterator14 = set, _isArray14 = Array.isArray(_iterator14), _i14 = 0, _iterator14 = _isArray14 ? _iterator14 : _getIterator(_iterator14);;) {
	          var _ref15;

	          if (_isArray14) {
	            if (_i14 >= _iterator14.length) break;
	            _ref15 = _iterator14[_i14++];
	          } else {
	            _i14 = _iterator14.next();
	            if (_i14.done) break;
	            _ref15 = _i14.value;
	          }

	          var rule = _ref15;

	          if (this.sequenceMatches(1, rule.input)) {
	            return this.applyLookupList(rule.lookupRecords);
	          }
	        }

	        break;

	      case 2:
	        if (this.coverageIndex(table.coverage) === -1) {
	          return false;
	        }

	        index = this.getClassID(this.glyphIterator.cur.id, table.classDef);
	        if (index === -1) {
	          return false;
	        }

	        set = table.classSet[index];
	        for (var _iterator15 = set, _isArray15 = Array.isArray(_iterator15), _i15 = 0, _iterator15 = _isArray15 ? _iterator15 : _getIterator(_iterator15);;) {
	          var _ref16;

	          if (_isArray15) {
	            if (_i15 >= _iterator15.length) break;
	            _ref16 = _iterator15[_i15++];
	          } else {
	            _i15 = _iterator15.next();
	            if (_i15.done) break;
	            _ref16 = _i15.value;
	          }

	          var _rule = _ref16;

	          if (this.classSequenceMatches(1, _rule.classes, table.classDef)) {
	            return this.applyLookupList(_rule.lookupRecords);
	          }
	        }

	        break;

	      case 3:
	        if (this.coverageSequenceMatches(0, table.coverages)) {
	          return this.applyLookupList(table.lookupRecords);
	        }

	        break;
	    }

	    return false;
	  };

	  OTProcessor.prototype.applyChainingContext = function applyChainingContext(table) {
	    switch (table.version) {
	      case 1:
	        var index = this.coverageIndex(table.coverage);
	        if (index === -1) {
	          return false;
	        }

	        var set = table.chainRuleSets[index];
	        for (var _iterator16 = set, _isArray16 = Array.isArray(_iterator16), _i16 = 0, _iterator16 = _isArray16 ? _iterator16 : _getIterator(_iterator16);;) {
	          var _ref17;

	          if (_isArray16) {
	            if (_i16 >= _iterator16.length) break;
	            _ref17 = _iterator16[_i16++];
	          } else {
	            _i16 = _iterator16.next();
	            if (_i16.done) break;
	            _ref17 = _i16.value;
	          }

	          var rule = _ref17;

	          if (this.sequenceMatches(-rule.backtrack.length, rule.backtrack) && this.sequenceMatches(1, rule.input) && this.sequenceMatches(1 + rule.input.length, rule.lookahead)) {
	            return this.applyLookupList(rule.lookupRecords);
	          }
	        }

	        break;

	      case 2:
	        if (this.coverageIndex(table.coverage) === -1) {
	          return false;
	        }

	        index = this.getClassID(this.glyphIterator.cur.id, table.inputClassDef);
	        var rules = table.chainClassSet[index];
	        if (!rules) {
	          return false;
	        }

	        for (var _iterator17 = rules, _isArray17 = Array.isArray(_iterator17), _i17 = 0, _iterator17 = _isArray17 ? _iterator17 : _getIterator(_iterator17);;) {
	          var _ref18;

	          if (_isArray17) {
	            if (_i17 >= _iterator17.length) break;
	            _ref18 = _iterator17[_i17++];
	          } else {
	            _i17 = _iterator17.next();
	            if (_i17.done) break;
	            _ref18 = _i17.value;
	          }

	          var _rule2 = _ref18;

	          if (this.classSequenceMatches(-_rule2.backtrack.length, _rule2.backtrack, table.backtrackClassDef) && this.classSequenceMatches(1, _rule2.input, table.inputClassDef) && this.classSequenceMatches(1 + _rule2.input.length, _rule2.lookahead, table.lookaheadClassDef)) {
	            return this.applyLookupList(_rule2.lookupRecords);
	          }
	        }

	        break;

	      case 3:
	        if (this.coverageSequenceMatches(-table.backtrackGlyphCount, table.backtrackCoverage) && this.coverageSequenceMatches(0, table.inputCoverage) && this.coverageSequenceMatches(table.inputGlyphCount, table.lookaheadCoverage)) {
	          return this.applyLookupList(table.lookupRecords);
	        }

	        break;
	    }

	    return false;
	  };

	  return OTProcessor;
	}();

	var GlyphInfo = function () {
	  function GlyphInfo(font, id) {
	    var codePoints = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
	    var features = arguments[3];

	    _classCallCheck(this, GlyphInfo);

	    this._font = font;
	    this.codePoints = codePoints;
	    this.id = id;

	    this.features = {};
	    if (Array.isArray(features)) {
	      for (var i = 0; i < features.length; i++) {
	        var feature = features[i];
	        this.features[feature] = true;
	      }
	    } else if ((typeof features === 'undefined' ? 'undefined' : _typeof(features)) === 'object') {
	      _Object$assign(this.features, features);
	    }

	    this.ligatureID = null;
	    this.ligatureComponent = null;
	    this.isLigated = false;
	    this.cursiveAttachment = null;
	    this.markAttachment = null;
	    this.shaperInfo = null;
	    this.substituted = false;
	    this.isMultiplied = false;
	  }

	  GlyphInfo.prototype.copy = function copy() {
	    return new GlyphInfo(this._font, this.id, this.codePoints, this.features);
	  };

	  _createClass(GlyphInfo, [{
	    key: 'id',
	    get: function get() {
	      return this._id;
	    },
	    set: function set(id) {
	      this._id = id;
	      this.substituted = true;

	      var GDEF = this._font.GDEF;
	      if (GDEF && GDEF.glyphClassDef) {
	        // TODO: clean this up
	        var classID = OTProcessor.prototype.getClassID(id, GDEF.glyphClassDef);
	        this.isBase = classID === 1;
	        this.isLigature = classID === 2;
	        this.isMark = classID === 3;
	        this.markAttachmentType = GDEF.markAttachClassDef ? OTProcessor.prototype.getClassID(id, GDEF.markAttachClassDef) : 0;
	      } else {
	        this.isMark = this.codePoints.every(unicode.isMark);
	        this.isBase = !this.isMark;
	        this.isLigature = this.codePoints.length > 1;
	        this.markAttachmentType = 0;
	      }
	    }
	  }]);

	  return GlyphInfo;
	}();

	var _class$5;
	var _temp$1;
	/**
	 * This is a shaper for the Hangul script, used by the Korean language.
	 * It does the following:
	 *   - decompose if unsupported by the font:
	 *     <LV>   -> <L,V>
	 *     <LVT>  -> <L,V,T>
	 *     <LV,T> -> <L,V,T>
	 *
	 *   - compose if supported by the font:
	 *     <L,V>   -> <LV>
	 *     <L,V,T> -> <LVT>
	 *     <LV,T>  -> <LVT>
	 *
	 *   - reorder tone marks (S is any valid syllable):
	 *     <S, M> -> <M, S>
	 *
	 *   - apply ljmo, vjmo, and tjmo OpenType features to decomposed Jamo sequences.
	 *
	 * This logic is based on the following documents:
	 *   - http://www.microsoft.com/typography/OpenTypeDev/hangul/intro.htm
	 *   - http://ktug.org/~nomos/harfbuzz-hangul/hangulshaper.pdf
	 */
	var HangulShaper = (_temp$1 = _class$5 = function (_DefaultShaper) {
	  _inherits(HangulShaper, _DefaultShaper);

	  function HangulShaper() {
	    _classCallCheck(this, HangulShaper);

	    return _possibleConstructorReturn(this, _DefaultShaper.apply(this, arguments));
	  }

	  HangulShaper.planFeatures = function planFeatures(plan) {
	    plan.add(['ljmo', 'vjmo', 'tjmo'], false);
	  };

	  HangulShaper.assignFeatures = function assignFeatures(plan, glyphs) {
	    var state = 0;
	    var i = 0;
	    while (i < glyphs.length) {
	      var action = void 0;
	      var glyph = glyphs[i];
	      var code = glyph.codePoints[0];
	      var type = getType(code);

	      var _STATE_TABLE$state$ty = STATE_TABLE$1[state][type];
	      action = _STATE_TABLE$state$ty[0];
	      state = _STATE_TABLE$state$ty[1];


	      switch (action) {
	        case DECOMPOSE:
	          // Decompose the composed syllable if it is not supported by the font.
	          if (!plan.font.hasGlyphForCodePoint(code)) {
	            i = decompose(glyphs, i, plan.font);
	          }
	          break;

	        case COMPOSE:
	          // Found a decomposed syllable. Try to compose if supported by the font.
	          i = compose(glyphs, i, plan.font);
	          break;

	        case TONE_MARK:
	          // Got a valid syllable, followed by a tone mark. Move the tone mark to the beginning of the syllable.
	          reorderToneMark(glyphs, i, plan.font);
	          break;

	        case INVALID:
	          // Tone mark has no valid syllable to attach to, so insert a dotted circle
	          i = insertDottedCircle(glyphs, i, plan.font);
	          break;
	      }

	      i++;
	    }
	  };

	  return HangulShaper;
	}(DefaultShaper), _class$5.zeroMarkWidths = 'NONE', _temp$1);
	var HANGUL_BASE = 0xac00;
	var HANGUL_END = 0xd7a4;
	var HANGUL_COUNT = HANGUL_END - HANGUL_BASE + 1;
	var L_BASE = 0x1100; // lead
	var V_BASE = 0x1161; // vowel
	var T_BASE = 0x11a7; // trail
	var L_COUNT = 19;
	var V_COUNT = 21;
	var T_COUNT = 28;
	var L_END = L_BASE + L_COUNT - 1;
	var V_END = V_BASE + V_COUNT - 1;
	var T_END = T_BASE + T_COUNT - 1;
	var DOTTED_CIRCLE = 0x25cc;

	var isL = function isL(code) {
	  return 0x1100 <= code && code <= 0x115f || 0xa960 <= code && code <= 0xa97c;
	};
	var isV = function isV(code) {
	  return 0x1160 <= code && code <= 0x11a7 || 0xd7b0 <= code && code <= 0xd7c6;
	};
	var isT = function isT(code) {
	  return 0x11a8 <= code && code <= 0x11ff || 0xd7cb <= code && code <= 0xd7fb;
	};
	var isTone = function isTone(code) {
	  return 0x302e <= code && code <= 0x302f;
	};
	var isLVT = function isLVT(code) {
	  return HANGUL_BASE <= code && code <= HANGUL_END;
	};
	var isLV = function isLV(code) {
	  return code - HANGUL_BASE < HANGUL_COUNT && (code - HANGUL_BASE) % T_COUNT === 0;
	};
	var isCombiningL = function isCombiningL(code) {
	  return L_BASE <= code && code <= L_END;
	};
	var isCombiningV = function isCombiningV(code) {
	  return V_BASE <= code && code <= V_END;
	};
	var isCombiningT = function isCombiningT(code) {
	  return T_BASE + 1 && 1 <= code && code <= T_END;
	};

	// Character categories
	var X = 0; // Other character
	var L = 1; // Leading consonant
	var V = 2; // Medial vowel
	var T = 3; // Trailing consonant
	var LV = 4; // Composed <LV> syllable
	var LVT = 5; // Composed <LVT> syllable
	var M = 6; // Tone mark

	// This function classifies a character using the above categories.
	function getType(code) {
	  if (isL(code)) {
	    return L;
	  }
	  if (isV(code)) {
	    return V;
	  }
	  if (isT(code)) {
	    return T;
	  }
	  if (isLV(code)) {
	    return LV;
	  }
	  if (isLVT(code)) {
	    return LVT;
	  }
	  if (isTone(code)) {
	    return M;
	  }
	  return X;
	}

	// State machine actions
	var NO_ACTION = 0;
	var DECOMPOSE = 1;
	var COMPOSE = 2;
	var TONE_MARK = 4;
	var INVALID = 5;

	// Build a state machine that accepts valid syllables, and applies actions along the way.
	// The logic this is implementing is documented at the top of the file.
	var STATE_TABLE$1 = [
	//       X                 L                 V                T                  LV                LVT               M
	// State 0: start state
	[[NO_ACTION, 0], [NO_ACTION, 1], [NO_ACTION, 0], [NO_ACTION, 0], [DECOMPOSE, 2], [DECOMPOSE, 3], [INVALID, 0]],

	// State 1: <L>
	[[NO_ACTION, 0], [NO_ACTION, 1], [COMPOSE, 2], [NO_ACTION, 0], [DECOMPOSE, 2], [DECOMPOSE, 3], [INVALID, 0]],

	// State 2: <L,V> or <LV>
	[[NO_ACTION, 0], [NO_ACTION, 1], [NO_ACTION, 0], [COMPOSE, 3], [DECOMPOSE, 2], [DECOMPOSE, 3], [TONE_MARK, 0]],

	// State 3: <L,V,T> or <LVT>
	[[NO_ACTION, 0], [NO_ACTION, 1], [NO_ACTION, 0], [NO_ACTION, 0], [DECOMPOSE, 2], [DECOMPOSE, 3], [TONE_MARK, 0]]];

	function getGlyph(font, code, features) {
	  return new GlyphInfo(font, font.glyphForCodePoint(code).id, [code], features);
	}

	function decompose(glyphs, i, font) {
	  var glyph = glyphs[i];
	  var code = glyph.codePoints[0];

	  var s = code - HANGUL_BASE;
	  var t = T_BASE + s % T_COUNT;
	  s = s / T_COUNT | 0;
	  var l = L_BASE + s / V_COUNT | 0;
	  var v = V_BASE + s % V_COUNT;

	  // Don't decompose if all of the components are not available
	  if (!font.hasGlyphForCodePoint(l) || !font.hasGlyphForCodePoint(v) || t !== T_BASE && !font.hasGlyphForCodePoint(t)) {
	    return i;
	  }

	  // Replace the current glyph with decomposed L, V, and T glyphs,
	  // and apply the proper OpenType features to each component.
	  var ljmo = getGlyph(font, l, glyph.features);
	  ljmo.features.ljmo = true;

	  var vjmo = getGlyph(font, v, glyph.features);
	  vjmo.features.vjmo = true;

	  var insert = [ljmo, vjmo];

	  if (t > T_BASE) {
	    var tjmo = getGlyph(font, t, glyph.features);
	    tjmo.features.tjmo = true;
	    insert.push(tjmo);
	  }

	  glyphs.splice.apply(glyphs, [i, 1].concat(insert));
	  return i + insert.length - 1;
	}

	function compose(glyphs, i, font) {
	  var glyph = glyphs[i];
	  var code = glyphs[i].codePoints[0];
	  var type = getType(code);

	  var prev = glyphs[i - 1].codePoints[0];
	  var prevType = getType(prev);

	  // Figure out what type of syllable we're dealing with
	  var lv = void 0,
	      ljmo = void 0,
	      vjmo = void 0,
	      tjmo = void 0;
	  if (prevType === LV && type === T) {
	    // <LV,T>
	    lv = prev;
	    tjmo = glyph;
	  } else {
	    if (type === V) {
	      // <L,V>
	      ljmo = glyphs[i - 1];
	      vjmo = glyph;
	    } else {
	      // <L,V,T>
	      ljmo = glyphs[i - 2];
	      vjmo = glyphs[i - 1];
	      tjmo = glyph;
	    }

	    var l = ljmo.codePoints[0];
	    var v = vjmo.codePoints[0];

	    // Make sure L and V are combining characters
	    if (isCombiningL(l) && isCombiningV(v)) {
	      lv = HANGUL_BASE + ((l - L_BASE) * V_COUNT + (v - V_BASE)) * T_COUNT;
	    }
	  }

	  var t = tjmo && tjmo.codePoints[0] || T_BASE;
	  if (lv != null && (t === T_BASE || isCombiningT(t))) {
	    var s = lv + (t - T_BASE);

	    // Replace with a composed glyph if supported by the font,
	    // otherwise apply the proper OpenType features to each component.
	    if (font.hasGlyphForCodePoint(s)) {
	      var del = prevType === V ? 3 : 2;
	      glyphs.splice(i - del + 1, del, getGlyph(font, s, glyph.features));
	      return i - del + 1;
	    }
	  }

	  // Didn't compose (either a non-combining component or unsupported by font).
	  if (ljmo) {
	    ljmo.features.ljmo = true;
	  }
	  if (vjmo) {
	    vjmo.features.vjmo = true;
	  }
	  if (tjmo) {
	    tjmo.features.tjmo = true;
	  }

	  if (prevType === LV) {
	    // Sequence was originally <L,V>, which got combined earlier.
	    // Either the T was non-combining, or the LVT glyph wasn't supported.
	    // Decompose the glyph again and apply OT features.
	    decompose(glyphs, i - 1, font);
	    return i + 1;
	  }

	  return i;
	}

	function getLength(code) {
	  switch (getType(code)) {
	    case LV:
	    case LVT:
	      return 1;
	    case V:
	      return 2;
	    case T:
	      return 3;
	  }
	}

	function reorderToneMark(glyphs, i, font) {
	  var glyph = glyphs[i];
	  var code = glyphs[i].codePoints[0];

	  // Move tone mark to the beginning of the previous syllable, unless it is zero width
	  if (font.glyphForCodePoint(code).advanceWidth === 0) {
	    return;
	  }

	  var prev = glyphs[i - 1].codePoints[0];
	  var len = getLength(prev);

	  glyphs.splice(i, 1);
	  return glyphs.splice(i - len, 0, glyph);
	}

	function insertDottedCircle(glyphs, i, font) {
	  var glyph = glyphs[i];
	  var code = glyphs[i].codePoints[0];

	  if (font.hasGlyphForCodePoint(DOTTED_CIRCLE)) {
	    var dottedCircle = getGlyph(font, DOTTED_CIRCLE, glyph.features);

	    // If the tone mark is zero width, insert the dotted circle before, otherwise after
	    var idx = font.glyphForCodePoint(code).advanceWidth === 0 ? i : i + 1;
	    glyphs.splice(idx, 0, dottedCircle);
	    i++;
	  }

	  return i;
	}

	var stateTable = [[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 2, 3, 4, 5, 6, 7, 8, 9, 0, 10, 11, 11, 12, 13, 14, 15, 16, 17], [0, 0, 0, 18, 19, 20, 21, 22, 23, 0, 24, 0, 0, 25, 26, 0, 0, 27, 0], [0, 0, 0, 28, 29, 30, 31, 32, 33, 0, 34, 0, 0, 35, 36, 0, 0, 37, 0], [0, 0, 0, 38, 5, 7, 7, 8, 9, 0, 10, 0, 0, 0, 13, 0, 0, 16, 0], [0, 39, 0, 0, 0, 40, 41, 0, 9, 0, 10, 0, 0, 0, 42, 0, 39, 0, 0], [0, 0, 0, 0, 43, 44, 44, 8, 9, 0, 0, 0, 0, 12, 43, 0, 0, 0, 0], [0, 0, 0, 0, 43, 44, 44, 8, 9, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0], [0, 0, 0, 45, 46, 47, 48, 49, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 50, 0, 0, 51, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 53, 54, 55, 56, 57, 58, 0, 59, 0, 0, 60, 61, 0, 0, 62, 0], [0, 0, 0, 4, 5, 7, 7, 8, 9, 0, 10, 0, 0, 0, 13, 0, 0, 16, 0], [0, 63, 64, 0, 0, 40, 41, 0, 9, 0, 10, 0, 0, 0, 42, 0, 63, 0, 0], [0, 2, 3, 4, 5, 6, 7, 8, 9, 0, 10, 11, 11, 12, 13, 0, 2, 16, 0], [0, 0, 0, 18, 65, 20, 21, 22, 23, 0, 24, 0, 0, 25, 26, 0, 0, 27, 0], [0, 0, 0, 0, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 0, 0], [0, 0, 0, 69, 0, 70, 70, 0, 71, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 73, 19, 74, 74, 22, 23, 0, 24, 0, 0, 0, 26, 0, 0, 27, 0], [0, 75, 0, 0, 0, 76, 77, 0, 23, 0, 24, 0, 0, 0, 78, 0, 75, 0, 0], [0, 0, 0, 0, 79, 80, 80, 22, 23, 0, 0, 0, 0, 25, 79, 0, 0, 0, 0], [0, 0, 0, 18, 19, 20, 74, 22, 23, 0, 24, 0, 0, 25, 26, 0, 0, 27, 0], [0, 0, 0, 81, 82, 83, 84, 85, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 86, 0, 0, 87, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 18, 19, 74, 74, 22, 23, 0, 24, 0, 0, 0, 26, 0, 0, 27, 0], [0, 89, 90, 0, 0, 76, 77, 0, 23, 0, 24, 0, 0, 0, 78, 0, 89, 0, 0], [0, 0, 0, 0, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 0, 0], [0, 0, 0, 94, 29, 95, 31, 32, 33, 0, 34, 0, 0, 0, 36, 0, 0, 37, 0], [0, 96, 0, 0, 0, 97, 98, 0, 33, 0, 34, 0, 0, 0, 99, 0, 96, 0, 0], [0, 0, 0, 0, 100, 101, 101, 32, 33, 0, 0, 0, 0, 35, 100, 0, 0, 0, 0], [0, 0, 0, 0, 100, 101, 101, 32, 33, 0, 0, 0, 0, 0, 100, 0, 0, 0, 0], [0, 0, 0, 102, 103, 104, 105, 106, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 107, 0, 0, 108, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 28, 29, 95, 31, 32, 33, 0, 34, 0, 0, 0, 36, 0, 0, 37, 0], [0, 110, 111, 0, 0, 97, 98, 0, 33, 0, 34, 0, 0, 0, 99, 0, 110, 0, 0], [0, 0, 0, 0, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 0, 0], [0, 0, 0, 0, 5, 7, 7, 8, 9, 0, 10, 0, 0, 0, 13, 0, 0, 16, 0], [0, 0, 0, 115, 116, 117, 118, 8, 9, 0, 10, 0, 0, 119, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 39, 0, 122, 0, 123, 123, 8, 9, 0, 10, 0, 0, 0, 42, 0, 39, 0, 0], [0, 124, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 0, 0], [0, 39, 0, 0, 0, 121, 125, 0, 9, 0, 10, 0, 0, 0, 42, 0, 39, 0, 0], [0, 0, 0, 0, 0, 126, 126, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 46, 47, 48, 49, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 47, 47, 49, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 127, 127, 49, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 128, 127, 127, 49, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 129, 130, 131, 132, 133, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 135, 54, 56, 56, 57, 58, 0, 59, 0, 0, 0, 61, 0, 0, 62, 0], [0, 136, 0, 0, 0, 137, 138, 0, 58, 0, 59, 0, 0, 0, 139, 0, 136, 0, 0], [0, 0, 0, 0, 140, 141, 141, 57, 58, 0, 0, 0, 0, 60, 140, 0, 0, 0, 0], [0, 0, 0, 0, 140, 141, 141, 57, 58, 0, 0, 0, 0, 0, 140, 0, 0, 0, 0], [0, 0, 0, 142, 143, 144, 145, 146, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 147, 0, 0, 148, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 53, 54, 56, 56, 57, 58, 0, 59, 0, 0, 0, 61, 0, 0, 62, 0], [0, 150, 151, 0, 0, 137, 138, 0, 58, 0, 59, 0, 0, 0, 139, 0, 150, 0, 0], [0, 0, 0, 0, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 0, 0], [0, 0, 0, 155, 116, 156, 157, 8, 9, 0, 10, 0, 0, 158, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 75, 3, 4, 5, 159, 160, 8, 161, 0, 162, 0, 11, 12, 163, 0, 75, 16, 0], [0, 0, 0, 0, 0, 40, 164, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 165, 44, 44, 8, 9, 0, 0, 0, 0, 0, 165, 0, 0, 0, 0], [0, 124, 64, 0, 0, 40, 164, 0, 9, 0, 10, 0, 0, 0, 42, 0, 124, 0, 0], [0, 0, 0, 0, 0, 70, 70, 0, 71, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 166, 0, 0, 167, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 19, 74, 74, 22, 23, 0, 24, 0, 0, 0, 26, 0, 0, 27, 0], [0, 0, 0, 0, 79, 80, 80, 22, 23, 0, 0, 0, 0, 0, 79, 0, 0, 0, 0], [0, 0, 0, 169, 170, 171, 172, 22, 23, 0, 24, 0, 0, 173, 174, 0, 0, 27, 0], [0, 0, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 75, 0, 176, 0, 177, 177, 22, 23, 0, 24, 0, 0, 0, 78, 0, 75, 0, 0], [0, 178, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 0, 0], [0, 75, 0, 0, 0, 175, 179, 0, 23, 0, 24, 0, 0, 0, 78, 0, 75, 0, 0], [0, 0, 0, 0, 0, 180, 180, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 82, 83, 84, 85, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 83, 83, 85, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 181, 181, 85, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 182, 181, 181, 85, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 183, 184, 185, 186, 187, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 86, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 189, 170, 190, 191, 22, 23, 0, 24, 0, 0, 192, 174, 0, 0, 27, 0], [0, 0, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 76, 193, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 194, 80, 80, 22, 23, 0, 0, 0, 0, 0, 194, 0, 0, 0, 0], [0, 178, 90, 0, 0, 76, 193, 0, 23, 0, 24, 0, 0, 0, 78, 0, 178, 0, 0], [0, 0, 0, 0, 29, 95, 31, 32, 33, 0, 34, 0, 0, 0, 36, 0, 0, 37, 0], [0, 0, 0, 0, 100, 101, 101, 32, 33, 0, 0, 0, 0, 0, 100, 0, 0, 0, 0], [0, 0, 0, 195, 196, 197, 198, 32, 33, 0, 34, 0, 0, 199, 200, 0, 0, 37, 0], [0, 0, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 96, 0, 202, 0, 203, 203, 32, 33, 0, 34, 0, 0, 0, 99, 0, 96, 0, 0], [0, 204, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 0, 0], [0, 96, 0, 0, 0, 201, 205, 0, 33, 0, 34, 0, 0, 0, 99, 0, 96, 0, 0], [0, 0, 0, 0, 0, 206, 206, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 103, 104, 105, 106, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 104, 104, 106, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 207, 207, 106, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 208, 207, 207, 106, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 209, 210, 211, 212, 213, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 107, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 215, 196, 216, 217, 32, 33, 0, 34, 0, 0, 218, 200, 0, 0, 37, 0], [0, 0, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 97, 219, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 220, 101, 101, 32, 33, 0, 0, 0, 0, 0, 220, 0, 0, 0, 0], [0, 204, 111, 0, 0, 97, 219, 0, 33, 0, 34, 0, 0, 0, 99, 0, 204, 0, 0], [0, 0, 0, 221, 116, 222, 222, 8, 9, 0, 10, 0, 0, 0, 120, 0, 0, 16, 0], [0, 223, 0, 0, 0, 40, 224, 0, 9, 0, 10, 0, 0, 0, 42, 0, 223, 0, 0], [0, 0, 0, 0, 225, 44, 44, 8, 9, 0, 0, 0, 0, 119, 225, 0, 0, 0, 0], [0, 0, 0, 115, 116, 117, 222, 8, 9, 0, 10, 0, 0, 119, 120, 0, 0, 16, 0], [0, 0, 0, 115, 116, 222, 222, 8, 9, 0, 10, 0, 0, 0, 120, 0, 0, 16, 0], [0, 226, 64, 0, 0, 40, 224, 0, 9, 0, 10, 0, 0, 0, 42, 0, 226, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 39, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 39, 0, 0], [0, 0, 0, 0, 0, 44, 44, 8, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 227, 0, 228, 229, 0, 9, 0, 10, 0, 0, 230, 0, 0, 0, 0, 0], [0, 39, 0, 122, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 39, 0, 0], [0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 231, 231, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 130, 131, 132, 133, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 131, 131, 133, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 233, 233, 133, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 234, 233, 233, 133, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 235, 236, 237, 238, 239, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 54, 56, 56, 57, 58, 0, 59, 0, 0, 0, 61, 0, 0, 62, 0], [0, 0, 0, 240, 241, 242, 243, 57, 58, 0, 59, 0, 0, 244, 245, 0, 0, 62, 0], [0, 0, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 136, 0, 247, 0, 248, 248, 57, 58, 0, 59, 0, 0, 0, 139, 0, 136, 0, 0], [0, 249, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 0, 0], [0, 136, 0, 0, 0, 246, 250, 0, 58, 0, 59, 0, 0, 0, 139, 0, 136, 0, 0], [0, 0, 0, 0, 0, 251, 251, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 143, 144, 145, 146, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 144, 144, 146, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 252, 252, 146, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 253, 252, 252, 146, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 254, 255, 256, 257, 258, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 147, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 259, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 260, 241, 261, 262, 57, 58, 0, 59, 0, 0, 263, 245, 0, 0, 62, 0], [0, 0, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 137, 264, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 265, 141, 141, 57, 58, 0, 0, 0, 0, 0, 265, 0, 0, 0, 0], [0, 249, 151, 0, 0, 137, 264, 0, 58, 0, 59, 0, 0, 0, 139, 0, 249, 0, 0], [0, 0, 0, 221, 116, 222, 222, 8, 9, 0, 10, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 225, 44, 44, 8, 9, 0, 0, 0, 0, 158, 225, 0, 0, 0, 0], [0, 0, 0, 155, 116, 156, 222, 8, 9, 0, 10, 0, 0, 158, 120, 0, 0, 16, 0], [0, 0, 0, 155, 116, 222, 222, 8, 9, 0, 10, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 43, 266, 266, 8, 161, 0, 24, 0, 0, 12, 267, 0, 0, 0, 0], [0, 75, 0, 176, 43, 268, 268, 269, 161, 0, 24, 0, 0, 0, 267, 0, 75, 0, 0], [0, 0, 0, 0, 0, 270, 0, 0, 271, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 272, 0, 0, 0, 0, 0, 0, 0, 0], [0, 273, 274, 0, 0, 40, 41, 0, 9, 0, 10, 0, 0, 0, 42, 0, 273, 0, 0], [0, 0, 0, 40, 0, 123, 123, 8, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 121, 275, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 166, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 277, 170, 278, 278, 22, 23, 0, 24, 0, 0, 0, 174, 0, 0, 27, 0], [0, 279, 0, 0, 0, 76, 280, 0, 23, 0, 24, 0, 0, 0, 78, 0, 279, 0, 0], [0, 0, 0, 0, 281, 80, 80, 22, 23, 0, 0, 0, 0, 173, 281, 0, 0, 0, 0], [0, 0, 0, 169, 170, 171, 278, 22, 23, 0, 24, 0, 0, 173, 174, 0, 0, 27, 0], [0, 0, 0, 169, 170, 278, 278, 22, 23, 0, 24, 0, 0, 0, 174, 0, 0, 27, 0], [0, 282, 90, 0, 0, 76, 280, 0, 23, 0, 24, 0, 0, 0, 78, 0, 282, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 75, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 75, 0, 0], [0, 0, 0, 0, 0, 80, 80, 22, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 283, 0, 284, 285, 0, 23, 0, 24, 0, 0, 286, 0, 0, 0, 0, 0], [0, 75, 0, 176, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 75, 0, 0], [0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 287, 287, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 184, 185, 186, 187, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 185, 185, 187, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 289, 289, 187, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 290, 289, 289, 187, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 291, 292, 293, 294, 295, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 277, 170, 278, 278, 22, 23, 0, 24, 0, 0, 0, 174, 0, 0, 27, 0], [0, 0, 0, 0, 281, 80, 80, 22, 23, 0, 0, 0, 0, 192, 281, 0, 0, 0, 0], [0, 0, 0, 189, 170, 190, 278, 22, 23, 0, 24, 0, 0, 192, 174, 0, 0, 27, 0], [0, 0, 0, 189, 170, 278, 278, 22, 23, 0, 24, 0, 0, 0, 174, 0, 0, 27, 0], [0, 0, 0, 76, 0, 177, 177, 22, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 175, 296, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 297, 196, 298, 298, 32, 33, 0, 34, 0, 0, 0, 200, 0, 0, 37, 0], [0, 299, 0, 0, 0, 97, 300, 0, 33, 0, 34, 0, 0, 0, 99, 0, 299, 0, 0], [0, 0, 0, 0, 301, 101, 101, 32, 33, 0, 0, 0, 0, 199, 301, 0, 0, 0, 0], [0, 0, 0, 195, 196, 197, 298, 32, 33, 0, 34, 0, 0, 199, 200, 0, 0, 37, 0], [0, 0, 0, 195, 196, 298, 298, 32, 33, 0, 34, 0, 0, 0, 200, 0, 0, 37, 0], [0, 302, 111, 0, 0, 97, 300, 0, 33, 0, 34, 0, 0, 0, 99, 0, 302, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 96, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 96, 0, 0], [0, 0, 0, 0, 0, 101, 101, 32, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 303, 0, 304, 305, 0, 33, 0, 34, 0, 0, 306, 0, 0, 0, 0, 0], [0, 96, 0, 202, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 96, 0, 0], [0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 307, 307, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 308, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 210, 211, 212, 213, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 211, 211, 213, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 309, 309, 213, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 310, 309, 309, 213, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 311, 312, 313, 314, 315, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 297, 196, 298, 298, 32, 33, 0, 34, 0, 0, 0, 200, 0, 0, 37, 0], [0, 0, 0, 0, 301, 101, 101, 32, 33, 0, 0, 0, 0, 218, 301, 0, 0, 0, 0], [0, 0, 0, 215, 196, 216, 298, 32, 33, 0, 34, 0, 0, 218, 200, 0, 0, 37, 0], [0, 0, 0, 215, 196, 298, 298, 32, 33, 0, 34, 0, 0, 0, 200, 0, 0, 37, 0], [0, 0, 0, 97, 0, 203, 203, 32, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 201, 316, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 116, 222, 222, 8, 9, 0, 10, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 225, 44, 44, 8, 9, 0, 0, 0, 0, 0, 225, 0, 0, 0, 0], [0, 0, 0, 317, 318, 319, 320, 8, 9, 0, 10, 0, 0, 321, 322, 0, 0, 16, 0], [0, 223, 0, 323, 0, 123, 123, 8, 9, 0, 10, 0, 0, 0, 42, 0, 223, 0, 0], [0, 223, 0, 0, 0, 121, 324, 0, 9, 0, 10, 0, 0, 0, 42, 0, 223, 0, 0], [0, 0, 0, 325, 318, 326, 327, 8, 9, 0, 10, 0, 0, 328, 322, 0, 0, 16, 0], [0, 0, 0, 64, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 230, 0, 0, 0, 0, 0], [0, 0, 0, 227, 0, 228, 121, 0, 9, 0, 10, 0, 0, 230, 0, 0, 0, 0, 0], [0, 0, 0, 227, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0], [0, 0, 0, 0, 0, 329, 329, 133, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 330, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 236, 237, 238, 239, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 237, 237, 239, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 331, 331, 239, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 332, 331, 331, 239, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 333, 40, 121, 334, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 335, 241, 336, 336, 57, 58, 0, 59, 0, 0, 0, 245, 0, 0, 62, 0], [0, 337, 0, 0, 0, 137, 338, 0, 58, 0, 59, 0, 0, 0, 139, 0, 337, 0, 0], [0, 0, 0, 0, 339, 141, 141, 57, 58, 0, 0, 0, 0, 244, 339, 0, 0, 0, 0], [0, 0, 0, 240, 241, 242, 336, 57, 58, 0, 59, 0, 0, 244, 245, 0, 0, 62, 0], [0, 0, 0, 240, 241, 336, 336, 57, 58, 0, 59, 0, 0, 0, 245, 0, 0, 62, 0], [0, 340, 151, 0, 0, 137, 338, 0, 58, 0, 59, 0, 0, 0, 139, 0, 340, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 136, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 136, 0, 0], [0, 0, 0, 0, 0, 141, 141, 57, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 341, 0, 342, 343, 0, 58, 0, 59, 0, 0, 344, 0, 0, 0, 0, 0], [0, 136, 0, 247, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 136, 0, 0], [0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 345, 345, 146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 255, 256, 257, 258, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 256, 256, 258, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 347, 347, 258, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 348, 347, 347, 258, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 349, 350, 351, 352, 353, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 335, 241, 336, 336, 57, 58, 0, 59, 0, 0, 0, 245, 0, 0, 62, 0], [0, 0, 0, 0, 339, 141, 141, 57, 58, 0, 0, 0, 0, 263, 339, 0, 0, 0, 0], [0, 0, 0, 260, 241, 261, 336, 57, 58, 0, 59, 0, 0, 263, 245, 0, 0, 62, 0], [0, 0, 0, 260, 241, 336, 336, 57, 58, 0, 59, 0, 0, 0, 245, 0, 0, 62, 0], [0, 0, 0, 137, 0, 248, 248, 57, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 246, 354, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 126, 126, 8, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 355, 90, 0, 0, 121, 125, 0, 9, 0, 10, 0, 0, 0, 42, 0, 355, 0, 0], [0, 0, 0, 0, 0, 356, 356, 269, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 357, 358, 359, 360, 361, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 270, 0, 0, 0, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 363, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 364, 116, 365, 366, 8, 161, 0, 162, 0, 0, 367, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 368, 368, 0, 161, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 40, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 170, 278, 278, 22, 23, 0, 24, 0, 0, 0, 174, 0, 0, 27, 0], [0, 0, 0, 0, 281, 80, 80, 22, 23, 0, 0, 0, 0, 0, 281, 0, 0, 0, 0], [0, 0, 0, 369, 370, 371, 372, 22, 23, 0, 24, 0, 0, 373, 374, 0, 0, 27, 0], [0, 279, 0, 375, 0, 177, 177, 22, 23, 0, 24, 0, 0, 0, 78, 0, 279, 0, 0], [0, 279, 0, 0, 0, 175, 376, 0, 23, 0, 24, 0, 0, 0, 78, 0, 279, 0, 0], [0, 0, 0, 377, 370, 378, 379, 22, 23, 0, 24, 0, 0, 380, 374, 0, 0, 27, 0], [0, 0, 0, 90, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 286, 0, 0, 0, 0, 0], [0, 0, 0, 283, 0, 284, 175, 0, 23, 0, 24, 0, 0, 286, 0, 0, 0, 0, 0], [0, 0, 0, 283, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0], [0, 0, 0, 0, 0, 381, 381, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 382, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 292, 293, 294, 295, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 293, 293, 295, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 0, 383, 383, 295, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 384, 383, 383, 295, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 385, 76, 175, 386, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 76, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 196, 298, 298, 32, 33, 0, 34, 0, 0, 0, 200, 0, 0, 37, 0], [0, 0, 0, 0, 301, 101, 101, 32, 33, 0, 0, 0, 0, 0, 301, 0, 0, 0, 0], [0, 0, 0, 387, 388, 389, 390, 32, 33, 0, 34, 0, 0, 391, 392, 0, 0, 37, 0], [0, 299, 0, 393, 0, 203, 203, 32, 33, 0, 34, 0, 0, 0, 99, 0, 299, 0, 0], [0, 299, 0, 0, 0, 201, 394, 0, 33, 0, 34, 0, 0, 0, 99, 0, 299, 0, 0], [0, 0, 0, 395, 388, 396, 397, 32, 33, 0, 34, 0, 0, 398, 392, 0, 0, 37, 0], [0, 0, 0, 111, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 306, 0, 0, 0, 0, 0], [0, 0, 0, 303, 0, 304, 201, 0, 33, 0, 34, 0, 0, 306, 0, 0, 0, 0, 0], [0, 0, 0, 303, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 0, 0], [0, 0, 0, 0, 0, 399, 399, 213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 312, 313, 314, 315, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 313, 313, 315, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 0, 401, 401, 315, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 402, 401, 401, 315, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 403, 97, 201, 404, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 97, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 405, 318, 406, 406, 8, 9, 0, 10, 0, 0, 0, 322, 0, 0, 16, 0], [0, 407, 0, 0, 0, 40, 408, 0, 9, 0, 10, 0, 0, 0, 42, 0, 407, 0, 0], [0, 0, 0, 0, 409, 44, 44, 8, 9, 0, 0, 0, 0, 321, 409, 0, 0, 0, 0], [0, 0, 0, 317, 318, 319, 406, 8, 9, 0, 10, 0, 0, 321, 322, 0, 0, 16, 0], [0, 0, 0, 317, 318, 406, 406, 8, 9, 0, 10, 0, 0, 0, 322, 0, 0, 16, 0], [0, 410, 64, 0, 0, 40, 408, 0, 9, 0, 10, 0, 0, 0, 42, 0, 410, 0, 0], [0, 223, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 223, 0, 0], [0, 223, 0, 323, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 223, 0, 0], [0, 0, 0, 405, 318, 406, 406, 8, 9, 0, 10, 0, 0, 0, 322, 0, 0, 16, 0], [0, 0, 0, 0, 409, 44, 44, 8, 9, 0, 0, 0, 0, 328, 409, 0, 0, 0, 0], [0, 0, 0, 325, 318, 326, 406, 8, 9, 0, 10, 0, 0, 328, 322, 0, 0, 16, 0], [0, 0, 0, 325, 318, 406, 406, 8, 9, 0, 10, 0, 0, 0, 322, 0, 0, 16, 0], [0, 0, 0, 0, 0, 0, 0, 133, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 0, 0], [0, 0, 0, 0, 0, 411, 411, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 412, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 40, 121, 334, 0, 9, 0, 10, 0, 0, 0, 42, 0, 0, 0, 0], [0, 0, 0, 0, 413, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 241, 336, 336, 57, 58, 0, 59, 0, 0, 0, 245, 0, 0, 62, 0], [0, 0, 0, 0, 339, 141, 141, 57, 58, 0, 0, 0, 0, 0, 339, 0, 0, 0, 0], [0, 0, 0, 414, 415, 416, 417, 57, 58, 0, 59, 0, 0, 418, 419, 0, 0, 62, 0], [0, 337, 0, 420, 0, 248, 248, 57, 58, 0, 59, 0, 0, 0, 139, 0, 337, 0, 0], [0, 337, 0, 0, 0, 246, 421, 0, 58, 0, 59, 0, 0, 0, 139, 0, 337, 0, 0], [0, 0, 0, 422, 415, 423, 424, 57, 58, 0, 59, 0, 0, 425, 419, 0, 0, 62, 0], [0, 0, 0, 151, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 0, 344, 0, 0, 0, 0, 0], [0, 0, 0, 341, 0, 342, 246, 0, 58, 0, 59, 0, 0, 344, 0, 0, 0, 0, 0], [0, 0, 0, 341, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 0, 0], [0, 0, 0, 0, 0, 426, 426, 258, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 427, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 350, 351, 352, 353, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 351, 351, 353, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 0, 428, 428, 353, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 429, 428, 428, 353, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 430, 137, 246, 431, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 137, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 432, 116, 433, 434, 8, 161, 0, 162, 0, 0, 435, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 180, 180, 269, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 358, 359, 360, 361, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 359, 359, 361, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 436, 436, 361, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 437, 436, 436, 361, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 438, 439, 440, 441, 442, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 443, 274, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 443, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 444, 116, 445, 445, 8, 161, 0, 162, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 225, 44, 44, 8, 161, 0, 0, 0, 0, 367, 225, 0, 0, 0, 0], [0, 0, 0, 364, 116, 365, 445, 8, 161, 0, 162, 0, 0, 367, 120, 0, 0, 16, 0], [0, 0, 0, 364, 116, 445, 445, 8, 161, 0, 162, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 0, 0, 0, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 446, 370, 447, 447, 22, 23, 0, 24, 0, 0, 0, 374, 0, 0, 27, 0], [0, 448, 0, 0, 0, 76, 449, 0, 23, 0, 24, 0, 0, 0, 78, 0, 448, 0, 0], [0, 0, 0, 0, 450, 80, 80, 22, 23, 0, 0, 0, 0, 373, 450, 0, 0, 0, 0], [0, 0, 0, 369, 370, 371, 447, 22, 23, 0, 24, 0, 0, 373, 374, 0, 0, 27, 0], [0, 0, 0, 369, 370, 447, 447, 22, 23, 0, 24, 0, 0, 0, 374, 0, 0, 27, 0], [0, 451, 90, 0, 0, 76, 449, 0, 23, 0, 24, 0, 0, 0, 78, 0, 451, 0, 0], [0, 279, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 279, 0, 0], [0, 279, 0, 375, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 279, 0, 0], [0, 0, 0, 446, 370, 447, 447, 22, 23, 0, 24, 0, 0, 0, 374, 0, 0, 27, 0], [0, 0, 0, 0, 450, 80, 80, 22, 23, 0, 0, 0, 0, 380, 450, 0, 0, 0, 0], [0, 0, 0, 377, 370, 378, 447, 22, 23, 0, 24, 0, 0, 380, 374, 0, 0, 27, 0], [0, 0, 0, 377, 370, 447, 447, 22, 23, 0, 24, 0, 0, 0, 374, 0, 0, 27, 0], [0, 0, 0, 0, 0, 0, 0, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 0, 0], [0, 0, 0, 0, 0, 452, 452, 295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 453, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 76, 175, 386, 0, 23, 0, 24, 0, 0, 0, 78, 0, 0, 0, 0], [0, 0, 0, 0, 454, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 455, 388, 456, 456, 32, 33, 0, 34, 0, 0, 0, 392, 0, 0, 37, 0], [0, 457, 0, 0, 0, 97, 458, 0, 33, 0, 34, 0, 0, 0, 99, 0, 457, 0, 0], [0, 0, 0, 0, 459, 101, 101, 32, 33, 0, 0, 0, 0, 391, 459, 0, 0, 0, 0], [0, 0, 0, 387, 388, 389, 456, 32, 33, 0, 34, 0, 0, 391, 392, 0, 0, 37, 0], [0, 0, 0, 387, 388, 456, 456, 32, 33, 0, 34, 0, 0, 0, 392, 0, 0, 37, 0], [0, 460, 111, 0, 0, 97, 458, 0, 33, 0, 34, 0, 0, 0, 99, 0, 460, 0, 0], [0, 299, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 299, 0, 0], [0, 299, 0, 393, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 299, 0, 0], [0, 0, 0, 455, 388, 456, 456, 32, 33, 0, 34, 0, 0, 0, 392, 0, 0, 37, 0], [0, 0, 0, 0, 459, 101, 101, 32, 33, 0, 0, 0, 0, 398, 459, 0, 0, 0, 0], [0, 0, 0, 395, 388, 396, 456, 32, 33, 0, 34, 0, 0, 398, 392, 0, 0, 37, 0], [0, 0, 0, 395, 388, 456, 456, 32, 33, 0, 34, 0, 0, 0, 392, 0, 0, 37, 0], [0, 0, 0, 0, 0, 0, 0, 213, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 0, 0], [0, 0, 0, 0, 0, 461, 461, 315, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 462, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 97, 201, 404, 0, 33, 0, 34, 0, 0, 0, 99, 0, 0, 0, 0], [0, 0, 0, 0, 463, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 318, 406, 406, 8, 9, 0, 10, 0, 0, 0, 322, 0, 0, 16, 0], [0, 0, 0, 0, 409, 44, 44, 8, 9, 0, 0, 0, 0, 0, 409, 0, 0, 0, 0], [0, 0, 0, 464, 465, 466, 467, 8, 9, 0, 10, 0, 0, 468, 469, 0, 0, 16, 0], [0, 407, 0, 470, 0, 123, 123, 8, 9, 0, 10, 0, 0, 0, 42, 0, 407, 0, 0], [0, 407, 0, 0, 0, 121, 471, 0, 9, 0, 10, 0, 0, 0, 42, 0, 407, 0, 0], [0, 0, 0, 472, 465, 473, 474, 8, 9, 0, 10, 0, 0, 475, 469, 0, 0, 16, 0], [0, 0, 0, 0, 0, 0, 0, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 0, 0], [0, 0, 0, 0, 0, 0, 476, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 477, 415, 478, 478, 57, 58, 0, 59, 0, 0, 0, 419, 0, 0, 62, 0], [0, 479, 0, 0, 0, 137, 480, 0, 58, 0, 59, 0, 0, 0, 139, 0, 479, 0, 0], [0, 0, 0, 0, 481, 141, 141, 57, 58, 0, 0, 0, 0, 418, 481, 0, 0, 0, 0], [0, 0, 0, 414, 415, 416, 478, 57, 58, 0, 59, 0, 0, 418, 419, 0, 0, 62, 0], [0, 0, 0, 414, 415, 478, 478, 57, 58, 0, 59, 0, 0, 0, 419, 0, 0, 62, 0], [0, 482, 151, 0, 0, 137, 480, 0, 58, 0, 59, 0, 0, 0, 139, 0, 482, 0, 0], [0, 337, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 337, 0, 0], [0, 337, 0, 420, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 337, 0, 0], [0, 0, 0, 477, 415, 478, 478, 57, 58, 0, 59, 0, 0, 0, 419, 0, 0, 62, 0], [0, 0, 0, 0, 481, 141, 141, 57, 58, 0, 0, 0, 0, 425, 481, 0, 0, 0, 0], [0, 0, 0, 422, 415, 423, 478, 57, 58, 0, 59, 0, 0, 425, 419, 0, 0, 62, 0], [0, 0, 0, 422, 415, 478, 478, 57, 58, 0, 59, 0, 0, 0, 419, 0, 0, 62, 0], [0, 0, 0, 0, 0, 0, 0, 258, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0], [0, 0, 0, 0, 0, 483, 483, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 137, 246, 431, 0, 58, 0, 59, 0, 0, 0, 139, 0, 0, 0, 0], [0, 0, 0, 0, 485, 0, 0, 0, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 444, 116, 445, 445, 8, 161, 0, 162, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 225, 44, 44, 8, 161, 0, 0, 0, 0, 435, 225, 0, 0, 0, 0], [0, 0, 0, 432, 116, 433, 445, 8, 161, 0, 162, 0, 0, 435, 120, 0, 0, 16, 0], [0, 0, 0, 432, 116, 445, 445, 8, 161, 0, 162, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 0, 486, 486, 361, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 487, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 439, 440, 441, 442, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 440, 440, 442, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 488, 488, 442, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 489, 488, 488, 442, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 490, 491, 492, 493, 494, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 495, 0, 496, 497, 0, 161, 0, 162, 0, 0, 498, 0, 0, 0, 0, 0], [0, 0, 0, 0, 116, 445, 445, 8, 161, 0, 162, 0, 0, 0, 120, 0, 0, 16, 0], [0, 0, 0, 0, 225, 44, 44, 8, 161, 0, 0, 0, 0, 0, 225, 0, 0, 0, 0], [0, 0, 0, 0, 370, 447, 447, 22, 23, 0, 24, 0, 0, 0, 374, 0, 0, 27, 0], [0, 0, 0, 0, 450, 80, 80, 22, 23, 0, 0, 0, 0, 0, 450, 0, 0, 0, 0], [0, 0, 0, 499, 500, 501, 502, 22, 23, 0, 24, 0, 0, 503, 504, 0, 0, 27, 0], [0, 448, 0, 505, 0, 177, 177, 22, 23, 0, 24, 0, 0, 0, 78, 0, 448, 0, 0], [0, 448, 0, 0, 0, 175, 506, 0, 23, 0, 24, 0, 0, 0, 78, 0, 448, 0, 0], [0, 0, 0, 507, 500, 508, 509, 22, 23, 0, 24, 0, 0, 510, 504, 0, 0, 27, 0], [0, 0, 0, 0, 0, 0, 0, 295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 292, 0, 0], [0, 0, 0, 0, 0, 0, 511, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 388, 456, 456, 32, 33, 0, 34, 0, 0, 0, 392, 0, 0, 37, 0], [0, 0, 0, 0, 459, 101, 101, 32, 33, 0, 0, 0, 0, 0, 459, 0, 0, 0, 0], [0, 0, 0, 512, 513, 514, 515, 32, 33, 0, 34, 0, 0, 516, 517, 0, 0, 37, 0], [0, 457, 0, 518, 0, 203, 203, 32, 33, 0, 34, 0, 0, 0, 99, 0, 457, 0, 0], [0, 457, 0, 0, 0, 201, 519, 0, 33, 0, 34, 0, 0, 0, 99, 0, 457, 0, 0], [0, 0, 0, 520, 513, 521, 522, 32, 33, 0, 34, 0, 0, 523, 517, 0, 0, 37, 0], [0, 0, 0, 0, 0, 0, 0, 315, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 312, 0, 0], [0, 0, 0, 0, 0, 0, 524, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 525, 465, 526, 526, 8, 9, 0, 10, 0, 0, 0, 469, 0, 0, 16, 0], [0, 527, 0, 0, 0, 40, 528, 0, 9, 0, 10, 0, 0, 0, 42, 0, 527, 0, 0], [0, 0, 0, 0, 529, 44, 44, 8, 9, 0, 0, 0, 0, 468, 529, 0, 0, 0, 0], [0, 0, 0, 464, 465, 466, 526, 8, 9, 0, 10, 0, 0, 468, 469, 0, 0, 16, 0], [0, 0, 0, 464, 465, 526, 526, 8, 9, 0, 10, 0, 0, 0, 469, 0, 0, 16, 0], [0, 530, 64, 0, 0, 40, 528, 0, 9, 0, 10, 0, 0, 0, 42, 0, 530, 0, 0], [0, 407, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 407, 0, 0], [0, 407, 0, 470, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 407, 0, 0], [0, 0, 0, 525, 465, 526, 526, 8, 9, 0, 10, 0, 0, 0, 469, 0, 0, 16, 0], [0, 0, 0, 0, 529, 44, 44, 8, 9, 0, 0, 0, 0, 475, 529, 0, 0, 0, 0], [0, 0, 0, 472, 465, 473, 526, 8, 9, 0, 10, 0, 0, 475, 469, 0, 0, 16, 0], [0, 0, 0, 472, 465, 526, 526, 8, 9, 0, 10, 0, 0, 0, 469, 0, 0, 16, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0], [0, 0, 0, 0, 415, 478, 478, 57, 58, 0, 59, 0, 0, 0, 419, 0, 0, 62, 0], [0, 0, 0, 0, 481, 141, 141, 57, 58, 0, 0, 0, 0, 0, 481, 0, 0, 0, 0], [0, 0, 0, 531, 532, 533, 534, 57, 58, 0, 59, 0, 0, 535, 536, 0, 0, 62, 0], [0, 479, 0, 537, 0, 248, 248, 57, 58, 0, 59, 0, 0, 0, 139, 0, 479, 0, 0], [0, 479, 0, 0, 0, 246, 538, 0, 58, 0, 59, 0, 0, 0, 139, 0, 479, 0, 0], [0, 0, 0, 539, 532, 540, 541, 57, 58, 0, 59, 0, 0, 542, 536, 0, 0, 62, 0], [0, 0, 0, 0, 0, 0, 0, 353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, 0], [0, 0, 0, 0, 0, 0, 543, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 361, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 358, 0, 0], [0, 0, 0, 0, 0, 544, 544, 442, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 545, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 491, 492, 493, 494, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 492, 492, 494, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 546, 546, 494, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 547, 546, 546, 494, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 548, 549, 368, 550, 0, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 274, 0, 368, 368, 0, 161, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 161, 0, 0, 0, 0, 498, 0, 0, 0, 0, 0], [0, 0, 0, 495, 0, 496, 368, 0, 161, 0, 162, 0, 0, 498, 0, 0, 0, 0, 0], [0, 0, 0, 495, 0, 368, 368, 0, 161, 0, 162, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 551, 500, 552, 552, 22, 23, 0, 24, 0, 0, 0, 504, 0, 0, 27, 0], [0, 553, 0, 0, 0, 76, 554, 0, 23, 0, 24, 0, 0, 0, 78, 0, 553, 0, 0], [0, 0, 0, 0, 555, 80, 80, 22, 23, 0, 0, 0, 0, 503, 555, 0, 0, 0, 0], [0, 0, 0, 499, 500, 501, 552, 22, 23, 0, 24, 0, 0, 503, 504, 0, 0, 27, 0], [0, 0, 0, 499, 500, 552, 552, 22, 23, 0, 24, 0, 0, 0, 504, 0, 0, 27, 0], [0, 556, 90, 0, 0, 76, 554, 0, 23, 0, 24, 0, 0, 0, 78, 0, 556, 0, 0], [0, 448, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 448, 0, 0], [0, 448, 0, 505, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 448, 0, 0], [0, 0, 0, 551, 500, 552, 552, 22, 23, 0, 24, 0, 0, 0, 504, 0, 0, 27, 0], [0, 0, 0, 0, 555, 80, 80, 22, 23, 0, 0, 0, 0, 510, 555, 0, 0, 0, 0], [0, 0, 0, 507, 500, 508, 552, 22, 23, 0, 24, 0, 0, 510, 504, 0, 0, 27, 0], [0, 0, 0, 507, 500, 552, 552, 22, 23, 0, 24, 0, 0, 0, 504, 0, 0, 27, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0], [0, 0, 0, 557, 513, 558, 558, 32, 33, 0, 34, 0, 0, 0, 517, 0, 0, 37, 0], [0, 559, 0, 0, 0, 97, 560, 0, 33, 0, 34, 0, 0, 0, 99, 0, 559, 0, 0], [0, 0, 0, 0, 561, 101, 101, 32, 33, 0, 0, 0, 0, 516, 561, 0, 0, 0, 0], [0, 0, 0, 512, 513, 514, 558, 32, 33, 0, 34, 0, 0, 516, 517, 0, 0, 37, 0], [0, 0, 0, 512, 513, 558, 558, 32, 33, 0, 34, 0, 0, 0, 517, 0, 0, 37, 0], [0, 562, 111, 0, 0, 97, 560, 0, 33, 0, 34, 0, 0, 0, 99, 0, 562, 0, 0], [0, 457, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 457, 0, 0], [0, 457, 0, 518, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 457, 0, 0], [0, 0, 0, 557, 513, 558, 558, 32, 33, 0, 34, 0, 0, 0, 517, 0, 0, 37, 0], [0, 0, 0, 0, 561, 101, 101, 32, 33, 0, 0, 0, 0, 523, 561, 0, 0, 0, 0], [0, 0, 0, 520, 513, 521, 558, 32, 33, 0, 34, 0, 0, 523, 517, 0, 0, 37, 0], [0, 0, 0, 520, 513, 558, 558, 32, 33, 0, 34, 0, 0, 0, 517, 0, 0, 37, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0], [0, 0, 0, 0, 465, 526, 526, 8, 9, 0, 10, 0, 0, 0, 469, 0, 0, 16, 0], [0, 0, 0, 0, 529, 44, 44, 8, 9, 0, 0, 0, 0, 0, 529, 0, 0, 0, 0], [0, 0, 0, 563, 66, 564, 565, 8, 9, 0, 10, 0, 0, 566, 68, 0, 0, 16, 0], [0, 527, 0, 567, 0, 123, 123, 8, 9, 0, 10, 0, 0, 0, 42, 0, 527, 0, 0], [0, 527, 0, 0, 0, 121, 568, 0, 9, 0, 10, 0, 0, 0, 42, 0, 527, 0, 0], [0, 0, 0, 569, 66, 570, 571, 8, 9, 0, 10, 0, 0, 572, 68, 0, 0, 16, 0], [0, 0, 0, 573, 532, 574, 574, 57, 58, 0, 59, 0, 0, 0, 536, 0, 0, 62, 0], [0, 575, 0, 0, 0, 137, 576, 0, 58, 0, 59, 0, 0, 0, 139, 0, 575, 0, 0], [0, 0, 0, 0, 577, 141, 141, 57, 58, 0, 0, 0, 0, 535, 577, 0, 0, 0, 0], [0, 0, 0, 531, 532, 533, 574, 57, 58, 0, 59, 0, 0, 535, 536, 0, 0, 62, 0], [0, 0, 0, 531, 532, 574, 574, 57, 58, 0, 59, 0, 0, 0, 536, 0, 0, 62, 0], [0, 578, 151, 0, 0, 137, 576, 0, 58, 0, 59, 0, 0, 0, 139, 0, 578, 0, 0], [0, 479, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 479, 0, 0], [0, 479, 0, 537, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 479, 0, 0], [0, 0, 0, 573, 532, 574, 574, 57, 58, 0, 59, 0, 0, 0, 536, 0, 0, 62, 0], [0, 0, 0, 0, 577, 141, 141, 57, 58, 0, 0, 0, 0, 542, 577, 0, 0, 0, 0], [0, 0, 0, 539, 532, 540, 574, 57, 58, 0, 59, 0, 0, 542, 536, 0, 0, 62, 0], [0, 0, 0, 539, 532, 574, 574, 57, 58, 0, 59, 0, 0, 0, 536, 0, 0, 62, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 0, 0], [0, 0, 0, 0, 0, 0, 0, 442, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 439, 0, 0], [0, 0, 0, 0, 0, 579, 579, 494, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 580, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 549, 368, 550, 0, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 0, 368, 368, 0, 161, 0, 162, 0, 0, 0, 362, 0, 0, 0, 0], [0, 0, 0, 0, 581, 0, 0, 0, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 500, 552, 552, 22, 23, 0, 24, 0, 0, 0, 504, 0, 0, 27, 0], [0, 0, 0, 0, 555, 80, 80, 22, 23, 0, 0, 0, 0, 0, 555, 0, 0, 0, 0], [0, 0, 0, 582, 91, 583, 584, 22, 23, 0, 24, 0, 0, 585, 93, 0, 0, 27, 0], [0, 553, 0, 586, 0, 177, 177, 22, 23, 0, 24, 0, 0, 0, 78, 0, 553, 0, 0], [0, 553, 0, 0, 0, 175, 587, 0, 23, 0, 24, 0, 0, 0, 78, 0, 553, 0, 0], [0, 0, 0, 588, 91, 589, 590, 22, 23, 0, 24, 0, 0, 591, 93, 0, 0, 27, 0], [0, 0, 0, 0, 513, 558, 558, 32, 33, 0, 34, 0, 0, 0, 517, 0, 0, 37, 0], [0, 0, 0, 0, 561, 101, 101, 32, 33, 0, 0, 0, 0, 0, 561, 0, 0, 0, 0], [0, 0, 0, 592, 112, 593, 594, 32, 33, 0, 34, 0, 0, 595, 114, 0, 0, 37, 0], [0, 559, 0, 596, 0, 203, 203, 32, 33, 0, 34, 0, 0, 0, 99, 0, 559, 0, 0], [0, 559, 0, 0, 0, 201, 597, 0, 33, 0, 34, 0, 0, 0, 99, 0, 559, 0, 0], [0, 0, 0, 598, 112, 599, 600, 32, 33, 0, 34, 0, 0, 601, 114, 0, 0, 37, 0], [0, 0, 0, 602, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 16, 0], [0, 0, 0, 0, 165, 44, 44, 8, 9, 0, 0, 0, 0, 566, 165, 0, 0, 0, 0], [0, 0, 0, 563, 66, 564, 67, 8, 9, 0, 10, 0, 0, 566, 68, 0, 0, 16, 0], [0, 0, 0, 563, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 16, 0], [0, 527, 0, 0, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 527, 0, 0], [0, 527, 0, 567, 0, 121, 121, 0, 9, 0, 10, 0, 0, 0, 42, 0, 527, 0, 0], [0, 0, 0, 602, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 16, 0], [0, 0, 0, 0, 165, 44, 44, 8, 9, 0, 0, 0, 0, 572, 165, 0, 0, 0, 0], [0, 0, 0, 569, 66, 570, 67, 8, 9, 0, 10, 0, 0, 572, 68, 0, 0, 16, 0], [0, 0, 0, 569, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 16, 0], [0, 0, 0, 0, 532, 574, 574, 57, 58, 0, 59, 0, 0, 0, 536, 0, 0, 62, 0], [0, 0, 0, 0, 577, 141, 141, 57, 58, 0, 0, 0, 0, 0, 577, 0, 0, 0, 0], [0, 0, 0, 603, 152, 604, 605, 57, 58, 0, 59, 0, 0, 606, 154, 0, 0, 62, 0], [0, 575, 0, 607, 0, 248, 248, 57, 58, 0, 59, 0, 0, 0, 139, 0, 575, 0, 0], [0, 575, 0, 0, 0, 246, 608, 0, 58, 0, 59, 0, 0, 0, 139, 0, 575, 0, 0], [0, 0, 0, 609, 152, 610, 611, 57, 58, 0, 59, 0, 0, 612, 154, 0, 0, 62, 0], [0, 0, 0, 0, 0, 0, 0, 494, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 491, 0, 0], [0, 0, 0, 0, 0, 0, 613, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 614, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 27, 0], [0, 0, 0, 0, 194, 80, 80, 22, 23, 0, 0, 0, 0, 585, 194, 0, 0, 0, 0], [0, 0, 0, 582, 91, 583, 92, 22, 23, 0, 24, 0, 0, 585, 93, 0, 0, 27, 0], [0, 0, 0, 582, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 27, 0], [0, 553, 0, 0, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 553, 0, 0], [0, 553, 0, 586, 0, 175, 175, 0, 23, 0, 24, 0, 0, 0, 78, 0, 553, 0, 0], [0, 0, 0, 614, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 27, 0], [0, 0, 0, 0, 194, 80, 80, 22, 23, 0, 0, 0, 0, 591, 194, 0, 0, 0, 0], [0, 0, 0, 588, 91, 589, 92, 22, 23, 0, 24, 0, 0, 591, 93, 0, 0, 27, 0], [0, 0, 0, 588, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 27, 0], [0, 0, 0, 615, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 37, 0], [0, 0, 0, 0, 220, 101, 101, 32, 33, 0, 0, 0, 0, 595, 220, 0, 0, 0, 0], [0, 0, 0, 592, 112, 593, 113, 32, 33, 0, 34, 0, 0, 595, 114, 0, 0, 37, 0], [0, 0, 0, 592, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 37, 0], [0, 559, 0, 0, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 559, 0, 0], [0, 559, 0, 596, 0, 201, 201, 0, 33, 0, 34, 0, 0, 0, 99, 0, 559, 0, 0], [0, 0, 0, 615, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 37, 0], [0, 0, 0, 0, 220, 101, 101, 32, 33, 0, 0, 0, 0, 601, 220, 0, 0, 0, 0], [0, 0, 0, 598, 112, 599, 113, 32, 33, 0, 34, 0, 0, 601, 114, 0, 0, 37, 0], [0, 0, 0, 598, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 37, 0], [0, 0, 0, 0, 66, 67, 67, 8, 9, 0, 10, 0, 0, 0, 68, 0, 0, 16, 0], [0, 0, 0, 616, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 62, 0], [0, 0, 0, 0, 265, 141, 141, 57, 58, 0, 0, 0, 0, 606, 265, 0, 0, 0, 0], [0, 0, 0, 603, 152, 604, 153, 57, 58, 0, 59, 0, 0, 606, 154, 0, 0, 62, 0], [0, 0, 0, 603, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 62, 0], [0, 575, 0, 0, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 575, 0, 0], [0, 575, 0, 607, 0, 246, 246, 0, 58, 0, 59, 0, 0, 0, 139, 0, 575, 0, 0], [0, 0, 0, 616, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 62, 0], [0, 0, 0, 0, 265, 141, 141, 57, 58, 0, 0, 0, 0, 612, 265, 0, 0, 0, 0], [0, 0, 0, 609, 152, 610, 153, 57, 58, 0, 59, 0, 0, 612, 154, 0, 0, 62, 0], [0, 0, 0, 609, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 62, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 549, 0, 0], [0, 0, 0, 0, 91, 92, 92, 22, 23, 0, 24, 0, 0, 0, 93, 0, 0, 27, 0], [0, 0, 0, 0, 112, 113, 113, 32, 33, 0, 34, 0, 0, 0, 114, 0, 0, 37, 0], [0, 0, 0, 0, 152, 153, 153, 57, 58, 0, 59, 0, 0, 0, 154, 0, 0, 62, 0]];
	var accepting = [false, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, false, true, true, true, false, true, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, false, true, true, true, false, true, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, false, true, true, true, false, true, false, true, true, false, false, false, true, true, false, false, true, true, true, true, true, true, false, true, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, false, true, false, true, true, false, false, false, true, true, false, false, true, true, true, false, true, true, true, true, true, true, false, true, true, true, false, true, false, true, true, false, false, false, true, true, false, false, true, true, true, false, true, true, true, true, true, false, true, true, true, true, true, false, true, true, false, false, false, false, true, true, false, false, true, true, true, false, true, true, true, false, true, false, true, true, false, false, false, true, true, false, false, true, true, true, false, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, false, true, true, false, false, false, false, true, true, false, false, true, true, true, false, true, true, true, true, true, false, true, true, false, false, false, false, true, true, false, false, true, true, true, true, false, true, true, true, true, true, true, false, true, true, false, false, false, false, true, false, true, false, true, true, true, true, true, false, true, true, false, false, false, false, true, true, false, false, true, true, true, false, true, true, false, false, true, false, true, true, false, true, true, false, true, true, false, true, true, true, true, true, true, false, true, true, false, false, false, false, true, false, true, true, false, true, true, true, true, true, true, false, true, true, false, false, false, false, true, false, true, false, true, true, true, true, false, false, false, true, true, false, true, true, true, true, true, true, false, true, true, false, false, false, false, true, false, true, false, true, true, false, false, true, true, false, false, true, true, true, false, true, false, true, true, true, true, false, false, false, true, false, true, true, true, true, false, false, false, true, true, false, true, true, true, true, true, true, false, true, true, false, true, false, true, true, true, true, false, false, false, false, false, false, false, true, true, false, false, true, true, false, true, true, true, true, false, true, true, true, true, true, true, false, true, true, false, true, true, false, true, true, true, true, true, true, false, true, true, false, true, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false, true, true, false, false, false, false, false, true, true, false, true, false, true, true, true, true, true, false, true, true, true, true, true, false, true, true, true, true, true, false, true, true, true, false, true, true, true, true, false, false, false, true, false, true, true, true, true, true, false, true, true, true, false, true, true, true, true, true, false, true, true, true, true, false, true, true, true, true, true, false, true, true, false, true, true, true];
	var tags = [[], ["broken_cluster"], ["consonant_syllable"], ["vowel_syllable"], ["broken_cluster"], ["broken_cluster"], [], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["standalone_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["consonant_syllable"], ["broken_cluster"], ["symbol_cluster"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], [], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["broken_cluster"], ["broken_cluster"], ["consonant_syllable", "broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["symbol_cluster"], [], ["symbol_cluster"], ["symbol_cluster"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], [], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], [], [], [], ["broken_cluster"], ["broken_cluster"], [], [], ["broken_cluster"], ["broken_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["symbol_cluster"], ["symbol_cluster"], ["symbol_cluster"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], [], [], [], ["consonant_syllable"], ["consonant_syllable"], [], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], [], [], ["vowel_syllable"], ["vowel_syllable"], [], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], [], [], [], [], ["broken_cluster"], ["broken_cluster"], [], [], ["broken_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], [], [], ["standalone_cluster"], ["standalone_cluster"], [], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["broken_cluster"], ["symbol_cluster"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], [], [], [], [], ["consonant_syllable"], ["consonant_syllable"], [], [], ["consonant_syllable"], ["consonant_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], [], [], [], ["vowel_syllable"], ["vowel_syllable"], [], [], ["vowel_syllable"], ["vowel_syllable"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], [], [], [], [], ["broken_cluster"], [], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], [], [], [], ["standalone_cluster"], ["standalone_cluster"], [], [], ["standalone_cluster"], ["standalone_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], [], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], [], [], [], [], ["consonant_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], [], [], [], ["vowel_syllable"], [], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], [], [], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], [], [], [], ["standalone_cluster"], [], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], [], [], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], [], [], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], [], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], [], [], [], [], [], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], [], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], [], [], [], [], ["consonant_syllable", "broken_cluster"], ["consonant_syllable", "broken_cluster"], [], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], [], [], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], ["consonant_syllable"], [], ["consonant_syllable"], ["consonant_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], ["vowel_syllable"], [], ["vowel_syllable"], ["vowel_syllable"], ["broken_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], ["standalone_cluster"], [], ["standalone_cluster"], ["standalone_cluster"], [], ["consonant_syllable"], ["vowel_syllable"], ["standalone_cluster"]];
	var indicMachine = {
		stateTable: stateTable,
		accepting: accepting,
		tags: tags
	};

	var categories = ["O", "IND", "S", "GB", "B", "FM", "CGJ", "VMAbv", "VMPst", "VAbv", "VPst", "CMBlw", "VPre", "VBlw", "H", "VMBlw", "CMAbv", "MBlw", "CS", "R", "SUB", "MPst", "MPre", "FAbv", "FPst", "FBlw", "SMAbv", "SMBlw", "VMPre", "ZWNJ", "ZWJ", "WJ", "VS", "N", "HN", "MAbv"];
	var decompositions$1 = { "2507": [2503, 2494], "2508": [2503, 2519], "2888": [2887, 2902], "2891": [2887, 2878], "2892": [2887, 2903], "3018": [3014, 3006], "3019": [3015, 3006], "3020": [3014, 3031], "3144": [3142, 3158], "3264": [3263, 3285], "3271": [3270, 3285], "3272": [3270, 3286], "3274": [3270, 3266], "3275": [3270, 3266, 3285], "3402": [3398, 3390], "3403": [3399, 3390], "3404": [3398, 3415], "3546": [3545, 3530], "3548": [3545, 3535], "3549": [3545, 3535, 3530], "3550": [3545, 3551], "3635": [3661, 3634], "3763": [3789, 3762], "3955": [3953, 3954], "3957": [3953, 3956], "3958": [4018, 3968], "3959": [4018, 3953, 3968], "3960": [4019, 3968], "3961": [4019, 3953, 3968], "3969": [3953, 3968], "6971": [6970, 6965], "6973": [6972, 6965], "6976": [6974, 6965], "6977": [6975, 6965], "6979": [6978, 6965], "69934": [69937, 69927], "69935": [69938, 69927], "70475": [70471, 70462], "70476": [70471, 70487], "70843": [70841, 70842], "70844": [70841, 70832], "70846": [70841, 70845], "71098": [71096, 71087], "71099": [71097, 71087] };
	var stateTable$1 = [[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [2, 2, 3, 4, 4, 5, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 0, 17, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 2, 0, 24, 0, 25], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 28, 0, 0, 0, 0, 27, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 39, 0, 0, 47], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 0, 0, 12, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 0, 9, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 0, 11, 12, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 0, 9, 0, 0, 12, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 0, 7, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 0, 11, 12, 0, 14, 0, 0, 0, 0, 0, 11, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 4, 4, 5, 0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 48, 11, 12, 13, 14, 48, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 49, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 0, 11, 12, 0, 14, 0, 16, 0, 0, 0, 11, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 51, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 0, 11, 12, 0, 14, 0, 16, 0, 0, 0, 11, 0, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 28, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 0, 0, 36, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 0, 33, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 0, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 47], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 0, 35, 36, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 0, 33, 0, 0, 36, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 0, 31, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 47], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 0, 35, 36, 0, 38, 0, 0, 0, 0, 0, 35, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 52, 35, 36, 37, 38, 52, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 53, 0, 0, 47], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 0, 35, 36, 0, 38, 0, 40, 0, 0, 0, 35, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 47], [0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 0, 35, 36, 0, 38, 0, 40, 0, 0, 0, 35, 0, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 48, 11, 12, 13, 14, 0, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 5, 0, 6, 7, 8, 9, 48, 11, 12, 13, 14, 48, 16, 0, 0, 18, 11, 19, 20, 21, 22, 0, 0, 23, 0, 0, 0, 0, 0, 0, 25], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 52, 35, 36, 37, 38, 0, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 47], [0, 0, 0, 0, 0, 29, 0, 30, 31, 32, 33, 52, 35, 36, 37, 38, 52, 40, 0, 0, 41, 35, 42, 43, 44, 45, 0, 0, 46, 0, 0, 0, 0, 0, 0, 47], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 51, 0]];
	var accepting$1 = [false, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true];
	var tags$1 = [[], ["broken_cluster"], ["independent_cluster"], ["symbol_cluster"], ["standard_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], [], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["broken_cluster"], ["numeral_cluster"], ["broken_cluster"], ["independent_cluster"], ["symbol_cluster"], ["symbol_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["virama_terminated_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["standard_cluster"], ["broken_cluster"], ["broken_cluster"], ["numeral_cluster"], ["number_joiner_terminated_cluster"], ["standard_cluster"], ["standard_cluster"], ["numeral_cluster"]];
	var useData = {
		categories: categories,
		decompositions: decompositions$1,
		stateTable: stateTable$1,
		accepting: accepting$1,
		tags: tags$1
	};

	// Cateories used in the OpenType spec:
	// https://www.microsoft.com/typography/otfntdev/devanot/shaping.aspx
	var CATEGORIES = {
	  X: 1 << 0,
	  C: 1 << 1,
	  V: 1 << 2,
	  N: 1 << 3,
	  H: 1 << 4,
	  ZWNJ: 1 << 5,
	  ZWJ: 1 << 6,
	  M: 1 << 7,
	  SM: 1 << 8,
	  VD: 1 << 9,
	  A: 1 << 10,
	  Placeholder: 1 << 11,
	  Dotted_Circle: 1 << 12,
	  RS: 1 << 13, // Register Shifter, used in Khmer OT spec.
	  Coeng: 1 << 14, // Khmer-style Virama.
	  Repha: 1 << 15, // Atomically-encoded logical or visual repha.
	  Ra: 1 << 16,
	  CM: 1 << 17, // Consonant-Medial.
	  Symbol: 1 << 18 // Avagraha, etc that take marks (SM,A,VD).
	};

	// Visual positions in a syllable from left to right.
	var POSITIONS = {
	  Start: 1 << 0,

	  Ra_To_Become_Reph: 1 << 1,
	  Pre_M: 1 << 2,
	  Pre_C: 1 << 3,

	  Base_C: 1 << 4,
	  After_Main: 1 << 5,

	  Above_C: 1 << 6,

	  Before_Sub: 1 << 7,
	  Below_C: 1 << 8,
	  After_Sub: 1 << 9,

	  Before_Post: 1 << 10,
	  Post_C: 1 << 11,
	  After_Post: 1 << 12,

	  Final_C: 1 << 13,
	  SMVD: 1 << 14,

	  End: 1 << 15
	};

	var CONSONANT_FLAGS = CATEGORIES.C | CATEGORIES.Ra | CATEGORIES.CM | CATEGORIES.V | CATEGORIES.Placeholder | CATEGORIES.Dotted_Circle;
	var JOINER_FLAGS = CATEGORIES.ZWJ | CATEGORIES.ZWNJ;
	var HALANT_OR_COENG_FLAGS = CATEGORIES.H | CATEGORIES.Coeng;

	var INDIC_CONFIGS = {
	  Default: {
	    hasOldSpec: false,
	    virama: 0,
	    basePos: 'Last',
	    rephPos: POSITIONS.Before_Post,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Devanagari: {
	    hasOldSpec: true,
	    virama: 0x094D,
	    basePos: 'Last',
	    rephPos: POSITIONS.Before_Post,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Bengali: {
	    hasOldSpec: true,
	    virama: 0x09CD,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Sub,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Gurmukhi: {
	    hasOldSpec: true,
	    virama: 0x0A4D,
	    basePos: 'Last',
	    rephPos: POSITIONS.Before_Sub,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Gujarati: {
	    hasOldSpec: true,
	    virama: 0x0ACD,
	    basePos: 'Last',
	    rephPos: POSITIONS.Before_Post,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Oriya: {
	    hasOldSpec: true,
	    virama: 0x0B4D,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Main,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Tamil: {
	    hasOldSpec: true,
	    virama: 0x0BCD,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Post,
	    rephMode: 'Implicit',
	    blwfMode: 'Pre_And_Post'
	  },

	  Telugu: {
	    hasOldSpec: true,
	    virama: 0x0C4D,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Post,
	    rephMode: 'Explicit',
	    blwfMode: 'Post_Only'
	  },

	  Kannada: {
	    hasOldSpec: true,
	    virama: 0x0CCD,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Post,
	    rephMode: 'Implicit',
	    blwfMode: 'Post_Only'
	  },

	  Malayalam: {
	    hasOldSpec: true,
	    virama: 0x0D4D,
	    basePos: 'Last',
	    rephPos: POSITIONS.After_Main,
	    rephMode: 'Log_Repha',
	    blwfMode: 'Pre_And_Post'
	  },

	  // Handled by UniversalShaper
	  // Sinhala: {
	  //   hasOldSpec: false,
	  //   virama: 0x0DCA,
	  //   basePos: 'Last_Sinhala',
	  //   rephPos: POSITIONS.After_Main,
	  //   rephMode: 'Explicit',
	  //   blwfMode: 'Pre_And_Post'
	  // },

	  Khmer: {
	    hasOldSpec: false,
	    virama: 0x17D2,
	    basePos: 'First',
	    rephPos: POSITIONS.Ra_To_Become_Reph,
	    rephMode: 'Vis_Repha',
	    blwfMode: 'Pre_And_Post'
	  }
	};

	// Additional decompositions that aren't in Unicode
	var INDIC_DECOMPOSITIONS = {
	  // Khmer
	  0x17BE: [0x17C1, 0x17BE],
	  0x17BF: [0x17C1, 0x17BF],
	  0x17C0: [0x17C1, 0x17C0],
	  0x17C4: [0x17C1, 0x17C4],
	  0x17C5: [0x17C1, 0x17C5]
	};

	var _class$6;
	var _temp$2;
	var decompositions = useData.decompositions;

	var trie$1 = new UnicodeTrie(Buffer("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","base64"));
	var stateMachine = new StateMachine(indicMachine);

	/**
	 * The IndicShaper supports indic scripts e.g. Devanagari, Kannada, etc.
	 * Based on code from Harfbuzz: https://github.com/behdad/harfbuzz/blob/master/src/hb-ot-shape-complex-indic.cc
	 */
	var IndicShaper = (_temp$2 = _class$6 = function (_DefaultShaper) {
	  _inherits(IndicShaper, _DefaultShaper);

	  function IndicShaper() {
	    _classCallCheck(this, IndicShaper);

	    return _possibleConstructorReturn(this, _DefaultShaper.apply(this, arguments));
	  }

	  IndicShaper.planFeatures = function planFeatures(plan) {
	    plan.addStage(setupSyllables);

	    plan.addStage(['locl', 'ccmp']);

	    plan.addStage(initialReordering);

	    plan.addStage('nukt');
	    plan.addStage('akhn');
	    plan.addStage('rphf', false);
	    plan.addStage('rkrf');
	    plan.addStage('pref', false);
	    plan.addStage('blwf', false);
	    plan.addStage('abvf', false);
	    plan.addStage('half', false);
	    plan.addStage('pstf', false);
	    plan.addStage('vatu');
	    plan.addStage('cjct');
	    plan.addStage('cfar', false);

	    plan.addStage(finalReordering);

	    plan.addStage({
	      local: ['init'],
	      global: ['pres', 'abvs', 'blws', 'psts', 'haln', 'dist', 'abvm', 'blwm', 'calt', 'clig']
	    });

	    // Setup the indic config for the selected script
	    plan.unicodeScript = fromOpenType(plan.script);
	    plan.indicConfig = INDIC_CONFIGS[plan.unicodeScript] || INDIC_CONFIGS.Default;
	    plan.isOldSpec = plan.indicConfig.hasOldSpec && plan.script[plan.script.length - 1] !== '2';

	    // TODO: turn off kern (Khmer) and liga features.
	  };

	  IndicShaper.assignFeatures = function assignFeatures(plan, glyphs) {
	    var _loop = function _loop(i) {
	      var codepoint = glyphs[i].codePoints[0];
	      var d = INDIC_DECOMPOSITIONS[codepoint] || decompositions[codepoint];
	      if (d) {
	        var decomposed = d.map(function (c) {
	          var g = plan.font.glyphForCodePoint(c);
	          return new GlyphInfo(plan.font, g.id, [c], glyphs[i].features);
	        });

	        glyphs.splice.apply(glyphs, [i, 1].concat(decomposed));
	      }
	    };

	    // Decompose split matras
	    // TODO: do this in a more general unicode normalizer
	    for (var i = glyphs.length - 1; i >= 0; i--) {
	      _loop(i);
	    }
	  };

	  return IndicShaper;
	}(DefaultShaper), _class$6.zeroMarkWidths = 'NONE', _temp$2);
	function indicCategory(glyph) {
	  return trie$1.get(glyph.codePoints[0]) >> 8;
	}

	function indicPosition(glyph) {
	  return 1 << (trie$1.get(glyph.codePoints[0]) & 0xff);
	}

	var IndicInfo = function IndicInfo(category, position, syllableType, syllable) {
	  _classCallCheck(this, IndicInfo);

	  this.category = category;
	  this.position = position;
	  this.syllableType = syllableType;
	  this.syllable = syllable;
	};

	function setupSyllables(font, glyphs) {
	  var syllable = 0;
	  var last = 0;
	  for (var _iterator = stateMachine.match(glyphs.map(indicCategory)), _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);;) {
	    var _ref;

	    if (_isArray) {
	      if (_i >= _iterator.length) break;
	      _ref = _iterator[_i++];
	    } else {
	      _i = _iterator.next();
	      if (_i.done) break;
	      _ref = _i.value;
	    }

	    var _ref2 = _ref,
	        start = _ref2[0],
	        end = _ref2[1],
	        tags = _ref2[2];

	    if (start > last) {
	      ++syllable;
	      for (var _i2 = last; _i2 < start; _i2++) {
	        glyphs[_i2].shaperInfo = new IndicInfo(CATEGORIES.X, POSITIONS.End, 'non_indic_cluster', syllable);
	      }
	    }

	    ++syllable;

	    // Create shaper info
	    for (var _i3 = start; _i3 <= end; _i3++) {
	      glyphs[_i3].shaperInfo = new IndicInfo(1 << indicCategory(glyphs[_i3]), indicPosition(glyphs[_i3]), tags[0], syllable);
	    }

	    last = end + 1;
	  }

	  if (last < glyphs.length) {
	    ++syllable;
	    for (var i = last; i < glyphs.length; i++) {
	      glyphs[i].shaperInfo = new IndicInfo(CATEGORIES.X, POSITIONS.End, 'non_indic_cluster', syllable);
	    }
	  }
	}

	function isConsonant(glyph) {
	  return glyph.shaperInfo.category & CONSONANT_FLAGS;
	}

	function isJoiner(glyph) {
	  return glyph.shaperInfo.category & JOINER_FLAGS;
	}

	function isHalantOrCoeng(glyph) {
	  return glyph.shaperInfo.category & HALANT_OR_COENG_FLAGS;
	}

	function wouldSubstitute(glyphs, feature) {
	  for (var _iterator2 = glyphs, _isArray2 = Array.isArray(_iterator2), _i4 = 0, _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2);;) {
	    var _glyph$features;

	    var _ref3;

	    if (_isArray2) {
	      if (_i4 >= _iterator2.length) break;
	      _ref3 = _iterator2[_i4++];
	    } else {
	      _i4 = _iterator2.next();
	      if (_i4.done) break;
	      _ref3 = _i4.value;
	    }

	    var glyph = _ref3;

	    glyph.features = (_glyph$features = {}, _glyph$features[feature] = true, _glyph$features);
	  }

	  var GSUB = glyphs[0]._font._layoutEngine.engine.GSUBProcessor;
	  GSUB.applyFeatures([feature], glyphs);

	  return glyphs.length === 1;
	}

	function consonantPosition(font, consonant, virama) {
	  var glyphs = [virama, consonant, virama];
	  if (wouldSubstitute(glyphs.slice(0, 2), 'blwf') || wouldSubstitute(glyphs.slice(1, 3), 'blwf')) {
	    return POSITIONS.Below_C;
	  } else if (wouldSubstitute(glyphs.slice(0, 2), 'pstf') || wouldSubstitute(glyphs.slice(1, 3), 'pstf')) {
	    return POSITIONS.Post_C;
	  } else if (wouldSubstitute(glyphs.slice(0, 2), 'pref') || wouldSubstitute(glyphs.slice(1, 3), 'pref')) {
	    return POSITIONS.Post_C;
	  }

	  return POSITIONS.Base_C;
	}

	function initialReordering(font, glyphs, plan) {
	  var indicConfig = plan.indicConfig;
	  var features = font._layoutEngine.engine.GSUBProcessor.features;

	  var dottedCircle = font.glyphForCodePoint(0x25cc).id;
	  var virama = font.glyphForCodePoint(indicConfig.virama).id;
	  if (virama) {
	    var info = new GlyphInfo(font, virama, [indicConfig.virama]);
	    for (var i = 0; i < glyphs.length; i++) {
	      if (glyphs[i].shaperInfo.position === POSITIONS.Base_C) {
	        glyphs[i].shaperInfo.position = consonantPosition(font, glyphs[i].copy(), info);
	      }
	    }
	  }

	  for (var start = 0, end = nextSyllable(glyphs, 0); start < glyphs.length; start = end, end = nextSyllable(glyphs, start)) {
	    var _glyphs$start$shaperI = glyphs[start].shaperInfo,
	        category = _glyphs$start$shaperI.category,
	        syllableType = _glyphs$start$shaperI.syllableType;


	    if (syllableType === 'symbol_cluster' || syllableType === 'non_indic_cluster') {
	      continue;
	    }

	    if (syllableType === 'broken_cluster' && dottedCircle) {
	      var g = new GlyphInfo(font, dottedCircle, [0x25cc]);
	      g.shaperInfo = new IndicInfo(1 << indicCategory(g), indicPosition(g), glyphs[start].shaperInfo.syllableType, glyphs[start].shaperInfo.syllable);

	      // Insert after possible Repha.
	      var _i5 = start;
	      while (_i5 < end && glyphs[_i5].shaperInfo.category === CATEGORIES.Repha) {
	        _i5++;
	      }

	      glyphs.splice(_i5++, 0, g);
	      end++;
	    }

	    // 1. Find base consonant:
	    //
	    // The shaping engine finds the base consonant of the syllable, using the
	    // following algorithm: starting from the end of the syllable, move backwards
	    // until a consonant is found that does not have a below-base or post-base
	    // form (post-base forms have to follow below-base forms), or that is not a
	    // pre-base reordering Ra, or arrive at the first consonant. The consonant
	    // stopped at will be the base.

	    var base = end;
	    var limit = start;
	    var hasReph = false;

	    // If the syllable starts with Ra + Halant (in a script that has Reph)
	    // and has more than one consonant, Ra is excluded from candidates for
	    // base consonants.
	    if (indicConfig.rephPos !== POSITIONS.Ra_To_Become_Reph && features.rphf && start + 3 <= end && (indicConfig.rephMode === 'Implicit' && !isJoiner(glyphs[start + 2]) || indicConfig.rephMode === 'Explicit' && glyphs[start + 2].shaperInfo.category === CATEGORIES.ZWJ)) {
	      // See if it matches the 'rphf' feature.
	      var _g = [glyphs[start].copy(), glyphs[start + 1].copy(), glyphs[start + 2].copy()];
	      if (wouldSubstitute(_g.slice(0, 2), 'rphf') || indicConfig.rephMode === 'Explicit' && wouldSubstitute(_g, 'rphf')) {
	        limit += 2;
	        while (limit < end && isJoiner(glyphs[limit])) {
	          limit++;
	        }
	        base 