import { z } from 'zod';
export declare const Lang: z.ZodEnum<["en", "ja"]>;
export declare const Size: z.ZodObject<{
    height: z.ZodNumber;
    width: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    width: number;
    height: number;
}, {
    width: number;
    height: number;
}>;
export declare const Alignment: z.ZodEnum<["left", "center", "right"]>;
export declare const barcodeSchemaTypes: readonly ["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"];
export declare const schemaTypes: readonly ["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"];
export declare const BarcodeSchemaType: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
export declare const SchemaType: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
export declare const CommonSchema: z.ZodObject<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "text" | "image" | "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    type: "text" | "image" | "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>;
export declare const TextSchema: z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"text">;
    alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
    fontSize: z.ZodOptional<z.ZodNumber>;
    fontName: z.ZodOptional<z.ZodString>;
    fontColor: z.ZodOptional<z.ZodString>;
    backgroundColor: z.ZodOptional<z.ZodString>;
    characterSpacing: z.ZodOptional<z.ZodNumber>;
    lineHeight: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>;
export declare const ImageSchema: z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"image">;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>;
export declare const BarcodeSchema: z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>;
export declare const Schema: z.ZodUnion<[z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"text">;
    alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
    fontSize: z.ZodOptional<z.ZodNumber>;
    fontName: z.ZodOptional<z.ZodString>;
    fontColor: z.ZodOptional<z.ZodString>;
    backgroundColor: z.ZodOptional<z.ZodString>;
    characterSpacing: z.ZodOptional<z.ZodNumber>;
    lineHeight: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>, z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"image">;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>, z.ZodObject<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    width: number;
    height: number;
}>]>;
export declare const SchemaForUI: z.ZodUnion<[z.ZodObject<z.extendShape<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"text">;
    alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
    fontSize: z.ZodOptional<z.ZodNumber>;
    fontName: z.ZodOptional<z.ZodString>;
    fontColor: z.ZodOptional<z.ZodString>;
    backgroundColor: z.ZodOptional<z.ZodString>;
    characterSpacing: z.ZodOptional<z.ZodNumber>;
    lineHeight: z.ZodOptional<z.ZodNumber>;
}>, {
    id: z.ZodString;
    key: z.ZodString;
    data: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}, {
    rotate?: number | undefined;
    alignment?: "left" | "center" | "right" | undefined;
    fontSize?: number | undefined;
    fontName?: string | undefined;
    fontColor?: string | undefined;
    backgroundColor?: string | undefined;
    characterSpacing?: number | undefined;
    lineHeight?: number | undefined;
    type: "text";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}>, z.ZodObject<z.extendShape<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodLiteral<"image">;
}>, {
    id: z.ZodString;
    key: z.ZodString;
    data: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}, {
    rotate?: number | undefined;
    type: "image";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}>, z.ZodObject<z.extendShape<z.extendShape<{
    type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    position: z.ZodObject<{
        x: z.ZodNumber;
        y: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        x: number;
        y: number;
    }, {
        x: number;
        y: number;
    }>;
    width: z.ZodNumber;
    height: z.ZodNumber;
    rotate: z.ZodOptional<z.ZodNumber>;
}, {
    type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
}>, {
    id: z.ZodString;
    key: z.ZodString;
    data: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}, {
    rotate?: number | undefined;
    type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
    position: {
        x: number;
        y: number;
    };
    data: string;
    width: number;
    height: number;
    id: string;
    key: string;
}>]>;
export declare const Font: z.ZodRecord<z.ZodString, z.ZodObject<{
    data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
    fallback: z.ZodOptional<z.ZodBoolean>;
    subset: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    fallback?: boolean | undefined;
    subset?: boolean | undefined;
    data: ArrayBuffer | Uint8Array;
}, {
    fallback?: boolean | undefined;
    subset?: boolean | undefined;
    data: ArrayBuffer | Uint8Array;
}>>;
export declare const BasePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
export declare const Template: z.ZodObject<{
    schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
        type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        position: z.ZodObject<{
            x: z.ZodNumber;
            y: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            x: number;
            y: number;
        }, {
            x: number;
            y: number;
        }>;
        width: z.ZodNumber;
        height: z.ZodNumber;
        rotate: z.ZodOptional<z.ZodNumber>;
    }, {
        type: z.ZodLiteral<"text">;
        alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
        fontSize: z.ZodOptional<z.ZodNumber>;
        fontName: z.ZodOptional<z.ZodString>;
        fontColor: z.ZodOptional<z.ZodString>;
        backgroundColor: z.ZodOptional<z.ZodString>;
        characterSpacing: z.ZodOptional<z.ZodNumber>;
        lineHeight: z.ZodOptional<z.ZodNumber>;
    }>, "strip", z.ZodTypeAny, {
        rotate?: number | undefined;
        alignment?: "left" | "center" | "right" | undefined;
        fontSize?: number | undefined;
        fontName?: string | undefined;
        fontColor?: string | undefined;
        backgroundColor?: string | undefined;
        characterSpacing?: number | undefined;
        lineHeight?: number | undefined;
        type: "text";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }, {
        rotate?: number | undefined;
        alignment?: "left" | "center" | "right" | undefined;
        fontSize?: number | undefined;
        fontName?: string | undefined;
        fontColor?: string | undefined;
        backgroundColor?: string | undefined;
        characterSpacing?: number | undefined;
        lineHeight?: number | undefined;
        type: "text";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }>, z.ZodObject<z.extendShape<{
        type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        position: z.ZodObject<{
            x: z.ZodNumber;
            y: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            x: number;
            y: number;
        }, {
            x: number;
            y: number;
        }>;
        width: z.ZodNumber;
        height: z.ZodNumber;
        rotate: z.ZodOptional<z.ZodNumber>;
    }, {
        type: z.ZodLiteral<"image">;
    }>, "strip", z.ZodTypeAny, {
        rotate?: number | undefined;
        type: "image";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }, {
        rotate?: number | undefined;
        type: "image";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }>, z.ZodObject<z.extendShape<{
        type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        position: z.ZodObject<{
            x: z.ZodNumber;
            y: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            x: number;
            y: number;
        }, {
            x: number;
            y: number;
        }>;
        width: z.ZodNumber;
        height: z.ZodNumber;
        rotate: z.ZodOptional<z.ZodNumber>;
    }, {
        type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
    }>, "strip", z.ZodTypeAny, {
        rotate?: number | undefined;
        type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }, {
        rotate?: number | undefined;
        type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }>]>>, "many">;
    basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
    sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
    columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    sampledata?: Record<string, string>[] | undefined;
    columns?: string[] | undefined;
    schemas: Record<string, {
        rotate?: number | undefined;
        alignment?: "left" | "center" | "right" | undefined;
        fontSize?: number | undefined;
        fontName?: string | undefined;
        fontColor?: string | undefined;
        backgroundColor?: string | undefined;
        characterSpacing?: number | undefined;
        lineHeight?: number | undefined;
        type: "text";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    } | {
        rotate?: number | undefined;
        type: "image";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    } | {
        rotate?: number | undefined;
        type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }>[];
    basePdf: string | ArrayBuffer | Uint8Array;
}, {
    sampledata?: Record<string, string>[] | undefined;
    columns?: string[] | undefined;
    schemas: Record<string, {
        rotate?: number | undefined;
        alignment?: "left" | "center" | "right" | undefined;
        fontSize?: number | undefined;
        fontName?: string | undefined;
        fontColor?: string | undefined;
        backgroundColor?: string | undefined;
        characterSpacing?: number | undefined;
        lineHeight?: number | undefined;
        type: "text";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    } | {
        rotate?: number | undefined;
        type: "image";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    } | {
        rotate?: number | undefined;
        type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
        position: {
            x: number;
            y: number;
        };
        width: number;
        height: number;
    }>[];
    basePdf: string | ArrayBuffer | Uint8Array;
}>;
export declare const Inputs: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">;
export declare const CommonProps: z.ZodObject<{
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    options: z.ZodOptional<z.ZodObject<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
}>;
export declare const GeneratorOptions: z.ZodObject<z.extendShape<{
    font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
        fallback: z.ZodOptional<z.ZodBoolean>;
        subset: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }>>>;
}, {
    splitThreshold: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    font?: Record<string, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }> | undefined;
    splitThreshold?: number | undefined;
}, {
    font?: Record<string, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }> | undefined;
    splitThreshold?: number | undefined;
}>;
export declare const GenerateProps: z.ZodObject<z.extendShape<{
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    options: z.ZodOptional<z.ZodObject<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }>>;
}, {
    inputs: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">;
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        splitThreshold: z.ZodOptional<z.ZodNumber>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        splitThreshold?: number | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        splitThreshold?: number | undefined;
    }>>;
}>, "strict", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        splitThreshold?: number | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        splitThreshold?: number | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
}>;
export declare const UIOptions: z.ZodObject<z.extendShape<{
    font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
        fallback: z.ZodOptional<z.ZodBoolean>;
        subset: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }>>>;
}, {
    lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
}>, "strip", z.ZodTypeAny, {
    font?: Record<string, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }> | undefined;
    lang?: "en" | "ja" | undefined;
}, {
    font?: Record<string, {
        fallback?: boolean | undefined;
        subset?: boolean | undefined;
        data: ArrayBuffer | Uint8Array;
    }> | undefined;
    lang?: "en" | "ja" | undefined;
}>;
export declare const UIProps: z.ZodObject<z.extendShape<{
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    options: z.ZodOptional<z.ZodObject<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }>>;
}, {
    domContainer: z.ZodType<HTMLElement, z.ZodTypeDef, HTMLElement>;
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }>>;
}>, "strip", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    domContainer: HTMLElement;
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    domContainer: HTMLElement;
}>;
export declare const PreviewProps: z.ZodObject<z.extendShape<z.extendShape<{
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    options: z.ZodOptional<z.ZodObject<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }>>;
}, {
    domContainer: z.ZodType<HTMLElement, z.ZodTypeDef, HTMLElement>;
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }>>;
}>, {
    inputs: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">;
}>, "strict", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
    domContainer: HTMLElement;
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
    domContainer: HTMLElement;
}>;
export declare const PreviewReactProps: z.ZodObject<z.extendShape<{
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }>>;
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    inputs: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">;
}, {
    onChangeInput: z.ZodOptional<z.ZodFunction<z.ZodTuple<[z.ZodObject<{
        index: z.ZodNumber;
        value: z.ZodString;
        key: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        value: string;
        key: string;
        index: number;
    }, {
        value: string;
        key: string;
        index: number;
    }>], z.ZodUnknown>, z.ZodVoid>>;
    size: z.ZodObject<{
        height: z.ZodNumber;
        width: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        width: number;
        height: number;
    }, {
        width: number;
        height: number;
    }>;
}>, "strict", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    onChangeInput?: ((args_0: {
        value: string;
        key: string;
        index: number;
    }, ...args_1: unknown[]) => void) | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
    size: {
        width: number;
        height: number;
    };
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    onChangeInput?: ((args_0: {
        value: string;
        key: string;
        index: number;
    }, ...args_1: unknown[]) => void) | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    inputs: Record<string, string>[];
    size: {
        width: number;
        height: number;
    };
}>;
export declare const DesignerProps: z.ZodObject<z.extendShape<z.extendShape<{
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
    options: z.ZodOptional<z.ZodObject<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
    }>>;
}, {
    domContainer: z.ZodType<HTMLElement, z.ZodTypeDef, HTMLElement>;
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }>>;
}>, {}>, "strict", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    domContainer: HTMLElement;
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    domContainer: HTMLElement;
}>;
export declare const DesignerReactProps: z.ZodObject<z.extendShape<{
    options: z.ZodOptional<z.ZodObject<z.extendShape<{
        font: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
            data: z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>;
            fallback: z.ZodOptional<z.ZodBoolean>;
            subset: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }>>>;
    }, {
        lang: z.ZodOptional<z.ZodEnum<["en", "ja"]>>;
    }>, "strip", z.ZodTypeAny, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }, {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    }>>;
    template: z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>;
}, {
    onSaveTemplate: z.ZodFunction<z.ZodTuple<[z.ZodObject<{
        schemas: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"text">;
            alignment: z.ZodOptional<z.ZodEnum<["left", "center", "right"]>>;
            fontSize: z.ZodOptional<z.ZodNumber>;
            fontName: z.ZodOptional<z.ZodString>;
            fontColor: z.ZodOptional<z.ZodString>;
            backgroundColor: z.ZodOptional<z.ZodString>;
            characterSpacing: z.ZodOptional<z.ZodNumber>;
            lineHeight: z.ZodOptional<z.ZodNumber>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodLiteral<"image">;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>, z.ZodObject<z.extendShape<{
            type: z.ZodEnum<["text", "image", "qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
            position: z.ZodObject<{
                x: z.ZodNumber;
                y: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                x: number;
                y: number;
            }, {
                x: number;
                y: number;
            }>;
            width: z.ZodNumber;
            height: z.ZodNumber;
            rotate: z.ZodOptional<z.ZodNumber>;
        }, {
            type: z.ZodEnum<["qrcode", "japanpost", "ean13", "ean8", "code39", "code128", "nw7", "itf14", "upca", "upce"]>;
        }>, "strip", z.ZodTypeAny, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }, {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>]>>, "many">;
        basePdf: z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodType<ArrayBuffer, z.ZodTypeDef, ArrayBuffer>, z.ZodType<Uint8Array, z.ZodTypeDef, Uint8Array>]>]>;
        sampledata: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodString>, "many">>;
        columns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }>], z.ZodUnknown>, z.ZodVoid>;
    size: z.ZodObject<{
        height: z.ZodNumber;
        width: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        width: number;
        height: number;
    }, {
        width: number;
        height: number;
    }>;
}>, "strict", z.ZodTypeAny, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    size: {
        width: number;
        height: number;
    };
    onSaveTemplate: (args_0: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, ...args_1: unknown[]) => void;
}, {
    options?: {
        font?: Record<string, {
            fallback?: boolean | undefined;
            subset?: boolean | undefined;
            data: ArrayBuffer | Uint8Array;
        }> | undefined;
        lang?: "en" | "ja" | undefined;
    } | undefined;
    template: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    };
    size: {
        width: number;
        height: number;
    };
    onSaveTemplate: (args_0: {
        sampledata?: Record<string, string>[] | undefined;
        columns?: string[] | undefined;
        schemas: Record<string, {
            rotate?: number | undefined;
            alignment?: "left" | "center" | "right" | undefined;
            fontSize?: number | undefined;
            fontName?: string | undefined;
            fontColor?: string | undefined;
            backgroundColor?: string | undefined;
            characterSpacing?: number | undefined;
            lineHeight?: number | undefined;
            type: "text";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "image";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        } | {
            rotate?: number | undefined;
            type: "qrcode" | "japanpost" | "ean13" | "ean8" | "code39" | "code128" | "nw7" | "itf14" | "upca" | "upce";
            position: {
                x: number;
                y: number;
            };
            width: number;
            height: number;
        }>[];
        basePdf: string | ArrayBuffer | Uint8Array;
    }, ...args_1: unknown[]) => void;
}>;
