import {
  PDFME_VERSION,
  MM_TO_PT_RATIO,
  PT_TO_MM_RATIO,
  PT_TO_PX_RATIO,
  BLANK_PDF,
  ZOOM,
  DEFAULT_FONT_NAME,
} from './constants';
import type {
  ChangeSchemaItem,
  ChangeSchemas,
  SchemaPageArray,
  PropPanel,
  PropPanelSchema,
  PropPanelWidgetProps,
  PDFRenderProps,
  Mode,
  UIRenderProps,
  Plugin,
  Lang,
  Dict,
  Size,
  Schema,
  SchemaForUI,
  Font,
  ColorType,
  BasePdf,
  BlankPdf,
  Template,
  CommonOptions,
  GeneratorOptions,
  Plugins,
  GenerateProps,
  UIOptions,
  UIProps,
  PreviewProps,
  DesignerProps,
} from './types';
import {
  cloneDeep,
  getFallbackFontName,
  getDefaultFont,
  getB64BasePdf,
  b64toUint8Array,
  checkFont,
  checkInputs,
  checkUIOptions,
  checkTemplate,
  checkUIProps,
  checkPreviewProps,
  checkDesignerProps,
  checkGenerateProps,
  mm2pt,
  pt2mm,
  pt2px,
  px2mm,
  isHexValid,
  getInputFromTemplate,
  isBlankPdf,
} from './helper';
import { getDynamicTemplate } from './dynamicTemplate';
import { replacePlaceholders } from './expression';

export {
  PDFME_VERSION,
  MM_TO_PT_RATIO,
  PT_TO_MM_RATIO,
  PT_TO_PX_RATIO,
  BLANK_PDF,
  ZOOM,
  DEFAULT_FONT_NAME,
  cloneDeep,
  getFallbackFontName,
  getDefaultFont,
  getB64BasePdf,
  b64toUint8Array,
  mm2pt,
  pt2mm,
  pt2px,
  px2mm,
  isHexValid,
  getInputFromTemplate,
  isBlankPdf,
  getDynamicTemplate,
  replacePlaceholders,
  checkFont,
  checkInputs,
  checkUIOptions,
  checkTemplate,
  checkUIProps,
  checkPreviewProps,
  checkDesignerProps,
  checkGenerateProps,
};

export type {
  Lang,
  Dict,
  Size,
  Schema,
  SchemaForUI,
  Font,
  ColorType,
  BasePdf,
  BlankPdf,
  Template,
  CommonOptions,
  GeneratorOptions,
  Plugins,
  GenerateProps,
  UIOptions,
  UIProps,
  PreviewProps,
  DesignerProps,
  ChangeSchemaItem,
  ChangeSchemas,
  SchemaPageArray,
  PropPanel,
  PropPanelSchema,
  PropPanelWidgetProps,
  PDFRenderProps,
  UIRenderProps,
  Mode,
  Plugin,
};
