import { PDFPage, PDFFont, PDFDocument, PDFImage, PDFEmbeddedPage } from 'pdf-lib';
import { Schema, Font, BasePdf, BarCodeType } from '@pdfme/common';
export interface InputImageCache {
    [key: string]: PDFImage | undefined;
}
export declare const createBarCode: (arg: {
    type: BarCodeType;
    input: string;
    width: number;
    height: number;
    backgroundColor?: string;
}) => Promise<Buffer>;
declare type EmbedPdfBox = {
    mediaBox: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    bleedBox: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    trimBox: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
};
export declare const embedAndGetFontObj: (arg: {
    pdfDoc: PDFDocument;
    font: Font;
}) => Promise<{
    [key: string]: PDFFont;
}>;
export declare const getEmbeddedPagesAndEmbedPdfBoxes: (arg: {
    pdfDoc: PDFDocument;
    basePdf: BasePdf;
}) => Promise<{
    embeddedPages: PDFEmbeddedPage[];
    embedPdfBoxes: EmbedPdfBox[];
}>;
interface TextSchemaSetting {
    fontObj: {
        [key: string]: PDFFont;
    };
    fallbackFontName: string;
    splitThreshold: number;
}
export declare const drawInputByTemplateSchema: (arg: {
    input: string;
    templateSchema: Schema;
    pdfDoc: PDFDocument;
    page: PDFPage;
    pageHeight: number;
    textSchemaSetting: TextSchemaSetting;
    inputImageCache: InputImageCache;
}) => Promise<void>;
export declare const drawEmbeddedPage: (arg: {
    page: PDFPage;
    embeddedPage: PDFEmbeddedPage;
    embedPdfBox: EmbedPdfBox;
}) => void;
export {};
