"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const generate_js_1 = __importDefault(require("../src/generate.js"));
const common_1 = require("@pdfme/common");
const schemas_1 = require("@pdfme/schemas");
const utils_js_1 = require("./utils.js");
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
require("jest-image-snapshot");
const signature = {
    pdf: schemas_1.image.pdf,
    ui: () => { },
    propPanel: {
        ...schemas_1.image.propPanel,
        defaultSchema: {
            ...schemas_1.image.propPanel.defaultSchema,
            type: 'signature',
        },
    },
};
const PERFORMANCE_THRESHOLD = parseFloat(process.env.PERFORMANCE_THRESHOLD || '1.5');
// Load all templates from playground/public/template-assets
function loadPlaygroundTemplates() {
    const templatesDir = path.join(__dirname, '../../../playground/public/template-assets');
    const templates = {};
    const folders = fs.readdirSync(templatesDir);
    for (const folder of folders) {
        const folderPath = path.join(templatesDir, folder);
        const stat = fs.statSync(folderPath);
        if (stat.isDirectory()) {
            const templatePath = path.join(folderPath, 'template.json');
            if (fs.existsSync(templatePath)) {
                try {
                    const templateContent = fs.readFileSync(templatePath, 'utf-8');
                    const template = JSON.parse(templateContent);
                    templates[folder] = template;
                }
                catch (error) {
                    console.warn(`Failed to load template from ${folder}:`, error);
                }
            }
        }
    }
    return templates;
}
describe('generate integration test(playground)', () => {
    const playgroundTemplates = loadPlaygroundTemplates();
    const RealDate = Date;
    beforeAll(() => {
        class MockDate extends RealDate {
            constructor(...args) {
                if (args.length === 0) {
                    super('2024-01-01T00:00:00.000Z');
                }
                else {
                    // @ts-expect-error Allow passing arguments to Date constructor
                    super(...args);
                }
            }
        }
        global.Date = MockDate;
    });
    afterAll(() => {
        global.Date = RealDate;
    });
    describe.each([playgroundTemplates])('%s', (templateData) => {
        const entries = Object.entries(templateData);
        for (let l = 0; l < entries.length; l += 1) {
            const [key, template] = entries[l];
            // eslint-disable-next-line no-loop-func
            test(`snapshot ${key}`, async () => {
                const inputs = (0, common_1.getInputFromTemplate)(template);
                const font = (0, utils_js_1.getFont)();
                const hrstart = process.hrtime();
                const pdf = await (0, generate_js_1.default)({
                    inputs,
                    template,
                    plugins: {
                        text: schemas_1.text,
                        image: schemas_1.image,
                        svg: schemas_1.svg,
                        line: schemas_1.line,
                        rectangle: schemas_1.rectangle,
                        ellipse: schemas_1.ellipse,
                        signature,
                        table: schemas_1.table,
                        multiVariableText: schemas_1.multiVariableText,
                        ...schemas_1.barcodes,
                    },
                    options: { font },
                });
                const hrend = process.hrtime(hrstart);
                const execSeconds = hrend[0] + hrend[1] / 1000000000;
                if (process.env.CI) {
                    expect(execSeconds).toBeLessThan(PERFORMANCE_THRESHOLD);
                }
                else if (execSeconds >= PERFORMANCE_THRESHOLD) {
                    console.warn(`Warning: Execution time for ${key} is ${execSeconds} seconds, which is above the threshold of ${PERFORMANCE_THRESHOLD} seconds.`);
                }
                const images = await (0, utils_js_1.pdfToImages)(pdf);
                for (let i = 0; i < images.length; i++) {
                    expect(images[i]).toMatchImageSnapshot({
                        customSnapshotIdentifier: `${key}-${i + 1}`,
                        failureThreshold: 0.001, // Allow 0.1% pixel difference
                        failureThresholdType: 'percent',
                    });
                }
            });
        }
    });
});
//# sourceMappingURL=integration-playground.test.js.map