"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const generate_js_1 = __importDefault(require("../src/generate.js"));
const index_js_1 = require("./assets/templates/index.js");
const common_1 = require("@pdfme/common");
const schemas_1 = require("@pdfme/schemas");
const utils_js_1 = require("./utils.js");
require("jest-image-snapshot");
const PERFORMANCE_THRESHOLD = parseFloat(process.env.PERFORMANCE_THRESHOLD || '2.5');
describe('generate integration test(segmenter)', () => {
    describe.each([index_js_1.segmenter])('%s', (templateData) => {
        const entries = Object.entries(templateData);
        for (let l = 0; l < entries.length; l += 1) {
            const [key, template] = entries[l];
            // eslint-disable-next-line no-loop-func
            test(`snapshot ${key}`, async () => {
                const inputs = (0, common_1.getInputFromTemplate)(template);
                const font = (0, utils_js_1.getFont)();
                font['NotoSerifJP-Regular'].fallback = false;
                font.NotoSerifJP.fallback = false;
                font.NotoSansJP.fallback = false;
                const hrstart = process.hrtime();
                const pdf = await (0, generate_js_1.default)({
                    inputs,
                    template,
                    plugins: { text: schemas_1.text, image: schemas_1.image, multiVariableText: schemas_1.multiVariableText, ...schemas_1.barcodes },
                    options: { font },
                });
                const hrend = process.hrtime(hrstart);
                const execSeconds = hrend[0] + hrend[1] / 1000000000;
                if (process.env.CI) {
                    expect(execSeconds).toBeLessThan(PERFORMANCE_THRESHOLD);
                }
                else if (execSeconds >= PERFORMANCE_THRESHOLD) {
                    console.warn(`Warning: Execution time for ${key} is ${execSeconds} seconds, which is above the threshold of ${PERFORMANCE_THRESHOLD} seconds.`);
                }
                const images = await (0, utils_js_1.pdfToImages)(pdf);
                for (let i = 0; i < images.length; i++) {
                    expect(images[i]).toMatchImageSnapshot({
                        customSnapshotIdentifier: `${key}-${i + 1}`,
                    });
                }
            });
        }
    });
});
//# sourceMappingURL=integration-segmenter.test.js.map