"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.pdfToImages = exports.getFont = void 0;
const fs_1 = require("fs");
const path = __importStar(require("path"));
const common_1 = require("@pdfme/common");
const converter_1 = require("@pdfme/converter");
const NotoSerifJPRegularData = (0, fs_1.readFileSync)(
// path.join(__dirname, `/assets/fonts/NotoSerifJP-Regular.otf`)
path.join(__dirname, `/assets/fonts/NotoSerifJP-Regular.ttf`));
const NotoSansJPRegularData = (0, fs_1.readFileSync)(
// path.join(__dirname, `/assets/fonts/NotoSansJP-Regular.otf`)
path.join(__dirname, `/assets/fonts/NotoSansJP-Regular.ttf`));
const GloriaHallelujahRegularData = (0, fs_1.readFileSync)(path.join(__dirname, `/assets/fonts/GloriaHallelujah-Regular.ttf`));
const GreatVibesRegularData = (0, fs_1.readFileSync)(path.join(__dirname, `/assets/fonts/GreatVibes-Regular.ttf`));
const JuliusSansOneRegularData = (0, fs_1.readFileSync)(path.join(__dirname, `/assets/fonts/JuliusSansOne-Regular.ttf`));
const getFont = () => ({
    ...(0, common_1.getDefaultFont)(),
    'NotoSerifJP-Regular': { data: NotoSerifJPRegularData },
    'NotoSansJP-Regular': { data: NotoSansJPRegularData },
    'GloriaHallelujah-Regular': { data: GloriaHallelujahRegularData },
    'GreatVibes-Regular': { data: GreatVibesRegularData },
    'JuliusSansOne-Regular': { data: JuliusSansOneRegularData },
    NotoSerifJP: { data: NotoSerifJPRegularData },
    NotoSansJP: { data: NotoSansJPRegularData },
    'PinyonScript-Regular': {
        fallback: false,
        data: 'https://fonts.gstatic.com/s/pinyonscript/v22/6xKpdSJbL9-e9LuoeQiDRQR8aOLQO4bhiDY.ttf',
    },
});
exports.getFont = getFont;
const pdfToImages = async (pdf) => {
    const arrayBuffers = await (0, converter_1.pdf2img)(pdf, { imageType: 'png' });
    return arrayBuffers.map((buf) => Buffer.from(new Uint8Array(buf)));
};
exports.pdfToImages = pdfToImages;
//# sourceMappingURL=utils.js.map