"use strict";
// tslint:disable: max-classes-per-file
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidMaxLengthError = exports.ExceededMaxLengthError = exports.CombedTextLayoutError = exports.RichTextFieldReadError = exports.FieldExistsAsNonTerminalError = exports.InvalidFieldNamePartError = exports.FieldAlreadyExistsError = exports.MissingOnValueCheckError = exports.UnexpectedFieldTypeError = exports.NoSuchFieldError = exports.RemovePageFromEmptyDocumentError = exports.ForeignPageError = exports.FontkitNotRegisteredError = exports.EncryptedPDFError = void 0;
// TODO: Include link to documentation with example
class EncryptedPDFError extends Error {
    constructor() {
        const msg = 'Input document to `PDFDocument.load` is encrypted. You can use `PDFDocument.load(..., { ignoreEncryption: true })` if you wish to load the document anyways.';
        super(msg);
    }
}
exports.EncryptedPDFError = EncryptedPDFError;
// TODO: Include link to documentation with example
class FontkitNotRegisteredError extends Error {
    constructor() {
        const msg = 'Input to `PDFDocument.embedFont` was a custom font, but no `fontkit` instance was found. You must register a `fontkit` instance with `PDFDocument.registerFontkit(...)` before embedding custom fonts.';
        super(msg);
    }
}
exports.FontkitNotRegisteredError = FontkitNotRegisteredError;
// TODO: Include link to documentation with example
class ForeignPageError extends Error {
    constructor() {
        const msg = 'A `page` passed to `PDFDocument.addPage` or `PDFDocument.insertPage` was from a different (foreign) PDF document. If you want to copy pages from one PDFDocument to another, you must use `PDFDocument.copyPages(...)` to copy the pages before adding or inserting them.';
        super(msg);
    }
}
exports.ForeignPageError = ForeignPageError;
// TODO: Include link to documentation with example
class RemovePageFromEmptyDocumentError extends Error {
    constructor() {
        const msg = 'PDFDocument has no pages so `PDFDocument.removePage` cannot be called';
        super(msg);
    }
}
exports.RemovePageFromEmptyDocumentError = RemovePageFromEmptyDocumentError;
class NoSuchFieldError extends Error {
    constructor(name) {
        const msg = `PDFDocument has no form field with the name "${name}"`;
        super(msg);
    }
}
exports.NoSuchFieldError = NoSuchFieldError;
class UnexpectedFieldTypeError extends Error {
    constructor(name, expected, actual) {
        var _a, _b;
        const expectedType = expected === null || expected === void 0 ? void 0 : expected.name;
        const actualType = (_b = (_a = actual === null || actual === void 0 ? void 0 : actual.constructor) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : actual;
        const msg = `Expected field "${name}" to be of type ${expectedType}, ` +
            `but it is actually of type ${actualType}`;
        super(msg);
    }
}
exports.UnexpectedFieldTypeError = UnexpectedFieldTypeError;
class MissingOnValueCheckError extends Error {
    constructor(onValue) {
        const msg = `Failed to select check box due to missing onValue: "${onValue}"`;
        super(msg);
    }
}
exports.MissingOnValueCheckError = MissingOnValueCheckError;
class FieldAlreadyExistsError extends Error {
    constructor(name) {
        const msg = `A field already exists with the specified name: "${name}"`;
        super(msg);
    }
}
exports.FieldAlreadyExistsError = FieldAlreadyExistsError;
class InvalidFieldNamePartError extends Error {
    constructor(namePart) {
        const msg = `Field name contains invalid component: "${namePart}"`;
        super(msg);
    }
}
exports.InvalidFieldNamePartError = InvalidFieldNamePartError;
class FieldExistsAsNonTerminalError extends Error {
    constructor(name) {
        const msg = `A non-terminal field already exists with the specified name: "${name}"`;
        super(msg);
    }
}
exports.FieldExistsAsNonTerminalError = FieldExistsAsNonTerminalError;
class RichTextFieldReadError extends Error {
    constructor(fieldName) {
        const msg = `Reading rich text fields is not supported: Attempted to read rich text field: ${fieldName}`;
        super(msg);
    }
}
exports.RichTextFieldReadError = RichTextFieldReadError;
class CombedTextLayoutError extends Error {
    constructor(lineLength, cellCount) {
        const msg = `Failed to layout combed text as lineLength=${lineLength} is greater than cellCount=${cellCount}`;
        super(msg);
    }
}
exports.CombedTextLayoutError = CombedTextLayoutError;
class ExceededMaxLengthError extends Error {
    constructor(textLength, maxLength, name) {
        const msg = `Attempted to set text with length=${textLength} for TextField with maxLength=${maxLength} and name=${name}`;
        super(msg);
    }
}
exports.ExceededMaxLengthError = ExceededMaxLengthError;
class InvalidMaxLengthError extends Error {
    constructor(textLength, maxLength, name) {
        const msg = `Attempted to set maxLength=${maxLength}, which is less than ${textLength}, the length of this field's current value (name=${name})`;
        super(msg);
    }
}
exports.InvalidMaxLengthError = InvalidMaxLengthError;
//# sourceMappingURL=errors.js.map