"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setFillingGrayscaleColor = exports.drawObject = exports.rotateAndSkewTextDegreesAndTranslate = exports.rotateAndSkewTextRadiansAndTranslate = exports.setTextMatrix = exports.setTextRenderingMode = exports.TextRenderingMode = exports.setTextRise = exports.setLineHeight = exports.setCharacterSqueeze = exports.setWordSpacing = exports.setCharacterSpacing = exports.setFontAndSize = exports.endText = exports.beginText = exports.showText = exports.moveText = exports.nextLine = exports.endPath = exports.fillAndStroke = exports.fillEvenOdd = exports.fill = exports.FillRule = exports.stroke = exports.square = exports.rectangle = exports.lineTo = exports.moveTo = exports.closePath = exports.appendQuadraticCurve = exports.appendBezierCurve = exports.setLineWidth = exports.popGraphicsState = exports.pushGraphicsState = exports.setGraphicsState = exports.setLineJoin = exports.LineJoinStyle = exports.setLineCap = exports.LineCapStyle = exports.restoreDashPattern = exports.setDashPattern = exports.skewDegrees = exports.skewRadians = exports.rotateDegrees = exports.rotateRadians = exports.scale = exports.translate = exports.concatTransformationMatrix = exports.clipEvenOdd = exports.clip = void 0;
exports.endMarkedContent = exports.beginMarkedContent = exports.setStrokingCmykColor = exports.setFillingCmykColor = exports.setStrokingRgbColor = exports.setFillingRgbColor = exports.setStrokingGrayscaleColor = void 0;
const objects_1 = require("./objects");
const rotations_1 = require("./rotations");
const core_1 = require("../core");
/* ==================== Clipping Path Operators ==================== */
const clip = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.ClipNonZero);
exports.clip = clip;
const clipEvenOdd = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.ClipEvenOdd);
exports.clipEvenOdd = clipEvenOdd;
/* ==================== Graphics State Operators ==================== */
const { cos, sin, tan } = Math;
const concatTransformationMatrix = (a, b, c, d, e, f) => core_1.PDFOperator.of(core_1.PDFOperatorNames.ConcatTransformationMatrix, [
    (0, objects_1.asPDFNumber)(a),
    (0, objects_1.asPDFNumber)(b),
    (0, objects_1.asPDFNumber)(c),
    (0, objects_1.asPDFNumber)(d),
    (0, objects_1.asPDFNumber)(e),
    (0, objects_1.asPDFNumber)(f),
]);
exports.concatTransformationMatrix = concatTransformationMatrix;
const translate = (xPos, yPos) => (0, exports.concatTransformationMatrix)(1, 0, 0, 1, xPos, yPos);
exports.translate = translate;
const scale = (xPos, yPos) => (0, exports.concatTransformationMatrix)(xPos, 0, 0, yPos, 0, 0);
exports.scale = scale;
const rotateRadians = (angle) => (0, exports.concatTransformationMatrix)(cos((0, objects_1.asNumber)(angle)), sin((0, objects_1.asNumber)(angle)), -sin((0, objects_1.asNumber)(angle)), cos((0, objects_1.asNumber)(angle)), 0, 0);
exports.rotateRadians = rotateRadians;
const rotateDegrees = (angle) => (0, exports.rotateRadians)((0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(angle)));
exports.rotateDegrees = rotateDegrees;
const skewRadians = (xSkewAngle, ySkewAngle) => (0, exports.concatTransformationMatrix)(1, tan((0, objects_1.asNumber)(xSkewAngle)), tan((0, objects_1.asNumber)(ySkewAngle)), 1, 0, 0);
exports.skewRadians = skewRadians;
const skewDegrees = (xSkewAngle, ySkewAngle) => (0, exports.skewRadians)((0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(xSkewAngle)), (0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(ySkewAngle)));
exports.skewDegrees = skewDegrees;
const setDashPattern = (dashArray, dashPhase) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetLineDashPattern, [
    `[${dashArray.map(objects_1.asPDFNumber).join(' ')}]`,
    (0, objects_1.asPDFNumber)(dashPhase),
]);
exports.setDashPattern = setDashPattern;
const restoreDashPattern = () => (0, exports.setDashPattern)([], 0);
exports.restoreDashPattern = restoreDashPattern;
var LineCapStyle;
(function (LineCapStyle) {
    LineCapStyle[LineCapStyle["Butt"] = 0] = "Butt";
    LineCapStyle[LineCapStyle["Round"] = 1] = "Round";
    LineCapStyle[LineCapStyle["Projecting"] = 2] = "Projecting";
})(LineCapStyle = exports.LineCapStyle || (exports.LineCapStyle = {}));
const setLineCap = (style) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetLineCapStyle, [(0, objects_1.asPDFNumber)(style)]);
exports.setLineCap = setLineCap;
var LineJoinStyle;
(function (LineJoinStyle) {
    LineJoinStyle[LineJoinStyle["Miter"] = 0] = "Miter";
    LineJoinStyle[LineJoinStyle["Round"] = 1] = "Round";
    LineJoinStyle[LineJoinStyle["Bevel"] = 2] = "Bevel";
})(LineJoinStyle = exports.LineJoinStyle || (exports.LineJoinStyle = {}));
const setLineJoin = (style) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetLineJoinStyle, [(0, objects_1.asPDFNumber)(style)]);
exports.setLineJoin = setLineJoin;
const setGraphicsState = (state) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetGraphicsStateParams, [(0, objects_1.asPDFName)(state)]);
exports.setGraphicsState = setGraphicsState;
const pushGraphicsState = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.PushGraphicsState);
exports.pushGraphicsState = pushGraphicsState;
const popGraphicsState = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.PopGraphicsState);
exports.popGraphicsState = popGraphicsState;
const setLineWidth = (width) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetLineWidth, [(0, objects_1.asPDFNumber)(width)]);
exports.setLineWidth = setLineWidth;
/* ==================== Path Construction Operators ==================== */
const appendBezierCurve = (x1, y1, x2, y2, x3, y3) => core_1.PDFOperator.of(core_1.PDFOperatorNames.AppendBezierCurve, [
    (0, objects_1.asPDFNumber)(x1),
    (0, objects_1.asPDFNumber)(y1),
    (0, objects_1.asPDFNumber)(x2),
    (0, objects_1.asPDFNumber)(y2),
    (0, objects_1.asPDFNumber)(x3),
    (0, objects_1.asPDFNumber)(y3),
]);
exports.appendBezierCurve = appendBezierCurve;
const appendQuadraticCurve = (x1, y1, x2, y2) => core_1.PDFOperator.of(core_1.PDFOperatorNames.CurveToReplicateInitialPoint, [
    (0, objects_1.asPDFNumber)(x1),
    (0, objects_1.asPDFNumber)(y1),
    (0, objects_1.asPDFNumber)(x2),
    (0, objects_1.asPDFNumber)(y2),
]);
exports.appendQuadraticCurve = appendQuadraticCurve;
const closePath = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.ClosePath);
exports.closePath = closePath;
const moveTo = (xPos, yPos) => core_1.PDFOperator.of(core_1.PDFOperatorNames.MoveTo, [(0, objects_1.asPDFNumber)(xPos), (0, objects_1.asPDFNumber)(yPos)]);
exports.moveTo = moveTo;
const lineTo = (xPos, yPos) => core_1.PDFOperator.of(core_1.PDFOperatorNames.LineTo, [(0, objects_1.asPDFNumber)(xPos), (0, objects_1.asPDFNumber)(yPos)]);
exports.lineTo = lineTo;
/**
 * @param xPos x coordinate for the lower left corner of the rectangle
 * @param yPos y coordinate for the lower left corner of the rectangle
 * @param width width of the rectangle
 * @param height height of the rectangle
 */
const rectangle = (xPos, yPos, width, height) => core_1.PDFOperator.of(core_1.PDFOperatorNames.AppendRectangle, [
    (0, objects_1.asPDFNumber)(xPos),
    (0, objects_1.asPDFNumber)(yPos),
    (0, objects_1.asPDFNumber)(width),
    (0, objects_1.asPDFNumber)(height),
]);
exports.rectangle = rectangle;
/**
 * @param xPos x coordinate for the lower left corner of the square
 * @param yPos y coordinate for the lower left corner of the square
 * @param size width and height of the square
 */
const square = (xPos, yPos, size) => (0, exports.rectangle)(xPos, yPos, size, size);
exports.square = square;
/* ==================== Path Painting Operators ==================== */
const stroke = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.StrokePath);
exports.stroke = stroke;
var FillRule;
(function (FillRule) {
    FillRule["NonZero"] = "f";
    FillRule["EvenOdd"] = "f*";
})(FillRule = exports.FillRule || (exports.FillRule = {}));
const fill = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.FillNonZero);
exports.fill = fill;
const fillEvenOdd = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.FillEvenOdd);
exports.fillEvenOdd = fillEvenOdd;
const fillAndStroke = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.FillNonZeroAndStroke);
exports.fillAndStroke = fillAndStroke;
const endPath = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.EndPath);
exports.endPath = endPath;
/* ==================== Text Positioning Operators ==================== */
const nextLine = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.NextLine);
exports.nextLine = nextLine;
const moveText = (x, y) => core_1.PDFOperator.of(core_1.PDFOperatorNames.MoveText, [(0, objects_1.asPDFNumber)(x), (0, objects_1.asPDFNumber)(y)]);
exports.moveText = moveText;
/* ==================== Text Showing Operators ==================== */
const showText = (text) => core_1.PDFOperator.of(core_1.PDFOperatorNames.ShowText, [text]);
exports.showText = showText;
/* ==================== Text State Operators ==================== */
const beginText = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.BeginText);
exports.beginText = beginText;
const endText = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.EndText);
exports.endText = endText;
const setFontAndSize = (name, size) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetFontAndSize, [(0, objects_1.asPDFName)(name), (0, objects_1.asPDFNumber)(size)]);
exports.setFontAndSize = setFontAndSize;
const setCharacterSpacing = (spacing) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetCharacterSpacing, [(0, objects_1.asPDFNumber)(spacing)]);
exports.setCharacterSpacing = setCharacterSpacing;
const setWordSpacing = (spacing) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetWordSpacing, [(0, objects_1.asPDFNumber)(spacing)]);
exports.setWordSpacing = setWordSpacing;
/** @param squeeze horizontal character spacing */
const setCharacterSqueeze = (squeeze) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetTextHorizontalScaling, [(0, objects_1.asPDFNumber)(squeeze)]);
exports.setCharacterSqueeze = setCharacterSqueeze;
const setLineHeight = (lineHeight) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetTextLineHeight, [(0, objects_1.asPDFNumber)(lineHeight)]);
exports.setLineHeight = setLineHeight;
const setTextRise = (rise) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetTextRise, [(0, objects_1.asPDFNumber)(rise)]);
exports.setTextRise = setTextRise;
var TextRenderingMode;
(function (TextRenderingMode) {
    TextRenderingMode[TextRenderingMode["Fill"] = 0] = "Fill";
    TextRenderingMode[TextRenderingMode["Outline"] = 1] = "Outline";
    TextRenderingMode[TextRenderingMode["FillAndOutline"] = 2] = "FillAndOutline";
    TextRenderingMode[TextRenderingMode["Invisible"] = 3] = "Invisible";
    TextRenderingMode[TextRenderingMode["FillAndClip"] = 4] = "FillAndClip";
    TextRenderingMode[TextRenderingMode["OutlineAndClip"] = 5] = "OutlineAndClip";
    TextRenderingMode[TextRenderingMode["FillAndOutlineAndClip"] = 6] = "FillAndOutlineAndClip";
    TextRenderingMode[TextRenderingMode["Clip"] = 7] = "Clip";
})(TextRenderingMode = exports.TextRenderingMode || (exports.TextRenderingMode = {}));
const setTextRenderingMode = (mode) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetTextRenderingMode, [(0, objects_1.asPDFNumber)(mode)]);
exports.setTextRenderingMode = setTextRenderingMode;
const setTextMatrix = (a, b, c, d, e, f) => core_1.PDFOperator.of(core_1.PDFOperatorNames.SetTextMatrix, [
    (0, objects_1.asPDFNumber)(a),
    (0, objects_1.asPDFNumber)(b),
    (0, objects_1.asPDFNumber)(c),
    (0, objects_1.asPDFNumber)(d),
    (0, objects_1.asPDFNumber)(e),
    (0, objects_1.asPDFNumber)(f),
]);
exports.setTextMatrix = setTextMatrix;
const rotateAndSkewTextRadiansAndTranslate = (rotationAngle, xSkewAngle, ySkewAngle, x, y) => (0, exports.setTextMatrix)(cos((0, objects_1.asNumber)(rotationAngle)), sin((0, objects_1.asNumber)(rotationAngle)) + tan((0, objects_1.asNumber)(xSkewAngle)), -sin((0, objects_1.asNumber)(rotationAngle)) + tan((0, objects_1.asNumber)(ySkewAngle)), cos((0, objects_1.asNumber)(rotationAngle)), x, y);
exports.rotateAndSkewTextRadiansAndTranslate = rotateAndSkewTextRadiansAndTranslate;
const rotateAndSkewTextDegreesAndTranslate = (rotationAngle, xSkewAngle, ySkewAngle, x, y) => (0, exports.rotateAndSkewTextRadiansAndTranslate)((0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(rotationAngle)), (0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(xSkewAngle)), (0, rotations_1.degreesToRadians)((0, objects_1.asNumber)(ySkewAngle)), x, y);
exports.rotateAndSkewTextDegreesAndTranslate = rotateAndSkewTextDegreesAndTranslate;
/* ==================== XObject Operator ==================== */
const drawObject = (name) => core_1.PDFOperator.of(core_1.PDFOperatorNames.DrawObject, [(0, objects_1.asPDFName)(name)]);
exports.drawObject = drawObject;
/* ==================== Color Operators ==================== */
const setFillingGrayscaleColor = (gray) => core_1.PDFOperator.of(core_1.PDFOperatorNames.NonStrokingColorGray, [(0, objects_1.asPDFNumber)(gray)]);
exports.setFillingGrayscaleColor = setFillingGrayscaleColor;
const setStrokingGrayscaleColor = (gray) => core_1.PDFOperator.of(core_1.PDFOperatorNames.StrokingColorGray, [(0, objects_1.asPDFNumber)(gray)]);
exports.setStrokingGrayscaleColor = setStrokingGrayscaleColor;
const setFillingRgbColor = (red, green, blue) => core_1.PDFOperator.of(core_1.PDFOperatorNames.NonStrokingColorRgb, [
    (0, objects_1.asPDFNumber)(red),
    (0, objects_1.asPDFNumber)(green),
    (0, objects_1.asPDFNumber)(blue),
]);
exports.setFillingRgbColor = setFillingRgbColor;
const setStrokingRgbColor = (red, green, blue) => core_1.PDFOperator.of(core_1.PDFOperatorNames.StrokingColorRgb, [
    (0, objects_1.asPDFNumber)(red),
    (0, objects_1.asPDFNumber)(green),
    (0, objects_1.asPDFNumber)(blue),
]);
exports.setStrokingRgbColor = setStrokingRgbColor;
const setFillingCmykColor = (cyan, magenta, yellow, key) => core_1.PDFOperator.of(core_1.PDFOperatorNames.NonStrokingColorCmyk, [
    (0, objects_1.asPDFNumber)(cyan),
    (0, objects_1.asPDFNumber)(magenta),
    (0, objects_1.asPDFNumber)(yellow),
    (0, objects_1.asPDFNumber)(key),
]);
exports.setFillingCmykColor = setFillingCmykColor;
const setStrokingCmykColor = (cyan, magenta, yellow, key) => core_1.PDFOperator.of(core_1.PDFOperatorNames.StrokingColorCmyk, [
    (0, objects_1.asPDFNumber)(cyan),
    (0, objects_1.asPDFNumber)(magenta),
    (0, objects_1.asPDFNumber)(yellow),
    (0, objects_1.asPDFNumber)(key),
]);
exports.setStrokingCmykColor = setStrokingCmykColor;
/* ==================== Marked Content Operators ==================== */
const beginMarkedContent = (tag) => core_1.PDFOperator.of(core_1.PDFOperatorNames.BeginMarkedContent, [(0, objects_1.asPDFName)(tag)]);
exports.beginMarkedContent = beginMarkedContent;
const endMarkedContent = () => core_1.PDFOperator.of(core_1.PDFOperatorNames.EndMarkedContent);
exports.endMarkedContent = endMarkedContent;
//# sourceMappingURL=operators.js.map