"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rotateRectangle = exports.adjustDimsForRotation = exports.reduceRotation = exports.toDegrees = exports.toRadians = exports.radiansToDegrees = exports.degreesToRadians = exports.degrees = exports.radians = exports.RotationTypes = void 0;
const utils_1 = require("../utils");
var RotationTypes;
(function (RotationTypes) {
    RotationTypes["Degrees"] = "degrees";
    RotationTypes["Radians"] = "radians";
})(RotationTypes = exports.RotationTypes || (exports.RotationTypes = {}));
const radians = (radianAngle) => {
    (0, utils_1.assertIs)(radianAngle, 'radianAngle', ['number']);
    return { type: RotationTypes.Radians, angle: radianAngle };
};
exports.radians = radians;
const degrees = (degreeAngle) => {
    (0, utils_1.assertIs)(degreeAngle, 'degreeAngle', ['number']);
    return { type: RotationTypes.Degrees, angle: degreeAngle };
};
exports.degrees = degrees;
const { Radians, Degrees } = RotationTypes;
const degreesToRadians = (degree) => (degree * Math.PI) / 180;
exports.degreesToRadians = degreesToRadians;
const radiansToDegrees = (radian) => (radian * 180) / Math.PI;
exports.radiansToDegrees = radiansToDegrees;
// prettier-ignore
const toRadians = (rotation) => rotation.type === Radians ? rotation.angle
    : rotation.type === Degrees ? (0, exports.degreesToRadians)(rotation.angle)
        : (0, utils_1.error)(`Invalid rotation: ${JSON.stringify(rotation)}`);
exports.toRadians = toRadians;
// prettier-ignore
const toDegrees = (rotation) => rotation.type === Radians ? (0, exports.radiansToDegrees)(rotation.angle)
    : rotation.type === Degrees ? rotation.angle
        : (0, utils_1.error)(`Invalid rotation: ${JSON.stringify(rotation)}`);
exports.toDegrees = toDegrees;
const reduceRotation = (degreeAngle = 0) => {
    const quadrants = (degreeAngle / 90) % 4;
    if (quadrants === 0)
        return 0;
    if (quadrants === 1)
        return 90;
    if (quadrants === 2)
        return 180;
    if (quadrants === 3)
        return 270;
    return 0; // `degreeAngle` is not a multiple of 90
};
exports.reduceRotation = reduceRotation;
const adjustDimsForRotation = (dims, degreeAngle = 0) => {
    const rotation = (0, exports.reduceRotation)(degreeAngle);
    return rotation === 90 || rotation === 270
        ? { width: dims.height, height: dims.width }
        : { width: dims.width, height: dims.height };
};
exports.adjustDimsForRotation = adjustDimsForRotation;
const rotateRectangle = (rectangle, borderWidth = 0, degreeAngle = 0) => {
    const { x, y, width: w, height: h } = rectangle;
    const r = (0, exports.reduceRotation)(degreeAngle);
    const b = borderWidth / 2;
    // prettier-ignore
    if (r === 0)
        return { x: x - b, y: y - b, width: w, height: h };
    else if (r === 90)
        return { x: x - h + b, y: y - b, width: h, height: w };
    else if (r === 180)
        return { x: x - w + b, y: y - h + b, width: w, height: h };
    else if (r === 270)
        return { x: x - b, y: y - w + b, width: h, height: w };
    else
        return { x: x - b, y: y - b, width: w, height: h };
};
exports.rotateRectangle = rotateRectangle;
//# sourceMappingURL=rotations.js.map