"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const PDFAcroTerminal_1 = (0, tslib_1.__importDefault)(require("./PDFAcroTerminal"));
const PDFHexString_1 = (0, tslib_1.__importDefault)(require("../objects/PDFHexString"));
const PDFString_1 = (0, tslib_1.__importDefault)(require("../objects/PDFString"));
const PDFArray_1 = (0, tslib_1.__importDefault)(require("../objects/PDFArray"));
const PDFName_1 = (0, tslib_1.__importDefault)(require("../objects/PDFName"));
const flags_1 = require("./flags");
const errors_1 = require("../errors");
class PDFAcroChoice extends PDFAcroTerminal_1.default {
    setValues(values) {
        if (this.hasFlag(flags_1.AcroChoiceFlags.Combo) &&
            !this.hasFlag(flags_1.AcroChoiceFlags.Edit) &&
            !this.valuesAreValid(values)) {
            throw new errors_1.InvalidAcroFieldValueError();
        }
        if (values.length === 0) {
            this.dict.delete(PDFName_1.default.of('V'));
        }
        if (values.length === 1) {
            this.dict.set(PDFName_1.default.of('V'), values[0]);
        }
        if (values.length > 1) {
            if (!this.hasFlag(flags_1.AcroChoiceFlags.MultiSelect)) {
                throw new errors_1.MultiSelectValueError();
            }
            this.dict.set(PDFName_1.default.of('V'), this.dict.context.obj(values));
        }
        this.updateSelectedIndices(values);
    }
    valuesAreValid(values) {
        const options = this.getOptions();
        for (let idx = 0, len = values.length; idx < len; idx++) {
            const val = values[idx].decodeText();
            if (!options.find((o) => val === (o.display || o.value).decodeText())) {
                return false;
            }
        }
        return true;
    }
    updateSelectedIndices(values) {
        if (values.length > 1) {
            const indices = new Array(values.length);
            const options = this.getOptions();
            for (let idx = 0, len = values.length; idx < len; idx++) {
                const val = values[idx].decodeText();
                indices[idx] = options.findIndex((o) => val === (o.display || o.value).decodeText());
            }
            this.dict.set(PDFName_1.default.of('I'), this.dict.context.obj(indices.sort()));
        }
        else {
            this.dict.delete(PDFName_1.default.of('I'));
        }
    }
    getValues() {
        const v = this.V();
        if (v instanceof PDFString_1.default || v instanceof PDFHexString_1.default)
            return [v];
        if (v instanceof PDFArray_1.default) {
            const values = [];
            for (let idx = 0, len = v.size(); idx < len; idx++) {
                const value = v.lookup(idx);
                if (value instanceof PDFString_1.default || value instanceof PDFHexString_1.default) {
                    values.push(value);
                }
            }
            return values;
        }
        return [];
    }
    Opt() {
        return this.dict.lookupMaybe(PDFName_1.default.of('Opt'), PDFString_1.default, PDFHexString_1.default, PDFArray_1.default);
    }
    setOptions(options) {
        const newOpt = new Array(options.length);
        for (let idx = 0, len = options.length; idx < len; idx++) {
            const { value, display } = options[idx];
            newOpt[idx] = this.dict.context.obj([value, display || value]);
        }
        this.dict.set(PDFName_1.default.of('Opt'), this.dict.context.obj(newOpt));
    }
    getOptions() {
        const Opt = this.Opt();
        // Not supposed to happen - Opt _should_ always be `PDFArray | undefined`
        if (Opt instanceof PDFString_1.default || Opt instanceof PDFHexString_1.default) {
            return [{ value: Opt, display: Opt }];
        }
        if (Opt instanceof PDFArray_1.default) {
            const res = [];
            for (let idx = 0, len = Opt.size(); idx < len; idx++) {
                const item = Opt.lookup(idx);
                // If `item` is a string, use that as both the export and text value
                if (item instanceof PDFString_1.default || item instanceof PDFHexString_1.default) {
                    res.push({ value: item, display: item });
                }
                // If `item` is an array of one, treat it the same as just a string,
                // if it's an array of two then `item[0]` is the export value and
                // `item[1]` is the text value
                if (item instanceof PDFArray_1.default) {
                    if (item.size() > 0) {
                        const first = item.lookup(0, PDFString_1.default, PDFHexString_1.default);
                        const second = item.lookupMaybe(1, PDFString_1.default, PDFHexString_1.default);
                        res.push({ value: first, display: second || first });
                    }
                }
            }
            return res;
        }
        return [];
    }
}
exports.default = PDFAcroChoice;
//# sourceMappingURL=PDFAcroChoice.js.map