"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const CharCodes_1 = (0, tslib_1.__importDefault)(require("../syntax/CharCodes"));
const utils_1 = require("../../utils");
class PDFTrailer {
    constructor(lastXRefOffset) {
        this.lastXRefOffset = String(lastXRefOffset);
    }
    toString() {
        return `startxref\n${this.lastXRefOffset}\n%%EOF`;
    }
    sizeInBytes() {
        return 16 + this.lastXRefOffset.length;
    }
    copyBytesInto(buffer, offset) {
        const initialOffset = offset;
        buffer[offset++] = CharCodes_1.default.s;
        buffer[offset++] = CharCodes_1.default.t;
        buffer[offset++] = CharCodes_1.default.a;
        buffer[offset++] = CharCodes_1.default.r;
        buffer[offset++] = CharCodes_1.default.t;
        buffer[offset++] = CharCodes_1.default.x;
        buffer[offset++] = CharCodes_1.default.r;
        buffer[offset++] = CharCodes_1.default.e;
        buffer[offset++] = CharCodes_1.default.f;
        buffer[offset++] = CharCodes_1.default.Newline;
        offset += (0, utils_1.copyStringIntoBuffer)(this.lastXRefOffset, buffer, offset);
        buffer[offset++] = CharCodes_1.default.Newline;
        buffer[offset++] = CharCodes_1.default.Percent;
        buffer[offset++] = CharCodes_1.default.Percent;
        buffer[offset++] = CharCodes_1.default.E;
        buffer[offset++] = CharCodes_1.default.O;
        buffer[offset++] = CharCodes_1.default.F;
        return offset - initialOffset;
    }
}
PDFTrailer.forLastCrossRefSectionOffset = (offset) => new PDFTrailer(offset);
exports.default = PDFTrailer;
//# sourceMappingURL=PDFTrailer.js.map