"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const PDFHexString_1 = (0, tslib_1.__importDefault)(require("../objects/PDFHexString"));
class JavaScriptEmbedder {
    constructor(script, scriptName) {
        this.script = script;
        this.scriptName = scriptName;
    }
    static for(script, scriptName) {
        return new JavaScriptEmbedder(script, scriptName);
    }
    async embedIntoContext(context, ref) {
        const jsActionDict = context.obj({
            Type: 'Action',
            S: 'JavaScript',
            JS: PDFHexString_1.default.fromText(this.script),
        });
        if (ref) {
            context.assign(ref, jsActionDict);
            return ref;
        }
        else {
            return context.register(jsActionDict);
        }
    }
}
exports.default = JavaScriptEmbedder;
//# sourceMappingURL=JavaScriptEmbedder.js.map