"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingKeywordError = exports.MissingPDFHeaderError = exports.StalledParserError = exports.UnbalancedParenthesisError = exports.PDFStreamParsingError = exports.PDFInvalidObjectParsingError = exports.PDFObjectParsingError = exports.NextByteAssertionError = exports.PDFParsingError = exports.NumberParsingError = exports.MissingTfOperatorError = exports.MissingDAEntryError = exports.MultiSelectValueError = exports.InvalidAcroFieldValueError = exports.IndexOutOfBoundsError = exports.CorruptPageTreeError = exports.InvalidTargetIndexError = exports.InvalidPDFDateStringError = exports.PDFArrayIsNotRectangleError = exports.PageEmbeddingMismatchedContextError = exports.UnrecognizedStreamTypeError = exports.MissingPageContentsEmbeddingError = exports.MissingCatalogError = exports.ReparseError = exports.UnsupportedEncodingError = exports.UnexpectedObjectTypeError = exports.PrivateConstructorError = exports.MethodNotImplementedError = void 0;
const utils_1 = require("../utils");
class MethodNotImplementedError extends Error {
    constructor(className, methodName) {
        const msg = `Method ${className}.${methodName}() not implemented`;
        super(msg);
    }
}
exports.MethodNotImplementedError = MethodNotImplementedError;
class PrivateConstructorError extends Error {
    constructor(className) {
        const msg = `Cannot construct ${className} - it has a private constructor`;
        super(msg);
    }
}
exports.PrivateConstructorError = PrivateConstructorError;
class UnexpectedObjectTypeError extends Error {
    constructor(expected, actual) {
        const name = (t) => { var _a, _b; return (_a = t === null || t === void 0 ? void 0 : t.name) !== null && _a !== void 0 ? _a : (_b = t === null || t === void 0 ? void 0 : t.constructor) === null || _b === void 0 ? void 0 : _b.name; };
        const expectedTypes = Array.isArray(expected)
            ? expected.map(name)
            : [name(expected)];
        const msg = `Expected instance of ${expectedTypes.join(' or ')}, ` +
            `but got instance of ${actual ? name(actual) : actual}`;
        super(msg);
    }
}
exports.UnexpectedObjectTypeError = UnexpectedObjectTypeError;
class UnsupportedEncodingError extends Error {
    constructor(encoding) {
        const msg = `${encoding} stream encoding not supported`;
        super(msg);
    }
}
exports.UnsupportedEncodingError = UnsupportedEncodingError;
class ReparseError extends Error {
    constructor(className, methodName) {
        const msg = `Cannot call ${className}.${methodName}() more than once`;
        super(msg);
    }
}
exports.ReparseError = ReparseError;
class MissingCatalogError extends Error {
    constructor(ref) {
        const msg = `Missing catalog (ref=${ref})`;
        super(msg);
    }
}
exports.MissingCatalogError = MissingCatalogError;
class MissingPageContentsEmbeddingError extends Error {
    constructor() {
        const msg = `Can't embed page with missing Contents`;
        super(msg);
    }
}
exports.MissingPageContentsEmbeddingError = MissingPageContentsEmbeddingError;
class UnrecognizedStreamTypeError extends Error {
    constructor(stream) {
        var _a, _b, _c;
        const streamType = (_c = (_b = (_a = stream === null || stream === void 0 ? void 0 : stream.contructor) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : stream === null || stream === void 0 ? void 0 : stream.name) !== null && _c !== void 0 ? _c : stream;
        const msg = `Unrecognized stream type: ${streamType}`;
        super(msg);
    }
}
exports.UnrecognizedStreamTypeError = UnrecognizedStreamTypeError;
class PageEmbeddingMismatchedContextError extends Error {
    constructor() {
        const msg = `Found mismatched contexts while embedding pages. All pages in the array passed to \`PDFDocument.embedPages()\` must be from the same document.`;
        super(msg);
    }
}
exports.PageEmbeddingMismatchedContextError = PageEmbeddingMismatchedContextError;
class PDFArrayIsNotRectangleError extends Error {
    constructor(size) {
        const msg = `Attempted to convert PDFArray with ${size} elements to rectangle, but must have exactly 4 elements.`;
        super(msg);
    }
}
exports.PDFArrayIsNotRectangleError = PDFArrayIsNotRectangleError;
class InvalidPDFDateStringError extends Error {
    constructor(value) {
        const msg = `Attempted to convert "${value}" to a date, but it does not match the PDF date string format.`;
        super(msg);
    }
}
exports.InvalidPDFDateStringError = InvalidPDFDateStringError;
class InvalidTargetIndexError extends Error {
    constructor(targetIndex, Count) {
        const msg = `Invalid targetIndex specified: targetIndex=${targetIndex} must be less than Count=${Count}`;
        super(msg);
    }
}
exports.InvalidTargetIndexError = InvalidTargetIndexError;
class CorruptPageTreeError extends Error {
    constructor(targetIndex, operation) {
        const msg = `Failed to ${operation} at targetIndex=${targetIndex} due to corrupt page tree: It is likely that one or more 'Count' entries are invalid`;
        super(msg);
    }
}
exports.CorruptPageTreeError = CorruptPageTreeError;
class IndexOutOfBoundsError extends Error {
    constructor(index, min, max) {
        const msg = `index should be at least ${min} and at most ${max}, but was actually ${index}`;
        super(msg);
    }
}
exports.IndexOutOfBoundsError = IndexOutOfBoundsError;
class InvalidAcroFieldValueError extends Error {
    constructor() {
        const msg = `Attempted to set invalid field value`;
        super(msg);
    }
}
exports.InvalidAcroFieldValueError = InvalidAcroFieldValueError;
class MultiSelectValueError extends Error {
    constructor() {
        const msg = `Attempted to select multiple values for single-select field`;
        super(msg);
    }
}
exports.MultiSelectValueError = MultiSelectValueError;
class MissingDAEntryError extends Error {
    constructor(fieldName) {
        const msg = `No /DA (default appearance) entry found for field: ${fieldName}`;
        super(msg);
    }
}
exports.MissingDAEntryError = MissingDAEntryError;
class MissingTfOperatorError extends Error {
    constructor(fieldName) {
        const msg = `No Tf operator found for DA of field: ${fieldName}`;
        super(msg);
    }
}
exports.MissingTfOperatorError = MissingTfOperatorError;
class NumberParsingError extends Error {
    constructor(pos, value) {
        const msg = `Failed to parse number ` +
            `(line:${pos.line} col:${pos.column} offset=${pos.offset}): "${value}"`;
        super(msg);
    }
}
exports.NumberParsingError = NumberParsingError;
class PDFParsingError extends Error {
    constructor(pos, details) {
        const msg = `Failed to parse PDF document ` +
            `(line:${pos.line} col:${pos.column} offset=${pos.offset}): ${details}`;
        super(msg);
    }
}
exports.PDFParsingError = PDFParsingError;
class NextByteAssertionError extends PDFParsingError {
    constructor(pos, expectedByte, actualByte) {
        const msg = `Expected next byte to be ${expectedByte} but it was actually ${actualByte}`;
        super(pos, msg);
    }
}
exports.NextByteAssertionError = NextByteAssertionError;
class PDFObjectParsingError extends PDFParsingError {
    constructor(pos, byte) {
        const msg = `Failed to parse PDF object starting with the following byte: ${byte}`;
        super(pos, msg);
    }
}
exports.PDFObjectParsingError = PDFObjectParsingError;
class PDFInvalidObjectParsingError extends PDFParsingError {
    constructor(pos) {
        const msg = `Failed to parse invalid PDF object`;
        super(pos, msg);
    }
}
exports.PDFInvalidObjectParsingError = PDFInvalidObjectParsingError;
class PDFStreamParsingError extends PDFParsingError {
    constructor(pos) {
        const msg = `Failed to parse PDF stream`;
        super(pos, msg);
    }
}
exports.PDFStreamParsingError = PDFStreamParsingError;
class UnbalancedParenthesisError extends PDFParsingError {
    constructor(pos) {
        const msg = `Failed to parse PDF literal string due to unbalanced parenthesis`;
        super(pos, msg);
    }
}
exports.UnbalancedParenthesisError = UnbalancedParenthesisError;
class StalledParserError extends PDFParsingError {
    constructor(pos) {
        const msg = `Parser stalled`;
        super(pos, msg);
    }
}
exports.StalledParserError = StalledParserError;
class MissingPDFHeaderError extends PDFParsingError {
    constructor(pos) {
        const msg = `No PDF header found`;
        super(pos, msg);
    }
}
exports.MissingPDFHeaderError = MissingPDFHeaderError;
class MissingKeywordError extends PDFParsingError {
    constructor(pos, keyword) {
        const msg = `Did not find expected keyword '${(0, utils_1.arrayAsString)(keyword)}'`;
        super(pos, msg);
    }
}
exports.MissingKeywordError = MissingKeywordError;
//# sourceMappingURL=errors.js.map