"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const errors_1 = require("../errors");
const PDFName_1 = (0, tslib_1.__importDefault)(require("./PDFName"));
const PDFNumber_1 = (0, tslib_1.__importDefault)(require("./PDFNumber"));
const PDFObject_1 = (0, tslib_1.__importDefault)(require("./PDFObject"));
const CharCodes_1 = (0, tslib_1.__importDefault)(require("../syntax/CharCodes"));
class PDFStream extends PDFObject_1.default {
    constructor(dict) {
        super();
        this.dict = dict;
    }
    clone(_context) {
        throw new errors_1.MethodNotImplementedError(this.constructor.name, 'clone');
    }
    getContentsString() {
        throw new errors_1.MethodNotImplementedError(this.constructor.name, 'getContentsString');
    }
    getContents() {
        throw new errors_1.MethodNotImplementedError(this.constructor.name, 'getContents');
    }
    getContentsSize() {
        throw new errors_1.MethodNotImplementedError(this.constructor.name, 'getContentsSize');
    }
    updateDict() {
        const contentsSize = this.getContentsSize();
        this.dict.set(PDFName_1.default.Length, PDFNumber_1.default.of(contentsSize));
    }
    sizeInBytes() {
        this.updateDict();
        return this.dict.sizeInBytes() + this.getContentsSize() + 18;
    }
    toString() {
        this.updateDict();
        let streamString = this.dict.toString();
        streamString += '\nstream\n';
        streamString += this.getContentsString();
        streamString += '\nendstream';
        return streamString;
    }
    copyBytesInto(buffer, offset) {
        this.updateDict();
        const initialOffset = offset;
        offset += this.dict.copyBytesInto(buffer, offset);
        buffer[offset++] = CharCodes_1.default.Newline;
        buffer[offset++] = CharCodes_1.default.s;
        buffer[offset++] = CharCodes_1.default.t;
        buffer[offset++] = CharCodes_1.default.r;
        buffer[offset++] = CharCodes_1.default.e;
        buffer[offset++] = CharCodes_1.default.a;
        buffer[offset++] = CharCodes_1.default.m;
        buffer[offset++] = CharCodes_1.default.Newline;
        const contents = this.getContents();
        for (let idx = 0, len = contents.length; idx < len; idx++) {
            buffer[offset++] = contents[idx];
        }
        buffer[offset++] = CharCodes_1.default.Newline;
        buffer[offset++] = CharCodes_1.default.e;
        buffer[offset++] = CharCodes_1.default.n;
        buffer[offset++] = CharCodes_1.default.d;
        buffer[offset++] = CharCodes_1.default.s;
        buffer[offset++] = CharCodes_1.default.t;
        buffer[offset++] = CharCodes_1.default.r;
        buffer[offset++] = CharCodes_1.default.e;
        buffer[offset++] = CharCodes_1.default.a;
        buffer[offset++] = CharCodes_1.default.m;
        return offset - initialOffset;
    }
}
exports.default = PDFStream;
//# sourceMappingURL=PDFStream.js.map