"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodePDFRawStream = void 0;
const tslib_1 = require("tslib");
const errors_1 = require("../errors");
const PDFArray_1 = (0, tslib_1.__importDefault)(require("../objects/PDFArray"));
const PDFDict_1 = (0, tslib_1.__importDefault)(require("../objects/PDFDict"));
const PDFName_1 = (0, tslib_1.__importDefault)(require("../objects/PDFName"));
const PDFNumber_1 = (0, tslib_1.__importDefault)(require("../objects/PDFNumber"));
const Ascii85Stream_1 = (0, tslib_1.__importDefault)(require("./Ascii85Stream"));
const AsciiHexStream_1 = (0, tslib_1.__importDefault)(require("./AsciiHexStream"));
const FlateStream_1 = (0, tslib_1.__importDefault)(require("./FlateStream"));
const LZWStream_1 = (0, tslib_1.__importDefault)(require("./LZWStream"));
const RunLengthStream_1 = (0, tslib_1.__importDefault)(require("./RunLengthStream"));
const Stream_1 = (0, tslib_1.__importDefault)(require("./Stream"));
const decodeStream = (stream, encoding, params) => {
    if (encoding === PDFName_1.default.of('FlateDecode')) {
        return new FlateStream_1.default(stream);
    }
    if (encoding === PDFName_1.default.of('LZWDecode')) {
        let earlyChange = 1;
        if (params instanceof PDFDict_1.default) {
            const EarlyChange = params.lookup(PDFName_1.default.of('EarlyChange'));
            if (EarlyChange instanceof PDFNumber_1.default) {
                earlyChange = EarlyChange.asNumber();
            }
        }
        return new LZWStream_1.default(stream, undefined, earlyChange);
    }
    if (encoding === PDFName_1.default.of('ASCII85Decode')) {
        return new Ascii85Stream_1.default(stream);
    }
    if (encoding === PDFName_1.default.of('ASCIIHexDecode')) {
        return new AsciiHexStream_1.default(stream);
    }
    if (encoding === PDFName_1.default.of('RunLengthDecode')) {
        return new RunLengthStream_1.default(stream);
    }
    throw new errors_1.UnsupportedEncodingError(encoding.asString());
};
const decodePDFRawStream = ({ dict, contents, transform, }) => {
    let stream = new Stream_1.default(contents);
    if (transform) {
        stream = transform.createStream(stream, contents.length);
    }
    const Filter = dict.lookup(PDFName_1.default.of('Filter'));
    const DecodeParms = dict.lookup(PDFName_1.default.of('DecodeParms'));
    if (Filter instanceof PDFName_1.default) {
        stream = decodeStream(stream, Filter, DecodeParms);
    }
    else if (Filter instanceof PDFArray_1.default) {
        for (let idx = 0, len = Filter.size(); idx < len; idx++) {
            stream = decodeStream(stream, Filter.lookup(idx, PDFName_1.default), DecodeParms && DecodeParms.lookupMaybe(idx, PDFDict_1.default));
        }
    }
    else if (!!Filter) {
        throw new errors_1.UnexpectedObjectTypeError([PDFName_1.default, PDFArray_1.default], Filter);
    }
    return stream;
};
exports.decodePDFRawStream = decodePDFRawStream;
//# sourceMappingURL=decode.js.map